name = 'wref_resolver'

version = '0.3.15'


@late()
def build_requires():
    if this.is_package:
        return []
    elif this.index == 0:
        return ["python-2.7","boost-1.61", "usd-19.11", "maya-2018", "maya_sdk-2018"]
    elif this.index == 1:
        return ["python-2.7","boost-1.70", "usd-20.08", "maya-2018", "maya_sdk-2018"]
    elif this.index == 2:
        return ["python-3.7","boost-1.73", "usd-21.08", "maya-2022","maya_sdk-2022"]
    elif this.index == 3:
        return ["python-3.9","boost-1.76", "usd-22.05", "maya-2023","maya_sdk-2023"]
    elif this.index == 4:
        return ["houdini-18.5", "python-2.7", "houdini_sdk-18.5"]
    elif this.index == 5:
        return ["houdini-19.0", "python-3.7", "houdini_sdk-19.0"]
    elif this.index == 6:
        return ["houdini-19.5", "python-3.9", "houdini_sdk-19.5"]
    elif this.index == 7:
        return ["boost-1.70", "usd-20.08", "python-2.7"]
    elif this.index == 8:
        return ["boost-1.73", "usd-21.08", "python-3.7"]
    elif this.index == 9:
        return ["boost-1.76", "usd-22.05", "python-3.9"]

build_command = "python {root}/rezbuild.py"

variants = [
    ["boost-1.61","~usd-19.11",'~maya-2018'],
    ["boost-1.70","~usd-20.08",'~maya-2018'],
    ["boost-1.73","~usd-21.08",'~maya-2022'],
    ["boost-1.76","~usd-22.05",'~maya-2023'],
    ['houdini-18.5',"!usd"],
    ['houdini-19.0',"!usd"],
    ['houdini-19.5',"!usd"],
    ["boost-1.70", "~usd-20.08"],
    ["boost-1.73", "~usd-21.08"],
    ["boost-1.76", "~usd-22.05"]
]

def commands():
    env.PATH.append('{root}/lib/')
    if defined("WIZART_FREELANCE") and getenv("WIZART_FREELANCE") == "1":
        env.WREF_RESOLVER_NO_VCS_SERVICE.set("1")
    env.PYTHONPATH.append('{root}/python')
    if 'houdini' in resolve:
        env.PXR_PLUGINPATH_NAME.append('{root}/lib/usd')
    else:
        if "usd" in resolve:
            env.PXR_PLUGINPATH_NAME.append('{root}/lib/usd')
        if "maya" in resolve:
            env.MAYA_PLUG_IN_PATH.append("{root}/plugin")
            env.PYTHONPATH.append("{root}/python/maya_startup")
