# -*- coding: utf-8 -*-

name = 'wref_resolver'

version = '0.3.10'

requires = [
    'boost-1.61',
    '~usd-19.11',
    '~maya-2018'
]

@late()
def build_requires():
    if this.is_package:
        return []
    elif this.index == 0:
        return ["python-2.7","boost-1.61", "usd-19.11", "maya-2018"]
    else:
        return ["houdini-18", "python-2.7"]

variants = [
    ['boost-1.61', '~usd-19.11', '~maya-2018'],
    ['houdini-18', '!usd']
]

def commands():
    env.PATH.append('{root}/lib/')
    env.WREF_RESOLVER_NO_VCS_SERVICE.set("1")
    env.PYTHONPATH.append('{root}/python')
    if 'houdini' in resolve:
        env.PXR_PLUGINPATH_NAME.append('{root}/lib/usd')
    else:
        if "usd" in resolve:
            env.PXR_PLUGINPATH_NAME.append('{root}/lib/usd')
        if "maya" in resolve:
            env.MAYA_PLUG_IN_PATH.append("{root}/plugin")
            env.PYTHONPATH.append("{root}/python/maya_startup")

timestamp = 1587713936

format_version = 2
