
def bootstrap(wizart_software_path):

    import os, sys, __main__

    if os.environ.get("WIZART_SOFTWARE_LEGACY_BOOTSTRAP") == "1":
        """
        Early out, we have two various software startup hooks during migration, so we dont want to initialize code twice
        """
        return

    print 'Wizart Animation software configuration loading...'

    def wizart_excepthook(type, value, tback):
        """
        We need these to prevent sys exits on raising exceptions in PyQt5 slot
        """
        sys.__excepthook__(type, value, tback)

    sys.excepthook = wizart_excepthook
    print 'installed wizart sys.excepthook'

    import maya.cmds
    import maya.OpenMaya
    from functools import partial

    if not os.environ.get("REZ_WIZARTSOFT_MAYA2018_ROOT"):
        os.environ['WIZART_SOFTWARE_PATH'] = wizart_software_path
        __main__.WIZART_SOFTWARE_PATH = wizart_software_path

        if os.path.exists(wizart_software_path):
            sys.path.append(wizart_software_path)
            print 'successfully appended wizart animation python modules to python sys path'
            try:
                import wizart
            except:
                print 'failed appending wizart animation python modules to python sys path'
                print 'reason: cannot import wizart python module'
        else:
            print 'failed appending wizart animation python modules to python sys path'
            print 'reason: "%s" path not exists' % wizart_software_path
        wizart_shared_lib_path = os.path.join(wizart_software_path, 'shared_lib')

        if os.path.exists(wizart_shared_lib_path):
            os.environ['PATH'] += ";" + wizart_shared_lib_path
            print 'successfully appended wizart animation shared libraries to PATH environment variable'
        else:
            print 'failed appending wizart animation shared libraries to PATH environment variable'
            print 'reason: "%s" path not exists' % wizart_shared_lib_path
        wizart_python_site_packages_path = os.path.join(wizart_software_path, 'site-packages')

        if os.path.exists(wizart_python_site_packages_path):
            sys.path.append(wizart_python_site_packages_path)
            print 'successfully appended wizart animation python site-packages to python sys path'
            import site_packages_loader
            site_packages_loader.load_site_packages()
        else:
            print 'failed appending wizart animation python site-packages to python sys path'
            print 'reason: "%s" path not exists' % wizart_python_site_packages_path


        import pymel.versions as maya_versions

        if maya_versions.current() >= maya_versions.v2017:
            os.environ["QT_PREFERRED_BINDING"] = "PySide2"
            import Qt

    wizart_maya_plugins_path = os.path.join(wizart_software_path, 'maya_plugins')

    def load_cgfxShader(path):
        if maya.cmds.pluginInfo("cgfxShader.mll", q = True, loaded = True):
            maya.cmds.unloadPlugin("cgfxShader.mll")
        default_load_plugin(path)

    def default_load_plugin(path):
        try:
            maya.cmds.loadPlugin(path)
            if maya.cmds.pluginInfo(path, q = True, loaded = True):
                print 'loaded plugin "%s"' % path
            else:
                print 'plugin "%s" is not loaded' % path
        except:
            print 'cannot load plugin "%s" skipping' % (path)
    wizart_python_site_packages_path = os.path.join(wizart_software_path, 'site-packages')
    if os.path.exists(wizart_python_site_packages_path):
        import pymel.versions as maya_versions
        version_map = {'2011 x64' : '2011-x64', '2013 x64' : '2013-x64', '2017': '2017','2018': '2018'}
        maya_version = maya_versions.fullName()
        if maya_version in version_map:
            import glob
            plugins_path = os.path.join(wizart_maya_plugins_path, version_map[maya_version])
            os.environ['PATH'] = os.environ['PATH'] + ';' + plugins_path
            os.environ['MAYA_PLUG_IN_PATH'] = os.environ.get('MAYA_PLUG_IN_PATH','') + ';' + plugins_path
            files = glob.glob(plugins_path + "/*.mll") + glob.glob(plugins_path + "/*.py")

            #need this for some rigs
            maya.cmds.loadPlugin("matrixNodes.mll")

            plugin_loaders = {
                'cgfxShader.mll': load_cgfxShader
            }

            for file in files:
                base_path = os.path.basename(file)
                plugin_loaders.get(base_path, default_load_plugin)( os.path.join(plugins_path, base_path) )

        if os.path.exists(os.path.join(plugins_path,'deferred')):
            os.environ['MAYA_PLUG_IN_PATH'] = os.environ.get('MAYA_PLUG_IN_PATH','') + ';' + os.path.join(plugins_path,'deferred')
            deferred_files = glob.glob(os.path.join(plugins_path,'deferred') + "/*.mll") + glob.glob(os.path.join(plugins_path,'deferred') + "/*.py")

            for file in deferred_files:
                base_path = os.path.basename(file)
                maya.cmds.evalDeferred(partial(plugin_loaders.get(base_path, default_load_plugin), file) )
        print 'successfully loaded wizart animation maya plugins into maya %s' % maya_versions.fullName()

    def load_runtime_maya_module(module_file_path):

        def _process_env_vars(root_path, env_lines):
            for line in env_lines:
                if '+:=' in line:
                    env_name, env_value = line.split('+:=', 1)
                    env_name, env_value = env_name.replace("\r", "").replace("\n", ""), env_value.replace("\r", "").replace("\n", "")
                    if os.environ.has_key(env_name):
                        os.environ[env_name] += ';' + os.path.join(root_path, env_value)
                    else:
                        os.environ[env_name] = os.path.join(root_path, env_value)
                    if env_name == 'MAYA_SCRIPT_PATH':
                        sys.path.append(os.path.join(root_path, env_value))
                elif ':=' in line:
                    env_name, env_value = line.split(':=', 1)
                    env_name, env_value = env_name.replace("\r", "").replace("\n", ""), env_value.replace("\r", "").replace("\n", "")
                    os.environ[env_name] = os.path.join(root_path, env_value)
                    if env_name == 'MAYA_SCRIPT_PATH':
                        sys.path.append(os.path.join(root_path, env_value))

        with open(module_file_path, "r") as f:
            lines = f.readlines()
            if lines:
                module_def_path = lines[0].split()[-1]
                if os.path.isabs(module_def_path):
                    _process_env_vars(module_def_path, lines[1:])
                else:
                    mod_file_dir = os.path.dirname(module_file_path)
                    _process_env_vars(os.path.join(mod_file_dir, module_def_path), lines[1:])
                print 'successfully loaded "%s" maya module at runtime' % module_file_path

    if not os.environ.get("REZ_WIZARTSOFT_MAYA2018_ROOT"):
        #maya modules path
        if os.path.exists(os.path.join(os.environ['WIZART_SOFTWARE_PATH'],'maya_modules') ):
            for file in glob.glob(os.path.join(os.environ['WIZART_SOFTWARE_PATH'],'maya_modules') +"/*.mod"):
                load_runtime_maya_module(file)

    for script in glob.glob(os.path.join(os.environ['WIZART_SOFTWARE_PATH'],'maya_ui','scripts') + "/*.py"):
        #__import__(os.path.splitext(script)[0], locals(), globals())
        import imp
        module = imp.load_source(os.path.splitext(os.path.basename(script))[0], script)

    def _load_plugin_deferred(name):
        maya.cmds.loadPlugin(name)
        print "loaded '%s' plugin" % name 
    os.environ["WIZART_SOFTWARE_LEGACY_BOOTSTRAP"] = "1"
    if os.environ.get("REZ_AL_USDMAYA_ROOT"):        
        if not maya.cmds.pluginInfo("AL_USDMayaPlugin", query = True, loaded = True):
            maya.cmds.evalDeferred(partial(_load_plugin_deferred, "AL_USDMayaPlugin") )
        if not maya.cmds.pluginInfo("AL_USDMayaPxrTranslators", query = True, loaded = True):
            maya.cmds.evalDeferred(partial(_load_plugin_deferred, "AL_USDMayaPxrTranslators") )
    if not maya.cmds.pluginInfo("MayaScanner.py", query = True, loaded = True):
        maya.cmds.evalDeferred(partial(_load_plugin_deferred, "MayaScanner.py") )
    if not maya.cmds.pluginInfo("MayaScannerCB.py", query = True, loaded = True):
        maya.cmds.evalDeferred(partial(_load_plugin_deferred, "MayaScannerCB.py") )
    print 'Wizart Animation software configurated successfully!'
