import platform,sys,os, glob
# for now assume we have only windows platform but we can scale anytime
# /todo better logging
def load_site_packages():
	successfull_mapping = True
	python_version_list = [('2', '6'), ('2', '7')]
	python_arch_map = {'64bit':'x64'}
	python_compiler_map = {
	'MSC v.1500 64 bit (AMD64)':'msvc1600', #win maya 2011 x64bit
	'MSC v.1600 64 bit (AMD64)':'msvc1600', #win maya 2013 x64bit,
	'MSC v.1900 64 bit (AMD64)':'msvc1600' #nuke11, houdini 16, maya 2018
	}
	python_version = ""
	python_arch = ""
	python_compiler = ""
	if platform.python_version_tuple()[:-1] in python_version_list:
		python_version = "py%s%s" % platform.python_version_tuple()[:-1]
	else:
		successfull_mapping = False
		print 'site-packages error: not found current python version in  python version list'

	try:
		python_arch = python_arch_map[ platform.architecture() [0] ]
	except KeyError:
		successfull_mapping = False
		print 'site-packages error: not found current python architecture from python architecture map'

	try:
		python_compiler = python_compiler_map [platform.python_compiler()]
	except KeyError:
		successfull_mapping = False
		print 'site-packages error: not found current python compiler from python compiler map'

	current_path = os.path.dirname(__file__)
	common_python_folder = os.path.join(current_path, 'common')
	sys.path.insert( 0, common_python_folder)
	print 'successfully appended wizart animation common python site-packages to python sys path'
	if successfull_mapping:
		# if no mapping errors
		if python_version != "" and python_arch != "" and python_compiler != "":
			#if we dont have defaults values
			mapped_folder_name = "%(python_version)s%(python_arch)s_%(python_compiler)s" % dict(python_version = python_version, python_arch = python_arch, python_compiler = python_compiler )
			sys.path.insert( 0, os.path.join(current_path,mapped_folder_name))
			for pth_file in glob.glob(os.path.join(current_path,mapped_folder_name,"*.pth")):
				lines = []
				with open(pth_file, 'r') as f:
					lines = f.readlines()
					f.close()
				for line in lines:
					if not line.startswith("#"):
						append_path = os.path.join(current_path,mapped_folder_name, line.strip())
						sys.path.insert( 1, append_path)
			print 'successfully appended wizart animation python site-packages to python sys path (folder: %s)' % mapped_folder_name
			return True, os.path.join(current_path, mapped_folder_name)
		else:
			print 'site-packages error: some of the variables are equal to default'
			return False, None
	else:
		print 'site-packages error: cant get folder path'
		return False, None
