import os, glob
from stat import S_IWUSR, S_IREAD
import logging
log = logging.getLogger("wizart_desktop")

def scan_for_maya_malware():
    maya_folder = os.path.expandvars("$USERPROFILE/Documents/maya")
    result = []
    log.info("scan maya folder '%s' for malware" % maya_folder)
    for root, dirnames, filenames in os.walk(maya_folder):
        for filename in filenames:
            fullpath = os.path.join(root, filename)
            ##Virus type 1
            if filename == "userSetup.mel":
                with open(fullpath, "r") as f:
                    data = f.read()
                    if 'fuck_All_U' in data:
                        status = 'compromised'
                        log.warning('%s : Compromised by Malware!' % fullpath)
                    if all([len(data) >= 4118,
                            '// Maya Mel UI Configuration File.Maya Mel UI Configuration File..\n// \n//\n//  This script is machine generated.  Edit at your own risk' in data,
                            'string $chengxu' in data]):
                        log.warning('%s : Created by Malware!' % fullpath)
                        status = 'delete'
                        result.append((fullpath, status))
            ##Virus type 2
            elif filename == "userSetup.py":
                with open(fullpath, "r") as f:
                    data = f.read()
                    if "cmds.evalDeferred(\'leukocyte = vaccine.phage()\')" in data and "cmds.evalDeferred(\'leukocyte.occupation()\')" in data:
                        log.warning('%s : Infected by Malware!' % fullpath)
                        status = 'delete'
                        result.append((fullpath, status))
            elif filename == "vaccine.py":
                with open(fullpath, "r") as f:
                    data = f.read()
                    if "petri_dish_path = cmds.internalVar(userAppDir=True) + 'scripts/userSetup.py" in data:
                        log.warning('%s found : Infected by Malware!' % fullpath)
                        status = 'delete'
                        result.append((fullpath, status))
            elif filename == "vaccine.pyc":
                log.warning('%s found : Infected by Malware!' % fullpath)
                status = 'delete'
                result.append((fullpath, status))       

    if len(result) == 0:
        log.info("Not found any malware in maya folder '%s'" % maya_folder)
    else:
        log.info("Found '%d' malware scripts in maya folder '%s'" % (len(result), maya_folder) )
    return result

def ask_for_fix_maya_malware(malware_list):
    from Qt import QtWidgets
    filepath_list = [malware_entry[0] for malware_entry in malware_list]
    result = QtWidgets.QMessageBox.question(None, "Malware Delete Files", "We found chinese malware in these files, that could hang maya startup. DELETE these files : %s ?" % ",".join(filepath_list), QtWidgets.QMessageBox.Yes | QtWidgets.QMessageBox.No)
    if result == QtWidgets.QMessageBox.Yes:
        return True
    return False

def fix_maya_malware(malware_list):
    for malware_entry in malware_list:
        if malware_entry[1] == "delete":
            os.chmod(malware_entry[0], S_IWUSR | S_IREAD)
            os.remove(malware_entry[0])
            log.warning("Delete malware file:'%s'", malware_entry[0])
