from Qt import QtCore, QtWidgets, QtGui
import qt_utils
class DesktopSystemTrayIcon(QtWidgets.QSystemTrayIcon):
    def __init__(self, parent):
        super(DesktopSystemTrayIcon, self).__init__()
        icon = QtGui.QIcon(":systray_icon")
        self.parent = parent
        self.setIcon(icon)
        self.setToolTip("Wizart Desktop")
        self.setContextMenu(qt_utils.make_desktop_menu())
        self.activated.connect(self.__activated)

    def __activated(self, reason):
        if reason == QtWidgets.QSystemTrayIcon.Trigger:
            active = self.parent.isActiveWindow()
            if active:
                # shown and topmost, hide
                self.parent.hide()
            else:
                self.activate()

    def activate(self):
        """
        Ensures the Desktop's dialog is visible and on top of other windows.
        """
        if self.parent.isHidden():
            self.parent.show()
            self.parent.raise_()
            self.parent.showNormal()
            self.parent.activateWindow()
        else:
            # shown and not topmost, just bring to the top
            self.parent.showNormal()
            self.parent.raise_()
            self.parent.activateWindow()
