import sys

from Qt import QtCore, QtWidgets
from Qt.QtWidgets import QDialogButtonBox

AWS_REGIONS = ["us-east-1",
               "us-east-2",
               "us-west-2",
               "us-west-1",
               "ca-central-1",
               "eu-west-1",
               "eu-west-2",
               "eu-north-1",
               "eu-central-1",
               "ap-southeast-1",
               "ap-southeast-2",
               "ap-northeast-1",
               "ap-northeast-2",
               "ap-south-1",
               "ap-east-1",
               "sa-east-1"]


class OptionGroupBox(QtWidgets.QGroupBox):
    def __init__(self, kwargs):
        super(OptionGroupBox, self).__init__(kwargs)
        self.setLayout(QtWidgets.QVBoxLayout())


class SettingsDialog(QtWidgets.QDialog):
    def __init__(self, parent=None):
        super(SettingsDialog, self).__init__(parent)
        self.setWindowTitle("Desktop Settings")
        self.setLayout(QtWidgets.QVBoxLayout())
        self.setMinimumWidth(250)

        # MAYA_APP_DIR GroupBox
        mad_box = OptionGroupBox("Redefinition MAYA_APP_DIR")
        self.mad_checkbox = QtWidgets.QCheckBox("Change Path to MAYA_APP_DIR")
        mad_box.layout().addWidget(self.mad_checkbox)

        mad_path_group = QtWidgets.QWidget()
        mad_path_group.setLayout(QtWidgets.QHBoxLayout())

        self.mad_path = QtWidgets.QLineEdit()
        mad_path_group.layout().addWidget(self.mad_path)

        mad_path_btn = QtWidgets.QPushButton("...")
        mad_path_btn.setMaximumWidth(25)
        mad_path_btn.released.connect(self.select_path)
        mad_path_group.layout().addWidget(mad_path_btn)

        mad_box.layout().addWidget(mad_path_group)
        mad_prompt_txt = "To override value of MAYA_APP_DIR, enable this option and set path."

        mad_prompt = QtWidgets.QLabel(mad_prompt_txt)
        mad_prompt.setStyleSheet("font-size: 8pt;")
        mad_prompt.setWordWrap(True)
        mad_box.layout().addWidget(mad_prompt)
        self.layout().addWidget(mad_box)

        # Maya_scan_malware_pre_launch
        scan_malware = OptionGroupBox("Maya scan malware pre launch")
        self.scan_malware_checkbox = QtWidgets.QCheckBox("Enable malware scanning")
        scan_malware.layout().addWidget(self.scan_malware_checkbox)
        self.layout().addWidget(scan_malware)

        # Notifications GroupBox
        notice_groupBox = OptionGroupBox("Desktop Alerts")
        self.notice_checkbox = QtWidgets.QCheckBox("Show desktop notifications")
        notice_groupBox.layout().addWidget(self.notice_checkbox)
        self.layout().addWidget(notice_groupBox)

        # S3 GroupBox
        if hasattr(sys, "freelance_build"):
            filesync_groupBox = OptionGroupBox("File Sync")
            self.s3_sync_checkbox = QtWidgets.QCheckBox("S3 Sync")
            filesync_groupBox.layout().addWidget(self.s3_sync_checkbox)
            hlt = QtWidgets.QHBoxLayout()
            hlt.addWidget(QtWidgets.QLabel("S3 Bucket Name"))
            self.s3_bucket_name_edit = QtWidgets.QLineEdit()
            hlt.addWidget(self.s3_bucket_name_edit)
            filesync_groupBox.layout().addLayout(hlt)

            hlt = QtWidgets.QHBoxLayout()
            hlt.addWidget(QtWidgets.QLabel("S3 Bucket Region"))
            self.s3_bucket_region_combobox = QtWidgets.QComboBox()
            self.s3_bucket_region_combobox.addItems(AWS_REGIONS)
            hlt.addWidget(self.s3_bucket_region_combobox)

            filesync_groupBox.layout().addLayout(hlt)

            self.layout().addWidget(filesync_groupBox)
            self.s3_bucket_name_edit.setDisabled(True)
            self.s3_bucket_region_combobox.setDisabled(True)
            self.s3_sync_checkbox.stateChanged.connect(self.__update_s3_state)

        if not hasattr(sys, "freelance_build"):
            dev_groupBox = OptionGroupBox("Development")
            self.show_dev_projects_checkbox = QtWidgets.QCheckBox("Show Dev Projects")
            dev_groupBox.layout().addWidget(self.show_dev_projects_checkbox)

            self.show_inactive_projects_checkbox = QtWidgets.QCheckBox("Show Inactive Projects")
            dev_groupBox.layout().addWidget(self.show_inactive_projects_checkbox)
            self.layout().addWidget(dev_groupBox)

        # Button box
        buttonBox = QDialogButtonBox(
            QDialogButtonBox.Ok | QDialogButtonBox.Cancel)
        buttonBox.accepted.connect(self.accept)
        buttonBox.rejected.connect(self.reject)
        self.layout().addWidget(buttonBox)

    def __update_s3_state(self, state):
        if state == QtCore.Qt.Checked:
            self.s3_bucket_name_edit.setDisabled(False)
            self.s3_bucket_region_combobox.setDisabled(False)
        else:
            self.s3_bucket_name_edit.setDisabled(True)
            self.s3_bucket_region_combobox.setDisabled(True)

    def select_path(self):
        path = QtWidgets.QFileDialog.getExistingDirectory(self)
        self.mad_path.setText(path)
