import sys

import login_dialog
import main_window
import settings_dialog
import utils
from Qt import QtCore, QtWidgets


def restart_app():
    app = QtWidgets.QApplication.instance()
    app.quit()
    QtCore.QProcess.startDetached(app.arguments()[0], [])


def rescan_projects_config():
    from wizart.desktop import main_window
    main_window = main_window.DesktopWindow.instance()
    main_window.rescan_projects_config()


def set_credentials():
    diag = login_dialog.LoginDialog()
    username = utils.get_user()
    if username:
        diag.login_input.setText(username)
    if username:
        password = utils.get_password(username)
        if password:
            diag.password_input.setText(password)
    result = diag.exec_()
    if result:
        username = str(diag.login_input.text())
        password = str(diag.password_input.text())
        utils.set_user(username)
        utils.set_password(username, password)
    mw = main_window.DesktopWindow.instance()
    mw.update_credentials_slot()
    if result:
        mw.auth_updater.run()

def set_settings():
    dialog = settings_dialog.SettingsDialog()
    dialog.mad_path.setText(utils.get_maya_app_dir_var())
    dialog.mad_checkbox.setChecked(utils.get_override_maya_app_dir_var())
    dialog.notice_checkbox.setChecked(utils.get_show_desktop_notifications())
    dialog.scan_malware_checkbox.setChecked(utils.get_maya_scan_malware())
    if hasattr(sys, 'freelance_build'):
        dialog.s3_sync_checkbox.setChecked(utils.get_sync_is_s3())
        dialog.s3_bucket_name_edit.setText(utils.get_sync_s3_bucket_name())
        dialog.s3_bucket_region_combobox.setCurrentText(utils.get_sync_s3_bucket_region())
    if not hasattr(sys, 'freelance_build'):
        dialog.show_dev_projects_checkbox.setChecked(utils.get_show_dev_projects())
        dialog.show_inactive_projects_checkbox.setChecked(utils.get_show_inactive_projects())
    result = dialog.exec_()
    if result:
        utils.set_maya_app_dir_var(dialog.mad_path.text())
        utils.set_override_maya_app_dir_var(dialog.mad_checkbox.isChecked())
        utils.set_show_desktop_notifications(dialog.notice_checkbox.isChecked())
        utils.set_maya_scan_malware(dialog.scan_malware_checkbox.isChecked())
        if hasattr(sys, 'freelance_build'):
            s3_state = dialog.s3_sync_checkbox.isChecked()
            utils.set_sync_is_s3(s3_state)
            if s3_state is True:
                utils.set_sync_s3_bucket_name(dialog.s3_bucket_name_edit.text())
                utils.set_sync_s3_bucket_region(dialog.s3_bucket_region_combobox.currentText())
        if not hasattr(sys, 'freelance_build'):
            utils.set_show_dev_projects(dialog.show_dev_projects_checkbox.isChecked())
            utils.set_show_inactive_projects(dialog.show_inactive_projects_checkbox.isChecked())
            rescan_projects_config()

def ftp_update_projects_config():
    from wizart.desktop import main_window
    main_window = main_window.DesktopWindow.instance()
    main_window.actions_tab.launch_sync(utils.SYNC_MODE_DOWNLOAD_CONFIG)

def run_public_s3_sync():
    instance = main_window.DesktopWindow.instance()
    instance.actions_tab.launch_sync(utils.SYNC_MODE_PUBLIC_S3_SYNC)

def check_software_updates():
    from wizart.desktop.freelance_software_updater import FreelanceSoftwareUpdater
    res = FreelanceSoftwareUpdater().check_updates()
    if not res:
        FreelanceSoftwareUpdater().show_not_updates_needed_popup()

def make_desktop_menu(parent=None):
    menu = QtWidgets.QMenu("Desktop", parent)
    if not hasattr(sys, "freelance_build"):
        menu.addAction("Set Login/Password", set_credentials)
    menu.addAction('Settings', set_settings)
    menu.addSeparator()
    menu.addAction("Open Rez Terminal", utils.open_rez_terminal)
    if hasattr(sys, 'freelance_build'):
        menu.addAction("Sync Projects Config", ftp_update_projects_config)
        menu.addAction("Sync Public Data", run_public_s3_sync)
    menu.addAction("Rescan Projects Config", rescan_projects_config)
    if hasattr(sys, 'freelance_build'):
        menu.addAction('Check Software Updates', check_software_updates)
    menu.addAction("Restart", restart_app)
    menu.addAction("Exit", lambda: QtWidgets.QApplication.instance().quit())
    return menu
