import qt_utils
import sys

from Qt import QtCore, QtWidgets, QtGui

USER_ICON = u"\uf2bd"

class StatusBarLabel(QtWidgets.QLabel):
    def __init__(self, parent=None):
        super(StatusBarLabel, self).__init__(parent)
        self.setObjectName("statusbar")
        self.setWordWrap(True)

class ProgressScale(QtWidgets.QProgressBar):
    def __init__(self, parent=None):
        super(ProgressScale, self).__init__(parent)
        self.hide()

    def show_progress(self, value):
        self.show()
        self.setValue(value)

class SettingsButton(QtWidgets.QPushButton):
    def __init__(self, parent=None):
        super(SettingsButton, self).__init__(parent)

        self.setText(USER_ICON)
        font = QtGui.QFont("Font Awesome 5 Free Solid", 16)
        self.setFont(font)
        menu = qt_utils.make_desktop_menu(self)
        self.setMenu(menu)
        self.setFixedSize(40, 30)


class BottomPanel(QtWidgets.QFrame):
    def __init__(self, parent=None):
        super(BottomPanel, self).__init__(parent)
        self.setLayout(QtWidgets.QHBoxLayout())
        self.setObjectName("bottompanel")

        self.status_label = StatusBarLabel(self)
        self.progress_scale = ProgressScale(self)
        self.progress_label = QtWidgets.QLabel(self)
        self.progress_label.hide()
        self.settings_button = SettingsButton(self)

        status_bar = QtWidgets.QVBoxLayout()
        status_bar.addWidget(self.status_label)
        status_bar.addWidget(self.progress_scale)
        status_bar.addWidget(self.progress_label)

        self.layout().addLayout(status_bar)
        self.layout().addWidget(self.settings_button, alignment=QtCore.Qt.AlignBottom)

    def set_status(self, msg, progress_value):
        if progress_value > -1:
            self.progress_scale.show_progress(progress_value)
            self.progress_label.show()
            self.progress_label.setText(msg.split("\n")[0])
        else:
            self.status_label.setText(msg)

    def hide_progress_bar(self):
        self.progress_scale.hide()
        self.progress_label.hide()
