from Qt import QtWidgets, QtCore, QtGui
from wizart.desktop.projects_registry import ProjectsAggregator


class ProjectsTab(QtWidgets.QWidget):
    def __init__(self, app, parent=None):
        super(ProjectsTab, self).__init__(parent)
        self.app = app
        self.setObjectName("projects")
        self.setLayout(QtWidgets.QVBoxLayout())
        self.project_label = QtWidgets.QLabel("<b>PROJECTS</b>")

        self.layout().addWidget(self.project_label)
        self.list_widget = QtWidgets.QListWidget()
        self.list_widget.setViewMode(QtWidgets.QListView.IconMode)
        self.list_widget.setMovement(QtWidgets.QListView.Static)
        self.list_widget.setSelectionMode(QtWidgets.QAbstractItemView.ExtendedSelection)
        self.list_widget.setResizeMode(QtWidgets.QListView.Adjust)
        self.list_widget.setIconSize(QtCore.QSize(100, 100))
        self.layout().addWidget(self.list_widget)
        self.update_projects()
       
    def update_projects(self):
        self.list_widget.clear()
        for proj in ProjectsAggregator.get_projects():
            item = QtWidgets.QListWidgetItem(self.list_widget)
            item.setIcon(QtGui.QIcon(proj.icon))
            item.setText(proj.label)
            item._obj = proj