from Qt import QtCore, QtWidgets
import utils

class LoginDialog(QtWidgets.QDialog):
    def __init__(self, parent=None):
        super(LoginDialog, self).__init__(parent)
        self.setWindowTitle("Studio Login")
        self.setLayout(QtWidgets.QVBoxLayout())

        hlt_1 = QtWidgets.QHBoxLayout()
        hlt_1.addWidget(QtWidgets.QLabel("Login:"))
        self.login_input = QtWidgets.QLineEdit()
        hlt_1.addWidget(self.login_input)
        self.layout().addLayout(hlt_1)
        if utils.get_sync_is_s3():
            hlt_2 = QtWidgets.QHBoxLayout()
            hlt_2.addWidget(QtWidgets.QLabel("AWS_ACCESS_KEY_ID:"))
            self.aws_access_key_id_input = QtWidgets.QLineEdit()
            self.aws_access_key_id_input.setEchoMode(QtWidgets.QLineEdit.Password)
            hlt_2.addWidget(self.aws_access_key_id_input)
            self.layout().addLayout(hlt_2)

            hlt_3 = QtWidgets.QHBoxLayout()
            hlt_3.addWidget(QtWidgets.QLabel("AWS_SECRET_ACCESS_KEY:"))
            self.aws_secret_access_key_input = QtWidgets.QLineEdit()
            self.aws_secret_access_key_input.setEchoMode(QtWidgets.QLineEdit.Password)
            hlt_3.addWidget(self.aws_secret_access_key_input)
            self.layout().addLayout(hlt_3)
        else:
            hlt_2 = QtWidgets.QHBoxLayout()
            hlt_2.addWidget(QtWidgets.QLabel("Password:"))
            self.password_input = QtWidgets.QLineEdit()
            self.password_input.setEchoMode(QtWidgets.QLineEdit.Password)
            hlt_2.addWidget(self.password_input)
            self.layout().addLayout(hlt_2)
            
        hlt_3 = QtWidgets.QHBoxLayout()
        self.ok_btn = QtWidgets.QPushButton("OK")
        self.ok_btn.released.connect(self.accept)
        hlt_3.addWidget(self.ok_btn)
        self.cancel_btn = QtWidgets.QPushButton("Cancel")
        self.cancel_btn.released.connect(self.reject)
        hlt_3.addWidget(self.cancel_btn)
        self.layout().addLayout(hlt_3)
