import os
from .layer_widget import LayerWidget, LayerWidgetRole, ShowLayerText, CopyLayerPath, ReloadLayer, \
    MenuSeparator, CreateSubLayer, CreateAnonymousSubLayer, AddExistingSubLayer, RemoveLayer


class MayaLayerWidgetRole(LayerWidgetRole):
    """Helper which provides standard hooks for defining the context menu
    actions and menu bar menus that should be added to an Layer Widget.
    """

    @classmethod
    def GetContextMenuActions(cls):
        """
        Returns
        -------
        List[Union[MenuAction, Type[MenuAction]]]
        """
        if os.environ.get('WIZART_FREELANCE') == '1':
            return [ShowLayerText, CopyLayerPath, ReloadLayer
                    ]
        else:
            return LayerWidgetRole.GetContextMenuActions()


class MayaLayerWidget(LayerWidget):
    def __init__(self, stage=None, role=None, editTargetChangeCallback=None, parent=None):
        if not role:
            role = MayaLayerWidgetRole()
        LayerWidget.__init__(self, stage, role, editTargetChangeCallback, parent=parent)
        if os.environ.get('WIZART_FREELANCE') == '1':
            self._edit_sublayers_btn.setVisible(False)
        
    def maya_ui_settings(self):
        self._edit_sublayers_btn.setMaximumHeight(18)
        self._edit_sublayers_btn.setMaximumWidth(18)