from Qt import QtCore, QtGui, QtWidgets
from .composition_tree import CompositionTreeWidget
from pxr import Tf, Usd


class MayaCompositionTreeWidget(CompositionTreeWidget):
    def apply_settings(self):
        self.hideColumn(self.columns.index(self.PATH))
        self.hideColumn(self.columns.index(self.RES_PATH))
        self.hideColumn(self.columns.index(self.VERSION))
        self.hideColumn(self.columns.index(self.MUTED))
        self.hideColumn(self.columns.index(self.DIRTY))
        self.header().resizeSection(self.columns.index(self.LAYER), 400)


class MayaCompositionEditor(QtWidgets.QDialog):
    def __init__(self, prim, stage, parent=None):
        QtWidgets.QDialog.__init__(self, parent=parent)
        self.setWindowTitle('Select Edit Target')
        self.setModal(True)
        self.resize(700, 400)

        self._layout = QtWidgets.QVBoxLayout(self)
        self._layout.setContentsMargins(3, 3, 3, 3)
        self._layout.setSpacing(3)
        self._stage = stage
        current_layer = stage.GetEditTarget().GetLayer().GetDisplayName()

        self._crnt_edit_targer_layout = QtWidgets.QHBoxLayout()
        self._layout.addLayout(self._crnt_edit_targer_layout)
        self._crnt_edit_targer_layout.addWidget(QtWidgets.QLabel('Current Edit Target: '))
        self._crnt_edit_target_lbl = QtWidgets.QLabel(current_layer)
        self._crnt_edit_targer_layout.addWidget(self._crnt_edit_target_lbl)
        self._crnt_edit_targer_layout.addWidget(QtWidgets.QSplitter())

        self._composition_tree = MayaCompositionTreeWidget()
        self._layout.addWidget(self._composition_tree)
        self._composition_tree.update(prim, stage)

        buttons = QtWidgets.QDialogButtonBox(
            QtWidgets.QDialogButtonBox.Ok,
            QtCore.Qt.Horizontal, self)
        buttons.accepted.connect(self.close)

        self._layout.addWidget(buttons)
        self._listener_edit_target_chgd = Tf.Notice.Register(Usd.Notice.StageEditTargetChanged,
                                                             self.set_edit_target, stage)

    def set_edit_target(self, *args):
        self._crnt_edit_target_lbl.setText(self._stage.GetEditTarget().GetLayer().GetDisplayName())

    def close(self):
        self._listener_edit_target_chgd = None
        QtWidgets.QDialog.close(self)

