from pxr.UsdQtEditors._Qt import QtCore, QtWidgets, QtGui
from pxr.UsdQtEditors.outliner import NO_VARIANT_SELECTION
try:
    from dcc.undo import UsdEditsUndoBlock as UndoBlock
except ImportError:
    from pxr.UsdQt._usdQt import UndoBlock
from pxr import UsdGeom

class VariantsEditor(QtWidgets.QComboBox):
    def __init__(self, parent, prim, variantSet):
        QtWidgets.QComboBox.__init__(self, parent)
        self.prim = prim

        current = variantSet.GetVariantSelection()
        self.addItems([NO_VARIANT_SELECTION] + variantSet.GetVariantNames())

        current_index = self.findText(current)
        self.setCurrentIndex(current_index)

    def getNewCurrent(self):
        return self.currentText()


class VariantsViewDelegate(QtWidgets.QStyledItemDelegate):
    def __init__(self, dataModel, variants_set_name=''):
        QtWidgets.QStyledItemDelegate.__init__(self)
        self._dataModel = dataModel

    def _showVariantsEditor(self, prim):
        if not prim.HasVariantSets():
            return 0

        variantSet = prim.GetVariantSet(self._set_name)
        variants = variantSet.GetVariantNames()
        if len(variants) <= 0:
            return 0

        return 1

    def createEditor(self, parent, options, index):
        """When editing starting, create editor"""
        prim = index.model()._GetPrimForIndex(index)

        if self._showVariantsEditor(prim):
            variantSet = prim.GetVariantSet(self._set_name)
            dlg = DrawModeEditor(parent=parent, prim=prim)
            return dlg
        else:
            return

    def setModelData(self, editor, model, index):
        """When editing finished, apply changes to model"""
        prim = index.model()._GetPrimForIndex(index)
        variantValue = editor.getNewCurrent()
        if prim:
            variantSet = prim.GetVariantSet(self._set_name)
            with UndoBlock():
                if variantValue == NO_VARIANT_SELECTION:
                    variantSet.ClearVariantSelection()
                else:
                    variantSet.SetVariantSelection(variantValue)


class MaterialViewDelegate(QtWidgets.QStyledItemDelegate):
    def __init__(self, dataModel):
        QtWidgets.QStyledItemDelegate.__init__(self)
        self._dataModel = dataModel

    def editorEvent(self, event, model, option, index):
        paths = index.data(QtCore.Qt.DisplayRole)
        if paths:
            paths = paths.split(',')
            model.needSelectIndexes.emit(paths)
        return True


class RefineLevelDelegate(QtWidgets.QStyledItemDelegate):
    def __init__(self, dataModel):
        QtWidgets.QStyledItemDelegate.__init__(self)
        self._dataModel = dataModel
        from dcc_core import UsdViewportRefineManager
        self.refine_manager = UsdViewportRefineManager.instance()

    def createEditor(self, parent, options, index):
        """When editing starting, create editor"""
        editor = QtWidgets.QSpinBox(parent=parent)
        editor.setMinimum(0)
        editor.setMaximum(8)
        return editor

    def setEditorData(self, editor, index):
        editor.blockSignals(True)
        editor.setValue(index.data(QtCore.Qt.DisplayRole))
        editor.blockSignals(False)




class DrawModeEditor(QtWidgets.QComboBox):
    def __init__(self, parent, prim):
        QtWidgets.QComboBox.__init__(self, parent)
        self.prim = prim
        model = UsdGeom.ModelAPI(self.prim)
        current = model.ComputeModelDrawMode()
        self.addItems([UsdGeom.Tokens.default_, UsdGeom.Tokens.cards, UsdGeom.Tokens.bounds, UsdGeom.Tokens.origin ])

        current_index = self.findText(current)
        self.setCurrentIndex(current_index)

    def getNewCurrent(self):
        return self.currentText()


class DrawModeViewDelegate(QtWidgets.QStyledItemDelegate):
    def __init__(self, dataModel, variants_set_name=''):
        QtWidgets.QStyledItemDelegate.__init__(self)
        self._dataModel = dataModel

    def createEditor(self, parent, options, index):
        """When editing starting, create editor"""
        prim = index.model()._GetPrimForIndex(index)

        if prim:
            dlg = DrawModeEditor(parent=parent, prim=prim)
            return dlg
        else:
            return

    def setModelData(self, editor, model, index):
        """When editing finished, apply changes to model"""
        prim = index.model()._GetPrimForIndex(index)
        value = editor.getNewCurrent()
        if prim:
            model = UsdGeom.ModelAPI(prim)
            with UndoBlock():
                model.CreateModelDrawModeAttr().Set(value)