from pxr.UsdQtEditors._Qt import QtWidgets, QtCore, QtGui

class HeaderVisibilityMenu(QtWidgets.QMenu):
    def __init__(self, parent):
        QtWidgets.QMenu.__init__(self, parent=parent)
        self.view = parent

        self._permanent_columns = set()

        self.aboutToShow.connect(self.update_actions_list)

    def update_actions_list(self):
        self.clear()

        header = self.view.header()
        for column_index in range(self.view.header().count()):
            if column_index in self._permanent_columns:
                continue
            title = self.view.model().headerData(column_index, QtCore.Qt.Horizontal, QtCore.Qt.DisplayRole)
            if title == 'Vis': # I'm not happy about that either
                title = 'Visibility'
            icon = self.view.model().headerData(column_index, QtCore.Qt.Horizontal, QtCore.Qt.DecorationRole)

            is_hidden = header.isSectionHidden(column_index)
            func = (lambda arg: lambda checked_flag:
                    self.change_state(checked_flag, arg))\
                   (column_index)
            self.add_action(title,
                                     QtGui.QIcon(icon),
                                     not is_hidden,
                                     func)

    def add_action(self, name, icon, checked, func):
        action = QtWidgets.QWidgetAction(self)
        checkBox = QtWidgets.QCheckBox(name, self)
        checkBox.setIcon(icon)
        action.setDefaultWidget(checkBox)
        checkBox.setChecked(checked)
        checkBox.toggled.connect(func)
        self.addAction(action)
        return action

    def change_state(self, checked, column_index):
        if checked:
            self.view.showColumn(column_index)
        if not checked:
            self.view.hideColumn(column_index)

    def set_column_permanent(self, index, flag):
        if flag:
            self._permanent_columns.add(index)
        else:
            if index in self._permanent_columns:
                self._permanent_columns.remove(index)
