from Qt import QtCore, QtGui, QtWidgets
import wizart.dcc.core as dcc_core
from .composition_editor import CompositionEditor

class DccCompositionEditor(CompositionEditor):
    def __init__(self, parent=None):
        CompositionEditor.__init__(self, parent=parent)

        self.selection_callback_id = None

        self.app = dcc_core.Application.instance()

        self._current_prim = None

    def showEvent(self, event):
        """Add callbacks to keep ui in sync while visible"""
        self.selection_callback_id = self.app.register_event_callback("selection_changed",
                                                                      self.update_data)
        self.stage_changed_callback_id = self.app.register_event_callback("current_stage_changed",
                                                                          self.update_data)
        # make sure editor starts in correct state
        self.update_data()
        QtWidgets.QWidget.showEvent(self, event)

    def update_data(self):
        session = self.app.get_session()
        stage = session.get_current_stage()
        if not stage:
            CompositionEditor.update(self)
            return

        selected_prim_path = self.app.get_prim_selection()

        prims = []
        for prim_path in selected_prim_path:
            prim = stage.GetPrimAtPath(prim_path)
            if prim.IsValid():
                prims.append(prim)

        # if after changing selection added new selected prims
        # and first selected stayed the same
        # we don't update
        if self._current_prim in prims:
            return

        prim = None
        if prims:
            prim = prims[0]

        CompositionEditor.update(self, prim, stage)

    def hideEvent(self, event):
        """Remove callbacks on ui hide"""
        if self.selection_callback_id:
            self.app.unregister_event_callback("selection_changed", self.selection_callback_id)
            self.selection_callback_id = None
        if self.stage_changed_callback_id:
            self.app.unregister_event_callback("current_stage_changed", self.stage_changed_callback_id)
            self.stage_changed_callback_id = None
        QtWidgets.QWidget.hideEvent(self, event)
