from Qt import QtCore, QtGui, QtWidgets
from pxr import Usd, Tf

from composition_metadata_tree import CompositionMetadataTree


class CompositionMetadataEditor(QtWidgets.QWidget):
    def __init__(self, prim=None, parent=None):
        QtWidgets.QWidget.__init__(self, parent)


        self._layout = QtWidgets.QVBoxLayout(self)
        self._layout.setContentsMargins(0, 0, 0, 0)
        self._layout.setSpacing(0)

        self._tree = CompositionMetadataTree(prim, self)
        self._layout.addWidget(self._tree)

        self.destroyed.connect(self.on_destroyed)

    def update(self, prim=None):
        if not prim:
            self._invalidate()
            return

        self._prim = prim
        stage = self._prim.GetStage()
        self._listener = Tf.Notice.Register(
            Usd.Notice.ObjectsChanged, self.on_object_changed,
            stage)

        self._tree.update(prim)

    def on_object_changed(self, notice, sender):
        if not self._prim:
            self._invalidate()
            return
        changeInfoPaths = notice.GetChangedInfoOnlyPaths()
        resyncedPaths = notice.GetResyncedPaths()
        changeInfoPrimPaths = [path for path in changeInfoPaths if path.IsPrimPath()]
        if self._prim.GetPath() in changeInfoPrimPaths+resyncedPaths:
            self.update(self._prim)

    def _invalidate(self):
        self._prim = None
        self._listener = None
        self._tree.update(None)

    def on_destroyed(self):
        self._invalidate()



