from Qt import QtCore, QtGui, QtWidgets

from composition_metadata_editor import CompositionMetadataEditor
from composition_tree import CompositionTreeWidget


class CompositionEditor(QtWidgets.QWidget):
    def __init__(self, parent=None):
        QtWidgets.QWidget.__init__(self, parent=parent)
        self._layout = QtWidgets.QVBoxLayout(self)
        self._layout.setContentsMargins(0, 0, 0, 0)

        self._splitter = QtWidgets.QSplitter(QtCore.Qt.Vertical, self)
        self._layout.addWidget(self._splitter)

        self._composition_tree = CompositionTreeWidget()
        self._splitter.addWidget(self._composition_tree)

        self._md_widget = CompositionMetadataEditor()
        self._splitter.addWidget(self._md_widget)

    def update(self, prim=None, stage=None):
        self._composition_tree.update(prim, stage)
        self._md_widget.update(prim)
