class Wrapper:
    def __init__(self, cls):
        self.wrapped = cls
        self.instance = None

    def __call__(self, *args, **kwargs):
        if self.instance is None:
            self.instance = self.wrapped(*args, **kwargs)
        return self.instance

def singleton(cls):
    return Wrapper(cls)
