import pymel.core as pm
import functools

def check_alusdmaya_plugin(func):
    @functools.wraps(func)
    def wrapper(*args, **kwargs):
        if not pm.pluginInfo("AL_USDMayaPlugin", query=True, loaded=True):
            pm.loadPlugin("AL_USDMayaPlugin")
        if not pm.pluginInfo("AL_USDMayaPxrTranslators", query=True, loaded=True):
            pm.loadPlugin("AL_USDMayaPxrTranslators")
        return func(*args, **kwargs)
    return wrapper