from pymel.util.arrays import *
from typing import *
import pymel.internal.factories as _factories
import pymel.util as _util
from _typeshed import Incomplete
from pymel.util.enum import Enum as Enum
from typing import Any, Callable, List, Optional, Tuple, Union, overload

class MetaMayaArrayTypeWrapper(_factories.MetaMayaTypeRegistry):
    def __new__(mcl, classname, bases, classdict): ...

class Vector(VectorN):
    apicls: Incomplete
    cnames: Incomplete
    shape: Incomplete
    unit: Incomplete
    def __new__(cls, *args, **kwargs): ...
    def __init__(self, *args, **kwargs) -> None: ...
    data: Incomplete
    def assign(self, value): ...
    def get(self): ...
    def __len__(self) -> int: ...
    def __getitem__(self, i): ...
    def __setitem__(self, i, a) -> None: ...
    def __iter__(self, *args, **kwargs): ...
    def __contains__(self, value) -> bool: ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...
    def __neg__(self): ...
    def __add__(self, other): ...
    def __radd__(self, other): ...
    def __iadd__(self, other): ...
    def __sub__(self, other): ...
    def __rsub__(self, other): ...
    def __isub__(self, other): ...
    def __truediv__(self, other): ...
    __div__ = __truediv__
    def __rtruediv__(self, other): ...
    __rdiv__ = __rtruediv__
    def __itruediv__(self, other): ...
    __idiv__ = __itruediv__
    def __mul__(self, other): ...
    def __rmul__(self, other): ...
    def __imul__(self, other): ...
    def __xor__(self, other): ...
    def __ixor__(self, other): ...
    def isEquivalent(self, other, tol: Incomplete | None = ...): ...
    def isParallel(self, other, tol: Incomplete | None = ...): ...
    def distanceTo(self, other): ...
    def length(self): ...
    def sqlength(self): ...
    def normal(self): ...
    def normalize(self) -> None: ...
    def rotateTo(self, other): ...
    def rotateBy(self, *args): ...
    def transformAsNormal(self, other): ...
    def dot(self, other): ...
    def cross(self, other): ...
    def axis(self, other, normalize: bool = ...): ...
    def angle(self, other): ...
    def cotan(self, other): ...
    Axis: Incomplete
    one: Incomplete
    xAxis: Incomplete
    xNegAxis: Incomplete
    yAxis: Incomplete
    yNegAxis: Incomplete
    zAxis: Incomplete
    zNegAxis: Incomplete
    zero: Incomplete

class FloatVector(Vector):
    apicls: Incomplete
    one: Incomplete
    xAxis: Incomplete
    xNegAxis: Incomplete
    yAxis: Incomplete
    yNegAxis: Incomplete
    zAxis: Incomplete
    zNegAxis: Incomplete
    zero: Incomplete

def planar(p, *args, **kwargs): ...
def center(p, *args): ...
def bWeights(p, *args): ...

class Point(Vector):
    apicls: Incomplete
    cnames: Incomplete
    shape: Incomplete
    def __melobject__(self): ...
    def __len__(self) -> int: ...
    def __iter__(self, *args, **kwargs): ...
    def __add__(self, other): ...
    def __radd__(self, other): ...
    def __iadd__(self, other): ...
    def cartesianize(self): ...
    def cartesian(self): ...
    def rationalize(self): ...
    def rational(self): ...
    def homogenize(self): ...
    def homogen(self): ...
    def isEquivalent(self, other, tol: Incomplete | None = ...): ...
    def axis(self, start, end, normalize: bool = ...): ...
    def angle(self, start, end): ...
    def cotan(self, start, end): ...
    def planar(self, *args, **kwargs): ...
    def center(self, *args): ...
    def bWeights(self, *args): ...
    origin: Incomplete

class FloatPoint(Point):
    apicls: Incomplete
    origin: Incomplete
    def setCast(self, srcpt: Point) -> None: ...

class Color(Vector):
    apicls: Incomplete
    cnames: Incomplete
    shape: Incomplete
    modes: Incomplete
    red: Incomplete
    green: Incomplete
    blue: Incomplete
    white: Incomplete
    black: Incomplete
    opaque: Incomplete
    clear: Incomplete
    @staticmethod
    def rgbtohsv(c): ...
    @staticmethod
    def hsvtorgb(c): ...
    rgba: Incomplete
    rgb: Incomplete
    hsva: Incomplete
    hsv: Incomplete
    h: Incomplete
    s: Incomplete
    v: Incomplete
    def __init__(self, *args, **kwargs) -> None: ...
    def __melobject__(self): ...
    def __add__(self, other): ...
    def __radd__(self, other): ...
    def __iadd__(self, other): ...
    def __sub__(self, other): ...
    def __rsub__(self, other): ...
    def __isub__(self, other): ...
    def __mul__(self, other): ...
    def __rmul__(self, other): ...
    def __imul__(self, other): ...
    def over(self, other): ...
    def premult(self): ...
    def gamma(self, g): ...
    def hsvblend(self, other, weight: float = ...): ...
    MColorType: Incomplete
    kOpaqueBlack: Incomplete
    def set(self, colorModel: Color.MColorType, c1: float, c2: float, c3: float, alpha: float = ...) -> bool: ...

class Space:
    apicls: Incomplete
    Space: Incomplete

Spaces: Incomplete

def equivalentSpace(space1: Union[int, str], space2: Union[int, str], rotationOnly: bool = ...) -> None: ...

class Matrix(MatrixN):
    apicls: Incomplete
    shape: Incomplete
    cnames: Incomplete
    identity: Incomplete
    def __new__(cls, *args, **kwargs): ...
    def __init__(self, *args, **kwargs) -> None: ...
    data: Incomplete
    translate: Incomplete
    rotate: Incomplete
    scale: Incomplete
    def __melobject__(self): ...
    def asMatrix(self, percent: Incomplete | None = ...): ...
    matrix: Incomplete
    def assign(self, value): ...
    def get(self): ...
    def __len__(self) -> int: ...
    def __iter__(self, *args, **kwargs): ...
    def __getitem__(self, index): ...
    def __getslice__(self, start, end): ...
    def __setitem__(self, index, value) -> None: ...
    def __setslice__(self, start, end, value) -> None: ...
    def __delitem__(self, index) -> None: ...
    def __delslice__(self, start, end) -> None: ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...
    def __neg__(self): ...
    def __add__(self, other): ...
    def __radd__(self, other): ...
    def __iadd__(self, other): ...
    def __sub__(self, other): ...
    def __rsub__(self, other): ...
    def __isub__(self, other): ...
    def __mul__(self, other): ...
    def __rmul__(self, other): ...
    def __imul__(self, other): ...
    def setToIdentity(self): ...
    def setToProduct(self, left, right): ...
    def transpose(self): ...
    def inverse(self): ...
    def adjoint(self): ...
    def homogenize(self): ...
    def det(self): ...
    def det4x4(self): ...
    def det3x3(self): ...
    def isEquivalent(self, other, tol=...): ...
    def isSingular(self): ...
    def blend(self, other, weight: float = ...): ...
    def weighted(self, weight): ...

class FloatMatrix(Matrix):
    apicls: Incomplete

class Quaternion(Matrix):
    apicls: Incomplete
    shape: Incomplete
    cnames: Incomplete
    def __new__(cls, *args, **kwargs): ...
    unit: str
    def __init__(self, *args, **kwargs) -> None: ...
    translate: Incomplete
    rotate: Incomplete
    scale: Incomplete
    def assign(self, value): ...
    def get(self): ...
    def __getitem__(self, i): ...
    def __setitem__(self, i, a) -> None: ...
    def __iter__(self): ...
    def __len__(self) -> int: ...
    def __contains__(self, value) -> bool: ...
    identity: Incomplete
    def asEulerRotation(self) -> EulerRotation: ...
    def conjugateIt(self) -> Quaternion: ...
    def exp(self) -> Quaternion: ...
    def invertIt(self) -> Quaternion: ...
    def log(self) -> Quaternion: ...
    def negateIt(self) -> Quaternion: ...
    def normalizeIt(self) -> Quaternion: ...
    def scaleIt(self, scale: float) -> Quaternion: ...
    def setToXAxis(self, theta: float) -> Quaternion: ...
    def setToYAxis(self, theta: float) -> Quaternion: ...
    def setToZAxis(self, theta: float) -> Quaternion: ...

class TransformationMatrix(Matrix):
    apicls: Incomplete
    translate: Incomplete
    rotate: Incomplete
    def rotateTo(self, value): ...
    def eulerRotation(self): ...
    euler: Incomplete
    def getRotation(self): ...
    def setRotation(self, *args) -> None: ...
    scale: Incomplete
    RotationOrder: Incomplete
    identity: Incomplete
    def __getattribute__(self, name): ...
    def addRotation(self, rot: Tuple[float, float, float], order: TransformationMatrix.RotationOrder, space: Space.Space) -> None: ...
    def addRotationQuaternion(self, x: float, y: float, z: float, w: float, space: Space.Space) -> None: ...
    def addScale(self, scale: Tuple[float, float, float], space: Space.Space) -> None: ...
    def addShear(self, shear: Tuple[float, float, float], space: Space.Space) -> None: ...
    def addTranslation(self, vector: Vector, space: Space.Space) -> None: ...
    def asMatrixInverse(self) -> Matrix: ...
    def asRotateMatrix(self) -> Matrix: ...
    def asScaleMatrix(self) -> Matrix: ...
    def getRotatePivot(self, space: Space.Space) -> Point: ...
    def getRotatePivotTranslation(self, space: Space.Space) -> Vector: ...
    def getRotationOrientation(self) -> Quaternion: ...
    def getRotationQuaternion(self) -> Tuple[float, float, float, float]: ...
    def getScale(self, space: Space.Space) -> Tuple[float, float, float]: ...
    def getScalePivot(self, space: Space.Space) -> Point: ...
    def getScalePivotTranslation(self, space: Space.Space) -> Vector: ...
    def getShear(self, space: Space.Space) -> Tuple[float, float, float]: ...
    def getTranslation(self, space: Space.Space) -> Vector: ...
    def reorderRotation(self, order: TransformationMatrix.RotationOrder) -> None: ...
    def rotateBy(self, q: Quaternion, space: Space.Space) -> TransformationMatrix: ...
    def rotationOrder(self) -> TransformationMatrix.RotationOrder: ...
    def setRotatePivot(self, point: Point, space: Space.Space, balance: bool) -> None: ...
    def setRotatePivotTranslation(self, vector: Vector, space: Space.Space) -> None: ...
    def setRotationOrientation(self, q: Quaternion) -> TransformationMatrix: ...
    def setRotationQuaternion(self, x: float, y: float, z: float, w: float) -> None: ...
    def setScale(self, scale: Tuple[float, float, float], space: Space.Space) -> None: ...
    def setScalePivot(self, point: Point, space: Space.Space, balance: bool) -> None: ...
    def setScalePivotTranslation(self, vector: Vector, space: Space.Space) -> None: ...
    def setShear(self, shear: Tuple[float, float, float], space: Space.Space) -> None: ...
    def setToRotationAxis(self, axis: Vector, rotation: float) -> None: ...
    def setTranslation(self, vector: Vector, space: Space.Space) -> None: ...

class EulerRotation:
    apicls: Incomplete
    shape: Incomplete
    cnames: Incomplete
    order: Incomplete
    def __new__(cls, *args, **kwargs): ...
    unit: Incomplete
    def __init__(self, *args, **kwargs) -> None: ...
    def setDisplayUnit(self, unit) -> None: ...
    def __iter__(self): ...
    def __getitem__(self, i): ...
    def __setitem__(self, key, val) -> None: ...
    def assign(self, *args, **kwargs): ...
    def get(self): ...
    def __contains__(self, value) -> bool: ...
    def __len__(self) -> int: ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...
    def __neg__(self): ...
    def __add__(self, other): ...
    def __radd__(self, other): ...
    def __iadd__(self, other): ...
    def __sub__(self, other): ...
    def __rsub__(self, other): ...
    def __isub__(self, other): ...
    def __truediv__(self, other): ...
    __div__ = __truediv__
    def __rtruediv__(self, other): ...
    __rdiv__ = __rtruediv__
    def __itruediv__(self, other): ...
    __idiv__ = __itruediv__
    def __mul__(self, other): ...
    def __rmul__(self, other): ...
    def __imul__(self, other): ...
    RotationOrder: Incomplete
    identity: Incomplete
    def alternateSolution(self) -> EulerRotation: ...
    def asMatrix(self) -> Matrix: ...
    def asQuaternion(self) -> Quaternion: ...
    def asVector(self) -> Vector: ...
    def bound(self) -> EulerRotation: ...
    def boundIt(self, src: EulerRotation) -> EulerRotation: ...
    def closestCut(self, dst: EulerRotation) -> EulerRotation: ...
    def closestSolution(self, dst: EulerRotation) -> EulerRotation: ...
    @classmethod
    def decompose(self, matrix: Matrix, ord: EulerRotation.RotationOrder) -> EulerRotation: ...
    def incrementalRotateBy(self, axis: Vector, angle: float) -> EulerRotation: ...
    def inverse(self) -> EulerRotation: ...
    def invertIt(self) -> EulerRotation: ...
    def isZero(self, tolerance: float = ...) -> bool: ...
    def reorder(self, ord: EulerRotation.RotationOrder) -> EulerRotation: ...
    def reorderIt(self, ord: EulerRotation.RotationOrder) -> EulerRotation: ...
    def setToAlternateSolution(self, src: EulerRotation) -> EulerRotation: ...
    def setToClosestCut(self, src: EulerRotation, dst: EulerRotation) -> EulerRotation: ...
    def setToClosestSolution(self, src: EulerRotation, dst: EulerRotation) -> EulerRotation: ...
    def setValue(self, v: Vector, ord: EulerRotation.RotationOrder = ...) -> EulerRotation: ...

class Unit(float):
    @classmethod
    def getUIUnit(cls): ...
    @classmethod
    def setUIUnit(cls, unit: Incomplete | None = ...) -> None: ...
    @classmethod
    def getInternalUnit(cls): ...
    @classmethod
    def uiToInternal(cls, value): ...
    @classmethod
    def kUnit(cls, unit: Incomplete | None = ...): ...
    @classmethod
    def sUnit(cls, unit: Incomplete | None = ...): ...
    def getUnit(self): ...
    unit: Incomplete
    def __new__(cls, value, unit: Incomplete | None = ...): ...
    def assign(self, *args) -> None: ...
    def asUnit(self, unit): ...
    def asUIUnit(self): ...
    def asInternalUnit(self): ...

class Time(Unit):
    apicls: Incomplete
    Unit: Incomplete

class Distance(Unit):
    apicls: Incomplete
    def asMillimeter(self): ...
    def asCentimeters(self): ...
    def asKilometers(self): ...
    def asMeters(self): ...
    def asInches(self): ...
    def asFeet(self): ...
    def asYards(self): ...
    def asMiles(self): ...
    Unit: Incomplete

class Angle(Unit):
    apicls: Incomplete
    def asRadians(self): ...
    def asDegrees(self): ...
    def asAngMinutes(self): ...
    def asAngSeconds(self): ...
    Unit: Incomplete

class BoundingBox:
    apicls: Incomplete
    def __init__(self, *args) -> None: ...
    def __getitem__(self, item): ...
    def __melobject__(self): ...
    repr: Incomplete
    def center(self) -> Point: ...
    def clear(self) -> None: ...
    def contains(self, point: Point) -> bool: ...
    def depth(self) -> float: ...
    d: Incomplete
    def expand(self, point: Point) -> None: ...
    def height(self) -> float: ...
    h: Incomplete
    def intersects(self, box: BoundingBox, tol: float = ...) -> bool: ...
    def max(self) -> Point: ...
    def min(self) -> Point: ...
    def transformUsing(self, matrix: Matrix) -> None: ...
    def width(self) -> float: ...
    w: Incomplete

def getPlugValue(plug): ...
