version = (1, 2)

data = {'TanimLayer': {'description': '', 'flags': {}},
 'TrenderSetupStates': {'description': '', 'flags': {}},
 'aaf2fcp': {'description': 'This command is used to convert an aff file to a Final Cut Pro (fcp) xml file The conversion process can take several seconds to complete and the command is meant to be run asynchronously \t         ',
             'flags': {'deleteFile': {'docstring': 'Delete temporary file. Can only be used with the terminate option'},
                       'dstPath': {'docstring': 'Specifiy a destination path'},
                       'getFileName': {'docstring': 'Query output file name'},
                       'progress': {'docstring': 'Request progress report'},
                       'srcFile': {'docstring': 'Specifiy a source file'},
                       'terminate': {'docstring': 'Complete the task'},
                       'waitCompletion': {'docstring': 'Wait for the conversion process to complete \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'about': {'description': 'This command displays version information about the application if it is executed without flags.  If one of the above flags is specified then the specified version information is returned. ',
           'flags': {'apiVersion': {'docstring': 'Returns the api version.'},
                     'application': {'docstring': 'Returns the application name string.'},
                     'batch': {'docstring': 'Returns true if application is in batch mode.'},
                     'buildDirectory': {'docstring': 'Returns the build directory string.'},
                     'buildVariant': {'docstring': 'Returns the build variant string.'},
                     'codeset': {'docstring': 'Returns a string identifying the codeset (codepage) of the locale that Maya is running in. Example return values include "UTF-8", "ISO-8859-1", "1252". Note that the codeset values and naming conventions are highly platform dependent.  They may differ in format even if they have the same meaning (e.g. "utf8" vs. "UTF-8").'},
                     'compositingManager': {'docstring': 'On Linux, returns true if there is a compositing manager running; on all other platforms, it always returns true.'},
                     'connected': {'docstring': 'Return whether the user is connected or not to the Internet.'},
                     'ctime': {'docstring': 'Returns the current time in the format Wed Jan 02 02:03:55 1980\\n\\0'},
                     'currentDate': {'docstring': 'Returns the current date in the format yyyy/mm/dd, e.g. 2003/05/04.'},
                     'currentTime': {'docstring': 'Returns the current time in the format hh:mm:ss, e.g. 14:27:53.'},
                     'customVersion': {'docstring': 'Returns true if this is a custom version of Maya.'},
                     'customVersionClient': {'docstring': 'Returns the custom client version string for Maya or an empty string if this is not a custom version.'},
                     'customVersionMajor': {'docstring': 'Returns the custom major version of Maya or 0 if this is not a custom version.'},
                     'customVersionMinor': {'docstring': 'Returns the custom minor version of Maya or 0 if this is not a custom version.'},
                     'customVersionString': {'docstring': 'Returns the custom version string for Maya or an empty string if this is not a custom version.'},
                     'cutIdentifier': {'docstring': 'Returns the cut string.'},
                     'date': {'docstring': 'Returns the build date string.'},
                     'environmentFile': {'docstring': 'Returns the location of the application defaults file.'},
                     'evalVersion': {'docstring': 'This flag is now deprecated. Always returns false, as the eval version is no longer supported.'},
                     'file': {'docstring': 'Returns the file version string.'},
                     'fontInfo': {'docstring': 'Returns a string of the specifications of the fonts requested, and the specifications of the fonts that are actually being used.'},
                     'helpDataDirectory': {'docstring': 'Returns the help data directory.'},
                     'installedVersion': {'docstring': 'Returns the product version string.'},
                     'ioVersion': {'docstring': 'Returns true if this is the Maya IO version of the application.'},
                     'irix': {'docstring': 'Returns true if the operating system is Irix. Always false with support for Irix removed.'},
                     'is64': {'docstring': 'Returns true if the application is 64 bit.'},
                     'languageResources': {'docstring': 'Returns a string array of the currently installed language resources. Each string entry consists of three elements delimited with a colon (\':\'). The first token is the locale code (ISO 639-1 language code followed by ISO 3166-1 country code).  The second token is the language name in English. This third token is the alpha-3 code (ISO 639-2).  For example English is represented as "en_US:English:enu".'},
                     'linux': {'docstring': 'Returns true if the operating system is Linux.'},
                     'linux64': {'docstring': 'Returns true if the operating system is Linux 64 bit.'},
                     'liveUpdate': {'docstring': 'This flag is deprecated(2019) and may be removed in future releases of Maya. Returns Autodesk formatted product information.'},
                     'localizedResourceLocation': {'docstring': 'Returns the path to the top level of the localized resource directory, if we are running in an alternate language. Returns an empty string if we are running in the default language.'},
                     'ltVersion': {'docstring': 'Returns true if this is the Maya LT version of the application.'},
                     'macOS': {'docstring': 'Returns true if the operating system is Macintosh.'},
                     'macOSppc': {'docstring': 'Returns true if the operating system is a PowerPC Macintosh.'},
                     'macOSx86': {'docstring': 'Returns true if the operating system is an Intel Macintosh.'},
                     'majorVersion': {'docstring': 'Returns the major version of Maya.'},
                     'minorVersion': {'docstring': 'Returns the minor version of Maya.'},
                     'ntOS': {'docstring': 'Returns true if the operating system is Windows.'},
                     'operatingSystem': {'docstring': 'Returns the operating system type. Valid return types are "nt", "win64", "mac", "linux" and "linux64"'},
                     'operatingSystemVersion': {'docstring': 'Returns the operating system version. on Linux this returns the equivalent of uname -srvm'},
                     'patchVersion': {'docstring': 'Returns the patch version of Maya.'},
                     'preferences': {'docstring': 'Returns the location of the preferences directory.'},
                     'product': {'docstring': 'Returns the license product name.'},
                     'qtVersion': {'docstring': 'Returns Qt version string.'},
                     'query': {'docstring': ''},
                     'tablet': {'docstring': 'Windows only.  Returns true if the PC is a Tablet PC.'},
                     'tabletMode': {'docstring': 'Windows 8 (and above) only.  If your device is a Tablet PC, then the convertible mode the device is currently running in.  Returns  either: tablet or laptop (keyboard attached). See the tabletflag.'},
                     'uiLanguage': {'docstring': 'Returns the language that Maya\'s running in.  Example return values include "en_US" for English and "ja_JP" for Japanese.'},
                     'uiLanguageForStartup': {'docstring': "Returns the language that is used for Maya's next start up. This is read from config file and is rewritten after setting ui language in preference."},
                     'uiLanguageIsLocalized': {'docstring': 'Returns true if we are running in an alternate language, not the default (English).'},
                     'uiLocaleLanguage': {'docstring': 'Returns the language locale of the OS. English is default.'},
                     'version': {'docstring': 'Returns the version string.'},
                     'win64': {'docstring': 'Returns true if the operating system is Windows x64 based.'},
                     'windowManager': {'docstring': 'Returns the name of the Window Manager that is assumed to be running.'},
                     'windows': {'docstring': 'Returns true if the operating system is Windows based.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'addAttr': {'description': 'This command is used to add a dynamic attribute to a node or nodes. Either the longName or the shortName or both must be specified. If neither a dataType nor an attributeType is specified, a double attribute will be added.  The dataType flag can be specified more than once indicating that any of the supplied types will be accepted (logical-or).  To add a non-double attribute the following criteria can be used to determine whether the dataType or the attributeType flag is appropriate.  Some types, such as double3can use either. In these cases the -dtflag should be used when you only wish to access the data as an atomic entity (eg. you never want to access the three individual values that make up a double3).  In general it is best to use the -atin these cases for maximum flexibility. In most cases the -dtversion will not display in the attribute editor as it is an atomic type and you are not allowed to change individual parts of it.  All attributes flagged as "(compound)" below or the compound attribute itself are not actually added to the node until all of the children are defined (using the "-p" flag to set their parent to the compound being created).  See the EXAMPLES section for more details.  Type of attribute              Flag and argument to use      boolean                                                -at bool                      32 bit integer                                 -at long                      16 bit integer                                 -at short                     8 bit integer                                  -at byte                      char                                                   -at char                      enum                                                  -at enum (specify the enum names using the enumName flag) float                                                  -at "float" (use quotes                                                                         since float is a mel keyword)   double                                                 -at double            angle value                                    -at doubleAngle       linear value                                   -at doubleLinear      string                                                 -dt "string" (use quotes                                                                         since string is a mel keyword)  array of strings                               -dt stringArray       compound                                               -at compound          message (no data)                              -at message           time                                                   -at time                      4x4 double matrix                              -dt "matrix" (use quotes                                                                         since matrix is a mel keyword)  4x4 float matrix                               -at fltMatrix         reflectance                                    -dt reflectanceRGBreflectance (compound)                 -at reflectance       spectrum                                               -dt spectrumRGB       spectrum (compound)                    -at spectrum          2 floats                                               -dt float2            2 floats (compound)                    -at float2            3 floats                                               -dt float3            3 floats (compound)                    -at float3            2 doubles                                              -dt double2           2 doubles (compound)                   -at double2           3 doubles                                              -dt double3           3 doubles (compound)                   -at double3           2 32-bit integers                              -dt long2                     2 32-bit integers (compound)   -at long2                     3 32-bit integers                              -dt long3                     3 32-bit integers (compound)   -at long3                     2 16-bit integers                              -dt short2            2 16-bit integers (compound)   -at short2            3 16-bit integers                              -dt short3            3 16-bit integers (compound)   -at short3            array of doubles                               -dt doubleArray       array of floats                                -dt floatArray        array of 32-bit ints                   -dt Int32Array        array of vectors                               -dt vectorArray       nurbs curve                                    -dt nurbsCurve        nurbs surface                                  -dt nurbsSurface      polygonal mesh                                 -dt mesh                      lattice                                                -dt lattice           array of double 4D points              -dt pointArray        In query mode, return type is based on queried flag.',
             'flags': {'attributeType': {'docstring': 'Specifies the attribute type, see above table for more details. Note that the attribute types "float", "matrix" and "string" are also MEL keywords and must be enclosed in quotes.'},
                       'binaryTag': {'docstring': 'This flag is obsolete and does not do anything any more'},
                       'cachedInternally': {'docstring': 'Whether or not attribute data is cached internally in the node. This flag defaults to true for writable attributes and false for non-writable attributes. A warning will be issued if users attempt to force a writable attribute to be uncached as this will make it impossible to set keyframes.'},
                       'category': {'docstring': 'An attribute category is a string associated with the attribute to identify it. (e.g. the name of a plugin that created the attribute, version information, etc.) Any attribute can be associated with an arbitrary number of categories however categories can not be removed once associated.'},
                       'dataType': {'docstring': 'Specifies the data type.  See "setAttr" for more information on data type names.'},
                       'defaultValue': {'docstring': 'Specifies the default value for the attribute (can only be used for numeric attributes).'},
                       'disconnectBehaviour': {'docstring': 'defines the Disconnect Behaviour 2 Nothing, 1 Reset, 0 Delete'},
                       'edit': {'docstring': ''},
                       'enumName': {'docstring': 'Flag used to specify the ui names corresponding to the enum values. The specified string should contain a colon-separated list of the names, with optional values. If values are not specified, they will treated as sequential integers starting with 0. For example: -enumName "A:B:C" would produce options: A,B,C with values of 0,1,2; -enumName "zero:one:two:thousand=1000" would produce four options with values 0,1,2,1000; and -enumName "solo=1:triplet=3:quintet=5" would produce three options with values 1,3,5.  (Note that there is a current limitation of the Channel Box that will sometimes incorrectly display an enumerated attribute\'s pull-down menu.  Extra menu items can appear that represent the numbers inbetween non-sequential option values.  To avoid this limitation, specify sequential values for the options of any enumerated attributes that will appear in the Channel Box.  For example: "solo=1:triplet=2:quintet=3".)'},
                       'exists': {'docstring': 'Returns true if the attribute queried is a user-added, dynamic attribute; false if not.'},
                       'fromPlugin': {'docstring': 'Was the attribute originally created by a plugin? Normally set automatically when the API call is made - only added here to support storing it in a file independently from the creating plugin.'},
                       'hasMaxValue': {'docstring': 'Flag indicating whether an attribute has a maximum value. (can only be used for numeric attributes).'},
                       'hasMinValue': {'docstring': 'Flag indicating whether an attribute has a minimum value. (can only be used for numeric attributes).'},
                       'hasSoftMaxValue': {'docstring': 'Flag indicating whether a numeric attribute has a soft maximum.'},
                       'hasSoftMinValue': {'docstring': 'Flag indicating whether a numeric attribute has a soft minimum.'},
                       'hidden': {'docstring': 'Will this attribute be hidden from the UI?'},
                       'indexMatters': {'docstring': 'Sets whether an index must be used when connecting to this multi-attribute. Setting indexMatters to false forces the attribute to non-readable.'},
                       'internalSet': {'docstring': 'Whether or not the internal cached value is set when this attribute value is changed.  This is an internal flag used for updating UI elements.'},
                       'keyable': {'docstring': 'Is the attribute keyable by default?'},
                       'longName': {'docstring': 'Sets the long name of the attribute.'},
                       'maxValue': {'docstring': 'Specifies the maximum value for the attribute (can only be used for numeric attributes).'},
                       'minValue': {'docstring': 'Specifies the minimum value for the attribute (can only be used for numeric attributes).'},
                       'multi': {'docstring': 'Makes the new attribute a multi-attribute.'},
                       'niceName': {'docstring': 'Sets the nice name of the attribute for display in the UI.  Setting the attribute\'s nice name to a non-empty string overrides the default behaviour of looking up the nice name from Maya\'s string catalog.   (Use the MEL commands "attributeNiceName" and "attributeQuery -niceName" to lookup an attribute\'s nice name in the catalog.)'},
                       'numberOfChildren': {'docstring': 'How many children will the new attribute have?'},
                       'parent': {'docstring': "Attribute that is to be the new attribute's parent."},
                       'proxy': {'docstring': "Proxy another node's attribute. Proxied plug will be connected as source. The UsedAsProxy flag is automatically set in this case."},
                       'query': {'docstring': ''},
                       'readable': {'docstring': 'Can outgoing connections be made from this attribute?'},
                       'shortName': {'docstring': 'Sets the short name of the attribute.'},
                       'softMaxValue': {'docstring': 'Soft maximum, valid for numeric attributes only.  Specifies the upper default limit used in sliders for this attribute.'},
                       'softMinValue': {'docstring': 'Soft minimum, valid for numeric attributes only.  Specifies the lower default limit used in sliders for this attribute.'},
                       'storable': {'docstring': 'Can the attribute be stored out to a file?'},
                       'usedAsColor': {'docstring': 'Is the attribute to be used as a color definition? Must have 3 DOUBLE or 3 FLOAT children to use this flag.  The attribute type "-at" should be "double3" or "float3" as appropriate.  It can also be used to less effect with data types "-dt" as "double3" or "float3" as well but some parts of the code do not support this alternative.  The special attribute types/data "spectrum" and "reflectance" also support the color flag and on them it is set by default.'},
                       'usedAsFilename': {'docstring': 'Is the attribute to be treated as a filename definition? This flag is only supported on attributes with data type "-dt" of "string".'},
                       'usedAsProxy': {'docstring': 'Set if the specified attribute should be treated as a proxy to another attributes.'},
                       'worldSpace': {'docstring': 'Sets whether this attribute should be treated as worldspace. Being worldspace indicates the attribute is dependent on the worldSpace transformation of this node, and will be marked dirty by any attribute changes in the hierarchy that affects the worldSpace transformation. The attribute needs to be an array since during instancing there are multiple worldSpace paths to the node and Maya requires one array element per path for worldSpace attributes. Remarks: 1. Can only be used on array attributes. 2. This property is ignored on non-dag nodes. 3. The attribute should be affected by another attribute or have a connection.    Otherwise, the attribute will not get computed and will not get dirty again.'},
                       'writable': {'docstring': 'Can incoming connections be made to this attribute? \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'addDynamic': {'description': 'Makes the "object" specified as second argument the source of an existing field or emitter specified as the first argument. In practical terms, what this means is that a field will emanate its force from its owner object, and an emitter will emit from its owner object. addDynamic makes the specified field or emitter a child of the owner\'s transform (adding it to the model if it was not already there), and makes the necessary attribute connections. If either of the arguments is omitted, addDynamic searches the selection list for objects to use instead. If more than one possible owner or field/emitter is selected, addDynamic will do nothing. If the specified field/emitter already has a source, addDynamic will remove the current source and replace it with the newly specified source. If a subset of the owner object\'s cvs/particles/vertices is selected, addDynamic will add the field/emitter to that subset only. ',
                'flags': {}},
 'addExtension': {'description': 'This command is used to add an extension attribute to a node type. Either the longName or the shortName or both must be specified. If neither a dataType nor an attributeType is specified, a double attribute will be added.  The dataType flag can be specified more than once indicating that any of the supplied types will be accepted (logical-or).  To add a non-double attribute the following criteria can be used to determine whether the dataType or the attributeType flag is appropriate.  Some types, such as double3can use either. In these cases the -dtflag should be used when you only wish to access the data as an atomic entity (eg. you never want to access the three individual values that make up a double3).  In general it is best to use the -atin these cases for maximum flexibility. In most cases the -dtversion will not display in the attribute editor as it is an atomic type and you are not allowed to change individual parts of it.  All attributes flagged as "(compound)" below or the compound attribute itself are not actually added to the node until all of the children are defined (using the "-p" flag to set their parent to the compound being created).  See the EXAMPLES section for more details.  Type of attribute              Flag and argument to use      boolean                                                -at bool                      32 bit integer                                 -at long                      16 bit integer                                 -at short                     8 bit integer                                  -at byte                      char                                                   -at char                      enum                                                  -at enum (specify the enum names using the enumName flag) float                                                  -at "float" (use quotes                                                                         since float is a mel keyword)   double                                                 -at double            angle value                                    -at doubleAngle       linear value                                   -at doubleLinear      string                                                 -dt "string" (use quotes                                                                         since string is a mel keyword)  array of strings                               -dt stringArray       compound                                               -at compound          message (no data)                              -at message           time                                                   -at time                      4x4 double matrix                              -dt "matrix" (use quotes                                                                         since matrix is a mel keyword)  4x4 float matrix                               -at fltMatrix         reflectance                                    -dt reflectanceRGBreflectance (compound)                 -at reflectance       spectrum                                               -dt spectrumRGB       spectrum (compound)                    -at spectrum          2 floats                                               -dt float2            2 floats (compound)                    -at float2            3 floats                                               -dt float3            3 floats (compound)                    -at float3            2 doubles                                              -dt double2           2 doubles (compound)                   -at double2           3 doubles                                              -dt double3           3 doubles (compound)                   -at double3           2 32-bit integers                              -dt long2                     2 32-bit integers (compound)   -at long2                     3 32-bit integers                              -dt long3                     3 32-bit integers (compound)   -at long3                     2 16-bit integers                              -dt short2            2 16-bit integers (compound)   -at short2            3 16-bit integers                              -dt short3            3 16-bit integers (compound)   -at short3            array of doubles                               -dt doubleArray       array of floats                                -dt floatArray        array of 32-bit ints                   -dt Int32Array        array of vectors                               -dt vectorArray       nurbs curve                                    -dt nurbsCurve        nurbs surface                                  -dt nurbsSurface      polygonal mesh                                 -dt mesh                      lattice                                                -dt lattice           array of double 4D points              -dt pointArray        In query mode, return type is based on queried flag.',
                  'flags': {'attributeType': {'docstring': 'Specifies the attribute type, see above table for more details. Note that the attribute types "float", "matrix" and "string" are also MEL keywords and must be enclosed in quotes.'},
                            'binaryTag': {'docstring': 'This flag is obsolete and does not do anything any more'},
                            'cachedInternally': {'docstring': 'Whether or not attribute data is cached internally in the node. This flag defaults to true for writable attributes and false for non-writable attributes. A warning will be issued if users attempt to force a writable attribute to be uncached as this will make it impossible to set keyframes.'},
                            'category': {'docstring': 'An attribute category is a string associated with the attribute to identify it. (e.g. the name of a plugin that created the attribute, version information, etc.) Any attribute can be associated with an arbitrary number of categories however categories can not be removed once associated.'},
                            'dataType': {'docstring': 'Specifies the data type.  See "setAttr" for more information on data type names.'},
                            'defaultValue': {'docstring': 'Specifies the default value for the attribute (can only be used for numeric attributes).'},
                            'disconnectBehaviour': {'docstring': 'defines the Disconnect Behaviour 2 Nothing, 1 Reset, 0 Delete'},
                            'edit': {'docstring': ''},
                            'enumName': {'docstring': 'Flag used to specify the ui names corresponding to the enum values. The specified string should contain a colon-separated list of the names, with optional values. If values are not specified, they will treated as sequential integers starting with 0. For example: -enumName "A:B:C" would produce options: A,B,C with values of 0,1,2; -enumName "zero:one:two:thousand=1000" would produce four options with values 0,1,2,1000; and -enumName "solo=1:triplet=3:quintet=5" would produce three options with values 1,3,5.  (Note that there is a current limitation of the Channel Box that will sometimes incorrectly display an enumerated attribute\'s pull-down menu.  Extra menu items can appear that represent the numbers inbetween non-sequential option values.  To avoid this limitation, specify sequential values for the options of any enumerated attributes that will appear in the Channel Box.  For example: "solo=1:triplet=2:quintet=3".)'},
                            'exists': {'docstring': 'Returns true if the attribute queried is a user-added, dynamic attribute; false if not.'},
                            'fromPlugin': {'docstring': 'Was the attribute originally created by a plugin? Normally set automatically when the API call is made - only added here to support storing it in a file independently from the creating plugin.'},
                            'hasMaxValue': {'docstring': 'Flag indicating whether an attribute has a maximum value. (can only be used for numeric attributes).'},
                            'hasMinValue': {'docstring': 'Flag indicating whether an attribute has a minimum value. (can only be used for numeric attributes).'},
                            'hasSoftMaxValue': {'docstring': 'Flag indicating whether a numeric attribute has a soft maximum.'},
                            'hasSoftMinValue': {'docstring': 'Flag indicating whether a numeric attribute has a soft minimum.'},
                            'hidden': {'docstring': 'Will this attribute be hidden from the UI?'},
                            'indexMatters': {'docstring': 'Sets whether an index must be used when connecting to this multi-attribute. Setting indexMatters to false forces the attribute to non-readable.'},
                            'internalSet': {'docstring': 'Whether or not the internal cached value is set when this attribute value is changed.  This is an internal flag used for updating UI elements.'},
                            'keyable': {'docstring': 'Is the attribute keyable by default?'},
                            'longName': {'docstring': 'Sets the long name of the attribute.'},
                            'maxValue': {'docstring': 'Specifies the maximum value for the attribute (can only be used for numeric attributes).'},
                            'minValue': {'docstring': 'Specifies the minimum value for the attribute (can only be used for numeric attributes).'},
                            'multi': {'docstring': 'Makes the new attribute a multi-attribute.'},
                            'niceName': {'docstring': 'Sets the nice name of the attribute for display in the UI.  Setting the attribute\'s nice name to a non-empty string overrides the default behaviour of looking up the nice name from Maya\'s string catalog.   (Use the MEL commands "attributeNiceName" and "attributeQuery -niceName" to lookup an attribute\'s nice name in the catalog.)'},
                            'nodeType': {'docstring': 'Specifies the type of node to which the attribute will be added. See the nodeType command for the names of different node types.'},
                            'numberOfChildren': {'docstring': 'How many children will the new attribute have?'},
                            'parent': {'docstring': "Attribute that is to be the new attribute's parent."},
                            'proxy': {'docstring': "Proxy another node's attribute. Proxied plug will be connected as source. The UsedAsProxy flag is automatically set in this case."},
                            'query': {'docstring': ''},
                            'readable': {'docstring': 'Can outgoing connections be made from this attribute?'},
                            'shortName': {'docstring': 'Sets the short name of the attribute.'},
                            'softMaxValue': {'docstring': 'Soft maximum, valid for numeric attributes only.  Specifies the upper default limit used in sliders for this attribute.'},
                            'softMinValue': {'docstring': 'Soft minimum, valid for numeric attributes only.  Specifies the lower default limit used in sliders for this attribute.'},
                            'storable': {'docstring': 'Can the attribute be stored out to a file?'},
                            'usedAsColor': {'docstring': 'Is the attribute to be used as a color definition? Must have 3 DOUBLE or 3 FLOAT children to use this flag.  The attribute type "-at" should be "double3" or "float3" as appropriate.  It can also be used to less effect with data types "-dt" as "double3" or "float3" as well but some parts of the code do not support this alternative.  The special attribute types/data "spectrum" and "reflectance" also support the color flag and on them it is set by default.'},
                            'usedAsFilename': {'docstring': 'Is the attribute to be treated as a filename definition? This flag is only supported on attributes with data type "-dt" of "string".'},
                            'usedAsProxy': {'docstring': 'Set if the specified attribute should be treated as a proxy to another attributes.'},
                            'worldSpace': {'docstring': 'Sets whether this attribute should be treated as worldspace. Being worldspace indicates the attribute is dependent on the worldSpace transformation of this node, and will be marked dirty by any attribute changes in the hierarchy that affects the worldSpace transformation. The attribute needs to be an array since during instancing there are multiple worldSpace paths to the node and Maya requires one array element per path for worldSpace attributes. Remarks: 1. Can only be used on array attributes. 2. This property is ignored on non-dag nodes. 3. The attribute should be affected by another attribute or have a connection.    Otherwise, the attribute will not get computed and will not get dirty again.'},
                            'writable': {'docstring': 'Can incoming connections be made to this attribute? \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'addMetadata': {'description': 'Defines the attachment of a metadata structure to one or more selected objects. This creates a placeholder with an empty metadata Stream for later population through the editMetadatacommand. It\'s similar in concept to the addAttrcommand for nodes - a data description is added but no data is actually set.  When assigning a metadata structure you must specify these flags - channelNameis the metadata channel type (e.g. "vertex"), streamNameis the name of the metadata stream to be created, and structureis the name of the structure type defining the contents of the metadata. The indexTypeflag is optional. If it is not present then the index will be presumed to be a standard numerical value.  You can query metadata information at a variety of levels. See the table below for a full list of the queryable arguments. In each case the specification of any of the non-queried arguments filters the list of metadata to be examined during the query. For all queries a single object must be selected for querying.  For example querying the channelNameflag with no other arguments will return the list of all Channel types on the selected object that contain any metadata. Querying the channelNameflag with the indexTypeflag specified will return only those channel types containing metadata streams that use that particular type of index.  Query the channelNameflag to return the list of any channel types that have metadata.Specify the channelNameand streamNameflags and query the structureflag to return the name of the structure assigned to the given stream (if any).Specify a channelNameand query the streamNameto return the list of all streams assigned to that particular channel type.If you query the streamNamewithout a specific channelNamethen it returns a list of pairs of (channelName, streamName) for all metadata streams.Flag Combinations: ChannelName IndexType StreamName Structure   Create   Can Query      0          0          0         0         X        ChannelName, StreamName, Structure      0          0          0         1         X        ChannelName, StreamName, IndexType      0          0          1         0         X        ChannelName, Structure, IndexType      0          0          1         1         X        ChannelName, IndexType      0          1          0         0         X        ChannelName, StreamName, Structure      0          1          0         1         X        ChannelName, StreamName      0          1          1         0         X        ChannelName, Structure      0          1          1         1         X        ChannelName      1          0          0         0         X        StreamName, Structure, IndexType      1          0          0         1         X        StreamName, IndexType      1          0          1         0         X        Structure, IndexType      1          0          1         1        (a)       IndexType      1          1          0         0         X        StreamName, Structure      1          1          0         1         X        StreamName      1          1          1         0         X        Structure      1          1          1         1        (b)       X     (a) Assign an empty metadata stream with default index type     (b) Assign an empty metadata stream with the named index type ',
                 'flags': {'channelName': {'docstring': 'Name of the Channel type to which the structure is to be added (e.g. "vertex"). In query mode, this flag can accept a value.'},
                           'channelType': {'docstring': "Obsolete - use the 'channelName' flag instead. In query mode, this flag can accept a value."},
                           'indexType': {'docstring': 'Name of the index type the new Channel should be using. If not specified this defaults to a simple numeric index. Of the native types only a mesh "vertexFace" channel is different, using a "pair" index type. In query mode, this flag can accept a value.'},
                           'query': {'docstring': ''},
                           'scene': {'docstring': 'Use this flag when you want to add metadata to the scene as a whole rather than to any individual nodes. If you use this flag and have nodes selected the nodes will be ignored and a warning will be displayed.'},
                           'streamName': {'docstring': 'Name of the empty stream being created. In query mode not specifying a value will return a list of streams on the named channel type. In query mode, this flag can accept a value.'},
                           'structure': {'docstring': 'Name of the structure which defines the metadata to be attached to the object. In query mode this will return the name of the structure attached at a given stream. In query mode, this flag can accept a value.Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'addPP': {'description': 'Adds per-point (per-cv, per-vertex, or per-particle) attribute capability for an attribute of an emitter or field.  The -atr flag identifies the attribute.  If no attribute is named, addPP returns a warning and does nothing. The command adds any other necessary attributes wherever they are needed, and makes all necessary connections.  If any of the attributes already exist, the command simply connects to them.  The command also toggles any relevant attributes in the emitter or field to indicate that per-point capability is being used. The command adds a separate per-point attribute to the owning object for each emitter/field.  For example, for emission rate, there is a separate ratePP for each emitter.  These attributes are named according to the convention <emitter/field name><attr name>PP.  For example, if a particle shape owned an emitter "smoke", that shape would get attribute "smokeRatePP." The name of the object must be the emitter or field for which per-point capability is to be added (or the name of its parent transform).  The addPP command adds the per-point capability for that emitter or field but not for any others owned by the same object.  If per-point capability is not supported for a named object, the command will trigger a warning, but will continue executing for any other objects which were valid. If no objects are named, addPP uses any objects in the current selection list for which the specified attribute is applicable.  (For example, it would add per-point rate for all selected emitters.) If addPP detects that the owner object has left-over attributes from a deleted emitter, it will remove those attributes before adding the new ones.  Thus, you can delete the emitter, make a new one, and run addPP again, and addPP will clean up after the deleted emitter.  This is most commonly used if you have a geometry emitter and then decide to change the geometry.  Likewise, if addPP detects that some cvs or vertices have been added to the geometry, then it will expand the corresponding multi-attributes as necessary.  However, if it detects that some cvs/vertices have been removed, it will not remove any entries from the multi.  See the user manual for more discussion. ',
           'flags': {'attribute': {'docstring': 'Name of attribute to which you wish to add PP capability. Currently the only attribute supported is rate (for emitters).                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'adpAnalyticsDialog': {'description': '',
                        'flags': {'activeNotification': {'docstring': ''},
                                  'desktopAnalytics': {'docstring': ''}}},
 'adskAsset': {'description': '',
               'flags': {'assetID': {'docstring': ''},
                         'library': {'docstring': ''},
                         'query': {'docstring': ''},
                         'resolved': {'docstring': ''}}},
 'adskAssetLibrary': {'description': '',
                      'flags': {'unload': {'docstring': ''},
                                'unloadAll': {'docstring': ''}}},
 'adskAssetList': {'description': '', 'flags': {'infoType': {'docstring': ''}}},
 'adskAssetListUI': {'description': '',
                     'flags': {'commandSuffix': {'docstring': ''},
                               'materialLoaded': {'docstring': ''},
                               'query': {'docstring': ''},
                               'uiCommand': {'docstring': ''}}},
 'affectedNet': {'description': "This command gets the list of attributes on a node or node type and creates nodes of type TdnAffect, one for each attribute, that are connected iff the source node's attribute affects the destination node's attribute. In query mode, return type is based on queried flag.",
                 'flags': {'edit': {'docstring': ''},
                           'query': {'docstring': ''},
                           'type': {'docstring': 'Get information from the given node type instead of one node                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'affects': {'description': 'This command returns the list of attributes on a node or node type which affect the named attribute. \t         ',
             'flags': {'by': {'docstring': ''},
                       'type': {'docstring': "static node type from which to get 'affects' information \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list."}}},
 'agFormatIn': {'description': '',
                'flags': {'file': {'docstring': ''},
                          'name': {'docstring': ''}}},
 'agFormatOut': {'description': '', 'flags': {'file': {'docstring': ''}}},
 'aimConstraint': {'description': 'Constrain an object\'s orientation to point at a target object or at the average position of a number of targets. An aimConstraint takes as input one or more "target" DAG transform nodes at which to aim the single "constraint object" DAG transform node.  The aimConstraint orients the constrained object such that the aimVector (in the object\'s local coordinate system) points to the in weighted average of the world space position target objects.  The upVector (again the the object\'s local coordinate system) is aligned in world space with the worldUpVector. ',
                   'flags': {'aimVector': {'docstring': 'Set the aim vector.  This is the vector in local coordinates that points at the target.  If not given at creation time, the default value of (1.0, 0.0, 0.0) is used.'},
                             'edit': {'docstring': ''},
                             'layer': {'docstring': 'Specify the name of the animation layer where the constraint should be added.'},
                             'maintainOffset': {'docstring': "The offset necessary to preserve the constrained object's initial rotation will be calculated and used as the offset."},
                             'name': {'docstring': 'Sets the name of the constraint node to the specified name.  Default name is constrainedObjectName_constraintType'},
                             'offset': {'docstring': 'Sets or queries the value of the offset. Default is 0,0,0.'},
                             'query': {'docstring': ''},
                             'remove': {'docstring': 'removes the listed target(s) from the constraint.'},
                             'skip': {'docstring': 'Specify the axis to be skipped. Valid values are "x", "y", "z" and "none". During creation, "none" is the default.'},
                             'targetList': {'docstring': 'Return the list of target objects.'},
                             'upVector': {'docstring': 'Set local up vector.  This is the vector in local coordinates that aligns with the world up vector.  If not given at creation time, the default value of (0.0, 1.0, 0.0) is used.'},
                             'weight': {'docstring': 'Sets the weight value for the specified target(s). If not given at creation time, the default value of 1.0 is used.'},
                             'weightAliasList': {'docstring': 'Returns the names of the attributes that control the weight of the target objects. Aliases are returned in the same order as the targets are returned by the targetList flag'},
                             'worldUpObject': {'docstring': 'Set the DAG object use for worldUpType "object" and "objectrotation". See worldUpType for greater detail. The default value is no up object, which is interpreted as world space.'},
                             'worldUpType': {'docstring': 'Set the type of the world up vector computation. The worldUpType can have one of 5 values: "scene", "object", "objectrotation", "vector", or "none". If the value is "scene", the upVector is aligned with the up axis of the scene and worldUpVector and worldUpObject are ignored. If the value is "object", the upVector is aimed as closely as possible to the origin of the space of the worldUpObject and the worldUpVector is ignored. If the value is "objectrotation" then the worldUpVector is interpreted as being in the coordinate space of the worldUpObject, transformed into world space and the upVector is aligned as closely as possible to the result. If the value is "vector", the upVector is aligned with worldUpVector as closely as possible and worldUpMatrix is ignored. Finally, if the value is "none" no twist calculation is performed by the constraint, with the resulting "upVector" orientation based previous orientation of the constrained object, and the "great circle" rotation needed to align the aim vector with its constraint. The default worldUpType is "vector".'},
                             'worldUpVector': {'docstring': 'Set world up vector.  This is the vector in world coordinates that up vector should align with. See -wut/worldUpType (below)for greater detail. If not given at creation time, the default value of (0.0, 1.0, 0.0) is used.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'air': {'description': "For each listed object, the command creates a new field. The field has a shape which lives in the DAG and it has an associated dependency node. The field is added to the list of fields owned by the object. Use connectDynamic to cause the field to affect a dynamic object. Note that if more than one object is listed, a separate field is created for each object. If fields are created, this command returns the names of each owning shape and of the field shapes themselves. If a field was queried, the results of the query are returned. If a field was edited, the field name is returned. If no object names are provided but the active selection list is non-empty, the command creates a field for every object in the list. If the list is empty, the command defaults to -pos 0 0 0. The air field simulates the effects of moving air. The affected objects will be accelerated or decelerated so that their velocities match that of the air. With the '-vco true' flag thrown, only accelerations are applied. By parenting an air field to a moving part of an object (ie. a foot of a character) and using '-i 1 -m 0 -s .5 -vco true' flags, one can simulate the movement of air around the foot as it moves, since the TOTAL velocity vector of the field would be only based on the movement of the foot. This can be done while the character walks through leaves or dust on the ground. For each listed object, the command creates a new field. The transform is the associated dependency node. Use connectDynamic to cause the field to affect a dynamic object. If fields are created,  this command returns the field names. If a field was queried, the results of the query are returned. If a field was edited, the field name is returned. If the -pos flag is specified, a field is created at the position specified. If not, if object names are provided or the active selection list is non-empty, the command creates a field for every object in the list and calls addDynamic to add it to the object; otherwise the command defaults to -pos 0 0 0. Setting the -pos flag with objects named on the command line is an error. ",
         'flags': {'attenuation': {'docstring': 'Attentuation rate of field'},
                   'directionX': {'docstring': ''},
                   'directionY': {'docstring': ''},
                   'directionZ': {'docstring': "Direction that the air will try to match the affected particles' velocity to. NOTE: This is not the velocity; this is only the direction. Use the -s flag to set the speed."},
                   'edit': {'docstring': ''},
                   'enableSpread': {'docstring': "This tells the system whether or not to use the spread angle given by '-sp'. If this is 'false' then all connected objectswithin the maximum distance will be affected. Also, if this is set to 'false', all affected objects are forced to match their velocities along the direction vector. If this is set to 'true' and spread is used, then the direction of the force is along the direction from the field to the object."},
                   'fanSetup': {'docstring': "Similar to 'windSetup' except that the effects of a fan or a person blowing air are approximated. The user can pass the same flags on the command line to adjust them from the defaults. These are the values that get set to approximate a 'fan': inheritVelocity 1.0 inheritRotation true componentOnly false enableSpread true spread .5 (45 degrees from center )"},
                   'inheritRotation': {'docstring': "If this is set to 'true', then the direction vector described with -dx, -dy, and -dz will be considered local to the owning object. Therefore, if the owning object's transform undergoes any rotation (by itself or one of its parents), the direction vector of the air field will undergo that same rotation."},
                   'inheritVelocity': {'docstring': "Amount (from 0 to 1) of the field-owner's velocity added to the vector determined by the direction and speed flags. The combination of these two vectors makes up the TOTAL velocity vector for the air field. This allows the air to be determined directly by the motion of the owning object."},
                   'magnitude': {'docstring': 'Strength of field.'},
                   'maxDistance': {'docstring': 'Maximum distance at which field is exerted. -1 indicates that the field has no maximum distance.'},
                   'name': {'docstring': 'name of field'},
                   'perVertex': {'docstring': 'Per-vertex application. If this flag is set true, then each individual point (CV, particle, vertex,etc.) of the chosen object exerts an identical copy of the force field. If this flag is set to false, then the froce is exerted only from the geometric center of the set of points.'},
                   'position': {'docstring': 'Position in space (x,y,z) where you want to place a gravity field. The gravity then emanates from this position in space rather than from an object. Note that you can both use -pos (creating a field at a position) and also provide object names.'},
                   'query': {'docstring': ''},
                   'speed': {'docstring': "How fast the affected objects' speed reaches the speed (based on the -mag, -dx, -dy, -dz flags) of the air field. This value gets clamped internally to be between 0.0 and 1.0.  A value of 0.0 will make the air field have no effect. A value of 1.0 will try to match the air field's speed much quicker, but not necessarily immediately."},
                   'spread': {'docstring': 'This represents the angle from the direction vector within which objects will be affected. The values are in the range of 0 to 1. A value of 0 will result in an effect only exactly in front of the air field along the direction vector. A value of 1 will result in any object in front of the owning object, 90 degrees in all direction from the direction vector.'},
                   'torusSectionRadius': {'docstring': 'Section radius for a torus volume.  Applies only to torus. Similar to the section radius in the torus modelling primitive.'},
                   'velocityComponentOnly': {'docstring': "If this is 'false', the air will accelerate or decelerate the affected objects so that their velocities will eventually match the TOTAL velocity vector of the air field. If this is 'true', only ACCELERTION is applied to the affected objects so that their velocity component along the TOTAL velocity vector matches or is greater in magnitude than the TOTAL velocity vector. This will not slow objects down to match velocities, only speed them up to match components. This is most useful when using the -iv flag with a value >0."},
                   'volumeExclusion': {'docstring': 'Volume exclusion of the field.  If true, points outside the volume (defined by the volume shape attribute) are affected,  If false, points inside the volume are affected.  Has no effect if volumeShape is set to "none."'},
                   'volumeOffset': {'docstring': "Volume offset of the field.  Volume offset translates the field's volume by the specified amount from the actual field location. This is in the field's local space."},
                   'volumeShape': {'docstring': 'Volume shape of the field.  Sets/edits/queries the field\'s volume shape attribute.  If set to any value other than "none", determines a 3-D volume within which the field has effect. Values are: "none," "cube," "sphere," "cylinder," "cone," "torus."'},
                   'volumeSweep': {'docstring': 'Volume sweep of the field.  Applies only to sphere, cone, cylinder, and torus.  Similar effect to the sweep attribute in modelling.'},
                   'wakeSetup': {'docstring': "Like the 'windSetup' and 'fanSetup', 'wakeSetup' sets certain values in the field to approximate the movement of air near a moving object, such as  a character's foot or hand. The values that are set are: inheritVelocity 1.0 inheritRotation false componentOnly true enableSpread false speed 0.0"},
                   'windSetup': {'docstring': "This will set some of the values above in a way that approximates the effects of a basic wind. This allows the user to then change certain values as he/she wishes on the same command line. First the preset values get set, and then any other flags that were passed get taken into account. These are the values that get set to approximate 'wind': inheritVelocity 0.0 inheritRotation true componentOnly false enableSpread false                  Flag can have multiple arguments, passed either as a tuple or a list."}}},
 'aliasAttr': {'description': 'Allows aliases (alternate names) to be defined for any attribute of a specified node. When an attribute is aliased, the alias will be used by the system to display information about the attribute. The user may, however, freely use either the alias or the original name of the attribute. Only a single alias can be specified for an attribute so setting an alias on an already-aliased attribute destroys the old alias. \t         ',
               'flags': {'edit': {'docstring': ''},
                         'query': {'docstring': ''},
                         'remove': {'docstring': 'Specifies that aliases listed should be removed (otherwise new aliases are added). \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'align': {'description': 'Align or spread objects along X Y and Z axis. \t         ',
           'flags': {'alignToLead': {'docstring': 'When set, the min, center or max values are computed from the lead object. Otherwise, the values are averaged for all objects. Default is false'},
                     'coordinateSystem': {'docstring': 'Defines the X, Y, and Z coordinates. Default is the world coordinates'},
                     'xAxis': {'docstring': 'Any of none, min, mid, max, dist, stack. This defines the kind of alignment to perfom, default is none.'},
                     'yAxis': {'docstring': 'Any of none, min, mid, max, dist, stack. This defines the kind of alignment to perfom, default is none.'},
                     'zAxis': {'docstring': 'Any of none, min, mid, max, dist, stack. This defines the kind of alignment to perfom, default is none. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'alignCtx': {'description': 'The alignCtx command creates a tool for aligning and distributing objects. ',
              'flags': {'align': {'docstring': 'Align objects'},
                        'anchorFirstObject': {'docstring': 'Anchor first or last selected object. Default false. Only applicable when aligning objects.'},
                        'distribute': {'docstring': 'Distribute objects'},
                        'edit': {'docstring': ''},
                        'exists': {'docstring': 'Returns true or false depending upon whether the specified object exists. Other flags are ignored.'},
                        'history': {'docstring': 'If this is a tool command, turn the construction history on for the tool in question.'},
                        'image1': {'docstring': 'First of three possible icons representing the tool associated with the context.'},
                        'image2': {'docstring': 'Second of three possible icons representing the tool associated with the context.'},
                        'image3': {'docstring': 'Third of three possible icons representing the tool associated with the context.'},
                        'name': {'docstring': 'If this is a tool command, name the tool appropriately.'},
                        'query': {'docstring': ''},
                        'showAlignTouch': {'docstring': 'Show or hide align touching handles. Default true. Only applicable when aligning objects.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'alignCurve': {'description': 'The curve align command is used to align curves in maya. The main alignment options are positional, tangent and curvature continuity. Curvature continuity implies tangent continuity. Positional continuity means the curves (move) or the ends of the curves (modify) are changed. Tangent continuity means one of the curves is modified to be tangent at the points where they meet. Curvature continuity means one of the curves is modified to be curvature continuous as well as tangent. The default behaviour, when no curves or flags are passed, is to only do positional and tangent continuity on the active list with the end of the first curve and the start of the other curve used for alignment. ',
                'flags': {'attach': {'docstring': 'True if the curve is to be attached'},
                          'caching': {'docstring': 'Toggle caching for all attributes so that no recomputation is needed'},
                          'constructionHistory': {'docstring': 'Turn the construction history on or off.'},
                          'curvatureContinuity': {'docstring': 'Curvature continuity is on if true and off otherwise. Default:false'},
                          'curvatureScale1': {'docstring': 'Curvature scale applied to curvature of first curve for curvature continuity. Default:0.0'},
                          'curvatureScale2': {'docstring': 'Curvature scale applied to curvature of second curve for curvature continuity. Default:0.0'},
                          'edit': {'docstring': ''},
                          'frozen': {'docstring': ''},
                          'joinParameter': {'docstring': 'Parameter on reference curve where modified curve is to be aligned to. Default:123456.0'},
                          'keepMultipleKnots': {'docstring': 'True if multiple knots should be left as-is.'},
                          'name': {'docstring': 'Sets the name of the newly-created node. If it contains namespace path, the new node will be created under the specified namespace; if the namespace does not exist, it will be created.'},
                          'nodeState': {'docstring': "Maya dependency nodes have 6 possible states. The Normal (0), HasNoEffect (1), and Blocking (2)states can be used to alter how the graph is evaluated.   The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)are for internal use only. They temporarily shut off parts of the graph during interaction (e.g., manipulation). The understanding is that once the operation is done, the state will be reset appropriately, e.g. Waiting-Blockingwill reset back to Blocking.   The Normaland Blockingcases apply to all nodes, while HasNoEffectis node specific; many nodes do not support this option. Plug-ins store state in the MPxNode::stateattribute. Anyone can set it or check this attribute.  Additional details about each of these 3 states follow.  StateDescriptionNormalThe normal node state. This is the default.HasNoEffectThe HasNoEffectoption (a.k.a. pass-through), is used in cases where there is an operation on an input producing an output of the same data type. Nearly all deformers support this state, as do a few other nodes. As stated earlier, it is not supported by all nodes.  Itâ€™s typical to implement support for the HasNoEffectstate in the nodeâ€™s compute method and to perform appropriate operations. Plug-ins can also support HasNoEffect.  The usual implementation of this state is to copy the input directly to the matching output without applying the algorithm in the node. For deformers, applying this state leaves the input geometry undeformed on the output.  BlockingThis is implemented in the depend node base class and applies to all nodes. Blockingis applied during the evaluation phase to connections. An evaluation request to a blocked connection will return as failures, causing the destination plug to retain its current value. Dirty propagation is indirectly affected by this state since blocked connections are never cleaned.  When a node is set to Blockingthe behavior is supposed to be the same as if all outgoing connections were broken. As long as nobody requests evaluation of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked node will still respond to getAttrrequests but a getAttron a downstream node will not reevaluate the blocked node.  Setting the root transform of a hierarchy to Blockingwonâ€™t automatically influence child transforms in the hierarchy. To do this, youâ€™d need to explicitly set all child nodes to the Blockingstate.  For example, to set all child transforms to Blocking, you could use the following script.  import maya.cmds as cmds def blockTree(root): nodesToBlock = [] for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys(): nodesToBlock += cmds.listConnections(node, source=True, destination=True ) for node in {source:1 for source in nodesToBlock}.keys(): cmds.setAttr( '%s.nodeState' % node, 2 )  Applying this script would continue to draw objects but things would not be animated.  Default:kdnNormal"},
                          'object': {'docstring': 'Create the result, or just the dependency node.'},
                          'positionalContinuity': {'docstring': 'Positional continuity is on if true and off otherwise. Default:true'},
                          'positionalContinuityType': {'docstring': 'Positional continuity type legal values: 1 - move first curve, 2 - move second curve, 3 - move both curves, 4 - modify first curve, 5 - modify second curve, 6 - modify both curves Default:1'},
                          'query': {'docstring': ''},
                          'replaceOriginal': {'docstring': 'Create "in place" (i.e., replace).                  Flag can have multiple arguments, passed either as a tuple or a list.'},
                          'reverse1': {'docstring': 'If true, reverse the first input curve before doing align. Otherwise, do nothing to the first input curve before aligning. NOTE: setting this attribute to random values will cause unpredictable results and is not supported. Default:false'},
                          'reverse2': {'docstring': 'If true, reverse the second input curve before doing align. Otherwise, do nothing to the second input curve before aligning. NOTE: setting this attribute to random values will cause unpredictable results and is not supported. Default:false'},
                          'tangentContinuity': {'docstring': 'Tangent continuity is on if true and off otherwise. Default:true'},
                          'tangentContinuityType': {'docstring': 'Tangent continuity type legal values: 1 - do tangent continuity on first curve, 2 - do tangent continuity on second curve Default:1'},
                          'tangentScale1': {'docstring': 'Tangent scale applied to tangent of first curve for tangent continuity. Default:1.0'},
                          'tangentScale2': {'docstring': 'Tangent scale applied to tangent of second curve for tangent continuity. Default:1.0                  Common flags'}}},
 'alignSurface': {'description': "The surface align command is used to align surfaces in maya. The main alignment options are positional, tangent and curvature continuity. Curvature continuity implies tangent continuity. NOTE: this tool is based on Studio's align tool. Positional continuity means the surfaces (move) or the ends of the surfaces (modify) are changed. Tangent continuity means one of the surfaces is modified to be tangent at the points where they meet. Curvature continuity means one of the surfaces is modified to be curvature continuous as well as tangent. The default behaviour, when no surfaces or flags are passed, is to only do positional and tangent continuity on the active list with the end of the first surface and the start of the other surface used for alignment. ",
                  'flags': {'attach': {'docstring': 'Should surfaces be attached after alignment?'},
                            'caching': {'docstring': 'Toggle caching for all attributes so that no recomputation is needed'},
                            'constructionHistory': {'docstring': 'Turn the construction history on or off.'},
                            'curvatureContinuity': {'docstring': 'Curvature continuity is on if true and off otherwise. Default:false'},
                            'curvatureScale1': {'docstring': 'Curvature scale applied to curvature of first surface for curvature continuity. Default:0.0'},
                            'curvatureScale2': {'docstring': 'Curvature scale applied to curvature of second surface for curvature continuity. Default:0.0'},
                            'directionU': {'docstring': 'If true use U direction of surface and V direction otherwise. Default:true'},
                            'edit': {'docstring': ''},
                            'frozen': {'docstring': ''},
                            'joinParameter': {'docstring': 'Parameter on reference surface where modified surface is to be aligned to. Default:123456.0'},
                            'keepMultipleKnots': {'docstring': 'Should multiple knots be kept?'},
                            'name': {'docstring': 'Sets the name of the newly-created node. If it contains namespace path, the new node will be created under the specified namespace; if the namespace does not exist, it will be created.'},
                            'nodeState': {'docstring': "Maya dependency nodes have 6 possible states. The Normal (0), HasNoEffect (1), and Blocking (2)states can be used to alter how the graph is evaluated.   The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)are for internal use only. They temporarily shut off parts of the graph during interaction (e.g., manipulation). The understanding is that once the operation is done, the state will be reset appropriately, e.g. Waiting-Blockingwill reset back to Blocking.   The Normaland Blockingcases apply to all nodes, while HasNoEffectis node specific; many nodes do not support this option. Plug-ins store state in the MPxNode::stateattribute. Anyone can set it or check this attribute.  Additional details about each of these 3 states follow.  StateDescriptionNormalThe normal node state. This is the default.HasNoEffectThe HasNoEffectoption (a.k.a. pass-through), is used in cases where there is an operation on an input producing an output of the same data type. Nearly all deformers support this state, as do a few other nodes. As stated earlier, it is not supported by all nodes.  Itâ€™s typical to implement support for the HasNoEffectstate in the nodeâ€™s compute method and to perform appropriate operations. Plug-ins can also support HasNoEffect.  The usual implementation of this state is to copy the input directly to the matching output without applying the algorithm in the node. For deformers, applying this state leaves the input geometry undeformed on the output.  BlockingThis is implemented in the depend node base class and applies to all nodes. Blockingis applied during the evaluation phase to connections. An evaluation request to a blocked connection will return as failures, causing the destination plug to retain its current value. Dirty propagation is indirectly affected by this state since blocked connections are never cleaned.  When a node is set to Blockingthe behavior is supposed to be the same as if all outgoing connections were broken. As long as nobody requests evaluation of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked node will still respond to getAttrrequests but a getAttron a downstream node will not reevaluate the blocked node.  Setting the root transform of a hierarchy to Blockingwonâ€™t automatically influence child transforms in the hierarchy. To do this, youâ€™d need to explicitly set all child nodes to the Blockingstate.  For example, to set all child transforms to Blocking, you could use the following script.  import maya.cmds as cmds def blockTree(root): nodesToBlock = [] for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys(): nodesToBlock += cmds.listConnections(node, source=True, destination=True ) for node in {source:1 for source in nodesToBlock}.keys(): cmds.setAttr( '%s.nodeState' % node, 2 )  Applying this script would continue to draw objects but things would not be animated.  Default:kdnNormal"},
                            'object': {'docstring': 'Create the result, or just the dependency node.'},
                            'positionalContinuity': {'docstring': 'Positional continuity is on if true and off otherwise. Default:true'},
                            'positionalContinuityType': {'docstring': 'Positional continuity type legal values: 1 - move first surface, 2 - move second surface, 3 - move both surfaces, 4 - modify first surface, 5 - modify second surface, 6 - modify both surfaces Default:1'},
                            'query': {'docstring': ''},
                            'replaceOriginal': {'docstring': 'Create "in place" (i.e., replace).                  Flag can have multiple arguments, passed either as a tuple or a list.'},
                            'reverse1': {'docstring': 'If true, reverse the direction (specified by directionU) of the first input surface before doing align. Otherwise, do nothing to the first input surface before aligning. NOTE: setting this attribute to random values will cause unpredictable results and is not supported. Default:false'},
                            'reverse2': {'docstring': 'If true, reverse the direction (specified by directionU) of the second input surface before doing align. Otherwise, do nothing to the second input surface before aligning. NOTE: setting this attribute to random values will cause unpredictable results and is not supported. Default:false'},
                            'swap1': {'docstring': 'If true, swap the UV directions of the first input surface before doing align. Otherwise, do nothing to the first input surface before aligning. NOTE: setting this attribute to random values will cause unpredictable results and is not supported. Default:false'},
                            'swap2': {'docstring': 'If true, swap the UV directions of the second input surface before doing align. Otherwise, do nothing to the second input surface before aligning. NOTE: setting this attribute to random values will cause unpredictable results and is not supported. Default:false'},
                            'tangentContinuity': {'docstring': 'Tangent continuity is on if true and off otherwise. Default:true'},
                            'tangentContinuityType': {'docstring': 'Tangent continuity type legal values: 1 - do tangent continuity on first surface, 2 - do tangent continuity on second surface Default:1'},
                            'tangentScale1': {'docstring': 'Tangent scale applied to tangent of first surface for tangent continuity. Default:1.0'},
                            'tangentScale2': {'docstring': 'Tangent scale applied to tangent of second surface for tangent continuity. Default:1.0'},
                            'twist': {'docstring': 'If true, reverse the second surface in the opposite direction (specified by directionU) before doing align. This will avoid twists in the aligned surfaces. Otherwise, do nothing to the second input surface before aligning. NOTE: setting this attribute to random values will cause unpredictable results and is not supported. Default:false                  Common flags'}}},
 'allNodeTypes': {'description': 'This command returns a list containing the type names of every kind of creatable node registered with the system. Note that some node types are abstract and cannot be created. These will not show up on this list. (e.g. transform and polyShape both inherit from dagObject, but dagObject  cannot be created directly so it will not appear on this list.) \t         ',
                  'flags': {'includeAbstract': {'docstring': 'Show every node type, even the abstract ones which cannot be created via the \'createNode\' command. These will have the suffix "(abstract)" appended to them in the list. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'ambientLight': {'description': "TlightCmd is the base class for other light commands. The ambientLight command is used to edit the parameters of existing ambientLights, or to create new ones. The default behaviour is to create a new ambientlight. This is the commmand that instantiates an ambientLight or edits the parameters of an existing one. TambientLightCmd inherits from TlightCmd which defines common flags like intensity, colour etc. See TlightCmd for a global picture of the light commands. Note that the flag fAmbientLightUsed indicates whether the command uses any ambient specific flags. That is, if a command doesn't use flags defined here, the boolean fAmbientLightUsed is set to false and thus the undo/redo information is not saved at this level. TambientLightCmd behaves like any other command, it has flags, saves undo information etc. the only slightly different behaviour is that it calls up to TlightCmd to complete the functionality of the command. Example\tparseArgs:  TambientLightCmd defines ambientLight specific parameters like -ambientShade however, several other parameters are available in TlightCmd such as -intensity etc.  So when parsing the arguments, a call is made to TlightCmd::parseArgs to parse common parameters (like Intensity). ",
                  'flags': {'ambientShade': {'docstring': 'ambientShade'},
                            'discRadius': {'docstring': 'radius of the disc around the light'},
                            'edit': {'docstring': ''},
                            'exclusive': {'docstring': 'True if the light is exclusively assigned'},
                            'intensity': {'docstring': 'Intensity of the light'},
                            'name': {'docstring': 'Name of the light'},
                            'position': {'docstring': 'Position of the light'},
                            'query': {'docstring': ''},
                            'rgb': {'docstring': 'RGB colour of the light'},
                            'rotation': {'docstring': 'Rotation of the light for orientation, where applicable'},
                            'shadowColor': {'docstring': "Color of the light's shadow"},
                            'shadowDither': {'docstring': 'dither the shadow'},
                            'shadowSamples': {'docstring': 'number of shadow samples.'},
                            'softShadow': {'docstring': 'soft shadow'},
                            'useRayTraceShadows': {'docstring': 'True if ray trace shadows are to be used                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'angleBetween': {'description': 'Returns the axis and angle required to rotate one vector onto another. If the construction history (ch) flag is ON, then the name of the new dependency node is returned. ',
                  'flags': {'caching': {'docstring': 'Toggle caching for all attributes so that no recomputation is needed'},
                            'constructionHistory': {'docstring': 'Turn the construction history on or off.'},
                            'euler': {'docstring': 'return the rotation as 3 Euler angles instead of axis + angle'},
                            'frozen': {'docstring': ''},
                            'name': {'docstring': ''},
                            'nodeState': {'docstring': "Maya dependency nodes have 6 possible states. The Normal (0), HasNoEffect (1), and Blocking (2)states can be used to alter how the graph is evaluated.   The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)are for internal use only. They temporarily shut off parts of the graph during interaction (e.g., manipulation). The understanding is that once the operation is done, the state will be reset appropriately, e.g. Waiting-Blockingwill reset back to Blocking.   The Normaland Blockingcases apply to all nodes, while HasNoEffectis node specific; many nodes do not support this option. Plug-ins store state in the MPxNode::stateattribute. Anyone can set it or check this attribute.  Additional details about each of these 3 states follow.  StateDescriptionNormalThe normal node state. This is the default.HasNoEffectThe HasNoEffectoption (a.k.a. pass-through), is used in cases where there is an operation on an input producing an output of the same data type. Nearly all deformers support this state, as do a few other nodes. As stated earlier, it is not supported by all nodes.  Itâ€™s typical to implement support for the HasNoEffectstate in the nodeâ€™s compute method and to perform appropriate operations. Plug-ins can also support HasNoEffect.  The usual implementation of this state is to copy the input directly to the matching output without applying the algorithm in the node. For deformers, applying this state leaves the input geometry undeformed on the output.  BlockingThis is implemented in the depend node base class and applies to all nodes. Blockingis applied during the evaluation phase to connections. An evaluation request to a blocked connection will return as failures, causing the destination plug to retain its current value. Dirty propagation is indirectly affected by this state since blocked connections are never cleaned.  When a node is set to Blockingthe behavior is supposed to be the same as if all outgoing connections were broken. As long as nobody requests evaluation of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked node will still respond to getAttrrequests but a getAttron a downstream node will not reevaluate the blocked node.  Setting the root transform of a hierarchy to Blockingwonâ€™t automatically influence child transforms in the hierarchy. To do this, youâ€™d need to explicitly set all child nodes to the Blockingstate.  For example, to set all child transforms to Blocking, you could use the following script.  import maya.cmds as cmds def blockTree(root): nodesToBlock = [] for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys(): nodesToBlock += cmds.listConnections(node, source=True, destination=True ) for node in {source:1 for source in nodesToBlock}.keys(): cmds.setAttr( '%s.nodeState' % node, 2 )  Applying this script would continue to draw objects but things would not be animated.  Default:kdnNormal"},
                            'vector1': {'docstring': 'vector from which to compute the rotation'},
                            'vector1X': {'docstring': 'X coordinate of the vector from which to compute the rotation'},
                            'vector1Y': {'docstring': 'Y coordinate of the vector from which to compute the rotation'},
                            'vector1Z': {'docstring': 'Z coordinate of the vector from which to compute the rotation'},
                            'vector2': {'docstring': 'vector to which to compute the rotation'},
                            'vector2X': {'docstring': 'X coordinate of the vector to which to compute the rotation'},
                            'vector2Y': {'docstring': 'Y coordinate of the vector to which to compute the rotation'},
                            'vector2Z': {'docstring': 'Z coordinate of the vector to which to compute the rotation                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'animCurveEditor': {'description': 'Edit a characteristic of a graph editor \t         ',
                     'flags': {'areCurvesSelected': {'docstring': 'Returns a boolean to know if at least one curve is selected in the graph editor.'},
                               'autoFit': {'docstring': 'on | off | tgl Auto fit-to-view.'},
                               'autoFitTime': {'docstring': 'on | off | tgl Auto fit-to-view along the time axis, as well.'},
                               'classicMode': {'docstring': 'When on, the graph editor is displayed in "Classic Mode", otherwise "Suites Mode" is used.'},
                               'clipTime': {'docstring': 'Valid values: "on" "off"Display the clips with their offset and scale applied to the anim curves in the clip.'},
                               'constrainDrag': {'docstring': 'Constrains all Graph Editor animation curve drag operations to either the X-axis, the Y-axis, or to neither of those axes. Values to supply are: 0 for not constraining any axis, 1 for constraing the X-axis, or 2 for constraining the Y-axis. When used in queries, this flag returns the latter values and these values have the same interpretation as above. Note: when the shift key is pressed before dragging the animation curve, the first mouse movement will instead determine (and override) any prior set constrained axis.'},
                               'control': {'docstring': 'Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus. Caution: It is possible for an editor to exist without a control. The query will return "NONE" if no control is present.'},
                               'curvesShown': {'docstring': 'Returns a string array containing the names of the animCurve nodes currently displayed in the graph editor.'},
                               'curvesShownForceUpdate': {'docstring': 'Returns a string array containing the names of the animCurve nodes currently displayed in the graph editor. Unlike the curvesShown flag, this will force an update of the graph editor for the case where the mainListConnection has been modified since the last refresh.'},
                               'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                               'denormalizeCurvesCommand': {'docstring': 'Sets the script that is run to denormalize curves in the graph editor. This is intended for internal use only.'},
                               'displayActiveKeyTangents': {'docstring': 'on | off | tgl Display active key tangents in the editor.'},
                               'displayActiveKeys': {'docstring': 'on | off | tgl Display active keys in the editor.'},
                               'displayInfinities': {'docstring': 'on | off | tgl Display infinities in the editor.'},
                               'displayKeys': {'docstring': 'on | off | tgl Display keyframes in the editor.'},
                               'displayNormalized': {'docstring': 'When on, display all curves normalized to the range -1 to +1.'},
                               'displayTangents': {'docstring': 'on | off | tgl Display tangents in the editor.'},
                               'displayValues': {'docstring': 'on | off | tgl Display active keys and tangents values in the editor.'},
                               'docTag': {'docstring': 'Attaches a tag to the editor.'},
                               'edit': {'docstring': ''},
                               'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                               'filter': {'docstring': 'Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the main list of the editor.'},
                               'forceMainConnection': {'docstring': 'Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.'},
                               'highlightAffectedCurves': {'docstring': 'When on, highlights the curve segment affected by the selected key/tangent'},
                               'highlightConnection': {'docstring': 'Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all editors have a highlight list. For those that do, it is a secondary selection list.'},
                               'keyMinScale': {'docstring': 'The minimum key selection size in the graph editor. A value of 0.0 means there is no minimum size. A value of 1.0 means the minimum size is the size of a key with keyScale set to 1.0'},
                               'keyScale': {'docstring': 'Scales the key size in the graph editor'},
                               'keyingTime': {'docstring': 'The current time in the given curve to be keyed in the graph editor.'},
                               'lockMainConnection': {'docstring': 'Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor. Further changes to the original mainConnection are ignored.'},
                               'lockPlayRangeShades': {'docstring': 'Valid values: "on" "off" "tgl"Lock Play Range Shades.'},
                               'lookAt': {'docstring': 'all | selected | currentTime FitView helpers.'},
                               'mainListConnection': {'docstring': 'Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object.'},
                               'menu': {'docstring': "Specify a script to be run when the editor is created.  The function will be passed one string argument which is the new editor's name."},
                               'normalizeCurvesCommand': {'docstring': 'Sets the script that is run to normalize curves in the graph editor. This is intended for internal use only.'},
                               'outliner': {'docstring': 'The name of the outliner that is associated with the graph editor.'},
                               'panel': {'docstring': 'Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is deleted.'},
                               'parent': {'docstring': 'Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.'},
                               'preSelectionHighlight': {'docstring': 'When on, the curve/key/tangent under the mouse pointer is highlighted to ease selection.'},
                               'query': {'docstring': ''},
                               'renormalizeCurves': {'docstring': 'This flag causes the curve normalization factors to be recalculated.'},
                               'resultSamples': {'docstring': 'Specify the sampling for result curves Note: the smaller this number is, the longer it will take to update the display.'},
                               'resultScreenSamples': {'docstring': 'Specify the screen base result sampling for result curves. If 0, then results are sampled in time.'},
                               'resultUpdate': {'docstring': 'Valid values: "interactive" "delayed"Controls how changes to animCurves are reflected in the result curves (if results are being shown).  If resultUpdate is "interactive", then as interactive changes are being made to the animCurve, the result curves will be updated.  If modelUpdate is delayed (which is the default setting), then result curves are updated once the final change to an animCurve has been made.'},
                               'selectionConnection': {'docstring': 'Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes changes, the editor updates to show the changes.'},
                               'showActiveCurveNames': {'docstring': "Display the active curve(s)'s name."},
                               'showBufferCurves': {'docstring': 'Valid values: "on" "off" "tgl"Display buffer curves.'},
                               'showCurveNames': {'docstring': "Display the curves's name."},
                               'showPlayRangeShades': {'docstring': 'Valid values: "on" "off" "tgl"Display Play Range Shades.'},
                               'showResults': {'docstring': 'Valid values: "on" "off" "tgl"Display result curves from expression or other non-keyed action.'},
                               'showUpstreamCurves': {'docstring': 'If true, the dependency graph is searched upstream for all curves that drive the selected plugs (showing multiple curves for example in a typical driven key setup, where first the driven key curve is encountered, followed by the actual animation curve that drives the source object). If false, only the first curves encountered will be shown. Note that, even if false, multiple curves can be shown if e.g. a blendWeighted node is being used to combine multiple curves.'},
                               'simpleKeyView': {'docstring': 'on | off Display simpler and smaller key.'},
                               'smoothness': {'docstring': 'Valid values: "coarse" "rough" "medium" "fine"Specify the display smoothness of animation curves.'},
                               'snapTime': {'docstring': 'none | integer | keyframe Keyframe move snap in time.'},
                               'snapValue': {'docstring': 'none | integer | keyframe Keyframe move snap in values.'},
                               'stackedCurves': {'docstring': 'Switches the display mode between normal (all curves sharing one set of axes) to stacked (each curve on its own value axis, stacked vertically).'},
                               'stackedCurvesMax': {'docstring': 'Sets the maximum value on the per-curve value axis when in stacked mode.'},
                               'stackedCurvesMin': {'docstring': 'Sets the minimum value on the per-curve value axis when in stacked mode.'},
                               'stackedCurvesSpace': {'docstring': 'Sets the spacing between curves when in stacked mode.'},
                               'stateString': {'docstring': 'Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned command string uses the string variable $editorName in place of a specific name.'},
                               'timelinePositionTop': {'docstring': 'on | off | tgl Display timeline either at the top or bottom.'},
                               'unParent': {'docstring': 'Specifies that the editor should be removed from its layout. This cannot be used in query mode.'},
                               'unlockMainConnection': {'docstring': 'Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic updates.'},
                               'updateMainConnection': {'docstring': 'Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.'},
                               'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                               'valueLinesToggle': {'docstring': 'on | off | tgl Display the value lines for high/low/zero of selected curves in the editor                  Flag can have multiple arguments, passed either as a tuple or a list.'},
                               'viewLeft': {'docstring': ''},
                               'viewRight': {'docstring': ''}}},
 'animDisplay': {'description': 'This command changes certain display options used by animation windows. In query mode, return type is based on queried flag.',
                 'flags': {'edit': {'docstring': ''},
                           'modelUpdate': {'docstring': 'Controls how changes to animCurves are propagated through the dependency graph. Valid modes are "none", "interactive" or "delayed". If modelUpdate is "none" then changing an animCurve will not cause the model to be updated (change currentTime in order to update the model).  If modelUpdate is "interactive" (which is the default setting), then as interactive changes are being made to the animCurve, the model will be updated.  If modelUpdate is delayed, then the model is updated once the final change to an animCurve has been made.  With modelUpdate set to either "interactive" or "delayed", changes to animCurves made via commands will also cause the model to be updated.'},
                           'query': {'docstring': ''},
                           'refAnimCurvesEditable': {'docstring': 'Specify if animation curves from referenced files are editable.'},
                           'timeCode': {'docstring': 'Controls how time value are display. Valid values are "frame", "timecode", "fulltimecode". If the value is "frame" maya will display time in frame everywhere. If the value is "timecode" maya will display time in timecode in time slider, graph editor and dope sheet. If the value is "fulltimecode" maya will display time in timecode everywhere.'},
                           'timeCodeOffset': {'docstring': 'This flag has now been deprecated.  It still exists to not break legacy scripts, but it will now do nothing.  See the new timeCode command to set and query timeCodes.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'animLayer': {'description': 'This command creates and edits animation layers. \t         ',
               'flags': {'addRelatedKG': {'docstring': 'Used adding attributes to a layer. Determines if associated keying groups should be added or not to the layer.'},
                         'addSelectedObjects': {'docstring': 'Adds selected object(s) to the layer.'},
                         'affectedLayers': {'docstring': 'Return the layers that the currently selected object(s) are members of'},
                         'animCurves': {'docstring': 'In query mode returns the anim curves associated with this layer'},
                         'attribute': {'docstring': 'Adds a specific attribute on a object to the layer.'},
                         'baseAnimCurves': {'docstring': 'In query mode returns the base layer anim curves associated with this layer, if any.'},
                         'bestAnimLayer': {'docstring': 'In query mode returns the best anim layers for keying for the selected objects. If used in conjunction with -at, will return the best anim layers for keying for the specific plugs (attributes) specified.'},
                         'bestLayer': {'docstring': 'Return the layer that will be keyed for specified attribute.'},
                         'blendNodes': {'docstring': 'In query mode returns the blend nodes associated with this layer'},
                         'children': {'docstring': 'Get the list of children layers. Return value is a string array.'},
                         'collapse': {'docstring': 'Determine if a layer is collapse in the layer editor.'},
                         'copy': {'docstring': 'Copy from layer.'},
                         'copyAnimation': {'docstring': 'Copy animation from specified layer to destination layer, only animation that are on attribute layered by both layer that are concerned.'},
                         'copyNoAnimation': {'docstring': 'Copy from layer without the animation curves.'},
                         'edit': {'docstring': ''},
                         'excludeBoolean': {'docstring': 'When adding selected object(s) to the layer, excludes any boolean attributes.'},
                         'excludeDynamic': {'docstring': 'When adding selected object(s) to the layer, excludes any dynamic attributes.'},
                         'excludeEnum': {'docstring': 'When adding selected object(s) to the layer, excludes any enum attributes.'},
                         'excludeRotate': {'docstring': 'When adding selected object(s) to the layer, exclude the rotate attribute.'},
                         'excludeScale': {'docstring': 'When adding selected object(s) to the layer, exclude the scale attribute.'},
                         'excludeTranslate': {'docstring': 'When adding selected object(s) to the layer, excludes the translate attribute.'},
                         'excludeVisibility': {'docstring': 'When adding selected object(s) to the layer, exclude the visibility attribute.'},
                         'exists': {'docstring': 'Determine if an layer exists.'},
                         'extractAnimation': {'docstring': 'Transfer animation from specified layer to destination layer, only animation that are on attribute layered by both layer that are concerned.'},
                         'findCurveForPlug': {'docstring': 'Finds the parameter curve containing the animation data for the specified plug on the given layer.'},
                         'forceUIRebuild': {'docstring': 'Rebuilds the animation layers user interface.'},
                         'forceUIRefresh': {'docstring': 'Refreshes the animation layers user interface.'},
                         'layeredPlug': {'docstring': 'Returns the plug on the blend node corresponding to the specified layer'},
                         'lock': {'docstring': 'Set the lock state of the specified layer. A locked layer cannot receive key. Default is false.'},
                         'maxLayers': {'docstring': 'Returns the maximum number of anim layers supported by this product.'},
                         'moveLayerAfter': {'docstring': 'Move layer after the specified layer'},
                         'moveLayerBefore': {'docstring': 'Move layer before the specified layer'},
                         'mute': {'docstring': 'Set the mute state of the specified layer. Default is false.'},
                         'override': {'docstring': 'Set the overide state of the specified layer. Default is false.'},
                         'parent': {'docstring': 'Set the parent of the specified layer. Default is the animation layer root.'},
                         'passthrough': {'docstring': 'Set the passthrough state of the specified layer. Default is true.'},
                         'preferred': {'docstring': 'Determine if a layer is a preferred layer, the best layer algorithm will try to set keyframe in preferred layer first.'},
                         'query': {'docstring': ''},
                         'removeAllAttributes': {'docstring': 'Remove all objects from layer.'},
                         'removeAttribute': {'docstring': 'Remove object from layer.'},
                         'root': {'docstring': 'Return the base layer if it exist'},
                         'selected': {'docstring': 'Determine if a layer is selected, a selected layer will be show in the timecontrol, graph editor.'},
                         'solo': {'docstring': 'Set the solo state of the specified layer. Default is false.'},
                         'weight': {'docstring': 'Set the weight of the specified layer between 0.0 and 1.0. Default is 1.'},
                         'writeBlendnodeDestinations': {'docstring': 'In edit mode writes the destination plugs of the blend nodes that belong to the layer into the blend node. This is used for layer import/export purposes and is not for general use. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'animView': {'description': 'This command allows you to specify the current view range within an animation editor. In query mode, return type is based on queried flag.',
              'flags': {'edit': {'docstring': ''},
                        'endTime': {'docstring': 'End time to display within the editor'},
                        'maxValue': {'docstring': 'Upper value to display within the editor'},
                        'minValue': {'docstring': 'Lower value to display within the editor'},
                        'nextView': {'docstring': 'Switches to the next view.'},
                        'previousView': {'docstring': 'Switches to the previous view.'},
                        'query': {'docstring': ''},
                        'startTime': {'docstring': 'Start time to display within the editor                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'annotate': {'description': 'This command is used to create an annotation to be attached to the specified objects at the specified point. ',
              'flags': {'point': {'docstring': 'Specifies the point about which the annotation text is to be centered.'},
                        'text': {'docstring': 'Specifies the annotation text.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'applyAttrPattern': {'description': "Take the attribute structure described by a pre-defined pattern and apply it either to a node (as dynamic attributes) or a node type (as extension attributes). The same pattern can be applied more than once to different nodes or node types as the operation duplicates the attribute structure described by the pattern.  See the 'createAttrPatterns' command for a description of how to create a pattern. \t         ",
                      'flags': {'nodeType': {'docstring': 'Name of the node type to which the attribute pattern is to be applied. This flag will cause a new extension attribute tree to be created, making the new attributes available on all nodes of the given type. If it is not specified then either a node name must be specified or a node must be selected for application of dynamic attributes.'},
                                'patternName': {'docstring': 'The name of the pattern to apply. The pattern with this name must have been previously created using the createAttrPatterns command. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'applyMetadata': {'description': 'Define the values of a particular set of metadata on selected objects. This command is used in preservation of metadata through Maya file formats (.ma/.mb). If any metadata already exists it will be kept and merged with the new metadata, overwriting duplicate entries. (i.e. if this command specifies data at index N and you already have a value at index N then the one this command specifies will be the new value and the old one will cease to exist.)  Unlike the editMetadatacommand it is not necessary to first use the addMetadatacommand or API equivalent to attach a metadata stream to the object, this command will do both assignment of structure and of metadata values. You do have to use the dataStructurecommand or API equivalent to create the structure being assigned first though.  The formatted input will be in a form expected by the data associations serializer (see adsk::Data::AssociationsSerializer for more information). The specific serialization type will be the default \'raw\' if the formatflag is not used.  For example the "raw" format input string "channel face\\n[STREAMDATA]\\nendChannels\\nendAssociations" with no flags is equivalent to the input "[STREAMDATA]\\nendChannels" with the channelflag set to \'face\' \t         ',
                   'flags': {'format': {'docstring': 'Name of the data association format type to use in the value flag parsing. Default value is "raw".'},
                             'scene': {'docstring': 'Use this flag when you want to apply metadata to the scene as a whole rather than to any individual nodes. If you use this flag and have nodes selected the nodes will be ignored and a warning will be displayed. Scene metadata is incompatible with referenced scenes. Node associated metadata from referenced files will still be readable from master scenes but scene specific metadata of referenced files will not be accessible from a any master scene. This will ensure that referenced files metadata will not end up corrupting the master file scene-metadata.'},
                             'value': {'docstring': 'String containing all of the metadata to be assigned to the selected object. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'applyTake': {'description': 'This command takes data in a device (refered to as a take) and converts it into a form that may be played back and reviewed. The take can either be imported through the readTake action, or recorded by the recordDevice action. The take is either converted into animation curves or if the -preview flag is used, into blendDevice nodes. The command looks for animation curves attached to the target attributes of a device attachment. If animation curves exist, the take is pasted over the existing curves. If the curves do not exist, new animation curves are created. If devices are not specified, all of the devices with take data and that are enabled for applyTake, will have their data applied. See also: recordDevice, enableDevice, readTake, writeTake ',
               'flags': {'channel': {'docstring': 'This flag overrides the set channel enable value. If a channel is specified, it will be enabled. C: The default is all applyTake enabled channels for the device(s).'},
                         'device': {'docstring': 'Specifies which device contains the take. C: The default is all applyTake enabled devices.'},
                         'filter': {'docstring': 'This flag specifies the filters to use during the applyTake. If this flag is used multiple times, the ordering of the filters is from left to right. C: The default is no filters.'},
                         'preview': {'docstring': 'Applies the take to blendDevice nodes attached to the target attributes connected to the device attachments. Animation curves attached to the attributes will not be altered, but for the time that preview data is defined, the preview data will be the data used during playback. C: The default is to not preview.'},
                         'recurseChannel': {'docstring': 'When this flag is used, the children of the channel(s) specified by -c/channel are also applied. C: The default is all of the enabled channels.'},
                         'reset': {'docstring': 'Resets the blendDevice nodes affected by -preview. The preview data is removed and if animation curves exist, they are used during playback.'},
                         'specifyChannel': {'docstring': 'This flag is used with -c/channel flag. When used, applyTake will only work on the channels listed with the -c/channel flag. C: The default is all of the enabled channels.'},
                         'startTime': {'docstring': 'The default start time for a take is determined at record time. The startTime option sets the starting time of the take in the current animation units. C: The default is the first time stamp of the take. If a time stamp does not exist for the take, 0 is used.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'arcLenDimContext': {'description': 'Command used to register the arcLenDimCtx tool. \t         ',
                      'flags': {'edit': {'docstring': ''},
                                'exists': {'docstring': 'Returns true or false depending upon whether the specified object exists. Other flags are ignored.'},
                                'history': {'docstring': 'If this is a tool command, turn the construction history on for the tool in question.'},
                                'image1': {'docstring': 'First of three possible icons representing the tool associated with the context.'},
                                'image2': {'docstring': 'Second of three possible icons representing the tool associated with the context.'},
                                'image3': {'docstring': 'Third of three possible icons representing the tool associated with the context.'},
                                'name': {'docstring': 'If this is a tool command, name the tool appropriately.                  Flag can have multiple arguments, passed either as a tuple or a list.'},
                                'query': {'docstring': ''}}},
 'arcLengthDimension': {'description': 'This command is used to create an arcLength dimension to display the arcLength of a curve/surface at a specified point on the curve/surface. ',
                        'flags': {}},
 'arclen': {'description': 'This command returns the arclength of a curve if the history flag is not set (the default).  If the history flag is set, a node is created that can produce the arclength, and is connected and its name returned.  Having the construction history option on makes this command useful for expressions. ',
            'flags': {'caching': {'docstring': 'Toggle caching for all attributes so that no recomputation is needed'},
                      'constructionHistory': {'docstring': 'Turn the construction history on or off.'},
                      'edit': {'docstring': ''},
                      'frozen': {'docstring': ''},
                      'name': {'docstring': ''},
                      'nodeState': {'docstring': "Maya dependency nodes have 6 possible states. The Normal (0), HasNoEffect (1), and Blocking (2)states can be used to alter how the graph is evaluated.   The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)are for internal use only. They temporarily shut off parts of the graph during interaction (e.g., manipulation). The understanding is that once the operation is done, the state will be reset appropriately, e.g. Waiting-Blockingwill reset back to Blocking.   The Normaland Blockingcases apply to all nodes, while HasNoEffectis node specific; many nodes do not support this option. Plug-ins store state in the MPxNode::stateattribute. Anyone can set it or check this attribute.  Additional details about each of these 3 states follow.  StateDescriptionNormalThe normal node state. This is the default.HasNoEffectThe HasNoEffectoption (a.k.a. pass-through), is used in cases where there is an operation on an input producing an output of the same data type. Nearly all deformers support this state, as do a few other nodes. As stated earlier, it is not supported by all nodes.  Itâ€™s typical to implement support for the HasNoEffectstate in the nodeâ€™s compute method and to perform appropriate operations. Plug-ins can also support HasNoEffect.  The usual implementation of this state is to copy the input directly to the matching output without applying the algorithm in the node. For deformers, applying this state leaves the input geometry undeformed on the output.  BlockingThis is implemented in the depend node base class and applies to all nodes. Blockingis applied during the evaluation phase to connections. An evaluation request to a blocked connection will return as failures, causing the destination plug to retain its current value. Dirty propagation is indirectly affected by this state since blocked connections are never cleaned.  When a node is set to Blockingthe behavior is supposed to be the same as if all outgoing connections were broken. As long as nobody requests evaluation of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked node will still respond to getAttrrequests but a getAttron a downstream node will not reevaluate the blocked node.  Setting the root transform of a hierarchy to Blockingwonâ€™t automatically influence child transforms in the hierarchy. To do this, youâ€™d need to explicitly set all child nodes to the Blockingstate.  For example, to set all child transforms to Blocking, you could use the following script.  import maya.cmds as cmds def blockTree(root): nodesToBlock = [] for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys(): nodesToBlock += cmds.listConnections(node, source=True, destination=True ) for node in {source:1 for source in nodesToBlock}.keys(): cmds.setAttr( '%s.nodeState' % node, 2 )  Applying this script would continue to draw objects but things would not be animated.  Default:kdnNormal                  Flag can have multiple arguments, passed either as a tuple or a list."},
                      'query': {'docstring': ''}}},
 'arrayMapper': {'description': 'Create an arrayMapper node and connect it to a target object. If the -type flag is used, then this command also creates an external node used for computing the output values. If the input attribute does not already exist, it will be created. The output attribute must exists. If    a flag is omitted, the selection list will be used to supply the needed objects. If none are found, that action is omitted. ',
                 'flags': {'destAttr': {'docstring': 'Specifies the attribute which will be the downstream connection for the output data from the mapper node. The attribute type will be used to determine which output attribute to use: float array gets outValuePP, vector array gets outColorPP. If the flag is omitted, no output connection is made.'},
                           'inputU': {'docstring': "Specifies the upstream attribute to connect to the mapper's uCoordPP attribute. If the flag is omitted, no input connection is made."},
                           'inputV': {'docstring': "Specifies the upstream attribute to connect to the mapper's vCoordPP attribute. If the flag is omitted, no input connection is made."},
                           'mapTo': {'docstring': 'Specifies an existing node to be used to compute the output values. This node must be of the appropriate type. Currently, only ramp nodes may be used.'},
                           'target': {'docstring': 'Specifies the target object to be connected to.'},
                           'type': {'docstring': 'Specifies the node type to create which will be used to compute the output values. Currently, only ramp is valid. If the flag is omitted, no connection is made and the external node is not created.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'art3dPaintCtx': {'description': 'This is a tool context command for 3d Paint tool. \t         In query mode, return type is based on queried flag.',
                   'flags': {'accopacity': {'docstring': 'Sets opacity accumulation on/off. C: Default is false (Except for sculpt tool for which it is true by default). Q: When queried, it returns a boolean.'},
                             'afterStrokeCmd': {'docstring': 'The passed string is executed as a MEL command immediately after the end of a stroke. C: Default is no command. Q: When queried, it returns the current command'},
                             'alphablendmode': {'docstring': 'Specifies the blend mode used while painting RGB channel. Currently, we support the following blend modes: "Default" "Lighten" "Darken" "Difference" "Exclusion" "Hard Light" "Soft Light" "Multiply" "Screen" "Overlay" "Constant" Default is "Default".'},
                             'alwaysKeepFile': {'docstring': ''},
                             'assigntxt': {'docstring': 'Sends a request to the tool to allocate and assign file textures to the specified attibute on the selected shaders.'},
                             'attrnames': {'docstring': 'Name of attributes'},
                             'beforeStrokeCmd': {'docstring': 'The passed string is executed as a MEL command immediately before the start of a stroke. C: Default is no command. Q: When queried, it returns the current command'},
                             'brushalignment': {'docstring': 'Specifies the path brush alignemnt. If true, the brush will align to stroke path, otherwise it will align to up vector. C: Default is true. Q: When queried, it returns a boolean.'},
                             'brushdepth': {'docstring': 'Depth of the brush'},
                             'brushfeedback': {'docstring': 'Specifies if the brush additional feedback should be drawn. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                             'brushtype': {'docstring': 'Name of the brush type'},
                             'clear': {'docstring': 'Floods all cvs/vertices to the current value.'},
                             'commonattr': {'docstring': 'Returns a string with the names of all common to all the shaders paintable attributes and supported by the Paint Texture Tool.'},
                             'dragSlider': {'docstring': 'Sets the current brush drag state for resizing or offsetting the brush (like the \'b\' and \'m\' default hotkeys). The string argument is one of: "radius", "lowradius", "opacity", "value", "depth", "displacement", "uvvector" or "none". C: Default is "none".'},
                             'dynclonemode': {'docstring': 'Enable or disable dynamic clone mode.'},
                             'edit': {'docstring': ''},
                             'exists': {'docstring': 'Returns true or false depending upon whether the specified object exists. Other flags are ignored.'},
                             'expandfilename': {'docstring': 'If true, it will expand the name of the export file and concatenate it with the surface name. Otherwise it will take the name as it is. C: Default is true.'},
                             'exportaspectratio': {'docstring': ''},
                             'exportfilemode': {'docstring': ''},
                             'exportfilesave': {'docstring': ''},
                             'exportfilesizex': {'docstring': ''},
                             'exportfilesizey': {'docstring': ''},
                             'exportfiletype': {'docstring': ''},
                             'extendFillColor': {'docstring': 'States if the painted textures will be automatically postprocessed on each stroke to fill in the background color. Default is true.'},
                             'fileformat': {'docstring': 'Name of the file format'},
                             'filetxtaspectratio': {'docstring': 'Specifies the aspect ration of the texture width and height. Default is 1.'},
                             'filetxtsizex': {'docstring': 'Specifies the width of the texture. Default is 256.'},
                             'filetxtsizey': {'docstring': 'Specifies the height of the texture. Default is 256.'},
                             'floodOpacity': {'docstring': 'Value of the flood opacity'},
                             'floodall': {'docstring': 'Turn on to flood everything'},
                             'floodselect': {'docstring': 'Should the selected area be flooded?'},
                             'history': {'docstring': 'If this is a tool command, turn the construction history on for the tool in question.'},
                             'image1': {'docstring': 'First of three possible icons representing the tool associated with the context.'},
                             'image2': {'docstring': 'Second of three possible icons representing the tool associated with the context.'},
                             'image3': {'docstring': 'Third of three possible icons representing the tool associated with the context.'},
                             'importfileload': {'docstring': ''},
                             'importfilemode': {'docstring': ''},
                             'importreassign': {'docstring': ''},
                             'keepaspectratio': {'docstring': 'States if the aspect ratio of the file texture sizes should remain constant. Default is true. boolean.'},
                             'lastRecorderCmd': {'docstring': 'Value of last recorded command.'},
                             'lastStampName': {'docstring': 'Value of the last stamp name.'},
                             'lowerradius': {'docstring': 'Sets the lower size of the brush (only apply on tablet).'},
                             'makeStroke': {'docstring': 'Stroke point values.'},
                             'mappressure': {'docstring': 'Sets the tablet pressure mapping when the table is used. There are three options: "Opacity" - the pressure is mapped to the opacity, "Radius" - the is mapped to modify the radius of the brush, "Both" - the pressure modifies both the opacity and the radius. C: Default is "Opacity". Q: When queried, it returns a string.'},
                             'name': {'docstring': 'If this is a tool command, name the tool appropriately.'},
                             'opacity': {'docstring': 'Sets the brush opacity. C: Default is 1.0. Q: When queried, it returns a float.'},
                             'outline': {'docstring': 'Specifies if the brush should be drawn. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                             'outwhilepaint': {'docstring': 'Specifies if the brush outline should be drawn while painting. C: Default is FALSE. Q: When queried, it returns a boolean.'},
                             'paintmode': {'docstring': 'Specifies the paint mode. There are two possibilities: "screen" and "tangent". C: Default is "screen". Q: When queried, it returns a string.'},
                             'paintoperationtype': {'docstring': 'Specifies the operation type used by the Paint Tool.  Currently, we support the following paint modes: "Paint", "Smear", "Blur", "Erase" and "Clone". Default is "Paint".'},
                             'painttxtattr': {'docstring': 'Specifies the attribute on the shader which the user wants to paint. Currently, we support the following attributes: "Color", "Transparency", "Ambient", "Incandescence", "BumpMap", "Diffuse", "Translucence" "Eccentricity" "SpecularColor", "Reflectivity", "ReflectedColor", and user-defined float, float3, double, and double3 attributes. Default is "Color".'},
                             'painttxtattrname': {'docstring': 'Returns a string with the names of all paintable attributes supported by the Paint Texture Tool.'},
                             'pfxScale': {'docstring': 'Specifies the scale for Paint Effect brushes.'},
                             'pfxWidth': {'docstring': 'Specifies the width for Paint Effect brushes.'},
                             'pickColor': {'docstring': 'Set pick color mode on or off'},
                             'pickValue': {'docstring': 'Toggle for picking'},
                             'playbackCursor': {'docstring': 'Values for the playback cursor.'},
                             'playbackPressure': {'docstring': 'Valus for the playback pressure.'},
                             'preserveclonesource': {'docstring': 'Whether or not to preserve a clone source.'},
                             'pressureMapping1': {'docstring': 'First pressure mapping value'},
                             'pressureMapping2': {'docstring': 'Second pressure mapping value'},
                             'pressureMapping3': {'docstring': 'Third pressure mapping value'},
                             'pressureMax1': {'docstring': 'First pressure maximum value'},
                             'pressureMax2': {'docstring': 'Second pressure maximum value'},
                             'pressureMax3': {'docstring': 'Third pressure maximum value'},
                             'pressureMin1': {'docstring': 'First pressure minimum value'},
                             'pressureMin2': {'docstring': 'Second pressure minimum value'},
                             'pressureMin3': {'docstring': 'Third pressure minimum value'},
                             'profileShapeFile': {'docstring': 'Passes a name of the image file for the stamp shape profile.'},
                             'projective': {'docstring': "Specifies the projective paint mode. C: Default is 'false'. Q: When queried, it returns a boolean."},
                             'query': {'docstring': ''},
                             'radius': {'docstring': 'Sets the size of the brush. C: Default is 1.0 cm. Q: When queried, it returns a float.'},
                             'record': {'docstring': 'Toggle on for recording.'},
                             'reflection': {'docstring': "Specifies the reflection mode. C: Default is 'false'. Q: When queried, it returns a boolean."},
                             'reflectionaboutorigin': {'docstring': 'Toggle on to reflect about the origin'},
                             'reflectionaxis': {'docstring': 'Specifies the reflection axis. There are three possibilities: "x", "y" and "z". C: Default is "x". Q: When queried, it returns a string.'},
                             'reloadtexfile': {'docstring': 'Sends a request to the tool to reload the texture from the disc.'},
                             'resizeratio': {'docstring': 'Specifies the scale by which to resize the current textures.'},
                             'resizetxt': {'docstring': 'Sends a request to the tool to resize all the currently in use textures.'},
                             'rgbcolor': {'docstring': 'Colour value'},
                             'rgbflood': {'docstring': 'Color of the flood'},
                             'saveTextureOnStroke': {'docstring': 'States if the original texture will be automatically saved on each stroke. Default is false.'},
                             'saveonstroke': {'docstring': 'States if the temporary texture will be automatically saved on each stroke. Default is false.'},
                             'savetexture': {'docstring': 'Sends a request to the tool to save the texture to the disc.'},
                             'screenRadius': {'docstring': 'Brush radius on the screen'},
                             'selectclonesource': {'docstring': 'Toggle on to select the clone source'},
                             'shadernames': {'docstring': 'Returns a string with the names of all shaders assigned to selected surfaces.'},
                             'shapeattr': {'docstring': 'States if the attribute to paint is an attribute of the shape and not the shader. Default is false.'},
                             'shapenames': {'docstring': 'Returns a string with the names of all surfaces which are being painted on.'},
                             'showactive': {'docstring': 'Sets on/off the display of the surface isoparms. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                             'soloAsDiffuse': {'docstring': 'States if the currently paintable texture will be rendered as as diffuse texture in the viewport. Default is false.'},
                             'stampDepth': {'docstring': 'Depth of the stamps'},
                             'stampProfile': {'docstring': 'Sets the brush profile of the current stamp. Currently, the following profiles are supported: "gaussian", "poly", "solid" and "square". C: Default is gaussian. Q: When queried, it returns a string.'},
                             'stampSpacing': {'docstring': 'Specifies the stamp spacing. Default is 1.0.'},
                             'strokesmooth': {'docstring': 'Stroke smoothing type name'},
                             'surfaceConformedBrushVertices': {'docstring': 'Enables/disables the the display of the effective brush area as affected vertices.'},
                             'tablet': {'docstring': 'Returns true if the tablet device is present, false if it is absent'},
                             'tangentOutline': {'docstring': 'Enables/disables the display of the brush circle tangent to the surface.'},
                             'textureFilenames': {'docstring': 'Returns a string array with the names of all the painted file textures.'},
                             'updateEraseTex': {'docstring': 'Should the erase texture update?'},
                             'usepressure': {'docstring': 'Sets the tablet pressure on/off. C: Default is false. Q: When queried, it returns a boolean.'},
                             'worldRadius': {'docstring': 'Radius in worldspace                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'artAttr': {'description': '', 'flags': {}},
 'artAttrCtx': {'description': 'This is a context command to set the flags on the artAttrContext, which is the base context for attribute painting operations. All commands require the name of the context as the last argument as this provides the name of the context to create, edit or query. This is a context command to set the flags on the Attribute Paint Tool context. \t         ',
                'flags': {'accopacity': {'docstring': 'Sets opacity accumulation on/off. C: Default is false (Except for sculpt tool for which it is true by default). Q: When queried, it returns a boolean.'},
                          'activeListChangedProc': {'docstring': 'Accepts a string that contains a MEL command that is invoked whenever the active list changes. There may be some situations where the UI, for example, needs to be updated, when objects are selected/deselected in the scene. In query mode, the name of the currently registered MEL command is returned and this will be an empty string if none is defined.'},
                          'afterStrokeCmd': {'docstring': 'The passed string is executed as a MEL command immediately after the end of a stroke. C: Default is no command. Q: When queried, it returns the current command'},
                          'alphaclamp': {'docstring': 'Specifies if the weight value should be alpha clamped to the lower and upper bounds. There are four options here: "none" - no clamping is performed, "lower" - clamps only to the lower bound, "upper" - clamps only to the upper bounds, "both" - clamps to the lower and upper bounds. C: Default is "none".  Q: When queried, it returns a string.'},
                          'alphaclamplower': {'docstring': 'Specifies the lower bound for the alpha values. C: Default is 0.0.  Q: When queried, it returns a float.'},
                          'alphaclampupper': {'docstring': 'Specifies the upper bound for the alpha values. C: Default is 1.0.  Q: When queried, it returns a float.'},
                          'attrSelected': {'docstring': 'Returns a name of the currently selected attribute. Q: When queried, it returns a string.'},
                          'beforeStrokeCmd': {'docstring': 'The passed string is executed as a MEL command immediately before the start of a stroke. C: Default is no command. Q: When queried, it returns the current command'},
                          'brushalignment': {'docstring': 'Specifies the path brush alignemnt. If true, the brush will align to stroke path, otherwise it will align to up vector. C: Default is true. Q: When queried, it returns a boolean.'},
                          'brushfeedback': {'docstring': 'Specifies if the brush additional feedback should be drawn. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                          'clamp': {'docstring': 'Specifies if the weight value should be clamped to the lower and upper bounds. There are four options here: "none" - no clamping is performed, "lower" - clamps only to the lower bound, "upper" - clamps only to the upper bounds, "both" - clamps to the lower and upper bounds. C: Default is "none".  Q: When queried, it returns a string.'},
                          'clamplower': {'docstring': 'Specifies the lower bound for the values. C: Default is 0.0.  Q: When queried, it returns a float.'},
                          'clampupper': {'docstring': 'Specifies the upper bound for the values. C: Default is 1.0.  Q: When queried, it returns a float.'},
                          'clear': {'docstring': 'Floods all cvs/vertices to the current value.'},
                          'colorAlphaValue': {'docstring': 'The Alpha value of the color.'},
                          'colorRGBAValue': {'docstring': 'The RGBA value of the color.'},
                          'colorRGBValue': {'docstring': 'The RGB value of the color.'},
                          'colorRamp': {'docstring': 'Allows a user defined color ramp to be used to map values to colors.'},
                          'colorfeedback': {'docstring': 'Sets on/off the color feedback display. C: Default is FALSE.  Q: When queried, it returns a boolean.'},
                          'colorfeedbackOverride': {'docstring': 'Sets on/off the color feedback override. C: Default is FALSE.  Q: When queried, it returns a boolean.'},
                          'colorrangelower': {'docstring': 'Specifies the value that maps to black when color feedback mode is on. C: Default is 0.0.  Q: When queried, it returns a float.'},
                          'colorrangeupper': {'docstring': 'Specifies the value that maps to the maximum color when color feedback mode is on. C: Default is 1.0.  Q: When queried, it returns a float.'},
                          'dataTypeIndex': {'docstring': 'When the selected paintable attribute is a vectorArray, it specifies which field to paint on.'},
                          'disablelighting': {'docstring': 'If color feedback is on, this flag determines whether lighting is disabled or not for the surfaces that are affected. C: Default is FALSE.  Q: When queried, it returns a boolean.'},
                          'dragSlider': {'docstring': 'Sets the current brush drag state for resizing or offsetting the brush (like the \'b\' and \'m\' default hotkeys). The string argument is one of: "radius", "lowradius", "opacity", "value", "depth", "displacement", "uvvector" or "none". C: Default is "none".'},
                          'duringStrokeCmd': {'docstring': 'The passed string is executed as a MEL command during the stroke, each time the mouse is dragged. C: Default is no command. Q: When queried, it returns the current command'},
                          'dynclonemode': {'docstring': 'Enable or disable dynamic clone mode.'},
                          'edit': {'docstring': ''},
                          'exists': {'docstring': 'Returns true or false depending upon whether the specified object exists. Other flags are ignored.'},
                          'expandfilename': {'docstring': 'If true, it will expand the name of the export file and concatenate it with the surface name. Otherwise it will take the name as it is. C: Default is true.'},
                          'exportaspectratio': {'docstring': 'Value of aspect ratio for export'},
                          'exportfilemode': {'docstring': 'Specifies the export channel.The valid entries here are: "alpha", "luminance", "rgb", "rgba". C: Default is "luminance/rgb". Q: When queried, it returns a string.'},
                          'exportfilesave': {'docstring': 'Exports the attribute map and saves to a specified file.'},
                          'exportfilesizex': {'docstring': 'Specifies the width of the attribute map to export. C: Default width is 256. Q: When queried, it returns an integer.'},
                          'exportfilesizey': {'docstring': 'Specifies the width of the attribute map to export. C: Default width is 256. Q: When queried, it returns an integer.'},
                          'exportfiletype': {'docstring': 'Specifies the image file format. It can be one of the following: "iff", "tiff", "jpeg", "alias", "rgb", "fit" "postScriptEPS", "softimage", "wavefrontRLA", "wavefrontEXP". C: default is tiff. Q: When queried, it returns a string.'},
                          'filterNodes': {'docstring': 'Sets the node filter.'},
                          'history': {'docstring': 'If this is a tool command, turn the construction history on for the tool in question.'},
                          'image1': {'docstring': 'First of three possible icons representing the tool associated with the context.'},
                          'image2': {'docstring': 'Second of three possible icons representing the tool associated with the context.'},
                          'image3': {'docstring': 'Third of three possible icons representing the tool associated with the context.'},
                          'importfileload': {'docstring': 'Load the attribute map a specified file.'},
                          'importfilemode': {'docstring': 'Specifies the channel to import. The valid entries here are: "alpha", "luminance", "red", "green", "blue", and "rgb" C: Default is "alpha". Q: When queried, it returns a string.'},
                          'importreassign': {'docstring': 'Specifies if the multiply atrribute maps are to be reassigned while importing. Only maps previously exported from within Artisan can be reassigned. C: Default is FALSE. Q: When queried, it returns a  boolean.'},
                          'interactiveUpdate': {'docstring': 'Specifies how often to transfer the painted values into the attribute. TRUE: transfer them "continuously" (many times per stroke) FALSE: transfer them only at the end of a stroke (on mouse button release). C: Default is TRUE. Q: When queried, it returns a boolean.'},
                          'lastRecorderCmd': {'docstring': 'Value of last recorded command.'},
                          'lastStampName': {'docstring': 'Value of the last stamp name.'},
                          'lowerradius': {'docstring': 'Sets the lower size of the brush (only apply on tablet).'},
                          'makeStroke': {'docstring': 'Stroke point values.'},
                          'mappressure': {'docstring': 'Sets the tablet pressure mapping when the table is used. There are three options: "Opacity" - the pressure is mapped to the opacity, "Radius" - the is mapped to modify the radius of the brush, "Both" - the pressure modifies both the opacity and the radius. C: Default is "Opacity". Q: When queried, it returns a string.'},
                          'maxvalue': {'docstring': 'Specifies the maximum value for each attribute. C: Default is 1.0.  Q: When queried, it returns a float.'},
                          'minvalue': {'docstring': 'Specifies the minimum value for each attribute. C: Default is 0.0.  Q: When queried, it returns a float.'},
                          'name': {'docstring': 'If this is a tool command, name the tool appropriately.'},
                          'objattrArray': {'docstring': 'An array of all paintable attributes. Each element of the array is a string with the following information: NodeType.NodeName.AttributeName.MenuType. \\*MenuType: type (level) of the item in the Menu (UI). Q: When queried, it returns a string.'},
                          'opacity': {'docstring': 'Sets the brush opacity. C: Default is 1.0. Q: When queried, it returns a float.'},
                          'outline': {'docstring': 'Specifies if the brush should be drawn. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                          'outwhilepaint': {'docstring': 'Specifies if the brush outline should be drawn while painting. C: Default is FALSE. Q: When queried, it returns a boolean.'},
                          'paintNodeArray': {'docstring': 'An array of paintable nodes. Q: When queried, it returns a string.'},
                          'paintattrselected': {'docstring': 'An array of selected paintable attributes. Each element of the array is a string with the following information: NodeType.NodeName.AttributeName.'},
                          'paintmode': {'docstring': 'Specifies the paint mode. There are two possibilities: "screen" and "tangent". C: Default is "screen". Q: When queried, it returns a string.'},
                          'paintoperationtype': {'docstring': 'Specifies the operation type used by the Paint Tool.  Currently, we support the following paint modes: "Paint", "Smear", "Blur", "Erase" and "Clone". Default is "Paint".'},
                          'pickColor': {'docstring': 'Set pick color mode on or off'},
                          'pickValue': {'docstring': 'Toggle for picking'},
                          'playbackCursor': {'docstring': 'Values for the playback cursor.'},
                          'playbackPressure': {'docstring': 'Valus for the playback pressure.'},
                          'preserveclonesource': {'docstring': 'Whether or not to preserve a clone source.'},
                          'profileShapeFile': {'docstring': 'Passes a name of the image file for the stamp shape profile.'},
                          'projective': {'docstring': "Specifies the projective paint mode. C: Default is 'false'. Q: When queried, it returns a boolean."},
                          'query': {'docstring': ''},
                          'radius': {'docstring': 'Sets the size of the brush. C: Default is 1.0 cm. Q: When queried, it returns a float.'},
                          'rampMaxColor': {'docstring': 'Defines a special color to be used when the value is greater than or equal to the maximum value.'},
                          'rampMinColor': {'docstring': 'Defines a special color to be used when the value is less than or equal to the minimum value.'},
                          'record': {'docstring': 'Toggle on for recording.'},
                          'reflection': {'docstring': "Specifies the reflection mode. C: Default is 'false'. Q: When queried, it returns a boolean."},
                          'reflectionaboutorigin': {'docstring': 'Toggle on to reflect about the origin'},
                          'reflectionaxis': {'docstring': 'Specifies the reflection axis. There are three possibilities: "x", "y" and "z". C: Default is "x". Q: When queried, it returns a string.'},
                          'screenRadius': {'docstring': 'Brush radius on the screen'},
                          'selectclonesource': {'docstring': 'Toggle on to select the clone source'},
                          'selectedattroper': {'docstring': 'Sets the edit weight operation. Four edit weights operations are provided : "absolute" - the value of the weight is replaced by the current one, "additive" - the value of the weight is added to the current one, "scale" - the value of the weight is multiplied by the current one, "smooth" - the value of the weight is divided by the current one. C: Default is "absolute".  Q: When queried, it returns a string.'},
                          'showactive': {'docstring': 'Sets on/off the display of the surface isoparms. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                          'stampDepth': {'docstring': 'Depth of the stamps'},
                          'stampProfile': {'docstring': 'Sets the brush profile of the current stamp. Currently, the following profiles are supported: "gaussian", "poly", "solid" and "square". C: Default is gaussian. Q: When queried, it returns a string.'},
                          'stampSpacing': {'docstring': 'Specifies the stamp spacing. Default is 1.0.'},
                          'strokesmooth': {'docstring': 'Stroke smoothing type name'},
                          'surfaceConformedBrushVertices': {'docstring': 'Enables/disables the the display of the effective brush area as affected vertices.'},
                          'tablet': {'docstring': 'Returns true if the tablet device is present, false if it is absent'},
                          'tangentOutline': {'docstring': 'Enables/disables the display of the brush circle tangent to the surface.'},
                          'toolOffProc': {'docstring': 'Accepts a strings describing the name of a MEL procedure that is invoked whenever the tool is turned off. For example, cloth invokes "clothPaintToolOff" when the cloth paint tool is turned on. Define this callback if your tool requires special functionality when your tool is deactivated. It is typical that if you implement a toolOffProc you will want to implement a toolOnProc as well (see the -toolOnProc flag. In query mode, the name of the currently registered MEL command is returned and this will be an empty string if none is defined.'},
                          'toolOnProc': {'docstring': 'Accepts a strings describing the name of a MEL procedure that is invoked whenever the tool is turned on. For example, cloth invokes "clothPaintToolOn" when the cloth paint tool is turned on. Define this callback if your tool requires special functionality when your tool is activated. It is typical that if you implement a toolOnProc you will want to implement a toolOffProc as well (see the -toolOffProc flag. In query mode, the name of the currently registered MEL command is returned and this will be an empty string if none is defined.'},
                          'useColorRamp': {'docstring': 'Specifies whether the user defined color ramp should be used to map values from to colors.  If this is turned off, the default greyscale feedback will be used.'},
                          'useMaxMinColor': {'docstring': 'Specifies whether the out of range colors should be used.  See rampMinColor and rampMaxColor flags for further details.'},
                          'usepressure': {'docstring': 'Sets the tablet pressure on/off. C: Default is false. Q: When queried, it returns a boolean.'},
                          'value': {'docstring': 'Specifies the value for each attribute. C: Default is 0.0.  Q: When queried, it returns a float.'},
                          'whichTool': {'docstring': 'The string defines the name of the tool to be used for the Artisan context. An example is "artClothPaint". In query mode, the tool name for the given context is returned. Note: due to the way MEL works, always specify the -query flag last when specifying a flag that takes arguments.'},
                          'worldRadius': {'docstring': 'Radius in worldspace                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'artAttrPaintVertexCtx': {'description': 'This is a context command to set the flags on the artAttrContext, which is the base context for attribute painting operations. All commands require the name of the context as the last argument as this provides the name of the context to create, edit or query. This is a context command to set the flags on the Paint color on vertex Tool context. In query mode, return type is based on queried flag.',
                           'flags': {'accopacity': {'docstring': 'Sets opacity accumulation on/off. C: Default is false (Except for sculpt tool for which it is true by default). Q: When queried, it returns a boolean.'},
                                     'activeListChangedProc': {'docstring': 'Accepts a string that contains a MEL command that is invoked whenever the active list changes. There may be some situations where the UI, for example, needs to be updated, when objects are selected/deselected in the scene. In query mode, the name of the currently registered MEL command is returned and this will be an empty string if none is defined.'},
                                     'afterStrokeCmd': {'docstring': 'The passed string is executed as a MEL command immediately after the end of a stroke. C: Default is no command. Q: When queried, it returns the current command'},
                                     'alphaclamp': {'docstring': 'Specifies if the weight value should be alpha clamped to the lower and upper bounds. There are four options here: "none" - no clamping is performed, "lower" - clamps only to the lower bound, "upper" - clamps only to the upper bounds, "both" - clamps to the lower and upper bounds. C: Default is "none".  Q: When queried, it returns a string.'},
                                     'alphaclamplower': {'docstring': 'Specifies the lower bound for the alpha values. C: Default is 0.0.  Q: When queried, it returns a float.'},
                                     'alphaclampupper': {'docstring': 'Specifies the upper bound for the alpha values. C: Default is 1.0.  Q: When queried, it returns a float.'},
                                     'attrSelected': {'docstring': 'Returns a name of the currently selected attribute. Q: When queried, it returns a string.'},
                                     'beforeStrokeCmd': {'docstring': 'The passed string is executed as a MEL command immediately before the start of a stroke. C: Default is no command. Q: When queried, it returns the current command'},
                                     'brushalignment': {'docstring': 'Specifies the path brush alignemnt. If true, the brush will align to stroke path, otherwise it will align to up vector. C: Default is true. Q: When queried, it returns a boolean.'},
                                     'brushfeedback': {'docstring': 'Specifies if the brush additional feedback should be drawn. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                                     'clamp': {'docstring': 'Specifies if the weight value should be clamped to the lower and upper bounds. There are four options here: "none" - no clamping is performed, "lower" - clamps only to the lower bound, "upper" - clamps only to the upper bounds, "both" - clamps to the lower and upper bounds. C: Default is "none".  Q: When queried, it returns a string.'},
                                     'clamplower': {'docstring': 'Specifies the lower bound for the values. C: Default is 0.0.  Q: When queried, it returns a float.'},
                                     'clampupper': {'docstring': 'Specifies the upper bound for the values. C: Default is 1.0.  Q: When queried, it returns a float.'},
                                     'clear': {'docstring': 'Floods all cvs/vertices to the current value.'},
                                     'colorAlphaValue': {'docstring': 'The Alpha value of the color.'},
                                     'colorRGBAValue': {'docstring': 'The RGBA value of the color.'},
                                     'colorRGBValue': {'docstring': 'The RGB value of the color.'},
                                     'colorRamp': {'docstring': 'Allows a user defined color ramp to be used to map values to colors.'},
                                     'colorfeedback': {'docstring': 'Sets on/off the color feedback display. C: Default is FALSE.  Q: When queried, it returns a boolean.'},
                                     'colorfeedbackOverride': {'docstring': 'Sets on/off the color feedback override. C: Default is FALSE.  Q: When queried, it returns a boolean.'},
                                     'colorrangelower': {'docstring': 'Specifies the value that maps to black when color feedback mode is on. C: Default is 0.0.  Q: When queried, it returns a float.'},
                                     'colorrangeupper': {'docstring': 'Specifies the value that maps to the maximum color when color feedback mode is on. C: Default is 1.0.  Q: When queried, it returns a float.'},
                                     'dataTypeIndex': {'docstring': 'When the selected paintable attribute is a vectorArray, it specifies which field to paint on.'},
                                     'disablelighting': {'docstring': 'If color feedback is on, this flag determines whether lighting is disabled or not for the surfaces that are affected. C: Default is FALSE.  Q: When queried, it returns a boolean.'},
                                     'dragSlider': {'docstring': 'Sets the current brush drag state for resizing or offsetting the brush (like the \'b\' and \'m\' default hotkeys). The string argument is one of: "radius", "lowradius", "opacity", "value", "depth", "displacement", "uvvector" or "none". C: Default is "none".'},
                                     'duringStrokeCmd': {'docstring': 'The passed string is executed as a MEL command during the stroke, each time the mouse is dragged. C: Default is no command. Q: When queried, it returns the current command'},
                                     'dynclonemode': {'docstring': 'Enable or disable dynamic clone mode.'},
                                     'edit': {'docstring': ''},
                                     'exists': {'docstring': 'Returns true or false depending upon whether the specified object exists. Other flags are ignored.'},
                                     'expandfilename': {'docstring': 'If true, it will expand the name of the export file and concatenate it with the surface name. Otherwise it will take the name as it is. C: Default is true.'},
                                     'exportaspectratio': {'docstring': 'Value of aspect ratio for export'},
                                     'exportfilemode': {'docstring': 'Specifies the export channel.The valid entries here are: "alpha", "luminance", "rgb", "rgba". C: Default is "luminance/rgb". Q: When queried, it returns a string.'},
                                     'exportfilesave': {'docstring': 'Exports the attribute map and saves to a specified file.'},
                                     'exportfilesizex': {'docstring': 'Specifies the width of the attribute map to export. C: Default width is 256. Q: When queried, it returns an integer.'},
                                     'exportfilesizey': {'docstring': 'Specifies the width of the attribute map to export. C: Default width is 256. Q: When queried, it returns an integer.'},
                                     'exportfiletype': {'docstring': 'Specifies the image file format. It can be one of the following: "iff", "tiff", "jpeg", "alias", "rgb", "fit" "postScriptEPS", "softimage", "wavefrontRLA", "wavefrontEXP". C: default is tiff. Q: When queried, it returns a string.'},
                                     'filterNodes': {'docstring': 'Sets the node filter.'},
                                     'history': {'docstring': 'If this is a tool command, turn the construction history on for the tool in question.'},
                                     'image1': {'docstring': 'First of three possible icons representing the tool associated with the context.'},
                                     'image2': {'docstring': 'Second of three possible icons representing the tool associated with the context.'},
                                     'image3': {'docstring': 'Third of three possible icons representing the tool associated with the context.'},
                                     'importfileload': {'docstring': 'Load the attribute map a specified file.'},
                                     'importfilemode': {'docstring': 'Specifies the channel to import. The valid entries here are: "alpha", "luminance", "red", "green", "blue", and "rgb" C: Default is "alpha". Q: When queried, it returns a string.'},
                                     'importreassign': {'docstring': 'Specifies if the multiply atrribute maps are to be reassigned while importing. Only maps previously exported from within Artisan can be reassigned. C: Default is FALSE. Q: When queried, it returns a  boolean.'},
                                     'interactiveUpdate': {'docstring': 'Specifies how often to transfer the painted values into the attribute. TRUE: transfer them "continuously" (many times per stroke) FALSE: transfer them only at the end of a stroke (on mouse button release). C: Default is TRUE. Q: When queried, it returns a boolean.'},
                                     'lastRecorderCmd': {'docstring': 'Value of last recorded command.'},
                                     'lastStampName': {'docstring': 'Value of the last stamp name.'},
                                     'lowerradius': {'docstring': 'Sets the lower size of the brush (only apply on tablet).'},
                                     'makeStroke': {'docstring': 'Stroke point values.'},
                                     'mappressure': {'docstring': 'Sets the tablet pressure mapping when the table is used. There are three options: "Opacity" - the pressure is mapped to the opacity, "Radius" - the is mapped to modify the radius of the brush, "Both" - the pressure modifies both the opacity and the radius. C: Default is "Opacity". Q: When queried, it returns a string.'},
                                     'maxvalue': {'docstring': 'Specifies the maximum value for each attribute. C: Default is 1.0.  Q: When queried, it returns a float.'},
                                     'minvalue': {'docstring': 'Specifies the minimum value for each attribute. C: Default is 0.0.  Q: When queried, it returns a float.'},
                                     'name': {'docstring': 'If this is a tool command, name the tool appropriately.'},
                                     'objattrArray': {'docstring': 'An array of all paintable attributes. Each element of the array is a string with the following information: NodeType.NodeName.AttributeName.MenuType. \\*MenuType: type (level) of the item in the Menu (UI). Q: When queried, it returns a string.'},
                                     'opacity': {'docstring': 'Sets the brush opacity. C: Default is 1.0. Q: When queried, it returns a float.'},
                                     'outline': {'docstring': 'Specifies if the brush should be drawn. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                                     'outwhilepaint': {'docstring': 'Specifies if the brush outline should be drawn while painting. C: Default is FALSE. Q: When queried, it returns a boolean.'},
                                     'paintComponent': {'docstring': 'Specifies whether face or vertex or vertex face is being painted. 1 - Vertex 2 - VertexFace 3 - Face C: Default is Vertex.  Q: When queried, it returns a int.'},
                                     'paintNodeArray': {'docstring': 'An array of paintable nodes. Q: When queried, it returns a string.'},
                                     'paintNumChannels': {'docstring': 'Number of channels to paint - 1 (alpha), 3 (RGB), or 4 (RGBA)'},
                                     'paintRGBA': {'docstring': 'Specifies whether RGB or RGBA channels are being painted. TRUE: RGBA channels. FALSE: RGB channels. Alpha channel remains unaffected. C: Default is FALSE (Painting RGB channels). Q: When queried, it returns a int.'},
                                     'paintVertexFace': {'docstring': 'Specifies whether vertex face is being painted. TRUE: Vertex face being painted. (Allows each face connected to the vertex to be painted) FALSE: Vertex being painted.(affects all connected faces) C: Default is FALSE.  Q: When queried, it returns a int.'},
                                     'paintattrselected': {'docstring': 'An array of selected paintable attributes. Each element of the array is a string with the following information: NodeType.NodeName.AttributeName.'},
                                     'paintmode': {'docstring': 'Specifies the paint mode. There are two possibilities: "screen" and "tangent". C: Default is "screen". Q: When queried, it returns a string.'},
                                     'paintoperationtype': {'docstring': 'Specifies the operation type used by the Paint Tool.  Currently, we support the following paint modes: "Paint", "Smear", "Blur", "Erase" and "Clone". Default is "Paint".'},
                                     'pickColor': {'docstring': 'Set pick color mode on or off'},
                                     'pickValue': {'docstring': 'Toggle for picking'},
                                     'playbackCursor': {'docstring': 'Values for the playback cursor.'},
                                     'playbackPressure': {'docstring': 'Valus for the playback pressure.'},
                                     'preserveclonesource': {'docstring': 'Whether or not to preserve a clone source.'},
                                     'profileShapeFile': {'docstring': 'Passes a name of the image file for the stamp shape profile.'},
                                     'projective': {'docstring': "Specifies the projective paint mode. C: Default is 'false'. Q: When queried, it returns a boolean."},
                                     'query': {'docstring': ''},
                                     'radius': {'docstring': 'Sets the size of the brush. C: Default is 1.0 cm. Q: When queried, it returns a float.'},
                                     'rampMaxColor': {'docstring': 'Defines a special color to be used when the value is greater than or equal to the maximum value.'},
                                     'rampMinColor': {'docstring': 'Defines a special color to be used when the value is less than or equal to the minimum value.'},
                                     'record': {'docstring': 'Toggle on for recording.'},
                                     'reflection': {'docstring': "Specifies the reflection mode. C: Default is 'false'. Q: When queried, it returns a boolean."},
                                     'reflectionaboutorigin': {'docstring': 'Toggle on to reflect about the origin'},
                                     'reflectionaxis': {'docstring': 'Specifies the reflection axis. There are three possibilities: "x", "y" and "z". C: Default is "x". Q: When queried, it returns a string.'},
                                     'screenRadius': {'docstring': 'Brush radius on the screen'},
                                     'selectclonesource': {'docstring': 'Toggle on to select the clone source'},
                                     'selectedattroper': {'docstring': 'Sets the edit weight operation. Four edit weights operations are provided : "absolute" - the value of the weight is replaced by the current one, "additive" - the value of the weight is added to the current one, "scale" - the value of the weight is multiplied by the current one, "smooth" - the value of the weight is divided by the current one. C: Default is "absolute".  Q: When queried, it returns a string.'},
                                     'showactive': {'docstring': 'Sets on/off the display of the surface isoparms. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                                     'stampDepth': {'docstring': 'Depth of the stamps'},
                                     'stampProfile': {'docstring': 'Sets the brush profile of the current stamp. Currently, the following profiles are supported: "gaussian", "poly", "solid" and "square". C: Default is gaussian. Q: When queried, it returns a string.'},
                                     'stampSpacing': {'docstring': 'Specifies the stamp spacing. Default is 1.0.'},
                                     'strokesmooth': {'docstring': 'Stroke smoothing type name'},
                                     'surfaceConformedBrushVertices': {'docstring': 'Enables/disables the the display of the effective brush area as affected vertices.'},
                                     'tablet': {'docstring': 'Returns true if the tablet device is present, false if it is absent'},
                                     'tangentOutline': {'docstring': 'Enables/disables the display of the brush circle tangent to the surface.'},
                                     'toolOffProc': {'docstring': 'Accepts a strings describing the name of a MEL procedure that is invoked whenever the tool is turned off. For example, cloth invokes "clothPaintToolOff" when the cloth paint tool is turned on. Define this callback if your tool requires special functionality when your tool is deactivated. It is typical that if you implement a toolOffProc you will want to implement a toolOnProc as well (see the -toolOnProc flag. In query mode, the name of the currently registered MEL command is returned and this will be an empty string if none is defined.'},
                                     'toolOnProc': {'docstring': 'Accepts a strings describing the name of a MEL procedure that is invoked whenever the tool is turned on. For example, cloth invokes "clothPaintToolOn" when the cloth paint tool is turned on. Define this callback if your tool requires special functionality when your tool is activated. It is typical that if you implement a toolOnProc you will want to implement a toolOffProc as well (see the -toolOffProc flag. In query mode, the name of the currently registered MEL command is returned and this will be an empty string if none is defined.'},
                                     'useColorRamp': {'docstring': 'Specifies whether the user defined color ramp should be used to map values from to colors.  If this is turned off, the default greyscale feedback will be used.'},
                                     'useMaxMinColor': {'docstring': 'Specifies whether the out of range colors should be used.  See rampMinColor and rampMaxColor flags for further details.'},
                                     'usepressure': {'docstring': 'Sets the tablet pressure on/off. C: Default is false. Q: When queried, it returns a boolean.'},
                                     'value': {'docstring': 'Specifies the value for each attribute. C: Default is 0.0.  Q: When queried, it returns a float.'},
                                     'vertexColorRange': {'docstring': 'Specifies whether the vertex color range should be applied to the currently selected object. C: Default is false  Q: When queried, it returns a boolean.'},
                                     'vertexColorRangeLower': {'docstring': 'Specifies the min value of the vertex color range. C: Default is 0.0.  Q: When queried, it returns a float.'},
                                     'vertexColorRangeUpper': {'docstring': 'Specifies the max value of the vertex color range. C: Default is 1.0.  Q: When queried, it returns a float.'},
                                     'whichTool': {'docstring': 'The string defines the name of the tool to be used for the Artisan context. An example is "artClothPaint". In query mode, the tool name for the given context is returned. Note: due to the way MEL works, always specify the -query flag last when specifying a flag that takes arguments.'},
                                     'worldRadius': {'docstring': 'Radius in worldspace                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'artAttrSkinPaint': {'description': '', 'flags': {}},
 'artAttrSkinPaintCmd': {'description': '', 'flags': {}},
 'artAttrSkinPaintCtx': {'description': 'This is a context command to set the flags on the artAttrContext, which is the base context for attribute painting operations. All commands require the name of the context as the last argument as this provides the name of the context to create, edit or query. This is a context command to set the flags on the Paint skin weights tool context. In query mode, return type is based on queried flag.',
                         'flags': {'accopacity': {'docstring': 'Sets opacity accumulation on/off. C: Default is false (Except for sculpt tool for which it is true by default). Q: When queried, it returns a boolean.'},
                                   'activeListChangedProc': {'docstring': 'Accepts a string that contains a MEL command that is invoked whenever the active list changes. There may be some situations where the UI, for example, needs to be updated, when objects are selected/deselected in the scene. In query mode, the name of the currently registered MEL command is returned and this will be an empty string if none is defined.'},
                                   'afterStrokeCmd': {'docstring': 'The passed string is executed as a MEL command immediately after the end of a stroke. C: Default is no command. Q: When queried, it returns the current command'},
                                   'alphaclamp': {'docstring': 'Specifies if the weight value should be alpha clamped to the lower and upper bounds. There are four options here: "none" - no clamping is performed, "lower" - clamps only to the lower bound, "upper" - clamps only to the upper bounds, "both" - clamps to the lower and upper bounds. C: Default is "none".  Q: When queried, it returns a string.'},
                                   'alphaclamplower': {'docstring': 'Specifies the lower bound for the alpha values. C: Default is 0.0.  Q: When queried, it returns a float.'},
                                   'alphaclampupper': {'docstring': 'Specifies the upper bound for the alpha values. C: Default is 1.0.  Q: When queried, it returns a float.'},
                                   'attrSelected': {'docstring': 'Returns a name of the currently selected attribute. Q: When queried, it returns a string.'},
                                   'beforeStrokeCmd': {'docstring': 'The passed string is executed as a MEL command immediately before the start of a stroke. C: Default is no command. Q: When queried, it returns the current command'},
                                   'brushalignment': {'docstring': 'Specifies the path brush alignemnt. If true, the brush will align to stroke path, otherwise it will align to up vector. C: Default is true. Q: When queried, it returns a boolean.'},
                                   'brushfeedback': {'docstring': 'Specifies if the brush additional feedback should be drawn. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                                   'clamp': {'docstring': 'Specifies if the weight value should be clamped to the lower and upper bounds. There are four options here: "none" - no clamping is performed, "lower" - clamps only to the lower bound, "upper" - clamps only to the upper bounds, "both" - clamps to the lower and upper bounds. C: Default is "none".  Q: When queried, it returns a string.'},
                                   'clamplower': {'docstring': 'Specifies the lower bound for the values. C: Default is 0.0.  Q: When queried, it returns a float.'},
                                   'clampupper': {'docstring': 'Specifies the upper bound for the values. C: Default is 1.0.  Q: When queried, it returns a float.'},
                                   'clear': {'docstring': 'Floods all cvs/vertices to the current value.'},
                                   'colorAlphaValue': {'docstring': 'The Alpha value of the color.'},
                                   'colorRGBAValue': {'docstring': 'The RGBA value of the color.'},
                                   'colorRGBValue': {'docstring': 'The RGB value of the color.'},
                                   'colorRamp': {'docstring': 'Allows a user defined color ramp to be used to map values to colors.'},
                                   'colorfeedback': {'docstring': 'Sets on/off the color feedback display. C: Default is FALSE.  Q: When queried, it returns a boolean.'},
                                   'colorfeedbackOverride': {'docstring': 'Sets on/off the color feedback override. C: Default is FALSE.  Q: When queried, it returns a boolean.'},
                                   'colorrangelower': {'docstring': 'Specifies the value that maps to black when color feedback mode is on. C: Default is 0.0.  Q: When queried, it returns a float.'},
                                   'colorrangeupper': {'docstring': 'Specifies the value that maps to the maximum color when color feedback mode is on. C: Default is 1.0.  Q: When queried, it returns a float.'},
                                   'dataTypeIndex': {'docstring': 'When the selected paintable attribute is a vectorArray, it specifies which field to paint on.'},
                                   'disablelighting': {'docstring': 'If color feedback is on, this flag determines whether lighting is disabled or not for the surfaces that are affected. C: Default is FALSE.  Q: When queried, it returns a boolean.'},
                                   'dragSlider': {'docstring': 'Sets the current brush drag state for resizing or offsetting the brush (like the \'b\' and \'m\' default hotkeys). The string argument is one of: "radius", "lowradius", "opacity", "value", "depth", "displacement", "uvvector" or "none". C: Default is "none".'},
                                   'duringStrokeCmd': {'docstring': 'The passed string is executed as a MEL command during the stroke, each time the mouse is dragged. C: Default is no command. Q: When queried, it returns the current command'},
                                   'dynclonemode': {'docstring': 'Enable or disable dynamic clone mode.'},
                                   'edit': {'docstring': ''},
                                   'exists': {'docstring': 'Returns true or false depending upon whether the specified object exists. Other flags are ignored.'},
                                   'expandfilename': {'docstring': 'If true, it will expand the name of the export file and concatenate it with the surface name. Otherwise it will take the name as it is. C: Default is true.'},
                                   'exportaspectratio': {'docstring': 'Value of aspect ratio for export'},
                                   'exportfilemode': {'docstring': 'Specifies the export channel.The valid entries here are: "alpha", "luminance", "rgb", "rgba". C: Default is "luminance/rgb". Q: When queried, it returns a string.'},
                                   'exportfilesave': {'docstring': 'Exports the attribute map and saves to a specified file.'},
                                   'exportfilesizex': {'docstring': 'Specifies the width of the attribute map to export. C: Default width is 256. Q: When queried, it returns an integer.'},
                                   'exportfilesizey': {'docstring': 'Specifies the width of the attribute map to export. C: Default width is 256. Q: When queried, it returns an integer.'},
                                   'exportfiletype': {'docstring': 'Specifies the image file format. It can be one of the following: "iff", "tiff", "jpeg", "alias", "rgb", "fit" "postScriptEPS", "softimage", "wavefrontRLA", "wavefrontEXP". C: default is tiff. Q: When queried, it returns a string.'},
                                   'filterNodes': {'docstring': 'Sets the node filter.'},
                                   'history': {'docstring': 'If this is a tool command, turn the construction history on for the tool in question.'},
                                   'image1': {'docstring': 'First of three possible icons representing the tool associated with the context.'},
                                   'image2': {'docstring': 'Second of three possible icons representing the tool associated with the context.'},
                                   'image3': {'docstring': 'Third of three possible icons representing the tool associated with the context.'},
                                   'importfileload': {'docstring': 'Load the attribute map a specified file.'},
                                   'importfilemode': {'docstring': 'Specifies the channel to import. The valid entries here are: "alpha", "luminance", "red", "green", "blue", and "rgb" C: Default is "alpha". Q: When queried, it returns a string.'},
                                   'importreassign': {'docstring': 'Specifies if the multiply atrribute maps are to be reassigned while importing. Only maps previously exported from within Artisan can be reassigned. C: Default is FALSE. Q: When queried, it returns a  boolean.'},
                                   'influence': {'docstring': 'Specifies which joint has been selected by the user for painting. Q: When queried, it returns a string.'},
                                   'interactiveUpdate': {'docstring': 'Specifies how often to transfer the painted values into the attribute. TRUE: transfer them "continuously" (many times per stroke) FALSE: transfer them only at the end of a stroke (on mouse button release). C: Default is TRUE. Q: When queried, it returns a boolean.'},
                                   'lastRecorderCmd': {'docstring': 'Value of last recorded command.'},
                                   'lastStampName': {'docstring': 'Value of the last stamp name.'},
                                   'lowerradius': {'docstring': 'Sets the lower size of the brush (only apply on tablet).'},
                                   'makeStroke': {'docstring': 'Stroke point values.'},
                                   'mappressure': {'docstring': 'Sets the tablet pressure mapping when the table is used. There are three options: "Opacity" - the pressure is mapped to the opacity, "Radius" - the is mapped to modify the radius of the brush, "Both" - the pressure modifies both the opacity and the radius. C: Default is "Opacity". Q: When queried, it returns a string.'},
                                   'maxvalue': {'docstring': 'Specifies the maximum value for each attribute. C: Default is 1.0.  Q: When queried, it returns a float.'},
                                   'minvalue': {'docstring': 'Specifies the minimum value for each attribute. C: Default is 0.0.  Q: When queried, it returns a float.'},
                                   'name': {'docstring': 'If this is a tool command, name the tool appropriately.'},
                                   'objattrArray': {'docstring': 'An array of all paintable attributes. Each element of the array is a string with the following information: NodeType.NodeName.AttributeName.MenuType. \\*MenuType: type (level) of the item in the Menu (UI). Q: When queried, it returns a string.'},
                                   'opacity': {'docstring': 'Sets the brush opacity. C: Default is 1.0. Q: When queried, it returns a float.'},
                                   'outline': {'docstring': 'Specifies if the brush should be drawn. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                                   'outwhilepaint': {'docstring': 'Specifies if the brush outline should be drawn while painting. C: Default is FALSE. Q: When queried, it returns a boolean.'},
                                   'paintNodeArray': {'docstring': 'An array of paintable nodes. Q: When queried, it returns a string.'},
                                   'paintSelectMode': {'docstring': 'Specifies whether the paint select tool: adds to selection (1) removes from selection (2), toggles selection (3) Q: When queried, it returns an int as defined above.'},
                                   'paintattrselected': {'docstring': 'An array of selected paintable attributes. Each element of the array is a string with the following information: NodeType.NodeName.AttributeName.'},
                                   'paintmode': {'docstring': 'Specifies the paint mode. There are two possibilities: "screen" and "tangent". C: Default is "screen". Q: When queried, it returns a string.'},
                                   'paintoperationtype': {'docstring': 'Specifies the operation type used by the Paint Tool.  Currently, we support the following paint modes: "Paint", "Smear", "Blur", "Erase" and "Clone". Default is "Paint".'},
                                   'pickColor': {'docstring': 'Set pick color mode on or off'},
                                   'pickValue': {'docstring': 'Toggle for picking'},
                                   'playbackCursor': {'docstring': 'Values for the playback cursor.'},
                                   'playbackPressure': {'docstring': 'Valus for the playback pressure.'},
                                   'preserveclonesource': {'docstring': 'Whether or not to preserve a clone source.'},
                                   'profileShapeFile': {'docstring': 'Passes a name of the image file for the stamp shape profile.'},
                                   'projective': {'docstring': "Specifies the projective paint mode. C: Default is 'false'. Q: When queried, it returns a boolean."},
                                   'query': {'docstring': ''},
                                   'radius': {'docstring': 'Sets the size of the brush. C: Default is 1.0 cm. Q: When queried, it returns a float.'},
                                   'rampMaxColor': {'docstring': 'Defines a special color to be used when the value is greater than or equal to the maximum value.'},
                                   'rampMinColor': {'docstring': 'Defines a special color to be used when the value is less than or equal to the minimum value.'},
                                   'record': {'docstring': 'Toggle on for recording.'},
                                   'reflection': {'docstring': "Specifies the reflection mode. C: Default is 'false'. Q: When queried, it returns a boolean."},
                                   'reflectionaboutorigin': {'docstring': 'Toggle on to reflect about the origin'},
                                   'reflectionaxis': {'docstring': 'Specifies the reflection axis. There are three possibilities: "x", "y" and "z". C: Default is "x". Q: When queried, it returns a string.'},
                                   'screenRadius': {'docstring': 'Brush radius on the screen'},
                                   'selectclonesource': {'docstring': 'Toggle on to select the clone source'},
                                   'selectedattroper': {'docstring': 'Sets the edit weight operation. Four edit weights operations are provided : "absolute" - the value of the weight is replaced by the current one, "additive" - the value of the weight is added to the current one, "scale" - the value of the weight is multiplied by the current one, "smooth" - the value of the weight is divided by the current one. C: Default is "absolute".  Q: When queried, it returns a string.'},
                                   'showactive': {'docstring': 'Sets on/off the display of the surface isoparms. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                                   'skinPaintMode': {'docstring': 'Specifies whether the skin paint tool is in paint skin weights mode (1) Marquee select mode (0), or paint select mode (2) Q: When queried, it returns an int as defined above.'},
                                   'stampDepth': {'docstring': 'Depth of the stamps'},
                                   'stampProfile': {'docstring': 'Sets the brush profile of the current stamp. Currently, the following profiles are supported: "gaussian", "poly", "solid" and "square". C: Default is gaussian. Q: When queried, it returns a string.'},
                                   'stampSpacing': {'docstring': 'Specifies the stamp spacing. Default is 1.0.'},
                                   'strokesmooth': {'docstring': 'Stroke smoothing type name'},
                                   'surfaceConformedBrushVertices': {'docstring': 'Enables/disables the the display of the effective brush area as affected vertices.'},
                                   'tablet': {'docstring': 'Returns true if the tablet device is present, false if it is absent'},
                                   'tangentOutline': {'docstring': 'Enables/disables the display of the brush circle tangent to the surface.'},
                                   'toolOffProc': {'docstring': 'Accepts a strings describing the name of a MEL procedure that is invoked whenever the tool is turned off. For example, cloth invokes "clothPaintToolOff" when the cloth paint tool is turned on. Define this callback if your tool requires special functionality when your tool is deactivated. It is typical that if you implement a toolOffProc you will want to implement a toolOnProc as well (see the -toolOnProc flag. In query mode, the name of the currently registered MEL command is returned and this will be an empty string if none is defined.'},
                                   'toolOnProc': {'docstring': 'Accepts a strings describing the name of a MEL procedure that is invoked whenever the tool is turned on. For example, cloth invokes "clothPaintToolOn" when the cloth paint tool is turned on. Define this callback if your tool requires special functionality when your tool is activated. It is typical that if you implement a toolOnProc you will want to implement a toolOffProc as well (see the -toolOffProc flag. In query mode, the name of the currently registered MEL command is returned and this will be an empty string if none is defined.'},
                                   'useColorRamp': {'docstring': 'Specifies whether the user defined color ramp should be used to map values from to colors.  If this is turned off, the default greyscale feedback will be used.'},
                                   'useMaxMinColor': {'docstring': 'Specifies whether the out of range colors should be used.  See rampMinColor and rampMaxColor flags for further details.'},
                                   'usepressure': {'docstring': 'Sets the tablet pressure on/off. C: Default is false. Q: When queried, it returns a boolean.'},
                                   'value': {'docstring': 'Specifies the value for each attribute. C: Default is 0.0.  Q: When queried, it returns a float.'},
                                   'whichTool': {'docstring': 'The string defines the name of the tool to be used for the Artisan context. An example is "artClothPaint". In query mode, the tool name for the given context is returned. Note: due to the way MEL works, always specify the -query flag last when specifying a flag that takes arguments.'},
                                   'worldRadius': {'docstring': 'Radius in worldspace'},
                                   'xrayJoints': {'docstring': 'Specifies whether joints should be displayed in xray mode while painting Q: When queried, it returns a boolean.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'artAttrTool': {'description': 'The artAttrTool command manages the list of tool types which are         used for attribute painting. This command supports querying the         list contents as well as adding new tools to the list. Note that         there is a set of built-in tools. The list of built-ins can         be queried by starting Maya and doing an "artAttrTool -q". The tools which are managed by this command are all intended for         attribute painting via Artisan: when you create a new context via         artAttrCtx you specify the tool name via artAttrCtx\'s -whichToolflag. Typically the user may wish to simply use one of the built-in         tools. However, if you need to have custom Properties and Values sheets         asscociated with your tool, you will need to define a custom tool         via artAttrTool -add "toolName". For an example of a custom         attribute painting tool, see the devkit example customtoolPaint.mel. \t         In query mode, return type is based on queried flag.',
                 'flags': {'add': {'docstring': ''},
                           'exists': {'docstring': 'Checks if the named tool exists, returning true if found, and false otherwise.'},
                           'query': {'docstring': ''},
                           'remove': {'docstring': 'Removes the named tool from the internal list of tools. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'artBaseCtx': {'description': '',
                'flags': {'accopacity': {'docstring': ''},
                          'afterStrokeCmd': {'docstring': ''},
                          'beforeStrokeCmd': {'docstring': ''},
                          'brushalignment': {'docstring': ''},
                          'brushfeedback': {'docstring': ''},
                          'clear': {'docstring': ''},
                          'dragSlider': {'docstring': ''},
                          'dynclonemode': {'docstring': ''},
                          'edit': {'docstring': ''},
                          'exists': {'docstring': ''},
                          'expandfilename': {'docstring': ''},
                          'exportaspectratio': {'docstring': ''},
                          'exportfilemode': {'docstring': ''},
                          'exportfilesave': {'docstring': ''},
                          'exportfilesizex': {'docstring': ''},
                          'exportfilesizey': {'docstring': ''},
                          'exportfiletype': {'docstring': ''},
                          'history': {'docstring': ''},
                          'image1': {'docstring': ''},
                          'image2': {'docstring': ''},
                          'image3': {'docstring': ''},
                          'importfileload': {'docstring': ''},
                          'importfilemode': {'docstring': ''},
                          'importreassign': {'docstring': ''},
                          'lastRecorderCmd': {'docstring': ''},
                          'lastStampName': {'docstring': ''},
                          'lowerradius': {'docstring': ''},
                          'makeStroke': {'docstring': ''},
                          'mappressure': {'docstring': ''},
                          'name': {'docstring': ''},
                          'opacity': {'docstring': ''},
                          'outline': {'docstring': ''},
                          'outwhilepaint': {'docstring': ''},
                          'paintmode': {'docstring': ''},
                          'paintoperationtype': {'docstring': ''},
                          'pickColor': {'docstring': ''},
                          'pickValue': {'docstring': ''},
                          'playbackCursor': {'docstring': ''},
                          'playbackPressure': {'docstring': ''},
                          'preserveclonesource': {'docstring': ''},
                          'profileShapeFile': {'docstring': ''},
                          'projective': {'docstring': ''},
                          'query': {'docstring': ''},
                          'radius': {'docstring': ''},
                          'record': {'docstring': ''},
                          'reflection': {'docstring': ''},
                          'reflectionaboutorigin': {'docstring': ''},
                          'reflectionaxis': {'docstring': ''},
                          'screenRadius': {'docstring': ''},
                          'selectclonesource': {'docstring': ''},
                          'showactive': {'docstring': ''},
                          'stampDepth': {'docstring': ''},
                          'stampProfile': {'docstring': ''},
                          'stampSpacing': {'docstring': ''},
                          'strokesmooth': {'docstring': ''},
                          'surfaceConformedBrushVertices': {'docstring': ''},
                          'tablet': {'docstring': ''},
                          'tangentOutline': {'docstring': ''},
                          'usepressure': {'docstring': ''},
                          'worldRadius': {'docstring': ''}}},
 'artBuildPaintMenu': {'description': '?? \t         ', 'flags': {}},
 'artFluidAttr': {'description': '', 'flags': {}},
 'artFluidAttrCtx': {'description': 'This is a context command to set the flags on the artAttrContext, which is the base context for attribute painting operations. All commands require the name of the context as the last argument as this provides the name of the context to create, edit or query. This command is used to paint properties (such as density) of selected fluid volumes. In query mode, return type is based on queried flag.',
                     'flags': {'accopacity': {'docstring': 'Sets opacity accumulation on/off. C: Default is false (Except for sculpt tool for which it is true by default). Q: When queried, it returns a boolean.'},
                               'activeListChangedProc': {'docstring': 'Accepts a string that contains a MEL command that is invoked whenever the active list changes. There may be some situations where the UI, for example, needs to be updated, when objects are selected/deselected in the scene. In query mode, the name of the currently registered MEL command is returned and this will be an empty string if none is defined.'},
                               'afterStrokeCmd': {'docstring': 'The passed string is executed as a MEL command immediately after the end of a stroke. C: Default is no command. Q: When queried, it returns the current command'},
                               'alphaclamp': {'docstring': 'Specifies if the weight value should be alpha clamped to the lower and upper bounds. There are four options here: "none" - no clamping is performed, "lower" - clamps only to the lower bound, "upper" - clamps only to the upper bounds, "both" - clamps to the lower and upper bounds. C: Default is "none".  Q: When queried, it returns a string.'},
                               'alphaclamplower': {'docstring': 'Specifies the lower bound for the alpha values. C: Default is 0.0.  Q: When queried, it returns a float.'},
                               'alphaclampupper': {'docstring': 'Specifies the upper bound for the alpha values. C: Default is 1.0.  Q: When queried, it returns a float.'},
                               'attrSelected': {'docstring': 'Returns a name of the currently selected attribute. Q: When queried, it returns a string.'},
                               'autoSave': {'docstring': 'A MEL command to save the fluid state.  Called before an event which could overwrite unsaved values of painted fluid properties.  Such events include: changing current time, changing the current paintable property, and exiting the paint tool.  (To turn auto-save off, pass in an empty-valued string argument: e.g., "".)'},
                               'beforeStrokeCmd': {'docstring': 'The passed string is executed as a MEL command immediately before the start of a stroke. C: Default is no command. Q: When queried, it returns the current command'},
                               'brushalignment': {'docstring': 'Specifies the path brush alignemnt. If true, the brush will align to stroke path, otherwise it will align to up vector. C: Default is true. Q: When queried, it returns a boolean.'},
                               'brushfeedback': {'docstring': 'Specifies if the brush additional feedback should be drawn. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                               'clamp': {'docstring': 'Specifies if the weight value should be clamped to the lower and upper bounds. There are four options here: "none" - no clamping is performed, "lower" - clamps only to the lower bound, "upper" - clamps only to the upper bounds, "both" - clamps to the lower and upper bounds. C: Default is "none".  Q: When queried, it returns a string.'},
                               'clamplower': {'docstring': 'Specifies the lower bound for the values. C: Default is 0.0.  Q: When queried, it returns a float.'},
                               'clampupper': {'docstring': 'Specifies the upper bound for the values. C: Default is 1.0.  Q: When queried, it returns a float.'},
                               'clear': {'docstring': 'Floods all cvs/vertices to the current value.'},
                               'colorAlphaValue': {'docstring': 'The Alpha value of the color.'},
                               'colorRGBAValue': {'docstring': 'The RGBA value of the color.'},
                               'colorRGBValue': {'docstring': 'The RGB value of the color.'},
                               'colorRamp': {'docstring': 'Allows a user defined color ramp to be used to map values to colors.'},
                               'colorfeedback': {'docstring': 'Sets on/off the color feedback display. C: Default is FALSE.  Q: When queried, it returns a boolean.'},
                               'colorfeedbackOverride': {'docstring': 'Sets on/off the color feedback override. C: Default is FALSE.  Q: When queried, it returns a boolean.'},
                               'colorrangelower': {'docstring': 'Specifies the value that maps to black when color feedback mode is on. C: Default is 0.0.  Q: When queried, it returns a float.'},
                               'colorrangeupper': {'docstring': 'Specifies the value that maps to the maximum color when color feedback mode is on. C: Default is 1.0.  Q: When queried, it returns a float.'},
                               'currentPaintableFluid': {'docstring': 'Query the name of the fluid on which this context is currently painting.  Returns string.'},
                               'dataTypeIndex': {'docstring': 'When the selected paintable attribute is a vectorArray, it specifies which field to paint on.'},
                               'delaySelectionChanged': {'docstring': 'Internal use only.  Under normal conditions, the tool responds to changes to the selection list so it can update its list of paintable geometry.  When -dsl true is used, the tool will not update its paintable list until a corresponding -dsl false is called.'},
                               'disablelighting': {'docstring': 'If color feedback is on, this flag determines whether lighting is disabled or not for the surfaces that are affected. C: Default is FALSE.  Q: When queried, it returns a boolean.'},
                               'displayAsRender': {'docstring': 'When true, sets the "Shaded Display" attribute of the fluid to "AsRender": all fluid properties displayed as hardware rendered.  When false, displays only the currently selected paintable attribute of the fluid.'},
                               'displayVelocity': {'docstring': 'Turns on/off velocity display, independently of the above "dar/displayAsRender" setting.  Use this flag to enable velocity display while only displaying density, for example.'},
                               'doAutoSave': {'docstring': 'Execute the -autoSave command if there are unsaved painted fluid properties.'},
                               'dragSlider': {'docstring': 'Sets the current brush drag state for resizing or offsetting the brush (like the \'b\' and \'m\' default hotkeys). The string argument is one of: "radius", "lowradius", "opacity", "value", "depth", "displacement", "uvvector" or "none". C: Default is "none".'},
                               'duringStrokeCmd': {'docstring': 'The passed string is executed as a MEL command during the stroke, each time the mouse is dragged. C: Default is no command. Q: When queried, it returns the current command'},
                               'dynclonemode': {'docstring': 'Enable or disable dynamic clone mode.'},
                               'edit': {'docstring': ''},
                               'exists': {'docstring': 'Returns true or false depending upon whether the specified object exists. Other flags are ignored.'},
                               'expandfilename': {'docstring': 'If true, it will expand the name of the export file and concatenate it with the surface name. Otherwise it will take the name as it is. C: Default is true.'},
                               'exportaspectratio': {'docstring': 'Value of aspect ratio for export'},
                               'exportfilemode': {'docstring': 'Specifies the export channel.The valid entries here are: "alpha", "luminance", "rgb", "rgba". C: Default is "luminance/rgb". Q: When queried, it returns a string.'},
                               'exportfilesave': {'docstring': 'Exports the attribute map and saves to a specified file.'},
                               'exportfilesizex': {'docstring': 'Specifies the width of the attribute map to export. C: Default width is 256. Q: When queried, it returns an integer.'},
                               'exportfilesizey': {'docstring': 'Specifies the width of the attribute map to export. C: Default width is 256. Q: When queried, it returns an integer.'},
                               'exportfiletype': {'docstring': 'Specifies the image file format. It can be one of the following: "iff", "tiff", "jpeg", "alias", "rgb", "fit" "postScriptEPS", "softimage", "wavefrontRLA", "wavefrontEXP". C: default is tiff. Q: When queried, it returns a string.'},
                               'filterNodes': {'docstring': 'Sets the node filter.'},
                               'history': {'docstring': 'If this is a tool command, turn the construction history on for the tool in question.'},
                               'image1': {'docstring': 'First of three possible icons representing the tool associated with the context.'},
                               'image2': {'docstring': 'Second of three possible icons representing the tool associated with the context.'},
                               'image3': {'docstring': 'Third of three possible icons representing the tool associated with the context.'},
                               'importfileload': {'docstring': 'Load the attribute map a specified file.'},
                               'importfilemode': {'docstring': 'Specifies the channel to import. The valid entries here are: "alpha", "luminance", "red", "green", "blue", and "rgb" C: Default is "alpha". Q: When queried, it returns a string.'},
                               'importreassign': {'docstring': 'Specifies if the multiply atrribute maps are to be reassigned while importing. Only maps previously exported from within Artisan can be reassigned. C: Default is FALSE. Q: When queried, it returns a  boolean.'},
                               'interactiveUpdate': {'docstring': 'Specifies how often to transfer the painted values into the attribute. TRUE: transfer them "continuously" (many times per stroke) FALSE: transfer them only at the end of a stroke (on mouse button release). C: Default is TRUE. Q: When queried, it returns a boolean.'},
                               'lastRecorderCmd': {'docstring': 'Value of last recorded command.'},
                               'lastStampName': {'docstring': 'Value of the last stamp name.'},
                               'lowerradius': {'docstring': 'Sets the lower size of the brush (only apply on tablet).'},
                               'makeStroke': {'docstring': 'Stroke point values.'},
                               'mappressure': {'docstring': 'Sets the tablet pressure mapping when the table is used. There are three options: "Opacity" - the pressure is mapped to the opacity, "Radius" - the is mapped to modify the radius of the brush, "Both" - the pressure modifies both the opacity and the radius. C: Default is "Opacity". Q: When queried, it returns a string.'},
                               'maxvalue': {'docstring': 'Specifies the maximum value for each attribute. C: Default is 1.0.  Q: When queried, it returns a float.'},
                               'minvalue': {'docstring': 'Specifies the minimum value for each attribute. C: Default is 0.0.  Q: When queried, it returns a float.'},
                               'name': {'docstring': 'If this is a tool command, name the tool appropriately.'},
                               'objattrArray': {'docstring': 'An array of all paintable attributes. Each element of the array is a string with the following information: NodeType.NodeName.AttributeName.MenuType. \\*MenuType: type (level) of the item in the Menu (UI). Q: When queried, it returns a string.'},
                               'opacity': {'docstring': 'Sets the brush opacity. C: Default is 1.0. Q: When queried, it returns a float.'},
                               'outline': {'docstring': 'Specifies if the brush should be drawn. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                               'outwhilepaint': {'docstring': 'Specifies if the brush outline should be drawn while painting. C: Default is FALSE. Q: When queried, it returns a boolean.'},
                               'paintNodeArray': {'docstring': 'An array of paintable nodes. Q: When queried, it returns a string.'},
                               'paintattrselected': {'docstring': 'An array of selected paintable attributes. Each element of the array is a string with the following information: NodeType.NodeName.AttributeName.'},
                               'paintmode': {'docstring': 'Specifies the paint mode. There are two possibilities: "screen" and "tangent". C: Default is "screen". Q: When queried, it returns a string.'},
                               'paintoperationtype': {'docstring': 'Specifies the operation type used by the Paint Tool.  Currently, we support the following paint modes: "Paint", "Smear", "Blur", "Erase" and "Clone". Default is "Paint".'},
                               'pickColor': {'docstring': 'Set pick color mode on or off'},
                               'pickValue': {'docstring': 'Toggle for picking'},
                               'playbackCursor': {'docstring': 'Values for the playback cursor.'},
                               'playbackPressure': {'docstring': 'Valus for the playback pressure.'},
                               'preserveclonesource': {'docstring': 'Whether or not to preserve a clone source.'},
                               'profileShapeFile': {'docstring': 'Passes a name of the image file for the stamp shape profile.'},
                               'projective': {'docstring': "Specifies the projective paint mode. C: Default is 'false'. Q: When queried, it returns a boolean."},
                               'property': {'docstring': 'Specifies a property to paint on the fluid. Valid values are "color", "density", "densityAndColor," "densityAndFuel," "temperature," "fuel", "velocity".'},
                               'query': {'docstring': ''},
                               'radius': {'docstring': 'Sets the size of the brush. C: Default is 1.0 cm. Q: When queried, it returns a float.'},
                               'rampMaxColor': {'docstring': 'Defines a special color to be used when the value is greater than or equal to the maximum value.'},
                               'rampMinColor': {'docstring': 'Defines a special color to be used when the value is less than or equal to the minimum value.'},
                               'record': {'docstring': 'Toggle on for recording.'},
                               'reflection': {'docstring': "Specifies the reflection mode. C: Default is 'false'. Q: When queried, it returns a boolean."},
                               'reflectionaboutorigin': {'docstring': 'Toggle on to reflect about the origin'},
                               'reflectionaxis': {'docstring': 'Specifies the reflection axis. There are three possibilities: "x", "y" and "z". C: Default is "x". Q: When queried, it returns a string.'},
                               'rgbValue': {'docstring': 'Specifies the values of the red, green, and blue components of the color to use when painting the property "color."'},
                               'screenRadius': {'docstring': 'Brush radius on the screen'},
                               'selectclonesource': {'docstring': 'Toggle on to select the clone source'},
                               'selectedattroper': {'docstring': 'Sets the edit weight operation. Four edit weights operations are provided : "absolute" - the value of the weight is replaced by the current one, "additive" - the value of the weight is added to the current one, "scale" - the value of the weight is multiplied by the current one, "smooth" - the value of the weight is divided by the current one. C: Default is "absolute".  Q: When queried, it returns a string.'},
                               'showactive': {'docstring': 'Sets on/off the display of the surface isoparms. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                               'stampDepth': {'docstring': 'Depth of the stamps'},
                               'stampProfile': {'docstring': 'Sets the brush profile of the current stamp. Currently, the following profiles are supported: "gaussian", "poly", "solid" and "square". C: Default is gaussian. Q: When queried, it returns a string.'},
                               'stampSpacing': {'docstring': 'Specifies the stamp spacing. Default is 1.0.'},
                               'strokesmooth': {'docstring': 'Stroke smoothing type name'},
                               'surfaceConformedBrushVertices': {'docstring': 'Enables/disables the the display of the effective brush area as affected vertices.'},
                               'tablet': {'docstring': 'Returns true if the tablet device is present, false if it is absent'},
                               'tangentOutline': {'docstring': 'Enables/disables the display of the brush circle tangent to the surface.'},
                               'toolOffProc': {'docstring': 'Accepts a strings describing the name of a MEL procedure that is invoked whenever the tool is turned off. For example, cloth invokes "clothPaintToolOff" when the cloth paint tool is turned on. Define this callback if your tool requires special functionality when your tool is deactivated. It is typical that if you implement a toolOffProc you will want to implement a toolOnProc as well (see the -toolOnProc flag. In query mode, the name of the currently registered MEL command is returned and this will be an empty string if none is defined.'},
                               'toolOnProc': {'docstring': 'Accepts a strings describing the name of a MEL procedure that is invoked whenever the tool is turned on. For example, cloth invokes "clothPaintToolOn" when the cloth paint tool is turned on. Define this callback if your tool requires special functionality when your tool is activated. It is typical that if you implement a toolOnProc you will want to implement a toolOffProc as well (see the -toolOffProc flag. In query mode, the name of the currently registered MEL command is returned and this will be an empty string if none is defined.'},
                               'useColorRamp': {'docstring': 'Specifies whether the user defined color ramp should be used to map values from to colors.  If this is turned off, the default greyscale feedback will be used.'},
                               'useMaxMinColor': {'docstring': 'Specifies whether the out of range colors should be used.  See rampMinColor and rampMaxColor flags for further details.'},
                               'useStrokeDirection': {'docstring': 'Applicable only during "velocity" painting.  Specifies whether the value of the painted velocity should come from the direction of the brush stroke, overriding the value specified by the -v/-velocity flag.'},
                               'usepressure': {'docstring': 'Sets the tablet pressure on/off. C: Default is false. Q: When queried, it returns a boolean.'},
                               'value': {'docstring': 'Specifies the value for each attribute. C: Default is 0.0.  Q: When queried, it returns a float.'},
                               'velocity': {'docstring': 'Specifies the values of the x, y, and z components of the velocity to use when painting the property "velocity".'},
                               'whichTool': {'docstring': 'The string defines the name of the tool to be used for the Artisan context. An example is "artClothPaint". In query mode, the tool name for the given context is returned. Note: due to the way MEL works, always specify the -query flag last when specifying a flag that takes arguments.'},
                               'worldRadius': {'docstring': 'Radius in worldspace                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'artPuttyCtx': {'description': 'This is a context command to set the flags on the artAttrContext, which is the base context for attribute painting operations. All commands require the name of the context as the last argument as this provides the name of the context to create, edit or query. This command is used to modify NURBS surfaces using a brush based interface (Maya Artisan). This is accomplished by moving the control vertices (CVs) under the brush in the specified direction. In query mode, return type is based on queried flag.',
                 'flags': {'accopacity': {'docstring': 'Sets opacity accumulation on/off. C: Default is false (Except for sculpt tool for which it is true by default). Q: When queried, it returns a boolean.'},
                           'activeListChangedProc': {'docstring': 'Accepts a string that contains a MEL command that is invoked whenever the active list changes. There may be some situations where the UI, for example, needs to be updated, when objects are selected/deselected in the scene. In query mode, the name of the currently registered MEL command is returned and this will be an empty string if none is defined.'},
                           'afterStrokeCmd': {'docstring': 'The passed string is executed as a MEL command immediately after the end of a stroke. C: Default is no command. Q: When queried, it returns the current command'},
                           'alphaclamp': {'docstring': 'Specifies if the weight value should be alpha clamped to the lower and upper bounds. There are four options here: "none" - no clamping is performed, "lower" - clamps only to the lower bound, "upper" - clamps only to the upper bounds, "both" - clamps to the lower and upper bounds. C: Default is "none".  Q: When queried, it returns a string.'},
                           'alphaclamplower': {'docstring': 'Specifies the lower bound for the alpha values. C: Default is 0.0.  Q: When queried, it returns a float.'},
                           'alphaclampupper': {'docstring': 'Specifies the upper bound for the alpha values. C: Default is 1.0.  Q: When queried, it returns a float.'},
                           'attrSelected': {'docstring': 'Returns a name of the currently selected attribute. Q: When queried, it returns a string.'},
                           'autosmooth': {'docstring': 'Sets up the auto smoothing option. When the brush is in the smooth mode, adjusting the strength will adjust how fast the surfaces is smoothed out. C: Default is FALSE.  Q: When queried, it returns a boolean.'},
                           'beforeStrokeCmd': {'docstring': 'The passed string is executed as a MEL command immediately before the start of a stroke. C: Default is no command. Q: When queried, it returns the current command'},
                           'brushStrength': {'docstring': 'Sets the strength of the brush. Brush strength is supported by the pinch and slide brushes. In pinch mode, adjusting the strength will adjust how quickly the surface converges on the brush center. In slide mode, the strength scales the motion of the brush. C: Default is 1.0.  Q: When queried, it returns a float.'},
                           'brushalignment': {'docstring': 'Specifies the path brush alignemnt. If true, the brush will align to stroke path, otherwise it will align to up vector. C: Default is true. Q: When queried, it returns a boolean.'},
                           'brushfeedback': {'docstring': 'Specifies if the brush additional feedback should be drawn. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                           'clamp': {'docstring': 'Specifies if the weight value should be clamped to the lower and upper bounds. There are four options here: "none" - no clamping is performed, "lower" - clamps only to the lower bound, "upper" - clamps only to the upper bounds, "both" - clamps to the lower and upper bounds. C: Default is "none".  Q: When queried, it returns a string.'},
                           'clamplower': {'docstring': 'Specifies the lower bound for the values. C: Default is 0.0.  Q: When queried, it returns a float.'},
                           'clampupper': {'docstring': 'Specifies the upper bound for the values. C: Default is 1.0.  Q: When queried, it returns a float.'},
                           'clear': {'docstring': 'Floods all cvs/vertices to the current value.'},
                           'collapsecvtol': {'docstring': 'Specifies the tolerance for the collapse cv detection. C: Default is 0.005 cm.  Q: When queried, it returns a float.'},
                           'colorAlphaValue': {'docstring': 'The Alpha value of the color.'},
                           'colorRGBAValue': {'docstring': 'The RGBA value of the color.'},
                           'colorRGBValue': {'docstring': 'The RGB value of the color.'},
                           'colorRamp': {'docstring': 'Allows a user defined color ramp to be used to map values to colors.'},
                           'colorfeedback': {'docstring': 'Sets on/off the color feedback display. C: Default is FALSE.  Q: When queried, it returns a boolean.'},
                           'colorfeedbackOverride': {'docstring': 'Sets on/off the color feedback override. C: Default is FALSE.  Q: When queried, it returns a boolean.'},
                           'colorrangelower': {'docstring': 'Specifies the value that maps to black when color feedback mode is on. C: Default is 0.0.  Q: When queried, it returns a float.'},
                           'colorrangeupper': {'docstring': 'Specifies the value that maps to the maximum color when color feedback mode is on. C: Default is 1.0.  Q: When queried, it returns a float.'},
                           'dataTypeIndex': {'docstring': 'When the selected paintable attribute is a vectorArray, it specifies which field to paint on.'},
                           'disablelighting': {'docstring': 'If color feedback is on, this flag determines whether lighting is disabled or not for the surfaces that are affected. C: Default is FALSE.  Q: When queried, it returns a boolean.'},
                           'dispdecr': {'docstring': 'Decreases a maximum displacement by 10%.'},
                           'dispincr': {'docstring': 'Increases a maximum displacement by 10%.'},
                           'dragSlider': {'docstring': 'Sets the current brush drag state for resizing or offsetting the brush (like the \'b\' and \'m\' default hotkeys). The string argument is one of: "radius", "lowradius", "opacity", "value", "depth", "displacement", "uvvector" or "none". C: Default is "none".'},
                           'duringStrokeCmd': {'docstring': 'The passed string is executed as a MEL command during the stroke, each time the mouse is dragged. C: Default is no command. Q: When queried, it returns the current command'},
                           'dynclonemode': {'docstring': 'Enable or disable dynamic clone mode.'},
                           'edit': {'docstring': ''},
                           'erasesrfupd': {'docstring': 'Toggles the update for the erase surface'},
                           'exists': {'docstring': 'Returns true or false depending upon whether the specified object exists. Other flags are ignored.'},
                           'expandfilename': {'docstring': 'If true, it will expand the name of the export file and concatenate it with the surface name. Otherwise it will take the name as it is. C: Default is true.'},
                           'exportaspectratio': {'docstring': 'Value of aspect ratio for export'},
                           'exportfilemode': {'docstring': 'Specifies the export channel.The valid entries here are: "alpha", "luminance", "rgb", "rgba". C: Default is "luminance/rgb". Q: When queried, it returns a string.'},
                           'exportfilesave': {'docstring': 'Exports the attribute map and saves to a specified file.'},
                           'exportfilesizex': {'docstring': 'Specifies the width of the attribute map to export. C: Default width is 256. Q: When queried, it returns an integer.'},
                           'exportfilesizey': {'docstring': 'Specifies the width of the attribute map to export. C: Default width is 256. Q: When queried, it returns an integer.'},
                           'exportfiletype': {'docstring': 'Specifies the image file format. It can be one of the following: "iff", "tiff", "jpeg", "alias", "rgb", "fit" "postScriptEPS", "softimage", "wavefrontRLA", "wavefrontEXP". C: default is tiff. Q: When queried, it returns a string.'},
                           'filterNodes': {'docstring': 'Sets the node filter.'},
                           'history': {'docstring': 'If this is a tool command, turn the construction history on for the tool in question.'},
                           'image1': {'docstring': 'First of three possible icons representing the tool associated with the context.'},
                           'image2': {'docstring': 'Second of three possible icons representing the tool associated with the context.'},
                           'image3': {'docstring': 'Third of three possible icons representing the tool associated with the context.'},
                           'importfileload': {'docstring': 'Load the attribute map a specified file.'},
                           'importfilemode': {'docstring': 'Specifies the channel to import. The valid entries here are: "alpha", "luminance", "red", "green", "blue", and "rgb" C: Default is "alpha". Q: When queried, it returns a string.'},
                           'importreassign': {'docstring': 'Specifies if the multiply atrribute maps are to be reassigned while importing. Only maps previously exported from within Artisan can be reassigned. C: Default is FALSE. Q: When queried, it returns a  boolean.'},
                           'interactiveUpdate': {'docstring': 'Specifies how often to transfer the painted values into the attribute. TRUE: transfer them "continuously" (many times per stroke) FALSE: transfer them only at the end of a stroke (on mouse button release). C: Default is TRUE. Q: When queried, it returns a boolean.'},
                           'invertrefvector': {'docstring': 'Sets the invert of the reference vector option when the reflection is ON. If it is true, the reference vector for the reflected stroke is negated with respect to the original one. C: Default is FALSE. Q: When queried, it returns a boolean.'},
                           'lastRecorderCmd': {'docstring': 'Value of last recorded command.'},
                           'lastStampName': {'docstring': 'Value of the last stamp name.'},
                           'lowerradius': {'docstring': 'Sets the lower size of the brush (only apply on tablet).'},
                           'makeStroke': {'docstring': 'Stroke point values.'},
                           'mappressure': {'docstring': 'Sets the tablet pressure mapping when the table is used. There are three options: "Opacity" - the pressure is mapped to the opacity, "Radius" - the is mapped to modify the radius of the brush, "Both" - the pressure modifies both the opacity and the radius. C: Default is "Opacity". Q: When queried, it returns a string.'},
                           'maxdisp': {'docstring': 'Defines a maximum displacement ( maxDisp in [0.0..5.0] ). C: Default is 1.0.  Q: When queried, it returns a float.'},
                           'maxvalue': {'docstring': 'Specifies the maximum value for each attribute. C: Default is 1.0.  Q: When queried, it returns a float.'},
                           'minvalue': {'docstring': 'Specifies the minimum value for each attribute. C: Default is 0.0.  Q: When queried, it returns a float.'},
                           'mouldtypehead': {'docstring': 'Type of type mould to use'},
                           'mouldtypemouse': {'docstring': 'Specifies the putty operations/mode ("push" - pushes CVs along the given direction (see refvector flag), "pull" - pulls CVs along the specified direction, "smooth" - smooths the sculpt, "erase" - erases the paint). C: Default is "push".  Q: When queried, it returns a string.'},
                           'mouldtypetail': {'docstring': 'Type of eraser mould to use'},
                           'name': {'docstring': 'If this is a tool command, name the tool appropriately.'},
                           'objattrArray': {'docstring': 'An array of all paintable attributes. Each element of the array is a string with the following information: NodeType.NodeName.AttributeName.MenuType. \\*MenuType: type (level) of the item in the Menu (UI). Q: When queried, it returns a string.'},
                           'opacity': {'docstring': 'Sets the brush opacity. C: Default is 1.0. Q: When queried, it returns a float.'},
                           'outline': {'docstring': 'Specifies if the brush should be drawn. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                           'outwhilepaint': {'docstring': 'Specifies if the brush outline should be drawn while painting. C: Default is FALSE. Q: When queried, it returns a boolean.'},
                           'paintNodeArray': {'docstring': 'An array of paintable nodes. Q: When queried, it returns a string.'},
                           'paintattrselected': {'docstring': 'An array of selected paintable attributes. Each element of the array is a string with the following information: NodeType.NodeName.AttributeName.'},
                           'paintmode': {'docstring': 'Specifies the paint mode. There are two possibilities: "screen" and "tangent". C: Default is "screen". Q: When queried, it returns a string.'},
                           'paintoperationtype': {'docstring': 'Specifies the operation type used by the Paint Tool.  Currently, we support the following paint modes: "Paint", "Smear", "Blur", "Erase" and "Clone". Default is "Paint".'},
                           'pickColor': {'docstring': 'Set pick color mode on or off'},
                           'pickValue': {'docstring': 'Toggle for picking'},
                           'playbackCursor': {'docstring': 'Values for the playback cursor.'},
                           'playbackPressure': {'docstring': 'Valus for the playback pressure.'},
                           'polecv': {'docstring': 'Pull all the pole CVs to the same position.'},
                           'preserveclonesource': {'docstring': 'Whether or not to preserve a clone source.'},
                           'profileShapeFile': {'docstring': 'Passes a name of the image file for the stamp shape profile.'},
                           'projective': {'docstring': "Specifies the projective paint mode. C: Default is 'false'. Q: When queried, it returns a boolean."},
                           'query': {'docstring': ''},
                           'radius': {'docstring': 'Sets the size of the brush. C: Default is 1.0 cm. Q: When queried, it returns a float.'},
                           'rampMaxColor': {'docstring': 'Defines a special color to be used when the value is greater than or equal to the maximum value.'},
                           'rampMinColor': {'docstring': 'Defines a special color to be used when the value is less than or equal to the minimum value.'},
                           'record': {'docstring': 'Toggle on for recording.'},
                           'reflection': {'docstring': "Specifies the reflection mode. C: Default is 'false'. Q: When queried, it returns a boolean."},
                           'reflectionaboutorigin': {'docstring': 'Toggle on to reflect about the origin'},
                           'reflectionaxis': {'docstring': 'Specifies the reflection axis. There are three possibilities: "x", "y" and "z". C: Default is "x". Q: When queried, it returns a string.'},
                           'refsurface': {'docstring': 'Sets on/off the update of the reference surface. If it is true the reference surface is automatically updated on the per stroke bases. If it is false, the user has to update the reference surface explicitly by pressing the update button (see updaterefsrf). C: Default is TRUE.  Q: When queried, it returns a boolean.'},
                           'refvector': {'docstring': 'Specifies the direction of the push/pull operation ("normal" - sculpt along normals, "firstnormal" - sculpt along the first normal of the stroke, "view" - sculpt along the view direction, "xaxis", "yaxis", "zaxis" - sculpt along a given axis directions, "uisoparm", "visoparm" - sculpt along U or V isoparametric lines), "uvvector" - sculpt along an arbitrary vector in UV space. C: Default is "normal".  Q: When queried, it returns a string.'},
                           'refvectoru': {'docstring': 'Specifies the U component of the UV vector to be used when -refVector is set to "uvvector".'},
                           'refvectorv': {'docstring': 'Specifies the V component of the UV vector to be used when -refVector is set to "uvvector".'},
                           'screenRadius': {'docstring': 'Brush radius on the screen'},
                           'selectclonesource': {'docstring': 'Toggle on to select the clone source'},
                           'selectedattroper': {'docstring': 'Sets the edit weight operation. Four edit weights operations are provided : "absolute" - the value of the weight is replaced by the current one, "additive" - the value of the weight is added to the current one, "scale" - the value of the weight is multiplied by the current one, "smooth" - the value of the weight is divided by the current one. C: Default is "absolute".  Q: When queried, it returns a string.'},
                           'showactive': {'docstring': 'Sets on/off the display of the surface isoparms. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                           'smoothiters': {'docstring': 'Sets the quality of the smoothing operation (number of iterations). C: Default is 3.  Q: When queried, it returns an int.'},
                           'stampDepth': {'docstring': 'Depth of the stamps'},
                           'stampProfile': {'docstring': 'Sets the brush profile of the current stamp. Currently, the following profiles are supported: "gaussian", "poly", "solid" and "square". C: Default is gaussian. Q: When queried, it returns a string.'},
                           'stampSpacing': {'docstring': 'Specifies the stamp spacing. Default is 1.0.'},
                           'stitchcorner': {'docstring': 'Sets on/off the stitching corner mode C: Default is "off".  Q: When queried, it returns a boolean.'},
                           'stitchedgeflood': {'docstring': 'Triggers postprocessing stitching edge procedure.'},
                           'stitchtype': {'docstring': 'Sets on/off the stitching mode ( "off" - stitching is turned off, "position" - position stitching is done without taking care about the tangent continuity C0, "tan" - C1 continuity is preserved). C: Default is "position".  Q: When queried, it returns a string.'},
                           'strokesmooth': {'docstring': 'Stroke smoothing type name'},
                           'surfaceConformedBrushVertices': {'docstring': 'Enables/disables the the display of the effective brush area as affected vertices.'},
                           'tablet': {'docstring': 'Returns true if the tablet device is present, false if it is absent'},
                           'tangentOutline': {'docstring': 'Enables/disables the display of the brush circle tangent to the surface.'},
                           'toolOffProc': {'docstring': 'Accepts a strings describing the name of a MEL procedure that is invoked whenever the tool is turned off. For example, cloth invokes "clothPaintToolOff" when the cloth paint tool is turned on. Define this callback if your tool requires special functionality when your tool is deactivated. It is typical that if you implement a toolOffProc you will want to implement a toolOnProc as well (see the -toolOnProc flag. In query mode, the name of the currently registered MEL command is returned and this will be an empty string if none is defined.'},
                           'toolOnProc': {'docstring': 'Accepts a strings describing the name of a MEL procedure that is invoked whenever the tool is turned on. For example, cloth invokes "clothPaintToolOn" when the cloth paint tool is turned on. Define this callback if your tool requires special functionality when your tool is activated. It is typical that if you implement a toolOnProc you will want to implement a toolOffProc as well (see the -toolOffProc flag. In query mode, the name of the currently registered MEL command is returned and this will be an empty string if none is defined.'},
                           'updateerasesrf': {'docstring': 'Updates the erase surface.'},
                           'updaterefsrf': {'docstring': 'Updates the reference surface.'},
                           'useColorRamp': {'docstring': 'Specifies whether the user defined color ramp should be used to map values from to colors.  If this is turned off, the default greyscale feedback will be used.'},
                           'useMaxMinColor': {'docstring': 'Specifies whether the out of range colors should be used.  See rampMinColor and rampMaxColor flags for further details.'},
                           'usepressure': {'docstring': 'Sets the tablet pressure on/off. C: Default is false. Q: When queried, it returns a boolean.'},
                           'value': {'docstring': 'Specifies the value for each attribute. C: Default is 0.0.  Q: When queried, it returns a float.'},
                           'whichTool': {'docstring': 'The string defines the name of the tool to be used for the Artisan context. An example is "artClothPaint". In query mode, the tool name for the given context is returned. Note: due to the way MEL works, always specify the -query flag last when specifying a flag that takes arguments.'},
                           'worldRadius': {'docstring': 'Radius in worldspace                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'artSelect': {'description': '', 'flags': {}},
 'artSelectCtx': {'description': 'This command is used to select/deselect/toggle components on selected surfaces using a brush interface (Maya Artisan). Since, it selects components of the surface, it only works in the component mode. In query mode, return type is based on queried flag.',
                  'flags': {'accopacity': {'docstring': 'Sets opacity accumulation on/off. C: Default is false (Except for sculpt tool for which it is true by default). Q: When queried, it returns a boolean.'},
                            'addselection': {'docstring': 'If true, each new stroke adds cvs to the active list. If false, each stroke replaces the previous selection. C: Default is true. Q: When queried, it returns a boole'},
                            'afterStrokeCmd': {'docstring': 'The passed string is executed as a MEL command immediately after the end of a stroke. C: Default is no command. Q: When queried, it returns the current command'},
                            'beforeStrokeCmd': {'docstring': 'The passed string is executed as a MEL command immediately before the start of a stroke. C: Default is no command. Q: When queried, it returns the current command'},
                            'brushalignment': {'docstring': 'Specifies the path brush alignemnt. If true, the brush will align to stroke path, otherwise it will align to up vector. C: Default is true. Q: When queried, it returns a boolean.'},
                            'brushfeedback': {'docstring': 'Specifies if the brush additional feedback should be drawn. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                            'clear': {'docstring': 'Floods all cvs/vertices to the current value.'},
                            'dragSlider': {'docstring': 'Sets the current brush drag state for resizing or offsetting the brush (like the \'b\' and \'m\' default hotkeys). The string argument is one of: "radius", "lowradius", "opacity", "value", "depth", "displacement", "uvvector" or "none". C: Default is "none".'},
                            'dynclonemode': {'docstring': 'Enable or disable dynamic clone mode.'},
                            'edit': {'docstring': ''},
                            'exists': {'docstring': 'Returns true or false depending upon whether the specified object exists. Other flags are ignored.'},
                            'expandfilename': {'docstring': 'If true, it will expand the name of the export file and concatenate it with the surface name. Otherwise it will take the name as it is. C: Default is true.'},
                            'exportaspectratio': {'docstring': 'Value of aspect ratio for export'},
                            'exportfilemode': {'docstring': 'Specifies the export channel.The valid entries here are: "alpha", "luminance", "rgb", "rgba". C: Default is "luminance/rgb". Q: When queried, it returns a string.'},
                            'exportfilesave': {'docstring': 'Exports the attribute map and saves to a specified file.'},
                            'exportfilesizex': {'docstring': 'Specifies the width of the attribute map to export. C: Default width is 256. Q: When queried, it returns an integer.'},
                            'exportfilesizey': {'docstring': 'Specifies the width of the attribute map to export. C: Default width is 256. Q: When queried, it returns an integer.'},
                            'exportfiletype': {'docstring': 'Specifies the image file format. It can be one of the following: "iff", "tiff", "jpeg", "alias", "rgb", "fit" "postScriptEPS", "softimage", "wavefrontRLA", "wavefrontEXP". C: default is tiff. Q: When queried, it returns a string.'},
                            'history': {'docstring': 'If this is a tool command, turn the construction history on for the tool in question.'},
                            'image1': {'docstring': 'First of three possible icons representing the tool associated with the context.'},
                            'image2': {'docstring': 'Second of three possible icons representing the tool associated with the context.'},
                            'image3': {'docstring': 'Third of three possible icons representing the tool associated with the context.'},
                            'importfileload': {'docstring': 'Load the attribute map a specified file.'},
                            'importfilemode': {'docstring': 'Specifies the channel to import. The valid entries here are: "alpha", "luminance", "red", "green", "blue", and "rgb" C: Default is "alpha". Q: When queried, it returns a string.'},
                            'importreassign': {'docstring': 'Specifies if the multiply atrribute maps are to be reassigned while importing. Only maps previously exported from within Artisan can be reassigned. C: Default is FALSE. Q: When queried, it returns a  boolean.'},
                            'importthreshold': {'docstring': 'Specifies the threshold for the import of the attribute maps. C: Default is 0.5.  Q: When queried, it returns a float.'},
                            'lastRecorderCmd': {'docstring': 'Value of last recorded command.'},
                            'lastStampName': {'docstring': 'Value of the last stamp name.'},
                            'lowerradius': {'docstring': 'Sets the lower size of the brush (only apply on tablet).'},
                            'makeStroke': {'docstring': 'Stroke point values.'},
                            'mappressure': {'docstring': 'Sets the tablet pressure mapping when the table is used. There are three options: "Opacity" - the pressure is mapped to the opacity, "Radius" - the is mapped to modify the radius of the brush, "Both" - the pressure modifies both the opacity and the radius. C: Default is "Opacity". Q: When queried, it returns a string.'},
                            'name': {'docstring': 'If this is a tool command, name the tool appropriately.'},
                            'opacity': {'docstring': 'Sets the brush opacity. C: Default is 1.0. Q: When queried, it returns a float.'},
                            'outline': {'docstring': 'Specifies if the brush should be drawn. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                            'outwhilepaint': {'docstring': 'Specifies if the brush outline should be drawn while painting. C: Default is FALSE. Q: When queried, it returns a boolean.'},
                            'paintmode': {'docstring': 'Specifies the paint mode. There are two possibilities: "screen" and "tangent". C: Default is "screen". Q: When queried, it returns a string.'},
                            'paintoperationtype': {'docstring': 'Specifies the operation type used by the Paint Tool.  Currently, we support the following paint modes: "Paint", "Smear", "Blur", "Erase" and "Clone". Default is "Paint".'},
                            'pickColor': {'docstring': 'Set pick color mode on or off'},
                            'pickValue': {'docstring': 'Toggle for picking'},
                            'playbackCursor': {'docstring': 'Values for the playback cursor.'},
                            'playbackPressure': {'docstring': 'Valus for the playback pressure.'},
                            'preserveclonesource': {'docstring': 'Whether or not to preserve a clone source.'},
                            'profileShapeFile': {'docstring': 'Passes a name of the image file for the stamp shape profile.'},
                            'projective': {'docstring': "Specifies the projective paint mode. C: Default is 'false'. Q: When queried, it returns a boolean."},
                            'query': {'docstring': ''},
                            'radius': {'docstring': 'Sets the size of the brush. C: Default is 1.0 cm. Q: When queried, it returns a float.'},
                            'record': {'docstring': 'Toggle on for recording.'},
                            'reflection': {'docstring': "Specifies the reflection mode. C: Default is 'false'. Q: When queried, it returns a boolean."},
                            'reflectionaboutorigin': {'docstring': 'Toggle on to reflect about the origin'},
                            'reflectionaxis': {'docstring': 'Specifies the reflection axis. There are three possibilities: "x", "y" and "z". C: Default is "x". Q: When queried, it returns a string.'},
                            'screenRadius': {'docstring': 'Brush radius on the screen'},
                            'selectall': {'docstring': 'Selects all vertices/egdes/faces/uvs.'},
                            'selectclonesource': {'docstring': 'Toggle on to select the clone source'},
                            'selectop': {'docstring': 'Specifies the selection operation ("select", "unselect", "toggle"). C: Default is "select". Q: When queried, it returns a string.'},
                            'showactive': {'docstring': 'Sets on/off the display of the surface isoparms. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                            'stampDepth': {'docstring': 'Depth of the stamps'},
                            'stampProfile': {'docstring': 'Sets the brush profile of the current stamp. Currently, the following profiles are supported: "gaussian", "poly", "solid" and "square". C: Default is gaussian. Q: When queried, it returns a string.'},
                            'stampSpacing': {'docstring': 'Specifies the stamp spacing. Default is 1.0.'},
                            'strokesmooth': {'docstring': 'Stroke smoothing type name'},
                            'surfaceConformedBrushVertices': {'docstring': 'Enables/disables the the display of the effective brush area as affected vertices.'},
                            'tablet': {'docstring': 'Returns true if the tablet device is present, false if it is absent'},
                            'tangentOutline': {'docstring': 'Enables/disables the display of the brush circle tangent to the surface.'},
                            'toggleall': {'docstring': 'Toggle all vertices/egdes/faces/uvs.'},
                            'unselectall': {'docstring': 'Unselects all vertices/egdes/faces/uvs.'},
                            'usepressure': {'docstring': 'Sets the tablet pressure on/off. C: Default is false. Q: When queried, it returns a boolean.'},
                            'worldRadius': {'docstring': 'Radius in worldspace                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'artSetPaint': {'description': '', 'flags': {}},
 'artSetPaintCtx': {'description': "This tool allows the user to modify the set membership (add, transfer, remove cvs) on nurbs surfaces using Maya Artisan's interface. In query mode, return type is based on queried flag.",
                    'flags': {'accopacity': {'docstring': 'Sets opacity accumulation on/off. C: Default is false (Except for sculpt tool for which it is true by default). Q: When queried, it returns a boolean.'},
                              'afterStrokeCmd': {'docstring': 'The passed string is executed as a MEL command immediately after the end of a stroke. C: Default is no command. Q: When queried, it returns the current command'},
                              'beforeStrokeCmd': {'docstring': 'The passed string is executed as a MEL command immediately before the start of a stroke. C: Default is no command. Q: When queried, it returns the current command'},
                              'brushalignment': {'docstring': 'Specifies the path brush alignemnt. If true, the brush will align to stroke path, otherwise it will align to up vector. C: Default is true. Q: When queried, it returns a boolean.'},
                              'brushfeedback': {'docstring': 'Specifies if the brush additional feedback should be drawn. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                              'clear': {'docstring': 'Floods all cvs/vertices to the current value.'},
                              'dragSlider': {'docstring': 'Sets the current brush drag state for resizing or offsetting the brush (like the \'b\' and \'m\' default hotkeys). The string argument is one of: "radius", "lowradius", "opacity", "value", "depth", "displacement", "uvvector" or "none". C: Default is "none".'},
                              'dynclonemode': {'docstring': 'Enable or disable dynamic clone mode.'},
                              'edit': {'docstring': ''},
                              'exists': {'docstring': 'Returns true or false depending upon whether the specified object exists. Other flags are ignored.'},
                              'expandfilename': {'docstring': 'If true, it will expand the name of the export file and concatenate it with the surface name. Otherwise it will take the name as it is. C: Default is true.'},
                              'exportaspectratio': {'docstring': 'Value of aspect ratio for export'},
                              'exportfilemode': {'docstring': 'Specifies the export channel.The valid entries here are: "alpha", "luminance", "rgb", "rgba". C: Default is "luminance/rgb". Q: When queried, it returns a string.'},
                              'exportfilesave': {'docstring': 'Exports the attribute map and saves to a specified file.'},
                              'exportfilesizex': {'docstring': 'Specifies the width of the attribute map to export. C: Default width is 256. Q: When queried, it returns an integer.'},
                              'exportfilesizey': {'docstring': 'Specifies the width of the attribute map to export. C: Default width is 256. Q: When queried, it returns an integer.'},
                              'exportfiletype': {'docstring': 'Specifies the image file format. It can be one of the following: "iff", "tiff", "jpeg", "alias", "rgb", "fit" "postScriptEPS", "softimage", "wavefrontRLA", "wavefrontEXP". C: default is tiff. Q: When queried, it returns a string.'},
                              'history': {'docstring': 'If this is a tool command, turn the construction history on for the tool in question.'},
                              'image1': {'docstring': 'First of three possible icons representing the tool associated with the context.'},
                              'image2': {'docstring': 'Second of three possible icons representing the tool associated with the context.'},
                              'image3': {'docstring': 'Third of three possible icons representing the tool associated with the context.'},
                              'importfileload': {'docstring': 'Load the attribute map a specified file.'},
                              'importfilemode': {'docstring': 'Specifies the channel to import. The valid entries here are: "alpha", "luminance", "red", "green", "blue", and "rgb" C: Default is "alpha". Q: When queried, it returns a string.'},
                              'importreassign': {'docstring': 'Specifies if the multiply atrribute maps are to be reassigned while importing. Only maps previously exported from within Artisan can be reassigned. C: Default is FALSE. Q: When queried, it returns a  boolean.'},
                              'lastRecorderCmd': {'docstring': 'Value of last recorded command.'},
                              'lastStampName': {'docstring': 'Value of the last stamp name.'},
                              'lowerradius': {'docstring': 'Sets the lower size of the brush (only apply on tablet).'},
                              'makeStroke': {'docstring': 'Stroke point values.'},
                              'mappressure': {'docstring': 'Sets the tablet pressure mapping when the table is used. There are three options: "Opacity" - the pressure is mapped to the opacity, "Radius" - the is mapped to modify the radius of the brush, "Both" - the pressure modifies both the opacity and the radius. C: Default is "Opacity". Q: When queried, it returns a string.'},
                              'name': {'docstring': 'If this is a tool command, name the tool appropriately.'},
                              'objectsetnames': {'docstring': 'Default name of object sets'},
                              'opacity': {'docstring': 'Sets the brush opacity. C: Default is 1.0. Q: When queried, it returns a float.'},
                              'outline': {'docstring': 'Specifies if the brush should be drawn. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                              'outwhilepaint': {'docstring': 'Specifies if the brush outline should be drawn while painting. C: Default is FALSE. Q: When queried, it returns a boolean.'},
                              'paintmode': {'docstring': 'Specifies the paint mode. There are two possibilities: "screen" and "tangent". C: Default is "screen". Q: When queried, it returns a string.'},
                              'paintoperationtype': {'docstring': 'Specifies the operation type used by the Paint Tool.  Currently, we support the following paint modes: "Paint", "Smear", "Blur", "Erase" and "Clone". Default is "Paint".'},
                              'pickColor': {'docstring': 'Set pick color mode on or off'},
                              'pickValue': {'docstring': 'Toggle for picking'},
                              'playbackCursor': {'docstring': 'Values for the playback cursor.'},
                              'playbackPressure': {'docstring': 'Valus for the playback pressure.'},
                              'preserveclonesource': {'docstring': 'Whether or not to preserve a clone source.'},
                              'profileShapeFile': {'docstring': 'Passes a name of the image file for the stamp shape profile.'},
                              'projective': {'docstring': "Specifies the projective paint mode. C: Default is 'false'. Q: When queried, it returns a boolean."},
                              'query': {'docstring': ''},
                              'radius': {'docstring': 'Sets the size of the brush. C: Default is 1.0 cm. Q: When queried, it returns a float.'},
                              'record': {'docstring': 'Toggle on for recording.'},
                              'reflection': {'docstring': "Specifies the reflection mode. C: Default is 'false'. Q: When queried, it returns a boolean."},
                              'reflectionaboutorigin': {'docstring': 'Toggle on to reflect about the origin'},
                              'reflectionaxis': {'docstring': 'Specifies the reflection axis. There are three possibilities: "x", "y" and "z". C: Default is "x". Q: When queried, it returns a string.'},
                              'screenRadius': {'docstring': 'Brush radius on the screen'},
                              'selectclonesource': {'docstring': 'Toggle on to select the clone source'},
                              'setcolorfeedback': {'docstring': 'Specifies if the color feedback is on or off. C: Default is ON.  Q: When queried, it returns a boolean.'},
                              'setdisplaycvs': {'docstring': 'Specifies if the active cvs are displayed. C: Default is ON. Q: When queried, it returns a boolean.'},
                              'setopertype': {'docstring': 'Specifies the setEdit operation ("add", "transfer", "remove"). C: Default is "add". Q: When queried, it returns a string.'},
                              'settomodify': {'docstring': 'Specifies the name of the set to modify. Q: When queried, it returns a string.'},
                              'showactive': {'docstring': 'Sets on/off the display of the surface isoparms. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                              'stampDepth': {'docstring': 'Depth of the stamps'},
                              'stampProfile': {'docstring': 'Sets the brush profile of the current stamp. Currently, the following profiles are supported: "gaussian", "poly", "solid" and "square". C: Default is gaussian. Q: When queried, it returns a string.'},
                              'stampSpacing': {'docstring': 'Specifies the stamp spacing. Default is 1.0.'},
                              'strokesmooth': {'docstring': 'Stroke smoothing type name'},
                              'surfaceConformedBrushVertices': {'docstring': 'Enables/disables the the display of the effective brush area as affected vertices.'},
                              'tablet': {'docstring': 'Returns true if the tablet device is present, false if it is absent'},
                              'tangentOutline': {'docstring': 'Enables/disables the display of the brush circle tangent to the surface.'},
                              'usepressure': {'docstring': 'Sets the tablet pressure on/off. C: Default is false. Q: When queried, it returns a boolean.'},
                              'worldRadius': {'docstring': 'Radius in worldspace                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'artUserPaintCtx': {'description': "This is a context command to set the flags on the artAttrContext, which is the base context for attribute painting operations. All commands require the name of the context as the last argument as this provides the name of the context to create, edit or query. This command executes a scriptable paint (Maya Artisan). It allows the user to apply Mel commands/scripts to modify cvs' attributes for all cvs under the paint brush. ",
                     'flags': {'accopacity': {'docstring': 'Sets opacity accumulation on/off. C: Default is false (Except for sculpt tool for which it is true by default). Q: When queried, it returns a boolean.'},
                               'activeListChangedProc': {'docstring': 'Accepts a string that contains a MEL command that is invoked whenever the active list changes. There may be some situations where the UI, for example, needs to be updated, when objects are selected/deselected in the scene. In query mode, the name of the currently registered MEL command is returned and this will be an empty string if none is defined.'},
                               'afterStrokeCmd': {'docstring': 'The passed string is executed as a MEL command immediately after the end of a stroke. C: Default is no command. Q: When queried, it returns the current command'},
                               'alphaclamp': {'docstring': 'Specifies if the weight value should be alpha clamped to the lower and upper bounds. There are four options here: "none" - no clamping is performed, "lower" - clamps only to the lower bound, "upper" - clamps only to the upper bounds, "both" - clamps to the lower and upper bounds. C: Default is "none".  Q: When queried, it returns a string.'},
                               'alphaclamplower': {'docstring': 'Specifies the lower bound for the alpha values. C: Default is 0.0.  Q: When queried, it returns a float.'},
                               'alphaclampupper': {'docstring': 'Specifies the upper bound for the alpha values. C: Default is 1.0.  Q: When queried, it returns a float.'},
                               'attrSelected': {'docstring': 'Returns a name of the currently selected attribute. Q: When queried, it returns a string.'},
                               'beforeStrokeCmd': {'docstring': 'The passed string is executed as a MEL command immediately before the start of a stroke. C: Default is no command. Q: When queried, it returns the current command'},
                               'brushalignment': {'docstring': 'Specifies the path brush alignemnt. If true, the brush will align to stroke path, otherwise it will align to up vector. C: Default is true. Q: When queried, it returns a boolean.'},
                               'brushfeedback': {'docstring': 'Specifies if the brush additional feedback should be drawn. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                               'chunkCommand': {'docstring': 'Specifies th name of the Mel script/procedure that is called once for every selected surface when a chunk is received on that surface. Q: When queried, it returns a string.'},
                               'clamp': {'docstring': 'Specifies if the weight value should be clamped to the lower and upper bounds. There are four options here: "none" - no clamping is performed, "lower" - clamps only to the lower bound, "upper" - clamps only to the upper bounds, "both" - clamps to the lower and upper bounds. C: Default is "none".  Q: When queried, it returns a string.'},
                               'clamplower': {'docstring': 'Specifies the lower bound for the values. C: Default is 0.0.  Q: When queried, it returns a float.'},
                               'clampupper': {'docstring': 'Specifies the upper bound for the values. C: Default is 1.0.  Q: When queried, it returns a float.'},
                               'clear': {'docstring': 'Floods all cvs/vertices to the current value.'},
                               'colorAlphaValue': {'docstring': 'The Alpha value of the color.'},
                               'colorRGBAValue': {'docstring': 'The RGBA value of the color.'},
                               'colorRGBValue': {'docstring': 'The RGB value of the color.'},
                               'colorRamp': {'docstring': 'Allows a user defined color ramp to be used to map values to colors.'},
                               'colorfeedback': {'docstring': 'Sets on/off the color feedback display. C: Default is FALSE.  Q: When queried, it returns a boolean.'},
                               'colorfeedbackOverride': {'docstring': 'Sets on/off the color feedback override. C: Default is FALSE.  Q: When queried, it returns a boolean.'},
                               'colorrangelower': {'docstring': 'Specifies the value that maps to black when color feedback mode is on. C: Default is 0.0.  Q: When queried, it returns a float.'},
                               'colorrangeupper': {'docstring': 'Specifies the value that maps to the maximum color when color feedback mode is on. C: Default is 1.0.  Q: When queried, it returns a float.'},
                               'dataTypeIndex': {'docstring': 'When the selected paintable attribute is a vectorArray, it specifies which field to paint on.'},
                               'disablelighting': {'docstring': 'If color feedback is on, this flag determines whether lighting is disabled or not for the surfaces that are affected. C: Default is FALSE.  Q: When queried, it returns a boolean.'},
                               'dragSlider': {'docstring': 'Sets the current brush drag state for resizing or offsetting the brush (like the \'b\' and \'m\' default hotkeys). The string argument is one of: "radius", "lowradius", "opacity", "value", "depth", "displacement", "uvvector" or "none". C: Default is "none".'},
                               'duringStrokeCmd': {'docstring': 'The passed string is executed as a MEL command during the stroke, each time the mouse is dragged. C: Default is no command. Q: When queried, it returns the current command'},
                               'dynclonemode': {'docstring': 'Enable or disable dynamic clone mode.'},
                               'edit': {'docstring': ''},
                               'exists': {'docstring': 'Returns true or false depending upon whether the specified object exists. Other flags are ignored.'},
                               'expandfilename': {'docstring': 'If true, it will expand the name of the export file and concatenate it with the surface name. Otherwise it will take the name as it is. C: Default is true.'},
                               'exportaspectratio': {'docstring': 'Value of aspect ratio for export'},
                               'exportfilemode': {'docstring': 'Specifies the export channel.The valid entries here are: "alpha", "luminance", "rgb", "rgba". C: Default is "luminance/rgb". Q: When queried, it returns a string.'},
                               'exportfilesave': {'docstring': 'Exports the attribute map and saves to a specified file.'},
                               'exportfilesizex': {'docstring': 'Specifies the width of the attribute map to export. C: Default width is 256. Q: When queried, it returns an integer.'},
                               'exportfilesizey': {'docstring': 'Specifies the width of the attribute map to export. C: Default width is 256. Q: When queried, it returns an integer.'},
                               'exportfiletype': {'docstring': 'Specifies the image file format. It can be one of the following: "iff", "tiff", "jpeg", "alias", "rgb", "fit" "postScriptEPS", "softimage", "wavefrontRLA", "wavefrontEXP". C: default is tiff. Q: When queried, it returns a string.'},
                               'filterNodes': {'docstring': 'Sets the node filter.'},
                               'finalizeCmd': {'docstring': 'Specifies the name of the Mel script/procedure that is called at the end of each stroke. Q: When queried, it returns a string.'},
                               'fullpaths': {'docstring': 'Specifies whether full path names should be used when surface names are passed to scripts. If false, just the surface name is passed. C: Default is false  Q: When queried, it returns a boolean.'},
                               'getArrayAttrCommand': {'docstring': 'Specifies the name of the Mel script/procedure that is called once for every surface that is selected for painting. This procedure returns a string, which is interpreted as a list of names referring to double array attributes on some dependency node. Q: When queried, it returns a string.'},
                               'getSurfaceCommand': {'docstring': 'Specifies the name of the Mel script/procedure that is called once for every dependency node on the selection list, whenever Artisan processes the selection list. It returns the name of the surface to paint on. Q: When queried, it returns a string.'},
                               'getValueCommand': {'docstring': 'Specifies the name of the Mel script/procedure that is called every time a value on the surface is needed by the scriptable paint tool. Q: When queried, it returns a string.'},
                               'history': {'docstring': 'If this is a tool command, turn the construction history on for the tool in question.'},
                               'image1': {'docstring': 'First of three possible icons representing the tool associated with the context.'},
                               'image2': {'docstring': 'Second of three possible icons representing the tool associated with the context.'},
                               'image3': {'docstring': 'Third of three possible icons representing the tool associated with the context.'},
                               'importfileload': {'docstring': 'Load the attribute map a specified file.'},
                               'importfilemode': {'docstring': 'Specifies the channel to import. The valid entries here are: "alpha", "luminance", "red", "green", "blue", and "rgb" C: Default is "alpha". Q: When queried, it returns a string.'},
                               'importreassign': {'docstring': 'Specifies if the multiply atrribute maps are to be reassigned while importing. Only maps previously exported from within Artisan can be reassigned. C: Default is FALSE. Q: When queried, it returns a  boolean.'},
                               'initializeCmd': {'docstring': 'Specifies the name of the Mel script/procedure that is called in the beginning of each stroke. Q: When queried, it returns a string.'},
                               'interactiveUpdate': {'docstring': 'Specifies how often to transfer the painted values into the attribute. TRUE: transfer them "continuously" (many times per stroke) FALSE: transfer them only at the end of a stroke (on mouse button release). C: Default is TRUE. Q: When queried, it returns a boolean.'},
                               'lastRecorderCmd': {'docstring': 'Value of last recorded command.'},
                               'lastStampName': {'docstring': 'Value of the last stamp name.'},
                               'lowerradius': {'docstring': 'Sets the lower size of the brush (only apply on tablet).'},
                               'makeStroke': {'docstring': 'Stroke point values.'},
                               'mappressure': {'docstring': 'Sets the tablet pressure mapping when the table is used. There are three options: "Opacity" - the pressure is mapped to the opacity, "Radius" - the is mapped to modify the radius of the brush, "Both" - the pressure modifies both the opacity and the radius. C: Default is "Opacity". Q: When queried, it returns a string.'},
                               'maxvalue': {'docstring': 'Specifies the maximum value for each attribute. C: Default is 1.0.  Q: When queried, it returns a float.'},
                               'minvalue': {'docstring': 'Specifies the minimum value for each attribute. C: Default is 0.0.  Q: When queried, it returns a float.'},
                               'name': {'docstring': 'If this is a tool command, name the tool appropriately.'},
                               'objattrArray': {'docstring': 'An array of all paintable attributes. Each element of the array is a string with the following information: NodeType.NodeName.AttributeName.MenuType. \\*MenuType: type (level) of the item in the Menu (UI). Q: When queried, it returns a string.'},
                               'opacity': {'docstring': 'Sets the brush opacity. C: Default is 1.0. Q: When queried, it returns a float.'},
                               'outline': {'docstring': 'Specifies if the brush should be drawn. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                               'outwhilepaint': {'docstring': 'Specifies if the brush outline should be drawn while painting. C: Default is FALSE. Q: When queried, it returns a boolean.'},
                               'paintNodeArray': {'docstring': 'An array of paintable nodes. Q: When queried, it returns a string.'},
                               'paintattrselected': {'docstring': 'An array of selected paintable attributes. Each element of the array is a string with the following information: NodeType.NodeName.AttributeName.'},
                               'paintmode': {'docstring': 'Specifies the paint mode. There are two possibilities: "screen" and "tangent". C: Default is "screen". Q: When queried, it returns a string.'},
                               'paintoperationtype': {'docstring': 'Specifies the operation type used by the Paint Tool.  Currently, we support the following paint modes: "Paint", "Smear", "Blur", "Erase" and "Clone". Default is "Paint".'},
                               'pickColor': {'docstring': 'Set pick color mode on or off'},
                               'pickValue': {'docstring': 'Toggle for picking'},
                               'playbackCursor': {'docstring': 'Values for the playback cursor.'},
                               'playbackPressure': {'docstring': 'Valus for the playback pressure.'},
                               'preserveclonesource': {'docstring': 'Whether or not to preserve a clone source.'},
                               'profileShapeFile': {'docstring': 'Passes a name of the image file for the stamp shape profile.'},
                               'projective': {'docstring': "Specifies the projective paint mode. C: Default is 'false'. Q: When queried, it returns a boolean."},
                               'query': {'docstring': ''},
                               'radius': {'docstring': 'Sets the size of the brush. C: Default is 1.0 cm. Q: When queried, it returns a float.'},
                               'rampMaxColor': {'docstring': 'Defines a special color to be used when the value is greater than or equal to the maximum value.'},
                               'rampMinColor': {'docstring': 'Defines a special color to be used when the value is less than or equal to the minimum value.'},
                               'record': {'docstring': 'Toggle on for recording.'},
                               'reflection': {'docstring': "Specifies the reflection mode. C: Default is 'false'. Q: When queried, it returns a boolean."},
                               'reflectionaboutorigin': {'docstring': 'Toggle on to reflect about the origin'},
                               'reflectionaxis': {'docstring': 'Specifies the reflection axis. There are three possibilities: "x", "y" and "z". C: Default is "x". Q: When queried, it returns a string.'},
                               'screenRadius': {'docstring': 'Brush radius on the screen'},
                               'selectclonesource': {'docstring': 'Toggle on to select the clone source'},
                               'selectedattroper': {'docstring': 'Sets the edit weight operation. Four edit weights operations are provided : "absolute" - the value of the weight is replaced by the current one, "additive" - the value of the weight is added to the current one, "scale" - the value of the weight is multiplied by the current one, "smooth" - the value of the weight is divided by the current one. C: Default is "absolute".  Q: When queried, it returns a string.'},
                               'setArrayValueCommand': {'docstring': 'Specifies the name of the Mel script/procedure that is called for each paint stamp. A stamp may affect one or more values on the surface. This call rolls up all the calls that would be made to setValueCommand for the stamp into one call with array arguments. Q: When queried, it returns a string.'},
                               'setValueCommand': {'docstring': 'Specifies the name of the Mel script/procedure that is called every time a value on the surface is changed. Q: When queried, it returns a string.'},
                               'showactive': {'docstring': 'Sets on/off the display of the surface isoparms. C: Default is TRUE. Q: When queried, it returns a boolean.'},
                               'stampDepth': {'docstring': 'Depth of the stamps'},
                               'stampProfile': {'docstring': 'Sets the brush profile of the current stamp. Currently, the following profiles are supported: "gaussian", "poly", "solid" and "square". C: Default is gaussian. Q: When queried, it returns a string.'},
                               'stampSpacing': {'docstring': 'Specifies the stamp spacing. Default is 1.0.'},
                               'strokesmooth': {'docstring': 'Stroke smoothing type name'},
                               'surfaceConformedBrushVertices': {'docstring': 'Enables/disables the the display of the effective brush area as affected vertices.'},
                               'tablet': {'docstring': 'Returns true if the tablet device is present, false if it is absent'},
                               'tangentOutline': {'docstring': 'Enables/disables the display of the brush circle tangent to the surface.'},
                               'toolCleanupCmd': {'docstring': 'Specifies the name of the Mel script/procedure that is called when this tool is exited. Q: When queried, it returns a string.'},
                               'toolOffProc': {'docstring': 'Accepts a strings describing the name of a MEL procedure that is invoked whenever the tool is turned off. For example, cloth invokes "clothPaintToolOff" when the cloth paint tool is turned on. Define this callback if your tool requires special functionality when your tool is deactivated. It is typical that if you implement a toolOffProc you will want to implement a toolOnProc as well (see the -toolOnProc flag. In query mode, the name of the currently registered MEL command is returned and this will be an empty string if none is defined.'},
                               'toolOnProc': {'docstring': 'Accepts a strings describing the name of a MEL procedure that is invoked whenever the tool is turned on. For example, cloth invokes "clothPaintToolOn" when the cloth paint tool is turned on. Define this callback if your tool requires special functionality when your tool is activated. It is typical that if you implement a toolOnProc you will want to implement a toolOffProc as well (see the -toolOffProc flag. In query mode, the name of the currently registered MEL command is returned and this will be an empty string if none is defined.'},
                               'toolSetupCmd': {'docstring': 'Specifies the name of the Mel script/procedure that is called once for every selected surface when an initial click is received on that surface. Q: When queried, it returns a string.'},
                               'useColorRamp': {'docstring': 'Specifies whether the user defined color ramp should be used to map values from to colors.  If this is turned off, the default greyscale feedback will be used.'},
                               'useMaxMinColor': {'docstring': 'Specifies whether the out of range colors should be used.  See rampMinColor and rampMaxColor flags for further details.'},
                               'usepressure': {'docstring': 'Sets the tablet pressure on/off. C: Default is false. Q: When queried, it returns a boolean.'},
                               'value': {'docstring': 'Specifies the value for each attribute. C: Default is 0.0.  Q: When queried, it returns a float.'},
                               'whichTool': {'docstring': 'The string defines the name of the tool to be used for the Artisan context. An example is "artClothPaint". In query mode, the tool name for the given context is returned. Note: due to the way MEL works, always specify the -query flag last when specifying a flag that takes arguments.'},
                               'worldRadius': {'docstring': 'Radius in worldspace                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'arubaNurbsToPoly': {'description': 'This command tesselates a NURBS surface and produces a polygonal surface. The name of the new polygonal surface is returned. If construction history is ON, then the name of the new dependency node is returned as well. ',
                      'flags': {'adaptive': {'docstring': ''},
                                'caching': {'docstring': 'Toggle caching for all attributes so that no recomputation is needed'},
                                'chordalDeviation': {'docstring': ''},
                                'constructionHistory': {'docstring': 'Turn the construction history on or off.'},
                                'edit': {'docstring': ''},
                                'frozen': {'docstring': ''},
                                'localSpace': {'docstring': 'Tesselate in local space'},
                                'maxChordLength': {'docstring': ''},
                                'minChordLength': {'docstring': ''},
                                'name': {'docstring': 'Sets the name of the newly-created node. If it contains namespace path, the new node will be created under the specified namespace; if the namespace does not exist, it will be created.'},
                                'nodeState': {'docstring': "Maya dependency nodes have 6 possible states. The Normal (0), HasNoEffect (1), and Blocking (2)states can be used to alter how the graph is evaluated.   The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)are for internal use only. They temporarily shut off parts of the graph during interaction (e.g., manipulation). The understanding is that once the operation is done, the state will be reset appropriately, e.g. Waiting-Blockingwill reset back to Blocking.   The Normaland Blockingcases apply to all nodes, while HasNoEffectis node specific; many nodes do not support this option. Plug-ins store state in the MPxNode::stateattribute. Anyone can set it or check this attribute.  Additional details about each of these 3 states follow.  StateDescriptionNormalThe normal node state. This is the default.HasNoEffectThe HasNoEffectoption (a.k.a. pass-through), is used in cases where there is an operation on an input producing an output of the same data type. Nearly all deformers support this state, as do a few other nodes. As stated earlier, it is not supported by all nodes.  Itâ€™s typical to implement support for the HasNoEffectstate in the nodeâ€™s compute method and to perform appropriate operations. Plug-ins can also support HasNoEffect.  The usual implementation of this state is to copy the input directly to the matching output without applying the algorithm in the node. For deformers, applying this state leaves the input geometry undeformed on the output.  BlockingThis is implemented in the depend node base class and applies to all nodes. Blockingis applied during the evaluation phase to connections. An evaluation request to a blocked connection will return as failures, causing the destination plug to retain its current value. Dirty propagation is indirectly affected by this state since blocked connections are never cleaned.  When a node is set to Blockingthe behavior is supposed to be the same as if all outgoing connections were broken. As long as nobody requests evaluation of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked node will still respond to getAttrrequests but a getAttron a downstream node will not reevaluate the blocked node.  Setting the root transform of a hierarchy to Blockingwonâ€™t automatically influence child transforms in the hierarchy. To do this, youâ€™d need to explicitly set all child nodes to the Blockingstate.  For example, to set all child transforms to Blocking, you could use the following script.  import maya.cmds as cmds def blockTree(root): nodesToBlock = [] for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys(): nodesToBlock += cmds.listConnections(node, source=True, destination=True ) for node in {source:1 for source in nodesToBlock}.keys(): cmds.setAttr( '%s.nodeState' % node, 2 )  Applying this script would continue to draw objects but things would not be animated.  Default:kdnNormal"},
                                'normalTolerance': {'docstring': ''},
                                'object': {'docstring': 'Create the result, or just the dependency node.'},
                                'query': {'docstring': ''},
                                'sampleType': {'docstring': ''},
                                'samples': {'docstring': ''},
                                'tolerance': {'docstring': ''},
                                'useSurfaceShader': {'docstring': ''},
                                'worldSpace': {'docstring': 'Tesselate in world space                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'assembly': {'description': 'Command to register assemblies for the scene assembly framework, to create them, and to edit and query them. Assembly nodes are DAG nodes, and are therefore shown in the various DAG editors (Outliner, Hypergraph, Node Editor). At assembly creation time, the node name defaults to the node type name. The assembly command can create any node that is derived from the assembly node base class.  It also acts as a registry of these types, so that various scripting callbacks can be defined and registered with the assembly command.  These callbacks are invoked by Maya during operations on assembly nodes, and can be used to customize behavior. In query mode, return type is based on queried flag.',
              'flags': {'active': {'docstring': 'Set the active representation by name, or query the name of the active representation. Edit mode can be applied to more than one assembly. Query mode will return a single string when only a single assembly is specified, and will return an array of strings when multiple assemblies are specified. Using an empty string as name means to inactivate the currently active representation.'},
                        'activeLabel': {'docstring': 'Set the active representation by label, or query the label of the active representation. Edit mode can be applied to more than one assembly. Query mode will return a single string when only a single assembly is specified, and will return an array of strings when multiple assemblies are specified.'},
                        'canCreate': {'docstring': 'Query the representation types the specific assembly can create.'},
                        'createOptionBoxProc': {'docstring': 'Set or query the option box menu procedure for a specific assembly type. The assembly type will be the default type, unless the -type flag is used to specify an explicit assembly type.'},
                        'createRepresentation': {'docstring': 'Create and add a specific type of representation for an assembly. If the representation type needs additional parameters, they must be specified using the "input" flag. For example, the Maya scene assembly reference implementation Cache and Scene representations need an input file.'},
                        'defaultType': {'docstring': 'Set or query the default type of assembly.  When the assembly command is used to perform an operation on an assembly type rather than on an assembly object, it will be performed on the default type, unless the -type flag is used to specify an explicit assembly type.'},
                        'deleteRepresentation': {'docstring': 'Delete a specific representation from an assembly.'},
                        'deregister': {'docstring': 'Deregister a registered assembly type. If the deregistered type is the default type, the default type will be set to the empty string.'},
                        'edit': {'docstring': ''},
                        'input': {'docstring': 'Specify the additional parameters of representation creation procedure when creating a representation. This flag must be used with createRepresentation flag.'},
                        'isAType': {'docstring': 'Query whether the given object is of an assembly type.'},
                        'isTrackingMemberEdits': {'docstring': 'Query whether the given object is tracking member edits.'},
                        'label': {'docstring': 'Set or query the label for an assembly type. Assembly type is specified with flag "type". If no type specified, the default type is used.'},
                        'listRepTypes': {'docstring': 'Query the supported representation types for a given assembly type.  The assembly type will be the default type, unless the -type flag is used to specify an explicit assembly type.'},
                        'listRepTypesProc': {'docstring': 'Set or query the procedure that provides the representation type list which an assembly type supports.  This procedure takes no argument, and returns a string array of representation types that represents the full set of representation types this assembly type can create.  The assembly type for which this procedure applies will be the default type, unless the type flag is used to specify an explicit assembly type.'},
                        'listRepresentations': {'docstring': 'Query the created representations list for a specific assembly.  The -repType flag can be used to filter the list and return representations for a single representation type.  If the -repType flag is not used, all created representations will be returned.'},
                        'listTypes': {'docstring': 'Query the supported assembly types.'},
                        'name': {'docstring': 'Specify the name of the assembly when creating it.'},
                        'newRepLabel': {'docstring': 'Specify the representation label to set on representation label edit.'},
                        'postCreateUIProc': {'docstring': 'Set or query the UI post-creation procedure for a given assembly type. This procedure will be invoked by Maya immediately after an assembly of the specified type is created from the UI, but not through scripting.  It can be used to invoke a dialog, to obtain and set initial parameters on a newly-created assembly.  The assembly type will be the default type, unless the -type flag is used to specify an explicit assembly type.'},
                        'proc': {'docstring': 'Specify the procedure when setting the representation UI post- or pre-creation procedure, for a given assembly type.  The assembly type will be the default type, unless the -type flag is used to specify an explicit assembly type.'},
                        'query': {'docstring': ''},
                        'renameRepresentation': {'docstring': 'Renames the representation that is the argument to this flag.  The repName flag must be used to provide the new name.'},
                        'repLabel': {'docstring': 'Query or edit the label of the representation that is the argument to this flag, for a given assembly.  In both query and edit modes, the -repLabel flag specifies the name of the representation.  In edit mode, the -newRepLabel flag must be used to specify the new representation label.'},
                        'repName': {'docstring': 'Specify the representation name to set on representation creation or rename. This flag is optional with the createRepresentation flag: if omitted, the assembly will name the representation.  It is mandatory with the renameRepresentation flag.'},
                        'repNamespace': {'docstring': "Query the representation namespace of this assembly node. The value returned is used by Maya for creating the namespace where nodes created by the activation of a representation will be added. If a name clash occurs when the namespace is added to its parent namespace, Maya will update repNamespace with the new name. Two namespaces are involved when dealing with an assembly node: the namespace of the assembly node itself (which this flag does not affect or query), and the namespace of its representations. The representation namespace is a child of its assembly node's namespace. The assembly node's namespace is set by its containing assembly, if it is nested, or by the top-level file. Either the assembly node's namespace, or the representation namespace, or both, can be the empty string. It should be noted that if the assembly node is nested, the assembly node's namespace will be (by virtue of its nesting) the representation namespace of its containing assembly."},
                        'repPostCreateUIProc': {'docstring': 'Set or query the UI post-creation procedure for a specific representation type, and for a specific assembly type.  This procedure takes two arguments, the first the DAG path to the assembly, and the second the name of the representation.  It returns no value.  It will be invoked by Maya immediately after a representation of the specified type is created from the UI, but not through scripting.  It can be used to invoke a dialog, to obtain and set initial parameters on a newly-created representation.  The representation type is the argument of this flag. The -proc flag must be used to specify the procedure name.  The assembly type will be the default type, unless the -type flag is used to specify an explicit assembly type.'},
                        'repPreCreateUIProc': {'docstring': 'Set or query the UI pre-creation procedure for a specific representation type, and for a specific assembly type.  This procedure takes no argument, and returns a string that is passed as an argument to the -input flag when Maya invokes the assembly command with the -createRepresentation flag. The representation pre-creation procedure is invoked by Maya immediately before creating a representation of the specified type from the UI, but not through scripting.  It can be used to invoke a dialog, to obtain the creation argument for a new representation.  The representation type is the argument of this flag.  The -proc flag must be used to specify the procedure name.  The assembly type will be the default type, unless the -type flag is used to specify an explicit assembly type.'},
                        'repType': {'docstring': 'Specify a representation type to use as a filter for the -listRepresentations query.  The representation type is the argument to this flag.'},
                        'repTypeLabel': {'docstring': 'Query the label of the specific representation type.'},
                        'repTypeLabelProc': {'docstring': 'Set or query the procedure that provides the representation type label, for a given assembly type.  The procedure takes the representation type as its sole argument, and returns a localized representation type label. The assembly type for which this procedure applies will be the default type, unless the -type flag is used to specify an explicit assembly type.'},
                        'type': {'docstring': 'Set or query properties for the specified registered assembly type. Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'assignCommand': {'description': 'This command allows the user to assign hotkeys and manipulate the internal array of named command objects. Each object in the array has an 1-based index which is used for referencing. Under expected usage you should not need to use this command directly as the Hotkey Editor may be used to assign hotkeys. This command is obsolete for setting new hotkeys, instead please use the "hotkey" command. In query mode, return type is based on queried flag.',
                   'flags': {'addDivider': {'docstring': 'Appends an "annotated divider" item to the end of the list of commands.'},
                             'altModifier': {'docstring': 'This flag specifies if an alt modifier is used for the key.'},
                             'annotation': {'docstring': 'The string is the english name describing the command.'},
                             'command': {'docstring': 'This is the command that is executed when this object is mapped to a key or menuItem.'},
                             'commandModifier': {'docstring': 'This flag specifies if a command modifier is used for the key. This is only available on systems which support a separate command key.'},
                             'ctrlModifier': {'docstring': 'This flag specifies if a ctrl modifier is used for the key.'},
                             'data1': {'docstring': 'Optional, user-defined data strings may be attached to the nameCommand objects.'},
                             'data2': {'docstring': 'Optional, user-defined data strings may be attached to the nameCommand objects.'},
                             'data3': {'docstring': 'Optional, user-defined data strings may be attached to the nameCommand objects.'},
                             'delete': {'docstring': 'This tells the Manager to delete the object at position index.'},
                             'dividerString': {'docstring': 'If the passed index corresponds to a "divider" item, then the divider\'s annotation is returned.  Otherwise, a null string is returned.'},
                             'edit': {'docstring': ''},
                             'enableCommandRepeat': {'docstring': 'This flag specifies whether command repeat is enabled.'},
                             'factorySettings': {'docstring': 'This flag sets the manager back to factory settings.'},
                             'index': {'docstring': 'The index of the object to operate on. The index value ranges from 1 to the number of name command objects.'},
                             'keyArray': {'docstring': 'This flag returns all of the hotkeys on the command.'},
                             'keyString': {'docstring': 'This specifies a key to assign a command to in edit mode. In query mode this flag returns the key string, modifiers and indicates if the command is mapped to keyUp or keyDown.'},
                             'keyUp': {'docstring': 'This flag specifies if the command is executed on keyUp or keyDown.'},
                             'name': {'docstring': 'The name of the command object.'},
                             'numDividersPreceding': {'docstring': 'If the index of a namedCommand object Cis passed in, then this flag returns the number of "divider" items preceding Cwhen the namedCommands are sorted by category.'},
                             'numElements': {'docstring': "This command returns the number of namedCommands in the system. This flag doesn't require the index to be specified."},
                             'optionModifier': {'docstring': 'This flag specifies if an option modifier is used for the key.'},
                             'query': {'docstring': ''},
                             'sortByKey': {'docstring': 'This key tells the manager to sort by key or by order of creation.'},
                             'sourceUserCommands': {'docstring': 'This command sources the user named command file.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'assignInputDevice': {'description': 'This command associates a command string (i.e. a mel script) with the input device.  When the device moves or a button on the device is pressed, the command string is executed as if you typed it into the window.  If the command string contains the names of buttons or axes of the device, the current value of these buttons/axes are substituted in.  Buttons are reported as booleans and axes as doubles. This command is most useful for associating buttons on a device with commands.  For using a device to capture continous movements it is much more efficient to attach the device directly into the dependency graph. ',
                       'flags': {'clutch': {'docstring': 'specify a clutch button.  This button must be down for the command string to be executed. If no clutch is specified the command string is executed everytime the device state changes'},
                                 'continuous': {'docstring': 'if this flag is set the command string is continously (once for everytime the device changes state).  By default if a clutch button is specified the command string is only executed once when the button is pressed.'},
                                 'device': {'docstring': 'specify which device to assign the command string.'},
                                 'immediate': {'docstring': 'Immediately executes the command, without using the queue.'},
                                 'multiple': {'docstring': 'if this flag is set the other command strings associated with this device are not deleted. By default, when a new command string is attached to the device, all other command strings are deleted.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'assignViewportFactories': {'description': 'Sets viewport factories for displays as materials or textures. \t         In query mode, return type is based on queried flag.',
                             'flags': {'edit': {'docstring': ''},
                                       'materialFactory': {'docstring': 'Set or query the materialFactory for the node type.'},
                                       'nodeType': {'docstring': 'The node type.'},
                                       'query': {'docstring': ''},
                                       'textureFactory': {'docstring': 'Set or query the textureFactory for the node type. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'attachCurve': {'description': 'This attach command is used to attach curves. Once the curves are attached, there will be multiple knots at the joined point(s). These can be kept or removed if the user wishes. If there are two curves, the end of the first curve is attached to the start of the second curve. If there are more than two curves, closest endpoints are joined. Note: if the command is done with Keep Original off, the first curve is replaced by the attached curve. All other curves will remain, the command does not delete them. ',
                 'flags': {'blendBias': {'docstring': 'Skew the result toward the first or the second curve depending on the blend factory being smaller or larger than 0.5. Default:0.5'},
                           'blendKnotInsertion': {'docstring': 'If set to true, insert a knot in one of the original curves (relative position given by the parameter attribute below) in order to produce a slightly different effect. Default:false'},
                           'caching': {'docstring': 'Toggle caching for all attributes so that no recomputation is needed'},
                           'constructionHistory': {'docstring': 'Turn the construction history on or off.'},
                           'edit': {'docstring': ''},
                           'frozen': {'docstring': ''},
                           'keepMultipleKnots': {'docstring': 'If true, keep multiple knots at the join parameter. Otherwise remove them. Default:true'},
                           'method': {'docstring': 'Attach method (connect-0, blend-1) Default:0'},
                           'name': {'docstring': 'Sets the name of the newly-created node. If it contains namespace path, the new node will be created under the specified namespace; if the namespace does not exist, it will be created.'},
                           'nodeState': {'docstring': "Maya dependency nodes have 6 possible states. The Normal (0), HasNoEffect (1), and Blocking (2)states can be used to alter how the graph is evaluated.   The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)are for internal use only. They temporarily shut off parts of the graph during interaction (e.g., manipulation). The understanding is that once the operation is done, the state will be reset appropriately, e.g. Waiting-Blockingwill reset back to Blocking.   The Normaland Blockingcases apply to all nodes, while HasNoEffectis node specific; many nodes do not support this option. Plug-ins store state in the MPxNode::stateattribute. Anyone can set it or check this attribute.  Additional details about each of these 3 states follow.  StateDescriptionNormalThe normal node state. This is the default.HasNoEffectThe HasNoEffectoption (a.k.a. pass-through), is used in cases where there is an operation on an input producing an output of the same data type. Nearly all deformers support this state, as do a few other nodes. As stated earlier, it is not supported by all nodes.  Itâ€™s typical to implement support for the HasNoEffectstate in the nodeâ€™s compute method and to perform appropriate operations. Plug-ins can also support HasNoEffect.  The usual implementation of this state is to copy the input directly to the matching output without applying the algorithm in the node. For deformers, applying this state leaves the input geometry undeformed on the output.  BlockingThis is implemented in the depend node base class and applies to all nodes. Blockingis applied during the evaluation phase to connections. An evaluation request to a blocked connection will return as failures, causing the destination plug to retain its current value. Dirty propagation is indirectly affected by this state since blocked connections are never cleaned.  When a node is set to Blockingthe behavior is supposed to be the same as if all outgoing connections were broken. As long as nobody requests evaluation of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked node will still respond to getAttrrequests but a getAttron a downstream node will not reevaluate the blocked node.  Setting the root transform of a hierarchy to Blockingwonâ€™t automatically influence child transforms in the hierarchy. To do this, youâ€™d need to explicitly set all child nodes to the Blockingstate.  For example, to set all child transforms to Blocking, you could use the following script.  import maya.cmds as cmds def blockTree(root): nodesToBlock = [] for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys(): nodesToBlock += cmds.listConnections(node, source=True, destination=True ) for node in {source:1 for source in nodesToBlock}.keys(): cmds.setAttr( '%s.nodeState' % node, 2 )  Applying this script would continue to draw objects but things would not be animated.  Default:kdnNormal"},
                           'object': {'docstring': 'Create the result, or just the dependency node.'},
                           'parameter': {'docstring': 'The parameter value for the positioning of the newly inserted knot. Default:0.1'},
                           'query': {'docstring': ''},
                           'replaceOriginal': {'docstring': 'Create "in place" (i.e., replace).                  Flag can have multiple arguments, passed either as a tuple or a list.'},
                           'reverse1': {'docstring': 'If true, reverse the first input curve before doing attach. Otherwise, do nothing to the first input curve before attaching. NOTE: setting this attribute to random values will cause unpredictable results and is not supported. Default:false'},
                           'reverse2': {'docstring': 'If true, reverse the second input curve before doing attach. Otherwise, do nothing to the second input curve before attaching. NOTE: setting this attribute to random values will cause unpredictable results and is not supported. Default:false                  Common flags'}}},
 'attachDeviceAttr': {'description': 'This command associates a device/axis pair with a node/attribute pair. When the device axis moves, the value of the attribute is set to the value of the axis. This value can be scaled and offset using the setAttrScale command. In query mode, return type is based on queried flag.',
                      'flags': {'attribute': {'docstring': 'specify the attribute to attach to'},
                                'axis': {'docstring': 'specify the axis to attach from.'},
                                'camera': {'docstring': 'This flag attaches the device/axis to the current camera. The mapping between device axes and camera controls is uses a heuristic based on the device descripton. The interaction is a copy of the mouse camera navigation controls.'},
                                'cameraRotate': {'docstring': 'This flag attaches the device/axis to the current cameras rotation controls.'},
                                'cameraTranslate': {'docstring': 'This flag attaches the device/axis to the current cameras translate controls.'},
                                'clutch': {'docstring': 'specify a clutch button.  This button must be down for the command string to be executed. If no clutch is specified the command string is executed everytime the device state changes'},
                                'device': {'docstring': 'specify which device to assign the command string.'},
                                'selection': {'docstring': 'This flag attaches to the nodes in the selection list. This is different from the default arguments of the command since changing the selection will change the attachments.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'attachSurface': {'description': 'This attach command is used to attach surfaces. Once the surfaces are attached, there will be multiple knots at the joined point(s). These can be kept or removed if the user wishes. The end of the first surface is attached to the start of the second surface in the specified direction. Note: if the command is done with Keep Original off there will be an extra surface in the model (the second surface). The command does not delete it. The first surface is replaced by the attached surface. ',
                   'flags': {'blendBias': {'docstring': 'Skew the result toward the first or the second curve depending on the blend factory being smaller or larger than 0.5. Default:0.5'},
                             'blendKnotInsertion': {'docstring': 'If set to true, insert a knot in one of the original curves (relative position given by the parameter attribute below) in order to produce a slightly different effect. Default:false'},
                             'caching': {'docstring': 'Toggle caching for all attributes so that no recomputation is needed'},
                             'constructionHistory': {'docstring': 'Turn the construction history on or off.'},
                             'directionU': {'docstring': 'If true attach in U direction of surface and V direction otherwise. Default:true'},
                             'edit': {'docstring': ''},
                             'frozen': {'docstring': ''},
                             'keepMultipleKnots': {'docstring': 'If true, keep multiple knots at the join parameter. Otherwise remove them. Default:true'},
                             'method': {'docstring': 'Attach method (connect-0, blend-1) Default:0'},
                             'name': {'docstring': 'Sets the name of the newly-created node. If it contains namespace path, the new node will be created under the specified namespace; if the namespace does not exist, it will be created.'},
                             'nodeState': {'docstring': "Maya dependency nodes have 6 possible states. The Normal (0), HasNoEffect (1), and Blocking (2)states can be used to alter how the graph is evaluated.   The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)are for internal use only. They temporarily shut off parts of the graph during interaction (e.g., manipulation). The understanding is that once the operation is done, the state will be reset appropriately, e.g. Waiting-Blockingwill reset back to Blocking.   The Normaland Blockingcases apply to all nodes, while HasNoEffectis node specific; many nodes do not support this option. Plug-ins store state in the MPxNode::stateattribute. Anyone can set it or check this attribute.  Additional details about each of these 3 states follow.  StateDescriptionNormalThe normal node state. This is the default.HasNoEffectThe HasNoEffectoption (a.k.a. pass-through), is used in cases where there is an operation on an input producing an output of the same data type. Nearly all deformers support this state, as do a few other nodes. As stated earlier, it is not supported by all nodes.  Itâ€™s typical to implement support for the HasNoEffectstate in the nodeâ€™s compute method and to perform appropriate operations. Plug-ins can also support HasNoEffect.  The usual implementation of this state is to copy the input directly to the matching output without applying the algorithm in the node. For deformers, applying this state leaves the input geometry undeformed on the output.  BlockingThis is implemented in the depend node base class and applies to all nodes. Blockingis applied during the evaluation phase to connections. An evaluation request to a blocked connection will return as failures, causing the destination plug to retain its current value. Dirty propagation is indirectly affected by this state since blocked connections are never cleaned.  When a node is set to Blockingthe behavior is supposed to be the same as if all outgoing connections were broken. As long as nobody requests evaluation of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked node will still respond to getAttrrequests but a getAttron a downstream node will not reevaluate the blocked node.  Setting the root transform of a hierarchy to Blockingwonâ€™t automatically influence child transforms in the hierarchy. To do this, youâ€™d need to explicitly set all child nodes to the Blockingstate.  For example, to set all child transforms to Blocking, you could use the following script.  import maya.cmds as cmds def blockTree(root): nodesToBlock = [] for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys(): nodesToBlock += cmds.listConnections(node, source=True, destination=True ) for node in {source:1 for source in nodesToBlock}.keys(): cmds.setAttr( '%s.nodeState' % node, 2 )  Applying this script would continue to draw objects but things would not be animated.  Default:kdnNormal"},
                             'object': {'docstring': 'Create the result, or just the dependency node.'},
                             'parameter': {'docstring': 'The parameter value for the positioning of the newly inserted knot. Default:0.1'},
                             'query': {'docstring': ''},
                             'replaceOriginal': {'docstring': 'Create "in place" (i.e., replace).                  Flag can have multiple arguments, passed either as a tuple or a list.'},
                             'reverse1': {'docstring': 'If true, reverse the direction (specified by directionU) of the first input surface before doing attach. Otherwise, do nothing to the first input surface before attaching. NOTE: setting this attribute to random values will cause unpredictable results and is not supported. Default:false'},
                             'reverse2': {'docstring': 'If true, reverse the direction (specified by directionU) of the second input surface before doing attach. Otherwise, do nothing to the second input surface before attaching. NOTE: setting this attribute to random values will cause unpredictable results and is not supported. Default:false'},
                             'swap1': {'docstring': 'If true, swap the UV directions of the first input surface before doing attach. Otherwise, do nothing to the first input surface before attaching. NOTE: setting this attribute to random values will cause unpredictable results and is not supported. Default:false'},
                             'swap2': {'docstring': 'If true, swap the UV directions of the second input surface before doing attach. Otherwise, do nothing to the second input surface before attaching. NOTE: setting this attribute to random values will cause unpredictable results and is not supported. Default:false'},
                             'twist': {'docstring': 'If true, reverse the second surface in the opposite direction (specified by directionU) before doing attach. This will avoid twists in the attached surfaces. Otherwise, do nothing to the second input surface before attaching. NOTE: setting this attribute to random values will cause unpredictable results and is not supported. Default:false                  Common flags'}}},
 'attrColorSliderGrp': {'description': 'All of the group commands position their individual controls in columns starting at column 1.  The layout of each control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign, and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one column in any group can be adjustable. Create a color slider group consisting of a label, a color canvas, a slider and a button.  Clicking on the canvas will bring up the color editor.  If the button is visible, it will allow you to map a texture to the attribute. ',
                        'flags': {'adjustableColumn': {'docstring': 'Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based index. Passing 0 as argument turns off the previous adjustable column.'},
                                  'adjustableColumn2': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly two columns.'},
                                  'adjustableColumn3': {'docstring': 'Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly three columns.'},
                                  'adjustableColumn4': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly four columns.'},
                                  'adjustableColumn5': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly five columns.'},
                                  'adjustableColumn6': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly six columns.'},
                                  'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                                  'attrNavDecision': {'docstring': 'The first argument is the name of an attribute. The button will be attached to the attribute so the button can be kept in synch with the attribute.  The second argument is the navigatorDecisionString that can guide the behaviour that the navigator implements.'},
                                  'attribute': {'docstring': 'The name of a unique attribute of type 3double.  This newly created field will be attached to the attribute, so that modifications to one will change the other.'},
                                  'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                                  'columnAlign': {'docstring': 'Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type for the specified column.'},
                                  'columnAlign2': {'docstring': 'Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are "left", "right", and "center".'},
                                  'columnAlign3': {'docstring': 'Sets the text alignment for all three columns.  Ignored if there are not exactly three columns. Valid values are "left", "right", and "center".'},
                                  'columnAlign4': {'docstring': 'Sets the text alignment for all four columns.  Ignored if there are not exactly four columns. Valid values are "left", "right", and "center".'},
                                  'columnAlign5': {'docstring': 'Sets the text alignment for all five columns.  Ignored if there are not exactly five columns. Valid values are "left", "right", and "center".'},
                                  'columnAlign6': {'docstring': 'Sets the text alignment for all six columns.  Ignored if there are not exactly six columns. Valid values are "left", "right", and "center".'},
                                  'columnAttach': {'docstring': 'Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies column attachment types and offets.'},
                                  'columnAttach2': {'docstring': 'Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are "left", "right", and "both".'},
                                  'columnAttach3': {'docstring': 'Sets the attachment type for all three columns. Ignored if there are not exactly three columns. Valid values are "left", "right", and "both".'},
                                  'columnAttach4': {'docstring': 'Sets the attachment type for all four columns. Ignored if there are not exactly four columns. Valid values are "left", "right", and "both".'},
                                  'columnAttach5': {'docstring': 'Sets the attachment type for all five columns. Ignored if there are not exactly five columns. Valid values are "left", "right", and "both".'},
                                  'columnAttach6': {'docstring': 'Sets the attachment type for all six columns. Ignored if there are not exactly six columns. Valid values are "left", "right", and "both".'},
                                  'columnOffset2': {'docstring': 'This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the -columnAttach2 flag.  Ignored if there are not exactly two columns.'},
                                  'columnOffset3': {'docstring': 'This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the -columnAttach3 flag.  Ignored if there are not exactly three columns.'},
                                  'columnOffset4': {'docstring': 'This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the -columnAttach4 flag.  Ignored if there are not exactly four columns.'},
                                  'columnOffset5': {'docstring': 'This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the -columnAttach5 flag.  Ignored if there are not exactly five columns.'},
                                  'columnOffset6': {'docstring': 'This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the -columnAttach6 flag.  Ignored if there are not exactly six columns.'},
                                  'columnWidth': {'docstring': 'Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies the column (1 based index) and the second parameter specifies the width.'},
                                  'columnWidth1': {'docstring': 'Sets the width of the first column. Ignored if there is not exactly one column.'},
                                  'columnWidth2': {'docstring': 'Sets the column widths of both columns. Ignored if there are not exactly two columns.'},
                                  'columnWidth3': {'docstring': 'Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.'},
                                  'columnWidth4': {'docstring': 'Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.'},
                                  'columnWidth5': {'docstring': 'Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.'},
                                  'columnWidth6': {'docstring': 'Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.'},
                                  'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                                  'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                                  'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                                  'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                                  'edit': {'docstring': ''},
                                  'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                                  'enableBackground': {'docstring': 'Enables the background color of the control.'},
                                  'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                                  'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                                  'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                                  'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                                  'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                                  'hsvValue': {'docstring': 'Specifies the color in hsv style.'},
                                  'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                                  'label': {'docstring': 'By default, the label of this field will be the name of the attribute.  This flag can be used to override that name with whatever the user wants.'},
                                  'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                                  'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                                  'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                                  'parent': {'docstring': 'The parent layout for this control.'},
                                  'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                                  'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                                  'query': {'docstring': ''},
                                  'rgbValue': {'docstring': 'Specifies the color in rgb style.'},
                                  'rowAttach': {'docstring': 'Arguments are : column, attachment type, offset. Possible attachments are: top | bottom | both. Specifies attachment types and offsets for the entire row.'},
                                  'showButton': {'docstring': 'Control the display of the texture link button. True by default (show it).'},
                                  'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                                  'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                                  'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                                  'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                                  'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'attrCompatibility': {'description': '',
                       'flags': {'addAttr': {'docstring': ''},
                                 'clear': {'docstring': ''},
                                 'dumpTable': {'docstring': ''},
                                 'enable': {'docstring': ''},
                                 'nodeRename': {'docstring': ''},
                                 'pluginNode': {'docstring': ''},
                                 'removeAttr': {'docstring': ''},
                                 'renameAttr': {'docstring': ''},
                                 'type': {'docstring': ''},
                                 'version': {'docstring': ''}}},
 'attrControlGrp': {'description': 'This command creates a control of the type most appropriate for the specified attribute, and associates the control with the attribute. Any change to the control will cause a change in the attribute value, and any change to the attribute value will be reflected in the control. Not all attribute types are supported. \t         ',
                    'flags': {'annotation': {'docstring': 'Sets or queries the annotation value of the control group.'},
                              'attribute': {'docstring': 'Sets or queries the attribute the control represents. The name of the attribute must be fully specified, including the name of the node. Some types of attributes are not supported, but most commonly used attribute types are.'},
                              'changeCommand': {'docstring': 'Sets or queries the change command of the control group. The change command will be executed when the control is used to change the value of the attribute.'},
                              'edit': {'docstring': ''},
                              'enable': {'docstring': 'Sets or queries the enable state of the control group. The control is dimmed if the enable state is set to false.'},
                              'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                              'handlesAttribute': {'docstring': 'Returns true or false as to whether this command can create a control for the specified attribute.'},
                              'hideMapButton': {'docstring': 'Force the map button to remain hidden for this control.'},
                              'label': {'docstring': 'Sets or queries the label of the control group.'},
                              'preventOverride': {'docstring': 'Sets or queries the prevent adjustment state of the control group. If true, the RMB menu for the control will not allow adjustments to be made. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'},
                              'query': {'docstring': ''}}},
 'attrEnumOptionMenu': {'description': 'This command creates an enumerated attribute control. It is usually an option menu. ',
                        'flags': {'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                                  'attribute': {'docstring': 'Attribute that the menu controls.'},
                                  'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                                  'changeCommand': {'docstring': 'The command string is executed when the value of the option menu changes.'},
                                  'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                                  'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                                  'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                                  'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                                  'edit': {'docstring': ''},
                                  'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                                  'enableBackground': {'docstring': 'Enables the background color of the control.'},
                                  'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                                  'enumeratedItem': {'docstring': 'Enumerated item and the corresponding string.  If this flag is not supplied when the control is created, then the command will try to read the values from the attribute.'},
                                  'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                                  'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                                  'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                                  'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                                  'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                                  'label': {'docstring': 'The label text.'},
                                  'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                                  'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                                  'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                                  'parent': {'docstring': 'The parent layout for this control.'},
                                  'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                                  'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                                  'query': {'docstring': ''},
                                  'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                                  'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                                  'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                                  'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                                  'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'attrEnumOptionMenuGrp': {'description': 'All of the group commands position their individual controls in columns starting at column 1.  The layout of each control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign, and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one column in any group can be adjustable. This command creates a pre-packaged collection of label and option menu button associated with an attribute of a node. The attribute should be an integer, and this control allows a UI association of strings to the integers of the attribute. When a new menu item is choosen the corresponding integer will be assigned to the attribute. This control will automatically read the enumeration values from the attribute if none are provided. ',
                           'flags': {'adjustableColumn': {'docstring': 'Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based index. Passing 0 as argument turns off the previous adjustable column.'},
                                     'adjustableColumn2': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly two columns.'},
                                     'adjustableColumn3': {'docstring': 'Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly three columns.'},
                                     'adjustableColumn4': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly four columns.'},
                                     'adjustableColumn5': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly five columns.'},
                                     'adjustableColumn6': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly six columns.'},
                                     'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                                     'attribute': {'docstring': 'The name of an attribute.  The button will be attached to the attribute so the button can be kept in synch with the attribute.'},
                                     'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                                     'columnAlign': {'docstring': 'Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type for the specified column.'},
                                     'columnAlign2': {'docstring': 'Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are "left", "right", and "center".'},
                                     'columnAlign3': {'docstring': 'Sets the text alignment for all three columns.  Ignored if there are not exactly three columns. Valid values are "left", "right", and "center".'},
                                     'columnAlign4': {'docstring': 'Sets the text alignment for all four columns.  Ignored if there are not exactly four columns. Valid values are "left", "right", and "center".'},
                                     'columnAlign5': {'docstring': 'Sets the text alignment for all five columns.  Ignored if there are not exactly five columns. Valid values are "left", "right", and "center".'},
                                     'columnAlign6': {'docstring': 'Sets the text alignment for all six columns.  Ignored if there are not exactly six columns. Valid values are "left", "right", and "center".'},
                                     'columnAttach': {'docstring': 'Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies column attachment types and offets.'},
                                     'columnAttach2': {'docstring': 'Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are "left", "right", and "both".'},
                                     'columnAttach3': {'docstring': 'Sets the attachment type for all three columns. Ignored if there are not exactly three columns. Valid values are "left", "right", and "both".'},
                                     'columnAttach4': {'docstring': 'Sets the attachment type for all four columns. Ignored if there are not exactly four columns. Valid values are "left", "right", and "both".'},
                                     'columnAttach5': {'docstring': 'Sets the attachment type for all five columns. Ignored if there are not exactly five columns. Valid values are "left", "right", and "both".'},
                                     'columnAttach6': {'docstring': 'Sets the attachment type for all six columns. Ignored if there are not exactly six columns. Valid values are "left", "right", and "both".'},
                                     'columnOffset2': {'docstring': 'This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the -columnAttach2 flag.  Ignored if there are not exactly two columns.'},
                                     'columnOffset3': {'docstring': 'This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the -columnAttach3 flag.  Ignored if there are not exactly three columns.'},
                                     'columnOffset4': {'docstring': 'This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the -columnAttach4 flag.  Ignored if there are not exactly four columns.'},
                                     'columnOffset5': {'docstring': 'This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the -columnAttach5 flag.  Ignored if there are not exactly five columns.'},
                                     'columnOffset6': {'docstring': 'This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the -columnAttach6 flag.  Ignored if there are not exactly six columns.'},
                                     'columnWidth': {'docstring': 'Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies the column (1 based index) and the second parameter specifies the width.'},
                                     'columnWidth1': {'docstring': 'Sets the width of the first column. Ignored if there is not exactly one column.'},
                                     'columnWidth2': {'docstring': 'Sets the column widths of both columns. Ignored if there are not exactly two columns.'},
                                     'columnWidth3': {'docstring': 'Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.'},
                                     'columnWidth4': {'docstring': 'Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.'},
                                     'columnWidth5': {'docstring': 'Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.'},
                                     'columnWidth6': {'docstring': 'Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.'},
                                     'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                                     'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                                     'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                                     'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                                     'edit': {'docstring': ''},
                                     'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                                     'enableBackground': {'docstring': 'Enables the background color of the control.'},
                                     'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                                     'enumeratedItem': {'docstring': 'Enumerated item and the corresponding string. If this flag is not supplied when the control is created, then the command will try to read the values from the attribute.'},
                                     'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                                     'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                                     'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                                     'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                                     'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                                     'label': {'docstring': 'Text for the control.'},
                                     'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                                     'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                                     'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                                     'parent': {'docstring': 'The parent layout for this control.'},
                                     'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                                     'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                                     'query': {'docstring': ''},
                                     'rowAttach': {'docstring': 'Arguments are : column, attachment type, offset. Possible attachments are: top | bottom | both. Specifies attachment types and offsets for the entire row.'},
                                     'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                                     'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                                     'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                                     'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                                     'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'attrFieldGrp': {'description': 'All of the group commands position their individual controls in columns starting at column 1.  The layout of each control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign, and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one column in any group can be adjustable. This command creates a pre-packaged collection of label text, plus two to four float fields.  These fields will be attached to the specified vector attribute, so that changes in either will be reflected in the other. The fields created here are expression fields -- while normally operating as a float field, the user can type in any expression starting with the character "-". The field also has an automatic menu brought up by the right mouse button.  The contents of this menu change depending on the state of the attribute being watched by the field. ',
                  'flags': {'adjustableColumn': {'docstring': 'Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based index. Passing 0 as argument turns off the previous adjustable column.'},
                            'adjustableColumn2': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly two columns.'},
                            'adjustableColumn3': {'docstring': 'Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly three columns.'},
                            'adjustableColumn4': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly four columns.'},
                            'adjustableColumn5': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly five columns.'},
                            'adjustableColumn6': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly six columns.'},
                            'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                            'attribute': {'docstring': 'The name of a unique attribute of type vector.  This newly created field will be attached to the attribute, so that modifications to one will change the other.  A "vector" attribute is any compound attribute whose children consist of two to four double-valued attributes.'},
                            'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                            'changeCommand': {'docstring': 'The command string is executed when the value of any of the floatFields change.'},
                            'columnAlign': {'docstring': 'Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type for the specified column.'},
                            'columnAlign2': {'docstring': 'Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are "left", "right", and "center".'},
                            'columnAlign3': {'docstring': 'Sets the text alignment for all three columns.  Ignored if there are not exactly three columns. Valid values are "left", "right", and "center".'},
                            'columnAlign4': {'docstring': 'Sets the text alignment for all four columns.  Ignored if there are not exactly four columns. Valid values are "left", "right", and "center".'},
                            'columnAlign5': {'docstring': 'Sets the text alignment for all five columns.  Ignored if there are not exactly five columns. Valid values are "left", "right", and "center".'},
                            'columnAlign6': {'docstring': 'Sets the text alignment for all six columns.  Ignored if there are not exactly six columns. Valid values are "left", "right", and "center".'},
                            'columnAttach': {'docstring': 'Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies column attachment types and offets.'},
                            'columnAttach2': {'docstring': 'Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are "left", "right", and "both".'},
                            'columnAttach3': {'docstring': 'Sets the attachment type for all three columns. Ignored if there are not exactly three columns. Valid values are "left", "right", and "both".'},
                            'columnAttach4': {'docstring': 'Sets the attachment type for all four columns. Ignored if there are not exactly four columns. Valid values are "left", "right", and "both".'},
                            'columnAttach5': {'docstring': 'Sets the attachment type for all five columns. Ignored if there are not exactly five columns. Valid values are "left", "right", and "both".'},
                            'columnAttach6': {'docstring': 'Sets the attachment type for all six columns. Ignored if there are not exactly six columns. Valid values are "left", "right", and "both".'},
                            'columnOffset2': {'docstring': 'This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the -columnAttach2 flag.  Ignored if there are not exactly two columns.'},
                            'columnOffset3': {'docstring': 'This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the -columnAttach3 flag.  Ignored if there are not exactly three columns.'},
                            'columnOffset4': {'docstring': 'This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the -columnAttach4 flag.  Ignored if there are not exactly four columns.'},
                            'columnOffset5': {'docstring': 'This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the -columnAttach5 flag.  Ignored if there are not exactly five columns.'},
                            'columnOffset6': {'docstring': 'This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the -columnAttach6 flag.  Ignored if there are not exactly six columns.'},
                            'columnWidth': {'docstring': 'Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies the column (1 based index) and the second parameter specifies the width.'},
                            'columnWidth1': {'docstring': 'Sets the width of the first column. Ignored if there is not exactly one column.'},
                            'columnWidth2': {'docstring': 'Sets the column widths of both columns. Ignored if there are not exactly two columns.'},
                            'columnWidth3': {'docstring': 'Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.'},
                            'columnWidth4': {'docstring': 'Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.'},
                            'columnWidth5': {'docstring': 'Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.'},
                            'columnWidth6': {'docstring': 'Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.'},
                            'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                            'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                            'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                            'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                            'edit': {'docstring': ''},
                            'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                            'enableBackground': {'docstring': 'Enables the background color of the control.'},
                            'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                            'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                            'extraButton': {'docstring': 'Add an extra icon button to the end of this control (before extra label).'},
                            'extraButtonCommand': {'docstring': 'The command string is executed when the extra button is clicked.'},
                            'extraButtonIcon': {'docstring': 'The icon file name of the extra button.'},
                            'extraLabel': {'docstring': 'set an optional string that will be positioned to the right of all the fields.'},
                            'forceAddMapButton': {'docstring': 'Force adding a map button to this control. If this option is true, option hideMapButton is suppressed.'},
                            'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                            'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                            'hideMapButton': {'docstring': 'Force the map button to remain hidden for this control.'},
                            'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                            'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                            'label': {'docstring': 'By default, the label of this field will be the name of the attribute.  This flag can be used to override that name with whatever the user wants.'},
                            'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                            'maxValue': {'docstring': 'Sets the maximum value for all fields.'},
                            'minValue': {'docstring': 'Sets the minimum value for all fields.'},
                            'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                            'numberOfFields': {'docstring': 'sets the number of fields.  Only allowed values are 2 to 4.  If not specified, defaults to 3.  NOTE: if the -at flag is used when this widget is created, the number of children in the attribute will determine the number of fields.  Also note:  after creation, the number of fields cannot be changed with the -e flag.'},
                            'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                            'parent': {'docstring': 'The parent layout for this control.'},
                            'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                            'precision': {'docstring': 'Sets the precision for all fields'},
                            'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                            'query': {'docstring': ''},
                            'rowAttach': {'docstring': 'Arguments are : column, attachment type, offset. Possible attachments are: top | bottom | both. Specifies attachment types and offsets for the entire row.'},
                            'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                            'step': {'docstring': 'Sets the increment for all fields'},
                            'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                            'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                            'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                            'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'attrFieldSliderGrp': {'description': 'All of the group commands position their individual controls in columns starting at column 1.  The layout of each control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign, and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one column in any group can be adjustable. This command creates a pre-packaged collection of label text, float field and float slider (for values with a min or max specified) The group also supports the notion of a larger secondary range of possible field values. If an attribute is specified for this object, then it will use any min and max values defined in the attribute.  The user-specified values can reduce the min and max, but cannot expand them. The field created here is an expression field -- while normally operating as a float field, the user can type in any expression starting with the character "=".  This will expand the field to occupy the space previously taken by the slider. The field also has an automatic menu brought up by the right mouse button. The contents of this menu change depending on the state of the attribute being watched by the field. ',
                        'flags': {'adjustableColumn': {'docstring': 'Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based index. Passing 0 as argument turns off the previous adjustable column.'},
                                  'adjustableColumn2': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly two columns.'},
                                  'adjustableColumn3': {'docstring': 'Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly three columns.'},
                                  'adjustableColumn4': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly four columns.'},
                                  'adjustableColumn5': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly five columns.'},
                                  'adjustableColumn6': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly six columns.'},
                                  'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                                  'attribute': {'docstring': 'The name of a unique attribute of type double or int. This newly created field will be attached to the attribute, so that modifications to one will change the other.'},
                                  'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                                  'changeCommand': {'docstring': 'The command string is executed when the value of the slider or floatField changes.  It will be executed only once after a drag of the slider.'},
                                  'columnAlign': {'docstring': 'Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type for the specified column.'},
                                  'columnAlign2': {'docstring': 'Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are "left", "right", and "center".'},
                                  'columnAlign3': {'docstring': 'Sets the text alignment for all three columns.  Ignored if there are not exactly three columns. Valid values are "left", "right", and "center".'},
                                  'columnAlign4': {'docstring': 'Sets the text alignment for all four columns.  Ignored if there are not exactly four columns. Valid values are "left", "right", and "center".'},
                                  'columnAlign5': {'docstring': 'Sets the text alignment for all five columns.  Ignored if there are not exactly five columns. Valid values are "left", "right", and "center".'},
                                  'columnAlign6': {'docstring': 'Sets the text alignment for all six columns.  Ignored if there are not exactly six columns. Valid values are "left", "right", and "center".'},
                                  'columnAttach': {'docstring': 'Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies column attachment types and offets.'},
                                  'columnAttach2': {'docstring': 'Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are "left", "right", and "both".'},
                                  'columnAttach3': {'docstring': 'Sets the attachment type for all three columns. Ignored if there are not exactly three columns. Valid values are "left", "right", and "both".'},
                                  'columnAttach4': {'docstring': 'Sets the attachment type for all four columns. Ignored if there are not exactly four columns. Valid values are "left", "right", and "both".'},
                                  'columnAttach5': {'docstring': 'Sets the attachment type for all five columns. Ignored if there are not exactly five columns. Valid values are "left", "right", and "both".'},
                                  'columnAttach6': {'docstring': 'Sets the attachment type for all six columns. Ignored if there are not exactly six columns. Valid values are "left", "right", and "both".'},
                                  'columnOffset2': {'docstring': 'This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the -columnAttach2 flag.  Ignored if there are not exactly two columns.'},
                                  'columnOffset3': {'docstring': 'This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the -columnAttach3 flag.  Ignored if there are not exactly three columns.'},
                                  'columnOffset4': {'docstring': 'This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the -columnAttach4 flag.  Ignored if there are not exactly four columns.'},
                                  'columnOffset5': {'docstring': 'This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the -columnAttach5 flag.  Ignored if there are not exactly five columns.'},
                                  'columnOffset6': {'docstring': 'This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the -columnAttach6 flag.  Ignored if there are not exactly six columns.'},
                                  'columnWidth': {'docstring': 'Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies the column (1 based index) and the second parameter specifies the width.'},
                                  'columnWidth1': {'docstring': 'Sets the width of the first column. Ignored if there is not exactly one column.'},
                                  'columnWidth2': {'docstring': 'Sets the column widths of both columns. Ignored if there are not exactly two columns.'},
                                  'columnWidth3': {'docstring': 'Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.'},
                                  'columnWidth4': {'docstring': 'Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.'},
                                  'columnWidth5': {'docstring': 'Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.'},
                                  'columnWidth6': {'docstring': 'Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.'},
                                  'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                                  'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                                  'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                                  'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                                  'edit': {'docstring': ''},
                                  'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                                  'enableBackground': {'docstring': 'Enables the background color of the control.'},
                                  'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                                  'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                                  'extraButton': {'docstring': 'Add an extra icon button to the end of this control.'},
                                  'extraButtonCommand': {'docstring': 'The command string is executed when the extra button is clicked.'},
                                  'extraButtonIcon': {'docstring': 'The icon file name of the extra button.'},
                                  'fieldMaxValue': {'docstring': 'Set the maximum value for the field.  This flag allows you to specify a maximum bound for the field higher than that of the slider.   (See note above about max and min values.)'},
                                  'fieldMinValue': {'docstring': 'Set the minimum value for the field.  This flag allows you to specify a minimum bound for the field lower than that of the slider.  (See note above about max and min values.)'},
                                  'fieldStep': {'docstring': 'Sets the increment for the float field.'},
                                  'forceAddMapButton': {'docstring': 'Force adding a map button to this control. If this option is true, option hideMapButton is suppressed.'},
                                  'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                                  'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                                  'hideMapButton': {'docstring': 'Force the map button to remain hidden for this control.'},
                                  'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                                  'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                                  'label': {'docstring': 'By default, the label of this field will be the name of the attribute.  This flag can be used to override that name with whatever string you want.'},
                                  'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                                  'maxValue': {'docstring': 'Sets the maximum value for both the slider and the field. (See note above about min and max values)'},
                                  'minValue': {'docstring': 'Sets the minimum value for both the slider and the field. (by default max and min are set according to what is in the attribute, if anything.  If no max and min are specified, or if only one of the two are specified, then no slider is created.)'},
                                  'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                                  'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                                  'parent': {'docstring': 'The parent layout for this control.'},
                                  'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                                  'precision': {'docstring': 'Sets the number of digits to the right of the decimal. (If attached to an int attribute, this is automatically set to 0 and cannot be overridden.)'},
                                  'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                                  'query': {'docstring': ''},
                                  'rowAttach': {'docstring': 'Arguments are : column, attachment type, offset. Possible attachments are: top | bottom | both. Specifies attachment types and offsets for the entire row.'},
                                  'sliderMaxValue': {'docstring': 'Set the maximum value for the slider.  The slider max will be clipped to the field max.'},
                                  'sliderMinValue': {'docstring': 'Set the minimum value for the slider.  The slider min will be clipped to the field min.'},
                                  'sliderStep': {'docstring': 'On Linux the slider step value represents the amount the value will increase or decrease when you click either side of the slider.'},
                                  'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                                  'step': {'docstring': 'Sets the increment for both the slider and float field.'},
                                  'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                                  'vertical': {'docstring': 'Whether the orientation of the controls in this group are horizontal (default) or vertical.'},
                                  'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                                  'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                                  'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'attrNavigationControlGrp': {'description': 'All of the group commands position their individual controls in columns starting at column 1.  The layout of each control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign, and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one column in any group can be adjustable. This command creates a pre-packaged label navigation button. The group is used to help the user manage connections to a particular attribute. When creating the control you have the opportunity to attach scripts to the control that are executed on various UI events.  You can define what happens when the navigation button is pressed, and when a node is dragged and dropped onto this attribute. The navigation button can traverse to the connected node or can bring up UI to create new connections to the attribute. The button also can show you state information: if there already exists a connection/if the connection is ignored. ',
                              'flags': {'adjustableColumn': {'docstring': 'Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based index. Passing 0 as argument turns off the previous adjustable column.'},
                                        'adjustableColumn2': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly two columns.'},
                                        'adjustableColumn3': {'docstring': 'Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly three columns.'},
                                        'adjustableColumn4': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly four columns.'},
                                        'adjustableColumn5': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly five columns.'},
                                        'adjustableColumn6': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly six columns.'},
                                        'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                                        'attrNavDecision': {'docstring': 'The first argument is the name of an attribute. The button will be attached to the attribute so the button can be kept in synch with the attribute.  The second argument is the navigatorDecisionString that can guide the behaviour that the navigator implements.'},
                                        'attribute': {'docstring': 'The name of an attribute. The button will be attached to the attribute so the button can be kept in synch with the attribute.'},
                                        'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                                        'columnAlign': {'docstring': 'Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type for the specified column.'},
                                        'columnAlign2': {'docstring': 'Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are "left", "right", and "center".'},
                                        'columnAlign3': {'docstring': 'Sets the text alignment for all three columns.  Ignored if there are not exactly three columns. Valid values are "left", "right", and "center".'},
                                        'columnAlign4': {'docstring': 'Sets the text alignment for all four columns.  Ignored if there are not exactly four columns. Valid values are "left", "right", and "center".'},
                                        'columnAlign5': {'docstring': 'Sets the text alignment for all five columns.  Ignored if there are not exactly five columns. Valid values are "left", "right", and "center".'},
                                        'columnAlign6': {'docstring': 'Sets the text alignment for all six columns.  Ignored if there are not exactly six columns. Valid values are "left", "right", and "center".'},
                                        'columnAttach': {'docstring': 'Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies column attachment types and offets.'},
                                        'columnAttach2': {'docstring': 'Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are "left", "right", and "both".'},
                                        'columnAttach3': {'docstring': 'Sets the attachment type for all three columns. Ignored if there are not exactly three columns. Valid values are "left", "right", and "both".'},
                                        'columnAttach4': {'docstring': 'Sets the attachment type for all four columns. Ignored if there are not exactly four columns. Valid values are "left", "right", and "both".'},
                                        'columnAttach5': {'docstring': 'Sets the attachment type for all five columns. Ignored if there are not exactly five columns. Valid values are "left", "right", and "both".'},
                                        'columnAttach6': {'docstring': 'Sets the attachment type for all six columns. Ignored if there are not exactly six columns. Valid values are "left", "right", and "both".'},
                                        'columnOffset2': {'docstring': 'This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the -columnAttach2 flag.  Ignored if there are not exactly two columns.'},
                                        'columnOffset3': {'docstring': 'This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the -columnAttach3 flag.  Ignored if there are not exactly three columns.'},
                                        'columnOffset4': {'docstring': 'This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the -columnAttach4 flag.  Ignored if there are not exactly four columns.'},
                                        'columnOffset5': {'docstring': 'This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the -columnAttach5 flag.  Ignored if there are not exactly five columns.'},
                                        'columnOffset6': {'docstring': 'This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the -columnAttach6 flag.  Ignored if there are not exactly six columns.'},
                                        'columnWidth': {'docstring': 'Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies the column (1 based index) and the second parameter specifies the width.'},
                                        'columnWidth1': {'docstring': 'Sets the width of the first column. Ignored if there is not exactly one column.'},
                                        'columnWidth2': {'docstring': 'Sets the column widths of both columns. Ignored if there are not exactly two columns.'},
                                        'columnWidth3': {'docstring': 'Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.'},
                                        'columnWidth4': {'docstring': 'Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.'},
                                        'columnWidth5': {'docstring': 'Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.'},
                                        'columnWidth6': {'docstring': 'Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.'},
                                        'connectAttrToDropped': {'docstring': 'The script to execute when a node is dragged and dropped onto an attribute (multilister dnd attribute editor). Your script should take in two arguments: the source node and destination attribute respectively.'},
                                        'connectNodeToDropped': {'docstring': 'The script to execute when a node is dragged and dropped onto a node (the multilister issues this).  Your script should take in two arguments: the source node and destination node respectively.'},
                                        'connectToExisting': {'docstring': 'The script to execute when a connection should be made to an existing node.'},
                                        'createNew': {'docstring': 'The script to execute when a new "connection" is requested.'},
                                        'defaultTraversal': {'docstring': 'The script to execute to find out the name of the default traversal node.  The script you attach should be able to take in one argument (the attribute) and return the name of the node that is the default traversal node.'},
                                        'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                                        'delete': {'docstring': 'The script to execute when the connection (and the node connected to) should be deleted.'},
                                        'disconnect': {'docstring': 'The script to execute when a "disconnection" is requested.'},
                                        'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                                        'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                                        'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                                        'edit': {'docstring': ''},
                                        'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                                        'enableBackground': {'docstring': 'Enables the background color of the control.'},
                                        'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                                        'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                                        'extraButton': {'docstring': 'Add an extra icon button to the last of this control.'},
                                        'extraButtonCommand': {'docstring': 'The command string is executed when the extra button is clicked.'},
                                        'extraButtonIcon': {'docstring': 'The icon file name of the extra button.'},
                                        'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                                        'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                                        'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                                        'ignore': {'docstring': 'The script to execute when the connection should be ignored.'},
                                        'ignoreNotSupported': {'docstring': 'Obsolete flag; has no effect.'},
                                        'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                                        'label': {'docstring': 'Text for the control.'},
                                        'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                                        'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                                        'noIgnorableMenu': {'docstring': 'Not show ignorable related popup menu when right click the label.'},
                                        'noKeyableMenu': {'docstring': 'Not show keyable related popup menu when right click the label.'},
                                        'notIgnorableMenu': {'docstring': ''},
                                        'notKeyableMenu': {'docstring': ''},
                                        'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                                        'parent': {'docstring': 'The parent layout for this control.'},
                                        'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                                        'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                                        'query': {'docstring': ''},
                                        'relatedNodes': {'docstring': 'The script to execute to find out what the related nodes are.  The script you attach should be able to take in one argument (the attribute) and return a list of strings that are the name of the nodes that are related.'},
                                        'rowAttach': {'docstring': 'Arguments are : column, attachment type, offset. Possible attachments are: top | bottom | both. Specifies attachment types and offsets for the entire row.'},
                                        'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                                        'unignore': {'docstring': 'The script to execute when the connection should be unignored.'},
                                        'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                                        'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                                        'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                                        'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'attributeInfo': {'description': 'This command lists all of the attributes that are marked with certain flags.  Combinations of flags may be specified and all will be considered. (The method of combination depends on the state of the "logicalAnd/and" flag.) When the "allAttributes/all" flag is specified, attributes of all types will be listed. \t         ',
                   'flags': {'allAttributes': {'docstring': 'Show all attributes associated with the node regardless of type. Use of this flag overrides any other attribute type flags and logical operation that may be specified on the command.'},
                             'bool': {'docstring': "Show the attributes that are of type boolean. Use the 'on' state to get only boolean attributes; the 'off' state to ignore boolean attributes."},
                             'enumerated': {'docstring': "Show the attributes that are of type enumerated. Use the 'on' state to get only enumerated attributes; the 'off' state to ignore enumerated attributes."},
                             'hidden': {'docstring': "Show the attributes that are marked as hidden. Use the 'on' state to get hidden attributes; the 'off' state to get non-hidden attributes."},
                             'inherited': {'docstring': "Filter the attributes based on whether they belong to the node type directly or have been inherited from a root type (e.g. meshShape/direct or dagObject/inherited). Use the 'on' state to get only inherited attributes, the 'off' state to get only directly owned attributes, and leave the flag unspecified to get both."},
                             'internal': {'docstring': "Show the attributes that are marked as internal to the node. Use the 'on' state to get internal attributes; the 'off' state to get non-internal attributes."},
                             'leaf': {'docstring': "Show the attributes that are complex leaves (ie. that have parent attributes and have no children themselves). Use the 'on' state to get leaf attributes; the 'off' state to get non-leaf attributes."},
                             'logicalAnd': {'docstring': "The default is to take the logical 'or' of the above conditions. Specifying this flag switches to the logical 'and' instead."},
                             'multi': {'docstring': "Show the attributes that are multis. Use the 'on' state to get multi attributes; the 'off' state to get non-multi attributes."},
                             'short': {'docstring': 'Show the short attribute names instead of the long names.'},
                             'type': {'docstring': "static node type from which to get 'affects' information \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list."},
                             'userInterface': {'docstring': 'Show the UI-friendly attribute names instead of the Maya ASCII names. Takes precedence over the -s/-short flag if both are specified.'},
                             'writable': {'docstring': "Show the attributes that are writable (ie. can have input connections). Use the 'on' state to get writable attributes; the 'off' state to get non-writable attributes."}}},
 'attributeMenu': {'description': 'Action to generate popup connection menus for Hypershade. This command is used internally by the Hypershade panel. \t         ',
                   'flags': {'beginMenu': {'docstring': 'If true the menu will be used to start a connection edit so it will list all available attributes for either inputs or outputs.  If false the menu will be used to complete a connection so it will list only the attributes compatible with the attribute at the other end of the connection.  A plug must be supplied in this case.'},
                             'editor': {'docstring': 'Name of the Hypergraph, Hypershade or Visor editor for which this menu is being built.  This argument is no longer mandatory. If it is omitted, the inputs flag and the node must be used to specify the search targets. This allows attributeMenu to be used in the absence of a hypershade editor.'},
                             'finishMenu': {'docstring': 'finishes the menu'},
                             'inputs': {'docstring': 'If true only attributes which can be used as inputs will be listed.  If false only attributes which can be used as outputs will be listed'},
                             'plug': {'docstring': 'If inputs is false then we are completing a connection and the name of the plug at the other end of the connection must be supplied.'},
                             'regPulldownMenuCommand': {'docstring': 'This flag will register a callback that allows the user to define their own popup menu for a specific node type for use in the Hypershade and Hypergraph editor. The command signature should look like this: global proc int proc_name>(string $editorName, string $nodeName, string $plug, string $mode, string $menuType) The method should return 0 if it does not recognize the node type and the default attributeMenu popup menu will be displayed. If the callback returns one then the menu is considered built and no other menuItems will be added to the popup. The return value from this flag will be the ID to use for the -unregPulldownMenuCommand flag.'},
                             'unregPulldownMenuCommand': {'docstring': 'This flag will unregister a callback procedure that was registered with the -regPulldownMenuCommand flag. The argument should be the integer identifier returned from the -regPulldownMenuCommand flag. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'attributeName': {'description': 'This command takes one "node.attribute"-style specifier on the command line and returns either the attribute\'s long, short, or nice name.  (The "nice" name, or UI name, is the name used to display the attribute in Maya\'s interface, and may be localized when running Maya in a language other than English.) If more than one "node.attribute" specifier is given on the command line, only the first valid specifier is processed. \t         ',
                   'flags': {'leaf': {'docstring': 'When false, shows parent multi attributes (like "controlPoints[2].xValue").  When true, shows only the leaf-level attribute name (like "xValue").  Default is true. Note that for incomplete attribute strings, like a missing multi-parent index ("controlPoints.xValue") or an incorrectly named compound (cntrlPnts[2].xValue), this flag defaults to true and provides a result as long as the named leaf-level attribute is defined for the node.'},
                             'long': {'docstring': 'Returns names in "long name" format like "translateX"'},
                             'nice': {'docstring': 'Returns names in "nice name" format like "Translate X"'},
                             'short': {'docstring': 'Returns names in "short name" format like "tx" \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'attributeQuery': {'description': 'attributeQuery returns information about the configuration of an attribute. It handles both boolean flags, returning true or false, as well as other return values. Specifying more than one boolean flag will return the logical "and" of all the specified boolean flags.  You may not specify any two flags when both do not provide a boolean return type.  (eg. "-internal -hidden" is okay but "-range -hidden" or "-range -softRange" is not.) \t         ',
                    'flags': {'affectsAppearance': {'docstring': 'Return true if the attribute affects the appearance of the node'},
                              'affectsWorldspace': {'docstring': 'Return the status of the attribute flag marking attributes affecting worldspace'},
                              'attributeType': {'docstring': 'Return the name of the attribute type (will be the same type names as described in the addAttr and addExtension commands).'},
                              'cachedInternally': {'docstring': 'Return whether the attribute is cached within the node as well as in the datablock'},
                              'categories': {'docstring': 'Return the categories to which the attribute belongs or an empty list if it does not belong to any.'},
                              'channelBox': {'docstring': 'Return whether the attribute should show up in the channelBox or not'},
                              'connectable': {'docstring': 'Return the connectable status of the attribute'},
                              'enum': {'docstring': 'Return true if the attribute is a enum attribute'},
                              'exists': {'docstring': 'Return true if the attribute exists'},
                              'hidden': {'docstring': 'Return the hidden status of the attribute'},
                              'indeterminant': {'docstring': "Return true if this attribute might be used in evaluation but it's not known for sure until evaluation time"},
                              'indexMatters': {'docstring': 'Return the indexMatters status of the attribute'},
                              'internal': {'docstring': 'Return true if the attribute is either internalSet or internalGet'},
                              'internalGet': {'docstring': 'Return true if the attribute come from getCachedValue'},
                              'internalSet': {'docstring': 'Return true if the attribute must be set through setCachedValue'},
                              'keyable': {'docstring': 'Return the keyable status of the attribute'},
                              'listChildren': {'docstring': 'Return the list of children attributes of the given attribute.'},
                              'listDefault': {'docstring': 'Return the default values of numeric and compound numeric attributes.'},
                              'listEnum': {'docstring': 'Return the list of enum strings for the given attribute.'},
                              'listParent': {'docstring': 'Return the parent of the given attribute.'},
                              'listSiblings': {'docstring': 'Return the list of sibling attributes of the given attribute.'},
                              'localizedListEnum': {'docstring': 'Return the list of localized enum strings for the given attribute.'},
                              'longName': {'docstring': 'Return the long name of the attribute.'},
                              'maxExists': {'docstring': 'Return true if the attribute has a hard maximum. A min does not have to be present.'},
                              'maximum': {'docstring': "Return the hard maximum of the attribute's value"},
                              'message': {'docstring': 'Return true if the attribute is a message attribute'},
                              'minExists': {'docstring': 'Return true if the attribute has a hard minimum. A max does not have to be present.'},
                              'minimum': {'docstring': "Return the hard minimum of the attribute's value"},
                              'multi': {'docstring': 'Return true if the attribute is a multi-attribute'},
                              'niceName': {'docstring': 'Return the nice name (or "UI name") of the attribute.'},
                              'node': {'docstring': 'Use all attributes from node named NAME'},
                              'numberOfChildren': {'docstring': 'Return the number of children the attribute has'},
                              'range': {'docstring': "Return the hard range of the attribute's value"},
                              'rangeExists': {'docstring': 'Return true if the attribute has a hard range. Both min and max must be present.'},
                              'readable': {'docstring': 'Return the readable status of the attribute'},
                              'renderSource': {'docstring': 'Return whether this attribute is marked as a render source or not'},
                              'shortName': {'docstring': 'Return the short name of the attribute.'},
                              'softMax': {'docstring': "Return the soft max (slider range) of the attribute's value"},
                              'softMaxExists': {'docstring': 'Return true if the attribute has a soft maximum. A min does not have to be present.'},
                              'softMin': {'docstring': "Return the soft min (slider range) of the attribute's value"},
                              'softMinExists': {'docstring': 'Return true if the attribute has a soft minimum. A max does not have to be present.'},
                              'softRange': {'docstring': "Return the soft range (slider range) of the attribute's value"},
                              'softRangeExists': {'docstring': 'Return true if the attribute has a soft range. Both min and max must be present.'},
                              'storable': {'docstring': 'Return true if the attribute is storable'},
                              'type': {'docstring': 'Use static attributes from nodes of type TYPE.  Includes attributes inherited from parent class nodes.'},
                              'typeExact': {'docstring': 'Use static attributes only from nodes of type TYPE.  Does not included inherited attributes.'},
                              'usedAsColor': {'docstring': 'Return true if the attribute should bring up a color picker'},
                              'usedAsFilename': {'docstring': 'Return true if the attribute should bring up a file browser'},
                              'usesMultiBuilder': {'docstring': 'Return true if the attribute is a multi-attribute and it uses the multi-builder to handle its data'},
                              'worldspace': {'docstring': 'Return the status of the attribute flag marking worldspace attribute'},
                              'writable': {'docstring': 'Return the writable status of the attribute \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'audioTrack': {'description': 'This command is used for inserting and removing tracks related to the audio clips displayed in the sequencer. It can also be used to modify the track state, for example, to lock or mute a track. \t         In query mode, return type is based on queried flag.',
                'flags': {'edit': {'docstring': ''},
                          'insertTrack': {'docstring': 'This flag is used to insert a new empty track at the track index specified. Indices are 1-based.'},
                          'lock': {'docstring': 'This flag specifies whether all audio clips on the same track as the specified audio node are to be locked at their current location and track.'},
                          'mute': {'docstring': 'This flag specifies whether all audio clips on the same track as the specified audio node are to be muted or not.'},
                          'numTracks': {'docstring': 'To query the number of audio tracks'},
                          'query': {'docstring': ''},
                          'removeEmptyTracks': {'docstring': 'This flag is used to remove all tracks that have no clips.'},
                          'removeTrack': {'docstring': 'This flag is used to remove the track with the specified index.  The track must have no clips on it before it can be removed.'},
                          'solo': {'docstring': 'This flag specifies whether all audio clips on the same track as the specified audio node are to be soloed or not.'},
                          'swapTracks': {'docstring': 'This flag is used to swap the contents of two specified tracks. Indices are 1-based.'},
                          'title': {'docstring': 'This flag specifies the title for the track.'},
                          'track': {'docstring': "Specify the track on which to operate by using the track's trackNumber. Flag can have multiple arguments, passed either as a tuple or a list."}}},
 'autoKeyframe': {'description': 'With no flags, this command will set keyframes on all attributes that have been modified since an "autoKeyframe -state on" command was issued.  To stop keeping track of modified attributes, use "autoKeyframe -state off" autoKeyframe does not create new animation curves.  An attribute must have already been keyframed (with the setKeyframe command) for autoKeyframe to  add new keyframes for modified attributes. You can also query the current state of autoKeyframing with "autoKeyframe -query -state". ',
                  'flags': {'addAttr': {'docstring': 'Add to the list of plugs (node.attribute) that autoKeyframe is currently considering for auto keying.  This list is transient and short-lived, and is reset as soon as autoKeyframe sets the keyframe or decides that no keyframe is to be set, on completion of the next set attribute.'},
                            'characterOption': {'docstring': 'Valid options are: "standard", "all". Dictates whether when auto-keying characters the auto-key works as usual or whether it keys all of the character attributes. Default is "standard".'},
                            'edit': {'docstring': ''},
                            'listAttr': {'docstring': 'Returns the list of plugs (node.attribute) that autoKeyframe is currently considering for auto keying.  This list is transient and short-lived, and is reset as soon as autoKeyframe sets the keyframe or decides that no keyframe is to be set, on completion of the next set attribute.'},
                            'noReset': {'docstring': 'Must be used in conjunction with the state/st flag. When noReset/nr is specified, the list of plugs to be autokeyed is not cleared when the state changes'},
                            'query': {'docstring': ''},
                            'state': {'docstring': 'turns on/off remembering of modified attributes                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'autoPlace': {'description': 'This command takes a point in the centre of the current modeling pane and projects it onto the live surface. This produces a point in 3 space which is returned. If the um/useMouseflag is set the current mouse position is used rather than the centre of the modeling pane. ',
               'flags': {'useMouse': {'docstring': 'Use the current mouse position rather than the centre of the active view.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'autoSave': {'description': 'Provides an interface to the auto-save mechanism. \t         In query mode, return type is based on queried flag.',
              'flags': {'destination': {'docstring': 'Sets the option for where auto-save files go. 0 - auto-saves go into the workspace autosave folder 1 - auto-saves go into the named folder (set with the -folder flag) 2 - auto-saves go into a folder set by an environment variable (MAYA_AUTOSAVE_FOLDER)'},
                        'destinationFolder': {'docstring': "Queries the actual destination folder for auto-saves, based on the current setting of the -destination flag, workspace rules and environment variables. Resolves environment variables etc. and makes any relative path absolute (resolved relative to the workspace root). The returned string will end with a trailing separator ('/')."},
                        'enable': {'docstring': 'Enables or disables auto-saves.'},
                        'folder': {'docstring': 'Sets the folder for auto-saves used if the destination option is 1.'},
                        'interval': {'docstring': 'Sets the interval between auto-saves (in seconds). The default interval is 600 seconds (10 minutes).'},
                        'limitBackups': {'docstring': 'Sets whether the number of auto-save files is limited.'},
                        'maxBackups': {'docstring': 'Sets the maximum number of auto-save files, if limiting is in effect.'},
                        'perform': {'docstring': 'Invokes the auto-save process.'},
                        'prompt': {'docstring': 'Sets whether the auto-save prompts the user before auto-saving.                  Flag can have multiple arguments, passed either as a tuple or a list.'},
                        'query': {'docstring': ''}}},
 'backgroundEvaluationManager': {'description': 'Allows user to pause and restart background evaluations. \t         In query mode, return type is based on queried flag.',
                                 'flags': {'interrupt': {'docstring': 'Enable or disable fast interrupt of background execution during interactive workflow.'},
                                           'mode': {'docstring': 'Changes the current evaluation mode in the evaluation manager. Supported values are "serial" and "parallel".'},
                                           'pause': {'docstring': 'Pause background evaluation. Will block till background evaluation is fully stopped. Can be queried to get the current state.'},
                                           'query': {'docstring': ''},
                                           'resume': {'docstring': 'Resume background evaluation. Will start suspended evaluations unless someones else requested it. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'bakeClip': {'description': 'This command is used to bake clips and blends into a single clip. \t         ',
              'flags': {'blend': {'docstring': 'Specify the indices of the clips being blended.'},
                        'clipIndex': {'docstring': 'Specify the index of the clip to bake.'},
                        'keepOriginals': {'docstring': 'Keep original clips in the trax editor and place the merged clip into the visor. The default is to schedule the merged clip, and to keep the original clips in the visor.'},
                        'name': {'docstring': 'Specify the name of the new clip to create. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'bakeDeformer': {'description': 'Given a rigged character, whose mesh shape is determined by a set of deformers, bakeDeformer calculates linear blend skin weights most closely approximating observed deformations. To do this, a test set of examples is generated by moving the rig through a range of motion. Results mesh and pose pairs are then used to solve a constrained optimization, solving for skinning weights. bakeDeformer automatically binds and applies resulting weights to the destination geometry. If the source and destination mesh/skeleton are identical, the command will replace the original deformations with a skinCluster and computed weights. See the below examples for sample usage. \t         ',
                  'flags': {'colorizeSkeleton': {'docstring': 'The new skin cluster created will have its skeleton colorized. Must be used with the -srcSkeletonName and -dstSkeletonName flags.'},
                            'customRangeOfMotion': {'docstring': 'When this flag is specified with the frames for the range of motion to be used, the tool will step through each frame as a separate pose. Otherwise the tool will use the existing range of motion in the tool that rotates each influence 45 degrees. Usage examples:     -rom "10:20" means all frames in the range from 10 to 20, inclusive, in the current time unit. Omitting one end of a range means using either end of the animation range (or both), as in the following examples: -rom "10:" means all frames from time 10 (in the current time unit) onwards to the maximum time in the animation range (on the timeline). -rom ":10" means all frames from the minimum time on the animation range (on the timeline) up to (and including) time 10 (in the current time unit). -rom ":" is a short form to specify all frames, from minimum to maximum time on the current animation range. When using this flag, some of the joints in the specified range of motion may not have changed sufficiently. To improve bakeDeformer results or avoid algorithm errors, the command will return a list of influences that do not move enough in the specified range of motion. To detect these joints, the localtransformation of each joint is compared between subsequent frames. We consider that a joint has sufficiently changed if any of the below criteria are met:     There is a rotation of at least 5 degrees, as determined by the shortest rotation between transforms.There is a translation of 1% or greater of the size of the largest bounding box containing all joints for each frame.There is a scaling change of at least 1%. This percentage represents the smallest scaling value over the largest scaling value (in absolute value).If a joint has not met any of the criteria, it will be added to the warning of joints that have not moved enough.       The custom range of motion should be considered experimental.'},
                            'dstMeshName': {'docstring': 'The destination mesh name.'},
                            'dstSkeletonName': {'docstring': 'The destination skeleton name.'},
                            'hierarchy': {'docstring': 'All children of the passed joints that are used in the influences flag are used.'},
                            'influences': {'docstring': 'A list of joints that are used as the influences to determine new weights.'},
                            'maxInfluences': {'docstring': 'The maximum number of influences per vertex.'},
                            'pruneWeights': {'docstring': 'On the newly created skin cluster, set any weight below the given the value to zero (post-processing). This will call the skinPercent command as follows: "skinPercent -pruneWeights [value] [skinClusterName] [dstMeshName]" where [value] is the value passed into this flag, [skinClusterName] is the name of the new skinCluster node created after running this tool, and [dstMeshName] is the mesh provided in the -dstMeshName flag.'},
                            'smoothWeights': {'docstring': 'The number of smoothing iterations for smoothing weights (post-processing). This also renormalizes the remaining the weights.'},
                            'srcMeshName': {'docstring': 'The source mesh name.'},
                            'srcSkeletonName': {'docstring': 'The source skeleton name. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'bakePartialHistory': {'description': 'This command is used to bake sections of the construction history of a shape node when possible. A typical usage would be on a shape that has both modelling operations and deformers in its history. Using this command with the -prePostDeformers flag will bake the modeling portions of the graph, so that only the deformers remain. Note that not all modeling operations can be baked such that they create exactly the same effect after baking. For example, imagine the history contains a skinning operation followed by a smooth. Before baking, the smooth operation is performed each time the skin deforms, so it will smooth differently depending on the output of the skin. When the smooth operation is baked into the skinning, the skin will be reweighted based on the smooth points to attempt to approximate the original behavior. However, the skin node does not perform the smooth operation, it merely performs skinning with the newly calculated weights and the result will not be identical to before the bake. In general, modeling operations that occur before deformers can be baked precisely. Those which occur after can only be approximated. The -pre and -post flags allow you to control whether only the operations before or after the deformers are baked. When the command is used on an object with no deformers, the entire history will be deleted. \t         ',
                        'flags': {'allShapes': {'docstring': 'Specifies that the bake operation should be performed on all shapes in the entire scene. By default, only selected objects are baked. If this option is specified and there are no shapes in the scene, then this command will do nothing and end successfully.'},
                                  'edit': {'docstring': ''},
                                  'postSmooth': {'docstring': 'Specifies whether or not a smoothing operation should be done on skin vertices. This smoothing is only done on vertices that are found to deviate largely from other vertex values.  The default is false.'},
                                  'preCache': {'docstring': 'Specifies baking of any history operations that occur before the caching operation, including deformers. In query mode, returns a list of the nodes that will be baked.'},
                                  'preDeformers': {'docstring': 'Specifies baking of any modeling operations in the history that occur before the deformers. In query mode, returns a list of the nodes that will be baked.'},
                                  'prePostDeformers': {'docstring': 'Specifies baking of all modeling operations in the history whether they are before or after the deformers in the history. If neither the -prePostDeformers nor the -preDeformers flag is specified, prePostDeformers will be used as the default. In query mode, returns a list of the nodes that will be baked. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'},
                                  'query': {'docstring': ''}}},
 'bakeResults': {'description': 'This command allows the user to replace a chain of dependency nodes which define the value for an attribute with a single animation curve. Command allows the user to specify the range and frequency of sampling. This command operates on a keyset. A keyset is defined as a group of keys within a specified time range on one or more animation curves. The animation curves comprising a keyset depend on the value of the "-animation" flag: keysOrObjects: Any active keys, when no target objects or -attribute flags appear on the command line, orAll animation curves connected to all keyframable attributes of objects specified as the command line\'s targetList, when there are no active keys.keys: Only act on active keys or tangents. If there are no active keys or tangents, do not do anything. objects: Only act on specified objects. If there are no objects specified, do not do anything. Note that the "-animation" flag can be used to override the curves uniquely identified by the multi-use "-attribute" flag, which takes an argument of the form attributeName, such as "translateX". Keys on animation curves are identified by either their time values or their indices. Times and indices should be specified as a range, as shown below. -time "10:20"means all keys in the range from 10 to 20, inclusive, in the current time unit.-index "1:5"means the 2nd, 3rd, 4th, 5th, and 6th keys of each animation curve.',
                 'flags': {'animation': {'docstring': 'Where this command should get the animation to act on. Valid values are "objects," "keys," and "keysOrObjects" Default: "keysOrObjects." See command description for details.'},
                           'attribute': {'docstring': 'List of attributes to select'},
                           'bakeOnOverrideLayer': {'docstring': 'If true, all layered and baked attribute will be added as a top override layer.'},
                           'controlPoints': {'docstring': 'This flag explicitly specifies whether or not to include the control points of a shape (see "-s" flag) in the list of attributes. Default: false.  (Not valid for "pasteKey" cmd.)'},
                           'destinationLayer': {'docstring': 'This flag can be used to specify an existing layer where the baked results should be stored. Use this flag with caution. If the destination layer already has animation on it that contributes to the final result, it will be replaced by the output of the bake. As a result, it is possible that the combined animation visible in the scene is different before / after the baking process.'},
                           'disableImplicitControl': {'docstring': 'Whether to disable implicit control after the anim curves are obtained as the result of this command. An implicit control to an attribute is some function that affects the attribute without using an explicit dependency graph connection. The control of IK, via ik handles, is an example.'},
                           'edit': {'docstring': ''},
                           'float': {'docstring': 'value uniquely representing a non-time-based key (or key range) on a time-based animCurve. Valid floatRange include single values (-f 10) or a string with a lower and upper bound, separated by a colon (-f "10:20")'},
                           'hierarchy': {'docstring': 'Hierarchy expansion options.  Valid values are "above," "below," "both," and "none." (Not valid for "pasteKey" cmd.)'},
                           'includeUpperBound': {'docstring': 'When the -t/time or -f/float flags represent a range of keys, this flag determines whether the keys at the upper bound of the range are included in the keyset. Default value: true. This flag is only valid when the argument to the -t/time flag is a time range with a lower and upper bound. Note: when used with the "pasteKey" command, this flag refers only to the time range of the target curve that is replaced, when using options such as "replace," "fitReplace," or "scaleReplace." This flag has no effect on the curve pasted from the clipboard.'},
                           'index': {'docstring': 'index of a key on an animCurve'},
                           'minimizeRotation': {'docstring': 'Specify whether to minimize the local Euler component from key to key during baking of rotation channels.'},
                           'oversamplingRate': {'docstring': 'Amount of samples per sampleBy period. Default is 1.'},
                           'preserveOutsideKeys': {'docstring': 'Whether to preserve keys that are outside the bake range when there are directly connected animation curves or a pairBlend node which has an animation curve as its direct input. The default (false) is to remove frames outside the bake range. If the channel that you are baking is not controlled by a single animation curve, then a new animation curve will be created with keys only in the bake range. In the case of pairBlend-driven channels, setting pok to true will retain both the pairBlend and its input animCurve. The blended values will be baked onto the animCurve and the weight of the pairBlend weight will be keyed to the animCurve during the baked range.'},
                           'query': {'docstring': ''},
                           'removeBakedAnimFromLayer': {'docstring': 'If true, all baked animation will be removed from the layer. Otherwise all layer associated with the baked animation will be muted.'},
                           'removeBakedAttributeFromLayer': {'docstring': 'If true, all baked attribute will be removed from the layer. Otherwise all layer associated with the baked attribute will be muted.'},
                           'resolveWithoutLayer': {'docstring': 'This flag can be used to specify a list of layers to be merged together during the bake process. This is a multi-use flag. Its name refers to the fact that when solving for the value to key, it determines the proper value to key on the destination layer to achieve the same result as the merged layers.'},
                           'sampleBy': {'docstring': 'Amount to sample by. Default is 1.0 in current timeUnit.'},
                           'shape': {'docstring': 'Consider attributes of shapes below transforms as well, except "controlPoints".  Default: true.  (Not valid for "pasteKey" cmd.)'},
                           'simulation': {'docstring': 'Using this flag instructs the command to preform a simulation instead of just evaluating each attribute separately over the range of time. The simulation flag is required to bake animation that depends on the whole scene being evaluated at each time step such as dynamics. The default is false.'},
                           'smart': {'docstring': 'Specify whether to enable smart bake and the optional smart bake tolerance.'},
                           'sparseAnimCurveBake': {'docstring': 'When this is true and anim curves are being baked, do not insert any keys into areas of the curve where animation is defined. And, use as few keys as possible to bake the pre and post infinity behavior. When this is false, one key will be inserted at each time step. The default is false.'},
                           'time': {'docstring': 'time uniquely representing a key (or key range) on a time-based animCurve. See the code examples below on how to format for a single frame or frame ranges.       Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'bakeSimulation': {'description': 'This command operates on a keyset.  A keyset is defined as a group of keys within a specified time range on one or more animation curves. The animation curves comprising a keyset depend on the value of the "-animation" flag: keysOrObjects: Any active keys, when no target objects or -attribute flags appear on the command line, orAll animation curves connected to all keyframable attributes of objects specified as the command line\'s targetList, when there are no active keys.keys: Only act on active keys or tangents. If there are no active keys or tangents, don\'t do anything. objects: Only act on specified objects.  If there are no objects specified, don\'t do anything. Note that the "-animation" flag can be used to override the curves uniquely identified by the multi-use "-attribute" flag, which takes an argument of the form attributeName, such as "translateX". Keys on animation curves are identified by either their time values or their indices.  Times and indices can be given individually or as part of a list or range (see Examples). The bakeSimulation command is obsolete.  Instead, "bakeResults -simulation true" should be used.  The bakeSimulation command has retained for backwards compatibility. This command allows the user to replace a chain of dependency nodes, or implicit relationship, such as those between joints and IK handles, which define the value of an attribute, with a single animation curve. Command allows the user to specify the range and frequency of sampling. Unlike the bakeResults command, this command will actually set the time of the current scene to all the times, in sequence, inside the given time interval before it sets the time back to when it is started. As a result, it may modify the scene. In query mode, return type is based on queried flag.',
                    'flags': {'animation': {'docstring': 'Where this command should get the animation to act on.  Valid values are "objects," "keys," and "keysOrObjects" Default: "keysOrObjects."  (See Description for details.)'},
                              'attribute': {'docstring': 'List of attributes to select'},
                              'bakeOnOverrideLayer': {'docstring': 'If true, all layered and baked attributes will be added as a top override layer.'},
                              'controlPoints': {'docstring': 'This flag explicitly specifies whether or not to include the control points of a shape (see "-s" flag) in the list of attributes. Default: false.  (Not valid for "pasteKey" cmd.)'},
                              'destinationLayer': {'docstring': 'This flag can be used to specify an existing layer where the baked results should be stored.'},
                              'disableImplicitControl': {'docstring': 'Whether to disable implicit control after the anim curves are obtained as the result of this command. An implicit control to an attribute is some function that affects the attribute without using an explicit dependency graph connection. The control of IK, via ik handles, is an example.'},
                              'edit': {'docstring': ''},
                              'float': {'docstring': 'value uniquely representing a non-time-based key (or key range) on a time-based animCurve.  Valid floatRange include single values (-f 10) or a string with a lower and upper bound, separated by a colon (-f "10:20")'},
                              'hierarchy': {'docstring': 'Hierarchy expansion options.  Valid values are "above," "below," "both," and "none." (Not valid for "pasteKey" cmd.)'},
                              'includeUpperBound': {'docstring': 'When the -t/time or -f/float flags represent a range of keys, this flag determines whether the keys at the upper bound of the range are included in the keyset. Default value: true.  This flag is only valid when the argument to the -t/time flag is a time range with a lower and upper bound.  (When used with the "pasteKey" command, this flag refers only to the time range of the target curve that is replaced, when using options such as "replace," "fitReplace," or "scaleReplace."  This flag has no effect on the curve pasted from the clipboard.)'},
                              'index': {'docstring': 'index of a key on an animCurve'},
                              'minimizeRotation': {'docstring': 'Specify whether to minimize the local euler component from key to key during baking of rotation channels.'},
                              'oversamplingRate': {'docstring': ''},
                              'preserveOutsideKeys': {'docstring': 'Whether to preserve keys that are outside the bake range when there are directly connected animation curves.  The default (false) is to remove frames outside the bake range.  If the channel that you are baking is not controlled by a single animation curve, then a new animation curve will be created with keys only in the bake range.'},
                              'query': {'docstring': ''},
                              'removeBakedAnimFromLayer': {'docstring': 'If true, all baked animation will be removed from the layer.'},
                              'removeBakedAttributeFromLayer': {'docstring': 'If true, all baked attributes will be removed from the layer.'},
                              'resolveWithoutLayer': {'docstring': 'This flag can be used to specify a list of layers to be merged together during the bake process. This is a multi-use flag. Its name refers to the fact that when solving for the value to key, it determines the proper value to key on the destination layer to achieve the same result as the merged layers.'},
                              'sampleBy': {'docstring': 'Amount to sample by. Default is 1.0 in current timeUnit'},
                              'shape': {'docstring': 'Consider attributes of shapes below transforms as well, except "controlPoints".  Default: true.  (Not valid for "pasteKey" cmd.)'},
                              'simulation': {'docstring': 'Using this flag instructs the command to preform a simulation instead of just evaluating each attribute separately over the range of time. The simulation flag is required to bake animation that that depends on the whole scene being evaluated at each time step such as dynamics. The default is true.'},
                              'smart': {'docstring': 'Specify whether to enable smart bake and the optional smart bake tolerance.'},
                              'sparseAnimCurveBake': {'docstring': 'When baking anim curves, do not insert any keys into areas of the curve where animation is defined.  And, use as few keys as possible to bake the pre and post infinity behaviors.  When this is false, one key will be inserted at each time step.  The default is false.'},
                              'time': {'docstring': 'time uniquely representing a key (or key range) on a time-based animCurve. See the code examples below on how to format for a single frame or frame ranges.       Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'baseTemplate': {'description': 'This is the class for the commands that edit and/or query templates. \t         In query mode, return type is based on queried flag.',
                  'flags': {'edit': {'docstring': ''},
                            'exists': {'docstring': 'Returns true or false depending upon whether the specified template exists. When used with the matchFile argument, the query will return true if the template exists and the filename it was loaded from matches the filename given.'},
                            'fileName': {'docstring': 'Specifies the filename associated with the template.  This argument can be used in conjunction with load, save or query modes. If no filename is associated with a template, a default file name based on the template name will be used.  It is recommended but not required that the filename and template name correspond.'},
                            'force': {'docstring': 'This flag is used with some actions to allow them to proceed with an overwrite or destructive operation. When used with load, it will allow an existing template to be reloaded from a file.  When used in create mode, it will allow an existing template to be recreated (for example when using fromContainer argument to regenerate a template).'},
                            'load': {'docstring': 'Load an existing template from a file. If a filename is specified for the template, the entire file (and all templates in it) will be loaded. If no file is specified, a default filename will be assumed, based on the template name.'},
                            'matchFile': {'docstring': 'Used in query mode in conjunction with other flags this flag specifies an optional file name that is to be matched as part of the query operation.'},
                            'query': {'docstring': ''},
                            'silent': {'docstring': 'Silent mode will suppress any error or warning messages that would normally be reported from the command execution.  The return values are unaffected.'},
                            'unload': {'docstring': 'Unload the specified template.  This action will not delete the associated template file if one exists, it merely removes the template definition from the current session.'},
                            'viewList': {'docstring': 'Used in query mode, returns a list of all views defined on the template. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'baseView': {'description': "A view defines the layout information for the attributes of a particular node type or container.  Views can be selected from a set of built-in views or may be defined on an associated container template. This command queries the view-related information for a container node or for a given template.  The information returned from this command will be based on the view-related settings in force on the container node at the time of the query (i.e. the container's view mode, template name, view name attributes), when applicable. \t         In query mode, return type is based on queried flag.",
              'flags': {'edit': {'docstring': ''},
                        'itemInfo': {'docstring': "Used in query mode in conjunction with the itemList flag. The command will return a list of information for each item in the view, the information fields returned for each item are determined by this argument value. The information fields will be listed in the string array returned. The order in which the keyword is specified will determine the order in which the data will be returned by the command. One or more of the following keywords, separated by colons ':' are used to specify the argument value. itemIndex  : sequential item number (0-based)itemName   : item name (string)itemLabel  : item display label (string)itemDescription : item description field (string)itemLevel  : item hierarchy level (0-n)itemIsGroup : (boolean 0 or 1) indicates whether or not this item is a groupitemIsAttribute : (boolean 0 or 1) indicates whether or not this item is an attributeitemNumChildren: number of immediate children (groups or attributes) of this itemitemAttrType : item attribute type (string)itemCallback : item callback field (string)"},
                        'itemList': {'docstring': 'Used in query mode, the command will return a list of information for each item in the view.  The viewName flag is used to select the view to query. The information returned about each item is determined by the itemInfo argument value. For efficiency, it is best to query all necessary item information at one time (to avoid recomputing the view information on each call).'},
                        'query': {'docstring': ''},
                        'viewDescription': {'docstring': 'Used in query mode, returns the description field associated with the selected view. If no description was defined for this view, the value will be empty.'},
                        'viewLabel': {'docstring': 'Used in query mode, returns the display label associated with the view. An appropriate label suitable for the user interface will be returned based on the selected view.  Use of the view label is usually more suitable than the view name for display purposes.'},
                        'viewList': {'docstring': 'Used in query mode, command will return a list of all views defined for the given target (container or template).'},
                        'viewName': {'docstring': 'Used in query mode, specifies the name of the queried view when used in conjunction with a template target. When used in conjunction with a container target, it requires no string argument, and returns the name of the currently active view associated with the container; this value may be empty if the current view is not a valid template view or is generated by one of the built-in views modes. For this reason, the view label is generally more suitable for display purposes. In query mode, this flag can accept a value.Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'batchRender': {'description': "The batchRender command is used to spawn off a separate rendering session of the current maya file. If no mayaFile is specified, it'll ask you whether you want the current job killed. The batchRender will spawn a separate maya process in which commands will be communicated to it through a commandPort. If Maya is unable to find an available port an error will be produced. Maya will attempt to use ports 7835 through 7844. ",
                 'flags': {'filename': {'docstring': 'Filename to be rendered; if empty, a temporary filename will be created.'},
                           'melCommand': {'docstring': 'Mel command to execute to run a renderer other than the software renderer.'},
                           'numProcs': {'docstring': 'Number of processors to use (0 means use all available processors).'},
                           'preRenderCommand': {'docstring': 'Command to be run prior to invoking a batch render.'},
                           'remoteRenderMachine': {'docstring': 'Name of remote render machine. Not available on Windows.'},
                           'renderCommandOptions': {'docstring': 'Arguments to the render command for batch rendering.'},
                           'showImage': {'docstring': 'Show progress of the current rendering job.'},
                           'status': {'docstring': 'Status string for displaying the batch render status.'},
                           'useRemoteRender': {'docstring': 'If remote rendering is desired. Not available on Windows.'},
                           'useStandalone': {'docstring': 'Batch rendering is to be done by exporting the scene and rendering with a standalone renderer.'},
                           'verbosity': {'docstring': 'Defines the verbosity level to report the batch rendering status:1: display only one start message, then one message when all frames are rendered.2: display only start and end frame messages.3: display all messages (default).Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'bevel': {'description': 'The bevel command creates a new bevel surface for the specified curve. The curve can be any nurbs curves. ',
           'flags': {'bevelShapeType': {'docstring': 'Shape type: 1 - straight cut, 2 - curve out, 3 - curve in Default:1'},
                     'caching': {'docstring': 'Toggle caching for all attributes so that no recomputation is needed'},
                     'constructionHistory': {'docstring': 'Turn the construction history on or off.'},
                     'cornerType': {'docstring': 'Corner type: 1 - linear, 2 - circular Default:2'},
                     'depth': {'docstring': 'The depth for bevel Default:0.5'},
                     'edit': {'docstring': ''},
                     'extrudeDepth': {'docstring': 'The extrude depth for bevel Default:1.0'},
                     'frozen': {'docstring': ''},
                     'joinSurfaces': {'docstring': 'Attach bevelled surfaces into one surface for each input curve. Default:true'},
                     'name': {'docstring': 'Sets the name of the newly-created node. If it contains namespace path, the new node will be created under the specified namespace; if the namespace does not exist, it will be created.'},
                     'nodeState': {'docstring': "Maya dependency nodes have 6 possible states. The Normal (0), HasNoEffect (1), and Blocking (2)states can be used to alter how the graph is evaluated.   The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)are for internal use only. They temporarily shut off parts of the graph during interaction (e.g., manipulation). The understanding is that once the operation is done, the state will be reset appropriately, e.g. Waiting-Blockingwill reset back to Blocking.   The Normaland Blockingcases apply to all nodes, while HasNoEffectis node specific; many nodes do not support this option. Plug-ins store state in the MPxNode::stateattribute. Anyone can set it or check this attribute.  Additional details about each of these 3 states follow.  StateDescriptionNormalThe normal node state. This is the default.HasNoEffectThe HasNoEffectoption (a.k.a. pass-through), is used in cases where there is an operation on an input producing an output of the same data type. Nearly all deformers support this state, as do a few other nodes. As stated earlier, it is not supported by all nodes.  Itâ€™s typical to implement support for the HasNoEffectstate in the nodeâ€™s compute method and to perform appropriate operations. Plug-ins can also support HasNoEffect.  The usual implementation of this state is to copy the input directly to the matching output without applying the algorithm in the node. For deformers, applying this state leaves the input geometry undeformed on the output.  BlockingThis is implemented in the depend node base class and applies to all nodes. Blockingis applied during the evaluation phase to connections. An evaluation request to a blocked connection will return as failures, causing the destination plug to retain its current value. Dirty propagation is indirectly affected by this state since blocked connections are never cleaned.  When a node is set to Blockingthe behavior is supposed to be the same as if all outgoing connections were broken. As long as nobody requests evaluation of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked node will still respond to getAttrrequests but a getAttron a downstream node will not reevaluate the blocked node.  Setting the root transform of a hierarchy to Blockingwonâ€™t automatically influence child transforms in the hierarchy. To do this, youâ€™d need to explicitly set all child nodes to the Blockingstate.  For example, to set all child transforms to Blocking, you could use the following script.  import maya.cmds as cmds def blockTree(root): nodesToBlock = [] for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys(): nodesToBlock += cmds.listConnections(node, source=True, destination=True ) for node in {source:1 for source in nodesToBlock}.keys(): cmds.setAttr( '%s.nodeState' % node, 2 )  Applying this script would continue to draw objects but things would not be animated.  Default:kdnNormal"},
                     'numberOfSides': {'docstring': 'How to apply the bevel. 1 - no bevels2 - bevel at start only3 - bevel at end only4 - bevel at start and endDefault:4'},
                     'object': {'docstring': 'Create the result, or just the dependency node.'},
                     'polygon': {'docstring': 'The value of this argument controls the type of the object created by this operation 0: nurbs surface1: polygon (use nurbsToPolygonsPref to set the parameters for the conversion)2: subdivision surface (use nurbsToSubdivPref to set the parameters for the conversion)3: Bezier surface4: subdivision surface solid (use nurbsToSubdivPref to set the parameters for the conversion)'},
                     'query': {'docstring': ''},
                     'range': {'docstring': 'Force a curve range on complete input curve.                  Flag can have multiple arguments, passed either as a tuple or a list.'},
                     'tolerance': {'docstring': 'The tolerance for bevel offsets Default:0.01'},
                     'width': {'docstring': 'The width for bevel Default:0.5                  Common flags'}}},
 'bevelPlus': {'description': 'The bevelPlus command creates a new bevel surface for the specified curves using a given style curve. The first curve should be the "outside" curve, and the (optional) rest of them should be inside of the first one. For predictable results, the curves should be planar and all in the same plane. ',
               'flags': {'bevelInside': {'docstring': 'If true, ensure surface always remains within the original profile curve Default:false'},
                         'caching': {'docstring': ''},
                         'capSides': {'docstring': 'How to cap the bevel. 1 - no caps2 - cap at start only3 - cap at end only4 - cap at start and endDefault:4'},
                         'constructionHistory': {'docstring': 'Turn the construction history on or off.'},
                         'depth': {'docstring': ''},
                         'edit': {'docstring': ''},
                         'extrudeDepth': {'docstring': ''},
                         'frozen': {'docstring': ''},
                         'innerStyle': {'docstring': 'Similar to outerStyle, this style is applied to all but the first (outer) curve specified.'},
                         'joinSurfaces': {'docstring': 'Attach bevelled surfaces into one surface for each input curve. Default:true'},
                         'name': {'docstring': 'Sets the name of the newly-created node. If it contains namespace path, the new node will be created under the specified namespace; if the namespace does not exist, it will be created.'},
                         'nodeState': {'docstring': ''},
                         'normalsOutwards': {'docstring': 'If enabled, the normals point outwards on the resulting NURBS or poly surface.'},
                         'numberOfSides': {'docstring': 'How to apply the bevel. 1 - no bevels2 - bevel at start only3 - bevel at end only4 - bevel at start and endDefault:4'},
                         'outerStyle': {'docstring': 'Choose a style to use for the bevel of the first (outer) curve.  There are 15 predefined styles (values 0 to 14 can be used to select them). For those experienced with MEL, you can, after the fact, specify a custom curve and use it for the style curve. See the documentation for styleCurve node to see what requirements a style curve must satisfy.'},
                         'polyOutChordHeight': {'docstring': ''},
                         'polyOutChordHeightRatio': {'docstring': ''},
                         'polyOutCount': {'docstring': ''},
                         'polyOutCurveSamples': {'docstring': ''},
                         'polyOutCurveType': {'docstring': ''},
                         'polyOutExtrusionSamples': {'docstring': ''},
                         'polyOutExtrusionType': {'docstring': ''},
                         'polyOutMethod': {'docstring': ''},
                         'polyOutUseChordHeight': {'docstring': ''},
                         'polyOutUseChordHeightRatio': {'docstring': ''},
                         'polygon': {'docstring': 'The value of this argument controls the type of the object created by this operation 0: nurbs surface1: polygon (use nurbsToPolygonsPref to set the parameters for the conversion)2: subdivision surface (use nurbsToSubdivPref to set the parameters for the conversion)3: Bezier surface4: subdivision surface solid (use nurbsToSubdivPref to set the parameters for the conversion)'},
                         'query': {'docstring': ''},
                         'range': {'docstring': 'Force a curve range on complete input curve.                  Flag can have multiple arguments, passed either as a tuple or a list.'},
                         'tolerance': {'docstring': ''},
                         'width': {'docstring': ''}}},
 'bezierAnchorPreset': {'description': 'This command provides a queryable interface for Bezier curve shapes. ',
                        'flags': {'preset': {'docstring': 'Selects a preset to apply to selected Bezier anchors. Valid arguments are:  0: Bezier 1: Bezier Corner 2: Corner                   Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'bezierAnchorState': {'description': 'The bezierAnchorState command provides an easy interface to modify anchor states: - Smooth/Broken anchor tangents - Even/Uneven weighted anchor tangents ',
                       'flags': {'even': {'docstring': 'Sets selected anchors (or attached tangent handles) to even weighting when true, uneven otherwise.'},
                                 'smooth': {'docstring': 'Sets selected anchors (or attached tangent handles) to smooth when true, broken otherwise.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'bezierCurveToNurbs': {'description': 'The bezierCurveToNurbs command attempts to convert an existing NURBS curve to a Bezier curve. ',
                        'flags': {}},
 'bezierInfo': {'description': 'This command provides a queryable interface for Bezier curve shapes. ',
                'flags': {'anchorFromCV': {'docstring': 'Returns the Bezier anchor index from a given CV index'},
                          'cvFromAnchor': {'docstring': 'Returns the CV index for a given Bezier anchor index'},
                          'isAnchorSelected': {'docstring': 'Returns 1 if an anchor CV is currently selected. 0, otherwise.'},
                          'isTangentSelected': {'docstring': 'Returns 1 if a tangent CV is currently selected. 0, otherwise.'},
                          'onlyAnchorsSelected': {'docstring': 'Returns 1 if the only CV components selected are anchor CVs. 0, otherwise.'},
                          'onlyTangentsSelected': {'docstring': 'Returns 1 if the only CV components selected are tangent CVs. 0, otherwise.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'binMembership': {'description': 'Command to assign nodes to bins. \t         ',
                   'flags': {'addToBin': {'docstring': 'Add the nodes in a node list to a bin.'},
                             'exists': {'docstring': 'Query if a node exists in a bin.  The exists flag can take only one node.'},
                             'inheritBinsFromNodes': {'docstring': "Let the node in the flag's argument inherit bins from nodes in the specified node list.  The node list is specified as the object of the command."},
                             'isValidBinName': {'docstring': 'Query if the specified bin name is valid.  If so, return true. Otherwise, return false.'},
                             'listBins': {'docstring': 'Query and return a list of bins a list of nodes belong to. If a bin contains any of the nodes in the selection list, then it should be included in the returned bin list.'},
                             'makeExclusive': {'docstring': 'Make the specified nodes belong exclusively in the specified bin.'},
                             'notifyChanged': {'docstring': 'This flag is used to notify that binMembership has been changed.'},
                             'query': {'docstring': ''},
                             'removeFromBin': {'docstring': 'Remove the nodes in a node list from a bin. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'bindSkin': {'description': 'This command binds the currently selected objects to the currently selected skeletons.  Shapes which can be bound are: meshes, nurbs curves, nurbs surfaces, lattices, subdivision surfaces, and API shapes. Multiple shapes and multiple skeletons can be bound at once by selecting them or specifying them on the command line. Selection order is not important.The skin is bound using the so-called "rigid" bind, in which the components are rigidly attached to the closest bone in the skeleton. Flexors can later be added to the skeleton to smooth out the skinning around joints.The skin(s) can be bound either to the entire skeleton hierarchy of the selected joint(s), or to only the selected joints. The entire hierarchy is the default. The -tsb/-toSelectedBones flag allows binding to only the selected bones.This command can also be used to detach the skin from the skeleton. Detaching the skin is useful in a variety of situations, such as: inserting additional bones, deleting bones, changing the bind position of the skeleton or skin, or simply getting rid of the skinning nodes altogether. The options to use when detaching the skin depend on how much of the skinning info you want to get rid of. Namely: (1) -delete or -unbind: remove all skinning nodes, (2) -unbindKeepHistory: remove the skinning sets, but keep the weights, (3) -disable: disable the skinning but keep the skinning sets and the weights.',
              'flags': {'byClosestPoint': {'docstring': 'bind each point in the object to the segment closest to the point. The byClosestPoint and byPartition flags are mutually exclusive.  The byClosestPoint flag is the default.'},
                        'byPartition': {'docstring': "bind each group in the partition to the segment closest to the group's centroid. A partition must be specified with the -p/-partition flag"},
                        'colorJoints': {'docstring': "In bind mode, this flag assigns colors to the joints based on the colors assigned to the joint's skin set. In delete and unlock mode, this flag removes the colors from joints that are no longer bound as skin. In disable and unbindKeepHistory mode, this flag does nothing."},
                        'delete': {'docstring': 'Detach the skin on the selected skeletons and remove all bind- related construction history.'},
                        'doNotDescend': {'docstring': 'Do not descend to shapes that are parented below the selected object(s). Bind only the selected objects.'},
                        'edit': {'docstring': ''},
                        'enable': {'docstring': 'Enable or disable a bind that has been disabled on the selected skeletons. To enable the bind on selected bones only, select the bones and use the -tsb flag with the -en flag. This flag is used when you want to temporarily disable the bind without losing the set information or the weight information of the skinning, for example if you want to modify the bindPose.'},
                        'name': {'docstring': 'This flag is obsolete.'},
                        'partition': {'docstring': 'Specify a partition to bind by. This is only valid when used with the -bp/-byPartition flag.'},
                        'query': {'docstring': ''},
                        'toAll': {'docstring': 'objects will be bound to the entire selected skeletons. Even bones with zero influence will be bound, whereas the toSkeleton will only bind non-zero influences.'},
                        'toSelectedBones': {'docstring': 'objects will be bound to the selected bones only.'},
                        'toSkeleton': {'docstring': 'objects will be bound to the selected skeletons. The toSkeleton, toAll and toSelectedBones flags are mutually exclusive. The toSkeleton flag is the default.'},
                        'unbind': {'docstring': 'unbind the selected objects. They will no longer move with the skeleton. Any bindSkin history that is no longer used will be deleted.'},
                        'unbindKeepHistory': {'docstring': 'unbind the selected objects. They will no longer move with the skeleton. However, existing weights on the skin will be kept for use the next time the skin is bound. This option is appropriate if you want to modify the skeleton without losing the weighting information on the skin.'},
                        'unlock': {'docstring': 'unlock the selected objects. Since bindSkin will no longer give normal results if bound objects are moved away from the skeleton, bindSkin locks translate, rotate and scale. This command unlocks the selected objects translate, rotate and scale.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'blend': {'description': '',
           'flags': {'autoDirection': {'docstring': ''},
                     'caching': {'docstring': ''},
                     'constructionHistory': {'docstring': ''},
                     'crvsInFirstRail': {'docstring': ''},
                     'edit': {'docstring': ''},
                     'flipLeft': {'docstring': ''},
                     'flipRight': {'docstring': ''},
                     'frozen': {'docstring': ''},
                     'leftParameter': {'docstring': ''},
                     'multipleKnots': {'docstring': ''},
                     'name': {'docstring': ''},
                     'nodeState': {'docstring': ''},
                     'object': {'docstring': ''},
                     'polygon': {'docstring': ''},
                     'positionTolerance': {'docstring': ''},
                     'query': {'docstring': ''},
                     'rightParameter': {'docstring': ''},
                     'tangentTolerance': {'docstring': ''}}},
 'blend2': {'description': 'This command creates a surface by blending between given curves. This is an enhancement (more user control) compared to blend which is now obsolete. ',
            'flags': {'autoAnchor': {'docstring': 'If true and both paths are closed, automatically determine the value on the right rail so that they match Default:true'},
                      'autoNormal': {'docstring': 'If true, the direction of each starting tangent is computed based on given geometry. Default:true'},
                      'caching': {'docstring': 'Toggle caching for all attributes so that no recomputation is needed'},
                      'constructionHistory': {'docstring': 'Turn the construction history on or off.'},
                      'crvsInFirstRail': {'docstring': 'Number of curves in the first rail of the blend.'},
                      'edit': {'docstring': ''},
                      'flipLeftNormal': {'docstring': 'If true, flip the starting tangent off the left boundary. Default:false'},
                      'flipRightNormal': {'docstring': 'If true, flip the starting tangent off the right boundary. Default:false'},
                      'frozen': {'docstring': ''},
                      'leftAnchor': {'docstring': 'The reference parameter on the left boundary where the blend surface starts in the case of the closed rail. Default:0.0'},
                      'leftEnd': {'docstring': 'The reference parameter on the left boundary where the blend surface ends. Default:1.0'},
                      'leftStart': {'docstring': 'The reference parameter on the left boundary where the blend surface starts. Default:0.0'},
                      'multipleKnots': {'docstring': 'If true, use the new blend which produces fully multiple interior knots Default:true'},
                      'name': {'docstring': 'Sets the name of the newly-created node. If it contains namespace path, the new node will be created under the specified namespace; if the namespace does not exist, it will be created.'},
                      'nodeState': {'docstring': "Maya dependency nodes have 6 possible states. The Normal (0), HasNoEffect (1), and Blocking (2)states can be used to alter how the graph is evaluated.   The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)are for internal use only. They temporarily shut off parts of the graph during interaction (e.g., manipulation). The understanding is that once the operation is done, the state will be reset appropriately, e.g. Waiting-Blockingwill reset back to Blocking.   The Normaland Blockingcases apply to all nodes, while HasNoEffectis node specific; many nodes do not support this option. Plug-ins store state in the MPxNode::stateattribute. Anyone can set it or check this attribute.  Additional details about each of these 3 states follow.  StateDescriptionNormalThe normal node state. This is the default.HasNoEffectThe HasNoEffectoption (a.k.a. pass-through), is used in cases where there is an operation on an input producing an output of the same data type. Nearly all deformers support this state, as do a few other nodes. As stated earlier, it is not supported by all nodes.  Itâ€™s typical to implement support for the HasNoEffectstate in the nodeâ€™s compute method and to perform appropriate operations. Plug-ins can also support HasNoEffect.  The usual implementation of this state is to copy the input directly to the matching output without applying the algorithm in the node. For deformers, applying this state leaves the input geometry undeformed on the output.  BlockingThis is implemented in the depend node base class and applies to all nodes. Blockingis applied during the evaluation phase to connections. An evaluation request to a blocked connection will return as failures, causing the destination plug to retain its current value. Dirty propagation is indirectly affected by this state since blocked connections are never cleaned.  When a node is set to Blockingthe behavior is supposed to be the same as if all outgoing connections were broken. As long as nobody requests evaluation of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked node will still respond to getAttrrequests but a getAttron a downstream node will not reevaluate the blocked node.  Setting the root transform of a hierarchy to Blockingwonâ€™t automatically influence child transforms in the hierarchy. To do this, youâ€™d need to explicitly set all child nodes to the Blockingstate.  For example, to set all child transforms to Blocking, you could use the following script.  import maya.cmds as cmds def blockTree(root): nodesToBlock = [] for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys(): nodesToBlock += cmds.listConnections(node, source=True, destination=True ) for node in {source:1 for source in nodesToBlock}.keys(): cmds.setAttr( '%s.nodeState' % node, 2 )  Applying this script would continue to draw objects but things would not be animated.  Default:kdnNormal"},
                      'object': {'docstring': 'Create the result, or just the dependency node.'},
                      'polygon': {'docstring': 'The value of this argument controls the type of the object created by this operation 0: nurbs surface1: polygon (use nurbsToPolygonsPref to set the parameters for the conversion)2: subdivision surface (use nurbsToSubdivPref to set the parameters for the conversion)3: Bezier surface4: subdivision surface solid (use nurbsToSubdivPref to set the parameters for the conversion)Flag can have multiple arguments, passed either as a tuple or a list.'},
                      'positionTolerance': {'docstring': 'The positional C(0) tolerance of the blend surface to the adjacent surfaces. Default:0.1'},
                      'query': {'docstring': ''},
                      'reverseLeft': {'docstring': 'If true, reverse the direction off the left boundary.  autoDirection must be false for this value to be considered. Default:false'},
                      'reverseRight': {'docstring': 'If true, reverse the direction of the right boundary.  autoDirection must be false for this value to be considered. Default:false'},
                      'rightAnchor': {'docstring': 'The reference parameter on the right boundary where the blend surface starts in the case of the closed rail. Default:0.0'},
                      'rightEnd': {'docstring': 'The reference parameter on the right boundary where the blend surface ends. Default:1.0'},
                      'rightStart': {'docstring': 'The reference parameter on the right boundary where the blend surface starts. Default:0.0'},
                      'tangentTolerance': {'docstring': 'The tangent G(1) continuity tolerance of the blend surface to the adjacent surfaces. Default:0.1                  Common flags'}}},
 'blendCtx': {'description': '',
              'flags': {'activeNodes': {'docstring': ''},
                        'autoCreate': {'docstring': ''},
                        'autoDirection': {'docstring': ''},
                        'caching': {'docstring': ''},
                        'constructionHistory': {'docstring': ''},
                        'crvsInFirstRail': {'docstring': ''},
                        'edit': {'docstring': ''},
                        'exists': {'docstring': ''},
                        'flipLeft': {'docstring': ''},
                        'flipRight': {'docstring': ''},
                        'frozen': {'docstring': ''},
                        'image1': {'docstring': ''},
                        'image2': {'docstring': ''},
                        'image3': {'docstring': ''},
                        'immediate': {'docstring': ''},
                        'leftParameter': {'docstring': ''},
                        'multipleKnots': {'docstring': ''},
                        'name': {'docstring': ''},
                        'nodeState': {'docstring': ''},
                        'object': {'docstring': ''},
                        'polygon': {'docstring': ''},
                        'positionTolerance': {'docstring': ''},
                        'query': {'docstring': ''},
                        'reset': {'docstring': ''},
                        'rightParameter': {'docstring': ''},
                        'tangentTolerance': {'docstring': ''},
                        'toolNode': {'docstring': ''},
                        'useGlobalTol': {'docstring': ''}}},
 'blendShape': {'description': 'This command creates a blendShape deformer, which blends in specified amounts of each target shape to the initial base shape. Each base shape is deformed by its own set of target shapes. Every target shape has an index that associates it with one of the shape weight values.In the create mode the first item on the selection list is treated as the base and the remaining inputs as targets. If the first item on the list has multiple shapes grouped beneath it, the targets must have an identical shape hierarchy. Additional base shapes can be added in edit mode using the deformers -g flag. ',
                'flags': {'after': {'docstring': 'If the default behavior for insertion/appending into/onto the existing chain is not the desired behavior then this flag can be used to force the command to place the deformer node after the selected node in the chain even if a new geometry shape has to be created in order to do so. Works in create mode (and edit mode if the deformer has no geometry added yet).'},
                          'afterReference': {'docstring': 'The -afterReference flag is used to specify deformer ordering in a hybrid way that choses between -before and -after automatically. If the geometry being deformed is referenced then the -after mode is used when adding the new deformer, otherwise the -before mode is used. The net effect when using -afterReference to build deformer chains is that internal shape nodes in the deformer chain will only appear at reference file boundaries, leading to lightweight deformer networks that may be more amicable to reference swapping.'},
                          'automatic': {'docstring': 'The -automatic flag is used to specify deformer ordering in a way that choses between -frontOfChain and -before automatically. If the geometry being deformed is only affected by invertible deformers, the -frontOfChain mode is used, otherwise the -before mode is used.'},
                          'before': {'docstring': 'If the default behavior for insertion/appending into/onto the existing chain is not the desired behavior then this flag can be used to force the command to place the deformer node before the selected node in the chain even if a new geometry shape has to be created in order to do so. Works in create mode (and edit mode if the deformer has no geometry added yet).'},
                          'copyDelta': {'docstring': 'Set the base, source, and destination delta index values.'},
                          'copyInBetweenDelta': {'docstring': 'Set the base, target, source, and destination delta index values.'},
                          'deformerTools': {'docstring': 'Returns the name of the deformer tool objects (if any) as string string ...'},
                          'edit': {'docstring': ''},
                          'envelope': {'docstring': 'Set the envelope value for the deformer, controlling how much of the total deformation gets applied. Default is 1.0.'},
                          'exclusive': {'docstring': 'Puts the deformation set in a deform partition.'},
                          'export': {'docstring': 'Export the shapes to the named file path.'},
                          'exportTarget': {'docstring': 'Specify the base and target index pairs for the export.'},
                          'flipTarget': {'docstring': 'Flip the list of base and target pairs.'},
                          'frontOfChain': {'docstring': "This command is used to specify that the new deformer node should be placed ahead (upstream) of existing deformer and skin nodes in the shape's history (but not ahead of existing tweak nodes). The input to the deformer will be the upstream shape rather than the visible downstream shape, so the behavior of this flag is the most intuitive if the downstream deformers are in their reset (hasNoEffect) position when the new deformer is added. Works in create mode (and edit mode if the deformer has no geometry added yet)."},
                          'geometry': {'docstring': 'The specified object will be added to the list of objects being deformed by this deformer object, unless the -rm flag is also specified. When queried, this flag returns string string string ...'},
                          'geometryIndices': {'docstring': 'Complements the -geometry flag in query mode. Returns the multi index of each geometry.'},
                          'ignoreSelected': {'docstring': 'Tells the command to not deform objects on the current selection list'},
                          'inBetween': {'docstring': 'Indicate that the specified target should serve as an inbetween. An inbetween target is one that serves as an intermediate target between the base shape and another target.'},
                          'inBetweenIndex': {'docstring': 'Only used with the -rtd/-resetTargetDelta flag to remove delta values for points in the inbetween target geometry defined by this index.'},
                          'inBetweenType': {'docstring': 'Specify if the in-between target to be created is relative to the hero target or if it is absolute. If it is relative to hero targets, the in-between target will get any changes made to the hero target. Valid values are "relative" and "absolute". This flag should always be used with the -ib/-inBetween and -t/-target flags.'},
                          'includeHiddenSelections': {'docstring': 'Apply the deformer to any visible and hidden objects in the selection list. Default is false.'},
                          'ip': {'docstring': 'Import the shapes from the named file path.'},
                          'mergeSource': {'docstring': 'List of source indexes for a merge.'},
                          'mergeTarget': {'docstring': 'Target index of a merge'},
                          'mirrorDirection': {'docstring': 'Mirror direction; 0 = negative, 1 = positive'},
                          'mirrorTarget': {'docstring': 'Mirror the list of base and target pairs.'},
                          'name': {'docstring': 'Used to specify the name of the node being created.'},
                          'normalizationGroups': {'docstring': 'Returns a list of the used normalization group IDs.'},
                          'origin': {'docstring': 'blendShape will be performed with respect to the world by default. Valid values are "world" and "local". The local flag will cause the blend shape to be performed with respect to the shape\'s local origin.'},
                          'parallel': {'docstring': 'Inserts the new deformer in a parallel chain to any existing deformers in the history of the object. A blendShape is inserted to blend the parallel results together. Works in create mode (and edit mode if the deformer has no geometry added yet).'},
                          'prune': {'docstring': 'Removes any points not being deformed by the deformer in its current configuration from the deformer set.'},
                          'query': {'docstring': ''},
                          'remove': {'docstring': 'Specifies that objects listed after the -g flag should be removed from this deformer.'},
                          'resetTargetDelta': {'docstring': 'Remove all delta values for points in the target geometry, including all sequential targets defined by target index. Parameter list: uint: the base object indexuint: the target index'},
                          'split': {'docstring': 'Branches off a new chain in the dependency graph instead of inserting/appending the deformer into/onto an existing chain. Works in create mode (and edit mode if the deformer has no geometry added yet).'},
                          'suppressDialog': {'docstring': 'Suppress dialog box and run the command as defined by the user.'},
                          'symmetryAxis': {'docstring': 'Axis for symmetry. Valid values are "X", "Y", and "Z".'},
                          'symmetryEdge': {'docstring': 'One or two symmetry edge names, separated by a ".". See the blendShape node\'s symmetryEdge attribute for legal values.'},
                          'symmetrySpace': {'docstring': 'Space for symmetry. 0 = Topological, 1 = Object, 2 = UV'},
                          'tangentSpace': {'docstring': 'Indicate that the delta of the specified target should be relative to the tangent space of the surface.'},
                          'target': {'docstring': 'Set target object as the index target shape for the base shape base object. The full influence of target shape takes effect when its shape weight is targetValue. Parameter list: string: the base objectint: indexstring: the target objectdouble: target value'},
                          'topologyCheck': {'docstring': 'Set the state of checking for a topology match between the shapes being blended. Default is on.'},
                          'transform': {'docstring': 'Set transform for target, then the deltas will become relative to a post transform. Typically the best workflow for this option is to choose a joint that is related to the fix you have introduced. This flag should be used only if the "Deformation order" of blendShape node is "Before".'},
                          'useComponentTags': {'docstring': 'When this flag is specified a setup using componentTags will be created. This means no groupId, groupParts, tweak or objectSet nodes will be created and connected to the new deformer.'},
                          'weight': {'docstring': 'Set the weight value (second parameter) at index (first parameter).'},
                          'weightCount': {'docstring': 'Set the number of shape weight values.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'blendShapeEditor': {'description': 'This command creates an editor that derives from the base editor class that has controls for blendShape, control nodes. ',
                      'flags': {'control': {'docstring': 'Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus. Caution: It is possible for an editor to exist without a control. The query will return "NONE" if no control is present.'},
                                'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                                'docTag': {'docstring': 'Attaches a tag to the editor.'},
                                'edit': {'docstring': ''},
                                'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                                'filter': {'docstring': 'Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the main list of the editor.'},
                                'forceMainConnection': {'docstring': 'Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.'},
                                'highlightConnection': {'docstring': 'Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all editors have a highlight list. For those that do, it is a secondary selection list.'},
                                'lockMainConnection': {'docstring': 'Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor. Further changes to the original mainConnection are ignored.'},
                                'mainListConnection': {'docstring': 'Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object.'},
                                'panel': {'docstring': 'Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is deleted.'},
                                'parent': {'docstring': 'Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.'},
                                'query': {'docstring': ''},
                                'selectionConnection': {'docstring': 'Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes changes, the editor updates to show the changes.'},
                                'stateString': {'docstring': 'Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned command string uses the string variable $editorName in place of a specific name.'},
                                'targetControlList': {'docstring': ''},
                                'targetList': {'docstring': ''},
                                'unParent': {'docstring': 'Specifies that the editor should be removed from its layout. This cannot be used in query mode.'},
                                'unlockMainConnection': {'docstring': 'Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic updates.'},
                                'updateMainConnection': {'docstring': 'Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.'},
                                'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                                'verticalSliders': {'docstring': 'Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'blendShapePanel': {'description': 'This command creates a panel that derives from the base panel class that houses a blendShapeEditor. ',
                     'flags': {'blendShapeEditor': {'docstring': 'Query only flag that returns the name of an editor to be associated with the panel.'},
                               'control': {'docstring': 'Returns the top level control for this panel. Usually used for getting a parent to attach popup menus. CAUTION: panels may not have controls at times.  This flag can return "" if no control is present.'},
                               'copy': {'docstring': 'Makes this panel a copy of the specified panel.  Both panels must be of the same type.'},
                               'createString': {'docstring': 'Command string used to create a panel'},
                               'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                               'docTag': {'docstring': 'Attaches a tag to the Maya panel.'},
                               'edit': {'docstring': ''},
                               'editString': {'docstring': 'Command string used to edit a panel'},
                               'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                               'init': {'docstring': "Initializes the panel's default state.  This is usually done automatically on file -new and file -open."},
                               'isUnique': {'docstring': 'Returns true if only one instance of this panel type is allowed.'},
                               'label': {'docstring': 'Specifies the user readable label for the panel.'},
                               'menuBarRepeatLast': {'docstring': 'Controls whether clicking on the menu header with the middle mouse button would repeat the last selected menu item.'},
                               'menuBarVisible': {'docstring': 'Controls whether the menu bar for the panel is displayed.'},
                               'needsInit': {'docstring': '(Internal) On Edit will mark the panel as requiring initialization. Query will return whether the panel is marked for initialization.  Used during file -new and file -open.'},
                               'parent': {'docstring': 'Specifies the parent layout for this panel.'},
                               'popupMenuProcedure': {'docstring': 'Specifies the procedure called for building the panel\'s popup menu(s). The default value is "buildPanelPopupMenu".  The procedure should take one string argument which is the panel\'s name.'},
                               'query': {'docstring': ''},
                               'replacePanel': {'docstring': 'Will replace the specified panel with this panel.  If the target panel is within the same layout it will perform a swap.'},
                               'tearOff': {'docstring': 'Will tear off this panel into a separate window with a paneLayout as the parent of the panel. When queried this flag will return if the panel has been torn off into its own window.'},
                               'tearOffCopy': {'docstring': 'Will create this panel as a torn of copy of the specified source panel.'},
                               'tearOffRestore': {'docstring': 'Restores panel if it is torn off and focus is given to it. If docked, becomes the active panel in the docked window. This should be the default flag that is added to all panels instead of -to/-tearOffflag which should only be used to tear off the panel.'},
                               'unParent': {'docstring': 'Specifies that the panel should be removed from its layout. This (obviously) cannot be used with query.'},
                               'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'blendTwoAttr': {'description': 'A blendTwoAttr nodes takes two inputs, and blends the values of the inputs from one to the other, into an output value. The blending of the two inputs uses a blending function, and the following formula: (1 - blendFunction) \\* input[0]  +  blendFunction \\* input[1] The blendTwoAttr command can be used to blend the animation of an object to transition smoothly between the animation of two other objects. When the blendTwoAttr command is issued, it creates a blendTwoAttr node on the specified attributes, and reconnects whatever was previously connected to the attributes to the new blend nodes. You may also specify which two attributes should be used to blend together. The driver is used when you want to keyframe an object after it is being animated by a blend node. The current driver index specifies which of the two blended attributes should be keyframed. ',
                  'flags': {'attribute': {'docstring': 'A list of attributes for the selected nodes for which a blendTwoAttr node will be created.'},
                            'attribute0': {'docstring': 'The attribute that should be connected to the first input of the new blendTwoAttr node. When queried, it returns a string.'},
                            'attribute1': {'docstring': 'The attribute that should be connected to the second input of the new blendTwoAttr node. When queried, it returns a string.'},
                            'blender': {'docstring': 'The blender attribute. This is the attribute that will be connected to the newly created blendTwoAttr node(s) blender attribute. This attribute controls how much of each of the two attributes to use in the blend. If this flag is not specified, a new animation curve is created whose value goes from 1 to 0 throughout the time range specified by the -t flag. If -t is not specified, an abrupt change from the value of the first to the value of the second attribute will occur at the current time when this command is issued.'},
                            'controlPoints': {'docstring': 'Explicitly specify whether or not to include the control points of a shape (see "-s" flag) in the list of attributes. Default: false.'},
                            'driver': {'docstring': 'The index of the driver attribute for this blend node (0 or 1) When queried, it returns an integer.'},
                            'edit': {'docstring': ''},
                            'name': {'docstring': 'name for the new blend node(s)'},
                            'query': {'docstring': ''},
                            'shape': {'docstring': 'Consider all attributes of shapes below transforms as well, except "controlPoints". Default: true'},
                            'time': {'docstring': 'The time range between which the blending between the 2 attributes should occur. If a single time is specified, then the blend will cause an abrupt change from the first to the second attribute at that time.  If a range is specified, a smooth blending will occur over that time range. The default is to make a sudden transition at the current time.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'blindDataType': {'description': 'This command creates a blind data type, which is represented by a blindDataTemplate node in the DG. A blind data type can have one or more attributes. On the command line, the attributes should be ordered by type for best memory utilization, largest first: string, binary, double, float, int, and finally boolean. Once a blind data type is created, blind data of that type may be assigned using the polyBlindData command. Note that as well as polygon components, blind data may be assigned to objects and to NURBS patches. A blind data type may not be modified after it is created: in order to do so it must be deleted and recreated. Any existing blind data of that type would also need to be deleted and recreated. When used with the query flag, this command will return information about the attributes of the specified blind data type. \t         ',
                   'flags': {'dataType': {'docstring': 'Specifies the dataTypes that are part of BlindData node being created. Allowable strings are "int", "float", "double", "string", "boolean" and "binary". Must be used togeter with the -ldn and -sdn flags to specify each attribute.'},
                             'longDataName': {'docstring': 'Specifies the long names of the datas that are part of BlindData node being created. Must be used togeter with the -dt and -sdn flags to specify each attribute.'},
                             'longNames': {'docstring': 'Specifies that for a query command the long attributes names be listed.'},
                             'query': {'docstring': 'Specifies that this is a special query type command.'},
                             'shortDataName': {'docstring': 'Specifies the short names of the data that are part of BlindData node being created. Must be used togeter with the -dt and -ldn flags to specify each attribute.'},
                             'shortNames': {'docstring': 'Specifies that for a query command the short attribute names be listed.'},
                             'typeId': {'docstring': 'Specifies the typeId of the BlindData type being created.'},
                             'typeNames': {'docstring': 'Specifies that for a query command the data types be listed. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'boneLattice': {'description': 'This command creates/edits/queries a boneLattice deformer. The name of the created/edited object is returned. Usually you would make use of this functionality through the higher level flexor command. ',
                 'flags': {'after': {'docstring': 'If the default behavior for insertion/appending into/onto the existing chain is not the desired behavior then this flag can be used to force the command to place the deformer node after the selected node in the chain even if a new geometry shape has to be created in order to do so. Works in create mode (and edit mode if the deformer has no geometry added yet).'},
                           'afterReference': {'docstring': 'The -afterReference flag is used to specify deformer ordering in a hybrid way that choses between -before and -after automatically. If the geometry being deformed is referenced then the -after mode is used when adding the new deformer, otherwise the -before mode is used. The net effect when using -afterReference to build deformer chains is that internal shape nodes in the deformer chain will only appear at reference file boundaries, leading to lightweight deformer networks that may be more amicable to reference swapping.'},
                           'before': {'docstring': 'If the default behavior for insertion/appending into/onto the existing chain is not the desired behavior then this flag can be used to force the command to place the deformer node before the selected node in the chain even if a new geometry shape has to be created in order to do so. Works in create mode (and edit mode if the deformer has no geometry added yet).'},
                           'bicep': {'docstring': 'Affects the bulging of lattice points on the inside of the bend. Positive/negative values cause the points to bulge outwards/inwards. Default value is 0.0. When queried, this flag returns a float.'},
                           'deformerTools': {'docstring': 'Returns the name of the deformer tool objects (if any) as string string ...'},
                           'edit': {'docstring': ''},
                           'exclusive': {'docstring': 'Puts the deformation set in a deform partition.'},
                           'frontOfChain': {'docstring': "This command is used to specify that the new deformer node should be placed ahead (upstream) of existing deformer and skin nodes in the shape's history (but not ahead of existing tweak nodes). The input to the deformer will be the upstream shape rather than the visible downstream shape, so the behavior of this flag is the most intuitive if the downstream deformers are in their reset (hasNoEffect) position when the new deformer is added. Works in create mode (and edit mode if the deformer has no geometry added yet)."},
                           'geometry': {'docstring': 'The specified object will be added to the list of objects being deformed by this deformer object, unless the -rm flag is also specified. When queried, this flag returns string string string ...'},
                           'geometryIndices': {'docstring': 'Complements the -geometry flag in query mode. Returns the multi index of each geometry.'},
                           'ignoreSelected': {'docstring': 'Tells the command to not deform objects on the current selection list'},
                           'includeHiddenSelections': {'docstring': 'Apply the deformer to any visible and hidden objects in the selection list. Default is false.'},
                           'joint': {'docstring': 'Specifies which joint will be used to drive the bulging behaviors.'},
                           'lengthIn': {'docstring': 'Affects the location of lattice points along the upper half of the bone. Positive/negative values cause the points to move away/towards the center of the bone.  Changing this parameter also modifies the regions affected by the creasing, rounding and width parameters. Default value is 0.0. When queried, this flag returns a float.'},
                           'lengthOut': {'docstring': 'Affects the location of lattice points along the lower half of the bone. Positive/negative values cause the points to move away/towards the center of the bone.  Changing this parameter also modifies the regions affected by the creasing, rounding and width parameters. Default value is 0.0. When queried, this flag returns a float.'},
                           'name': {'docstring': 'Used to specify the name of the node being created.'},
                           'parallel': {'docstring': 'Inserts the new deformer in a parallel chain to any existing deformers in the history of the object. A blendShape is inserted to blend the parallel results together. Works in create mode (and edit mode if the deformer has no geometry added yet).'},
                           'prune': {'docstring': 'Removes any points not being deformed by the deformer in its current configuration from the deformer set.'},
                           'query': {'docstring': ''},
                           'remove': {'docstring': 'Specifies that objects listed after the -g flag should be removed from this deformer.'},
                           'split': {'docstring': 'Branches off a new chain in the dependency graph instead of inserting/appending the deformer into/onto an existing chain. Works in create mode (and edit mode if the deformer has no geometry added yet).'},
                           'transform': {'docstring': 'Specifies which dag node is being used to rigidly transform the lattice which this node is going to deform.  If this flag is not specified an identity matrix will be assumed.'},
                           'tricep': {'docstring': 'Affects the bulging of lattice points on the outside of the bend. Positive/negative values cause the points to bulge outwards/inwards. Default value is 0.0. When queried, this flag returns a float.'},
                           'useComponentTags': {'docstring': 'When this flag is specified a setup using componentTags will be created. This means no groupId, groupParts, tweak or objectSet nodes will be created and connected to the new deformer.'},
                           'widthLeft': {'docstring': 'Affects the bulging of lattice points on the left side of the bend. Positive/negative values cause the points to bulge outwards/inwards. Default value is 0.0. When queried, this flag returns a float.'},
                           'widthRight': {'docstring': 'Affects the bulging of lattice points on the right side of the bend. Positive/negative values cause the points to bulge outwards/inwards. Default value is 0.0. When queried, this flag returns a float.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'boundary': {'description': 'This command produces a boundary surface given 3 or 4 curves. This resulting boundary surface passes through two of the given curves in one direction, while in the other direction the shape is defined by the remaining curve(s).  If the "endPoint" option is on, then the curve endpoints must touch before a surface will be created.   This is the usual situation where a boundary surface is useful. Note that there is no tangent continuity option with this command. Unless all the curve end points are touching, the resulting surface will not pass through all curves.  Instead, use the birail command. ',
              'flags': {'caching': {'docstring': 'Toggle caching for all attributes so that no recomputation is needed'},
                        'constructionHistory': {'docstring': 'Turn the construction history on or off.'},
                        'edit': {'docstring': ''},
                        'endPoint': {'docstring': 'True means the curve ends must touch before a surface will be created. Default:false'},
                        'endPointTolerance': {'docstring': 'Tolerance for end points, only used if endPoint attribute is true. Default:0.1'},
                        'frozen': {'docstring': ''},
                        'name': {'docstring': 'Sets the name of the newly-created node. If it contains namespace path, the new node will be created under the specified namespace; if the namespace does not exist, it will be created.'},
                        'nodeState': {'docstring': "Maya dependency nodes have 6 possible states. The Normal (0), HasNoEffect (1), and Blocking (2)states can be used to alter how the graph is evaluated.   The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)are for internal use only. They temporarily shut off parts of the graph during interaction (e.g., manipulation). The understanding is that once the operation is done, the state will be reset appropriately, e.g. Waiting-Blockingwill reset back to Blocking.   The Normaland Blockingcases apply to all nodes, while HasNoEffectis node specific; many nodes do not support this option. Plug-ins store state in the MPxNode::stateattribute. Anyone can set it or check this attribute.  Additional details about each of these 3 states follow.  StateDescriptionNormalThe normal node state. This is the default.HasNoEffectThe HasNoEffectoption (a.k.a. pass-through), is used in cases where there is an operation on an input producing an output of the same data type. Nearly all deformers support this state, as do a few other nodes. As stated earlier, it is not supported by all nodes.  Itâ€™s typical to implement support for the HasNoEffectstate in the nodeâ€™s compute method and to perform appropriate operations. Plug-ins can also support HasNoEffect.  The usual implementation of this state is to copy the input directly to the matching output without applying the algorithm in the node. For deformers, applying this state leaves the input geometry undeformed on the output.  BlockingThis is implemented in the depend node base class and applies to all nodes. Blockingis applied during the evaluation phase to connections. An evaluation request to a blocked connection will return as failures, causing the destination plug to retain its current value. Dirty propagation is indirectly affected by this state since blocked connections are never cleaned.  When a node is set to Blockingthe behavior is supposed to be the same as if all outgoing connections were broken. As long as nobody requests evaluation of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked node will still respond to getAttrrequests but a getAttron a downstream node will not reevaluate the blocked node.  Setting the root transform of a hierarchy to Blockingwonâ€™t automatically influence child transforms in the hierarchy. To do this, youâ€™d need to explicitly set all child nodes to the Blockingstate.  For example, to set all child transforms to Blocking, you could use the following script.  import maya.cmds as cmds def blockTree(root): nodesToBlock = [] for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys(): nodesToBlock += cmds.listConnections(node, source=True, destination=True ) for node in {source:1 for source in nodesToBlock}.keys(): cmds.setAttr( '%s.nodeState' % node, 2 )  Applying this script would continue to draw objects but things would not be animated.  Default:kdnNormal"},
                        'object': {'docstring': 'Create the result, or just the dependency node.'},
                        'order': {'docstring': 'True if the curve order is important. Default:true                  Common flags'},
                        'polygon': {'docstring': 'The value of this argument controls the type of the object created by this operation 0: nurbs surface1: polygon (use nurbsToPolygonsPref to set the parameters for the conversion)2: subdivision surface (use nurbsToSubdivPref to set the parameters for the conversion)3: Bezier surface4: subdivision surface solid (use nurbsToSubdivPref to set the parameters for the conversion)'},
                        'query': {'docstring': ''},
                        'range': {'docstring': 'Force a curve range on complete input curve.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'boxDollyCtx': {'description': 'This command can be used to create, edit, or query a dolly context. ',
                 'flags': {'alternateContext': {'docstring': 'Set the ALT+MMB and ALT+SHIFT+MMB to refer to this context.'},
                           'edit': {'docstring': ''},
                           'exists': {'docstring': 'Returns true or false depending upon whether the specified object exists. Other flags are ignored.'},
                           'history': {'docstring': 'If this is a tool command, turn the construction history on for the tool in question.'},
                           'image1': {'docstring': 'First of three possible icons representing the tool associated with the context.'},
                           'image2': {'docstring': 'Second of three possible icons representing the tool associated with the context.'},
                           'image3': {'docstring': 'Third of three possible icons representing the tool associated with the context.'},
                           'name': {'docstring': 'If this is a tool command, name the tool appropriately.'},
                           'query': {'docstring': ''},
                           'toolName': {'docstring': 'Name of the specific tool to which this command refers.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'boxZoomCtx': {'description': 'This command can be used to create, edit, or query a box zoom context. If this context is used on a perspective camera, the field of view and view direction are changed. If the camera is orthographic, the orthographic width and eye point are changed. The left and middle mouse interactively zoom the view. The control key can be used to enable box zoom. A box starting from left to right will zoom in, and a box starting from right to left will zoom out. ',
                'flags': {'edit': {'docstring': ''},
                          'exists': {'docstring': 'Returns true or false depending upon whether the specified object exists. Other flags are ignored.'},
                          'history': {'docstring': 'If this is a tool command, turn the construction history on for the tool in question.'},
                          'image1': {'docstring': 'First of three possible icons representing the tool associated with the context.'},
                          'image2': {'docstring': 'Second of three possible icons representing the tool associated with the context.'},
                          'image3': {'docstring': 'Third of three possible icons representing the tool associated with the context.'},
                          'name': {'docstring': 'If this is a tool command, name the tool appropriately.'},
                          'query': {'docstring': ''},
                          'zoomScale': {'docstring': 'Scale the zoom.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'bufferCurve': {'description': 'This command operates on a keyset.  A keyset is defined as a group of keys within a specified time range on one or more animation curves. The animation curves comprising a keyset depend on the value of the "-animation" flag: keysOrObjects: Any active keys, when no target objects or -attribute flags appear on the command line, orAll animation curves connected to all keyframable attributes of objects specified as the command line\'s targetList, when there are no active keys.keys: Only act on active keys or tangents. If there are no active keys or tangents, don\'t do anything. objects: Only act on specified objects.  If there are no objects specified, don\'t do anything. Note that the "-animation" flag can be used to override the curves uniquely identified by the multi-use "-attribute" flag, which takes an argument of the form attributeName, such as "translateX". Keys on animation curves are identified by either their time values or their indices.  Times and indices can be given individually or as part of a list or range (see Examples). This command helps manage buffer curve for animated objects \t         ',
                 'flags': {'animation': {'docstring': 'Where this command should get the animation to act on.  Valid values are "objects," "keys," and "keysOrObjects" Default: "keysOrObjects."  (See Description for details.)'},
                           'attribute': {'docstring': 'List of attributes to select'},
                           'controlPoints': {'docstring': 'This flag explicitly specifies whether or not to include the control points of a shape (see "-s" flag) in the list of attributes. Default: false.  (Not valid for "pasteKey" cmd.)'},
                           'exists': {'docstring': 'Returns true if a buffer curve currently exists on the specified attribute; false otherwise.'},
                           'float': {'docstring': 'value uniquely representing a non-time-based key (or key range) on a time-based animCurve.  Valid floatRange include single values (-f 10) or a string with a lower and upper bound, separated by a colon (-f "10:20")'},
                           'hierarchy': {'docstring': 'Hierarchy expansion options.  Valid values are "above," "below," "both," and "none." (Not valid for "pasteKey" cmd.)'},
                           'includeUpperBound': {'docstring': 'When the -t/time or -f/float flags represent a range of keys, this flag determines whether the keys at the upper bound of the range are included in the keyset. Default value: true.  This flag is only valid when the argument to the -t/time flag is a time range with a lower and upper bound.  (When used with the "pasteKey" command, this flag refers only to the time range of the target curve that is replaced, when using options such as "replace," "fitReplace," or "scaleReplace."  This flag has no effect on the curve pasted from the clipboard.)'},
                           'index': {'docstring': 'index of a key on an animCurve'},
                           'overwrite': {'docstring': 'Create a buffer curve.  "true" means create a buffer curve whether or not one already existed.  "false" means if a buffer curve exists already then leave it alone.  If no flag is specified, then the command defaults to -overwrite false'},
                           'query': {'docstring': ''},
                           'shape': {'docstring': 'Consider attributes of shapes below transforms as well, except "controlPoints".  Default: true.  (Not valid for "pasteKey" cmd.)'},
                           'swap': {'docstring': 'For animated attributes which have buffer curves, swap the buffer curve with the current animation curve'},
                           'time': {'docstring': 'time uniquely representing a key (or key range) on a time-based animCurve. See the code examples below on how to format for a single frame or frame ranges.'},
                           'useReferencedCurve': {'docstring': 'In create mode, sets the buffer curve to the referenced curve. Curves which are not from file references will ignore this flag. In query mode, returns true if the selected keys are displaying their referenced curve as the buffer curve, and false if they are not.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'buildBookmarkMenu': {'description': 'This command handles building the "dynamic" Bookmark menu, to show all bookmarks ("sets") of a specified type ("sets -text") menuName is the string returned by the "menu" command. ',
                       'flags': {'editor': {'docstring': 'Name of the editor which this menu belongs to'},
                                 'type': {'docstring': 'Type of bookmark (sets -text) to display                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'buildKeyframeMenu': {'description': 'This command handles building the "dynamic" Keyframe menu, to show attributes of currently selected objects, filtered by the current manipulator. menuName is the string returned by the "menu" command. The target menu will entries appended to it (and deleted from it) to always show what\'s currently keyframable. ',
                       'flags': {}},
 'button': {'description': 'Create a button control capable of displaying a textual label and executing a command when selected by the user. ',
            'flags': {'actOnPress': {'docstring': 'If true then the command specified by the command flag will be executed when a mouse button is pressed.  If false then that command will be executed after the mouse button is released. The default value is false.'},
                      'actionIsSubstitute': {'docstring': 'This flag is obsolete and should no longer be used.'},
                      'align': {'docstring': 'This flag is obsolete and should no longer be used. The button label will always be center-aligned.'},
                      'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                      'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                      'command': {'docstring': 'Command executed when the control is pressed.'},
                      'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                      'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                      'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                      'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                      'edit': {'docstring': ''},
                      'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                      'enableBackground': {'docstring': 'Enables the background color of the control.'},
                      'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                      'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                      'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                      'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                      'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                      'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                      'label': {'docstring': 'The label text.  The default label is the name of the control.'},
                      'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                      'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                      'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                      'parent': {'docstring': 'The parent layout for this control.'},
                      'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                      'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                      'query': {'docstring': ''},
                      'recomputeSize': {'docstring': "If true then the control will recompute it's size to just fit the size of the label.  If false then the control size will remain fixed as you change the size of the label.  The default value of this flag is true."},
                      'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                      'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                      'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                      'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                      'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'buttonManip': {'description': 'This creates a button manipulator. This manipulator has a position in space and a triad manip for positioning. When you click on the top part of the manip, the command defined by the first argument is executed. The command is associated with the manipulator when it is created. If a dag object is included on the command line, the manip will be parented to the object. This means moving the object will move the manip. You can move the manip independently of the object using its triad. Note that a buttonManip may not be parented to more than one object. ',
                 'flags': {'icon': {'docstring': 'Specify an icon to represent the manipulator.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'cacheFile': {'description': 'Creates one or more cache files on disk to store attribute data for a span of frames. The caches can be created for points/normals on a geometry (using the pts/points or pan/pointsAndNormals flag), for vectorArray output data (using the oa/outAttr flag), or for additional node specific data (using the cnd/cacheableNode flag for those nodes that support it). When the ia/inAttr flag is used, connects a cacheFile node that associates the data file on disk with the attribute. Frames can be replaced/appended to an existing cache with the rcf/replaceCachedFrame and apf/appendFrame flag.  Replaced frames are never deleted. They are stored in the same directory as the original cache files with the name provided by the f/fileName flag. If no file name is provided, the cacheFile name is prefixed with "backup" followed by a unique number. Single file caches are backed up in their entirety. To revert to an older version, simply attach to this cache. One file per frame caches only backup the description file and the frames that were replaced. To recover these types of caches, the user must rename these files to the original name. \t         ',
               'flags': {'appendFrame': {'docstring': 'Appends data to the cache for the times specified by the startTime and endTime flags. If no time is provided, appends the current time. Must be used in conjunction with the pts/points or cnd/cacheableNode flag. Any overwritten frames will not be deleted, but renamed as specified by the f/fileName flag.'},
                         'attachFile': {'docstring': 'Used to indicate that rather than creating a cache file, that an existing cache file on disk should be attached to an attribute in the scene. The inAttr flag is used to specify the attribute.'},
                         'cacheFileNode': {'docstring': 'Specifies the name of the cache file node(s) we are appending/replacing to if more than one cache is attached to the specified geometries.'},
                         'cacheFormat': {'docstring': "Cache file format, default is Maya's .mcx format, but others available via plugin"},
                         'cacheInfo': {'docstring': 'In create mode, used to specify a mel script returning a string array. When creating the cache, this mel script will be executed and the returned strings will be written to the .xml description file of the cache. In query mode, returns descriptive info stored in the cacheFile such as the user name, Maya scene name and maya version number.'},
                         'cacheableAttrs': {'docstring': 'Returns the list of cacheable attributes defined on the accompanying cache node. This argument requires the use of the cacheableNode flag.'},
                         'cacheableNode': {'docstring': 'Specifies the name of a cacheable node whose contents will be cached. A cacheable node is a node that is specially designed to work with the caching mechanism.  An example of a cacheable node is a nCloth node.'},
                         'channelIndex': {'docstring': 'A query-only flag which returns the channel index for the selected geometry for the cacheFile node specified using the cacheFileNode flag.'},
                         'channelName': {'docstring': 'When attachFile is used, used to indicate the channel in the file that should be attached to inAttr.  If not specified, the first channel in the file is used. In query mode, allows user to query the channels associated with a description file.'},
                         'convertPc2': {'docstring': 'Convert a PC2 file to the Maya cache format (true), or convert Maya cache to pc2 format (false)'},
                         'createCacheNode': {'docstring': 'Used to indicate that rather than creating a cache file, that a cacheFile node should be created related to an existing cache file on disk.'},
                         'creationChannelName': {'docstring': 'When creating a new cache, this multi-use flag specifies the channels to be cached. The names come from the cacheable channel names defined by the object being cached. If this flag is not used when creating a cache, then all cacheable channels are cached.'},
                         'dataSize': {'docstring': 'This is a query-only flag that returns the size of the data being cached per frame. This flag is to be used in conjunction with the cacheableNode, points, pointsAndNormals and outAttr flags.'},
                         'deleteCachedFrame': {'docstring': 'Deletes cached data for the times specified by the startTime/endTime flags. If no time is provided, deletes the current frame. Must be used in conjunction with the pts/points or cnd/cacheableNode flag. Deleted frames will not be removed from disk, but renamed as specified by the f/fileName flag.'},
                         'descriptionFileName': {'docstring': 'This is a query-only flag that returns the name of the description file for an existing cacheFile node. Or if no cacheFile node is specified, it returns the description file name that would be created based on the other flags specified.'},
                         'directory': {'docstring': 'Specifies the directory where the cache files will be located. If the directory flag is not specified, the cache files will be placed in the project data directory.'},
                         'doubleToFloat': {'docstring': 'During cache creation, double data is stored in the file as floats.  This helps cut down file size.'},
                         'edit': {'docstring': ''},
                         'endTime': {'docstring': 'Specifies the end frame of the cache range.'},
                         'fileName': {'docstring': 'Specifies the base file name for the cache files. If more than one object is being cached and the format is OneFilePerFrame, each cache file will be prefixed with this base file name. In query mode, returns the files associated with the specified cacheFile node. When used with rpf/replaceCachedFrame or apf/appendFrame specifies the name of the backup files. If not specified, replaced frames will be stored with a default name. In query mode, this flag can accept a value.'},
                         'format': {'docstring': 'Specifies the distribution format of the cache.  Valid values are "OneFile" and "OneFilePerFrame"'},
                         'geometry': {'docstring': 'A query flag which returns the geometry controlled by the specified cache node'},
                         'inAttr': {'docstring': 'Specifies the name of the attribute that the cache file will drive. This file is optional when creating cache files. If this flag is not used during create mode, the cache files will be created on disk, but will not be driving anything in the scene. This flag is required when the attachFile flag is used.'},
                         'inTangent': {'docstring': 'Specifies the in-tangent type when interpolating frames before the replaced frame(s). Must be used with the ist/interpStartTime and iet/interpEndTime flags. Valid values are "linear", "smooth" and "step".'},
                         'interpEndTime': {'docstring': 'Specifies the frame until which there will be linear interpolation, beginning at endTime. Must be used with the rpf/replaceCachedFrame or apf/appendFrame flag. Interpolation is achieved by removing frames between endTime and interpEndTime from the cache. Removed frames will be renamed as specified by the f/fileName flag.'},
                         'interpStartTime': {'docstring': 'Specifies the frame from which to begin linear interpolation, ending at startTime. Must be used with the rpf/replaceCachedFrame or apf/appendFrame flags. Interpolation is achieved by removing  frames between interpStartTime and startTime from the cache. These removed frames will will be renamed as specified by the f/fileName flag.'},
                         'noBackup': {'docstring': 'Specifies that backup files should not be created for any files that may be over-written during append, replace or delete cache frames. Can only be used with the apf/appendFrame, rpf/replaceCachedFrame or dcf/deleteCachedFrame flags.'},
                         'outAttr': {'docstring': 'Specifies the name of the attribute that will be cached to disk.'},
                         'outTangent': {'docstring': 'Specifies the out-tangent type when interpolating frames after the replaced frame(s). Must be used with the ist/interpStartTime and iet/interpEndTime flags. Valid values are "linear", "smooth" and "step".'},
                         'pc2File': {'docstring': 'Specifies the full path to the pc2 file.  Must be used in conjunction with the pc2 flag.'},
                         'pointCount': {'docstring': 'A query flag which returns the number of points stored in the cache file. The channelName flag should be used to specify the channel to be queried.'},
                         'points': {'docstring': 'Specifies the name of a geometry whose points will be cached.'},
                         'pointsAndNormals': {'docstring': 'Specifies the name of a geometry whose points and normals will be cached. The normals is per-vertex per-polygon. The normals cache cannot be imported back to geometry. This flag can only be used to export cache file. It cannot be used with the apf/appendFrame, dcf/deleteCachedFrame and rpf/replaceCachedFrame flags.'},
                         'prefix': {'docstring': 'Indicates that the specified fileName should be used as a prefix for the cacheName.'},
                         'query': {'docstring': ''},
                         'refresh': {'docstring': 'When used during cache creation, forces a screen refresh during caching. This causes the cache creation to be slower but allows you to see how the simulation is progressing during the cache.'},
                         'replaceCachedFrame': {'docstring': 'Replaces cached data for the times specified by the startTime/endTime flags. If no time is provided, replaces cache file for the current time. Must be used in conjunction with the pts/points or cnd/cacheableNode flag. Replaced frames will not be deleted, but renamed as specified by the f/fileName flag.'},
                         'replaceWithoutSimulating': {'docstring': 'When replacing cached frames, this flag specifies whether the replacement should come from the cached node without simulating or from advancing time and letting the simulation run.  This flag is valid only when neither the startTime nor endTime flags are used or when both the startTime and endTime flags specify the same time value.'},
                         'runupFrames': {'docstring': 'Specifies the number of frames of runup to simulate ahead of the starting frame. The value must be greater than or equal to 0.  The default is 2.'},
                         'sampleMultiplier': {'docstring': 'Specifies the sample rate when caches are being created as a multiple of simulation Rate. If the value is 1, then a sample will be cached everytime the time is advanced.  If the value is 2, then every other sample will be cached, and so on.  The default is 1.'},
                         'simulationRate': {'docstring': 'Specifies the simulation rate when caches are being created.  During cache creation, the time will be advanced by the simulation rate, until the end time of the cache is reached or surpassed.  The value is given in frames. The default value is 1 frame.'},
                         'singleCache': {'docstring': 'When used in conjunction with the points, pointsAndNormal or cacheableNode flag, specifies whether multiple geometries should be put into a single cache or to create one cache per geometry (default).'},
                         'startTime': {'docstring': 'Specifies the start frame of the cache range.'},
                         'staticCache': {'docstring': 'If false, during cache creation, do not save a cache for the object if it appears to have no animation or deformation. If true, save a cache even if the object appears to have no animation or deformation. Default is true. In query mode, when supplied a shape, the flag returns true if the shape appears to have no animation or deformation.'},
                         'worldSpace': {'docstring': 'If the points flag is used, turning on this flag will result in the world space positions of the points being written. The expected use of this flag is for cache export. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'cacheFileCombine': {'description': 'Creates a cacheBlend node that can be used to combine, layer or blend multiple cacheFiles for a given object. \t         ',
                      'flags': {'cacheIndex': {'docstring': 'A query only flag that returns the index related to the cache specified with the connectCache flag.'},
                                'channelName': {'docstring': 'Used in conjunction with the connectCache flag to indicate the channel(s) that should be connected.  If not specified, the first channel in the file is used.'},
                                'connectCache': {'docstring': 'An edit flag that specifies a cacheFile node that should be connected to the next available index on the specified cacheBlend node. As a query flag, it returns a string array containing the cacheFiles that feed into the specified cacheBlend node. In query mode, this flag can accept a value.'},
                                'edit': {'docstring': ''},
                                'keepWeights': {'docstring': 'This is a flag for use in combination with the connectCache flag only. By default, the connectCache flag will set all weights other than the newly added cacheWeight to 0 so that the new cache gets complete control. This flag disables that behavior so that all existing blend weights are retained.'},
                                'layerNode': {'docstring': 'A query flag that returns a string array of the existing cacheBlends on the selected object(s). Returns an empty string array if no cacheBlends are found.'},
                                'nextAvailable': {'docstring': 'A query flag that returns the next available index on the selected cacheBlend node.'},
                                'object': {'docstring': 'This flag is used in combination with the objectIndex flag. It is used to specify the object whose index you wish to query.'},
                                'objectIndex': {'docstring': 'In edit mode, used in conjunction with the connectCache flag to indicate the objectIndex to be connected. In query mode, returns the index related to the object specified with the object flag. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'},
                                'query': {'docstring': ''}}},
 'cacheFileMerge': {'description': 'If selected/specified caches can be successfully merged, will return the start/end frames of the new cache followed by the start/end frames of any gaps in the merged cache for which no data should be written to file. In query mode, will return the names of geometry associated with the specified cache file nodes. \t         ',
                    'flags': {'edit': {'docstring': ''},
                              'endTime': {'docstring': 'Specifies the end frame of the merge range. If not specified, will figure out range from times of caches being merged.'},
                              'geometry': {'docstring': 'Query-only flag used to find the geometry nodes associated with the specified cache files.'},
                              'query': {'docstring': ''},
                              'startTime': {'docstring': 'Specifies the start frame of the merge range. If not specified, will figure out range from the times of the caches being merged. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'cacheFileTrack': {'description': 'This command is used for inserting and removing tracks related to the caches displayed in the trax editor. It can also be used to modify the track state, for example, to lock or mute a track. \t         In query mode, return type is based on queried flag.',
                    'flags': {'edit': {'docstring': ''},
                              'insertTrack': {'docstring': 'This flag is used to insert a new empty track at the track index specified.'},
                              'lock': {'docstring': 'This flag specifies whether clips on a track are to be locked or not.'},
                              'mute': {'docstring': 'This flag specifies whether clips on a track are to be muted or not.'},
                              'query': {'docstring': ''},
                              'removeEmptyTracks': {'docstring': 'This flag is used to remove all tracks that have no clips.'},
                              'removeTrack': {'docstring': 'This flag is used to remove the track with the specified index.  The track must have no clips on it before it can be removed.'},
                              'solo': {'docstring': 'This flag specifies whether clips on a track are to be soloed or not.'},
                              'track': {'docstring': 'Used to specify a new track index for a cache to be displayed. Track-indices are 1-based. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'caddyManip': {'description': '', 'flags': {}},
 'callbacks': {'description': 'This command allows you to add callbacks at key times during UI creation so that the Maya UI can be extended. The list of standard Maya hooks, as well as the arguments which will be passed to the callback based on the context are enumerated in the describeHookssection below. Custom hooks can also be added if third parties want to add UI extensibility to their plugins. \t         ',
               'flags': {'addCallback': {'docstring': 'Add a callback for the specified hook. The owner must also be specified when adding callbacks.'},
                         'clearAllCallbacks': {'docstring': 'Clear all the callbacks for all hooks and owners. This is generally only used during plugin development and testing as it affects all callbacks registered by Maya and other third parties.'},
                         'clearCallbacks': {'docstring': 'Clear all the callbacks for the specified owner. If a hook is specified, only the callbacks for that hook and owner will be cleared.'},
                         'describeHooks': {'docstring': 'List the standard Maya hooks. Below is a list of the hooks and their associated arguments and return values. Custom hooks added by third parties are not listed. hyperShadePanelBuildCreateMenuThis hook is called to add content to the Hypershade panel create menu. It will be called after the standard Maya node entries have been created. This callback does not have any arguments or return values. In order to preserve the desired look in the Maya UI, these callbacks should add a menu item divider just before returning using: menuItem -divider true. hyperShadePanelBuildCreateSubMenuThis hook is called to get a classification string for the custom renderer shading nodes, to prevent them from being listed with the standard Maya nodes. This callback does not have any arguments. returns: a classification string, such as rendernode/myrendererhyperShadePanelPluginChangeThis hook is called when a plugin change event (loading / unloading) has occurred to inform Maya whether the Hypershade panel needs to be rebuilt. classification (string): classification string belonging to a plugin node,     possibly from another pluginchangeType (string): either loadPluginor unloadPluginreturns: (int) non-zero if your plugin is responsible for nodes of this classification,     and a Hypershade rebuild is requiredcreateRenderNodeSelectNodeCategoriesThis hook is called when the Create Render Node dialog is being constructed, and allows a third party to have their nodes selected by default. A flag of the form -allWithMyRendererUpis the standard form, and the selection can be set up in the tree lister in the callback. There is no return value for this callback. flag (string): flag passed to the Create Render Node dialog command with the leading minus (-) removedtreeLister (string): the tree lister widget which should be affectedFor example, your callback might look like: global proc myRendererCreateRenderNodeSelectNodeCategoriesCallback(string $flag, string $treeLister){     if($flag == "allWithMyRendererUp") {         treeLister -e -selectPath "myrenderer" $treeLister;     } } createRenderNodePluginChangeThis hook is called when a plugin change event has occurred to decide if the Create Render Node dialog needs to be closed. classification (string): classification string belonging to a plugin node,     possibly from another pluginreturns: (int) non-zero if your plugin is responsible for nodes of this classification,     and the Create Render Node dialog needs to be closedrenderNodeClassificationThis hook is called to get a classification string for the custom renderer shading nodes.  This is used to determine if a given node type belongs to a plugin renderer. This callback does not have any arguments. returns: a classification string, such as rendernode/myrenderercreateRenderNodeCommandThis hook is called to give plugin renderers the chance to register their own command for creating their nodes from the render node treeLister and Node Editor. The callback should determine from the classification of the node type in question if it is theirs, and if so, return the appropriate command for creating new nodes of that type. postCommand (string): command to be run after the create commandtype (string): nodeTypereturns: (string) MEL create commandbuildRenderNodeTreeListerContentThis hook is called to give plugin renderers the chance to add their content to the render node tree lister. renderNodeTreeLister (string): the render node tree listerpostCommand (string): command to be run post-creationfilterString (string): a space delimited list of filtersAETemplateCustomContentThis hook is called to give plugins a chance to add content to the Attribute Editor for nodes which source AEdependNodeTemplate. nodeName (string): the name of the node for which the Attribute Editor is being constructedfirstConnectedShaderThis hook is called to determine the primary custom shader connected to the given Shading Engine. nodeName (string): the name of the Shading Enginereturns (string): the name of the custom shader if applicableallConnectedShadersThis hook is called to determine all the shaders connected to the given Shading Engine. nodeName (string): the name of the Shading Enginereturns (string): a colon separated list of the connected custom shaders (shader1:shader2:shader3)renderLayerPresetMenuThis hook is called to give plugins a chance to add presets to a renderLayer node. nodeName (string): the name of the renderLayer nodeaddBakingMenuItemsThis hook is called to give plugins a chance to add baking menu items to the global Render - Lighting/Shading menu. menuItemAnchor (string): the name of the menuItem which the new baking menu items should be inserted after. addVertexBakingMenuItemsThis hook is called to give plugins a chance to add baking menu items to the global Polygon - Color menu. addPrelightMenuItemsThis hook is called to give plugins a chance to add pre-lighting menu items to the global Polygon - Color Set Editor menu. addRMBBakingMenuItemsThis hook is called to give plugins a chance to add baking menu items to the RMB menu. objectName (string): the name of the object the right mouse button event occured on.addMayaRenderingPreferencesThis hook is called to give plugins a chance to add custom preferences to the Maya\'s Rendering Preferences section. updateMayaRenderingPreferencesThis hook is called to give plugins a chance to update custom preferences of the Maya\'s Rendering Preferences section. addMayaMuscleMenuItemsThis hook is called to give plugins a chance to add menu items to the Maya muscle Displace menu. menuItemAnchor (string): the name of the menuItem which the new Maya muscle menu items should be inserted after. addMayaMuscleShelfButtonsThis hook is called to give plugins a chance to add items to the Maya muscle shelves. addBackburnerRendererMenuItemsThis hook is called to give plugins a chance to add items to Maya\'s Backburner list of available renderers. Note: The menuItem added must be named with the short name equivalent of the renderer. eg: The Maya software renderer adds a menuItem named \'sw\'. provideAETemplateForNodeTypeThis hook is called to give plugins a chance to provide a UI template for nodes which do not have a corresponding AE\'nodeType\'Template procedure. nodeType (string): the type of the node for which the AE is being constructed. returns (string): the name of a MEL command or procedure to use as the AETemplate for the requested node type. AEnewMultiHandlerThis hook is called to give plugins a chance to provide a UI creation handler for multi attributes. nodeName (string): the name of the node for which the AE is being constructed. atributeName (string): the name of the multi attribute.uiName (string): the UI name of the attribute.changedCommand (string): the MEL command or procedure to be executed when the value of the multi attribute is changed.elementIndexString (string): a colon separated list of indices at which the elements of the multi attribute live.returns (string): if the callback handled the attribute then it should return the full name of the topmost UI element that it created, otherwise it should return an empty string.AEreplaceMultiHandlerThis hook is called to give plugins a chance to provide an update handler for multi attributes. layoutName (string): the well defined name of the Maya UI component which represents the multi attribute (.nodeName (string): the name of the node for which the AE is being constructed. atributeName (string): the name of the multi attribute.changedCommand (string): the MEL command or procedure to be executed when the value of the multi attribute is changed.elementIndexString (string): a colon separated list of indices at which the elements of the multi attribute live.returns (int): Return 1 if the callback handled the multi attribute, Return 0 if Maya should provide its default handling.AEnewAttributeHandlerThis hook is called to give plugins a chance to provide a UI creation handler for attributes. nodeName (string): the name of the node for which the AE is being constructed. atributeName (string): the name of the attribute.uiName (string): the UI name of the attribute.changedCommand (string): the MEL command or procedure to be executed when the value of the attribute is changed.returns (string): if the callback handled the attribute then it should return the full name of the topmost UI element that it created, otherwise it should return an empty string.AEreplaceAttributeHandlerThis hook is called to give plugins a chance to provide an update handler for attributes. nodeName (string): the name of the node for which the AE is being constructed. atributeName (string): the name of the attribute.changedCommand (string): the MEL command or procedure to be executed when the value of the attribute is changed.returns (int): Return 1 if the callback handled the attribute, Return 0 if Maya should provide its default handling.provideClassificationStringsThis hook must be supplied by all third parties that add nodes to the \'shader/surface\' classification namespace. returns (string): a colon separated list representing the different plugin node classifications.provideClassificationExclusionStringsThis hook is called to give plugins a chance to provide a list of classifications which should be filtered out from a nodeTreeLister category. For example a plugin might want to filter out nodes classified as both \'material\' and \'legacy\' out of the \'material\' category. classification (string): the classification the nodeTreeBuilder is inquiring about.returns (string): a colon separated list representing the different classifications that should be excluded from the classification the nodeTreeBuilder is inquiring about.provideClassificationStringsForFilteredTreeListerThis hook is called by \'createAssignNewMaterialTreeLister\' and gives plugins a chance to append to the classification filter passed to the Tree Lister builder. It must return a string where each new classification is separated by a white space. currentFilterString (string): a white-space-separated string representing the current classifications.nodeCanBeUsedAsMaterialThe hook is used by the RMB \'Assign Favorite Material\' menu to determine which shading nodes can be used as materials. It must return 1 if the node can be used as a material node and 0 otherwise. nodeId (string): the node Id of the shading node being queried.nodeOwner (string): the name of the plugin the node belongs to.addHeaderContentToMayaLambertianShadersAEThis hook is called to give plugins a chance to add content to the header of the Attribute Editor of Maya\'s Lambertian-â€‹derived shaders. nodeName (string): the name of the node for which the Attribute Editor is being constructed.provideNodeToAttrConnectionThis hook is called to give plugins a chance to provide which output attribute should be used when a node is connected to an input attribute. If an input attribute type is given an output attribute of matching type should be returned. If no attribute type is specified (empty string) a preferred output attribute of any type can be returned. If no output attribute of matching type is available an empty string should be returned. nodeType (string): the node type of the node queried.attributeType (string): the data type of the input attribute.returns (string): the name of the output attribute to use.provideNodeToNodeConnectionThis hook is called to give plugins a chance to provide which attributes should be connected when a node to node connection is made. Both the source and destination attributes should be returned in a colon separated list, e.g. "src1:dst1:src2:dst2:src3:dst3" srcType (string): the node type of the source node.dstType (string): the node type of the destination node.returns (string): A colon separated list of source and destination attribute names.provideOutputAttributeNameForTextureNodeThis hook is called to give plugins a chance to provide a different output attribute name for Texture nodes. If this hook isn\'t provided \'outColor\' is used. nodeName (string): the name of the texture node queried.returns (string): the output attribute name of the Texture node.addItemsToHypergraphNodePopupMenuThis hook is called to give plugins a chance to add items to the Hypergraph node popup menu. nodeName (string): the name of the node for which the Hypergraph node menu is being constructed.addItemsToRenderLayerEditorPopupMenuThis hook is called to give plugins a chance to add items to the Render Layer Editor popup menu. layerName (string): the name of the render layer for which the popup menu is being constructed.preventMaterialDeletionFromCleanUpSceneCommandThis hook is called by the cleanUpScene command and gives the plugin a chance to communicate that a material node is still in use and shouldn\'t be deleted. The hook is called once per plug/connection pair of each shader instance. shader (string): the name of the shader node being deleted.plug (string): the name of the plug queried.connection (string): the name of the connection queried.connectNodeToNodeOverrideCallbackThis hook is called to give plugins a chance to redefine the behavior of drag and drop. srcNode (string): the name of the source node (the dragged node).dstNode (string): the name of the destination node (the dropped-on node).returns (int): Return 1 if Maya should perform the operation that would normally result from this connection. Return 0 to override and provide custom behavior.prepareRenderChangedThis hook is called after an edit on a traversal set with the prepareRender command. enableRenderPassMenuOfRenderViewThis hook is called to give plugins a chance to tell Maya it should enable the render pass menu of the render view (under File->Load Render Pass). \'addRenderPassMenuItemsToRenderView\' can be used to add items to this menu. returns (int): Return 1 if the plugin wants the render pass menu of the render view to be enabled. Return 0 otherwise.addItemsToRenderPassMenuOfRenderViewThis hook is called to give plugins a chance to add menu items to the \'render pass\' menu of the render view (under File->Load Render Pass). \'enableRenderPassMenuOfRenderView\' can be used to enable the render pass menu of the render view. addItemsToRMBMenuOfTreeListerThis hook is called to give plugins a chance to populate the RMB menu of nodes listed in a tree lister. Plugins should add a menu item divider (using: menuItem -divider true) before adding any more items to the RMB menu. nodeType (string): The node type of the tree lister node for which the RMB menu is being built.scriptCommand (string): The script command associated with the tree lister node for which the RMB menu is being built.returns (int): Return 0 if Maya should append its own items to the menu of the current node type. This should be the return value for all node types a plugin isn\'t explicitly interested in. Return 1 if Maya shouldn\'t add any of its items to the menu of the current node type. Note: All menu items related to managing the \'Favorites\' section of the tree lister will always be added to the RMB menu regardless of the return value (those are treated as special cases).saveCustomNodePresetAttributesThis hook is called to give plugins a chance to store extra commands in the node preset file being saved. presetNodeToSave (string): The name of the preset node being saved.returns (string): The custom procedure to use to generate the mel script to be appended to the nodePreset -custom flag of the current presetNode save event (see the documentation of the nodePreset command for more information on the format of the -custom flag).addItemToFileMenuThis hook is called to give plugins a chance to add menu items to the main File menu. addItemToCreateLightMenuThis hook is called to give plugins a chance to add menu items to the create light menu. textureReloadThis hook is called to give plugins a chance to update all nodes that reference the texture file. file (string): the file path of the texture to reload.renderSettingsBuiltThis hook is called after the render settings window has been built. rendererAddOneTabToGlobalsWindowCreateProcThis hook is called to allow renderers the opportunity to add renderer specific tabs to the unified render globals window (render settings window). createProc (string): the name of the procedure used to create the content of the tab. shouldEarlyReturnFromUpdateMultiCameraBufferNamingMenuThis hook is called to allow users to early return from the updateMultiCameraBufferNamingMenu() function by returning "true" in the callback handler. returns (string): Returns "true" if the caller wishes to early return from the updateMultiCameraBufferNamingMenu() function.shouldEarlyReturnFromUpdateMayaSoftwareImageFormatControlThis hook is called to allow users to early return from the updateMayaSoftwareImageFormatControl() function by returning "true" in the callback handler. returns (string): Returns "true" if the caller wishes to early return from the updateMayaSoftwareImageFormatControl() function.shouldEarlyReturnFromUpdateDefaultTraversalSetMenuThis hook is called to allow users to early return from the updateDefaultTraversalSetMenu() function by returning "true" in the callback handler. returns (string): Returns "true" if the caller wishes to early return from the updateDefaultTraversalSetMenu() function.shouldEarlyReturnFromShouldAppearInNodeCreateUIThis hook is called to allow users to early return from the shouldAppearInNodeCreateUI() function by returning "true" in the callback handler. returns (string): Returns "true" if the caller wishes to early return from the shouldAppearInNodeCreateUI() function.updateAEThis hook is called at the end of the updateAE() function.'},
                         'dumpCallbacks': {'docstring': 'Gives a list of all the registered callbacks for all hooks and owners. Can be useful for debugging.'},
                         'executeCallbacks': {'docstring': 'Execute the callbacks for the specified hook, passing the extra arguments to each callback when it is executed.  Returns an array (MEL) or list (Python) containing the return values from each callback that was executed. If a callback returns no value, the array will contain an empty string (MEL) or None (Python).'},
                         'hook': {'docstring': 'The name of the hook for which the callback should be registered.'},
                         'listCallbacks': {'docstring': 'Get the list of callbacks for the specified hook name. If the owner is specified, only callbacks for the specified hook and owner will be listed.'},
                         'owner': {'docstring': 'The name of the owner registering the callback. This is typically a plugin name.'},
                         'removeCallback': {'docstring': 'Remove an existing callback for the specified hook name. The owner must also be specified when removing a callback. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'camera': {'description': 'Create, edit, or query a camera with the specified properties. The resulting camera can be repositioned using the viewPlace command. Many of the camera settings only affect the resulting rendered image. E.g. the F/Stop, shutter speed, the film related options, etc. Scaling the camera icon does not change any camera properties. ',
            'flags': {'aspectRatio': {'docstring': 'The ratio of the film back width to the film back height.'},
                      'cameraScale': {'docstring': 'Scale the camera.'},
                      'centerOfInterest': {'docstring': "Set the linear distance from the camera's eye point to the center of interest."},
                      'clippingPlanes': {'docstring': 'Activate manual clipping planes.'},
                      'depthOfField': {'docstring': 'Determines whether a depth of field calculation is performed to give varying focus depending on the distance of the objects.'},
                      'displayFieldChart': {'docstring': 'Activate display of the video field chart when looking through the camera.'},
                      'displayFilmGate': {'docstring': 'Activate display of the film gate icons when looking through the camera.'},
                      'displayFilmOrigin': {'docstring': 'Activate the display of the film origin guide when looking through the camera.'},
                      'displayFilmPivot': {'docstring': 'Activate display of the film pivot guide when looking through the camera.'},
                      'displayGateMask': {'docstring': 'Display the gate mask, file or resolution, as a shaded area to the edge of the viewport.'},
                      'displayResolution': {'docstring': 'Activate display of the current rendering resolution (as defined in the render globals) when looking through the camera.'},
                      'displaySafeAction': {'docstring': 'Activate display of the video Safe Action guide when looking through the camera.'},
                      'displaySafeTitle': {'docstring': 'Activate display of the video Safe Title guide when looking through the camera.'},
                      'edit': {'docstring': ''},
                      'fStop': {'docstring': 'A real lens normally contains a diaphragm or other stop which blocks some of the light that would otherwise pass through it. This stop is usually approximately round, and its diameter as seen from the front of the lens is called the lens diameter. The lens diameter is often described by its relation to the focal length of the lens. A lens whose diameter is one-eighth its local length is said to have an F-stop of 8. This is an optical property of the lens.'},
                      'farClipPlane': {'docstring': 'Specify the distance to the far clipping plane.'},
                      'farFocusDistance': {'docstring': 'Linear distance to the far focus plane.'},
                      'filmFit': {'docstring': 'This describes how the digital image (in pixels) relates to the film back. Since the film back is defined in terms of real numbers with some arbitrary film aspect, and the digital image is defined in integer pixels with an equally arbitrary (and different) resolution, relating the two can get complicated. There are 4 choices: horizontal In this case the digital image is made to fit the film back exactly in the horizontal direction. This then gives each pixel a horizontal size = (film back width) / (horizontal resolution). The pixel height is then = (pixel width) / (pixel aspect ratio). Now that the pixel has a size, resolution gives us a complete image. That image will match the film back exactly in width. It will almost never match in height, either being too tall or too short. By playing with the numbers you can get it pretty close though.verticalThis is the same idea as horizontal fit, only applied vertically. Thus the digital image will match the film back exactly in height, but miss in width.fillThis is a convenience item. The system calculates both horizontal and vertical fits and then applies the one that makes the digital image larger than the film back.overscanOverscanning the film gate in the camera view allows us to choreograph action outside of the frustum from within the camera view without having to resort to a dolly or zoom. This feature is also essential for animating image planes.'},
                      'filmFitOffset': {'docstring': 'Since we know from the above that the digital image may not match the film back exactly, we now have the question of how to position one relative to the other. Thus fit offset. Normally the centers are aligned. Fit offset lets you move the smaller image within the larger one. Specify the distance for film offset (inches).'},
                      'filmRollOrder': {'docstring': 'Specifies how the roll is applied with respect to the pivot value. Rotate-TranslateThe film back is first rotated then translated by the pivot point value.Translate-RotateThe film back is first translated then rotated by the film roll value.'},
                      'filmRollValue': {'docstring': 'This specifies that amount of rotation around the film back. The roll value is specified in degrees. The rotation occurs around the specified pivot point. This value is used to compute a film roll matrix, which is a component of the post-projection matrix.'},
                      'filmTranslateH': {'docstring': 'The horizontal film translation. Values are normalized to the viewing area.'},
                      'filmTranslateV': {'docstring': 'The vertical film translation. Values are normalized to the viewing area.'},
                      'focalLength': {'docstring': 'This is the distance along the lens axis between the lens and the film plane when "focal distance" is infinitely large. This is an optical property of the lens. This double precision parameter is always specified in millimeters.'},
                      'focusDistance': {'docstring': 'Set the focus at a certain distance in front of the camera.'},
                      'homeCommand': {'docstring': 'Specify the command to execute when "viewSet -home" is applied to this camera. All occurances of "%camera" will be replaced with the cameras name before viewSet runs the command.'},
                      'horizontalFieldOfView': {'docstring': 'This is the film back width as seen by the lens when focused at infinity (ie., focal length away) measured as an angle. Note that it has nothing to do with pixels or the digital image or any aspects. Angle of view is a derived field, that is, it is not used internally by Alias and can be completely determined from other information. It is included as a convenience for the user. Its derivation is aov = 2 \\* atan( fbw / (2 \\* f) ) where "aov" is the angle of view, "fbw" is the film back width and "f" is the focal length.'},
                      'horizontalFilmAperture': {'docstring': "The horizontal width of the camera's film plane. The camera's film is located on the film plane. The extent of the film which will be exposed to an image of the scene in front of the lens is limited to a rectangular area described by the film back. This double precision parameter is always specified in inches."},
                      'horizontalFilmOffset': {'docstring': 'Horizontal offset from the center of the film back. Normally the film back will be centered on the lens axis. However, this need not be so. Film offset is the displacement of the center of the film back from the lens axis, also measured in inches. Note that offsetting the film back will distort the image, but will not alter the focus. This double precision parameter is always specified in inches.'},
                      'horizontalPan': {'docstring': 'Horizontal 2D camera pan (inches)'},
                      'horizontalRollPivot': {'docstring': 'The horizontal pivot point from the center of the film back. The pivot point is used during rotation of the film back.  The pivot is the point where the rotation occurs around. This double precision parameter corresponds to the normalized viewport. This value is a part of the post projection matrix.'},
                      'horizontalShake': {'docstring': 'Another horizontal offset from the center of the film back, which can be used and stored on the camera in addition to the horizonal film offset attribute.  This allows for film-based camera shake internal to the camera.  This works in exactly the same units and coordinates that the film offset attribute does. The effect of this attribute is toggled by the shake enabled attribute.'},
                      'journalCommand': {'docstring': 'Journal interactive camera commands. Commands can be undone when a camera is journaled.'},
                      'lensSqueezeRatio': {'docstring': 'This is presently just an information field in the camera editor is meant to convey the horizontal distortion of the anamorphic lens normally used with some film formats. If it were used, it would do something like pixel aspect. Remember however that lens distortion (intentional or not) is slightly different than the output hardware\'s quantization. The fact that a "net" distortion parameter could be used for both may or may not confuse the issue.'},
                      'lockTransform': {'docstring': "Lock the camera. When a camera is locked, its transformation information, that is, its Translate and Rotate properties cannot be adjusted, and the center of interest point cannot be moved. For orthographic cameras, Orthographic Width is also locked. For camera groups, Aim and Up locator's translate is also locked. For stereo cameras, the root camera is locked."},
                      'motionBlur': {'docstring': "Determines whether the camera's image is motion blured (as opposed to an object's image). For example, if you want to blur the camera movement when you are performing a flyby."},
                      'name': {'docstring': 'Name of the camera.'},
                      'nearClipPlane': {'docstring': 'Specify the distance to the NEAR clipping plane.'},
                      'nearFocusDistance': {'docstring': 'Linear distance to the near focus plane.'},
                      'orthographic': {'docstring': 'Activate the orthographic camera.'},
                      'orthographicWidth': {'docstring': 'Set the orthographic projection width.'},
                      'overscan': {'docstring': 'Set the percent of overscan.'},
                      'panZoomEnabled': {'docstring': 'Toggle camera 2D pan and zoom'},
                      'position': {'docstring': 'Three linear values can be specified to translate the camera.'},
                      'postScale': {'docstring': 'The post-scale value.  This value multiplied against the computed projection matrix. It is applied after the the film roll.'},
                      'preScale': {'docstring': 'The pre-scale value. The value is multiplied against the computed projection matrix. It is applied before the film roll.'},
                      'query': {'docstring': ''},
                      'renderPanZoom': {'docstring': 'Toggle camera 2D pan and zoom in render'},
                      'rotation': {'docstring': 'Three angular values can be specified to rotate the camera.'},
                      'shakeEnabled': {'docstring': 'Toggles the effect of the horizontal and vertical shake attributes.'},
                      'shakeOverscan': {'docstring': 'Controls the amount of overscan in the output rendered image. For use when adding film-based camera shake.  Acts as a multiplier to the film aperture on the camera.'},
                      'shakeOverscanEnabled': {'docstring': 'Toggles the effect of the shake overscan attribute.'},
                      'shutterAngle': {'docstring': 'Specify the shutter angle (degrees).'},
                      'startupCamera': {'docstring': 'A startup camera is marked undeletable and implicit. This flag can be used to set or query the startup state of a camera. There must always be at least one startup camera.'},
                      'stereoHorizontalImageTranslate': {'docstring': 'A film-back offset for use in stereo camera rigs.'},
                      'stereoHorizontalImageTranslateEnabled': {'docstring': 'Toggles the effect of the stereo HIT attribute.'},
                      'verticalFieldOfView': {'docstring': 'Set the vertical field of view.'},
                      'verticalFilmAperture': {'docstring': "The vertical height of the camera's film plane. This double precision parameter is always specified in inches."},
                      'verticalFilmOffset': {'docstring': 'Vertical offset from the center of the film back. This double precision parameter is always specified in inches.'},
                      'verticalLock': {'docstring': 'Lock the size of the vertical film aperture.'},
                      'verticalPan': {'docstring': 'Vertical 2D camera pan (inches)'},
                      'verticalRollPivot': {'docstring': 'Vertical pivot point used for rotating the film back. This double precision parameter corresponds to the normalized viewport. This value is used to compute the film roll matrix, which is a component of the post projection matrix.'},
                      'verticalShake': {'docstring': 'Vertical offset from the center of the film back.  See horizontal shake attribute description.  This is toggled by the shake enabled attribute.'},
                      'worldCenterOfInterest': {'docstring': 'Camera world center of interest point.'},
                      'worldUp': {'docstring': 'Camera world up vector.'},
                      'zoom': {'docstring': 'The percent over the film viewable frustum to display                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'cameraSet': {'description': 'This command manages camera set nodes. Camera sets allow the users to break a single camera shot into layers. Instead of drawing all objects with a single camera, you can isolate the camera to only focus on certain objects and layer another camera into the viewport that draws the other objects. The situation to use camera sets primarily occurs when building stereoscopic scenes. For example, a set of stereo parameters may make the background objects divergent beyond the tolerable range of the human perceptual system. However, you like the settings because the main focus is in the foreground and the depth is important to the visual look of the scene.  You can use camera sets to break apart the shot into a foreground stereo camera and background stereo camera. The foreground stereo camera will retain the original parameters; however, it will only focus on the foreground elements.  The background stereo camera will have a different set of stereo parameters and will only draw the background element. Camera sets can be viewed using the stereo viewer and are currently only designed to work with stereo camera rigs. ',
               'flags': {'active': {'docstring': 'Gets / sets the active camera layer.'},
                         'appendTo': {'docstring': 'Append a new camera and/or object set to then end of the cameraSet layer list. This flag cannot be used in conjunction with insert flag. Additionally, it requires the camera and/or objectSet flag to be used.'},
                         'camera': {'docstring': 'Set/get the camera for a particular layer. When in query mode, You must specify the layer with the layer flag.'},
                         'clearDepth': {'docstring': 'Specifies if the drawing buffer should be cleared before beginning the draw for that layer.'},
                         'deleteAll': {'docstring': 'Delete all camera layers'},
                         'deleteLayer': {'docstring': 'Delete a layer from the camera set. You must specify the layer using the layer flag.'},
                         'edit': {'docstring': ''},
                         'insertAt': {'docstring': 'Inserts the specified camera and/or object set at the specified layer. This flag cannot be used in conjunction with the append flag. Additionally, this flag requires layer and camera (or objectSet) flag to be used.'},
                         'layer': {'docstring': 'Specifies the layer index to be used when accessing layer information'},
                         'name': {'docstring': 'Gets or sets the name for the created camera set.'},
                         'numLayers': {'docstring': 'Returns the number of layers defined in the specified cameraSet'},
                         'objectSet': {'docstring': 'Set/get the objectSet for a particular layer. When in query mode, you must specify the layer with the layer flag.'},
                         'order': {'docstring': 'Set the order in which a particular layer is processed. This flag must be used in conjunction with the layer flag.                  Flag can have multiple arguments, passed either as a tuple or a list.'},
                         'query': {'docstring': ''}}},
 'cameraView': {'description': "This command creates a preset view for a camera which is then independent of the camera. The view stores a camera's eye point, center of interest point, up vector, tumble pivot, horizontal aperture, vertical aperature, focal length, orthographic width, and whether the camera is orthographic or perspective by default. Or you can only store 2D pan/zoom attributes by setting the bookmarkType to 1. These settings can be applied to any other camera through the set camera flag. This command can be used for creation or edit of camera view objects.  This command can only be executed with one of the add bookmark, or remove bookmark and one of set camera, or the set view flags set. ",
                'flags': {'addBookmark': {'docstring': 'Associate this view with the camera specified or the camera in the active model panel. This flag can be used for creation or edit.'},
                          'animate': {'docstring': 'Set the animation capability for view switches.'},
                          'bookmarkType': {'docstring': 'Specify the bookmark type, which can be: 0. 3D bookmark; 1. 2D Pan/Zoom bookmark.'},
                          'camera': {'docstring': 'Specify the camera to use. This flag should be used in conjunction with the add bookmark, remove bookmark, set camera, or set view flags. If this flag is not specified the camera in the active model panel will be used.'},
                          'edit': {'docstring': ''},
                          'name': {'docstring': 'Set the name of the view. This flag can only be used for creation.'},
                          'removeBookmark': {'docstring': 'Remove the association of this view with the camera specified or the camera in the active model panel. This can only be used with edit.'},
                          'setCamera': {'docstring': 'Set this view into a camera specified by the camera flag or the camera in the active model panel. This flag can only be used with edit.'},
                          'setView': {'docstring': 'Set the camera view to match a camera specified or the active model panel. This flag can only be used with edit.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'canCreateCaddyManip': {'description': 'This command returns true if there can be a manipulator made for the specified selection, false otherwise. ',
                         'flags': {}},
 'canCreateManip': {'description': 'This command returns true if there can be a manipulator made for the specified selection, false otherwise. ',
                    'flags': {}},
 'canvas': {'description': 'Creates a control capable of displaying a color swatch. This control can also accept a command to be called when the colour swatch is pressed by the user. Note: The -dgc/dragCallback and -dpc/dropCallback are not available for this control. ',
            'flags': {'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                      'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                      'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                      'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                      'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                      'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                      'edit': {'docstring': ''},
                      'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                      'enableBackground': {'docstring': 'Enables the background color of the control.'},
                      'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                      'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                      'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                      'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                      'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                      'hsvValue': {'docstring': 'Three float values corresponding to the hue, saturation, and value color components, where the hue value ranges from 0.0 to 360.0 and the saturation and value components range from 0.0 to 1.0.'},
                      'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                      'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                      'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                      'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                      'parent': {'docstring': 'The parent layout for this control.'},
                      'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                      'pressCommand': {'docstring': 'Command to be executed when there is a mouse press.'},
                      'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                      'query': {'docstring': ''},
                      'rgbValue': {'docstring': 'Three float values corresponding to the red, green, and blue color components, all of which range from 0.0 to 1.0.'},
                      'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                      'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                      'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                      'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                      'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'changeSubdivComponentDisplayLevel': {'description': 'Explicitly forces the subdivision surface to display components at a particular level of refinement. \t         ',
                                       'flags': {'level': {'docstring': 'Specifies the display level of components.'},
                                                 'query': {'docstring': ''},
                                                 'relative': {'docstring': 'If set, level refers to the relative display level \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'changeSubdivRegion': {'description': 'Changes a subdivision surface region based on the command parameters. The command operates on the selected subdivision surfaces. \t         ',
                        'flags': {'action': {'docstring': 'Specifies the action to the selection region      1 = delete selection region      2 = enlarge selection region'},
                                  'level': {'docstring': 'Specify the level of the subdivision surface to perform the operation \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'channelBox': {'description': 'This command creates a channel box, which is sensitive to the active list.  It displays certain attributes (channels) of the last node on the active list, and provides a two-way connection to keep the widget up to date. Note: when setting the color of attribute names, that color is only valid for its current Maya session; each subsequent session will display the default color for the attribute name(s) listed in the Channel Box. Any subsequent attributes that are added to the Channel Box will be affected by prior regular expressions in their current Maya session. ',
                'flags': {'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                          'attrBgColor': {'docstring': 'Controls the background text color of specific attribute names. As with the foreground option, this text coloring also depends on the node name choice for the nodeRegex flag. Arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. If attrRegex is unspecified then it will assume a value of "\\*" for a regular expression. The same idea simultaneously applies to the flag nodeRegex. Note: nodes that are renamed will have their node name coloring be affected in the channel box.'},
                          'attrColor': {'docstring': 'Controls the foreground text color of specific attribute names. This text coloring also depends on the node name choice for the nodeRegex flag. Arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. If attrRegex is unspecified then it will assume a value of "\\*" for a regular expression. The same idea simultaneously applies to the flag nodeRegex. Note: nodes that are renamed will have their node name coloring be affected in the channel box.'},
                          'attrFilter': {'docstring': 'Specifies the name of an itemFilter object to be placed on the channel box. This filters the attributes displayed. A filter of "0" can be used to reset the filter.'},
                          'attrRegex': {'docstring': 'Specifies a valid regular expression to specify which attribute names should be selected for foreground text coloring. If attrRegex is unspecified then it will assume a value of "\\*" for a regular expression. The same idea simultaneously applies to the flag nodeRegex. The attrColor flag is required to be specified. Note: this regular expression will be treated as though it were case-insensitve'},
                          'attributeEditorMode': {'docstring': 'Modifies what appears in the channel box for use in the attribute editor. Default is false. Queried, returns a boolean.'},
                          'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                          'containerAtTop': {'docstring': 'This flag can be used to specify whether or not the container is drawn at the top of the channel box when a node in the container is selected.'},
                          'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                          'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                          'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                          'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                          'edit': {'docstring': ''},
                          'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                          'enableBackground': {'docstring': 'Enables the background color of the control.'},
                          'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                          'enableLabelSelection': {'docstring': 'Enables the selection of attributes in the channelBox when used in conjunction with -attributeEditorMode. Default is false.  Queried, returns a boolean.'},
                          'execute': {'docstring': 'Immediately executes the command string once for every cell (or every selected cell, if the boolean argument is TRUE) in the channel box, for every matching selected object (ie, for every object would be affected if you changed a cell value.)  Before the command is executed, "#A" is substituted with the name of the attribute, and "#N" with the name of the node, and "#P" with the full path name of the node.'},
                          'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                          'fieldWidth': {'docstring': 'An optional flag which is used to modify the width assigned to fields appearing in the channelBox.'},
                          'fixedAttrList': {'docstring': 'Forces the channel box to only display attributes with the specified names, in the order they are specified.  If an empty list is specified, then the channel box will revert to its default behaviour of listing all keyable attributes.'},
                          'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                          'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                          'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                          'historyObjectList': {'docstring': 'Returns a list of strings, the names of every INPUT node associated with an object on the main object list that is of the same type as the node displayed in the INPUT section of the channel box.'},
                          'hyperbolic': {'docstring': 'Determines whether or not the distance that the mouse has been dragged should be interpreted as a linear or hyperbolic function.  The default is set to hyperbolic being false.'},
                          'inputs': {'docstring': "Returns the items shown under the 'INPUTS' heading in the channel box."},
                          'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                          'labelWidth': {'docstring': 'An optional flag which is used to modify the width assigned to labels appearing in the channelBox.'},
                          'longNames': {'docstring': 'Controls whether long or short attribute names will be used in the interface.  Note that this flag is ignored if the -niceNames flag is set.  Default is short names. Queried, returns a boolean.'},
                          'mainListConnection': {'docstring': 'Specifies the name of a selectionConnection object which the editor will use as its source of content.  The channel box will only display the (last) item contained in the selectionConnection object. If a NULL string ("") is specified, then the channel box will revert to its default behaviour of working on the active list.'},
                          'mainObjectList': {'docstring': 'Returns a list of strings, the names of every object on the active list that is the same type as the object displayed in the top (main) section of the channel box.'},
                          'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                          'maxHeight': {'docstring': 'An optional flag which is used to limit the height of the channelBox.'},
                          'maxWidth': {'docstring': 'An optional flag which is used to limit the width of the channelBox.'},
                          'niceNames': {'docstring': 'Controls whether the attribute names will be displayed in a more user-friendly, readable way.  When this is on, the longNames flag is ignored.  When this is off, attribute names will be displayed either long or short, according to the longNames flag. Default is on. Queried, returns a boolean.'},
                          'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                          'nodeRegex': {'docstring': 'Specifies a valid regular expression to specify which node names should (potentially) have their attributes selected for foreground text coloring. If nodeRegex is unspecified then it will assume a value of "\\*\' for a regular expression. The same idea simultaneously applies to the flag attrRegex. The attrColor flag is required to be specified. Note: this regular expression will be treated as though it were case-insensitve Note: nodes in namespaces have regular expressions applied as though those nodes weren\'t in namespaces'},
                          'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                          'outputObjectList': {'docstring': 'Returns a list of strings, the names of every OUTPUT node associated an object on the main object list that is of the same type as the node displayed in the OUTPUT section of the channel box.'},
                          'outputs': {'docstring': "Returns the items shown under the 'OUTPUTS' heading in the channel box."},
                          'parent': {'docstring': 'The parent layout for this control.'},
                          'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                          'precision': {'docstring': 'Controls the number of digits to the right of the decimal point that will be displayed for float-valued channels. Default is 3.  Queried, returns an int.'},
                          'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                          'query': {'docstring': ''},
                          'select': {'docstring': 'Allows programmatic selection of items (nodes or plugs) in the channel box. Selection is equivalent to clicking the item with the mouse; therefore only items currently shown in the channel box can be selected this way.'},
                          'selectedHistoryAttributes': {'docstring': 'Returns a list of strings, the names of all the selected attributes in the INPUT section of the channel box.'},
                          'selectedMainAttributes': {'docstring': 'Returns a list of strings, the names of all the selected attributes in the top section of the channel box.'},
                          'selectedOutputAttributes': {'docstring': 'Returns a list of strings, the names of all the selected attributes in the OUTPUT section of the channel box.'},
                          'selectedShapeAttributes': {'docstring': 'Returns a list of strings, the names of all the selected attributes in the middle (shape) section of the channel box.'},
                          'shapeObjectList': {'docstring': 'Returns a list of strings, the names of every shape associated with an object on the main object list that is of the same type as the object displayed in the middle (shape) section of the channel box.'},
                          'shapes': {'docstring': "Returns the items shown under the 'SHAPES' heading in the channel box."},
                          'showNamespace': {'docstring': 'Controls whether or not the namespace of an object is displayed if the object is not in the root namespace.'},
                          'showTransforms': {'docstring': 'Controls whether this control will display transform attributes only, or all other attributes. False by default. Queried, returns a boolean.'},
                          'speed': {'docstring': 'Controls the speed at which the attributes are changed based on the distance the mouse has been dragged.  Common settings for slow/medium/fast are 0.1/1.0/10.0 respectively.  The default is 1.0.'},
                          'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                          'takeFocus': {'docstring': 'causes the channel box to take over the keyboard focus, if it can.'},
                          'update': {'docstring': 'This flag can be used to force an update of the channel box display, for example after changing a display preference.'},
                          'useManips': {'docstring': 'When you click on a field or label in the channel box, the tool switches to a manipulator that can change that value if you drag in the 3d view.  This flag controls the kind of manips.  Allowed values are "none" (self-explanatory), "invisible" (you won\'t see anything, but dragging in the window will adjust any of the selected attributes), and "standard" (the same as invisible, except for scale, rotate, and translate, which will be represented by their usual manips.)'},
                          'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                          'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                          'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                          'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'character': {'description': 'This command is used to manage the membership of a character.  Characters are a type of set that gathers together the attributes of a node or nodes that a user wishes to animate as a single entity. ',
               'flags': {'addElement': {'docstring': 'Adds the list of items to the given character.  If some of the items cannot be added to the character because they are in another character, the command will fail.  When another character is passed to to -addElement, is is added as a sub character.  When a node is passed in, it is expanded into its keyable attributes, which are then added to the character.'},
                         'addOffsetObject': {'docstring': 'Indicates that the selected character member objects should be used when calculating and applying offsets. The flag argument is used to specify the character.'},
                         'anyMember': {'docstring': 'An operation which tests whether any of the given items are members of the given set.'},
                         'characterPlug': {'docstring': 'Returns the plug on the character that corresponds to the specified character member.'},
                         'clear': {'docstring': 'An operation which removes all items from the given character.'},
                         'edit': {'docstring': ''},
                         'empty': {'docstring': 'Indicates that the character to be created should be empty. (i.e. it ignores any arguments identifying objects to be added to the character.'},
                         'excludeDynamic': {'docstring': 'When creating the character, exclude dynamic attributes.'},
                         'excludeRotate': {'docstring': 'When creating the character, exclude rotate attributes from transform-type nodes.'},
                         'excludeScale': {'docstring': 'When creating the character, exclude scale attributes from transform-type nodes.'},
                         'excludeTranslate': {'docstring': 'When creating the character, exclude translate attributes from transform-type nodes. For example, if your character contains joints only, perhaps you only want to include rotations in the character.'},
                         'excludeVisibility': {'docstring': 'When creating the character, exclude visibility attribute from transform-type nodes.'},
                         'flatten': {'docstring': "An operation that flattens the structure of the given character. That is, any characters contained by the given character will be replaced by its members so that the character no longer contains other characters but contains the other characters' members."},
                         'forceElement': {'docstring': 'For use in edit mode only. Forces addition of the items to the character. If the items are in another character which is in the character partition, the items will be removed from the other character in order to keep the characters in the character partition mutually exclusive with respect to membership.'},
                         'include': {'docstring': 'Adds the list of items to the given character.  If some of the items cannot be added to the character, a warning will be issued. This is a less strict version of the -add/addElement operation.'},
                         'intersection': {'docstring': 'An operation that returns a list of items which are members of all the character in the list.  In general, characters should be mutually exclusive.'},
                         'isIntersecting': {'docstring': 'An operation which tests whether or not the characters in the list have common members.  In general, characters should be mutually exclusive, so this should always return false.'},
                         'isMember': {'docstring': 'An operation which tests whether or not all the given items are members of the given character.'},
                         'library': {'docstring': 'Returns the clip library associated with this character, if there is one. A clip library will only exist if you have created clips on your character.'},
                         'memberIndex': {'docstring': 'Returns the memberIndex of the specified character member if used after the query flag. Or if used before the query flag, returns the member that corresponds to the specified index.'},
                         'name': {'docstring': 'Assigns string as the name for a new character. Valid for operations that create a new character.'},
                         'noWarnings': {'docstring': 'Indicates that warning messages should not be reported such as when trying to add an invalid item to a character. (used by UI)'},
                         'nodesOnly': {'docstring': 'This flag modifies the results of character membership queries. When listing the attributes (e.g. sphere1.tx) contained in the character, list only the nodes.  Each node will only be listed once, even if more than one attribute or component of the node exists in the character.'},
                         'offsetNode': {'docstring': 'Returns the name of the characterOffset node used to add offsets to the root of the character.'},
                         'query': {'docstring': ''},
                         'remove': {'docstring': 'Removes the list of items from the given character.'},
                         'removeOffsetObject': {'docstring': 'Indicates that the selected character offset objects should be removed as offsets. The flag argument is used to specify the character.'},
                         'root': {'docstring': "Specifies the transform node which will act as the root of the character being created. This creates a characterOffset node in addition to the character node, which can be used to add offsets to the character to change the direction of the character's animtion without inserting additional nodes in its hierarchy."},
                         'scheduler': {'docstring': 'Returns the scheduler associated with this character, if there is one. A scheduler will only exist if you have created clips on your character.'},
                         'split': {'docstring': 'Produces a new set with the list of items and removes each item in the list of items from the given set.'},
                         'subtract': {'docstring': 'An operation between two characters which returns the members of the first character that are not in the second character. In general, characters should be mutually exclusive.'},
                         'text': {'docstring': 'Defines an annotation string to be stored with the character.'},
                         'union': {'docstring': 'An operation that returns a list of all the members of all characters listed.'},
                         'userAlias': {'docstring': 'Returns the user defined alias for the given attribute on the character or and empty string if there is not one.  Characters automatically alias the attributes where character animation data is stored.  A user alias will exist when the automatic aliases are overridden using the aliasAttr command.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'characterMap': {'description': 'This command is used to create a correlation between the attributes of 2 or more characters. \t         ',
                  'flags': {'edit': {'docstring': ''},
                            'mapAttr': {'docstring': 'In query mode, this flag can be used to query the mapping stored by the specified map node. It returns an array of strings. In non-query mode, this flag can be used to create a mapping between the specified character members. Any previous mapping on the attributes is removed in favor of the newly specified mapping.'},
                            'mapMethod': {'docstring': 'This is is valid in create mode only. It specifies how the mapping should be done. Valid options are: "byNodeName", "byAttrName", and "byAttrOrder". "byAttrOrder" is the default. The flags mean the following: "byAttrOrder" maps using the order that the character stores the attributes internally, "byAttrName" uses the attribute name to find a correspondence, "byNodeName" uses the node name \\*and\\* the attribute name to find a correspondence.'},
                            'mapNode': {'docstring': 'This flag can be used to map all the attributes on the source node to their matching attributes on the destination node.'},
                            'mapping': {'docstring': 'This flag is valid in query mode only. It must be used before the query flag with a string argument. It is used for querying the mapping for a particular attribute.  A string array is returned.'},
                            'proposedMapping': {'docstring': 'This flag is valid in query mode only. It is used to get an array of the mapping that the character map would prvide if called with the specified characters and the (optional) specified mappingMethod. If a character map exists on the characters, the map is not affected by the query operation.  A string array is returned.'},
                            'query': {'docstring': ''},
                            'unmapAttr': {'docstring': 'This flag can be used to unmap the mapping stored by the specified map node.'},
                            'unmapNode': {'docstring': 'This flag can be used to unmap all the attributes on the source node to their matching attributes on the destination node. Note that mapped attributes which do not have matching names, will not be unmapped. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'characterize': {'description': 'This command is used to scan a joint hierarchy for predefined joint names or labels. If the required joints are found, human IK effectors will be created to control the skeleton using full-body IK. Alternatively, you can manually create all of the components required for fullbody IK, and use this command to hook them up. Fullbody IK needs 3 major components: the user input skeleton (sk), the fk skeleton on which keys are set (fk) and the hik effectors (ik).  Together fk and ik provide parameters to the fullbody IK engine, which solves for the output and plots it onto sk. This command usage is used internally by Maya when importing data from fbx files, but is not generally recommended. Note that a minimum set of required joint names or joint labels  must be found in order for the characterize command to succeed. Please refer to the Maya documentation for details on properly naming or labeling your skeleton. The skeleton should also be z-facing, with its y-axis up, its left hand parallel to positive x-axis and right hand parallel to negative x-axis. END_COMMENT \t         ',
                  'flags': {'activatePivot': {'docstring': 'Activates a pivot that has been properly placed.  After activating this new pivot, you will now be able to rotate and translate about this pivot. A pivot behaves in all ways the same as an effector (it IS an effector, except that it is offset from the normal position of the effector to allow one to rotate about a different point.'},
                            'addAuxEffector': {'docstring': 'Adds an auxilliary (secondary) effector to an existing effector.'},
                            'addFloorContactPlane': {'docstring': 'Adds a floor contact plane to one of the hands or feet.  With this plane, you will be able to adjust the floor contact height.  Select a hand or foot effector and then issue the characterize command with this flag.'},
                            'addMissingEffectors': {'docstring': 'This flag tells the characterize command to look for any effectors that can be added to the skeleton. For example, if the user has deleted some effectors or added fingers to an existing skeleton, "characterize -e -addMissingEffectors" can be used to restore them.'},
                            'attributeFromHIKProperty': {'docstring': 'Query for the attribute name associated with a MotionBuilder property.'},
                            'attributeFromHIKPropertyMode': {'docstring': 'Query for the attribute name associated with a MotionBuilder property mode.'},
                            'autoActivateBodyPart': {'docstring': 'Query or change whether auto activation of character nodes representing body parts should be enabled.'},
                            'changePivotPlacement': {'docstring': 'Reverts a pivot back into pivot placement mode.  A pivot that is in placement mode will not participate in full body manipulation until it has been activated with the -activatePivot flag.'},
                            'edit': {'docstring': ''},
                            'effectors': {'docstring': 'Specify the effectors to be used by human IK by providing 2 pieces of information for each effector:  1) the partial path of the effector and 2) the name of the full body effector this represents.  1) and 2) are to be separated by white space, and multiple entries separated by ",". Normally, the effectors are automatically created.  This flag is for advanced users only.'},
                            'fkSkeleton': {'docstring': 'Specify the fk skeleton to be used by human IK by providing 2 pieces of information for each joint of the FK skeleton:  1) the partial path of the joint and 2) the name of the full body joint this represents.  1) and 2) are to be separated by white space, and multiple entries separated by ",". Normally, the fk control skeleton is automatically created.  This flag is for advanced users only.'},
                            'name': {'docstring': 'At characterization (FBIK creation) time, use this flag to name your FBIK character. This will affect the name of the hikHandle node and the control rig will be put into a namespace that matches the name of your character.  If you do not specify the character name, a default one will be used. At the moment edit and query of the character name is not supported.'},
                            'pinHandFeet': {'docstring': 'When the character is first being characterized, pin the hands and feet by default.'},
                            'placeNewPivot': {'docstring': 'Creates a new pivot and puts it into placement mode.  Note that you will not be able to do full body manipulation about this pivot until you have activated it with the -activatePivot flag. A pivot behaves in all ways the same as an effector (it IS an effector, except that it is offset from the normal position of the effector to allow one to rotate about a different point). A new pivot created with this flag allow you to adjust the offset interactively before activating it.'},
                            'posture': {'docstring': 'Specifies the posture of the character. Valid options are "biped" and "quadruped". The default is "biped".'},
                            'query': {'docstring': ''},
                            'sourceSkeleton': {'docstring': 'This flag can be used to characterize a skeleton that has not been named or labelled according to the FBIK guidelines. It specifies the association between the actual joint names and the expected FBIK joint names. The format of the string is as follows: For each joint that the user wants to involve in the solve:  1) the partial path of the joint and 2) the name of the full body joint this represents.  1) and 2) are to be separated by white space, and multiple entries separated by ",".'},
                            'stancePose': {'docstring': 'Specify the default stance pose to be used by human IK.  The stance pose is specified by providing 2 pieces of information for each joint involved in the solve: 1) the partial path to the joint and 2) 9 numbers representing translation rotation and scale. 1) and 2) are to be separated by white space, and multiple entries separated by ",". Normally, the stance pose is taken from the selected skeleton.  This flag is for advanced users only.'},
                            'type': {'docstring': 'Specifies the technique used by the characterization to identify the joint type. Valid options are "label" and "name". When "label" is used, the joints must be labelled using the guidelines described in the Maya documentation. When name is used, the joint names must follow the naming conventions described in the Maya documentation. The default is "name". This flag cannot be used in conjunction with the sourceSkeleton flag. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'checkBox': {'description': "This command creates a check box.  A check box is a simple control containing a text label and a state of either on or off.  Commands can be attached to any or all of the following events:  when the check box is turned on, turned off, or simply when it's state is changed. ",
              'flags': {'align': {'docstring': 'This flag is obsolete and should no longer be used. The check box label will always be left-aligned.'},
                        'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                        'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                        'changeCommand': {'docstring': "Command executed when the check box's state is changed. Note that this flag should not be used in conjunction with onCommand and offCommand. That is, one should either use changeCommand and test the state of the check box from inside the callback, or use onCommand and offCommand as separate callbacks."},
                        'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                        'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                        'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                        'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                        'edit': {'docstring': ''},
                        'editable': {'docstring': "The edit state of the check box.  By default, this flag is set to true and the check box value may be changed by clicking on it.  If false then the check box is 'read only' and can not be clicked on. The value of the check box can always be changed with the -v/valueflag regardless of the state of the -ed/editableflag."},
                        'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                        'enableBackground': {'docstring': 'Enables the background color of the control.'},
                        'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                        'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                        'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                        'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                        'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                        'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                        'label': {'docstring': 'The label text. The default label is the name of the control.'},
                        'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                        'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                        'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                        'offCommand': {'docstring': 'Command executed when the check box is turned off.'},
                        'onCommand': {'docstring': 'Command executed when the check box is turned on.'},
                        'parent': {'docstring': 'The parent layout for this control.'},
                        'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                        'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                        'query': {'docstring': ''},
                        'recomputeSize': {'docstring': "If true then the control will recompute it's size to just fit the size of the label.  If false then the control size will remain fixed as you change the size of the label.  The default value of this flag is true."},
                        'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                        'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                        'value': {'docstring': 'State of the check box.'},
                        'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                        'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                        'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'checkBoxGrp': {'description': 'All of the group commands position their individual controls in columns starting at column 1.  The layout of each control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign, and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one column in any group can be adjustable. This command creates from one to four check boxes in a single row. They can have an optional text label. TelfBaseGrpCmd.cpp ',
                 'flags': {'adjustableColumn': {'docstring': 'Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based index. Passing 0 as argument turns off the previous adjustable column.'},
                           'adjustableColumn2': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly two columns.'},
                           'adjustableColumn3': {'docstring': 'Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly three columns.'},
                           'adjustableColumn4': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly four columns.'},
                           'adjustableColumn5': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly five columns.'},
                           'adjustableColumn6': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly six columns.'},
                           'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                           'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                           'changeCommand': {'docstring': 'Command executed when the group changes state. Note that this flag should not be used in conjunction with onCommand and offCommand. That is, one should either use changeCommand and test the state of a check box from inside the callback, or use onCommand and offCommand as separate callbacks.'},
                           'changeCommand1': {'docstring': ''},
                           'changeCommand2': {'docstring': ''},
                           'changeCommand3': {'docstring': ''},
                           'changeCommand4': {'docstring': 'Specify a changed state command for each respective check box.'},
                           'columnAlign': {'docstring': 'Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type for the specified column.'},
                           'columnAlign2': {'docstring': 'Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are "left", "right", and "center".'},
                           'columnAlign3': {'docstring': 'Sets the text alignment for all three columns.  Ignored if there are not exactly three columns. Valid values are "left", "right", and "center".'},
                           'columnAlign4': {'docstring': 'Sets the text alignment for all four columns.  Ignored if there are not exactly four columns. Valid values are "left", "right", and "center".'},
                           'columnAlign5': {'docstring': 'Sets the text alignment for all five columns.  Ignored if there are not exactly five columns. Valid values are "left", "right", and "center".'},
                           'columnAlign6': {'docstring': 'Sets the text alignment for all six columns.  Ignored if there are not exactly six columns. Valid values are "left", "right", and "center".'},
                           'columnAttach': {'docstring': 'Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies column attachment types and offets.'},
                           'columnAttach2': {'docstring': 'Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are "left", "right", and "both".'},
                           'columnAttach3': {'docstring': 'Sets the attachment type for all three columns. Ignored if there are not exactly three columns. Valid values are "left", "right", and "both".'},
                           'columnAttach4': {'docstring': 'Sets the attachment type for all four columns. Ignored if there are not exactly four columns. Valid values are "left", "right", and "both".'},
                           'columnAttach5': {'docstring': 'Sets the attachment type for all five columns. Ignored if there are not exactly five columns. Valid values are "left", "right", and "both".'},
                           'columnAttach6': {'docstring': 'Sets the attachment type for all six columns. Ignored if there are not exactly six columns. Valid values are "left", "right", and "both".'},
                           'columnOffset2': {'docstring': 'This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the -columnAttach2 flag.  Ignored if there are not exactly two columns.'},
                           'columnOffset3': {'docstring': 'This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the -columnAttach3 flag.  Ignored if there are not exactly three columns.'},
                           'columnOffset4': {'docstring': 'This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the -columnAttach4 flag.  Ignored if there are not exactly four columns.'},
                           'columnOffset5': {'docstring': 'This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the -columnAttach5 flag.  Ignored if there are not exactly five columns.'},
                           'columnOffset6': {'docstring': 'This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the -columnAttach6 flag.  Ignored if there are not exactly six columns.'},
                           'columnWidth': {'docstring': 'Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies the column (1 based index) and the second parameter specifies the width.'},
                           'columnWidth1': {'docstring': 'Sets the width of the first column. Ignored if there is not exactly one column.'},
                           'columnWidth2': {'docstring': 'Sets the column widths of both columns. Ignored if there are not exactly two columns.'},
                           'columnWidth3': {'docstring': 'Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.'},
                           'columnWidth4': {'docstring': 'Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.'},
                           'columnWidth5': {'docstring': 'Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.'},
                           'columnWidth6': {'docstring': 'Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.'},
                           'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                           'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                           'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                           'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                           'edit': {'docstring': ''},
                           'editable': {'docstring': "The edit state of the group.  By default, this flag is set to true and the check box values may be changed by clicking on them.  If false then the check boxes are 'read only' and can not be clicked on. The value of the check boxes can always be changed with the -v/valueflags regardless of the state of the -ed/editableflag."},
                           'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                           'enable1': {'docstring': ''},
                           'enable2': {'docstring': ''},
                           'enable3': {'docstring': ''},
                           'enable4': {'docstring': 'Enable state of the individual check boxes.'},
                           'enableBackground': {'docstring': 'Enables the background color of the control.'},
                           'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                           'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                           'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                           'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                           'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                           'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                           'label': {'docstring': 'When present on creation an optional text label will be built with the group.  The string specifes the label text.'},
                           'label1': {'docstring': ''},
                           'label2': {'docstring': ''},
                           'label3': {'docstring': ''},
                           'label4': {'docstring': 'Specify label strings for the respective check boxes in the group.'},
                           'labelArray2': {'docstring': ''},
                           'labelArray3': {'docstring': ''},
                           'labelArray4': {'docstring': "Specify multiple labels in a single flag.  These flags are ignored if the number of radio buttons doesn't match."},
                           'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                           'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                           'numberOfCheckBoxes': {'docstring': 'Number of check boxes in the group (1 - 4).'},
                           'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                           'offCommand': {'docstring': 'Command executed when any check box turns off.'},
                           'offCommand1': {'docstring': ''},
                           'offCommand2': {'docstring': ''},
                           'offCommand3': {'docstring': ''},
                           'offCommand4': {'docstring': 'Off command for each respective check box.'},
                           'onCommand': {'docstring': 'Command executed when any check box turns on.'},
                           'onCommand1': {'docstring': ''},
                           'onCommand2': {'docstring': ''},
                           'onCommand3': {'docstring': ''},
                           'onCommand4': {'docstring': 'On command for each respective check box.'},
                           'parent': {'docstring': 'The parent layout for this control.'},
                           'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                           'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                           'query': {'docstring': ''},
                           'rowAttach': {'docstring': 'Arguments are : column, attachment type, offset. Possible attachments are: top | bottom | both. Specifies attachment types and offsets for the entire row.'},
                           'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                           'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                           'value1': {'docstring': ''},
                           'value2': {'docstring': ''},
                           'value3': {'docstring': ''},
                           'value4': {'docstring': 'Values for the respective check boxes in the group.'},
                           'valueArray2': {'docstring': ''},
                           'valueArray3': {'docstring': ''},
                           'valueArray4': {'docstring': "Specifies multiple values in a single flag.  These flags are ignored if the number of check boxes doesn't match."},
                           'vertical': {'docstring': 'Whether the orientation of the checkbox controls in this group are horizontal (default) or vertical.'},
                           'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                           'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                           'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'checkDefaultRenderGlobals': {'description': 'To query whether or not the defaultRenderGlobals node has been modified since the last file save, use `ls -modified`. To force the scene to be dirty/clean use `file -modified` \t         In query mode, return type is based on queried flag.',
                               'flags': {'edit': {'docstring': ''},
                                         'query': {'docstring': ''}}},
 'choice': {'description': "The choice command provides a mechanism for changing the inputs to an attribute based on some (usually time-based) criteria. For example, an object could be animated from frames 1 to 30 by a motion path, then from frames 30 to 50 it follows keyframe animation, and after frame 50 it returns to the motion path. Or, a revolve surface could change its input curve depending on some transform's rotation value.The choice command creates a choice node (if one does not already exist) on all specified attributes of the selected objects. If the attribute was already connected to something, that something is now reconnected to the i'th index of the choice node's input (or the next available input if the -in/index flag is not specified). If a source attribute is specified, then that attribute is connected to the choice node's i'th input instead.The choice node operates by using the value of its selector attribute to determine which of its input attributes to pass through to its output. The input attributes can be of any type. For example, if the selector attribute was connected by an animation curve with keyframes at (1,1), (30,2) and (50,1), then that would mean that the choice node would pass on the data from input[1] from time 1 to 30, and after time 50, and the data from input[2] between times 30 and 50.This command returns the names of the created or modified choice nodes, and if a keyframe was added to the animation curve, it specifies the index (or value on the animation curve).",
            'flags': {'attribute': {'docstring': 'specifies the attributes onto which choice node(s) should be created. The default is all keyable attributes of the given objects. Note that although this flag is not queryable, it can be used to qualify which attributes of the given objects to query.'},
                      'controlPoints': {'docstring': 'Explicitly specify whether or not to include the control points of a shape (see "-s" flag) in the list of attributes. Default: false.'},
                      'edit': {'docstring': ''},
                      'index': {'docstring': 'specifies the multi-input index of the choice node to connect the source attribute to. When queried, returns a list of integers one per specified -t/time that indicates the multi-index of the choice node to use at that time.'},
                      'name': {'docstring': 'the name to give to any newly created choice node(s). When queried, returns a list of strings.'},
                      'query': {'docstring': ''},
                      'selector': {'docstring': "specifies the attribute to be used as the choice node's selector. The value of the selector at a given time determines which of the choice node's multi-indices should be used as the output of the choice node at that time. This flag is only editable (it cannot be specified at creation time). When queried, returns a list of strings."},
                      'shape': {'docstring': 'Consider all attributes of shapes below transforms as well, except "controlPoints". Default: true'},
                      'sourceAttribute': {'docstring': 'specifies the attribute to connect to the choice node that will be selected at the given time(s) specified by -t/time.'},
                      'time': {'docstring': 'specifies the time at which the choice should use the given source attribute, or the currently connected attribute if source attribute is not specified. The default is the curren time. Note that although this flag is not queryable, it can be used to qualify the times at which to query the other attributes.       Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'circle': {'description': 'The circle command creates a circle or partial circle (arc) \t         ',
            'flags': {'caching': {'docstring': 'Toggle caching for all attributes so that no recomputation is needed'},
                      'center': {'docstring': 'The center point of the circle.'},
                      'centerX': {'docstring': 'X of the center point. Default:0'},
                      'centerY': {'docstring': 'Y of the center point. Default:0'},
                      'centerZ': {'docstring': 'Z of the center point. Default:0'},
                      'constructionHistory': {'docstring': 'Turn the construction history on or off.'},
                      'degree': {'docstring': 'The degree of the resulting circle: 1 - linear, 3 - cubic Default:3'},
                      'edit': {'docstring': ''},
                      'first': {'docstring': 'The start point of the circle if fixCenter is false. Determines the orientation of the circle if fixCenter is true.'},
                      'firstPointX': {'docstring': 'X of the first point. Default:1'},
                      'firstPointY': {'docstring': 'Y of the first point. Default:0'},
                      'firstPointZ': {'docstring': 'Z of the first point. Default:0'},
                      'fixCenter': {'docstring': 'Fix the center of the circle to the specified center point. Otherwise the circle will start at the specified first point. Default:true'},
                      'frozen': {'docstring': ''},
                      'name': {'docstring': 'Sets the name of the newly-created node. If it contains namespace path, the new node will be created under the specified namespace; if the namespace does not exist, it will be created.'},
                      'nodeState': {'docstring': "Maya dependency nodes have 6 possible states. The Normal (0), HasNoEffect (1), and Blocking (2)states can be used to alter how the graph is evaluated.   The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)are for internal use only. They temporarily shut off parts of the graph during interaction (e.g., manipulation). The understanding is that once the operation is done, the state will be reset appropriately, e.g. Waiting-Blockingwill reset back to Blocking.   The Normaland Blockingcases apply to all nodes, while HasNoEffectis node specific; many nodes do not support this option. Plug-ins store state in the MPxNode::stateattribute. Anyone can set it or check this attribute.  Additional details about each of these 3 states follow.  StateDescriptionNormalThe normal node state. This is the default.HasNoEffectThe HasNoEffectoption (a.k.a. pass-through), is used in cases where there is an operation on an input producing an output of the same data type. Nearly all deformers support this state, as do a few other nodes. As stated earlier, it is not supported by all nodes.  Itâ€™s typical to implement support for the HasNoEffectstate in the nodeâ€™s compute method and to perform appropriate operations. Plug-ins can also support HasNoEffect.  The usual implementation of this state is to copy the input directly to the matching output without applying the algorithm in the node. For deformers, applying this state leaves the input geometry undeformed on the output.  BlockingThis is implemented in the depend node base class and applies to all nodes. Blockingis applied during the evaluation phase to connections. An evaluation request to a blocked connection will return as failures, causing the destination plug to retain its current value. Dirty propagation is indirectly affected by this state since blocked connections are never cleaned.  When a node is set to Blockingthe behavior is supposed to be the same as if all outgoing connections were broken. As long as nobody requests evaluation of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked node will still respond to getAttrrequests but a getAttron a downstream node will not reevaluate the blocked node.  Setting the root transform of a hierarchy to Blockingwonâ€™t automatically influence child transforms in the hierarchy. To do this, youâ€™d need to explicitly set all child nodes to the Blockingstate.  For example, to set all child transforms to Blocking, you could use the following script.  import maya.cmds as cmds def blockTree(root): nodesToBlock = [] for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys(): nodesToBlock += cmds.listConnections(node, source=True, destination=True ) for node in {source:1 for source in nodesToBlock}.keys(): cmds.setAttr( '%s.nodeState' % node, 2 )  Applying this script would continue to draw objects but things would not be animated.  Default:kdnNormal"},
                      'normal': {'docstring': 'The normal of the plane in which the circle will lie.'},
                      'normalX': {'docstring': 'X of the normal direction. Default:0'},
                      'normalY': {'docstring': 'Y of the normal direction. Default:0'},
                      'normalZ': {'docstring': 'Z of the normal direction. Default:1'},
                      'object': {'docstring': 'Create the result, or just the dependency node.                  Flag can have multiple arguments, passed either as a tuple or a list.'},
                      'query': {'docstring': ''},
                      'radius': {'docstring': 'The radius of the circle. Default:1.0'},
                      'sections': {'docstring': 'The number of sections determines the resolution of the circle. Used only if useTolerance is false. Default:8'},
                      'sweep': {'docstring': 'The sweep angle determines the completeness of the circle. A full circle is 2Pi radians, or 360 degrees. Default:6.2831853'},
                      'tolerance': {'docstring': 'The tolerance with which to build a circle. Used only if useTolerance is true Default:0.01'},
                      'useTolerance': {'docstring': 'Use the specified tolerance to determine resolution. Otherwise number of sections will be used. Default:false                  Common flags'}}},
 'circularFillet': {'description': 'The cmd is used to compute the rolling ball surface fillet ( circular fillet ) between two given NURBS surfaces. To generate trim curves on the surfaces, use -cos true. ',
                    'flags': {'caching': {'docstring': 'Toggle caching for all attributes so that no recomputation is needed'},
                              'constructionHistory': {'docstring': 'Turn the construction history on or off.'},
                              'curveOnSurface': {'docstring': 'If possible, create 2D curve as a result.'},
                              'edit': {'docstring': ''},
                              'frozen': {'docstring': ''},
                              'name': {'docstring': 'Sets the name of the newly-created node. If it contains namespace path, the new node will be created under the specified namespace; if the namespace does not exist, it will be created.'},
                              'nodeState': {'docstring': "Maya dependency nodes have 6 possible states. The Normal (0), HasNoEffect (1), and Blocking (2)states can be used to alter how the graph is evaluated.   The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)are for internal use only. They temporarily shut off parts of the graph during interaction (e.g., manipulation). The understanding is that once the operation is done, the state will be reset appropriately, e.g. Waiting-Blockingwill reset back to Blocking.   The Normaland Blockingcases apply to all nodes, while HasNoEffectis node specific; many nodes do not support this option. Plug-ins store state in the MPxNode::stateattribute. Anyone can set it or check this attribute.  Additional details about each of these 3 states follow.  StateDescriptionNormalThe normal node state. This is the default.HasNoEffectThe HasNoEffectoption (a.k.a. pass-through), is used in cases where there is an operation on an input producing an output of the same data type. Nearly all deformers support this state, as do a few other nodes. As stated earlier, it is not supported by all nodes.  Itâ€™s typical to implement support for the HasNoEffectstate in the nodeâ€™s compute method and to perform appropriate operations. Plug-ins can also support HasNoEffect.  The usual implementation of this state is to copy the input directly to the matching output without applying the algorithm in the node. For deformers, applying this state leaves the input geometry undeformed on the output.  BlockingThis is implemented in the depend node base class and applies to all nodes. Blockingis applied during the evaluation phase to connections. An evaluation request to a blocked connection will return as failures, causing the destination plug to retain its current value. Dirty propagation is indirectly affected by this state since blocked connections are never cleaned.  When a node is set to Blockingthe behavior is supposed to be the same as if all outgoing connections were broken. As long as nobody requests evaluation of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked node will still respond to getAttrrequests but a getAttron a downstream node will not reevaluate the blocked node.  Setting the root transform of a hierarchy to Blockingwonâ€™t automatically influence child transforms in the hierarchy. To do this, youâ€™d need to explicitly set all child nodes to the Blockingstate.  For example, to set all child transforms to Blocking, you could use the following script.  import maya.cmds as cmds def blockTree(root): nodesToBlock = [] for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys(): nodesToBlock += cmds.listConnections(node, source=True, destination=True ) for node in {source:1 for source in nodesToBlock}.keys(): cmds.setAttr( '%s.nodeState' % node, 2 )  Applying this script would continue to draw objects but things would not be animated.  Default:kdnNormal"},
                              'object': {'docstring': 'Create the result, or just the dependency node.                  Flag can have multiple arguments, passed either as a tuple or a list.'},
                              'positionTolerance': {'docstring': 'C(0) Tolerance For Fillet Surface Default:0.01'},
                              'primaryRadius': {'docstring': 'primary Radius Default:1.0'},
                              'query': {'docstring': ''},
                              'secondaryRadius': {'docstring': 'secondary Radius Default:1.0'},
                              'tangentTolerance': {'docstring': 'G(1) Tolerance For Fillet Surface Default:0.01                  Common flags'}}},
 'clearCache': {'description': 'Even though dependency graph values are computed or dirty they may still occupy space temporarily within the nodes.  This command goes in to all of the data that can be regenerated if required and removes it from the caches (datablocks), thus clearing up space in memory. \t         ',
                'flags': {'allNodes': {'docstring': 'If toggled then all nodes in the graph are cleared.  Otherwise only those nodes that are selected are cleared.'},
                          'computed': {'docstring': 'If toggled then remove all data that is computable.  (Warning: If the data is requested for redraw then the recompute will immediately fill the data back in.)'},
                          'dirty': {'docstring': 'If toggled then remove all heavy data that is dirty. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'clearShear': {'description': '', 'flags': {}},
 'clip': {'description': 'This command is used to create, edit and query character clips. \t         ',
          'flags': {'absolute': {'docstring': 'This flag is now deprecated.  Use aa/allAbsolute, ar/allRelative, ra/rotationsAbsolute, or da/defaultAbsolute instead.  This flag controls whether the clip follows its keyframe values or whether they are offset by a value to maintain a smooth path. Default is true.'},
                    'absoluteRotations': {'docstring': 'This flag is now deprecated.  Use aa/allAbsolute, ar/allRelative, ra/rotationsAbsolute, or da/defaultAbsolute instead. If true, this overrides the -absolute flag so that rotation channels are always calculated with absolute offsets. This allows you to have absolute offsets on rotations and relative offsets on all other channels.'},
                    'active': {'docstring': 'Query or edit the active clip. This flag is not valid in create mode. Making a clip active causes its animCurves to be hooked directly to the character attributes in addition to being attached to the clip library node. This makes it easier to access the animCurves if you want to edit, delete or add additional animCruves to the clip.'},
                    'addTrack': {'docstring': 'This flag is now obsolete. Use the insertTrack flag on the clipSchedule command instead.'},
                    'allAbsolute': {'docstring': 'Set all channels to be calculated with absolute offsets.  This flag cannot be used in conjunction with the ar/allRelative, ra/rotationsAbsolute or da/defaultAbsolute flags.'},
                    'allClips': {'docstring': 'This flag is used to query all the clips in the scene. Nodes of type "animClip" that are storing poses, are not returned by this command.'},
                    'allRelative': {'docstring': 'Set all channels to be calculated with relative offsets.  This flag cannot be used in conjunction with the aa/allAbsolute, ra/rotationsAbsolute or da/defaultAbsolute flags.'},
                    'allSourceClips': {'docstring': 'This flag is used to query all the source clips in the scene. Nodes of type "animClip" that are storing poses or clip instances, are not returned by this command.'},
                    'animCurveRange': {'docstring': 'This flag can be used at the time you create the clip instead of the startTime and endTime flags. It specifies that you want the range of the clip to span the range of keys in the clips associated animCurves.'},
                    'character': {'docstring': 'This is a query only flag which operates on the specified clip. It returns the names of any characters that a clip is associated with.'},
                    'constraint': {'docstring': 'This creates a clip out of any constraints on the character. The constraint will be moved off of the character and into the clip, so that it is only active for the duration of the clip, and its value can be scaled/offset/cycled according to the clip attributes.'},
                    'copy': {'docstring': 'This flag is used to copy a clip or clips to the clipboard. It should be used in conjunction with the name flag to copy the named clips on the specified character and its subcharacters. In query mode, this flag allows you to query what, if anything, has been copied into the clip clipboard.'},
                    'defaultAbsolute': {'docstring': 'Sets all top-level channels except rotations in the clip to relative, and the remaining channels to absolute. This is the default during clip creation if no offset flag is specified.  This flag cannot be used in conjunction with the aa/allAbsolute, ar/allRelative, or ra/rotationsAbsolute flags.'},
                    'duplicate': {'docstring': 'Duplicate the clip specified by the name flag. The start time of the new clip should be specified with the startTime flag.'},
                    'edit': {'docstring': ''},
                    'endTime': {'docstring': 'Specify the clip end'},
                    'expression': {'docstring': 'This creates a clip out of any expressions on the character. The expression will be moved off of the character and into the clip, so that it is only active for the duration of the clip, and its value can be scaled/offset/cycled according to the clip attributes.'},
                    'ignoreSubcharacters': {'docstring': 'During clip creation, duplication and isolation, subcharacters are included by default. If you want to create a clip on the top level character only, or you want to duplicate the clip on the top level character without including subCharacters, use the ignoreSubcharacters flag.'},
                    'isolate': {'docstring': 'This flag should be used in conjunction with the name flag to specify that a clip or clips should be copied to a new clip library. The most common use of this flag is for export, when you want to only export certain clips from the character, without exporting all of the clips.'},
                    'leaveOriginal': {'docstring': 'This flag is used when creating a clip to specify that the animation curves should be copied to the clip library, and left on the character.'},
                    'mapMethod': {'docstring': 'This is is valid with the paste and pasteInstance flags only. It specifies how the mapping should be done. Valid options are: "byNodeName", "byAttrName", "byCharacterMap", "byAttrOrder", "byMapOrAttrName" and "byMapOrNodeName". "byAttrName" is the default. The flags mean the following: "byAttrOrder" maps using the order that the character stores the attributes internally, "byAttrName" uses the attribute name to find a correspondence, "byNodeName" uses the node name \\*and\\* the attribute name to find a correspondence, "byCharacterMap" uses the existing characterMap node to do the mapping. "byMapOrAttrName" uses a character map if one exists, otherwise uses the attribute name. "byMapOrNodeName" uses a character map if one exists, otherwise uses the attribute name.'},
                    'name': {'docstring': 'In create mode, specify the clip name. In query mode, return a list of all the clips. In duplicate mode, specify the clip to be duplicated. In copy mode, specify the clip to be copied. This flag is multi-use, but multiple use is only supported with the copy flag. For use during create and with all other flags, only the first instance of the name flag will be utilized. In query mode, this flag can accept a value.'},
                    'newName': {'docstring': 'Rename a clip. Must be used in conjunction with the clip name flag, which is used to specify the clip to be renamed.'},
                    'paste': {'docstring': 'This flag is used to paste a clip or clips from the clipboard to a character. Clips are added to the clipboard using the c/copy flag.'},
                    'pasteInstance': {'docstring': 'This flag is used to paste an instance of a clip or clips from the clipboard to a character. Unlike the p/paste flag, which duplicates the animCurves from the original source clip, the pi/pasteInstance flag shares the animCurves from the source clip.'},
                    'query': {'docstring': ''},
                    'remove': {'docstring': 'Remove the clip specified by the name flag. The clip will be permanently removed from the library and deleted from any times where it has been scheduled.'},
                    'removeTrack': {'docstring': 'This flag is now obsolete. Use removeTrack flag on the clipSchedule command instead.'},
                    'rotationOffset': {'docstring': "Return the channel offsets used to modify the clip's rotation."},
                    'rotationsAbsolute': {'docstring': 'Set all channels except rotations to be calculated with relative offsets.  Rotation channels will be calculated with absolute offsets.  This flag cannot be used in conjunction with the aa/allAbsolute, ar/allRelative or da/defaultAbsolute flags.'},
                    'scheduleClip': {'docstring': 'This flag is used when creating a clip to specify whether or not the clip should immediately be scheduled at the current time. If the clip is not scheduled, the clip will be placed in the library for future use, but will not be placed on the timeline. This flag is for use only when creating a new clip or duplicating an existing. The default is true.'},
                    'sourceClipName': {'docstring': 'This flag is for query only. It returns the name of the source clip that controls an instanced clip.'},
                    'split': {'docstring': 'Split an existing clip into two clips. The split occurs around the specified time.'},
                    'startTime': {'docstring': 'Specify the clip start'},
                    'translationOffset': {'docstring': "Return the channel offsets used to modify the clip's translation."},
                    'useChannel': {'docstring': 'Specify which channels should be acted on. This flag is valid only in conjunction with clip creation, and the isolate flag. The specified channels must be members of the character. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'clipEditor': {'description': 'Create a clip editor with the given name. \t         ',
                'flags': {'allTrackHeights': {'docstring': 'OBSOLETE flag. Use clipStyle instead.'},
                          'autoFit': {'docstring': 'on | off | tgl Auto fit-to-view.'},
                          'autoFitTime': {'docstring': 'on | off | tgl Auto fit-to-view along the time axis, as well.'},
                          'characterOutline': {'docstring': ''},
                          'clipDropCmd': {'docstring': 'Command executed when clip node is dropped on the TraX editor'},
                          'clipStyle': {'docstring': 'Set/return the clip track style in the specified editor. Default is 2. Valid values are 1-3.'},
                          'control': {'docstring': 'Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus. Caution: It is possible for an editor to exist without a control. The query will return "NONE" if no control is present.'},
                          'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                          'deleteCmd': {'docstring': 'Command executed when backspacekey is pressed'},
                          'deselectAll': {'docstring': 'Deselect all clips and blends in the editor.'},
                          'displayActiveKeyTangents': {'docstring': 'on | off | tgl Display active key tangents in the editor.'},
                          'displayActiveKeys': {'docstring': 'on | off | tgl Display active keys in the editor.'},
                          'displayInfinities': {'docstring': 'on | off | tgl Display infinities in the editor.'},
                          'displayKeys': {'docstring': 'on | off | tgl Display keyframes in the editor.'},
                          'displayTangents': {'docstring': 'on | off | tgl Display tangents in the editor.'},
                          'displayValues': {'docstring': 'on | off | tgl Display active keys and tangents values in the editor.'},
                          'docTag': {'docstring': 'Attaches a tag to the editor.'},
                          'edit': {'docstring': ''},
                          'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                          'filter': {'docstring': 'Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the main list of the editor.'},
                          'forceMainConnection': {'docstring': 'Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.'},
                          'frameAll': {'docstring': 'Frame view around all clips in the editor.'},
                          'frameRange': {'docstring': "The editor's current frame range."},
                          'highlightConnection': {'docstring': 'Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all editors have a highlight list. For those that do, it is a secondary selection list.'},
                          'highlightedBlend': {'docstring': 'Returns the highlighted blend, listed as scheduler and index'},
                          'highlightedClip': {'docstring': 'Returns the highlighted clip, listed as scheduler and index'},
                          'initialized': {'docstring': 'Returns whether the clip editor is fully initialized, and has a port to draw through. If not, the -frameRange and -frameAll flags will fail.'},
                          'listAllCharacters': {'docstring': 'List all characters in the editor and outliner.'},
                          'listCurrentCharacters': {'docstring': 'List only the characters in the editor and outliner.'},
                          'lockMainConnection': {'docstring': 'Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor. Further changes to the original mainConnection are ignored.'},
                          'lookAt': {'docstring': 'all | selected | currentTime FitView helpers.'},
                          'mainListConnection': {'docstring': 'Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object.'},
                          'manageSequencer': {'docstring': 'Sets/returns whether the clip editor should manage sequencer nodes.  If so, animation clips and characters are not represented.'},
                          'menuContext': {'docstring': 'Returns a string array denoting the type of data object the cursor is over.  Returned values are: {"timeSlider"} {"nothing"} {"track", "track index", "character node name", "group name"} {"clip", "clip node name"}'},
                          'panel': {'docstring': 'Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is deleted.'},
                          'parent': {'docstring': 'Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.'},
                          'query': {'docstring': ''},
                          'selectBlend': {'docstring': 'Select the blends specified by the scheduler name and the indicies of the two clips used in the blend. When queried, a string containing the scheduler name and the two clip indicies for all of the selected blends is returned.'},
                          'selectClip': {'docstring': 'Selects the clip specified by the scheduler name and the clip index. When queried, a string containing the scheduler and clip index of all of the selected clips is returned.'},
                          'selectionConnection': {'docstring': 'Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes changes, the editor updates to show the changes.'},
                          'snapTime': {'docstring': 'none | integer | keyframe Keyframe move snap in time.'},
                          'snapValue': {'docstring': 'none | integer | keyframe Keyframe move snap in values.'},
                          'stateString': {'docstring': 'Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned command string uses the string variable $editorName in place of a specific name.'},
                          'unParent': {'docstring': 'Specifies that the editor should be removed from its layout. This cannot be used in query mode.'},
                          'unlockMainConnection': {'docstring': 'Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic updates.'},
                          'updateMainConnection': {'docstring': 'Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.'},
                          'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'clipEditorCurrentTimeCtx': {'description': 'This command creates a context which may be used to change current time within the track area of a clip editor. ',
                              'flags': {'edit': {'docstring': ''},
                                        'exists': {'docstring': 'Returns true or false depending upon whether the specified object exists. Other flags are ignored.'},
                                        'history': {'docstring': 'If this is a tool command, turn the construction history on for the tool in question.'},
                                        'image1': {'docstring': 'First of three possible icons representing the tool associated with the context.'},
                                        'image2': {'docstring': 'Second of three possible icons representing the tool associated with the context.'},
                                        'image3': {'docstring': 'Third of three possible icons representing the tool associated with the context.'},
                                        'name': {'docstring': 'If this is a tool command, name the tool appropriately.                  Flag can have multiple arguments, passed either as a tuple or a list.'},
                                        'query': {'docstring': ''}}},
 'clipMatching': {'description': 'This command is used to compute an offset to apply on a source clip in order to automatically align it to a destination clip at a specified match element. For this command to work, offset objects must be specified for the character. \t         ',
                  'flags': {'clipDst': {'docstring': 'The clip to match so that the source clip can be offsetted correctly.  This flag takes in a clip name and the percentage value ranging from 0.0 to 1.0 in order to have the source clip match at a certain time in the destination clip.'},
                            'clipSrc': {'docstring': 'The clip to offset so that it aligns with the destination clip.  This flag takes in a clip name and the percentage value ranging from 0.0 to 1.0 in order to have it match at a certain time in the clip.'},
                            'matchRotation': {'docstring': 'This flag sets the rotation match type. By default, it is set to not match the rotation. 0 - None 1 - Match full rotation 2 - Match projected rotation on ground plane'},
                            'matchTranslation': {'docstring': 'This flag sets the translation match type. By default, it is set to not match the translation. 0 - None 1 - Match full translation 2 - Match projected translation on ground plane \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'clipSchedule': {'description': 'This command is used to create, edit and query clips and blends in the Trax editor. It operates on the clipScheduler node attached to the character. In query mode, if no flags are specified, returns an array of strings in this form:  (clipName,clipIndex,clipStart,clipSourceStart,clipSourceEnd,clipScale,clipPreCycle,clipPostCycle,clipHold) \t         ',
                  'flags': {'allAbsolute': {'docstring': 'Set all channels to be calculated with absolute offsets.  This flag cannot be used in conjunction with the ar/allRelative, ra/rotationsAbsolute or da/defaultAbsolute flags.'},
                            'allRelative': {'docstring': 'Set all channels to be calculated with relative offsets.  This flag cannot be used in conjunction with the aa/allAbsolute, ra/rotationsAbsolute or da/defaultAbsolute flags.'},
                            'blend': {'docstring': 'This flag is used to blend two clips, whose indices are provided as flag arguments.'},
                            'blendNode': {'docstring': 'This query only flag list all of the blend nodes associated with the blend defined by the two clip indices. This flag returns a string array. In query mode, this flag can accept a value.'},
                            'blendUsingNode': {'docstring': 'This flag is used to blend using an existing blend node. It is used in conjunction with the blend flag. The blend flag specifies the clip indices for the blend. The name of an existing animBlend node should be supplied supplied as an argument for the blendUsingNode flag.'},
                            'character': {'docstring': 'This flag is used to query which characters this scheduler controls. It returns an array of strings.'},
                            'clipIndex': {'docstring': 'Specify the index of the clip to schedule. In query mode, returns an array of strings in this form: (clipName,index,start,sourceStart,sourceEnd,scale,preCycle,postCycle) In query mode, this flag can accept a value.'},
                            'cycle': {'docstring': 'This flag is now obsolete. Use the postCycle flag instead.'},
                            'defaultAbsolute': {'docstring': 'Sets all top-level channels except rotations in the clip to relative, and the remaining channels to absolute. This is the default during clip creation if no offset flag is specified.  This flag cannot be used in conjunction with the aa/allAbsolute, ar/allRelative, or ra/rotationsAbsolute flags.'},
                            'edit': {'docstring': ''},
                            'enable': {'docstring': 'This flag is used to enable or disable a clip. It must be used in conjunction with the ci/clipIndex flag. The specified clip will be enabled or disabled.'},
                            'group': {'docstring': 'This flag is used to add (true) or remove (false) a list of clips (specified with groupIndex) into a group.'},
                            'groupIndex': {'docstring': 'This flag specifies a multiple number of clips to be added or removed from a group.'},
                            'groupName': {'docstring': 'This flag is used to specify the group that should be added to.  If no group by that name exists and new group is created with that name.  By default if this is not specified a new group will be created.'},
                            'hold': {'docstring': 'Specify how long to hold the last value of the clip after its normal or cycled end.'},
                            'insertTrack': {'docstring': 'This flag is used to insert a new empty track at the track index specified.'},
                            'instance': {'docstring': 'Create an instanced copy of the named clip. An instanced clip is one that is linked to an original clip. Thus, changes to the animation curve of the original curve will also modify all instanced clips. The name of the instanced clip is returned as a string.'},
                            'listCurves': {'docstring': 'This flag is used to list the animation curves associated with a clip. It should be used in conjunction with the clipIndex flag, which specifies the clip of interest.'},
                            'listPairs': {'docstring': 'This query only flag returns a string array containing the channels in a character that are used by a clip and the names of the animation curves that drive the channels. Each string in the string array consists of the name of a channel, a space, and the name of the animation curve animating that channel. This flag must be used with the ci/clipIndex flag.'},
                            'lock': {'docstring': 'This flag specifies whether clips on a track are to be locked or not. Must be used in conjuction with the track flag.'},
                            'mute': {'docstring': 'This flag specifies whether clips on a track are to be muted or not. Must be used in conjuction with the track flag.'},
                            'name': {'docstring': 'This flag is used to query the name of the clip node associated with the specified clip index, or to specify the name of the instanced clip during instancing. In query mode, this flag can accept a value.'},
                            'postCycle': {'docstring': 'Specify the number of times to repeat the clip after its normal end.'},
                            'preCycle': {'docstring': 'Specify the number of times to repeat the clip before its normal start.'},
                            'query': {'docstring': ''},
                            'remove': {'docstring': 'This flag is used to remove a clip from the timeline. It must be used in conjunction with the ci/clipIndex flag. The specified clip will be removed from the timeline, but will still exist in the library and any instanced clips will remain in the timeline. To permanently remove a clip from the scene, the clip command should be used instead.'},
                            'removeBlend': {'docstring': 'This flag is used to remove an existing blend between two clips, whose indices are provided as flag arguments.'},
                            'removeEmptyTracks': {'docstring': 'This flag is used to remove all tracks that have no clips.'},
                            'removeTrack': {'docstring': 'This flag is used to remove the track with the specified index.  The track must have no clips on it before it can be removed.'},
                            'rotationsAbsolute': {'docstring': 'Set all channels except rotations to be calculated with relative offsets.  Rotation channels will be calculated with absolute offsets.  This flag cannot be used in conjunction with the aa/allAbsolute, ar/allRelative or da/defaultAbsolute flags.'},
                            'scale': {'docstring': 'Specify the amount to scale the clip. Values must be greater than 0.'},
                            'shift': {'docstring': 'This flag allows multiple clips to be shifted by a certain number of tracks and works in conjunction with the shiftIndex flag.  The flag specifies the number of tracks to shift the associated clips.  Positive values shift the clips down an negative values shift the clips up.'},
                            'shiftIndex': {'docstring': 'This flag allows multiple clips to be shifted by a certain number of tracks and works in conjunction with the shiftAmount flag.  The flag specifies the index of the clip to shift.  This flag can be used multiple times on the command line to specify a number of clips to shift.'},
                            'solo': {'docstring': 'This flag specifies whether clips on a track are to be soloed or not. Must be used in conjuction with the track flag.'},
                            'sourceClipName': {'docstring': 'This flag is used to query the name of the source clip node associated with the specified clip index.'},
                            'sourceEnd': {'docstring': "Specify where to end in the source clip's animation curves"},
                            'sourceStart': {'docstring': "Specify where to start in the source clip's animation curves"},
                            'start': {'docstring': 'Specify the placement of the start of the clip'},
                            'track': {'docstring': 'Specify the track to operate on. For example, which track to place a clip on, which track to mute/lock/solo.  In query mode, it may be used in conjuction with the clipIndex flag to return the track number of a clip, where track 1 is the first track of the character. In query mode, this flag can accept a value.'},
                            'weight': {'docstring': 'This flag is used in to set or query the weight of the clip associated with the specified clip index.'},
                            'weightStyle': {'docstring': 'This flag is used to set or query the weightStyle attribute of the clip associated with the specified clip index. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'clipSchedulerOutliner': {'description': 'This command creates/edits/queries a clip scheduler outliner control. \t         ',
                           'flags': {'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                                     'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                                     'clipScheduler': {'docstring': 'Name of the clip scheduler for which to display information.'},
                                     'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                                     'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                                     'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                                     'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                                     'edit': {'docstring': ''},
                                     'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                                     'enableBackground': {'docstring': 'Enables the background color of the control.'},
                                     'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                                     'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                                     'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                                     'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                                     'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                                     'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                                     'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                                     'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                                     'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                                     'parent': {'docstring': 'The parent layout for this control.'},
                                     'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                                     'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                                     'query': {'docstring': ''},
                                     'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                                     'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                                     'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                                     'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                                     'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'closeCurve': {'description': 'The closeCurve command closes a curve, making it periodic. The pathname to the newly closed curve and the name of the resulting dependency node are returned.  If a curve is not specified in the command, then the first active curve will be used. ',
                'flags': {'blendBias': {'docstring': 'Skew the result toward the first or the second curve depending on the blend value being smaller or larger than 0.5. Default:0.5'},
                          'blendKnotInsertion': {'docstring': 'If set to true, insert a knot in one of the original curves (relative position given by the parameter attribute below) in order to produce a slightly different effect. Default:false'},
                          'caching': {'docstring': 'Toggle caching for all attributes so that no recomputation is needed'},
                          'constructionHistory': {'docstring': 'Turn the construction history on or off.'},
                          'curveOnSurface': {'docstring': 'If possible, create 2D curve as a result.'},
                          'edit': {'docstring': ''},
                          'frozen': {'docstring': ''},
                          'name': {'docstring': 'Sets the name of the newly-created node. If it contains namespace path, the new node will be created under the specified namespace; if the namespace does not exist, it will be created.'},
                          'nodeState': {'docstring': "Maya dependency nodes have 6 possible states. The Normal (0), HasNoEffect (1), and Blocking (2)states can be used to alter how the graph is evaluated.   The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)are for internal use only. They temporarily shut off parts of the graph during interaction (e.g., manipulation). The understanding is that once the operation is done, the state will be reset appropriately, e.g. Waiting-Blockingwill reset back to Blocking.   The Normaland Blockingcases apply to all nodes, while HasNoEffectis node specific; many nodes do not support this option. Plug-ins store state in the MPxNode::stateattribute. Anyone can set it or check this attribute.  Additional details about each of these 3 states follow.  StateDescriptionNormalThe normal node state. This is the default.HasNoEffectThe HasNoEffectoption (a.k.a. pass-through), is used in cases where there is an operation on an input producing an output of the same data type. Nearly all deformers support this state, as do a few other nodes. As stated earlier, it is not supported by all nodes.  Itâ€™s typical to implement support for the HasNoEffectstate in the nodeâ€™s compute method and to perform appropriate operations. Plug-ins can also support HasNoEffect.  The usual implementation of this state is to copy the input directly to the matching output without applying the algorithm in the node. For deformers, applying this state leaves the input geometry undeformed on the output.  BlockingThis is implemented in the depend node base class and applies to all nodes. Blockingis applied during the evaluation phase to connections. An evaluation request to a blocked connection will return as failures, causing the destination plug to retain its current value. Dirty propagation is indirectly affected by this state since blocked connections are never cleaned.  When a node is set to Blockingthe behavior is supposed to be the same as if all outgoing connections were broken. As long as nobody requests evaluation of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked node will still respond to getAttrrequests but a getAttron a downstream node will not reevaluate the blocked node.  Setting the root transform of a hierarchy to Blockingwonâ€™t automatically influence child transforms in the hierarchy. To do this, youâ€™d need to explicitly set all child nodes to the Blockingstate.  For example, to set all child transforms to Blocking, you could use the following script.  import maya.cmds as cmds def blockTree(root): nodesToBlock = [] for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys(): nodesToBlock += cmds.listConnections(node, source=True, destination=True ) for node in {source:1 for source in nodesToBlock}.keys(): cmds.setAttr( '%s.nodeState' % node, 2 )  Applying this script would continue to draw objects but things would not be animated.  Default:kdnNormal"},
                          'object': {'docstring': 'Create the result, or just the dependency node.'},
                          'parameter': {'docstring': 'The parameter value for the positioning of the newly inserted knot. Default:0.1'},
                          'preserveShape': {'docstring': '0 - without preserving the shape 1 - preserve shape 2 - blend Default:1                  Common flags'},
                          'query': {'docstring': ''},
                          'replaceOriginal': {'docstring': 'Create "in place" (i.e., replace).                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'closeSurface': {'description': 'The closeSurface command closes a surface in the U, V, or both directions, making it periodic. The close direction is controlled by the direction flag. If a surface is not specified in the command, then the first selected surface will be used. The pathname to the newly closed surface and the name of the resulting dependency node are returned. This command also handles selected surface isoparms. For example, if an isoparm is specified, surface1.u[0.33], then the surface will be closed in V, regardless of the direction flag. ',
                  'flags': {'blendBias': {'docstring': 'Skew the result toward the first or the second surface depending on the blend value being smaller or larger than 0.5. Default:0.5'},
                            'blendKnotInsertion': {'docstring': 'If set to true, insert a knot in one of the original surfaces (relative position given by the parameter attribute below) in order to produce a slightly different effect. Default:false'},
                            'caching': {'docstring': 'Toggle caching for all attributes so that no recomputation is needed'},
                            'constructionHistory': {'docstring': 'Turn the construction history on or off.'},
                            'direction': {'docstring': 'The direction in which to close: 0 - U, 1 - V, 2 - Both U and V Default:0'},
                            'edit': {'docstring': ''},
                            'frozen': {'docstring': ''},
                            'name': {'docstring': 'Sets the name of the newly-created node. If it contains namespace path, the new node will be created under the specified namespace; if the namespace does not exist, it will be created.'},
                            'nodeState': {'docstring': "Maya dependency nodes have 6 possible states. The Normal (0), HasNoEffect (1), and Blocking (2)states can be used to alter how the graph is evaluated.   The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)are for internal use only. They temporarily shut off parts of the graph during interaction (e.g., manipulation). The understanding is that once the operation is done, the state will be reset appropriately, e.g. Waiting-Blockingwill reset back to Blocking.   The Normaland Blockingcases apply to all nodes, while HasNoEffectis node specific; many nodes do not support this option. Plug-ins store state in the MPxNode::stateattribute. Anyone can set it or check this attribute.  Additional details about each of these 3 states follow.  StateDescriptionNormalThe normal node state. This is the default.HasNoEffectThe HasNoEffectoption (a.k.a. pass-through), is used in cases where there is an operation on an input producing an output of the same data type. Nearly all deformers support this state, as do a few other nodes. As stated earlier, it is not supported by all nodes.  Itâ€™s typical to implement support for the HasNoEffectstate in the nodeâ€™s compute method and to perform appropriate operations. Plug-ins can also support HasNoEffect.  The usual implementation of this state is to copy the input directly to the matching output without applying the algorithm in the node. For deformers, applying this state leaves the input geometry undeformed on the output.  BlockingThis is implemented in the depend node base class and applies to all nodes. Blockingis applied during the evaluation phase to connections. An evaluation request to a blocked connection will return as failures, causing the destination plug to retain its current value. Dirty propagation is indirectly affected by this state since blocked connections are never cleaned.  When a node is set to Blockingthe behavior is supposed to be the same as if all outgoing connections were broken. As long as nobody requests evaluation of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked node will still respond to getAttrrequests but a getAttron a downstream node will not reevaluate the blocked node.  Setting the root transform of a hierarchy to Blockingwonâ€™t automatically influence child transforms in the hierarchy. To do this, youâ€™d need to explicitly set all child nodes to the Blockingstate.  For example, to set all child transforms to Blocking, you could use the following script.  import maya.cmds as cmds def blockTree(root): nodesToBlock = [] for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys(): nodesToBlock += cmds.listConnections(node, source=True, destination=True ) for node in {source:1 for source in nodesToBlock}.keys(): cmds.setAttr( '%s.nodeState' % node, 2 )  Applying this script would continue to draw objects but things would not be animated.  Default:kdnNormal"},
                            'object': {'docstring': 'Create the result, or just the dependency node.'},
                            'parameter': {'docstring': 'The parameter value for the positioning of the newly inserted knot. Default:0.1'},
                            'preserveShape': {'docstring': '0 - without preserving the shape 1 - preserve shape 2 - blend Default:1                  Common flags'},
                            'query': {'docstring': ''},
                            'replaceOriginal': {'docstring': 'Create "in place" (i.e., replace).                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'cluster': {'description': "The cluster command creates a cluster or edits the membership of an existing cluster. The command returns the name of the cluster node upon creation of a new cluster. After creating a cluster, the cluster's weights can be modified using the percent command or the set editor window. ",
             'flags': {'after': {'docstring': 'If the default behavior for insertion/appending into/onto the existing chain is not the desired behavior then this flag can be used to force the command to place the deformer node after the selected node in the chain even if a new geometry shape has to be created in order to do so. Works in create mode (and edit mode if the deformer has no geometry added yet).'},
                       'afterReference': {'docstring': 'The -afterReference flag is used to specify deformer ordering in a hybrid way that choses between -before and -after automatically. If the geometry being deformed is referenced then the -after mode is used when adding the new deformer, otherwise the -before mode is used. The net effect when using -afterReference to build deformer chains is that internal shape nodes in the deformer chain will only appear at reference file boundaries, leading to lightweight deformer networks that may be more amicable to reference swapping.'},
                       'before': {'docstring': 'If the default behavior for insertion/appending into/onto the existing chain is not the desired behavior then this flag can be used to force the command to place the deformer node before the selected node in the chain even if a new geometry shape has to be created in order to do so. Works in create mode (and edit mode if the deformer has no geometry added yet).'},
                       'bindState': {'docstring': 'When turned on, this flag adds in a compensation to ensure the clustered objects preserve their spatial position when clustered. This is required to prevent the geometry from jumping at the time the cluster is created in situations when the cluster transforms at cluster time are not identity.'},
                       'deformerTools': {'docstring': 'Returns the name of the deformer tool objects (if any) as string string ...'},
                       'edit': {'docstring': ''},
                       'envelope': {'docstring': 'Set the envelope value for the deformer. Default is 1.0'},
                       'exclusive': {'docstring': 'Puts the deformation set in a deform partition.'},
                       'frontOfChain': {'docstring': "This command is used to specify that the new deformer node should be placed ahead (upstream) of existing deformer and skin nodes in the shape's history (but not ahead of existing tweak nodes). The input to the deformer will be the upstream shape rather than the visible downstream shape, so the behavior of this flag is the most intuitive if the downstream deformers are in their reset (hasNoEffect) position when the new deformer is added. Works in create mode (and edit mode if the deformer has no geometry added yet)."},
                       'geometry': {'docstring': 'The specified object will be added to the list of objects being deformed by this deformer object, unless the -rm flag is also specified. When queried, this flag returns string string string ...'},
                       'geometryIndices': {'docstring': 'Complements the -geometry flag in query mode. Returns the multi index of each geometry.'},
                       'ignoreSelected': {'docstring': 'Tells the command to not deform objects on the current selection list'},
                       'includeHiddenSelections': {'docstring': 'Apply the deformer to any visible and hidden objects in the selection list. Default is false.'},
                       'name': {'docstring': 'Used to specify the name of the node being created.'},
                       'parallel': {'docstring': 'Inserts the new deformer in a parallel chain to any existing deformers in the history of the object. A blendShape is inserted to blend the parallel results together. Works in create mode (and edit mode if the deformer has no geometry added yet).'},
                       'prune': {'docstring': 'Removes any points not being deformed by the deformer in its current configuration from the deformer set.'},
                       'query': {'docstring': ''},
                       'relative': {'docstring': 'Enable relative mode for the cluster. In relative mode, Only the transformations directly above the cluster are used by the cluster. Default is off.'},
                       'remove': {'docstring': 'Specifies that objects listed after the -g flag should be removed from this deformer.'},
                       'resetGeometry': {'docstring': 'Reset the geometry matrices for the objects being deformed by the cluster. This flag is used to get rid of undesirable effects that happen if you scale an object that is deformed by a cluster.'},
                       'split': {'docstring': 'Branches off a new chain in the dependency graph instead of inserting/appending the deformer into/onto an existing chain. Works in create mode (and edit mode if the deformer has no geometry added yet).'},
                       'useComponentTags': {'docstring': 'When this flag is specified a setup using componentTags will be created. This means no groupId, groupParts, tweak or objectSet nodes will be created and connected to the new deformer.'},
                       'weightedNode': {'docstring': 'Transform node in the DAG above the cluster to which all percents are applied. The second DAGobject specifies the descendent of the first DAGobject from where the transformation matrix is evaluated. Default is the cluster handle.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'cmdFileOutput': {'description': 'This command will open a text file to receive all of the commands and results that normally get printed to the Script Editor window or console. The file will stay open until an explicit -close with the correct file descriptor or a -closeAll, so care should be taken not to leave a file open. To enable logging to commence as soon as Maya starts up, the environment variable MAYA_CMD_FILE_OUTPUT may be specified prior to launching Maya. Setting MAYA_CMD_FILE_OUTPUT to a filename will create and output to that given file. To access the descriptor after Maya has started, use the -query and -open flags together. ',
                   'flags': {'close': {'docstring': 'Closes the file corresponding to the given descriptor. If -3 is returned, the file did not exist. -1 is returned on error, 0 is returned on successful close.'},
                             'closeAll': {'docstring': 'Closes all open files.'},
                             'open': {'docstring': 'Opens the given file for writing (will overwrite if it exists and is writable). If successful, a value is returned to enable status queries and file close. -1 is returned if the file cannot be opened for writing. The -open flag can also be specified in -query mode. In query mode, if the named file is currently opened, the descriptor for the specified file is returned, otherwise -1 is returned. This is an easy way to check if a given file is currently open.'},
                             'query': {'docstring': ''},
                             'status': {'docstring': 'Queries the status of the given descriptor. -3 is returned if no such file exists, -2 indicates the file is not open, -1 indicates an error condition, 0 indicates file is ready for writing.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'cmdScrollFieldExecuter': {'description': 'A script editor executer control used to issue script commands to Maya. \t         ',
                            'flags': {'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                                      'appendText': {'docstring': 'Appends text to the end of this field.'},
                                      'autoCloseBraces': {'docstring': 'Specifies whether a closing brace should automatically be added when hitting enter after an opening brace. (default on)'},
                                      'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                                      'clear': {'docstring': 'Clears the field.'},
                                      'commandCompletion': {'docstring': 'Enable/disable command completion'},
                                      'copySelection': {'docstring': 'Copies the current selection from this field.'},
                                      'currentLine': {'docstring': 'Sets/returns the current line which the cursor is on.'},
                                      'cutSelection': {'docstring': 'Cuts the current selection from this field.'},
                                      'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                                      'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                                      'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                                      'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                                      'edit': {'docstring': ''},
                                      'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                                      'enableBackground': {'docstring': 'Enables the background color of the control.'},
                                      'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                                      'execute': {'docstring': 'Executes the current selection.  If there is no selection, all text is executed.'},
                                      'executeAll': {'docstring': 'Executes all text.'},
                                      'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                                      'fileChangedCommand': {'docstring': 'Only valid when this field contains a file. Sets a script which will be called whenever the file is externally modified, renamed or removed from disk. In MEL, the function should have the following signature: proc fileChanged(string $file)'},
                                      'filename': {'docstring': "Returns the full path + filename of the script which was either loaded or saved. If there isn't one returns an empty string."},
                                      'filterKeyPress': {'docstring': "Sets a script which will be called to handle key-press events. The function should have the following signature: proc int filterKeyPress(int $modifiers, string $key)modifiers: a bit mask where Shift is bit 1, Ctrl is bit 3, Alt is bit 4, and bit 5 is the 'Windows' key on Windows keyboards and the Command key on Mac keyboards. key: Specifies what key was pressed. The key is either a single ascii character or one of the keyword strings for the special keyboard characters. For example: Up, Down, Right, Left, Home, End, Page_Up, Page_Down, Insert Return, Space F1 to F12 The function should return 1 to indicate that they key event has been handled, and 0 to indicate that it has not been handled."},
                                      'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                                      'hasFocus': {'docstring': 'Whether this control is currently in focus.'},
                                      'hasSelection': {'docstring': 'Whether this control currently has a selection or not.'},
                                      'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                                      'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                                      'indentSelection': {'docstring': ''},
                                      'insertText': {'docstring': 'Inserts the specified text into the position under the cursor, replacing any currently selected text. The selection and cursor position can be set using the selectflag. Appends text to the end of this field.'},
                                      'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                                      'load': {'docstring': 'Prompts the user for a script to load into this field.  The loaded filename becomes associated with this executer field and saving will save directly to the file.'},
                                      'loadContents': {'docstring': 'Loads the contents of the specified filename into this field.  The path and extension for this filename is provided internally.  This command is only intended for loading the contents of this executer field from a previous instance of this executer field.'},
                                      'loadFile': {'docstring': 'If the provided string is a fully specified file path, then attempts to load the file contents into this field.  If the string is empty or not valid then prompts the user for a script to load into this field.  In both cases the filename becomes associated with this executer field and saving will save directly to the file.'},
                                      'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                                      'modificationChangedCommand': {'docstring': 'Sets a script which will be called whenever the content of this field changes in a way that affects the modification state. In MEL, the function should have the following signature: proc modificationChanged(int $m)If $m is true, the field has been modified; otherwise it is false.'},
                                      'modified': {'docstring': 'Sets or returns whether the field has been modified.'},
                                      'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                                      'numberOfLines': {'docstring': 'Returns the total number of lines in the document.'},
                                      'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                                      'objectPathCompletion': {'docstring': 'Enable/disable path completion'},
                                      'parent': {'docstring': 'The parent layout for this control.'},
                                      'pasteSelection': {'docstring': 'Pastes text into this field at the current caret position.'},
                                      'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                                      'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                                      'query': {'docstring': ''},
                                      'receiveFocusCommand': {'docstring': ''},
                                      'redo': {'docstring': 'Redo the last operation.'},
                                      'removeStoredContents': {'docstring': 'Removes the stored contents of this field with the specified filename.  The path and extension for the file is provided internally.  This command is only intended for removing previously stored contents of this executer field.'},
                                      'replaceAll': {'docstring': 'Replaces all instances of the first string in the field text with the second string.  The case sensitivity of this operation is set with the -searchMatchCaseflag.'},
                                      'saveFile': {'docstring': 'Saves the entire script contents of this field directly to the specified file path.'},
                                      'saveSelection': {'docstring': 'Prompts to save the current selection to a file.  The default filename prompt will be prepended with the given string.'},
                                      'saveSelectionToShelf': {'docstring': 'Prompts to save the current selection to an item in the shelf.'},
                                      'searchAndSelect': {'docstring': 'Searches for (and selects) the specified search string using the specified search options.'},
                                      'searchDown': {'docstring': 'Specifies whether to search from the cursor down, or up.'},
                                      'searchMatchCase': {'docstring': 'Specifies whether the search is to be case sensitive or not.'},
                                      'searchString': {'docstring': 'Specifies the string to search for.'},
                                      'searchWraps': {'docstring': 'Specifies whether the search should wrap around.'},
                                      'select': {'docstring': 'Selects text within a specified range.'},
                                      'selectAll': {'docstring': 'Selects all text.'},
                                      'selectedText': {'docstring': 'The text in the current selection range.'},
                                      'showLineNumbers': {'docstring': 'Shows/hides the line numbes column.'},
                                      'showTooltipHelp': {'docstring': 'Enable/disable tooltips in the command execution window'},
                                      'source': {'docstring': 'Prompts the user for a script to source (execute without loading).'},
                                      'sourceType': {'docstring': 'Sets the source type for this command executer field. Valid values are "mel" (enabled by default) and "python".'},
                                      'spacesPerTab': {'docstring': 'Specifies the number of spaces equivalent to one tab stop. (default 4)'},
                                      'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                                      'storeContents': {'docstring': 'If the provided string is a fully specified file path, then attempts to store the contents of this field to that path. Otherwise, uses the provided string as a filename only and uses an internally generated path and extension for the file, as used by the -loadContents and -removeStoredContents flags. In both cases, a new unique filename will be generated if the specified name exists. Returns the filename of the file saved upon completion, and an empty string otherwise.'},
                                      'tabsForIndent': {'docstring': 'Specifies whether tab characters should be inserted when indenting. (default on)'},
                                      'text': {'docstring': 'Replaces the field text with the given string.'},
                                      'textLength': {'docstring': 'The number of characters in this text field.'},
                                      'undo': {'docstring': 'Undo the last operation.'},
                                      'unindentSelection': {'docstring': ''},
                                      'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                                      'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                                      'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                                      'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'cmdScrollFieldReporter': {'description': 'A script editor reporter control used to receive and display the history of processed commmands. \t         ',
                            'flags': {'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                                      'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                                      'clear': {'docstring': 'Clears the field.'},
                                      'copySelection': {'docstring': 'Copies the current selection from this field.'},
                                      'cutSelection': {'docstring': 'Cuts the current selection from this field.'},
                                      'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                                      'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                                      'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                                      'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                                      'echoAllCommands': {'docstring': 'Echo all commands.    (Global parameter, affects all command reporters)'},
                                      'edit': {'docstring': ''},
                                      'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                                      'enableBackground': {'docstring': 'Enables the background color of the control.'},
                                      'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                                      'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                                      'filterSourceType': {'docstring': 'Filters the specified source type from showing in this command reporter. Currently supports either "mel", "python", or "" (default). Setting the filter to the empty string ("") will remove all filtering and show both "mel" and "python" results.'},
                                      'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                                      'hasFocus': {'docstring': 'Whether this control is currently in focus.'},
                                      'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                                      'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                                      'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                                      'lineNumbers': {'docstring': 'Show line numbers (in Error/Warning messages).    (Global parameter, affects all command reporters)'},
                                      'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                                      'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                                      'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                                      'parent': {'docstring': 'The parent layout for this control.'},
                                      'pasteSelection': {'docstring': 'Pastes text into this field at the current caret position.'},
                                      'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                                      'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                                      'query': {'docstring': ''},
                                      'receiveFocusCommand': {'docstring': 'Command executed when the field receives focus.'},
                                      'saveSelection': {'docstring': 'Prompts to save the current selection to a file. The default filename prompt will be prepended with the given string.'},
                                      'saveSelectionToShelf': {'docstring': 'Prompts to save the current selection to an item in the shelf.'},
                                      'select': {'docstring': 'Selects text within a specified range.'},
                                      'selectAll': {'docstring': 'Selects all text.'},
                                      'stackTrace': {'docstring': 'Show stack trace.    (Global parameter, affects all command reporters)'},
                                      'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                                      'suppressErrors': {'docstring': 'Suppress errors.'},
                                      'suppressInfo': {'docstring': 'Suppress info.'},
                                      'suppressResults': {'docstring': 'Suppress results.'},
                                      'suppressStackTrace': {'docstring': 'Suppress stack trace.'},
                                      'suppressWarnings': {'docstring': 'Suppress warnings.'},
                                      'text': {'docstring': 'Replaces the field text with the given string.'},
                                      'textLength': {'docstring': 'The number of characters in this text field.'},
                                      'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                                      'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                                      'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                                      'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'cmdShell': {'description': 'This command creates a scrolling field that behaves similar to a unix shell for entering user input.  You may specify the number of lines that will be remembered by the field with the -nsl/numberOfSavedLines flag.  The default number of lines saved is 100.  The shellField also maintains a command history buffer. You can specify the number of input lines that will be saved with the -hlc/historyLineCount flag.  The default size of this buffer is 10. ',
              'flags': {'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                        'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                        'clear': {'docstring': 'Erases all visible text, and also deletes any text that had scrolled of the top of the field.  After clearing the field it will be blank, and you will not be able to scroll up to see previous lines.  This flag does not affect the command history buffer, however.'},
                        'command': {'docstring': 'Command executed when the contents change.'},
                        'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                        'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                        'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                        'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                        'edit': {'docstring': ''},
                        'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                        'enableBackground': {'docstring': 'Enables the background color of the control.'},
                        'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                        'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                        'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                        'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                        'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                        'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                        'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                        'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                        'numberOfHistoryLines': {'docstring': 'The number of input lines to be saved in the command history buffer.  You can cycle through this buffer by pressing the up and down arrow keys.  Valid values are 0 through 32767.  Any value less than 0 will be handled as if 0 was specified.  Similarly, any value greater than 32767 will be handled as if 32767 was specified.'},
                        'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                        'numberOfSavedLines': {'docstring': 'The total number of lines (the scrolled lines and currently visible lines) that will be remembered by the field. Any lines beyond this number will be lost, and the user will not be able to review them by scrolling.  Valid values are 1 through 32767.  Any value less than 1 will be handled as if 1 was specified.  Similarly, any value greater than 32767 will be handled as if 32767 was specified.'},
                        'parent': {'docstring': 'The parent layout for this control.'},
                        'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                        'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                        'prompt': {'docstring': 'The text that is used as a prompt.'},
                        'query': {'docstring': ''},
                        'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                        'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                        'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                        'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                        'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'coarsenSubdivSelectionList': {'description': 'Coarsens a subdivision surface set of components based on the selection list. The selected components are selected at a coarser level. \t         ',
                                'flags': {}},
 'collision': {'description': 'For each listed object, the command creates a new field. The field has a shape which lives in the DAG and it has an associated dependency node. The field is added to the list of fields owned by the object. Use connectDynamic to cause the field to affect a dynamic object. Note that if more than one object is listed, a separate field is created for each object. If fields are created, this command returns the names of each owning shape and of the field shapes themselves. If a field was queried, the results of the query are returned. If a field was edited, the field name is returned. If no object names are provided but the active selection list is non-empty, the command creates a field for every object in the list. If the list is empty, the command defaults to -pos 0 0 0. The collision command causes particles to collide with geometry. It also allows you to specify values for the surface properties (friction and resilience) of the collision.  These values are stored in the geoConnector node for the geometry object.  Unlike earlier versions of Maya, there is no separate "collision node." If a soft object is in the selection list, the collision command assumes that you want to make it a collider.  In order to make the soft object collide with something use, use connectDynamic -c.  The collision menu option sorts this out using the lead object rule and issues the necessary commands. On creation, this command returns a string arrayof the geometry names that were setup for particle collision.When the command is used to query information, there are several possible return types. These include: If the -resilience or -friction flag is passed on the command line and a single collision geometry is either selected or on the command line, then resilience or friction value for that collision geometry is returned as a single floatvalue.If the -resilience or -friction flag is passed on the command line and a single collision geometry and a single particle object are either selected or on the command line, then two results might occur. If the particle object is not set up to collide with the geometry, then an error is displayed stating that.  If the objects are set up to collide with each other, then the resilience or friction value that the particle object is using for collisions with the geometry is returned as a single floatvalue.  This can be different than the geometry\'s resilience and friction, because the user may break the connection from the geometry\'s geoConnector node\'s resilience or friction to the particle, and set a different value in the particle\'s collisionResilience, collisionFriction or collisionOffset attribute that is used for that geometry.  This allows the user to make each particle respond to the same surface differently. If neither flag is pass on the command line and a single geometry and single particle object are either selected or on the command line, then a single integervalue of 1 is returned if the objects are set up to collide with each other, and 0 is returned if they are not. Lastly, if no flags are passed on the command line and a single particle object is either selected or on the command line, then a string arraywith the names of all geometries that the particle object will collide against and the multiIndex that the geometries are connected to is returned.  The array is formatted as follows: pPlaneShape1:0 pPlaneShape2:2 nurbsSphereShape1:3 ...where the number following the ":" is the multiIndex.',
               'flags': {'edit': {'docstring': ''},
                         'friction': {'docstring': "Friction of the surface.  This is the amount of the colliding particle's velocity parallel to the surface which is removed when the particle collides. A value of 0 will mean that no tangential velocity is lost, while a value of 1 will cause the particle to reflect straight along the normal of the surface."},
                         'name': {'docstring': 'name of field'},
                         'offset': {'docstring': 'Offset value for the connector.'},
                         'query': {'docstring': ''},
                         'resilience': {'docstring': "Resilience of the surface.  This is the amount of the colliding particle's velocity reflected along the normal of the surface.  A value of 1 will give perfect reflection, while a value of 0 will have no reflection along the normal of the surface.                  Flag can have multiple arguments, passed either as a tuple or a list."}}},
 'color': {'description': 'This command sets the dormant wireframe color of the specified objects to be their class color or if the -ud/userDefined flag is specified, one of the user defined colors. The -rgb/rgbColor flags can be specified if the user requires floating point RGB colors. ',
           'flags': {'rgbColor': {'docstring': 'Specifies and rgb color to set the selected object to.'},
                     'userDefined': {'docstring': 'Specifies the user defined color index to set selected object to. The valid range of numbers is [1-8].                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'colorAtPoint': {'description': 'The colorAtPointcommand is used to query textures or ocean           shaders at passed in uv coordinates.       (For ocean shaders uv is x and z in worldspace ).           The return value is a floating point array whose size is           determined by either the number of input uv arguments passed in and the           the queried value.  One can query alpha only, rgb only, or rgba values.           The returned array is only single indexed, so if rgb is specified then           the index for red values would be index \\* 3. Blue is index \\* 3 + 1, and           green is index \\* 3 + 2. For rgba use a multiple of 4 instead of 3.           For alpha only one can simply use the index.           There are two basic argument formats that may be used:           colorAtPoint -u 0 -v 0   -u .2 -v .1  etc.. for all points           or           colorAtPoint -mu 0 -mv 0  -xu 1 -xv 1 -su 10 -sv 10 // samples 100 points           If one is sampling several points and they are all in a regular grid           formation it is more efficient to call this routine with the latter           method, which uses a min/max uv and number of samples, rather than           a long argument list of uv coords.           return values (-o A or RGB or RGBA )individual UV coordinates to sample (-u float  -v float )(numbers of calls to -u and -v must match)uniform grid of points to sample (-su int -sv int)(may not use this in combination with -u or -v)bounds for sample grid  (-mu float  -mv float -xu float -xv float)',
                  'flags': {'coordU': {'docstring': 'Input u coordinate to sample texture at.'},
                            'coordV': {'docstring': 'Input v coordinate to sample texture at.'},
                            'maxU': {'docstring': 'DEFAULT 1.0 Maximum u bounds to sample.'},
                            'maxV': {'docstring': 'DEFAULT 1.0 Maximum v bounds to sample.'},
                            'minU': {'docstring': 'DEFAULT 0.0 Minimum u bounds to sample.'},
                            'minV': {'docstring': 'DEFAULT 0.0 Minimum v bounds to sample.'},
                            'output': {'docstring': 'Type of data to output:         A        = alpha only         RGB  = color only         RGBA = color and alpha'},
                            'samplesU': {'docstring': 'DEFAULT 1 The number of points to sample in the U dimension.'},
                            'samplesV': {'docstring': 'DEFAULT 1 The number of points to sample in the V dimension. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'colorEditor': {'description': 'The colorEditorcommand displays a modal dialog that may be used to specify colors in RGB or HSV. The default behaviour when no arguments are specified is to provide an initial color of black (rgb 0.0 0.0 0.0). The command will return the user\'s color component values along with a boolean to indicate whether the dialog was dismissed by pressing the "OK" button.  As an alternative to responding to the colorEditorcommand\'s return string you can now query the -rgb/rgbValue, -hsv/hsvValue, and -r/resultflags to get the same information. The final argument is 1 if the dialog\'s "OK" button was pressed, and 0 if the "Cancel" button was pressed.In query mode, return type is based on queried flag.',
                 'flags': {'alpha': {'docstring': 'Float values corresponding to the alpha transparency component, , which ranges from 0.0 to 1.0.  Use this flag to specify the initial alpha value of the Color Editor, or query this flag to determine the alpha value set in the editor.'},
                           'hsvValue': {'docstring': 'Three float values corresponding to the hue, saturation, and value color components, where the hue value ranges from 0.0 to 360.0 and the saturation and value components range from 0.0 to 1.0.  Use this flag to specify the initial color of the Color Editor, or query this flag to determine the color set in the editor.'},
                           'mini': {'docstring': 'Enable the mini color editor mode.'},
                           'parent': {'docstring': "Specify the parent window for the dialog.  The dialog will be centered on this window and raise and lower with it's parent. By default, the dialog is not parented to a particular window and is simply centered on the screen."},
                           'position': {'docstring': 'Specify the window position for the dialog.'},
                           'query': {'docstring': ''},
                           'result': {'docstring': 'This query only flag returns true if the dialog\'s "OK" button was pressed, false otherwise.  If you query this flag immediately after showing the Color Editor then it will return the same value as the boolean value returned in the colorEditorcommand\'s return string.'},
                           'rgbValue': {'docstring': 'Three float values corresponding to the red, green, and blue color components, all of which range from 0.0 to 1.0.  Use this flag to specify the initial color of the Color Editor, or query this flag to determine the color set in the editor.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'colorIndex': {'description': 'The index specifies a color index in the color palette. The r, g, and b values (between 0-1) specify the RGB values (or the HSV values if the -hsv flag is used) for the color. ',
                'flags': {'hueSaturationValue': {'docstring': 'Indicates that rgb values are really hsv values. Upon query, returns the HSV valuses as an array of 3 floats.'},
                          'query': {'docstring': ''},
                          'resetToFactory': {'docstring': 'Resets all color index palette entries to their factory defaults.'},
                          'resetToSaved': {'docstring': 'Resets all color palette entries to their saved values.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'colorIndexSliderGrp': {'description': 'All of the group commands position their individual controls in columns starting at column 1.  The layout of each control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign, and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one column in any group can be adjustable. This command creates a color slider group consisting of a label, a color canvas and a slider. The value of the slider defines a color index into the a color table. The corresponding color is displayed in the canvas. ',
                         'flags': {'adjustableColumn': {'docstring': 'Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based index. Passing 0 as argument turns off the previous adjustable column.'},
                                   'adjustableColumn2': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly two columns.'},
                                   'adjustableColumn3': {'docstring': 'Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly three columns.'},
                                   'adjustableColumn4': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly four columns.'},
                                   'adjustableColumn5': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly five columns.'},
                                   'adjustableColumn6': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly six columns.'},
                                   'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                                   'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                                   'changeCommand': {'docstring': 'Command executed when the value changes.  This command is not invoked when the value changes via the -v/value flag.'},
                                   'columnAlign': {'docstring': 'Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type for the specified column.'},
                                   'columnAlign2': {'docstring': 'Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are "left", "right", and "center".'},
                                   'columnAlign3': {'docstring': 'Sets the text alignment for all three columns.  Ignored if there are not exactly three columns. Valid values are "left", "right", and "center".'},
                                   'columnAlign4': {'docstring': 'Sets the text alignment for all four columns.  Ignored if there are not exactly four columns. Valid values are "left", "right", and "center".'},
                                   'columnAlign5': {'docstring': 'Sets the text alignment for all five columns.  Ignored if there are not exactly five columns. Valid values are "left", "right", and "center".'},
                                   'columnAlign6': {'docstring': 'Sets the text alignment for all six columns.  Ignored if there are not exactly six columns. Valid values are "left", "right", and "center".'},
                                   'columnAttach': {'docstring': 'Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies column attachment types and offets.'},
                                   'columnAttach2': {'docstring': 'Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are "left", "right", and "both".'},
                                   'columnAttach3': {'docstring': 'Sets the attachment type for all three columns. Ignored if there are not exactly three columns. Valid values are "left", "right", and "both".'},
                                   'columnAttach4': {'docstring': 'Sets the attachment type for all four columns. Ignored if there are not exactly four columns. Valid values are "left", "right", and "both".'},
                                   'columnAttach5': {'docstring': 'Sets the attachment type for all five columns. Ignored if there are not exactly five columns. Valid values are "left", "right", and "both".'},
                                   'columnAttach6': {'docstring': 'Sets the attachment type for all six columns. Ignored if there are not exactly six columns. Valid values are "left", "right", and "both".'},
                                   'columnOffset2': {'docstring': 'This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the -columnAttach2 flag.  Ignored if there are not exactly two columns.'},
                                   'columnOffset3': {'docstring': 'This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the -columnAttach3 flag.  Ignored if there are not exactly three columns.'},
                                   'columnOffset4': {'docstring': 'This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the -columnAttach4 flag.  Ignored if there are not exactly four columns.'},
                                   'columnOffset5': {'docstring': 'This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the -columnAttach5 flag.  Ignored if there are not exactly five columns.'},
                                   'columnOffset6': {'docstring': 'This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the -columnAttach6 flag.  Ignored if there are not exactly six columns.'},
                                   'columnWidth': {'docstring': 'Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies the column (1 based index) and the second parameter specifies the width.'},
                                   'columnWidth1': {'docstring': 'Sets the width of the first column. Ignored if there is not exactly one column.'},
                                   'columnWidth2': {'docstring': 'Sets the column widths of both columns. Ignored if there are not exactly two columns.'},
                                   'columnWidth3': {'docstring': 'Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.'},
                                   'columnWidth4': {'docstring': 'Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.'},
                                   'columnWidth5': {'docstring': 'Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.'},
                                   'columnWidth6': {'docstring': 'Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.'},
                                   'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                                   'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                                   'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                                   'dragCommand': {'docstring': "Command executed when the value changes by dragging the slider's value marker."},
                                   'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                                   'edit': {'docstring': ''},
                                   'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                                   'enableBackground': {'docstring': 'Enables the background color of the control.'},
                                   'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                                   'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                                   'extraLabel': {'docstring': 'Sets the string to be the text for the extra label.'},
                                   'forceDragRefresh': {'docstring': 'If used then force refresh on drag'},
                                   'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                                   'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                                   'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                                   'invisible': {'docstring': 'Set the invisible color index.'},
                                   'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                                   'label': {'docstring': 'Label text for the group.'},
                                   'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                                   'maxValue': {'docstring': 'Maximum color index.'},
                                   'minValue': {'docstring': 'Minimum color index.'},
                                   'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                                   'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                                   'parent': {'docstring': 'The parent layout for this control.'},
                                   'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                                   'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                                   'query': {'docstring': ''},
                                   'rowAttach': {'docstring': 'Arguments are : column, attachment type, offset. Possible attachments are: top | bottom | both. Specifies attachment types and offsets for the entire row.'},
                                   'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                                   'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                                   'value': {'docstring': 'Color index.'},
                                   'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                                   'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                                   'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'colorInputWidgetGrp': {'description': 'All of the group commands position their individual controls in columns starting at column 1.  The layout of each control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign, and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one column in any group can be adjustable. Create a color slider group consisting of a label, a color canvas, RGB and HSV sliders.  Clicking on the canvas will bring up the color editor. ',
                         'flags': {'adjustableColumn': {'docstring': 'Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based index. Passing 0 as argument turns off the previous adjustable column.'},
                                   'adjustableColumn2': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly two columns.'},
                                   'adjustableColumn3': {'docstring': 'Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly three columns.'},
                                   'adjustableColumn4': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly four columns.'},
                                   'adjustableColumn5': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly five columns.'},
                                   'adjustableColumn6': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly six columns.'},
                                   'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                                   'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                                   'changeCommand': {'docstring': 'Command string executed when slider value changes.'},
                                   'columnAlign': {'docstring': 'Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type for the specified column.'},
                                   'columnAlign2': {'docstring': 'Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are "left", "right", and "center".'},
                                   'columnAlign3': {'docstring': 'Sets the text alignment for all three columns.  Ignored if there are not exactly three columns. Valid values are "left", "right", and "center".'},
                                   'columnAlign4': {'docstring': 'Sets the text alignment for all four columns.  Ignored if there are not exactly four columns. Valid values are "left", "right", and "center".'},
                                   'columnAlign5': {'docstring': 'Sets the text alignment for all five columns.  Ignored if there are not exactly five columns. Valid values are "left", "right", and "center".'},
                                   'columnAlign6': {'docstring': 'Sets the text alignment for all six columns.  Ignored if there are not exactly six columns. Valid values are "left", "right", and "center".'},
                                   'columnAttach': {'docstring': 'Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies column attachment types and offets.'},
                                   'columnAttach2': {'docstring': 'Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are "left", "right", and "both".'},
                                   'columnAttach3': {'docstring': 'Sets the attachment type for all three columns. Ignored if there are not exactly three columns. Valid values are "left", "right", and "both".'},
                                   'columnAttach4': {'docstring': 'Sets the attachment type for all four columns. Ignored if there are not exactly four columns. Valid values are "left", "right", and "both".'},
                                   'columnAttach5': {'docstring': 'Sets the attachment type for all five columns. Ignored if there are not exactly five columns. Valid values are "left", "right", and "both".'},
                                   'columnAttach6': {'docstring': 'Sets the attachment type for all six columns. Ignored if there are not exactly six columns. Valid values are "left", "right", and "both".'},
                                   'columnOffset2': {'docstring': 'This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the -columnAttach2 flag.  Ignored if there are not exactly two columns.'},
                                   'columnOffset3': {'docstring': 'This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the -columnAttach3 flag.  Ignored if there are not exactly three columns.'},
                                   'columnOffset4': {'docstring': 'This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the -columnAttach4 flag.  Ignored if there are not exactly four columns.'},
                                   'columnOffset5': {'docstring': 'This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the -columnAttach5 flag.  Ignored if there are not exactly five columns.'},
                                   'columnOffset6': {'docstring': 'This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the -columnAttach6 flag.  Ignored if there are not exactly six columns.'},
                                   'columnWidth': {'docstring': 'Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies the column (1 based index) and the second parameter specifies the width.'},
                                   'columnWidth1': {'docstring': 'Sets the width of the first column. Ignored if there is not exactly one column.'},
                                   'columnWidth2': {'docstring': 'Sets the column widths of both columns. Ignored if there are not exactly two columns.'},
                                   'columnWidth3': {'docstring': 'Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.'},
                                   'columnWidth4': {'docstring': 'Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.'},
                                   'columnWidth5': {'docstring': 'Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.'},
                                   'columnWidth6': {'docstring': 'Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.'},
                                   'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                                   'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                                   'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                                   'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                                   'edit': {'docstring': ''},
                                   'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                                   'enableBackground': {'docstring': 'Enables the background color of the control.'},
                                   'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                                   'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                                   'forceDragRefresh': {'docstring': 'If used then force refresh on drag'},
                                   'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                                   'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                                   'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                                   'hsvValue': {'docstring': 'Color in hue, saturation, and value format.'},
                                   'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                                   'label': {'docstring': 'Label text for the group.'},
                                   'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                                   'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                                   'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                                   'parent': {'docstring': 'The parent layout for this control.'},
                                   'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                                   'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                                   'query': {'docstring': ''},
                                   'rgbValue': {'docstring': 'Color in red, green, and blue format.'},
                                   'rowAttach': {'docstring': 'Arguments are : column, attachment type, offset. Possible attachments are: top | bottom | both. Specifies attachment types and offsets for the entire row.'},
                                   'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                                   'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                                   'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                                   'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                                   'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'colorManagementCatalog': {'description': 'This non-undoable action performs additions and removals of custom color transforms from the Autodesk native color transform catalog.  Once a custom color transform has been added to the catalog, it can be used in the same way as the builtin Autodesk native color transforms. \t         ',
                            'flags': {'addTransform': {'docstring': 'Add transform to collection.'},
                                      'editUserTransformPath': {'docstring': 'Edit the user transform directory. By changing the directory, all custom transforms currently added could be changed, and new ones could appear.'},
                                      'listSupportedExtensions': {'docstring': 'List the file extensions that are supported by add transform.  This list is valid for all transform types, and therefore this flag does not require use of the type flag.'},
                                      'listTransformConnections': {'docstring': 'List the transforms that can be used as source (for "view" and "output" types) or destination (for "input" and "rendering space" types) to connect a custom transform to the rest of the transform collection.'},
                                      'path': {'docstring': 'In addTransform mode, the path to the transform data file.'},
                                      'queryUserTransformPath': {'docstring': 'Query the user transform directory.'},
                                      'removeTransform': {'docstring': 'Remove transform from collection.'},
                                      'transformConnection': {'docstring': 'In addTransform mode, an existing transform to which the added transform will be connected. For an input transform or rendering space transform, this will be a destination. For a view or output transform, this will be a source.'},
                                      'type': {'docstring': 'The type of transform added, removed, or whose transform connections are to be listed. Must be one of "view", "rendering space", "input", or "output". \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'colorManagementConvert': {'description': 'This command can be used to convert rendering (a.k.a. working) space color values to display space color values. This is useful if you create custom UI with colors painted to screen, where you need to handle color management yourself. The current view transform set in the Color Management user preferences will be used. \t         ',
                            'flags': {'toDisplaySpace': {'docstring': 'Converts the given RGB value to display space. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'colorManagementFileRules': {'description': 'This non-undoable action manages the list of rules that Maya uses to assign an initial input color space to dependency graph nodes that read in color information from a file.  Rules are structured in a chain of responsibility, from highest priority rule to lowest priority rule, each rule matching a file path pattern and extension.  If a rule matches a given file path, its color space is returned as the result of rules evaluation, and no further rule is considered.  The lowest priority rule will always return a match. Rules can be added, removed, and changed in priority in the list.  Each rule can have its file path pattern, extension, and color space changed. The rule list can be saved to user preferences, and loaded from user preferences. \t         In query mode, return type is based on queried flag.',
                              'flags': {'addRule': {'docstring': 'Add a rule with the argument name to the list of rules, as the highest-priority rule.  If this flag is used, the pattern, extension, and colorSpace flags must be used as well, to specify the file rule pattern, extension, and color space, respectively.'},
                                        'colorSpace': {'docstring': 'The input color space for the rule.  If the rule matches a file path, this is the color space that is returned.  This color space must match an existing color space in the input color space list.'},
                                        'colorSpaceDescription': {'docstring': 'Returns the description for a specific color space.'},
                                        'colorSpaceFamilies': {'docstring': 'Returns the list of families for a specific color space. Used to add submenus when populating the color spaces UI popup of a rule.'},
                                        'colorSpaceNames': {'docstring': 'Returns the list of available color spaces. Used to populate the color spaces UI popup of a rule.'},
                                        'down': {'docstring': 'Move the rule with the argument name down one position towards lower priority.'},
                                        'edit': {'docstring': ''},
                                        'enabled': {'docstring': 'Are the file rules enabled?'},
                                        'evaluate': {'docstring': 'Evaluates the list of rules and returns the input color space name that corresponds to the argument file path.'},
                                        'extension': {'docstring': 'The file extension for the rule is case insensitive'},
                                        'listRules': {'docstring': 'Returns an array of rule name strings, in order, from lowest-priority (rule 0) to highest-priority (last rule in array).'},
                                        'load': {'docstring': 'Read the rules from Maya preferences.  Any existing rules are cleared.'},
                                        'moveUp': {'docstring': 'Move the rule with the argument name up one position towards higher priority.'},
                                        'pattern': {'docstring': "The file path pattern for the rule.  This is the substring to match in the file path, expressed as a glob pattern: for example, '\\*' matches all files. For more information about glob pattern syntax, see http://en.wikipedia.org/wiki/Glob_%28programming%29."},
                                        'query': {'docstring': ''},
                                        'remove': {'docstring': 'Remove the rule with the argument name from the list of rules.'},
                                        'restoreDefaults': {'docstring': 'Restore the list of rules to the default ones only.'},
                                        'save': {'docstring': 'Save the rules to Maya preferences. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'colorManagementPrefs': {'description': 'This command allows querying and editing the color management global data in a scene.  It also allows for setting the view transform and rendering space which automatically configures the color processing in the enabled views. \t         In query mode, return type is based on queried flag.',
                          'flags': {'cmConfigFileEnabled': {'docstring': 'Turn on or off applying an OCIO configuration file.  If set, the color management configuration set in the preferences is used.'},
                                    'cmEnabled': {'docstring': 'Turn on or off color management in general.  If set, the color management configuration set in the preferences is used.'},
                                    'colorManageAllNodes': {'docstring': 'Adds color management to all input nodes such as file texture nodes'},
                                    'colorManagePots': {'docstring': 'Turn on or off color management of color pots in the UI.  If set, colors in color pots are taken to be in rendering space, and are displayed after being transformed by the view transform set in the preferences.'},
                                    'colorManagedNodes': {'docstring': 'Gets the names of all nodes that apply color management to bring pixels from an input color space to the rendering space. Examples include file texture node.'},
                                    'colorManagementSDKVersion': {'docstring': 'Obtain the version of the color management SDK used by Maya.'},
                                    'configFilePath': {'docstring': 'The configuration file to be used, if color management is enabled.'},
                                    'configFileVersion': {'docstring': 'Obtain the version of the config version.'},
                                    'defaultInputSpaceName': {'docstring': 'This flag is obsolete.  See the colorManagementFileRules command for more information.'},
                                    'displayName': {'docstring': 'The display from the (display, view) pair, to be applied by color managed viewers and color managed UI controls.'},
                                    'displayNames': {'docstring': 'Returns the list of available displays.  Used to populate the color management preference UI popup.'},
                                    'edit': {'docstring': ''},
                                    'equalsToPolicyFile': {'docstring': 'Query if the current loaded policy settings is the same with the settings described in the policy file which is the argument of the command.'},
                                    'exportPolicy': {'docstring': 'Export the color management parameters to policy file'},
                                    'inhibitEvents': {'docstring': 'Inhibit client-server notifications and event triggers which occur when changing the color management settings.'},
                                    'inputSpaceDescription': {'docstring': 'Returns the description for a specific input color space.'},
                                    'inputSpaceFamilies': {'docstring': 'Returns the list of families for a specific input color space. Used to add submenus when populating the input color spaces UI popup.'},
                                    'inputSpaceNames': {'docstring': 'Returns the list of available input color spaces. Used to populate the input color spaces UI popup.'},
                                    'loadPolicy': {'docstring': 'Load the color management policy file. This file overides the color management settings.'},
                                    'loadedDefaultInputSpaceName': {'docstring': 'This flag is obsolete.'},
                                    'loadedDisplayName': {'docstring': 'Gets the loaded display from the (display, view) pair.  Used by file open, import, and reference to check for missing color spaces or transforms.'},
                                    'loadedOutputTransformName': {'docstring': 'Gets the loaded output transform.  Used by file open, import, and reference to check for missing color spaces or transforms.'},
                                    'loadedRenderingSpaceName': {'docstring': 'Gets the loaded rendering space.  Used by file open, import, and reference to check for missing color spaces or transforms.'},
                                    'loadedViewName': {'docstring': 'Gets the loaded view from the (display, view) pair.  Used by file open, import, and reference to check for missing color spaces or transforms.'},
                                    'loadedViewTransformName': {'docstring': 'Gets the loaded view transform.  Used by file open, import, and reference to check for missing color spaces or transforms.'},
                                    'missingColorSpaceNodes': {'docstring': 'Gets the names of the nodes that have color spaces not defined in the selected transform collection.'},
                                    'ocioRulesEnabled': {'docstring': 'Turn on or off the use of colorspace assignment rules from the OCIO library.'},
                                    'ociov2Enabled': {'docstring': 'Is OCIOv2 the colour management system by default.'},
                                    'outputTarget': {'docstring': 'Indicates to which output the outputTransformEnabled or the outputTransformName flags are to be applied. Valid values are "renderer" or "playblast".'},
                                    'outputTransformEnabled': {'docstring': 'Turn on or off applying the output transform for out of viewport renders. If set, the output transform set in the preferences is used.'},
                                    'outputTransformName': {'docstring': 'The output transform to be applied for out of viewport renders.  Disables output use view transform mode.'},
                                    'outputTransformNames': {'docstring': 'Returns the list of available output transforms.'},
                                    'outputTransformUseColorConversion': {'docstring': 'Turn on or off selecting the color space conversion for the output color space of viewport renders.  If set, a conversion color space is used; otherwise, a view transform is used.'},
                                    'outputUseViewTransform': {'docstring': 'Turns use view transform mode on.  In this mode, the output transform is set to match the view transform.  To turn the mode off, set an output transform using the outputTransformName flag.'},
                                    'policyFileName': {'docstring': 'Set the policy file name'},
                                    'popupOnError': {'docstring': 'Turn on or off displaying a modal popup on error (as well as the normal script editor reporting of the error), for this invocation of the command.  Default is off.'},
                                    'query': {'docstring': ''},
                                    'refresh': {'docstring': 'Refresh the color management.'},
                                    'renderingSpaceName': {'docstring': 'The color space to be used during rendering.  This is the source color space to the viewing transform, for color managed viewers and color managed UI controls, and the destination color space for color managed input pixels.'},
                                    'renderingSpaceNames': {'docstring': 'Returns the list of available rendering spaces.  Used to populate the color management preference UI popup.'},
                                    'restoreDefaults': {'docstring': 'Restore the color management settings to their default value.'},
                                    'viewName': {'docstring': 'The view from the (display, view) pair, to be applied by color managed viewers and color managed UI controls.'},
                                    'viewNames': {'docstring': 'Returns the list of available views from the selected display.  Used to populate the color management preference UI popup.'},
                                    'viewTransformName': {'docstring': 'The view transform to be applied by color managed viewers and color managed UI controls.'},
                                    'viewTransformNames': {'docstring': 'Returns the list of available view transforms.  Used to populate the color management preference UI popup. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'colorSliderButtonGrp': {'description': 'All of the group commands position their individual controls in columns starting at column 1.  The layout of each control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign, and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one column in any group can be adjustable. This command object creates a new color slider group with a button and a symbol button. This control is primarily used in the rendering UI. In this context, the button brings up a dialog that allows the user to assign a texture map to this parameter. Once a texture map is available, a symbol button shows up. When this symbol button is pressed, the user is taken to another dialog to edit the texture map. ',
                          'flags': {'adjustableColumn': {'docstring': 'Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based index. Passing 0 as argument turns off the previous adjustable column.'},
                                    'adjustableColumn2': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly two columns.'},
                                    'adjustableColumn3': {'docstring': 'Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly three columns.'},
                                    'adjustableColumn4': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly four columns.'},
                                    'adjustableColumn5': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly five columns.'},
                                    'adjustableColumn6': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly six columns.'},
                                    'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                                    'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                                    'buttonCommand': {'docstring': 'Command string executed when the button is pressed.'},
                                    'buttonLabel': {'docstring': 'The button text.'},
                                    'changeCommand': {'docstring': 'Command string executed when slider value changes.'},
                                    'columnAlign': {'docstring': 'Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type for the specified column.'},
                                    'columnAlign2': {'docstring': 'Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are "left", "right", and "center".'},
                                    'columnAlign3': {'docstring': 'Sets the text alignment for all three columns.  Ignored if there are not exactly three columns. Valid values are "left", "right", and "center".'},
                                    'columnAlign4': {'docstring': 'Sets the text alignment for all four columns.  Ignored if there are not exactly four columns. Valid values are "left", "right", and "center".'},
                                    'columnAlign5': {'docstring': 'Sets the text alignment for all five columns.  Ignored if there are not exactly five columns. Valid values are "left", "right", and "center".'},
                                    'columnAlign6': {'docstring': 'Sets the text alignment for all six columns.  Ignored if there are not exactly six columns. Valid values are "left", "right", and "center".'},
                                    'columnAttach': {'docstring': 'Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies column attachment types and offets.'},
                                    'columnAttach2': {'docstring': 'Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are "left", "right", and "both".'},
                                    'columnAttach3': {'docstring': 'Sets the attachment type for all three columns. Ignored if there are not exactly three columns. Valid values are "left", "right", and "both".'},
                                    'columnAttach4': {'docstring': 'Sets the attachment type for all four columns. Ignored if there are not exactly four columns. Valid values are "left", "right", and "both".'},
                                    'columnAttach5': {'docstring': 'Sets the attachment type for all five columns. Ignored if there are not exactly five columns. Valid values are "left", "right", and "both".'},
                                    'columnAttach6': {'docstring': 'Sets the attachment type for all six columns. Ignored if there are not exactly six columns. Valid values are "left", "right", and "both".'},
                                    'columnOffset2': {'docstring': 'This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the -columnAttach2 flag.  Ignored if there are not exactly two columns.'},
                                    'columnOffset3': {'docstring': 'This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the -columnAttach3 flag.  Ignored if there are not exactly three columns.'},
                                    'columnOffset4': {'docstring': 'This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the -columnAttach4 flag.  Ignored if there are not exactly four columns.'},
                                    'columnOffset5': {'docstring': 'This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the -columnAttach5 flag.  Ignored if there are not exactly five columns.'},
                                    'columnOffset6': {'docstring': 'This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the -columnAttach6 flag.  Ignored if there are not exactly six columns.'},
                                    'columnWidth': {'docstring': 'Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies the column (1 based index) and the second parameter specifies the width.'},
                                    'columnWidth1': {'docstring': 'Sets the width of the first column. Ignored if there is not exactly one column.'},
                                    'columnWidth2': {'docstring': 'Sets the column widths of both columns. Ignored if there are not exactly two columns.'},
                                    'columnWidth3': {'docstring': 'Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.'},
                                    'columnWidth4': {'docstring': 'Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.'},
                                    'columnWidth5': {'docstring': 'Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.'},
                                    'columnWidth6': {'docstring': 'Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.'},
                                    'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                                    'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                                    'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                                    'dragCommand': {'docstring': 'Command string executed when slider value marker is dragged.'},
                                    'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                                    'edit': {'docstring': ''},
                                    'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                                    'enableBackground': {'docstring': 'Enables the background color of the control.'},
                                    'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                                    'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                                    'forceDragRefresh': {'docstring': 'If used then force refresh on drag'},
                                    'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                                    'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                                    'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                                    'hsvValue': {'docstring': 'Color in hue, saturation, and value format.'},
                                    'image': {'docstring': 'Image displayed on the symbol button.'},
                                    'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                                    'label': {'docstring': 'Label text for the group.'},
                                    'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                                    'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                                    'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                                    'parent': {'docstring': 'The parent layout for this control.'},
                                    'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                                    'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                                    'query': {'docstring': ''},
                                    'rgbValue': {'docstring': 'Color in red, green, and blue format.'},
                                    'rowAttach': {'docstring': 'Arguments are : column, attachment type, offset. Possible attachments are: top | bottom | both. Specifies attachment types and offsets for the entire row.'},
                                    'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                                    'symbolButtonCommand': {'docstring': 'Command string executed when the symbol button is pressed.'},
                                    'symbolButtonDisplay': {'docstring': 'Visibility of the symbol button.'},
                                    'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                                    'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                                    'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                                    'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'colorSliderGrp': {'description': 'All of the group commands position their individual controls in columns starting at column 1.  The layout of each control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign, and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one column in any group can be adjustable. This command creates a color Slider group consisting of a label, a color canvas and a slider.  Clicking on the canvas will bring up the color editor dialog. ',
                    'flags': {'adjustableColumn': {'docstring': 'Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based index. Passing 0 as argument turns off the previous adjustable column.'},
                              'adjustableColumn2': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly two columns.'},
                              'adjustableColumn3': {'docstring': 'Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly three columns.'},
                              'adjustableColumn4': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly four columns.'},
                              'adjustableColumn5': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly five columns.'},
                              'adjustableColumn6': {'docstring': 'Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly six columns.'},
                              'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                              'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                              'changeCommand': {'docstring': 'Command string executed when slider value changes.'},
                              'columnAlign': {'docstring': 'Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type for the specified column.'},
                              'columnAlign2': {'docstring': 'Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are "left", "right", and "center".'},
                              'columnAlign3': {'docstring': 'Sets the text alignment for all three columns.  Ignored if there are not exactly three columns. Valid values are "left", "right", and "center".'},
                              'columnAlign4': {'docstring': 'Sets the text alignment for all four columns.  Ignored if there are not exactly four columns. Valid values are "left", "right", and "center".'},
                              'columnAlign5': {'docstring': 'Sets the text alignment for all five columns.  Ignored if there are not exactly five columns. Valid values are "left", "right", and "center".'},
                              'columnAlign6': {'docstring': 'Sets the text alignment for all six columns.  Ignored if there are not exactly six columns. Valid values are "left", "right", and "center".'},
                              'columnAttach': {'docstring': 'Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies column attachment types and offets.'},
                              'columnAttach2': {'docstring': 'Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are "left", "right", and "both".'},
                              'columnAttach3': {'docstring': 'Sets the attachment type for all three columns. Ignored if there are not exactly three columns. Valid values are "left", "right", and "both".'},
                              'columnAttach4': {'docstring': 'Sets the attachment type for all four columns. Ignored if there are not exactly four columns. Valid values are "left", "right", and "both".'},
                              'columnAttach5': {'docstring': 'Sets the attachment type for all five columns. Ignored if there are not exactly five columns. Valid values are "left", "right", and "both".'},
                              'columnAttach6': {'docstring': 'Sets the attachment type for all six columns. Ignored if there are not exactly six columns. Valid values are "left", "right", and "both".'},
                              'columnOffset2': {'docstring': 'This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the -columnAttach2 flag.  Ignored if there are not exactly two columns.'},
                              'columnOffset3': {'docstring': 'This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the -columnAttach3 flag.  Ignored if there are not exactly three columns.'},
                              'columnOffset4': {'docstring': 'This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the -columnAttach4 flag.  Ignored if there are not exactly four columns.'},
                              'columnOffset5': {'docstring': 'This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the -columnAttach5 flag.  Ignored if there are not exactly five columns.'},
                              'columnOffset6': {'docstring': 'This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the -columnAttach6 flag.  Ignored if there are not exactly six columns.'},
                              'columnWidth': {'docstring': 'Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies the column (1 based index) and the second parameter specifies the width.'},
                              'columnWidth1': {'docstring': 'Sets the width of the first column. Ignored if there is not exactly one column.'},
                              'columnWidth2': {'docstring': 'Sets the column widths of both columns. Ignored if there are not exactly two columns.'},
                              'columnWidth3': {'docstring': 'Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.'},
                              'columnWidth4': {'docstring': 'Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.'},
                              'columnWidth5': {'docstring': 'Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.'},
                              'columnWidth6': {'docstring': 'Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.'},
                              'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                              'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                              'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                              'dragCommand': {'docstring': 'Command string executed when slider value marker is dragged.'},
                              'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                              'edit': {'docstring': ''},
                              'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                              'enableBackground': {'docstring': 'Enables the background color of the control.'},
                              'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                              'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                              'forceDragRefresh': {'docstring': 'If used then force refresh on drag'},
                              'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                              'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                              'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                              'hsvValue': {'docstring': 'Color in hue, saturation, and value format.'},
                              'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                              'label': {'docstring': 'Label text for the group.'},
                              'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                              'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                              'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                              'parent': {'docstring': 'The parent layout for this control.'},
                              'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                              'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                              'query': {'docstring': ''},
                              'rgbValue': {'docstring': 'Color in red, green, and blue format.'},
                              'rowAttach': {'docstring': 'Arguments are : column, attachment type, offset. Possible attachments are: top | bottom | both. Specifies attachment types and offsets for the entire row.'},
                              'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                              'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                              'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                              'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                              'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'columnLayout': {'description': 'This command creates a layout that arranges its children in a single column. ',
                  'flags': {'adjustableColumn': {'docstring': 'Sets the children of the layout to be attached on both sides. They will stretch or shrink with the layout.'},
                            'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                            'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                            'childArray': {'docstring': "Returns a string array of the names of the layout's immediate children."},
                            'columnAlign': {'docstring': 'Sets the alignment of children containing text or pixmaps. Align values: "left" | "right" | "center".'},
                            'columnAttach': {'docstring': 'Sets the attachment and offsets for the children of the layout.  Side values: "left" | "right" | "both".  Left or both is recommended.'},
                            'columnOffset': {'docstring': 'Sets the offsets for children of the layout. Side values: "left" | "right" | "both".'},
                            'columnWidth': {'docstring': 'Sets the width of the column.  Unless the children are attached to both sides of the column, the width cannot be enforced. Larger children will expand layout.'},
                            'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                            'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                            'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                            'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                            'edit': {'docstring': ''},
                            'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                            'enableBackground': {'docstring': 'Enables the background color of the control.'},
                            'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                            'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                            'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                            'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                            'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                            'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                            'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                            'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                            'numberOfChildren': {'docstring': 'Returns in an int the number of immediate children of the layout.'},
                            'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                            'parent': {'docstring': 'The parent layout for this control.'},
                            'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                            'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                            'query': {'docstring': ''},
                            'rowSpacing': {'docstring': 'Sets the space between children.'},
                            'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                            'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                            'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                            'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                            'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'combinationShape': {'description': 'Command to create or edit drive relationship of blend shape targets \t         ',
                      'flags': {'addDriver': {'docstring': 'Add drivers to the combination shape'},
                                'allDrivers': {'docstring': 'All drivers of the combination shape'},
                                'blendShape': {'docstring': 'Associated blend shape node of the combination shape In query mode, this flag can accept a value.'},
                                'combinationTargetIndex': {'docstring': 'Driven blend shape target index of the combination shape In query mode, this flag can accept a value.'},
                                'combinationTargetName': {'docstring': 'Driven blend shape target name of the combination shape In query mode, this flag can accept a value.'},
                                'combineMethod': {'docstring': 'Combine method of the combination shape: 0 : Multiplication1 : Lowest Weighting2 : Lowest Weighting (Smooth)'},
                                'driverTargetIndex': {'docstring': 'Driver blend shape target index of the combination shape'},
                                'driverTargetName': {'docstring': 'Driver blend shape target name of the combination shape'},
                                'edit': {'docstring': ''},
                                'exist': {'docstring': 'If the combination shape exist'},
                                'query': {'docstring': ''},
                                'removeDriver': {'docstring': 'Remove drivers from the combination shape \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'commandEcho': {'description': 'This command controls what is echoed to the command window. \t         In query mode, return type is based on queried flag.',
                 'flags': {'addFilter': {'docstring': 'This flag allows you to append filters to the current list of filtered commands when echo all commands is enabled. Just like the filter flag, you can provide a partial command name, so all commands that start with a substring specified in the addFilter entry will be filtered out.'},
                           'filter': {'docstring': 'This flag allows you to filter out unwanted commands when echo all commands is enabled. You can provide a partial command name, so all commands that start with a substring specified in filter entry will be filtered out. If filter is empty, all commands are echoed to the command window.'},
                           'lineNumbers': {'docstring': 'If true then file name and line number information is provided in error and warning messages. If false then no file name and line number information is provided in error and warning messages.'},
                           'query': {'docstring': ''},
                           'state': {'docstring': 'If true then all commands are echoed to the command window. If false then only relevant commands are echoed.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'commandLine': {'description': 'This command creates a single line for command input/output.The left half is for input, the right half for output. ',
                 'flags': {'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                           'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                           'command': {'docstring': 'Command executed when the command line text changes.'},
                           'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                           'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                           'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                           'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                           'edit': {'docstring': ''},
                           'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                           'enableBackground': {'docstring': 'Enables the background color of the control.'},
                           'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                           'enterCommand': {'docstring': "Command executed when the keypad 'Enter' key is pressed."},
                           'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                           'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                           'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                           'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                           'holdFocus': {'docstring': 'Sets whether the command line should hold focus after exectuing a command.'},
                           'inputAnnotation': {'docstring': 'Annotate the input field with an extra string value.'},
                           'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                           'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                           'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                           'numberOfHistoryLines': {'docstring': 'Sets the maximum number of commands saved to the command line history. Up to -nhl/numberOfHistoryLines previous commands will be available by pressing the up-arrow from within the input field. The default value is 50.'},
                           'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                           'outputAnnotation': {'docstring': 'Annotate the output field with an extra string value.'},
                           'parent': {'docstring': 'The parent layout for this control.'},
                           'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                           'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                           'query': {'docstring': ''},
                           'sourceType': {'docstring': 'Sets the source type of this command line. Currently supports "mel" (enabled by default) and "python".'},
                           'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                           'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                           'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                           'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                           'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'commandLogging': {'description': 'This command controls logging of Maya commands, in memory and on disk. Note that if commands are logged in memory, they will be available to the crash reporter and appear in crash logs. \t         In query mode, return type is based on queried flag.',
                    'flags': {'historySize': {'docstring': 'Sets the number of entries in the in-memory command history.'},
                              'logCommands': {'docstring': 'Enables or disables the on-disk logging of commands.'},
                              'logFile': {'docstring': 'Sets the filename to use for the on-disk log. If logging is active, the current file will be closed before the new one is opened.'},
                              'query': {'docstring': ''},
                              'recordCommands': {'docstring': 'Enables or disables the in-memory logging of commands.'},
                              'resetLogFile': {'docstring': "Reset the log filename to the default ('mayaCommandLog.txt' in the application folder, alongside 'Maya.env' and the default projects folder).                  Flag can have multiple arguments, passed either as a tuple or a list."}}},
 'commandPort': {'description': 'Opens or closes the Maya command port. The command port comprises a socket to which a client program may connect. An example command port client "mcp" is included in the Motion Capture developers kit. It supports multi-byte commands and uses utf-8 as its transform format. It will receive utf8 command string and decode it to Maya native coding. The result will also be encoded to utf-8 before sending back. Care should be taken regarding INET domain sockets as no user identification, or authorization is required to connect to a given socket, and all commands (including "system(...)") are allowed and executed with the user id and permissions of the Maya user. The prefix flag can be used to reduce this security risk, as only the prefix command is executed. The query flag can be used to determine if a given command port exists. See examples below. ',
                 'flags': {'bufferSize': {'docstring': 'Commands and results are each subject to size limits. This option allows the user to specify the size of the buffer used to communicate with Maya. If unspecified the default buffer size is 4096 characters. Commands longer than bufferSize characters will cause the client connection to close. Results longer that bufferSize characters are replaced with an error message.'},
                           'close': {'docstring': 'Closes the commandPort, deletes the pipes'},
                           'echoOutput': {'docstring': 'Sends a copy of all command output to the command port. Typically only the result is transmitted. This option provides a copy of all output.'},
                           'listPorts': {'docstring': 'Returns the available ports'},
                           'name': {'docstring': 'Specifies the name of the command port which this command creates. CommandPort names of the form namecreate a UNIX domain socket on the localhost corresponding to name. If namedoes not begin with "/", then /tmp/nameis used. If namebegins with "/", namedenotes the full path to the socket.  Names of the form :port numbercreate an INET domain on the local host at the given port.'},
                           'noreturn': {'docstring': 'Do not write the results from executed commands back to the command port socket. Instead, the results from executed commands are written to the script editor window. As no information passes back to the command port client regarding the execution of the submitted commands, care must be taken not to overflow the command buffer, which would cause the connection to close.'},
                           'outputVar': {'docstring': ''},
                           'pickleOutput': {'docstring': 'Python output will be pickled.'},
                           'prefix': {'docstring': 'The string argument is the name of a Maya command taking one string argument. This command is called each time data is sent to the command port. The data written to the command port is passed as the argument to the prefix command. The data from the command port is encoded as with enocodeString and enclosed in quotes.  If newline characters are embedded in the command port data, the input is split into individual lines. These lines are treated as if they were separate writes to the command port. Only the result to the last prefix command is returned.'},
                           'query': {'docstring': ''},
                           'returnNumCommands': {'docstring': 'Ignore the result of the command, but return the number of commands that have been read and executed in this call. This is a simple way to track buffer overflow. This flag is ignored when the noreturnflag is specified.'},
                           'securityWarning': {'docstring': 'Enables security warning on command port input.'},
                           'sourceType': {'docstring': 'The string argument is used to indicate which source type would be passed to the commandPort, like "mel", "python". The default source type is "mel".                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'componentBox': {'description': 'This command creates a component box, which is sensitive to the active list.  It displays certain components of the last node on the active list, and provides a two-way connection to keep the widget up to date. ',
                  'flags': {'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                            'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                            'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                            'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                            'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                            'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                            'edit': {'docstring': ''},
                            'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                            'enableBackground': {'docstring': 'Enables the background color of the control.'},
                            'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                            'execute': {'docstring': 'Immediately executes the command string once for every cell (or every selected cell, if the boolean argument is TRUE) in the component box, for every matching selected object (ie, for every object would be affected if you changed a cell value.)  Before the command is executed, "#A" is substituted with the name of the attribute, and "#N" with the name of the node, and "#P" with the full path name of the node.'},
                            'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                            'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                            'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                            'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                            'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                            'labelWidth': {'docstring': 'An optional flag which is used to modify the width assigned to labels appearing in the componentBox.'},
                            'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                            'maxHeight': {'docstring': 'An optional flag which is used to limit the height of the componentBox.'},
                            'maxWidth': {'docstring': 'An optional flag which is used to limit the width of the componentBox.'},
                            'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                            'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                            'parent': {'docstring': 'The parent layout for this control.'},
                            'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                            'precision': {'docstring': 'Controls the number of digits to the right of the decimal point that will be displayed for float-valued components. Default is 3.  Queried, returns an int.'},
                            'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                            'query': {'docstring': ''},
                            'rowHeight': {'docstring': 'An optional flag which is used to set the height of all rows in the componentBox.'},
                            'selectedAttr': {'docstring': 'Returns a list of names of all the attributes that are selected. This flag is ignored when not being queried.'},
                            'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                            'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                            'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                            'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                            'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'componentEditor': {'description': 'This command creates a new component editor in the current layout. ',
                     'flags': {'control': {'docstring': 'Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus. Caution: It is possible for an editor to exist without a control. The query will return "NONE" if no control is present.'},
                               'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                               'docTag': {'docstring': 'Attaches a tag to the editor.'},
                               'edit': {'docstring': ''},
                               'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                               'filter': {'docstring': 'Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the main list of the editor.'},
                               'floatField': {'docstring': 'assigns a float field that the component editor will use for editing groups of values.'},
                               'floatSlider': {'docstring': 'assigns a float slider that the component editor will use for editing groups of values.'},
                               'forceMainConnection': {'docstring': 'Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.'},
                               'hidePathName': {'docstring': 'Hides path name of displayed element.  By default this flag is set to false.'},
                               'hideZeroColumns': {'docstring': 'Hides columns whose elements are all zero.  By default this flag is set to false.'},
                               'highlightConnection': {'docstring': 'Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all editors have a highlight list. For those that do, it is a secondary selection list.'},
                               'justifyHeaders': {'docstring': 'Set justification mode for headers of columns.  Possible values are 0 (right justify), or 1 (left justify). By default this flag is set to 0.'},
                               'lockInput': {'docstring': 'Prevents the editor from responding to changes in the active list. Independent of selection connection.'},
                               'lockMainConnection': {'docstring': 'Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor. Further changes to the original mainConnection are ignored.'},
                               'mainListConnection': {'docstring': 'Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object.'},
                               'newTab': {'docstring': 'Creates a new tab, named by the first argument, based on an existing tab, given as the second argument using elements from a set, given in the third argument'},
                               'operationCount': {'docstring': 'returns the total number of operation types known to the component editor.'},
                               'operationLabels': {'docstring': 'returns a string array containing the names for all operation types known to the editor.'},
                               'operationType': {'docstring': 'Tells the editor which of its known operation types it should be performing. This is a 0-based index.'},
                               'panel': {'docstring': 'Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is deleted.'},
                               'parent': {'docstring': 'Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.'},
                               'precision': {'docstring': 'Specifies the maximum number of digits displayed to the right of the decimal place.  Can be 0 to 20.'},
                               'query': {'docstring': ''},
                               'removeTab': {'docstring': 'Removes the tab based on the set provided'},
                               'selected': {'docstring': 'Returns a list of strings, containing the labels of the currently selected columns'},
                               'selectionConnection': {'docstring': 'Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes changes, the editor updates to show the changes.'},
                               'setOperationLabel': {'docstring': 'uses the string as the new name for the existing operation type specified by the integer index. Note that there is no messaging system which allows UI to be informed of changes made by this flag.'},
                               'showNamespaces': {'docstring': 'Show the namespaces for objects, if any.  By default this flag is set to true.'},
                               'showObjects': {'docstring': 'Restricts the display to columns that are in the current active list.'},
                               'showSelected': {'docstring': 'Restricts the display to those columns which are currently selected. By default this flag is set to false, so all columns are selected. The results from this flag obey the current -hideZeroColumns setting.'},
                               'sortAlpha': {'docstring': 'Controls alphabetical (true), or hierarchical sorting of columns'},
                               'stateString': {'docstring': 'Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned command string uses the string variable $editorName in place of a specific name.'},
                               'unParent': {'docstring': 'Specifies that the editor should be removed from its layout. This cannot be used in query mode.'},
                               'unlockMainConnection': {'docstring': 'Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic updates.'},
                               'updateMainConnection': {'docstring': 'Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.'},
                               'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'condition': {'description': 'This command creates a new named condition object whose true/false value is calculated by running a mel script. This new condition can then be used for dimming, or controlling other scripts, or whatever. In query mode, return type is based on queried flag.',
               'flags': {'delete': {'docstring': 'Deletes the condition.'},
                         'dependency': {'docstring': 'Each -dependency flag specifies another condition that the new condition will be dependent on.  When any of these conditions change, the new-state-script will run, and the state of this condition will be set accordingly.  It is possible to define infinite loops, but they will be caught and handled correctly at run-time.'},
                         'edit': {'docstring': ''},
                         'initialize': {'docstring': 'Initializes the condition, by forcing it to run its script as soon as it is created.  If this flag is not specified, the script will not run until one of the dependencies is triggered.'},
                         'query': {'docstring': ''},
                         'script': {'docstring': 'The script that determines the new state of the condition.'},
                         'state': {'docstring': 'Sets the state of the condition. This can be used to create a manually triggered condition: you could create a condition without any dependencies and without a new-state-script. This condition would only change state in response to the -st/state flag.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'cone': {'description': 'The cone command creates a new cone and/or a dependency node that creates one, and returns their names. ',
          'flags': {'axis': {'docstring': "The primitive's axis"},
                    'caching': {'docstring': 'Toggle caching for all attributes so that no recomputation is needed'},
                    'constructionHistory': {'docstring': 'Turn the construction history on or off.'},
                    'degree': {'docstring': 'The degree of the resulting surface: 1 - linear, 3 - cubic Default:3'},
                    'edit': {'docstring': ''},
                    'endSweep': {'docstring': 'The angle at which to end the surface of revolution. Default is 2Pi radians, or 360 degrees. Default:6.2831853'},
                    'frozen': {'docstring': ''},
                    'heightRatio': {'docstring': 'Ratio of "height" to "width" Default:2.0'},
                    'name': {'docstring': 'Sets the name of the newly-created node. If it contains namespace path, the new node will be created under the specified namespace; if the namespace does not exist, it will be created.'},
                    'nodeState': {'docstring': "Maya dependency nodes have 6 possible states. The Normal (0), HasNoEffect (1), and Blocking (2)states can be used to alter how the graph is evaluated.   The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)are for internal use only. They temporarily shut off parts of the graph during interaction (e.g., manipulation). The understanding is that once the operation is done, the state will be reset appropriately, e.g. Waiting-Blockingwill reset back to Blocking.   The Normaland Blockingcases apply to all nodes, while HasNoEffectis node specific; many nodes do not support this option. Plug-ins store state in the MPxNode::stateattribute. Anyone can set it or check this attribute.  Additional details about each of these 3 states follow.  StateDescriptionNormalThe normal node state. This is the default.HasNoEffectThe HasNoEffectoption (a.k.a. pass-through), is used in cases where there is an operation on an input producing an output of the same data type. Nearly all deformers support this state, as do a few other nodes. As stated earlier, it is not supported by all nodes.  Itâ€™s typical to implement support for the HasNoEffectstate in the nodeâ€™s compute method and to perform appropriate operations. Plug-ins can also support HasNoEffect.  The usual implementation of this state is to copy the input directly to the matching output without applying the algorithm in the node. For deformers, applying this state leaves the input geometry undeformed on the output.  BlockingThis is implemented in the depend node base class and applies to all nodes. Blockingis applied during the evaluation phase to connections. An evaluation request to a blocked connection will return as failures, causing the destination plug to retain its current value. Dirty propagation is indirectly affected by this state since blocked connections are never cleaned.  When a node is set to Blockingthe behavior is supposed to be the same as if all outgoing connections were broken. As long as nobody requests evaluation of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked node will still respond to getAttrrequests but a getAttron a downstream node will not reevaluate the blocked node.  Setting the root transform of a hierarchy to Blockingwonâ€™t automatically influence child transforms in the hierarchy. To do this, youâ€™d need to explicitly set all child nodes to the Blockingstate.  For example, to set all child transforms to Blocking, you could use the following script.  import maya.cmds as cmds def blockTree(root): nodesToBlock = [] for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys(): nodesToBlock += cmds.listConnections(node, source=True, destination=True ) for node in {source:1 for source in nodesToBlock}.keys(): cmds.setAttr( '%s.nodeState' % node, 2 )  Applying this script would continue to draw objects but things would not be animated.  Default:kdnNormal"},
                    'object': {'docstring': 'Create the result, or just the dependency node.'},
                    'pivot': {'docstring': "The primitive's pivot point"},
                    'polygon': {'docstring': 'The value of this argument controls the type of the object created by this operation 0: nurbs surface1: polygon (use nurbsToPolygonsPref to set the parameters for the conversion)2: subdivision surface (use nurbsToSubdivPref to set the parameters for the conversion)3: Bezier surface4: subdivision surface solid (use nurbsToSubdivPref to set the parameters for the conversion)Flag can have multiple arguments, passed either as a tuple or a list.'},
                    'query': {'docstring': ''},
                    'radius': {'docstring': 'The radius of the object Default:1.0'},
                    'sections': {'docstring': 'The number of sections determines the resolution of the surface in the sweep direction. Used only if useTolerance is false. Default:8'},
                    'spans': {'docstring': 'The number of spans determines the resolution of the surface in the opposite direction. Default:1'},
                    'startSweep': {'docstring': 'The angle at which to start the surface of revolution Default:0'},
                    'tolerance': {'docstring': 'The tolerance with which to build the surface. Used only if useTolerance is true Default:0.01'},
                    'useOldInitBehaviour': {'docstring': 'Create the cone with base on the origin as in Maya V8.0 and below Otherwise create cone centred at origin Default:false'},
                    'useTolerance': {'docstring': 'Use the specified tolerance to determine resolution. Otherwise number of sections will be used. Default:false                  Common flags'}}},
 'confirmDialog': {'description': 'The confirmDialog command creates a modal dialog with a message to the user and a variable number of buttons to dismiss the dialog.  The dialog is dismissed when the user presses any button or chooses the close item from the window menu.  In the case where a button is pressed then the name of the button selected is returned.  If the dialog is dismissed via the close item then the string returned is specified by the dismissStringflag. The default behaviour when no arguments are specified is to create an empty single button dialog. ',
                   'flags': {'annotation': {'docstring': 'set the annotation for the buttons'},
                             'backgroundColor': {'docstring': 'The background color of the dialog. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. (Windows only flag)'},
                             'button': {'docstring': "Create a button with the given string as it's text."},
                             'cancelButton': {'docstring': 'The cancel button is activated by pressing the escape key. Note that this flag does not create a button, it simply indicates which button created via the buttonflag shall respond to the escape key.'},
                             'defaultButton': {'docstring': 'The default button is activated by pressing the enter key. Note that this flag does not create a button, it simply indicates which button created via the buttonflag shall respond to the enter key.'},
                             'dismissString': {'docstring': 'The string returned when the user selects the \'Close\' item from the Window Manager menu.  If this flag is not set then the string "dismiss" is returned.'},
                             'icon': {'docstring': 'The user can specify one of the four standard icons -- "question", "information", "warning" and "critical".  The question icon indicates that the messsage is asking a question.  The information icon indicates that the message is nothing out of the ordinary.  The warning icon indicates that the message is a warning, but can be dealt with.  The critical icon indicates that the message represents a critical problem. When no icon flag is present, we assume the user does not want to include any icon in the confirm dialog.'},
                             'message': {'docstring': 'The message text appearing in the dialog.'},
                             'messageAlign': {'docstring': 'Align the message left, center, or right.'},
                             'parent': {'docstring': "Specify the parent window for the dialog.  The dialog will be centered on this window and raise and lower with it's parent. By default, the dialog is not parented to a particular window and is simply centered on the screen."},
                             'title': {'docstring': 'The dialog title.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'connectAttr': {'description': 'Connect the attributes of two dependency nodes and return the names of the two connected attributes. The connected attributes must be be of compatible types. First argument is the source attribute, second one is the destination. Refer to dependency node documentation. ',
                 'flags': {'force': {'docstring': 'Forces the connection.  If the destination is already connected, the old connection is broken and the new one made.'},
                           'lock': {'docstring': 'If the argument is true, the destination attribute is locked after making the connection. If the argument is false, the connection is unlocked before making the connection.'},
                           'nextAvailable': {'docstring': 'If the destination multi-attribute has set the indexMatters to be false with this flag specified, a connection is made to the next available index. No index need be specified.'},
                           'referenceDest': {'docstring': 'This flag is used for file io only. The flag indicates that the connection replaces a connection made in a referenced file, and the flag argument indicates the original destination from the referenced file. This flag is used so that if the reference file is modified, maya can still attempt to make the appropriate connections in the main scene to the referenced object.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'connectControl': {'description': "This command attaches a UI widget, specified as the first argument, to one or more dependency node attributes. The attributes/nodes don't have to exist yet, they will get looked up as needed. With no flag specified, this command works on these kinds of controls: floatField, floatScrollBar, floatSlider, intField, intScrollBar, intSlider, floatFieldGrp, intFieldGrp, checkBox, radioCollection, and optionMenu. With the indexflag, It will also work on the individual components of all other groups. This command sets up a two-way connectionbetween the control and the (first-specified) attribute. If this first attribute is changed in any way, the control will be appropriately updated to match its value. Summary: if you change the control, ALL the connected attributes change. If you change the FIRST attribute attached to the control, then the control will change. NOTE: the two-way connection will not be established if the attributes do not exist when the connectControlcommand is run. If the user later uses the control, the connection will be established at that time. To effectively use connectControlwith radioCollections and optionMenus, you must attach a piece of data to each radioButton and menuItem. This piece of data (an integer) can be attached using the dataflag in the radioButtonand menuItemcommands. When the button/item is selected, the attribute will be set to the value of its data. When the attribute is changed, the collection (or optionMenu) will switch to the item that matches the new attribute value. If no item matches, it will be left unchanged. There are some specialized controls that have connection capability (and more) built right into them. See attrFieldSliderGrp, attrFieldGrp, and attrColorSliderGrp. Using these classes can be easier than using connectControl. ",
                    'flags': {'fileName': {'docstring': 'This flag causes the connection to be treated as a filename, and the conversion from internal to external filename representation is made as the data is copied. This only applies to connections to Tfield controls.'},
                              'includeChildren': {'docstring': ''},
                              'index': {'docstring': 'This flag enables you to pick out a sub-control from a group that contains a number of different controls. For example, you can connect one field of a floatFieldGrp.  You must count each member of the group, including any text labels that may exist.  For example, if you have a check box group with a label, the label will count as index 1, and the first check box as index 2.  (Indices are 1-based)'},
                              'preventContextualMenu': {'docstring': 'If true, this flag will block the right mouse button menu of the associated control attribute.'},
                              'preventOverride': {'docstring': "If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  Flag can have multiple arguments, passed either as a tuple or a list."}}},
 'connectDynamic': {'description': 'Dynamic connection specifies that the force fields, emitters, or collisions of an object affect another dynamic object. The dynamic object that is connected to a field, emitter, or collision object is influenced by those fields, emitters and collision objects. Connections are made to individual fields, emitters, collisions.  So, if an object owns several fields, if the user wants some of the fields to affect an object, s/he can specify each field with a "-f" flag; but if the user wants to connect all the fields owned by an object, s/he can specify the object name with the "-f" flag. The same is true for emitters and collisions. Different connection types (i.e., for fields vs. emitters) between the same pair of objects are logically independent. In other words, an object can be influenced by another object\'s fields without being influenced by its emitters or collisions. Each connected object must be a dynamic object. The object connected to can be any object that owns fields, emitters, etc.; it need not be dynamic. Objects that can own influences are particles, geometry objects (nurbs and polys) and lattices.  You can specify either the shape name or the transform name of the object to be influenced. ',
                    'flags': {'addScriptHandler': {'docstring': 'Registers a script that will be given a chance to handle calls to the dynamicConnect command. This flag allows other dynamics systems to override the behaviour of the connectDynamic command. You must pass a Python function as the argument for this flag, and that function must take the following keyword arguments: fields, emitters, collisionObjects and objects. The python function must return True if it has handled the call to connectDynamic. In the case that the script returns true, the connectDynamic command will not do anything as it assumes that the work was handled by the script. If all of the callbacks return false, the connectDynamic command will proceed as normal.  The addScriptHandler flag may not be used with any other flags. When the flag is used, the command will return a numerical id that can be used to deregister the callback later (see the removeScriptHandler flag)'},
                              'collisions': {'docstring': 'Connects each object to the collision models of the given object.'},
                              'delete': {'docstring': 'Deletes existing connections.'},
                              'emitters': {'docstring': 'Connects each object to the emitters of the given object.'},
                              'fields': {'docstring': 'Connects each object to the fields of the given object.'},
                              'removeScriptHandler': {'docstring': 'This flag is used to remove a callback that was previously registered with the addScriptHandler flag. The argument to this flag is the numerical id returned by dynamicConnect when the addScriptHandler flag was used. If this flag is called with an invalid id, then the command will do nothing.  This flag may not be used with any other flag.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'connectJoint': {'description': 'This command will connect two skeletons based on the two selected joints. The first selected joint can be made a child of the parent of the second selected joint or a child of the second selected joint, depending on the flags used. Note1: The first selected joint must be the root of a skeleton. The second selected joint must have a parent. Note2: If a joint name is specified in the command line, it is used as the child and the first selected joint will be the parent. If no joint name is given at the command line, two joints must be selected. ',
                  'flags': {'connectMode': {'docstring': 'The first selected joint will be parented under the parent of the second selected joint.'},
                            'parentMode': {'docstring': 'The first selected joint will be parented under the second selected joint. Both joints will be in the active list(selection list).                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'connectionInfo': {'description': 'The connectionInfocommand is used to get information about connection sources and destinations.  Unlike the isConnected command, this command needs only one end of the connection. ',
                    'flags': {'destinationFromSource': {'docstring': 'If the specified plug (or its ancestor) is a source, this flag returns the list of destinations connected from the source. (array of strings, empty array if none)'},
                              'getExactDestination': {'docstring': 'If the plug or its ancestor is connection destination, this returns the name of the plug that is the exact destination. (empty string if there is no such connection).'},
                              'getExactSource': {'docstring': 'If the plug or its ancestor is a connection source, this returns the name of the plug that is the exact source. (empty string if there is no such connection).'},
                              'getLockedAncestor': {'docstring': 'If the specified plug is locked, its name is returned.  If an ancestor of the plug is locked, its name is returned.  If more than one ancestor is locked, only the name of the closest one is returned.  If neither this plug nor any ancestors are locked, an empty string is returned.'},
                              'isDestination': {'docstring': 'Returns true if the plug (or its ancestor) is the destination of a connection, false otherwise.'},
                              'isExactDestination': {'docstring': 'Returns true if the plug is the exact destination of a connection, false otherwise.'},
                              'isExactSource': {'docstring': 'Returns true if the plug is the exact source of a connection, false otherwise.'},
                              'isLocked': {'docstring': 'Returns true if this plug (or its ancestor) is locked'},
                              'isSource': {'docstring': 'Returns true if the plug (or its ancestor) is the source of a connection, false otherwise.'},
                              'sourceFromDestination': {'docstring': 'If the specified plug (or its ancestor) is a destination, this flag returns the source of the connection. (string, empty if none)                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'constrain': {'description': 'This command constrains rigid bodies to the world or other rigid bodies. \t         In query mode, return type is based on queried flag.',
               'flags': {'barrier': {'docstring': 'Creates a barrier constraint.  This command requires one rigid bodies.'},
                         'damping': {'docstring': 'Sets the damping constant. Default value: 0.1 Range: -1000.0 to 1000.0'},
                         'directionalHinge': {'docstring': 'Creates a directional hinge constraint.  This command requires two rigid bodies. The directional hinge always maintains the initial direction of its axis.'},
                         'edit': {'docstring': ''},
                         'hinge': {'docstring': 'Creates a hinge constraint.  This command requires one or two rigid bodies.'},
                         'interpenetrate': {'docstring': 'Allows (or disallows) the rigid bodies defined in the constrain to ipenetrate.'},
                         'nail': {'docstring': 'Creates a nail constraint.  This command requires one rigid body.'},
                         'name': {'docstring': 'Names the rigid constraint.'},
                         'orientation': {'docstring': 'Set initial orientation of the constraint in world space.  This command is only valid with hinge and barrier constraints Default value: 0.0 0.0 0.0'},
                         'pinConstraint': {'docstring': 'Creates a pin constraint.  This command requires two rigid bodies.'},
                         'position': {'docstring': 'Set initial position of the constraint in world space. Default value: 0.0 0.0 0.0 for uni-constraints, midpoint of bodies for deul constraint.'},
                         'query': {'docstring': ''},
                         'restLength': {'docstring': 'Sets the rest length. Default value: 1.0'},
                         'spring': {'docstring': 'Creates a spring constraint.  This command requires one or two rigidies.'},
                         'stiffness': {'docstring': 'Sets the springs stiffness constant. Default value: 5.0                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'constructionHistory': {'description': 'This command turns construction history on or off. \t         In query mode, return type is based on queried flag.',
                         'flags': {'query': {'docstring': ''},
                                   'toggle': {'docstring': 'Turns construction history on or off.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'container': {'description': 'This command can be used to create and query container nodes. It is also used to perform operations on containers such as: add and remove nodes from the containerpublish attributes from nodes inside the containerreplace the connections and values from one container onto another oneremove a container without removing its member nodes',
               'flags': {'addNode': {'docstring': 'Specifies the list of nodes to add to container.'},
                         'asset': {'docstring': "When queried, if all the nodes in nodeList belong to the same container, returns container's name. Otherwise returns empty string. This flag is functionally equivalent to the findContainer flag."},
                         'assetMember': {'docstring': 'Can be used during query in conjunction with the bindAttr flag to query for the only published attributes related to the specified node within the container.'},
                         'bindAttr': {'docstring': 'Bind a contained attribute to an unbound published name on the interface of the container; returns a list of bound published names. The first string specifies the node and attribute name to be bound in "node.attr" format. The second string specifies the name of the unbound published name. In query mode, returns a string array of the published names and their corresponding attributes. The flag can also be used in query mode in conjunction with the -publishName, -publishAsParent, and -publishAsChild flags.'},
                         'connectionList': {'docstring': 'Returns a list of the exterior connections to the container node.'},
                         'current': {'docstring': 'In create mode, specify that the newly created asset should be current. In edit mode, set the selected asset as current. In query, return the current asset.'},
                         'edit': {'docstring': ''},
                         'fileName': {'docstring': 'Used to query for the assets associated with a given file name.'},
                         'findContainer': {'docstring': "When queried, if all the nodes in nodeList belong to the same container, returns container's name. Otherwise returns empty string."},
                         'force': {'docstring': 'This flag can be used in conjunction with -addNode and -removeNode flags only. If specified with -addNode, nodes will be disconnected from their current containers before they are added to new one. If specified with -removeNode, nodes will be removed from all containers, instead of remaining in the parent container if being removed from a nested container.'},
                         'includeHierarchyAbove': {'docstring': 'Used to specify that the parent hierarchy of the supplied node list should also be included in the container (or deleted from the container). Hierarchy inclusion will stop at nodes which are members of other containers.'},
                         'includeHierarchyBelow': {'docstring': 'Used to specify that the hierarchy below the supplied node list should also be included in the container (or delete from the container). Hierarchy inclusion will stop at nodes which are members of other containers.'},
                         'includeNetwork': {'docstring': 'Used to specify that the node network connected to supplied node list should also be included in the container. Network traversal will stop at default nodes and nodes which are members of other containers.'},
                         'includeNetworkDetails': {'docstring': 'Used to specify specific parts of the network that should be included. Valid arguments to this flag are: "channels", "sdk", "constraints", "history" and "expressions", "inputs", "outputs". The difference between this flag and the includeNetwork flag, is that it will include all connected nodes regardless of their type. Note that dag containers include their children, so they will always include constraint nodes that are parented beneath the selected objects, even when constraints are not specified as an input.'},
                         'includeShaders': {'docstring': 'Used to specify that for any shapes included, their shaders will also be included in the container.'},
                         'includeShapes': {'docstring': 'Used to specify that for any transforms selected, their direct child shapes will be included in the container (or deleted from the container). This flag is not necessary when includeHierarchyBelow is used since the child shapes and all other descendents will automatically be included.'},
                         'includeTransform': {'docstring': 'Used to specify that for any shapes selected, their parent transform will be included in the container (or deleted from the container). This flag is not necessary when includeHierarchyAbove is used since the parent transform and all of its parents will automatically be included.'},
                         'isContainer': {'docstring': 'Return true if the selected or specified node is a container node. If multiple containers are queried, only the state of the first will be returned.'},
                         'name': {'docstring': 'Sets the name of the newly-created container.'},
                         'nodeList': {'docstring': 'When queried, returns a list of nodes in container. The list will be sorted in the order they were added to the container. This will also display any reordering done with the reorderContainer command.'},
                         'nodeNamePrefix': {'docstring': 'Specifies that the name of published attributes should be of the form "node_attr". Must be used with the -publishConnections/-pc flag.'},
                         'parentContainer': {'docstring': 'Flag to query the parent container of a specified container.'},
                         'preview': {'docstring': 'This flag is valid in create mode only. It indicates that you do not want the container to be created, instead you want to preview its contents. When this flag is used, Maya will select the nodes that would be put in the container if you did create the container. For example you can see what would go into the container with -includeNetwork, then modify your selection as desired, and do a create container with the selected objects only.'},
                         'publishAndBind': {'docstring': 'Publish the given name and bind the attribute to the given name. First string specifies the node and attribute name in "node.attr" format. Second string specifies the name it should be published with.'},
                         'publishAsChild': {'docstring': 'Publish contained node to the interface of the container to indicate it can be a child of external nodes. The second string is the name of the published node. In query mode, returns a string of the published names and the corresponding nodes. If -publishName flag is used in query mode, only returns the published names; if -bindAttr flag is used in query mode, only returns the name of the published nodes.'},
                         'publishAsParent': {'docstring': 'Publish contained node to the interface of the container to indicate it can be a parent to external nodes. The second string is the name of the published node. In query mode, returns a string of array of the published names and the corresponding nodes. If -publishName flag is used in query mode, only returns the published names; if -bindAttr flag is used in query mode, only returns the name of the published nodes.'},
                         'publishAsRoot': {'docstring': 'Publish or unpublish a node as a root. The significance of root transform node is twofold. When container-centric selection is enabled, the root transform will be selected if a container node in the hierarchy below it is selected in the main scene view. Also, when exporting a container proxy, any published root transformation attributes such as translate, rotate or scale will be hooked up to attributes on a stand-in node. In query mode, returns the node that has been published as root.'},
                         'publishAttr': {'docstring': 'In query mode, can only be used with the -publishName(-pn) flag, and takes an attribute as an argument; returns the published name of the attribute, if any.'},
                         'publishConnections': {'docstring': 'Publish all connections from nodes inside the container to nodes outside the container.'},
                         'publishName': {'docstring': 'Publish a name to the interface of the container, and returns the actual name published to the interface.  In query mode, returns the published names for the container. If the -bindAttr flag is specified, returns only the names that are bound; if the -unbindAttr flag is specified, returns only the names that are not bound; if the -publishAsParent/-publishAsChild flags are specified, returns only names of published parents/children. if the -publishAttr is specified with an attribute argument in the "node.attr" format, returns the published name for that attribute, if any.'},
                         'query': {'docstring': ''},
                         'removeContainer': {'docstring': 'Disconnects all the nodes from container and deletes container node.'},
                         'removeNode': {'docstring': 'Specifies the list of nodes to remove from container. If node is a member of a nested container, it will be added to the parent container. To remove from all containers completely, use the -force flag.'},
                         'type': {'docstring': 'By default, a container node will be created. Alternatively, the type flag can be used to indicate that a different type of container should be created. At the present time, the only other valid type of container node is "dagContainer".'},
                         'unbindAndUnpublish': {'docstring': 'Unbind the given attribute (in "node.attr" format) and unpublish its associated name. Unbinding a compound may trigger unbinds of its compound parents/children. So the advantage of using this one flag is that it will automatically unpublish the names associated with these automatic unbinds.'},
                         'unbindAttr': {'docstring': 'Unbind a published attribute from its published name on the interface of the container, leaving an unbound published name on the interface of the container; returns a list of unbound published names. The first string specifies the node and attribute name to be unbound in "node.attr" format, and the second string specifies the name of the bound published name. In query mode, can only be used with the -publishName, -publishAsParent and -publishAsChild flags.'},
                         'unbindChild': {'docstring': 'Unbind the node published as child, but do not remove its published name from the interface of the container.'},
                         'unbindParent': {'docstring': 'Unbind the node published as parent, but do not remove its published name from the interface of the container.'},
                         'unpublishChild': {'docstring': 'Unpublish node published as child from the interface of the container'},
                         'unpublishName': {'docstring': 'Unpublish an unbound name from the interface of the container.'},
                         'unpublishParent': {'docstring': 'Unpublish node published as parent from the interface of the container'},
                         'unsortedOrder': {'docstring': 'This flag has no effect on the operation of the container command (OBSOLETE).                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'containerBind': {'description': "This is an accessory command to the container command which is used for some automated binding operations on the container. A container's published interface can be bound using a bindingSet on the associated container template. \t         In query mode, return type is based on queried flag.",
                   'flags': {'allNames': {'docstring': "Specifies that all published names on the container should be considered during the binding operation.  By default only unbound published names will be operated on.  Additionally specifying the 'force' option with 'all' will cause all previously bound published names to be reset (or unbound) before the binding operation is performed; in the event that there is no appropriate binding found for the published name, it will be left in the unbound state."},
                             'bindingSet': {'docstring': 'Specifies the name of the template binding set to use for the bind or query operation. This flag is not available in query mode.'},
                             'bindingSetConditions': {'docstring': "Used in query mode, returns a list of binding set condition entries from the specified template binding set.  The list returned is composed of of all published name / condition string pairs for each entry in the binding set. This flag returns all entries in the associated binding set and does not take into account the validity of each entry with respect to the container's list of published names, bound or unbound state, etc."},
                             'bindingSetList': {'docstring': 'Used in query mode, returns a list of available binding sets that are defined on the associated container template.'},
                             'edit': {'docstring': ''},
                             'force': {'docstring': 'This flag is used to force certain operations to proceed that would normally not be performed.'},
                             'preview': {'docstring': 'This flag will provide a preview of the results of a binding operation but will not actually perform it.  A list of publishedName/boundName pairs are returned for each published name that would be affected by the binding action. If the binding of a published name will not change as a result of the action it will not be listed. Published names that were bound but will become unbound are also listed, in this case the associated boundName will be indicated by an empty string. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'},
                             'query': {'docstring': ''}}},
 'containerProxy': {'description': 'Creates a new container with the same published interface, dynamic attributes and attribute values as the specified container but with fewer container members. This proxy container can be used as a reference proxy so that values can be set on container attributes without loading in the full container. The proxy container will contain one or more locator nodes. The first locator has dynamic attributes that serve as stand-ins for the original published attributes. The remaining locators serve as stand-ins for any dag nodes that have been published as parent or as child and will be placed at the world space location of the published parent/child nodes. The expected usage of container proxies is to serve as a reference proxy for a referenced container. For automated creation, export and setup of the proxy see the doExportContainerProxy.mel script which is invoked by the "Export Container Proxy" menu item. \t         In query mode, return type is based on queried flag.',
                    'flags': {'edit': {'docstring': ''},
                              'fromTemplate': {'docstring': 'Specifies the name of a template file which will be used to create the new container proxy. Stand-in attributes will be created and published for all the numeric attributes on the proxy.'},
                              'query': {'docstring': ''},
                              'type': {'docstring': "Specifies the type of container node to use for the proxy. This flag is only valid in conjunction with the fromTemplate flag. When creating a proxy for an existing container, the type created will always be identical to that of the source container. The default value for this flag is 'container'. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list."}}},
 'containerPublish': {'description': 'This is an accessory command to the container command which is used for some advanced publishing operations on the container. For example, the "publishConnections" flag on the container will publish all the connections, but this command can be used to publish just the inputs, outputs, or to collapse the shared inputs into a single attribute before publishing. \t         In query mode, return type is based on queried flag.',
                      'flags': {'bindNode': {'docstring': 'Bind the specified node to the published node name.'},
                                'bindTemplateStandins': {'docstring': 'This flag will create a temporary stand-in attribute for any attributes that exist in the template but are not already bound. This enables you to set values for unbound attributes.'},
                                'edit': {'docstring': ''},
                                'inConnections': {'docstring': 'Specifies that the unpublished connections to nodes in the container from external nodes should be published.'},
                                'mergeShared': {'docstring': 'For use with the inConnections flag. Indicates that when an external attribute connects to multiple internal attributes within the container, a single published attribute should be used to correspond to all of the internal attributes.'},
                                'outConnections': {'docstring': 'Specifies that the unpublished connections from nodes in the container to external nodes should be published.'},
                                'publishNode': {'docstring': 'Publish a name and type. When first published, nothing will be bound. To bind a node to the published name, use the bindNode flag.'},
                                'query': {'docstring': ''},
                                'unbindNode': {'docstring': 'Unbind the node that is published with the name specified by the flag.'},
                                'unpublishNode': {'docstring': 'Unpublish the specified published node name. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'containerTemplate': {'description': "A container template is a description of a container's published interface. This command provides the ability to create and save a template file for a container or load an existing template file.  Once a template exists, the user can query the template information. \t         In query mode, return type is based on queried flag.",
                       'flags': {'addBindingSet': {'docstring': 'This argument is used to add a new binding set with the given name to a template. A default binding set will be created. If the binding set already exists, the force flag must be used to replace the existing binding set. When used with the fromContainer option, default bindings will be entered based on the current bindings of the designated container. When used without a reference container, the binding set will be made with placeholder entries. The template must be saved before the new binding set is permanently stored with the template file.'},
                                 'addNames': {'docstring': 'In edit mode, when used with the fromContainer flag, any published name on the container not present as an attribute on the template will be added to the template.'},
                                 'addView': {'docstring': 'This argument is used to add a new view with the given name to a template. By default a view containing a flat list of all template attributes will be created.  The layoutMode flag provides more layout options. The template must be saved before the new view is permanently stored with the template file.'},
                                 'allKeyable': {'docstring': 'Used when the fromSelection flag is true and fromContainer is false. If true we will use all keyable attributes to define the template or the view, if false we use the attributes passed in with the attribute flag.'},
                                 'attribute': {'docstring': 'If fromSelection is true and allKeyable is false, this attribute name will be used to create an attribute item in the template file.'},
                                 'attributeList': {'docstring': 'Used in query mode, returns a list of attributes contained in the template definition.'},
                                 'baseName': {'docstring': 'Used in query mode, returns the base name of the template. The basename is the template name with any package qualifiers stripped off.'},
                                 'bindingSetList': {'docstring': 'Used in query mode, returns a list of all binding sets defined on the template.'},
                                 'childAnchor': {'docstring': 'This flag can be optionally specified when querying the publishedNodeList. The resulting list will contain only childAnchor published nodes.'},
                                 'delete': {'docstring': 'Delete the specified template and its file. All objects that are associated with this template or contained in the same template file will be deleted. To simply unload a template without permanently deleting its file, use unload instead.'},
                                 'edit': {'docstring': ''},
                                 'exists': {'docstring': 'Returns true or false depending upon whether the specified template exists. When used with the matchFile argument, the query will return true if the template exists and the filename it was loaded from matches the filename given.'},
                                 'expandCompounds': {'docstring': 'This argument is used to determine how compound parent attributes and their children will be added to generated views when both are published to the container. When true, the compound parent and all compound child attributes published to the container will be included in the view. When false, only the parent attribute is included in the view. Note: if only the child attributes are published and not the parent, the children will be included in the view, this flag is only used in the situation where both parent and child attributes are published to the container. The default value is false.'},
                                 'fileName': {'docstring': 'Specifies the filename associated with the template.  This argument can be used in conjunction with load, save or query modes. If no filename is associated with a template, a default file name based on the template name will be used.  It is recommended but not required that the filename and template name correspond.'},
                                 'force': {'docstring': 'This flag is used with some actions to allow them to proceed with an overwrite or destructive operation. When used with load, it will allow an existing template to be reloaded from a file.  When used in create mode, it will allow an existing template to be recreated (for example when using fromContainer argument to regenerate a template).'},
                                 'fromContainer': {'docstring': 'This argument is used in create or edit mode to specify a container node to be used for generating the template contents. In template creation mode, the template definition will be created based on the list of published attributes in the specified container. In edit mode, when used with the addNames flag or with no other flag, any published name on the container not present as an attribute on the template will be added to the template. This flag is also used in conjunction with flags such as addView.'},
                                 'fromSelection': {'docstring': 'If true, we will use the active selection list to create the template or the view. If allKeyable is also true then we will create the template from all keyable attributes in the selection, otherwise we will create the template using the attributes specified with the attribute flag.'},
                                 'layoutMode': {'docstring': 'This argument is used to specify the layout mode when creating a view. Values correspond as follows: 0: layout in flat list (default when not creating view from container) 1: layout grouped by node (default if creating view from container) The fromContainer or fromSelection argument is required to provide the reference container or selection for layout modes that require node information.  Note that views can only refer to defined template attributes. This means that when using the fromContainer or from Selection flag to add a view to an existing template, only attributes that are defined on both the template and the container or the current selection will be included in the view (i.e. published attributes on the container that are not defined in the template will be ignored).'},
                                 'load': {'docstring': 'Load an existing template from a file. If a filename is specified for the template, the entire file (and all templates in it) will be loaded. If no file is specified, a default filename will be assumed, based on the template name.'},
                                 'matchFile': {'docstring': 'Used in query mode in conjunction with other flags this flag specifies an optional file name that is to be matched as part of the query operation.'},
                                 'matchName': {'docstring': 'Used in query mode in conjunction with other flags this flag specifies an optional template name that is to be matched as part of the query operation. The base template name is used for matching, any template with the same basename will be matched even across different packages.'},
                                 'parentAnchor': {'docstring': 'This flag can be optionally specified when querying the publishedNodeList. The resulting list will contain only parentAnchor published nodes.'},
                                 'publishedNodeList': {'docstring': 'Used in query mode, returns a list of published nodes contained in the template definition. By default all published nodes on the template will be returned. The list of published nodes can be limited to only include certain types of published nodes using one of the childAnchor, parentAnchor or rootTransform flags. If an optional flag is are specified, only nodes of the specified type will be returned.'},
                                 'query': {'docstring': ''},
                                 'removeBindingSet': {'docstring': 'This argument is used to remove the named binding set from the template. The template must be saved before the binding set is permanently removed from the template file.'},
                                 'removeView': {'docstring': 'This argument is used to remove the named view from the template. The template must be saved before the view is permanently removed from the template file.'},
                                 'rootTransform': {'docstring': 'This flag can be optionally specified when querying the publishedNodeList. The resulting list will contain only rootTransform published nodes.'},
                                 'save': {'docstring': 'Save the specified template to a file. If a filename is specified for the template, the entire file (and all templates associated with it) will be saved. If no file name is specified, a default filename will be assumed, based on the template name.'},
                                 'searchPath': {'docstring': "The template searchPath is an ordered list of all locations that are being searched to locate template files (first location searched to last location searched). The template search path setting is stored in the current workspace and can also be set and queried as the file rule entry for 'templates' (see the workspace command for more information). In edit mode, this flag allows the search path setting to be customized. When setting the search path value, the list should conform to a path list format expected on the current platform.  This means that paths should be separated by a semicolon (;) on Windows and a colon (:) on Linux and MacOSX. Environment variables can also be used. Additional built-in paths may be added automatically by maya to the customized settings. In query mode, this flag returns the current contents of the search path; all paths, both customized and built-in, will be included in the query return value."},
                                 'silent': {'docstring': 'Silent mode will suppress any error or warning messages that would normally be reported from the command execution.  The return values are unaffected.'},
                                 'templateList': {'docstring': 'Used in query mode, returns a list of all loaded templates. This query can be used with optional matchFile and matchName flags. When used with the matchFile flag, the list of templates will be restricted to those associated with the specified file.  When used with the matchName flag, the list of templates will be restricted to those matching the specified template name.'},
                                 'unload': {'docstring': 'Unload the specified template.  This action will not delete the associated template file if one exists, it merely removes the template definition from the current session.'},
                                 'updateBindingSet': {'docstring': 'This argument is used to update an existing binding set with new bindings. When used with the fromContainer argument binding set entries with be replaced or merged in the binding set based on the bindings of the designated container. If the force flag is used, existing entries in the binding set are replaced with new values. When force is not used, only new entries are merged into the binding set, any existing entries will be left as-is. When used without a reference container, the binding set will be updated with placeholder entries. The template must be saved before the new binding set is permanently stored with the template file.'},
                                 'useHierarchy': {'docstring': "If true, and the fromSelection flag is set, the selection list will expand to include it's hierarchy also."},
                                 'viewList': {'docstring': 'Used in query mode, returns a list of all views defined on the template. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'containerView': {'description': "A container view defines the layout information for the published attributes of a particular container.  Container views can be selected from a set of built-in views or may be defined on an associated container template. This command queries the view-related information for a container node. The information returned from this command will be based on the view-related settings in force on the container node at the time of the query (i.e. the container's view mode, template name, view name attributes). \t         In query mode, return type is based on queried flag.",
                   'flags': {'edit': {'docstring': ''},
                             'itemInfo': {'docstring': "Used in query mode in conjunction with the itemList flag. The command will return a list of information for each item in the view, the information fields returned for each item are determined by this argument value. The information fields will be listed in the string array returned. The order in which the keyword is specified will determine the order in which the data will be returned by the command. One or more of the following keywords, separated by colons ':' are used to specify the argument value. itemIndex  : sequential item number (0-based)itemName   : item name (string)itemLabel  : item display label (string)itemDescription : item description field (string)itemLevel  : item hierarchy level (0-n)itemIsGroup : (boolean 0 or 1) indicates whether or not this item is a groupitemIsAttribute : (boolean 0 or 1) indicates whether or not this item is an attributeitemNumChildren: number of immediate children (groups or attributes) of this itemitemAttrType : item attribute type (string)itemCallback : item callback field (string)"},
                             'itemList': {'docstring': 'Used in query mode, the command will return a list of information for each item in the view.  The viewName flag is used to select the view to query. The information returned about each item is determined by the itemInfo argument value. For efficiency, it is best to query all necessary item information at one time (to avoid recomputing the view information on each call).'},
                             'query': {'docstring': ''},
                             'viewDescription': {'docstring': 'Used in query mode, returns the description field associated with the selected view. If no description was defined for this view, the value will be empty.'},
                             'viewLabel': {'docstring': 'Used in query mode, returns the display label associated with the view. An appropriate label suitable for the user interface will be returned based on the selected view.  Use of the view label is usually more suitable than the view name for display purposes.'},
                             'viewList': {'docstring': 'Used in query mode, command will return a list of all views defined for the given target (container or template).'},
                             'viewName': {'docstring': 'Used in query mode, specifies the name of the queried view when used in conjunction with a template target. When used in conjunction with a container target, it requires no string argument, and returns the name of the currently active view associated with the container; this value may be empty if the current view is not a valid template view or is generated by one of the built-in views modes. For this reason, the view label is generally more suitable for display purposes. In query mode, this flag can accept a value.Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'contentBrowser': {'description': 'This command is used to edit and query a Content Browser. The Content Browser is a unique panel, so only one instance of it can exist at a given time. The optional argument is the name of the control. \t         ',
                    'flags': {'addContentPath': {'docstring': 'Adds the given path(s) to the libraries displayed on the Examples tab. Also updates the corresponding MAYA_CONTENT_PATH environment variable.'},
                              'context': {'docstring': 'Sets the default location for the given context. The two optional arguments (Python only) are the category (tab) and location. To clear the content use empty strings for category and location.  In query mode, it returns the context of the content browser in an array of 3 strings : the name of the context, the default category name, the default location.'},
                              'control': {'docstring': 'Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus. Caution: It is possible for an editor to exist without a control. The query will return "NONE" if no control is present.'},
                              'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                              'docTag': {'docstring': 'Attaches a tag to the editor.'},
                              'edit': {'docstring': ''},
                              'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                              'filter': {'docstring': 'Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the main list of the editor.'},
                              'forceMainConnection': {'docstring': 'Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.'},
                              'highlightConnection': {'docstring': 'Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all editors have a highlight list. For those that do, it is a secondary selection list.'},
                              'location': {'docstring': 'Switches to the Examples tab and selects the given library location.'},
                              'lockMainConnection': {'docstring': 'Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor. Further changes to the original mainConnection are ignored.'},
                              'mainListConnection': {'docstring': 'Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object.'},
                              'panel': {'docstring': 'Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is deleted.'},
                              'parent': {'docstring': 'Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.'},
                              'preview': {'docstring': 'Shows / hides the preview panel. Note: this flag will not affect the currently opened Content Browser, but only any subsequently opened ones.'},
                              'query': {'docstring': ''},
                              'refreshTreeView': {'docstring': 'Forces a refresh of the Examples tab tree view pane.'},
                              'removeContentPath': {'docstring': 'Removes the given path(s) from the libraries displayed on the Examples tab. Also updates the corresponding MAYA_CONTENT_PATH environment variable.'},
                              'saveCurrentContext': {'docstring': 'Saves the context for the current Content Browser tab.'},
                              'selectionConnection': {'docstring': 'Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes changes, the editor updates to show the changes.'},
                              'stateString': {'docstring': 'Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned command string uses the string variable $editorName in place of a specific name.'},
                              'thumbnailView': {'docstring': 'Shows / hides the thumbnail panel. Note: this flag will not affect the currently opened Content Browser, but only any subsequently opened ones.'},
                              'treeView': {'docstring': 'Shows / hides the tree view panel. Note: this flag will not affect the currently opened Content Browser, but only any subsequently opened ones.'},
                              'unParent': {'docstring': 'Specifies that the editor should be removed from its layout. This cannot be used in query mode.'},
                              'unlockMainConnection': {'docstring': 'Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic updates.'},
                              'updateMainConnection': {'docstring': 'Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.'},
                              'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'contextInfo': {'description': 'This command allows you to get information on named contexts. \t         ',
                 'flags': {'apiImage1': {'docstring': ''},
                           'c': {'docstring': 'Return the class type of the named context.'},
                           'edit': {'docstring': ''},
                           'escapeContext': {'docstring': 'Return the command string that will allow you to exit the current tool.'},
                           'exists': {'docstring': 'Return true if the context exists, false if it does not exists (or is internal and therefore untouchable)'},
                           'image1': {'docstring': 'Returns the name of an xpm associated with the named context.'},
                           'image2': {'docstring': 'Returns the name of an xpm associated with the named context.'},
                           'image3': {'docstring': 'Returns the name of an xpm associated with the named context.'},
                           'query': {'docstring': ''},
                           'title': {'docstring': 'Return the title string of the named context.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'control': {'description': 'This command allows you to edit or query the properties of any control. \t         In query mode, return type is based on queried flag.',
             'flags': {'annotation': {'docstring': 'Annotate the control with an extra string value.'},
                       'backgroundColor': {'docstring': 'The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.'},
                       'defineTemplate': {'docstring': 'Puts the command in a mode where any other flags and arguments are parsed and added to the command template specified in the argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set as the current template.'},
                       'docTag': {'docstring': 'Add a documentation flag to the control.  The documentation flag has a directory structure. (e.g., -dt render/multiLister/createNode/material)'},
                       'dragCallback': {'docstring': 'Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTRL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL, 3 == CTRL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "x", "y", "modifiers".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(x)d %(y)d %(modifiers)d\'")'},
                       'dropCallback': {'docstring': 'Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys "dragControl", "dropControl", "messages", "x", "y", "type".  The "dragControl" value is a string and the other values are integers (eg the callback string could be "print \'%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d\'")'},
                       'edit': {'docstring': ''},
                       'enable': {'docstring': 'The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.'},
                       'enableBackground': {'docstring': 'Enables the background color of the control.'},
                       'enableKeyboardFocus': {'docstring': 'If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse. This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls If disabled, text in text fields can still be selected with the mouse but it cannot be copied (except in Linux when "Middle Click Paste" is enabled).'},
                       'exists': {'docstring': 'Returns whether the specified object exists or not. Other flags are ignored.'},
                       'fullPathName': {'docstring': 'Return the full path name of the widget, which includes all the parents.'},
                       'height': {'docstring': 'The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.'},
                       'highlightColor': {'docstring': 'The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.'},
                       'isObscured': {'docstring': "Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified."},
                       'manage': {'docstring': 'Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.'},
                       'noBackground': {'docstring': "Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control."},
                       'numberOfPopupMenus': {'docstring': 'Return the number of popup menus attached to this control.'},
                       'parent': {'docstring': 'The parent layout for this control.'},
                       'popupMenuArray': {'docstring': 'Return the names of all the popup menus attached to this control.'},
                       'preventOverride': {'docstring': "If true, this flag prevents overriding the control's attribute via the control's right mouse button menu."},
                       'query': {'docstring': ''},
                       'statusBarMessage': {'docstring': 'Extra string to display in the status bar when the mouse is over the control.'},
                       'useTemplate': {'docstring': 'Forces the command to use a command template other than the current one.'},
                       'visible': {'docstring': "The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s)."},
                       'visibleChangeCommand': {'docstring': 'Command that gets executed when visible state of the control changes.'},
                       'width': {'docstring': 'The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'controller': {'description': 'Commands for managing animation sources \t         ',
                'flags': {'allControllers': {'docstring': 'When this flag is queried, returns all dependNode attached to a controller in the scene.'},
                          'children': {'docstring': 'Return true if the specified dependNode is a controller.'},
                          'edit': {'docstring': ''},
                          'group': {'docstring': 'Create a controller that is not associated with any object. This new controller will be the parent of all the selected objects.'},
                          'index': {'docstring': "In query mode, returns the index of the controller in the parent controller's list of children. In edit mode, reorder the parent controller's children connections so that the current controller is assigned the given index."},
                          'isController': {'docstring': 'Returns true if the specified dependNode is a controller.'},
                          'parent': {'docstring': 'Set or query the parent controller of the selected controller node.'},
                          'pickWalkDown': {'docstring': 'Return the first child.'},
                          'pickWalkLeft': {'docstring': 'Return the previous sibling.'},
                          'pickWalkRight': {'docstring': 'Return the next sibling.'},
                          'pickWalkUp': {'docstring': 'Return the parent.'},
                          'query': {'docstring': ''},
                          'unparent': {'docstring': 'Unparent all selected controller objects from their respective parent. \t\t\t           Flag can have multiple arguments, passed either as a tuple or a list.'}}},
 'convertIffToPsd': {'description': 'Converts iff file to PSD file of given size \t 