import pymel.util as _util
import pymel.core.datatypes as datatypes
import pymel.core.nodetypes as nodetypes
import pymel.core.nodetypes as nt
import pymel.core.other as other
from _typeshed import Incomplete
from builtins import object, str
from collections.abc import Generator
from pymel.util.enum import Enum as Enum
from pymel.util.py2to3 import RePattern as RePattern
from typing import Any, Callable, Dict, Iterable, Iterator, List, Optional, Pattern, Sequence, Tuple, Type, TypeVar, Union, overload
from typing_extensions import Literal, TypeGuard

TYPE_CHECKING: bool
T = TypeVar('T')
DependNodeT = TypeVar('DependNodeT', bound=nodetypes.DependNode)
DependNodeT1 = TypeVar('DependNodeT1', bound=nodetypes.DependNode)
DependNodeT2 = TypeVar('DependNodeT2', bound=nodetypes.DependNode)
DependNodeT3 = TypeVar('DependNodeT3', bound=nodetypes.DependNode)
DagNodeT = TypeVar('DagNodeT', bound=nodetypes.DagNode)
ShapeT = TypeVar('ShapeT', bound=nodetypes.Shape)
TransformT = TypeVar('TransformT', bound=nodetypes.Transform)
PatternTypes = Union[str, Pattern, List[Union[str, Pattern]]]
SelectableTypes = nodetypes.DependNode
EnumArgTypes = Union[Dict[str, int], Dict[int, str], _util.EnumDict, str]
TypeArgTypes = Union[str, Type[nodetypes.DependNode], Tuple[Union[str, Type[nodetypes.DependNode]], ...]]
LimitedTypeArgTypes = Union[str, Iterable[Union[str, Type[nodetypes.DependNode]]]]
CHECK_ATTR_BEFORE_LOCK: Incomplete


@overload
def objectType(arg: Any, isAType: Type[T]) -> TypeGuard[T]: ...
@overload
def objectType(arg: Any, isType: Type[T]) -> TypeGuard[T]: ...
@overload
def objectType(*args, convertTag: _util.ProxyUnicode | str = ..., ct: _util.ProxyUnicode | str = ..., isAType: _util.ProxyUnicode | str = ..., isa: _util.ProxyUnicode | str = ..., isType: _util.ProxyUnicode | str = ..., i: _util.ProxyUnicode | str = ..., tagFromType: _util.ProxyUnicode | str = ..., tgt: _util.ProxyUnicode | str = ..., typeFromTag: int = ..., tpt: int = ..., typeTag: bool | int = ..., tt: bool | int = ...) -> None: ...
def select(*args, add: bool | int = ..., addFirst: bool | int = ..., af: bool | int = ..., all: bool | int = ..., allDagObjects: bool | int = ..., ado: bool | int = ..., allDependencyNodes: bool | int = ..., adn: bool | int = ..., clear: bool | int = ..., cl: bool | int = ..., containerCentric: bool | int = ..., cc: bool | int = ..., deselect: bool | int = ..., d: bool | int = ..., hierarchy: bool | int = ..., hi: bool | int = ..., noExpand: bool | int = ..., ne: bool | int = ..., replace: bool | int = ..., r: bool | int = ..., symmetry: bool | int = ..., sym: bool | int = ..., symmetrySide: int = ..., sys: int = ..., toggle: bool | int = ..., tgl: bool | int = ..., visible: bool | int = ..., vis: bool | int = ...) -> None: ...
def move(*args, absolute: bool | int = ..., a: bool | int = ..., componentOffset: bool | int = ..., co: bool | int = ..., componentSpace: bool | int = ..., cs: bool | int = ..., constrainAlongNormal: bool | int = ..., xn: bool | int = ..., deletePriorHistory: bool | int = ..., dph: bool | int = ..., localSpace: bool | int = ..., ls: bool | int = ..., moveX: bool | int = ..., x: bool | int = ..., moveXY: bool | int = ..., xy: bool | int = ..., moveXYZ: bool | int = ..., xyz: bool | int = ..., moveXZ: bool | int = ..., xz: bool | int = ..., moveY: bool | int = ..., y: bool | int = ..., moveYZ: bool | int = ..., yz: bool | int = ..., moveZ: bool | int = ..., z: bool | int = ..., objectSpace: bool | int = ..., os: bool | int = ..., orientJoint: _util.ProxyUnicode | str = ..., oj: _util.ProxyUnicode | str = ..., parameter: bool | int = ..., p: bool | int = ..., preserveChildPosition: bool | int = ..., pcp: bool | int = ..., preserveGeometryPosition: bool | int = ..., pgp: bool | int = ..., preserveUV: bool | int = ..., puv: bool | int = ..., reflection: bool | int = ..., rfl: bool | int = ..., reflectionAboutBBox: bool | int = ..., rab: bool | int = ..., reflectionAboutOrigin: bool | int = ..., rao: bool | int = ..., reflectionAboutX: bool | int = ..., rax: bool | int = ..., reflectionAboutY: bool | int = ..., ray: bool | int = ..., reflectionAboutZ: bool | int = ..., raz: bool | int = ..., reflectionTolerance: float = ..., rft: float = ..., relative: bool | int = ..., r: bool | int = ..., rotatePivotRelative: bool | int = ..., rpr: bool | int = ..., scalePivotRelative: bool | int = ..., spr: bool | int = ..., secondaryAxisOrient: _util.ProxyUnicode | str = ..., sao: _util.ProxyUnicode | str = ..., symNegative: bool | int = ..., smn: bool | int = ..., ufeRotatePivot: bool | int = ..., urp: bool | int = ..., ufeScalePivot: bool | int = ..., usp: bool | int = ..., worldSpace: bool | int = ..., ws: bool | int = ..., worldSpaceDistance: bool | int = ..., wd: bool | int = ..., xformConstraint: _util.ProxyUnicode | str = ..., xc: _util.ProxyUnicode | str = ...): ...
def scale(obj, *args, absolute: bool | int = ..., a: bool | int = ..., centerPivot: bool | int = ..., cp: bool | int = ..., componentSpace: bool | int = ..., cs: bool | int = ..., constrainAlongNormal: bool | int = ..., xn: bool | int = ..., deletePriorHistory: bool | int = ..., dph: bool | int = ..., distanceOnly: bool | int = ..., dso: bool | int = ..., localSpace: bool | int = ..., ls: bool | int = ..., objectCenterPivot: bool | int = ..., ocp: bool | int = ..., objectSpace: bool | int = ..., os: bool | int = ..., orientAxes: Tuple[float, float, float] = ..., oa: Tuple[float, float, float] = ..., pivot: Tuple[float, float, float] = ..., p: Tuple[float, float, float] = ..., preserveChildPosition: bool | int = ..., pcp: bool | int = ..., preserveGeometryPosition: bool | int = ..., pgp: bool | int = ..., preserveUV: bool | int = ..., puv: bool | int = ..., reflection: bool | int = ..., rfl: bool | int = ..., reflectionAboutBBox: bool | int = ..., rab: bool | int = ..., reflectionAboutOrigin: bool | int = ..., rao: bool | int = ..., reflectionAboutX: bool | int = ..., rax: bool | int = ..., reflectionAboutY: bool | int = ..., ray: bool | int = ..., reflectionAboutZ: bool | int = ..., raz: bool | int = ..., reflectionTolerance: float = ..., rft: float = ..., relative: bool | int = ..., r: bool | int = ..., scaleX: bool | int = ..., x: bool | int = ..., scaleXY: bool | int = ..., xy: bool | int = ..., scaleXYZ: bool | int = ..., xyz: bool | int = ..., scaleXZ: bool | int = ..., xz: bool | int = ..., scaleY: bool | int = ..., y: bool | int = ..., scaleYZ: bool | int = ..., yz: bool | int = ..., scaleZ: bool | int = ..., z: bool | int = ..., symNegative: bool | int = ..., smn: bool | int = ..., worldSpace: bool | int = ..., ws: bool | int = ..., xformConstraint: _util.ProxyUnicode | str = ..., xc: _util.ProxyUnicode | str = ...): ...
def rotate(obj, *args, absolute: bool | int = ..., a: bool | int = ..., centerPivot: bool | int = ..., cp: bool | int = ..., componentSpace: bool | int = ..., cs: bool | int = ..., constrainAlongNormal: bool | int = ..., xn: bool | int = ..., deletePriorHistory: bool | int = ..., dph: bool | int = ..., euler: bool | int = ..., eu: bool | int = ..., forceOrderXYZ: bool | int = ..., fo: bool | int = ..., objectCenterPivot: bool | int = ..., ocp: bool | int = ..., objectSpace: bool | int = ..., os: bool | int = ..., orientAxes: Tuple[float, float, float] = ..., oa: Tuple[float, float, float] = ..., pivot: Tuple[float, float, float] = ..., p: Tuple[float, float, float] = ..., preserveChildPosition: bool | int = ..., pcp: bool | int = ..., preserveGeometryPosition: bool | int = ..., pgp: bool | int = ..., preserveUV: bool | int = ..., puv: bool | int = ..., reflection: bool | int = ..., rfl: bool | int = ..., reflectionAboutBBox: bool | int = ..., rab: bool | int = ..., reflectionAboutOrigin: bool | int = ..., rao: bool | int = ..., reflectionAboutX: bool | int = ..., rax: bool | int = ..., reflectionAboutY: bool | int = ..., ray: bool | int = ..., reflectionAboutZ: bool | int = ..., raz: bool | int = ..., reflectionTolerance: float = ..., rft: float = ..., relative: bool | int = ..., r: bool | int = ..., rotateX: bool | int = ..., x: bool | int = ..., rotateXY: bool | int = ..., xy: bool | int = ..., rotateXYZ: bool | int = ..., xyz: bool | int = ..., rotateXZ: bool | int = ..., xz: bool | int = ..., rotateY: bool | int = ..., y: bool | int = ..., rotateYZ: bool | int = ..., yz: bool | int = ..., rotateZ: bool | int = ..., z: bool | int = ..., symNegative: bool | int = ..., smn: bool | int = ..., translate: bool | int = ..., t: bool | int = ..., worldSpace: bool | int = ..., ws: bool | int = ..., xformConstraint: _util.ProxyUnicode | str = ..., xc: _util.ProxyUnicode | str = ...): ...
def connectAttr(source, destination, force: bool | int = ..., f: bool | int = ..., lock: bool | int = ..., l: bool | int = ..., nextAvailable: bool | int = ..., na: bool | int = ..., referenceDest: _util.ProxyUnicode | str = ..., rd: _util.ProxyUnicode | str = ...) -> None: ...
def disconnectAttr(source: Union[str, Attribute], destination: Union[str, Attribute, None] = ..., inputs: Optional[bool] = ..., outputs: Optional[bool] = ..., nextAvailable: bool | int = ..., na: bool | int = ...) -> None: ...
def getAttr(attr, default: Incomplete | None = ..., asString: bool | int = ..., caching: bool | int = ..., ca: bool | int = ..., channelBox: bool | int = ..., cb: bool | int = ..., expandEnvironmentVariables: bool | int = ..., x: bool | int = ..., keyable: bool | int = ..., k: bool | int = ..., lock: bool | int = ..., l: bool | int = ..., multiIndices: bool | int = ..., mi: bool | int = ..., settable: bool | int = ..., se: bool | int = ..., silent: bool | int = ..., sl: bool | int = ..., size: bool | int = ..., s: bool | int = ..., time: int | float = ..., t: int | float = ..., type: bool | int = ..., typ: bool | int = ...): ...

class AmbiguityWarning(Warning): ...

def setAttr(attr, *args, alteredValue: bool | int = ..., av: bool | int = ..., caching: bool | int = ..., ca: bool | int = ..., capacityHint: int = ..., ch: int = ..., channelBox: bool | int = ..., cb: bool | int = ..., clamp: bool | int = ..., c: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., keyable: bool | int = ..., k: bool | int = ..., lock: bool | int = ..., l: bool | int = ..., query: bool | int = ..., q: bool | int = ..., size: int = ..., s: int = ..., type: _util.ProxyUnicode | str = ..., typ: _util.ProxyUnicode | str = ...) -> None: ...
@overload
def addAttr(*args: Any, type: Union[str, Type] = ..., childSuffixes: Sequence[str] = ..., enumName: EnumArgTypes = ..., attributeType: bool | int | _util.ProxyUnicode | str = ..., at: bool | int | _util.ProxyUnicode | str = ..., binaryTag: bool | int | _util.ProxyUnicode | str = ..., bt: bool | int | _util.ProxyUnicode | str = ..., cachedInternally: bool | int = ..., ci: bool | int = ..., category: bool | int | str | List[str] = ..., ct: bool | int | str | List[str] = ..., dataType: bool | int | str | List[str] = ..., dt: bool | int | str | List[str] = ..., defaultValue: bool | int | float = ..., dv: bool | int | float = ..., disconnectBehaviour: bool | int | int = ..., dcb: bool | int | int = ..., edit: bool | int = ..., e: bool | int = ..., exists: bool | int = ..., ex: bool | int = ..., fromPlugin: bool | int = ..., fp: bool | int = ..., hasMaxValue: bool | int = ..., hxv: bool | int = ..., hasMinValue: bool | int = ..., hnv: bool | int = ..., hasSoftMaxValue: bool | int = ..., hsx: bool | int = ..., hasSoftMinValue: bool | int = ..., hsn: bool | int = ..., hidden: bool | int = ..., h: bool | int = ..., indexMatters: bool | int = ..., im: bool | int = ..., internalSet: bool | int = ..., keyable: bool | int = ..., k: bool | int = ..., longName: bool | int | _util.ProxyUnicode | str = ..., ln: bool | int | _util.ProxyUnicode | str = ..., maxValue: bool | int | float = ..., max: bool | int | float = ..., minValue: bool | int | float = ..., min: bool | int | float = ..., multi: bool | int = ..., m: bool | int = ..., niceName: bool | int | _util.ProxyUnicode | str = ..., nn: bool | int | _util.ProxyUnicode | str = ..., numberOfChildren: bool | int | int = ..., nc: bool | int | int = ..., parent: bool | int | _util.ProxyUnicode | str = ..., p: bool | int | _util.ProxyUnicode | str = ..., proxy: bool | int | _util.ProxyUnicode | str = ..., pxy: bool | int | _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., readable: bool | int = ..., r: bool | int = ..., shortName: bool | int | _util.ProxyUnicode | str = ..., sn: bool | int | _util.ProxyUnicode | str = ..., softMaxValue: bool | int | float = ..., smx: bool | int | float = ..., softMinValue: bool | int | float = ..., smn: bool | int | float = ..., storable: bool | int = ..., s: bool | int = ..., usedAsColor: bool | int = ..., uac: bool | int = ..., usedAsFilename: bool | int = ..., uaf: bool | int = ..., usedAsProxy: bool | int = ..., uap: bool | int = ..., worldSpace: bool | int = ..., ws: bool | int = ..., writable: bool | int = ..., w: bool | int = ...) -> Any: ...
def hasAttr(pyObj: PyNode, attr: Union[str, Attribute, AttributeSpec], checkShape: bool = ...) -> bool: ...
def setEnums(attr, enums) -> None: ...
def getEnums(attr: Union[str, Attribute]) -> _util.enum.EnumDict: ...
@overload
def listConnections(*args: Any, connections: Literal[True], plugs: Literal[True], sourceFirst: bool = ..., type: TypeArgTypes = ..., destination: bool | int = ..., d: bool | int = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ..., source: bool | int = ..., s: bool | int = ...) -> List[Tuple[Attribute, Attribute]]: ...
@overload
def listConnections(*args: Any, connections: Literal[True], shapes: Literal[True], type: Type[DependNodeT], plugs: Literal[False] = ..., destination: bool | int = ..., d: bool | int = ..., exactType: bool | int = ..., et: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ..., source: bool | int = ..., s: bool | int = ...) -> List[Tuple[Attribute, DependNodeT]]: ...
@overload
def listConnections(*args: Any, connections: Literal[True], shapes: Literal[True], type: LimitedTypeArgTypes, plugs: Literal[False] = ..., destination: bool | int = ..., d: bool | int = ..., exactType: bool | int = ..., et: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ..., source: bool | int = ..., s: bool | int = ...) -> List[Tuple[Attribute, nodetypes.DependNode]]: ...
@overload
def listConnections(*args: Any, connections: Literal[True], shapes: Literal[False] = ..., plugs: Literal[False] = ..., type: Type[nodetypes.Shape] = ..., destination: bool | int = ..., d: bool | int = ..., exactType: bool | int = ..., et: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ..., source: bool | int = ..., s: bool | int = ...) -> List[Tuple[Attribute, nodetypes.Transform]]: ...
@overload
def listConnections(*args: Any, connections: Literal[True], shapes: Literal[False] = ..., plugs: Literal[False] = ..., type: Type[TransformT] = ..., destination: bool | int = ..., d: bool | int = ..., exactType: bool | int = ..., et: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ..., source: bool | int = ..., s: bool | int = ...) -> List[Tuple[Attribute, TransformT]]: ...
@overload
def listConnections(*args: Any, connections: Literal[True], shapes: Literal[False] = ..., plugs: Literal[False] = ..., type: LimitedTypeArgTypes = ..., destination: bool | int = ..., d: bool | int = ..., exactType: bool | int = ..., et: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ..., source: bool | int = ..., s: bool | int = ...) -> List[Tuple[Attribute, nodetypes.DependNode]]: ...
@overload
def listConnections(*args: Any, plugs: Literal[True], connections: Literal[False] = ..., type: TypeArgTypes = ..., destination: bool | int = ..., d: bool | int = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ..., source: bool | int = ..., s: bool | int = ...) -> List[Attribute]: ...
@overload
def listConnections(*args: Any, type: Type[DependNodeT], shapes: Literal[True], plugs: Literal[False] = ..., connections: Literal[False] = ..., destination: bool | int = ..., d: bool | int = ..., exactType: bool | int = ..., et: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ..., source: bool | int = ..., s: bool | int = ...) -> List[DependNodeT]: ...
@overload
def listConnections(*args: Any, type: Type[nodetypes.Shape], shapes: Literal[False] = ..., plugs: Literal[False] = ..., connections: Literal[False] = ..., destination: bool | int = ..., d: bool | int = ..., exactType: bool | int = ..., et: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ..., source: bool | int = ..., s: bool | int = ...) -> List[nodetypes.Transform]: ...
@overload
def listConnections(*args: Any, type: Type[TransformT], shapes: Literal[False] = ..., plugs: Literal[False] = ..., connections: Literal[False] = ..., destination: bool | int = ..., d: bool | int = ..., exactType: bool | int = ..., et: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ..., source: bool | int = ..., s: bool | int = ...) -> List[TransformT]: ...
@overload
def listConnections(*args: Any, type: Type[nodetypes.DependNode], shapes: Literal[False] = ..., plugs: Literal[False] = ..., connections: Literal[False] = ..., destination: bool | int = ..., d: bool | int = ..., exactType: bool | int = ..., et: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ..., source: bool | int = ..., s: bool | int = ...) -> List[nodetypes.DependNode]: ...
@overload
def listConnections(*args: Any, type: LimitedTypeArgTypes = ..., connections: bool | int = ..., c: bool | int = ..., destination: bool | int = ..., d: bool | int = ..., exactType: bool | int = ..., et: bool | int = ..., plugs: bool | int = ..., p: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ..., source: bool | int = ..., s: bool | int = ...) -> List[nodetypes.DependNode]: ...
@overload
def listHistory(*args: Any, type: Type[DependNodeT], exactType: Optional[str] = ..., allConnections: bool | int = ..., ac: bool | int = ..., allFuture: bool | int = ..., af: bool | int = ..., allGraphs: bool | int = ..., ag: bool | int = ..., breadthFirst: bool | int = ..., bf: bool | int = ..., fastIteration: bool | int = ..., fi: bool | int = ..., future: bool | int = ..., f: bool | int = ..., futureLocalAttr: bool | int = ..., fl: bool | int = ..., futureWorldAttr: bool | int = ..., fw: bool | int = ..., groupLevels: bool | int = ..., gl: bool | int = ..., historyAttr: bool | int = ..., ha: bool | int = ..., interestLevel: int = ..., il: int = ..., leaf: bool | int = ..., lf: bool | int = ..., levels: int = ..., lv: int = ..., pruneDagObjects: bool | int = ..., pdo: bool | int = ..., query: bool | int = ..., q: bool | int = ...) -> List[DependNodeT]: ...
@overload
def listHistory(*args: Any, type: Optional[str] = ..., exactType: Optional[str] = ..., allConnections: bool | int = ..., ac: bool | int = ..., allFuture: bool | int = ..., af: bool | int = ..., allGraphs: bool | int = ..., ag: bool | int = ..., breadthFirst: bool | int = ..., bf: bool | int = ..., fastIteration: bool | int = ..., fi: bool | int = ..., future: bool | int = ..., f: bool | int = ..., futureLocalAttr: bool | int = ..., fl: bool | int = ..., futureWorldAttr: bool | int = ..., fw: bool | int = ..., groupLevels: bool | int = ..., gl: bool | int = ..., historyAttr: bool | int = ..., ha: bool | int = ..., interestLevel: int = ..., il: int = ..., leaf: bool | int = ..., lf: bool | int = ..., levels: int = ..., lv: int = ..., pruneDagObjects: bool | int = ..., pdo: bool | int = ..., query: bool | int = ..., q: bool | int = ...) -> List[nodetypes.DependNode]: ...
@overload
def listFuture(*args: Any, type: Type[DependNodeT], exactType: Optional[str] = ..., allConnections: bool | int = ..., ac: bool | int = ..., allFuture: bool | int = ..., af: bool | int = ..., allGraphs: bool | int = ..., ag: bool | int = ..., breadthFirst: bool | int = ..., bf: bool | int = ..., fastIteration: bool | int = ..., fi: bool | int = ..., futureLocalAttr: bool | int = ..., fl: bool | int = ..., futureWorldAttr: bool | int = ..., fw: bool | int = ..., groupLevels: bool | int = ..., gl: bool | int = ..., historyAttr: bool | int = ..., ha: bool | int = ..., interestLevel: int = ..., il: int = ..., leaf: bool | int = ..., lf: bool | int = ..., levels: int = ..., lv: int = ..., pruneDagObjects: bool | int = ..., pdo: bool | int = ..., query: bool | int = ..., q: bool | int = ...) -> List[DependNodeT]: ...
@overload
def listFuture(*args: Any, type: Optional[str] = ..., exactType: Optional[str] = ..., allConnections: bool | int = ..., ac: bool | int = ..., allFuture: bool | int = ..., af: bool | int = ..., allGraphs: bool | int = ..., ag: bool | int = ..., breadthFirst: bool | int = ..., bf: bool | int = ..., fastIteration: bool | int = ..., fi: bool | int = ..., futureLocalAttr: bool | int = ..., fl: bool | int = ..., futureWorldAttr: bool | int = ..., fw: bool | int = ..., groupLevels: bool | int = ..., gl: bool | int = ..., historyAttr: bool | int = ..., ha: bool | int = ..., interestLevel: int = ..., il: int = ..., leaf: bool | int = ..., lf: bool | int = ..., levels: int = ..., lv: int = ..., pruneDagObjects: bool | int = ..., pdo: bool | int = ..., query: bool | int = ..., q: bool | int = ...) -> List[nodetypes.DependNode]: ...
@overload
def listRelatives(*args: Any, type: Type[DagNodeT], allDescendents: bool | int = ..., ad: bool | int = ..., allParents: bool | int = ..., ap: bool | int = ..., children: bool | int = ..., c: bool | int = ..., fullPath: bool | int = ..., f: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., parent: bool | int = ..., p: bool | int = ..., path: bool | int = ..., pa: bool | int = ..., shapes: bool | int = ..., s: bool | int = ...) -> List[DagNodeT]: ...
@overload
def listRelatives(*args: Any, shapes: Literal[True], allDescendents: bool | int = ..., ad: bool | int = ..., allParents: bool | int = ..., ap: bool | int = ..., children: bool | int = ..., c: bool | int = ..., fullPath: bool | int = ..., f: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., parent: bool | int = ..., p: bool | int = ..., path: bool | int = ..., pa: bool | int = ..., type: str | List[str] = ..., typ: str | List[str] = ...) -> List[nodetypes.Shape]: ...
@overload
def listRelatives(*args: Any, type: Union[str, Iterable[Union[str, Type[nodetypes.DagNode]]]] = ..., allDescendents: bool | int = ..., ad: bool | int = ..., allParents: bool | int = ..., ap: bool | int = ..., children: bool | int = ..., c: bool | int = ..., fullPath: bool | int = ..., f: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., parent: bool | int = ..., p: bool | int = ..., path: bool | int = ..., pa: bool | int = ..., shapes: bool | int = ..., s: bool | int = ...) -> List[nodetypes.DagNode]: ...
@overload
def ls(*args: Any, type: Type[DependNodeT], editable: bool = ..., regex: PatternTypes = ..., absoluteName: bool | int = ..., an: bool | int = ..., allPaths: bool | int = ..., ap: bool | int = ..., assemblies: bool | int = ..., cameras: bool | int = ..., ca: bool | int = ..., containerType: str | List[str] = ..., ct: str | List[str] = ..., containers: bool | int = ..., con: bool | int = ..., dagObjects: bool | int = ..., dag: bool | int = ..., defaultNodes: bool | int = ..., dn: bool | int = ..., dependencyNodes: bool | int = ..., dep: bool | int = ..., exactType: str | List[str] = ..., et: str | List[str] = ..., excludeType: str | List[str] = ..., ext: str | List[str] = ..., flatten: bool | int = ..., fl: bool | int = ..., geometry: bool | int = ..., g: bool | int = ..., ghost: bool | int = ..., gh: bool | int = ..., head: int = ..., hd: int = ..., hilite: bool | int = ..., hl: bool | int = ..., intermediateObjects: bool | int = ..., io: bool | int = ..., invisible: bool | int = ..., iv: bool | int = ..., leaf: bool | int = ..., lf: bool | int = ..., lights: bool | int = ..., lt: bool | int = ..., live: bool | int = ..., lv: bool | int = ..., lockedNodes: bool | int = ..., ln: bool | int = ..., long: bool | int = ..., l: bool | int = ..., materials: bool | int = ..., mat: bool | int = ..., modified: bool | int = ..., mod: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., nodeTypes: bool | int = ..., nt: bool | int = ..., objectsOnly: bool | int = ..., o: bool | int = ..., orderedSelection: bool | int = ..., os: bool | int = ..., partitions: bool | int = ..., pr: bool | int = ..., persistentNodes: bool | int = ..., pn: bool | int = ..., planes: bool | int = ..., pl: bool | int = ..., preSelectHilite: bool | int = ..., psh: bool | int = ..., readOnly: bool | int = ..., ro: bool | int = ..., recursive: bool | int = ..., r: bool | int = ..., referencedNodes: bool | int = ..., rn: bool | int = ..., references: bool | int = ..., rf: bool | int = ..., renderGlobals: bool | int = ..., rg: bool | int = ..., renderQualities: bool | int = ..., rq: bool | int = ..., renderResolutions: bool | int = ..., rr: bool | int = ..., renderSetups: bool | int = ..., rs: bool | int = ..., selection: bool | int = ..., sl: bool | int = ..., sets: bool | int = ..., set: bool | int = ..., shapes: bool | int = ..., s: bool | int = ..., shortNames: bool | int = ..., sn: bool | int = ..., showNamespace: bool | int = ..., sns: bool | int = ..., showType: bool | int = ..., st: bool | int = ..., tail: int = ..., tl: int = ..., templated: bool | int = ..., tm: bool | int = ..., textures: bool | int = ..., tex: bool | int = ..., transforms: bool | int = ..., tr: bool | int = ..., ufeObjects: bool | int = ..., ufe: bool | int = ..., undeletable: bool | int = ..., ud: bool | int = ..., untemplated: bool | int = ..., ut: bool | int = ..., uuid: bool | int = ..., uid: bool | int = ..., visible: bool | int = ..., v: bool | int = ...) -> List[DependNodeT]: ...
@overload
def ls(*args: Any, type: Tuple[Type[DependNodeT1], Type[DependNodeT2]], editable: bool = ..., regex: PatternTypes = ..., absoluteName: bool | int = ..., an: bool | int = ..., allPaths: bool | int = ..., ap: bool | int = ..., assemblies: bool | int = ..., cameras: bool | int = ..., ca: bool | int = ..., containerType: str | List[str] = ..., ct: str | List[str] = ..., containers: bool | int = ..., con: bool | int = ..., dagObjects: bool | int = ..., dag: bool | int = ..., defaultNodes: bool | int = ..., dn: bool | int = ..., dependencyNodes: bool | int = ..., dep: bool | int = ..., exactType: str | List[str] = ..., et: str | List[str] = ..., excludeType: str | List[str] = ..., ext: str | List[str] = ..., flatten: bool | int = ..., fl: bool | int = ..., geometry: bool | int = ..., g: bool | int = ..., ghost: bool | int = ..., gh: bool | int = ..., head: int = ..., hd: int = ..., hilite: bool | int = ..., hl: bool | int = ..., intermediateObjects: bool | int = ..., io: bool | int = ..., invisible: bool | int = ..., iv: bool | int = ..., leaf: bool | int = ..., lf: bool | int = ..., lights: bool | int = ..., lt: bool | int = ..., live: bool | int = ..., lv: bool | int = ..., lockedNodes: bool | int = ..., ln: bool | int = ..., long: bool | int = ..., l: bool | int = ..., materials: bool | int = ..., mat: bool | int = ..., modified: bool | int = ..., mod: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., nodeTypes: bool | int = ..., nt: bool | int = ..., objectsOnly: bool | int = ..., o: bool | int = ..., orderedSelection: bool | int = ..., os: bool | int = ..., partitions: bool | int = ..., pr: bool | int = ..., persistentNodes: bool | int = ..., pn: bool | int = ..., planes: bool | int = ..., pl: bool | int = ..., preSelectHilite: bool | int = ..., psh: bool | int = ..., readOnly: bool | int = ..., ro: bool | int = ..., recursive: bool | int = ..., r: bool | int = ..., referencedNodes: bool | int = ..., rn: bool | int = ..., references: bool | int = ..., rf: bool | int = ..., renderGlobals: bool | int = ..., rg: bool | int = ..., renderQualities: bool | int = ..., rq: bool | int = ..., renderResolutions: bool | int = ..., rr: bool | int = ..., renderSetups: bool | int = ..., rs: bool | int = ..., selection: bool | int = ..., sl: bool | int = ..., sets: bool | int = ..., set: bool | int = ..., shapes: bool | int = ..., s: bool | int = ..., shortNames: bool | int = ..., sn: bool | int = ..., showNamespace: bool | int = ..., sns: bool | int = ..., showType: bool | int = ..., st: bool | int = ..., tail: int = ..., tl: int = ..., templated: bool | int = ..., tm: bool | int = ..., textures: bool | int = ..., tex: bool | int = ..., transforms: bool | int = ..., tr: bool | int = ..., ufeObjects: bool | int = ..., ufe: bool | int = ..., undeletable: bool | int = ..., ud: bool | int = ..., untemplated: bool | int = ..., ut: bool | int = ..., uuid: bool | int = ..., uid: bool | int = ..., visible: bool | int = ..., v: bool | int = ...) -> List[Union[DependNodeT1, DependNodeT2]]: ...
@overload
def ls(*args: Any, exactType: Type[DependNodeT], editable: bool = ..., regex: PatternTypes = ..., absoluteName: bool | int = ..., an: bool | int = ..., allPaths: bool | int = ..., ap: bool | int = ..., assemblies: bool | int = ..., cameras: bool | int = ..., ca: bool | int = ..., containerType: str | List[str] = ..., ct: str | List[str] = ..., containers: bool | int = ..., con: bool | int = ..., dagObjects: bool | int = ..., dag: bool | int = ..., defaultNodes: bool | int = ..., dn: bool | int = ..., dependencyNodes: bool | int = ..., dep: bool | int = ..., excludeType: str | List[str] = ..., ext: str | List[str] = ..., flatten: bool | int = ..., fl: bool | int = ..., geometry: bool | int = ..., g: bool | int = ..., ghost: bool | int = ..., gh: bool | int = ..., head: int = ..., hd: int = ..., hilite: bool | int = ..., hl: bool | int = ..., intermediateObjects: bool | int = ..., io: bool | int = ..., invisible: bool | int = ..., iv: bool | int = ..., leaf: bool | int = ..., lf: bool | int = ..., lights: bool | int = ..., lt: bool | int = ..., live: bool | int = ..., lv: bool | int = ..., lockedNodes: bool | int = ..., ln: bool | int = ..., long: bool | int = ..., l: bool | int = ..., materials: bool | int = ..., mat: bool | int = ..., modified: bool | int = ..., mod: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., nodeTypes: bool | int = ..., nt: bool | int = ..., objectsOnly: bool | int = ..., o: bool | int = ..., orderedSelection: bool | int = ..., os: bool | int = ..., partitions: bool | int = ..., pr: bool | int = ..., persistentNodes: bool | int = ..., pn: bool | int = ..., planes: bool | int = ..., pl: bool | int = ..., preSelectHilite: bool | int = ..., psh: bool | int = ..., readOnly: bool | int = ..., ro: bool | int = ..., recursive: bool | int = ..., r: bool | int = ..., referencedNodes: bool | int = ..., rn: bool | int = ..., references: bool | int = ..., rf: bool | int = ..., renderGlobals: bool | int = ..., rg: bool | int = ..., renderQualities: bool | int = ..., rq: bool | int = ..., renderResolutions: bool | int = ..., rr: bool | int = ..., renderSetups: bool | int = ..., rs: bool | int = ..., selection: bool | int = ..., sl: bool | int = ..., sets: bool | int = ..., set: bool | int = ..., shapes: bool | int = ..., s: bool | int = ..., shortNames: bool | int = ..., sn: bool | int = ..., showNamespace: bool | int = ..., sns: bool | int = ..., showType: bool | int = ..., st: bool | int = ..., tail: int = ..., tl: int = ..., templated: bool | int = ..., tm: bool | int = ..., textures: bool | int = ..., tex: bool | int = ..., transforms: bool | int = ..., tr: bool | int = ..., type: str | List[str] = ..., typ: str | List[str] = ..., ufeObjects: bool | int = ..., ufe: bool | int = ..., undeletable: bool | int = ..., ud: bool | int = ..., untemplated: bool | int = ..., ut: bool | int = ..., uuid: bool | int = ..., uid: bool | int = ..., visible: bool | int = ..., v: bool | int = ...) -> List[DependNodeT]: ...
@overload
def ls(*args: Any, textures: Literal[True], editable: bool = ..., regex: PatternTypes = ..., absoluteName: bool | int = ..., an: bool | int = ..., allPaths: bool | int = ..., ap: bool | int = ..., assemblies: bool | int = ..., cameras: bool | int = ..., ca: bool | int = ..., containerType: str | List[str] = ..., ct: str | List[str] = ..., containers: bool | int = ..., con: bool | int = ..., dagObjects: bool | int = ..., dag: bool | int = ..., defaultNodes: bool | int = ..., dn: bool | int = ..., dependencyNodes: bool | int = ..., dep: bool | int = ..., exactType: str | List[str] = ..., et: str | List[str] = ..., excludeType: str | List[str] = ..., ext: str | List[str] = ..., flatten: bool | int = ..., fl: bool | int = ..., geometry: bool | int = ..., g: bool | int = ..., ghost: bool | int = ..., gh: bool | int = ..., head: int = ..., hd: int = ..., hilite: bool | int = ..., hl: bool | int = ..., intermediateObjects: bool | int = ..., io: bool | int = ..., invisible: bool | int = ..., iv: bool | int = ..., leaf: bool | int = ..., lf: bool | int = ..., lights: bool | int = ..., lt: bool | int = ..., live: bool | int = ..., lv: bool | int = ..., lockedNodes: bool | int = ..., ln: bool | int = ..., long: bool | int = ..., l: bool | int = ..., materials: bool | int = ..., mat: bool | int = ..., modified: bool | int = ..., mod: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., nodeTypes: bool | int = ..., nt: bool | int = ..., objectsOnly: bool | int = ..., o: bool | int = ..., orderedSelection: bool | int = ..., os: bool | int = ..., partitions: bool | int = ..., pr: bool | int = ..., persistentNodes: bool | int = ..., pn: bool | int = ..., planes: bool | int = ..., pl: bool | int = ..., preSelectHilite: bool | int = ..., psh: bool | int = ..., readOnly: bool | int = ..., ro: bool | int = ..., recursive: bool | int = ..., r: bool | int = ..., referencedNodes: bool | int = ..., rn: bool | int = ..., references: bool | int = ..., rf: bool | int = ..., renderGlobals: bool | int = ..., rg: bool | int = ..., renderQualities: bool | int = ..., rq: bool | int = ..., renderResolutions: bool | int = ..., rr: bool | int = ..., renderSetups: bool | int = ..., rs: bool | int = ..., selection: bool | int = ..., sl: bool | int = ..., sets: bool | int = ..., set: bool | int = ..., shapes: bool | int = ..., s: bool | int = ..., shortNames: bool | int = ..., sn: bool | int = ..., showNamespace: bool | int = ..., sns: bool | int = ..., showType: bool | int = ..., st: bool | int = ..., tail: int = ..., tl: int = ..., templated: bool | int = ..., tm: bool | int = ..., transforms: bool | int = ..., tr: bool | int = ..., type: str | List[str] = ..., typ: str | List[str] = ..., ufeObjects: bool | int = ..., ufe: bool | int = ..., undeletable: bool | int = ..., ud: bool | int = ..., untemplated: bool | int = ..., ut: bool | int = ..., uuid: bool | int = ..., uid: bool | int = ..., visible: bool | int = ..., v: bool | int = ...) -> List[nodetypes.DependNode]: ...
@overload
def ls(*args: Any, references: Literal[True], editable: bool = ..., regex: PatternTypes = ..., absoluteName: bool | int = ..., an: bool | int = ..., allPaths: bool | int = ..., ap: bool | int = ..., assemblies: bool | int = ..., cameras: bool | int = ..., ca: bool | int = ..., containerType: str | List[str] = ..., ct: str | List[str] = ..., containers: bool | int = ..., con: bool | int = ..., dagObjects: bool | int = ..., dag: bool | int = ..., defaultNodes: bool | int = ..., dn: bool | int = ..., dependencyNodes: bool | int = ..., dep: bool | int = ..., exactType: str | List[str] = ..., et: str | List[str] = ..., excludeType: str | List[str] = ..., ext: str | List[str] = ..., flatten: bool | int = ..., fl: bool | int = ..., geometry: bool | int = ..., g: bool | int = ..., ghost: bool | int = ..., gh: bool | int = ..., head: int = ..., hd: int = ..., hilite: bool | int = ..., hl: bool | int = ..., intermediateObjects: bool | int = ..., io: bool | int = ..., invisible: bool | int = ..., iv: bool | int = ..., leaf: bool | int = ..., lf: bool | int = ..., lights: bool | int = ..., lt: bool | int = ..., live: bool | int = ..., lv: bool | int = ..., lockedNodes: bool | int = ..., ln: bool | int = ..., long: bool | int = ..., l: bool | int = ..., materials: bool | int = ..., mat: bool | int = ..., modified: bool | int = ..., mod: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., nodeTypes: bool | int = ..., nt: bool | int = ..., objectsOnly: bool | int = ..., o: bool | int = ..., orderedSelection: bool | int = ..., os: bool | int = ..., partitions: bool | int = ..., pr: bool | int = ..., persistentNodes: bool | int = ..., pn: bool | int = ..., planes: bool | int = ..., pl: bool | int = ..., preSelectHilite: bool | int = ..., psh: bool | int = ..., readOnly: bool | int = ..., ro: bool | int = ..., recursive: bool | int = ..., r: bool | int = ..., referencedNodes: bool | int = ..., rn: bool | int = ..., renderGlobals: bool | int = ..., rg: bool | int = ..., renderQualities: bool | int = ..., rq: bool | int = ..., renderResolutions: bool | int = ..., rr: bool | int = ..., renderSetups: bool | int = ..., rs: bool | int = ..., selection: bool | int = ..., sl: bool | int = ..., sets: bool | int = ..., set: bool | int = ..., shapes: bool | int = ..., s: bool | int = ..., shortNames: bool | int = ..., sn: bool | int = ..., showNamespace: bool | int = ..., sns: bool | int = ..., showType: bool | int = ..., st: bool | int = ..., tail: int = ..., tl: int = ..., templated: bool | int = ..., tm: bool | int = ..., textures: bool | int = ..., tex: bool | int = ..., transforms: bool | int = ..., tr: bool | int = ..., type: str | List[str] = ..., typ: str | List[str] = ..., ufeObjects: bool | int = ..., ufe: bool | int = ..., undeletable: bool | int = ..., ud: bool | int = ..., untemplated: bool | int = ..., ut: bool | int = ..., uuid: bool | int = ..., uid: bool | int = ..., visible: bool | int = ..., v: bool | int = ...) -> List[nodetypes.Reference]: ...
@overload
def ls(*args: Any, cameras: Literal[True], editable: bool = ..., regex: PatternTypes = ..., absoluteName: bool | int = ..., an: bool | int = ..., allPaths: bool | int = ..., ap: bool | int = ..., assemblies: bool | int = ..., containerType: str | List[str] = ..., ct: str | List[str] = ..., containers: bool | int = ..., con: bool | int = ..., dagObjects: bool | int = ..., dag: bool | int = ..., defaultNodes: bool | int = ..., dn: bool | int = ..., dependencyNodes: bool | int = ..., dep: bool | int = ..., exactType: str | List[str] = ..., et: str | List[str] = ..., excludeType: str | List[str] = ..., ext: str | List[str] = ..., flatten: bool | int = ..., fl: bool | int = ..., geometry: bool | int = ..., g: bool | int = ..., ghost: bool | int = ..., gh: bool | int = ..., head: int = ..., hd: int = ..., hilite: bool | int = ..., hl: bool | int = ..., intermediateObjects: bool | int = ..., io: bool | int = ..., invisible: bool | int = ..., iv: bool | int = ..., leaf: bool | int = ..., lf: bool | int = ..., lights: bool | int = ..., lt: bool | int = ..., live: bool | int = ..., lv: bool | int = ..., lockedNodes: bool | int = ..., ln: bool | int = ..., long: bool | int = ..., l: bool | int = ..., materials: bool | int = ..., mat: bool | int = ..., modified: bool | int = ..., mod: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., nodeTypes: bool | int = ..., nt: bool | int = ..., objectsOnly: bool | int = ..., o: bool | int = ..., orderedSelection: bool | int = ..., os: bool | int = ..., partitions: bool | int = ..., pr: bool | int = ..., persistentNodes: bool | int = ..., pn: bool | int = ..., planes: bool | int = ..., pl: bool | int = ..., preSelectHilite: bool | int = ..., psh: bool | int = ..., readOnly: bool | int = ..., ro: bool | int = ..., recursive: bool | int = ..., r: bool | int = ..., referencedNodes: bool | int = ..., rn: bool | int = ..., references: bool | int = ..., rf: bool | int = ..., renderGlobals: bool | int = ..., rg: bool | int = ..., renderQualities: bool | int = ..., rq: bool | int = ..., renderResolutions: bool | int = ..., rr: bool | int = ..., renderSetups: bool | int = ..., rs: bool | int = ..., selection: bool | int = ..., sl: bool | int = ..., sets: bool | int = ..., set: bool | int = ..., shapes: bool | int = ..., s: bool | int = ..., shortNames: bool | int = ..., sn: bool | int = ..., showNamespace: bool | int = ..., sns: bool | int = ..., showType: bool | int = ..., st: bool | int = ..., tail: int = ..., tl: int = ..., templated: bool | int = ..., tm: bool | int = ..., textures: bool | int = ..., tex: bool | int = ..., transforms: bool | int = ..., tr: bool | int = ..., type: str | List[str] = ..., typ: str | List[str] = ..., ufeObjects: bool | int = ..., ufe: bool | int = ..., undeletable: bool | int = ..., ud: bool | int = ..., untemplated: bool | int = ..., ut: bool | int = ..., uuid: bool | int = ..., uid: bool | int = ..., visible: bool | int = ..., v: bool | int = ...) -> List[nodetypes.Camera]: ...
@overload
def ls(*args: Any, assemblies: Literal[True], editable: bool = ..., regex: PatternTypes = ..., absoluteName: bool | int = ..., an: bool | int = ..., allPaths: bool | int = ..., ap: bool | int = ..., cameras: bool | int = ..., ca: bool | int = ..., containerType: str | List[str] = ..., ct: str | List[str] = ..., containers: bool | int = ..., con: bool | int = ..., dagObjects: bool | int = ..., dag: bool | int = ..., defaultNodes: bool | int = ..., dn: bool | int = ..., dependencyNodes: bool | int = ..., dep: bool | int = ..., exactType: str | List[str] = ..., et: str | List[str] = ..., excludeType: str | List[str] = ..., ext: str | List[str] = ..., flatten: bool | int = ..., fl: bool | int = ..., geometry: bool | int = ..., g: bool | int = ..., ghost: bool | int = ..., gh: bool | int = ..., head: int = ..., hd: int = ..., hilite: bool | int = ..., hl: bool | int = ..., intermediateObjects: bool | int = ..., io: bool | int = ..., invisible: bool | int = ..., iv: bool | int = ..., leaf: bool | int = ..., lf: bool | int = ..., lights: bool | int = ..., lt: bool | int = ..., live: bool | int = ..., lv: bool | int = ..., lockedNodes: bool | int = ..., ln: bool | int = ..., long: bool | int = ..., l: bool | int = ..., materials: bool | int = ..., mat: bool | int = ..., modified: bool | int = ..., mod: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., nodeTypes: bool | int = ..., nt: bool | int = ..., objectsOnly: bool | int = ..., o: bool | int = ..., orderedSelection: bool | int = ..., os: bool | int = ..., partitions: bool | int = ..., pr: bool | int = ..., persistentNodes: bool | int = ..., pn: bool | int = ..., planes: bool | int = ..., pl: bool | int = ..., preSelectHilite: bool | int = ..., psh: bool | int = ..., readOnly: bool | int = ..., ro: bool | int = ..., recursive: bool | int = ..., r: bool | int = ..., referencedNodes: bool | int = ..., rn: bool | int = ..., references: bool | int = ..., rf: bool | int = ..., renderGlobals: bool | int = ..., rg: bool | int = ..., renderQualities: bool | int = ..., rq: bool | int = ..., renderResolutions: bool | int = ..., rr: bool | int = ..., renderSetups: bool | int = ..., rs: bool | int = ..., selection: bool | int = ..., sl: bool | int = ..., sets: bool | int = ..., set: bool | int = ..., shapes: bool | int = ..., s: bool | int = ..., shortNames: bool | int = ..., sn: bool | int = ..., showNamespace: bool | int = ..., sns: bool | int = ..., showType: bool | int = ..., st: bool | int = ..., tail: int = ..., tl: int = ..., templated: bool | int = ..., tm: bool | int = ..., textures: bool | int = ..., tex: bool | int = ..., transforms: bool | int = ..., tr: bool | int = ..., type: str | List[str] = ..., typ: str | List[str] = ..., ufeObjects: bool | int = ..., ufe: bool | int = ..., undeletable: bool | int = ..., ud: bool | int = ..., untemplated: bool | int = ..., ut: bool | int = ..., uuid: bool | int = ..., uid: bool | int = ..., visible: bool | int = ..., v: bool | int = ...) -> List[nodetypes.Transform]: ...
@overload
def ls(*args: Any, transforms: Literal[True], editable: bool = ..., regex: PatternTypes = ..., absoluteName: bool | int = ..., an: bool | int = ..., allPaths: bool | int = ..., ap: bool | int = ..., assemblies: bool | int = ..., cameras: bool | int = ..., ca: bool | int = ..., containerType: str | List[str] = ..., ct: str | List[str] = ..., containers: bool | int = ..., con: bool | int = ..., dagObjects: bool | int = ..., dag: bool | int = ..., defaultNodes: bool | int = ..., dn: bool | int = ..., dependencyNodes: bool | int = ..., dep: bool | int = ..., exactType: str | List[str] = ..., et: str | List[str] = ..., excludeType: str | List[str] = ..., ext: str | List[str] = ..., flatten: bool | int = ..., fl: bool | int = ..., geometry: bool | int = ..., g: bool | int = ..., ghost: bool | int = ..., gh: bool | int = ..., head: int = ..., hd: int = ..., hilite: bool | int = ..., hl: bool | int = ..., intermediateObjects: bool | int = ..., io: bool | int = ..., invisible: bool | int = ..., iv: bool | int = ..., leaf: bool | int = ..., lf: bool | int = ..., lights: bool | int = ..., lt: bool | int = ..., live: bool | int = ..., lv: bool | int = ..., lockedNodes: bool | int = ..., ln: bool | int = ..., long: bool | int = ..., l: bool | int = ..., materials: bool | int = ..., mat: bool | int = ..., modified: bool | int = ..., mod: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., nodeTypes: bool | int = ..., nt: bool | int = ..., objectsOnly: bool | int = ..., o: bool | int = ..., orderedSelection: bool | int = ..., os: bool | int = ..., partitions: bool | int = ..., pr: bool | int = ..., persistentNodes: bool | int = ..., pn: bool | int = ..., planes: bool | int = ..., pl: bool | int = ..., preSelectHilite: bool | int = ..., psh: bool | int = ..., readOnly: bool | int = ..., ro: bool | int = ..., recursive: bool | int = ..., r: bool | int = ..., referencedNodes: bool | int = ..., rn: bool | int = ..., references: bool | int = ..., rf: bool | int = ..., renderGlobals: bool | int = ..., rg: bool | int = ..., renderQualities: bool | int = ..., rq: bool | int = ..., renderResolutions: bool | int = ..., rr: bool | int = ..., renderSetups: bool | int = ..., rs: bool | int = ..., selection: bool | int = ..., sl: bool | int = ..., sets: bool | int = ..., set: bool | int = ..., shapes: bool | int = ..., s: bool | int = ..., shortNames: bool | int = ..., sn: bool | int = ..., showNamespace: bool | int = ..., sns: bool | int = ..., showType: bool | int = ..., st: bool | int = ..., tail: int = ..., tl: int = ..., templated: bool | int = ..., tm: bool | int = ..., textures: bool | int = ..., tex: bool | int = ..., type: str | List[str] = ..., typ: str | List[str] = ..., ufeObjects: bool | int = ..., ufe: bool | int = ..., undeletable: bool | int = ..., ud: bool | int = ..., untemplated: bool | int = ..., ut: bool | int = ..., uuid: bool | int = ..., uid: bool | int = ..., visible: bool | int = ..., v: bool | int = ...) -> List[nodetypes.Transform]: ...
@overload
def ls(*args: Any, shapes: Literal[True], editable: bool = ..., regex: PatternTypes = ..., absoluteName: bool | int = ..., an: bool | int = ..., allPaths: bool | int = ..., ap: bool | int = ..., assemblies: bool | int = ..., cameras: bool | int = ..., ca: bool | int = ..., containerType: str | List[str] = ..., ct: str | List[str] = ..., containers: bool | int = ..., con: bool | int = ..., dagObjects: bool | int = ..., dag: bool | int = ..., defaultNodes: bool | int = ..., dn: bool | int = ..., dependencyNodes: bool | int = ..., dep: bool | int = ..., exactType: str | List[str] = ..., et: str | List[str] = ..., excludeType: str | List[str] = ..., ext: str | List[str] = ..., flatten: bool | int = ..., fl: bool | int = ..., geometry: bool | int = ..., g: bool | int = ..., ghost: bool | int = ..., gh: bool | int = ..., head: int = ..., hd: int = ..., hilite: bool | int = ..., hl: bool | int = ..., intermediateObjects: bool | int = ..., io: bool | int = ..., invisible: bool | int = ..., iv: bool | int = ..., leaf: bool | int = ..., lf: bool | int = ..., lights: bool | int = ..., lt: bool | int = ..., live: bool | int = ..., lv: bool | int = ..., lockedNodes: bool | int = ..., ln: bool | int = ..., long: bool | int = ..., l: bool | int = ..., materials: bool | int = ..., mat: bool | int = ..., modified: bool | int = ..., mod: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., nodeTypes: bool | int = ..., nt: bool | int = ..., objectsOnly: bool | int = ..., o: bool | int = ..., orderedSelection: bool | int = ..., os: bool | int = ..., partitions: bool | int = ..., pr: bool | int = ..., persistentNodes: bool | int = ..., pn: bool | int = ..., planes: bool | int = ..., pl: bool | int = ..., preSelectHilite: bool | int = ..., psh: bool | int = ..., readOnly: bool | int = ..., ro: bool | int = ..., recursive: bool | int = ..., r: bool | int = ..., referencedNodes: bool | int = ..., rn: bool | int = ..., references: bool | int = ..., rf: bool | int = ..., renderGlobals: bool | int = ..., rg: bool | int = ..., renderQualities: bool | int = ..., rq: bool | int = ..., renderResolutions: bool | int = ..., rr: bool | int = ..., renderSetups: bool | int = ..., rs: bool | int = ..., selection: bool | int = ..., sl: bool | int = ..., sets: bool | int = ..., set: bool | int = ..., shortNames: bool | int = ..., sn: bool | int = ..., showNamespace: bool | int = ..., sns: bool | int = ..., showType: bool | int = ..., st: bool | int = ..., tail: int = ..., tl: int = ..., templated: bool | int = ..., tm: bool | int = ..., textures: bool | int = ..., tex: bool | int = ..., transforms: bool | int = ..., tr: bool | int = ..., type: str | List[str] = ..., typ: str | List[str] = ..., ufeObjects: bool | int = ..., ufe: bool | int = ..., undeletable: bool | int = ..., ud: bool | int = ..., untemplated: bool | int = ..., ut: bool | int = ..., uuid: bool | int = ..., uid: bool | int = ..., visible: bool | int = ..., v: bool | int = ...) -> List[nodetypes.Shape]: ...
@overload
def ls(*args: Any, dag: Literal[True], editable: bool = ..., regex: PatternTypes = ..., absoluteName: bool | int = ..., an: bool | int = ..., allPaths: bool | int = ..., ap: bool | int = ..., assemblies: bool | int = ..., cameras: bool | int = ..., ca: bool | int = ..., containerType: str | List[str] = ..., ct: str | List[str] = ..., containers: bool | int = ..., con: bool | int = ..., defaultNodes: bool | int = ..., dn: bool | int = ..., dependencyNodes: bool | int = ..., dep: bool | int = ..., exactType: str | List[str] = ..., et: str | List[str] = ..., excludeType: str | List[str] = ..., ext: str | List[str] = ..., flatten: bool | int = ..., fl: bool | int = ..., geometry: bool | int = ..., g: bool | int = ..., ghost: bool | int = ..., gh: bool | int = ..., head: int = ..., hd: int = ..., hilite: bool | int = ..., hl: bool | int = ..., intermediateObjects: bool | int = ..., io: bool | int = ..., invisible: bool | int = ..., iv: bool | int = ..., leaf: bool | int = ..., lf: bool | int = ..., lights: bool | int = ..., lt: bool | int = ..., live: bool | int = ..., lv: bool | int = ..., lockedNodes: bool | int = ..., ln: bool | int = ..., long: bool | int = ..., l: bool | int = ..., materials: bool | int = ..., mat: bool | int = ..., modified: bool | int = ..., mod: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., nodeTypes: bool | int = ..., nt: bool | int = ..., objectsOnly: bool | int = ..., o: bool | int = ..., orderedSelection: bool | int = ..., os: bool | int = ..., partitions: bool | int = ..., pr: bool | int = ..., persistentNodes: bool | int = ..., pn: bool | int = ..., planes: bool | int = ..., pl: bool | int = ..., preSelectHilite: bool | int = ..., psh: bool | int = ..., readOnly: bool | int = ..., ro: bool | int = ..., recursive: bool | int = ..., r: bool | int = ..., referencedNodes: bool | int = ..., rn: bool | int = ..., references: bool | int = ..., rf: bool | int = ..., renderGlobals: bool | int = ..., rg: bool | int = ..., renderQualities: bool | int = ..., rq: bool | int = ..., renderResolutions: bool | int = ..., rr: bool | int = ..., renderSetups: bool | int = ..., rs: bool | int = ..., selection: bool | int = ..., sl: bool | int = ..., sets: bool | int = ..., set: bool | int = ..., shapes: bool | int = ..., s: bool | int = ..., shortNames: bool | int = ..., sn: bool | int = ..., showNamespace: bool | int = ..., sns: bool | int = ..., showType: bool | int = ..., st: bool | int = ..., tail: int = ..., tl: int = ..., templated: bool | int = ..., tm: bool | int = ..., textures: bool | int = ..., tex: bool | int = ..., transforms: bool | int = ..., tr: bool | int = ..., type: str | List[str] = ..., typ: str | List[str] = ..., ufeObjects: bool | int = ..., ufe: bool | int = ..., undeletable: bool | int = ..., ud: bool | int = ..., untemplated: bool | int = ..., ut: bool | int = ..., uuid: bool | int = ..., uid: bool | int = ..., visible: bool | int = ..., v: bool | int = ...) -> List[nodetypes.DagNode]: ...
@overload
def ls(*args: Any, type: LimitedTypeArgTypes, editable: bool = ..., regex: PatternTypes = ..., absoluteName: bool | int = ..., an: bool | int = ..., allPaths: bool | int = ..., ap: bool | int = ..., assemblies: bool | int = ..., cameras: bool | int = ..., ca: bool | int = ..., containerType: str | List[str] = ..., ct: str | List[str] = ..., containers: bool | int = ..., con: bool | int = ..., dagObjects: bool | int = ..., dag: bool | int = ..., defaultNodes: bool | int = ..., dn: bool | int = ..., dependencyNodes: bool | int = ..., dep: bool | int = ..., exactType: str | List[str] = ..., et: str | List[str] = ..., excludeType: str | List[str] = ..., ext: str | List[str] = ..., flatten: bool | int = ..., fl: bool | int = ..., geometry: bool | int = ..., g: bool | int = ..., ghost: bool | int = ..., gh: bool | int = ..., head: int = ..., hd: int = ..., hilite: bool | int = ..., hl: bool | int = ..., intermediateObjects: bool | int = ..., io: bool | int = ..., invisible: bool | int = ..., iv: bool | int = ..., leaf: bool | int = ..., lf: bool | int = ..., lights: bool | int = ..., lt: bool | int = ..., live: bool | int = ..., lv: bool | int = ..., lockedNodes: bool | int = ..., ln: bool | int = ..., long: bool | int = ..., l: bool | int = ..., materials: bool | int = ..., mat: bool | int = ..., modified: bool | int = ..., mod: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., nodeTypes: bool | int = ..., nt: bool | int = ..., objectsOnly: bool | int = ..., o: bool | int = ..., orderedSelection: bool | int = ..., os: bool | int = ..., partitions: bool | int = ..., pr: bool | int = ..., persistentNodes: bool | int = ..., pn: bool | int = ..., planes: bool | int = ..., pl: bool | int = ..., preSelectHilite: bool | int = ..., psh: bool | int = ..., readOnly: bool | int = ..., ro: bool | int = ..., recursive: bool | int = ..., r: bool | int = ..., referencedNodes: bool | int = ..., rn: bool | int = ..., references: bool | int = ..., rf: bool | int = ..., renderGlobals: bool | int = ..., rg: bool | int = ..., renderQualities: bool | int = ..., rq: bool | int = ..., renderResolutions: bool | int = ..., rr: bool | int = ..., renderSetups: bool | int = ..., rs: bool | int = ..., selection: bool | int = ..., sl: bool | int = ..., sets: bool | int = ..., set: bool | int = ..., shapes: bool | int = ..., s: bool | int = ..., shortNames: bool | int = ..., sn: bool | int = ..., showNamespace: bool | int = ..., sns: bool | int = ..., showType: bool | int = ..., st: bool | int = ..., tail: int = ..., tl: int = ..., templated: bool | int = ..., tm: bool | int = ..., textures: bool | int = ..., tex: bool | int = ..., transforms: bool | int = ..., tr: bool | int = ..., ufeObjects: bool | int = ..., ufe: bool | int = ..., undeletable: bool | int = ..., ud: bool | int = ..., untemplated: bool | int = ..., ut: bool | int = ..., uuid: bool | int = ..., uid: bool | int = ..., visible: bool | int = ..., v: bool | int = ...) -> List[nodetypes.DependNode]: ...
@overload
def ls(*args: Any, selection: Literal[True], objectsOnly: Literal[True], editable: bool = ..., regex: PatternTypes = ..., absoluteName: bool | int = ..., an: bool | int = ..., allPaths: bool | int = ..., ap: bool | int = ..., assemblies: bool | int = ..., cameras: bool | int = ..., ca: bool | int = ..., containerType: str | List[str] = ..., ct: str | List[str] = ..., containers: bool | int = ..., con: bool | int = ..., dagObjects: bool | int = ..., dag: bool | int = ..., defaultNodes: bool | int = ..., dn: bool | int = ..., dependencyNodes: bool | int = ..., dep: bool | int = ..., exactType: str | List[str] = ..., et: str | List[str] = ..., excludeType: str | List[str] = ..., ext: str | List[str] = ..., flatten: bool | int = ..., fl: bool | int = ..., geometry: bool | int = ..., g: bool | int = ..., ghost: bool | int = ..., gh: bool | int = ..., head: int = ..., hd: int = ..., hilite: bool | int = ..., hl: bool | int = ..., intermediateObjects: bool | int = ..., io: bool | int = ..., invisible: bool | int = ..., iv: bool | int = ..., leaf: bool | int = ..., lf: bool | int = ..., lights: bool | int = ..., lt: bool | int = ..., live: bool | int = ..., lv: bool | int = ..., lockedNodes: bool | int = ..., ln: bool | int = ..., long: bool | int = ..., l: bool | int = ..., materials: bool | int = ..., mat: bool | int = ..., modified: bool | int = ..., mod: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., nodeTypes: bool | int = ..., nt: bool | int = ..., orderedSelection: bool | int = ..., os: bool | int = ..., partitions: bool | int = ..., pr: bool | int = ..., persistentNodes: bool | int = ..., pn: bool | int = ..., planes: bool | int = ..., pl: bool | int = ..., preSelectHilite: bool | int = ..., psh: bool | int = ..., readOnly: bool | int = ..., ro: bool | int = ..., recursive: bool | int = ..., r: bool | int = ..., referencedNodes: bool | int = ..., rn: bool | int = ..., references: bool | int = ..., rf: bool | int = ..., renderGlobals: bool | int = ..., rg: bool | int = ..., renderQualities: bool | int = ..., rq: bool | int = ..., renderResolutions: bool | int = ..., rr: bool | int = ..., renderSetups: bool | int = ..., rs: bool | int = ..., sets: bool | int = ..., set: bool | int = ..., shapes: bool | int = ..., s: bool | int = ..., shortNames: bool | int = ..., sn: bool | int = ..., showNamespace: bool | int = ..., sns: bool | int = ..., showType: bool | int = ..., st: bool | int = ..., tail: int = ..., tl: int = ..., templated: bool | int = ..., tm: bool | int = ..., textures: bool | int = ..., tex: bool | int = ..., transforms: bool | int = ..., tr: bool | int = ..., type: str | List[str] = ..., typ: str | List[str] = ..., ufeObjects: bool | int = ..., ufe: bool | int = ..., undeletable: bool | int = ..., ud: bool | int = ..., untemplated: bool | int = ..., ut: bool | int = ..., uuid: bool | int = ..., uid: bool | int = ..., visible: bool | int = ..., v: bool | int = ...) -> List[nodetypes.DependNode]: ...
@overload
def ls(*args: Any, selection: Literal[True], objectsOnly: Literal[False] = ..., editable: bool = ..., regex: PatternTypes = ..., absoluteName: bool | int = ..., an: bool | int = ..., allPaths: bool | int = ..., ap: bool | int = ..., assemblies: bool | int = ..., cameras: bool | int = ..., ca: bool | int = ..., containerType: str | List[str] = ..., ct: str | List[str] = ..., containers: bool | int = ..., con: bool | int = ..., dagObjects: bool | int = ..., dag: bool | int = ..., defaultNodes: bool | int = ..., dn: bool | int = ..., dependencyNodes: bool | int = ..., dep: bool | int = ..., exactType: str | List[str] = ..., et: str | List[str] = ..., excludeType: str | List[str] = ..., ext: str | List[str] = ..., flatten: bool | int = ..., fl: bool | int = ..., geometry: bool | int = ..., g: bool | int = ..., ghost: bool | int = ..., gh: bool | int = ..., head: int = ..., hd: int = ..., hilite: bool | int = ..., hl: bool | int = ..., intermediateObjects: bool | int = ..., io: bool | int = ..., invisible: bool | int = ..., iv: bool | int = ..., leaf: bool | int = ..., lf: bool | int = ..., lights: bool | int = ..., lt: bool | int = ..., live: bool | int = ..., lv: bool | int = ..., lockedNodes: bool | int = ..., ln: bool | int = ..., long: bool | int = ..., l: bool | int = ..., materials: bool | int = ..., mat: bool | int = ..., modified: bool | int = ..., mod: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., nodeTypes: bool | int = ..., nt: bool | int = ..., orderedSelection: bool | int = ..., os: bool | int = ..., partitions: bool | int = ..., pr: bool | int = ..., persistentNodes: bool | int = ..., pn: bool | int = ..., planes: bool | int = ..., pl: bool | int = ..., preSelectHilite: bool | int = ..., psh: bool | int = ..., readOnly: bool | int = ..., ro: bool | int = ..., recursive: bool | int = ..., r: bool | int = ..., referencedNodes: bool | int = ..., rn: bool | int = ..., references: bool | int = ..., rf: bool | int = ..., renderGlobals: bool | int = ..., rg: bool | int = ..., renderQualities: bool | int = ..., rq: bool | int = ..., renderResolutions: bool | int = ..., rr: bool | int = ..., renderSetups: bool | int = ..., rs: bool | int = ..., sets: bool | int = ..., set: bool | int = ..., shapes: bool | int = ..., s: bool | int = ..., shortNames: bool | int = ..., sn: bool | int = ..., showNamespace: bool | int = ..., sns: bool | int = ..., showType: bool | int = ..., st: bool | int = ..., tail: int = ..., tl: int = ..., templated: bool | int = ..., tm: bool | int = ..., textures: bool | int = ..., tex: bool | int = ..., transforms: bool | int = ..., tr: bool | int = ..., type: str | List[str] = ..., typ: str | List[str] = ..., ufeObjects: bool | int = ..., ufe: bool | int = ..., undeletable: bool | int = ..., ud: bool | int = ..., untemplated: bool | int = ..., ut: bool | int = ..., uuid: bool | int = ..., uid: bool | int = ..., visible: bool | int = ..., v: bool | int = ...) -> List[SelectableTypes]: ...
@overload
def ls(*args: Any, selection: Literal[False] = ..., editable: bool = ..., regex: PatternTypes = ..., absoluteName: bool | int = ..., an: bool | int = ..., allPaths: bool | int = ..., ap: bool | int = ..., assemblies: bool | int = ..., cameras: bool | int = ..., ca: bool | int = ..., containerType: str | List[str] = ..., ct: str | List[str] = ..., containers: bool | int = ..., con: bool | int = ..., dagObjects: bool | int = ..., dag: bool | int = ..., defaultNodes: bool | int = ..., dn: bool | int = ..., dependencyNodes: bool | int = ..., dep: bool | int = ..., exactType: str | List[str] = ..., et: str | List[str] = ..., excludeType: str | List[str] = ..., ext: str | List[str] = ..., flatten: bool | int = ..., fl: bool | int = ..., geometry: bool | int = ..., g: bool | int = ..., ghost: bool | int = ..., gh: bool | int = ..., head: int = ..., hd: int = ..., hilite: bool | int = ..., hl: bool | int = ..., intermediateObjects: bool | int = ..., io: bool | int = ..., invisible: bool | int = ..., iv: bool | int = ..., leaf: bool | int = ..., lf: bool | int = ..., lights: bool | int = ..., lt: bool | int = ..., live: bool | int = ..., lv: bool | int = ..., lockedNodes: bool | int = ..., ln: bool | int = ..., long: bool | int = ..., l: bool | int = ..., materials: bool | int = ..., mat: bool | int = ..., modified: bool | int = ..., mod: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., nodeTypes: bool | int = ..., nt: bool | int = ..., objectsOnly: bool | int = ..., o: bool | int = ..., orderedSelection: bool | int = ..., os: bool | int = ..., partitions: bool | int = ..., pr: bool | int = ..., persistentNodes: bool | int = ..., pn: bool | int = ..., planes: bool | int = ..., pl: bool | int = ..., preSelectHilite: bool | int = ..., psh: bool | int = ..., readOnly: bool | int = ..., ro: bool | int = ..., recursive: bool | int = ..., r: bool | int = ..., referencedNodes: bool | int = ..., rn: bool | int = ..., references: bool | int = ..., rf: bool | int = ..., renderGlobals: bool | int = ..., rg: bool | int = ..., renderQualities: bool | int = ..., rq: bool | int = ..., renderResolutions: bool | int = ..., rr: bool | int = ..., renderSetups: bool | int = ..., rs: bool | int = ..., sets: bool | int = ..., set: bool | int = ..., shapes: bool | int = ..., s: bool | int = ..., shortNames: bool | int = ..., sn: bool | int = ..., showNamespace: bool | int = ..., sns: bool | int = ..., showType: bool | int = ..., st: bool | int = ..., tail: int = ..., tl: int = ..., templated: bool | int = ..., tm: bool | int = ..., textures: bool | int = ..., tex: bool | int = ..., transforms: bool | int = ..., tr: bool | int = ..., type: str | List[str] = ..., typ: str | List[str] = ..., ufeObjects: bool | int = ..., ufe: bool | int = ..., undeletable: bool | int = ..., ud: bool | int = ..., untemplated: bool | int = ..., ut: bool | int = ..., uuid: bool | int = ..., uid: bool | int = ..., visible: bool | int = ..., v: bool | int = ...) -> List[nodetypes.DependNode]: ...
def listTransforms(*args: Any, **kwargs: Any) -> List[nodetypes.Transform]: ...
def listSets(*args: Any, allSets: bool | int = ..., extendToShape: bool | int = ..., ets: bool | int = ..., object: PyNode | str = ..., o: PyNode | str = ..., type: int = ..., t: int = ...) -> List[nodetypes.ObjectSet]: ...
def nodeType(node: Any, apiType: bool | int = ..., api: bool | int = ..., derived: bool | int = ..., d: bool | int = ..., inherited: bool | int = ..., i: bool | int = ..., isTypeName: bool | int = ..., itn: bool | int = ..., ufeRuntimeName: bool | int = ..., urn: bool | int = ...) -> str: ...
def group(*args: Any, absolute: bool | int = ..., a: bool | int = ..., empty: bool | int = ..., em: bool | int = ..., name: _util.ProxyUnicode | str = ..., n: _util.ProxyUnicode | str = ..., parent: _util.ProxyUnicode | str = ..., p: _util.ProxyUnicode | str = ..., relative: bool | int = ..., r: bool | int = ..., useAsGroup: _util.ProxyUnicode | str = ..., uag: _util.ProxyUnicode | str = ..., world: bool | int = ..., w: bool | int = ...) -> nodetypes.Transform: ...
def parent(*args: Any, absolute: bool | int = ..., a: bool | int = ..., addObject: bool | int = ..., add: bool | int = ..., noConnections: bool | int = ..., nc: bool | int = ..., noInvScale: bool | int = ..., nis: bool | int = ..., relative: bool | int = ..., r: bool | int = ..., removeObject: bool | int = ..., rm: bool | int = ..., shape: bool | int = ..., s: bool | int = ..., world: bool | int = ..., w: bool | int = ...) -> List[nodetypes.DagNode]: ...

class NodeTracker:
    def __init__(self) -> None: ...
    def startTrack(self) -> None: ...
    def endTrack(self) -> None: ...
    def getNodes(self, returnType: str = ...) -> None: ...
    def isTracking(self): ...
    def reset(self) -> None: ...
    def __enter__(self): ...
    def __exit__(self, exctype, excval, exctb) -> None: ...


@overload
def duplicate(arg: DependNodeT, fullPath: bool | int = ..., f: bool | int = ..., inputConnections: bool | int = ..., ic: bool | int = ..., instanceLeaf: bool | int = ..., ilf: bool | int = ..., name: _util.ProxyUnicode | str = ..., n: _util.ProxyUnicode | str = ..., parentOnly: bool | int = ..., po: bool | int = ..., renameChildren: bool | int = ..., rc: bool | int = ..., returnRootsOnly: bool | int = ..., rr: bool | int = ..., smartTransform: bool | int = ..., st: bool | int = ..., transformsOnly: bool | int = ..., to: bool | int = ..., upstreamNodes: bool | int = ..., un: bool | int = ...) -> List[DependNodeT]: ...
@overload
def duplicate(arg: Iterable[DependNodeT], fullPath: bool | int = ..., f: bool | int = ..., inputConnections: bool | int = ..., ic: bool | int = ..., instanceLeaf: bool | int = ..., ilf: bool | int = ..., name: _util.ProxyUnicode | str = ..., n: _util.ProxyUnicode | str = ..., parentOnly: bool | int = ..., po: bool | int = ..., renameChildren: bool | int = ..., rc: bool | int = ..., returnRootsOnly: bool | int = ..., rr: bool | int = ..., smartTransform: bool | int = ..., st: bool | int = ..., transformsOnly: bool | int = ..., to: bool | int = ..., upstreamNodes: bool | int = ..., un: bool | int = ...) -> List[DependNodeT]: ...
@overload
def duplicate(*args: Any, fullPath: bool | int = ..., f: bool | int = ..., inputConnections: bool | int = ..., ic: bool | int = ..., instanceLeaf: bool | int = ..., ilf: bool | int = ..., name: _util.ProxyUnicode | str = ..., n: _util.ProxyUnicode | str = ..., parentOnly: bool | int = ..., po: bool | int = ..., renameChildren: bool | int = ..., rc: bool | int = ..., returnRootsOnly: bool | int = ..., rr: bool | int = ..., smartTransform: bool | int = ..., st: bool | int = ..., transformsOnly: bool | int = ..., to: bool | int = ..., upstreamNodes: bool | int = ..., un: bool | int = ...) -> List[nodetypes.DependNode]: ...
def rename(obj: Union[str, nodetypes.DependNode], newname: str, ignoreShape: bool | int = ..., uuid: bool | int = ..., uid: bool | int = ...) -> nodetypes.DependNode: ...
@overload
def createNode(arg: Type[DependNodeT], name: _util.ProxyUnicode | str = ..., n: _util.ProxyUnicode | str = ..., parent: _util.ProxyUnicode | str = ..., p: _util.ProxyUnicode | str = ..., shared: bool | int = ..., s: bool | int = ..., skipSelect: bool | int = ..., ss: bool | int = ...) -> DependNodeT: ...
@overload
def createNode(*args: Any, name: _util.ProxyUnicode | str = ..., n: _util.ProxyUnicode | str = ..., parent: _util.ProxyUnicode | str = ..., p: _util.ProxyUnicode | str = ..., shared: bool | int = ..., s: bool | int = ..., skipSelect: bool | int = ..., ss: bool | int = ...) -> nodetypes.DependNode: ...
def sets(*args, addElement: PyNode | str = ..., add: PyNode | str = ..., afterFilters: bool | int = ..., af: bool | int = ..., anyMember: PyNode | str = ..., am: PyNode | str = ..., clear: PyNode | str = ..., cl: PyNode | str = ..., color: bool | int | int = ..., co: bool | int | int = ..., copy: PyNode | str = ..., cp: PyNode | str = ..., edges: bool | int = ..., eg: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., editPoints: bool | int = ..., ep: bool | int = ..., empty: bool | int = ..., em: bool | int = ..., facets: bool | int = ..., fc: bool | int = ..., flatten: PyNode | str = ..., fl: PyNode | str = ..., forceElement: PyNode | str = ..., fe: PyNode | str = ..., include: PyNode | str = ..., intersection: PyNode | str = ..., int: PyNode | str = ..., isIntersecting: PyNode | str = ..., ii: PyNode | str = ..., isMember: PyNode | str = ..., im: PyNode | str = ..., layer: bool | int = ..., l: bool | int = ..., name: _util.ProxyUnicode | str = ..., n: _util.ProxyUnicode | str = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., noSurfaceShader: bool | int = ..., nss: bool | int = ..., noWarnings: bool | int = ..., nw: bool | int = ..., nodesOnly: bool | int = ..., no: bool | int = ..., query: bool | int = ..., q: bool | int = ..., remove: PyNode | str = ..., rm: PyNode | str = ..., renderable: bool | int = ..., r: bool | int = ..., size: bool | int = ..., s: bool | int = ..., split: PyNode | str = ..., sp: PyNode | str = ..., subtract: PyNode | str = ..., sub: PyNode | str = ..., text: bool | int | _util.ProxyUnicode | str = ..., t: bool | int | _util.ProxyUnicode | str = ..., union: PyNode | str = ..., un: PyNode | str = ..., vertices: bool | int = ..., v: bool | int = ...): ...
def delete(*args, all: bool | int = ..., attribute: str | List[str] = ..., at: str | List[str] = ..., channels: bool | int = ..., c: bool | int = ..., constraints: bool | int = ..., cn: bool | int = ..., constructionHistory: bool | int = ..., ch: bool | int = ..., controlPoints: bool | int = ..., cp: bool | int = ..., expressions: bool | int = ..., e: bool | int = ..., hierarchy: _util.ProxyUnicode | str = ..., hi: _util.ProxyUnicode | str = ..., inputConnectionsAndNodes: bool | int = ..., icn: bool | int = ..., motionPaths: bool | int = ..., mp: bool | int = ..., shape: bool | int = ..., s: bool | int = ..., staticChannels: bool | int = ..., sc: bool | int = ..., timeAnimationCurves: bool | int = ..., tac: bool | int = ..., unitlessAnimationCurves: bool | int = ..., uac: bool | int = ...) -> None: ...
def getClassification(*args: Any, satisfies: _util.ProxyUnicode | str = ..., sat: _util.ProxyUnicode | str = ...) -> List[str]: ...
def uniqueObjExists(name: Union[str, PyNode]) -> bool: ...
def selected(**kwargs): ...
def spaceLocator(*args, absolute: bool | int = ..., a: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., name: _util.ProxyUnicode | str = ..., n: _util.ProxyUnicode | str = ..., position: bool | int | Tuple[float, float, float] = ..., p: bool | int | Tuple[float, float, float] = ..., query: bool | int = ..., q: bool | int = ..., relative: bool | int = ..., r: bool | int = ...): ...
def instancer(*args, addObject: bool | int = ..., a: bool | int = ..., cycle: bool | int | _util.ProxyUnicode | str = ..., c: bool | int | _util.ProxyUnicode | str = ..., cycleStep: bool | int | float = ..., cs: bool | int | float = ..., cycleStepUnits: bool | int | _util.ProxyUnicode | str = ..., csu: bool | int | _util.ProxyUnicode | str = ..., edit: bool | int = ..., e: bool | int = ..., index: bool | int | int = ..., i: bool | int | int = ..., levelOfDetail: bool | int | _util.ProxyUnicode | str = ..., lod: bool | int | _util.ProxyUnicode | str = ..., name: bool | int | _util.ProxyUnicode | str = ..., n: bool | int | _util.ProxyUnicode | str = ..., object: bool | int | str | List[str] = ..., obj: bool | int | str | List[str] = ..., objectPosition: bool | int | _util.ProxyUnicode | str = ..., op: bool | int | _util.ProxyUnicode | str = ..., objectRotation: bool | int | _util.ProxyUnicode | str = ..., objectScale: bool | int | _util.ProxyUnicode | str = ..., os: bool | int | _util.ProxyUnicode | str = ..., pointDataSource: bool | int = ..., pds: bool | int = ..., query: bool | int = ..., q: bool | int = ..., removeObject: bool | int = ..., rm: bool | int = ..., rotationOrder: bool | int | _util.ProxyUnicode | str = ..., ro: bool | int | _util.ProxyUnicode | str = ..., rotationUnits: bool | int | _util.ProxyUnicode | str = ..., ru: bool | int | _util.ProxyUnicode | str = ..., valueName: bool | int | _util.ProxyUnicode | str = ..., vn: bool | int | _util.ProxyUnicode | str = ...): ...

class MayaObjectError(TypeError):
    node: Incomplete
    def __init__(self, node: Incomplete | None = ...) -> None: ...

class MayaNodeError(MayaObjectError): ...
class MayaAttributeError(MayaObjectError, AttributeError): ...

class MayaAttributeEnumError(MayaAttributeError):
    enum: Incomplete
    def __init__(self, node: Incomplete | None = ..., enum: Incomplete | None = ...) -> None: ...

class MayaComponentError(MayaAttributeError): ...
class MayaInstanceError(MayaNodeError): ...

class DeletedMayaNodeError(MayaNodeError):
    def __init__(self, node: Incomplete | None = ...) -> None: ...
    @classmethod
    def handle(cls, pynode) -> None: ...

class MayaParticleAttributeError(MayaComponentError): ...

class PyNode(_util.ProxyUnicode):
    __apiobjects__: Incomplete
    def __new__(cls, *args, **kwargs): ...
    def __init__(self, *args, **kwargs) -> None: ...
    def __melobject__(self): ...
    def __apimfn__(self): ...
    def __radd__(self, other): ...
    def __reduce__(self): ...
    def __eq__(self, other: Any) -> bool: ...
    def __ne__(self, other: Any) -> bool: ...
    def __bool__(self) -> bool: ...
    def __lt__(self, other): ...
    def __gt__(self, other): ...
    def __le__(self, other): ...
    def __ge__(self, other): ...
    def stripNamespace(self, *args: Any, **kwargs: Any) -> other.NameParser: ...
    def swapNamespace(self, prefix: Any) -> other.NameParser: ...
    def namespaceList(self) -> List[str]: ...
    def addPrefix(self, prefix: Any) -> other.NameParser: ...
    def exists(self, **kwargs): ...
    objExists = exists
    nodeType: Incomplete
    def select(self, **kwargs): ...
    def deselect(self) -> None: ...
    def listSets(self, *args: Any, **kwargs: Any) -> List[PyNode]: ...
    connections = listConnections
    listConnections = listConnections
    history = listHistory
    listHistory = listHistory
    future = listFuture
    listFuture = listFuture

deprecated_str_methods: Incomplete
strDeprecateDecorator: Incomplete

class Attribute(PyNode):
    __apicls__: Incomplete
    attrItemReg: Incomplete
    def __apiobject__(self): ...
    def __apimobject__(self): ...
    def __apimplug__(self): ...
    def __apimdagpath__(self): ...
    def __apimattr__(self): ...
    def removeMultiInstance(self, index: Optional[Union[int, Iterable[int]]] = ..., break_: bool = ...) -> None: ...
    __delitem__ = removeMultiInstance
    def attr(self, attr: str) -> Attribute: ...
    def __getattr__(self, attr: str) -> Attribute: ...
    def __call__(self, *args, **kwargs) -> None: ...
    def __iter__(self) -> Iterator[Attribute]: ...
    def __eq__(self, other: Any) -> bool: ...
    def __hash__(self) -> int: ...
    def __ne__(self, other: Any) -> bool: ...
    def name(self, includeNode: bool = ..., longName: bool = ..., fullAttrPath: bool = ..., fullDagPath: bool = ..., placeHolderIndices: bool = ...) -> str: ...
    def plugNode(self) -> nodetypes.DependNode: ...
    node = plugNode
    def plugAttr(self, longName: bool = ..., fullPath: bool = ...) -> str: ...
    def lastPlugAttr(self, longName: bool = ...) -> str: ...
    def longName(self, fullPath: bool = ...) -> str: ...
    def shortName(self, fullPath: bool = ...) -> str: ...
    def nodeName(self) -> str: ...
    def attrName(self, longName: bool = ..., includeNode: bool = ...) -> str: ...
    def namespace(self, root: bool = ...) -> str: ...
    def array(self) -> Attribute: ...
    def elements(self) -> List[str]: ...
    def getArrayIndices(self) -> List[int]: ...
    def numElements(self) -> int: ...
    getEnums = getEnums
    setEnums = setEnums
    set = setAttr
    get = getAttr
    def isConnectedTo(self, other: Any, ignoreUnitConversion: bool = ..., checkLocalArray: bool = ..., checkOtherArray: bool = ...) -> bool: ...
    connect = connectAttr
    def __rshift__(self, other): ...
    disconnect = disconnectAttr
    def __floordiv__(self, other) -> None: ...
    @overload
    def inputs(self, connections: Literal[True], plugs: Literal[True], sourceFirst: bool = ..., type: TypeArgTypes = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[Tuple[Attribute, Attribute]]: ...
    @overload
    def inputs(self, connections: Literal[True], type: Type[DependNodeT], plugs: Literal[False] = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[Tuple[Attribute, DependNodeT]]: ...
    @overload
    def inputs(self, connections: Literal[True], plugs: Literal[False] = ..., type: LimitedTypeArgTypes = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[Tuple[Attribute, nodetypes.DependNode]]: ...
    @overload
    def inputs(self, plugs: Literal[True], connections: Literal[False] = ..., type: TypeArgTypes = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[Attribute]: ...
    @overload
    def inputs(self, type: Type[DependNodeT], plugs: Literal[False] = ..., connections: Literal[False] = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[DependNodeT]: ...
    @overload
    def inputs(self, type: LimitedTypeArgTypes = ..., connections: bool | int = ..., c: bool | int = ..., exactType: bool | int = ..., et: bool | int = ..., plugs: bool | int = ..., p: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[nodetypes.DependNode]: ...
    @overload
    def outputs(self, connections: Literal[True], plugs: Literal[True], sourceFirst: bool = ..., type: TypeArgTypes = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[Tuple[Attribute, Attribute]]: ...
    @overload
    def outputs(self, connections: Literal[True], type: Type[DependNodeT], plugs: Literal[False] = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[Tuple[Attribute, DependNodeT]]: ...
    @overload
    def outputs(self, connections: Literal[True], plugs: Literal[False] = ..., type: LimitedTypeArgTypes = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[Tuple[Attribute, nodetypes.DependNode]]: ...
    @overload
    def outputs(self, plugs: Literal[True], connections: Literal[False] = ..., type: TypeArgTypes = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[Attribute]: ...
    @overload
    def outputs(self, type: Type[DependNodeT], plugs: Literal[False] = ..., connections: Literal[False] = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[DependNodeT]: ...
    @overload
    def outputs(self, type: LimitedTypeArgTypes = ..., connections: bool | int = ..., c: bool | int = ..., exactType: bool | int = ..., et: bool | int = ..., plugs: bool | int = ..., p: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[nodetypes.DependNode]: ...
    def insertInput(self, node, nodeOutAttr, nodeInAttr) -> None: ...
    def setKey(self, adjustTangent: bool | int = ..., adt: bool | int = ..., animLayer: _util.ProxyUnicode | str = ..., al: _util.ProxyUnicode | str = ..., animated: bool | int = ..., an: bool | int = ..., attribute: str | List[str] = ..., at: str | List[str] = ..., breakdown: bool | int = ..., bd: bool | int = ..., clip: _util.ProxyUnicode | str = ..., c: _util.ProxyUnicode | str = ..., controlPoints: bool | int = ..., cp: bool | int = ..., dirtyDG: bool | int = ..., dd: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., float: float | List[float] = ..., f: float | List[float] = ..., hierarchy: _util.ProxyUnicode | str = ..., hi: _util.ProxyUnicode | str = ..., identity: bool | int = ..., id: bool | int = ..., inTangentType: _util.ProxyUnicode | str = ..., itt: _util.ProxyUnicode | str = ..., insert: bool | int = ..., i: bool | int = ..., insertBlend: bool | int = ..., ib: bool | int = ..., minimizeRotation: bool | int = ..., mr: bool | int = ..., noResolve: bool | int = ..., nr: bool | int = ..., outTangentType: _util.ProxyUnicode | str = ..., ott: _util.ProxyUnicode | str = ..., preserveCurveShape: bool | int = ..., pcs: bool | int = ..., query: bool | int = ..., q: bool | int = ..., respectKeyable: bool | int = ..., rk: bool | int = ..., shape: bool | int = ..., s: bool | int = ..., time: int | float | List[int | float] = ..., t: int | float | List[int | float] = ..., useCurrentLockedWeights: bool | int = ..., lw: bool | int = ..., value: float = ..., v: float = ...): ...
    def getAlias(self) -> Optional[str]: ...
    def setAlias(self, alias: str) -> None: ...
    def delete(self) -> None: ...
    def remove(self, allChildren: bool | int = ..., all: bool | int = ..., b: bool | int = ...): ...
    def isDirty(self, connection: bool | int = ..., c: bool | int = ..., datablock: bool | int = ..., d: bool | int = ...) -> bool: ...
    def setDirty(self, allPlugs: bool | int = ..., a: bool | int = ..., clean: bool | int = ..., c: bool | int = ..., implicit: bool | int = ..., i: bool | int = ..., list: bool | int | _util.ProxyUnicode | str = ..., l: bool | int | _util.ProxyUnicode | str = ..., propagation: bool | int = ..., p: bool | int = ..., query: bool | int = ..., q: bool | int = ..., showTiming: bool | int = ..., st: bool | int = ..., verbose: bool | int = ..., v: bool | int = ...) -> None: ...
    def evaluate(self, src: bool | int = ..., verbose: bool | int = ..., v: bool | int = ...) -> None: ...
    def affects(self) -> List[Attribute]: ...
    def affected(self) -> List[Attribute]: ...
    class _TempRealIndexedAttr:
        origAttr: Incomplete
        toDelete: Incomplete
        def __init__(self, attr) -> None: ...
        chain: Incomplete
        def __enter__(self): ...
        def __exit__(self, type, value, traceback) -> None: ...
    def type(self) -> str: ...
    def setLocked(self, locked: bool, checkReference: bool = ...) -> None: ...
    def lock(self, checkReference: bool = ...) -> None: ...
    def unlock(self, checkReference: bool = ...) -> None: ...
    def isMuted(self) -> bool: ...
    def mute(self, disable: bool | int = ..., d: bool | int = ..., force: bool | int = ..., f: bool | int = ..., query: bool | int = ..., q: bool | int = ...) -> None: ...
    def unmute(self, query: bool | int = ..., q: bool | int = ...) -> None: ...
    def isSettable(self) -> bool: ...
    def isHidden(self) -> bool: ...
    def isConnectable(self) -> bool: ...
    def isUsedAsColor(self) -> bool: ...
    def indexMatters(self) -> bool: ...
    def exists(self) -> bool: ...
    def getDefault(self) -> Any: ...
    def getSoftMin(self) -> Optional[float]: ...
    def getSoftMax(self) -> Optional[float]: ...
    def getMin(self) -> Optional[float]: ...
    def getMax(self) -> Optional[float]: ...
    def getSoftRange(self) -> List[float]: ...
    def getRange(self) -> List[float]: ...
    def setMin(self, newMin: float) -> None: ...
    def setMax(self, newMax: float) -> None: ...
    def setSoftMin(self, newMin: float) -> None: ...
    def setSoftMax(self, newMax: float) -> None: ...
    @overload
    def setRange(self, range: Tuple[Optional[float], Optional[float]]) -> None: ...
    @overload
    def setRange(self, newMin: Optional[float], newMax: Optional[float]) -> None: ...
    @overload
    def setRange(self, range: Tuple[Optional[float], Optional[float]]) -> None: ...
    @overload
    def setRange(self, newMin: Optional[float], newMax: Optional[float]) -> None: ...
    def setSoftRange(self, *args) -> None: ...
    def getChildren(self) -> List[Attribute]: ...
    children = getChildren
    def iterDescendants(self, levels: Optional[int] = ..., leavesOnly: bool = ...) -> Iterator[Attribute]: ...
    def getSiblings(self) -> Optional[List[Attribute]]: ...
    siblings = getSiblings
    def firstParent(self): ...
    @overload
    def getParent(self, generations: None = ..., arrays: bool = ...) -> List[Attribute]: ...
    @overload
    def getParent(self, generations: int = ..., arrays: bool = ...) -> Attribute: ...
    def getAllParents(self, arrays: bool = ...) -> List[Attribute]: ...
    parent = getParent
    FreeToChangeState: Incomplete
    MValueSelector: Incomplete
    def destinations(self) -> Tuple[bool, List[Attribute]]: ...
    def destinationsWithConversions(self) -> Tuple[bool, List[Attribute]]: ...
    def elementByLogicalIndex(self, index: int) -> Attribute: ...
    __getitem__ = elementByLogicalIndex
    def elementByPhysicalIndex(self, index: int) -> Attribute: ...
    def evaluateNumElements(self) -> int: ...
    def getNumElements(self) -> int: ...
    def getSetAttrCmds(self, valueSelector: datatypes.Plug.MValueSelector = ..., useLongNames: bool = ...) -> List[str]: ...
    def info(self) -> str: ...
    def isArray(self) -> bool: ...
    isMulti = isArray
    def isCaching(self) -> bool: ...
    def isChild(self) -> bool: ...
    def isCompound(self) -> bool: ...
    def isConnected(self) -> bool: ...
    def isDefaultValue(self, forceEval: bool = ...) -> bool: ...
    def isDestination(self) -> bool: ...
    def isDynamic(self) -> bool: ...
    def isElement(self) -> bool: ...
    def isExactlyEqual(self, other: Union[str, Attribute]) -> bool: ...
    def isFreeToChange(self, checkParents: bool = ..., checkChildren: bool = ...) -> datatypes.Plug.FreeToChangeState: ...
    def isFromReferencedFile(self) -> bool: ...
    def isIgnoredWhenRendering(self) -> bool: ...
    def isInChannelBox(self) -> bool: ...
    def isKeyable(self) -> bool: ...
    def isLocked(self) -> bool: ...
    def isNetworked(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isProcedural(self) -> bool: ...
    def isProxy(self) -> bool: ...
    def isSource(self) -> bool: ...
    def logicalIndex(self) -> int: ...
    item = logicalIndex
    index = logicalIndex
    def numChildren(self) -> int: ...
    def numConnectedChildren(self) -> int: ...
    def numConnectedElements(self) -> int: ...
    def proxied(self) -> Attribute: ...
    def setCaching(self, isCaching: bool) -> None: ...
    def setKeyable(self, keyable: bool) -> None: ...
    def setNumElements(self, elements: int) -> None: ...
    def showInChannelBox(self, inChannelBox: bool) -> None: ...
    def source(self) -> Attribute: ...
    def sourceWithConversion(self) -> Attribute: ...
ProxySlice = slice

class HashableSlice(ProxySlice):
    def __init__(self, *args, **kwargs) -> None: ...
    def __hash__(self): ...
    def __eq__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    @property
    def start(self) -> int: ...
    @property
    def stop(self) -> int: ...
    @property
    def step(self) -> int: ...

class Component(PyNode):
    _apienum__: Incomplete
    _ComponentLabel__: str
    def __init__(self, *args, **kwargs) -> None: ...
    def __apimdagpath__(self): ...
    def __apimobject__(self): ...
    def __apiobject__(self): ...
    def __apihandle__(self): ...
    def __apicomponent__(self): ...
    def __apimfn__(self): ...
    def __eq__(self, other): ...
    def __bool__(self) -> bool: ...
    def __melobject__(self): ...
    def name(self) -> str: ...
    def node(self): ...
    def namespace(self, *args, **kwargs): ...
    plugNode = node
    def plugAttr(self): ...
    def isComplete(self, *args, **kwargs): ...
    @staticmethod
    def numComponentsFromStrings(*componentStrings): ...

class DimensionedComponent(Component):
    dimensions: int
    def __init__(self, *args, **kwargs) -> None: ...
    VALID_SINGLE_INDEX_TYPES: Incomplete
    def __getitem__(self, item): ...
    def currentDimension(self): ...

class ComponentIndex(tuple):
    label: Incomplete
    def __new__(cls, *args, **kwargs): ...
    def __add__(self, other): ...

def validComponentIndexType(argObj, allowDicts: bool = ..., componentIndexTypes: Incomplete | None = ...): ...

class DiscreteComponent(DimensionedComponent):
    VALID_SINGLE_INDEX_TYPES: Incomplete
    def __init__(self, *args, **kwargs) -> None: ...
    def __iter__(self): ...
    indicesIter: Incomplete
    def indices(self): ...
    def __len__(self) -> int: ...
    def count(self): ...
    def totalSize(self): ...
    def setIndex(self, index): ...
    def getIndex(self): ...
    def currentItem(self): ...
    def currentItemIndex(self): ...
    def __next__(self): ...
    def reset(self) -> None: ...

class ContinuousComponent(DimensionedComponent):
    VALID_SINGLE_INDEX_TYPES: Incomplete
    def __iter__(self): ...

class Component1DFloat(ContinuousComponent):
    dimensions: int
    def index(self): ...

class Component2DFloat(ContinuousComponent):
    dimensions: int

class Component1D(DiscreteComponent):
    _apienum__: Incomplete
    dimensions: int
    def index(self): ...
    def name(self) -> str: ...
    def currentItem(self): ...
    def currentItemIndex(self): ...
    def indicesIter(self) -> Generator[Incomplete, None, None]: ...
    def __add__(self, other): ...
    def __iadd__(self, other): ...

class Component2D(DiscreteComponent):
    _apienum__: Incomplete
    dimensions: int

class Component3D(DiscreteComponent):
    _apienum__: Incomplete
    dimensions: int

class MItComponent(Component):
    def __init__(self, *args, **kwargs) -> None: ...
    def __apimit__(self, alwaysUnindexed: bool = ...): ...
    def __apimfn__(self): ...

class MItComponent1D(MItComponent, Component1D): ...

class Component1D64(DiscreteComponent):
    _apienum__: Incomplete
    def totalSize(self) -> None: ...
    def __len__(self) -> int: ...
    dimensions: int

class MeshVertex(MItComponent1D):
    __apicls__: Incomplete
    _ComponentLabel__: str
    _apienum__: Incomplete
    def setColor(self, color) -> None: ...
    def connectedEdges(self) -> List[MeshEdge]: ...
    def connectedFaces(self) -> List[MeshFace]: ...
    def connectedVertices(self) -> List[MeshVertex]: ...
    def isConnectedTo(self, component: Any) -> bool: ...
    def getColor(self, *args: Any, **kwargs: Any) -> datatypes.Color: ...
    def geomChanged(self) -> None: ...
    def getColorIndices(self, colorSetName: str = ...) -> List[int]: ...
    def getColors(self, colorSetName: str = ...) -> List[datatypes.Color]: ...
    def getNormal(self, space: datatypes.Space.Space = ...) -> datatypes.Vector: ...
    def getNormalIndices(self) -> List[int]: ...
    def getNormals(self, space: datatypes.Space.Space = ...) -> List[datatypes.Vector]: ...
    def getPosition(self, space: datatypes.Space.Space = ...) -> datatypes.Point: ...
    def getUV(self, uvSet: str = ...) -> Tuple[float, float]: ...
    def getUVIndices(self, uvSet: str = ...) -> List[int]: ...
    def getUVs(self, uvSet: str = ...) -> Tuple[List[float], List[float], List[int]]: ...
    def hasColor(self) -> bool: ...
    def isConnectedToEdge(self, index: int) -> bool: ...
    def isConnectedToFace(self, index: int) -> bool: ...
    def isOnBoundary(self) -> bool: ...
    def numConnectedEdges(self) -> int: ...
    def numConnectedFaces(self) -> int: ...
    def numUVs(self, uvSet: str = ...) -> int: ...
    def setPosition(self, point: datatypes.Point, space: datatypes.Space.Space = ...) -> None: ...
    def setUV(self, uvPoint: Tuple[float, float], uvSet: str = ...) -> None: ...
    def setUVs(self, uArray: List[float], vArray: List[float], faceIds: List[int], uvSet: str = ...) -> None: ...
    def translateBy(self, vector: datatypes.Vector, space: datatypes.Space.Space = ...) -> None: ...
    def updateSurface(self) -> None: ...

class MeshEdge(MItComponent1D):
    __apicls__: Incomplete
    _ComponentLabel__: str
    _apienum__: Incomplete
    def connectedEdges(self) -> List[MeshEdge]: ...
    def connectedFaces(self) -> List[MeshFace]: ...
    def connectedVertices(self) -> Tuple[MeshVertex, MeshVertex]: ...
    def isConnectedTo(self, component: Union[MeshFace, MeshEdge, MeshVertex]) -> bool: ...
    def getLength(self, space: datatypes.Space.Space = ...) -> float: ...
    def getPoint(self, index: int, space: datatypes.Space.Space = ...) -> datatypes.Point: ...
    def isConnectedToEdge(self, index: int) -> bool: ...
    def isConnectedToFace(self, index: int) -> bool: ...
    def isOnBoundary(self) -> bool: ...
    def isSmooth(self) -> bool: ...
    def next(self) -> None: ...
    def numConnectedEdges(self) -> int: ...
    def numConnectedFaces(self) -> int: ...
    def setPoint(self, point: datatypes.Point, index: int, space: datatypes.Space.Space = ...) -> None: ...
    def setSmoothing(self, smooth: bool = ...) -> None: ...
    def updateSurface(self) -> None: ...

class MeshFace(MItComponent1D):
    __apicls__: Incomplete
    _ComponentLabel__: str
    _apienum__: Incomplete
    def connectedEdges(self) -> List[MeshEdge]: ...
    def connectedFaces(self) -> List[MeshFace]: ...
    def connectedVertices(self) -> List[MeshVertex]: ...
    def isConnectedTo(self, component: Union[MeshFace, MeshEdge, MeshVertex]) -> bool: ...
    def geomChanged(self) -> None: ...
    def getArea(self, space: datatypes.Space.Space = ...) -> float: ...
    def getAxisAtUV(self, uvPoint: Tuple[float, float], space: datatypes.Space.Space = ..., uvSet: str = ..., tolerance: float = ...) -> Tuple[datatypes.Vector, datatypes.Vector, datatypes.Vector]: ...
    def getColor(self, colorSetName: str = ...) -> datatypes.Color: ...
    def getColorIndex(self, vertexIndex: int, colorSetName: str = ...) -> int: ...
    def getColorIndices(self, colorSetName: str = ...) -> List[int]: ...
    def getColors(self, colorSetName: str = ...) -> List[datatypes.Color]: ...
    def getEdges(self) -> List[int]: ...
    def getNormal(self, space: datatypes.Space.Space = ...) -> datatypes.Vector: ...
    def getNormals(self, space: datatypes.Space.Space = ...) -> List[datatypes.Vector]: ...
    def getPoint(self, index: int, space: datatypes.Space.Space = ...) -> datatypes.Point: ...
    def getPointAtUV(self, uvPoint: Tuple[float, float], space: datatypes.Space.Space = ..., uvSet: str = ..., tolerance: float = ...) -> datatypes.Point: ...
    def getPoints(self, space: datatypes.Space.Space = ...) -> List[datatypes.Point]: ...
    def getUV(self, vertex: int, uvSet: str = ...) -> Tuple[float, float]: ...
    def getUVArea(self, uvSet: str = ...) -> float: ...
    def getUVAtPoint(self, pt: datatypes.Point, space: datatypes.Space.Space = ..., uvSet: str = ...) -> Tuple[float, float]: ...
    def getUVIndex(self, vertex: int, uvSet: str = ...) -> int: ...
    def getUVSetNames(self) -> List[str]: ...
    def getUVs(self, uvSet: str = ...) -> Tuple[List[float], List[float]]: ...
    def getVertices(self) -> List[int]: ...
    def hasColor(self) -> bool: ...
    def hasUVs(self) -> bool: ...
    def hasValidTriangulation(self) -> bool: ...
    def isConnectedToEdge(self, index: int) -> bool: ...
    def isConnectedToFace(self, index: int) -> bool: ...
    def isConnectedToVertex(self, index: int) -> bool: ...
    def isConvex(self) -> bool: ...
    def isHoled(self) -> bool: ...
    def isLamina(self) -> bool: ...
    def isOnBoundary(self) -> bool: ...
    def isPlanar(self) -> bool: ...
    def isStarlike(self) -> bool: ...
    def isUVReversed(self, uvSet: str = ...) -> bool: ...
    def isZeroArea(self) -> bool: ...
    def isZeroUVArea(self) -> bool: ...
    def normalIndex(self, localVertexIndex: int) -> int: ...
    def numColors(self, colorSetName: str = ...) -> int: ...
    def numConnectedEdges(self) -> int: ...
    def numConnectedFaces(self) -> int: ...
    def numTriangles(self) -> int: ...
    def polygonVertexCount(self) -> int: ...
    def setPoint(self, point: datatypes.Point, index: int, space: datatypes.Space.Space = ...) -> None: ...
    def setPoints(self, pointArray: List[datatypes.Point], space: datatypes.Space.Space = ...) -> None: ...
    def setUV(self, vertexId: int, uvPoint: Tuple[float, float], uvSet: str = ...) -> None: ...
    def setUVs(self, uArray: List[float], vArray: List[float], uvSet: str = ...) -> None: ...
    def updateSurface(self) -> None: ...

class MeshUV(Component1D):
    _ComponentLabel__: str
    _apienum__: Incomplete

class MeshVertexFace(Component2D):
    _ComponentLabel__: str
    _apienum__: Incomplete
    def __melobject__(self): ...
    def totalSize(self): ...

class SubdVertex(Component1D64):
    _ComponentLabel__: str
    _apienum__: Incomplete

class SubdEdge(Component1D64):
    _ComponentLabel__: str
    _apienum__: Incomplete

class SubdFace(Component1D64):
    _ComponentLabel__: str
    _apienum__: Incomplete

class SubdUV(Component1D):
    _ComponentLabel__: str
    _apienum__: Incomplete
    def totalSize(self) -> None: ...

class NurbsCurveParameter(Component1DFloat):
    _ComponentLabel__: str
    _apienum__: Incomplete

class NurbsCurveCV(MItComponent1D):
    __apicls__: Incomplete
    _ComponentLabel__: str
    _apienum__: Incomplete
    def getPosition(self, space: datatypes.Space.Space = ...) -> datatypes.Point: ...
    def hasHistoryOnCreate(self) -> bool: ...
    def isDone(self) -> bool: ...
    def next(self) -> None: ...
    def setPosition(self, pt: datatypes.Point, space: datatypes.Space.Space = ...) -> None: ...
    def translateBy(self, vec: datatypes.Vector, space: datatypes.Space.Space = ...) -> None: ...
    def updateCurve(self) -> None: ...

class NurbsCurveEP(Component1D):
    _ComponentLabel__: str
    _apienum__: Incomplete

class NurbsCurveKnot(Component1D):
    _ComponentLabel__: str
    _apienum__: Incomplete

class NurbsSurfaceIsoparm(Component2DFloat):
    _ComponentLabel__: Incomplete
    _apienum__: Incomplete
    def __init__(self, *args, **kwargs) -> None: ...

class NurbsSurfaceRange(NurbsSurfaceIsoparm):
    _ComponentLabel__: Incomplete
    _apienum__: Incomplete

class NurbsSurfaceCV(Component2D):
    _ComponentLabel__: str
    _apienum__: Incomplete

class NurbsSurfaceEP(Component2D):
    _ComponentLabel__: str
    _apienum__: Incomplete

class NurbsSurfaceKnot(Component2D):
    _ComponentLabel__: str
    _apienum__: Incomplete

class NurbsSurfaceFace(Component2D):
    _ComponentLabel__: str
    _apienum__: Incomplete

class LatticePoint(Component3D):
    _ComponentLabel__: str
    _apienum__: Incomplete

class Pivot(Component):
    _ComponentLabel__: Incomplete
    _apienum__: Incomplete

class ParticleComponent(Component1D):
    _ComponentLabel__: str
    _apienum__: Incomplete
    def attr(self, attr): ...
    def __getattr__(self, attr): ...

class AttributeSpec(PyNode):
    __apicls__: Incomplete
    def __new__(cls, *args, **kwargs): ...
    def __apiobject__(self): ...
    def __apimobject__(self): ...
    def __apimplug__(self): ...
    def __apimdagpath__(self): ...
    def name(self) -> str: ...
    def parent(self): ...
    DisconnectBehavior: Incomplete
    def accepts(self, type: nt.Data.Type) -> bool: ...
    def addToCategory(self, category: str) -> None: ...
    def getAddAttrCmd(self, useLongName: bool = ...) -> str: ...
    def getAffectsAppearance(self) -> bool: ...
    def getCategories(self) -> List[str]: ...
    def getDisconnectBehavior(self) -> nt.Attribute.DisconnectBehavior: ...
    def getIndexMatters(self) -> bool: ...
    def getInternal(self) -> bool: ...
    def getUsesArrayDataBuilder(self) -> bool: ...
    def hasCategory(self, category: str) -> bool: ...
    def isAffectsWorldSpace(self) -> bool: ...
    def isArray(self) -> bool: ...
    def isCached(self) -> bool: ...
    def isChannelBoxFlagSet(self) -> bool: ...
    def isConnectable(self) -> bool: ...
    def isDynamic(self) -> bool: ...
    def isExtension(self) -> bool: ...
    def isHidden(self) -> bool: ...
    def isIndeterminant(self) -> bool: ...
    def isKeyable(self) -> bool: ...
    def isProxyAttribute(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isRenderSource(self) -> bool: ...
    def isStorable(self) -> bool: ...
    def isUsedAsColor(self) -> bool: ...
    def isUsedAsFilename(self) -> bool: ...
    def isWorldSpace(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def removeFromCategory(self, category: str) -> None: ...
    def setAffectsAppearance(self, state: bool) -> None: ...
    def setAffectsWorldSpace(self, state: bool) -> None: ...
    def setArray(self, state: bool) -> None: ...
    def setCached(self, state: bool) -> None: ...
    def setChannelBox(self, state: bool) -> None: ...
    def setConnectable(self, state: bool) -> None: ...
    def setDisconnectBehavior(self, behavior: nt.Attribute.DisconnectBehavior) -> None: ...
    def setHidden(self, state: bool) -> None: ...
    def setIndeterminant(self, state: bool) -> None: ...
    def setIndexMatters(self, state: bool) -> None: ...
    def setInternal(self, state: bool) -> None: ...
    def setKeyable(self, state: bool) -> None: ...
    def setNiceNameOverride(self, localizedName: str) -> None: ...
    def setProxyAttribute(self, state: bool) -> None: ...
    def setReadable(self, state: bool) -> None: ...
    def setRenderSource(self, state: bool) -> None: ...
    def setStorable(self, state: bool) -> None: ...
    def setUsedAsColor(self, state: bool) -> None: ...
    def setUsedAsFilename(self, state: bool) -> None: ...
    def setUsesArrayDataBuilder(self, state: bool) -> None: ...
    def setWorldSpace(self, state: bool) -> None: ...
    def setWritable(self, state: bool) -> None: ...
    def shortName(self) -> str: ...
AttributeDefaults = AttributeSpec

class Scene:
    def __getattr__(self, obj): ...

SCENE: Incomplete
def about(*args, apiVersion: bool | int = ..., api: bool | int = ..., application: bool | int = ..., a: bool | int = ..., batch: bool | int = ..., b: bool | int = ..., buildDirectory: bool | int = ..., bd: bool | int = ..., buildVariant: bool | int = ..., bv: bool | int = ..., codeset: bool | int = ..., cs: bool | int = ..., compositingManager: bool | int = ..., cm: bool | int = ..., connected: bool | int = ..., cnt: bool | int = ..., ctime: bool | int = ..., cti: bool | int = ..., currentDate: bool | int = ..., cd: bool | int = ..., currentTime: bool | int = ..., ct: bool | int = ..., customVersion: bool | int = ..., cv: bool | int = ..., customVersionClient: bool | int = ..., cvc: bool | int = ..., customVersionMajor: bool | int = ..., cvm: bool | int = ..., customVersionMinor: bool | int = ..., cvn: bool | int = ..., customVersionString: bool | int = ..., cvs: bool | int = ..., cutIdentifier: bool | int = ..., c: bool | int = ..., date: bool | int = ..., d: bool | int = ..., environmentFile: bool | int = ..., env: bool | int = ..., evalVersion: bool | int = ..., ev: bool | int = ..., file: bool | int = ..., f: bool | int = ..., fontInfo: bool | int = ..., foi: bool | int = ..., helpDataDirectory: bool | int = ..., hdd: bool | int = ..., installedVersion: bool | int = ..., iv: bool | int = ..., ioVersion: bool | int = ..., io: bool | int = ..., irix: bool | int = ..., ir: bool | int = ..., is64: bool | int = ..., x64: bool | int = ..., languageResources: bool | int = ..., lr: bool | int = ..., linux: bool | int = ..., li: bool | int = ..., linux64: bool | int = ..., l64: bool | int = ..., liveUpdate: bool | int = ..., lu: bool | int = ..., localizedResourceLocation: bool | int = ..., lrl: bool | int = ..., ltVersion: bool | int = ..., lt: bool | int = ..., macOS: bool | int = ..., mac: bool | int = ..., macOSppc: bool | int = ..., ppc: bool | int = ..., macOSx86: bool | int = ..., x86: bool | int = ..., majorVersion: bool | int = ..., mjv: bool | int = ..., minorVersion: bool | int = ..., mnv: bool | int = ..., ntOS: bool | int = ..., nt: bool | int = ..., operatingSystem: bool | int = ..., os: bool | int = ..., operatingSystemVersion: bool | int = ..., osv: bool | int = ..., patchVersion: bool | int = ..., pv: bool | int = ..., preferences: bool | int = ..., pd: bool | int = ..., product: bool | int = ..., p: bool | int = ..., qtVersion: bool | int = ..., qt: bool | int = ..., query: bool | int = ..., q: bool | int = ..., tablet: bool | int = ..., tab: bool | int = ..., tabletMode: bool | int = ..., tm: bool | int = ..., uiLanguage: bool | int = ..., uil: bool | int = ..., uiLanguageForStartup: bool | int = ..., uis: bool | int = ..., uiLanguageIsLocalized: bool | int = ..., uii: bool | int = ..., uiLocaleLanguage: bool | int = ..., ull: bool | int = ..., version: bool | int = ..., v: bool | int = ..., win64: bool | int = ..., w64: bool | int = ..., windowManager: bool | int = ..., wm: bool | int = ..., windows: bool | int = ..., win: bool | int = ...) -> Any: ...
def addExtension(*args, attributeType: bool | int | _util.ProxyUnicode | str = ..., at: bool | int | _util.ProxyUnicode | str = ..., binaryTag: bool | int | _util.ProxyUnicode | str = ..., bt: bool | int | _util.ProxyUnicode | str = ..., cachedInternally: bool | int = ..., ci: bool | int = ..., category: bool | int | str | List[str] = ..., ct: bool | int | str | List[str] = ..., dataType: bool | int | str | List[str] = ..., dt: bool | int | str | List[str] = ..., defaultValue: bool | int | float = ..., dv: bool | int | float = ..., disconnectBehaviour: bool | int | int = ..., dcb: bool | int | int = ..., edit: bool | int = ..., e: bool | int = ..., enumName: bool | int | _util.ProxyUnicode | str = ..., en: bool | int | _util.ProxyUnicode | str = ..., exists: bool | int = ..., ex: bool | int = ..., fromPlugin: bool | int = ..., fp: bool | int = ..., hasMaxValue: bool | int = ..., hxv: bool | int = ..., hasMinValue: bool | int = ..., hnv: bool | int = ..., hasSoftMaxValue: bool | int = ..., hsx: bool | int = ..., hasSoftMinValue: bool | int = ..., hsn: bool | int = ..., hidden: bool | int = ..., h: bool | int = ..., indexMatters: bool | int = ..., im: bool | int = ..., internalSet: bool | int = ..., keyable: bool | int = ..., k: bool | int = ..., longName: bool | int | _util.ProxyUnicode | str = ..., ln: bool | int | _util.ProxyUnicode | str = ..., maxValue: bool | int | float = ..., max: bool | int | float = ..., minValue: bool | int | float = ..., min: bool | int | float = ..., multi: bool | int = ..., m: bool | int = ..., niceName: bool | int | _util.ProxyUnicode | str = ..., nn: bool | int | _util.ProxyUnicode | str = ..., nodeType: bool | int | _util.ProxyUnicode | str = ..., nt: bool | int | _util.ProxyUnicode | str = ..., numberOfChildren: bool | int | int = ..., nc: bool | int | int = ..., parent: bool | int | _util.ProxyUnicode | str = ..., p: bool | int | _util.ProxyUnicode | str = ..., proxy: bool | int | _util.ProxyUnicode | str = ..., pxy: bool | int | _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., readable: bool | int = ..., r: bool | int = ..., shortName: bool | int | _util.ProxyUnicode | str = ..., sn: bool | int | _util.ProxyUnicode | str = ..., softMaxValue: bool | int | float = ..., smx: bool | int | float = ..., softMinValue: bool | int | float = ..., smn: bool | int | float = ..., storable: bool | int = ..., s: bool | int = ..., usedAsColor: bool | int = ..., uac: bool | int = ..., usedAsFilename: bool | int = ..., uaf: bool | int = ..., usedAsProxy: bool | int = ..., uap: bool | int = ..., worldSpace: bool | int = ..., ws: bool | int = ..., writable: bool | int = ..., w: bool | int = ...) -> Any: ...
def affectedNet(*args, edit: bool | int = ..., e: bool | int = ..., query: bool | int = ..., q: bool | int = ..., type: _util.ProxyUnicode | str = ..., t: _util.ProxyUnicode | str = ...) -> Any: ...
def affects(*args, by: Any = ..., boolean: Any = ..., type: _util.ProxyUnicode | str = ..., t: _util.ProxyUnicode | str = ...) -> Any: ...
def aliasAttr(*args, edit: bool | int = ..., e: bool | int = ..., query: bool | int = ..., q: bool | int = ..., remove: bool | int = ..., rm: bool | int = ...) -> Any: ...
def align(*args, alignToLead: bool | int = ..., atl: bool | int = ..., coordinateSystem: PyNode | str = ..., cs: PyNode | str = ..., xAxis: _util.ProxyUnicode | str = ..., x: _util.ProxyUnicode | str = ..., yAxis: _util.ProxyUnicode | str = ..., y: _util.ProxyUnicode | str = ..., zAxis: _util.ProxyUnicode | str = ..., z: _util.ProxyUnicode | str = ...) -> Any: ...
def applyAttrPattern(*args, nodeType: _util.ProxyUnicode | str = ..., nt: _util.ProxyUnicode | str = ..., patternName: _util.ProxyUnicode | str = ..., pn: _util.ProxyUnicode | str = ...) -> Any: ...
def artAttrTool(*args, add: Any = ..., string: Any = ..., exists: bool | int | _util.ProxyUnicode | str = ..., ex: bool | int | _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., remove: _util.ProxyUnicode | str = ..., rm: _util.ProxyUnicode | str = ...) -> Any: ...

def assembly(*args, active: bool | int | _util.ProxyUnicode | str = ..., a: bool | int | _util.ProxyUnicode | str = ..., activeLabel: bool | int | _util.ProxyUnicode | str = ..., al: bool | int | _util.ProxyUnicode | str = ..., canCreate: bool | int | _util.ProxyUnicode | str = ..., cc: bool | int | _util.ProxyUnicode | str = ..., createOptionBoxProc: bool | int | str | Callable = ..., cob: bool | int | str | Callable = ..., createRepresentation: _util.ProxyUnicode | str = ..., cr: _util.ProxyUnicode | str = ..., defaultType: bool | int | _util.ProxyUnicode | str = ..., dt: bool | int | _util.ProxyUnicode | str = ..., deleteRepresentation: _util.ProxyUnicode | str = ..., dr: _util.ProxyUnicode | str = ..., deregister: _util.ProxyUnicode | str = ..., d: _util.ProxyUnicode | str = ..., edit: bool | int = ..., e: bool | int = ..., input: _util.ProxyUnicode | str = ..., isAType: bool | int | _util.ProxyUnicode | str = ..., isa: bool | int | _util.ProxyUnicode | str = ..., isTrackingMemberEdits: bool | int | _util.ProxyUnicode | str = ..., ite: bool | int | _util.ProxyUnicode | str = ..., label: bool | int | _util.ProxyUnicode | str = ..., lbl: bool | int | _util.ProxyUnicode | str = ..., listRepTypes: bool | int = ..., lrt: bool | int = ..., listRepTypesProc: bool | int | str | Callable = ..., lrp: bool | int | str | Callable = ..., listRepresentations: bool | int = ..., lr: bool | int = ..., listTypes: bool | int = ..., lt: bool | int = ..., name: _util.ProxyUnicode | str = ..., n: _util.ProxyUnicode | str = ..., newRepLabel: _util.ProxyUnicode | str = ..., nrl: _util.ProxyUnicode | str = ..., postCreateUIProc: bool | int | str | Callable = ..., aoc: bool | int | str | Callable = ..., proc: str | Callable = ..., prc: str | Callable = ..., query: bool | int = ..., q: bool | int = ..., renameRepresentation: _util.ProxyUnicode | str = ..., rnr: _util.ProxyUnicode | str = ..., repLabel: bool | int | _util.ProxyUnicode | str = ..., rl: bool | int | _util.ProxyUnicode | str = ..., repName: _util.ProxyUnicode | str = ..., rnm: _util.ProxyUnicode | str = ..., repNamespace: bool | int | _util.ProxyUnicode | str = ..., rns: bool | int | _util.ProxyUnicode | str = ..., repPostCreateUIProc: bool | int | _util.ProxyUnicode | str = ..., poc: bool | int | _util.ProxyUnicode | str = ..., repPreCreateUIProc: bool | int | _util.ProxyUnicode | str = ..., pec: bool | int | _util.ProxyUnicode | str = ..., repType: bool | int | _util.ProxyUnicode | str = ..., rt: bool | int | _util.ProxyUnicode | str = ..., repTypeLabel: bool | int | _util.ProxyUnicode | str = ..., rtl: bool | int | _util.ProxyUnicode | str = ..., repTypeLabelProc: bool | int | str | Callable = ..., rtp: bool | int | str | Callable = ..., type: bool | int | _util.ProxyUnicode | str = ..., typ: bool | int | _util.ProxyUnicode | str = ...): ...

def attributeInfo(*args, allAttributes: bool | int = ..., all: bool | int = ..., bool: bool | int = ..., b: bool | int = ..., enumerated: bool | int = ..., e: bool | int = ..., hidden: bool | int = ..., h: bool | int = ..., inherited: bool | int = ..., internal: bool | int = ..., i: bool | int = ..., leaf: bool | int = ..., l: bool | int = ..., logicalAnd: bool | int = ..., multi: bool | int = ..., m: bool | int = ..., short: bool | int = ..., s: bool | int = ..., type: _util.ProxyUnicode | str = ..., t: _util.ProxyUnicode | str = ..., userInterface: bool | int = ..., ui: bool | int = ..., writable: bool | int = ..., w: bool | int = ...) -> Any: ...
def attributeName(*args, leaf: bool | int = ..., lf: bool | int = ..., long: bool | int = ..., l: bool | int = ..., nice: bool | int = ..., n: bool | int = ..., short: bool | int = ..., s: bool | int = ...) -> Any: ...
def attributeQuery(*args, affectsAppearance: bool | int = ..., aa: bool | int = ..., affectsWorldspace: bool | int = ..., aws: bool | int = ..., attributeType: bool | int = ..., at: bool | int = ..., cachedInternally: bool | int = ..., ci: bool | int = ..., categories: bool | int = ..., ct: bool | int = ..., channelBox: bool | int = ..., ch: bool | int = ..., connectable: bool | int = ..., c: bool | int = ..., enum: bool | int = ..., e: bool | int = ..., exists: bool | int = ..., ex: bool | int = ..., hidden: bool | int = ..., h: bool | int = ..., indeterminant: bool | int = ..., idt: bool | int = ..., indexMatters: bool | int = ..., im: bool | int = ..., internal: bool | int = ..., i: bool | int = ..., internalGet: bool | int = ..., ig: bool | int = ..., internalSet: bool | int = ..., keyable: bool | int = ..., k: bool | int = ..., listChildren: bool | int = ..., lc: bool | int = ..., listDefault: bool | int = ..., ld: bool | int = ..., listEnum: bool | int = ..., le: bool | int = ..., listParent: bool | int = ..., lp: bool | int = ..., listSiblings: bool | int = ..., ls: bool | int = ..., localizedListEnum: bool | int = ..., lz: bool | int = ..., longName: bool | int = ..., ln: bool | int = ..., maxExists: bool | int = ..., mxe: bool | int = ..., maximum: bool | int = ..., max: bool | int = ..., message: bool | int = ..., msg: bool | int = ..., minExists: bool | int = ..., mne: bool | int = ..., minimum: bool | int = ..., min: bool | int = ..., multi: bool | int = ..., m: bool | int = ..., niceName: bool | int = ..., nn: bool | int = ..., node: PyNode | str = ..., n: PyNode | str = ..., numberOfChildren: bool | int = ..., nc: bool | int = ..., range: bool | int = ..., r: bool | int = ..., rangeExists: bool | int = ..., re: bool | int = ..., readable: bool | int = ..., rd: bool | int = ..., renderSource: bool | int = ..., rs: bool | int = ..., shortName: bool | int = ..., sn: bool | int = ..., softMax: bool | int = ..., smx: bool | int = ..., softMaxExists: bool | int = ..., sxe: bool | int = ..., softMin: bool | int = ..., smn: bool | int = ..., softMinExists: bool | int = ..., sme: bool | int = ..., softRange: bool | int = ..., s: bool | int = ..., softRangeExists: bool | int = ..., se: bool | int = ..., storable: bool | int = ..., st: bool | int = ..., type: _util.ProxyUnicode | str = ..., typ: _util.ProxyUnicode | str = ..., typeExact: _util.ProxyUnicode | str = ..., tex: _util.ProxyUnicode | str = ..., usedAsColor: bool | int = ..., uac: bool | int = ..., usedAsFilename: bool | int = ..., uaf: bool | int = ..., usesMultiBuilder: bool | int = ..., umb: bool | int = ..., worldspace: bool | int = ..., ws: bool | int = ..., writable: bool | int = ..., w: bool | int = ...) -> Any: ...
def bakePartialHistory(*args, allShapes: bool | int = ..., all: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., postSmooth: bool | int = ..., nps: bool | int = ..., preCache: bool | int = ..., pc: bool | int = ..., preDeformers: bool | int = ..., pre: bool | int = ..., prePostDeformers: bool | int = ..., ppt: bool | int = ..., query: bool | int = ..., q: bool | int = ...) -> Any: ...
def baseTemplate(*args, edit: bool | int = ..., e: bool | int = ..., exists: bool | int = ..., ex: bool | int = ..., fileName: bool | int | _util.ProxyUnicode | str = ..., fn: bool | int | _util.ProxyUnicode | str = ..., force: bool | int = ..., f: bool | int = ..., load: bool | int = ..., l: bool | int = ..., matchFile: bool | int | _util.ProxyUnicode | str = ..., mf: bool | int | _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., silent: bool | int = ..., si: bool | int = ..., unload: bool | int = ..., u: bool | int = ..., viewList: bool | int | _util.ProxyUnicode | str = ..., vl: bool | int | _util.ProxyUnicode | str = ...) -> Any: ...
def baseView(*args, edit: bool | int = ..., e: bool | int = ..., itemInfo: bool | int | _util.ProxyUnicode | str = ..., ii: bool | int | _util.ProxyUnicode | str = ..., itemList: bool | int = ..., il: bool | int = ..., query: bool | int = ..., q: bool | int = ..., viewDescription: bool | int = ..., vd: bool | int = ..., viewLabel: bool | int = ..., vb: bool | int = ..., viewList: bool | int = ..., vl: bool | int = ..., viewName: bool | int | _util.ProxyUnicode | str = ..., vn: bool | int | _util.ProxyUnicode | str = ...) -> Any: ...
def color(*args, rgbColor: Tuple[float, float, float] = ..., rgb: Tuple[float, float, float] = ..., userDefined: int = ..., ud: int = ...) -> Any: ...
def colorIndex(*args, hueSaturationValue: bool | int = ..., hsv: bool | int = ..., query: bool | int = ..., q: bool | int = ..., resetToFactory: bool | int = ..., rf: bool | int = ..., resetToSaved: bool | int = ..., rs: bool | int = ...) -> Any: ...
def colorManagementCatalog(*args, addTransform: _util.ProxyUnicode | str = ..., adt: _util.ProxyUnicode | str = ..., editUserTransformPath: _util.ProxyUnicode | str = ..., eut: _util.ProxyUnicode | str = ..., listSupportedExtensions: bool | int = ..., lse: bool | int = ..., listTransformConnections: bool | int = ..., ltc: bool | int = ..., path: _util.ProxyUnicode | str = ..., pth: _util.ProxyUnicode | str = ..., queryUserTransformPath: bool | int = ..., qut: bool | int = ..., removeTransform: _util.ProxyUnicode | str = ..., rmt: _util.ProxyUnicode | str = ..., transformConnection: _util.ProxyUnicode | str = ..., tcn: _util.ProxyUnicode | str = ..., type: _util.ProxyUnicode | str = ..., typ: _util.ProxyUnicode | str = ...) -> Any: ...
def colorManagementConvert(*args, toDisplaySpace: Tuple[float, float, float] = ..., tds: Tuple[float, float, float] = ...) -> Any: ...
def colorManagementFileRules(*args, addRule: _util.ProxyUnicode | str = ..., add: _util.ProxyUnicode | str = ..., colorSpace: bool | int | _util.ProxyUnicode | str = ..., cs: bool | int | _util.ProxyUnicode | str = ..., colorSpaceDescription: bool | int | _util.ProxyUnicode | str = ..., csd: bool | int | _util.ProxyUnicode | str = ..., colorSpaceFamilies: bool | int | _util.ProxyUnicode | str = ..., csf: bool | int | _util.ProxyUnicode | str = ..., colorSpaceNames: bool | int = ..., csn: bool | int = ..., down: _util.ProxyUnicode | str = ..., dwn: _util.ProxyUnicode | str = ..., edit: bool | int = ..., e: bool | int = ..., enabled: bool | int = ..., ena: bool | int = ..., evaluate: _util.ProxyUnicode | str = ..., ev: _util.ProxyUnicode | str = ..., extension: bool | int | _util.ProxyUnicode | str = ..., ext: bool | int | _util.ProxyUnicode | str = ..., listRules: bool | int = ..., lsr: bool | int = ..., load: bool | int = ..., ld: bool | int = ..., moveUp: _util.ProxyUnicode | str = ..., up: _util.ProxyUnicode | str = ..., pattern: bool | int | _util.ProxyUnicode | str = ..., pat: bool | int | _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., remove: _util.ProxyUnicode | str = ..., rm: _util.ProxyUnicode | str = ..., restoreDefaults: bool | int = ..., rde: bool | int = ..., save: bool | int = ..., sav: bool | int = ...) -> Any: ...
def colorManagementPrefs(*args, cmConfigFileEnabled: bool | int = ..., cfe: bool | int = ..., cmEnabled: bool | int = ..., cme: bool | int = ..., colorManageAllNodes: bool | int = ..., cma: bool | int = ..., colorManagePots: bool | int = ..., cmp: bool | int = ..., colorManagedNodes: bool | int = ..., cmn: bool | int = ..., colorManagementSDKVersion: bool | int | _util.ProxyUnicode | str = ..., cmv: bool | int | _util.ProxyUnicode | str = ..., configFilePath: bool | int | _util.ProxyUnicode | str = ..., cfp: bool | int | _util.ProxyUnicode | str = ..., configFileVersion: bool | int | _util.ProxyUnicode | str = ..., cfv: bool | int | _util.ProxyUnicode | str = ..., defaultInputSpaceName: bool | int | _util.ProxyUnicode | str = ..., din: bool | int | _util.ProxyUnicode | str = ..., displayName: bool | int | _util.ProxyUnicode | str = ..., dn: bool | int | _util.ProxyUnicode | str = ..., displayNames: bool | int = ..., dns: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., equalsToPolicyFile: bool | int | _util.ProxyUnicode | str = ..., etp: bool | int | _util.ProxyUnicode | str = ..., exportPolicy: _util.ProxyUnicode | str = ..., epy: _util.ProxyUnicode | str = ..., inhibitEvents: bool | int = ..., ie: bool | int = ..., inputSpaceDescription: bool | int | _util.ProxyUnicode | str = ..., isd: bool | int | _util.ProxyUnicode | str = ..., inputSpaceFamilies: bool | int | _util.ProxyUnicode | str = ..., isf: bool | int | _util.ProxyUnicode | str = ..., inputSpaceNames: bool | int = ..., iss: bool | int = ..., loadPolicy: _util.ProxyUnicode | str = ..., lpy: _util.ProxyUnicode | str = ..., loadedDefaultInputSpaceName: bool | int | _util.ProxyUnicode | str = ..., ldn: bool | int | _util.ProxyUnicode | str = ..., loadedDisplayName: bool | int | _util.ProxyUnicode | str = ..., ld: bool | int | _util.ProxyUnicode | str = ..., loadedOutputTransformName: bool | int | _util.ProxyUnicode | str = ..., lon: bool | int | _util.ProxyUnicode | str = ..., loadedRenderingSpaceName: bool | int | _util.ProxyUnicode | str = ..., lrn: bool | int | _util.ProxyUnicode | str = ..., loadedViewName: bool | int | _util.ProxyUnicode | str = ..., lv: bool | int | _util.ProxyUnicode | str = ..., loadedViewTransformName: bool | int | _util.ProxyUnicode | str = ..., lvn: bool | int | _util.ProxyUnicode | str = ..., missingColorSpaceNodes: bool | int = ..., mcn: bool | int = ..., ocioRulesEnabled: bool | int = ..., ore: bool | int = ..., ociov2Enabled: bool | int = ..., oci: bool | int = ..., outputTarget: bool | int | _util.ProxyUnicode | str = ..., ott: bool | int | _util.ProxyUnicode | str = ..., outputTransformEnabled: bool | int = ..., ote: bool | int = ..., outputTransformName: bool | int | _util.ProxyUnicode | str = ..., otn: bool | int | _util.ProxyUnicode | str = ..., outputTransformNames: bool | int = ..., ots: bool | int = ..., outputTransformUseColorConversion: bool | int = ..., otc: bool | int = ..., outputUseViewTransform: bool | int = ..., ovt: bool | int = ..., policyFileName: bool | int | _util.ProxyUnicode | str = ..., pfn: bool | int | _util.ProxyUnicode | str = ..., popupOnError: bool | int = ..., poe: bool | int = ..., query: bool | int = ..., q: bool | int = ..., refresh: bool | int = ..., rfr: bool | int = ..., renderingSpaceName: bool | int | _util.ProxyUnicode | str = ..., rsn: bool | int | _util.ProxyUnicode | str = ..., renderingSpaceNames: bool | int = ..., rss: bool | int = ..., restoreDefaults: bool | int = ..., rde: bool | int = ..., viewName: bool | int | _util.ProxyUnicode | str = ..., vn: bool | int | _util.ProxyUnicode | str = ..., viewNames: bool | int = ..., vns: bool | int = ..., viewTransformName: bool | int | _util.ProxyUnicode | str = ..., vtn: bool | int | _util.ProxyUnicode | str = ..., viewTransformNames: bool | int = ..., vts: bool | int = ...) -> Any: ...

def commandLogging(*args, historySize: bool | int | int = ..., hs: bool | int | int = ..., logCommands: bool | int = ..., lc: bool | int = ..., logFile: bool | int | _util.ProxyUnicode | str = ..., lf: bool | int | _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., recordCommands: bool | int = ..., rc: bool | int = ..., resetLogFile: bool | int = ..., rl: bool | int = ...): ...
def commandPort(*args, bufferSize: int = ..., bs: int = ..., close: bool | int = ..., cl: bool | int = ..., echoOutput: bool | int = ..., eo: bool | int = ..., listPorts: bool | int = ..., lp: bool | int = ..., name: _util.ProxyUnicode | str = ..., n: _util.ProxyUnicode | str = ..., noreturn: bool | int = ..., nr: bool | int = ..., outputVar: _util.ProxyUnicode | str = ..., o: _util.ProxyUnicode | str = ..., pickleOutput: bool | int = ..., po: bool | int = ..., prefix: _util.ProxyUnicode | str = ..., pre: _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., returnNumCommands: bool | int = ..., rnc: bool | int = ..., securityWarning: bool | int = ..., sw: bool | int = ..., sourceType: _util.ProxyUnicode | str = ..., stp: _util.ProxyUnicode | str = ...): ...

def connectionInfo(*args, destinationFromSource: bool | int = ..., dfs: bool | int = ..., getExactDestination: bool | int = ..., ged: bool | int = ..., getExactSource: bool | int = ..., ges: bool | int = ..., getLockedAncestor: bool | int = ..., gla: bool | int = ..., isDestination: bool | int = ..., id: bool | int = ..., isExactDestination: bool | int = ..., ied: bool | int = ..., isExactSource: bool | int = ..., ies: bool | int = ..., isLocked: bool | int = ..., il: bool | int = ..., isSource: bool | int = ..., sourceFromDestination: bool | int = ..., sfd: bool | int = ...) -> Any: ...

def container(*args, addNode: _util.ProxyUnicode | str = ..., an: _util.ProxyUnicode | str = ..., asset: bool | int | _util.ProxyUnicode | str = ..., a: bool | int | _util.ProxyUnicode | str = ..., assetMember: bool | int | _util.ProxyUnicode | str = ..., am: bool | int | _util.ProxyUnicode | str = ..., bindAttr: bool | int | Tuple[str, str] = ..., ba: bool | int | Tuple[str, str] = ..., connectionList: bool | int = ..., cl: bool | int = ..., current: bool | int = ..., c: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., fileName: bool | int | _util.ProxyUnicode | str = ..., fn: bool | int | _util.ProxyUnicode | str = ..., findContainer: bool | int | _util.ProxyUnicode | str = ..., fc: bool | int | _util.ProxyUnicode | str = ..., force: bool | int = ..., f: bool | int = ..., includeHierarchyAbove: bool | int = ..., iha: bool | int = ..., includeHierarchyBelow: bool | int = ..., ihb: bool | int = ..., includeNetwork: bool | int = ..., inc: bool | int = ..., includeNetworkDetails: str | List[str] = ..., ind: str | List[str] = ..., includeShaders: bool | int = ..., isd: bool | int = ..., includeShapes: bool | int = ..., ish: bool | int = ..., includeTransform: bool | int = ..., it: bool | int = ..., isContainer: bool | int = ..., isc: bool | int = ..., name: _util.ProxyUnicode | str = ..., n: _util.ProxyUnicode | str = ..., nodeList: bool | int = ..., nl: bool | int = ..., nodeNamePrefix: bool | int = ..., nnp: bool | int = ..., parentContainer: bool | int = ..., par: bool | int = ..., preview: bool | int = ..., p: bool | int = ..., publishAndBind: Tuple[str, str] = ..., pb: Tuple[str, str] = ..., publishAsChild: bool | int | Tuple[str, str] = ..., pac: bool | int | Tuple[str, str] = ..., publishAsParent: bool | int | Tuple[str, str] = ..., pap: bool | int | Tuple[str, str] = ..., publishAsRoot: bool | int | Tuple[str, bool | int] = ..., pro: bool | int | Tuple[str, bool | int] = ..., publishAttr: bool | int | _util.ProxyUnicode | str = ..., pa: bool | int | _util.ProxyUnicode | str = ..., publishConnections: bool | int = ..., pc: bool | int = ..., publishName: bool | int | _util.ProxyUnicode | str = ..., pn: bool | int | _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., removeContainer: bool | int = ..., rc: bool | int = ..., removeNode: _util.ProxyUnicode | str = ..., rn: _util.ProxyUnicode | str = ..., type: bool | int | _util.ProxyUnicode | str = ..., typ: bool | int | _util.ProxyUnicode | str = ..., unbindAndUnpublish: _util.ProxyUnicode | str = ..., ubp: _util.ProxyUnicode | str = ..., unbindAttr: bool | int | Tuple[str, str] = ..., ua: bool | int | Tuple[str, str] = ..., unbindChild: _util.ProxyUnicode | str = ..., unc: _util.ProxyUnicode | str = ..., unbindParent: _util.ProxyUnicode | str = ..., unp: _util.ProxyUnicode | str = ..., unpublishChild: _util.ProxyUnicode | str = ..., upc: _util.ProxyUnicode | str = ..., unpublishName: _util.ProxyUnicode | str = ..., un: _util.ProxyUnicode | str = ..., unpublishParent: _util.ProxyUnicode | str = ..., upp: _util.ProxyUnicode | str = ..., unsortedOrder: bool | int = ..., uso: bool | int = ...): ...

def containerBind(*args, allNames: bool | int = ..., all: bool | int = ..., bindingSet: bool | int | _util.ProxyUnicode | str = ..., bs: bool | int | _util.ProxyUnicode | str = ..., bindingSetConditions: bool | int = ..., bsc: bool | int = ..., bindingSetList: bool | int = ..., bsl: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., force: bool | int = ..., f: bool | int = ..., preview: bool | int = ..., p: bool | int = ..., query: bool | int = ..., q: bool | int = ...) -> Any: ...
def containerProxy(*args, edit: bool | int = ..., e: bool | int = ..., fromTemplate: _util.ProxyUnicode | str = ..., ft: _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., type: _util.ProxyUnicode | str = ..., typ: _util.ProxyUnicode | str = ...) -> Any: ...
def containerPublish(*args, bindNode: bool | int | Tuple[str, str] = ..., bn: bool | int | Tuple[str, str] = ..., bindTemplateStandins: bool | int = ..., bts: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., inConnections: bool | int = ..., ic: bool | int = ..., mergeShared: bool | int = ..., ms: bool | int = ..., outConnections: bool | int = ..., oc: bool | int = ..., publishNode: bool | int | Tuple[str, str] = ..., pn: bool | int | Tuple[str, str] = ..., query: bool | int = ..., q: bool | int = ..., unbindNode: bool | int | _util.ProxyUnicode | str = ..., ubn: bool | int | _util.ProxyUnicode | str = ..., unpublishNode: bool | int | _util.ProxyUnicode | str = ..., upn: bool | int | _util.ProxyUnicode | str = ...) -> Any: ...
def containerTemplate(*args, addBindingSet: _util.ProxyUnicode | str = ..., abs: _util.ProxyUnicode | str = ..., addNames: bool | int = ..., an: bool | int = ..., addView: _util.ProxyUnicode | str = ..., av: _util.ProxyUnicode | str = ..., allKeyable: bool | int = ..., ak: bool | int = ..., attribute: str | List[str] = ..., at: str | List[str] = ..., attributeList: bool | int | _util.ProxyUnicode | str = ..., al: bool | int | _util.ProxyUnicode | str = ..., baseName: bool | int | _util.ProxyUnicode | str = ..., bn: bool | int | _util.ProxyUnicode | str = ..., bindingSetList: bool | int | _util.ProxyUnicode | str = ..., bsl: bool | int | _util.ProxyUnicode | str = ..., childAnchor: bool | int = ..., can: bool | int = ..., delete: bool | int = ..., d: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., exists: bool | int = ..., ex: bool | int = ..., expandCompounds: bool | int = ..., ec: bool | int = ..., fileName: bool | int | _util.ProxyUnicode | str = ..., fn: bool | int | _util.ProxyUnicode | str = ..., force: bool | int = ..., f: bool | int = ..., fromContainer: _util.ProxyUnicode | str = ..., fc: _util.ProxyUnicode | str = ..., fromSelection: bool | int = ..., fs: bool | int = ..., layoutMode: int = ..., lm: int = ..., load: bool | int = ..., l: bool | int = ..., matchFile: bool | int | _util.ProxyUnicode | str = ..., mf: bool | int | _util.ProxyUnicode | str = ..., matchName: bool | int | _util.ProxyUnicode | str = ..., mn: bool | int | _util.ProxyUnicode | str = ..., parentAnchor: bool | int = ..., pan: bool | int = ..., publishedNodeList: bool | int | _util.ProxyUnicode | str = ..., pnl: bool | int | _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., removeBindingSet: _util.ProxyUnicode | str = ..., rbs: _util.ProxyUnicode | str = ..., removeView: _util.ProxyUnicode | str = ..., rv: _util.ProxyUnicode | str = ..., rootTransform: bool | int = ..., rtn: bool | int = ..., save: bool | int = ..., s: bool | int = ..., searchPath: bool | int | _util.ProxyUnicode | str = ..., sp: bool | int | _util.ProxyUnicode | str = ..., silent: bool | int = ..., si: bool | int = ..., templateList: bool | int | _util.ProxyUnicode | str = ..., tl: bool | int | _util.ProxyUnicode | str = ..., unload: bool | int = ..., u: bool | int = ..., updateBindingSet: _util.ProxyUnicode | str = ..., ubs: _util.ProxyUnicode | str = ..., useHierarchy: bool | int = ..., uh: bool | int = ..., viewList: bool | int | _util.ProxyUnicode | str = ..., vl: bool | int | _util.ProxyUnicode | str = ...) -> Any: ...
def containerView(*args, edit: bool | int = ..., e: bool | int = ..., itemInfo: bool | int | _util.ProxyUnicode | str = ..., ii: bool | int | _util.ProxyUnicode | str = ..., itemList: bool | int = ..., il: bool | int = ..., query: bool | int = ..., q: bool | int = ..., viewDescription: bool | int = ..., vd: bool | int = ..., viewLabel: bool | int = ..., vb: bool | int = ..., viewList: bool | int = ..., vl: bool | int = ..., viewName: bool | int | _util.ProxyUnicode | str = ..., vn: bool | int | _util.ProxyUnicode | str = ...) -> Any: ...
def contextInfo(*args, apiImage1: _util.ProxyUnicode | str = ..., ip1: _util.ProxyUnicode | str = ..., c: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., escapeContext: bool | int = ..., esc: bool | int = ..., exists: bool | int = ..., ex: bool | int = ..., image1: bool | int = ..., i1: bool | int = ..., image2: bool | int = ..., i2: bool | int = ..., image3: bool | int = ..., i3: bool | int = ..., query: bool | int = ..., q: bool | int = ..., title: bool | int = ..., t: bool | int = ...) -> Any: ...
def copyAttr(*args, attribute: str | List[str] = ..., at: str | List[str] = ..., containerParentChild: bool | int = ..., cpc: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., inConnections: bool | int = ..., ic: bool | int = ..., keepSourceConnections: bool | int = ..., ksc: bool | int = ..., outConnections: bool | int = ..., oc: bool | int = ..., query: bool | int = ..., q: bool | int = ..., renameTargetContainer: bool | int = ..., rtc: bool | int = ..., values: bool | int = ..., v: bool | int = ...) -> Any: ...
def createAttrPatterns(*args, patternDefinition: _util.ProxyUnicode | str = ..., pd: _util.ProxyUnicode | str = ..., patternFile: _util.ProxyUnicode | str = ..., pf: _util.ProxyUnicode | str = ..., patternType: _util.ProxyUnicode | str = ..., pt: _util.ProxyUnicode | str = ...) -> Any: ...

def createDisplayLayer(*args, empty: bool | int = ..., e: bool | int = ..., makeCurrent: bool | int = ..., mc: bool | int = ..., name: _util.ProxyUnicode | str = ..., n: _util.ProxyUnicode | str = ..., noRecurse: bool | int = ..., nr: bool | int = ..., number: int = ..., num: int = ...): ...

def currentUnit(*args, angle: bool | int | _util.ProxyUnicode | str = ..., a: bool | int | _util.ProxyUnicode | str = ..., fullName: bool | int = ..., f: bool | int = ..., linear: bool | int | _util.ProxyUnicode | str = ..., l: bool | int | _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., time: bool | int | _util.ProxyUnicode | str = ..., t: bool | int | _util.ProxyUnicode | str = ..., updateAnimation: bool | int = ..., ua: bool | int = ...) -> Any: ...
def cycleCheck(*args, all: bool | int = ..., children: bool | int = ..., c: bool | int = ..., dag: bool | int = ..., evaluation: bool | int = ..., e: bool | int = ..., firstCycleOnly: bool | int = ..., fco: bool | int = ..., firstPlugPerNode: bool | int = ..., fpn: bool | int = ..., lastPlugPerNode: bool | int = ..., lpn: bool | int = ..., list: bool | int = ..., l: bool | int = ..., listSeparator: _util.ProxyUnicode | str = ..., ls: _util.ProxyUnicode | str = ..., parents: bool | int = ..., p: bool | int = ..., query: bool | int = ..., q: bool | int = ..., secondary: bool | int = ..., s: bool | int = ..., timeLimit: int | float = ..., tl: int | float = ...) -> Any: ...
def deleteAttr(*args, attribute: _util.ProxyUnicode | str = ..., at: _util.ProxyUnicode | str = ..., edit: bool | int = ..., e: bool | int = ..., query: bool | int = ..., q: bool | int = ...) -> Any: ...
def deleteAttrPattern(*args, allPatterns: bool | int = ..., all: bool | int = ..., patternName: _util.ProxyUnicode | str = ..., pn: _util.ProxyUnicode | str = ..., patternType: _util.ProxyUnicode | str = ..., pt: _util.ProxyUnicode | str = ...) -> Any: ...
def deleteExtension(*args, attribute: _util.ProxyUnicode | str = ..., at: _util.ProxyUnicode | str = ..., forceDelete: bool | int = ..., fd: bool | int = ..., nodeType: _util.ProxyUnicode | str = ..., nt: _util.ProxyUnicode | str = ...) -> Any: ...
def displayAffected(*args, query: bool | int = ..., q: bool | int = ...) -> Any: ...
def displayColor(*args, active: bool | int = ..., a: bool | int = ..., create: bool | int = ..., c: bool | int = ..., dormant: bool | int = ..., d: bool | int = ..., list: bool | int = ..., l: bool | int = ..., query: bool | int = ..., q: bool | int = ..., queryIndex: int = ..., qi: int = ..., resetToFactory: bool | int = ..., rf: bool | int = ..., resetToSaved: bool | int = ..., rs: bool | int = ...) -> Any: ...
def displayCull(*args, backFaceCulling: bool | int = ..., bfc: bool | int = ..., query: bool | int = ..., q: bool | int = ...) -> Any: ...
def displayLevelOfDetail(*args, levelOfDetail: bool | int = ..., lod: bool | int = ..., query: bool | int = ..., q: bool | int = ...) -> Any: ...
def displayPref(*args, activeObjectPivots: bool | int = ..., aop: bool | int = ..., defaultFontSize: int = ..., dfs: int = ..., displayAffected: bool | int = ..., da: bool | int = ..., displayGradient: bool | int = ..., dgr: bool | int = ..., fontSettingMode: int = ..., fm: int = ..., ghostFrames: bool | int | Tuple[int, int, int] = ..., gf: bool | int | Tuple[int, int, int] = ..., lineWidth: float = ..., lw: float = ..., materialLoadingMode: bool | int | _util.ProxyUnicode | str = ..., mld: bool | int | _util.ProxyUnicode | str = ..., maxHardwareTextureResolution: bool | int = ..., mhr: bool | int = ..., maxTextureResolution: bool | int | int = ..., mtr: bool | int | int = ..., purgeExistingTextures: bool | int = ..., pet: bool | int = ..., query: bool | int = ..., q: bool | int = ..., regionOfEffect: bool | int = ..., roe: bool | int = ..., shadeTemplates: bool | int = ..., st: bool | int = ..., smallFontSize: int = ..., sfs: int = ..., textureDrawPixel: bool | int = ..., tdp: bool | int = ..., wireframeOnShadedActive: bool | int | _util.ProxyUnicode | str = ..., wsa: bool | int | _util.ProxyUnicode | str = ...) -> Any: ...
def displayRGBColor(*args, create: bool | int = ..., c: bool | int = ..., hueSaturationValue: bool | int = ..., hsv: bool | int = ..., list: bool | int = ..., l: bool | int = ..., query: bool | int = ..., q: bool | int = ..., resetToFactory: bool | int = ..., rf: bool | int = ..., resetToSaved: bool | int = ..., rs: bool | int = ...) -> Any: ...
def displaySmoothness(*args, all: bool | int = ..., boundary: bool | int = ..., bn: bool | int = ..., defaultCreation: bool | int = ..., dc: bool | int = ..., divisionsU: bool | int | int = ..., du: bool | int | int = ..., divisionsV: bool | int | int = ..., dv: bool | int | int = ..., full: bool | int = ..., f: bool | int = ..., hull: bool | int = ..., hl: bool | int = ..., pointsShaded: bool | int | int = ..., ps: bool | int | int = ..., pointsWire: bool | int | int = ..., pw: bool | int | int = ..., polygonObject: bool | int | int = ..., po: bool | int | int = ..., query: bool | int = ..., q: bool | int = ..., renderTessellation: bool | int = ..., rt: bool | int = ..., simplifyU: bool | int | int = ..., su: bool | int | int = ..., simplifyV: bool | int | int = ..., sv: bool | int | int = ...) -> Any: ...
def displayStats(*args, frameRate: bool | int = ..., fr: bool | int = ..., query: bool | int = ..., q: bool | int = ...) -> Any: ...
def displaySurface(*args, flipNormals: bool | int = ..., flp: bool | int = ..., query: bool | int = ..., q: bool | int = ..., twoSidedLighting: bool | int = ..., two: bool | int = ..., xRay: bool | int = ..., x: bool | int = ...) -> Any: ...

def distanceDimension(*args, endPoint: Tuple[float, float, float] = ..., ep: Tuple[float, float, float] = ..., startPoint: Tuple[float, float, float] = ..., sp: Tuple[float, float, float] = ...): ...

def editDisplayLayerGlobals(*args, baseId: bool | int | int = ..., bi: bool | int | int = ..., currentDisplayLayer: bool | int | PyNode | str = ..., cdl: bool | int | PyNode | str = ..., mergeType: bool | int | int = ..., mt: bool | int | int = ..., query: bool | int = ..., q: bool | int = ..., useCurrent: bool | int = ..., uc: bool | int = ...) -> Any: ...
def editDisplayLayerMembers(*args, fullNames: bool | int = ..., fn: bool | int = ..., noRecurse: bool | int = ..., nr: bool | int = ..., query: bool | int = ..., q: bool | int = ...) -> Any: ...
def exactWorldBoundingBox(*args, calculateExactly: bool | int = ..., ce: bool | int = ..., ignoreInvisible: bool | int = ..., ii: bool | int = ...) -> Any: ...
def expandedSelection(*args, depth: int = ..., d: int = ..., expansionType: _util.ProxyUnicode | str = ..., et: _util.ProxyUnicode | str = ...) -> Any: ...
def filterInstances(*args, query: bool | int = ..., q: bool | int = ..., shapes: bool | int = ..., s: bool | int = ...) -> Any: ...
def geometryAttrInfo(*args, boundingBox: bool | int = ..., bb: bool | int = ..., castToEdges: bool | int = ..., cte: bool | int = ..., castToFaces: bool | int = ..., ctf: bool | int = ..., castToVerts: bool | int = ..., ctv: bool | int = ..., componentTagCategory: bool | int = ..., ccy: bool | int = ..., componentTagExpression: _util.ProxyUnicode | str = ..., cex: _util.ProxyUnicode | str = ..., componentTagHash: bool | int = ..., hsh: bool | int = ..., componentTagHistory: bool | int = ..., cth: bool | int = ..., componentTagHistoryHash: bool | int = ..., chh: bool | int = ..., componentTagNames: bool | int = ..., cnm: bool | int = ..., components: bool | int = ..., cmp: bool | int = ..., deformerChain: bool | int = ..., dch: bool | int = ..., elementCount: bool | int = ..., ec: bool | int = ..., groupId: int = ..., gid: int = ..., matrix: bool | int = ..., mtx: bool | int = ..., nodeChain: bool | int = ..., nch: bool | int = ..., originalGeometry: bool | int = ..., og: bool | int = ..., outputPlugChain: bool | int = ..., och: bool | int = ..., plugChain: bool | int = ..., pch: bool | int = ..., pointCount: bool | int = ..., pc: bool | int = ..., pointIndices: bool | int = ..., pi: bool | int = ..., points: bool | int = ..., pnt: bool | int = ..., subsetState: bool | int = ..., sbs: bool | int = ...) -> Any: ...
def hide(*args, allObjects: bool | int = ..., all: bool | int = ..., clearLastHidden: bool | int = ..., clh: bool | int = ..., clearSelection: bool | int = ..., cs: bool | int = ..., invertComponents: bool | int = ..., ic: bool | int = ..., returnHidden: bool | int = ..., rh: bool | int = ..., testVisibility: bool | int = ..., tv: bool | int = ...) -> Any: ...
def hilite(*args, replace: bool | int = ..., r: bool | int = ..., toggle: bool | int = ..., tgl: bool | int = ..., unHilite: bool | int = ..., u: bool | int = ...) -> Any: ...
def inheritTransform(*args, off: bool | int = ..., on: bool | int = ..., preserve: bool | int = ..., p: bool | int = ..., query: bool | int = ..., q: bool | int = ..., toggle: bool | int = ..., tgl: bool | int = ...) -> Any: ...

def instance(*args, leaf: bool | int = ..., lf: bool | int = ..., name: _util.ProxyUnicode | str = ..., n: _util.ProxyUnicode | str = ..., smartTransform: bool | int = ..., st: bool | int = ...): ...

def instanceable(*args, allow: bool | int = ..., a: bool | int = ..., query: bool | int = ..., q: bool | int = ..., recursive: bool | int = ..., r: bool | int = ..., shape: bool | int = ..., s: bool | int = ...) -> Any: ...
def isConnected(*args, ignoreUnitConversion: bool | int = ..., iuc: bool | int = ...) -> Any: ...
def isDirty(*args, connection: bool | int = ..., c: bool | int = ..., datablock: bool | int = ..., d: bool | int = ...) -> Any: ...
def isolateSelect(*args, addDagObject: PyNode | str = ..., ado: PyNode | str = ..., addSelected: bool | int = ..., addSelectedObjects: bool | int = ..., aso: bool | int = ..., loadSelected: bool | int = ..., ls: bool | int = ..., query: bool | int = ..., q: bool | int = ..., removeDagObject: PyNode | str = ..., rdo: PyNode | str = ..., removeSelected: bool | int = ..., rs: bool | int = ..., state: bool | int = ..., s: bool | int = ..., update: bool | int = ..., u: bool | int = ..., viewObjects: bool | int = ..., vo: bool | int = ...) -> Any: ...
def license(*args, borrow: bool | int = ..., b: bool | int = ..., info: bool | int = ..., i: bool | int = ..., isBorrowed: bool | int = ..., ib: bool | int = ..., isExported: bool | int = ..., ie: bool | int = ..., isTrial: bool | int = ..., it: bool | int = ..., licenseMethod: bool | int = ..., lm: bool | int = ..., productChoice: bool | int = ..., pc: bool | int = ..., r: bool | int = ..., showBorrowInfo: bool | int = ..., sbi: bool | int = ..., showProductInfoDialog: bool | int = ..., spi: bool | int = ..., status: bool | int = ..., s: bool | int = ..., usage: bool | int = ..., u: bool | int = ...) -> Any: ...

def listAttr(*args, array: bool | int = ..., a: bool | int = ..., caching: bool | int = ..., ca: bool | int = ..., category: str | List[str] = ..., ct: str | List[str] = ..., changedSinceFileOpen: bool | int = ..., cfo: bool | int = ..., channelBox: bool | int = ..., cb: bool | int = ..., connectable: bool | int = ..., c: bool | int = ..., extension: bool | int = ..., ex: bool | int = ..., fromPlugin: bool | int = ..., fp: bool | int = ..., hasData: bool | int = ..., hd: bool | int = ..., hasNullData: bool | int = ..., hnd: bool | int = ..., inUse: bool | int = ..., iu: bool | int = ..., keyable: bool | int = ..., k: bool | int = ..., leaf: bool | int = ..., lf: bool | int = ..., locked: bool | int = ..., l: bool | int = ..., multi: bool | int = ..., m: bool | int = ..., output: bool | int = ..., o: bool | int = ..., ramp: bool | int = ..., ra: bool | int = ..., read: bool | int = ..., r: bool | int = ..., readOnly: bool | int = ..., ro: bool | int = ..., scalar: bool | int = ..., s: bool | int = ..., scalarAndArray: bool | int = ..., sa: bool | int = ..., settable: bool | int = ..., se: bool | int = ..., shortNames: bool | int = ..., sn: bool | int = ..., string: str | List[str] = ..., st: str | List[str] = ..., unlocked: bool | int = ..., u: bool | int = ..., usedAsFilename: bool | int = ..., uf: bool | int = ..., userDefined: bool | int = ..., ud: bool | int = ..., visible: bool | int = ..., v: bool | int = ..., write: bool | int = ..., w: bool | int = ...): ...

def listAttrPatterns(*args, patternType: bool | int = ..., pt: bool | int = ..., verbose: bool | int = ..., v: bool | int = ...) -> Any: ...
def listNodeTypes(*args, exclude: _util.ProxyUnicode | str = ..., ex: _util.ProxyUnicode | str = ...) -> Any: ...
def listNodesWithIncorrectNames(*args) -> Any: ...
def lockNode(*args, ignoreComponents: bool | int = ..., ic: bool | int = ..., lock: bool | int = ..., l: bool | int = ..., lockName: bool | int = ..., ln: bool | int = ..., lockUnpublished: bool | int = ..., lu: bool | int = ..., query: bool | int = ..., q: bool | int = ...) -> Any: ...
def makeIdentity(*args, apply: bool | int = ..., a: bool | int = ..., jointOrient: bool | int = ..., jo: bool | int = ..., normal: int = ..., n: int = ..., preserveNormals: bool | int = ..., pn: bool | int = ..., rotate: bool | int = ..., r: bool | int = ..., scale: bool | int = ..., s: bool | int = ..., translate: bool | int = ..., t: bool | int = ...) -> Any: ...
def makeLive(*args, none: bool | int = ..., n: bool | int = ...) -> Any: ...
def makePaintable(*args, activate: bool | int = ..., ac: bool | int = ..., activateAll: bool | int = ..., aca: bool | int = ..., altAttribute: bool | int | str | List[str] = ..., aa: bool | int | str | List[str] = ..., attrType: bool | int | _util.ProxyUnicode | str = ..., at: bool | int | _util.ProxyUnicode | str = ..., clearAll: bool | int = ..., ca: bool | int = ..., query: bool | int = ..., q: bool | int = ..., remove: bool | int = ..., rm: bool | int = ..., shapeMode: bool | int | _util.ProxyUnicode | str = ..., sm: bool | int | _util.ProxyUnicode | str = ..., uiName: bool | int | _util.ProxyUnicode | str = ..., ui: bool | int | _util.ProxyUnicode | str = ...) -> Any: ...
def matchTransform(*args, pivots: bool | int = ..., piv: bool | int = ..., position: bool | int = ..., pos: bool | int = ..., positionX: bool | int = ..., px: bool | int = ..., positionY: bool | int = ..., py: bool | int = ..., positionZ: bool | int = ..., pz: bool | int = ..., rotatePivot: bool | int = ..., rp: bool | int = ..., rotation: bool | int = ..., rot: bool | int = ..., rotationX: bool | int = ..., rx: bool | int = ..., rotationY: bool | int = ..., ry: bool | int = ..., rotationZ: bool | int = ..., rz: bool | int = ..., scale: bool | int = ..., scl: bool | int = ..., scaleBox: bool | int = ..., box: bool | int = ..., scalePivot: bool | int = ..., sp: bool | int = ..., scaleX: bool | int = ..., sx: bool | int = ..., scaleY: bool | int = ..., sy: bool | int = ..., scaleZ: bool | int = ..., sz: bool | int = ...) -> Any: ...
def nodeCast(*args, copyDynamicAttrs: bool | int = ..., cda: bool | int = ..., disableAPICallbacks: bool | int = ..., dsa: bool | int = ..., disableScriptJobCallbacks: bool | int = ..., dsj: bool | int = ..., disconnectUnmatchedAttrs: bool | int = ..., dua: bool | int = ..., force: bool | int = ..., f: bool | int = ..., swapNames: bool | int = ..., sn: bool | int = ..., swapValues: bool | int = ..., sv: bool | int = ...) -> Any: ...
def objExists(*args) -> Any: ...
def objectCenter(*args, gl: bool | int = ..., local: bool | int = ..., l: bool | int = ..., x: bool | int = ..., y: bool | int = ..., z: bool | int = ...) -> Any: ...
def objectType(*args, convertTag: _util.ProxyUnicode | str = ..., ct: _util.ProxyUnicode | str = ..., isAType: _util.ProxyUnicode | str = ..., isa: _util.ProxyUnicode | str = ..., isType: _util.ProxyUnicode | str = ..., i: _util.ProxyUnicode | str = ..., tagFromType: _util.ProxyUnicode | str = ..., tgt: _util.ProxyUnicode | str = ..., typeFromTag: int = ..., tpt: int = ..., typeTag: bool | int = ..., tt: bool | int = ...) -> Any: ...

def paramDimension(*args): ...

def paramLocator(*args, edit: bool | int = ..., e: bool | int = ..., position: bool | int = ..., p: bool | int = ..., query: bool | int = ..., q: bool | int = ...) -> Any: ...

def partition(*args, addSet: PyNode | str = ..., add: PyNode | str = ..., edit: bool | int = ..., e: bool | int = ..., name: _util.ProxyUnicode | str = ..., n: _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., removeSet: PyNode | str = ..., rm: PyNode | str = ..., render: bool | int = ..., re: bool | int = ...): ...

def performanceOptions(*args, clusterResolution: bool | int | float = ..., cr: bool | int | float = ..., disableStitch: bool | int | _util.ProxyUnicode | str = ..., ds: bool | int | _util.ProxyUnicode | str = ..., disableTrimBoundaryDisplay: bool | int | _util.ProxyUnicode | str = ..., dtb: bool | int | _util.ProxyUnicode | str = ..., disableTrimDisplay: bool | int | _util.ProxyUnicode | str = ..., dt: bool | int | _util.ProxyUnicode | str = ..., latticeResolution: bool | int | float = ..., lr: bool | int | float = ..., passThroughBindSkinAndFlexors: bool | int | _util.ProxyUnicode | str = ..., pbf: bool | int | _util.ProxyUnicode | str = ..., passThroughBlendShape: bool | int | _util.ProxyUnicode | str = ..., pbs: bool | int | _util.ProxyUnicode | str = ..., passThroughCluster: bool | int | _util.ProxyUnicode | str = ..., pc: bool | int | _util.ProxyUnicode | str = ..., passThroughDeltaMush: bool | int | _util.ProxyUnicode | str = ..., pdm: bool | int | _util.ProxyUnicode | str = ..., passThroughFlexors: bool | int | _util.ProxyUnicode | str = ..., pf: bool | int | _util.ProxyUnicode | str = ..., passThroughLattice: bool | int | _util.ProxyUnicode | str = ..., pl: bool | int | _util.ProxyUnicode | str = ..., passThroughPaintEffects: bool | int | _util.ProxyUnicode | str = ..., pp: bool | int | _util.ProxyUnicode | str = ..., passThroughSculpt: bool | int | _util.ProxyUnicode | str = ..., ps: bool | int | _util.ProxyUnicode | str = ..., passThroughWire: bool | int | _util.ProxyUnicode | str = ..., pw: bool | int | _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., skipHierarchyTraversal: bool | int = ..., sht: bool | int = ..., useClusterResolution: bool | int | _util.ProxyUnicode | str = ..., ucr: bool | int | _util.ProxyUnicode | str = ..., useLatticeResolution: bool | int | _util.ProxyUnicode | str = ..., ulr: bool | int | _util.ProxyUnicode | str = ...) -> Any: ...
def pickWalk(*args, direction: _util.ProxyUnicode | str = ..., d: _util.ProxyUnicode | str = ..., recurse: bool | int = ..., r: bool | int = ..., type: _util.ProxyUnicode | str = ..., typ: _util.ProxyUnicode | str = ...) -> Any: ...
def pixelMove(*args) -> Any: ...
def polySplitCtx2(*args, adjustEdgeFlow: bool | int | float = ..., aef: bool | int | float = ..., constrainToEdges: bool | int = ..., cte: bool | int = ..., detachEdges: bool | int = ..., de: bool | int = ..., edgeMagnets: bool | int | int = ..., em: bool | int | int = ..., edit: bool | int = ..., e: bool | int = ..., exists: bool | int = ..., ex: bool | int = ..., highlightPointColor: Tuple[float, float, float] = ..., hpc: Tuple[float, float, float] = ..., image1: bool | int | _util.ProxyUnicode | str = ..., i1: bool | int | _util.ProxyUnicode | str = ..., image2: bool | int | _util.ProxyUnicode | str = ..., i2: bool | int | _util.ProxyUnicode | str = ..., image3: bool | int | _util.ProxyUnicode | str = ..., i3: bool | int | _util.ProxyUnicode | str = ..., insertWithEdgeFlow: bool | int = ..., ief: bool | int = ..., query: bool | int = ..., q: bool | int = ..., snapTolerance: bool | int | float = ..., st: bool | int | float = ..., snappedToEdgeColor: bool | int | Tuple[float, float, float] = ..., sec: bool | int | Tuple[float, float, float] = ..., snappedToFaceColor: bool | int | Tuple[float, float, float] = ..., sfc: bool | int | Tuple[float, float, float] = ..., snappedToMagnetColor: bool | int | Tuple[float, float, float] = ..., smc: bool | int | Tuple[float, float, float] = ..., snappedToVertexColor: bool | int | Tuple[float, float, float] = ..., svc: bool | int | Tuple[float, float, float] = ..., snappingTolerance: float = ..., splitLineColor: Tuple[float, float, float] = ..., slc: Tuple[float, float, float] = ...) -> Any: ...
def relationship(*args, b: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., query: bool | int = ..., q: bool | int = ..., relationshipData: bool | int | str | List[str] = ..., rd: bool | int | str | List[str] = ...) -> Any: ...
def rememberCtxSettings(*args) -> Any: ...
def removeMultiInstance(*args, allChildren: bool | int = ..., all: bool | int = ..., b: bool | int = ...) -> Any: ...
def renameAttr(*args) -> Any: ...
def reorder(*args, back: bool | int = ..., b: bool | int = ..., front: bool | int = ..., f: bool | int = ..., relative: int = ..., r: int = ...) -> Any: ...
def reorderContainer(*args, back: bool | int = ..., b: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., front: bool | int = ..., f: bool | int = ..., query: bool | int = ..., q: bool | int = ..., relative: bool | int | int = ..., r: bool | int | int = ...) -> Any: ...
def resetTool(*args) -> Any: ...
def saveToolSettings(*args) -> Any: ...
def scaleComponents(*args, pivot: Tuple[float, float, float] = ..., p: Tuple[float, float, float] = ..., rotation: Tuple[float, float, float] = ..., ro: Tuple[float, float, float] = ...) -> Any: ...
def sceneLint(*args, issueType: bool | int | str | List[str] = ..., i: bool | int | str | List[str] = ..., verbose: bool | int = ..., v: bool | int = ...) -> Any: ...
def sculptMeshCacheChangeCloneSource(*args, blendShape: bool | int | _util.ProxyUnicode | str = ..., bs: bool | int | _util.ProxyUnicode | str = ..., edit: bool | int = ..., e: bool | int = ..., query: bool | int = ..., q: bool | int = ..., target: bool | int | _util.ProxyUnicode | str = ..., t: bool | int | _util.ProxyUnicode | str = ...) -> Any: ...

def selectKey(*args, addTo: bool | int = ..., add: bool | int = ..., animation: _util.ProxyUnicode | str = ..., an: _util.ProxyUnicode | str = ..., attribute: str | List[str] = ..., at: str | List[str] = ..., clear: bool | int = ..., cl: bool | int = ..., controlPoints: bool | int = ..., cp: bool | int = ..., float: str | int | float | List[str | int | float] = ..., f: str | int | float | List[str | int | float] = ..., hierarchy: _util.ProxyUnicode | str = ..., hi: _util.ProxyUnicode | str = ..., inTangent: bool | int = ..., it: bool | int = ..., includeUpperBound: bool | int = ..., iub: bool | int = ..., index: int | List[int] = ..., keyframe: bool | int = ..., k: bool | int = ..., outTangent: bool | int = ..., ot: bool | int = ..., remove: bool | int = ..., rm: bool | int = ..., replace: bool | int = ..., r: bool | int = ..., shape: bool | int = ..., s: bool | int = ..., time: str | Tuple[float, float] | Tuple[float] | List[str | Tuple[float, float] | Tuple[float]] = ..., t: str | Tuple[float, float] | Tuple[float] | List[str | Tuple[float, float] | Tuple[float]] = ..., toggle: bool | int = ..., tgl: bool | int = ..., unsnappedKeys: float = ..., uk: float = ...): ...

def selectMode(*args, component: bool | int = ..., co: bool | int = ..., hierarchical: bool | int = ..., h: bool | int = ..., leaf: bool | int = ..., l: bool | int = ..., object: bool | int = ..., o: bool | int = ..., preset: bool | int = ..., p: bool | int = ..., query: bool | int = ..., q: bool | int = ..., root: bool | int = ..., r: bool | int = ..., template: bool | int = ..., t: bool | int = ...) -> Any: ...
def selectPref(*args, affectsActive: bool | int = ..., aa: bool | int = ..., allowHiliteSelection: bool | int = ..., ahs: bool | int = ..., autoSelectContainer: bool | int = ..., asc: bool | int = ..., autoSelectOutlinerSetMembers: bool | int = ..., asm: bool | int = ..., autoUseDepth: bool | int = ..., aud: bool | int = ..., clickBoxSize: bool | int | int = ..., cbs: bool | int | int = ..., clickDrag: bool | int = ..., cld: bool | int = ..., containerCentricSelection: bool | int = ..., ccs: bool | int = ..., disableComponentPopups: bool | int = ..., dcp: bool | int = ..., expandPopupList: bool | int = ..., epl: bool | int = ..., ignoreSelectionPriority: bool | int = ..., isp: bool | int = ..., manipClickBoxSize: bool | int | int = ..., mcb: bool | int | int = ..., paintSelect: bool | int = ..., ps: bool | int = ..., paintSelectRefine: bool | int = ..., psf: bool | int = ..., paintSelectWithDepth: bool | int = ..., psd: bool | int = ..., popupMenuSelection: bool | int = ..., pms: bool | int = ..., preSelectBackfacing: bool | int = ..., psb: bool | int = ..., preSelectClosest: bool | int = ..., psc: bool | int = ..., preSelectDeadSpace: bool | int | int = ..., pds: bool | int | int = ..., preSelectHilite: bool | int = ..., psh: bool | int = ..., preSelectHiliteSize: bool | int | float = ..., phs: bool | int | float = ..., preSelectSize: int = ..., pss: int = ..., preSelectTweakDeadSpace: bool | int | int = ..., pdt: bool | int | int = ..., query: bool | int = ..., q: bool | int = ..., selectTypeChangeAffectsActive: bool | int = ..., stc: bool | int = ..., selectionChildHighlightMode: bool | int | int = ..., sch: bool | int | int = ..., singleBoxSelection: bool | int = ..., sbs: bool | int = ..., straightLineDistance: bool | int = ..., sld: bool | int = ..., trackSelectionOrder: bool | int = ..., tso: bool | int = ..., useDepth: bool | int = ..., ud: bool | int = ..., xformNoSelect: bool | int = ..., xns: bool | int = ...) -> Any: ...
def selectPriority(*args, allComponents: bool | int | int = ..., alc: bool | int | int = ..., allObjects: bool | int | int = ..., alo: bool | int | int = ..., animBreakdown: bool | int | int = ..., abd: bool | int | int = ..., animCurve: bool | int | int = ..., ac: bool | int | int = ..., animInTangent: bool | int | int = ..., ait: bool | int | int = ..., animKeyframe: bool | int | int = ..., ak: bool | int | int = ..., animOutTangent: bool | int | int = ..., aot: bool | int | int = ..., byName: Tuple[str, bool | int] | List[Tuple[str, bool | int]] = ..., bn: Tuple[str, bool | int] | List[Tuple[str, bool | int]] = ..., camera: bool | int | int = ..., ca: bool | int | int = ..., cluster: bool | int | int = ..., cl: bool | int | int = ..., collisionModel: bool | int | int = ..., clm: bool | int | int = ..., controlVertex: bool | int | int = ..., cv: bool | int | int = ..., curve: bool | int | int = ..., c: bool | int | int = ..., curveKnot: bool | int | int = ..., ck: bool | int | int = ..., curveOnSurface: bool | int | int = ..., cos: bool | int | int = ..., curveParameterPoint: bool | int | int = ..., cpp: bool | int | int = ..., dimension: bool | int | int = ..., dim: bool | int | int = ..., dynamicConstraint: bool | int | int = ..., dc: bool | int | int = ..., edge: bool | int | int = ..., eg: bool | int | int = ..., editPoint: bool | int | int = ..., ep: bool | int | int = ..., emitter: bool | int | int = ..., em: bool | int | int = ..., facet: bool | int | int = ..., fc: bool | int | int = ..., field: bool | int | int = ..., fi: bool | int | int = ..., fluid: bool | int | int = ..., fl: bool | int | int = ..., follicle: bool | int | int = ..., fo: bool | int | int = ..., hairSystem: bool | int | int = ..., hs: bool | int | int = ..., handle: bool | int | int = ..., ha: bool | int | int = ..., hull: bool | int | int = ..., hl: bool | int | int = ..., ikEndEffector: bool | int | int = ..., iee: bool | int | int = ..., ikHandle: bool | int | int = ..., ikh: bool | int | int = ..., imagePlane: bool | int | int = ..., ip: bool | int | int = ..., implicitGeometry: bool | int | int = ..., ig: bool | int | int = ..., isoparm: bool | int | int = ..., iso: bool | int | int = ..., joint: bool | int | int = ..., j: bool | int | int = ..., jointPivot: bool | int | int = ..., jp: bool | int | int = ..., lattice: bool | int | int = ..., la: bool | int | int = ..., latticePoint: bool | int | int = ..., lp: bool | int | int = ..., light: bool | int | int = ..., lt: bool | int | int = ..., localRotationAxis: bool | int | int = ..., ra: bool | int | int = ..., locator: bool | int | int = ..., lc: bool | int | int = ..., locatorUV: bool | int | int = ..., luv: bool | int | int = ..., locatorXYZ: bool | int | int = ..., xyz: bool | int | int = ..., meshUVShell: bool | int | int = ..., msh: bool | int | int = ..., motionTrailPoint: bool | int | int = ..., mtp: bool | int | int = ..., motionTrailTangent: bool | int | int = ..., mtt: bool | int | int = ..., nCloth: bool | int | int = ..., ncl: bool | int | int = ..., nParticle: bool | int | int = ..., npr: bool | int | int = ..., nParticleShape: bool | int | int = ..., nps: bool | int | int = ..., nRigid: bool | int | int = ..., nr: bool | int | int = ..., nonlinear: bool | int | int = ..., nl: bool | int | int = ..., nurbsCurve: bool | int | int = ..., nc: bool | int | int = ..., nurbsSurface: bool | int | int = ..., ns: bool | int | int = ..., orientationLocator: bool | int | int = ..., ol: bool | int | int = ..., particle: bool | int | int = ..., pr: bool | int | int = ..., particleShape: bool | int | int = ..., ps: bool | int | int = ..., plane: bool | int | int = ..., pl: bool | int | int = ..., polymesh: bool | int | int = ..., p: bool | int | int = ..., polymeshEdge: bool | int | int = ..., pe: bool | int | int = ..., polymeshFace: bool | int | int = ..., pf: bool | int | int = ..., polymeshFreeEdge: bool | int | int = ..., pfe: bool | int | int = ..., polymeshUV: bool | int | int = ..., puv: bool | int | int = ..., polymeshVertex: bool | int | int = ..., pv: bool | int | int = ..., polymeshVtxFace: bool | int | int = ..., pvf: bool | int | int = ..., query: bool | int = ..., q: bool | int = ..., queryByName: bool | int | _util.ProxyUnicode | str = ..., qbn: bool | int | _util.ProxyUnicode | str = ..., rigidBody: bool | int | int = ..., rb: bool | int | int = ..., rigidConstraint: bool | int | int = ..., rc: bool | int | int = ..., rotatePivot: bool | int | int = ..., rp: bool | int | int = ..., scalePivot: bool | int | int = ..., sp: bool | int | int = ..., sculpt: bool | int | int = ..., sc: bool | int | int = ..., selectHandle: bool | int | int = ..., sh: bool | int | int = ..., spring: bool | int | int = ..., spr: bool | int | int = ..., springComponent: bool | int | int = ..., spc: bool | int | int = ..., stroke: bool | int | int = ..., str: bool | int | int = ..., subdiv: bool | int | int = ..., sd: bool | int | int = ..., subdivMeshEdge: bool | int | int = ..., sme: bool | int | int = ..., subdivMeshFace: bool | int | int = ..., smf: bool | int | int = ..., subdivMeshPoint: bool | int | int = ..., smp: bool | int | int = ..., subdivMeshUV: bool | int | int = ..., smu: bool | int | int = ..., surfaceEdge: bool | int | int = ..., se: bool | int | int = ..., surfaceFace: bool | int | int = ..., sf: bool | int | int = ..., surfaceKnot: bool | int | int = ..., sk: bool | int | int = ..., surfaceParameterPoint: bool | int | int = ..., spp: bool | int | int = ..., surfaceRange: bool | int | int = ..., sr: bool | int | int = ..., texture: bool | int | int = ..., tx: bool | int | int = ..., vertex: bool | int | int = ..., v: bool | int | int = ...) -> Any: ...
def selectType(*args, allComponents: bool | int = ..., alc: bool | int = ..., allObjects: bool | int = ..., alo: bool | int = ..., animBreakdown: bool | int = ..., abd: bool | int = ..., animCurve: bool | int = ..., ac: bool | int = ..., animInTangent: bool | int = ..., ait: bool | int = ..., animKeyframe: bool | int = ..., ak: bool | int = ..., animOutTangent: bool | int = ..., aot: bool | int = ..., byName: Tuple[str, bool | int] | List[Tuple[str, bool | int]] = ..., bn: Tuple[str, bool | int] | List[Tuple[str, bool | int]] = ..., camera: bool | int = ..., ca: bool | int = ..., cluster: bool | int = ..., cl: bool | int = ..., collisionModel: bool | int = ..., clm: bool | int = ..., controlVertex: bool | int = ..., cv: bool | int = ..., curve: bool | int = ..., c: bool | int = ..., curveKnot: bool | int = ..., ck: bool | int = ..., curveOnSurface: bool | int = ..., cos: bool | int = ..., curveParameterPoint: bool | int = ..., cpp: bool | int = ..., dimension: bool | int = ..., dim: bool | int = ..., dynamicConstraint: bool | int = ..., dc: bool | int = ..., edge: bool | int = ..., eg: bool | int = ..., editPoint: bool | int = ..., ep: bool | int = ..., emitter: bool | int = ..., em: bool | int = ..., facet: bool | int = ..., fc: bool | int = ..., field: bool | int = ..., fi: bool | int = ..., fluid: bool | int = ..., fl: bool | int = ..., follicle: bool | int = ..., fo: bool | int = ..., hairSystem: bool | int = ..., hs: bool | int = ..., handle: bool | int = ..., ha: bool | int = ..., hull: bool | int = ..., hl: bool | int = ..., ikEndEffector: bool | int = ..., iee: bool | int = ..., ikHandle: bool | int = ..., ikh: bool | int = ..., imagePlane: bool | int = ..., ip: bool | int = ..., implicitGeometry: bool | int = ..., ig: bool | int = ..., isoparm: bool | int = ..., iso: bool | int = ..., joint: bool | int = ..., j: bool | int = ..., jointPivot: bool | int = ..., jp: bool | int = ..., lattice: bool | int = ..., la: bool | int = ..., latticePoint: bool | int = ..., lp: bool | int = ..., light: bool | int = ..., lt: bool | int = ..., localRotationAxis: bool | int = ..., ra: bool | int = ..., locator: bool | int = ..., lc: bool | int = ..., locatorUV: bool | int = ..., luv: bool | int = ..., locatorXYZ: bool | int = ..., xyz: bool | int = ..., meshComponents: bool | int = ..., mc: bool | int = ..., meshUVShell: bool | int = ..., msh: bool | int = ..., motionTrailPoint: bool | int = ..., mtp: bool | int = ..., motionTrailTangent: bool | int = ..., mtt: bool | int = ..., nCloth: bool | int = ..., ncl: bool | int = ..., nParticle: bool | int = ..., npr: bool | int = ..., nParticleShape: bool | int = ..., nps: bool | int = ..., nRigid: bool | int = ..., nr: bool | int = ..., nonlinear: bool | int = ..., nl: bool | int = ..., nurbsCurve: bool | int = ..., nc: bool | int = ..., nurbsSurface: bool | int = ..., ns: bool | int = ..., objectComponent: bool | int = ..., ocm: bool | int = ..., orientationLocator: bool | int = ..., ol: bool | int = ..., particle: bool | int = ..., pr: bool | int = ..., particleShape: bool | int = ..., ps: bool | int = ..., plane: bool | int = ..., pl: bool | int = ..., polymesh: bool | int = ..., p: bool | int = ..., polymeshEdge: bool | int = ..., pe: bool | int = ..., polymeshFace: bool | int = ..., pf: bool | int = ..., polymeshFreeEdge: bool | int = ..., pfe: bool | int = ..., polymeshUV: bool | int = ..., puv: bool | int = ..., polymeshVertex: bool | int = ..., pv: bool | int = ..., polymeshVtxFace: bool | int = ..., pvf: bool | int = ..., query: bool | int = ..., q: bool | int = ..., queryByName: bool | int | _util.ProxyUnicode | str = ..., qbn: bool | int | _util.ProxyUnicode | str = ..., rigidBody: bool | int = ..., rb: bool | int = ..., rigidConstraint: bool | int = ..., rc: bool | int = ..., rotatePivot: bool | int = ..., rp: bool | int = ..., scalePivot: bool | int = ..., sp: bool | int = ..., sculpt: bool | int = ..., sc: bool | int = ..., selectHandle: bool | int = ..., sh: bool | int = ..., spring: bool | int = ..., spr: bool | int = ..., springComponent: bool | int = ..., spc: bool | int = ..., stroke: bool | int = ..., str: bool | int = ..., subdiv: bool | int = ..., sd: bool | int = ..., subdivMeshEdge: bool | int = ..., sme: bool | int = ..., subdivMeshFace: bool | int = ..., smf: bool | int = ..., subdivMeshPoint: bool | int = ..., smp: bool | int = ..., subdivMeshUV: bool | int = ..., smu: bool | int = ..., surfaceEdge: bool | int = ..., se: bool | int = ..., surfaceFace: bool | int = ..., sf: bool | int = ..., surfaceKnot: bool | int = ..., sk: bool | int = ..., surfaceParameterPoint: bool | int = ..., spp: bool | int = ..., surfaceRange: bool | int = ..., sr: bool | int = ..., surfaceUV: bool | int = ..., suv: bool | int = ..., texture: bool | int = ..., tx: bool | int = ..., vertex: bool | int = ..., v: bool | int = ...) -> Any: ...
def selectedNodes(*args, dagObjects: bool | int = ..., do: bool | int = ...) -> Any: ...
def setToolTo(*args) -> Any: ...
def shapeCompare(*args) -> Any: ...
def showHidden(*args, above: bool | int = ..., a: bool | int = ..., allObjects: bool | int = ..., all: bool | int = ..., below: bool | int = ..., b: bool | int = ..., lastHidden: bool | int = ..., lh: bool | int = ...) -> Any: ...
def snapMode(*args, curve: bool | int = ..., c: bool | int = ..., distanceIncrement: bool | int | float = ..., dsi: bool | int | float = ..., edgeMagnet: bool | int | int = ..., em: bool | int | int = ..., edgeMagnetTolerance: bool | int | float = ..., emt: bool | int | float = ..., grid: bool | int = ..., gr: bool | int = ..., liveFaceCenter: bool | int = ..., lfc: bool | int = ..., livePoint: bool | int = ..., lp: bool | int = ..., meshCenter: bool | int = ..., mc: bool | int = ..., pixelCenter: bool | int = ..., pc: bool | int = ..., pixelSnap: bool | int = ..., ps: bool | int = ..., point: bool | int = ..., p: bool | int = ..., query: bool | int = ..., q: bool | int = ..., tolerance: bool | int | int = ..., t: bool | int | int = ..., useTolerance: bool | int = ..., ut: bool | int = ..., uvTolerance: bool | int | int = ..., uvt: bool | int | int = ..., viewPlane: bool | int = ..., vp: bool | int = ...) -> Any: ...
def softSelect(*args, compressUndo: bool | int | int = ..., cu: bool | int | int = ..., edit: bool | int = ..., e: bool | int = ..., enableFalseColor: bool | int | int = ..., efc: bool | int | int = ..., query: bool | int = ..., q: bool | int = ..., softSelectColorCurve: bool | int | _util.ProxyUnicode | str = ..., scc: bool | int | _util.ProxyUnicode | str = ..., softSelectCurve: bool | int | _util.ProxyUnicode | str = ..., ssc: bool | int | _util.ProxyUnicode | str = ..., softSelectDistance: bool | int | float = ..., ssd: bool | int | float = ..., softSelectEnabled: bool | int | int = ..., sse: bool | int | int = ..., softSelectFalloff: bool | int | int = ..., ssf: bool | int | int = ..., softSelectReset: bool | int = ..., ssr: bool | int = ..., softSelectUVDistance: bool | int | float = ..., sud: bool | int | float = ...) -> Any: ...
def suitePrefs(*args, applyToSuite: _util.ProxyUnicode | str = ..., ats: _util.ProxyUnicode | str = ..., edit: bool | int = ..., e: bool | int = ..., installedAsSuite: bool | int = ..., ias: bool | int = ..., isCompleteSuite: bool | int = ..., ics: bool | int = ..., query: bool | int = ..., q: bool | int = ...) -> Any: ...
def symmetricModelling(*args, about: bool | int | _util.ProxyUnicode | str = ..., a: bool | int | _util.ProxyUnicode | str = ..., allowPartial: bool | int = ..., ap: bool | int = ..., axis: bool | int | _util.ProxyUnicode | str = ..., ax: bool | int | _util.ProxyUnicode | str = ..., edit: bool | int = ..., e: bool | int = ..., preserveSeam: bool | int | int = ..., ps: bool | int | int = ..., query: bool | int = ..., q: bool | int = ..., reset: bool | int = ..., r: bool | int = ..., seamFalloffCurve: bool | int | _util.ProxyUnicode | str = ..., sf: bool | int | _util.ProxyUnicode | str = ..., seamTolerance: bool | int | float = ..., st: bool | int | float = ..., symmetry: bool | int | int = ..., s: bool | int | int = ..., tolerance: bool | int | float = ..., t: bool | int | float = ..., topoSymmetry: bool | int = ..., ts: bool | int = ...) -> Any: ...
def threadCount(*args, numberOfThreads: bool | int | int = ..., n: bool | int | int = ..., query: bool | int = ..., q: bool | int = ...) -> Any: ...
def timeCode(*args, edit: bool | int = ..., e: bool | int = ..., mayaStartFrame: bool | int | float = ..., msf: bool | int | float = ..., productionStartFrame: bool | int | float = ..., psf: bool | int | float = ..., productionStartHour: bool | int | float = ..., psh: bool | int | float = ..., productionStartMinute: bool | int | float = ..., psm: bool | int | float = ..., productionStartSecond: bool | int | float = ..., pss: bool | int | float = ..., query: bool | int = ..., q: bool | int = ...) -> Any: ...
def toggle(*args, above: bool | int = ..., a: bool | int = ..., below: bool | int = ..., b: bool | int = ..., boundary: bool | int = ..., bn: bool | int = ..., boundingBox: bool | int = ..., box: bool | int = ..., controlVertex: bool | int = ..., cv: bool | int = ..., doNotWrite: bool | int = ..., dnw: bool | int = ..., editPoint: bool | int = ..., ep: bool | int = ..., extent: bool | int = ..., et: bool | int = ..., facet: bool | int = ..., f: bool | int = ..., geometry: bool | int = ..., g: bool | int = ..., gl: bool | int = ..., highPrecisionNurbs: bool | int = ..., hpn: bool | int = ..., hull: bool | int = ..., hl: bool | int = ..., latticePoint: bool | int = ..., lp: bool | int = ..., latticeShape: bool | int = ..., ls: bool | int = ..., localAxis: bool | int = ..., la: bool | int = ..., newCurve: bool | int = ..., nc: bool | int = ..., newPolymesh: bool | int = ..., np: bool | int = ..., newSurface: bool | int = ..., ns: bool | int = ..., normal: bool | int = ..., nr: bool | int = ..., origin: bool | int = ..., o: bool | int = ..., point: bool | int = ..., pt: bool | int = ..., pointDisplay: bool | int = ..., pd: bool | int = ..., pointFacet: bool | int = ..., pf: bool | int = ..., query: bool | int = ..., q: bool | int = ..., rotatePivot: bool | int = ..., rp: bool | int = ..., scalePivot: bool | int = ..., sp: bool | int = ..., selectHandle: bool | int = ..., sh: bool | int = ..., state: bool | int = ..., st: bool | int = ..., surfaceFace: bool | int = ..., sf: bool | int = ..., template: bool | int = ..., te: bool | int = ..., uvCoords: bool | int = ..., uv: bool | int = ..., vertex: bool | int = ..., vt: bool | int = ...) -> Any: ...
def toggleAxis(*args, origin: bool | int = ..., o: bool | int = ..., query: bool | int = ..., q: bool | int = ..., view: bool | int = ..., v: bool | int = ...) -> Any: ...
def toggleDisplacement(*args) -> Any: ...
def toolDropped(*args) -> Any: ...
def toolHasOptions(*args) -> Any: ...

def toolPropertyWindow(*args, edit: bool | int = ..., e: bool | int = ..., field: bool | int | _util.ProxyUnicode | str = ..., fld: bool | int | _util.ProxyUnicode | str = ..., helpButton: bool | int | _util.ProxyUnicode | str = ..., hb: bool | int | _util.ProxyUnicode | str = ..., icon: bool | int | _util.ProxyUnicode | str = ..., icn: bool | int | _util.ProxyUnicode | str = ..., inMainWindow: bool | int = ..., imw: bool | int = ..., location: bool | int | _util.ProxyUnicode | str = ..., loc: bool | int | _util.ProxyUnicode | str = ..., noviceMode: bool | int = ..., nm: bool | int = ..., query: bool | int = ..., q: bool | int = ..., refresh: bool | int = ..., rf: bool | int = ..., resetButton: bool | int | _util.ProxyUnicode | str = ..., rb: bool | int | _util.ProxyUnicode | str = ..., restore: bool | int = ..., rs: bool | int = ..., selectCommand: bool | int | _util.ProxyUnicode | str = ..., sel: bool | int | _util.ProxyUnicode | str = ..., showCommand: bool | int | _util.ProxyUnicode | str = ..., shw: bool | int | _util.ProxyUnicode | str = ...): ...

def transformCompare(*args, root: bool | int = ..., r: bool | int = ...) -> Any: ...
def transformLimits(*args, edit: bool | int = ..., e: bool | int = ..., enableRotationX: bool | int | Tuple[bool | int, bool | int] = ..., erx: bool | int | Tuple[bool | int, bool | int] = ..., enableRotationY: bool | int | Tuple[bool | int, bool | int] = ..., ery: bool | int | Tuple[bool | int, bool | int] = ..., enableRotationZ: bool | int | Tuple[bool | int, bool | int] = ..., erz: bool | int | Tuple[bool | int, bool | int] = ..., enableScaleX: bool | int | Tuple[bool | int, bool | int] = ..., esx: bool | int | Tuple[bool | int, bool | int] = ..., enableScaleY: bool | int | Tuple[bool | int, bool | int] = ..., esy: bool | int | Tuple[bool | int, bool | int] = ..., enableScaleZ: bool | int | Tuple[bool | int, bool | int] = ..., esz: bool | int | Tuple[bool | int, bool | int] = ..., enableTranslationX: bool | int | Tuple[bool | int, bool | int] = ..., etx: bool | int | Tuple[bool | int, bool | int] = ..., enableTranslationY: bool | int | Tuple[bool | int, bool | int] = ..., ety: bool | int | Tuple[bool | int, bool | int] = ..., enableTranslationZ: bool | int | Tuple[bool | int, bool | int] = ..., etz: bool | int | Tuple[bool | int, bool | int] = ..., query: bool | int = ..., q: bool | int = ..., remove: bool | int = ..., rm: bool | int = ..., rotationX: bool | int | Tuple[float, float] = ..., rx: bool | int | Tuple[float, float] = ..., rotationY: bool | int | Tuple[float, float] = ..., ry: bool | int | Tuple[float, float] = ..., rotationZ: bool | int | Tuple[float, float] = ..., rz: bool | int | Tuple[float, float] = ..., scaleX: bool | int | Tuple[float, float] = ..., sx: bool | int | Tuple[float, float] = ..., scaleY: bool | int | Tuple[float, float] = ..., sy: bool | int | Tuple[float, float] = ..., scaleZ: bool | int | Tuple[float, float] = ..., sz: bool | int | Tuple[float, float] = ..., translationX: bool | int | Tuple[float, float] = ..., tx: bool | int | Tuple[float, float] = ..., translationY: bool | int | Tuple[float, float] = ..., ty: bool | int | Tuple[float, float] = ..., translationZ: bool | int | Tuple[float, float] = ..., tz: bool | int | Tuple[float, float] = ...) -> Any: ...
def ungroup(*args, absolute: bool | int = ..., a: bool | int = ..., parent: _util.ProxyUnicode | str = ..., p: _util.ProxyUnicode | str = ..., relative: bool | int = ..., r: bool | int = ..., world: bool | int = ..., w: bool | int = ...) -> Any: ...
def upAxis(*args, axis: bool | int | _util.ProxyUnicode | str = ..., ax: bool | int | _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., rotateView: bool | int = ..., rv: bool | int = ...) -> Any: ...
def weightsColor(*args, colorRamp: bool | int | _util.ProxyUnicode | str = ..., cr: bool | int | _util.ProxyUnicode | str = ..., deformer: bool | int | _util.ProxyUnicode | str = ..., dfm: bool | int | _util.ProxyUnicode | str = ..., falseColor: bool | int = ..., fc: bool | int = ..., outOfRangeColor: bool | int | Tuple[float, float, float] = ..., orc: bool | int | Tuple[float, float, float] = ..., query: bool | int = ..., q: bool | int = ..., rampMaxColor: bool | int | Tuple[float, float, float] = ..., rxc: bool | int | Tuple[float, float, float] = ..., rampMinColor: bool | int | Tuple[float, float, float] = ..., rmc: bool | int | Tuple[float, float, float] = ..., useColorRamp: bool | int = ..., ucr: bool | int = ..., useMaxMinColor: bool | int = ..., umc: bool | int = ...) -> Any: ...
def xform(*args, absolute: bool | int = ..., a: bool | int = ..., boundingBox: bool | int = ..., bb: bool | int = ..., boundingBoxInvisible: bool | int = ..., bbi: bool | int = ..., centerPivots: bool | int = ..., cp: bool | int = ..., centerPivotsOnComponents: bool | int = ..., cpc: bool | int = ..., deletePriorHistory: bool | int = ..., dph: bool | int = ..., euler: bool | int = ..., eu: bool | int = ..., matrix: bool | int | Tuple[float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float] = ..., m: bool | int | Tuple[float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float] = ..., objectSpace: bool | int = ..., os: bool | int = ..., pivots: bool | int | Tuple[float, float, float] = ..., piv: bool | int | Tuple[float, float, float] = ..., preserve: bool | int = ..., p: bool | int = ..., preserveUV: bool | int = ..., puv: bool | int = ..., query: bool | int = ..., q: bool | int = ..., reflection: bool | int = ..., rfl: bool | int = ..., reflectionAboutBBox: bool | int = ..., rab: bool | int = ..., reflectionAboutOrigin: bool | int = ..., rao: bool | int = ..., reflectionAboutX: bool | int = ..., rax: bool | int = ..., reflectionAboutY: bool | int = ..., ray: bool | int = ..., reflectionAboutZ: bool | int = ..., raz: bool | int = ..., reflectionTolerance: float = ..., rft: float = ..., relative: bool | int = ..., r: bool | int = ..., rotateAxis: bool | int | Tuple[float, float, float] = ..., ra: bool | int | Tuple[float, float, float] = ..., rotateOrder: bool | int | _util.ProxyUnicode | str = ..., roo: bool | int | _util.ProxyUnicode | str = ..., rotatePivot: bool | int | Tuple[float, float, float] = ..., rp: bool | int | Tuple[float, float, float] = ..., rotateTranslation: bool | int | Tuple[float, float, float] = ..., rt: bool | int | Tuple[float, float, float] = ..., rotation: bool | int | Tuple[float, float, float] = ..., ro: bool | int | Tuple[float, float, float] = ..., scale: bool | int | Tuple[float, float, float] = ..., s: bool | int | Tuple[float, float, float] = ..., scalePivot: bool | int | Tuple[float, float, float] = ..., sp: bool | int | Tuple[float, float, float] = ..., scaleTranslation: bool | int | Tuple[float, float, float] = ..., st: bool | int | Tuple[float, float, float] = ..., shear: bool | int | Tuple[float, float, float] = ..., sh: bool | int | Tuple[float, float, float] = ..., translation: bool | int | Tuple[float, float, float] = ..., t: bool | int | Tuple[float, float, float] = ..., worldSpace: bool | int = ..., ws: bool | int = ..., worldSpaceDistance: bool | int = ..., wd: bool | int = ..., zeroTransformPivots: bool | int = ..., ztp: bool | int = ...) -> Any: ...
def xformConstraint(*args, alongNormal: bool | int | int = ..., n: bool | int | int = ..., edit: bool | int = ..., e: bool | int = ..., live: bool | int = ..., l: bool | int = ..., query: bool | int = ..., q: bool | int = ..., type: bool | int | _util.ProxyUnicode | str = ..., t: bool | int | _util.ProxyUnicode | str = ...) -> Any: ...
def encodeString(*args) -> Any: ...
def format(*args, stringArg: str | List[str] = ..., s: str | List[str] = ...) -> Any: ...

def assignCommand(*args, addDivider: _util.ProxyUnicode | str = ..., ad: _util.ProxyUnicode | str = ..., altModifier: bool | int = ..., alt: bool | int = ..., annotation: bool | int | _util.ProxyUnicode | str = ..., ann: bool | int | _util.ProxyUnicode | str = ..., command: bool | int | str | Callable = ..., c: bool | int | str | Callable = ..., commandModifier: bool | int = ..., cmd: bool | int = ..., ctrlModifier: bool | int = ..., ctl: bool | int = ..., data1: bool | int | _util.ProxyUnicode | str = ..., da1: bool | int | _util.ProxyUnicode | str = ..., data2: bool | int | _util.ProxyUnicode | str = ..., da2: bool | int | _util.ProxyUnicode | str = ..., data3: bool | int | _util.ProxyUnicode | str = ..., da3: bool | int | _util.ProxyUnicode | str = ..., delete: int = ..., d: int = ..., dividerString: bool | int | _util.ProxyUnicode | str = ..., ds: bool | int | _util.ProxyUnicode | str = ..., edit: bool | int = ..., e: bool | int = ..., enableCommandRepeat: bool | int = ..., ecr: bool | int = ..., factorySettings: bool | int = ..., fs: bool | int = ..., index: int = ..., i: int = ..., keyArray: bool | int = ..., ka: bool | int = ..., keyString: bool | int | _util.ProxyUnicode | str = ..., k: bool | int | _util.ProxyUnicode | str = ..., keyUp: bool | int = ..., kup: bool | int = ..., name: bool | int = ..., n: bool | int = ..., numDividersPreceding: bool | int | int = ..., ndp: bool | int | int = ..., numElements: bool | int = ..., num: bool | int = ..., optionModifier: bool | int = ..., opt: bool | int = ..., query: bool | int = ..., q: bool | int = ..., sortByKey: bool | int = ..., sbk: bool | int = ..., sourceUserCommands: bool | int = ..., suc: bool | int = ...): ...

def commandEcho(*args, addFilter: _util.ProxyUnicode | str = ..., af: _util.ProxyUnicode | str = ..., filter: bool | int | _util.ProxyUnicode | str = ..., f: bool | int | _util.ProxyUnicode | str = ..., lineNumbers: bool | int = ..., ln: bool | int = ..., query: bool | int = ..., q: bool | int = ..., state: bool | int = ..., st: bool | int = ...) -> Any: ...

def condition(*args, delete: bool | int = ..., dependency: str | List[str] = ..., d: str | List[str] = ..., edit: bool | int = ..., e: bool | int = ..., initialize: bool | int = ..., i: bool | int = ..., query: bool | int = ..., q: bool | int = ..., script: _util.ProxyUnicode | str = ..., s: _util.ProxyUnicode | str = ..., state: bool | int = ..., st: bool | int = ...): ...

def evalDeferred(*args, evaluateNext: bool | int = ..., en: bool | int = ..., list: bool | int = ..., ls: bool | int = ..., lowPriority: bool | int = ..., low: bool | int = ..., lowestPriority: bool | int = ..., lp: bool | int = ...) -> Any: ...
def isTrue(*args) -> Any: ...
def itemFilter(*args, byBin: bool | int | str | List[str] = ..., bk: bool | int | str | List[str] = ..., byName: bool | int | _util.ProxyUnicode | str = ..., bn: bool | int | _util.ProxyUnicode | str = ..., byScript: bool | int | _util.ProxyUnicode | str = ..., bs: bool | int | _util.ProxyUnicode | str = ..., byType: bool | int | str | List[str] = ..., bt: bool | int | str | List[str] = ..., category: bool | int | str | List[str] = ..., cat: bool | int | str | List[str] = ..., classification: bool | int | _util.ProxyUnicode | str = ..., cls: bool | int | _util.ProxyUnicode | str = ..., clearByBin: bool | int = ..., cbk: bool | int = ..., clearByType: bool | int = ..., cbt: bool | int = ..., difference: bool | int | Tuple[str, str] = ..., di: bool | int | Tuple[str, str] = ..., edit: bool | int = ..., e: bool | int = ..., exists: bool | int = ..., ex: bool | int = ..., intersect: bool | int | Tuple[str, str] = ..., listBuiltInFilters: bool | int = ..., lbf: bool | int = ..., listOtherFilters: bool | int = ..., lof: bool | int = ..., listUserFilters: bool | int = ..., luf: bool | int = ..., negate: bool | int = ..., neg: bool | int = ..., parent: bool | int | _util.ProxyUnicode | str = ..., p: bool | int | _util.ProxyUnicode | str = ..., pythonModule: bool | int | _util.ProxyUnicode | str = ..., pym: bool | int | _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., secondScript: bool | int | _util.ProxyUnicode | str = ..., ss: bool | int | _util.ProxyUnicode | str = ..., text: bool | int | _util.ProxyUnicode | str = ..., t: bool | int | _util.ProxyUnicode | str = ..., union: bool | int | Tuple[str, str] = ..., un: bool | int | Tuple[str, str] = ..., uniqueNodeNames: bool | int = ..., unn: bool | int = ...) -> Any: ...
def itemFilterAttr(*args, byName: bool | int | _util.ProxyUnicode | str = ..., bn: bool | int | _util.ProxyUnicode | str = ..., byNameString: bool | int | str | List[str] = ..., bns: bool | int | str | List[str] = ..., byScript: bool | int | _util.ProxyUnicode | str = ..., bs: bool | int | _util.ProxyUnicode | str = ..., classification: bool | int | _util.ProxyUnicode | str = ..., cls: bool | int | _util.ProxyUnicode | str = ..., dynamic: bool | int = ..., dy: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., exists: bool | int = ..., ex: bool | int = ..., hasCurve: bool | int = ..., hc: bool | int = ..., hasDrivenKey: bool | int = ..., hdk: bool | int = ..., hasExpression: bool | int = ..., he: bool | int = ..., hidden: bool | int = ..., h: bool | int = ..., intersect: bool | int | Tuple[str, str] = ..., keyable: bool | int = ..., k: bool | int = ..., listBuiltInFilters: bool | int = ..., lbf: bool | int = ..., listOtherFilters: bool | int = ..., lof: bool | int = ..., listUserFilters: bool | int = ..., luf: bool | int = ..., negate: bool | int = ..., neg: bool | int = ..., parent: _util.ProxyUnicode | str = ..., p: _util.ProxyUnicode | str = ..., published: bool | int = ..., pub: bool | int = ..., query: bool | int = ..., q: bool | int = ..., readable: bool | int = ..., r: bool | int = ..., scaleRotateTranslate: bool | int = ..., srt: bool | int = ..., secondScript: bool | int | _util.ProxyUnicode | str = ..., ss: bool | int | _util.ProxyUnicode | str = ..., text: bool | int | _util.ProxyUnicode | str = ..., t: bool | int | _util.ProxyUnicode | str = ..., union: bool | int | Tuple[str, str] = ..., un: bool | int | Tuple[str, str] = ..., writable: bool | int = ..., w: bool | int = ...) -> Any: ...
def itemFilterRender(*args, anyTextures: bool | int = ..., at: bool | int = ..., category: str | List[str] = ..., cat: str | List[str] = ..., classification: _util.ProxyUnicode | str = ..., cls: _util.ProxyUnicode | str = ..., edit: bool | int = ..., e: bool | int = ..., exclusiveLights: bool | int = ..., exl: bool | int = ..., exists: bool | int = ..., ex: bool | int = ..., lightSets: bool | int = ..., ls: bool | int = ..., lights: bool | int = ..., l: bool | int = ..., linkedLights: bool | int = ..., ll: bool | int = ..., listBuiltInFilters: bool | int = ..., lbf: bool | int = ..., listOtherFilters: bool | int = ..., lof: bool | int = ..., listUserFilters: bool | int = ..., luf: bool | int = ..., negate: bool | int = ..., neg: bool | int = ..., nodeClassification: str | List[str] = ..., nc: str | List[str] = ..., nonExclusiveLights: bool | int = ..., nxl: bool | int = ..., nonIlluminatingLights: bool | int = ..., nil: bool | int = ..., parent: _util.ProxyUnicode | str = ..., p: _util.ProxyUnicode | str = ..., postProcess: bool | int = ..., pp: bool | int = ..., query: bool | int = ..., q: bool | int = ..., renderUtilityNode: bool | int = ..., run: bool | int = ..., renderableObjectSets: bool | int = ..., ros: bool | int = ..., renderingNode: bool | int = ..., rn: bool | int = ..., shaders: bool | int = ..., s: bool | int = ..., text: _util.ProxyUnicode | str = ..., t: _util.ProxyUnicode | str = ..., textures2d: bool | int = ..., t2d: bool | int = ..., textures3d: bool | int = ..., t3d: bool | int = ..., texturesProcedural: bool | int = ..., tp: bool | int = ...) -> Any: ...
def itemFilterType(*args, edit: bool | int = ..., e: bool | int = ..., query: bool | int = ..., q: bool | int = ..., text: bool | int | _util.ProxyUnicode | str = ..., t: bool | int | _util.ProxyUnicode | str = ..., type: bool | int = ..., typ: bool | int = ...) -> Any: ...
def pause(*args, seconds: int = ..., sec: int = ...) -> Any: ...
def refresh(*args, currentView: bool | int = ..., cv: bool | int = ..., fileExtension: _util.ProxyUnicode | str = ..., fe: _util.ProxyUnicode | str = ..., filename: _util.ProxyUnicode | str = ..., fn: _util.ProxyUnicode | str = ..., force: bool | int = ..., f: bool | int = ..., suspend: bool | int = ..., su: bool | int = ...) -> Any: ...
def stringArrayIntersector(*args, allowDuplicates: bool | int = ..., ad: bool | int = ..., defineTemplate: _util.ProxyUnicode | str = ..., dt: _util.ProxyUnicode | str = ..., edit: bool | int = ..., e: bool | int = ..., exists: bool | int = ..., ex: bool | int = ..., intersect: _util.ProxyUnicode | str = ..., i: _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., reset: bool | int = ..., r: bool | int = ..., useTemplate: _util.ProxyUnicode | str = ..., ut: _util.ProxyUnicode | str = ...) -> Any: ...

def selectionConnection(*args, activeCacheList: bool | int = ..., atc: bool | int = ..., activeCharacterList: bool | int = ..., acl: bool | int = ..., activeList: bool | int = ..., act: bool | int = ..., addScript: bool | int | str | Callable = ..., addTo: _util.ProxyUnicode | str = ..., add: _util.ProxyUnicode | str = ..., characterList: bool | int = ..., cl: bool | int = ..., clear: bool | int = ..., clr: bool | int = ..., connectionList: bool | int = ..., lst: bool | int = ..., defineTemplate: _util.ProxyUnicode | str = ..., dt: _util.ProxyUnicode | str = ..., deselect: None | str = ..., d: None | str = ..., edit: bool | int = ..., e: bool | int = ..., editor: bool | int | _util.ProxyUnicode | str = ..., ed: bool | int | _util.ProxyUnicode | str = ..., exists: bool | int = ..., ex: bool | int = ..., filter: bool | int | _util.ProxyUnicode | str = ..., f: bool | int | _util.ProxyUnicode | str = ..., findObject: bool | int | None | str = ..., fo: bool | int | None | str = ..., g: bool | int = ..., highlightList: bool | int = ..., hl: bool | int = ..., identify: bool | int = ..., id: bool | int = ..., keyframeList: bool | int = ..., key: bool | int = ..., lock: bool | int = ..., lck: bool | int = ..., modelList: bool | int = ..., mdl: bool | int = ..., object: bool | int | None | str = ..., obj: bool | int | None | str = ..., parent: bool | int | _util.ProxyUnicode | str = ..., p: bool | int | _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., remove: _util.ProxyUnicode | str = ..., rm: _util.ProxyUnicode | str = ..., removeScript: bool | int | str | Callable = ..., rs: bool | int | str | Callable = ..., select: None | str = ..., s: None | str = ..., setList: bool | int = ..., sl: bool | int = ..., switch: bool | int = ..., sw: bool | int = ..., useTemplate: _util.ProxyUnicode | str = ..., ut: _util.ProxyUnicode | str = ..., worldList: bool | int = ..., wl: bool | int = ...): ...
