from typing import *
import pymel.util as _util
import abc
import pymel.core.general as general
import pymel.core.nodetypes as nt
from _typeshed import Incomplete
from builtins import str
from collections.abc import MutableMapping
from pymel.util.decoration import decorator as decorator
from pymel.util.scanf import fscanf as fscanf
from typing import Any, Callable, List, Optional, Tuple, Union, overload

TYPE_CHECKING: bool

if LUMA:
    import luma.filepath
    pathClass = luma.filepath.Path
else:
    pathClass = _util.path

def getTypeFromExtension(path: str, mode: str = ...) -> str: ...

displayError: Incomplete
displayWarning: Incomplete
displayInfo: Incomplete

def feof(fileid): ...
def sceneName() -> Path: ...
def untitledFileName() -> str: ...

class UndoChunk:
    name: Incomplete
    def __init__(self, name: Optional[str] = ...) -> None: ...
    def __enter__(self): ...
    def __exit__(*args, **kwargs) -> None: ...

class Namespace(str):
    @classmethod
    def getCurrent(cls) -> Namespace: ...
    @classmethod
    def create(cls, name: Any) -> Namespace: ...
    def __new__(cls, namespace: str, create: bool = ...) -> Namespace: ...
    def __add__(self, other): ...
    def __cmp__(self, other): ...
    __eq__: Incomplete
    __ne__: Incomplete
    __le__: Incomplete
    __lt__: Incomplete
    __ge__: Incomplete
    __gt__: Incomplete
    def __hash__(self): ...
    def splitAll(self) -> List[str]: ...
    def shortName(self) -> str: ...
    def getParent(self) -> Optional[Namespace]: ...
    def ls(self, pattern: str = ..., **kwargs: Any) -> List[general.PyNode]: ...
    def getNode(self, nodeName: str, verify: bool = ...) -> general.PyNode: ...
    def listNamespaces(self, recursive: bool = ..., internal: bool = ...) -> List[Namespace]: ...
    def listNodes(self, recursive: bool = ..., internal: bool = ...) -> List[general.PyNode]: ...
    def setCurrent(self) -> None: ...
    def clean(self, haltOnError: bool = ..., reparentOtherChildren: bool = ...) -> None: ...
    def move(self, other, force: bool = ...) -> None: ...
    def remove(self, haltOnError: bool = ..., reparentOtherChildren: bool = ...) -> None: ...

def listNamespaces_old(): ...
def listNamespaces(root: Optional[str] = ..., recursive: bool = ..., internal: bool = ...) -> List[Namespace]: ...
def namespaceInfo(*args, absoluteName: bool | int = ..., an: bool | int = ..., baseName: bool | int = ..., bn: bool | int = ..., currentNamespace: bool | int = ..., cur: bool | int = ..., dagPath: bool | int = ..., dp: bool | int = ..., fullName: bool | int = ..., fn: bool | int = ..., internal: bool | int = ..., int: bool | int = ..., isRootNamespace: bool | int = ..., ir: bool | int = ..., listNamespace: bool | int = ..., ls: bool | int = ..., listOnlyDependencyNodes: bool | int = ..., lod: bool | int = ..., listOnlyNamespaces: bool | int = ..., lon: bool | int = ..., parent: bool | int = ..., p: bool | int = ..., recurse: bool | int = ..., r: bool | int = ..., shortName: bool | int = ..., sn: bool | int = ...): ...

class Translator:
    @staticmethod
    def listRegistered() -> List[str]: ...
    @staticmethod
    def fromExtension(ext: str, mode: str = ..., caseSensitive: bool = ...) -> Optional[Translator]: ...
    def __init__(self, name: str) -> None: ...
    def extension(self) -> str: ...
    ext: Incomplete
    name: Incomplete
    def filter(self): ...
    def optionsScript(self): ...
    def hasReadSupport(self): ...
    def hasWriteSupport(self): ...
    def getDefaultOptions(self): ...
    def setDefaultOptions(self, options) -> None: ...
    def getFileCompression(self): ...
    def setFileCompression(self, compression) -> None: ...

class WorkspaceEntryDict:
    entryType: Incomplete
    def __init__(self, entryType: str) -> None: ...
    def __getitem__(self, item): ...
    def __setitem__(self, item, value): ...
    def __contains__(self, key: str) -> bool: ...
    def items(self) -> List[Tuple[str, str]]: ...
    def keys(self) -> List[str]: ...
    def values(self) -> List[str]: ...
    def get(self, item, default: Incomplete | None = ...): ...
    def __iter__(self): ...
    has_key = __contains__

class Workspace:
    objectTypes: Incomplete
    fileRules: Incomplete
    renderTypes: Incomplete
    variables: Incomplete
    @classmethod
    def open(self, workspace): ...
    @classmethod
    def save(self): ...
    @classmethod
    def update(self): ...
    @classmethod
    def new(self, workspace): ...
    @classmethod
    def getName(self): ...
    @classmethod
    def getPath(self) -> Path: ...
    @classmethod
    def chdir(self, newdir): ...
    @classmethod
    def getcwd(self) -> Path: ...
    @classmethod
    def mkdir(self, newdir): ...
    @property
    def path(self) -> Path: ...
    @property
    def name(self) -> str: ...
    def __call__(self, *args, **kwargs): ...
    def expandName(self, path): ...

workspace: Workspace

class SingletonABCMeta(_util.Singleton, abc.ABCMeta): ...

class FileInfo(MutableMapping):
    def __getitem__(self, item: str) -> str: ...
    def __setitem__(self, item, value) -> None: ...
    def __delitem__(self, item: str) -> None: ...
    def __call__(self, *args, **kwargs): ...
    def items(self) -> List[Tuple[str, str]]: ...
    def keys(self) -> List[str]: ...
    def __iter__(self) -> Iterator[str]: ...
    def __len__(self) -> int: ...
    has_key: Incomplete

fileInfo: FileInfo

class Path(pathClass):
    getTypeName: Incomplete
    setSubType: Incomplete


@overload
def iterReferences(parentReference: Union[str, Path, FileReference, None] = ..., recursive: bool = ..., recurseType: str = ..., loaded: Optional[bool] = ..., unloaded: Optional[bool] = ...) -> Iterator[FileReference]: ...
@overload
def iterReferences(parentReference: Union[str, Path, FileReference, None] = ..., recursive: bool = ..., namespaces: Literal[True] = ..., recurseType: str = ..., loaded: Optional[bool] = ..., unloaded: Optional[bool] = ...) -> Iterator[Tuple[str, FileReference]]: ...
@overload
def iterReferences(parentReference: Union[str, Path, FileReference, None] = ..., recursive: bool = ..., refNodes: Literal[True] = ..., recurseType: str = ..., loaded: Optional[bool] = ..., unloaded: Optional[bool] = ...) -> Iterator[Tuple[nt.Reference, FileReference]]: ...
@overload
def iterReferences(parentReference: Union[str, Path, FileReference, None] = ..., recursive: bool = ..., namespaces: Literal[True] = ..., refNodes: Literal[False] = ..., references: Literal[False] = ..., recurseType: str = ..., loaded: Optional[bool] = ..., unloaded: Optional[bool] = ...) -> Iterator[str]: ...
@overload
def iterReferences(parentReference: Union[str, Path, FileReference, None] = ..., recursive: bool = ..., namespaces: Literal[False] = ..., refNodes: Literal[True] = ..., references: Literal[False] = ..., recurseType: str = ..., loaded: Optional[bool] = ..., unloaded: Optional[bool] = ...) -> Iterator[nt.Reference]: ...
@overload
def iterReferences(parentReference: Union[str, Path, FileReference, None] = ..., recursive: bool = ..., namespaces: Literal[True] = ..., refNodes: Literal[True] = ..., references: Literal[False] = ..., recurseType: str = ..., loaded: Optional[bool] = ..., unloaded: Optional[bool] = ...) -> Iterator[Tuple[str, nt.Reference]]: ...
@overload
def iterReferences(parentReference: Union[str, Path, FileReference, None] = ..., recursive: bool = ..., namespaces: Literal[True] = ..., refNodes: Literal[True] = ..., references: Literal[True] = ..., recurseType: str = ..., loaded: Optional[bool] = ..., unloaded: Optional[bool] = ...) -> Iterator[Tuple[str, nt.Reference, FileReference]]: ...
@overload
def listReferences(parentReference: Union[str, Path, FileReference, None] = ..., recursive: bool = ..., recurseType: str = ..., loaded: Optional[bool] = ..., unloaded: Optional[bool] = ...) -> List[FileReference]: ...
@overload
def listReferences(parentReference: Union[str, Path, FileReference, None] = ..., recursive: bool = ..., namespaces: Literal[True] = ..., recurseType: str = ..., loaded: Optional[bool] = ..., unloaded: Optional[bool] = ...) -> List[Tuple[str, FileReference]]: ...
@overload
def listReferences(parentReference: Union[str, Path, FileReference, None] = ..., recursive: bool = ..., refNodes: Literal[True] = ..., recurseType: str = ..., loaded: Optional[bool] = ..., unloaded: Optional[bool] = ...) -> List[Tuple[nt.Reference, FileReference]]: ...
@overload
def listReferences(parentReference: Union[str, Path, FileReference, None] = ..., recursive: bool = ..., namespaces: Literal[True] = ..., refNodes: Literal[False] = ..., references: Literal[False] = ..., recurseType: str = ..., loaded: Optional[bool] = ..., unloaded: Optional[bool] = ...) -> List[str]: ...
@overload
def listReferences(parentReference: Union[str, Path, FileReference, None] = ..., recursive: bool = ..., namespaces: Literal[False] = ..., refNodes: Literal[True] = ..., references: Literal[False] = ..., recurseType: str = ..., loaded: Optional[bool] = ..., unloaded: Optional[bool] = ...) -> List[nt.Reference]: ...
@overload
def listReferences(parentReference: Union[str, Path, FileReference, None] = ..., recursive: bool = ..., namespaces: Literal[True] = ..., refNodes: Literal[True] = ..., references: Literal[False] = ..., recurseType: str = ..., loaded: Optional[bool] = ..., unloaded: Optional[bool] = ...) -> List[Tuple[str, nt.Reference]]: ...
@overload
def listReferences(parentReference: Union[str, Path, FileReference, None] = ..., recursive: bool = ..., namespaces: Literal[True] = ..., refNodes: Literal[True] = ..., references: Literal[True] = ..., recurseType: str = ..., loaded: Optional[bool] = ..., unloaded: Optional[bool] = ...) -> Iterator[Tuple[str, nt.Reference, FileReference]]: ...
def getReferences(parentReference: Any = ..., recursive: Any = ...) -> Dict[str, FileReference]: ...

class FileReference:
    def __init__(self, pathOrRefNode: Optional[Union[str, nt.Reference]] = ..., namespace: Optional[str] = ..., refnode: Optional[Union[str, nt.Reference]] = ...) -> None: ...
    def __melobject__(self): ...
    def __gt__(self, other): ...
    def __ge__(self, other): ...
    def __lt__(self, other): ...
    def __le__(self, other): ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...
    def __hash__(self): ...
    def subReferences(self) -> Dict[str, FileReference]: ...
    def namespaceExists(self) -> bool: ...
    @property
    def namespace(self) -> str: ...
    @namespace.setter
    def namespace(self, namespace: str) -> None: ...
    @property
    def fullNamespace(self) -> str: ...
    @property
    def refNode(self) -> nt.Reference: ...
    @property
    def path(self) -> Path: ...
    def withCopyNumber(self) -> str: ...
    def unresolvedPath(self) -> Path: ...
    def parent(self) -> Optional[FileReference]: ...
    def importContents(self, removeNamespace: bool = ...): ...
    def remove(self, **kwargs): ...
    def unload(self): ...
    def load(self, newFile: Incomplete | None = ..., **kwargs): ...
    def replaceWith(self, newFile, **kwargs): ...
    def clean(self, **kwargs): ...
    def lock(self): ...
    def unlock(self): ...
    def isDeferred(self): ...
    def isLoaded(self): ...
    def nodes(self, recursive: bool = ...) -> List[nt.DependNode]: ...
    def copyNumberList(self): ...
    def selectAll(self): ...
    def isUsingNamespaces(self): ...
    def exportAnim(self, exportPath, **kwargs): ...
    def exportSelectedAnim(self, exportPath, **kwargs): ...
    def getReferenceEdits(self, **kwargs): ...
    def removeReferenceEdits(self, editCommand: str = ..., force: bool = ..., **kwargs: Any) -> None: ...

def referenceQuery(*args, child: bool | int = ..., ch: bool | int = ..., dagPath: bool | int = ..., dp: bool | int = ..., editAttrs: bool | int = ..., ea: bool | int = ..., editCommand: bool | int | str | List[str] = ..., ec: bool | int | str | List[str] = ..., editNodes: bool | int = ..., en: bool | int = ..., editStrings: bool | int = ..., es: bool | int = ..., failedEdits: bool | int = ..., fld: bool | int = ..., filename: bool | int = ..., f: bool | int = ..., isExportEdits: bool | int = ..., iee: bool | int = ..., isLoaded: bool | int = ..., il: bool | int = ..., isNodeReferenced: bool | int = ..., inr: bool | int = ..., isPreviewOnly: bool | int = ..., ipo: bool | int = ..., liveEdits: bool | int = ..., le: bool | int = ..., namespace: bool | int = ..., ns: bool | int = ..., nodes: bool | int = ..., n: bool | int = ..., onReferenceNode: bool | int | str | List[str] = ..., orn: bool | int | str | List[str] = ..., parent: bool | int = ..., p: bool | int = ..., parentNamespace: bool | int = ..., pns: bool | int = ..., referenceNode: bool | int = ..., rfn: bool | int = ..., shortName: bool | int = ..., shn: bool | int = ..., showDagPath: bool | int = ..., sdp: bool | int = ..., showNamespace: bool | int = ..., sns: bool | int = ..., successfulEdits: bool | int = ..., scs: bool | int = ..., topReference: bool | int = ..., tr: bool | int = ..., unresolvedName: bool | int = ..., un: bool | int = ..., withoutCopyNumber: bool | int = ..., wcn: bool | int = ...): ...

class ReferenceEdit(str):
    type: Incomplete
    fileReference: Incomplete
    successful: Incomplete
    def __new__(cls, editStr, fileReference: Incomplete | None = ..., successful: Incomplete | None = ...): ...
    namespace: Incomplete
    fullNamespace: Incomplete
    def remove(self, force: bool = ...) -> None: ...
    editData: Incomplete
    rawEditData: Incomplete

def createReference(filepath: str, **kwargs: Any) -> FileReference: ...
def loadReference(filepath: str, **kwargs: Any) -> FileReference: ...
def exportAll(exportPath: str, **kwargs: Any) -> Path: ...
def exportAsReference(exportPath: str, **kwargs: Any) -> FileReference: ...
def exportSelected(exportPath: str, **kwargs: Any) -> Path: ...
def exportAnim(exportPath: str, **kwargs: Any) -> Path: ...
def exportSelectedAnim(exportPath: str, **kwargs: Any) -> Path: ...
def exportAnimFromReference(exportPath: str, **kwargs: Any) -> Path: ...
def exportSelectedAnimFromReference(exportPath: str, **kwargs: Any) -> Path: ...
def importFile(filepath, **kwargs): ...
def newFile(**kwargs): ...
def openFile(filepath, **kwargs): ...
def renameFile(newname, *args, **kwargs): ...
def saveFile(**kwargs): ...
def saveAs(newname: Any, **kwargs: Any) -> Path: ...
def isModified(): ...

def aaf2fcp(*args, deleteFile: bool | int = ..., df: bool | int = ..., dstPath: _util.ProxyUnicode | str = ..., dst: _util.ProxyUnicode | str = ..., getFileName: int = ..., gfn: int = ..., progress: int = ..., pr: int = ..., srcFile: _util.ProxyUnicode | str = ..., src: _util.ProxyUnicode | str = ..., terminate: int = ..., t: int = ..., waitCompletion: int = ..., wc: int = ...) -> Any: ...
def allNodeTypes(*args, includeAbstract: bool | int = ..., ia: bool | int = ...) -> Any: ...
def assignInputDevice(*args, clutch: _util.ProxyUnicode | str = ..., c: _util.ProxyUnicode | str = ..., continuous: bool | int = ..., ct: bool | int = ..., device: _util.ProxyUnicode | str = ..., d: _util.ProxyUnicode | str = ..., immediate: bool | int = ..., im: bool | int = ..., multiple: bool | int = ..., m: bool | int = ...) -> Any: ...
def attachDeviceAttr(*args, attribute: str | List[str] = ..., at: str | List[str] = ..., axis: _util.ProxyUnicode | str = ..., ax: _util.ProxyUnicode | str = ..., camera: bool | int = ..., cam: bool | int = ..., cameraRotate: bool | int = ..., cr: bool | int = ..., cameraTranslate: bool | int = ..., ct: bool | int = ..., clutch: _util.ProxyUnicode | str = ..., c: _util.ProxyUnicode | str = ..., device: _util.ProxyUnicode | str = ..., d: _util.ProxyUnicode | str = ..., selection: bool | int = ..., sl: bool | int = ...) -> Any: ...
def audioTrack(*args, edit: bool | int = ..., e: bool | int = ..., insertTrack: int = ..., it: int = ..., lock: bool | int = ..., l: bool | int = ..., mute: bool | int = ..., m: bool | int = ..., numTracks: bool | int | int = ..., nt: bool | int | int = ..., query: bool | int = ..., q: bool | int = ..., removeEmptyTracks: bool | int = ..., ret: bool | int = ..., removeTrack: int = ..., rt: int = ..., solo: bool | int = ..., so: bool | int = ..., swapTracks: Tuple[int, int] = ..., st: Tuple[int, int] = ..., title: bool | int | _util.ProxyUnicode | str = ..., t: bool | int | _util.ProxyUnicode | str = ..., track: bool | int | int = ..., tr: bool | int | int = ...) -> Any: ...
def autoSave(*args, destination: bool | int | int = ..., dst: bool | int | int = ..., destinationFolder: bool | int = ..., df: bool | int = ..., enable: bool | int = ..., en: bool | int = ..., folder: bool | int | _util.ProxyUnicode | str = ..., fol: bool | int | _util.ProxyUnicode | str = ..., interval: bool | int | float = ..., int: bool | int | float = ..., limitBackups: bool | int = ..., lim: bool | int = ..., maxBackups: bool | int | int = ..., max: bool | int | int = ..., perform: bool | int = ..., p: bool | int = ..., prompt: bool | int = ..., prm: bool | int = ..., query: bool | int = ..., q: bool | int = ...) -> Any: ...
def cacheFile(*args, appendFrame: bool | int = ..., apf: bool | int = ..., attachFile: bool | int = ..., af: bool | int = ..., cacheFileNode: str | List[str] = ..., cfn: str | List[str] = ..., cacheFormat: bool | int | _util.ProxyUnicode | str = ..., cf: bool | int | _util.ProxyUnicode | str = ..., cacheInfo: bool | int | str | List[str] = ..., ci: bool | int | str | List[str] = ..., cacheableAttrs: bool | int | _util.ProxyUnicode | str = ..., cat: bool | int | _util.ProxyUnicode | str = ..., cacheableNode: str | List[str] = ..., cnd: str | List[str] = ..., channelIndex: bool | int = ..., chi: bool | int = ..., channelName: bool | int | str | List[str] = ..., cnm: bool | int | str | List[str] = ..., convertPc2: bool | int = ..., pc2: bool | int = ..., createCacheNode: bool | int = ..., ccn: bool | int = ..., creationChannelName: str | List[str] = ..., cch: str | List[str] = ..., dataSize: bool | int = ..., dsz: bool | int = ..., deleteCachedFrame: bool | int = ..., dcf: bool | int = ..., descriptionFileName: bool | int = ..., dfn: bool | int = ..., directory: bool | int | _util.ProxyUnicode | str = ..., dir: bool | int | _util.ProxyUnicode | str = ..., doubleToFloat: bool | int = ..., dtf: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., endTime: int | float = ..., et: int | float = ..., fileName: bool | int | _util.ProxyUnicode | str = ..., f: bool | int | _util.ProxyUnicode | str = ..., format: _util.ProxyUnicode | str = ..., fm: _util.ProxyUnicode | str = ..., geometry: bool | int = ..., gm: bool | int = ..., inAttr: str | List[str] = ..., ia: str | List[str] = ..., inTangent: _util.ProxyUnicode | str = ..., it: _util.ProxyUnicode | str = ..., interpEndTime: int | float = ..., iet: int | float = ..., interpStartTime: int | float = ..., ist: int | float = ..., noBackup: bool | int = ..., nb: bool | int = ..., outAttr: str | List[str] = ..., oa: str | List[str] = ..., outTangent: _util.ProxyUnicode | str = ..., ot: _util.ProxyUnicode | str = ..., pc2File: _util.ProxyUnicode | str = ..., pcf: _util.ProxyUnicode | str = ..., pointCount: bool | int = ..., pc: bool | int = ..., points: str | List[str] = ..., pts: str | List[str] = ..., pointsAndNormals: str | List[str] = ..., pan: str | List[str] = ..., prefix: bool | int = ..., p: bool | int = ..., query: bool | int = ..., q: bool | int = ..., refresh: bool | int = ..., r: bool | int = ..., replaceCachedFrame: bool | int = ..., rcf: bool | int = ..., replaceWithoutSimulating: bool | int = ..., rws: bool | int = ..., runupFrames: bool | int | int = ..., rf: bool | int | int = ..., sampleMultiplier: bool | int | int = ..., spm: bool | int | int = ..., simulationRate: bool | int | int | float = ..., smr: bool | int | int | float = ..., singleCache: bool | int = ..., sch: bool | int = ..., startTime: int | float = ..., st: int | float = ..., staticCache: bool | int = ..., sc: bool | int = ..., worldSpace: bool | int = ..., ws: bool | int = ...) -> Any: ...
def cacheFileCombine(*args, cacheIndex: bool | int = ..., ci: bool | int = ..., channelName: str | List[str] = ..., cnm: str | List[str] = ..., connectCache: bool | int | _util.ProxyUnicode | str = ..., cc: bool | int | _util.ProxyUnicode | str = ..., edit: bool | int = ..., e: bool | int = ..., keepWeights: bool | int = ..., kw: bool | int = ..., layerNode: bool | int = ..., ln: bool | int = ..., nextAvailable: bool | int = ..., na: bool | int = ..., object: bool | int | _util.ProxyUnicode | str = ..., obj: bool | int | _util.ProxyUnicode | str = ..., objectIndex: bool | int | int = ..., oi: bool | int | int = ..., query: bool | int = ..., q: bool | int = ...) -> Any: ...
def cacheFileMerge(*args, edit: bool | int = ..., e: bool | int = ..., endTime: int | float = ..., et: int | float = ..., geometry: bool | int = ..., g: bool | int = ..., query: bool | int = ..., q: bool | int = ..., startTime: int | float = ..., st: int | float = ...) -> Any: ...
def cacheFileTrack(*args, edit: bool | int = ..., e: bool | int = ..., insertTrack: int = ..., it: int = ..., lock: bool | int = ..., l: bool | int = ..., mute: bool | int = ..., m: bool | int = ..., query: bool | int = ..., q: bool | int = ..., removeEmptyTracks: bool | int = ..., ret: bool | int = ..., removeTrack: int = ..., rt: int = ..., solo: bool | int = ..., so: bool | int = ..., track: bool | int | int = ..., t: bool | int | int = ...) -> Any: ...
def clearCache(*args, allNodes: bool | int = ..., all: bool | int = ..., computed: bool | int = ..., c: bool | int = ..., dirty: bool | int = ..., d: bool | int = ...) -> Any: ...
def cmdFileOutput(*args, close: int = ..., c: int = ..., closeAll: bool | int = ..., ca: bool | int = ..., open: bool | int | _util.ProxyUnicode | str = ..., o: bool | int | _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., status: bool | int | int = ..., s: bool | int | int = ...) -> Any: ...
def convertUnit(*args, fromUnit: _util.ProxyUnicode | str = ..., f: _util.ProxyUnicode | str = ..., toUnit: _util.ProxyUnicode | str = ..., t: _util.ProxyUnicode | str = ...) -> Any: ...
def crashInfo(*args, crashFile: bool | int = ..., cf: bool | int = ..., query: bool | int = ..., q: bool | int = ..., savedBeforeCrash: bool | int = ..., sbc: bool | int = ...) -> Any: ...
def dagObjectCompare(*args, attribute: bool | int = ..., a: bool | int = ..., bail: _util.ProxyUnicode | str = ..., b: _util.ProxyUnicode | str = ..., connection: bool | int = ..., c: bool | int = ..., namespace: _util.ProxyUnicode | str = ..., n: _util.ProxyUnicode | str = ..., relative: bool | int = ..., r: bool | int = ..., short: bool | int = ..., s: bool | int = ..., type: bool | int = ..., t: bool | int = ...) -> Any: ...
def date(*args, date: bool | int = ..., d: bool | int = ..., format: _util.ProxyUnicode | str = ..., f: _util.ProxyUnicode | str = ..., shortDate: bool | int = ..., sd: bool | int = ..., shortTime: bool | int = ..., st: bool | int = ..., time: bool | int = ..., t: bool | int = ...) -> Any: ...
def dbcount(*args, enabled: bool | int = ..., e: bool | int = ..., file: _util.ProxyUnicode | str = ..., f: _util.ProxyUnicode | str = ..., keyword: _util.ProxyUnicode | str = ..., k: _util.ProxyUnicode | str = ..., list: bool | int = ..., l: bool | int = ..., maxdepth: int = ..., md: int = ..., quick: bool | int = ..., q: bool | int = ..., reset: bool | int = ..., r: bool | int = ..., spreadsheet: bool | int = ..., s: bool | int = ...) -> Any: ...
def dbfootprint(*args, allObjects: bool | int = ..., all: bool | int = ..., outputFile: _util.ProxyUnicode | str = ..., of: _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., type: bool | int | _util.ProxyUnicode | str = ..., t: bool | int | _util.ProxyUnicode | str = ...) -> Any: ...
def dbmessage(*args, file: _util.ProxyUnicode | str = ..., f: _util.ProxyUnicode | str = ..., list: bool | int = ..., l: bool | int = ..., monitor: bool | int = ..., m: bool | int = ..., type: _util.ProxyUnicode | str = ..., t: _util.ProxyUnicode | str = ...) -> Any: ...
def dbpeek(*args, allObjects: bool | int = ..., all: bool | int = ..., argument: bool | int | str | List[str] = ..., a: bool | int | str | List[str] = ..., count: bool | int | int = ..., c: bool | int | int = ..., evaluationGraph: bool | int = ..., eg: bool | int = ..., operation: bool | int | _util.ProxyUnicode | str = ..., op: bool | int | _util.ProxyUnicode | str = ..., outputFile: bool | int | _util.ProxyUnicode | str = ..., of: bool | int | _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ...) -> Any: ...
def dbtrace(*args, filter: bool | int | _util.ProxyUnicode | str = ..., f: bool | int | _util.ProxyUnicode | str = ..., info: bool | int = ..., i: bool | int = ..., keyword: bool | int | str | List[str] = ..., k: bool | int | str | List[str] = ..., mark: bool | int = ..., m: bool | int = ..., off: Any = ..., boolean: Any = ..., output: bool | int | _util.ProxyUnicode | str = ..., o: bool | int | _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., timed: bool | int = ..., tm: bool | int = ..., title: _util.ProxyUnicode | str = ..., t: _util.ProxyUnicode | str = ..., verbose: bool | int = ..., v: bool | int = ...) -> Any: ...
def detachDeviceAttr(*args, all: bool | int = ..., attribute: _util.ProxyUnicode | str = ..., at: _util.ProxyUnicode | str = ..., axis: _util.ProxyUnicode | str = ..., ax: _util.ProxyUnicode | str = ..., device: _util.ProxyUnicode | str = ..., d: _util.ProxyUnicode | str = ..., selection: bool | int = ..., sl: bool | int = ...) -> Any: ...
def deviceEditor(*args, control: bool | int = ..., ctl: bool | int = ..., defineTemplate: _util.ProxyUnicode | str = ..., dt: _util.ProxyUnicode | str = ..., docTag: bool | int | _util.ProxyUnicode | str = ..., dtg: bool | int | _util.ProxyUnicode | str = ..., exists: bool | int = ..., ex: bool | int = ..., filter: bool | int | _util.ProxyUnicode | str = ..., f: bool | int | _util.ProxyUnicode | str = ..., forceMainConnection: bool | int | _util.ProxyUnicode | str = ..., fmc: bool | int | _util.ProxyUnicode | str = ..., highlightConnection: bool | int | _util.ProxyUnicode | str = ..., hlc: bool | int | _util.ProxyUnicode | str = ..., lockMainConnection: bool | int = ..., lck: bool | int = ..., mainListConnection: bool | int | _util.ProxyUnicode | str = ..., mlc: bool | int | _util.ProxyUnicode | str = ..., panel: bool | int | _util.ProxyUnicode | str = ..., pnl: bool | int | _util.ProxyUnicode | str = ..., parent: bool | int | _util.ProxyUnicode | str = ..., p: bool | int | _util.ProxyUnicode | str = ..., selectionConnection: bool | int | _util.ProxyUnicode | str = ..., slc: bool | int | _util.ProxyUnicode | str = ..., stateString: bool | int = ..., sts: bool | int = ..., takePath: bool | int | _util.ProxyUnicode | str = ..., tp: bool | int | _util.ProxyUnicode | str = ..., unParent: bool | int = ..., up: bool | int = ..., unlockMainConnection: bool | int = ..., ulk: bool | int = ..., updateMainConnection: bool | int = ..., upd: bool | int = ..., useTemplate: _util.ProxyUnicode | str = ..., ut: _util.ProxyUnicode | str = ...) -> Any: ...

def devicePanel(*args, control: bool | int = ..., ctl: bool | int = ..., copy: _util.ProxyUnicode | str = ..., cp: _util.ProxyUnicode | str = ..., createString: bool | int = ..., cs: bool | int = ..., defineTemplate: _util.ProxyUnicode | str = ..., dt: _util.ProxyUnicode | str = ..., docTag: bool | int | _util.ProxyUnicode | str = ..., dtg: bool | int | _util.ProxyUnicode | str = ..., editString: bool | int = ..., es: bool | int = ..., exists: bool | int = ..., ex: bool | int = ..., init: bool | int = ..., isUnique: bool | int = ..., iu: bool | int = ..., label: bool | int | _util.ProxyUnicode | str = ..., l: bool | int | _util.ProxyUnicode | str = ..., menuBarRepeatLast: bool | int = ..., mrl: bool | int = ..., menuBarVisible: bool | int = ..., mbv: bool | int = ..., needsInit: bool | int = ..., ni: bool | int = ..., parent: _util.ProxyUnicode | str = ..., p: _util.ProxyUnicode | str = ..., popupMenuProcedure: bool | int | str | Callable = ..., pmp: bool | int | str | Callable = ..., replacePanel: _util.ProxyUnicode | str = ..., rp: _util.ProxyUnicode | str = ..., tearOff: bool | int = ..., to: bool | int = ..., tearOffCopy: _util.ProxyUnicode | str = ..., toc: _util.ProxyUnicode | str = ..., tearOffRestore: bool | int = ..., tor: bool | int = ..., unParent: bool | int = ..., up: bool | int = ..., useTemplate: _util.ProxyUnicode | str = ..., ut: _util.ProxyUnicode | str = ...): ...

def dgInfo(*args, allNodes: bool | int = ..., all: bool | int = ..., connections: bool | int = ..., c: bool | int = ..., dirty: bool | int = ..., d: bool | int = ..., nodes: bool | int = ..., n: bool | int = ..., nonDeletable: bool | int = ..., nd: bool | int = ..., outputFile: _util.ProxyUnicode | str = ..., of: _util.ProxyUnicode | str = ..., propagation: bool | int = ..., p: bool | int = ..., short: bool | int = ..., s: bool | int = ..., size: bool | int = ..., sz: bool | int = ..., subgraph: bool | int = ..., sub: bool | int = ..., type: _util.ProxyUnicode | str = ..., nt: _util.ProxyUnicode | str = ...) -> Any: ...
def dgValidateCurve(*args, allCurves: bool | int = ..., a: bool | int = ..., verbose: bool | int = ..., v: bool | int = ...) -> Any: ...
def dgdirty(*args, allPlugs: bool | int = ..., a: bool | int = ..., clean: bool | int = ..., c: bool | int = ..., implicit: bool | int = ..., i: bool | int = ..., list: bool | int | _util.ProxyUnicode | str = ..., l: bool | int | _util.ProxyUnicode | str = ..., propagation: bool | int = ..., p: bool | int = ..., query: bool | int = ..., q: bool | int = ..., showTiming: bool | int = ..., st: bool | int = ..., verbose: bool | int = ..., v: bool | int = ...) -> Any: ...
def dgeval(*args, src: bool | int = ..., verbose: bool | int = ..., v: bool | int = ...) -> Any: ...
def dgfilter(*args, attribute: _util.ProxyUnicode | str = ..., atr: _util.ProxyUnicode | str = ..., list: bool | int = ..., l: bool | int = ..., logicalAnd: Tuple[str, str] = ..., logicalNot: _util.ProxyUnicode | str = ..., logicalOr: Tuple[str, str] = ..., name: _util.ProxyUnicode | str = ..., n: _util.ProxyUnicode | str = ..., node: _util.ProxyUnicode | str = ..., nd: _util.ProxyUnicode | str = ..., nodeType: _util.ProxyUnicode | str = ..., nt: _util.ProxyUnicode | str = ..., plug: _util.ProxyUnicode | str = ..., p: _util.ProxyUnicode | str = ...) -> Any: ...
def dgmodified(*args) -> Any: ...
def dgtimer(*args, combineType: bool | int = ..., ct: bool | int = ..., hide: bool | int | str | List[str] = ..., hi: bool | int | str | List[str] = ..., hierarchy: bool | int = ..., h: bool | int = ..., maxDisplay: bool | int | int = ..., m: bool | int | int = ..., name: bool | int | _util.ProxyUnicode | str = ..., n: bool | int | _util.ProxyUnicode | str = ..., noHeader: bool | int = ..., nh: bool | int = ..., outputFile: bool | int | _util.ProxyUnicode | str = ..., o: bool | int | _util.ProxyUnicode | str = ..., overhead: bool | int = ..., oh: bool | int = ..., query: bool | int = ..., q: bool | int = ..., rangeLower: float = ..., rgl: float = ..., rangeUpper: float = ..., rgu: float = ..., reset: bool | int = ..., r: bool | int = ..., returnCode: bool | int | _util.ProxyUnicode | str = ..., rc: bool | int | _util.ProxyUnicode | str = ..., returnType: bool | int | _util.ProxyUnicode | str = ..., rt: bool | int | _util.ProxyUnicode | str = ..., show: bool | int | str | List[str] = ..., sh: bool | int | str | List[str] = ..., sortMetric: bool | int | _util.ProxyUnicode | str = ..., sm: bool | int | _util.ProxyUnicode | str = ..., sortType: bool | int | _util.ProxyUnicode | str = ..., st: bool | int | _util.ProxyUnicode | str = ..., threshold: bool | int | float = ..., th: bool | int | float = ..., timerOff: bool | int = ..., off: bool | int = ..., timerOn: bool | int = ..., on: bool | int = ..., trace: bool | int = ..., tr: bool | int = ..., type: bool | int | _util.ProxyUnicode | str = ..., t: bool | int | _util.ProxyUnicode | str = ..., uniqueName: bool | int = ..., un: bool | int = ..., updateHeatMap: int = ..., uhm: int = ...) -> Any: ...
def dirmap(*args, convertDirectory: _util.ProxyUnicode | str = ..., cd: _util.ProxyUnicode | str = ..., enable: bool | int = ..., en: bool | int = ..., getAllMappings: bool | int = ..., gam: bool | int = ..., getMappedDirectory: _util.ProxyUnicode | str = ..., gmd: _util.ProxyUnicode | str = ..., mapDirectory: Tuple[str, str] = ..., m: Tuple[str, str] = ..., query: bool | int = ..., q: bool | int = ..., unmapDirectory: _util.ProxyUnicode | str = ..., um: _util.ProxyUnicode | str = ...) -> Any: ...
def diskCache(*args, append: bool | int = ..., a: bool | int = ..., cacheType: bool | int | _util.ProxyUnicode | str = ..., ct: bool | int | _util.ProxyUnicode | str = ..., close: bool | int | _util.ProxyUnicode | str = ..., c: bool | int | _util.ProxyUnicode | str = ..., closeAll: bool | int = ..., ca: bool | int = ..., delete: bool | int | _util.ProxyUnicode | str = ..., d: bool | int | _util.ProxyUnicode | str = ..., deleteAll: bool | int = ..., da: bool | int = ..., empty: bool | int | _util.ProxyUnicode | str = ..., e: bool | int | _util.ProxyUnicode | str = ..., emptyAll: bool | int = ..., ea: bool | int = ..., enabledCachesOnly: bool | int = ..., eco: bool | int = ..., endTime: bool | int | int | float = ..., et: bool | int | int | float = ..., frameRangeType: bool | int | _util.ProxyUnicode | str = ..., frt: bool | int | _util.ProxyUnicode | str = ..., overSample: bool | int = ..., os: bool | int = ..., query: bool | int = ..., q: bool | int = ..., samplingRate: bool | int | int = ..., sr: bool | int | int = ..., startTime: bool | int | int | float = ..., st: bool | int | int | float = ..., tempDir: bool | int = ..., tmp: bool | int = ...) -> Any: ...
def displayString(*args, delete: bool | int = ..., d: bool | int = ..., exists: bool | int = ..., ex: bool | int = ..., keys: bool | int = ..., k: bool | int = ..., query: bool | int = ..., q: bool | int = ..., replace: bool | int = ..., r: bool | int = ..., value: bool | int | _util.ProxyUnicode | str = ..., v: bool | int | _util.ProxyUnicode | str = ...) -> Any: ...
def dynamicLoad(*args, query: bool | int = ..., q: bool | int = ...) -> Any: ...
def error(*args, noContext: bool | int = ..., n: bool | int = ..., showLineNumber: bool | int = ..., sl: bool | int = ...) -> Any: ...

def exportEdits(*args, editCommand: bool | int | str | List[str] = ..., ec: bool | int | str | List[str] = ..., excludeHierarchy: bool | int = ..., ehr: bool | int = ..., excludeNode: bool | int | str | List[str] = ..., en: bool | int | str | List[str] = ..., exportSelected: bool | int = ..., exs: bool | int = ..., force: bool | int = ..., f: bool | int = ..., includeAnimation: bool | int = ..., ian: bool | int = ..., includeConstraints: bool | int = ..., ic: bool | int = ..., includeDeformers: bool | int = ..., idf: bool | int = ..., includeNetwork: bool | int = ..., inw: bool | int = ..., includeNode: bool | int | str | List[str] = ..., includeSetAttrs: bool | int = ..., isa: bool | int = ..., includeSetDrivenKeys: bool | int = ..., sdk: bool | int = ..., includeShaders: bool | int = ..., ish: bool | int = ..., onReferenceNode: bool | int | str | List[str] = ..., orn: bool | int | str | List[str] = ..., query: bool | int = ..., q: bool | int = ..., selected: bool | int = ..., sel: bool | int = ..., type: bool | int | _util.ProxyUnicode | str = ..., typ: bool | int | _util.ProxyUnicode | str = ...): ...

def fcheck(*args) -> Any: ...

def fileBrowserDialog(*args, actionName: _util.ProxyUnicode | str = ..., an: _util.ProxyUnicode | str = ..., dialogStyle: int = ..., ds: int = ..., fileCommand: str | Callable = ..., fc: str | Callable = ..., fileType: _util.ProxyUnicode | str = ..., ft: _util.ProxyUnicode | str = ..., filterList: str | List[str] = ..., fl: str | List[str] = ..., includeName: _util.ProxyUnicode | str = ..., mode: int = ..., m: int = ..., operationMode: _util.ProxyUnicode | str = ..., om: _util.ProxyUnicode | str = ..., tipMessage: _util.ProxyUnicode | str = ..., tm: _util.ProxyUnicode | str = ..., windowTitle: _util.ProxyUnicode | str = ..., wt: _util.ProxyUnicode | str = ...): ...

def fileDialog(*args, application: bool | int = ..., app: bool | int = ..., defaultFileName: _util.ProxyUnicode | str = ..., dfn: _util.ProxyUnicode | str = ..., directoryMask: _util.ProxyUnicode | str = ..., dm: _util.ProxyUnicode | str = ..., mode: int = ..., m: int = ..., title: _util.ProxyUnicode | str = ..., t: _util.ProxyUnicode | str = ...) -> Any: ...

def fileDialog2(*args, buttonBoxOrientation: int = ..., bbo: int = ..., cancelCaption: _util.ProxyUnicode | str = ..., cc: _util.ProxyUnicode | str = ..., caption: _util.ProxyUnicode | str = ..., cap: _util.ProxyUnicode | str = ..., dialogStyle: int = ..., ds: int = ..., fileFilter: _util.ProxyUnicode | str = ..., ff: _util.ProxyUnicode | str = ..., fileMode: int = ..., fm: int = ..., fileTypeChanged: str | Callable = ..., ftc: str | Callable = ..., hideFileExtensions: bool | int = ..., hfe: bool | int = ..., hideNameEdit: bool | int = ..., hne: bool | int = ..., okCaption: _util.ProxyUnicode | str = ..., okc: _util.ProxyUnicode | str = ..., optionsUICancel: str | Callable = ..., oca: str | Callable = ..., optionsUICommit: str | Callable = ..., ocm: str | Callable = ..., optionsUICommit2: str | Callable = ..., oc2: str | Callable = ..., optionsUICreate: str | Callable = ..., ocr: str | Callable = ..., optionsUIInit: str | Callable = ..., oin: str | Callable = ..., optionsUITitle: _util.ProxyUnicode | str = ..., oti: _util.ProxyUnicode | str = ..., returnFilter: bool | int = ..., rf: bool | int = ..., selectFileFilter: _util.ProxyUnicode | str = ..., sff: _util.ProxyUnicode | str = ..., selectionChanged: str | Callable = ..., sc: str | Callable = ..., setProjectBtnEnabled: bool | int = ..., spe: bool | int = ..., startingDirectory: _util.ProxyUnicode | str = ..., dir: _util.ProxyUnicode | str = ...): ...

def filePathEditor(*args, attributeOnly: bool | int = ..., ao: bool | int = ..., attributeType: bool | int | _util.ProxyUnicode | str = ..., at: bool | int | _util.ProxyUnicode | str = ..., byType: bool | int | _util.ProxyUnicode | str = ..., bt: bool | int | _util.ProxyUnicode | str = ..., copyAndRepath: Tuple[str, str] = ..., cr: Tuple[str, str] = ..., deregisterType: _util.ProxyUnicode | str = ..., dt: _util.ProxyUnicode | str = ..., force: bool | int = ..., f: bool | int = ..., listDirectories: bool | int | _util.ProxyUnicode | str = ..., ld: bool | int | _util.ProxyUnicode | str = ..., listFiles: bool | int | _util.ProxyUnicode | str = ..., lf: bool | int | _util.ProxyUnicode | str = ..., listRegisteredTypes: bool | int = ..., lrt: bool | int = ..., preview: bool | int = ..., p: bool | int = ..., query: bool | int = ..., q: bool | int = ..., recursive: bool | int = ..., rc: bool | int = ..., refresh: bool | int = ..., rf: bool | int = ..., registerType: _util.ProxyUnicode | str = ..., rt: _util.ProxyUnicode | str = ..., relativeNames: bool | int = ..., rel: bool | int = ..., repath: _util.ProxyUnicode | str = ..., r: _util.ProxyUnicode | str = ..., replaceAll: bool | int = ..., ra: bool | int = ..., replaceField: _util.ProxyUnicode | str = ..., rfd: _util.ProxyUnicode | str = ..., replaceString: Tuple[str, str] = ..., rs: Tuple[str, str] = ..., status: bool | int = ..., s: bool | int = ..., temporary: bool | int = ..., tmp: bool | int = ..., typeLabel: bool | int | _util.ProxyUnicode | str = ..., tl: bool | int | _util.ProxyUnicode | str = ..., unresolved: bool | int = ..., u: bool | int = ..., withAttribute: bool | int = ..., wa: bool | int = ...) -> Any: ...
def findType(*args, deep: bool | int = ..., d: bool | int = ..., exact: bool | int = ..., e: bool | int = ..., forward: bool | int = ..., f: bool | int = ..., type: _util.ProxyUnicode | str = ..., t: _util.ProxyUnicode | str = ...) -> Any: ...
def flushUndo(*args) -> Any: ...
def getFileList(*args, filespec: _util.ProxyUnicode | str = ..., fs: _util.ProxyUnicode | str = ..., folder: _util.ProxyUnicode | str = ..., fld: _util.ProxyUnicode | str = ...) -> Any: ...
def getInputDeviceRange(*args, maxValue: bool | int = ..., max: bool | int = ..., minValue: bool | int = ..., min: bool | int = ...) -> Any: ...
def getModifiers(*args) -> Any: ...
def getModulePath(*args, moduleName: _util.ProxyUnicode | str = ..., mn: _util.ProxyUnicode | str = ...) -> Any: ...
def hardware(*args, brdType: bool | int = ..., brd: bool | int = ..., cpuType: bool | int = ..., cpu: bool | int = ..., graphicsType: bool | int = ..., gfx: bool | int = ..., megaHertz: bool | int = ..., mhz: bool | int = ..., numProcessors: bool | int = ..., npr: bool | int = ...) -> Any: ...
def hitTest(*args) -> Any: ...
def imfPlugins(*args, extension: bool | int | _util.ProxyUnicode | str = ..., ext: bool | int | _util.ProxyUnicode | str = ..., keyword: bool | int | _util.ProxyUnicode | str = ..., key: bool | int | _util.ProxyUnicode | str = ..., multiFrameSupport: bool | int | _util.ProxyUnicode | str = ..., mfs: bool | int | _util.ProxyUnicode | str = ..., pluginName: bool | int | _util.ProxyUnicode | str = ..., pn: bool | int | _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., readSupport: bool | int | _util.ProxyUnicode | str = ..., rs: bool | int | _util.ProxyUnicode | str = ..., writeSupport: bool | int | _util.ProxyUnicode | str = ..., ws: bool | int | _util.ProxyUnicode | str = ...) -> Any: ...
def internalVar(*args, userAppDir: bool | int = ..., uad: bool | int = ..., userBitmapsDir: bool | int = ..., ubd: bool | int = ..., userHotkeyDir: bool | int = ..., uhk: bool | int = ..., userMarkingMenuDir: bool | int = ..., umm: bool | int = ..., userPrefDir: bool | int = ..., upd: bool | int = ..., userPresetsDir: bool | int = ..., ups: bool | int = ..., userScriptDir: bool | int = ..., usd: bool | int = ..., userShelfDir: bool | int = ..., ush: bool | int = ..., userTmpDir: bool | int = ..., utd: bool | int = ..., userWorkspaceDir: bool | int = ..., uwd: bool | int = ...) -> Any: ...
def launch(*args, directory: _util.ProxyUnicode | str = ..., dir: _util.ProxyUnicode | str = ..., movie: _util.ProxyUnicode | str = ..., mov: _util.ProxyUnicode | str = ..., pdfFile: _util.ProxyUnicode | str = ..., pdf: _util.ProxyUnicode | str = ..., webPage: _util.ProxyUnicode | str = ..., web: _util.ProxyUnicode | str = ...) -> Any: ...
def launchImageEditor(*args, editImageFile: _util.ProxyUnicode | str = ..., eif: _util.ProxyUnicode | str = ..., viewImageFile: _util.ProxyUnicode | str = ..., vif: _util.ProxyUnicode | str = ...) -> Any: ...
def listDeviceAttachments(*args, attribute: _util.ProxyUnicode | str = ..., at: _util.ProxyUnicode | str = ..., axis: _util.ProxyUnicode | str = ..., ax: _util.ProxyUnicode | str = ..., clutch: _util.ProxyUnicode | str = ..., c: _util.ProxyUnicode | str = ..., device: _util.ProxyUnicode | str = ..., d: _util.ProxyUnicode | str = ..., file: _util.ProxyUnicode | str = ..., f: _util.ProxyUnicode | str = ..., selection: bool | int = ..., sl: bool | int = ..., write: bool | int = ..., w: bool | int = ...) -> Any: ...
def listInputDeviceAxes(*args) -> Any: ...
def listInputDeviceButtons(*args) -> Any: ...
def listInputDevices(*args, free: bool | int = ..., f: bool | int = ..., primary: bool | int = ..., p: bool | int = ..., secondary: bool | int = ..., s: bool | int = ...) -> Any: ...
def loadModule(*args, allModules: bool | int = ..., a: bool | int = ..., load: _util.ProxyUnicode | str = ..., ld: _util.ProxyUnicode | str = ..., scan: bool | int = ..., sc: bool | int = ...) -> Any: ...

def loadPlugin(*args, addCallback: str | Callable = ..., ac: str | Callable = ..., allPlugins: bool | int = ..., a: bool | int = ..., name: _util.ProxyUnicode | str = ..., n: _util.ProxyUnicode | str = ..., qObsolete: bool | int = ..., q: bool | int = ..., quiet: bool | int = ..., qt: bool | int = ..., removeCallback: str | Callable = ..., rc: str | Callable = ...): ...

def melInfo(*args) -> Any: ...
def memory(*args, adjustedVirtualMemory: bool | int = ..., av: bool | int = ..., asFloat: bool | int = ..., af: bool | int = ..., debug: bool | int = ..., dbg: bool | int = ..., freeMemory: bool | int = ..., fr: bool | int = ..., gigaByte: bool | int = ..., gb: bool | int = ..., heapMemory: bool | int = ..., he: bool | int = ..., kiloByte: bool | int = ..., kb: bool | int = ..., megaByte: bool | int = ..., mb: bool | int = ..., pageFaults: bool | int = ..., pf: bool | int = ..., pageReclaims: bool | int = ..., pr: bool | int = ..., physicalMemory: bool | int = ..., phy: bool | int = ..., processResidentMemory: bool | int = ..., prm: bool | int = ..., processVirtualMemory: bool | int = ..., pv: bool | int = ..., summary: bool | int = ..., sum: bool | int = ..., swapFree: bool | int = ..., swf: bool | int = ..., swapLogical: bool | int = ..., swl: bool | int = ..., swapMax: bool | int = ..., swm: bool | int = ..., swapPhysical: bool | int = ..., swp: bool | int = ..., swapReserved: bool | int = ..., swr: bool | int = ..., swapVirtual: bool | int = ..., swv: bool | int = ..., swaps: bool | int = ..., sw: bool | int = ...) -> Any: ...
def moduleInfo(*args, definition: bool | int = ..., d: bool | int = ..., listModules: bool | int = ..., lm: bool | int = ..., moduleName: _util.ProxyUnicode | str = ..., mn: _util.ProxyUnicode | str = ..., path: bool | int = ..., p: bool | int = ..., version: bool | int = ..., v: bool | int = ...) -> Any: ...
def mouse(*args, enableScrollWheel: bool | int = ..., esw: bool | int = ..., mouseButtonTracking: int = ..., mbt: int = ..., mouseButtonTrackingStatus: bool | int = ..., mbs: bool | int = ..., scrollWheelStatus: bool | int = ..., sws: bool | int = ...) -> Any: ...
def namespace(*args, absoluteName: bool | int = ..., an: bool | int = ..., addNamespace: _util.ProxyUnicode | str = ..., add: _util.ProxyUnicode | str = ..., collapseAncestors: _util.ProxyUnicode | str = ..., ch: _util.ProxyUnicode | str = ..., deleteNamespaceContent: bool | int = ..., dnc: bool | int = ..., exists: _util.ProxyUnicode | str = ..., ex: _util.ProxyUnicode | str = ..., force: bool | int = ..., f: bool | int = ..., isRootNamespace: bool | int | _util.ProxyUnicode | str = ..., ir: bool | int | _util.ProxyUnicode | str = ..., mergeNamespaceWithOther: _util.ProxyUnicode | str = ..., mno: _util.ProxyUnicode | str = ..., mergeNamespaceWithParent: bool | int = ..., mnp: bool | int = ..., mergeNamespaceWithRoot: bool | int = ..., mnr: bool | int = ..., moveNamespace: Tuple[str, str] = ..., mv: Tuple[str, str] = ..., parent: _util.ProxyUnicode | str = ..., p: _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., recurse: bool | int = ..., r: bool | int = ..., relativeNames: bool | int = ..., rel: bool | int = ..., removeNamespace: _util.ProxyUnicode | str = ..., rm: _util.ProxyUnicode | str = ..., rename: Tuple[str, str] = ..., ren: Tuple[str, str] = ..., setNamespace: _util.ProxyUnicode | str = ..., set: _util.ProxyUnicode | str = ..., validateName: _util.ProxyUnicode | str = ..., vn: _util.ProxyUnicode | str = ...) -> Any: ...
def ogs(*args, deviceInformation: bool | int = ..., di: bool | int = ..., disposeReleasableTextures: bool | int = ..., drt: bool | int = ..., dumpTexture: _util.ProxyUnicode | str = ..., dt: _util.ProxyUnicode | str = ..., enableHardwareInstancing: bool | int = ..., hwi: bool | int = ..., fragmentEditor: _util.ProxyUnicode | str = ..., fe: _util.ProxyUnicode | str = ..., fragmentXML: _util.ProxyUnicode | str = ..., xml: _util.ProxyUnicode | str = ..., gpuMemoryTotal: bool | int | int = ..., gmt: bool | int | int = ..., gpuMemoryUsed: bool | int = ..., gpu: bool | int = ..., isLegacyViewportEnabled: bool | int = ..., lve: bool | int = ..., isRemoteGLSessionEnabled: bool | int = ..., rgl: bool | int = ..., isWinRemoteSession: bool | int = ..., irs: bool | int = ..., pause: bool | int = ..., p: bool | int = ..., query: bool | int = ..., q: bool | int = ..., rebakeTextures: bool | int = ..., rbt: bool | int = ..., regenerateUVTilePreview: _util.ProxyUnicode | str = ..., rup: _util.ProxyUnicode | str = ..., reloadTextures: bool | int = ..., rlt: bool | int = ..., reset: bool | int = ..., r: bool | int = ..., shaderSource: bool | int | _util.ProxyUnicode | str = ..., ss: bool | int | _util.ProxyUnicode | str = ..., toggleTexturePaging: bool | int = ..., ttp: bool | int = ..., traceRenderPipeline: bool | int = ..., trp: bool | int = ...) -> Any: ...
def openCLInfo(*args, minVertexBuffer: bool | int = ..., mvb: bool | int = ..., query: bool | int = ..., q: bool | int = ..., valid: bool | int = ..., v: bool | int = ...) -> Any: ...
def openGLExtension(*args, extension: _util.ProxyUnicode | str = ..., ext: _util.ProxyUnicode | str = ..., renderer: bool | int = ..., rnd: bool | int = ..., vendor: bool | int = ..., vnd: bool | int = ..., version: bool | int = ..., ver: bool | int = ...) -> Any: ...
def openMayaPref(*args, edit: bool | int = ..., e: bool | int = ..., errlog: bool | int = ..., el: bool | int = ..., lazyLoad: bool | int = ..., lz: bool | int = ..., oldPluginWarning: bool | int = ..., ow: bool | int = ..., query: bool | int = ..., q: bool | int = ...) -> Any: ...
def pluginDisplayFilter(*args, classification: bool | int | _util.ProxyUnicode | str = ..., cls: bool | int | _util.ProxyUnicode | str = ..., deregister: bool | int = ..., dr: bool | int = ..., exists: bool | int = ..., ex: bool | int = ..., label: bool | int | _util.ProxyUnicode | str = ..., l: bool | int | _util.ProxyUnicode | str = ..., listFilters: bool | int = ..., lf: bool | int = ..., query: bool | int = ..., q: bool | int = ..., register: bool | int = ..., r: bool | int = ...) -> Any: ...

def pluginInfo(*args, activeFile: bool | int = ..., af: bool | int = ..., allEvaluators: bool | int = ..., ae: bool | int = ..., animCurveInterp: bool | int | _util.ProxyUnicode | str = ..., aci: bool | int | _util.ProxyUnicode | str = ..., apiVersion: bool | int = ..., av: bool | int = ..., autoload: bool | int = ..., a: bool | int = ..., cacheFormat: bool | int = ..., cf: bool | int = ..., changedCommand: str | Callable = ..., cc: str | Callable = ..., command: bool | int | str | List[str] = ..., c: bool | int | str | List[str] = ..., constraintCommand: bool | int = ..., cnc: bool | int = ..., controlCommand: bool | int = ..., ctc: bool | int = ..., data: bool | int | Tuple[str, str] | List[Tuple[str, str]] = ..., d: bool | int | Tuple[str, str] | List[Tuple[str, str]] = ..., dependNode: bool | int | bool | int | List[bool | int] = ..., dn: bool | int | bool | int | List[bool | int] = ..., dependNodeByType: bool | int | _util.ProxyUnicode | str = ..., dnt: bool | int | _util.ProxyUnicode | str = ..., dependNodeId: bool | int | _util.ProxyUnicode | str = ..., dni: bool | int | _util.ProxyUnicode | str = ..., device: bool | int = ..., dv: bool | int = ..., dragAndDropBehavior: bool | int = ..., ddb: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., evaluator: bool | int = ..., iksolver: bool | int = ..., ik: bool | int = ..., listPlugins: bool | int = ..., ls: bool | int = ..., listPluginsPath: bool | int = ..., lsp: bool | int = ..., loadPluginPrefs: bool | int = ..., lpp: bool | int = ..., loaded: bool | int = ..., l: bool | int = ..., modelEditorCommand: bool | int = ..., mec: bool | int = ..., name: bool | int | _util.ProxyUnicode | str = ..., n: bool | int | _util.ProxyUnicode | str = ..., path: bool | int | _util.ProxyUnicode | str = ..., p: bool | int | _util.ProxyUnicode | str = ..., pluginsInUse: bool | int = ..., pu: bool | int = ..., query: bool | int = ..., q: bool | int = ..., referenceTranslators: bool | int = ..., rtr: bool | int = ..., registered: bool | int = ..., r: bool | int = ..., remove: bool | int = ..., rm: bool | int = ..., renderer: bool | int = ..., rdr: bool | int = ..., savePluginPrefs: bool | int = ..., spp: bool | int = ..., serviceDescriptions: bool | int = ..., sd: bool | int = ..., settings: bool | int = ..., set: bool | int = ..., tool: bool | int | str | List[str] = ..., t: bool | int | str | List[str] = ..., translator: bool | int = ..., tr: bool | int = ..., unloadOk: bool | int = ..., uo: bool | int = ..., userNamed: bool | int = ..., u: bool | int = ..., vendor: bool | int | _util.ProxyUnicode | str = ..., vd: bool | int | _util.ProxyUnicode | str = ..., version: bool | int = ..., v: bool | int = ..., writeRequires: bool | int = ..., wr: bool | int = ...): ...
def preloadRefEd(*args, control: bool | int = ..., ctl: bool | int = ..., defineTemplate: _util.ProxyUnicode | str = ..., dt: _util.ProxyUnicode | str = ..., docTag: bool | int | _util.ProxyUnicode | str = ..., dtg: bool | int | _util.ProxyUnicode | str = ..., edit: bool | int = ..., e: bool | int = ..., exists: bool | int = ..., ex: bool | int = ..., filter: bool | int | _util.ProxyUnicode | str = ..., f: bool | int | _util.ProxyUnicode | str = ..., forceMainConnection: bool | int | _util.ProxyUnicode | str = ..., fmc: bool | int | _util.ProxyUnicode | str = ..., highlightConnection: bool | int | _util.ProxyUnicode | str = ..., hlc: bool | int | _util.ProxyUnicode | str = ..., lockMainConnection: bool | int = ..., lck: bool | int = ..., mainListConnection: bool | int | _util.ProxyUnicode | str = ..., mlc: bool | int | _util.ProxyUnicode | str = ..., panel: bool | int | _util.ProxyUnicode | str = ..., pnl: bool | int | _util.ProxyUnicode | str = ..., parent: bool | int | _util.ProxyUnicode | str = ..., p: bool | int | _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., selectCommand: bool | int | str | Callable = ..., sc: bool | int | str | Callable = ..., selectFileNode: bool | int = ..., sf: bool | int = ..., selectionConnection: bool | int | _util.ProxyUnicode | str = ..., slc: bool | int | _util.ProxyUnicode | str = ..., stateString: bool | int = ..., sts: bool | int = ..., unParent: bool | int = ..., up: bool | int = ..., unlockMainConnection: bool | int = ..., ulk: bool | int = ..., updateMainConnection: bool | int = ..., upd: bool | int = ..., useTemplate: _util.ProxyUnicode | str = ..., ut: _util.ProxyUnicode | str = ...): ...

def profiler(*args, addCategory: _util.ProxyUnicode | str = ..., a: _util.ProxyUnicode | str = ..., allCategories: bool | int = ..., ac: bool | int = ..., bufferSize: bool | int | int = ..., b: bool | int | int = ..., categoryIndex: bool | int | int = ..., ci: bool | int | int = ..., categoryIndexToName: bool | int | int = ..., cin: bool | int | int = ..., categoryInfo: bool | int | _util.ProxyUnicode | str = ..., cf: bool | int | _util.ProxyUnicode | str = ..., categoryName: bool | int | _util.ProxyUnicode | str = ..., cn: bool | int | _util.ProxyUnicode | str = ..., categoryNameToIndex: bool | int | _util.ProxyUnicode | str = ..., cni: bool | int | _util.ProxyUnicode | str = ..., categoryRecording: bool | int = ..., cr: bool | int = ..., clearAllMelInstrumentation: bool | int = ..., cam: bool | int = ..., colorIndex: int = ..., coi: int = ..., eventCPUId: bool | int = ..., eci: bool | int = ..., eventCategory: bool | int = ..., eca: bool | int = ..., eventColor: bool | int = ..., eco: bool | int = ..., eventCount: bool | int = ..., ec: bool | int = ..., eventDescription: bool | int = ..., ed: bool | int = ..., eventDuration: bool | int = ..., edu: bool | int = ..., eventIndex: bool | int | int = ..., ei: bool | int | int = ..., eventName: bool | int = ..., en: bool | int = ..., eventStartTime: bool | int = ..., et: bool | int = ..., eventThreadId: bool | int = ..., eti: bool | int = ..., instrumentMel: bool | int = ..., load: bool | int | _util.ProxyUnicode | str = ..., l: bool | int | _util.ProxyUnicode | str = ..., output: bool | int | _util.ProxyUnicode | str = ..., o: bool | int | _util.ProxyUnicode | str = ..., procedureDescription: _util.ProxyUnicode | str = ..., pd: _util.ProxyUnicode | str = ..., procedureName: _util.ProxyUnicode | str = ..., pn: _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., removeCategory: _util.ProxyUnicode | str = ..., rc: _util.ProxyUnicode | str = ..., reset: bool | int = ..., r: bool | int = ..., sampling: bool | int = ..., s: bool | int = ..., signalEvent: bool | int = ..., sig: bool | int = ..., signalMelEvent: bool | int = ..., sim: bool | int = ...) -> Any: ...
def profilerTool(*args, categoryView: bool | int = ..., cat: bool | int = ..., collapseSelectedEvents: bool | int = ..., cs: bool | int = ..., collapseSelectedEventsRepetition: bool | int = ..., csr: bool | int = ..., cpuView: bool | int = ..., cpu: bool | int = ..., destroy: bool | int = ..., dtr: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., eventTypes: bool | int = ..., et: bool | int = ..., exists: bool | int = ..., ex: bool | int = ..., expandSelectedEvents: bool | int = ..., es: bool | int = ..., expandSelectedEventsRepetition: bool | int = ..., esr: bool | int = ..., findNext: bool | int = ..., fn: bool | int = ..., findPrevious: bool | int = ..., fp: bool | int = ..., frameAll: bool | int = ..., fa: bool | int = ..., frameSelected: bool | int = ..., fs: bool | int = ..., isolateSegment: int = ..., make: bool | int = ..., mk: bool | int = ..., matchWholeWord: bool | int = ..., mww: bool | int = ..., query: bool | int = ..., q: bool | int = ..., searchEvent: bool | int | _util.ProxyUnicode | str = ..., se: bool | int | _util.ProxyUnicode | str = ..., segmentCount: bool | int = ..., sc: bool | int = ..., showAllEvent: bool | int = ..., sa: bool | int = ..., showCriticalPath: bool | int = ..., scp: bool | int = ..., showHotspot: bool | int = ..., sh: bool | int = ..., showSelectedEvents: bool | int = ..., ss: bool | int = ..., showSelectedEventsRepetition: bool | int = ..., ssr: bool | int = ..., threadView: bool | int = ..., thd: bool | int = ..., unisolateSegment: bool | int = ..., uis: bool | int = ...) -> Any: ...
def recordAttr(*args, attribute: str | List[str] = ..., at: str | List[str] = ..., delete: bool | int = ..., d: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., query: bool | int = ..., q: bool | int = ...) -> Any: ...
def redo(*args) -> Any: ...

def reference(*args, connectionsBroken: bool | int = ..., cb: bool | int = ..., connectionsMade: bool | int = ..., cm: bool | int = ..., dagPath: bool | int = ..., dp: bool | int = ..., editCommand: _util.ProxyUnicode | str = ..., ec: _util.ProxyUnicode | str = ..., filename: _util.ProxyUnicode | str = ..., f: _util.ProxyUnicode | str = ..., isNodeReferenced: bool | int = ..., inr: bool | int = ..., longName: bool | int = ..., ln: bool | int = ..., node: _util.ProxyUnicode | str = ..., n: _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., referenceNode: _util.ProxyUnicode | str = ..., rfn: _util.ProxyUnicode | str = ..., shortName: bool | int = ..., sn: bool | int = ...): ...
def referenceEdit(*args, applyFailedEdits: bool | int = ..., afe: bool | int = ..., changeEditTarget: Tuple[str, str] = ..., cet: Tuple[str, str] = ..., editCommand: bool | int | str | List[str] = ..., ec: bool | int | str | List[str] = ..., failedEdits: bool | int = ..., fld: bool | int = ..., onReferenceNode: bool | int | str | List[str] = ..., orn: bool | int | str | List[str] = ..., removeEdits: bool | int = ..., r: bool | int = ..., successfulEdits: bool | int = ..., scs: bool | int = ...): ...

def rehash(*args) -> Any: ...
def reloadImage(*args) -> Any: ...
def requires(*args, dataType: str | List[str] = ..., dt: str | List[str] = ..., nodeType: str | List[str] = ..., nt: str | List[str] = ...) -> Any: ...

def saveImage(*args, annotation: bool | int | _util.ProxyUnicode | str = ..., ann: bool | int | _util.ProxyUnicode | str = ..., backgroundColor: bool | int | Tuple[float, float, float] = ..., bgc: bool | int | Tuple[float, float, float] = ..., currentView: bool | int = ..., cv: bool | int = ..., defineTemplate: _util.ProxyUnicode | str = ..., dt: _util.ProxyUnicode | str = ..., docTag: bool | int | _util.ProxyUnicode | str = ..., dtg: bool | int | _util.ProxyUnicode | str = ..., dragCallback: str | Callable = ..., dgc: str | Callable = ..., dropCallback: str | Callable = ..., dpc: str | Callable = ..., edit: bool | int = ..., e: bool | int = ..., enable: bool | int = ..., en: bool | int = ..., enableBackground: bool | int = ..., ebg: bool | int = ..., enableKeyboardFocus: bool | int = ..., ekf: bool | int = ..., exists: bool | int = ..., ex: bool | int = ..., fullPathName: bool | int = ..., fpn: bool | int = ..., height: bool | int | int = ..., h: bool | int | int = ..., highlightColor: bool | int | Tuple[float, float, float] = ..., hlc: bool | int | Tuple[float, float, float] = ..., image: bool | int | _util.ProxyUnicode | str = ..., i: bool | int | _util.ProxyUnicode | str = ..., isObscured: bool | int = ..., io: bool | int = ..., manage: bool | int = ..., m: bool | int = ..., noBackground: bool | int = ..., nbg: bool | int = ..., numberOfPopupMenus: bool | int = ..., npm: bool | int = ..., objectThumbnail: _util.ProxyUnicode | str = ..., ot: _util.ProxyUnicode | str = ..., parent: bool | int | _util.ProxyUnicode | str = ..., p: bool | int | _util.ProxyUnicode | str = ..., popupMenuArray: bool | int = ..., pma: bool | int = ..., preventOverride: bool | int = ..., po: bool | int = ..., query: bool | int = ..., q: bool | int = ..., sceneFile: _util.ProxyUnicode | str = ..., sf: _util.ProxyUnicode | str = ..., statusBarMessage: _util.ProxyUnicode | str = ..., sbm: _util.ProxyUnicode | str = ..., useTemplate: _util.ProxyUnicode | str = ..., ut: _util.ProxyUnicode | str = ..., visible: bool | int = ..., vis: bool | int = ..., visibleChangeCommand: bool | int | str | Callable = ..., vcc: bool | int | str | Callable = ..., width: bool | int | int = ..., w: bool | int | int = ...): ...
def sceneEditor(*args, control: bool | int = ..., ctl: bool | int = ..., defineTemplate: _util.ProxyUnicode | str = ..., dt: _util.ProxyUnicode | str = ..., docTag: bool | int | _util.ProxyUnicode | str = ..., dtg: bool | int | _util.ProxyUnicode | str = ..., edit: bool | int = ..., e: bool | int = ..., exists: bool | int = ..., ex: bool | int = ..., filter: bool | int | _util.ProxyUnicode | str = ..., f: bool | int | _util.ProxyUnicode | str = ..., forceMainConnection: bool | int | _util.ProxyUnicode | str = ..., fmc: bool | int | _util.ProxyUnicode | str = ..., highlightConnection: bool | int | _util.ProxyUnicode | str = ..., hlc: bool | int | _util.ProxyUnicode | str = ..., lockMainConnection: bool | int = ..., lck: bool | int = ..., mainListConnection: bool | int | _util.ProxyUnicode | str = ..., mlc: bool | int | _util.ProxyUnicode | str = ..., onlyParents: bool | int = ..., op: bool | int = ..., panel: bool | int | _util.ProxyUnicode | str = ..., pnl: bool | int | _util.ProxyUnicode | str = ..., parent: bool | int | _util.ProxyUnicode | str = ..., p: bool | int | _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., refreshReferences: bool | int = ..., rr: bool | int = ..., selectCommand: bool | int | str | Callable = ..., sc: bool | int | str | Callable = ..., selectItem: bool | int | int = ..., si: bool | int | int = ..., selectReference: bool | int | _util.ProxyUnicode | str = ..., sr: bool | int | _util.ProxyUnicode | str = ..., selectionConnection: bool | int | _util.ProxyUnicode | str = ..., slc: bool | int | _util.ProxyUnicode | str = ..., shortName: bool | int = ..., shn: bool | int = ..., stateString: bool | int = ..., sts: bool | int = ..., unParent: bool | int = ..., up: bool | int = ..., unlockMainConnection: bool | int = ..., ulk: bool | int = ..., unresolvedName: bool | int = ..., un: bool | int = ..., updateMainConnection: bool | int = ..., upd: bool | int = ..., useTemplate: _util.ProxyUnicode | str = ..., ut: _util.ProxyUnicode | str = ..., withoutCopyNumber: bool | int = ..., wcn: bool | int = ...): ...

def sceneUIReplacement(*args, clear: bool | int = ..., cl: bool | int = ..., deleteRemaining: bool | int = ..., dr: bool | int = ..., getNextFilter: Tuple[str, str] = ..., gf: Tuple[str, str] = ..., getNextPanel: Tuple[str, str] = ..., gp: Tuple[str, str] = ..., getNextScriptedPanel: Tuple[str, str] = ..., gsp: Tuple[str, str] = ..., update: _util.ProxyUnicode | str = ..., u: _util.ProxyUnicode | str = ...) -> Any: ...
def scriptNode(*args, afterScript: bool | int | _util.ProxyUnicode | str = ..., beforeScript: bool | int | _util.ProxyUnicode | str = ..., bs: bool | int | _util.ProxyUnicode | str = ..., edit: bool | int = ..., e: bool | int = ..., executeAfter: bool | int = ..., ea: bool | int = ..., executeBefore: bool | int = ..., eb: bool | int = ..., ignoreReferenceEdits: bool | int = ..., ire: bool | int = ..., name: _util.ProxyUnicode | str = ..., n: _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., scriptType: bool | int | int = ..., st: bool | int | int = ..., sourceType: bool | int | _util.ProxyUnicode | str = ..., stp: bool | int | _util.ProxyUnicode | str = ...) -> Any: ...
def selLoadSettings(*args, activeProxy: bool | int | _util.ProxyUnicode | str = ..., ap: bool | int | _util.ProxyUnicode | str = ..., deferReference: bool | int = ..., dr: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., fileName: bool | int | _util.ProxyUnicode | str = ..., fn: bool | int | _util.ProxyUnicode | str = ..., numSettings: bool | int | int = ..., ns: bool | int | int = ..., proxyManager: bool | int | _util.ProxyUnicode | str = ..., pm: bool | int | _util.ProxyUnicode | str = ..., proxySetFiles: bool | int | _util.ProxyUnicode | str = ..., psf: bool | int | _util.ProxyUnicode | str = ..., proxySetTags: bool | int | _util.ProxyUnicode | str = ..., pst: bool | int | _util.ProxyUnicode | str = ..., proxyTag: bool | int | _util.ProxyUnicode | str = ..., pt: bool | int | _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., referenceNode: bool | int | _util.ProxyUnicode | str = ..., rfn: bool | int | _util.ProxyUnicode | str = ..., shortName: bool | int = ..., shn: bool | int = ..., unresolvedName: bool | int = ..., un: bool | int = ...) -> Any: ...
def setAttrMapping(*args, absolute: bool | int = ..., a: bool | int = ..., attribute: str | List[str] = ..., at: str | List[str] = ..., axis: _util.ProxyUnicode | str = ..., ax: _util.ProxyUnicode | str = ..., clutch: _util.ProxyUnicode | str = ..., c: _util.ProxyUnicode | str = ..., device: _util.ProxyUnicode | str = ..., d: _util.ProxyUnicode | str = ..., offset: float = ..., o: float = ..., relative: bool | int = ..., r: bool | int = ..., scale: float = ..., s: float = ..., selection: bool | int = ..., sl: bool | int = ...) -> Any: ...
def setInputDeviceMapping(*args, absolute: bool | int = ..., a: bool | int = ..., axis: str | List[str] = ..., ax: str | List[str] = ..., device: _util.ProxyUnicode | str = ..., d: _util.ProxyUnicode | str = ..., offset: float = ..., o: float = ..., relative: bool | int = ..., r: bool | int = ..., scale: float = ..., s: float = ..., view: bool | int = ..., v: bool | int = ..., world: bool | int = ..., w: bool | int = ...) -> Any: ...
def shotTrack(*args, edit: bool | int = ..., e: bool | int = ..., insertTrack: int = ..., it: int = ..., lock: bool | int = ..., l: bool | int = ..., mute: bool | int = ..., m: bool | int = ..., numTracks: bool | int | int = ..., nt: bool | int | int = ..., query: bool | int = ..., q: bool | int = ..., removeEmptyTracks: bool | int = ..., ret: bool | int = ..., removeTrack: int = ..., rt: int = ..., selfmute: bool | int = ..., sm: bool | int = ..., solo: bool | int = ..., so: bool | int = ..., swapTracks: Tuple[int, int] = ..., st: Tuple[int, int] = ..., title: bool | int | _util.ProxyUnicode | str = ..., t: bool | int | _util.ProxyUnicode | str = ..., track: bool | int | int = ..., tr: bool | int | int = ..., unsolo: bool | int = ..., uso: bool | int = ...) -> Any: ...
def showHelp(*args, absolute: bool | int = ..., a: bool | int = ..., docs: bool | int = ..., d: bool | int = ..., helpTable: bool | int = ..., ht: bool | int = ..., query: bool | int = ..., q: bool | int = ..., version: bool | int = ..., v: bool | int = ...) -> Any: ...
def sysFile(*args, copy: _util.ProxyUnicode | str = ..., cp: _util.ProxyUnicode | str = ..., delete: bool | int = ..., makeDir: bool | int = ..., md: bool | int = ..., move: _util.ProxyUnicode | str = ..., mov: _util.ProxyUnicode | str = ..., removeEmptyDir: bool | int = ..., red: bool | int = ..., rename: _util.ProxyUnicode | str = ..., ren: _util.ProxyUnicode | str = ...) -> Any: ...
def timer(*args, endTimer: bool | int = ..., e: bool | int = ..., lapTime: bool | int = ..., lap: bool | int = ..., name: _util.ProxyUnicode | str = ..., n: _util.ProxyUnicode | str = ..., startTimer: bool | int = ..., s: bool | int = ...) -> Any: ...
def timerX(*args, startTime: float = ..., st: float = ...) -> Any: ...
def translator(*args, defaultFileRule: bool | int = ..., dfr: bool | int = ..., defaultOptions: bool | int | _util.ProxyUnicode | str = ..., do: bool | int | _util.ProxyUnicode | str = ..., extension: bool | int = ..., ext: bool | int = ..., fileCompression: bool | int | _util.ProxyUnicode | str = ..., cmp: bool | int | _util.ProxyUnicode | str = ..., filter: bool | int = ..., f: bool | int = ..., list: bool | int = ..., l: bool | int = ..., loaded: bool | int = ..., ld: bool | int = ..., objectType: bool | int = ..., ot: bool | int = ..., optionsScript: bool | int = ..., os: bool | int = ..., query: bool | int = ..., q: bool | int = ..., readSupport: bool | int = ..., rs: bool | int = ..., writeSupport: bool | int = ..., ws: bool | int = ...) -> Any: ...
def unassignInputDevice(*args, clutch: _util.ProxyUnicode | str = ..., c: _util.ProxyUnicode | str = ..., device: _util.ProxyUnicode | str = ..., d: _util.ProxyUnicode | str = ...) -> Any: ...
def undo(*args) -> Any: ...
def undoInfo(*args, chunkName: bool | int | _util.ProxyUnicode | str = ..., cn: bool | int | _util.ProxyUnicode | str = ..., closeChunk: bool | int = ..., cck: bool | int = ..., infinity: bool | int = ..., length: bool | int | int = ..., l: bool | int | int = ..., openChunk: bool | int = ..., ock: bool | int = ..., printQueue: bool | int = ..., pq: bool | int = ..., printRedoQueue: bool | int = ..., prq: bool | int = ..., query: bool | int = ..., q: bool | int = ..., redoName: bool | int | _util.ProxyUnicode | str = ..., rn: bool | int | _util.ProxyUnicode | str = ..., redoQueueEmpty: bool | int = ..., rqe: bool | int = ..., state: bool | int = ..., st: bool | int = ..., stateWithoutFlush: bool | int = ..., swf: bool | int = ..., undoName: bool | int | _util.ProxyUnicode | str = ..., un: bool | int | _util.ProxyUnicode | str = ..., undoQueueEmpty: bool | int = ..., uqe: bool | int = ...) -> Any: ...
def unknownNode(*args, plugin: bool | int = ..., p: bool | int = ..., query: bool | int = ..., q: bool | int = ..., realClassName: bool | int = ..., rcn: bool | int = ..., realClassTag: bool | int = ..., rct: bool | int = ...) -> Any: ...
def unknownPlugin(*args, dataTypes: bool | int = ..., dt: bool | int = ..., list: bool | int = ..., l: bool | int = ..., nodeTypes: bool | int = ..., nt: bool | int = ..., query: bool | int = ..., q: bool | int = ..., remove: bool | int = ..., r: bool | int = ..., version: bool | int = ..., v: bool | int = ...) -> Any: ...

def unloadPlugin(*args, addCallback: str | Callable = ..., ac: str | Callable = ..., force: bool | int = ..., f: bool | int = ..., removeCallback: str | Callable = ..., rc: str | Callable = ...): ...

def warning(*args, noContext: bool | int = ..., n: bool | int = ..., showLineNumber: bool | int = ..., sl: bool | int = ...) -> Any: ...
def whatsNewHighlight(*args, highlightColor: bool | int | Tuple[float, float, float] = ..., hc: bool | int | Tuple[float, float, float] = ..., highlightOn: bool | int = ..., ho: bool | int = ..., query: bool | int = ..., q: bool | int = ..., showStartupDialog: bool | int = ..., ssd: bool | int = ...) -> Any: ...
def xpmPicker(*args, fileName: _util.ProxyUnicode | str = ..., fn: _util.ProxyUnicode | str = ..., parent: _util.ProxyUnicode | str = ..., p: _util.ProxyUnicode | str = ...) -> Any: ...
