from typing import *
import pymel.util as _util
import abc
import pymel.util as util
from _typeshed import Incomplete
from collections import MutableMapping
from future.utils import PY2 as PY2
from pymel.core import system as system
from typing import Any, Callable, List, Optional, Tuple, Union, overload

MELTYPES: Incomplete

def isValidMelType(typStr: Any) -> bool: ...
def pythonToMel(arg: str) -> str: ...
def pythonToMelCmd(command, *args, **kwargs): ...
def getMelType(pyObj: Any, exactOnly: bool = ..., allowBool: bool = ..., allowMatrix: bool = ...) -> str: ...

class MelGlobals(MutableMapping, _Parent, metaclass=abc.ABCMeta):
    melTypeToPythonType: Incomplete
    class MelGlobalArray(util.defaultlist):
        def __init__(self, type, variable, *args, **kwargs) -> None: ...
        def __setitem__(self, index, value) -> None: ...
        setItem = __setitem__
        def append(self, val) -> None: ...
        def extend(self, val) -> None: ...
    typeMap: Dict[str, str]
    VALID_TYPES = MELTYPES
    def __iter__(self) -> Iterable[str]: ...
    def __len__(self) -> int: ...
    def __getitem__(self, variable: str) -> str: ...
    def __setitem__(self, variable: str, value: Any) -> Any: ...
    @classmethod
    def getType(cls, variable: str) -> str: ...
    @classmethod
    def initVar(cls, type: str, variable: str) -> str: ...
    def get_dict(self, variable, default: Incomplete | None = ...): ...
    @classmethod
    def get(cls, variable: str, type: Optional[str] = ...) -> Any: ...
    @classmethod
    def set(cls, variable: str, value: Any, type: Optional[str] = ...) -> None: ...
    @classmethod
    def keys(cls) -> List[str]: ...

melGlobals: MelGlobals

def getMelGlobal(type, variable): ...
def setMelGlobal(type, variable, value): ...

class Catch:
    result: Incomplete
    success: Incomplete
    def __call__(self, func, *args, **kwargs): ...
    def reset(self) -> None: ...

catch: Catch

class OptionVarList(tuple):
    def __new__(cls, val, key): ...
    key: Incomplete
    def __init__(self, val, key) -> None: ...
    def __setitem__(self, key, val) -> None: ...
    def appendVar(self, val): ...
    append = appendVar

class OptionVarDict(MutableMapping):
    def __call__(self, *args, **kwargs): ...
    def __contains__(self, key: str) -> bool: ...
    def has_key(self, key: str) -> bool: ...
    def __getitem__(self, key: str) -> Any: ...
    def __setitem__(self, key: str, val: Any) -> None: ...
    def keys(self) -> List[str]: ...
    def pop(self, key: str) -> Any: ...
    def __delitem__(self, key: str) -> None: ...
    def iterkeys(self) -> Iterator[str]: ...
    __iter__ = iterkeys
    def __len__(self) -> int: ...

optionVar: OptionVarDict

class Env:
    optionVars: OptionVarDict
    envVars: Incomplete
    def setConstructionHistory(self, state: bool) -> None: ...
    def getConstructionHistory(self): ...
    def sceneName(self): ...
    def setUpAxis(self, axis, rotateView: bool = ...) -> None: ...
    def getUpAxis(self): ...
    def user(self) -> str: ...
    def host(self) -> str: ...
    def getTime(self) -> float: ...
    def setTime(self, val) -> None: ...
    time: Incomplete
    def getMinTime(self) -> float: ...
    def setMinTime(self, val: SupportsFloat) -> None: ...
    minTime: Incomplete
    def getMaxTime(self) -> float: ...
    def setMaxTime(self, val: SupportsFloat) -> None: ...
    maxTime: Incomplete
    def getAnimStartTime(self) -> float: ...
    def setAnimStartTime(self, val: SupportsFloat) -> None: ...
    animStartTime: Incomplete
    def getAnimEndTime(self) -> float: ...
    def setAnimEndTime(self, val: SupportsFloat) -> None: ...
    animEndTime: Incomplete
    def getPlaybackTimes(self) -> Tuple[float, float, float, float]: ...
    def setPlaybackTimes(self, playbackTimes: Tuple[SupportsFloat, SupportsFloat, SupportsFloat, SupportsFloat]) -> None: ...
    playbackTimes: Incomplete

env: Env

class MelError(RuntimeError): ...
class MelConversionError(MelError, TypeError): ...
class MelUnknownProcedureError(MelError, NameError): ...
class MelArgumentError(MelError, TypeError): ...
class MelSyntaxError(MelError, SyntaxError): ...

class MelCallable:
    full_name: Incomplete
    def __init__(self, head: str, name: str) -> None: ...
    def __getattr__(self, command: str) -> MelCallable: ...
    def __call__(self, *args, **kwargs): ...

class Mel:
    proc: Incomplete
    def __getattr__(self, command: str) -> MelCallable: ...
    @classmethod
    def mprint(cls, *args) -> None: ...
    @classmethod
    def source(cls, script: str, language: str = ...) -> None: ...
    @classmethod
    def eval(cls, cmd: str) -> Any: ...
    @staticmethod
    def error(msg, showLineNumber: bool = ...) -> None: ...
    @staticmethod
    def warning(msg, showLineNumber: bool = ...) -> None: ...
    @staticmethod
    def trace(msg, showLineNumber: bool = ...) -> None: ...
    @staticmethod
    def tokenize(*args) -> None: ...
    globals = melGlobals

mel: Mel

def conditionExists(conditionName: str) -> None: ...

def evalEcho(*args) -> Any: ...
def evalNoSelectNotify(*args) -> Any: ...
def getLastError(*args) -> Any: ...
def getProcArguments(*args) -> Any: ...
def matrixUtil(*args, edit: bool | int = ..., e: bool | int = ..., inverse: bool | int = ..., iv: bool | int = ..., quaternion: bool | int | Tuple[float, float, float, float] = ..., qt: bool | int | Tuple[float, float, float, float] = ..., query: bool | int = ..., q: bool | int = ..., relative: bool | int = ..., rt: bool | int = ..., rotation: bool | int | Tuple[float, float, float] = ..., r: bool | int | Tuple[float, float, float] = ..., scale: bool | int | Tuple[float, float, float] = ..., s: bool | int | Tuple[float, float, float] = ..., shear: bool | int | Tuple[float, float, float] = ..., sh: bool | int | Tuple[float, float, float] = ..., translation: bool | int | Tuple[float, float, float] = ..., t: bool | int | Tuple[float, float, float] = ..., transpose: bool | int = ..., tp: bool | int = ...) -> Any: ...
def melOptions(*args, duplicateVariableWarnings: bool | int = ..., dvw: bool | int = ..., query: bool | int = ..., q: bool | int = ...) -> Any: ...
def python(*args) -> Any: ...
def resourceManager(*args, nameFilter: _util.ProxyUnicode | str = ..., nf: _util.ProxyUnicode | str = ..., saveAs: Tuple[str, str] = ..., s: Tuple[str, str] = ...) -> Any: ...

def scriptJob(*args, allChildren: bool | int = ..., alc: bool | int = ..., attributeAdded: Tuple[str, str | Callable] = ..., aa: Tuple[str, str | Callable] = ..., attributeChange: Tuple[str, str | Callable] = ..., ac: Tuple[str, str | Callable] = ..., attributeDeleted: Tuple[str, str | Callable] = ..., ad: Tuple[str, str | Callable] = ..., compressUndo: bool | int = ..., cu: bool | int = ..., conditionChange: Tuple[str, str | Callable] = ..., cc: Tuple[str, str | Callable] = ..., conditionFalse: Tuple[str, str | Callable] = ..., cf: Tuple[str, str | Callable] = ..., conditionTrue: Tuple[str, str | Callable] = ..., ct: Tuple[str, str | Callable] = ..., connectionChange: Tuple[str, str | Callable] = ..., con: Tuple[str, str | Callable] = ..., disregardIndex: bool | int = ..., dri: bool | int = ..., event: Tuple[str, str | Callable] = ..., e: Tuple[str, str | Callable] = ..., exists: int = ..., ex: int = ..., force: bool | int = ..., f: bool | int = ..., idleEvent: str | Callable = ..., ie: str | Callable = ..., kill: int | List[int] = ..., k: int | List[int] = ..., killAll: bool | int = ..., ka: bool | int = ..., killWithScene: bool | int = ..., kws: bool | int = ..., listConditions: bool | int = ..., lc: bool | int = ..., listEvents: bool | int = ..., le: bool | int = ..., listJobs: bool | int = ..., lj: bool | int = ..., nodeDeleted: Tuple[str, str | Callable] = ..., nd: Tuple[str, str | Callable] = ..., nodeNameChanged: Tuple[str, str | Callable] = ..., nnc: Tuple[str, str | Callable] = ..., optionVarChanged: Tuple[str, str | Callable] = ..., ovc: Tuple[str, str | Callable] = ..., parent: _util.ProxyUnicode | str = ..., p: _util.ProxyUnicode | str = ..., permanent: bool | int = ..., per: bool | int = ..., protected: bool | int = ..., pro: bool | int = ..., replacePrevious: bool | int = ..., rp: bool | int = ..., runOnce: bool | int = ..., ro: bool | int = ..., timeChange: str | Callable = ..., tc: str | Callable = ..., uiDeleted: Tuple[str, str | Callable] = ..., uid: Tuple[str, str | Callable] = ...): ...

def sortCaseInsensitive(*args) -> Any: ...
def stackTrace(*args, dump: bool | int = ..., d: bool | int = ..., parameterCount: int = ..., pc: int = ..., parameterType: Tuple[int, int] = ..., pt: Tuple[int, int] = ..., parameterValue: Tuple[int, int] = ..., pv: Tuple[int, int] = ..., query: bool | int = ..., q: bool | int = ..., state: bool | int = ..., s: bool | int = ...) -> Any: ...
def waitCursor(*args, query: bool | int = ..., q: bool | int = ..., state: bool | int = ..., st: bool | int = ...) -> Any: ...
