version = (1, 2)

data = {'TanimLayer': '',
 'TrenderSetupStates': '',
 'UfeCommandObject': '',
 'aaf2fcp': "import maya.cmds as cmds\n\n\nhandle = cmds.aaf2fcp(srcFile='c:/tmp/test.aaf', dstPath='c:/tmp')\ndestinationFile = cmds.aff2fcp(getFileName=handle)\ncmds.aaf2fcp(waitCompletion=handle)\ncmds.aaf2fcp(terminate=handle,deleteFile=False)",
 'about': 'import maya.cmds as cmds\n\ncmds.about( )\n\nversion = cmds.about(v=True)',
 'addAttr': 'import maya.cmds as cmds\n\ncmds.sphere( name=\'earth\' )\n# Add an attribute named ms/mass with a default value of 1 and a\n# minimum value of 0.001 and a maximum of 10000.\n#\ncmds.addAttr( shortName=\'ms\', longName=\'mass\', defaultValue=1.0, minValue=0.001, maxValue=10000 )\n\n# Add a multi attribute named ff/forcefield of type double3.\n#\ncmds.addAttr( shortName=\'ff\', longName=\'forcefield\', dataType=\'double3\', multi=True )\n\n# Add a compound attribute named sampson with children home, midge,\n# damien, elizabeth, and sweetpea of varying types\n#\ncmds.addAttr( longName=\'sampson\', numberOfChildren=5, attributeType=\'compound\' )\ncmds.addAttr( longName=\'home\', attributeType=\'matrix\', parent=\'sampson\' )\ncmds.addAttr( longName=\'midge\', attributeType=\'message\', parent=\'sampson\' )\ncmds.addAttr( longName=\'damien\', attributeType=\'double\', parent=\'sampson\' )\ncmds.addAttr( longName=\'elizabeth\', attributeType=\'double\', parent=\'sampson\' )\ncmds.addAttr( longName=\'sweetpea\', attributeType=\'double\', parent=\'sampson\' )\n\n# To add an attribute that is to be interpreted as a color the\n# following attribute group must be used.\n#\n# Note that the word "float" must be in quotations since it is a\n# MEL keyword.\n#\ncmds.addAttr( longName=\'rainbow\', usedAsColor=True, attributeType=\'float3\' )\ncmds.addAttr( longName=\'redBow\', attributeType=\'float\', parent=\'rainbow\' )\ncmds.addAttr( longName=\'greenBow\', attributeType=\'float\', parent=\'rainbow\' )\ncmds.addAttr( longName=\'blueBow\', attributeType=\'float\', parent=\'rainbow\' )\n\n# Other legal attribute types that can be interpreted as colors need\n# not specify the "-usedAsColor" flag as it will be assumed.  These\n# include "-attributeType spectrum", "-attributeType reflectance",\n# "-dataType spectrumRGB", and "-dataType reflectanceRGB".\n#\ncmds.addAttr( longName=\'implColor\', dataType=\'spectrumRGB\' )\ncmds.addAttr( \'.implColor\', query=True, usedAsColor=True )\n# Result: 1 #\n\n# Add a double3 attribute named sanders with children bess, les and wes\n#\ncmds.addAttr( longName=\'sanders\', attributeType=\'double3\' )\ncmds.addAttr( longName=\'bess\', attributeType=\'double\', parent=\'sanders\' )\ncmds.addAttr( longName=\'les\', attributeType=\'double\', parent=\'sanders\' )\ncmds.addAttr( longName=\'wes\', attributeType=\'double\', parent=\'sanders\' )\n\n# Create a proxy attribute\ncmds.sphere( name=\'moon\' )\ncmds.select(\'earth\');\ncmds.addAttr(longName="someProxyAttr", proxy="moon.tx");',
 'addDynamic': "import maya.cmds as cmds\n\n# Create an emitter\ncmds.emitter( pos=(0, 0, 0), type='omni', r=100, sro=0, nuv=0, cye='none', cyi=1, spd=1, srn=0, nsp=1, tsp=0, mxd=0, mnd=0, dx=1, dy=0, dz=0, sp=0 )\n# Result: emitter1 #\n\n# Get the emitter to emit particles\ncmds.particle()\n# Result: particle2\ncmds.connectDynamic( 'particle1', em='emitter1' )\n\n# Create a particle to use as the source of the emitter\ncmds.particle( p=((6.0, 0, 7.0), (6.0, 0, 2.0)), c=1 )\n# Result: particle2\n\n# Use particle2 as a source of the emitter\ncmds.addDynamic( 'emitter1', 'particle2' )",
 'addExtension': 'import maya.cmds as cmds\n\n# Add an attribute named ms/mass with a default value of 1 and a\n# minimum value of 0.001 and a maximum of 10000 to all mesh shapes.\n#\ncmds.addExtension( nodeType=\'mesh\', shortName=\'ms\', longName=\'mass\', defaultValue=1.0, minValue=0.001, maxValue=10000 )\n\n# Add a multi attribute named ff/forcefield of type double3 to all mesh shapes.\n#\ncmds.addExtension( nodeType=\'mesh\', shortName=\'ff\', longName=\'forcefield\', dataType=\'double3\', multi=True )\n\n# Add a compound attribute named sampson with children home, midge,\n# damien, elizabeth, and sweetpea of varying types to all choice nodes.\n#\ncmds.addExtension( nodeType=\'choice\', longName=\'sampson\', numberOfChildren=5, attributeType=\'compound\' )\ncmds.addExtension( nodeType=\'choice\', longName=\'home\', attributeType=\'matrix\', parent=\'sampson\' )\ncmds.addExtension( nodeType=\'choice\', longName=\'midge\', attributeType=\'message\', parent=\'sampson\' )\ncmds.addExtension( nodeType=\'choice\', longName=\'damien\', attributeType=\'double\', parent=\'sampson\' )\ncmds.addExtension( nodeType=\'choice\', longName=\'elizabeth\', attributeType=\'double\', parent=\'sampson\' )\ncmds.addExtension( nodeType=\'choice\', longName=\'sweetpea\', attributeType=\'double\', parent=\'sampson\' )\n\n# To add an attribute that is to be interpreted as a color the\n# following attribute group must be used.\n#\n# Note that the word "float" must be in quotations since it is a\n# MEL keyword.\n#\ncmds.addExtension( nodeType=\'phong\', longName=\'rainbow\', usedAsColor=True, attributeType=\'float3\' )\ncmds.addExtension( nodeType=\'phong\', longName=\'redBow\', attributeType=\'float\', parent=\'rainbow\' )\ncmds.addExtension( nodeType=\'phong\', longName=\'greenBow\', attributeType=\'float\', parent=\'rainbow\' )\ncmds.addExtension( nodeType=\'phong\', longName=\'blueBow\', attributeType=\'float\', parent=\'rainbow\' )\n\n# Other legal attribute types that can be interpreted as colors need\n# not specify the "-usedAsColor" flag as it will be assumed.  These\n# include "-attributeType spectrum", "-attributeType reflectance",\n# "-dataType spectrumRGB", and "-dataType reflectanceRGB".\n#\ncmds.addExtension( nodeType=\'phong\', longName=\'implColor\', dataType=\'spectrumRGB\' )\n\n# Add a double3 attribute named sanders with children bess, les and wes\n# to all dag nodes, including shapes, transforms, and joints.\n#\ncmds.addExtension( nodeType=\'dagNode\', longName=\'sanders\', attributeType=\'double3\' )\ncmds.addExtension( nodeType=\'dagNode\', longName=\'bess\', attributeType=\'double\', parent=\'sanders\' )\ncmds.addExtension( nodeType=\'dagNode\', longName=\'les\', attributeType=\'double\', parent=\'sanders\' )\ncmds.addExtension( nodeType=\'dagNode\', longName=\'wes\', attributeType=\'double\', parent=\'sanders\' )',
 'addMetadata': "import maya.cmds as cmds\n\nimport maya.cmds as cmds\ncmds.polyPlane( name='p', ch=False )\ncmds.select( 'pShape', replace=True )\ncmds.dataStructure( format='raw', asString='name=IdStruct:int32=ID' )\ncmds.dataStructure( format='raw', asString='name=OffStruct:float=Offset' )\ncmds.dataStructure( format='raw', asString='name=OrgStruct:float[3]=Origin Point' )\n# Add three metadata streams\ncmds.addMetadata( streamName='IdStream', channelName='vertex', structure='IdStruct' )\ncmds.addMetadata( streamName='OffStream', channelName='vertex', structure='OffStruct' )\ncmds.addMetadata( streamName='OrgStream', channelName='edge', structure='OrgStruct' )\ncmds.addMetadata( streamName='VFStream', channelName='vertexFace', indexType='pair', structure='OrgStruct' )\n\n# Query for the list of all channel types possessing metadata\ncmds.addMetadata( query=True, channelName=True )\n# Return: ['edge', 'vertex', 'vertexFace'] #\n\n# Query for the structure assigned to a specific stream\ncmds.addMetadata( channelName='vertex', streamName='OffStream', query=True, structure=True )\n# Return: 'OffStruct' #\n\n# Query for the list of all streams on a specific channel type\ncmds.addMetadata( channelName='vertex', query=True, streamName=True )\n# Return: ['IdStream', 'OffStream'] #\n\n# Query for the list of all streams\ncmds.addMetadata( query=True, streamName=True )\n# Return: ['IdStream', 'OffStream', 'OrgStream', 'VFStream'] #\n\n# You can combine queries to answer more general questions about the\n# metadata on an object. For example suppose you wanted to know the\n# index type used by all Streams on the 'vertex' Channel.\n# First extract the list of Streams on the Channel\nstreams = cmds.addMetadata( channelName='vertex', query=True, streamName=True )\n# Loop through each Stream, querying the IndexType only for that Stream\nfor stream in streams:\n\tindexType = cmds.addMetadata( channelName='vertex', streamName=stream, query=True, indexType=True )[0]\n\tprint 'Index type on %s is %s' % (stream, indexType)",
 'addPP': 'import maya.cmds as cmds\n\nimport maya.cmds as cmds\n\ncmds.emitter( n=\'myEmitter1\' )\ncmds.particle( n=\'myParticle1\' )\ncmds.connectDynamic( \'myParticle1\', em=\'myEmitter1\' )\ncmds.select( \'myParticle1\' )\ncmds.emitter( n=\'myEmitter2\' )\ncmds.particle( n=\'myParticle2\' )\ncmds.connectDynamic( \'myParticle2\', em=\'myEmitter2\' )\n\ncmds.addPP( \'myEmitter2\', atr=\'rate\' )\n\n# Suppose that myEmitter2 is owned by a particle shape, "myParticle1."\n# addPP will add an attribute "myEmitter2RatePP" to myParticle1, will connect\n# myParticle1.myEmitter2RatePP to myEmitter2.ratePP, and will set myEmitter2.useRatePP\n# to true.',
 'adpAnalyticsDialog': '',
 'adpWaypoint': '',
 'adskAsset': '',
 'adskAssetLibrary': '',
 'adskAssetList': '',
 'adskAssetListUI': '',
 'affectedNet': "import maya.cmds as cmds\n\n# Create a network of this transform node's attributes that affect\n# each other\ncmds.affectedNet( 'transform1' )\n\n# Create a network all of the transform shared attributes that affect\n# each other\ncmds.affectedNet( t='transform' )\n\n# Create a network of the revolve and shape node type attributes that\n# affect each other\ncmds.affectedNet( t='revolve', t='shape' )",
 'affects': 'import maya.cmds as cmds\n\n# List the attributes on node "sphere" that affect the "tx" attribute\ncmds.sphere( n=\'sphere\' )\ncmds.affects( \'tx\', \'sphere\' )\n\n# List the attributes on nodes of type "transform" that are affected by\n# the "ty" attribute\ncmds.affects( \'ty\', by=True, t=\'transform\' )\n\n# List the attributes on nodes of type "revolve" that affect the\n# "outputSurface" attribute\ncmds.affects( \'outputSurface\', t=\'revolve\' )',
 'agFormatIn': '',
 'agFormatOut': '',
 'aimConstraint': 'import maya.cmds as cmds\n\n# Orients the aim vector of cube1 in it\'s local coordinate space, to point at cone1.\ncmds.aimConstraint( \'cone1\', \'cube1\' )\n\n# Aims cube2 at the average of the position of cone1 and surf2\ncmds.aimConstraint( \'cone1\', \'surf2\', \'cube2\', w=.1 )\n\n# Sets the weight for cone1\'s effect on cube2 to 10.\ncmds.aimConstraint( \'cone1\', \'cube2\', e=True, w=10.0 )\n\n# Removes surf2 from cube2\'s aimConstraint.\ncmds.aimConstraint( \'surf2\', \'cube2\', e=True, rm=True )\n\n# Adds surf3 to cube2\'s aimConstraint with the default weight.\ncmds.aimConstraint( \'surf3\', \'cube2\' )\n\n# Aim constrain the z-axis only of sph2 to sph1\ncmds.aimConstraint( \'sph1\', \'sph2\', skip=["x","y"] )',
 'air': "import maya.cmds as cmds\n\ncmds.air( name='particle1', m=5.0, mxd=2.0 )\n# Creates an air field with magnitude 5.0 and maximum distance 2.0,\n# and adds it to the list\n# of fields particle1 owns.\n\ncmds.air( wakeSetup=True )\n# Creates an air field with no no velocity in and of itself (magnitude = 0).\n# All of the air's\n# velocity is derived from the motion of the objects that own the field.",
 'aliasAttr': 'import maya.cmds as cmds\n\ncmds.createNode( \'blendShape\', n=\'blender\' )\n#\n# Define intuitive names for the weights of a blendShape.\n# The blendShape command does this automatically to allow you\n# to refer to the weight corresponding to a target shape by the name\n# of that shape.\n#\ncmds.aliasAttr( \'smile\', \'blender.w[0]\', \'frown\', \'blender.w[1]\' )\n# Result: 2 #\n#\n# List all the attribute aliases for the node blendShape1\n#\ncmds.aliasAttr( \'blender\', query=True )\n# Result: smile weight[0] frown weight[1] #\n#\n# Allow the X rotation on a joint to be called its "roll"\n#\ncmds.createNode( \'joint\', n=\'elbow\' )\ncmds.aliasAttr( \'roll\', \'elbow.rx\' )\n# Result: 1 #\ncmds.aliasAttr( \'tuck\', \'elbow.ry\' )\n# Result: 1 #\n#\n# Remove the roll alias defined above.\n#\ncmds.aliasAttr( \'elbow.roll\', rm=True )\n#\n# Remove the tuck alias defined above.\n#\ncmds.aliasAttr( \'elbow.ry\', rm=True )',
 'align': "import maya.cmds as cmds\n\n# align the selected objects to their average mid-point in x\ncmds.align(x='mid')\n\n# align the selected objects to the mid-point in x of the first select object\ncmds.align(x='mid', alignToLead=True)",
 'alignCtx': "import maya.cmds as cmds\n\n# Create a poly sphere and a poly cube, then move them apart\ncmds.polySphere(r=3, n='pSphere1')\ncmds.move(5, 0, 0)\ncmds.polyCube(w=3, h=3, d=3, n='pCube1')\ncmds.move(-5, 3, 0)\ncmds.select('pSphere1', 'pCube1', r=True)\n\n# Create a new align context which is used to align objects, then switch to it\n# Now you can use this tool to align objects\ncmds.alignCtx('alignCtx1',a=True)\ncmds.setToolTo('alignCtx1')",
 'alignCurve': 'import maya.cmds as cmds\n\n# Do modify positional continuity on both curves with no history:\ncmds.alignCurve( ch=False, pc=True, pct=6 )\n\n# Do positional and tangent continuity, with the second curve\n# tangent modified (by default move position continuity is done\n# on the first curve):\ncmds.alignCurve( tc=True, tct=2 )',
 'alignSurface': 'import maya.cmds as cmds\n\n# Do modify positional continuity on both active surfaces with no history:\ncmds.alignSurface( ch=False, pc=True, pct=6 )\n\n# Do positional and tangent continuity, with the second surface\n# tangent modified (by default move position continuity is done\n# on the first surface):\ncmds.alignSurface( tc=True, tct=2 )',
 'allNodeTypes': "import maya.cmds as cmds\n\n\ncmds.allNodeTypes()\n# Result: [u'list', u'of', u'node', u'types']  #\n\ncmds.allNodeTypes(includeAbstract=True)\n# Result: [u'very (abstract)', u'long (abstract)', u'list', u'of', u'all (abstract)', u'node', u'types']  #\n\n# Trickier example using Python capabilities to get node types starting with 'l'\n[item for item in cmds.allNodeTypes(includeAbstract=True) if item[0].lower() == 'l']\n# Result: [u'long (abstract)', u'list']  #",
 'ambientLight': 'import maya.cmds as cmds\n\n# Create an ambientLight light\nlight = cmds.ambientLight(intensity=0.8)\n\n# Change the light intensity\ncmds.ambientLight( light, e=True, intensity=0.5 )\n\n# Query it\ncmds.ambientLight( light, q=True, intensity=True )\n# Result:0.5 #',
 'angleBetween': "import maya.cmds as cmds\n\n# To find the euler angle between these two vectors. The result is three\n# angles in the current angular unit. In this example, the first vector\n# must be rotated -63.434949 degrees about the X axis, 16.60155 degrees\n# about the Y axis and -26.565051 degrees about the Z axis to achieve\n# the second vector.\n\ncmds.angleBetween( euler=True, v1=(0.0, 1.0, 2.0), v2=(1.0, 2.0, 0.0) )\n# Result: -63.434949 16.60155 -26.565051 #\n\n# To find the angle between these two vectors.  The result is an axis and\n# an angle (in the current angular unit).  In this example, the first\n# vector must be rotated 66.421822 degrees about the axis\n# (-0.8728716, 0.4364358, -0.2182179) to achieve the second vector.\n\ncmds.angleBetween( v1=(0.0, 1.0, 2.0), v2=(1.0, 2.0, 0.0) )\n# Result: -0.8728716 0.4364358 -0.2182179 66.421822 #\n\n# How to create a dependency node that calculates the angle between two\n# vectors. This example shows how the (x,z) position of a sphere\n# can be used to control the rotate factors (about y) of a cone shape.\n\nangleBtwnNode = cmds.angleBetween(v1=(1, 0, 0), v2=(1, 0, 0), ch=True)\nsphere = cmds.sphere()\ncmds.move( 5, 0, 5, sphere[0] )\ncmds.connectAttr( sphere[0]+'.translateX', angleBtwnNode+'.vector2X' )\ncmds.connectAttr( sphere[0]+'.translateZ', angleBtwnNode+'.vector2Z' )\n\ncone = cmds.cone( ch=False )\nconvert = cmds.createNode( 'unitConversion' )\ncmds.connectAttr( angleBtwnNode+'.eulerY', convert+'.input' )\ncmds.connectAttr( convert+'.output', cone[0]+'.rotateY' )",
 'animCurveEditor': 'import maya.cmds as cmds\n\n# Check to see if the "default" graph editor has been created\n#\ncmds.animCurveEditor( \'graphEditor1GraphEd\', exists=True )\n# Show result curves\n#\ncmds.animCurveEditor( \'graphEditor1GraphEd\', edit=True, showResults=\'on\' )\n# Show Play Range Shades\n#\ncmds.animCurveEditor( \'graphEditor1GraphEd\', edit=True, showPlayRangeShades=\'on\' )\n# Lock Play Range Shades\n#\ncmds.animCurveEditor( \'graphEditor1GraphEd\', edit=True, lockPlayRangeShades=\'on\' )\n# Decrease the sampling rate for the result curves\n#\ncmds.animCurveEditor( \'graphEditor1GraphEd\', edit=True, resultSamples=5 )\n\n# Constrain all Graph Editor animation curve traversals to the X-axis\n#\ncmds.animCurveEditor( \'graphEditor1GraphEd\', edit=True, constrainDrag=1 )',
 'animDisplay': 'import maya.cmds as cmds\n\n# If the current time unit were ntsc (30 frames per\n# second) frame 50 would be displayed as "00:00:01:20".\n#\ncmds.animDisplay( timeCode=True )\n\n\n# Set the display option so that interactive operations\n# in the graph editor or dope sheet will cause the\n# model views to be updated simultaneously\n#\ncmds.animDisplay( modelUpdate="interactive" )',
 'animLayer': 'import maya.cmds as cmds\n\n\ncmds.animLayer("layer1", mute=True, solo=True, override=True, passthrough=False, lock=True)\n\ncmds.animLayer("layer1", query=True, mute=True)\n# Result: 1 #\n\ncmds.animLayer("layer1", query=True, solo=True)\n# Result: 1 #\n\ncmds.animLayer("layer1", query=True, override=True)\n# Result: 1 #\n\ncmds.animLayer("layer1", query=True, passthrough=True)\n# Result: 0 #\n\ncmds.animLayer("layer1", query=True, lock=True)\n# Result: 1 #\n\ncmds.animLayer("layer1", query=True, parent=True)\n# Result: BaseAnimation #',
 'animView': "import maya.cmds as cmds\n\n# Look at the area between 0 and 5 seconds, and the range 0 - 100\ncmds.animView( 'graphView', startTime='0sec', endTime='5sec', minValue=0, maxValue=100 )",
 'annotate': 'import maya.cmds as cmds\n\n# The following specifies an annotation with text "my annotation text" on\n# object mySphere, with the text being centered at point [5,6,3].\ncmds.sphere( name=\'mySphere\' )\ncmds.annotate( \'mySphere\', tx=\'my annotation text\', p=(5, 6, 5) )',
 'appHome': "import maya.cmds as cmds\n\n# Hide app home\ncmds.appHome(edit=True, visibility=False)\n\n# Show app home\ncmds.appHome(edit=True, visibility=True)\n\n# Show app home on GettingStarted tab\ncmds.appHome(visibility=True, setTab='GettingStarted')\n\n# Update app home recent file data\ncmds.appHome(updateRecentFiles=True)\n\n# Query app home visilibity\nvisible = cmds.appHome(query=True, visibility=True)\n\n# Toggle app home visibility\ncmds.appHome(edit=True, toggleVisibility=True)",
 'applyAttrPattern': 'import maya.cmds as cmds\n\nimport maya.cmds as cmds\n\ncmds.polySphere( name="sphere1" )\ncmds.applyAttrPattern( patternName="myXMLPattern" )\n// Result: 1 //\n\nname2 = cmds.polySphere( name="sphere2" )\nname3 = cmds.polySphere( name="sphere3" )\ncmds.select( [name2, name3] )\ncmds.applyAttrPattern( patternName="myXMLPattern" )\n// Result: 2 //\n\ncmds.applyAttrPattern( patternName="myXMLPattern", nodeType="transform" )\n// Result: 1 //',
 'applyMetadata': "import maya.cmds as cmds\n\nimport maya.cmds as cmds\npNode = cmds.polyPlane( name='p' )\n# Create a sample structure\ncmds.dataStructure( format='raw', asString='name=IdStruct:int32=ID' )\n# Apply some metadata based on the defined structure to the created mesh\n# Normally you'll only see these in Maya files but it can be used from the\n# command line.\ncmds.applyMetadata( pNode, value='channel\\nname face\\nstream\\nname IdStream\\nstructure IdStruct\\n0\\n99\\n1\\n999\\n2\\n9999\\nendStream\\nendChannel\\nendAssociations' )\n# Return: 1 #",
 'applyTake': "import maya.cmds as cmds\n\n#    Apply all of the recorded data to param curves.\ncmds.applyTake()\n\n#    Applies the takes from clock and ultra devices and starts the\n#    data at anim time 100.\ncmds.applyTake( d=('clock', 'ultra'), st=100 )\n\n#    Applies the take from the ultra device and uses the euler and\n#    simplify filters.\ncmds.applyTake( d='ultra', f=('euler', 'simplify') )\n\n#    Applies only the shoulder channel and all of its children.\ncmds.applyTake( d='ultra', c='shoulder', sc=True, rc=True )",
 'arcLenDimContext': 'import maya.cmds as cmds\n\ncmds.arcLenDimContext()',
 'arcLengthDimension': "import maya.cmds as cmds\n\n# Measure the arcLength of curve curveShape1 at u = 0.5\ncmds.curve( d=3, p=((-9.3, 0, 3.2), (-4.2, 0, 5.0), (6.0, 0, 8.6), (2.1, 0, -1.9)), k=(0, 0, 0, 1, 2, 2));\ncmds.arcLengthDimension( 'curveShape1.u[0.5]' )\n\n# Measure the arcLength of sphere nurbsSphere1 at u = 0.5 and v = 0.5\ncmds.sphere();\ncmds.arcLengthDimension( 'nurbsSphere1.uv[0.5][0.5]' );",
 'arclen': "import maya.cmds as cmds\n\ncmds.arclen( 'curve1' )\n# This command returns a float value that is the length of curve1 in\n# the current linear units.\n\ncurveInfoNode = cmds.arclen('curve1', ch=True)\ncmds.expression( s= 'surface1.sx = %s.arcLength' %  curveInfoNode )\n# The first command produces a curve info node for curve1 and returns\n# the name of the curve info node.  The second command shows how the\n# arc length attribute of the curve info node can be used to set up\n# an expression, ie. it drives one of the scale factors of surface1.\n#\n# Note the expression command still only creates MEL expressions, although they can\n# be called from Python.",
 'arrayMapper': "import maya.cmds as cmds\n\ncmds.arrayMapper( target='particle1', destAttr='rgbPP', inputV='ageNormalized', type='ramp' )",
 'art3dPaintCtx': "import maya.cmds as cmds\n\n# Create a new 3d paint context, then switch to it\ncmds.art3dPaintCtx('art3dPaintCtx1')\ncmds.setToolTo('art3dPaintCtx1')\n\n# Set art3dPaintCtx1's radius to 2.0, lowerradius to 0.5\ncmds.art3dPaintCtx('art3dPaintCtx1', edit=True, r=2.0, lr=0.5)",
 'artAttr': '',
 'artAttrCtx': "import maya.cmds as cmds\n\n# Create a new Attribute Paint Tool context, then switch to it\ncmds.artAttrCtx('artAttrCtx1')\ncmds.setToolTo('artAttrCtx1')\n\n# Set brush's radius to 2.0, lower radius to 0.5\ncmds.artAttrCtx('artAttrCtx1', edit=True, r=2.0, lr=0.5)",
 'artAttrPaintVertexCtx': "import maya.cmds as cmds\n\n# Create a new vertexAttr paint context, then switch to it\ncmds.artAttrPaintVertexCtx('artAttrPaintVertexCtx1')\ncmds.setToolTo('artAttrPaintVertexCtx1')",
 'artAttrSkinPaint': '',
 'artAttrSkinPaintCmd': '',
 'artAttrSkinPaintCtx': 'import maya.cmds as cmds\n\n# Create a new skinAttr paint context, then switch to it\ncmds.artAttrSkinPaintCtx(\'artAttrSkinPaintCtx1\')\ncmds.setToolTo(\'artAttrSkinPaintCtx1\')\n\n# Set the edit weight operation to "smooth"\ncmds.artAttrSkinPaintCtx(\'artAttrSkinPaintCtx1\', edit=True, sao=\'smooth\')',
 'artAttrTool': 'import maya.cmds as cmds\n\n# Add a tool named "customtoolPaint" to the list of\n# attribute painting tools, then creates a new context called\n# "customtoolPaintContext" which utilises the "customtoolPaint" tool.\n#\ncmds.artAttrTool( add=\'customtoolPaint\' )\ncmds.artAttrCtx( \'customtoolPaintContext\', whichTool=\'customtoolPaint\' )\n\n# List all tools currently defined.\n#\ncmds.artAttrTool( query=True )',
 'artBaseCtx': '',
 'artBuildPaintMenu': 'import maya.cmds as cmds\n\n\n# build a list of paintable attributes for the selected item(s)\n#\ncmds.artBuildPaintMenu();',
 'artFluidAttr': '',
 'artFluidAttrCtx': "import maya.cmds as cmds\n\n# Create a new fluidAttr paint context, then switch to it\ncmds.artFluidAttrCtx('artFluidAttrCtx1')\ncmds.setToolTo('artFluidAttrCtx1')\n\n# Set to paint the color property on the fluid\ncmds.artFluidAttrCtx('artFluidAttrCtx1', edit=True, property='color')",
 'artPuttyCtx': "import maya.cmds as cmds\n\n# Set the brush radius to 20.0\ncmds.artPuttyCtx( 'artPuttyContext', e=True, radius=20.00  )\n\n# Set the display of additional brush feedback\ncmds.artPuttyCtx( 'artPuttyContext', e=True, brushfeedback=True )",
 'artSelect': '',
 'artSelectCtx': "import maya.cmds as cmds\n\n# Create a new select context, then switch to it\ncmds.artSelectCtx('artSelectCtx1')\ncmds.setToolTo('artSelectCtx1')\n\n# Set brush's radius to 2.0, lower radius to 0.5\ncmds.artSelectCtx('artSelectCtx1', edit=True, r=2.0, lr=0.5)",
 'artSetPaint': '',
 'artSetPaintCtx': "import maya.cmds as cmds\n\n# Create a new set membership paint context, then switch to it\ncmds.artSetPaintCtx('artSetPaintCtx1')\ncmds.setToolTo('artSetPaintCtx1')\n\n# Set brush's radius to 2.0, lower radius to 0.5\ncmds.artSetPaintCtx('artSetPaintCtx1', edit=True, r=2.0, lr=0.5)",
 'artUserPaintCtx': "import maya.cmds as cmds\n\n# create the context\ncmds.artUserPaintCtx('artUserPaintCtx')\n\n# set the init Mel script\ncmds.artUserPaintCtx( 'artUserPaintCtx', e=True, ic='spherePaint' )",
 'arubaNurbsToPoly': "import maya.cmds as cmds\n\n# To create a new polygonal surface from a NURBS surface:\ncmds.arubaNurbsToPoly( 'nurbsSphere1' )\n\n# To create a new polygonal surface from a NURBS surface with\n# history so that the tesselation can be edited afterwards:\ncmds.arubaNurbsToPoly( 'nurbsSphere1', ch=True )",
 'assembly': 'import maya.cmds as cmds\n\n\n#Create a default type of assembly and name it MyAssembly.\n#The assembly name is optional.\n#\ncmds.assembly(name=\'MyAssembly\')\n\n#Create an assembly of type MyAssemblyType and name it MyAssembly.\n#\ncmds.assembly(name=\'MyAssembly\', type=\'MyAssemblyType\')\n\n#Set the default type to be MyAssemblyType.\n#\ncmds.assembly(edit=True, defaultType=\'MyAssemblyType\')\n\n#Create a representation of type "MyRepType", on assembly myAssembly, and\n#name it "MyRepName"\n#\ncmds.assembly(myAssembly, edit=True, createRepresentation=\'MyRepType\',\n              repName=\'MyRepName\')\n\n#Rename representation "MyRepName" to "MyNewRepName" on assembly myAssembly.\n#\ncmds.assembly(myAssembly, edit=True, renameRepresentation=\'MyRepName\',\n                      repName=\'MyNewRepName\')\n\n#Create a representation of type "Locator", on assembly myAssembly, name it\n#"myLocator", and add an annotation using the input flag.\n#\ncmds.assembly(myAssembly, edit=True, createRepresentation=\'Locator\',\n\t\t\t  repName="myLocator", input="An Annotation")\n\n#Create a representation of type "Scene", on assembly myAssembly,\n#using file "/path/to/mayafile.mb"\n#\ncmds.assembly(myAssembly, edit=True, createRepresentation=\'Scene\',\n\t\t\t  input="/path/to/mayafile.mb")\n\n\n#Delete scene representation from assembly myAssembly\ncmds.assembly(myAssembly, edit=True, deleteRepresentation="mayafile.mb")\n\n#Delete locator representation from assembly myAssembly\ncmds.assembly(myAssembly, edit=True, deleteRepresentation="myLocator")\n\n#Set the procedure that provides the representation type label for\n#an assembly type.\n#\ncmds.assembly(edit=True, repTypeLabelProc=\'MyRepTypeLabelQuery\', type=\'MyAssembly\')\n\n#Set the label for the default assembly type.\n#\ncmds.assembly(edit=True, label=\'My Assembly Type\')\n\n#Set the procedure that provides the representation type list which the\n#default assembly supports.\n#\ncmds.assembly(edit=True, listRepTypesProc=\'MyRepTypesProc\')\n\n#Set the pre-create UI procedure for a representation type, for a\n#specific type of assembly.\n#\ncmds.assembly(edit=True, repPreCreateUIProc=\'MyRepresentation\', proc=\'MyPreCreateProcedure\', type=\'MyAssembly\')\n\n#Set the post-create UI procedure for a representation type, for the\n#default assembly type.\n#\ncmds.assembly(edit=True, repPostCreateUIProc=\'MyRepresentation\', proc=\'MyPostCreateProcedure\' )',
 'assignCommand': 'import maya.cmds as cmds\n\n# Print out all the names of the named command objects and the\n# hotkeys attached to them.\n#\ncount = cmds.assignCommand(query=True, numElements=True)\nprint (\'There are \' + str(count) + \' named command objects.\')\n\nfor index in range(1, count+1):\n    keyString = cmds.assignCommand(index, query=True, keyString=True)\n\n    if  0 < len(keyString) and keyString[0] != "NONE":\n        displayString = \'(\'\n\n        if "1" == keyString[2]: displayString += \'Ctrl+\'\n        if "1" == keyString[1]: displayString += \'Alt+\'\n        if "1" == keyString[5]: displayString += \'Command+\'\n        if "1" == keyString[6]: displayString += \'Shift+\'\n\n        displayString += keyString[0]\n\n        if "1" == keyString[3]: displayString += \' Release\'\n        if "1" == keyString[4]: displayString += \' KeyRepeat\'\n\n        displayString += \')\'\n\n        print cmds.assignCommand(index, query=True, name=True), displayString',
 'assignInputDevice': 'import maya.cmds as cmds\n\ncmds.assignInputDevice( \'setKeyframe\', d=\'spaceball\', c=\'Button1\' )\n\n# This command will assign button1 on the spaceball with\n# the setKeyframe command.  This is very much like using\n# the spaceball buttons as hotkeys.\n\ncmds.assignInputDevice( \'"currentTime -e Axis0"\', d=\'midi\', ct=True, m=True )\n\n# This command will execute the command to set the time\n# to the value of the first midi slider.  As the slider\n# moves this command will be executed.  So the slider\n# will control time.',
 'assignViewportFactories': "import maya.cmds as cmds\n\n# To set the viewport factories for all my_material nodes.\n#\ncmds.assignViewportFactories( materialFactory='solidMaterialInfo', textureFactory='solidTextureInfo', nodeType='my_material' )",
 'attachCurve': "import maya.cmds as cmds\n\n# Attach the curves and remove the multiple knots:\ncmds.attachCurve( 'curve1', 'curve2', kmk=False )",
 'attachDeviceAttr': "import maya.cmds as cmds\n\ncmds.attachDeviceAttr( 'surface1.translateX', d='spaceball', ax='XAxis' )\n\n# This command will assign the XAxis of the spaceball to\n# the translateX attribute of surface1.  This\n# assignment is independent of the selection list (i.e.\n# if surface1 was selected when the command is executed,\n# surface1 will be translated by the spaceball regardless\n# of the current selection.)\n\ncmds.attachDeviceAttr( d='spaceball', ax='XAxis', at='translateX' )\n\n# This command will assign the XAxis of the spaceball to\n# the translateX attribute of the selected objects.\n\ncmds.attachDeviceAttr( d='wacom', ax='puck:X', c='puckButton1', at='translateX', sl=True )\ncmds.attachDeviceAttr( d='wacom', ax='puck:Y', c='puckButton1', at='translateY', sl=True )\n\n# This command will attach the wacom puck X and Y axes to the\n# X and Y translate attributes of the selected items.\n# When the selection changes so does the attachment.\n# The -c option means you can only move the selected items\n# with the puck when button1 on the puck is down.",
 'attachSurface': "import maya.cmds as cmds\n\n# Attach the nurbs planes (in the default U direction) and remove the\n# multiple knots:\ncmds.attachSurface( 'nurbsPlane1', 'nurbsPlane2', kmk=False )\n\n# Attach the two active surfaces along the v direction (keeps multiple\n# knots by default):\ncmds.attachSurface( du=False )",
 'attrColorSliderGrp': "import maya.cmds as cmds\n\ncmds.window( title='Attr Field Slider Groups' )\nobjName = cmds.shadingNode('phong', asShader=True)\ncmds.columnLayout()\ncmds.attrColorSliderGrp( at='%s.color' % objName )\ncmds.showWindow()",
 'attrCompatibility': '',
 'attrControlGrp': "import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout()\ncmds.attrControlGrp( attribute='defaultResolution.width' )\ncmds.showWindow()",
 'attrEnumOptionMenu': "import maya.cmds as cmds\n\nwindow = cmds.window()\ncmds.columnLayout()\nnode = cmds.createNode('opticalFX')\nattrib = node + '.glowType'\ncmds.attrEnumOptionMenu( label='Glow Type', attribute=attrib );\ncmds.showWindow( window )",
 'attrEnumOptionMenuGrp': "import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout()\ncmds.attrEnumOptionMenuGrp( l='Output Format',\n                            at='defaultRenderGlobals.imageFormat',\n                            ei=[(0, 'GIF'),(1, 'SoftImage'), (2, 'RLA'),\n                                (3, 'TIFF'), (4, 'TIFF16'), (5, 'SGI'),\n                                (6, 'Alias PIX'), (7, 'Maya IFF'), (8, 'JPEG'),\n                                (9, 'EPS'), (10, 'Maya16 IFF'), (11, 'Cineon'),\n                                (12, 'Quantel'), (13, 'SGI16'), (19, 'Targa'),\n                                (20, 'BMP') ] )\ncmds.showWindow()",
 'attrFieldGrp': "import maya.cmds as cmds\n\n#    Create an object and a window containing an 'attrFieldGrp' that will\n#    manipulate the position of that object.\n#\nobject = cmds.sphere()\nwindow = cmds.window(title='attrFieldGrp Example')\ncmds.columnLayout()\ncmds.attrFieldGrp( attribute='%s.translate' % object[0] )\ncmds.showWindow()",
 'attrFieldSliderGrp': "import maya.cmds as cmds\n\ncmds.window( title='Attr Field Slider Groups' )\nobjName = cmds.sphere()\ncmds.columnLayout()\ncmds.attrFieldSliderGrp( min=-10.0, max=10.0, at='%s.tx' % objName[0] )\ncmds.showWindow()",
 'attrNavigationControlGrp': "import maya.cmds as cmds\n\nnewNode = cmds.shadingNode( 'blinn', asShader=True )\nnewNodeAttr = newNode + '.normalCamera'\ncmds.window()\ncmds.columnLayout()\ncmds.attrNavigationControlGrp( l='bump mapping', at=newNodeAttr )\ncmds.showWindow()",
 'attributeInfo': "import maya.cmds as cmds\n\ncmds.createNode( 'choice' )\n\n# Get the list of only hidden choice node attributes\n#\ncmds.attributeInfo( h=True, t='choice' )\n# Result: [u'message', u'isHistoricallyInteresting', u'binMembership'] #\n\n# Get the list of all attributes on choice nodes\ncmds.attributeInfo( all=True, t='choice' )\n# Result: [u'message', u'caching', u'isHistoricallyInteresting', u'nodeState', u'binMembership', u'selector', u'input', u'output'] #\n\n# Get the list of boolean or enumerated transform node attributes\n#\ncmds.attributeInfo( b=True, e=True, t='transform' )\n# Result: [u'caching', u'nodeState', u'visibility', u'intermediateObject', u'template', u'ghosting', u'useObjectColor', u'overrideDisplayType', u'overrideLevelOfDetail', u'overrideShading', u'overrideTexturing', u'overridePlayback', u'overrideEnabled', u'overrideVisibility', u'lodVisibility', u'layerRenderable', u'renderLayerRenderable', u'ghostingMode', u'rotateOrder', u'minTransXLimitEnable', u'minTransYLimitEnable', u'minTransZLimitEnable', u'maxTransXLimitEnable', u'maxTransYLimitEnable', u'maxTransZLimitEnable', u'minRotXLimitEnable', u'minRotYLimitEnable', u'minRotZLimitEnable', u'maxRotXLimitEnable', u'maxRotYLimitEnable', u'maxRotZLimitEnable', u'minScaleXLimitEnable', u'minScaleYLimitEnable', u'minScaleZLimitEnable', u'maxScaleXLimitEnable', u'maxScaleYLimitEnable', u'maxScaleZLimitEnable', u'inheritsTransform', u'displayHandle', u'displayScalePivot', u'displayRotatePivot', u'displayLocalAxis', u'dynamics', u'showManipDefault', u'rotationInterpolation', u'miDeriveFromMaya', u'miHide', u'miVisible', u'miTrace', u'miShadow', u'miCaustic', u'miGlobillum', u'miExportGeoShader'] #\n\n# Get the list of short names of enumerated attributes on a particular choice\n# node.\n#\ncmds.attributeInfo( 'choice1', s=True, e=True )\n# Result: message input output selector\n\n# Get the list of hidden or internal attributes on one particular choice node\n# using the UI name for the attributes (that is the one that will show up\n# in the attribute editor).\n#\ncmds.attributeInfo( 'choice1', ui=True, h=True, i=True )\n# Result: [u'Message', u'Caching', u'Is Historically Interesting', u'Node State', u'Bin Membership'] #",
 'attributeMenu': "import maya.cmds as cmds\n\ncmds.attributeMenu( 'nodeName', inputs=1, beginMenu=True, editor='editor' )\ncmds.attributeMenu( 'nodeName', inputs=0, beginMenu=True, editor='editor' )",
 'attributeName': 'import maya.cmds as cmds\n\nimport maya.cmds as cmds\ncmds.attributeName( "persp.tx" )\n# Result: Translate X #\n\ncmds.attributeName( "persp.translateX", s=True )\n# Result: tx #\n\ncmds.attributeName( "persp.tx", l=True )\n# Result: translateX #\n\ncmds.attributeName( "nurbsSphere1.controlPoints[50].xv", leaf=True )\n// Result: xValue //\n\ncmds.attributeName( "nurbsSphere1.controlPoints[50].xv", leaf=False )\n// Result: Control Points[50].X Value //',
 'attributeQuery': 'import maya.cmds as cmds\n\n# Determine the hidden status of the "selector" attribute on choice nodes.\n#\ncmds.attributeQuery( \'selector\', typ=\'choice\', h=True )\n# Result: 0\n\n# Determine the hidden status of the "selector" attribute on this choice node.\n# (Usually the same but you can do this for dynamic attributes too.)\n#\ncmds.createNode( \'choice\', n=\'whoIsIt\' )\n# Result: choice1\ncmds.attributeQuery( \'selector\', n=\'whoIsIt\', h=True )\n# Result: 0\n\n# Determine the range of the selector value on choice nodes.\n# In this case there is no range.\n# Note, if there is only a minimum or only a maximum range will not set.\n#\ncmds.attributeQuery( \'selector\', typ=\'choice\', range=True )\n\n# For the next several examples create a poly cube and add extra attributes.\ncmds.polyCube( cuv=4, ch=1, w=1, h=1, d=1, sx=1, sy=1, sz=1, ax=(0, 1, 0) )\ncmds.addAttr( \'|pCube1\', ln=\'egRange\', at=\'long\', min=0, max=5, dv=2 )\ncmds.setAttr( \'|pCube1.egRange\', e=True, keyable=False )\n\n# Determine if an attribute is keyable\n#\ncmds.attributeQuery( \'egRange\', node=\'pCube1\', k=True )\n# Result: 0\n\n# Determine the minimum and maximum values of the added attribute egRange\n#\ncmds.attributeQuery( \'egRange\', node=\'pCube1\', range=True )\n# Result: [0.0, 5.0]\n\n# Determine if there is a minimum for the attribute.\n# Note, having a minimum or maximum value does not imply the attribute has a range.\ncmds.addAttr( \'|pCube1\', ln=\'egMin\', at=\'long\', min=2 )\ncmds.attributeQuery( \'egMin\', node=\'pCube1\', minExists=True )\n# Result: 1\ncmds.attributeQuery( \'egMin\', node=\'pCube1\', maxExists=True )\n# Result: 0\ncmds.attributeQuery( \'egMin\', node=\'pCube1\', min=True )\n# Result: [2.0]\n\n# Determine if an attribute is an enum\n# List the enum strings. This will use \':\' as a separator like the attr is written in\n# an .ma file.\ncmds.addAttr( \'|pCube1\', ln=\'myEnum\', at=\'enum\', en=\'chicken:turkey:duck:\', ct=\'fowl\' )\ncmds.attributeQuery( \'myEnum\', node=\'pCube1\', listEnum=True )\n# Result: [u\'chicken:turkey:duck\'] #\n\n# Secondary way to find an attribute\'s type directly\ncmds.attributeQuery( \'myEnum\', node=\'pCube1\', attributeType=True )\n# Result: [\'enum\'] #\n\n# See to which categories and attribute belongs\ncmds.attributeQuery( \'myEnum\', node=\'pCube1\', categories=True )\n# Result: [\'fowl\'] #',
 'audioTrack': 'import maya.cmds as cmds\n\n#  Move the audio clip named "audio2" to track 3\n#\ncmds.audioTrack( \'audio2\', track=3 )\n\n# Lock the track containing the audio clip named "audio1"\n#\ncmds.audioTrack( \'audio1\', lock=True )\n\n# Remove any empty tracks\n#\ncmds.audioTrack(removeEmptyTracks=True)\n\n# audioTrack -q -track audio1;\n#\ncmds.audioTrack( \'audio1\', q=True, track=True )',
 'autoKeyframe': 'import maya.cmds as cmds\n\n# Start remembering attributes that have changed\n#\ncmds.autoKeyframe( state=True )\n\n# Set a keyframe for all attributes that have changed\n# since the last "autoKeyframe( state=True )\n#\ncmds.autoKeyframe()\n\n# Stop remembering attributes that have changed.\n# Note that Subsequent "autoKeyframe" commands\n# (with no flags) will have no effect until an\n# autoKeyframe( state=True ) command is executed.\n#\ncmds.autoKeyframe( state=False )\n\n# List the plugs that will be considered to add a key on completion of the\n# next set attribute.\ncmds.autoKeyframe(query=True, listAttr=True)\n\n# Add to the list the plugs that will be considered to add a key on\n# completion of the next set attribute.\ncmds.autoKeyframe(edit=True, addAttr=\'myNode.myAttr\')\n\n# When auto-keying, key all character attributes, not just\n# those that have changed.\n#\ncmds.autoKeyframe( characterOption="all" )',
 'autoPlace': 'import maya.cmds as cmds\n\n#    Move the scene around a bit so the grid is no longer\n#    centered in the view.\n#\ncmds.track( right=10 )\ncmds.track( down=10 )\n\n#    Create a sphere.\n#\nsphere = cmds.sphere()\n\n#    Reposition the sphere so that it is in the center of the\n#    view.\n#\nposition = cmds.autoPlace()\ncmds.move( position[0], position[1], position[2], sphere[0], relative=True )',
 'autoSave': 'import maya.cmds as cmds\n\n# set the interval between auto-saves to 5 minutes\n#\ncmds.autoSave( int=300 )\n\n# query the auto-save interval\n#\ncmds.autoSave( q=True, int=True )\n# Result: 300.0 #',
 'backgroundEvaluationManager': 'import maya.cmds as cmds\n\n\nimport maya.cmds as cmds\n\n# Set background evaluation manager to serial mode\ncmds.backgroundEvaluationManager( mode="serial" )\n# Result: True #\n\n# Return the current background evaluation manager mode\ncmds.backgroundEvaluationManager( query=True, m=True )\n# Result: [u\'serial\'] #\n\n# Pause background evaluation\ncmds.backgroundEvaluationManager( pause=True )\n# Result: True #\n\n# Return the current background evaluation manager mode\ncmds.backgroundEvaluationManager( query=True, p=True )\n# Result: True #\n\n# Resume background evaluation (unless was paused by someone else)\ncmds.backgroundEvaluationManager( resume=True )\n# Result: True #\n\n# Enable fast interrupt of background executions\ncmds.backgroundEvaluationManager( interrupt=True )\n# Result: True #',
 'bakeClip': "import maya.cmds as cmds\n\n#    First create a simple character.\n#\ncmds.cone( n='bakeCone' )\ncmds.character( n='coneCharacter' )\n\n#    Create some animation.\n#\ncmds.select( 'bakeCone', r=True )\ncmds.currentTime( 0 )\ncmds.setKeyframe( 'bakeCone.tx', v=0 )\ncmds.currentTime( 10 )\ncmds.setKeyframe( 'bakeCone.tx', v=10 )\n\n#     Make a clip.\n#\ncmds.clip( 'coneCharacter', startTime=0, endTime=10, name='up' )\n\n#    Create a second clip.\n#\ncmds.select( 'bakeCone', r=True )\ncmds.currentTime( 15 )\ncmds.setKeyframe( 'bakeCone.tx', v=15 )\ncmds.currentTime( 25 )\ncmds.setKeyframe( 'bakeCone.tx', v=0 )\n\n# Make a clip.\n#\ncmds.clip( 'coneCharacter', startTime=15, endTime=25, name='down' )\n\n# Blend the clips, with a linear weighting function.\n#\nscheduler = cmds.character('coneCharacter', query=True, sc=True)\ncmds.clipSchedule( scheduler, b=(0, 1) )\nblendNode = cmds.clipSchedule( scheduler, q=True, bn=(0, 1))\ncmds.setKeyframe( blendNode[0], at='weight', t=0.0, v=0.0 )\ncmds.setKeyframe( blendNode[0], at='weight', t=1.0, v=1.0 )\n\n#    Bake out the two clips and the blend.\n#\ncmds.bakeClip( 'coneCharacter', ci=[0, 1], name='bakedUpAndDown' )",
 'bakeDeformer': "import maya.cmds as cmds\n\nimport maya.cmds as cmds\nimport maya.mel as mel\n\ndef createJointsAndMesh(offset = (0., 0., 0.)):\n    root = cmds.joint()\n    for _ in range(0,5):\n        cmds.joint()\n        cmds.move(0., 2., 0., r=True)\n\n    meshes = cmds.polyCube(sx=3,sy=10,sz=3,h=10)\n    cmds.move(0, 5, 0, r=True)\n    cmds.select([root, meshes[0]], r=True)\n    cmds.move(offset[0], offset[1], offset[2], r=True)\n    cmds.select(cl=True)\n    return (root, meshes[0])\n\ndef bindMesh(object):\n    rootJoint, mesh = object\n    cmds.select(rootJoint, r=True, hi=True)\n    cmds.select(mesh, add=True)\n    mel.eval('SmoothBindSkin')\n    cmds.select(cl=True)\n\ndef randomizeJoints(object):\n    from math import degrees\n    rootJoint = object[0]\n    cmds.select(rootJoint, r=True)\n    cmds.pickWalk(d='down')\n    for i in range(4):\n        rads = mel.eval('sphrand 1.')\n        cmds.rotate(degrees(rads[0]), degrees(rads[1]), degrees(rads[2]))\n        cmds.pickWalk(d='down')\n\ndef matchRotations(src, dst):\n    cmds.select(src[0], r=True, hi=True)\n    srcChain = cmds.ls(sl=True)\n\n    cmds.select(dst[0], r=True, hi=True)\n    dstChain = cmds.ls(sl=True)\n\n    for joints in zip(dstChain, srcChain):\n        cmds.select(list(joints), r=True)\n        mel.eval('MatchRotation')\n\n# Create a new scene\ncmds.file(f=True, new=True)\n\n# Create two joint chains/meshes\nobject1 = createJointsAndMesh()\nobject2 = createJointsAndMesh(offset=(5, 0, 0))\n\n# Bind one of the joint chains to the mesh and rotate the weights\nbindMesh(object1)\nrandomizeJoints(object1)\n\n# Use bakeDeformer to learn and apply the linear blend skinning weights.\ncmds.bakeDeformer(ss=object1[0], sm=object1[1], ds=object2[0], dm=object2[1], mi=3)\n\n# Match the rotations of the two chains to show the results are similar\nmatchRotations(object1, object2)",
 'bakePartialHistory': 'import maya.cmds as cmds\n\n# create a cylinder with history to use as an example\n#\ncyl = cmds.polyCylinder()\ncmds.polySmooth()\ncmds.cluster()\ncmds.select( cyl[0],r=True )\ncmds.polyTriangulate()\n\n# query what will be baked\n#\ncmds.bakePartialHistory( cyl[0],query=True,prePostDeformers=True )\n\n# perform the bake, baking history from before and after the\n# deformer\n#\ncmds.bakePartialHistory( cyl[0],prePostDeformers=True )\n\n# Bake the history before the geometry cache on the cylinder.\n# To actually demo, add a geometry cache before executing the command\n# below.\n#\ncmds.select( cyl[0],r=True )\ncmds.bakePartialHistory( cyl[0],preCache=True )',
 'bakeResults': "import maya.cmds as cmds\n\n# To replace the set of nodes controlling the animation of\n# surface1.translateX with a single animation animCurve, between the\n# time interval 5-44, with a sampling frequency of 2 timeUnits, use the\n# following command:\ncmds.bakeResults( 'surface1.translateX', t=(5,44), sb=2 )\n\n# This bakes the joints on a skeleton over the time interval 1-40.\ncmds.bakeResults( 'joint*', t=(1,40), simulation=True )",
 'bakeSimulation': 'import maya.cmds as cmds\n\n# Keys on animation curves are identified by either\n# their time values or their indices.  Times and indices can\n# be given as a range or list of ranges.\n\n# time=(\'10pal\',\'10pal\') means the key at frame 10 (PAL format).\n# time=[(\'1.0sec\',\'1.0sec\'),(\'15ntsc\',\'15ntsc\'),(20,20)] means the keys at time 1.0 second, frame 15 (in NTSC format), and time 20 (in the currently defined global time unit).\n# time=(10,20) means all keys in the range from 10 to 20, inclusive, in the current time unit.\n# Omitting one end of a range means "go to infinity", as in the following examples:\n# time=(10,None) means all keys from time 10 (in the current time unit) onwards.\n# time=(10,) means the same as (10,10)\n# time=(0,10) means all keys up to (and including) time 10 (in the current time unit).\n# time=(None,None) is a short form to specify all keys.\n# index=(0,0) means the first key of each animation curve. (Indices are 0-based.)\n# index=[(2,2),(5,5),(7,7)] means the 3rd, 6th, and 8th keys.\n# index=(1,5) means the 2nd, 3rd, 4th, 5th, and 6th keys of each animation curve.\n\n# To replace the animation driven by an ik handle of joints,\n# starting from joint1, with separate animCurves, within the\n# time interval 5-44, with a sampling frequency of 2 timeUnits,\n# use the following command:\n#\ncmds.bakeSimulation( \'joint1\', t=(5,44), sb=2, at=["rx","ry","rz"], hi="below" )',
 'baseTemplate': "import maya.cmds as cmds\n\n\n#    Determine if template exists\n#\ncmds.baseTemplate ('foo.xml', exists=True)\n#",
 'baseView': "import maya.cmds as cmds\n\n\n# Obtain a list of all available views for template1\n#\ncmds.baseView ( 'AEblinn', query=True, viewList=True);\n# Result: [u'Animation', u'Rendering'] #\n#",
 'batchRender': "import maya.cmds as cmds\n\ncmds.batchRender()\n\ncmds.batchRender( 'mayafile' )",
 'bevel': "import maya.cmds as cmds\n\n# Bevel (one) active curve with a width and depth of 1.5:\ncmds.bevel( w=1.5, d=1.5 )\n\n# Create a single-sided bevel (at start) surface using the specified\n# curve (with the default dimensions):\ncmds.bevel( 'curve1', ns=2 )",
 'bevelPlus': "import maya.cmds as cmds\n\ncmds.circle()\ncmds.scale( 10, 10, 10, r=True )\ncmds.circle()\ncmds.scale( 5, 5, 5, r=True )\ncmds.bevelPlus( 'nurbsCircle1', 'nurbsCircle2', po=1, cap=4, outerStyle=2, innerStyle=4 )",
 'bezierAnchorPreset': 'import maya.cmds as cmds\n\n# Applies the "Bezier" anchor preset to all selected anchors\ncmds.bezierAnchorPreset( p=0 )\n\n# Applies the "Bezier Corner" anchor preset to all selected anchors\ncmds.bezierAnchorPreset( p=1 )\n\n# Applies the "Corner" anchor preset to all selected anchors\ncmds.bezierAnchorPreset( p=2 )',
 'bezierAnchorState': 'import maya.cmds as cmds\n\n# Sets all selected anchors (or attached tangent handles) to smooth and uneven\ncmds.bezierAnchorState( sm=1, ev=0 )',
 'bezierCurveToNurbs': 'import maya.cmds as cmds\n\ncmds.bezierCurveToNurbs( )\n# Converts call selected Bezier curves to NURBS curves.',
 'bezierInfo': 'import maya.cmds as cmds\n\n# Queries the CV index of the anchor index 1\ncmds.bezierInfo( cfa=1 )\n\n# Queries the anchor index of a CV index 3\ncmds.bezierInfo( afc=3 );',
 'binMembership': 'import maya.cmds as cmds\n\n# Add a given node to a bin.\n#\ncmds.binMembership( \'lambert1\', addToBin=\'wood\' )\n\n# Add a selection of nodes to a given bin.\n#\nnewLambertNode = cmds.createNode(\'lambert\')\nlist = ("lambert1", newLambertNode)\ncmds.binMembership( list, addToBin=\'grass\' )\n\n# Check if a node exists in a bin.\n#\ncmds.binMembership( \'lambert1\', exists=\'wood\' )\n\n# Query and return all the nodes which belong to the bin.\n#\nnewLambertNode = cmds.createNode(\'lambert\')\nnodeList = ("lambert1", newLambertNode)\ncmds.binMembership( nodeList, query=True, listBins=True )\n\n# Make the nodes belong exclusively in bin "wood".\n#\nnewLambertNode = cmds.createNode(\'lambert\')\nnodeList = ("lambert1", newLambertNode)\ncmds.binMembership( nodeList, makeExclusive=\'wood\' )\n\n# Let the dest node inherit bins from nodes in the src node list.\n# The dest node is specified by the "inheritBinsFromNodes" flag\'s\n# argument.\n#\ncmds.binMembership( \'lambert1\', addToBin=\'wood\' )\nnode = cmds.createNode(\'lambert\')\ncmds.binMembership( node, addToBin=\'grass\' )\nsrcNodeList = ("lambert1", node)\ndestNode = cmds.createNode(\'blinn\')\ncmds.binMembership( srcNodeList, inheritBinsFromNodes=destNode )\n\n# Notify that binMembership has been changed.\n#\ncmds.binMembership( notifyChanged=True )\n\n# Check if a bin name is valid or not.  If valid, return true.\n# Otherwise, return false.\n#\ncmds.binMembership( isValidBinName=\'wood\' )',
 'bindSkin': "import maya.cmds as cmds\n\n# Create a joint chain and a polygonal plane.\ncmds.select(d=True)\ncmds.joint(p=(-3.0, 0.0,-12.0))\ncmds.joint(p=(-3.0, 0.0, -5.0))\ncmds.joint(p=(1.0, 0.0, 5.5))\ncmds.joint(p=(6.0, 0.0, 10.0))\ncmds.polyPlane(w=20.0,h=20.0,sx=25,sy=25)\n\ncmds.select('joint1',add=True)\n\n# to bind the selected objects to the selected skeleton\n#\ncmds.bindSkin()\n\n# to bind nurbsSphere1 and pPlane1 to the skeleton containing joint2\n#\ncmds.bindSkin( 'nurbsSphere1', 'joint2', 'pPlane1' )\n\n# to bind the selected partition to the selected skeleton\n#\ncmds.bindSkin( bp=True )\n\n# to bind the selected objects to the selected bones only,\n# not the entire skeleton\n#\ncmds.bindSkin( tsb=True )\n\n# to detach the selected objects and delete any unused\n# bindSkin history\n#\ncmds.bindSkin( unbind=True )\n\n# to detach pPlane1 and delete any unused\n# bindSkin history\n#\ncmds.bindSkin( 'pPlane1', unbind=True )\n\n# to detach the selected objects and keep the history\n#\ncmds.bindSkin( unbindKeepHistory=True )\n\n# To disable the skin on the selected skeletons. This gives\n# the effect of detaching the skin without removing the\n# bindSkin groups on the object. You can then modify the joint\n# positioning, and enable the binding, keeping your original\n# groups.\n#\ncmds.bindSkin( enable=False )\n\n# to enable skin on a skeleton which has been disabled\n#\ncmds.bindSkin( enable=True )",
 'blend': '',
 'blend2': 'import maya.cmds as cmds\n\n# Do blend with auto normal and with no history:\ncmds.blend2( an=True, ch=False )\n\n# Do blend without auto normal\ncmds.blend2( an=False, fln=True, frn=True )',
 'blendCtx': '',
 'blendShape': "import maya.cmds as cmds\n\n#\n# Perform a blendShape using the currently-selected objects.\n# The lead (last-selected) object will be the base shape, and each\n# of the others become targets.\n#\ncmds.blendShape()\n\n#\n# Create a blendShape that starts with curve3 as the base, and blends\n# in curve1 and curve2 as targets.\n\ncmds.blendShape( 'curve1', 'curve2', 'curve3' )\n\n#\n# Apply 80% of the total blendShape deformation, by setting\n# the envelope parameter to 0.8\ncmds.blendShape( 'blendShape1', edit=True, en=0.8 )\n\n\n#\n# Set the weights for the first two target shapes to 0.6\n# and 0.1 respecxtively\ncmds.blendShape( 'blendShape1', edit=True, w=[(0, 0.6), (1, 0.1)] )\n\n#\n# Add a third target (target3) to the blendShape on curve3\ncmds.blendShape( 'blendShape1', edit=True, t=('curve3', 1, 'target3', 1.0) )\n\n#\n# Add an inbetween (smirk) on target3 for base shape curve3\n# The inbetween will take effect at a weight of 0.2\ncmds.blendShape( 'blendShape2', edit=True, ib=True, t=('curve3', 2, 'smirk', 0.2) )",
 'blendShapeEditor': "import maya.cmds as cmds\n\ncmds.blendShapeEditor( 'libEd' )",
 'blendShapePanel': "import maya.cmds as cmds\n\ncmds.blendShapePanel( 'bsP' )",
 'blendTwoAttr': 'import maya.cmds as cmds\n\n# Assume we have animated a bouncing sphere, sphere1, and we would like\n# the sphere to smoothly transition into following a second sphere\'s,\n# sphere2, animation between time 15 and 20.\n#\ncmds.select( \'sphere1\' )\ncmds.blendTwoAttr( at=\'tx\', at1=\'sphere2.tx\', t=(15,20) )\ncmds.blendTwoAttr( at=\'ty\', at1=\'sphere2.ty\', t=(15,20) )\ncmds.blendTwoAttr( at=\'tz\', at1=\'sphere2.tz\', t=(15,20) )\n\n# You can use the "-at" flag to narrow the query. For example, if\n# you wanted to know the names of the newly created blender curves\n# for only the tx and tz attributes of sphere1, you could say:\n#\ncmds.blendTwoAttr( at=[\'tx\',\'tz\'], query=True, blender=True )\n\n# You can now keyframe the sphere2\'s animation by changing the\n# driver on sphere1.\n#\ncmds.blendTwoAttr( at=\'tx\', edit=True, driver=1 )\n# setKeyframe ...\n\n# If you already had two objects, sphere1 and sphere2 animated, and\n# you wanted to blend between their animation abruptly at time 15,\n# you could do:\n#\ncmds.blendTwoAttr( \'newObject.tx\', t=(15,15), at0=\'sphere1.tx\', at1=\'sphere2.tx\' )',
 'blindDataType': "import maya.cmds as cmds\n\n# To create a new blind data typeId with a floating point attribute\ncmds.blindDataType( id=9001, dt='float', longDataName='bdFloat', shortDataName='bdf' )\n\n# To create a Blind Data type with several attributes\ncmds.blindDataType( 'ruf', '-dt', 'float', '-longDataName', 'smoothness', '-shortDataName', 'smo', '-dt', 'int' id=9005, dt='float', longDataName='roughness', shortDataName='', longDataName='count', shortDataName='cnt' )\n\n# To query if a type is already used\ncmds.blindDataType( 9001\n# to query the type of a single attribute\n 'blindDataType', '-q', '-id', 9001, '-tn', '-ldn', 'smoothness', query=True, id=True )\n\n# to get the types and names for all attributes\ncmds.blindDataType( 9001, '-tn', query=True, id=True )",
 'boneLattice': "import maya.cmds as cmds\n\n# select a lattice that has been added to a rigid skin shape\n#\ncmds.boneLattice( joint='joint2' )\ncmds.boneLattice( transform='joint1', joint='joint2' )\ncmds.boneLattice( 'boneLattice1', edit=True, bicep=0.5 )",
 'boundary': 'import maya.cmds as cmds\n\n# Creating boundary surfaces with three curves:\n\ncrv1 = cmds.curve(d= 3, p= ((8, 0, 3), (5, 0, 3), (2, 0, 2), (0, 0, 0)) )\ncrv2 = cmds.curve(d= 3, p= ((8, 0, -4), (5, 0, -3), (2, 0, -2), (0, 0, 0)) )\ncrv3 = cmds.curve(d= 3, p= ((10, 0, 3), (9, 3, 2), (11, 3, 1), (9, 0, -3)) )\n\n# These curves form a rough triangle shape pointing at the origin.\n# If order is OFF, then the apex of the surface will always between\n# the 1st and 2nd curves.\n\ncmds.boundary( crv3, crv1, crv2, order=False, ep=0 )\ncmds.boundary( crv3, crv2, crv1, order=False, ep=0 )\n\n# If order is ON, then think of the order of selection as "rail, rail, profile"\n# where the boundary is formed by sweeping the profile along two rails.\n# Direction of the curves becomes important as well; use the reverseCurve\n# command if you want to change a curve\'s direction.\ncmds.boundary( crv1, crv2, crv3, order=True )\n\n\n# Creating boundary surfaces with four curves:\n\ncrv1 = cmds.curve(d= 3, p=((-2, 0, 5), (-1, 0, 3), (1, 0, 3), (3, 0, 4), (6, 0, 5)) )\ncrv2 = cmds.curve(d= 3, p=(( 7, 0, 4), (8, 0, 2), (8, 0, -3), (7, 0, -4)) )\ncrv3 = cmds.curve(d= 3, p=(( 6, 0, -5), (2, 0, -3), (1, 0, -5), (-3, 0, -5)) )\ncrv4 = cmds.curve(d= 3, p=((-2, 0, 4), (-4, 0, 1), (-4, 0, -3), (-2, 0, -4)) )\n\n# These curves form a rough square shape around the origin.\n# To make a boundary surface from four curves, two of the curves are\n# "rails" while the other two are "profiles".\n\ncmds.boundary( crv1, crv2, crv3, crv4, order=False, ep=0 )\ncmds.boundary( crv2, crv3, crv4, crv1, order=False, ep=0 )\n\n# profile, rail, profile, rail\n# Notice that in both cases, the resulting boundary surface passes through\n# the rail curves.\n\n# When order is ON, direction of the curves becomes important;\n# use the reverseCurve command if you want to change a curve\'s direction.\n# Notice the difference between:\n\ncmds.boundary( crv1, crv2, crv3, crv4, order=False, ep=0 )\ncmds.boundary( crv1, crv2, crv3, crv4, order=True, ep=0 )',
 'boxDollyCtx': "import maya.cmds as cmds\n\ncmds.boxDollyCtx( 'boxDollyContext', ac=False )",
 'boxZoomCtx': "import maya.cmds as cmds\n\ncmds.boxZoomCtx( 'boxZoomContext', zs=1.0 )",
 'bufferCurve': 'import maya.cmds as cmds\n\n# Keys on animation curves are identified by either\n# their time values or their indices.  Times and indices can\n# be given as a range or list of ranges.\n\n# time=(\'10pal\',\'10pal\') means the key at frame 10 (PAL format).\n# time=[(\'1.0sec\',\'1.0sec\'),(\'15ntsc\',\'15ntsc\'),(20,20)] means the keys at time 1.0 second, frame 15 (in NTSC format), and time 20 (in the currently defined global time unit).\n# time=(10,20) means all keys in the range from 10 to 20, inclusive, in the current time unit.\n# Omitting one end of a range means "go to infinity", as in the following examples:\n# time=(10,None) means all keys from time 10 (in the current time unit) onwards.\n# time=(10,) means the same as (10,10)\n# time=(0,10) means all keys up to (and including) time 10 (in the current time unit).\n# time=(None,None) is a short form to specify all keys.\n# index=(0,0) means the first key of each animation curve. (Indices are 0-based.)\n# index=[(2,2),(5,5),(7,7)] means the 3rd, 6th, and 8th keys.\n# index=(1,5) means the 2nd, 3rd, 4th, 5th, and 6th keys of each animation curve.\n\n# Create a buffer curve for the selected keys\ncmds.bufferCurve( animation=\'keys\', overwrite=True )\n\n# Set the referenced anim curve to the buffer curve\ncmds.bufferCurve( useReferencedCurve=True)\n\n# Swap the buffer curve for the selected keys\ncmds.bufferCurve( animation=\'keys\', swap=True )',
 'buildBookmarkMenu': "import maya.cmds as cmds\n\n# Update the bookmarkMenu to show animation (bookmarkAnimCurves)\n# bookmarks\n#\ncmds.menu( 'bookmarkMenu' )\ncmds.buildBookmarkMenu( 'bookmarkMenu', type='bookmarkAnimCurves' )",
 'buildKeyframeMenu': 'import maya.cmds as cmds\n\n# Set up "myAttributeMenu" as a menu to always\n# reflect what\'s currently keyframable.\n#\ncmds.buildKeyframeMenu( \'myAttributeMenu\' )',
 'button': "import maya.cmds as cmds\n\ndef defaultButtonPush(*args):\n  print 'Button 1 was pushed.'\n\ncmds.window( width=150 )\ncmds.columnLayout( adjustableColumn=True )\ncmds.button( label='Button 1', command=defaultButtonPush )\ncmds.button( label='Button 2' )\ncmds.button( label='Button 3' )\ncmds.button( label='Button 4' )\ncmds.showWindow()",
 'buttonManip': 'import maya.cmds as cmds\n\n#    Example 1.\n#\n#    Create a button manipulator that will be parented to a sphere and will\n#    print "Button Manipulator" whenever it is pressed.\n#\n#    Note that moving the sphere will also move the manipulator.\n#\nsphere = cmds.sphere()\ncmds.buttonManip( \'print "Button Manipulator"\', sphere[0])\n\n#    Example 2.\n#\n#    Create a button manipulator that will execute the \'setKeyframe\' command\n#    when it is pressed.\n#\ncmds.buttonManip( \'setKeyframe\' )',
 'cacheFile': 'import maya.cmds as cmds\n\n# Create a disk cache containing the points of a plane from\n# frames 1 - 100. Typically the shape would be deforming.\n#\ncmds.polyPlane()\ncacheFiles = cmds.cacheFile(f=\'shapeCache\', st=1, et=100, points=\'pPlaneShape1\')\n\n# Add a historySwitch node to the history of the shape, and attach the\n# newly created cache into the historySwitch node.\n#\nswitch = maya.mel.eval(\'createHistorySwitch("pPlaneShape1",false)\')\ncacheNode = cmds.cacheFile(f=cacheFiles[0], cnm=\'pPlaneShape1\', ia=\'%s.inp[0]\' % switch ,attachFile=True)\ncmds.setAttr( \'%s.playFromCache\' % switch, 1 )\n\n# query the files associated with a cacheFile node\n#\ncmds.cacheFile( cacheNode, query=True, f=True )\n\n# Now use the staticCache flag to indicate that the cache should not be\n# created if the object appears to have no animation.\n# Since the plane is not animated or deformed, no cache will be created.\n#\ncmds.polyPlane()\ncacheFiles = cmds.cacheFile(f=\'shapeCache\', staticCache=0, st=1, et=100, points=\'pPlaneShape2\')\n\n# Convert a maya cache into pc2 format. The maya cache is named\n# pSphereShape1.xml and located in the directory "c:/test/".\n#\ncmds.cacheFile(pc2=0,pcf=\'c:/test/mypc2.pc2\',f=\'pSphereShape1\',dir=\'c:/test/\')\n\n# Convert a pc2 cache into a maya cache, with the cache data in a single\n# file.\n#\ncmds.cacheFile(pc2=1,pcf=\'c:/test/mypc2.pc2\',f=\'mayaCache2\',dir=\'c:/test/\',format=\'OneFile\')',
 'cacheFileCombine': "import maya.cmds as cmds\n\n# Create a cacheBlend node so that additional caches can be added to\n# the shape. This will attach the existing cacheFile on the shape\n# to the new cacheBlend node.\n#\ncmds.select( 'cachedShape', r=True )\nnewBlend = cmds.cacheFileCombine()\n\n# attach an additional cacheFile to the cacheBlend node\n#\ncmds.cacheFileCombine( newBlend[0], e=True, cc='cacheFile2' )\n\n# query the index of the newly connected cache\n#\ncmds.cacheFileCombine( newBlend[0], cc='cacheFile2', query=True, cacheIndex=True )\n\n# When more than one object is driven by the caches connected\n# to the cacheBlend node, the -channelName and -objectIndex flags can be\n# used to control which is connected.\n#\n# Query the objectIndex for the armShape geometry driven by cacheBlend3:\n#\nindex = cmds.cacheFileCombine('cacheBlend3' ,object='armShape', query=True, objectIndex=True)\n\n# Connect another cache up to drive the armShape\n#\ncmds.cacheFileCombine( 'cacheBlend3', channelName='myChannel', objectIndex=index, e=True, cc='cacheFile2' )",
 'cacheFileMerge': 'import maya.cmds as cmds\n\n# Find associated geometry nodes\n#\ngeom = cmds.cacheFileMerge(\'cache1\', \'cache2\' ,query=True, geometry=True)\n\n# Validate merging of caches and find out start/end times.\n# This will give a warning if there is a gap letting you know that\n# simulation data will fill the gap.\n#\nstartEndTimes = cmds.cacheFileMerge(\'cache1\', \'cache2\')\n# Result: { 0, 20, 5, 10 }\n\nstart = startEndTimes[0]\nend = startEndTimes[1]\ngapStart = startEndTimes[2]\ngapEnd = startEndTimes[3]\n\n# Create a new merged cache, using simulation data to fill in\n# any gaps between cache1 and cache2.\n#\ncacheFiles = cmds.cacheFile(fileName=\'mergedCache\', startTime=start, endTime=end, points=geom[0])\nswitch = maya.mel.eval(\'createHistorySwitch("pPlaneShape1", false)\');\ncmds.cacheFile( attachFile=True, f=cacheFiles[0], ia=\'%s.inp[0]\' % switch)\ncmds.setAttr( \'%s.playFromCache\' % switch, 1 )\n\n# Alternatively, can use append to make sure that we interpolate\n# for the frames in the gap between cache1 and cache2.\n#\ncacheFiles = cmds.cacheFile(fileName=\'mergedCache\', startTime=start, endTime=gapStart, points=geom[0])\nswitch = maya.mel.eval(\'createHistorySwitch("pPlane1", false)\');\ncmds.cacheFile( attachFile=True, f=cacheFiles[0], ia=\'%s.inp[0]\' % switch)\ncmds.setAttr( \'%s.playFromCache\' % switch, 1 )\ncmds.cacheFile( replaceCachedFrame=True, startTime=gapEnd, endTime=end, points=geom[0] )',
 'cacheFileTrack': 'import maya.cmds as cmds\n\n# Move the cache clip named "cubeCache2" to track 3\n#\ncmds.cacheFileTrack( \'cubeCache2\', track=3 )\n\n# Lock the track containing the cache clip named "sphCache1"\n#\ncmds.cacheFileTrack( \'sphCache1\', lock=True )\n\n# Remove any empty cache tracks for the object "sphereShape1"\n#\ncmds.cacheFileTrack(\'sphereShape1\',removeEmptyTracks=True)\n\n# query the track index of the cache clip named "sphCache1"\n#\ncmds.cacheFileTrack( \'sphCache1\', q=True, track=True )',
 'caddyManip': '',
 'callbacks': "import maya.cmds as cmds\n\ndef myCallbackFunction(arg1, arg2):\n\t\treturn arg1 + arg2\n\n# add a new callback for myPlugin to be called when creating the attribute editor UI\ncmds.callbacks(addCallback=myCallbackFunction, hook='desiredHook', owner='myPlugin')\n# remove an individual callback\ncmds.callbacks(removeCallback=myCallbackFunction, hook='desiredHook', owner='myPlugin')\n# remove all callbacks for myPlugin for a specified hook\ncmds.callbacks(clearCallbacks=True, hook='desiredHook', owner='myPlugin')\n# remove all callbacks for myPlugin for all hooks\ncmds.callbacks(clearCallbacks=True, owner='myPlugin')\n# list callbacks for a specified hook\ncallbacks = cmds.callbacks(listCallbacks=True, hook='desiredHook')\n# list callbacks for a specified hook and for a specified owner\ncallbacks = cmds.callbacks(listCallbacks=True, hook='desiredHook', owner='myPlugin')\n# get a list of the standard Maya hooks\ncmds.callbacks(describeHooks=True)\n# execute the callbacks for the hook 'desiredHook'\nresults = cmds.callbacks('arg1', 'arg2', executeCallbacks=True, hook='desiredHook')",
 'camera': "import maya.cmds as cmds\n\n# Create a camera and get the shape name.\ncameraName = cmds.camera()\ncameraShape = cameraName[1]\n\n# Get the focal length of the camera.\nfocalLength = cmds.camera(cameraShape, q=True, fl=True)\n\n# Change the film fit type.\ncmds.camera( cameraShape, e=True, ff='overscan' )",
 'cameraSet': 'import maya.cmds as cmds\n\n# create some objects\ncmds.sphere(n=\'sphere1\')\ncmds.cone(n=\'cone1\')\n\n# create a set with whatever is currently active\ncmds.select( \'sphere1\', \'cone1\')\nnewSet2 = cmds.sets()\n\ncmds.loadPlugin( "stereoCamera", qt=True )\nfrom maya.app.stereo import stereoCameraRig\nrig = stereoCameraRig.createStereoCameraRig(\'StereoCamera\')\n\n# Create a new cameraSet node.\ncmds.cameraSet()\n\n# Add the cam & object set to the set\ncmds.cameraSet( \'cameraSet1\', edit=True, appendTo=True, cam=rig[0], objectSet=newSet2 )',
 'cameraView': "import maya.cmds as cmds\n\n# Save the current position of the persp camera.\nhomeName = cmds.cameraView(camera='persp')\n\n# Add this view to the persp bookmark menu.\ncmds.cameraView( homeName, e=True, camera='persp', ab=True )\n\n# Change the persp camera position.\ncmds.dolly( 'persp', distance=-30 )\n\n# Create another bookmark for the zoomed position.\ncmds.cameraView( camera='persp', name='zoom', ab=True )\n\n# Restore original camera position.\ncmds.cameraView( homeName, e=True, camera='persp', sc=True )\n\n# Save the current 2D pan/zoom attributes of the persp camera\npanZoomBookmark = cmds.cameraView( camera='persp', ab=True, typ=1 )\n\n# Enable 2D pan/zoom\ncmds.setAttr( 'perspShape.panZoomEnabled', True )\n\n# Pan right\ncmds.panZoom( 'persp', r=0.6 )\n\n# Restore original film position\ncmds.cameraView( panZoomBookmark, e=True, camera='persp', sc=True )",
 'canCreateCaddyManip': "import maya.cmds as cmds\n\ncanWeCreateIt = cmds.canCreateCaddyManip('node')",
 'canCreateManip': "import maya.cmds as cmds\n\ncanWeCreateIt = cmds.canCreateManip('node')",
 'canvas': 'import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout( rowSpacing=5 )\ncmds.canvas( rgbValue=(0, 0, 1), width=100, height=20 )\ncmds.canvas( hsvValue=(60, 1, 1), width=100, height=20 )\ncmds.canvas( rgbValue=(1, 0, 1), width=100, height=20 )\ncmds.showWindow()',
 'changeSubdivComponentDisplayLevel': 'import maya.cmds as cmds\n\n# change the selected subdivision surface to display level 4 components\ncmds.changeSubdivComponentDisplayLevel( l=4 )\n\n# increase the display level of the selected subivision surface by 1\ncmds.changeSubdivComponentDisplayLevel( l=1, r=True )',
 'changeSubdivRegion': 'import maya.cmds as cmds\n\n# delete the selection region on the base mesh\ncmds.changeSubdivRegion( a=1, l=0 )\n\n# expand the selection region at the current level\ncmds.changeSubdivRegion( a=2 )',
 'channelBox': 'import maya.cmds as cmds\n\ncmds.window()\ncmds.formLayout( \'form\' )\ncmds.channelBox( \'dave\' )\ncmds.formLayout( \'form\', e=True, af=((\'dave\', \'top\', 0), (\'dave\', \'left\', 0), (\'dave\', \'right\', 0), (\'dave\', \'bottom\', 0)) )\ncmds.showWindow()\n\n// Color all attributes names, which have an attribute name\n// beginning with "T", white for all current and future objects\n// in the current Maya session\n\ncmds.channelBox( \'cb1\', attrRegex=\'T*\', attrColor=(1.0, 1.0, 1.0), attrBgColor=(0.0, 0.0, 0.0) )\ncmds.channelBox( \'cb1\', e=True, nodeRegex=\'D*\', attrRegex=\'A*\', attrColor=(0, 0, 0) )',
 'character': "import maya.cmds as cmds\n\n# create two characters with whatever is currently active\ncmds.character()\ncmds.character()\n\n# create a set which contains two sub characters\ncmds.character( 'character1', 'character2', n='parentCharacter' )\n\n# Add the keyable attributes of ikHandle1 to a character\ncmds.character( 'ikHandle1', add='character1' )\n\n# Remove the scale attributes for a transform from a character\ncmds.character( 'sphere1.sx', 'sphere1.sy', 'sphere1.sz', remove='character1' )\n\n# Query the members of the character\nmembers = cmds.character('character1', query=True)\n\n# Query the character plug for a specified member\ncmds.character( members[0], q=True, cp=True )\n\n# Query the library and scheduler of the character\ncmds.character( 'character1', q=True, library=True )\ncmds.character( 'character2', q=True, sc=True )\n\n# Add the sphere as an offset object on the character\ncmds.character( 'pSphere1', e=True, addOffsetObject = 'character1' )",
 'characterMap': "import maya.cmds as cmds\n\n# Create a mapping between character1 and character2, or if a map already\n# exists, update the mapping between any unmapped members.\n#\ncmds.characterMap( 'character1', 'character2' )\n\n# Query as to whether a mapping exists between two characters\n#\ncmds.characterMap( 'character1', 'character2', query=True )\n\n# Query which attributes are mapped between two characters\n#\ncmds.characterMap( 'character1', 'character2', query=True, mapAttr=True )\n\n# Delete the mapping between two pairs of attributes. If no mapping\n# exists between the attributes, nothing will happen.\n#\ncmds.characterMap( 'character1', 'character2', unmapAttr=('sphere1.tx','sphere2.tx') )\n\n# Add a mapping between two attributes.  Only attributes that\n# are members of characters can be mapped.\n#\ncmds.characterMap( 'character1', 'character2', mapAttr=('sphere1.tx','sphere2.tx') )\n\n# Query what attribute(s) are mapped to sphere1.tx between character1 and\n# character2\n#\ncmds.characterMap( 'character1', 'character2', mapping='sphere1.tx' )",
 'characterize': "import maya.cmds as cmds\n\n# Characterize a skeleton.  Select the root of the skeleton and enter\n# the following. The skeleton joints must be named according to the\n# FBIK naming conventions described in the main Maya documentation.\n#\ncmds.characterize( pinHandFeet=True )\n\n# Characterize a skeleton that has not been named according to the\n# FBIK naming conventions by using the -sk flag to define the\n# purpose of the joints. Select the skeleton and enter the following.\n#\ncmds.characterize( sk = 'pelvis Hips,hipL LeftUpLeg,kneeL LeftLeg,footL LeftFoot,toeL LeftToeBase,hipR RightUpLeg,kneeR RightLeg,footR RightFoot,toeR RightToeBase,spine Spine,spine1 Spine1,collarL LeftShoulder,shoulderL LeftArm,elbowL LeftForeArm,handL LeftHand,collarR RightShoulder,shoulderR RightArm,elbowR RightForeArm,handR RightHand,neck Neck,head Head,spine2 Spine2' )\n\n# Add a floor contact plane to the selected effector\n#\ncmds.select('LeftFootEff', r=True)\ncmds.characterize( e=True, addFloorContactPlane=True )\n\n# Add a full body pivot to the selected effector.\n#\ncmds.select('LeftHandEff', r=True)\ncmds.characterize( e=True, placeNewPivot=True )\ncmds.move( 1, 1, 0, r=True)\n\n# Activate a new pivot now that it has been placed in the desired location.\n#\ncmds.characterize( e=True, activatePivot=True )\n\n# De-activate a pivot so that it can be moved to another location.\n#\ncmds.characterize( e=True, changePivotPlacement=True )",
 'checkBox': "import maya.cmds as cmds\n\nwindow = cmds.window('window', width=150)\ncmds.columnLayout( adjustableColumn=True )\ncmds.checkBox( label='One' )\ncmds.checkBox( label='Two' )\ncmds.checkBox( label='Three' )\ncmds.checkBox( label='Four' )\ncmds.showWindow( window )",
 'checkBoxGrp': "import maya.cmds as cmds\n\nexampleWindow = cmds.window()\ncmds.columnLayout()\ncmds.checkBoxGrp( numberOfCheckBoxes=3, label='Three Buttons', labelArray3=['One', 'Two', 'Three'] )\ncmds.checkBoxGrp( numberOfCheckBoxes=4, label='Four Buttons', labelArray4=['I', 'II', 'III', 'IV'] )\ncmds.showWindow( exampleWindow )\n\n# Place a single checkbox with a label width of 100 pixels, and a checkbox\n# width of 165 pixels.  In this example, the two columns of the checkBoxGrp\n# controlled by the columnWidth2 flag are the label column and the checkbox\n# column.  Horizontal positioning of the checkbox can be controlled by\n# adjusting the width of the first column.\nexampleWindow = cmds.window()\ncmds.rowLayout()\ncmds.checkBoxGrp(columnWidth2=[100, 165], numberOfCheckBoxes=1, label='A Label', label1='A Checkbox', v1=True)\ncmds.showWindow(exampleWindow)",
 'checkDefaultRenderGlobals': "import maya.cmds as cmds\n\n# cmds.checkDefaultRenderGlobals(q=1) can be replaced with a call to the ls command\n# To check if the defaultRenderGlobals node is marked dirty or not, do this:\nif( 'defaultRenderGlobals' in cmds.ls(modified=1) ):\n\t# do something...\n\tpass\n\n# To mark the entire scene dirty.\ncmds.file( modified=1 )\n\n# To mark the entire scene clean\ncmds.file( modified=0 )",
 'choice': 'import maya.cmds as cmds\n\n# This example animates an object airplane along a motion path\n# from frames 1 to 30, then continues with keyframe animation until\n# frame 50, then returns to the motion path at frame 50.\npath = cmds.curve(d=3,p=[(-10, 0, 0),(-6, 0, 10),(-3, 0, -10),(10, 0, 0)],k=[0, 0, 0, 1, 1, 1])\ncmds.polyPlane()\ncmds.pathAnimation(\'pPlane1\',c=path,stu=1,etu=100)\n\n# Set a choice node on the path animation, ensuring that the choice\n# selects path animation from 1 to 30, and then returns at 50.\ncmds.choice( \'pPlane1\', at=\'ty\', t=[1,30,50] )\n\n# Start a new kind of choice at time 31\ncmds.choice( \'pPlane1\', at=\'ty\', t=31 )\n\n# Create some keyframe animation between times 31 and 49\ncmds.currentTime( 31 )\ncmds.setKeyframe( \'pPlane1\', at="ty" )\ncmds.move( 1, 2, 3, r=True )\ncmds.setKeyframe( \'pPlane1\', at="ty", t=40 )\ncmds.move( 4, 5, 6, r=True )\ncmds.setKeyframe( \'pPlane1\', at="ty", t=49 )\n\n# Note that the -at/attribute and -t/time flags are not\n# queryable in themselves, but they can be used to\n# modify the choice nodes to query.\n\n# What is the attribute that is connected to the pPlane1.ty choice node\'s\n# selector attribute?\ncmds.choice( \'pPlane1\', at=\'ty\', query=True, sl=True)\n\n# Which indices will be evaluated for the choice node to pPlane1.ty\n# at the given times?\ncmds.choice( \'pPlane1\', at=\'ty\', t=[1,30,50], query=True, index=True)',
 'circle': 'import maya.cmds as cmds\n\n# create full circle at origin on the x-y plane\ncmds.circle( nr=(0, 0, 1), c=(0, 0, 0) )\n\n# create half circle at origin on the x-y plane with radius 2\ncmds.circle( nr=(0, 0, 1), c=(0, 0, 0), sw=180, r=2 )',
 'circularFillet': "import maya.cmds as cmds\n\ncmds.circularFillet( 'surface1', 'surface2', ch=True, pr=-1.0, sr=1.0, cos=False )\ncmds.circularFillet( 'surface3', 'surface4', ch=False, pr=-1.0, sr=2.0, cos=True, pt=0.001 )",
 'clearCache': "import maya.cmds as cmds\n\n\n# Clear one node's datablock cache\ncmds.clearCache( 'node' )\n\n# Clear caches in all dependency graph nodes\ncmds.clearCache( all=True )",
 'clearShear': '',
 'clip': 'import maya.cmds as cmds\n\n# First, create a character to hold the clips. The character will be\n# a 3-bone skeleton named "arm".\n#\ncmds.select( d=True )\ncmds.joint( p=(0, 0, 0) )\ncmds.joint( p=(0, 4, 0)  )\ncmds.joint( \'joint1\', e=True, zso=True, oj=\'xyz\' )\ncmds.joint( p=(0, 8, -1) )\ncmds.joint( \'joint2\', e=True, zso=True, oj=\'xyz\' )\ncmds.joint( p=(0, 9, -2) )\ncmds.joint( \'joint3\', e=True, zso=True, oj=\'xyz\' )\ncmds.select( \'joint1\', \'joint2\', \'joint3\', r=True )\ncmds.character( name=\'arm\' )\n\n# Create some animation for the character. For this example the animation will\n# be quite trivial.\n#\ncmds.select( \'joint3\', r=True )\ncmds.currentTime( 0 )\ncmds.setKeyframe( \'joint3.rx\' )\ncmds.currentTime( 10 )\ncmds.setKeyframe( \'joint3.rx\', v=90 )\ncmds.currentTime( 20 )\ncmds.setKeyframe( \'joint3.rx\', v=0 )\n\n# Create a clip for the current animation named "handWave"\n#\ncmds.clip( \'arm\', startTime=0, endTime=20, name=\'handWave\' )\n\n# Create a 2nd animation for the character.\n#\ncmds.select( \'joint2\', r=True )\ncmds.currentTime( 0 )\ncmds.setKeyframe( \'joint2.rx\' )\ncmds.setKeyframe( \'joint2.ry\', v=20 )\ncmds.currentTime( 10 )\ncmds.setKeyframe( \'joint2.rx\', v=45 )\ncmds.setKeyframe( \'joint2.ry\', v=-20 )\ncmds.currentTime( 20 )\ncmds.setKeyframe( \'joint2.rx\', v=0 )\ncmds.setKeyframe( \'joint2.ry\', v=20 )\n\n# Create a clip for the current animation named "elbowWave"\n#\ncmds.clip( \'arm\', startTime=0, endTime=20, name=\'elbowWave\' )\n\n# Query the existing source clips\n#\ncmds.clip( \'arm\', query=True, n=True )\n# Result:[u\'handWaveSource\', u\'elbowWaveSource\'] #\n\n# Query the active clip. Note that the default clip is always active unless\n# another clip has been specified as active. This means that new keyframes\n# always go into the default clip unless you make another clip active.\n#\ncmds.clip( \'arm\', query=True, active=True )\n# Result: default #\n\n# Duplicate the clip named "elbowWaveSource" on the character named "arm" and\n# place the duplicate in the schedule at a start time of 50\n#\ncmds.clip( \'arm\', duplicate=True, name=\'elbowWaveSource\', s=50 )\n\n# Duplicate the clip named "wiggle" on the character named "arm" and\n# do not place the duplicate in the schedule\n#\ncmds.clip( \'arm\', duplicate=True, sc=False, name=\'wiggle\' )\n\n# Remove the clip from the character altogether. All instances of the clip will be\n# removed from the schedule and deleted from the library.\n#\ncmds.clip( \'arm\', rm=True, name=\'elbowWaveSource\')\n\n# Make the handWave clip active. This means that any new keyframes get\n# placed in the handWave clip, and modifications to existing handWave\n# keyframes can be made.\n#\ncmds.clip( \'arm\', edit=True, active=\'handWave\' )\n\n# Split the clip named "handWave" into two clips at time 10\n#\ncmds.clip( \'arm\', split=10, name=\'handWave\' )\n\n# Query the startTime of a clip. This is the start frame of the animation\n# curve range of the clip, and may differ from the scheduled time of the clip,\n# which is accessed using the clipSchedule command.\n#\ncmds.clip( \'arm\', name=\'handWave\', query=True, s=True )',
 'clipEditor': 'import maya.cmds as cmds\n\ncmds.clipEditor( "clipEditorName" )',
 'clipEditorCurrentTimeCtx': 'import maya.cmds as cmds\n\ncmds.clipEditorCurrentTimeCtx()',
 'clipMatching': 'import maya.cmds as cmds\n\n\n# Compute and set the offset on the "walk" clip in order to have it\'s start\n# pose align to the end of the "tornadoKick" clip at the LeftAnkle match\n# element.  Note that here we are matching the translation by specifying\n# with mt = 1.\n#\ncmds.select( \'character\', \'LeftAnkle\' )\ncmds.clipMatching( mt=1, cs=("walk",0.0), cd=("tornadoKick",1.0) )',
 'clipSchedule': 'import maya.cmds as cmds\n\n# First, create a character to hold the clips. The character will be\n# a 3-bone skeleton named "arm".\n#\ncmds.select( d=True )\ncmds.joint( p=(0, 0, 0) )\ncmds.joint( p=(0, 4, 0)  )\ncmds.joint( \'joint1\', e=True, zso=True, oj=\'xyz\' )\ncmds.joint( p=(0, 8, -1) )\ncmds.joint( \'joint2\', e=True, zso=True, oj=\'xyz\' )\ncmds.joint( p=(0, 9, -2) )\ncmds.joint( \'joint3\', e=True, zso=True, oj=\'xyz\' )\ncmds.select( \'joint1\', \'joint2\', \'joint3\', r=True )\ncmds.character( name=\'arm\' )\n\n# Create some animation for the character. For this example the animation will\n# be quite trivial.\n#\ncmds.select( \'joint3\', r=True )\ncmds.currentTime( 0 )\ncmds.setKeyframe( \'joint3.rx\' )\ncmds.currentTime( 10 )\ncmds.setKeyframe( \'joint3.rx\', v=90 )\ncmds.currentTime( 20 )\ncmds.setKeyframe( \'joint3.rx\', v=0 )\n\n# Create a clip for the current animation named "handWave"\n#\ncmds.clip( \'arm\', startTime=0, endTime=20, name=\'handWave\' )\n\n# Query the name of the clipScheduler for this character\n#\ncmds.character( \'arm\', query=True, sc=True )\n# Result: armScheduler1\n\n# Create a 2nd animation for the character.\n#\ncmds.select( \'joint2\', r=True )\ncmds.currentTime( 0 )\ncmds.setKeyframe( \'arm\' )\ncmds.currentTime( 10 )\ncmds.setKeyframe( \'joint2.rx\', v=45 )\ncmds.setKeyframe( \'joint2.ry\', v=-20 )\ncmds.currentTime( 20 )\ncmds.setKeyframe( \'joint2.rx\', v=0 )\ncmds.setKeyframe( \'joint2.ry\', v=20 )\n\n# Create a clip for the current animation named "elbowWave"\n#\ncmds.clip( \'arm\', startTime=0, endTime=20, name=\'elbowWave\' )\n\n# Instance handeWave at time 10\n#\ncmds.clipSchedule( \'armScheduler1\', instance=\'handWave\', s=10 )\n\n# Query the clip index of the latest instance of handWave. Each instance\n# of a clip received a unique clipIndex. The clip index is used to\n# edit and query data for existing clips.\n#\ncmds.clipSchedule( \'armScheduler1\', name=\'handWave1\', query=True, ci=True )\n\n# Query whether the clip associated with index 2 is enabled or not\n#\ncmds.clipSchedule( \'armScheduler1\', ci=2, query=True, enable=True )\n\n# Query the name of the clip associated with index 2\n#\ncmds.clipSchedule( \'armScheduler1\', ci=2, query=True, n=True )\n\n# Query the weight of the clip associated with index 2\n#\ncmds.clipSchedule( \'armScheduler1\', ci=2, query=True, weight=True )\n\n# Modify the elbowWave clip to start at frame 10 instead of frame 0\n#\ncmds.clipSchedule( \'armScheduler1\', start=10, ci=1 )\n\n# Trim the start of the elbowWave clip to\n# use the animation starting at frame 5 instead 0\n#\ncmds.clipSchedule( \'armScheduler1\', sourceStart=5, ci=1 )\n\n# Trim the end of the elbowWave clip to\n# use the animation up to frame 15 instead 20\n#\ncmds.clipSchedule( \'armScheduler1\', sourceEnd=15, ci=1 )\n\n# Modify the handWave clip to have two cycles instead of 1\n#\ncmds.clipSchedule( \'armScheduler1\', postCycle=1, ci=0 )\n\n# list the animation curves associated with a particular clip\n#\ncmds.clipSchedule( \'armScheduler1\', ci=2, listCurves=True )\n\n# Move a particular clip to a particular track\n#\ncmds.clipSchedule( \'armScheduler1\', track=2, ci=0 )\n\n# Add a blend between clips 1 and 2\n#\ncmds.clipSchedule( \'armScheduler1\', b=(1, 2) )\n\n# Query the name of the blendNode between clips 1 and 2\n#\ncmds.clipSchedule( \'armScheduler1\', q=True, bn=(1, 2) )\n\n# Lock the first track and then query its state\n#\ncmds.clipSchedule( \'armScheduler1\', track=1, e=True, lock=1 )\ncmds.clipSchedule( \'armScheduler1\', track=1, query=True, lock=True )\n\n# Query the existing clips in the scheduler.\n# In query mode, returns an array of strings in this form:\n# (clipName,index,start,sourceStart,sourceEnd,scale,preCycle,postCycle,hold)\n#\n# In this case there are three scheduled clips:\n#  2 instances of "handWave" and 1 of "elbowWave". The clip indices for "handWave" are 0\n#  and 3. The clip index for "elbowWave" is 2. Note that the clip indices can be sparse\n#  since a clip maintains its index as long as it is in the schedule (the TraX editor).\n#\ncmds.clipSchedule( \'armScheduler1\', query=True )\n# Result: handWave,0,0.000000,0.000000,20.000000,1.000000,0.00000,2.00000 elbowWave,1,0.000000,5.000000,15.000000,1.000000,0.00000,1.00000 handWave,2,10.000000,0.000000,20.000000,1.000000,0.00000,1.00000\n#\n\n# Shift clips 1 and 2 up 3 tracks\n#\ncmds.clipSchedule( \'armScheduler1\', sh=-3, shi=1, shi=2 )\n\n# Print out which anim curves animate which channels for the\n# clip with an index of 2.\n#\nout = cmds.clipSchedule(\'armScheduler1\' ,ci=2, query=True, lp=True)\nfor pair in out:\n   print pair',
 'clipSchedulerOutliner': "import maya.cmds as cmds\n\ncmds.window( 'myWindow', rtf=0, width=200 )\ncmds.formLayout( 'myForm' )\ncmds.clipSchedulerOutliner( 'myOutliner', clipScheduler='charScheduler1' )\ncmds.formLayout( 'myForm', e=True, af=[('myOutliner', 'top', 0), ('myOutliner', 'left', 0), ('myOutliner', 'bottom', 0), ('myOutliner', 'right', 0)] )\ncmds.showWindow()",
 'closeCurve': "import maya.cmds as cmds\n\ncmds.closeCurve( 'curve1', ch=True, ps=True )\n# Closes curve1 with history and by preserving shape.  The result will\n# be the name of the closed curve, and the name of the newly created\n# dependency node.\n\ncmds.closeCurve( 'curve1', ch=True, ps=False )\n# Closes curve1 with history and will not preserve the shape of the\n# curve.\n\ncmds.closeCurve( 'curve1', ch=True, rpo=True )\n# Closes curve1 with history and replaces the original curve with\n# the closed one.",
 'closeSurface': "import maya.cmds as cmds\n\ncmds.closeSurface( 'surface1', ch=True, d=0, ps=True )\n# Closes surface1 in the U direction with history and by preserving shape.\n# The name of the closed surface, and the name of the newly created\n# dependency node are returned.\n\ncmds.closeSurface( 'surface1', ch=True, d=2, ps=False )\n# Closes surface1 in both U and V directions, with history.  Closing\n# the surface will not preserve the shape of the surface.\n\ncmds.closeSurface( 'surface1.u[0.66]', ch= True )\n# Closes surface1 in the V direction, with history.  The direction is\n# implied from the specified isoparm.",
 'cluster': 'import maya.cmds as cmds\n\n# Create a cluster which uses the transformation of elbow1\n#\ncmds.joint(p=(2,0,0),name="elbow1")\ncmds.joint(p=(4,0,0),name="wrist1")\n\ncmds.sphere()\ncmds.cluster( wn=(\'elbow1\', \'elbow1\') )\n\n# Edit cluster1 to use the transformation of wrist1.\n#\ncmds.cluster( \'cluster1\', e=True, bs=1, wn=(\'wrist1\', \'wrist1\') )\n\n# Create a relative cluster with its own cluster handle. The\n# cluster handle is drawn as the letter "C".\n#\ncmds.cluster( rel=True )\n\n# Modify the membership of an existing cluster. First, find\n# the name of the cluster\'s associated set, then use the sets\n# command to edit the set membership (add a cube and remove a plane).\n#\ncmds.listConnections( \'cluster1\', type="objectSet" )\n# Result: cluster1Set\ncmds.sets( \'pCube1\', add=\'cluster1Set\' )\ncmds.sets( \'pPlane1\', rm=\'cluster1Set\' )',
 'cmdFileOutput': 'import maya.cmds as cmds\n\ncmds.cmdFileOutput( o=\'dbOutput.txt\' )\n# Result: 1 #\nprint( \'This message is in the file\\n\' )\n# This message is in the file\ncmds.cmdFileOutput( s=1 )\n# Result: 0 #\ncmds.cmdFileOutput( s=2 )\n# Result: -3 #\ncmds.cmdFileOutput( c=1 )\n# Result: 0 #\n# Notice that the \'This message is in the file\' string is in the file,\n# as are all of the entered commands and the\n# \'# Result: ...\' lines, etc.\n\n# Turn on logging to a file on Maya startup so as to log all error\n# messages which happen on startup.\n#\n# Set the environment variable MAYA_CMD_FILE_OUTPUT to "trace.txt"\n# Start up Maya\n# Messages should now be logged to the file "trace.txt" as well as the\n# script editor window.\n\n# Turn off logging to the filename specified by $MAYA_CMD_FILE_OUTPUT\n# after Maya has completed startup.\n#\nimport os\ntraceFile = os.environ[ "MAYA_CMD_FILE_OUTPUT" ]\ndescriptor = cmds.cmdFileOutput( q=True, o=traceFile )\nif -1 != descriptor:\n\tcmds.cmdFileOutput( close=descriptor )',
 'cmdScrollFieldExecuter': 'import maya.cmds as cmds\n\n# this will create a tiny window with a Mel command executer.\ncmds.window()\ncmds.columnLayout()\ncmds.cmdScrollFieldExecuter(width=200, height=100)\ncmds.showWindow()\n\n# this will create a tiny window with a Python command executer.\ncmds.window()\ncmds.columnLayout()\ncmds.cmdScrollFieldExecuter(width=200, height=100, sourceType="python")\ncmds.showWindow()',
 'cmdScrollFieldReporter': 'import maya.cmds as cmds\n\n# this will create a tiny window with a command history reporter\ncmds.window()\ncmds.columnLayout()\ncmds.cmdScrollFieldReporter(width=200, height=100)\ncmds.showWindow()',
 'cmdShell': 'import maya.cmds as cmds\n\nimport maya.cmds as cmds\n\n#    Delete the window if it already exists.\n#\nif cmds.window( \'ExampleWindow\', exists=True):\n\tcmds.deleteUI( \'ExampleWindow\', window=True)\n\n#    Create a window containing a cmdShell and a couple buttons.\n#\n#    Use a form layout to position the controls.\n#\ncmds.window( \'ExampleWindow\', widthHeight=(300, 300) )\nform = cmds.formLayout()\ncmdShell = cmds.cmdShell()\nclearButton = cmds.button(label=\'Clear\', command=(\'cmds.cmdShell(\\"\' + cmdShell + \'\\", edit=True, clear=True)\' ))\ncloseButton = cmds.button(label=\'Close\', command=(\'cmds.deleteUI( "ExampleWindow", window=True )\' ) )\n\n#    Set up the attachments.\n#\ncmds.formLayout( form, edit=True,\n\tattachForm=((cmdShell, \'top\', 0), (cmdShell, \'left\', 0), (cmdShell, \'right\', 0), (clearButton, \'left\', 0),\n\t\t\t\t\t\t\t\t(clearButton, \'bottom\', 0), (closeButton, \'bottom\', 0), (closeButton, \'right\', 0)),\n\tattachControl=(cmdShell, \'bottom\', 0, clearButton),\n\tattachNone=((clearButton, \'top\'), (closeButton, \'top\')),\n\tattachPosition=((clearButton, \'right\', 0, 50), (closeButton, \'left\', 0, 50)))\n\ncmds.showWindow( \'ExampleWindow\' )',
 'coarsenSubdivSelectionList': 'import maya.cmds as cmds\n\n# after selecting components of a subdivision surface\ncmds.coarsenSubdivSelectionList()',
 'collision': "import maya.cmds as cmds\n\ncmds.collision( 'nurbsSphere1', 'particle1', r=.75, f=.1 )\n# Causes particles of particle1 to collide with nurbsSphere1,\n# and sets a resilience value of 0.75 and a friction value of 0.1\n# for the surface.\n\ncmds.collision( 'nurbsSphere1', q=True, f=1 )\n# Returns the friction value stored in the geoConnector for nurbsSphere1.\n\ncmds.collision( 'particleShape1', 'nurbsSphere1', q=True, f=1 )\n# Returns the friction value that particleShape1 is using for collisions\n# against nurbsSphere1.  This may be the same as the friction stored in\n# nurbsSphere1's geoConnector.  Or, if the user broke that connection,\n# then it is whatever value is in the particleShape1's collisionFriction\n# attribute that is used for collision with nurbsSphere1.\n\ncmds.collision( 'nurbsSphere1', 'particleShape1', q=True )\n# Returns whether or not particleShape1 is checking for collisions\n# against nurbsSphere1.\n\ncmds.collision( 'particleShape1', q=True )\n# Returns all of the geometries that particleShape1 is colliding with.",
 'color': "import maya.cmds as cmds\n\n# create a sphere and deselect it\ncmds.sphere( n='sphere1' )\ncmds.select( d=True )\n\n# Set the inactive wireframe color of the sphere to the\n# first user defined color\ncmds.color( 'sphere1', ud=1 )\n\n# rgb defined color (red)\ncmds.color( 'sphere1', rgb=(1, 0, 0) )\n\n# set the wireframe color of the sphere back to its default color\ncmds.color( 'sphere1' )",
 'colorAtPoint': "import maya.cmds as cmds\n\n# The return value is the array of values determined by the number of\n# coord flag uses or samplesU * samplesV. The default return value is alpha.\n# If instead the return value is RGB there will be 3 times as many values returned,\n# and if it is RGBA there will be 4 times as many values.\n\ncmds.createNode( 'checker' )\n\ncmds.colorAtPoint( 'checker1' )\n# returns the alpha value at uv (0.0,0.0) for texture checker1\n# The return array will have one entry corresponding to this alpha.\n\ncmds.colorAtPoint( 'checker1', u=.5, v=.5 )\n# returns the alpha value at uv (0.5,0.5) for texture checker1\n# The return array will have one entry corresponding to this alpha.\n\ncmds.colorAtPoint( 'checker1', o='RGB', u=(.5, 0.0), v=(.5, 0.1) )\n# returns the colors at uv (0.5,0.5) and (0.0, 0.01) for texture checker1\n# The return array will have 6 values in the following order: RGBRGB\n\ncmds.colorAtPoint( 'checker1', o='A', su=11, sv=6 )\n# returns the alpha for 50 points in a uniform 11 by 6 grid mapped across\n# uv (0.0, 0.0) to uv (1.0, 1.0) The 12th point would be the first point\n# in the second row of samples where uv = (0.0, 0.2)\n\ncmds.colorAtPoint( 'checker1', o='A', su=3, sv=3, mu=0.3, mv=0.3, xu=0.4, xv=0.4 )\n# returns the alpha for 9 points in a uniform 3 by 3 grid mapped across\n# uv (0.3, 0.3) to uv (0.4, 0.4) The 4th point would be the first point\n# in the second row of samples where uv = (0.35, 0.3).",
 'colorEditor': "import maya.cmds as cmds\n\n#    Example 1.\n#\ncmds.colorEditor()\nif cmds.colorEditor(query=True, result=True):\n\tvalues = cmds.colorEditor(query=True, rgb=True)\n\tprint 'RGB = ' + str(values)\n\tvalues = cmds.colorEditor(query=True, hsv=True)\n\tprint 'HSV = ' + str(values)\n\talpha = cmds.colorEditor(query=True, alpha=True)\n\tprint 'Alpha = ' + str(alpha)\nelse:\n\tprint 'Editor was dismissed'\n\n#    Example 2.\n#\nresult = cmds.colorEditor()\nbuffer = result.split()\nif '1' == buffer[3]:\n\tvalues = cmds.colorEditor(query=True, rgb=True)\n\tprint 'RGB = ' + str(values)\n\talpha = cmds.colorEditor(query=True, alpha=True)\n\tprint 'Alpha = ' + str(alpha)\nelse:\n\tprint 'Editor was dismissed'",
 'colorIndex': 'import maya.cmds as cmds\n\n# Set the first entry in the color palette to have RGB values 1 0 0 - red.\ncmds.colorIndex( 1, 1, 0, 0 )\n\n# Set the first entry in the color palette to have HSV values 360 1 1 - red.\ncmds.colorIndex( 1, 360, 0, 0, hsv=True )\n\n# Return the RGB color values of the first entry of the color palette.\ncmds.colorIndex( 1, q=True )\n\n# Return the HSV color values of the first entry of the color palette.\ncmds.colorIndex( 1, q=True, hsv=True )',
 'colorIndexSliderGrp': "import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout()\ncmds.colorIndexSliderGrp( label='Select Color', min=0, max=20, value=10 )\ncmds.showWindow()",
 'colorInputWidgetGrp': "import maya.cmds as cmds\n\ncmds.window( title='Colors' )\ncmds.columnLayout()\ncmds.colorInputWidgetGrp( label='Color', rgb=(1, 0, 0) )\ncmds.showWindow()",
 'colorManagementCatalog': "import maya.cmds as cmds\n\n\ncmds.colorManagementCatalog(addTransform='My Custom Viewing LUT', type='view', path='/path/to/myCustomViewingLUT.lut', transformConnection='ACES')\n\ncmds.colorManagementCatalog(removeTransform='My Custom Viewing LUT', type='view')\n\ncmds.colorManagementCatalog(listTransformConnections=True, type='view')\n\ncmds.colorManagementCatalog(editUserTransformPath='/path/transforms')",
 'colorManagementConvert': 'import maya.cmds as cmds\n\n\nimport maya.cmds as cmds\ncolor = cmds.colorManagementConvert(toDisplaySpace=[0.5, 0.5, 0.5])',
 'colorManagementFileRules': "import maya.cmds as cmds\n\n\nimport maya.cmds as cmds\n\ncmds.colorManagementFileRules(add='ruleName', pattern='filePattern', extension='extension', colorSpace='colorSpace')\ncmds.colorManagementFileRules(remove='ruleName')\ncmds.colorManagementFileRules(up='ruleName')\ncmds.colorManagementFileRules(down='ruleName')\n\ncmds.colorManagementFileRules('ruleName', edit=True, pattern='filePattern')\ncmds.colorManagementFileRules('ruleName', edit=True, extension='extension')\ncmds.colorManagementFileRules('ruleName', edit=True, colorSpace='colorSpace')\ncmds.colorManagementFileRules('ruleName', query=True, pattern=True)\ncmds.colorManagementFileRules('ruleName', query=True, extension=True)\ncmds.colorManagementFileRules('ruleName', query=True, colorSpace=True)\n\ncmds.colorManagementFileRules(save=True)\ncmds.colorManagementFileRules(load=True)\n\n# Return array of rule name strings.\ncmds.colorManagementFileRules(listRules=True)\n\n# Return input space corresponding to file path.\ncmds.colorManagementFileRules(evaluate=filePath)",
 'colorManagementPrefs': 'import maya.cmds as cmds\n\n\nws = cmds.colorManagementPrefs(q=True, renderingSpaceName=True)\ncmds.colorManagementPrefs(e=True, viewTransformName="Log")\n\nrenderingSpaces = cmd.colorManagementPrefs(q=True, renderingSpaceNames=True)\nviewingTransforms = cmd.colorManagementPrefs(q=True, viewTransformNames=True)\n\ncmds.colorManagementPrefs(e=True, configFilePath="/project/local_config.ocio")',
 'colorSliderButtonGrp': "import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout()\ncmds.colorSliderButtonGrp( label='Label', buttonLabel='Button', rgb=(1, 0, 0), symbolButtonDisplay=True, columnWidth=(5, 30), image='navButtonUnconnected.png' )\ncmds.showWindow()",
 'colorSliderGrp': "import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout()\ncmds.colorSliderGrp( label='Blue', rgb=(0, 0, 1) )\ncmds.colorSliderGrp( label='Green', hsv=(120, 1, 1) )\ncmds.showWindow()",
 'columnLayout': "import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout( columnAttach=('both', 5), rowSpacing=10, columnWidth=250 )\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.showWindow()",
 'combinationShape': "import maya.cmds as cmds\n\n\nimport maya.cmds as cmds\n\n# Set a blend shape target as combination target, and another two blend shape targets as drivers, using target indexes.\n#\ncmds.combinationShape(blendShape='blendShape1', combinationTargetIndex=1, driverTargetIndex=[2,3])\n\n# Add two blend shape targets as drivers to a blend shape combination target, using target names.\n#\ncmds.combinationShape(edit='1', blendShape='blendShape1', combinationTargetName='TargetA', addDriver=1, driverTargetName=['TargetB', 'TargetC'])\n\n# Remove two blend shape targets from drivers of a blend shape combination target.\n#\ncmds.combinationShape(edit='1', blendShape='blendShape1', combinationTargetIndex=1, removeDriver=1, driverTargetName='TargetB', driverTargetIndex=2;\n\n# Change combine method of a blend shape combination target\n#\ncmds.combinationShape(edit='1', blendShape='blendShape1', combinationTargetIndex=1, combineMethod=2;\n\n# Remove all drivers of a blend shape combination target.\n#\ncmds.combinationShape(edit='1', blendShape='blendShape1', combinationTargetIndex=1, removeDriver=1, allDrivers=1)\n\n# Query all drivers of a blend shape combination target.\n#\ncmds.combinationShape(query='1', blendShape='blendShape1', combinationTargetIndex=1, allDrivers=1)",
 'commandEcho': "import maya.cmds as cmds\n\n# Echo everything\ncmds.commandEcho( state=True )\n# Go back to normal\ncmds.commandEcho( state=False )\n# Display line number information in messages.  This is the default.\ncmds.commandEcho( lineNumbers=True )\n# Do not display line number information in messages.\ncmds.commandEcho( lineNumbers=False )\n# Do not display changeToolIcon, escapeCurrentTool or autoUpdateAttrEd commands when echoing everything\ncmds.commandEcho( filter=('changeToolIcon', 'escapeCurrentTool', 'autoUpdateAttrEd') );\n# Do not display setLastFocusedCommandReporter or setLastFocusedCommandExecuter when echoing everything\ncmds.commandEcho( filter=('setLastFocusedCommand') );\n#  Add to the current filter\ncmds.commandEcho( addFilter=('addToolIcon') );",
 'commandLine': 'import maya.cmds as cmds\n\n#    Create a window that contains a command line.\n#\nwindow = cmds.window(\'window\')\nform = cmds.formLayout()\nfield = cmds.scrollField()\n\ncmdLine = cmds.commandLine()\ncmds.commandLine( cmdLine, edit=True, height=25)\ncmds.commandLine( cmdLine, edit=True, sourceType="python")\ncmds.formLayout( form, edit=True, attachForm=[(cmdLine, \'top\', 0), (cmdLine, \'left\', 0), (cmdLine, \'right\', 0), (field, \'left\', 0), (field, \'bottom\', 0), (field, \'right\', 0)], attachNone=(cmdLine, \'bottom\'), attachControl=(field, \'top\', 5, cmdLine) )\n\n#    Give the command line initial keyboard focus.\n#\ncmds.setFocus( cmdLine )\ncmds.showWindow( window )',
 'commandLogging': "import maya.cmds as cmds\n\n# Set the number of commands logged in memory to 20\n#\ncmds.commandLogging( historySize=20 )\n\n# Query the number of commands being logged in memory\n#\ncmds.commandLogging( q=True, historySize=True )\n# Result: 20\n\n# Query the log file location\n#\ncmds.commandLogging( q=True, logFile=True )\n# Result: C:/Users/foobar/Documents/maya/mayaCommandLog.txt\n\n# Change the log file location\n#\ncmds.commandLogging( logFile='C:/temp/log.txt' )\n\n# Reset the log file to default\n#\ncmds.commandLogging( resetLogFile=True )",
 'commandPort': 'import maya.cmds as cmds\n\n# Open a command port with the default name "mayaCommand".\ncmds.commandPort()\n\n# Close the command port with the default name. Open client connections\n# are not broken.\ncmds.commandPort( cl=True )\n\n# Query to see if the command command port "mayaCommand" exists.\ncmds.commandPort( \'mayaCommand\', q=True )',
 'componentBox': "import maya.cmds as cmds\n\ncmds.window()\ncmds.formLayout( 'form' )\ncmds.componentBox( 'cbox' )\ncmds.formLayout( 'form', e=True, af=(('cbox', 'top', 0), ('cbox', 'left', 0), ('cbox', 'right', 0), ('cbox', 'bottom', 0)) )\ncmds.showWindow()",
 'componentEditor': "import maya.cmds as cmds\n\n# componentEditorWindow is a MEL procedure so need to call through MEL.\nimport maya.mel\nmaya.mel.eval('componentEditorWindow()')\ncmds.componentEditor( 'componentEditorWinComponEditor', q=True, ctl=True )",
 'componentTag': "import maya.cmds as cmds\n\n    # Make a geometry\n    import maya.cmds as cmds\n    cmds.polyCylinder(ch=True, o=True, r=3.0, h=8.0, sc=1, sx=6, sy=9, cuv=3, name='cyl')\n\n    # Create some tags\n    cmds.componentTag(['cyl.f[0:17]'], cr=True, ntn='bottomSection')\n    cmds.componentTag(['cyl.f[36:53]'], cr=True, ntn='topSection')\n\n    # Edit a tag\n    cmds.componentTag(['cyl.f[18:35]'], tn='bottomSection', m='add')\n\n    # Rename the tag\n    cmds.componentTag('cyl', rn=True, tn='bottomSection', ntn='lowerSection')\n\n    # Delete tags (using a wild card)\n    cmds.componentTag('cyl', d=True, tn='*Section')",
 'condition': 'import maya.cmds as cmds\n\n#    Create a new condition, called "UndoNorRedo", which is true if\n#    and only if undo is not available and redo is not available:\n\ndef isUndoNorRedo() :\n\treturn not cmds.isTrue(\'UndoAvailable\') and not cmds.isTrue(\'RedoAvailable\')\n\ncmds.condition(\'UndoNorRedo\', initialize=True, d=[\'UndoAvailable\', \'RedoAvailable\'], s=\'python("isUndoNorRedo()")\')\n\n# Try out the new condition\n#\nif cmds.isTrue(\'UndoNorRedo\') :\n\tprint \'Neither undo nor redo is available\'\nelse :\n\tprint \'Undo or redo is available\'\n\ncmds.condition(\'UndoNorRedo\', delete=True)',
 'cone': "import maya.cmds as cmds\n\ncmds.cone()\ncmds.cone( ch= True, radius=10, hr=3 )\ncmds.cone( r=5, axis=(1, 1, 1), pivot=(0, 0, 1), ssw='0deg', esw='90deg' )\ncmds.cone( ut=True, tol=0.01 )\n\n#Query the radius of the selected cone\nr = cmds.cone( q=True, r=True )",
 'confirmDialog': "import maya.cmds as cmds\n\n\n# Create an empty single button dialog.\n#\n\ncmds.confirmDialog()\n\n\n# Create a basic Yes/No dialog.\n#\n\ncmds.confirmDialog( title='Confirm', message='Are you sure?', button=['Yes','No'], defaultButton='Yes', cancelButton='No', dismissString='No' )",
 'connectAttr': "import maya.cmds as cmds\n\ncmds.createNode( 'transform', n='firstGuy' )\ncmds.createNode( 'transform', n='secondGuy' )\n\n# Connect the translation of two nodes together\ncmds.connectAttr( 'firstGuy.t', 'secondGuy.translate' )\n\n# Connect the rotation of one node to the override colour\n# of a second node.\ncmds.connectAttr( 'firstGuy.rotate', 'secondGuy.overrideColor' )",
 'connectControl': "import maya.cmds as cmds\n\nsphereNames = cmds.sphere()\nsphereName = sphereNames[0]\nwindow = cmds.window()\ncmds.columnLayout()\ncmds.text( l='X Value:' )\ncmds.floatField( 'xx' )\ncmds.connectControl( 'xx', '%s.tx' % sphereName )\ncmds.text( l='Visibility' )\ncmds.checkBox( 'vis' )\ncmds.connectControl( 'vis', '%s.visibility' % sphereName )\ncmds.floatFieldGrp( 'rot', l='Rotation:', numberOfFields=3 )\n# index 1 would be the text label\ncmds.connectControl( 'rot', '%s.rx' % sphereName, index=2 )\ncmds.connectControl( 'rot', '%s.ry' % sphereName, index=3 )\ncmds.connectControl( 'rot', '%s.rz' % sphereName, index=4 )\ncmds.showWindow( window )\n\n# Connecting two attributes to a single control\n#\ncmds.window()\ncmds.columnLayout()\ncmds.floatSlider( 'slider' )\ncmds.showWindow()\n\ncmds.polySphere()\ncmds.polyCube()\ncmds.move( 0, 2, 0 )\ncmds.connectControl( 'slider', 'pCube1.tx', 'pSphere1.tx' )",
 'connectDynamic': 'import maya.cmds as cmds\n\ncmds.connectDynamic( \'Book\', c=\'Floor\' )\n# Connects the dynamic object "Book" to the collision model of the\n# "Floor". This means that the book will collide with and bounce off of\n# the floor.\n\ncmds.connectDynamic( \'Moon\', \'Spaceship\', f=\'Moon\' )\n# Connects dynamic object "Spaceship" to the all fields and emitters\n# owned by "Moon".\n\ncmds.connectDynamic( \'Spaceship\', f=\'newtonField1\' )\n# Connects dynamic object "Spaceship" to "newtonField1" owned by "Moon".\n\ncmds.connectDynamic( \'Moon\', f=\'newtonField1\' )\n# If the selection list consists of "Spaceship", connects dynamic object\n# "Spaceship" to "newtonField1" and all emitters owned by "Moon".\n\ncmds.connectDynamic( \'Spaceship\', d=True, f=\'Moon\' )\n# Deletes the field connection between all the fields owned by "Moon" and\n# "Spaceship". Note that the command establishing the connection need not\n# be in the undo queue.\n\ncmds.connectDynamic( \'Spaceship\', d=True, f=\'newtonField1\' )\n# Deletes the field connection between "newtonField1" owned by "Moon" and\n# "Spaceship".\n\ndef callback(fields, emitters, collisionObjects, objects):\n\t\'\'\'\n\tTest callback for intercepting calls to the connectDynamic command\n\t\'\'\'\n    print \'Fields: %s\' % str(fields)\n    print \'Emitters: %s\' % str(emitters)\n    print \'Collision Objects: %s\' % str(collisionObjects)\n    print \'Objects: %s\' % str(objects)\n\n    # Let connectDynamic handle the connection\n    return False\n\nhandler_id = cmds.connectDynamic(addScriptHandler=callback)\n# Installs the above handler to intercept calls to the connectDynamic command\n\ncmds.connectDynamic(removeScriptHandler=handler_id)\n# Remove the above script handler',
 'connectJoint': "import maya.cmds as cmds\n\n# make joint1 a child of joint4.\n#\ncmds.connectJoint( 'joint1', 'joint4', pm=True )\n\n# make joint1 a child of joint4's parent\n#\ncmds.connectJoint( 'joint1', 'joint4', cm=True )",
 'connectionInfo': "import maya.cmds as cmds\n\n#    Create a sphere and a cone and make the Z translation of the cone\n#    be dependent on the X translation of the sphere.\n#\ncone = cmds.cone()\nsphere = cmds.sphere()\nsphereTx = '%s.tx' % sphere[0]\nconeTz = '%s.tz' % cone[0]\ncmds.connectAttr(sphereTx, coneTz)\n\n#    Verify the connection and print out the source plug.\n#\nif cmds.connectionInfo( coneTz, isDestination=True):\n  print( 'Source: %s' % cmds.connectionInfo(coneTz,sourceFromDestination=True) )\n\n#    Verify the connection and print out the destination plug.\n#\nif cmds.connectionInfo( sphereTx, isSource=True):\n  destinations = cmds.connectionInfo(sphereTx, destinationFromSource=True)\n  for destination in destinations:\n    print destination",
 'constrain': 'import maya.cmds as cmds\n\n# "Nail" a rigid body at position <<0.0, 2.5, 0.0>>\n#\ncmds.constrain( \'rigidBody1\', nail=True, p=(0, 2.5, 0) )\n\n# "Pin" two rigid bodies together at the position <<0.0, 2.5, 0.0>>.\n#\ncmds.constrain( \'rigidBody1\', \'rigidBody2\', pin=True, n=\'pin\', p=(0, 2.5, 0) )\n\n# "Hinge" a rigid body at the position <<0.0, 2.5, 0.0>>.\n#\ncmds.constrain( \'rigidBody1\', hinge=True, p=(0, 2.5, 0) )\n\n# Create a barrier for a rigid body which will not allow the rigid body\n# to fall below (in y by default) the plane defined by the\n# barrier point <<0.0, 2.5, 0.0>>.\n#\ncmds.constrain( \'rigidBody1\', barrier=True, p=(0, 2.5, 0) )\n\n# Add a "Spring" to a rigid body at the position <<0.0, 2.5, 0.0>>\n# connected on the rigid body at point <<0, 0, 0>>\n#\ncmds.constrain( \'rigidBody1\', spring=True, name=\'spring\', p=(0, 2.5, 0), rl=1.0 )',
 'constructionHistory': 'import maya.cmds as cmds\n\ncmds.constructionHistory( tgl=True )\ncmds.constructionHistory( tgl=False )\n\n# Returns true if construction history is on.\n# Returns false if construction history is off.\ncmds.constructionHistory( q=True, tgl=True )',
 'container': 'import maya.cmds as cmds\n\n# Create a container holding a locator transform only (not its shape)\n#\nloc = cmds.spaceLocator()\ncon1 = cmds.container(addNode=[loc[0]])\n\n# Select the nodes that would be in the container, but don\'t create it\n#\ncmds.container(preview=True,addNode=[cone[0]],includeNetwork=True,includeHierarchyBelow=True)\n\n\n# Create a container holding a polygon shape, its transform and its\n# history node. Publish its tx attr.\n#\ncone = cmds.polyCone()\ncon2 = cmds.container(addNode=[cone[0]],includeNetwork=True,includeHierarchyBelow=True)\n\n# Publish the cone\'s tx and the locator\'s tx with the same name\n#\ncmds.container(con1,edit=True,publishName=\'main_tx\')\ncmds.container(con1,edit=True,bindAttr=[\'%s.tx\' % loc[0],\'main_tx\'])\ncmds.container(con2,edit=True,publishName=\'main_tx\')\ncmds.container(con2,edit=True,bindAttr=[\'%s.tx\' % cone[0],\'main_tx\'])\n\n# Publish the name "sam", but don\'t bind it to anything\n#\ncmds.container(con1,edit=True,publishName=\'sam\')\n\n# Query the bound publications\n#\ncmds.container(con1,query=True,bindAttr=1)\n# Result: [u\'locator1.translateX\', u\'main_tx\'] #\n\n# Query all the published names:\n#\ncmds.container(con1,query=True,publishName=1)\n# Result: [u\'main_tx\' u\'sam\'] #\n\n# Query just the bound published names:\n#\ncmds.container(con1,query=True,publishName=1,bindAttr=1)\n# Result: [u\'main_tx\'] #\n\n# Query just the unbound published names:\n#\ncmds.container(con1,query=True,publishName=1,unbindAttr=1)\n# Result: [u\'sam\'] #\n\n# Query just the published name for the published attribute locator1.translateX\n#\ncmds.container(con1,query=True,publishName=1,publishAttr=\'locator1.translateX\')\n# Result: [u\'main_tx\'] #\n\n# keyframe the cone\'s tx\n#\ncmds.currentTime(0)\nconeTx = \'%s.tx\' % cone[0]\ncmds.setKeyframe(coneTx)\ncmds.currentTime(4)\ncmds.setAttr(coneTx,10.0)\ncmds.setKeyframe(coneTx)\n\n# Query the nodes in the container\n#\nnodes = cmds.container(con2,query=True,nodeList=True)\n\n# Remove a node from the container\n#\ncmds.container(con2,edit=True,removeNode=nodes[2])\n\n# Remove the container without deleting the nodes within it\n#\ncmds.container(con2,edit=True,removeContainer=True)\n\n# query a referenced scenes for its assets\n#\ncmds.container(q=True,fileName=\'C:/My Documents/maya/projects/default/scenes/refFile.mb\')',
 'containerBind': 'import maya.cmds as cmds\n\n\n# query the template binding sets available for this container\n#\ncmds.containerBind(container1, query=1, bindingSetList=1)\n\n# attempt to bind published names on the container\n# using matching information in the bindingSet specified.\n# By default only unbound names are considered.\n#\ncmds.containerBind(container1, bindingSet="MayaBindings")\n\n# Attempt to bind all published names on the container\n# using matching information in the bindingSet specified.\n# Previously bound names will only be re-bound if the bindingSet\n# produces an appropriate match.\n#\ncmds.containerBind(container1, bindingSet="MayaBindings", allNames=1)\n\n# Forcibly re-bind all published names on the container\n# using matching information in the bindingSet specified.\n# All previously bound names will be unbound and will only\n# be re-bound if the binding set produces an appropriate match.\n#\ncmds.containerBind(container1, bindingSet="MayaBindings", allNames=1, force=1)\n\n# preview what the results of a binding operation would be, but do\n# not actually perform it.\ncmds.containerBind(container1, bindingSet="MayaBindings", preview=1, allNames=1, force=1)',
 'containerProxy': "import maya.cmds as cmds\n\n\n# create a proxy for container1\n#\ncmds.containerProxy('container1')",
 'containerPublish': 'import maya.cmds as cmds\n\n\n# create a proxy for container1\n#\ncmds.containerPublish(container1,inConnections=True,mergeShared=True)\n\n# add a published name \'mainShader\' of type \'objectSet\'\n#\ncmds.containerPublish(container1,publishNode=[\'mainShadingSet\',\'objectSet\']\n\n# bind a shading group to the published name\n#\ncontainerPublish -bindNode "mainShadingSet" blinn1SG container1;\n\n# query what is bound\n#\ncontainer -q -bindNode container1;\n\n# unbind the shading group\n#\ncontainerPublish -unbindNode "mainShadingSet" container1;',
 'containerTemplate': 'import maya.cmds as cmds\n\n\n#    Create a container template.\n#\ncmds.containerTemplate( \'characterRig\' )\n\n# Create a container template using the published attribute information from\n# container1.\ncmds.containerTemplate (\'characterRig\', fromContainer=\'container1\')\n#\n# Save the template to a template file in the default template location.\ncmds.containerTemplate (\'characterRig\', save=True)\n# Load a template (the template is located along the template search path)\ncmds.containerTemplate (\'characterRig\', load=True)\n# Re-load a template that has already been loaded\n# This is useful if you have made edits to the template outside of maya\ncmds.containerTemplate (\'characterRig\', force=True, load=True)\n# Determine the file that a template was loaded from\ncmds.containerTemplate (\'characterRig\', query=True, fileName=True)\n# Result: C:/myTemplates/characterRig.template #\n#\n# Add a view to a container template. This view will be generated from the\n# given container, and will use a group-by-node hierarchical layout.\n# The view can be subesequently customized if desired.\n#\ncmds.containerTemplate (\'characterRig\', edit=True, addView=\'newView\', fromContainer=\'container1\', layoutMode=1)\ncmds.containerTemplate (\'characterRig\', save=True)\n#\n# Add another view to a container template.\n# This view will be generated with a default layout and can be\n# subsequently customized.\n#\ncmds.containerTemplate (\'characterRig\', edit=True, addView="newView2")\ncmds.containerTemplate (\'characterRig\', save=True)\n#\n# Get the list of attributes in the template.  This will return\n# a flat list of attribute names in the order in which they appear\n# in the template definition.\n#\ncmds.containerTemplate (\'characterRig\', query=True, attributeList=True)\n# Result: [u\'attribute1\', u\'attribute2\', u\'attribute3\'] #\n#\n# List all loaded templates\nlist = cmds.containerTemplate(query=True, templateList=True)\n# Result: [u\'Object\', u\'characterRig\'] #\n#\n# List all templates matching a a given template name\n# Note that all templates with matching base name (in any package) will\n# be returned.\ncmds.containerTemplate (query=True, templateList=True, matchName=\'characterRig\')\n# Result: [u\'characterRig\'] #\n#',
 'containerView': 'import maya.cmds as cmds\n\n\n# Obtain a list of all available views for container1\n#\ncmds.containerView ( \'container1\', query=True, viewList=True);\n# Result: [u\'Animation\', u\'Rendering\'] #\n#\n# Get a list of view items in the current view for container1\n# In this example the list returned will include only the name for\n# each item in the view.\ncmds.containerView ( \'container1\', itemList=True, itemInfo="itemName", query=True)\n# Result: [u\'RenderSetup\', u\'color\', u\'intensity\', u\'Transform\', u\'rotateY\'] #\n#\n# Get a list of view items.\n# In this query the list returned will include the group boolean and label\n# for each item in the view.\ncmds.containerView ( \'container1\', itemList=True, itemInfo="itemIsGroup:itemLabel", query=True)\n# Result: [u\'1\', u\'RenderSetup\', u\'0\', u\'Color\', u\'0\', u\'Intensity\', u\'1\', u\'Transform\', u\'0\', u\'Rotate Y\'] #',
 'contentBrowser': "import maya.cmds as cmds\n\nimport maya.cmds as cmds\n\n# Create the Content Browser and select library in the Examples tab.\ncmds.scriptedPanel('contentBrowserPanel1', edit=True, tearOff=True, label='Content Browser')\npanelNames = cmds.getPanel(scriptType='contentBrowserPanel')\npanelName = panelNames[0]\npanelCompleteName = panelName + 'ContentBrowser'\ncmds.contentBrowser(panelCompleteName, edit=True, location='Examples/FX/Fluids/Ocean Examples')\n\n# Hide the preview pane.\ncmds.contentBrowser(panelCompleteName, edit=True, preview=False)\ncmds.scriptedPanel('contentBrowserPanel1', edit=True, tearOff=True, label='Content Browser')",
 'contextInfo': "import maya.cmds as cmds\n\n# Create a particle tool context, then switch to it\ncmds.dynParticleCtx('dynParticleCtx1')\ncmds.setToolTo('dynParticleCtx1')\n\n# Get the class type of the current context\nctx = cmds.currentCtx()\ncmds.contextInfo(ctx, c=True)\n# Result: dynParticle #\n\n# Get the title of the current context\ncmds.contextInfo(ctx, t=True)\n# Result: Particle Tool #",
 'control': "import maya.cmds as cmds\n\n#    Create a simple window containing a single column layout\n#    and a button.\n#\nwindow = cmds.window(title='Control Example')\ncolumn = cmds.columnLayout()\nbutton = cmds.button()\ncmds.showWindow( window )\n\n#    If you don't know that the control is actually a 'button' then\n#    you may use the 'control' command to determine certain properties.\n#\ncmds.control( button, query=True, width=True )\ncmds.control( button, query=True, height=True )\ncmds.control( button, edit=True, visible=False )\ncmds.control( button, query=True, visible=True )",
 'controller': 'import maya.cmds as cmds\n\ncmds.controller("object")',
 'convertIffToPsd': "import maya.cmds as cmds\n\ncmds.convertIffToPsd( 'd:/test.iff', 'd:/test.psd', xr=640, yr=320 )",
 'convertSolidTx': "import maya.cmds as cmds\n\ncmds.file( f=True, new=True )\n\n# Create a blinn shader with a marble texture.\ncmds.shadingNode( 'blinn', asShader=True )\ncmds.sets( renderable=True, noSurfaceShader=True, empty=True, name='blinn1SG' )\ncmds.connectAttr( 'blinn1.outColor', 'blinn1SG.surfaceShader', f=True )\ncmds.shadingNode( 'marble', asTexture=True )\ncmds.connectAttr( 'marble1.outColor', 'blinn1.color', f=True )\n\n# Create two objects, and assign the blinn shader to them.\ncmds.polySphere()\ncmds.sets( e=True, forceElement='blinn1SG' )\ncmds.polyPlane()\ncmds.move( 2, 0, 0 )\ncmds.sets( e=True, forceElement='blinn1SG' )\n\n# Create a low resolution texture for the sphere\ncmds.convertSolidTx( 'marble1', 'pSphere1', rx=64, ry=64 )\n\n# Create a transparency texture forthe plane.\ncmds.convertSolidTx( 'marble1.outAlpha', 'pPlane1' )\n\n# Create a texture named myTexture.iff for the sphere.\ncmds.convertSolidTx( 'marble1', 'pSphere1', bm='extend', fileImageName='myTexture.iff' )",
 'convertTessellation': "import maya.cmds as cmds\n\n# Convert the basic tessellation settings to advanced.\ncmds.convertTessellation( 'nurbsSphere1' )\n\n# Set the tessellation for nurbsSphere1 based on camera projection\n# from persp.\ncmds.convertTessellation( 'nurbsSphere1', camera='persp' )\n\n# Set tessellation based on all renderable cameras.\ncmds.convertTessellation( 'nurbsSphere2', allCameras='nurbsSphere1' )\n\n# Set the tessellation for all selected objects.\ncmds.convertTessellation()",
 'convertUnit': 'import maya.cmds as cmds\n\n# Returns string "4.80315in", which is 12.2cm in inches.\ncmds.convertUnit( \'12.2\', fromUnit=\'cm\', toUnit=\'in\' )\n\n# Returns string "3.499563yd", which is 3.2m in yards.\ncmds.convertUnit( \'3.2m\', toUnit=\'yard\' )\n\n# Returns float value 13.716, which is 5.4 inches in cm (default system units).\ncmds.convertUnit( \'5.4\', fromUnit=\'inch\' )',
 'copyAttr': "import maya.cmds as cmds\n\n\n# transfer input connections and values from locator1 to locator2\n#\ncmds.copyAttr('locator1','locator2',inConnections=True,values=True)\n\n# transfer only the translateX and translateY values\n#\ncmds.copyAttr('locator1','locator2',values=True,attribute=['tx','translateY'])",
 'copyDeformerWeights': "import maya.cmds as cmds\n\n# Create plane and a cluster.\n#\ncmds.file( f=True,new=True )\ncmds.polyPlane( ch=1, w=10, h=10, sx=5, sy=5, ax=(0,1,0) )\ncmds.cluster( n='testCluster', 'pPlane1' )\n\n# Modify some weights on the -x side of the character\n#\ncmds.select( ['pPlane1.vtx[0]', 'pPlane1.vtx[6]', 'pPlane1.vtx[12]', 'pPlane1.vtx[18]'])\ncmds.percent( 'testCluster', v='0.5' )\n\n# Mirror the skin weights to the other side of the character\n# Mirror inverse is chosen since we want to go from -x to +x, not +x to -x.\n#\ncmds.copyDeformerWeights( ss='pPlane1', ds='pPlane1', sd='testCluster', mirrorMode='YZ', mirrorInverse = True)\ncmds.select( ['pPlane1.vtx[5]', 'pPlane1.vtx[11]', 'pPlane1.vtx[17]', 'pPlane1.vtx[23]'])\ncmds.percent( 'testCluster', q=True, v=True )",
 'copyFlexor': "import maya.cmds as cmds\n\n# Copy flexor ffd1Lattice to joint8\n#\ncmds.copyFlexor( 'ffd1Lattice', 'joint8' )",
 'copyKey': 'import maya.cmds as cmds\n\n# Keys on animation curves are identified by either\n# their time values or their indices.  Times and indices can\n# be given as a range or list of ranges.\n\n# time=(\'10pal\',\'10pal\') means the key at frame 10 (PAL format).\n# time=[(\'1.0sec\',\'1.0sec\'),(\'15ntsc\',\'15ntsc\'),(20,20)] means the keys at time 1.0 second, frame 15 (in NTSC format), and time 20 (in the currently defined global time unit).\n# time=(10,20) means all keys in the range from 10 to 20, inclusive, in the current time unit.\n# Omitting one end of a range means "go to infinity", as in the following examples:\n# time=(10,None) means all keys from time 10 (in the current time unit) onwards.\n# time=(10,) means the same as (10,10)\n# time=(0,10) means all keys up to (and including) time 10 (in the current time unit).\n# time=(None,None) is a short form to specify all keys.\n# index=(0,0) means the first key of each animation curve. (Indices are 0-based.)\n# index=[(2,2),(5,5),(7,7)] means the 3rd, 6th, and 8th keys.\n# index=(1,5) means the 2nd, 3rd, 4th, 5th, and 6th keys of each animation curve.\n\n# Copy keyframes from frame 10 to 20 of cube1\'s "Translate X" attribute\n#\ncmds.copyKey( \'cube1\', time=(10,20), attribute=\'translateX\', option="curve" )\n\n# Copy from all active objects all keys in the range 0 to 60\n#\ncmds.copyKey( time=(0,60) )',
 'copyNode': '',
 'copySkinWeights': 'import maya.cmds as cmds\n\n# Create plane and a skeleton. Bind the skin.\n#\ncmds.file( f=True,new=True )\ncmds.polyPlane( ch=1, w=10, h=10, sx=5, sy=5, ax=(0,1,0) )\ncmds.select( d=True )\ncmds.joint( p=(0, 0, -6) )\ncmds.joint( p=(0, 0, -4) )\ncmds.joint( \'joint1\', e=True, zso=True, oj=\'xyz\')\ncmds.joint( p=(2, 0, -4) )\ncmds.joint( \'joint2\', e=True, zso=True, oj=\'xyz\')\ncmds.joint( p=(5, 0, -3) )\ncmds.joint( \'joint3\', e=True, zso=True, oj=\'xyz\')\ncmds.select( \'joint2\', r=True )\ncmds.joint( p=(-2, 0, -4) )\ncmds.joint( \'joint4\', e=True, zso=True, oj=\'xyz\')\ncmds.joint( p=(-5, 0, -3) )\ncmds.joint( \'joint5\', e=True, zso=True, oj=\'xyz\')\ncmds.select( \'joint2\', r=True )\ncmds.joint( p=(0, 0, 3) )\ncmds.joint( \'joint6\', e=True, zso=True, oj=\'xyz\')\ncmds.joint( p=(5, 0, 5) )\ncmds.joint( \'joint7\', e=True, zso=True, oj=\'xyz\')\ncmds.select( \'joint7\', r=True )\ncmds.joint( p=(-5, 0, 5) )\ncmds.joint( \'joint8\', e=True, zso=True, oj=\'xyz\')\ncmds.select( \'pPlane1\', \'joint1\', r=True )\nmaya.mel.eval(\'createSkinCluster "-mi 5 -dr 4"\' )\n\n# Modify some weights on the -x side of the character\n#\ncmds.skinPercent( \'skinCluster1\', \'pPlane1.vtx[30]\', tv=(\'joint2\',0.200000) )\ncmds.skinPercent( \'skinCluster1\', \'pPlane1.vtx[31]\', tv=(\'joint2\',0.200000) )\ncmds.skinPercent( \'skinCluster1\', \'pPlane1.vtx[24]\', tv=(\'joint5\',0.550000) )\ncmds.skinPercent( \'skinCluster1\', \'pPlane1.vtx[25]\', tv=(\'joint5\',0.550000) )\n\n# Mirror the skin weights to the other side of the character\n# Mirror inverse is chosen since we want to go from -x to +x, not +x to -x.\n#\ncmds.copySkinWeights( ss=\'skinCluster1\', ds=\'skinCluster1\', mirrorMode=\'YZ\', mirrorInverse=True )\n\n# Now create a second plane and bind it as skin\n#\ncmds.polyPlane( ch=1, w=10, h=10, sx=5, sy=5, ax=(0,1,0) )\ncmds.select( \'pPlane2\', r=\'joint1\' )\nmaya.mel.eval(\'createSkinCluster "-mi 5 -dr 4"\' )\n\n# Copy the skin weights from the first plane onto the new plane.\n# The -noMirror flag is used since we want to copy directly, not mirror.\n#\ncmds.copySkinWeights( ss=\'skinCluster1\', ds=\'skinCluster2\', noMirror=True )',
 'crashInfo': 'import maya.cmds as cmds\n\n# query the crash file full path name\n#\ncmds.crashInfo( q = True, cf = True)\n# Result: C:/Users/maya/AppData/Local/Temp/maya.20160413.2009.ma #\n\n# query the crash log full path name\n#\ncmds.crashInfo( q = True, cl = True)\n# Result: C:/Users/maya/AppData/Local/Temp/maya.20160413.2009.log #\n\n# query the saved file full path name before crash\n#\ncmds.crashInfo( q = True, sbc = True)\n# Result: C:/Users/maya/Documents/maya/projects/default/scenes/test.mb #',
 'crashInfoCmd': '',
 'createAttrPatterns': 'import maya.cmds as cmds\n\nimport maya.cmds as cmds\ncmds.createAttrPatterns( patternType="xmlPattern", patternFile="patterns/patternFile.xml" )\n// Result: [myXMLPattern] //',
 'createDisplayLayer': "import maya.cmds as cmds\n\n#    Create a sphere.\n#\nobjectArray = cmds.sphere()\n\n#    Select the sphere.\n#\ncmds.select( objectArray[0] )\n\n#    Create a layer. The selected object will be placed\n#    in this layer. Note in this case both the nurbsSphere\n#    and nurbsSphere shape are placed in the layer.\n#\ncmds.createDisplayLayer()\n\n#    Create a cone.\n#\nobjectArray = cmds.cone()\n\n#    Select the cone.\n#\ncmds.select( objectArray[0] )\n\n#    Create a layer but only put the nurbsCone in the layer.\n#    The nurbsConeShape will remain in the default layer\n#    as a result of specifying the -nr/noRecurse flag.\n#\n#    Note also that you can specify the name of the layer\n#    with the -n/name flag.\n#\n\ncmds.createDisplayLayer( noRecurse=True, name='ExampleLayer' )",
 'createEditor': "import maya.cmds as cmds\n\n# The following command will create an attribute\n# editor in someWindow|topLayout for curve2.\n#\ncmds.createEditor( 'someWindow|toplayout', 'curve2' )",
 'createLayeredPsdFile': 'import maya.cmds as cmds\n\n# Creates a layered PSD file with "Layer 1" as one of the layers. The image which\n# gets transfered to "Layer 1" is picked from D:/test.iff. The blend mode assigned to\n# is the "Normal" mode.\ncmds.createLayeredPsdFile( \'D:/test.psd\', xr=640, yr=480, ifn=(\'D:/test.iff\', \'Normal\', \'Layer 1\') )',
 'createNode': "import maya.cmds as cmds\n\ncmds.createNode( 'transform', n='transform1' )\ncmds.createNode( 'nurbsSurface', n='surface1', p='transform1' )\ncmds.createNode( 'camera', shared=True, n='top' )\n\n# This transform will be selected when created\ncmds.createNode( 'transform', n='selectedTransform' )\n\n# This will create a new transform node, but 'selectedTransform'\n# will still be selected.\ncmds.createNode( 'transform', ss=True )\n\n# Create node under new namespace\ncmds.createNode( 'transform', n='newNS:transform1' )",
 'createNurbsCircleCtx': '',
 'createNurbsConeCtx': '',
 'createNurbsCubeCtx': '',
 'createNurbsCylinderCtx': '',
 'createNurbsPlaneCtx': '',
 'createNurbsSphereCtx': '',
 'createNurbsSquareCtx': '',
 'createNurbsTorusCtx': '',
 'createPolyConeCtx': '',
 'createPolyCubeCtx': '',
 'createPolyCylinderCtx': '',
 'createPolyHelixCtx': '',
 'createPolyPipeCtx': '',
 'createPolyPlaneCtx': '',
 'createPolyPlatonicSolidCtx': '',
 'createPolyPrismCtx': '',
 'createPolyPyramidCtx': '',
 'createPolySoccerBallCtx': '',
 'createPolySphereCtx': '',
 'createPolyTorusCtx': '',
 'createRenderLayer': "import maya.cmds as cmds\n\n# Add nut and nutShape to a new render layer\n#\ncmds.select( 'nut' )\ncmds.createRenderLayer()\n# Result: renderLayer1 #\n\n# Add only bolt to a new render layer\n#\ncmds.createRenderLayer( 'bolt', noRecurse=True )\n# Result: renderLayer2 #\n\n# Add washer to the new render layer 'assembly'.\n#\ncmds.createRenderLayer( 'washer', noRecurse=True, name='assembly' )\n# Result: assembly #\n\n# Create a layer that will always contains everything\n#\ncmds.createRenderLayer( g=True )\n# Result: renderLayer3 #",
 'createSubdivRegion': 'import maya.cmds as cmds\n\n# after selecting components of a subdivision surface\ncmds.createSubdivRegion()',
 'ctxAbort': "import maya.cmds as cmds\n\n# Create a new particle tool context, then switch to it\ncmds.dynParticleCtx('dynParticleCtx1')\ncmds.setToolTo('dynParticleCtx1')\n# Click the positions where you want to place the particles\n\n# This command will reset the particle tool, clear the particles you have just created\ncmds.ctxAbort();",
 'ctxCompletion': "import maya.cmds as cmds\n\n# Create a curve\ncmds.curve(p=[(0, 0, 0), (3, 5, 6), (5, 6, 7), (9, 9, 9), (12, 10, 2)], k=[0,0,0,1,2,2,2])\n# Result: curve1 #\n\n# Create a new curve editor context to modify the curve, then switch to it\n# You can modify the curve using the manipulator handle\ncmds.curveEditorCtx('curveEditorCtx1')\ncmds.setToolTo('curveEditorCtx1')\n\n# This command ends curve editing, the manipulator handle will disappear, leaving the modified curve\ncmds.ctxCompletion()",
 'ctxData': '',
 'ctxEditMode': "import maya.cmds as cmds\n\n# Create a poly cube\ncmds.polyCube(w=2, h=2, d=2, n='pCube1')\n\n# Create a new rotate manip context, then switch to it.\ncmds.manipRotateContext('manipRotateContext1')\ncmds.setToolTo('manipRotateContext1')\n\n# Switch to edit mode to change pivots\ncmds.ctxEditMode()",
 'ctxTraverse': "import maya.cmds as cmds\n\n# Create a particle context, then switch to it\ncmds.dynParticleCtx('dynParticleCtx1')\ncmds.setToolTo('dynParticleCtx1')\n\n# Now you can create particles by mouse clicking\n# After creating several particles, we switch to edit mode\ncmds.ctxEditMode()\n\n# Traverse in the created particles\ncmds.ctxTraverse(left=True)\ncmds.ctxTraverse(left=True)\ncmds.ctxTraverse(right=True)",
 'currentCtx': 'import maya.cmds as cmds\n\ncmds.currentCtx()',
 'currentTime': 'import maya.cmds as cmds\n\n# Query the current time\n#\ncmds.currentTime( query=True )\n\n# Change the current time to "30" in current time units\n#\ncmds.currentTime( 30, edit=True )\ncmds.currentTime( 30 )\n\n# Change the current time to 2 seconds\n#\ncmds.currentTime( \'2sec\', edit=True )\n\n# Change the current time, but do not cause the model\n# to update.\n#\ncmds.currentTime( -10, update=False, edit=True )',
 'currentTimeCtx': 'import maya.cmds as cmds\n\ncmds.currentTimeCtx()',
 'currentUnit': "import maya.cmds as cmds\n\n# What is the current linear unit?\ncmds.currentUnit( query=True, linear=True )\n\n# What is the current angular unit in its long name form?\ncmds.currentUnit( fullName=True, query=True, angle=True )\n\n# Change the current time unit to ntsc\ncmds.currentUnit( time='ntsc' )\n\n# Change the current linear unit to inches\ncmds.currentUnit( linear='in' )",
 'curve': 'import maya.cmds as cmds\n\n# These commands create curves with four control vertices.\n# The first one is created without weights.  The third command\n# shows how you can use units to specify position.\ncmds.curve( p=[(0, 0, 0), (3, 5, 6), (5, 6, 7), (9, 9, 9)] )\ncmds.curve( pw=[(0, 0, 0, 1), (3, 5, 6, 1), (5, 6, 7, 1), (9, 9, 9, 1)] )\ncmds.curve( p=[(\'0cm\', \'0cm\', \'0cm\'), (\'3in\', \'5in\', \'6in\'), (\'5ft\', \'6ft\', \'7ft\'), (9, 9, 9)] )\n\n# This command replaces an existing curve, curve1, with the given points.\n# Do not use this flag on a curve that is a result of a construction\n# history operation.\ncmds.curve( \'curve1\', r=True, p=[(0, 0, 0), (3, 5, 6), (10, 12, 14), (9, 9, 9)] )\n\n# This command adds two CVs to an existing curve, curve1.\n# The "-ws" flag can be used if the specified CVs are in world space.\n# Do not use this flag on a curve that is a result of a construction\n# history operation.\ncmds.curve( \'curve1\', a=True, p=[(13, 13, 13), (13, 15, 16)] )\n\n# This command creates a curve with five control vertices,\n# with a knot vector. Notice that there must be\n# (number of CVs + degree - 1) knots and that the knot\n# vector must be non-decreasing.\ncmds.curve( p=[(0, 0, 0), (3, 5, 6), (5, 6, 7), (9, 9, 9), (12, 10, 2)], k=[0,0,0,1,2,2,2] )\n\n# This command creates a closed (or "periodic") curve with\n# four distinct CVs. You must specify a knot vector when the\n# "-per" flag is used. Notice that the first "degree" points\n# are the same as the last "degree" points (ie. the first three\n# points are the same as the last three points). Notice also\n# that the knot spacing between the first "degree" knots must\n# be the same as the spacing between the last "degree" knots\n# (ie. the space between the 1st and 2nd knots is the same as\n# the space between the 7th and 8th knots, and the space between\n# the 2nd and 3rd knots is the same as the space between the\n# 8th and 9th knots). There must be space between the first\n# "degree" knots, unlike the previous example, where the first\n# "degree" knots are the same.\ncmds.curve( per=True, p=[(0, 0, 0), (3, 5, 6), (5, 6, 7), (9, 9, 9), (0, 0, 0), (3, 5, 6), (5, 6, 7)], k=[-2,-1,0,1,2,3,4,5,6] )\n\n# How to query curve properties:\n\n# This returns the degree of the curve.  Note that the\n# number of CVs = degree + spans.\ncmds.getAttr( \'curve1.degree\' )\n\n# This returns the number of spans in the curve.  Note that the\n# number of CVs = degree + spans.\ncmds.getAttr( \'curve1.spans\' )\n\n# This returns the curve form.\ncmds.getAttr( \'curve1.form\' )\n\n# This returns the minimum parameter value on the curve.\ncmds.getAttr( \'curve1.minValue\' )\n\n# This returns the maximum parameter value on the curve.\ncmds.getAttr( \'curve1.maxValue\' )\n\n# This returns the local x,y,z of the 1st CV.  Use a curve info node if\n# the curve is a result of a construction history operation.\ncmds.getAttr( \'curve1.cv[0]\' )\n\n# This returns the local x,y,z of the 1st three CVs.  Use a curve info\n# node if the curve is a result of a construction history operation.\ncmds.getAttr( \'curve1.cv[*]\' )\n\n# This returns the local x,y,z of all CVs.  Use a curve info node if\n# the curve is a result of a construction history operation.\ncmds.getAttr( \'curve1.cv[0:2]\' )\n\n# This returns the arc length of the curve.  Use "-ch" flag with\n# the arclen command to get a curve info node that constantly updates\n# to the current arc length.\ncmds.arclen( \'curve1\' )\n\n# This sequence creates a curve info node, connects the info node to the\n# curve and queries the knot vector of the curve using the curve info node.\n# You can use the curve info node to query other attributes such as\n# world space CV values and arc length.\ncmds.createNode( \'curveInfo\' )\ncmds.connectAttr( \'curveShape1.worldSpace\', \'curveInfo1.inputCurve\' )\ncmds.getAttr( \'curveInfo1.knots[*]\' )',
 'curveAddPtCtx': 'import maya.cmds as cmds\n\n# To create a new context:\ncmds.curveAddPtCtx("CurveAddPtCtx")\ncmds.setToolTo("CurveAddPtCtx")',
 'curveBezierCtx': '',
 'curveCVCtx': 'import maya.cmds as cmds\n\n# To create a new context that will create curves of degree 5:\ncmds.curveCVCtx( "curveCVContext", degree=5 )\ncmds.setToolTo("curveCVContext")\n\n# To query the degree of an existing context:\ncmds.curveCVCtx( "curveCVContext", q=True, degree=True )\n\n# To edit the degree of an existing context:\ncmds.curveCVCtx( "curveCVContext", , e=True, degree=7 )',
 'curveEPCtx': "import maya.cmds as cmds\n\n# To create a new context that will create curves of degree 5:\ncmds.curveEPCtx( degree=5 )\n\n# To query the degree of an existing context:\ncmds.curveEPCtx( 'curveEPCtx1', q=True, degree=True )\n\n# To edit the degree of an existing context:\ncmds.curveEPCtx( 'curveEPCtx1', e=True, degree=7 )",
 'curveEditorCtx': "import maya.cmds as cmds\n\n# Create a curve\ncmds.curve(p=[(0, 0, 0), (3, 5, 6), (5, 6, 7), (9, 9, 9), (12, 10, 2)], k=[0,0,0,1,2,2,2])\n# Result: curve1 #\n\n# Create a new curve editor context to modify the curve, then switch to it\n# You can modify the curve using the manipulator handle\ncmds.curveEditorCtx('curveEditorCtx1')\ncmds.setToolTo('curveEditorCtx1')",
 'curveIntersect': 'import maya.cmds as cmds\n\ncmds.curveIntersect( \'curve1\', \'curve2\' )\n# Returns the parameter values that the curves intersect at.\n# eg. if 6 parameter values are returned, the first 3 are\n# on curve1 and the last 3 are on curve2.\n\n\ncmds.curveIntersect( \'curve1\', \'curve2\', useDirection=True, direction=(0, 1, 0) )\n# Returns the parameter values that the curves intersect at\n# when projected along vector (0, 1, 0).  This is useful\n# for example when you are viewing the two curves in an orthographic\n# view and the curves appear to intersect, even though\n# they do not intersect in 3D.\n\nnode = cmds.curveIntersect(\'curve1\', \'curve2\', ch= True)\np1 = cmds.getAttr(node + ".parameter1" )   # or use ".p1"\np2 = cmds.getAttr(node + ".parameter2" )   # or use ".p2"\n# Returns a string which is the name of a new curveIntersect\n# dependency node.\n# The "getAttr" commands return the parameter values at\n# which the curves intersect each other.',
 'curveMoveEPCtx': "import maya.cmds as cmds\n\n# Create a curve\ncmds.curve(p=[(0, 0, 0), (3, 5, 6), (5, 6, 7), (9, 9, 9), (12, 10, 2)], k=[0,0,0,1,2,2,2])\n# Result: curve1 #\n\n# Change the selection mode to components, and set edit-point selection mask on only\ncmds.selectMode(co=True)\ncmds.selectType(allComponents=False, editPoint=True)\n\n# Create a new curve edit point editor context, then switch to it\n# You can move the edit points using manipulator\ncmds.curveMoveEPCtx('curveMoveEPCtx1')\ncmds.setToolTo('curveMoveEPCtx1')",
 'curveOnSurface': 'import maya.cmds as cmds\n\n# These commands create curves with four control vertices.\n# The first one is created without weights.  The third command\n# shows how you can use units to specify position.\ncmds.curve( p=[(0, 0, 0), (3, 5, 6), (5, 6, 7), (9, 9, 9)] )\ncmds.curve( pw=[(0, 0, 0, 1), (3, 5, 6, 1), (5, 6, 7, 1), (9, 9, 9, 1)] )\ncmds.curve( p=[(\'0cm\', \'0cm\', \'0cm\'), (\'3in\', \'5in\', \'6in\'), (\'5ft\', \'6ft\', \'7ft\'), (9, 9, 9)] )\n\n# This command replaces an existing curve, curve1, with the given points.\n# Do not use this flag on a curve that is a result of a construction\n# history operation.\ncmds.curve( \'curve1\', r=True, p=[(0, 0, 0), (3, 5, 6), (10, 12, 14), (9, 9, 9)] )\n\n# This command adds two CVs to an existing curve, curve1.\n# The "-ws" flag can be used if the specified CVs are in world space.\n# Do not use this flag on a curve that is a result of a construction\n# history operation.\ncmds.curve( \'curve1\', a=True, p=[(13, 13, 13), (13, 15, 16)] )\n\n# This command creates a curve with five control vertices,\n# with a knot vector. Notice that there must be\n# (number of CVs + degree - 1) knots and that the knot\n# vector must be non-decreasing.\ncmds.curve( p=[(0, 0, 0), (3, 5, 6), (5, 6, 7), (9, 9, 9), (12, 10, 2)], k=[0,0,0,1,2,2,2] )\n\n# This command creates a closed (or "periodic") curve with\n# four distinct CVs. You must specify a knot vector when the\n# "-per" flag is used. Notice that the first "degree" points\n# are the same as the last "degree" points (ie. the first three\n# points are the same as the last three points). Notice also\n# that the knot spacing between the first "degree" knots must\n# be the same as the spacing between the last "degree" knots\n# (ie. the space between the 1st and 2nd knots is the same as\n# the space between the 7th and 8th knots, and the space between\n# the 2nd and 3rd knots is the same as the space between the\n# 8th and 9th knots). There must be space between the first\n# "degree" knots, unlike the previous example, where the first\n# "degree" knots are the same.\ncmds.curve( per=True, p=[(0, 0, 0), (3, 5, 6), (5, 6, 7), (9, 9, 9), (0, 0, 0), (3, 5, 6), (5, 6, 7)], k=[-2,-1,0,1,2,3,4,5,6] )\n\n# How to query curve properties:\n\n# This returns the degree of the curve.  Note that the\n# number of CVs = degree + spans.\ncmds.getAttr( \'curve1.degree\' )\n\n# This returns the number of spans in the curve.  Note that the\n# number of CVs = degree + spans.\ncmds.getAttr( \'curve1.spans\' )\n\n# This returns the curve form.\ncmds.getAttr( \'curve1.form\' )\n\n# This returns the minimum parameter value on the curve.\ncmds.getAttr( \'curve1.minValue\' )\n\n# This returns the maximum parameter value on the curve.\ncmds.getAttr( \'curve1.maxValue\' )\n\n# This returns the local x,y,z of the 1st CV.  Use a curve info node if\n# the curve is a result of a construction history operation.\ncmds.getAttr( \'curve1.cv[0]\' )\n\n# This returns the local x,y,z of the 1st three CVs.  Use a curve info\n# node if the curve is a result of a construction history operation.\ncmds.getAttr( \'curve1.cv[*]\' )\n\n# This returns the local x,y,z of all CVs.  Use a curve info node if\n# the curve is a result of a construction history operation.\ncmds.getAttr( \'curve1.cv[0:2]\' )\n\n# This returns the arc length of the curve.  Use "-ch" flag with\n# the arclen command to get a curve info node that constantly updates\n# to the current arc length.\ncmds.arclen( \'curve1\' )\n\n# This sequence creates a curve info node, connects the info node to the\n# curve and queries the knot vector of the curve using the curve info node.\n# You can use the curve info node to query other attributes such as\n# world space CV values and arc length.\ncmds.createNode( \'curveInfo\' )\ncmds.connectAttr( \'curveShape1.worldSpace\', \'curveInfo1.inputCurve\' )\ncmds.getAttr( \'curveInfo1.knots[*]\' )\n\ncmds.curveOnSurface( \'surface1\', d=3, uv=((0, 0),(0.3, 0.5), (0.5, 0.6), (0.9, 1.0)) )\n# This command creates a curve-on-surface of degree three with\n# four control vertices on surface1.\n\ncmds.curveOnSurface( \'surface1\', uv=((0, 0), (0.3, 0.5), (0.5, 0.6), (0.7, 0.8), (1.0, 1.0)), k=(0, 0, 0, 1, 2, 2, 2) )\n# This command creates a curve-on-surface with five CVs\n# and a knot vector, on surface1. Notice that there must be\n# (number of CVs + degree - 1) knots and that the knot\n# vector must be non-decreasing.\n\ncmds.curveOnSurface( \'surface1\', degree=3, per=True, uv=((0, 0), (0.2, 0.6), (0.4, 0.7), (0.9, 0.9), (0.0, 0.0), (0.2, 0.6), (0.4, 0.7)), k=(-2, -1, 0, 1, 2, 3, 4, 5, 6) )\n# This command creates a closed (or "periodic") curve-on-surface with\n# four distinct CVs. You must specify a knot vector when the\n# "-per" flag is on. Notice that the first "degree" points\n# are the same as the last "degree" points (ie. the first three\n# points are the same as the last three points). Notice also\n# that the knot spacing between the first "degree" knots must\n# be the same as the spacing between the last "degree" knots\n# (ie. the space between the 1st and 2nd knots is the same as\n# the space between the 7th and 8th knots, and the space between\n# the 2nd and 3rd knots is the same as the space between the\n# 8th and 9th knots). There must be space between the first\n# "degree" knots, unlike the previous example, where the first\n# "degree" knots are the same.\n\ncmds.curveOnSurface( \'surface1->curve1\', append=True, uv=(1.0, 1.0) )\n# This command appends a point to an existing curve-on-surface.\n# Notice that the curve-on-surface is specified, not just the surface.\n\ncmds.curveOnSurface( \'surface1->curve1\', replace=True, d=1, uv=((1.0, 1.0), (2.0, 2.0)) )\n# This command replaces an existing curve, surface1->curve1, with a\n# new curve of degree 1 having the given points. Do not use this\n# flag on a curve that is a result of a construction history operation.',
 'curveRGBColor': 'import maya.cmds as cmds\n\n# Set all "translateX" curves to draw magenta\ncmds.curveRGBColor( \'translateX\', 1, 0, 1 )\n\n# Set all curves whose names end in "Y" to draw yellow\ncmds.curveRGBColor( \'*Y\', 1, 1, 0 )\n\n# Remove the custom color for "translateX" curves\n# (which will revert to the standard UI color)\ncmds.curveRGBColor( r=True, \'translateX\' )\n\n# List the currently defined custom curve colors\ncmds.curveRGBColor( list=True )',
 'curveSketchCtx': 'import maya.cmds as cmds\n\n# To create a new sketch context, which creates degree 3 curves:\ncmds.curveSketchCtx( "pencilContext", degree=3 )\ncmds.setToolTo("pencilContext")\n\n# To query the degree of an existing context:\ncmds.curveSketchCtx( "pencilContext",q=True, degree=True )\n\n# To edit the degree of an existing context:\ncmds.curveSketchCtx( "pencilContext", e=True, degree=1 )',
 'cutKey': 'import maya.cmds as cmds\n\n# Keys on animation curves are identified by either\n# their time values or their indices.  Times and indices can\n# be given as a range or list of ranges.\n\n# time=(\'10pal\',\'10pal\') means the key at frame 10 (PAL format).\n# time=[(\'1.0sec\',\'1.0sec\'),(\'15ntsc\',\'15ntsc\'),(20,20)] means the keys at time 1.0 second, frame 15 (in NTSC format), and time 20 (in the currently defined global time unit).\n# time=(10,20) means all keys in the range from 10 to 20, inclusive, in the current time unit.\n# Omitting one end of a range means "go to infinity", as in the following examples:\n# time=(10,None) means all keys from time 10 (in the current time unit) onwards.\n# time=(10,) means the same as (10,10)\n# time=(0,10) means all keys up to (and including) time 10 (in the current time unit).\n# time=(None,None) is a short form to specify all keys.\n# index=(0,0) means the first key of each animation curve. (Indices are 0-based.)\n# index=[(2,2),(5,5),(7,7)] means the 3rd, 6th, and 8th keys.\n# index=(1,5) means the 2nd, 3rd, 4th, 5th, and 6th keys of each animation curve.\n\n# Cut keyframes from frame 10 to 20 of cube1\'s "Translate X" attribute\n#\ncmds.cutKey( \'cube1\', time=(10,20), attribute=\'translateX\', option="keys" )\n\n# Cut from all active objects all keys in the range 0 to 60\n#\ncmds.cutKey( time=(0,60) )',
 'cycleCheck': 'import maya.cmds as cmds\n\n# Print a message if xNode.tx is in a cycle.\ncmds.createNode( \'transform\', n=\'xNode\' )\nif cmds.cycleCheck(\'xNode.tx\') > 0:\n  print(\'xNode.tx is in a cycle\')\n\n# Get the list of plugs in a cycle with xNode.ty\ncmds.connectAttr( \'xNode.tx\', \'xNode.ty\' )\ncmds.connectAttr( \'xNode.ty\', \'xNode.tx\' )\ncycles = cmds.cycleCheck()\n\n# Print a message if there are any cycles in the graph.\nif cmds.cycleCheck(all=True, tl=\'10sec\') > 0:\n  print("Your graph has a cycle.")\nelse:\n  print("Your graph probably does not have a cycle")\n\n# List all cycles involving the DG and DAG hierarchy.\ncmds.cycleCheck(all=True,dag=True,l=True )',
 'cylinder': "import maya.cmds as cmds\n\ncmds.cylinder()\ncmds.cylinder( ch=True, radius=10, hr=3 )\ncmds.cylinder( r=5, axis=(1, 1, 1), pivot=(0, 0, 1), ssw='0deg', esw='90deg' )\ncmds.cylinder( ut=True, tol=0.01 )\n\n#Query the radius of the selected cylinder\nr = cmds.cylinder( q=True, r=True )",
 'dagCommandWrapper': '',
 'dagObjectCompare': 'import maya.cmds as cmds\n\n# Compare two objects based on type and their relatives where one is in the namespace "base":\ncmds.dagObjectCompare( t=True, r=True, n="base" )\n\n# Compare two objects based on their connections and attributes where one is in the namespace "base" , break on first error:\ncmds.dagObjectCompare( c=True, a=True, b="first")\n\n# Compare two objects based on their type, connections, attributes, relatives and break on error while finishing current category:\ncmds.dagObjectCompare( t=True, r=True, c=True, a=True, b=True, category=True, n="base")',
 'dagObjectHit': '',
 'dagPose': 'import maya.cmds as cmds\n\n# To create a pose for all objects parented above and below\n# the selected items.\n#\ncmds.dagPose( save=True )\n\n# To create a dagPose named "mypose" for the selected items only and not\n# the dag objects parented below the selected items.\n#\ncmds.dagPose( save=True, selection=True, name=\'mypose\' )\n\n# To restore the local (rather than global) mypose pose\n#\ncmds.dagPose( \'mypose\', restore=True )\n\n# To restore the mypose pose in global mode.\n#\ncmds.dagPose( \'mypose\', restore=True, global=True )\n\n# To query the members of the mypose pose.\n#\ncmds.dagPose( \'mypose\', query=True, members=True )\n\n# To return the name (if any) of the bindPose attached to the\n# selected items.\n#\ncmds.dagPose( q=True, bindPose=True )\n\n# To reset the pose data on a joint named bigToe for "mypose"\n#\ncmds.dagPose( \'bigToe\', reset=True, n=\'mypose\' )\n\n# To remove a joint named pinky from "mypose"\n#\ncmds.dagPose( \'pinky\', remove=True, n=\'mypose\' )\n\n# To restore the skeleton to its bindPose\n#\ncmds.dagPose( restore=True, global=True, bindPose=True )',
 'dataStructure': "import maya.cmds as cmds\n\nimport maya.cmds as cmds\ncmds.dataStructure( query=True, format=True )\n# Result: ['raw', 'debug'] #\n\ncmds.dataStructure( format='raw', asString='name=NameAndID:string=name:int32=ID' )\n# Result: 'NameAndID' #\n\n# Note that this file doesn't exist, it's just an example of how to read\n# from the file after you've created it. The file contents should look\n# like this:\n#\t\tname=FileBasedStructure\n#\t\tstring=fileInformation\ncmds.dataStructure( asFile='someFile.raw' )\n\ncmds.dataStructure( query=True )\n# Result: ['NameAndID', 'FileBasedStructure'] #\n\ncmds.dataStructure( name='NameAndID', format='raw', query=True, asString=True )\n# Result: 'name=NameAndID:string=name:int32=ID' #\n\ncmds.dataStructure( name='NameAndID', query=True, listMemberNames=True )\n# Result: [u'name', u'ID'] #\n\ncmds.dataStructure( name='NameAndID', query=True, listMemberNames=True, dataType=True )\n# Result: [u'name', u'string', u'ID', u'int32'] #\n\ncmds.dataStructure( remove=True, name='NameAndID' )\n# Result: 'NameAndID' #\n\ncmds.dataStructure( query=True )\n# Result: ['FileBasedStructure'] #\n\ncmds.dataStructure( removeAll=True )\n# Result: ['FileBasedStructure'] #",
 'date': "import maya.cmds as cmds\n\n# Get the current date and time\ncmds.date()\n# Result:2006/03/09 16:50:24 #\n\n# Get only the month and day\ncmds.date( shortDate=True )\n# Result:03/09 #\n\n# Get the date and time in a fancy format\ncmds.date( format='Year is YY (or YYYY), month is MM, day is DD. And it is now hh:mm:ss' )\n# Result:Year is 06 (or 2006), month is 03, day is 09. And it is now 16:53:20 #",
 'dbcount': 'import maya.cmds as cmds\n\n\ncmds.dbcount( e=\'on\' )              # Enable counters\ncmds.dbcount( )                     # Print all available counters\ncmds.dbcount( f=\'myCounts.txt\' )    # Print all available counters to the file "myCounts.txt"\ncmds.dbcount( k=\'dirty\' )           # Print all counters with "dirty" in their name\ncmds.dbcount( r=True, k=\'dirty\' )   # Reset counters with "dirty" in their name\ncmds.dbcount( l=True )              # List all counters\ncmds.dbcount( l=True, k=\'dirty\' )   # List all counters with "dirty" in their name\ncmds.dbcount( s=True, f=\'xls.txt\' ) # Print all counters in spreadsheet form to the file "xls.txt"',
 'dbfootprint': "import maya.cmds as cmds\n\ncmds.dbfootprint( query=True )\n# Result: ['nodes'] #",
 'dbmessage': 'import maya.cmds as cmds\n\n\ncmds.dbmessage( m=\'on\' )                  # Enable monitoring of all messages\ncmds.dbmessage( l=True )                  # Print all available messages and monitoring state\ncmds.dbmessage( f=\'msgs.txt\' )            # Redirect all message output to the file "msgs.txt"\ncmds.dbmessage( t=\'dgNodeAdded\', m=\'on\' ) # Turn on monitoring for the "dgNodeAdded" message',
 'dbpeek': 'import maya.cmds as cmds\n\nimport maya.cmds as cmds\n// Find the available peek operations\ncmds.dbpeek( op=True, query=True )\n# Return: [\'metadata\', \'nodes\', \'references\', \'plugIterator\'] #\n\n// Describe the detail of a single available operation\ncmds.dbpeek( query=True, op=\'nodes\' )\n# Return: \'\nPeek operation \'nodes\':\n    Normal display  will  show a count of nodes in the scene of each type.\nRecognized \'argument\' values:\n    attributes\n        Includes the attribute  count for each node as well, segregated by static, extension, and dynamic types.\n    visible\n        Filter the display  list to ignore any hidden or internal nodes. Default is to show all nodes.\n\'#\n\n# Describe the detail of a single available operation\ncmds.dbpeek( query=True, op=\'plugIterator\' )\n# Return: \'\nPeek operation \'plugIterator\':\n    This tests the performance of the class by iterating over all of the\n    networked plugs in a plug tree.\n    Suggested iteration count minimum is 1000000 for which the test machine\n    measured a time of 19.234s.\nThis operation does not take any arguments.\n\'#\n\ncmds.dbpeek( op=\'plugIterator\', count=10000 )\n# Return: \'Run 10,000 loops of plug iteration over a tree of size 51, depth 4\nTotal time:   17.0s\nMaximum time: 0.81s\nMinimum time: 0.23s\nAverage time: 0.30s\n\'#\n# Run a performance test for 1000000 loops and store the results\ncmds.dbpeek( op=\'plugIterator\', count=1000000, outputFile=\'MyFile.txt\' )\n# Return: 0 #\n\n\ncmds.loadPlugin( \'MetadataSample\' )\ncmds.polyPlane( name=\'planeLuck\' )\ncmds.dataStructure( asString=\'name=TestStructure:int32=ID )\ncmds.importMetadata( asString=\'channel face\\n stream\\n TestStream\\n TestStructure\\n 0\\n 99\\n 1\\n 999\\n 2\\n 9999\\n endStream\\n endChannel\\n endAssociations" "planeLuckShape\' )\n\n# Peek at the newly created metadata\n#\ncmds.dbpeek( op=\'metadata\', argument=\'summary\' )\n# Return: \'Node planeLuckShape : face( TestStream[3] )\' #',
 'dbtrace': 'import maya.cmds as cmds\n\n# The default action is to turn the trace object on.  This action can be\n# changed using one of the -off, -output, -mark, -query, or -title.\n\ncmds.dbtrace( off=True ) # turns all active tracing off\ncmds.dbtrace( k=\'key\' )  # turns on all tracing for keyword "key"\ncmds.dbtrace( o=\'FRED\' ) # sends all active tracing output to the file "FRED"\n\n# Inserts a title line in all active trace destinations having keyword \'key\'\ncmds.dbtrace( k=\'key\', t=\'This is a Title\' )\n\n# Only turn on traces with keyword "key" in Transform nodes\ncmds.dbtrace( k="key", f="transform" )\n\n# Show where output is going for all trace objects having keyword "fooTrace"\ncmds.dbtrace( query=True, k="fooTrace", output=True )',
 'debug': '',
 'debugNamespace': '',
 'debugVar': '',
 'defaultLightListCheckBox': "import maya.cmds as cmds\n\n# Create a window with a check box for at most 10 shading groups\n\ncmds.window( wh=(200, 100) )\ncmds.columnLayout( adj=True )\nseList = cmds.ls(type='shadingEngine')\nnumLines = min(len(seList), 10)\nfor i in range(numLines):\n    cmds.defaultLightListCheckBox( sg=seList[i], label=seList[i] )\ncmds.showWindow()",
 'defaultNavigation': 'import maya.cmds as cmds\n\n# Create a poly plane\ncmds.polyPlane(w=10, h=10, sx=10, sy=10, n=\'pPlane1\')\n\n# This will open the Create Render Node window from which you can select a node that you want to connect to the existing lambert1.color attribute\ncmds.defaultNavigation(createNew=True, destination=\'lambert1.color\')\n\n# Select the Checker Node, you will find "checker1.outColor" is connected to "lambert1.color"\n\n# Break the connection between "checker1.outColor" and "lambert1.color" you have just established\ncmds.disconnectAttr(\'checker1.outColor\', \'lambert1.color\')\n\n# Connect "checker1" to "lambert1". Only node is specified here, but the command will make a best guess.\n# So "checker1.outColor" and "lambert1.color" are connected\ncmds.defaultNavigation(connectToExisting=True, source=\'checker1\', destination=\'lambert1\')',
 'defineDataServer': 'import maya.cmds as cmds\n\ncmds.defineDataServer( s=\'ultratrak_server\', d=\'melvin\' )\n\n# Connects to the ultratrak_server running on the localhost and gives it\n# the name "melvin"\n\ncmds.defineDataServer( s=\'mocap_lab:5200\', d=\'labFlock\' )\n\n# Creates a device called "labFlock" which connects to the server running\n# on host "mocap_lab" at port "5200".\n\ncmds.defineDataServer( undefine=True, d=\'labFlock\' )\n\n# Delete the device "labFlock" closing the connection with the server\n# specified when it was created.',
 'defineVirtualDevice': "import maya.cmds as cmds\n\n#    Create a virtual clock and read in some data.\ncmds.defineVirtualDevice( create=True )\ncmds.defineVirtualDevice( channel='seconds', usage='rotZ', axis=2 )\ncmds.defineVirtualDevice( channel='minutes', usage='rotZ', axis=1 )\ncmds.defineVirtualDevice( channel='hours', usage='rotZ', axis=0 )\ncmds.defineVirtualDevice( device='virtualClock' )\ncmds.readTake( device='virtualClock', take='clock.mov' )\n\n#    Undefine the virtualClock\ncmds.defineVirtualDevice( device='virtualClock', undefine=True )\n\n#    Create a body device.\ncmds.defineVirtualDevice( create=True )\ncmds.defineVirtualDevice( channel='pelvis', usage='posRot' )\ncmds.defineVirtualDevice( channel='back', usage='posRot' )\ncmds.defineVirtualDevice( channel='head', usage='posRot' )\ncmds.defineVirtualDevice( device='body' )\n\n#    Explicitly order the axis of the device. The created device is\n#    the same as the above body device.\ncmds.defineVirtualDevice( create=True )\ncmds.defineVirtualDevice( channel='head', usage='posRot', axis=12 )\ncmds.defineVirtualDevice( channel='back', usage='posRot', axis=6 )\ncmds.defineVirtualDevice( channel='pelvis', usage='posRot', axis=0 )\ncmds.defineVirtualDevice( device='body' )",
 'deformableShape': 'import maya.cmds as cmds\n\n    # Create an original geometry if it does not exist\n    cmds.deformableShape(\'ball\', cog=True)\n\n    import maya.cmds as cmds\n\n    cmds.polyCylinder(n="myGeo", r=1, h=6, sx=4, sy=5, sz=1)[0]\n    cmds.select([\'myGeo.vtx[12:23]\', \'myGeo.vtx[25]\'])\n\n    clusterNode, clusterHandle = cmds.cluster()\n    cmds.move(1.0, 0, 0, clusterHandle, absolute=True)\n\n    # Get the node chain leading up to the shape\n    cmds.deformableShape(\'myGeoShape\', nch=True)\n    # Result: [u\'polyCylinder1\', u\'myGeoShapeOrig\', u\'groupParts2\', u\'tweak1\', u\'cluster1GroupParts\', u\'cluster1\', u\'myGeoShape\'] #\n\n    # Get the deformer chain leading up to the shape\n    cmds.deformableShape(\'myGeoShape\', ch=True)\n    # Result: [u\'tweak1\', u\'cluster1\'] #\n\n    # Get the plug chain leading up to the shape\n    cmds.deformableShape(\'myGeoShape\', pch=True)\n    # Result: [u\'polyCylinder1.output\', u\'myGeoShapeOrig.inMesh\', u\'myGeoShapeOrig.worldMesh[0]\', u\'groupParts2.inputGeometry\', u\'groupParts2.outputGeometry\', u\'tweak1.input[0].inputGeometry\', u\'tweak1.outputGeometry[0]\', u\'cluster1GroupParts.inputGeometry\', u\'cluster1GroupParts.outputGeometry\', u\'cluster1.input[0].inputGeometry\', u\'cluster1.outputGeometry[0]\', u\'myGeoShape.inMesh\'] #\n\n    # Get the output plug chain leading up to the shape\n    cmds.deformableShape(\'myGeoShape\', och=True)\n    # Result: [u\'polyCylinder1.output\', u\'myGeoShapeOrig.worldMesh[0]\', u\'groupParts2.outputGeometry\', u\'tweak1.outputGeometry[0]\', u\'cluster1GroupParts.outputGeometry\', u\'cluster1.outputGeometry[0]\'] #',
 'deformer': 'import maya.cmds as cmds\n\n# Select the geometries that you\'d like to deform,\n# and use the deformer command as follows. For example, to deform a\n# cylinder with a deltaMush:\n#\ncmds.cylinder( ax=(0, 1, 0), r=1, hr=10, d=3, s=8, nsp=20, ch=1 )\ncmds.select( \'nurbsCylinder1\', r=True )\ncmds.deformer( type="deltaMush" )\n\n# To query the membership of the deformer\n#\ncmds.deformer( \'deltaMush1\',q=True, g=True )\n\n# To add additional geometries from your deformer, type:\n#\ncmds.select( \'nurbsCylinder1\', r=True )\ncmds.duplicate()\n# Result: nurbsCylinder2 #\ncmds.move( -2.749017, 0, 0, r=True )\ncmds.deformer( \'deltaMush1\', e=True, g=\'nurbsCylinder2\' )\n\n# To remove a geometry from your deformer, type:\n#\ncmds.deformer( \'deltaMush1\', e=True, rm=True, g=\'nurbsCylinder2\' )\n\n# To query the components and the selected components used by the deformer\ncmds.polyCylinder(r=1, h=6, sx=6, sy=1, sz=1)\ncmds.select([\'pCylinder1.vtx[6:11]\', \'pCylinder1.vtx[13] \'], r=True)\ncmds.cluster()\n\ncmds.select([\'pCylinder1.vtx[4:5]\', \'pCylinder1.vtx[10:11] \'], r=True)\ncmds.deformer(\'cluster1\', q=True, cmp=True)\n# Result: [\'pCylinder1.vtx[6:11]\', \'pCylinder1.vtx[13]\'] #\ncmds.deformer(\'cluster1\', q=True, cms=True)\n# Result: [\'pCylinder1.vtx[10:11]\'] #',
 'deformerWeights': "import maya.cmds as cmds\n\n\nimport maya.cmds as cmds\n\ndef createRig(nsp='nsp1', res=5):\n    # Create a plane with two clusters in a namespace.\n    #\n    cmds.polyPlane( ch=1, w=10, h=10, sx=res, sy=res, ax=(0,1,0), name='%s:myShape'%nsp )\n    cmds.cluster('%s:myShape'%nsp, name='%s:clusterA'%nsp)\n    cmds.cluster('%s:myShape'%nsp, name='%s:clusterB'%nsp)\n\n#--------------------------------------------------------------------\n# Create the setup\n#--------------------------------------------------------------------\n\n# Clear file.\ncmds.file( f=True,new=True )\n\n# Create plane and two clusters.\ncreateRig(nsp='nsp1')\n\n# Modify some weights on clusterA.\ncmds.select( ['nsp1:myShape.vtx[6:11]'])\ncmds.percent( 'nsp1:clusterA', v=0.5 )\n\n# Modify some weights on clusterB.\n#\ncmds.select( ['nsp1:myShape.vtx[0:2]','nsp1:myShape.vtx[6:8]','nsp1:myShape.vtx[12:14]'])\ncmds.percent( 'nsp1:clusterB', v=0.3 )\n\n\n#--------------------------------------------------------------------\n# Export the weights in a variety of different ways\n#--------------------------------------------------------------------\n\n# Write cluster A weights.\n#\ncmds.deformerWeights ('clusterA.xml', ex=True, deformer='nsp1:clusterA')\n\n# Write cluster B weights, but do not write values of 1.0.\n#\ncmds.deformerWeights ('clusterB.xml', ex=True, deformer='nsp1:clusterB', dv=1.0)\n\n# Write cluster A and B weights at the same time.\n#\ncmds.deformerWeights ('clusterAB.xml', ex=True, deformer=['nsp1:clusterA', 'nsp1:clusterB'])\n\n# Export weights for all deformers on the shape, including vertex connections.\n#\ncmds.deformerWeights ('shape_all.xml', ex=True, sh='nsp1:myShape', vc=True)\n\n# Same as above skipping deformers matching '*B'.\n#\ncmds.deformerWeights ('shape_NotB.xml', ex=True, sh='nsp1:myShape', vc=True, sk='*B')\n\n# Export weights and attributes.\n#\nattributes = ['envelope', 'percentResolution', 'usePartialResolution']\ncmds.deformerWeights ('shape_all_attr.xml',ex=True, sh='nsp1:myShape', vc=True, at=attributes)\n\n# Export name space nsp1: in scene to nsp2: in xml.\ncmds.deformerWeights ('shape_all_nsp2.xml', ex=True, sh='nsp1:myShape', vc=True, remap='nsp1:(.*);nsp2:$1')\n\n\n#--------------------------------------------------------------------\n# Import the weights\n#--------------------------------------------------------------------\n\n# Read both cluster's weight files separately.\ncmds.deformerWeights('clusterA.xml', im=True, sh='nsp1:myShape', deformer='nsp1:clusterA')\ncmds.deformerWeights('clusterB.xml', im=True, sh='nsp1:myShape', deformer='nsp1:clusterB')\n\n# Read both deformers from the single file.\ncmds.deformerWeights('shape_all.xml', im=True, sh='nsp1:myShape', deformer=['nsp1:clusterA', 'nsp1:clusterB'])\n\n# Alternative way of reading both deformers.\ncmds.deformerWeights('shape_all.xml', im=True, deformer=['nsp1:clusterA', 'nsp1:clusterB'])\n\n# Read clusterA from the file containing both clusters.\ncmds.deformerWeights('shape_all.xml', im=True, deformer='nsp1:clusterA')\n\n#\n# Create the same rig in a different namespace.\n#\ncreateRig(nsp='nsp2')\n\n# Import weights from file that remapped the namespace on export.\ncmds.deformerWeights('shape_all_nsp2.xml', im=True, sh='nsp2:myShape', deformer=['nsp2:clusterA', 'nsp2:clusterB'])\n\n# Import weights from file containing a different namespace, and remap the namespace on import.\ncmds.deformerWeights('shape_all.xml', im=True, sh='nsp2:myShape', deformer=['nsp2:clusterA', 'nsp2:clusterB'], remap='nsp1:(.*);nsp2:$1')\n\n#\n# Create similar rig with different resolution (topology) in a different namespace.\n#\ncreateRig(nsp='nsp3', res=8)\n\n# Import weights from file, remap the namespace on import, and use the barycentric method to remap the weight values.\ncmds.deformerWeights('shape_all.xml', im=True, sh='nsp3:myShape', deformer=['nsp3:clusterA', 'nsp3:clusterB'], remap='nsp1:(.*);nsp3:$1', method='barycentric')",
 'delete': "import maya.cmds as cmds\n\n# To delete selected objects use:\ncmds.delete()\n\n# To delete a few specific objects like surfaceShape1, surface1 and\n# paramCurve1 use:\ncmds.delete( 'surfaceShape1', 'surface1', 'paramCurve1' )\n\n# To delete all channels in the scene:\ncmds.delete( all=True, c=True )\n\n# To delete static channels connected to selected nodes:\ncmds.delete( sc=True )\n\n# To delete motion path nodes connected to selected nodes:\ncmds.delete( mp=True )\n\n# To delete all expressions in the scene:\ncmds.delete( all=True, e=True )\n\n# To delete selected constraints and constraints attached to selected nodes:\ncmds.delete( cn=True )\n\n# Notes:\n\n# The at, h, s and cp flags only apply when either c/channels\n# or sc/staticChannels or e/expressions options are specified.",
 'deleteAttr': "import maya.cmds as cmds\n\ncmds.createNode( 'planet', n='mars' )\ncmds.addAttr( ln='martians', sn='mr', at='double' )\ncmds.addAttr( ln='greenMen', sn='gm', at='double' )\n\n# Delete an attribute named mr/martians.\ncmds.deleteAttr( 'mars', at='mr' )\n\n# Alternative syntax\ncmds.deleteAttr( 'mars.greenMen' )\n\n# Query for the list of dynamic attributes.\ncmds.deleteAttr( 'mars', q=True )",
 'deleteAttrPattern': 'import maya.cmds as cmds\n\nimport maya.cmds as cmds\ncmds.deleteAttrPattern( patternType="xmlPattern" )\n// Result: [myXMLPattern, myOtherXMLPattern] //\n\ncmds.deleteAttrPattern( patternName="myJSONPattern" )\n// Result: myJSONPattern //',
 'deleteExtension': "import maya.cmds as cmds\n\n\ncmds.addExtension( nodeType='planet', longName='martians', shortName='mr', attributeType='double' )\ncmds.createNode( 'planet', name='jupiter' )\ncmds.createNode( 'planet', name='mars' )\ncmds.setAttr( 'mars.mr', 35 )\n\n# Delete an extension attribute named mr/martians.\n# Only returns 1 since the planet node 'jupiter'\n# does not have a non-default value on the extension.\ncmds.deleteExtension( nodeType='planet', forceDelete=True, attribute='martians' )\n# Return: 1 //\n# The attribute is gone since it was forced out\ncmds.attributeQuery( type='planet', attribute='mr', query=True, exists=True )\n# Return: 0 //\n\n# Re-add and delete the extension again, forcing the\n# attribute to remain if non-default values exist.\ncmds.addExtension( nodeType='planet', longName='martians', shortName='mr', attributeType='double' )\ncmds.setAttr( 'mars.mr', 35 )\n\ncmds.deleteExtension( nodeType='planet', forceDelete=False, attribute='mr' )\n# Return: 0 //\n\n# The attribute still exists since it had some non-default values\ncmds.attributeQuery( type='planet', attribute='mr', query=True, exists=True )\n# Return: 1 //\ncmds.attributeQuery( name='jupiter', attribute='mr', query=True, exists=True )\n# Return: 1 //",
 'deleteUI': "import maya.cmds as cmds\n\n#    Example 1.\n#\n#    Create a simple window and then delete it and all of its children\n#    with one 'deleteUI -window' command.\n#\nwindow = cmds.window()\ncmds.paneLayout()\ncmds.button()\ncmds.showWindow( window )\n\ncmds.deleteUI( window, window=True )\n\n#    Example 2.\n#\n#    Create a window with a number of buttons and delete a few of the\n#    buttons with the 'deleteUI -control' command.\n#\nwindow = cmds.window()\ncmds.columnLayout()\ncmds.button()\ncmds.button()\ncmds.button()\nb1 = cmds.button()\nb2 = cmds.button()\nb3 = cmds.button()\ncmds.showWindow( window )\n\ncmds.deleteUI( b1, b2, b3, control=True )",
 'deltaMush': 'import maya.cmds as cmds\n\nimport maya.cmds as cmds\n\n# Create a poly sphere\ncmds.polySphere()\n\n# Attach a deltaMush deformer to the sphere performing\n# 20 smoothing iterations with a step of 0.8\ncmds.deltaMush( smoothingIterations=20, smoothingStep=0.8 )',
 'detachCurve': 'import maya.cmds as cmds\n\ncmds.detachCurve( \'curve1\', ch=True, p=0.2, replaceOriginal=False )\n# Detaches curve1 at parameter value 0.2.  The\n# result is two curves and a detachCurve dependency node.\n# The "-rpo" flag specifies that the original curve is not to be\n# replaced; as a result a new curve is created for each curve piece.\n# Note that if "k" flag is not used, then the default is that\n# all pieces are kept.\n\ncmds.detachCurve( \'curve1.ep[1]\', ch=True, replaceOriginal=False )\n# Detaches curve1 at its second edit point.\n\ncmds.detachCurve( \'curve1.u[0.2]\', ch=True, replaceOriginal=False )\n# Detaches curve1 at parameter value 0.2\n\ncmds.detachCurve( \'curve1\', ch=True, p=0.4, k=(1 , 0), rpo=False )\n# Detaches curve1 at parameter value 0.4 into two curves.  Because of\n# the "k" flags, two curves are created, but the second one is empty.\n# A detachCurve dependency node is also returned.\n\ncmds.detachCurve( \'curve1\', ch=True, p=(0.2, 0.4), rpo=True )\n# Detaches curve1 into three pieces.  Because the "rpo" flag is on,\n# the original curve is replaced with the first piece.  The names\n# of all curve pieces are returned.  If curve1 is a result of history,\n# then a dependency node is created and its output is connected as\n# the input to curve1.  If curve1 is not a result of construction\n# history, then a dependency node is not created (even though the\n# "ch" flag is on).\n\ncmds.detachCurve( \'circle1\', ch=True, p=(0.2, 0.4) )\n# Detaches a periodic curve, circle1, at two places.  Before\n# the detach, the circle is periodic, with a start parameter of 0.0,\n# and an end parameter of 8.0.\n# The first parameter, 0.2, is used to move the start point of the curve,\n# also called the "seam".  The second parameter, 0.4, is used to perform\n# a detach operation.  The result is TWO curves only.  The first curve\n# has a parameter range of 0.2 to 0.4.  The second curve has a parameter\n# range of 0.4 to 8.2.',
 'detachDeviceAttr': "import maya.cmds as cmds\n\ncmds.detachDeviceAttr( d='spaceball', ax='XAxis', at='translateX' )",
 'detachSurface': 'import maya.cmds as cmds\n\ncmds.detachSurface( \'surface1\', ch=True, d=1, p=0.3, rpo=False )\ncmds.detachSurface( \'surface1.u[0.3]\', ch=True )\n# Detaches surface1 into two pieces at u = 0.3.\n# The results are two surface pieces, and a detachSurface dependency node.\n# Since no "-keep" flag is used, all pieces are kept.\n\ncmds.detachSurface( \'surface1\', ch=True, k=(1,0), rpo=False, p=0.34, d=0 )\ncmds.detachSurface( \'surface1.v[0.34]\', ch=True, k=(1,0), rpo=False )\n# Detaches surface1 at v = 0.34.  Because of the "k" flags, two\n# surfaces are created but the second surface is empty.  A\n# detachSurface dependency node is also returned.\n\ncmds.detachSurface( \'surface1\', ch=True, rpo=True, p=(0.2, 0.5), d=1 )\ncmds.detachSurface( \'surface1.u[0.2]\', \'surface1.u[0.5]\', ch=True, rpo=True )\n# Detaches surface1 into three pieces.  Because of the "-rpo" flag,\n# the first surface piece is used to replace the original surface1.\n# The results are the three surfaces (including the original surface).\n# Even though the "ch" flag is on, a dependency node is not created\n# if surface1 is not a result of construction history.  If surface1\n# is the result of construction history, then a dependency node is\n# created and its name is returned.\n\ncmds.detachSurface( \'cylinder1\', ch=True, d=0, p=0.3, rpo=False )\n# Detaches cylinder1, which is periodic in V, where the V parameter\n# ranges between 0.0 and 8.0.  The parameter, 0.3, is used to move\n# the start point of the cylinder, also known as the "seam".\n# The resulting surface\'s V parameter range is 0.0 to 0.3.\n\ncmds.detachSurface( \'cylinder1\', ch=True, d=0, p=(0.3, 0.7), rpo=False )\n# Detaches cylinder1, which is periodic in V, where the V parameter\n# ranges between 0.0 and 8.0.  The 1st parameter, 0.3, is used to move\n# the start point of the cylinder, also known as the "seam".\n# The second parameter, 0.7, is used to detach the cylinder again.\n# The result is only TWO surfaces; the first surface\'s V parameter ranges\n# from 0.0 to 0.3. The second surface\'s V parameter ranges from 0.3 to 0.7.',
 'deviceEditor': "import maya.cmds as cmds\n\n# This example creates a new device editor in its own window\nwindow = cmds.window()\ncmds.paneLayout()\ncmds.deviceEditor('myDeviceEditor')\ncmds.showWindow( window )",
 'deviceManager': 'import maya.cmds as cmds\n\n\n# FIXME: get python sytax for above query.\ncmds.deviceManager("layer1", root=True)',
 'devicePanel': 'import maya.cmds as cmds\n\n# This example creates a new device panel in its own window\nwindow = cmds.window()\ncmds.paneLayout()\ncmds.devicePanel()\ncmds.showWindow( window )',
 'dgControl': '',
 'dgInfo': "import maya.cmds as cmds\n\n# create a node\ncmds.createNode('transform',name='NODE')\ncmds.setKeyframe('NODE.translate')\n\n# Print all things connected to node NODE\ncmds.dgInfo( 'NODE', c=True )\n\n# Print all connections currently in the graph\ncmds.dgInfo( c=True, all=True )\n\n# Print the datablock size of all nodes currently in the graph\ncmds.dgInfo( sz=True, all=True )\n# Return: [12, 12, 12314]\n\n# Print all connections to attribute tx on node NODE\ncmds.dgInfo('NODE.tx',c=True)\n\n# Print all dirty connections in the entire graph\ncmds.dgInfo( c=True, all=True, d=True )",
 'dgPerformance': '',
 'dgValidateCurve': 'import maya.cmds as cmds\n\n\n# Check all curves.\n#\ncmds.dgValidateCurve(allCurves=True);\n# Result: 123 #',
 'dgcontrol': '',
 'dgdebug': '',
 'dgdirty': 'import maya.cmds as cmds\n\n\n# Set everything in the entire scene dirty\n#\ncmds.dgdirty(allPlugs=True);\n# Result: 123 #\n\n# Set all connected plugs dirty on "myNode"\n# 5 plugs were set dirty\n#\ncmds.dgdirty( \'myNode\' )\n# Result: 5 #\n\n# Set all connected plugs dirty on "locator1"\n# 0 plugs were connected so no dirty message was sent\n#\ncmds.dgdirty( \'locator1\' )\n# Result: 0 #\n\n\n# Set myNode.tx dirty\ncmds.select( \'myNode.tx\' )\ncmds.dgdirty()\n# Result: 1 #\n\n# Show the dirty elements in the node\ncmds.dgdirty( list=\'data\' )\n# Result: [myNode.tx] #\n\n# Show plugs with dirty state, if any\ncmds.dgdirty( list=\'plug\' )\n# Result: [myNode.tx, myNode.ty] #\n\n# Show plugs with dirty connections, if any\ncmds.dgdirty( list=\'connection\' )\n# Result: [myNode.ty] #\n\n# Show the types of list parameters available\ncmds.dgdirty( query=True, list=True )\n# Result: [\'d/data\', \'p/plug\', \'c/connection\']\n\n# Show the types of list parameters available with timing\ncmds.dgdirty( query=True, list=True, showTiming=True )\n# Messages took 8 microseconds to process.\n# Result: [\'d/data\', \'p/plug\', \'c/connection\']',
 'dgeval': 'import maya.cmds as cmds\n\n# Evaluate all (connected) plugs on "myNode"\ncmds.dgeval( \'myNode\' )\n# Result: 5\n# This means that 5 plugs were evaluated\n\n# Evaluate myNode.tx only\ncmds.select( \'myNode.tx\' )\ncmds.dgeval()\n# Result: 1',
 'dgfilter': 'import maya.cmds as cmds\n\n# Define attribute filter on translateX\ncmds.dgfilter( atr=\'translateX\', n=\'TX\' )\n# Result: "TX"\n\n# Define plug filter on node.ty\ncmds.dgfilter( plug=\'node.ty\', n=\'TY\' )\n# Result: "TY"\n\n# Define logical \'OR\' filter.\ncmds.dgfilter( logicalOr=(\'TX\', \'TY\'), n=\'OR\' )\n# Result: "OR"\n\ncmds.polyCube()\n# Result: [u\'pCube1\', u\'polyCube1\'] #\ncmds.polyCube()\n# Result: [u\'pCube2\', u\'polyCube2\'] #\n\n# Filter passes since attribute matches\ncmds.dgfilter( \'pCube1.tx\', n=\'TX\' )\n# Result: 1\n\n# Filter passes since TX portion succeeds\ncmds.dgfilter( \'pCube1.tx\', n=\'OR\' )\n# Result: 1\n\n# Filter fails ; wrong attributes\ncmds.dgfilter( \'pCube1.tz\', n=\'OR\' )\n# Result: 0\n\n# Filter fails ; wrong node\ncmds.dgfilter( \'pCube2.ty\', n=\'TY\' )\n# Result: 0\n\n# Filter passes\ncmds.dgfilter( \'pCube1.ty\', n=\'TY\' )\n# Result: 1\n\n# List filters available\ncmds.dgfilter( list=True )\n# Result: [u\'TX\', u\'TY\', u\'OR\'] #\n\n# Show filter information\ncmds.dgfilter( list=True, n=\'OR\' )\n# Result: LogicalOr( AttributeName(translateX), PlugName(node.ty) )',
 'dgmodified': 'import maya.cmds as cmds\n\n# list all modified nodes\ncmds.dgmodified()',
 'dgstats': '',
 'dgtimer': "import maya.cmds as cmds\n\n# Turns on node timing and resets the timers.\ncmds.dgtimer( on=True )\n\n# Turns off node timing. Note that this does not reset the\n# timers.\ncmds.dgtimer( off=True )\n\n# Prints the current timer values to the default (stdout).\ncmds.dgtimer( query=True )\n\n# To reset the timers:\ncmds.dgtimer( reset=True )\n\n# Turn on node timing and reset the timer values to zero.\n# Then, playback the scene, turn off timing and dump to a file.\n# Turn on timing without resetting the timers, and repeat.\ncmds.dgtimer( on=True, reset=True )\ncmds.play( wait=True )\ncmds.dgtimer( off=True )\ncmds.dgtimer( outputFile='/home/virginia/timing/dgtrace_once.txt', query=True )\ncmds.dgtimer( on=True )\ncmds.play( wait=True )\ncmds.dgtimer( off=True )\ncmds.dgtimer( outputFile='/home/virginia/timing/dgtrace_twice.txt', query=True )",
 'dimWhen': "import maya.cmds as cmds\n\n#    Create a window with a menu item and button that will dim if\n#    there are no objects selected in the scene.\n#\nwindow = cmds.window(menuBar=True, title='dimWhen Example')\ncmds.menu( label='Edit' )\nmenuItem = cmds.menuItem(label='Delete Selection', command='cmds.delete()')\ncmds.columnLayout(adjustableColumn=True)\nbutton = cmds.button(label='Delete Selection', command='cmds.delete()')\n\n#    Create a few buttons to create some objects, select all the objects in\n#    the scene, and clear the selection.\n#\ncmds.button(label='Create Objects', command='cmds.sphere(); cmds.cone(); cmds.cylinder();')\ncmds.button(label='Select All', command='cmds.select(all=True)')\ncmds.button(label='Select Nothing', command='cmds.select(clear=True)')\n\n#    Add the dim conditions.\n#\ncmds.dimWhen( 'SomethingSelected', button, false=True )\ncmds.dimWhen( 'SomethingSelected', menuItem, false=True )\n\ncmds.showWindow( window )",
 'directConnectPath': '',
 'directKeyCtx': "import maya.cmds as cmds\n\n# Create a directKeyCtx which works in insert mode\n#\ncmds.directKeyCtx( 'specialDirectKeyContext', option='insert' )",
 'directionalLight': 'import maya.cmds as cmds\n\n# Create a directional light\nlight = cmds.directionalLight(rotation=(45, 30, 15))\n\n# Change the light intensity\ncmds.directionalLight( light, e=True, intensity=0.5 )\n\n# Query it\ncmds.directionalLight( light, q=True, intensity=True )\n# Result:0.5#',
 'dirmap': 'import maya.cmds as cmds\n\ncmds.dirmap( en=True )\ncmds.dirmap( m=(\'/usr/maya/textures\', \'/share/store/textures\') )\ncmds.dirmap( cd=\'/usr/maya/textures/characters/skin1.iff\' )\n# Result: /share/store/textures/characters/skin1.iff"\ncmds.dirmap( m=(\'D:/mySoundfiles\', \'/usr/me/sounds\') )\ncmds.dirmap( cd=\'D:/mySoundfiles/\' )\n# Result: /usr/me/sounds/',
 'disable': "import maya.cmds as cmds\n\ncmds.window()\ncmds.formLayout()\ncmds.button( 'fred' )\ncmds.showWindow()\ncmds.disable( 'fred' ) # dims the button\ncmds.disable( 'fred', v=False ) # un-dims it",
 'disableIncorrectNameWarning': 'import maya.cmds as cmds\n\ncmds.disableIncorrectNameWarning()',
 'disconnectAttr': "import maya.cmds as cmds\n\n#    Create a sphere and cone and connect their rotate attribute.\n#\nsph = cmds.sphere()\ncon = cmds.cone()\nsphereR = '%s.r' % sph[0]\nconeR = '%s.r' % con[0]\ncmds.connectAttr(sphereR, coneR)\n\n#    Break the connection between the rotate attributes.\n#\ncmds.disconnectAttr(sphereR, coneR)",
 'disconnectJoint': "import maya.cmds as cmds\n\ncmds.joint( p=(0, 0, 0), name='jointA' )\ncmds.joint( p=(0, 1, 0), name='jointB' )\ncmds.joint( p=(0, 2, 0), name='jointC' )\ncmds.disconnectJoint( 'jointB' )",
 'diskCache': "import maya.cmds as cmds\n\n# Explicitly specify the settings for disk cache\n# creation: the start time to 3 and the end time to 10.\ncmds.diskCache( startTime=3, endTime=10 )\n\n# Specify to use over sampling and with sampling\n# rate set to 2, sampling twice for each frame.\ncmds.diskCache( overSample=True, samplingRate=2 )\n\n# Delete all caches\ncmds.diskCache( deleteAll=True )\n\n# Clear the cache content for diskCache3's cache.\ncmds.diskCache( empty='diskCache3' )\n\n# Close all the disk caches.\ncmds.diskCache( emptyAll=True )",
 'dispatchGenericCommand': '',
 'displacementToPoly': 'import maya.cmds as cmds\n\n# To bake the rendered geometry and create a new meshShape, for the\n# selected geometry shape use:\ncmds.displacementToPoly()',
 'displayAffected': 'import maya.cmds as cmds\n\n# Turn on the display of affected objects\ncmds.displayAffected( True )\n\n# Query whether the display of affected objects is turned on:\ncmds.displayAffected( query=True )',
 'displayColor': "import maya.cmds as cmds\n\ncmds.displayColor( 'grid', 15, dormant=True )\ncmds.displayColor( 'grid', q=True, dormant=True )\ncmds.displayColor( list=True )\ncmds.displayColor( resetToFactory=True )\ncmds.displayColor( queryIndex=15 )",
 'displayCull': 'import maya.cmds as cmds\n\ncmds.displayCull( bfc=True )\ncmds.displayCull( bfc=False )\ncmds.displayCull( q=True, bfc=True )\n# Returns 0 if the back-face-culling on the selected object is false.\n# Returns 1 if the back-face-culling on the selected object is true.',
 'displayLevelOfDetail': 'import maya.cmds as cmds\n\ncmds.displayLevelOfDetail( lod=True )\ncmds.displayLevelOfDetail( lod=False )\ncmds.displayLevelOfDetail( q=True, lod=True )\n# Returns 0 if the level-of-detail display is false.\n# Returns 1 if the level-of-detail display is true.',
 'displayPref': "import maya.cmds as cmds\n\n# Turn on the display of affected objects\ncmds.displayPref( displayAffected=True )\n\n# Query whether affected objects will be displayed\n# in a special color or not.\ncmds.displayPref( q=True, displayAffected=True )\n# Result: 1 #\n\n# Turn on full wireframes on active shaded objects\ncmds.displayPref( wireframeOnShadedActive='full' )",
 'displayRGBColor': 'import maya.cmds as cmds\n\n# Set the background colour to red\ncmds.displayRGBColor( \'background\', 1, 0, 0 )\n\n# List the current RGB color settings\ncmds.displayRGBColor( list=True )\n\n# Query a RGB color by name\ncmds.displayRGBColor("object", query=True)\n\n# Query the HSVA values of a color\ncmds.displayRGBColor("object", query=True, hsv=True, alpha=True)',
 'displaySmoothness': 'import maya.cmds as cmds\n\n# create a surface\ncmds.sphere()\n\n# set rough smoothness settings\ncmds.displaySmoothness( du=0, dv=0, pw=4, ps=1 )\n\n# set medium smoothness settings\ncmds.displaySmoothness( du=1, dv=1, pw=8, ps=2 )\n\n# set fine smoothness settings\ncmds.displaySmoothness( du=2, dv=2, pw=16, ps=4 )\n\n# Display surface as a hull\ncmds.displaySmoothness( hull=True )\n\n# Display with reduced number of points\ncmds.displaySmoothness( hull=True, su=2, sv=2 )\n\n# Display rendering tesselation\ncmds.displaySmoothness( rt=1 )\n\n# Set default value for pointsShaded.\n# Subsequent surfaces created will have pointsShaded as 2.\ncmds.displaySmoothness( dc=True, ps=2 )\n\n# displaySmoothness queries\n#\n# query hull display, returns boolean\ncmds.displaySmoothness( q=True, hull=True )\n\n# query default pointsShaded value\ncmds.displaySmoothness( q=True, dc=True, ps=True )\n\n# query surface divisionsU value\ncmds.displaySmoothness( q=True, du=True )\n\n# Only the -pointsWire flag works on curves.\ncmds.circle()\n\n# change the number of points displayed per curve span.\ncmds.displaySmoothness( pw=3 )\n# query default pointsWire value for curves.\ncmds.displaySmoothness( q=True, dc=True, pw=True )\n\ncmds.polyCube()\n\n# Query the display resolution\ncmds.displaySmoothness( q=True, polygonObject=True )\n# Result: 0\n\n# Change the display resolution\ncmds.displaySmoothness( polygonObject=2 )',
 'displayStats': '',
 'displayString': 'import maya.cmds as cmds\n\n#    Associate a string with an identifier.\n#\ncmds.displayString( \'kExampleHelloWorld\', value=\'Hello world\' )\n\n#    Query string associated with an identifer.\n#\ncmds.displayString( \'kExampleHelloWorld\', query=True, value=True )\n\n#    Define a simple formatted string to append ellipses.\n#\ncmds.displayString( \'kExampleEllipsesFormat\', value=\'^1s...\' )\ncmds.displayString( \'kExampleEllipsesFormat\', \'kExampleHelloWorld\', query=True, value=True )\n\n#    Define a formatted string using all the available\n#    embedded characters.\n#\ncmds.displayString( \'kExampleAnotherFormat\', value=\'These ^1s are ^2s me ^3s\' )\ncmds.displayString( \'kExamplePretzels\', value=\'pretzels\' )\ncmds.displayString( \'kExampleAnotherFormat\', \'kExamplePretzels\', \'making\', \'thirsty\', query=True, value=True )\n\n# Obtain a list of matching displayString keys.\n# In the first example  a list of  all keys containing the substring\n# "niceName".\n# In the second example a list of all keys in the string set\n# m_testStrings\ncmds.displayString( \'niceName\', query=True, keys=True )\ncmds.displayString( \'m_testStrings.\', query=True, keys=True )\n\n#    If you do not specify the -v/value flag on creating then\n#    the value will be the same as the identifier.\n#\ncmds.displayString( \'kExampleMissingValue\' )\ncmds.displayString( \'kExampleMissingValue\', query=True, value=True )',
 'displaySurface': "import maya.cmds as cmds\n\ncmds.sphere(n='mySphere1')\ncmds.sphere(n='mySphere2')\ncmds.displaySurface( ['mySphere1', 'mySphere2'], two=False )\ncmds.displaySurface( xRay=True )",
 'distanceDimContext': 'import maya.cmds as cmds\n\ncmds.distanceDimContext()',
 'distanceDimension': 'import maya.cmds as cmds\n\n# To measure ths distance between [0,2,2] and [1,5,6]:\ncmds.distanceDimension( sp=(0, 2, 2), ep=(1, 5, 6) )\n#  Result: distanceDimensionShape1  #',
 'doBlur': "import maya.cmds as cmds\n\ncmds.doBlur( l=2, s=1, m=2, c='testimage', v='testimage.motion' )",
 'dockControl': "import maya.cmds as cmds\n\nmyWindow = cmds.window()\nbuttonForm = cmds.formLayout( parent = myWindow )\ncmds.button( parent = buttonForm )\nallowedAreas = ['right', 'left']\ncmds.dockControl( area='left', content=myWindow, allowedArea=allowedAreas )",
 'dolly': "import maya.cmds as cmds\n\ncmds.camera()\n\n# Moves the persp camera forward through its center of interest\ncmds.dolly( 'persp', abs=True, d=-3 )\n\n# Move the persp camera and its center of interest.\ncmds.dolly( 'persp', d=-3 )\n\n# Changes the ortho-width of the top camera to 7.5\ncmds.dolly( 'top', abs=True, os=7.5 )\n\n# Scale the ortho-width of the top camera by a quarter from its current value.\ncmds.dolly( 'top', os=0.25 )",
 'dollyCtx': "import maya.cmds as cmds\n\ncmds.dollyCtx( 'dollyContext', s=1.0, ac=False, ld=False, cd=False )\n\ncmds.dollyCtx( 'dollyContext', e=True, bdt='surface' )",
 'dopeSheetEditor': "import maya.cmds as cmds\n\ncmds.dopeSheetEditor( 'dopeSheetEditor' )",
 'doubleProfileBirailSurface': "import maya.cmds as cmds\n\ncmds.doubleProfileBirailSurface( 'curve1', 'curve2', 'curve3', 'curve4', bl=0.5 )\n\n# Tangent continuous birail surface across the two profiles.\ncmds.doubleProfileBirailSurface( 'surface1.u[0.5]', 'surface2.v[0.2]', 'curve1', 'curve2', bl=1.0, tp1=True, tp2=True )",
 'dpBirailCtx': '',
 'drag': "import maya.cmds as cmds\n\n# Creates a drag field resisting in direction (0,1,0.5).\ncmds.drag( name='myDrag', dx=0, dy=1.0, dz=0.5, useDirection=1 )\n\n# Edits the acceleration value of the field myDrag\ncmds.drag( 'myDrag', e=True, m=0.75 )\n\n# Queries myDrag for its magnitude\ncmds.drag( 'myDrag', q=True, m=True )",
 'dragAttrContext': "import maya.cmds as cmds\n\ncmds.polyPlane( w=10, h=10, sx=3, sy=3, ax=(0, 1, 0), tx=1, ch=1 )\n\ncmds.dragAttrContext( 'myDragAttrContext' )\n\n# Example 1: Move along X direction and rotate around X at the same time.\ncmds.dragAttrContext( 'myDragAttrContext', edit=True, connectTo=('pPlane1.translateX', 'pPlane1.rotateX') )\ncmds.setToolTo( 'myDragAttrContext' )\n\n# Example 2: Extrude a face and then modify the distance that it is extruded by.\ncmds.polyExtrudeFacet( 'pPlane1.f[0]', ch=1, kft=0, pvx=-1.633333373, pvy=-1.111623654, pvz=3.142515589, tx=0, ty=0, tz=0, rx=0, ry=0, rz=0, sx=1, sy=1, sz=1, ran=0, divisions=1, twist=0, taper=1, off=0, ltz=0, ws=0, ltx=0, lty=0, lrx=0, lry=0, lrz=0, lsx=1, lsy=1, lsz=1, ldx=1, ldy=0, ldz=0, w=0, gx=0, gy=-1, gz=0, att=0, mx=0, my=0, mz=0, sma=30 )\ncmds.dragAttrContext( 'myDragAttrContext', edit=True, connectTo='polyExtrudeFace1.localTranslateZ' )\ncmds.setToolTo( 'myDragAttrContext' )\n\n# Example 3: Do a wedge face and modify both the number of divisions and the\n# angle at the same time.\ncmds.polyWedgeFace( 'pPlane1.f[0]', 'pPlane1.e[30]', ws=1, wedgeAngle=90, divisions=4, ed=30, ch=1 )\ncmds.dragAttrContext( 'myDragAttrContext', edit=True, connectTo=('polyWedgeFace1.wedgeAngle', 'polyWedgeFace1.divisions') )\ncmds.setToolTo( 'myDragAttrContext' )",
 'draggerContext': 'import maya.cmds as cmds\n\n# Procedure called on press\ndef SampleContextPress():\n\tpressPosition = cmds.draggerContext( \'sampleContext\', query=True, anchorPoint=True)\n\tprint ("Press: " + str(pressPosition))\n\n# Procedure called on drag\ndef SampleContextDrag():\n\tdragPosition = cmds.draggerContext( \'sampleContext\', query=True, dragPoint=True)\n\tbutton = cmds.draggerContext( \'sampleContext\', query=True, button=True)\n\tmodifier = cmds.draggerContext( \'sampleContext\', query=True, modifier=True)\n\tprint ("Drag: " + str(dragPosition) + "  Button is " + str(button) + "  Modifier is " + modifier + "\\n")\n\tmessage = str(dragPosition[0]) + ", " + str(dragPosition[1])\n\tcmds.draggerContext( \'sampleContext\', edit=True, drawString=message)\n\n# Define draggerContext with press and drag procedures\ncmds.draggerContext( \'sampleContext\', pressCommand=\'SampleContextPress()\', dragCommand=\'SampleContextDrag()\', cursor=\'hand\' );\n\n# Set the tool to the sample context created\n# Results can be observed by dragging mouse around main window\ncmds.setToolTo(\'sampleContext\')',
 'drawExtrudeFacetCtx': '',
 'dropoffLocator': "import maya.cmds as cmds\n\n# create a wire deformer\n#\ncmds.polyPlane(w=24,h=24,sx=20,sy=20)\ncmds.curve(d=3,p=[(-10, 0, 0),(-6, 0, 10),(-3, 0, -10),(10, 0, 0)],k=[0, 0, 0, 1, 1, 1])\ncmds.select('pPlane1')\ncmds.wire(w='curve1')\n\n# add a locator at curve point 0.5, with envelope 2 and percent 1\n#\ncmds.select( 'curve1.u[0.5]', r=True )\ncmds.dropoffLocator( 2.0, 1.0, 'wire1' )",
 'duplicate': "import maya.cmds as cmds\n\n# Create a hierarchy of two spheres;\ncmds.sphere( n='sphere1' )\ncmds.move( 3, 0, 0 )\ncmds.sphere( n='sphere2' )\ncmds.move( -3, 0, 0 )\ncmds.group( 'sphere1', 'sphere2', n='group1' )\ncmds.circle( n='circle1' )\n\n# Create a duplicate of the group\ncmds.duplicate( 'group1' )\n# Result: group2 sphere1 sphere2 #\n\ncmds.undo()\ncmds.duplicate( 'group1', rr=True )\n# Result: group2 #\n\n# Create a row of 4 circles equally spaced using\n# the -smartTransform flag.\ncmds.duplicate( 'circle1' )\ncmds.move( 3, 0, 0 )\ncmds.duplicate( st=True )\ncmds.duplicate( st=True )\n\n# Duplicate a sphere along with its input connections.\n# If animCurves were feeding into original transforms of the\n# sphere, they will feed into the duplicated ones also.\n# If the sphere has history (in this case it does),\n# then the history is connected to the duplicate. Note that\n# changing the radius for the makeNurbSphere for the sphere1\n# affects the duplicated sphere.\n#\ncmds.duplicate( 'group1|sphere1', ic=True )\ncmds.move( 0, 0, 0 )\ncmds.setAttr( 'makeNurbSphere1.radius', 2 )\n\n# Duplicate selected objects along with their upstream nodes\n# and connections. This will duplicate the history.\ncmds.select( 'group1|sphere2' )\ncmds.duplicate( un=True )",
 'duplicateCurve': "import maya.cmds as cmds\n\ncmds.cone( ch=True, o=True, po=0, ax=(0, 1, 0), r=3, hr=4 )\n# Result: [u'nurbsCone1', u'makeNurbCone1'] #\n\n# duplicate isoparm at v param 0.5 with history\ncmds.duplicateCurve( 'nurbsCone1.v[0.5]', ch= True, o=True )\n\n# duplicate isoparm at normalized u param 0.1, no history\ncmds.duplicateCurve( 'nurbsCone1.un[0.1]', ch=False )\n\ncmds.nurbsPlane( ch=True, o=True, po=0, ax=(0, 1, 0), w=10, lr=1 ) ;\ncmds.circle( ch=True, o=True, nr=(0, 1, 0), r=4 ) ;\ncmds.projectCurve( 'nurbsCircle1', 'nurbsPlane1', ch=False, rn=False, un=False, tol=0.01 )\n# duplicate curve on surface\ncmds.duplicateCurve( 'nurbsPlaneShape1->projectionCurve1_1', ch=True, o=False )\n\ncmds.trim( 'nurbsPlaneShape1', 'projectionCurve1_Shape1', ch=True, o=True, rpo=True, lu=0.2, lv=0.3 )\n# duplicate trim edge\ncmds.duplicateCurve( 'nurbsPlane1.edge[1][1][1]', ch=True, o=False);",
 'duplicateSurface': "import maya.cmds as cmds\n\ncmds.nurbsPlane( u=4, v=3 )\ncmds.duplicateSurface( 'nurbsPlane1.sf[1:2][0:1]', ch=True, o=True )\n\n# Duplicates 4 faces of a nurbs plane.",
 'dynCache': "import maya.cmds as cmds\n\n# Create an emitter and connect it to a particle shape\ncmds.emitter(typ='omni', pos=(1, 1, 1), n='myEmitter')\ncmds.particle(n='myParticles')\ncmds.connectDynamic('myParticles', em='myEmitter')\n\n# Cache all attributes of the particle shape at time 50\ncmds.playbackOptions(min=0, max=50, ast=0, aet=100)\ncmds.currentTime('0');\ncmds.play(w=True)\ncmds.dynCache()",
 'dynControl': '',
 'dynExport': 'import maya.cmds as cmds\n\ncmds.dynExport( \'particle1\', mnf=5, mxf=10, os=2, atr=(\'position\', \'velocity\'), p=\'PDB\' )\n\n# Export position and velocity attributes for particle1\n# for frames 5 through 10 at every half frame interval,\n# to files in subdirectory "PDB" of the workspace root\n# directory. The default format (binary) will be used.',
 'dynExpression': 'import maya.cmds as cmds\n\ncmds.dynExpression( \'particleShape1\', s=\'rgbPP = << 1, 0, 0 >>\', c=1 )\n\n# This expression tells particleShape1 that whenever new particles are\n# created for this object, then their color should start out as << 1, 0, 0 >>,\n# which is red.\n\ncmds.dynExpression( \'particleShape1\', s=\'rgbPP = rgbPP * .9;\', rbd=1 )\n\n# This sets the runtime before dynamics expression for rgbPP.  When a particle is\n# first "born", its color will be red from the previous example.  Every other frame after\n# that, its color is reduced by 10 percent each time the expression is executed.\n\ncmds.dynExpression( \'particleShape1\', s=\'rgbPP = rgbPP * .9;\', rad=1 )\n\n# This sets the runtime after dynamics expression for rgbPP.  When a particle is\n# first "born", its color will be red from the previous example.  Every other frame after\n# that, its color is reduced by 10 percent each time the expression is executed.',
 'dynGlobals': 'import maya.cmds as cmds\n\ncmds.dynGlobals( e=True, os=5 )\n# or\ncmds.dynGlobals( os=5 )\n\n# Both of these commands will edit the overSampling attribute of\n# the active dynGlobals node.',
 'dynPaintCtx': '',
 'dynPaintEditor': "import maya.cmds as cmds\n\ncmds.dynPaintEditor( 'editor' )\n\ncmds.dynPaintEditor( 'editor', e=True, ni=(640, 480, 1.0, 0.5, 0.2) )",
 'dynParticleCtx': "import maya.cmds as cmds\n\ncmds.dynParticleCtx( 'dynParticleContext', e=True, nj=5, jr=1.5 )\n# Set the option values for number of jitters to 5 and jitter\n# radius to 1.5 in the particle context, which will result in\n# creating 5 particles for each mouse click in the viewport,\n# randomly placed, but all within 1.5 units of the mouse click.",
 'dynPref': 'import maya.cmds as cmds\n\n# Sets autoCreate rigid bodies to "on"\ncmds.dynPref( autoCreate=1 )',
 'dynSelectCtx': '',
 'dynTestData': '',
 'dynWireCtx': '',
 'dynamicLoad': "import maya.cmds as cmds\n\ncmds.dynamicLoad( 'libDynSlice.dll' )",
 'editDisplayLayerGlobals': "import maya.cmds as cmds\n\ncmds.editDisplayLayerGlobals( cdl='displayLayer1' )\n\ncmds.editDisplayLayerGlobals( query=True, cdl=True )\n# Result: displayLayer1\n\ncmds.editDisplayLayerGlobals( 'bi', query=True )\n# Result: 10\n\ncmds.editDisplayLayerGlobals( useCurrent='on' )",
 'editDisplayLayerMembers': "import maya.cmds as cmds\n\nimport maya.cmds as cmds\n\ncmds.editDisplayLayerMembers( 'displayLayer1', 'sphere1', 'cone1' )\n# Result : 2\n\ncmds.editDisplayLayerMembers( 'displayLayer1', query=True )\n# Result : sphere1 cone1\n\ncmds.editDisplayLayerMembers( 'displayLayer1', 'expression1', 'sphere2' )\n# Warning : Only DAG objects can be in a display layer.  'expression1' ignored.\n# Result : 1\n\nufeSel = cmds.ls(selection=True, ufe=True)\ncmds.editDisplayLayerMembers('layer1', ufeSel, noRecurse=True)\n// Result: 1\n\ncmds.editDisplayLayerMembers('layer1', clear=True)\n# Result: 1",
 'editMetadata': "import maya.cmds as cmds\n\nimport maya.cmds as cmds\ncmds.polyPlane( name='smcPlane', constructionHistory=False )\n# Result: smcPlane #\ncmds.pickWalk( d='down' )\n# Result: [u'smcPlaneShape'] #\n\n# Create structure\ncmds.dataStructure( format='raw', asString='name=idStructure:int32=ID' )\n# Result: idStructure #\n\n# Apply structure to plane\ncmds.addMetadata( structure='idStructure', streamName='idStream', channelName='vertex' )\n\n# Attach a metadata value to three of the components by selection\ncmds.select( 'smcPlaneShape.vtx[8:10]', replace=True )\ncmds.editMetadata( streamName='idStream', memberName='ID', value=7 )\n# Result: True #\n\n# Attach a metadata value to another component by manual indexing\ncmds.select( 'smcPlaneShape', replace=True )\ncmds.editMetadata( streamName='idStream', memberName='ID', channelName='vertex', value=8, index=14 )\n# Result: True #\n\n# Remove metadata from the middle of the three vertexes set earlier\ncmds.select( 'smcPlaneShape.vtx[9]', replace=True )\ncmds.editMetadata( streamName='idStream', remove=True )\n# Result: True #",
 'editRenderLayerAdjustment': "import maya.cmds as cmds\n\n# Create two adjustments for layer1\ncmds.editRenderLayerAdjustment( 'lambert1.color', 'lambert1.diffuse', layer='layer1' )\n# Result : 2\n\n# List all the adjustments to renderlayer1\ncmds.editRenderLayerAdjustment( 'layer1', query=True, layer=True )\n# Result : lambert1.color lambert1.diffuse\n\n# Create adjustments for the current render layer\ncmds.editRenderLayerAdjustment( 'lambert1.color' )\n# Result : 1\n\n# Remove one adjustment from the current render layer\ncmds.editRenderLayerAdjustment( 'lambert1.color', remove=True )\n# Result : 1\n\n# Query the current layer for the list of adjustments\ncmds.editRenderLayerAdjustment( query=True, alg=True )\n# castsShadows         nurbsSphereShape1.castsShadows\n#                      pPlaneShape1.castsShadows\n#                      pSphereShape1.castsShadows\n# instObjGroups        pCylinderShape1.instObjGroups[0]\n# motionBlurByFrame    defaultRenderGlobals.motionBlurByFrame\n# receiveShadows       nurbsSphereShape1.receiveShadows\n#                      pPlaneShape1.receiveShadows\n#                      pSphereShape1.receiveShadows\n# shadingSamples       defaultRenderQuality.shadingSamples",
 'editRenderLayerGlobals': "import maya.cmds as cmds\n\ncmds.editRenderLayerGlobals( currentRenderLayer='layer1' )\n\ncmds.editRenderLayerGlobals( query=True, currentRenderLayer=True )\n# Result: layer1\n\ncmds.editRenderLayerGlobals( query=True, baseId=True )\n# Result: 1\n\ncmds.editRenderLayerGlobals( useCurrent=True )\n\n# Enable automatic creation of adjustments\ncmds.editRenderLayerGlobals( enableAutoAdjustments=True )",
 'editRenderLayerMembers': "import maya.cmds as cmds\n\ncmds.editRenderLayerMembers( 'layer1', 'sphere1', 'cone1' )\n# Result : 4\n\ncmds.editRenderLayerMembers( 'layer1', query=True )\n# Result : sphere1 sphere1Shape cone1 cone1Shape\n\ncmds.editRenderLayerMembers( 'layer1', 'expression1', 'sphere2' )\n# Result : 2\n\ncmds.editRenderLayerMembers( 'layer1', 'sphere1', remove=True)\n# Result : 2",
 'editor': "import maya.cmds as cmds\n\n# To change the selection connection for any editor\n#\ncmds.editor( 'anyEditor', edit=True, mainListConnection='newConnection' )",
 'editorTemplate': 'import maya.cmds as cmds\n\n# You will most likely want to use this command when defining the controls\n# that appear in the Attribute Editor for a custom node created in a plugin.\n\n# To see how this is done compile and load the transCircleNode plugin. Then\n# create a node of type "transCircle" and show the Attribute Editor.\n\n# Now look at the AEtransCircleTemplate.mel script to see how the\n# editorTemplate command is used to define the controls that appear in\n# the Attribute Editor.\n\n# As you may have noticed the name of the template script must match the\n# node type you create, ie. AEnodeTypeTemplate.mel.',
 'effector': "import maya.cmds as cmds\n\n# Will cause effector1 not to be displayed if attached to a handle.\n# This is the default.\n#\ncmds.effector( 'effector1', e=True, hi=False )\n\n# Will cause effector1 to be displayed if attached to a handle.\n#\ncmds.effector( 'effector1', e=True, hi=True )",
 'emit': 'import maya.cmds as cmds\n\ncmds.particle()\ncmds.emit( object=\'particle1\', position=(1, 1, 1) )\n\n# This will create one particle at position <<1,1,1>> in the\n# already-existing particle object <i>particle1</i>.\n#\n\ncmds.particle()\ncmds.emit( object=\'particle1\', position=((1, 1, 1), (2, 2, 2)), attribute=(\'velocity\', \'rgbPP\'), vectorValue=((1, 2, 3), (2, 3, 4), (.5, 1, 0)), floatValue=.1 )\n\n# This will create two particles at positions <<1,1,1>> and <<2,2,2>> in\n# the already-existing particle object <i>particle1</i>.  Then the velocity\n# attribute of those particles is set to <<1,2,3>> and <<2,3,4>>,\n# respectively.  Also, the rgbPP values are set to <<.5,1,0>> and\n# <<.1,.1,.1>>, respectively.  Notice that the rgbPP value for the\n# second particle was set with the -floatValue flag, even though rgbPP\n# is a vector attribute.  The single value was converted into a vector.\n\ncmds.particle()\ncmds.emit( object=\'particle1\', position=((1, 1, 1), (2, 2, 2), (3, 3, 3), (4, 4, 4), (5, 5, 5)), attribute=(\'velocity\', \'mass\', \'velocity\'), vectorValue=((1, 2, 3), (2, 3, 4), (.1, .2, .3), (3, 4, 5)), floatValue=.5)\n\n# This will create five particles in <i>particle1</i>.  The values\n# for their attributes are:\n#\n# Attribute  Particle1   Particle2   Particle3   Particle4   Particle5\n# ----------+-----------+-----------+-----------+-----------+---------\n# position   <<<<1,1,1>>>>   <<<<2,2,2>>>>   <<<<3,3,3>>>>   <<<<4,4,4>>>>   <<<<5,5,5>>>>\n# velocity   <<<<1,2,3>>>>   <<<<2,3,4>>>>   <<<<3,4,5>>>>   <b><<<<3,4,5>>>>   <<<<3,4,5>>>></b>\n# mass     .5          .3742       <b>.3742       .3742       .3742</b>\n#\n# Notice that the second value for mass was seet with the -vectorValue\n# flag, even though mass is a float attribute.  The vector was\n# converted into a float by taking its length.  Also, notice the <b>bold</b>\n# values in the table.  The values for those attribute values were not\n# explicitly set in the command.  If there are fewer values given for\n# an attribute than there are position flags, the remaining unset\n# values are set to the last value set for that attribute.  This\n# allows the user to set many of the values to be the same without\n# having to use multiple value flags.  One last note.  Notice that the\n# attribute flag was passed twice for the attribute velocity.  The value\n# flags for repeated attributes pick up where the previous ones left\n# off.\n\nx = rand(1)\ny = rand(1)\nz = rand(1)\np = sphrand(5)\ncmds.emit( object=\'particle1\', pos=((x, y, z), (\'($p.x)\', \'($p.y)\', \'($p.z)\')) )\n\n# This is a piece of Python code that could be put in a script or\n# even in an expression.  It adds a random number of particles\n# to the already-existing particle object <i>particle1</i>.  Since\n# the number of particles as well as the positions and velocities\n# of the particles are random, it would be impossible to just have\n# the emit action itself in the expression or script.  It must be\n# built as a string and then sent to the command processor with the\n# <b>eval</b> or <b>evalEcho</b> commands.  Notice that when appending\n# the vector variables to the string, it is not necessary to append\n# each component of the vectors separately.  When they are converted\n# from a vector to a string, the three components get separated with\n# a space automatically, thus formatting them in the desired way.\n# An example of a possible result from this "script" could be:\n\ncmds.emit( object=\'particle1\', pos=((1.899864198, -6.721569708, 0.585203937), (8.103957656, -4.042442985, 2.047724209), (-1.392914569, -0.109724376, 8.62265813), (1.960103537, -3.203145195, -7.6892516), (2.564072614, -6.049536895, 1.334818295), (-5.603376821, 4.33595058, 6.952385447), (-2.478591746, 6.286855715, 6.851659059), (2.424670276, -4.083412217, 6.320538621), (6.440800453, 3.405519296, 5.462135819), (2.445192551, 1.397203422, 3.443755853)), at=\'velocity\', vv=((-2.348796409, 4.022130218, 0.5316172944), (4.149667117, -1.023146404, 1.97965556), (-0.08429132578, -0.5518495233, 1.591812495), (2.597930963, 1.033536331, -1.398351383), (-3.102859272, 3.423569856, 0.7895603241), (-2.519331228, -2.5684916, -1.530779154), (-2.645169119, -0.3186551381, 0.9164776099), (-0.6183816487, -1.060784068, -0.8748223942), (-0.2460372256, 3.567980747, -2.007567372), (1.735044809, -3.660099445, -1.765401859)) )\n\n# The spacing in the string is just for formatting reasons and does\n# not affect how the action executes or compiles.',
 'emitter': "import maya.cmds as cmds\n\ncmds.particle( p=((-1, 5, 2), (2, 2, 2), (3, 3, 3)), n='particles' )\ncmds.emitter( 'particles', r=300, mnd=1.5, mxd=2.5, n='emitter' )\ncmds.particle( n='emitted' )\ncmds.connectDynamic( 'emitted', em='emitter' )\n\n# Creates a particle emitter.\n\ncmds.emitter( dx=1, dy=0, dz=0, sp=0.33, pos=(1, 1, 1), n='myEmitter' )\ncmds.particle( n='emittedParticles' )\ncmds.connectDynamic( 'emittedParticles', em='myEmitter' )\n\n# Creates a point emitter.",
 'enableDevice': 'import maya.cmds as cmds\n\n# Enables all assignInputDevice and attachDeviceAttr actions for the\n# device named "clock"\ncmds.enableDevice( enable=True, d=\'clock\' )\n\n# Stops applyTake (with no arguments) from updating param curves\n# attached to the minutes  and hours channels of device named "clock"\ncmds.enableDevice( \'minutes\', \'hours\', enable=False, d=\'clock\', apply=True )',
 'encodeString': 'import maya.cmds as cmds\n\n# Set the string s to: print(\'Hello\\n\');\nquote = \'\\"\'\nbackslash = \'\\\\\'\ns = \'print(\' + quote + \'Hello\' + backslash + \'n\' + quote + \')\'\nprint \'s=\' + s\ns=print("Hello\\n")\n\nes = cmds.encodeString(s)\nprint \'es=\' + es\nes=print(\\"Hello\\\\n\\")',
 'error': 'import maya.cmds as cmds\n\n\nimport maya.cmds as cmds\ndef lightError():\n    l = cmds.ls( lights=True )\n    if len(l) == 0:\n        cmds.error( "No Lights" )\nlightError()\n\n# The above will produce the following output and raise a RuntimeError\n# exception from the script containing it:\n#\n#   # Error: No Lights #\n#\n# If the option to display line numbers or the stack trace is turned on\n# the following output will be produced and the same exception raised:\n#\n#   # Error: line 13 of \'lightError\' in \'<maya console\'>: No Lights #\n#',
 'eval': 'import maya.mel as mel\n\nmel.eval(\'match "a+b+" "abbcc"\')\n# Result: abb #\n\n# Eval can be used to access global MEL variables. For example, the following\n# assigns the current value in $gMainWindow to a Python variable.\nmyPythonVar=mel.eval(\'$tempMelVar=$gMainWindow\')\n\n# Print the value retrieved.\nprint myPythonVar\n# Result: MayaWindow',
 'evalContinue': '',
 'evalDeferred': 'import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout()\nbutton = cmds.button(label=\'Delete Me\')\ncmds.button(button, edit=True, command=(\'cmds.evalDeferred("cmds.deleteUI(button)")\'))\ncmds.showWindow()',
 'evalEcho': '',
 'evalNoSelectNotify': '',
 'evaluationManager': 'import maya.cmds as cmds\n\n\nimport maya.cmds as cmds\n\n# Enable evaluation manager in serial mode\ncmds.evaluationManager( mode="serial" )\n# Result: True #\n\n# Confirm that the evaluation manager is currently enabled\ncmds.evaluationManager( query=True, enabled=True )\n# Result: True #\n\n# Check if the evaluation manager has at least one animated node in it\ncmds.evaluationManager( query=True, empty=True )\n# Result: True #\n\n# Does nothing since it was already in serial mode\ncmds.evaluationManager( mode="serial" )\n# Result: True #\n\n# Return the current evaluation manager mode and graph state\ncmds.evaluationManager( query=True, mode=True )\n# Result: [u\'serial\'] #\n\n# Return all legal evaluation modes\ncmds.evaluationManager( query=True )\n# Result: [u\'off\', u\'serial\'] #\n\n# Disable evaluation manager\ncmds.evaluationManager( mode="off" )\n# Result: True #\n\n# Activate parallel scheduling override on transform nodes\ncmds.evaluationManager( "transform", nodeTypeParallel=True, on=True )\n# Result: True #\n\n# Query for node types with the parallel scheduling override\ncmds.evaluationManager( query=True, nodeTypeParallel=True )\n# Result: ["transform"] #\n\n# Query the parallel scheduling override of a particular node type\ncmds.evaluationManager( "transform", query=True, nodeTypeParallel=True )\n# Result: True #\n\n# Activate locally serial scheduling override on transform nodes\ncmds.evaluationManager( "transform", nodeTypeSerialize=True, on=True )\n# Result: True #\n\n# Query for node types with the locally serial scheduling override\ncmds.evaluationManager( query=True, nodeTypeSerialize=True )\n# Result: ["transform"] #\n\n# Query the locally serial scheduling override of a particular node type\ncmds.evaluationManager( "transform", query=True, nodeTypeSerialize=True )\n# Result: True #\n\n# Activate globally serial scheduling override on transform nodes\ncmds.evaluationManager( "transform", nodeTypeGloballySerialize=True, on=True )\n# Result: True #\n\n# Query for node types with the globally serial scheduling override\ncmds.evaluationManager( query=True, nodeTypeGloballySerialize=True )\n# Result: ["transform"] #\n\n# Query the globally serial scheduling override of a particular node type\ncmds.evaluationManager( "transform", query=True, nodeTypeGloballySerialize=True )\n# Result: True #\n\n# Activate untrusted scheduling override on transform nodes\ncmds.evaluationManager( "transform", nodeTypeUntrusted=True, on=True )\n# Result: True #\n\n# Query for node types with the untrusted scheduling override\ncmds.evaluationManager( query=True, nodeTypeUntrusted=True )\n# Result: ["transform"] #\n\n# Query the untrusted scheduling override of a particular node type\ncmds.evaluationManager( "transform", query=True, nodeTypeUntrusted=True )\n# Result: True #\n\n# Force rebuild of evaluation graph for normal context\ncmds.evaluationManager( invalidate=True )\n# Result: True #\n\n# Test if evaluation graph is valid for normal context\ncmds.evaluationManager( query=True, invalidate=True )\n# Result: False #\n\n# Activate safe mode for parallel executor\ncmds.evaluationManager( safeMode=True )\n# Result: True #\n\n# Query safe mode for parallel executor\ncmds.evaluationManager( query=True, safeMode=True )\n# Result: True #\n\n# Enable manipulation with evaluation manager\ncmds.evaluationManager( manipulation=True )\n# Result: True #\n\n# Query manipulation with evaluation manager\ncmds.evaluationManager( query=True, manipulation=True )\n# Result: True #\n\n# Enable manipulation prevalidation with evaluation manager\ncmds.evaluationManager( manipulationPrevalidation=True )\n# Result: True #\n\n# Query manipulation prevalidation with evaluation manager\ncmds.evaluationManager( query=True, manipulationPrevalidation=True )\n# Result: True #\n\n# Query if evaluation manager manipulation is ready/allowed\ncmds.evaluationManager( query=True, manipulationReady=True )\n# Result: True #\n\n# Show downstream nodes\ncmds.evaluationManager( downstreamFrom=\'myNode\' )\n# Result: [\'myDownstreamNode\'] #\n\n# Show all downstream nodes\ncmds.evaluationManager( query=True, downstreamFrom=\'myRoot\' )\n# Result: [\'0\', \'myRoot\', \'1\', \'myNode\', \'2\', \'myDownstreamNode\' ] #\n\n# Show upstream nodes\ncmds.evaluationManager( upstreamFrom=\'myDownstreamNode\' )\n# Result: [\'myNode\'] #\n\n# Show cycle cluster\ncmds.evaluationManager( cycleCluster=\'myNodeInCycle\' )\n# Result: [\'myNode\', \'myNodeInCycle\', \'myNode\'] #\n\n# Activate idle rebuild\ncmds.evaluationManager( idleAction=1 )\n# Result: True #\n\n# Query idleAction\ncmds.evaluationManager( query=True, idleAction=True )\n# Result: 1 #\n\n# Show the reasons the evaluation manager was disabled\ncmds.evaluationManager( query=True, disableInfo=True )\n# Result: #\n\n# Query for fallback evaluation state\ncmds.evaluationManager( query=True, fallbackTriggered=True )\n# Result: False #',
 'evaluationManagerInternal': '',
 'evaluator': 'import maya.cmds as cmds\n\n\nimport maya.cmds as cmds\n\n# Load a custom evaluator plug-in (not a real plug-in, just an example)\ncmds.loadPlugin( \'MY_CUSTOM_EVALUATOR\' );\n# Result: MY_CUSTOM_EVALUATOR #\n\n# List the available evaluators\ncmds.evaluator( query=True );\n# Result: [u\'MY_CUSTOM_EVALUATOR\'] #\n\n# Is \'MY_CUSTOM_EVALUATOR\' disabled?\ncmds.evaluator( query=True, name=\'MY_CUSTOM_EVALUATOR\' )\n# Result: False #\n\n# Check which evaluators are disabled\ncmds.evaluator( enable=False, query=True )\n# Result: [u\'MY_CUSTOM_EVALUATOR\'] #\n\n# Turn on \'MY_CUSTOM_EVALUATOR\'\ncmds.evaluator( enable=True, name=\'MY_CUSTOM_EVALUATOR\' )\n# Result: False #\n\n# Check to see which evaluators are enabled\ncmds.evaluator( enable=True, query=True )\n# Result: [u\'MY_CUSTOM_EVALUATOR\'] #\n\n# Make \'MY_CUSTOM_EVALUATOR\' handle nodes of type \'transform\'\ncmds.evaluator( enable=True, name=\'MY_CUSTOM_EVALUATOR\', nodeType=\'transform\' )\n# Result: [u\'transform\'] #\n\n# Make \'MY_CUSTOM_EVALUATOR\' handle nodes of type \'transform\' and all derived types\ncmds.evaluator( enable=True, name=\'MY_CUSTOM_EVALUATOR\', nodeType=\'transform\', nodeTypeChildren=True )\n# Result: [u\'transform\', u\'joint\', <large list omitted>] #\n\n# Get the list of clustered nodes handled by \'MY_CUSTOM_EVALUATOR\' in the current scene.\ncmds.evaluator( name=\'MY_CUSTOM_EVALUATOR\', query=True, clusters=True )\n# Result: [\'2\', \'transform1\', \'transform2\', \'3\', \'joint3\', \'joint4\', \'joint5\' ] #\n\n# Send a configuration message to \'MY_CUSTOM_EVALUATOR\'\ncmds.evaluator( name=\'MY_CUSTOM_EVALUATOR\', configuration=\'cluster=subgraph\' )\n# Result: #\n\n# Query information about \'MY_CUSTOM_EVALUATOR\'\ncmds.evaluator( query=True, name=\'MY_CUSTOM_EVALUATOR\', info=True )\n# Result: #\n\n# Query \'pruneRoots\' priority\ncmds.evaluator( query=True, name=\'pruneRoots\', priority=True )\n# Result: 1000\n\n# Set "pruneRoots" priority to 2500\ncmds.evaluator( name=\'pruneRoots\', priority=2500 )\n# Result: True',
 'evaluatorInternal': '',
 'event': 'import maya.cmds as cmds\n\ncmds.event( em=2, t=\'newCloud\' )\n# At every collision, emit two new particles into the object\n# newCloud. The original colliding particles will survive and\n# remain in their original object. This event will be\n# assigned to the currently selected object.\n\ncmds.event( em=2 )\n# At every collision, emit two new particles into the same object.\n\ncmds.event( count=1, em=2 )\n# At the first collision for each particle, emit two new particles\n# into the same object.\n# Subsequent collisions for that same particle will not cause any\n# additional particles to be emitted. However, the new particles will\n# each emit two new ones at their first collision, since they also\n# belong to the object for which this event has been assigned.\n\ncmds.event( die=1, count=2 )\n# All particles in the selected object will die at their second\n# collision.\n\ncmds.event( \'myCloud\', name=\'foo\', count=1, q=1 )\n# Return the current value of the count parameter for the event "foo"\n# assigned to particle shape myCloud.  The order of the flags is\n# important.  Thef lag you are querying (in this case, -count) must\n# come before the -q.  The -name flag and the particle object name must\n# come after.\n\ncmds.event( \'myCloud\', d=True, name=\'foo\' )\n# Delete the event "foo" assigned to particle shape myCloud.\n\ncmds.event( \'myCloud\', e=True, name=\'foo\', emit=2 )\n# Edit the "emit" value of the event "foo" assigned to\n# particle shape myCloud.\n\ncmds.event( \'myCloud\', proc=\'myProc\' )\n# Call the MEL proc "myProc(name, id, name) each time a particle\n# of myCloud collides with anything.\n\ncmds.event( name=\'oldName\', e=1, rename=\'newName\' )\n# For the selected particle shape, rename the event "oldName" to "newName."',
 'exactWorldBoundingBox': "import maya.cmds as cmds\n\nbbox = cmds.exactWorldBoundingBox( 'sphere1', 'cube1', 'cone2')\nprint 'Bounding box ranges from: %f' % bbox[0], ', %f' % bbox[1], ', %f' % bbox[2],\nprint ' to %f' % bbox[3], ', %f' % bbox[4], ', %f' % bbox[5]",
 'excludeObjectDisplayPreset': "import maya.cmds as cmds\n\ncmds.excludeObjectDisplayPreset( listPresets=True )\n# Result: ['All', 'None']",
 'exclusiveLightCheckBox': "import maya.cmds as cmds\n\n# Create a spot light\nmyLight = cmds.spotLight(coneAngle=45)\n\nmyWindow = cmds.window()\ncmds.columnLayout('cl')\ncmds.exclusiveLightCheckBox(width=200, label='Exclusive', light=myLight)\ncmds.showWindow(myWindow)",
 'expandedSelection': "import maya.cmds as cmds\n\ncmds.createNode( 'transform' name='t1' )\ncmds.createNode( 'transform' name='t2' )\ncmds.connectAttr( 't1.tx', 't2.tx' )\ncmds.select( 't1' );\n\n# Get the list of all DG nodes at most one connection away from the selected one, including it\ncmds.expandedSelection( depth=1, expansionType='DG' )\n# Result: ['t1', 't2'] #",
 'exportEdits': 'import maya.cmds as cmds\n\n\n# query nodes to be exported, target is selected nodes, include related shaders\nnodeList = cmds.exportEdits(query=1,selected=1,includeShaders=1)\n\n# exported selected nodes and related animation nodes to file\ncmds.exportEdits("myExportFile.ma",type=\'editMA\',selected=1,includeShaders=1)\n# Result: C:/Documents and Settings/user/My Documents/maya/projects/default/scenes/myExportFile.editMA',
 'expression': "import maya.cmds as cmds\n\ncmds.expression( s='a.translateX = b.translateX * sin(c.translateX)' )\n\ncmds.expression( o='ball', s='tx = sin(time);' )",
 'expressionEditorListen': 'import maya.cmds as cmds\n\ncmds.expressionEditorListen()',
 'extendCurve': 'import maya.cmds as cmds\n\n# to extend the start of a curve with a line of distance 3\ncmds.extendCurve( em=0, et=0, s=True, d=3.0 )\n\n# to extend the end of a curve to a point\ncmds.extendCurve( em=2, s=False, ip=(1, 2, 3) )',
 'extendFluid': '',
 'extendSurface': "import maya.cmds as cmds\n\n#Create a nurbs plane, then extend both sides of the plane by 10\ncmds.nurbsPlane(n='plane1')\ncmds.extendSurface('plane1', d=10, es=2)",
 'extrude': 'import maya.cmds as cmds\n\n# extrude profile curve "distance" 5 units along x axis\ncmds.extrude (\'profile\', et = 0, d= (1, 0, 0), l= 5)\n\n# extrude profile curve along path curve using "flat" method\ncmds.extrude( \'profile\', \'path\', et=1 )\n\n# extrude profile curve along path curve using "tube" method\ncmds.extrude( \'profile\', \'path\', et=2 )',
 'falloffCurve': "import maya.cmds as cmds\n\n# Create a window with a curve control for an optionVar\n#\ncmds.window( title='Curve Control For OptionVar' )\ncmds.optionVar(stringValueAppend=['falloffCurveOptionVar', '0,1'])\ncmds.optionVar(stringValueAppend=['falloffCurveOptionVar', '0.5,1'])\ncmds.optionVar(stringValueAppend=['falloffCurveOptionVar', '0.5,0'])\ncmds.optionVar(stringValueAppend=['falloffCurveOptionVar', '1,0'])\ncmds.columnLayout()\ncmds.falloffCurve( 'fCurve', h=200)\ncmds.falloffCurve( 'fCurve', e=True, optionVar='falloffCurveOptionVar' )\ncmds.showWindow()\n\n# Query for the control vertices' values of the curve.\n#\ncmds.falloffCurve( 'fCurve', q=True, asString=True )",
 'falloffCurveAttr': "import maya.cmds as cmds\n\n# Create a window with a curve control for a curve attribute\n#\ncmds.window( title='Curve Control For Attribute' )\nobjName = cmds.createNode('vectorExtrude')\ncmds.columnLayout()\ncmds.falloffCurveAttr( at='%s.extrudeCurve[1]' % objName )\ncmds.showWindow()",
 'fcheck': 'import maya.cmds as cmds\n\n# View the image "myImage.iff"\n#\ncmds.fcheck( \'myImage.iff\' )\n\n# You can also display several images at once using filenames with\n# wildcards (each in a separate window)\n#\ncmds.fcheck( \'myTest*\' )\n\n# You can display an animation using a trailing dot (.) on the\n# filename.\n#\ncmds.fcheck( \'mySequence.\' )',
 'file': 'import maya.cmds as cmds\n\n# save the current scene to an ascii file named "fred.ma"\n#\ncmds.file( rename=\'fred.ma\' )\ncmds.file( save=True, type=\'mayaAscii\' )\n\n# save the current scene to an ascii file without the ".ma" extension\n#\ncmds.file( rename=\'tmp\' )\ncmds.file( save=True, defaultExtensions=False, type=\'mayaAscii\' )\n\n# open the file fred.ma, using the default load settings. Any references will\n# be brought in in the same state they were in when fred.ma was last saved.\n#\ncmds.file( \'fred.ma\', open=True )\n\n# reference the file wilma.mb\n#\ncmds.file( \'C:/mystuff/wilma.mb\', reference=True )\n\n# get the name of the reference node for wilma.mb\ncmds.file( \'C:/mystuff/wilma.mb\', query=True, referenceNode=True )\n# Result: wilmaRN #\n\n# does the wilmaRN reference node represent a deferred reference?\ncmds.file(query=True, referenceNode=\'wilmaRN\', deferReference=True)\n# Result: False #\n\n# reference the file barney.mb into a namespace called "rubble".\n#\ncmds.file( \'C:/maya/projects/default/scenes/barney.ma\', reference=True, type=\'mayaAscii\', namespace=\'rubble\' )\n\n# change the namespace containing barney.mb.\n#\ncmds.file( \'C:/maya/projects/default/scenes/barney.ma\', edit=True, namespace=\'purpleDinosaur\' )\n\n# retrieve a string array of all files such as main scene and reference files in the scene\n#\ncmds.file( query=True, list=True )\n# Result: C:/maya/projects/default/scenes/fred.ma C:/mystuff/wilma.mb C:/maya/projects/default/scenes/barney.ma\n\n# Select "betty" and export betty to a separate file called "betty.mb".\n# Reference the new betty file into this scene, replacing the\n# previous betty object from this scene with the reference to betty.\n#\ncmds.file( \'c:/mystuff/betty.mb\', type=\'mayaBinary\', namespace=\'rubble\', exportAsReference=True )\n\n# Select all the objects associated with file betty.mb\n#\ncmds.file( \'c:/mystuff/betty.mb\', selectAll=True )\n# Result: rubble:betty\n\n# Remove the reference file betty.mb. All nodes in betty.mb will\n# be removed from the scene\ncmds.file( \'c:/mystuff/betty.mb\', removeReference=True )\n\n# Query whether the file named "foo.mb" exists on disk\n#\ncmds.file( \'foo.mb\', query=True, exists=True )\n# Result: 0 #\n\n# Query whether the reference node "rubble:betty is deferred loaded.\n# Note, -referenceNode flag has to come before -q flag.\ncmds.file(referenceNode=\'rubbleRN\', query=True, deferReference=True )\n\n# Query the last temp file during file save\n#\ncmds.file( query=True, lastTempFile=True)\n\n####################################/\n#/   Example for the \'-buildLoadSettings\' and \'-loadSettings\' flags  #/\n####################################/\n\n# Build load settings for "ref.ma"\ncmds.file( \'ref.ma\', open=True, buildLoadSettings=True )\n# Edit those settings, to indicate that some reference should\n# be brought in unloaded.\n# Note: the following command is primarily intended for internal\n# use. It may not be easy to determine the numeric ID of a given\n# reference ("2" in this case) .\n# cmds.loadSettings( \'2\', deferReference=1 )\n# Use the edited settings when opening the file\ncmds.file(\'ref.ma\', open=True, loadSettings=\'implicitLoadSettings\')\n\n#\n#   Example for the \'-cleanReference\' and \'-editCommand\' flags\n#\n\n# Create a simple reference to a sphere\n#\ncmds.file( force=True, new=True )\ncmds.polySphere()\ncmds.file( rename=\'ref.ma\' )\ncmds.file( force=True, type=\'mayaAscii\', save=True )\ncmds.file( force=True, new=True )\ncmds.file( \'ref.ma\', reference=True, namespace=\'ref\' )\n\n# Scale the sphere\n#\ncmds.setAttr( \'ref:pSphere1.s\', 5, 5, 5 )\ncmds.getAttr( \'ref:pSphere1.s\' )\n# Result: 5 5 5 #\n\n# The \'cleanReference\' and \'editCommand\' flags only work on\n# unloaded references.\n#\ncmds.file( unloadReference=\'refRN\' )\n\n# Query the setAttr edits:\n#\ncmds.reference( referenceNode=\'refRN\', query=True, editCommand=True )\n# Result: setAttr ref:pSphere1.s -type "double3" 5 5 5 setAttr ref:lightLinker1.lnk -s 2 #\n\n# Remove all setAttr edits on refRN:\n#\ncmds.file( cleanReference=\'refRN\', editCommand=\'setAttr\' )\ncmds.reference( referenceNode=\'refRN\', query=True, editCommand=True )\n# Note that nothing is returned\n\ncmds.file( loadReference=\'refRN\' )\n\ncmds.getAttr( \'ref:pSphere1.s\' )\n# Result: 1 1 1 #\n# Note that scale has returned to 1 1 1\n\n# apply the edit file to a reference\ncmds.file("translateSphere.editMA", reference=True, applyTo="refRN")\n# Result: maps <main> to refRN\'s namespace\n\n# apply the edit file to nodes in the main scene\ncmds.file("translateSphere.editMA", i=True, applyTo=":")\n# Result: maps <main> to the root namespace\n\n# apply the edit file to a reference, but it also has connections between two refs\ncmds.file("connectionsBetweenRefs.editMA", reference=True, applyTo="refRN", mapPlaceHolderNamespace=("<otherRef>", "otherRefRN"))\n# Result: maps <main> to refRN\'s namespace and <otherRef> to otherRefRN\'s namespace\n\n# Change the modified state of the file.\ncmds.file(modified=True)\n\n# Set the file options\ncmds.file( force=True, save=True, options=\'v=1;p=17\',type=\'mayaAscii\');\n# Result:The saved file uses full names for attributes on nodes and flags in command.Also the precision of values in file is 17.\n\n# Load Reference Preview\n\n# Create a nested reference with a child reference under a parent reference.\ncmds.file( force=True, new=True )\ncmds.polySphere()\ncmds.file( rename=\'child.ma\' )\ncmds.file( force=True, type=\'mayaAscii\', save=True )\ncmds.file( force=True, new=True )\ncmds.file( \'child.ma\', reference=True, namespace=\'child_namespace\' )\ncmds.file( rename=\'parent.ma\' )\ncmds.file( force=True, type=\'mayaAscii\', save=True )\n\n# Preview the unloaded child reference under the unloaded parent reference.\ncmds.file( force=True, new=True )\ncmds.file( \'parent.ma\', reference=True, namespace=\'parent_namespace\' )\ncmds.file( \'parent.ma\', unloadReference=True )\ncmds.file( \'parent.ma\', loadReferencePreview=True )\n\n#\n#\t\t\t   Example for \'mergeNamespacesOnClash\'\n#\n\n# Create a reference\ncmds.file( force=True, new=True )\ncmds.namespace( add="bar" )\ncmds.namespace( set="bar" )\ncmds.polySphere();\ncmds.file( rename="ref.ma" )\ncmds.file( force=True, type=\'mayaAscii\', save=True )\n\n# Create a scene with some namespaces and objects\ncmds.file( force=True, new=True )\ncmds.namespace( add="ref:foo:bar" )\ncmds.namespace( set="ref:foo:bar" )\ncmds.polySphere();\n\n# Merge into root\ncmds.file(\'ref.ma\', reference=True, mergeNamespacesOnClash=True, namespace=\':\');\n\n# Merge into nested namespace\ncmds.file(\'ref.ma\', i=True, mergeNamespacesOnClash=True, namespace=\':ref:foo\');\n\n# Don\'t merge namespace\ncmds.file(\'ref.ma\', reference=True, mergeNamespacesOnClash=False, namespace=\':ref:foo\');\n\n# Now Edit the new namespace and merge it\ncmds.file(\'ref.ma\', edit=True, mergeNamespacesOnClash=True, namespace=\':ref:foo\');\n\n\n\n\n###############################################/\n#/ Example for export with relativeNamespace  #/\n###############################################/\n\ncmds.file(new=True,force=True)\ncmds.sphere(name=":A:sphereA")\ncmds.sphere(name=":A:B:sphereB")\ncmds.sphere(name=":A:B:C:sphereC")\ncmds.sphere(name=":D:sphereD")\n\n# Select all the spheres.\n#\ncmds.select(":A:sphereA", replace=True)\ncmds.select(":A:B:sphereB",add=True)\ncmds.select(":A:B:C:sphereC",add=True)\ncmds.select(":D:sphereD",add=True)\n\n# Export all these spheres with -relativeNamespace flag.\n#\ncmds.file(rename="exp.ma")\ncmds.file(force=True, exportSelected=True, type="mayaAscii", relativeNamespace=":A:B")\n# The result in the exported file:\n# :A:sphereA\n# :C:sphereC\n# :D:sphereD\n# -sphereB\n#\n\n####################################################/\n#/ Example for export with exportSnapshotCallback  #/\n####################################################/\n\ndef python_export_callback():\n    """\n\tPrint all nodes to be exported and triangulate all mesh shapes.\n\t"""\n    oldRelNames = cmds.namespace(q=True, relativeNames=True)\n    cmds.namespace(relativeNames=True)\n    nodes = cmds.ls("*", r=True)\n    for node in nodes:\n        print("Exporting " + node)\n    meshes = cmds.ls("*", r=True, typ="mesh")\n    for mesh in meshes:\n        print("Triangulating " + mesh)\n        cmds.polyTriangulate(mesh)\n    cmds.namespace( relativeNames=oldRelNames )\n\ncmds.file( f=True, new=True)\nsphere = cmds.polySphere()\ncube = cmds.polyCube()\ncyl = cmds.polyCylinder()\ncmds.parent( sphere[0], cube[0] )\ncmds.parent( cube[0], cyl[0] )\ncmds.file( \'export.ma\', force=True, options="v=0;", type="mayaAscii", ea=True, esc=(python_export_callback, "TEMP_EXPORT"))',
 'fileBrowserDialog': 'import maya.cmds as cmds\n\n# Old way:\ndef importImage( fileName, fileType):\n   cmds.file( fileName, i=True );\n   return 1\n\ncmds.fileBrowserDialog( m=0, fc=importImage, ft=\'image\', an=\'Import_Image\', om=\'Import\' )\n\n# Recommended way:\nfilename = cmds.fileDialog2(fileMode=1, caption="Import Image")\ncmds.file( filename[0], i=True );',
 'fileDialog': 'import maya.cmds as cmds\n\n# Old way:\ncmds.fileDialog()\ncmds.fileDialog( directoryMask=\'/usr/u/bozo/myFiles/*.ma\' )\ncmds.fileDialog( dm=\'*.cc\' )\n\n# Recommended way:\ncmds.fileDialog2(startingDirectory ="/usr/u/bozo/myFiles/", fileFilter="Maya Ascii (*.ma)")',
 'fileDialog2': 'import maya.cmds as cmds\n\nimport maya.cmds as cmds\n\nbasicFilter = "*.mb"\ncmds.fileDialog2(fileFilter=basicFilter, dialogStyle=2)\n\nsingleFilter = "All Files (*.*)"\ncmds.fileDialog2(fileFilter=singleFilter, dialogStyle=2)\n\nmultipleFilters = "Maya Files (*.ma *.mb);;Maya ASCII (*.ma);;Maya Binary (*.mb);;All Files (*.*)"\ncmds.fileDialog2(fileFilter=multipleFilters, dialogStyle=2)',
 'fileInfo': "import maya.cmds as cmds\n\ncmds.fileInfo( 'application', 'maya' )\ncmds.fileInfo( 'product', 'Maya Unlimited 4.5' )\ncmds.fileInfo( 'version', '4.5' )\ncmds.fileInfo( 'cutIdentifier', '200111091529' )\ncmds.fileInfo( 'osv', 'IRIX 6.5 04151556 IP32' )\n\ncmds.fileInfo( 'application', query=True )\n# maya\n\ncmds.fileInfo( query=True )\n# returns a list of all keyword/value pairs, in the order they were\n# defined.",
 'filePathEditor': 'import maya.cmds as cmds\n\n\n#Return the directories of the external files in the Maya scene.\n#\ncmds.filePathEditor(query=True, listDirectories="")\n\n#Return the directories of the external files that are saved at the target\n#location.\n#\ncmds.filePathEditor(query=True, listDirectories="c:/textures/", status=True)\n\n#Return the files present in the specified directory, but not including the\n#files in the sub directories.If no specified directory, search all external\n#files in the scene.\n#\n#Use "withAttribute" to return the associated plugs.\n#\n#Use "status" to return whether the file exists.\n#\n#Use "unresolved" to return the broken files only.\n#\n#Use "attributeOnly" to return node and attribute name only.\n#\n#Use "byType" to specify the node and attribute type.\n#\n#For example, if "stone.jpg" exists and it is used by the plug\n#"node1.imageName", then the returned result will be an ordered pair:\n#"stone.jpg node1.imageName 1".\n#\ncmds.filePathEditor(query=True, listFiles="c:/textures/", withAttribute=True, status=True)\n#\n#If "rock.jpg" does not exists and it is used by the plug\n#"node1.imageName", then this broken file and its plug\n#can be found by the command.\n#\ncmds.filePathEditor(query=True, listFiles="", unresolved=True, withAttribute=True)\n#Result: [u\'rock.jpg\', u\'node1.imageName\']\n#\n#List files that are used in the specified attribute of imagePlane\n#\ncmds.filePathEditor(query=True, listFiles="", byType="imagePlane.imageName")\n#\n#List all files that are used in the imagePlane node\n#\ncmds.filePathEditor(query=True, listFiles="", byType="imagePlane")\n#\n#Get all nodes or attributes that are using broken files to repath them\n#\ncmds.filePathEditor(query=True, listFiles="", unresolved=True, attributeOnly=True)\n#\n#Get the imagePlane file attributes that are using broken files to repath them\n#\ncmds.filePathEditor(query=True, listFiles="", unresolved=True, attributeOnly=True, byType="imagePlane.imageName")\n\n#Return the label for the specified type.\n#\n#Strings are only guaranteed to be localized for the default types. For the\n#other types, the strings are user-specified.\n#\ncmds.filePathEditor(query=True, typeLabel="imagePlane")\n\n#Register and save a new file type and type label.\n#\n#These are persistent and can be used in future sessions.\n#\ncmds.filePathEditor(registerType="containerBase.iconName", typeLabel="ContainerIcon")\n\n#Deregister a file type and clean the saved information.\n#\ncmds.filePathEditor(deregisterType="containerBase.iconName")\n\n#Register a new non-persistent file type and type label.\n#\ncmds.filePathEditor(registerType="containerBase.iconName", typeLabel="ContainerIcon", temporary=True)\n\n#Deregister a file type without affecting the persistent information.\n#\ncmds.filePathEditor(deregisterType="containerBase.iconName", temporary=True)\n\n#Return all registered types, including default types.\n#\ncmds.filePathEditor(query=True, listRegisteredTypes=True)\n\n#Query the attribute type for a plug instance.\n#\ncmds.filePathEditor("node1.fileTextureName", query=True, attributeType=True)\n\n#Refresh all the file path editor\'s information for the current scene.\n#\ncmds.filePathEditor(refresh=True)\n\n#Recursively look for files with the same name in the target directory. Repath\n#the plugs value to those files.\n#\n#Use "force" to edit all the given plugs, even if the original path does not\n#exist.\n#\n#Use "recursive" to find files recursively and to make sure the files do exist.\n#\ncmds.filePathEditor("node1.fileTextureName", "node2.fileTextureName", repath="e:/textures/",\n\t\t\t\t\t\tforce=True, recursive=True)\n\n#Preview the result of an operation without doing it.\n#\n#Returns the file name and whether the new file exists. This is returned as a\n#list of pairs.\n#\ncmds.filePathEditor("node1.fileTextureName", "node2.fileTextureName", repath="e:/textures/", preview=True)\n\n#Replace strings in file paths.\n#\n#Here, the string "image" in the directory part will be replaced by "texture".\n#\ncmds.filePathEditor("node1.fileTextureName", "node2.fileTextureName", replaceField="pathOnly", replaceString=("image", "texture"), replaceAll=True)\n\n#Copy a file from the source to the destination and repath the plug data to the new file.\n#\n#Use "force" to overwrite the file at the destination if it has a name clash.\n#\ncmds.filePathEditor("node1.fileTextureName", "node2.fileTextureName",  copyAndRepath=("e:/textures", "g:/image"), force=True)',
 'filletCurve': "import maya.cmds as cmds\n\n# Create a circular fillet (by default) having radius 2.5 between the\n# active curves:\ncmds.filletCurve( r=2.5 )\n\n# Create a freeform curve fillet between the two specified curves at\n# these parameter values:\ncmds.filletCurve( 'curve1', 'curve2', cir=True, cp1=0.5, cp2=2.0 )",
 'filter': "import maya.cmds as cmds\n\ncmds.filter( t='filterEuler', n='houston' )\ncmds.filter( 'houston', edit=True, irx=0.0 )\ncmds.filter( 'houston', query=True, irx=True )",
 'filterButterworthCtx': 'import maya.cmds as cmds\n\nimport maya.cmds as cmds\n\n# Create a context\nctx = cmds.filterButterworthCtx()\n\n# Activate the tool context\ncmds.setToolTo( ctx )\n\n# Adjust the Butterworth cutoff frequency to selected keys.\ncmds.filterButterworthCtx( ctx, e=True, sk=True, cof=3.0 )\n\n# Apply the current settings to the selected curves.\ncmds.filterButterworthCtx( ctx, e=True, apply=True )',
 'filterCurve': "import maya.cmds as cmds\n\n\ncmds.filterCurve( 'nurbsCone1_rotateX', 'nurbsCone1_rotateY', 'nurbsCone1_rotateZ' )",
 'filterExpand': 'import maya.cmds as cmds\n\n# Returns any selected isoparms (mask 45) as individual items\n# (because of "ex=True").\ncmds.filterExpand( ex=True, sm=45 )\n\n# Returns any selected CVs (mask 28) as compact items.  For example,\n#   if curve.cv[0:3] is selected, then "curve.cv[0:3]" is returned.\n#   If "ex=True", then four items are returned, one for each CV.\ncmds.filterExpand( ex=False, sm=28 )\n\n# Returns any selected CVs (mask 28) and edit points (mask 30).\ncmds.filterExpand( sm=(28,30) )\n\n# Returns any selected nurbs curves.\ncmds.filterExpand( sm=9 )\n\n# Returns any selected nurbs curves-on-surface.\ncmds.filterExpand( sm=11 )\n\n# return the poly faces (mask 34) from the specified arguments\ncmds.filterExpand(["pCube1.f[1]","pCube1.f[4]","pCube1.vtx[0:3]"], sm=34)',
 'filterGaussianCtx': 'import maya.cmds as cmds\n\nimport maya.cmds as cmds\n\n# Create a context\nctx = cmds.filterGaussianCtx()\n\n# Set the context to the new context just created\ncmds.setToolTo(ctx)\n\n# Adjust the width and sample count to selected curves.\ncmds.filterGaussianCtx(ctx, e=True, width=3, sampleCount=8)\n\n# Apply current settings to the real curves.\ncmds.filterGaussianCtx(ctx, e=True, a=True)',
 'filterInstances': 'import maya.cmds as cmds\n\n# Returns true if any selected object(s) are instances of another selected object.\ncmds.filterInstances( q=True )\n\n# Returns a new selection list with duplicate instances removed.\ncmds.filterInstances()',
 'filterKeyReducerCtx': 'import maya.cmds as cmds\n\nimport maya.cmds as cmds\n\n# Create a context\nctx = cmds.filterKeyReducerCtx()\n\n# Activate the tool context\ncmds.setToolTo( ctx )\n\n# Adjust the KeyReducer cutoff frequency to selected keys.\ncmds.filterKeyReducerCtx( ctx, e=True, sk=True, pm=1, pre=0.5 )\n\n# Apply the current settings to the selected curves.\ncmds.filterKeyReducerCtx( ctx, e=True, apply=True )',
 'filterPeakRemoverCtx': '',
 'findDeformers': "import maya.cmds as cmds\n\ncmds.findDeformers('ball')",
 'findKeyframe': 'import maya.cmds as cmds\n\n# Keys on animation curves are identified by either\n# their time values or their indices.  Times and indices can\n# be given as a range or list of ranges.\n\n# time=(\'10pal\',\'10pal\') means the key at frame 10 (PAL format).\n# time=[(\'1.0sec\',\'1.0sec\'),(\'15ntsc\',\'15ntsc\'),(20,20)] means the keys at time 1.0 second, frame 15 (in NTSC format), and time 20 (in the currently defined global time unit).\n# time=(10,20) means all keys in the range from 10 to 20, inclusive, in the current time unit.\n# Omitting one end of a range means "go to infinity", as in the following examples:\n# time=(10,None) means all keys from time 10 (in the current time unit) onwards.\n# time=(10,) means the same as (10,10)\n# time=(0,10) means all keys up to (and including) time 10 (in the current time unit).\n# time=(None,None) is a short form to specify all keys.\n# index=(0,0) means the first key of each animation curve. (Indices are 0-based.)\n# index=[(2,2),(5,5),(7,7)] means the 3rd, 6th, and 8th keys.\n# index=(1,5) means the 2nd, 3rd, 4th, 5th, and 6th keys of each animation curve.\n\n# Find the next key from the current time, based upon the ticks\n# displayed within the time slider\n#\ncmds.findKeyframe( timeSlider=True, which="next" )\n\n# Find the next key for nurbsCone1 after time 25\n#\ncmds.findKeyframe( \'nurbsCone1\', time=(25,25), which="next" )\n\n# Find the curves driving the nurbsCone1\'s rotateX attribute\n#\ncmds.findKeyframe( \'nurbsCone1\', curve=True, at=\'rotateX\' )',
 'findType': 'import maya.cmds as cmds\n\n\ncmds.createNode( \'transform\', name=\'silly\' )\ncmds.createNode( \'transform\', name=\'putty\' )\ncmds.connectAttr( \'putty.tx\', \'silly.tx\' )\n\n# Find transform nodes connected to node "silly"\n#\ncmds.findType( \'silly\', deep=True, type=\'transform\' )\n# Result: [u\'silly\', u\'putty\'] #\n\n# Look forward from a selected item\n#\ncmds.select( \'silly\' )\ncmds.findType( deep=True, forward=True, type=\'transform\' )\n# Result: [u\'silly\'] #\n\n#\n# Find all time nodes\n#\ncmds.setKeyframe( t=10 )\ncmds.findType( type=\'time\', deep=True, exact=True )\n# Result: [u\'time1\'] #\n\n#\n# Find all anim curve nodes\n#\ncmds.findType( type="animCurve", deep=True )\n# Result: [u\'pairBlend1_inTranslateX1\', u\'silly_translateY\', u\'silly_translateZ\', u\'silly_visibility\', u\'silly_rotateX\', u\'silly_rotateY\', u\'silly_rotateZ\', u\'silly_scaleX\', u\'silly_scaleY\', u\'silly_scaleZ\'] #',
 'fitBspline': 'import maya.cmds as cmds\n\ncmds.curve( d=1, p=((0.2662494, 0, 10.640916), (-4.71138, 0, 7.070603), (-7.849212, 0, 1.051444), (-6.646792, 0, -3.475301), (-2.499369, 0, -3.770414), (2.041102, 0, -1.381914), (5.408074, 0, 3.095469)), k=(0, 1, 2, 3, 4, 5, 6) )\n\ncmds.fitBspline( ch=1, tol=0.01 )',
 'flagTest': '',
 'flexor': 'import maya.cmds as cmds\n\n# Create a sculpt object with a max displacement of 4.0 at the\n# selected joint\ncmds.flexor( typ=\'sculpt\', dc="sculpt -mxd 4.0", aj=True )\n\n# Create a lattice flexor at all joints on the skeleton:\ncmds.flexor( type=\'jointLattice\', aj=True, ts=True )\n\n# Create a lattice flexor of dimensions 4 6 4 on the selected joint\ncmds.flexor( type=\'jointLattice\', dc="lattice -dv 4 6 4 -cp -dualBase true", aj=True)',
 'floatField': 'import maya.cmds as cmds\n\nwindow = cmds.window()\ncmds.columnLayout()\ncmds.floatField()\ncmds.floatField( editable=False )\ncmds.floatField( minValue=-10, maxValue=10, value=0 )\ncmds.floatField( minValue=0, maxValue=1, precision=2 )\ncmds.floatField( minValue=-1, maxValue=1, precision=4, step=.01 )\ncmds.showWindow( window )',
 'floatFieldGrp': "import maya.cmds as cmds\n\nwindow = cmds.window()\ncmds.columnLayout()\ncmds.floatFieldGrp( numberOfFields=3, label='Scale', extraLabel='cm', value1=0.3, value2=0.5, value3=0.1 )\ncmds.showWindow( window )",
 'floatScrollBar': 'import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout( adjustableColumn=True )\ncmds.floatScrollBar()\ncmds.floatScrollBar( min=-100, max=100, value=0, step=1, largeStep=10 )\ncmds.showWindow()',
 'floatSlider': 'import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout( adjustableColumn=True )\ncmds.floatSlider()\ncmds.floatSlider( min=-100, max=100, value=0, step=1 )\ncmds.showWindow()',
 'floatSlider2': "import maya.cmds as cmds\n\n############ floatSlider2 example #############\n#\n# First, create one object to control with the slider. We will use one\n# slider handle to control the startSweep and the other the endSweep so\n# that the sphere can be made to open and close via the handles.\n#\ncmds.sphere()\n\n# Create a window containing a floatSlider2 (two handled float slider).\n# The window also contains two floating-point textfields.\n#    - Moving the handle updates the associated textfield.\n#    - Typing a value into a textfield moves the associated handle.\n#\ncmds.window()\ncmds.columnLayout()\n\nff1    = cmds.floatField()\nslider = cmds.floatSlider2()\nff2    = cmds.floatField()\n\n# Hook the slider handles up to drive the textfields. When you move the\n# slider handles, the textfields will update to display the\n# position of the handle.\n#\ncmds.floatSlider2( slider, edit=True, positionControl1=ff1, positionControl2=ff2 )\n\n# Set the slider direction (polarity) and upper limit.\n#\ncmds.floatSlider2( slider, edit=True, polarity=1, max=360 )\n\n# Connect the slider so that the handles drive the sweep angles of\n# the NURBS sphere.\n#\ncmds.floatSlider2(slider, edit=True, cc1='setAttr makeNurbSphere1.endSweep', cc2='setAttr makeNurbSphere1.startSweep' )\n\n# Display the window.\n#\ncmds.showWindow()",
 'floatSliderButtonGrp': "import maya.cmds as cmds\n\nwindow = cmds.window()\ncmds.columnLayout()\ncmds.floatSliderButtonGrp( label='Label', field=True, buttonLabel='Button', symbolButtonDisplay=True, columnWidth=(5, 23), image='cmdWndIcon.xpm' )\ncmds.showWindow( window )",
 'floatSliderGrp': "import maya.cmds as cmds\n\n#    Create a window with a couple float slider groups.  The first will\n#    use default limit values, and the second will set up a group that has\n#    a field range greater than the slider range.  Try entering values\n#    greater than the slider limits in both groups.\n#\nwindow = cmds.window(title='floatSliderGrp Example')\ncmds.columnLayout()\ncmds.floatSliderGrp( label='Group 1', field=True )\ncmds.floatSliderGrp( label='Group 2', field=True, minValue=-10.0, maxValue=10.0, fieldMinValue=-100.0, fieldMaxValue=100.0, value=0 )\ncmds.showWindow( window )",
 'flow': 'import maya.cmds as cmds\n\n# Create a simple motion path animation\n\n# create a path, e,g, a curve\npath = cmds.curve(d=3,p=[(-10, 0, 0),(-6, 0, 10),(-3, 0, -10),(10, 0, 0)],k=[0, 0, 0, 1, 1, 1])\n\n# create an object, e.g. a sphere\nobject = cmds.sphere()\ncmds.scale( 0.5, 2.0, 0.2 )\n\n# animate the object using a motion path with follow on for 30 frames\ncmds.pathAnimation( object[0], f=1, stu=0, etu=30, c=path )\n\n# select only the animated object\ncmds.select( object[0], r=True )\n\n# Create flow deformation on the selected object with default values:\ncmds.flow()\n\n# Create flow deformation on the selected object with\n# the lattice around the path, and lattice division of 3,20,2:\ncmds.flow( oc=False, dv=(3, 20, 2) )\n\n# Create flow deformation on the selected object with\n# lattice subdivisions 4, 7, and 3:\n\ncmds.flow( dv=(4, 7, 3) )\n\n# When the object is not currently selected, the name of the object\n# has to be specified in the command line (note: $object[0] has to\n# have a motion path animation):\n\ncmds.flow( object[0], dv=(4, 7, 3) )',
 'flowLayout': 'import maya.cmds as cmds\n\ncmds.window()\ncmds.flowLayout( columnSpacing=10 )\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.showWindow()',
 'fluidCacheInfo': "import maya.cmds as cmds\n\n# get start frame for Initial Conditions Cache\ncmds.fluidCacheInfo( ic=True, sf=True )\n\n# get resolution for Initial Conditions Cache\ncmds.fluidCacheInfo( ic=True, re=True )\n\n# get end frame for Playback Cache\ncmds.fluidCacheInfo( pb=True, ef=True )\n\n# get resolution for Playback Cache\ncmds.fluidCacheInfo( pb=True, re=True )\n\n# Is there data for any of the valid properties\n# in the playback cache?\ncmds.fluidCacheInfo( pb=True, hd=True )\n\n# Is there density data in the playback cache?\ncmds.fluidCacheInfo( at='density', pb=True, hd=True )",
 'fluidEmitter': "import maya.cmds as cmds\n\ncmds.fluidEmitter( pos=(0, 0, 0), type='omni', der=1, her=2, fer=3, fdr=1.5, r=100.0, cye='none', cyi=1, mxd=0, mnd=0 )\ncmds.connectDynamic( 'fluidShape1', em='emitter1' )\n\n# Creates an omni emitter that's emitting density, heat and fuel\n# into fluidShape1",
 'fluidVoxelInfo': "import maya.cmds as cmds\n\n# fluid3D is a 10x10x5 three-dimensional fluid.\n# fluid2D is a 9x9 two-dimensional fluid.\n#\n# Are the given indices within the bounds of the fluids?\n#\ncmds.fluidVoxelInfo( 'fluid2D', inBounds=( 9, 9, 0) )\n# Result: false\ncmds.fluidVoxelInfo( 'fluid2D', inBounds=( 8, 8, 0) )\n# Result: true\ncmds.fluidVoxelInfo( 'fluid3D', inBounds=( 2, 3, 4 ) )\n# Result: true\ncmds.fluidVoxelInfo( 'fluid3D', inBounds=( 12, 9, 2) )\n# Result: false",
 'flushIdleQueue': '',
 'flushThumbnailCache': '',
 'flushUndo': 'import maya.cmds as cmds\n\ncmds.flushUndo()',
 'fontDialog': 'import maya.cmds as cmds\n\n# Display a selection dialog containing all available fonts and save\n# the one selected by the user.\nfont = cmds.fontDialog()\n\n# Get an array of all available fonts.\nfonts = cmds.fontDialog(FontList=True)\n\n# Get an array of scalable fonts.\nscalableFonts = cmds.fontDialog(FontList=True, scalable=True)',
 'formLayout': "import maya.cmds as cmds\n\nwindow = cmds.window()\nform = cmds.formLayout(numberOfDivisions=100)\nb1 = cmds.button()\nb2 = cmds.button()\ncolumn = cmds.columnLayout()\ncmds.button()\ncmds.button()\ncmds.button()\n\ncmds.formLayout( form, edit=True, attachForm=[(b1, 'top', 5), (b1, 'left', 5), (b2, 'left', 5), (b2, 'bottom', 5), (b2, 'right', 5), (column, 'top', 5), (column, 'right', 5) ], attachControl=[(b1, 'bottom', 5, b2), (column, 'bottom', 5, b2)], attachPosition=[(b1, 'right', 5, 75), (column, 'left', 0, 75)], attachNone=(b2, 'top') )\n\ncmds.showWindow( window )",
 'format': 'import maya.cmds as cmds\n\n# The mel script below returns the sentence\n#     "Display all lambert and blinn nodes."\n#\ncmds.format( \'Display all ^1s and ^2s nodes.\', stringArg=(\'lambert\', \'blinn\') )',
 'frameBufferName': "import maya.cmds as cmds\n\n\ncmds.frameBufferName(renderLayer='layer1', renderPass='renderPass1', camera='camera1')",
 'frameLayout': "import maya.cmds as cmds\n\ncmds.window()\ncmds.scrollLayout( 'scrollLayout' )\ncmds.columnLayout( adjustableColumn=True )\ncmds.frameLayout( label='Buttons' )\ncmds.columnLayout()\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.setParent( '..' )\ncmds.setParent( '..' )\ncmds.frameLayout( label='Scroll Bars' )\ncmds.columnLayout()\ncmds.intSlider()\ncmds.intSlider()\ncmds.intSlider()\ncmds.setParent( '..' )\ncmds.setParent( '..' )\ncmds.frameLayout( label='Fields' )\ncmds.columnLayout()\ncmds.intField()\ncmds.intField()\ncmds.intField()\ncmds.setParent( '..' )\ncmds.setParent( '..' )\ncmds.frameLayout( label='Check Boxes' )\ncmds.columnLayout()\ncmds.checkBox()\ncmds.checkBox()\ncmds.checkBox()\ncmds.setParent( '..' )\ncmds.setParent( '..' )\ncmds.showWindow()",
 'framelessDialog': "import maya.cmds as cmds\n\ncmds.framelessDialog( title='Confirm', message='File not found',\n\tpath='c:/path/of/file/not/found.txt', button=['OK'], primary=['OK'])",
 'freeFormFillet': "import maya.cmds as cmds\n\n# Create the fillet across a curve on surface and surface isoparm.\ncmds.nurbsPlane( ch=True, o=True, po=0, ax=(0, 1, 0), w=11, lr=1 )\ncmds.circle( ch=True, o=True, nr=(0, 1, 0), r=3.79518 )\ncmds.projectCurve( 'nurbsCircle1', 'nurbsPlane1', ch=False, rn=False, un=False, tol=0.01 )\n# Result: [u'nurbsPlane1->projectionCurve1'] #\ncmds.nurbsPlane( p=(0, 6, 0), ax=(0, 1, 0), w=11, lr=1 )\n# Result: [u'nurbsPlane2', u'makeNurbPlane2'] #\ncmds.freeFormFillet( 'nurbsPlaneShape1->projectionCurve1_1', 'nurbsPlane2.v[1.0]', ch=True, bias=0.0, depth=0.5, po=True )\n# Result: [u'freeformFilletSurface1', u'ffFilletSrf1'] #\n\ncmds.trim( 'nurbsPlaneShape1', 'projectionCurve1_Shape1', ch=True, o=True, rpo=True, lu=0.2, lv=0.2 )\n# Result: [u'nurbsPlaneShape1', u'trim1'] #\n# Fillet across a surface trim edge boundary and surface isoparm.\ncmds.freeFormFillet( 'nurbsPlane1.edge[1][1][4]', 'nurbsPlane2.v[0][0.0:0.6]', ch=False )\n# Result: [u'freeformFilletSurface2'] #",
 'freezeOptions': "import maya.cmds as cmds\n\n\nimport maya.cmds as cmds\n\n# Print the current display layer freeze option\nprint 'Display layer freeze option is {}'.format( cmds.freezeOptions( query=True, displayLayers=True ) )\n\n# Toggle the display layer freeze option on\ncmds.freezeOptions( displayLayers=True )\n# Return: True #\n\n# Set downstream propagation to safe mode\ncmds.freezeOptions( downstream='safe' )\n# Return: True #",
 'geomBind': "import maya.cmds as cmds\n\n\n# Compute geodesic voxel weights for skinCluster1 and skinCluster2. This\n# command will create a geomBind node connected to the two skinClusters\n# and their common bind pose. The geomBind node will maintain the\n# geodesic voxel binding parameters used (ie: falloff, resolution, etc.)\n#\ncmds.select( 'skinCluster1', r=True )\ncmds.select( 'skinCluster2', add=True )\ncmds.geomBind( bm=3, fo=0, mi=5 )\n\n# Create a simple scene that use geodesic voxel weights for skin binding.\ncmds.file( f=True, new=True )\ncmds.polyCylinder( r=1, h=10, sx=20, sy=20, sz=5 )\ncmds.select( d=True )\ncmds.joint( p=[0, -4, 0] )\ncmds.joint( p=[0, 0, 0] )\ncmds.joint( p=[0, 4, 0] )\ncmds.select( 'joint1', 'joint2', 'joint3', 'pCylinder1' )\ncmds.skinCluster( bindMethod=3 )\ncmds.geomBind( 'skinCluster1', bindMethod=3 )",
 'geomToBBox': 'import maya.cmds as cmds\n\n\n# Create two poly spheres and parent them together\n#\ncmds.polySphere()\ncmds.move(-1, 0, 3)\ncmds.polySphere()\ncmds.move(3, 0, -1)\ncmds.parent( \'pSphere2\', \'pSphere1\' )\n\n# Select the parent sphere\n#\ncmds.select( \'pSphere1\', replace=True )\n\n# Create a bounding box per shape in the object hierarchy selected,\n# add a name and suffix for that bounding box and add a RGB color for the\n# shader color.\n#\ncmds.geomToBBox(name=\'MyBBox\', nameSuffix=\'_perShape\', shaderColor=[0,1,0.043])\n\n# Create two poly spheres and parent them together\n#\ncmds.polySphere()\ncmds.move(-1, 5, 3)\ncmds.polySphere()\ncmds.move(3, 5, -1)\ncmds.parent( \'pSphere2\', \'pSphere1\' )\n\n# Select the parent sphere\n#\ncmds.select( \'pSphere1\', replace=True )\n\n# Create one bounding box for the entire hierarchy selected,\n# add a name and suffix for that bounding box and add a RGB color for the\n# shader color.\n#\ncmds.geomToBBox(single=True, name=\'MyBBox\', nameSuffix=\'_hierarchy\', shaderColor=[0.928,0.460,1])\n\n# Create and simple animation and bake the animation on the bounding box for\n# a specific time frame and incremental evaluation time.\ncmds.polySphere(name="BouncingBall")\ncmds.currentTime(1)\ncmds.setKeyframe()\ncmds.currentTime(5)\ncmds.move( 0, 10, 0)\ncmds.setKeyframe()\ncmds.currentTime(9)\ncmds.move( 0, 0, 0)\ncmds.setKeyframe()\n\ncmds.geomToBBox(keepOriginal=True, name="BakedAnimBBox", bakeAnimation=True, startTime=3, endTime=7, sampleBy=0.5)\ncmds.currentTime(1)',
 'geometryAttrInfo': 'import maya.cmds as cmds\n\n    import maya.cmds as cmds\n\n    cmds.polyCylinder(n="myGeo", r=1, h=6, sx=4, sy=5, sz=1)[0]\n    cmds.select([\'myGeo.vtx[12:23]\', \'myGeo.vtx[25]\'])\n\n    clusterNode, clusterHandle = cmds.cluster()\n    cmds.move(1.0, 0, 0, clusterHandle, absolute=True)\n\n    # Find the groupId for the cluster node to test our queries\n    gid = cmds.getAttr(\'{0}.input[0].groupId\'.format(clusterNode))\n\n    # Get the number of points\n    n0 = cmds.geometryAttrInfo(\'myGeo.outMesh\', pc=True)\n    n1 = cmds.geometryAttrInfo(\'myGeo.outMesh\', gid=gid, pc=True)\n    print "Deforming {0} out of {1} points".format(n1, n0)\n    # Deforming 13 out of 26 points\n\n    # Get the indices that are being deformed\n    cmds.geometryAttrInfo(\'myGeo.outMesh\', gid=gid, pi=True)\n    # Result: [12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L, 25L] #\n\n    # Get the components that are being deformed\n    cmds.geometryAttrInfo(\'myGeo.outMesh\', gid=gid, cmp=True)\n    # Result: [u\'vtx[12:23]\', u\'vtx[25]\'] #\n\n    # Get the bounding box of the total geometry\n    cmds.geometryAttrInfo(\'myGeo.outMesh\', bb=True)\n    # Result: [-1.0, 2.0, -3.0, 3.0, -1.0, 1.0] #\n\n    # Get the bounding box of what is being deformed\n    cmds.geometryAttrInfo(\'myGeo.outMesh\', gid=gid, bb=True)\n    # Result: [0.0, 2.0, 0.6000001430511475, 3.0, -1.0, 1.0] #\n\n    # Get the node chain leading up to the cluster]\n    cmds.geometryAttrInfo(\'cluster1.outputGeometry[0]\', nch=True)\n    # Result: [u\'polyCylinder1\', u\'myGeoShapeOrig\', u\'groupParts2\', u\'tweak1\', u\'cluster1GroupParts\', u\'cluster1\'] #\n\n    # Get the deformer chain leading up to the cluster\n    cmds.geometryAttrInfo(\'cluster1.outputGeometry[0]\', dch=True)\n    # Result: [u\'tweak1\', u\'cluster1\'] #\n\n    # Get the plug chain leading up to the cluster\n    cmds.geometryAttrInfo(\'cluster1.outputGeometry[0]\', pch=True)\n    # Result: [u\'polyCylinder1.output\', u\'myGeoShapeOrig.inMesh\', u\'myGeoShapeOrig.worldMesh[0]\', u\'groupParts2.inputGeometry\', u\'groupParts2.outputGeometry\', u\'tweak1.input[0].inputGeometry\', u\'tweak1.outputGeometry[0]\', u\'cluster1GroupParts.inputGeometry\', u\'cluster1GroupParts.outputGeometry\', u\'cluster1.input[0].inputGeometry\', u\'cluster1.outputGeometry[0]\'] #\n\n    # Get the output plug chain leading up to the cluster\n    cmds.geometryAttrInfo(\'cluster1.outputGeometry[0]\', och=True)\n    # Result: [u\'polyCylinder1.output\', u\'myGeoShapeOrig.worldMesh[0]\', u\'groupParts2.outputGeometry\', u\'tweak1.outputGeometry[0]\', u\'cluster1GroupParts.outputGeometry\', u\'cluster1.outputGeometry[0]\'] #',
 'geometryConstraint': "import maya.cmds as cmds\n\n# Constrain cube1 to surf1 at the closest point to  cube1.\ncmds.geometryConstraint( 'surf1', 'cube1' )\n\n# Will prefer surf1 though the weights are equal\ncmds.geometryConstraint( 'surf1', 'surf2', 'cube2', w=.1 )\n\n# Now constraints cube2 to lie on surf2 as it's weight is greater\ncmds.geometryConstraint( 'surf2', 'cube2', e=True, w=10. )\n\n# Removes surf2 from cube2's geometryConstraint.\ncmds.geometryConstraint( 'surf2', 'cube2', e=True, rm=True )\n\n# Adds surf3 to cube2's geometryConstraint with the default weight.\ncmds.geometryConstraint( 'surf3', 'cube2' )",
 'getAttr': "import maya.cmds as cmds\n\ncmds.createNode( 'revolve', n='gravityWell' )\ncmds.sphere( n='loxTank' )\ncmds.cone( n='noseCone' )\ncmds.cone( n='fin' )\ncmds.pointConstraint( 'fin', 'noseCone', n='weld' )\n\nangle = cmds.getAttr('gravityWell.esw')\n# Result: 360 #\ntype = cmds.getAttr('loxTank.translate',type=True)\n# Result: double3 #\nlock = cmds.getAttr('noseCone.translateX',lock=True)\n# Result: 0 #\nfinZ = cmds.getAttr('fin.translateZ',time=12)\n# Result: 0.0 #\nsize = cmds.getAttr('weld.target',size=True)\n# Result: 1 #\nsize = cmds.getAttr('weld.target',settable=True)\n# Result: 0 #\nmatrix = cmds.getAttr('loxTank.matrix')\n# Result: 1.0 0.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 0.0 1.0 #\ncmds.createNode('file',n='file1')\ncmds.setAttr( 'file1.ftn', '$TMPDIR/smile.gif',type='string' )\ns = cmds.getAttr('file1.ftn')\n# Result: $TMPDIR/smile.gif #\ns = cmds.getAttr('file1.ftn',x=True)\n# Result: /var/tmp/smile.gif #\n\n# Get the list of all used indices on a multi attribute\ncmds.getAttr('initialShadingGroup.dagSetMembers', multiIndices=True)\n# Result: [0, 1, 2] #",
 'getClassification': 'import maya.cmds as cmds\n\n# Get the classification string for the "lambert" node type\n#\nclassifications = cmds.getClassification(\'lambert\')\nfor c in classifications[:]:\n    print \'\\tClassified as \' + c + \'\\n\'\n\nisShader = cmds.getClassification("lambert",satisfies="shader")',
 'getDefaultBrush': 'import maya.cmds as cmds\n\n# get the name of the current brush\n#\nbrush = cmds.getDefaultBrush()',
 'getFileList': "import maya.cmds as cmds\n\n# List the contents of the user's projects directory\n#\ncmds.getFileList( folder=cmds.internalVar(userWorkspaceDir=True) )\n\n# List all MEL files in the user's script directory\n#\ncmds.getFileList( folder=cmds.internalVar(userScriptDir=True), filespec='*.mel' )",
 'getFluidAttr': 'import maya.cmds as cmds\n\n# get density for entire fluid\ncmds.getFluidAttr( at=\'density\' )\n\n# get density at the cell x=1, y=2, z=3\ncmds.getFluidAttr( at=\'density\', xi=1, yi=2, zi=3 )\n\n# get the velocity at the cell  x=1, y=2, z=3\ncmds.getFluidAttr( at=\'velocity\', xi=1, yi=2, zi=3 )\n\n# get the x-component of the velocity at cell x=1,\n# y=2, z=3\ncmds.getFluidAttr( xvalue=True, at=\'velocity\', xi=1, yi=2, zi=3 )\n\n# get the first component (red) of the rgb vector-valued\n# attribute "color" at the cell x=1, y=2, z=3\ncmds.getFluidAttr( xvalue=True, at=\'color\', xi=1, yi=2, zi=3 )\n\n# get the velocity x component the plane x=5\ncmds.getFluidAttr( at=\'velocity\', x=True, xi=5 )',
 'getInputDeviceRange': "import maya.cmds as cmds\n\n# This will return a single value which is the minimum value\n# the spaceball translate:X axis can return.\ncmds.getInputDeviceRange( 'spaceball', 'translate:X', min=True )\n\n# This will return an array containing the maximum values for\n# all of the spaceball axes.\ncmds.getInputDeviceRange( 'spaceball', max=True )\n\n# Warning:\n#     Maya is dependent on the device driver or plugin to supply it with\n#     the correct value.  Some device drivers don't return correct\n#     information.",
 'getLastError': '',
 'getMetadata': "import maya.cmds as cmds\n\nimport maya.cmds as cmds\ncmds.polyPlane( name='smcPlane', constructionHistory=False )\n# Result: smcPlane #\ncmds.pickWalk( d='down' )\n# Result: [u'smcPlaneShape'] #\n\n# Create structures\ncmds.dataStructure( format='raw', asString='name=idStructure:int32=ID' )\n# Result: idStructure #\ncmds.dataStructure( format='raw', asString='name=keyValueStructure:string=value' )\n# Result: keyValueStructure #\n\n# Apply structures to plane\ncmds.addMetadata( structure='idStructure', streamName='idStream', channelName='vertex' )\ncmds.addMetadata( structure='keyValueStructure', streamName='keyValueStream', channelName='key', indexType='string' )\n\n# Set the metadata values on three of the components by selection\ncmds.select( 'smcPlaneShape.vtx[8:10]', replace=True )\ncmds.editMetadata( streamName='idStream', memberName='ID', value=7 )\n# Result: 1 #\n\n# Retrieve the three newly set metadata values\ncmds.select( 'smcPlaneShape', replace=True )\ncmds.getMetadata( streamName='idStream', memberName='ID', channelName='vertex', index=['8','9','10'] )\n# Result: [[7], [7], [7]] #\n\n# List stream names of the shape\ncmds.select( 'smcPlaneShape', replace=True )\ncmds.getMetadata( listStreamNames=True )\n# Result: [u'keyValueStream', u'idStream'] #\n\n# List stream names which is in the specified channel\ncmds.select( 'smcPlaneShape', replace=True )\ncmds.getMetadata( channelName='vertex', listStreamNames=True )\n# Result: [u'idStream'] #\n\n# List stream names of the shape which has the specified member\ncmds.select( 'smcPlaneShape', replace=True )\ncmds.getMetadata( memberName='ID', listStreamNames=True )\n# Result: [u'idStream'] #\n\n# List channel names which is used by the specified stream\ncmds.select( 'smcPlaneShape', replace=True )\ncmds.getMetadata( streamName='idStream', listChannelNames=True )\n# Result: [u'vertex'] #\n\n# List channel names which has the specified member\ncmds.select( 'smcPlaneShape', replace=True )\ncmds.getMetadata( memberName='ID', listChannelNames=True )\n# Result: [u'vertex'] #\n\n# List member names which is used by the specified stream\ncmds.select( 'smcPlaneShape', replace=True )\ncmds.getMetadata( streamName='idStream', listMemberNames=True )\n# Result: [u'ID'] #\n\n# Query data type of the listed member\ncmds.select( 'smcPlaneShape', replace=True )\ncmds.getMetadata( streamName='idStream', listMemberNames=True, dataType=True )\n# Result: [u'ID', u'int32'] #\n\n# Query data type of the specified member\ncmds.select( 'smcPlaneShape', replace=True )\ncmds.getMetadata( streamName='idStream', memberName='ID', dataType=True )\n# Result: [u'int32'] #\n\n# Get metadata from a larger group of indices all at once.\n# Note that unassigned metadata values assume the default (0 for numbers).\ncmds.select( 'smcPlaneShape.vtx[7:10]', replace=True )\ncmds.getMetadata( streamName='idStream', memberName='ID' )\n# Result: [[0], [7], [7], [7]] #\n\n# Set metadata values using the complex index type stream\ncmds.editMetadata( streamName='keyValueStream', memberName='value', stringValue='Starry Night', index='Title' )\n# Result: True #\ncmds.editMetadata( streamName='keyValueStream', memberName='value', stringValue='Vincent Van Gogh', index='Artist' )\n# Result: True #\n\n# Retrieve the complex index data (note return is in alphabetical order of index)\ncmds.getMetadata( streamName='keyValueStream', memberName='value', channelName='key', index=['Title', 'Artist'], indexType='string' )\n# Result: [['Vincent Van Gogh'], ['Starry Night']] #",
 'getModifiers': "import maya.cmds as cmds\n\ndef PrintModifiers(*args):\n    mods = cmds.getModifiers()\n    print 'Modifiers are:'\n    if (mods & 1) > 0: print ' Shift'\n    if (mods & 4) > 0: print ' Ctrl'\n    if (mods & 8) > 0: print ' Alt'\n    if (mods & 16): print ' Command/Windows'\n\ncmds.window()\ncmds.columnLayout()\ncmds.button( label='Press Me', command=PrintModifiers )\ncmds.showWindow()",
 'getModulePath': "import maya.cmds as cmds\n\ncmds.getModulePath(moduleName='myModule')",
 'getPanel': 'import maya.cmds as cmds\n\ncmds.getPanel( all=True )\ncmds.getPanel( type=\'modelPanel\' )\ncmds.getPanel( containing=\'button0\' )\ncmds.getPanel( underPointer=True )\ncmds.getPanel( withFocus=True )\n\n# Whenever the hotBox\'s \'noClickCommand\' is invoked, have it switch the\n# main Maya view to a single pane configuration, displaying the panel\n# which was under the mouse pointer at the time the \'hotBox\' command was\n# executed.\ndef panePopAt(x, y):\n\tpanel = cmds.getPanel(atPosition=(x, y))\n\tif panel != \'\':\n\t\tmel.eval(\'doSwitchPanes(1, { "single", "\' + panel + \'" })\')\n\ncmds.hotBox(noClickCommand=panePopAt, noClickPosition=True)',
 'getParticleAttr': "import maya.cmds as cmds\n\ncmds.getParticleAttr( 'particle1', at='velocity' )\n\n# This will return the average velocity for the entire particle\n# object as well as the maximum offset from the average.\n\ncmds.getParticleAttr( 'particleShape1.pt[0:7]', 'particleShape1.pt[11]', at='velocity' )\n\n# This will return the average velocity for particles 0-7 and 11\n# as well as the maximum offset from the average.\n\ncmds.getParticleAttr( 'particleShape1.pt[0:7]', 'particleShape1.pt[11]', at='position', array=1 )\n# This will return an array of 27 floats containing the position\n# values for the nine specified particles.",
 'getProcArguments': '',
 'getRenderDependencies': 'import maya.cmds as cmds\n\n# Return the dependencies of render target myRenderTarget.\n#\nimport maya.cmds as cmds\ndependencies = cmds.getRenderDependencies(myRenderTarget)',
 'getRenderTasks': "import maya.cmds as cmds\n\n# Return render tasks for myImageSource.\n#\nimport maya.cmds as cmds\ntasks = cmds.getRenderTasks('myImageSource', c='myCamera', rl='myRenderLayer')",
 'ghosting': 'import maya.cmds as cmds\n\n\nimport maya.cmds as cmds\n\n# Turn off all ghost drawing\ncmds.ghosting( enable=False )\n\n# Change the default actions to prevent walking down the DAG hierarchies when finding objects to ghost/unghost\ncmds.ghosting( hierarchy=False )\n\n# Ghost the selected objects\ncmds.ghosting( action=\'ghost\' )\n# Result: "OBJECT1" #\n\n# Unghost the selected objects\ncmds.ghosting( action=\'unghost\' )\n# Result: "OBJECT1" #\n\n# Unghost all objects\ncmds.ghosting( action=\'unghostAll\' )\n# Result: "OBJECT1" #\n\n# Set the mode to use only keyframes as specified, rather than every one in the playback range for ghosts\ncmds.ghosting( mode=\'keyframes\' )\ncmds.ghosting( allInRange=False )\n\n# Set three custom ghost frames\ncmds.ghosting( mode=\'custom\' )\ncmds.ghosting( customFrames=-9999999 )\ncmds.ghosting( query=True, customFrames=True )\n# Return: [] #\ncmds.ghosting( customFrames=[1,2,50] )\n\n# Set the opacity of the ghost farthest from the current frame\ncmds.ghosting( farOpacity=0.01 )\n\n# Query the current list of ghost frames using the ghost parameters on OBJECT1\ncmds.ghosting( OBJECT1, query=True, frames=True )\n# Return: [1.0, 2.0, 50.0] #\n\n# Make future ghosting actions skip geometry objects (e.g. meshes)\ncmds.ghosting( geometryFilter=True )\n\n# Get the list of currently ghosted objects\ncmds.ghosting( query=True, ghostedObjects=True )\n# Return: OBJECT1 #\n\n# Change the number of ghosted frames after the current time to 2\ncmds.ghosting( postFrames=2 )\n\n# Change the number of ghosted frames before the current time to 5\ncmds.ghosting( preFrames=5 )\n\n# Change the step between ghosts to be 2\ncmds.ghosting( ghostsStep=2 )\n\n# Make future ghosting actions skip joints\ncmds.ghosting( jointFilter=True )\n\n# Make future ghosting actions skip locators\ncmds.ghosting( locatorFilter=True )\n\n# Change the ghosting mode to only have ghosts before the current frame\ncmds.ghosting( mode=\'pre\' )\n\n# Set the opacity of the ghost closest to the current frame\ncmds.ghosting( nearOpacity=0.1 )\n\n# Set the color of ghosts after the current time to be green\ncmds.ghosting( postColor=[0.0, 1.0, 0.0] )\n\n# Set the color of ghosts before the current frame to red and modify all existing ghosts to use that color\ncmds.ghosting( edit=True, allGhostedObjects=True, preColor=[1.0, 0.0, 0.0] )\n# Return: OBJECT1 #\n\n# Set the preset to show every other ghost\ncmds.ghosting( preset=\'2s\' )\n\n# Set the preset to show 5 pre frames, 2 post frames, at every 5th frame\ncmds.ghosting( preset=\'Custom\' )\ncmds.ghosting( preFrames=5 )\ncmds.ghosting( postFrames=2 )\ncmds.ghosting( ghostsStep=5 )\ncmds.ghosting( mode=\'preAndPost\' )\n\n# Reset all cmds.ghosting(  parameters to their default values\ncmds.ghosting( resetAll=True )\n# Return: True #\n\n# Set the use-driver default for the ghosts\ncmds.ghosting( useDriver=True )',
 'glRender': 'import maya.cmds as cmds\n\n# Do a hardware render\ncmds.glRender(e=1)',
 'glRenderEditor': "import maya.cmds as cmds\n\n# Create a glRender editor, using the top view\nwindow = cmds.window()\ncmds.paneLayout()\ncmds.glRenderEditor(lookThru='top')\ncmds.showWindow( window )",
 'globalStitch': "import maya.cmds as cmds\n\n# GlobalStitch across three surfaces surface1, surface2, surface3.\ncmds.globalStitch( 'surface1', 'surface2', 'surface3', ch=True )",
 'goal': "import maya.cmds as cmds\n\ncmds.sphere( name='surface1')\ncmds.particle( name='Particle')\n\ncmds.goal( 'Particle', g='surface1', w=.75 )\n\n# This command assigns surface1 as a goal of Particle with a goal\n# weight of 0.75.\n\ncmds.goal( 'Particle', g='surface1', w=.75, utr=1 )\n\n# This command assigns the transform of surface1 as a goal of Particle\n# with a goal weight of 0.75.\n\ncmds.goal( 'Particle', g='camera1', w=.75 )\n\n# This command assigns the transform of camera1 as a goal of Particle\n# with a goal weight of 0.75.  The -utr flag is not relevant because\n# only the transform can be used for any object other than geometry\n# or particles.",
 'grabColor': 'import maya.cmds as cmds\n\ncmds.grabColor()\ncmds.grabColor( hsv=True, alpha=True )\ncolor = cmds.grabColor()',
 'gradientControl': "import maya.cmds as cmds\n\n# Create a ramp widget for the profileCurve attribute\n#\ncmds.window( title='Gradient Control For Attribute' )\nobjName = cmds.createNode('polySplitRing')\ncmds.columnLayout()\ncmds.gradientControl( at='%s.profileCurve' % objName )\ncmds.showWindow()\n\n# To add a ramp widget in the attribute editor, call the\n# AEaddRampControl mel script.\n#",
 'gradientControlNoAttr': "import maya.cmds as cmds\n\n# Create a window with a gradient control for an optionVar\n#\ncmds.window( title='Gradient Control For OptionVar' )\ncmds.optionVar(stringValueAppend=['falloffCurveOptionVar', '0,1,2'])\ncmds.optionVar(stringValueAppend=['falloffCurveOptionVar', '1,0,2'])\ncmds.columnLayout()\ncmds.gradientControlNoAttr( 'falloffCurve', h=90)\ncmds.gradientControlNoAttr( 'falloffCurve', e=True, optionVar='falloffCurveOptionVar' )\ncmds.showWindow()\n\n# Query for the value on the curve at a given position.\n#\ncmds.gradientControlNoAttr( 'falloffCurve', q=True, valueAtPoint=0.5 )",
 'graphDollyCtx': "import maya.cmds as cmds\n\n# Create a dolly view context for the graph editor\n#\ncmds.graphDollyCtx( 'graphDollyContext' )",
 'graphSelectContext': "import maya.cmds as cmds\n\n# Create a selection context for the hypergraph editor.\n#\ncmds.graphSelectContext( 'hyperGraphSelectContext' )",
 'graphTrackCtx': "import maya.cmds as cmds\n\n# Create a track view context for the graph editor\n#\ncmds.graphTrackCtx( 'graphTrackContext' )",
 'gravity': 'import maya.cmds as cmds\n\ncmds.gravity( \'particle1\' )\n# Creates a gravity field and adds it to the list of fields\n# owned by particle1.\n\ncmds.gravity( pos=(-2, 0, 4) )\n# Creates a gravity field at position (0,2,4) in world coordinates.\n\ncmds.gravity( \'MyGravity\', e=True, att=10.4 )\n# Changes the gravitational acceleration of the field called\n# "MyGravity" to 10.4.\n\ncmds.gravity( dx=0, dy=1.0, dz=0.5 )\n# Creates a gravity field pulling in direction (0,1,0.5) for every\n# active selection. If there is no active selection, it creates this\n# field at world position (0,0,0).',
 'grid': "import maya.cmds as cmds\n\n#To toggle the grid display of the grid (in all views):\ncurrState = cmds.grid( toggle=True, q=True )\ncmds.grid( toggle=(currState == 0) )\n\n# To reset the grid to default values:\ncmds.grid( reset=True )\n\n# To change the grid spacing and subdivisions:\ncmds.grid( spacing=10, d=10 )\n\n# To set the defaults for inches\ncmds.grid( default=True, spacing='1in', size='1ft', divisions=4 )\n\n# To change the size of the grid to 20x20, extending 10 units\n# in each direction:\ncmds.grid( spacing=10 )\n\n# To query the current size of the grid:\n# returns a size in the current linear unit.\ncmds.grid( query=True, size=True )\n\n# A typical grid would be a grid size of 20x20, with\n# major grid lines every 10 units, with 10 divisions between\n# major grid lines. This be done with the following command.\ncmds.grid( size='10cm', sp='10.0cm', d=10 )\n\n# Turn on numeric grid labels.\n#\ncmds.grid( displayPerspectiveLabels=True )\n\n# Display grid labels along the axes.\n#\ncmds.grid( perspectiveLabelPosition='axis' )",
 'gridLayout': 'import maya.cmds as cmds\n\ncmds.window()\ncmds.gridLayout( numberOfColumns=2, cellWidthHeight=(50, 50) )\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.showWindow()',
 'group': "import maya.cmds as cmds\n\n# create an empty group node with no children\ncmds.group( em=True, name='null1' )\n\n# create some objects and group them\ncmds.sphere( n='sphere1' )\ncmds.circle( n='circle1' )\ncmds.group( 'circle1', 'sphere1', n='group1' )\n\n# create a group node under another node and move\n# the sphere under the new group node.\ncmds.group( 'sphere1', parent='null1' )",
 'groupParts': '',
 'hardenPointCurve': 'import maya.cmds as cmds\n\n# Make the example curve.\ncmds.curve( d=3, p=((-7.253894, 0, 10.835724), (-7.423939, 0, 6.977646), (-7.400778, 0, 2.798971), (-7.458196, 0, -1.524959), (-2.411453, 0, -1.07677), (1.44791, 0, -0.8977448), (5.526346, 0, -0.8610371), (5.740407, 0, 3.780402), (6.293634, 0, 7.571941), (5.957847, 0, 10.72273), (2.753946, 0, 10.894312), (-0.6375988, 0, 11.062571), (-5.889847, 0, 10.940658)), k=(0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 10) )\n\n# Raise the ones that you want to have "sharp" corners\ncmds.hardenPointCurve( \'curve1.cv[3]\', \'curve1.cv[6]\', \'curve1.cv[9]\', ch=True, rpo=True, m=-1 )\n\n# Same result, as the in-between CVs are ignored:\ncmds.undo()\ncmds.hardenPointCurve( \'curve1.cv[0:12]\', ch=1, rpo=1, m=-1 )',
 'hardware': 'import maya.cmds as cmds\n\ncmds.hardware( cpu=True )\ncmds.hardware( brd=True )',
 'hardwareRenderPanel': "import maya.cmds as cmds\n\ncmds.window( width=500 )\ntheLayout = cmds.formLayout()\ntheHWbuffer = cmds.hardwareRenderPanel()\ncmds.formLayout( theLayout, e=True, af=((theHWbuffer, 'top', 0), (theHWbuffer, 'left', 0), (theHWbuffer, 'bottom', 0), (theHWbuffer, 'right', 0)) )\ncmds.showWindow()",
 'hasMetadata': 'import maya.cmds as cmds\n\nimport maya.cmds as cmds\ncmds.polyPlane( name=\'smcPlane\', constructionHistory=False )\n# Result: smcPlane #\n\n# Create structures\ncmds.dataStructure( format=\'raw\', asString=\'name=idStructure:int32=ID\' )\n# Result: idStructure #\ncmds.dataStructure( format=\'raw\', asString=\'name=keyValueStructure:string=value\' )\n# Result: keyValueStructure #\n\n# Apply structures to plane\ncmds.select( \'smcPlaneShape\', replace=True )\ncmds.addMetadata( structure=\'idStructure\', streamName=\'idStream\', channelName=\'vertex\' )\ncmds.addMetadata( structure=\'keyValueStructure\', streamName=\'keyValueStream\', channelName=\'key\', indexType=\'string\' )\n\n# Apply the metadata values to three of the components by selection\ncmds.select( \'smcPlaneShape.vtx[8:10]\', replace=True )\ncmds.editMetadata( streamName=\'idStream\', memberName=\'ID\', value=7 )\n# Result: 3 #\n\n# Verify existence of the three newly set metadata values at the node level\ncmds.select( \'smcPlaneShape\', replace=True )\ncmds.hasMetadata()\n# Result: [True] #\n\n# Verify existence of the three newly set metadata values at the Channel level\ncmds.hasMetadata( channelName=\'vertex\' )\n# Result: [True] #\ncmds.hasMetadata( channelName=\'edge\' )\n# Result: [False] #\n\n# Verify existence of the three newly set metadata values at the Stream level\ncmds.hasMetadata( channelName=\'vertex\', streamName=\'idStream\' )\n# Result: [True] #\ncmds.hasMetadata( channelName=\'edge\', streamName=\'someOtherStream\' )\n# Result: [False] #\n\n# Verify existence of the three newly set metadata values at the Index level\ncmds.hasMetadata( channelName=\'vertex\', streamName=\'idStream\', index=[\'8\',\'9\'] )\n# Result: [True, True] #\ncmds.hasMetadata( channelName=\'vertex\', streamName=\'idStream\', index=[\'8\',\'9999\'] )\n# Result: [True, False] #\n\n# Verify existence of default metadata values at the Index level. Since the\n# index range was established to be 0-17 by assignment and the Stream\n# defaults to returning default values for unassigned indices the lower index\n# values "0" and "1" do have metadata (as default values) but the higher one\n# "9999" in the above example does not.\ncmds.hasMetadata( channelName=\'vertex\', streamName=\'idStream\', index=[\'0\',\'1\'] )\n# Result: [True, True] #\n\n# Verify non-existence of non-default metadata values at the Index level\ncmds.hasMetadata( ignoreDefault=True, channelName=\'edge\', streamName=\'idStream\', memberName=\'ID\', index=[\'0\',\'1\'] )\n# Result: [False, False] #\n\n# Get the list of Index values with assigned metadata on the object\ncmds.select( \'smcPlaneShape.vtx[8:20]\', replace=True )\ncmds.hasMetadata( channelName=\'vertex\', streamName=\'idStream\', asList=True )\n# Result: [u\'8\', u\'9\', u\'10\'] #\n\n# Set metadata values using the complex index type=\'string\'\ncmds.editMetadata( streamName=\'keyValueStream\', memberName=\'value\', stringValue=\'Starry Night\', indexType=\'string\', index=\'Title\' )\ncmds.editMetadata( streamName=\'keyValueStream\', memberName=\'value\', stringValue=\'Vincent Van Gogh\', indexType=\'string\', index=\'Artist\' )\n\n# Verify existence of the complex index data\ncmds.hasMetadata( streamName=\'keyValueStream\', memberName=\'value\', channelName=\'key\', index=[\'Title\',\'Artist\'], indexType=\'string\', asList=True )\n# Result: [u\'Artist\', u\'Title\'] #',
 'headsUpDisplay': 'import maya.cmds as cmds\n\n#\n#Define a procedure that returns a value to be used by the Heads Up Display\n#\ndef objectPosition(*args):\n\ttry:\n\t\tselectedNodes = cmds.selectedNodes()\n\t\tmainObj = selectedNodes[-1]\n\t\tpositionList = cmds.getAttr(\'%s.translate\' % mainObj)\n\t\treturn positionList[0]\n\texcept:\n\t\treturn (0.0,0.0,0.0)\n\n#\n#Now, create a HUD object to display the return value of the above procedure\n#\n#Attributes:\n#\n#        - Section 1, block 0, represents the top second slot of the view.\n#        - Set the blockSize to "medium", instead of the default "small"\n#        - Assigned the HUD the label: "Position"\n#        - Defined the label font size to be large\n#        - Assigned the HUD a command to run on a SelectionChanged trigger\n#        - Attached the attributeChange node change to the SelectionChanged trigger\n#          to allow the update of the data on attribute changes.\n#\ncmds.headsUpDisplay( \'HUDObjectPosition\', section=1, block=0, blockSize=\'medium\', label=\'Position\', labelFontSize=\'large\', command=objectPosition, event=\'SelectionChanged\', nodeChanges=\'attributeChange\' )\n\n#\n#Create a preset HUD object to display the camera names.\n#\n#Attributes:\n#\n#    - Section 2, block 0, represents the top middle slot of the view.\n#    - Using blockalign, the HUD object is centered in the middle of the block\n#    - Setting a dw of 50, allocates a space of 50 pixels for the data to reside in.\n#    - Finally setting the preset to "cameraNames", selects a preset which will\n#      automatically insert the associated data into the data field.\n#\ncmds.headsUpDisplay( \'HUDCameraName\', s=2, b=0, ba=\'center\', dw=50, pre=\'cameraNames\')\n\n#\n#Now, remove these two HUDs. Both can be removed in three ways: name, ID or position.\n#The following examples will demonstrate removal by name and position\n#\ncmds.headsUpDisplay( \'HUDObjectPosition\', rem=True )\n\ncmds.headsUpDisplay( rp=(7, 0) )',
 'headsUpMessage': "import maya.cmds as cmds\n\ncmds.headsUpMessage( 'Ouch!' )\ncmds.headsUpMessage( 'This is Circle 1', object='circle1' )\ncmds.headsUpMessage( 'These objects are selected', selection=True )\ncmds.headsUpMessage( 'Text appears for minimum of 5 seconds.', time=5.0 )\ncmds.headsUpMessage( 'Text appears 0 pixels above point.', verticalOffset=20 )\ncmds.headsUpMessage( 'Text appears 20 pixels to the left of the point.', horizontalOffset=-20 )",
 'help': "import maya.cmds as cmds\n\n# List all commands starting with a, b or c\ncmds.help( '[a-c]*', list=True )\n\n# List all commands without vowels!\ncmds.help( '[^aeiou]+', list=True )\n\n# Print a message explaining how to use help\ncmds.help()\n\n# Bring up the main on-line help index\ncmds.help( doc=True)\n\n# Bring up the Python version of command documentation for the polySphere\n# command\ncmds.help( language='python', doc='polySphere' )\n\n# Bring up the on-line help for the disable command.\ncmds.help( 'disable', doc=True )",
 'helpLine': "import maya.cmds as cmds\n\n#    Create a window with a menu bar, some buttons and a help\n#    line.  Attach some annontations to the UI so that they\n#    appear in the help line.\n#\nwindow = cmds.window( menuBar=True )\ncmds.menu( label='File' )\ncmds.menuItem( label='New', annotation='Help for New' )\ncmds.menuItem( label='Open', annotation='Help for Open' )\ncmds.menuItem( label='Close', annotation='Help for Close' )\n\nform = cmds.formLayout()\ncolumn = cmds.rowLayout(numberOfColumns=4,\n                        columnWidth4=(32, 32, 32, 32),\n                        columnAttach4=('both', 'both', 'both', 'both'))\ncmds.button( label='A', height=32, annotation='Help for A' )\ncmds.button( label='B', height=32, annotation='Help for B' )\ncmds.button( label='C', height=32, annotation='Help for C' )\ncmds.button( label='D', height=32, annotation='Help for D' )\ncmds.setParent( '..' )\n\nframe = cmds.frameLayout( labelVisible=False )\ncmds.helpLine()\ncmds.formLayout( form, edit=True,\n                 attachForm=((column, 'top', 0), (column, 'left', 0),\n                             (column, 'right', 0), (frame, 'left', 0),\n                             (frame, 'bottom', 0), (frame, 'right', 0)),\n                 attachNone=((column, 'bottom'), (frame, 'top')) )\ncmds.showWindow( window )",
 'hide': "import maya.cmds as cmds\n\ncmds.hide( all=True )\ncmds.hide( cmds.ls( type='nurbsSurface' ) )",
 'hikGlobals': 'import maya.cmds as cmds\n\n# Enable the global release all pinning HIK flag\ncmds.hikGlobals( rap=1 )',
 'hilite': 'import maya.cmds as cmds\n\n#    Create a few objects.\n#\nsphere = cmds.sphere()\ncmds.move( 0, 0, 3, relative=True )\ncone = cmds.cone()\ncmds.move( 0, 0, -3, relative=True )\ncylinder = cmds.cylinder()\n\n#    Select the sphere.\n#\ncmds.select( sphere, replace=True )\n\n#    Add the cone and cylinder to the hilite list.\n#\ncmds.hilite( cone[0], cylinder[0] )\n\n#    Toggle the hilite state of the cylinder.\n#\ncmds.hilite( cylinder[0], toggle=True )\n\n#    Replace the hilite list with the current selected objects.\n#\ncmds.hilite( replace=True )',
 'hitTest': 'import maya.cmds as cmds\n\n#    Let\'s say that you have the name of a model editor that was\n#    created elsewhere.\n#\neditor = "MyModelEditor"\n\n#    Here\'s your drop callback:\n#\ndef myModelEditorDropCallback( dragControl,\n\t\t\t\t\t\t\t   dropControl,\n\t\t\t\t\t\t\t   msgs,\n\t\t\t\t\t\t\t   x,\n\t\t\t\t\t\t\t   y,\n\t\t\t\t\t\t\t   type ):\n\t#\tInside the callback we can hit-test the (x,y) drop-point\n\t#\tagainst the control. This will return a list of DAG objects\n\t#\tunderneath the drop-point.\n\t#\n\tobjects = cmds.hitTest( dropControl, x, y )\n\tif len( objects ):\n\t\t#\tThe hit-test returned something. You can now do something\n\t\t#\twith these objects.\n\t\tpass\n\n#\n#\tAttach a drop callback to this model editor.\n#\ntry:\n\tcontrol = cmds.editor( editor ,query=True, control=True )\n\tif cmds.control( control, exists=True ):\n\t\tcmds.control( control, edit=True, dropCallback=myModelEditorDropCallback )\nexcept RuntimeError:\n\tpass',
 'hotBox': 'import maya.cmds as cmds\n\n# Bind the hotBox to the spacebar.\n#\ncmds.nameCommand( \'NameComPop_hotBox\', annotation=\'Pop Hotbox\', command=\'hotBox\' )\ncmds.hotkey( k=\' \', name=\'NameComPop_hotBox\' )\n\n# Give the hotBox a \'noClickCommand\' which displays the screen position at\n# which the hotBox was requested. Note that \'showPos\' function is passed\n# to the \'noClickCommand\' flag as a function, not as a string. This is necessary\n# to allow Maya to pass the coordinates to it properly.\n#\ndef showPos(x, y):\n    print("hotBox requested at (%d, %d)" % (x, y))\n\ncmds.hotBox(noClickCommand=showPos, noClickPosition=True)',
 'hotkey': 'import maya.cmds as cmds\n\n# Here\'s an example of how to create a namedCommand\n# object and then map it to a key.\n#\ncmds.nameCommand( \'circleToolNamedCommand\', annotation=\'Select Circle Tool\', command=\'setToolTo circleContext\')\ncmds.hotkey( k=\'F5\', alt=True, name=\'circleToolNamedCommand\' )\n\n\n# Here are more examples of how to use the hotkey command.\n#\ncmds.hotkey( k=\'d\', name=\'Delete_Command\' )\ncmds.hotkey( k=\'d\', name=\'\' ) # unsets the above command\n\ncmds.hotkey( k=\'d\', name=\'Delete_Command\' )\ncmds.hotkey( k=\'d\', releaseName=\'After_Delete_Command\' )\ncmds.hotkey( k=\'d\', name=\'\' ) #only unsets the key press name\ncmds.hotkey( k=\'d\', releaseName=\'\' ) #only unsets the key release name\ncmds.hotkey( k=\'d\', n=\'\', rn=\'\' ) #unsets both the key press and release name\n\n#    Determine if a command is attached to either the press or release\n#    of the "z" hotkey.\n#\ncmds.hotkey( \'z\', query=True )\n\n#    Likewise, for the modified variations of the "z" key.\n#\ncmds.hotkey( \'z\', query=True, alt=True )\ncmds.hotkey( \'z\', query=True, ctl=True )\ncmds.hotkey( \'z\', query=True, alt=True, ctl=True )\n\n#    Determine the press command attached to the "z" key.\n#\ncmds.hotkey( \'z\', query=True, name=True )\n\n#    To query the "-" hotkey use the string "Dash" instead.\n#\ncmds.hotkey( \'Dash\', query=True )',
 'hotkeyCheck': 'import maya.cmds as cmds\n\n#    Create a window in which you can type a hotkey character\n#    and determine via the \'hotkeyCheck\' command the annotation\n#    of the command attached.\n#\nwindow = cmds.window( title=\'hotkeyCheck Example\' )\ncmds.columnLayout( adjustableColumn=True )\n\n#    A few instructions in a scrollField for the user.\n#\ninstructions = "Enter a single character in the field below.  \\\nThen press the \'Query\' button to determine the annotation of the command attached to that hotkey."\n\ncmds.scrollField( text=instructions, editable=False, height=120, wordWrap=True )\ntextFieldGrp = cmds.textFieldGrp( label="Enter a single hotkey character", text=\'a\', columnWidth2=(200, 50) )\n\n#    Create a couple controls for specifying modifier keys and the\n#    key press/release information.\n#\ncheckBoxGrp = cmds.checkBoxGrp( label="Modifiers",\n\t\t\t\t\t\t\tnumberOfCheckBoxes=2,\n\t\t\t\t\t\t\tlabelArray2=(\'Ctrl\', \'Alt\'),\n\t\t\t\t\t\t\tcolumnWidth3=(100, 75, 75))\nradioButtonGrp = cmds.radioButtonGrp( label="Action",\n\t\t\t\t\t\t\tnumberOfRadioButtons=2,\n\t\t\t\t\t\t\tselect=1,\n\t\t\t\t\t\t\tlabelArray2=(\'Press\', \'Release\'),\n\t\t\t\t\t\t\tcolumnWidth3=(100, 75, 75))\n\n#    Create a scroll field for printing the results.\n#\nscrollField = cmds.scrollField(editable=False, height=120, wordWrap=True)\n\n#    Create a button for querying the hotkey.\n#\ncmds.button( label=\'Query\', command=(\'ExampleHotkeyCheck("\' + textFieldGrp + \'","\' + checkBoxGrp + \'","\' + radioButtonGrp + \'","\' + scrollField + \'")\'))\ncmds.showWindow( window )\n\n#    This procedure uses the \'hotkeyCheck\' command to determine the\n#    annotation of the command attached to a hotkey.\n#\ndef ExampleHotkeyCheck( textFieldGrp, checkBoxGrp, radioButtonGrp, scrollField):\n\t#    Get the hotkey character, modifier state and key press/release\n\t#    information from the window.\n\t#\n\tkey = cmds.textFieldGrp(textFieldGrp, query=True, text=True)\n\tctrl = cmds.checkBoxGrp(checkBoxGrp, query=True, value1=True)\n\talt = cmds.checkBoxGrp(checkBoxGrp, query=True, value2=True)\n\tpress = cmds.radioButtonGrp(radioButtonGrp, query=True, select=True)\n\n\t#    Get the hotkey mapping taking into consideration key up or down\n\t#    and the state of the modifier keys.\n\t#\n\tif 1 == press:\n\t\tif not ctrl and not alt:\n\t\t\tmapping = cmds.hotkeyCheck(keyString=key)\n\t\t\tresult = key + \'-Press\'\n\t\telif ctrl and not alt:\n\t\t\tmapping = cmds.hotkeyCheck(keyString=key, ctl=True)\n\t\t\tresult = \'Ctrl-\' + key + \'-Press\'\n\t\telif not ctrl and alt:\n\t\t\tmapping = cmds.hotkeyCheck(keyString=key, alt=True)\n\t\t\tresult = \'Alt-\' + key + \'-Press\'\n\t\telif ctrl and alt:\n\t\t\tmapping = cmds.hotkeyCheck(keyString=key, ctl=True, alt=True)\n\t\t\tresult = \'Ctrl-Alt-\' + key + \'-Press\'\n\telse:\n\t\tif not ctrl and not alt:\n\t\t\tmapping = cmds.hotkeyCheck(keyString=key, keyUp=True)\n\t\t\tresult = key + \'-Release\'\n\t\telif ctrl and not alt:\n\t\t\tmapping = cmds.hotkeyCheck(keyString=key, ctl=True, keyUp=True)\n\t\t\tresult = \'Ctrl-\' + key + \'-Release\'\n\t\telif not ctrl and alt:\n\t\t\tmapping = cmds.hotkeyCheck(keyString=key, alt=True, keyUp=True)\n\t\t\tresult = \'Alt-\' + key + \'-Release\'\n\t\telif ctrl and alt:\n\t\t\tmapping = cmds.hotkeyCheck(keyString=key, ctl=True, alt=True, keyUp=True)\n\t\t\tresult = \'Ctrl-Alt-\' + key + \'-Release\'\n\n\n\t#    Print the results in the example window.\n\t#\n\tif mapping == "": mapping = \'Nothing\'\n\tcmds.scrollField( scrollField, edit=True, text=(result + \' is mapped to:\\n\\n\' + mapping ) )',
 'hotkeyCtx': "import maya.cmds as cmds\n\n# Here are some examples of how to use hotkeyCtx command.\n#\n\n# Create a new context type\ncmds.hotkeyCtx( insertTypeAt=('Global', 'CustomEditor') )\ncmds.hotkeyCtx( ita=('CustomEditor', 'CustomTool') )\n\n# Query all existing context types\nctxTypes = cmds.hotkeyCtx( typeArray=True, query=True )\nprint str(ctxTypes)\n\n# Remove an existing context type\ncmds.hotkeyCtx( removeType='CustomTool' )\n\n# Determine if the given context type exists.\ncmds.hotkeyCtx( te='CustomTool', query=True )\n\n# Associate the clients to the specific context type.\ncmds.hotkeyCtx( t='CustomEditor', ac=['hyperGraphPanel', 'outlinerPanel'] )\n\n# Set current context\ncmds.hotkeyCtx( t='CustomEditor', cc='hyperGraphPanel' )\n\n# Unassign the client from the specific context type.\ncmds.hotkeyCtx( t='CustomEditor', rc='outlinerPanel' )\n\n# Query all associated clients for the given context type.\ncl = cmds.hotkeyCtx( t='CustomEditor', ca=True, query=True )\nprint str(cl)\n\n# Remove all associated clients\ncmds.hotkeyCtx( t='CustomEditor', rac=True )",
 'hotkeyEditor': '',
 'hotkeyEditorPanel': 'import maya.cmds as cmds\n\nwindow = cmds.window( widthHeight=(400, 300) )\ncmds.hotkeyEditorPanel()\ncmds.showWindow( window )',
 'hotkeyMapSet': '',
 'hotkeySet': 'import maya.cmds as cmds\n\n# Create a new key set and set it as the active key set.\n# The current active hotkey set is used as its source.\nMyNewKeySet = \'MyNewKeySet\'\ncmds.hotkeySet( MyNewKeySet, current=True )\n\n# Query the name of the current key set\ncmds.hotkeySet( q=True, current=True )\n\n# Create a new hotkey set with a user hotkey set as source\nMyNewKeySet2 = \'MyNewKeySet2\'\ncmds.hotkeySet( MyNewKeySet2, source=\'MyNewKeySet\' )\n\n# Delete the created hotkey set.\ncmds.hotkeySet( MyNewKeySet, edit=True, delete=True )\n\n# Returns all available hotkey sets in Maya\ncmds.hotkeySet( q=True, hotkeySetArray=True )\n\n# Export a hotkey set\nfileName = (cmds.internalVar( userTmpDir=True ) + "exportHotkeySet1.mhk");\ncmds.hotkeySet( MyNewKeySet2, e=True, export=fileName);\n\n# Import a hotkey set\ncmds.hotkeySet( e=True, ip=fileName);',
 'hudButton': 'import maya.cmds as cmds\n\n# Define a "Hello!" counter procedure. This procedure will output\n# "Hello! [number]"\n# each time it is run. The number is incremented at the end of each call.\n#\ngHelloCount = 0\n\ndef HUDButtonHello(*args):\n  global gHelloCount\n  print \'Hello!( %i )\' % gHelloCount\n  gHelloCount += 1\n\n# Now create our button. Only execute on mouse release.\n#\ncmds.hudButton(\'HUDHelloButton\', s=7, b=5, vis=1, l=\'Button\', bw=80, bsh=\'roundRectangle\', rc=HUDButtonHello )',
 'hudSlider': 'import maya.cmds as cmds\n\n# Define a procedure to execute on press/drag/release. This procedure\n# will explicitly set any selected transforms to a given position along\n# the X axis based on the value of a given HUD slider.\n#\n\ndef translateXSlider( HUD ):\n\t# Since undo is not turned off automatically, we must\n\t# do it ourselves. The HUD will fire off many calls to this\n\t# procedure during a drag so we don\'t want to flood the undo\n\t# queue.\n\tcmds.undoInfo( swf=False )\n\ttry:\n\t\tfor object in cmds.ls( sl=True ):\n\t\t\tif cmds.objectType( object, isType=\'transform\' ):\n\t\t\t   translateX = object + \'.tx\'\n\t\t\t   value = cmds.hudSlider( HUD, q=True, v=True )\n\t\t\t   cmds.setAttr( translateX, value )\n\tfinally:\n\t\t# Re-enable the undo queue.\n\t\tcmds.undoInfo( swf=True)\n\n# Now create our slider HUD\n#\ncmds.hudSlider( \'HUDTranslateXSlider\',\n\t\t\t\tsection=2,\n\t\t\t\tblock=5,\n\t\t\t\tvisible=1,\n\t\t\t\tlabel="TranslateX:",\n\t\t\t\tvalue=0,\n\t\t\t\ttype="int",\n\t\t\t\tminValue=-10,\n\t\t\t\tmaxValue=10,\n\t\t\t\tlabelWidth=80,\n\t\t\t\tvalueWidth=50,\n\t\t\t\tsliderLength=100,\n\t\t\t\tsliderIncrement=1,\n\t\t\t\tpressCommand=\'translateXSlider( "HUDTranslateXSlider" )\',\n\t\t\t\tdragCommand=\'translateXSlider( "HUDTranslateXSlider" )\',\n\t\t\t\treleaseCommand=\'translateXSlider( "HUDTranslateXSlider" )\')',
 'hudSliderButton': 'import maya.cmds as cmds\n\n# Define a procedure to execute on press/drag/release. This procedure\n# will explicitly set any selected transforms to a given position along\n# the X axis based on the value of a given HUD slider.\n#\ndef translateXSliderButton( HUD ):\n\tcmds.undoInfo( swf=True )\n\tselList = cmds.ls( sl=True )\n\tfor object in selList:\n\t\tif cmds.objectType( object, isType=\'transform\' ):\n\t\t\tcmds.setAttr( object+".tx", cmds.hudSliderButton( HUD, query=True, v=True ) )\n\n# Create our slider button.  Use lambda to create an "anonymous" function that invokes the\n# callback with the desired button name argument.\n#\ncmds.hudSliderButton( \'HUDTranslateXSliderButton\', s=5, b=5, vis=True, sl=\'Slider:\', value=0, type=\'int\', min=-10, max=10, slw=50, vw=50, sln=100, si=1, bl=\'Button\', bw=60, bsh=\'rectangle\', brc=lambda : translateXSliderButton( \'HUDTranslateXSliderButton\' ))',
 'hwReflectionMap': "import maya.cmds as cmds\n\ncmds.hwReflectionMap( cm=1, en=1, ftn='D:\\\\Textures\\\\room.front.jpg', bkn='D:\\\\Textures\\\\room.back.jpg', tpn='D:\\\\Textures\\\\room.top.jpg', bmn='D:\\\\Textures\\\\room.bottom.jpg', ltn='D:\\\\Textures\\\\room.left.jpg', rtn='D:\\\\Textures\\\\room.right.jpg', smn='D:\\\\Textures\\\\room.front.jpg' )",
 'hwRender': "import maya.cmds as cmds\n\n# Create a poly sphere.\ncmds.polySphere()\n\n# Render it\ncmds.hwRender()\n\n# Render the region where left=20, right=50, bottom=30, top=60.\n# And do not write the output to a file.\n#\ncmds.hwRender( renderRegion=(20, 50, 30, 60), notWriteToFile=True )\n\n# Render with the specified width and height.\n#\ncmds.hwRender( width=100, height=200 )\n\n# Returns the imageFileName for image frame 11.\n#\ncmds.hwRender( imageFileName=True, frame=11 )\n\n# Returns the imageFileName for current frame.\n#\ncmds.hwRender( imageFileName=True )\n\n# Returns a version of the image file name after its number pattern\n# being represented in a unique way.\n#\ncmds.hwRender( query=True, fixFileNameNumberPattern=True )\n\n# Render the specified render layer.\ncmds.hwRender( layer='layer1' )",
 'hwRenderLoad': 'import maya.cmds as cmds\n\n# Load the HW render engine\ncmds.hwRenderLoad()',
 'hyperGraph': 'import maya.cmds as cmds\n\n# The hyperGraph command is not one which would commonly be used\n# by the user.\ncmds.polySphere( r=1, sx=20, sy=20, ax=(0, 1, 0), tx=2, ch=1 )\n\n# Gets the position of the node in the graph.\nmaya.mel.eval( "HypergraphHierarchyWindow" )\nposition = cmds.hyperGraph( \'hyperGraphPanel1HyperGraphEd\', query=True, getNodePosition=\'pSphere1\' )\nprint position',
 'hyperPanel': 'import maya.cmds as cmds\n\ncmds.window()\ncmds.frameLayout( lv=False )\ncmds.hyperPanel()\ncmds.showWindow()',
 'hyperShade': "import maya.cmds as cmds\n\ncmds.sphere()\ncmds.cone()\nmyBlinn = cmds.shadingNode('blinn', asShader=True)\ncmds.select( 'nurbsSphere1' )\ncmds.hyperShade( assign=myBlinn )\ncmds.select( cl=True )\ncmds.hyperShade( objects=myBlinn )\n\nblinn = cmds.createNode('blinn')\ncmds.select( 'lambert1', blinn )\ncmds.hyperShade( objects='' )\n\ncmds.polySphere(sx=20,sy=20)\ncmds.hyperShade( assign=myBlinn, geo=['pSphere1.f[300:359]', 'pSphere1.f[380:399]'])",
 'iconTextButton': "import maya.cmds as cmds\n\nwindow = cmds.window()\ncmds.columnLayout( adjustableColumn=True )\ncmds.iconTextButton( style='textOnly', image1='sphere.png', label='sphere' )\ncmds.iconTextButton( style='iconOnly', image1='spotlight.png', label='spotlight' )\ncmds.iconTextButton( style='iconAndTextHorizontal', image1='cone.png', label='cone' )\ncmds.iconTextButton( style='iconAndTextVertical', image1='cube.png', label='cube' )\ncmds.showWindow( window )",
 'iconTextCheckBox': "import maya.cmds as cmds\n\nwindow = cmds.window()\ncmds.columnLayout( adjustableColumn=True )\ncmds.iconTextCheckBox( style='textOnly', image1='sphere.png', label='sphere' )\ncmds.iconTextCheckBox( style='iconOnly', image1='spotlight.png', label='spotlight' )\ncmds.iconTextCheckBox( style='iconAndTextHorizontal', image1='cone.png', label='cone' )\ncmds.iconTextCheckBox( style='iconAndTextVertical', image1='cube.png', label='cube' )\ncmds.showWindow( window )",
 'iconTextRadioButton': "import maya.cmds as cmds\n\ncmds.window( tlc=(100, 400) )\ncmds.columnLayout( adj=True )\ncmds.iconTextRadioCollection( 'itRadCollection' )\ncmds.iconTextRadioButton( st='textOnly', i1='sphere.png', l='sphere' )\ncmds.iconTextRadioButton( st='iconOnly', i1='spotlight.png', l='spotlight' )\ncmds.iconTextRadioButton( st='iconAndTextHorizontal', i1='cone.png', l='cone' )\ncmds.iconTextRadioButton( st='iconAndTextVertical', i1='cube.png', l='cube' )\ncmds.showWindow()",
 'iconTextRadioCollection': "import maya.cmds as cmds\n\ncmds.window( tlc=(100, 400) )\ncmds.columnLayout( adj=True )\ncmds.iconTextRadioCollection( 'itRadCollection' )\ncmds.iconTextRadioButton( st='textOnly', i1='sphere.png', l='sphere' )\ncmds.iconTextRadioButton( st='iconOnly', i1='spotlight.png', l='spotlight' )\ncmds.iconTextRadioButton( st='iconAndTextHorizontal', i1='cone.png', l='cone' )\ncmds.iconTextRadioButton( st='iconAndTextVertical', i1='cube.png', l='cube' )\ncmds.showWindow()",
 'iconTextScrollList': "import maya.cmds as cmds\n\ncmds.window()\ncmds.paneLayout()\ncmds.iconTextScrollList(allowMultiSelection=True, append=('one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'ten', 'eleven', 'twelve', 'thirteen', 'fourteen', 'fifteen'), selectItem='six' )\ncmds.showWindow()",
 'iconTextStaticLabel': "import maya.cmds as cmds\n\ncmds.window( tlc=(100, 400) )\ncmds.columnLayout()\ncmds.iconTextStaticLabel( st='textOnly', i1='sphere.png', l='sphere' )\ncmds.iconTextStaticLabel( st='iconOnly', i1='spotlight.png', l='spotlight' )\ncmds.iconTextStaticLabel( st='iconAndTextHorizontal', i1='cone.png', l='cone' )\ncmds.iconTextStaticLabel( st='iconAndTextVertical', i1='cube.png', l='cube' )\ncmds.showWindow()",
 'ikHandle': "import maya.cmds as cmds\n\n# Will create a handle from Joint-1 to an end-effector at\n# the location of Joint-5 with a priority of 2 and a\n# weight of 0.5\n#\ncmds.ikHandle( sj='joint1', ee='joint5', p=2, w=.5 )\n\n# Create a handle called leg from the start joint\n# named hip to the end-effector named Ankle.\n#\ncmds.ikHandle( n='Leg', sj='Hip', ee='Ankle' )",
 'ikHandleCtx': "import maya.cmds as cmds\n\n#    Edit an existing context to create an ikHandle with snapping on.\n#\nif cmds.ikHandleCtx( 'ikHandleCtx', q=True, ex=True ):\n  cmds.ikHandleCtx('ikHandleCtx', e=True, snapHandleH=True)",
 'ikHandleDisplayScale': 'import maya.cmds as cmds\n\n# Half the display size with respect to the default size.\ncmds.ikHandleDisplayScale( 0.5 )',
 'ikSolver': "import maya.cmds as cmds\n\n# creates fooSolver of type ikSCsolver with max error of 0.5\n#\ncmds.ikSolver( st='ikSCsolver', ep=0.5, n='fooSolver' )",
 'ikSplineHandleCtx': "import maya.cmds as cmds\n\n#    Edit an existing context to create an ikSplineHandle with\n#    the curve parented to the corresponding joint.\n#\nif cmds.ikSplineHandleCtx( 'ikSplineHandleCtx', q=True, ex=True ):\n  cmds.ikSplineHandleCtx('ikSplineHandleCtx', e=True, parentCurve=True)",
 'ikSystem': 'import maya.cmds as cmds\n\n# Prints out the solver execution order\n#\ncmds.ikSystem( q=True, ls=True )\n\n# Moves solver on position 2 to position 1 in\n# the execution order list ( zero based index )\n#\ncmds.ikSystem( e=True, ls=(1, 0) )',
 'ikSystemInfo': 'import maya.cmds as cmds\n\n# Enable global handle snapping\n#\ncmds.ikSystemInfo( gsh=True )',
 'ikfkDisplayMethod': "import maya.cmds as cmds\n\n# Just display ik.\n#\ncmds.ikfkDisplayMethod( display='ik' )\n\n# Display ik and fk when the handle is selected\n#\ncmds.ikfkDisplayMethod( display='ikfk' )",
 'illustratorCurves': "import maya.cmds as cmds\n\n# Create curves from an input Adobe(R) Illustrator(R) file d:/sample.ai\n# and scale factor 2.54\ncmds.illustratorCurves( ifn='d:/sample.ai', sf=2.54 )",
 'image': 'import maya.cmds as cmds\n\n#    Note that for this example to work you must substitute\n#    "image" below with the full path name to a valid image.\n#\nwindow = cmds.window()\ncmds.paneLayout()\ncmds.image( image=\'image\' )\ncmds.showWindow( window )',
 'imagePlane': 'import maya.cmds as cmds\n\n\timport maya.cmds as cmds\n\n\t// create image plane with width and height example\n\tmyImagePlane = cmds.imagePlane( width=100, height=50 )\n\n\t// create image plane with width and maintainRatio off\n\tmyImagePlane = cmds.imagePlane( width=100, maintainRatio=False )\n\n\t// create free image plane with look through camera specified.\n\tmyImagePlane =  cmds.imagePlane( lookThrough="persp")\n\n\t// create free image plane with look through camera specified let it only show when looking through this specified camera.\n\tmyImagePlane =  cmds.imagePlane( lookThrough="persp", showInAllViews=false)\n\n\t// edit image plane example\n\tcmds.imagePlane( myImagePlane[1], e=True, w=100, h=200, mr=False ) ;\n\n\t// edit free image plane with look through camera specified.\n\tmyImagePlane =  cmds.imagePlane( myImagePlane[1], e=True, lookThrough="side")\n\n\t// query image width height example\n\tcmds.imagePlane( myImagePlane[1], q=True, w=True, h=True ) ;\n\n\t// Create image plane with name\n\tcmds.imagePlane( name="Foo") ;\n\tcmds.imagePlane( width=100, height=50, name="Foo") ;\n\n\t// query loaded image ratio\n\tcmds.imagePlane( myImagePlane[1], q=True, iz=True );\n\n\t// Create image plane under a specified camera\n\tcamera = cmds.camera()\n\tcmds.imagePlane(camera=camera[1])',
 'imageWindowEditor': '',
 'imfPlugins': "import maya.cmds as cmds\n\ncmds.imfPlugins( query=True )\n# returns a list of all imf plugin names\ncmds.imfPlugins( 'pluginName', query=True, ext=True )\n# returns image file extension of the plugin\ncmds.imfPlugins( 'pluginName', query=True, key=True )\n# returns IMF keyword of the plugin\ncmds.imfPlugins( 'imfKeyWord', query=True, pn=True )\n# returns plugin name corresponding to imf keyword\ncmds.imfPlugins( 'imfKeyWord', query=True, ws=True )\n# returns true if this plugin key supports write operations\ncmds.imfPlugins( 'imfKeyWord', query=True, rs=True )\n# returns true if this plugin key supports read operations\ncmds.imfPlugins( 'imfKeyWord', query=True, mfs=True )\n# returns true if this plugin key supports multiframe input/output",
 'inViewEditor': 'import maya.cmds as cmds\n\n#Show the In-View Editor outside the Show Manips context\ncmds.inViewEditor(visible=1)',
 'inViewMessage': "import maya.cmds as cmds\n\n# Create a user assist message in the center of the viewport with some of the text highlighted in yellow.\n# The message will fade out after the default time.\ncmds.inViewMessage( amg='In-view message <hl>test</hl>.', pos='midCenter', fade=True )",
 'inheritTransform': "import maya.cmds as cmds\n\n# create an circle, move it off center, group it\n# and move the group so that the circle is back in center\ncmds.circle( nr=(0, 1, 0), n='circle1' )\ncmds.move( 2, 0, 0 )\ncmds.group()\ncmds.move( -2, 0, 0 )\n\n# turn off inherits transform flag of circle1.\n# The circle will now appear at (2, 0, 0)\ncmds.inheritTransform( 'circle1', off=True )\n\n# turn off inherits transform flag of circle1 but preserve the\n# position of the circle. The circle will stay centered at (0, 0, 0)\ncmds.inheritTransform( 'circle1', on=True )\ncmds.inheritTransform( 'circle1', off=True, preserve=True )\n\n# query state of inherits transform flag\ncmds.inheritTransform( 'circle1', q=True )",
 'insertJoint': "import maya.cmds as cmds\n\n# Will insert a new joint under joint2. Child joints of joint2 will be\n# under the new inserted joint.\ncmds.insertJoint( 'joint2' )",
 'insertJointCtx': 'import maya.cmds as cmds\n\ncmds.insertJointCtx()',
 'insertKeyCtx': "import maya.cmds as cmds\n\n# Create a insert key context for the graph editor\n#\ncmds.insertKeyCtx( 'insertKeyContext' )",
 'insertKnotCurve': "import maya.cmds as cmds\n\ncmds.insertKnotCurve( 'curve1', ch=True, p=0.3, nk=2 )\ncmds.insertKnotCurve( 'curve1.u[0.3]', ch=True, nk=2 )\n# Both commands will insert two knots into curve1 at parameter value 0.3.\n# Because the ch flag is used, a dependency node is created.\n\ncmds.insertKnotCurve( 'curve1', ch=True, add=False, p=0.5, nk=3 )\n# Inserts enough knots into curve1 at parameter value 0.5 to\n# achieve a knot multiplicity of 3.  Because the ch flag is used,\n# a dependency node is created.\n\ncmds.insertKnotCurve( 'curve1', ch=True, p=(0.3, 0.5, 0.8) )\n# Inserts a default of one knot at each parameter value: 0.3, 0.5 and 0.8.\n\ncmds.insertKnotCurve( 'curve1', ch=True, p=(0.3, 0.5, 0.8), nk=2 )\n# Inserts two knots at each parameter value: 0.3, 0.5 and 0.8.\n\ncmds.insertKnotCurve( 'curve1', ch=True, p=(0.1, 0.3, 0.5, 0.8), nk=(1, 2) )\n# RuntimeError: Number of knot flags must match number of parameter flags.",
 'insertKnotSurface': 'import maya.cmds as cmds\n\ncmds.insertKnotSurface( \'surface1\', ch=True, p=0.3, d=0 )\ncmds.insertKnotSurface( \'surface1.v[0.3]\', ch=True )\n# Inserts one knot (which is the default) into surface1 at\n# parameter value v = 0.3.  When an isoparm is specified, the direction\n# and parameter value is implied and the "p" and "d" flags can be omitted.\n\ncmds.insertKnotSurface( \'surface1\', ch=True, p=0.3, nk=2, d=0 )\n# Inserts two knots into surface1 at parameter value v = 0.3.\n\ncmds.insertKnotSurface( \'surface1\', ch=True, p=0.3, p=0.5, p=0.8, nk=2, d=0 )\n# Inserts two knots at each parameter value v = 0.3, 0.5 and 0.8.\n\ncmds.insertKnotSurface( \'surface1\', ch=True, p=0.5, add=False, nk=3, d=1 )\n# Inserts enough knots into surface1 at parameter value u = 0.5 to\n# achieve a knot multiplicity of 3.',
 'instance': "import maya.cmds as cmds\n\n# Create a hierarchy\ncmds.sphere( n='sphere1' )\ncmds.move( 3, 0, 0 )\ncmds.sphere( n='sphere2' )\ncmds.move( -3, 0, 0 )\ncmds.group( 'sphere1', 'sphere2', n='group1' )\ncmds.group( 'group1', n='group2' )\n\n# Create an instance of one of the spheres\ncmds.instance( 'sphere1' )\n\n# Duplicate the hierarchy except for the shapes which are\n# instanced.instances of all leaf level shapes\ncmds.instance( 'group1', leaf=True )\n\n# Create a row of 4 instanced circles which are equally spaced\ncmds.circle( n='circle1' )\ncmds.instance()\ncmds.move( 3, 0, 0 )\ncmds.instance( smartTransform=True )\ncmds.instance( smartTransform=True )",
 'instanceable': "import maya.cmds as cmds\n\n# create a sphere.\n# flag the transform and its shape as non-instanceable, then try to instance the sphere.\n# you get an error because the shape is non-instanceable.\ncmds.sphere()\ncmds.instanceable( allow=0, shape=True )\ncmds.instance()\n# Error: '|nurbsSphere1' has non-instanceable children thus it cannot be instanced.\n\n# Flag the sphere and its shape as instanceable. Then it can be instanced.\ncmds.instanceable( allow=1, shape=True )\ncmds.instance()\n# Result: nurbsSphere2 #",
 'instancer': "import maya.cmds as cmds\n\ncmds.polySphere(n='myShape')\ncmds.instancer( name='myInstancerNode', a=True, object='myShape' )",
 'intField': 'import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout()\ncmds.intField()\ncmds.intField( editable=False )\ncmds.intField( minValue=-10, maxValue=10, value=0 )\ncmds.intField( minValue=-1000, maxValue=1000, step=10 )\ncmds.showWindow()',
 'intFieldGrp': "import maya.cmds as cmds\n\nwindow = cmds.window()\ncmds.columnLayout()\ncmds.intFieldGrp( numberOfFields=3, label='Scale', extraLabel='cm', value1=3, value2=5, value3=1 )\ncmds.showWindow( window )",
 'intScrollBar': 'import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout( adjustableColumn=True )\ncmds.intScrollBar()\ncmds.intScrollBar( min=-100, max=100, value=0, step=1, largeStep=10 )\ncmds.showWindow()',
 'intSlider': 'import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout( adjustableColumn=True )\ncmds.intSlider()\ncmds.intSlider( min=-100, max=100, value=0, step=1 )\ncmds.showWindow()',
 'intSliderGrp': "import maya.cmds as cmds\n\n#    Create a window with a couple integer slider groups.  The first will\n#    use default limit values, and the second will set up a group that has\n#    a field range greater than the slider range.  Try entering values\n#    greater than the slider limits in both groups.\n#\nwindow = cmds.window( title='intSliderGrp Example' )\ncmds.columnLayout()\ncmds.intSliderGrp( field=True, label='Group 1' )\ncmds.intSliderGrp( field=True, label='Group 2', minValue=-10, maxValue=10, fieldMinValue=-100, fieldMaxValue=100, value=0 )\ncmds.showWindow( window )",
 'interactionStyle': '',
 'internalVar': 'import maya.cmds as cmds\n\nmyScriptDir = cmds.internalVar(userScriptDir=True)',
 'intersect': "import maya.cmds as cmds\n\n# Intersect the two active surfaces and create the resulting curve on\n# surface as a 3D curve (note: only one 3D curve is created for each\n# pair of intersecting surfaces):\ncmds.intersect( cos=True )\n\n# Intersect the nurbs sphere and nurbs plane, creating a curve-on-surface\n# on each surface:\ncmds.intersect( 'nurbsSphere1', 'nurbsPlane1', fs=True )",
 'iprEngine': "import maya.cmds as cmds\n\n# Create a iprEngine and tell it about an already created ipr image.\ncmds.iprEngine(ipr='iprImages/persp_scene1_ipr.iff')\n\n# Tell the iprEngine about the region to update.\ncmds.iprEngine( 'iprEngine1', e=True, region=(10, 10, 100, 100))\n\n# Tell the iprEngine to watch changes and update pixels.\ncmds.iprEngine( 'iprEngine1', e=True, startTuning=True )",
 'isConnected': 'import maya.cmds as cmds\n\ncmds.sphere( n=\'jupiter\' )\ncmds.sphere( n=\'io\' )\ncmds.connectAttr( \'jupiter.ty\', \'io.ty\' )\n\n# Are the two "tx" attributes on transform1 and transform2 connected?\ncmds.isConnected( \'jupiter.tx\', \'io.tx\' )\n# Result: 0 #\n\n# Are the two "ty" attributes on transform1 and transform2 connected?\ncmds.isConnected( \'jupiter.ty\', \'io.ty\' )\n# Result: 1 #',
 'isDirty': "import maya.cmds as cmds\n\n# Create a plusMinusAverage node and a transform. We set the 'skipSelect'\n# flag so that they are not displayed in the Attribute Editor because\n# that would force an evaluation and cause the plugs to become clean.\nimport maya.cmds as cmds\ncmds.createNode('plusMinusAverage', n='pma', skipSelect=True)\ncmds.createNode('transform', n='t', skipSelect=True)\n\n# Hide the transform so that Maya's draw won't force an evaluation which\n# would clean its plugs.\ncmds.hide('t')\n\n# Connect the transform's 'tx' to one of the plusMinusAverage node's\n# inputs.\ncmds.connectAttr('t.tx', 'pma.input1D[0]')\n\n# Set the value of the transform's 'tx' and check that the\n# target of the connection has become dirty.\ncmds.setAttr('t.tx', 13)\ncmds.isDirty('pma.input1D[0]')\n# Result: 1 #\n\n# If we retrieve the value of the destination attribute\n# then the connection becomes clean.\ncmds.getAttr('pma.input1D[0]')\n# Result: 13.0 #\ncmds.isDirty('pma.input1D[0]')\n# Result: 0 #\n\n# A plusMinusAverage node's 'output1D' attribute depends\n# upon the values in its 'input1D' array. Since we haven't\n# retrieved its value yet, it should still be dirty. However,\n# it seems to be clean:\ncmds.isDirty('pma.output1D')\n# Result: 0 #\n\n# The reason for this is that the 'isDirty' command\n# by default only checks connections and 'output1D' has\n# no connection to be dirty. If we instead check its\n# value in the datablock, we get the expected result:\ncmds.isDirty('pma.output1D', d=True)\n# Result: 1 #\n\n# The output value will remain dirty until we\n# force its evaluation by retrieving it.\ncmds.getAttr('pma.output1D')\n# Result: 13.0 #\ncmds.isDirty('pma.output1D', d=True)\n# Result: 0 #",
 'isTrue': "import maya.cmds as cmds\n\ncmds.isTrue( 'SomethingSelected' )\n# Result: 1 #",
 'isolateSelect': "import maya.cmds as cmds\n\n# create some primitives and go into component selection mode\ncmds.sphere( n='sphere1' )\ncmds.cone( n='cone1' )\ncmds.selectMode( component=True )\n\n# Use the current modelPanel for isolation\nisolated_panel = cmds.paneLayout('viewPanes', q=True, pane1=True)\n\n# turn on isolate select mode for a particular 3d view. Only\n# the sphere and the selected CVs will be displayed.\ncmds.select( 'sphere1.cv[0:2][*]' )\n# Connect the selected objects with editor and\n# locks the current list of objects within the mainConnection\ncmds.editor( isolated_panel, edit=True, lockMainConnection=True, mainListConnection='activeList' )\ncmds.isolateSelect( isolated_panel, state=1 )\n\n# add the cone to the list of objects to be viewed\ncmds.select( 'cone1' )\ncmds.isolateSelect( isolated_panel, addSelected=True )\n\n# make just the sphere the object to be viewed\ncmds.select( 'sphere1' )\n# Unlock the current list of objects within the editor\ncmds.editor( isolated_panel, edit=True, mainListConnection='activeList' )\ncmds.isolateSelect( isolated_panel, loadSelected=True )",
 'itemFilter': 'import maya.cmds as cmds\n\n#    Create a filter that will pass all transforms.\n#\ntransforms = cmds.itemFilter(byType=\'transform\')\n\n#    Create a filter that will pass all spot lights.\n#\nspotLights = cmds.itemFilter(byType=\'spotLight\')\n\n#    There are two ways to create a filter that passes both\n#    spot lights and transforms.  You can create a filter\n#    that is a union of the previous two or just specify\n#    both object types on one filter.\n#\nunionFilter = cmds.itemFilter(union=(transforms, spotLights))\nspotLightsAndTransforms = cmds.itemFilter(byType=(\'transform\',\'spotLight\'))\n\n#    Create a filter that lists all objects beginning with the\n#    letter "a".\n#\naFilter = cmds.itemFilter(byName=\'a*\')\n\n#    Create a filter that lists only transforms and spot lights\n#    that begin with the letter "a".\n#\nintersectionFilter = cmds.itemFilter( intersect=(spotLightsAndTransforms, aFilter) )\n\n#    Delete the filters when done with them.\n#\ncmds.delete( transforms, spotLights, aFilter )\ncmds.delete( unionFilter, intersectionFilter )',
 'itemFilterAttr': "import maya.cmds as cmds\n\n#    Create a filter that will pass all the SRT (scale-rotate-translate)\n#    attributes.\n#\nsrtFilter = cmds.itemFilterAttr('itemFilterAttr', scaleRotateTranslate=True)\n\n#    Create a filter that will pass all the attributes driven by an\n#    expression.\n#\nexprFilter = cmds.itemFilterAttr(hasExpression=True)\n\n#    Create a filter that will pass all the SRT attributes driven by an\n#    expression (intersect two previous ones).\n#\nsrtExprFilter = cmds.itemFilterAttr(intersect=(srtFilter, exprFilter))\n\n#    Delete the filters when done with them.\n#\ncmds.delete( srtFilter, exprFilter, srtExprFilter )",
 'itemFilterRender': '',
 'itemFilterType': "import maya.cmds as cmds\n\n#    Create a filter that will pass all spot lights and transforms.\n#\nfilter = cmds.itemFilter(byType=('transform', 'spotLight'))\n\n#    Now query the type of the filter.\n#\ntype = cmds.itemFilterType(filter, q=True, type=True)\nprint( 'Filter type: ' + type + '\\n' )\n\n#    Delete the filter.\n#\ncmds.delete( filter )",
 'iterOnNurbs': '',
 'joint': "import maya.cmds as cmds\n\n# Create a 3-joint chain\n#\ncmds.select( d=True )\ncmds.joint( p=(0, 0, 0) )\ncmds.joint( p=(0, 4, 0)  )\ncmds.joint( 'joint1', e=True, zso=True, oj='xyz' )\ncmds.joint( p=(0, 8, -1) )\ncmds.joint( 'joint2', e=True, zso=True, oj='xyz' )\n\n# Create a fourth joint with z joint limits of -90 deg for\n# the lower limit and 90 deg for the upper limit.  The\n# joint will be positioned at (0, 0, 4) in world\n# coordinates.\n#\ncmds.joint( lz=('-90deg', '90deg'), p=(0, 8, 4) )\n\n# Set the joint limits but leave them disabled.\ncmds.joint( edit=True, lz=('-90deg', '90deg'), lsz=False )",
 'jointCluster': "import maya.cmds as cmds\n\n# To add a joint cluster to a rigidly bound skin.\n# Note the skin should be at bind pose when the cluster is added.\n#\ncmds.jointCluster( j='joint2', ab=20, bb=20 )",
 'jointCtx': "import maya.cmds as cmds\n\n#    Create a joint context that makes a ikHandle with an ikRPSolver.\n#    The use the tool.\n#\ncmds.jointCtx( 'myJointContext', createIKHandle=True, solverTypeH='ikRPsolver' )\ncmds.setToolTo( 'myJointContext' )",
 'jointDisplayScale': 'import maya.cmds as cmds\n\n# Half the display size with respect to the default size.\n#\ncmds.jointDisplayScale( 0.5 )\n\n# Set the display diameter of the joint to 2 linear units.\n#\ncmds.jointDisplayScale( 2.0, a=True )\n\n# Set the display diameter of ik/fk joints to 2 linear units.\n#\ncmds.jointDisplayScale(2.0, a=True, ik=True);',
 'jointLattice': 'import maya.cmds as cmds\n\n# Select a "dualBase" lattice that is connected to a rigidly bound skin.\n# To create a dualBase lattice, use the dualBase flag on the lattice command.\n#\ncmds.jointLattice( joint=\'joint2\', upperBindSkin=\'joint1Cluster1\',lowerBindSkin=\'joint2Cluster2\' )\ncmds.jointLattice( upperTransform=\'joint1\', lowerTransform=\'joint2\', joint=\'joint2\', upperBindSkin=\'joint1Cluster1\',lowerBindSkin=\'joint2Cluster1\' )\ncmds.jointLattice( \'jointLattice1\', edit=True, creasing=0.5 )',
 'journal': '',
 'keyTangent': 'import maya.cmds as cmds\n\n# Keys on animation curves are identified by either\n# their time values or their indices.  Times and indices can\n# be given as a range or list of ranges.\n\n# time=(\'10pal\',\'10pal\') means the key at frame 10 (PAL format).\n# time=[(\'1.0sec\',\'1.0sec\'),(\'15ntsc\',\'15ntsc\'),(20,20)] means the keys at time 1.0 second, frame 15 (in NTSC format), and time 20 (in the currently defined global time unit).\n# time=(10,20) means all keys in the range from 10 to 20, inclusive, in the current time unit.\n# Omitting one end of a range means "go to infinity", as in the following examples:\n# time=(10,None) means all keys from time 10 (in the current time unit) onwards.\n# time=(10,) means the same as (10,10)\n# time=(0,10) means all keys up to (and including) time 10 (in the current time unit).\n# time=(None,None) is a short form to specify all keys.\n# index=(0,0) means the first key of each animation curve. (Indices are 0-based.)\n# index=[(2,2),(5,5),(7,7)] means the 3rd, 6th, and 8th keys.\n# index=(1,5) means the 2nd, 3rd, 4th, 5th, and 6th keys of each animation curve.\n\n# Set the in-tangent to spline for all keyframes\n# on an object between 1 and 2 seconds.\n#\ncmds.keyTangent( \'nurbsSphere1\', inTangentType=\'spline\', time=(\'0sec\',\'2sec\') )\n\n# Set the angle and value for the out tangent of the\n# keyframe at time 5 of nurbsSphere1\'s translateX.\n#\ncmds.keyTangent( \'nurbsSphere1\', edit=True, time=(5,5), attribute=\'translateX\', absolute=True, outAngle=10, outWeight=5 )',
 'keyframe': 'import maya.cmds as cmds\n\n# Keys on animation curves are identified by either\n# their time values or their indices.  Times and indices can\n# be given as a range or list of ranges.\n\n# time=(\'10pal\',\'10pal\') means the key at frame 10 (PAL format).\n# time=[(\'1.0sec\',\'1.0sec\'),(\'15ntsc\',\'15ntsc\'),(20,20)] means the keys at time 1.0 second, frame 15 (in NTSC format), and time 20 (in the currently defined global time unit).\n# time=(10,20) means all keys in the range from 10 to 20, inclusive, in the current time unit.\n# Omitting one end of a range means "go to infinity", as in the following examples:\n# time=(10,None) means all keys from time 10 (in the current time unit) onwards.\n# time=(10,) means the same as (10,10)\n# time=(0,10) means all keys up to (and including) time 10 (in the current time unit).\n# time=(None,None) is a short form to specify all keys.\n# index=(0,0) means the first key of each animation curve. (Indices are 0-based.)\n# index=[(2,2),(5,5),(7,7)] means the 3rd, 6th, and 8th keys.\n# index=(1,5) means the 2nd, 3rd, 4th, 5th, and 6th keys of each animation curve.\n\nimport maya.cmds as cmds\n\n# Keys on animation curves are identified by either time values or indices.\n# Times and indices can be given as a ranges or list of ranges.\n\n# When specifying times/indices by range,\n#\n#  time=()         means all keys.\n#  time=(10,)      means all keys at time 10 (in the current time unit).\n#  time=(10,20)    means all keys in the range from 10 to 20, inclusive, in the current time unit.\n#  time=(\'10:\',)   means all keys at and after time 10\n#  time=(\':20\',)   means all keys before or at time 20\n#  time=(\'10pal\',) means the key at frame 10 (PAL format).\n#\n#  index=(0,0)     means the first key of each animation curve (i.e., indices are 0-based.)\n#  index=(1,5)     means the 2nd, 3rd, 4th, 5th, and 6th keys of each animation curve.\n#  index=(\'2:\',)   means all keys at and after the 3rd key\n#  index=(\':5\',)   means all keys before or at the 6th key\n#  index=(\'1:5\',)  means the 2nd - 6th keys (inclusive).\n#\n# When specifying times/indices by list\n#\n#  time=[(1.0,1.0),(\'15ntsc\',\'15ntsc\'),(20,20)] means the keys at time 1.0 second, frame 15 (in NTSC format), and time 20 (in the currently defined global time unit).\n#  index=[(2,2),(5,5),(7,7)] means the 3rd, 6th, and 8th keys.\n#\n\n# Two ways to find out how many keys there are on the\n# paramCurve connected to surface1.translateX;\n#\ncmds.keyframe( \'surface1\', attribute=\'translateX\', query=True, keyframeCount=True )\ncmds.keyframe( \'surface1.translateX\', query=True, keyframeCount=True )\n\n# Two ways to query all keyframes of object "surface1" within the time range 0 to 20.\n#\ncmds.keyframe( \'surface1\', time=(0,20), query=True, valueChange=True, timeChange=True);\ncmds.keyframe( \'surface1\', time=(\'0:20\',), query=True, valueChange=True, timeChange=True);\n\n# Three ways to query the time of the second key in the translate X\n# parameter curve. Note that since indices are 0-based, the second key is at index 1.\n#\ncmds.keyframe(\'surface1.translateX\',index=(\'1:1\',),query=True);\ncmds.keyframe(\'surface1.translateX\',index=(1,1),query=True);\ncmds.keyframe(\'surface1.translateX\',index=(1,),query=True);\n\n# Shift all the active object\'s keys in the range 10-20\n# by one (current) time unit (frame, second, etc.)\n#\ncmds.keyframe(edit=True,relative=True,timeChange=1,time=(10,20))\n\n# Two ways to move all keys at time 10 of the active object\n# to time 12.  Note that "-absolute" is the default.\n#\ncmds.keyframe(time=(10,),timeChange=12)\ncmds.keyframe(time=(10,10),absolute=True,timeChange=12)\n\n# Set the 2nd keyframe of cube1\'s Translate X parameter\n# curve to be 10.25 at time 1.5 seconds.\n#\ncmds.keyframe(\'surface1.translateX\',edit=True,index=(1,1),timeChange=\'1.5sec\',valueChange=10.25)\n\n# Evaluate the animCurve feeding into nurbsCone1\'s translateX attribute at time 3\n#\ncmds.keyframe(\'nurbsCone1\',at=\'tx\',t=(3,3),q=True,eval=True)\n\n# Query the times of the active keys on attribute translateX of nurbsCone1\n#\ncmds.keyframe( \'nurbsCone1\', at=\'tx\', sl=True, q=True, tc=True )\n\n# How many keys are selected on nurbsCone1?\n#\ncmds.keyframe( \'nurbsCone1\', sl=True, q=True, kc=True )\n\n# Here\'s a script to print out all a cone\'s animCurves that have\n# keys selected.  Each animCurve is followed by a list of times\n# for the selected keys. The result of this script is:\n#   nurbsCone1_translateX: [5.0]\n#   nurbsCone1_translateY: [12.0]\n#   nurbsCone1_translateZ: [4.0, 14.0]\n#\nmyCone = cmds.cone()\ncmds.setKeyframe( myCone[0], t=[0,5,10], at=\'tx\', v=5 )\ncmds.setKeyframe( myCone[0], t=[2,7,12], at=\'ty\', v=10 )\ncmds.setKeyframe( myCone[0], t=[4,9,14], at=\'tz\', v=15 )\ncmds.selectKey( t=[(5,5),(12,12),(4,4)] )\ncmds.selectKey( animation=\'objects\', add=True, t=(14,14) )\n\nnodes = cmds.keyframe(myCone,query=True,name=True)\nfor node in nodes:\n   keyTimes = cmds.keyframe(node,sl=True,query=True,tc=True)\n   print "  {}: {}".format(node, keyTimes)\n\n# For the above sample script, the last selected key is\n# nurbsCone1_translateZ: 14.  The following may be used to query\n# the values for that key\n#\ncmds.keyframe( query=True, lastSelected=True, name=True )\ncmds.keyframe( query=True, lastSelected=True, timeChange=True )\ncmds.keyframe( query=True, lastSelected=True, valueChange=True )',
 'keyframeOutliner': "import maya.cmds as cmds\n\ncmds.window( 'myWindow', width=850, height=75 )\ncmds.formLayout( 'myForm' )\ncmds.keyframeOutliner( 'myOutliner', animCurve='animCurve1' )\ncmds.formLayout( 'myForm', e=True, af=[('myOutliner', 'top', 0), ('myOutliner', 'left', 0), ('myOutliner', 'bottom', 0), ('myOutliner', 'right', 0)] )\ncmds.showWindow()",
 'keyframeRegionCurrentTimeCtx': 'import maya.cmds as cmds\n\ncmds.keyframeRegionCurrentTimeCtx()',
 'keyframeRegionDirectKeyCtx': "import maya.cmds as cmds\n\n# Create a direct key context for the dope sheet editor\n#\ncmds.keyframeRegionDirectKeyCtx( 'keyframeRegionDirectKeyContext' )",
 'keyframeRegionDollyCtx': "import maya.cmds as cmds\n\n# Create a dolly view context for the dope sheet editor\n#\ncmds.keyframeRegionDollyCtx( 'keyframeRegionDollyContext' )",
 'keyframeRegionInsertKeyCtx': "import maya.cmds as cmds\n\n# Create an insert key context for the dope sheet editor\n#\ncmds.keyframeRegionInsertKeyCtx( 'keyframeRegionInsertKeyContext' )",
 'keyframeRegionMoveKeyCtx': "import maya.cmds as cmds\n\n# Create a move key context which works in insert mode\n# for the dope sheet editor\n#\ncmds.keyframeRegionMoveKeyCtx( 'keyframeRegionMoveKeyContext', option='insert' )",
 'keyframeRegionScaleKeyCtx': "import maya.cmds as cmds\n\n# Create a manipulator style scale key context\n# for the dope sheet editor\n#\ncmds.keyframeRegionScaleKeyCtx( 'keyframeRegionScaleKeyContext', type='rect' )",
 'keyframeRegionSelectKeyCtx': "import maya.cmds as cmds\n\n# Create a select key context for the dope sheet editor\n#\ncmds.keyframeRegionSelectKeyCtx( 'keyframeRegionSelectKeyContext' )",
 'keyframeRegionSetKeyCtx': "import maya.cmds as cmds\n\n# Create a set key context for the dope sheet editor\n#\ncmds.keyframeRegionSetKeyCtx( 'keyframeRegionSetKeyContext' )",
 'keyframeRegionTrackCtx': "import maya.cmds as cmds\n\n# Create a track view context for the dope sheet editor\n#\ncmds.keyframeRegionTrackCtx( 'keyframeRegionTrackContext' )",
 'keyframeStats': "import maya.cmds as cmds\n\ncmds.window( 'myWindow', rtf=0, width=200 )\ncmds.formLayout( 'myForm' )\ncmds.keyframeStats( 'myOutliner' )\ncmds.formLayout( 'myForm', e=True, af=[('myOutliner', 'top', 0), ('myOutliner', 'left', 0), ('myOutliner', 'bottom', 0), ('myOutliner', 'right', 0)] )\ncmds.showWindow()",
 'keyframeTangentControl': 'import maya.cmds as cmds\n\ncmds.window()\ncmds.formLayout()\ncmds.keyframeTangentControl(precision=2)\ncmds.showWindow()',
 'keyingGroup': "import maya.cmds as cmds\n\nimport maya.cmds as cmds\n\ncmds.file(f=1, new=1)\n\n# Create a keying group with keyable attrs of the currently selected\n# object\n#\ncmds.polySphere(n='sphere1')\nsphereKG = cmds.keyingGroup(n='sphereKG')\n\n# Query the members: should return sphere1's visiblity and TRS\nmembers = cmds.keyingGroup(sphereKG, q=True)\n\n# Create a keying group which contains another keying group\nparentKG = cmds.keyingGroup(sphereKG, n='parentKG')\n\n# keying the parent KG should automatically key the sub KGs as well\ncmds.select(parentKG)\ncmds.setKeyframe(time=1)\n\n# Add 2 other spheres to the sphereKG\ncmds.polySphere(n='sphere2');\ncmds.polySphere(n='sphere3');\ncmds.keyingGroup('sphere2', 'sphere3', e=True, add=sphereKG)\n\n# Make another object the activator for the sphereKG. So if\n# this object is keyed, the sphereKG will be keyed\n# Note: the activator itself does not have to be part of the\n# keying group. If it is not part of the keyingGroup, it\n# will not be keyed. So only the spheres will be keyed below.\n# If the cube is to be keyed as well, execute:\n# cmds.keyingGroup('cube1',e=True, add=sphereKG)\ncmds.polyCube(n='cube1')\ncmds.keyingGroup('cube1',e=True,activator=sphereKG)\n\n# Set the global active keying group filter to work on\n# all keying group categories.\ncmds.keyingGroup(fil='AllKeyingGroups')\n\ncmds.select('cube1')\ncmds.setKeyframe(t=10)",
 'lassoContext': "import maya.cmds as cmds\n\n# Create a new lasso context, then switch to it\ncmds.lassoContext('lassoContext1')\ncmds.setToolTo('lassoContext1')",
 'lattice': "import maya.cmds as cmds\n\n# to create a 4x5x4 lattice centered around the sphere\n#\ncmds.sphere();\ncmds.lattice( dv=(4, 5, 4), oc=True )\n\n# to edit the lattice divisions to be 6x6x6\n#\ncmds.lattice( 'ffd1', e=True, dv=(6, 6, 6) )\n\n# move a point on the lattice\ncmds.select('ffd1Lattice.pt[2][2][5]',r=True)\ncmds.move(0,0,3,r=True)\n\n# to reset the lattice\n#\ncmds.lattice( 'ffd1', e=True, lr=True )",
 'latticeDeformKeyCtx': "import maya.cmds as cmds\n\n# Create a lattice manipulator with 4 x 4 lattice.\n#\ncmds.latticeDeformKeyCtx( 'latticeContex', latticeColumns=4, latticeRows=4 )",
 'launch': 'import maya.cmds as cmds\n\n#launch a web browser to open webpage http://www.autodesk.com\ncmds.launch(web="http://www.autodesk.com")',
 'launchImageEditor': "import maya.cmds as cmds\n\n# Create a blinn shader with a psd file texture.\ncmds.shadingNode('blinn', asShader=True)\ncmds.sets(renderable=True, noSurfaceShader=True, empty=True, name='blinn1SG')\ncmds.connectAttr('blinn1.outColor', 'blinn1SG.surfaceShader', f=True)\ncmds.shadingNode('psdFileTex', asTexture=True)\ncmds.connectAttr('psdFileTex1.outColor', 'blinn1.color')\ncmds.setAttr('psdFileTex1.fileTextureName', 'C:/test.psd', type='string')\n\n# Create a poly plane, and assign the blinn shader to it.\ncmds.polyPlane(w=10, h=10, sx=10, sy=10, n='pPlane1')\ncmds.sets(e=True, forceElement='blinn1SG')\n\n# Now you can launch Photoshop to edit this psd texture file\ncmds.launchImageEditor(eif=cmds.getAttr('psdFileTex1.fileTextureName'))",
 'layerButton': "import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout()\n# Create a button for the default layer, colour it red and select it\nb = cmds.layerButton(name='defaultLayer', cl=(1.0, 0.0, 0.0), s=True)\ncmds.showWindow()\n\n# Find out how wide the layer buttons are when created\nwidth = cmds.layerButton(b ,q=True, labelWidth=True )",
 'layeredShaderPort': "import maya.cmds as cmds\n\nlayer = cmds.shadingNode('layeredShader', asShader=True)\ncmds.window()\ncmds.columnLayout('r')\ncmds.layeredShaderPort(n=layer)\ncmds.showWindow()",
 'layeredTexturePort': "import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout('r')\ncmds.layeredTexturePort(n='layeredTexture1')\ncmds.showWindow()",
 'layout': "import maya.cmds as cmds\n\n#    Create a simple window containing a single column layout\n#    and a few buttons.\n#\nwindow = cmds.window(title='Layout Example')\ncolumn = cmds.columnLayout()\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.showWindow( window )\n\n#    If you don't know that the layout is actually a 'columnLayout' then\n#    you may use the 'layout' command to determine certain properties.\n#\ncmds.layout( column, query=True, numberOfChildren=True )\ncmds.layout( column, query=True, childArray=True )\ncmds.layout( column, query=True, height=True )",
 'layoutDialog': 'import maya.cmds as cmds\n\ndef checkboxPrompt():\n\t# Get the dialog\'s formLayout.\n\t#\n\tform = cmds.setParent(q=True)\n\n\t# layoutDialog\'s are not resizable, so hard code a size here,\n\t# to make sure all UI elements are visible.\n\t#\n\tcmds.formLayout(form, e=True, width=300)\n\n\tt = cmds.text(l=\'What do you want to do?\')\n\n\tb1 = cmds.button(l=\'Abort\', c=\'cmds.layoutDialog( dismiss="Abort" )\' )\n\tb2 = cmds.button(l=\'Skip\', c=\'cmds.layoutDialog( dismiss="Skip" )\' )\n\tb3 = cmds.button(l=\'Continue\', c=\'cmds.layoutDialog( dismiss="Continue" )\' )\n\n\tcb1 = cmds.checkBox(label=\'Remember my choice\')\n\n\tspacer = 5\n\ttop = 5\n\tedge = 5\n\n\tcmds.formLayout(form, edit=True,\n\t\t\t\t\tattachForm=[(t, \'top\', top), (t, \'left\', edge), (t, \'right\', edge), (b1, \'left\', edge), (b3, \'right\', edge), (cb1, \'left\', edge), (cb1, \'bottom\', spacer)],\n\t\t\t\t\tattachNone=[(t, \'bottom\'), (b1, \'bottom\'), (b2, \'bottom\'), (b3, \'bottom\'), (cb1, \'right\')],\n\t\t\t\t\tattachControl=[(b1, \'top\', spacer, t), (b2, \'top\', spacer, t), (b3, \'top\', spacer, t), (cb1, \'top\', spacer, b1)],\n\t\t\t\t\tattachPosition=[(b1, \'right\', spacer, 33), (b2, \'left\', spacer, 33), (b2, \'right\', spacer, 66), (b3, \'left\', spacer, 66)])\n\nprint cmds.layoutDialog(ui=checkboxPrompt)',
 'license': 'import maya.cmds as cmds\n\ncmds.license(showProductInfoDialog=True)',
 'licenseCheck': '',
 'lightList': "import maya.cmds as cmds\n\ncmds.lightList( add='foo' )",
 'lightlink': 'import maya.cmds as cmds\n\ncmds.lightlink( light=(\'spotLight1\', \'pointLight2\', \'ambientLight4\'), object=(\'apple\', \'orange\', \'banana\') )\n\n# causes a light link to be "created between"    each of the lights\n# spotLight1, pointLight2, ambientLight4 and each of the objects\n# apple, orange, banana. This creates 9 links. Note that no make,\n# break or query flag is specified so make is assumed since both\n# lights and objects are specified.\n\ncmds.lightlink( make=True, light=\'ceilingLightSet\', object=\'apple\' )\n# causes a light link to be "created between" the ceiling lights and\n# the apple geometry. If apple is already illuminated by\n# ceilingLightSet, then nothing changes and a warning is produced.\n\ncmds.lightlink( object=\'stillLifeSet\', light=\'spotLight1\' )\n# causes a light link to be "created between" spotLight1 and the still\n# life. If stillLifeSet is already illuminated by spotLight1, then\n# nothing changes and a warning is produced. Note: no make, break or\n# query flag is specified so the make flag is assumed since both lights\n# and objects are specified.\n\ncmds.lightlink( light=(\'ceilingLightSet\', \'floorLightSet\'), object=\'tableAndChairsSet\' )\n# causes a light link to be "created between" each of the light sets\n# ceilingLightSet, floorLightSet and the object set tableAndChairsSet.\n\ncmds.lightlink( query=True, light=\'ceilingLightSet\' )\n# will return a string array of objects which are illuminated by the\n# set ceilingLightSet. For example, the return value might be:\n# stillLifeSet table chair floor roomWallsSet binky\n\ncmds.lightlink( query=True, object=\'apple\' )\n# will return a string array of lights which illuminate the object\n# apple. For example, the return value might be ceilingLightSet\n# spotLight1 spotLight2 ambientLight1\n\ncmds.lightlink( object=\'apple\' )\n# will return a string array of lights which illuminate the object\n# apple. For example, the return value might be ceilingLightSet\n# spotLight1 spotLight2 ambientLight1. Note that no make, break\n# or query flag is specified, so query is assumed since no lights\n# are specified.\n\ncmds.lightlink( b=True, light=\'ceilingLightSet\', object=\'apple\' )\n# causes the light set ceilingLightSet to no longer illuminate the\n# object apple. If ceilingLightSet was already not illuminating apple,\n# nothing changes and a warning is produced.',
 'linearPrecision': 'import maya.cmds as cmds\n\ncmds.linearPrecision( 3 )\ncmds.linearPrecision( 10 ) # will be rounded down to 6, the maximum',
 'listAnimatable': 'import maya.cmds as cmds\n\n# List only the attrs driven by the current manip.\n#\ncmds.listAnimatable( manip=True )\n\n# List only the attrs driven by the current manipulator handle.\n#\ncmds.listAnimatable( manipHandle=True )\n\n# List only the types of nodes driven by the current manip.\n#\ncmds.listAnimatable( manip=True, type=True )\n\n# List only the types of the active nodes.\n#\ncmds.listAnimatable( type=True )\n\n# List attributes on active objects (and shapes below them),\n# or active attrs.\n#\ncmds.listAnimatable()\n\n# List types of active objects and types of any shapes below active\n# objects.\n#\ncmds.listAnimatable( type=True )',
 'listAttr': 'import maya.cmds as cmds\n\ncmds.sphere()\ncmds.listAttr( r=True, s=True )\n# This will list the scalar readable attributes of the\n# selected nodes.  If more than one node is selected attributes\n# may be listed several times.\n\ncmds.listAttr( s=True, r=True, w=True, c=True, st=[\'centerX\',\'centerY\'] )\n# This will list all scalar, readable, writable, and connectable\n# attributes whose names are "centerX" or "centerY".\n\ncmds.listAttr( r=True, st=\'center*\', ct=\'a*\' )\n# This will list all readable attributes whose names match\n# "center*" (e.g. "centerX" or "centerpede") and who belong to\n# a category starting with the letter "a".\n\ncmds.listAttr( \'nurbsSphere1\', s=True, cfo=True )\n# This will list all scalar attributes of\n# nurbsSphere1 that have been changed since the\n# file in which nurbsSphere1 is defined has been\n# opened.  If nurbsSphere1 comes from a referenced file,\n# the result will be all the attributes that have changed\n# since the referenced file was opened.',
 'listAttrPatterns': 'import maya.cmds as cmds\n\nimport maya.cmds as cmds\ncmds.listAttrPatterns()\n// Return: ["approvalAttrs", "sceneAndShotAttrs"] //\n\ncmds.listAttrPatterns( patternType=True )\n// Return: "xmlPatternFactory" //\n\ncmds.listAttrPatterns( patternType=True, verbose=True )\n// Return: ["xmlPatternFactory", "xmlPatternFactory/approvalAttrs", "xmlPatternFactory/sceneAndShotAttrs"] //\n\ncmds.listAttrPatterns( verbose=True )\nPattern approvalAttrs\n    PatternFactory xmlPatternFactory:\n    File: "attrPatterns/approvalAttrs.xml"\n    Attribute Count: 8\n    Attribute Tree:\n      fxApproval (compound)\n        fxApprover (string)\n        fxApprovalDate (int)\n        fxApprovalState (enum)\n      layoutApproval (compound)\n        layoutApprover (string)\n        layoutApprovalDate (int)\n        layoutApprovalState (enum)\n  Pattern sceneAndShotAttrs\n    PatternFactory xmlPatternFactory:\n    File: "attrPatterns/sceneAndShotAttrs.xml"\n    Attribute Count: 4\n    Attribute Tree:\n      sceneId (int)\n      sceneOwner (string)\n      shotId (int)\n      shotOwner (string)\n// Return: ["approvalAttrs", "sceneAndShotAttrs"] //',
 'listCameras': 'import maya.cmds as cmds\n\n# List all cameras\ncmds.listCameras()\n\n# List all persp cameras\nperspCameras = cmds.listCameras( p=True )',
 'listConnections': "import maya.cmds as cmds\n\ncmds.sphere( ch=True, n='BALL' )\ncmds.setKeyframe()\n# List all connections to BALL\nlist = cmds.listConnections('BALL')\n\n# List only incoming connections from BALL.tx\ncmds.listConnections( 'BALL.tx', d=False, s=True )\n\n# List connections from BALL to nodes of type 'transform'\ncmds.listConnections( t='transform' )\n\n# List connections on BALL, ignoring unit conversion nodes\ncmds.listConnections( 'BALL', scn=True )",
 'listDeviceAttachments': "import maya.cmds as cmds\n\ncmds.listDeviceAttachments()# List all attachments\n\n# List attachments on the spaceball that are clutched on Button1\ncmds.listDeviceAttachments( d='spaceball', c='Button1' )\n\n# write out attachments for the spaceball device, since there is\n# no file name specified, attachments will be written out to\n# spaceball.mel\ncmds.listDeviceAttachments( d='spaceball', w=True )\n\n# write out attachments for all devices, since there is not file\n# name specified, attachments will be written out to devices.mel\ncmds.listDeviceAttachments( w=True )",
 'listHistory': 'import maya.cmds as cmds\n\ncmds.curve( d=3, p=[(-3, 0, 0),(-1, 0, 6),(6, 0, 8),(8, 0, 2)], k=[0,0,0,1,1,1], n="snake" )\ncmds.instance( n="rattler" )\ncmds.revolve( \'rattler\', ch=True, n="charmer" )\ncmds.revolve( \'snake\', ch=True, n="medusa" )\n\ncmds.listHistory()\n# Result:[u\'medusaShape\', u\'revolve2\', u\'snake|curveShape1\'] #\n\ncmds.listHistory( \'charmer\' )\n# Result:[u\'charmerShape\', u\'revolve1\', u\'rattler|curveShape1\'] #\n\ncmds.listHistory( \'medusa\', lv=1 )\n# Result:[u\'medusaShape\', u\'revolve2\'] #\n\ncmds.listHistory( \'medusa\', future=True )\n# Result:[u\'medusaShape\', u\'initialShadingGroup\'] #\n\n# If you just list the curve\'s future you get both directions\ncmds.listHistory( \'curveShape1\', future=True )\n# Result:[u\'snake|curveShape1\', u\'revolve2\', u\'medusaShape\', u\'revolve1\', u\'charmerShape\'] #\n\n# To follow only one history you\'ll need to follow the path you\n# want first, then add the node you started at if so desired since\n# it will not be included (here snake|curveShape1 won\'t list).\n\n# List the future of the first curve\nhist = cmds.listConnections(\'curveShape1.ws[0]\',c=1)\ncmds.listHistory( hist[1], future=True )\n# Result:[u\'revolve2\', u\'medusaShape\'] #\n\n# List the future of the second curve\nhist = cmds.listConnections(\'curveShape1.ws[1]\',c=1)\ncmds.listHistory( hist[1], future=True )\n# Result:[u\'revolve1\', u\'charmerShape\'] #\n\ncmds.listHistory( leaf=0 )\n# Result:[u\'medusa\'] #',
 'listInputDeviceAxes': "import maya.cmds as cmds\n\n# Returns a list of the axes of the spaceball.\ncmds.listInputDeviceAxes( 'spaceball' )",
 'listInputDeviceButtons': "import maya.cmds as cmds\n\n# Returns a list of the buttons of the spaceball.\ncmds.listInputDeviceButtons( 'spaceball' )",
 'listInputDevices': 'import maya.cmds as cmds\n\n# Returns a list of devices.\ncmds.listInputDevices()',
 'listNodeTypes': "import maya.cmds as cmds\n\n# List all shader types in the system\ncmds.listNodeTypes( 'shader' )\n\n# List all 2D textures that are also shaders\ncmds.listNodeTypes( 'texture/2D:shader' )\n\n# List all volume shading nodes that are neither utility nodes nor particle nodes\ncmds.listNodeTypes( 'shader/volume', ex='shader/volume/utility:shader/volume/particle' )",
 'listNodesWithIncorrectNames': 'import maya.cmds as cmds\n\ncmds.listNodesWithIncorrectNames()',
 'listRelatives': "import maya.cmds as cmds\n\n# create an object and an instance for queries\ncmds.sphere( n='nexus' )\ncmds.instance( n='ball' )\n\n# List the name of the shape below the transform node.\nshapes = cmds.listRelatives('nexus')\n\n# list all parents of shape\n# (The result of the command is shown)\ncmds.listRelatives( shapes[0], allParents=True )\n# Result:[u'nexus', u'ball'] #",
 'listSets': "import maya.cmds as cmds\n\n# Get a list of all the sets which `nurbsSphere1` belongs to:\ncmds.listSets( object='nurbsSphere1' )\n\n# Get a list of all the deformer sets in the scene:\ncmds.listSets( type=2 )\n\n# Get a list of all the rendering sets which `coneShape1` belongs to:\ncmds.listSets( type=1, object='coneShape1' )",
 'loadFluid': 'import maya.cmds as cmds\n\n\n# Load the initial state cache into the fluid\ncmds.loadFluid( ic=True )',
 'loadModule': "import maya.cmds as cmds\n\ncmds.loadModule(scan=True)\ncmds.loadModule(load='myModuleDef')\ncmds.loadModule(allModules=True)",
 'loadPlugin': 'import maya.cmds as cmds\n\n# Load the plug-in named "newNode" into Maya.\n#\ncmds.loadPlugin( \'newNode.py\' )\n\n# Load all the plug-ins found in all the directories that are\n# included in MAYA_PLUG_IN_PATH.\n#\ncmds.loadPlugin( allPlugins=True )',
 'loadPrefObjects': 'import maya.cmds as cmds\n\ncmds.loadPrefObjects()',
 'loadUI': 'import maya.cmds as cmds\n\nimport maya.cmds as cmds\n\n# Note: mydialog.ui must already exist\ndialog1 = cmds.loadUI(f=\'/users/username/mydialog.ui\')\ncmds.showWindow(dialog1)\n\n# Load from a string\ndialog = ""\ncounter = 0\n\n# Define the button command callback\ndef onClick():\n    global counter\n    global dialog\n    counter += 1\n    control = "{}|verticalLayout|mybutton".format(dialog)\n    cmds.button(control,\n        edit=True,\n        label="Clicked {} times".format(counter))\n    print(counter)\n\n# Create a dialog with a button from a UI description in string form\ndef showDialog():\n    dialogString = \'\'\'<?xml version=\'1.0\' encoding=\'UTF-8\'?>\n        <ui version=\'4.0\'>\n        <class>Dialog</class>\n        <widget class=\'QDialog\' name=\'Dialog\'>\n        <layout class=\'QVBoxLayout\' name=\'verticalLayout\'>\n            <item>\n            <widget class=\'QPushButton\' name=\'mybutton\'>\n            <property name=\'text\'>\n            <string>Clicked 0 times</string>\n            </property>\n            <property name=\'+command\'>\n            <string>"onClick()"</string>\n            </property>\n            </widget>\n            </item>\n        </layout>\n        </widget>\n        </ui>\'\'\'\n\n    global dialog\n    dialog = cmds.loadUI(s=dialogString)\n    cmds.window(dialog, e=True, w=200, h=50)\n    cmds.showWindow(dialog)\n\nshowDialog()',
 'lockNode': "import maya.cmds as cmds\n\n# create a sphere, lock it, then try to delete it.\ncmds.sphere( n='sphere1' )\ncmds.lockNode( 'sphere1' )\ncmds.delete( 'sphere1' )\n# Error: Cannot delete locked nodes.\n\n# Unlock the sphere, then it can be deleted.\ncmds.lockNode( 'sphere1', lock=False )\ncmds.delete( 'sphere1' )",
 'loft': "import maya.cmds as cmds\n\n# A loft across two curves: curve1, curve2. Curve ranges\n# have been enabled on the curves. The curves will be reversed\n# internally if needed to avoid a bowtie looking surface.\ncmds.curve( d=3, p=( (-11, 0, 0), (-13, 0, -4), (-17, 0, -15), (-4.7, 0, -10), (1, 0, -8 ) ) )\n# Result: curve1 #\ncmds.curve( d=3, p=( (-2, 0, 5), (-2, 0, 3), (-2, 0, -1), (4, 0, 0), (7, 0, 0 ) ) )\n# Result: curve2 #\ncmds.loft( 'curve1', 'curve2', ch=True, rn=True, ar=True )",
 'lookThru': "import maya.cmds as cmds\n\ncmds.lookThru( 'cameraShape1', 'topView' )\n\ncmds.lookThru( 'perspView', 'cameraShape1', nc=100, fc=200 )\n\ncmds.lookThru( 'camera1' )\n\ncmds.lookThru( 'nurbsSphere1', nc=0.001, fc=5000.0 )\n\ncmds.lookThru( 'perspView', q=True )\n\ncmds.lookThru( q=True )",
 'ls': 'import maya.cmds as cmds\n\n# Create some objects to operate on and select them all.\n# Note that there are two objects named circle1;\ncmds.circle( n=\'circle1\' )\ncmds.group()\ncmds.circle( n=\'circle1\' )\ncmds.sphere( n=\'sphere1\' )\ncmds.group()\ncmds.instance()\ncmds.select( ado=True )\n\n# list all objects\ncmds.ls()\n\n# List all selected objects\ncmds.ls( selection=True )\n\n# List all hilited objects\ncmds.ls( hilite=True )\n\n# List last selected object\ncmds.ls( selection=True, tail=1 )\n\n# List all objects named "sphere1". Note that since sphere1 is\n# instanced, the command below lists only the first instance.\ncmds.ls( \'sphere1\' )\n\n# To list all instances of sphere1, use the -ap/allPaths flag.\ncmds.ls( \'sphere1\', ap=True )\n\n# List all selected objects named "group*"\ncmds.ls( \'group*\', sl=True )\n\n# List all geometry, lights and cameras in the DAG.\ncmds.ls( geometry=True, lights=True, cameras=True )\n\n# List all shapes in the dag.\ncmds.ls( shapes=True )\n\n# One thing to note is that it is better to always use the\n# -l/long flag when listing nodes without any filter. This is\n# because there may be two nodes with the same name (in this\n# example, circle1). \'ls\' will list the names of all the objects\n# in the scene. Objects with the same name need a qualified\n# path name which uniquely identifies the object. A command\n# to select all objects such as "select `ls`" will fail because\n# the object lookup can\'t resolve which "circle1" object is\n# intended. To select all objects, you need the following:\ncmds.select(cmds.ls(sl=True))\n\n# When trying to find a list of all objects of a specific\n# type, one approach might be to list all objects and then\n# use the nodeType command to then filter the list. As in:\nallObjects = cmds.ls(l=True)\nfor obj in allObjects:\n   if cmds.nodeType(obj) == \'surfaceShape\':\n     print obj\n\n# The problem with this is that \'nodeType\' returns the\n# most derived type of the node. In this example, "surfaceShape"\n# is a base type for nurbsSurface so nothing will be printed.\n# To do this properly, the -typ/type flag should be used\n# to list objects of a specific type as in:\nallObjects = cmds.ls(type=\'surfaceShape\')\nfor obj in allObjects:\n    print obj\n\n# List all geometry shapes and their types\ncmds.ls( type=\'geometryShape\', showType=True )\n\n# List all paths to all leaf nodes in the DAG\ncmds.ls( dag=True, lf=True, ap=True )\n\n# List all nodes below the selected node\ncmds.ls( dag=True, ap=True, sl=True )\n\n# List all ghosting objects\ncmds.ls( ghost=True )\n\n# List all dag nodes that are read-only (i.e. referenced nodes)\ncmds.ls( dag=True, ro=True )\n\n# List reference nodes associated with specific files\ncmds.ls( references=True )\n\n# List all reference nodes, including unknown and shared reference nodes\ncmds.ls( type=\'reference\' )\n\n# Select some components and then get the list in both selected and numeric order\nobj1 = cmds.polySphere( sx=20, sy=20 )\ncmds.select( clear=True )\n\ncmds.selectPref( trackSelectionOrder=1 )\n\ncmds.select( obj1[0]+".f[100]" )\ncmds.select( (obj1[0]+".f[50:55]"), add=True )\ncmds.select( (obj1[0]+".f[0]"), add=True )\ncmds.select( (obj1[0]+".f[56:60]"), add=True )\n\n# Regular -selection flag returns the components in compacted numeric order.\ncmds.ls( selection=True )\n# Result:_ [u\'pSphere1.f[0]\', u\'pSphere1.f[50:60]\', u\'pSphere1.f[100]\'] #\n\n# -orderedSelection flag returns the components in the order that we selected them.\ncmds.ls( orderedSelection=True )\n# Result:_ [u\'pSphere1.f[100]\', u\'pSphere1.f[50:55]\', u\'pSphere1.f[0]\', u\'pSphere1.f[56:60]\'] #\n\n# Turn off tracking when we are done\ncmds.selectPref( trackSelectionOrder=0 )\n\n# Init some namespace\ncmds.namespace( add="A:B:C" )\n\n# add object into namespace\ncmds.namespace( set=":A:B" )\ncmds.polySphere( name="obj1" )\ncmds.namespace( set=":A:B:C" )\ncmds.polySphere( name="obj1" )\ncmds.polySphere( name="obj2" )\n\n\n# The current Namespace is ":A:B:C" and relative mode is off\n# List all objects and their namespace in the scene\n# If the object is in the root namespace, then return root ":"\n# Note that the results shown below have been elided (...) for documentation purposes.\ncmds.ls( showNamespace=True )\n# Result: [u\'time1\', u\':\', u\'sequenceManager1\', u\':\', u\'renderPartition\', u\':\', (...), u\'A:B:obj1\', u\'A:B\', u\'A:B:C:obj1\', u\'A:B:C\', u\'A:B:C:obj2\', u\'A:B:C\'] #\n\ncmds.select( ":A:B:obj1", r=True )\ncmds.select( ":A:B:C:obj2", add=True)\n\n\n# List namespace of all objects named "obj1"\ncmds.ls( "obj1", showNamespace=True, recursive=True )\n# Result: [u\'A:B:obj1\', u\'A:B\', u\'A:B:C:obj1\', u\'A:B:C\'] #\n\n# List both name and namespace of each selected object\ncmds.ls( showNamespace=True, selection=True )\n# Result: [u\'A:B:obj1\', u\'A:B\', u\'A:B:C:obj2\', u\'A:B:C\'] #\n\n# Set current namespace\ncmds.namespace( set=":A:B" )\n\n# Enable relative mode\ncmds.namespace( relativeNames=True )\n\n# Now the current namespace is ":A:B" and relative mode is on\n# Note that the name of the current namespace is "" in relative mode\n# List both name and namespace of each selected objects\ncmds.ls( showNamespace=True, selection=True )\n# Result: [u\'obj1\', u\'\', u\'C:obj2\', u\'C\'] #\n\n# Make a new scene, modify the transform of the camera perspective, play with the timeline and modify the camera\'s shape\ncmds.file(force=True, new=True)\ncmds.setAttr(\'persp.translateX\', 10)\ncmds.currentTime(8)\ncmds.setAttr(\'perspShape.horizontalFilmAperture\', 16)\n\n# List all modified objects of type camera and type time\nallObjects=cmds.ls(type=[\'camera\',\'time\'], modified=True)\nprint allObjects\n# Result: [u\'perspShape\', u\'time1\']\n\ncmds.ls(modified=True)\n# Result: [u\'persp\', u\'perspShape\', u\'time1\']\n\ncmds.ls(modified=True, excludeType=\'camera\')\n# Result: [u\'persp\', u\'time1\']\n\n# Return a node\'s UUID\ncmds.ls( \'sphere1\', uuid=True )\n# Result: [u\'ECE85CCC-438D-8113-0236-39A6917DE484\']\n\n# Find a node by UUID\ncmds.ls( \'ECE85CCC-438D-8113-0236-39A6917DE484\' )\n# Result: [u\'group2|sphere1\']',
 'lsThroughFilter': 'import maya.cmds as cmds\n\n# Return all objects in the model that are named bob.\n# (See the command "itemFilter" for how to construct these filters.)\ncmds.lsThroughFilter( \'texturesNamedBobFilter\' )\n\n# Return same objects as above, but sorted in reverse\n# alphabetical order:\ncmds.lsThroughFilter( \'texturesNamedBobFilter\', na=True, sort=\'byName\', reverse=True )',
 'lsUI': "import maya.cmds as cmds\n\n#    List all windows.\n#\ncmds.lsUI( windows=True )\n\n#    List all panels and editors.\n#\ncmds.lsUI( panels=True, editors=True )\n\n#    Use the -typ/type flag to list all controls and control layouts.\n#    Alternatively, you could use the -ctl/controls and -cl/controlLayouts\n#    flags.\n#\ncmds.lsUI( type=['control','controlLayout'] )\n\n#    Or...\n#\ncmds.lsUI( controls=True, controlLayouts=True )",
 'makeIdentity': 'import maya.cmds as cmds\n\n# Example 1:  Create a hierarchical object, for example a\n# car. Scale the tires, translate the doors into place, rotate the\n# steering wheel, then select the group node above the car, and type:\n\ncmds.makeIdentity( apply=True )\n# The car should not move.\n\ncmds.move( 3, 0, 0 )\n# The car should move exactly 3 units to (3, 0, 0), since\n# the previous makeIdentity command set its translation to (0, 0, 0).\n\ncmds.makeIdentity()\n# The car should return to the same position as before the move.\n\n# Example 2:  Create a curve and translate, rotate and scale it.\n# Then group it and translate, rotate and scale the group.\n\ncmds.makeIdentity( \'group1\', apply=True, translate=True )\n# The curve will not move, but both the curve transform\'s and group\n# transform\'s translation will be set to 0, 0, 0. The rotation and\n# scale will remain the same.\n\ncmds.makeIdentity( \'group1\', apply=True, rotate=True )\n# The curve will not move, but both the curve transform\'s and group\n# transform\'s rotation will be set to 0, 0, 0. The translation and\n# scale will remain the same.\n\ncmds.makeIdentity( \'group1\', apply=True, scale=True )\n# The curve will not move, but both the curve transform\'s and group\n# transform\'s scale will be set to 1, 1, 1. The translation and rotation\n# will remain the same.\n\ncmds.makeIdentity( \'group1\', apply=True, translate=True, rotate=True )\n# The curve will not move, but both the curve transform\'s and group\n# transform\'s translation and rotation will be set to 0, 0, 0.\n# The scale will remain the same.\n\ncmds.makeIdentity( \'group1\', apply=False, translate=True )\n# The curve transform and group transform will have their translation\n# set to 0, 0, 0. The curve will probably move, since the apply\n# flag is false.\n\ncmds.makeIdentity( apply=True, translate=True, rotate=True, scale=True )\n# This is the same as "makeIdentity -apply true".\n\n# Example 3:  Create a polyCube and translate, rotate and scale it.\n# And then freeze the normals.\n\ncmds.polyCube()\ncmds.rotate( 30, 45, 0 )\ncmds.move( 2, 0, 2, r=True )\ncmds.scale( 2, 1, 2, r=True )\ncmds.makeIdentity( apply=True, t=1, r=1, s=1, n=2 )',
 'makeLive': "import maya.cmds as cmds\n\ncmds.makeLive( 'surface1' )\ncmds.makeLive( none=True )",
 'makePaintable': "import maya.cmds as cmds\n\n# Make particle.mass paintable.\ncmds.makePaintable( 'particle', 'mass', attrType='doubleArray' )\n\n# Make particle.goalPP paintable, with a ui name myGoalPP.\n# Also make the goalPP0 attribute painted simultaneously\ncmds.makePaintable( 'particle', 'goalPP', attrType='doubleArray', ui='myGoalPP', altAttribute='goalPP0' )\n\n# Make weightGeometryFilter.weights paintable. Define\n# weightGeometryFilter as a deformer node.\ncmds.makePaintable( 'weightGeometryFilter', 'weights', attrType='multiFloat', sm='deformer' )\n\n# Make all the attributes paintable on the artAttrPaintTest node.\ncmds.makePaintable( 'artAttrPaintTest', 'intArray', attrType='intArray' )\ncmds.makePaintable( 'artAttrPaintTest', 'dblArray', attrType='doubleArray' )\ncmds.makePaintable( 'artAttrPaintTest', 'vecArray', attrType='vectorArray' )\ncmds.makePaintable( 'artAttrPaintTest', 'intMulti', attrType='multiInteger' )\ncmds.makePaintable( 'artAttrPaintTest', 'fltMulti', attrType='multiFloat' )\ncmds.makePaintable( 'artAttrPaintTest', 'dblMulti', attrType='multiDouble' )\ncmds.makePaintable( 'artAttrPaintTest', 'flt3Multi', attrType='multiVector' )\ncmds.makePaintable( 'artAttrPaintTest', 'dbl3Multi', attrType='multiVector' )",
 'makeSingleSurface': "import maya.cmds as cmds\n\n# To make a single poly surface from a bunch of surfaces\ncmds.makeSingleSurface( 'nurbsPlane1', 'nurbsPlane2', 'nurbsPlane3' )",
 'makebot': "import maya.cmds as cmds\n\ncmds.makebot( i='in_image', o='/usr/tmp/out_bot_file' )",
 'manipComponentPivot': '',
 'manipComponentUpdate': '',
 'manipMoveContext': "import maya.cmds as cmds\n\n# To create a new move context:\ncmds.manipMoveContext()\n\n# To query the mode of an existing context:\ncmds.manipMoveContext( 'manipMoveContext1', q=True, mode=True )\n\n# To edit an existing context to come up with the X axis handle\n# active by default:\ncmds.manipMoveContext( 'manipMoveContext1', e=True, ah=0 )\n\ncmds.spaceLocator( p=(0, 0, 0), name='locatorA' )\n\ncmds.manipMoveContext( 'manipMoveContext1', e=True, m=2 ) # WorldSpace\ncmds.manipMoveContext( 'manipMoveContext1', e=True, snap=True )\ncmds.manipMoveContext( 'manipMoveContext1', e=True, snapValue=0.4 )\n# Now, dragging any of the move handles will\n# move the object in steps of 0.4 units.\n\ncmds.move( 0.8, 0, 0, 'locatorA', a=True )\ncmds.manipMoveContext( 'manipMoveContext1', e=True, snap=True )\ncmds.manipMoveContext( 'manipMoveContext1', e=True, snapValue=2 )\ncmds.manipMoveContext( 'manipMoveContext1', e=True, snapRelative=False )\n# Now, dragging X-axis handle will\n# move the object in steps of 2 units, and will\n# place the object anywhere in (0,0,0) (2,0,0) (4,0,0) ...etc\n# NOTE: If in objectSpace Mode, the snapRelative should be ON.\n# Absolute discrete move is not supported in objectSpace mode.\n\ncmds.move( 0.8, 0, 0, 'locatorA', a=True )\ncmds.manipMoveContext( 'manipMoveContext1', e=True, snap=True )\ncmds.manipMoveContext( 'manipMoveContext1', e=True, snapValue=2 )\ncmds.manipMoveContext( 'manipMoveContext1', e=True, snapRelative=True )\n# Now, dragging X-axis handle will\n# move the object in steps of 2 units, and will\n# place the object anywhere in (2.8,0,0) (4.8,0,0) (6.8,0,0) ...etc",
 'manipMoveLimitsCtx': 'import maya.cmds as cmds\n\ncmds.manipMoveLimitsCtx()',
 'manipOptions': 'import maya.cmds as cmds\n\n# Scales all handles by a 1.5 factor\ncmds.manipOptions( r=True, hs=1.5, ls=1.5 )\n\n# All manips are scaled by 2\ncmds.manipOptions( s=2 )',
 'manipPivot': 'import maya.cmds as cmds\n\n// Set tool component pivot to <1,0,0>\ncmds.manipPivot( p=(1, 0, 0) )',
 'manipRotateContext': "import maya.cmds as cmds\n\n# To create a new rotate context:\ncmds.manipRotateContext()\n\n# To query the mode of an existing context:\ncmds.manipRotateContext( 'manipRotateContext1', q=True, mode=True )\n\n# To edit an existing context to come up with the X axis\n# handle active by default:\ncmds.manipRotateContext( 'manipRotateContext1', e=True, ah=0 )",
 'manipRotateLimitsCtx': 'import maya.cmds as cmds\n\ncmds.manipRotateLimitsCtx()',
 'manipScaleContext': "import maya.cmds as cmds\n\n# To create a new scale context:\ncmds.manipScaleContext()\n\n# To query the active handle of an existing scale context:\ncmds.manipScaleContext( 'manipScaleContext1', q=True, ah=True )\n\n# To edit an exiting scale context so that it comes up with the X axis\n# handle active by default:\ncmds.manipScaleContext( 'manipScaleContext1', e=True, ah=0 )",
 'manipScaleLimitsCtx': 'import maya.cmds as cmds\n\ncmds.manipScaleLimitsCtx()',
 'marker': 'import maya.cmds as cmds\n\n# Create a simple motion path animation:\n\n# create a path, e,g, a curve\npath = cmds.curve(d=3,p=[(-10, 0, 0),(-6, 0, 10),(-3, 0, -10),(10, 0, 0)],k=[0, 0, 0, 1, 1, 1])\n\n# Create an object, e.g. a sphere\nobject = cmds.sphere()\ncmds.scale( 0.5, 2.0, 0.2 )\n\n# animate the object using a motion path with follow on\ncmds.pathAnimation( object[0], f=1, stu=0, etu=30, c=path )\n\n# change the current time to be frame 20\ncmds.currentTime( 20, edit=True )\n\n# Create a position marker on the path, at curve parameter value\n# 0.75 and at current time:\ncmds.marker( path, u=0.75 )\n\n# Create an orientation marker on the path, at time 15:\ncmds.marker( path, om=True, t=15 )\n\n# Create a position marker and an orientation marker on the path,\n# at curve parameter value .35 and at time 10:\ncmds.marker( path, pm=True, om=True, t=10, u=0.35 )',
 'matchTransform': "import maya.cmds as cmds\n\n# create a cone and randomly transform it\ncmds.polyCone(n='cone1')\ncmds.scale(0.2, 2.0, 0.2);\ncmds.rotate(20, 45, 70)\ncmds.move(-2, 0, 2)\n\n# create a cylinder\ncmds.polyCylinder(n='cylinder1')\n\n# modify the cylinder's transform to match the cone\ncmds.matchTransform('cylinder1','cone1')",
 'mateCtx': '',
 'matrix': '',
 'matrixUtil': 'import maya.cmds as cmds\n\n#compose a matrix from translation, rotation, scale and shear\ncmds.matrixUtil(t=[10, 20, 30], r=[90, 0, 90], s=[2, 3, 4], sh=[1, 0, 0])\n#query translation\ncmds.matrixUtil([1, 0, 0, 0,  0, 1, 0, 0,  0, 0, 1, 0,  0, 0, 0, 1], q=True, t=True)\n#query rotation\ncmds.matrixUtil([1, 0, 0, 0,  0, 1, 0, 0,  0, 0, 1, 0,  0, 0, 0, 1], q=True, r=True)\n#query scale\ncmds.matrixUtil([1, 0, 0, 0,  0, 1, 0, 0,  0, 0, 1, 0,  0, 0, 0, 1], q=True, s=True)\n#edit translation\ncmds.matrixUtil([2, 0, 0, 0,  0, 2, 0, 0,  0, 0, 2, 0,  0, 0, 0, 1], e=True, t=[3,4,5])',
 'mayaDpiSetting': 'import maya.cmds as cmds\n\n\n# Set the scale mode to system dpi based scaling.\ncmds.mayaDpiSetting( mode=0 )\n\n# Set the interface scaling to 150% custom scaling.\ncmds.mayaDpiSetting( mode=1, scaleValue=1.5 )\n\n# Disable the interface scaling.\ncmds.mayaDpiSetting( mode=2 )\n\n# Query the current scaling mode.\ncmds.mayaDpiSetting( query=True, mode=True )\n\n# Query the current scale value.\ncmds.mayaDpiSetting( query=True, scaleValue=True )\n\n# Query the system dpi value.\ncmds.mayaDpiSetting( query=True, systemDpi=True )\n\n# Query the current real scale value.\ncmds.mayaDpiSetting( query=True, realScaleValue=True )',
 'mayaDpiSettingAction': '',
 'mayaHasRenderSetup': 'import maya.cmds as cmds\n\n\n#Returns whether render setup mode is enabled or disabled\ncmds.mayaHasRenderSetup()\n\n#Query the state renderSetupEnableDuringTests\ncmds.mayaHasRenderSetup(query = True, enableCurrentSession = True)\n\n#Query the state renderSetupEnableDuringTests\ncmds.mayaHasRenderSetup(query = True, enableDuringTests = True)\n\n#Enable renderSetupEnableCurrentSession\ncmds.mayaHasRenderSetup(edit = True, enableCurrentSession = True)\n\n#Disable renderSetupEnableCurrentSession\ncmds.mayaHasRenderSetup(edit = True, enableCurrentSession = False)\n\n#Enable enableDuringTests\ncmds.mayaHasRenderSetup(edit = True, enableDuringTests = True)\n\n#Disable enableDuringTests\ncmds.mayaHasRenderSetup(edit = True, enableDuringTests = False)',
 'melInfo': 'import maya.cmds as cmds\n\n# Query the names of all the global MEL procedures currently defined.\n#\nprocs = cmds.melInfo()',
 'melOptions': 'import maya.cmds as cmds\n\n#\tTo find out if there are any duplicate variable declarations in\n#\ta script:\n\n#\tSave the current setting of the duplicateVariableWarnings option.\noptionVal = cmds.melOptions(q=True, duplicateVariableWarnings=True)\n\n#\tTurn the option on.\ncmds.melOptions(duplicateVariableWarnings=True)\n\n#\tSource the script and see all the warnings generated.\nimport maya.mel as mm\nmm.eval(\'source "myScript.mel"\')\n\n// Warning: \tint $i; //\n// Warning: "myScript.mel" line 5.8 : Redeclaration of variable "$i" shadows previous declaration at line 3. Previous value will be retained. //\n\n#\tRestore the option to its original value.\ncmds.melOptions(duplicateVariableWarnings=optionVal)',
 'memory': 'import maya.cmds as cmds\n\ncmds.memory(freeMemory=True)\n# Result: 525451264 #\n\ncmds.memory(freeMemory=True megaByte=True)\n# Result: 521 #\n\ncmds.memory(freeMemory=True megaByte=True asFloat=True)\n# Result: 521.33203125 #',
 'menu': 'import maya.cmds as cmds\n\ncmds.window( menuBar=True, width=200 )\ncmds.menu( label=\'File\', tearOff=True )\ncmds.menuItem( label=\'New\' )\ncmds.menuItem( label=\'Open\' )\ncmds.menuItem( label=\'Save\' )\ncmds.menuItem( divider=True )\ncmds.menuItem( label=\'Quit\' )\ncmds.menu( label=\'Help\', helpMenu=True )\ncmds.menuItem( \'Application..."\', label=\'"About\' )\ncmds.columnLayout()\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.showWindow()',
 'menuBarLayout': 'import maya.cmds as cmds\n\n#    Create a window with two menu bar layouts.\n#\nwindow = cmds.window()\ncmds.columnLayout( adjustableColumn=True )\n\n#    Create first menu bar layout.\n#\nmenuBarLayout = cmds.menuBarLayout()\ncmds.menu( label=\'File\' )\ncmds.menuItem( label=\'New\' )\ncmds.menuItem( label=\'Open\' )\ncmds.menuItem( label=\'Close\' )\n\ncmds.menu( label=\'Help\', helpMenu=True )\ncmds.menuItem( label=\'About...\' )\n\ncmds.columnLayout()\ncmds.button( label=\'Add Menu\', command=(\'cmds.menu(parent=\\"\' + menuBarLayout + \'\\"); cmds.menuItem()\') )\ncmds.setParent( \'..\' )\ncmds.setParent( \'..\' )\n\ncmds.separator( height=10, style=\'none\' )\n\n#    Create a second menu bar layout.\n#\ncmds.menuBarLayout()\ncmds.menu( label=\'Edit\' )\ncmds.menuItem( label=\'Cut\' )\ncmds.menuItem( label=\'Copy\' )\ncmds.menuItem( label=\'Paste\' )\n\ncmds.menu( label=\'View\' )\ncmds.menuItem( label=\'Fonts...\' )\ncmds.menuItem( label=\'Colors...\' )\n\ncmds.columnLayout()\ncmds.text( label=\'Add some controls here.\' )\ncmds.setParent( \'..\' )\ncmds.setParent( \'..\' )\n\ncmds.showWindow( window )',
 'menuEditor': 'import maya.cmds as cmds\n\n# No example is provided as <b>menuEditor</b> is not intended to be called\n# independently. It is recommended that you use the Marking Menu editor\n# to customize marking menus.',
 'menuItem': "import maya.cmds as cmds\n\ncmds.window( menuBar=True, width=200 )\ncmds.menu( label='Stuff' )\ncmds.menuItem( subMenu=True, label='Colors' )\ncmds.menuItem( label='Blue' )\ncmds.menuItem( label='Green' )\ncmds.menuItem( label='Yellow' )\ncmds.setParent( '..', menu=True )\ncmds.menuItem( divider=True, dividerLabel='Section 1' )\ncmds.radioMenuItemCollection()\ncmds.menuItem( label='Yes', radioButton=False )\ncmds.menuItem( label='Maybe', radioButton=False )\ncmds.menuItem( label='No', radioButton=True )\ncmds.menuItem( divider=True, dividerLabel='Section 2' )\ncmds.menuItem( label='Top', checkBox=True )\ncmds.menuItem( label='Middle', checkBox=False )\ncmds.menuItem( divider=True, longDivider=False )\ncmds.menuItem( label='Bottom', checkBox=True )\ncmds.menuItem( divider=True )\ncmds.menuItem( label='Option' )\ncmds.menuItem( optionBox=True )\ncmds.columnLayout()\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.showWindow()",
 'menuSet': 'import maya.cmds as cmds\n\n# creating a new menu set;\ncmds.menuSet( \'newMenuSetObjName\', label=\'newMenuSet Label\' )\n\n# using commands on a current menu set\n# first find the menu set if you don\'t know the name of it\nanimMS = maya.mel.eval(\'findMenuSetFromLabel("Animation")\')\n\n# menu sets can be queried like normal commands\nanimMenus = cmds.menuSet(animMS, query=True, menuArray=True)\n\n# but editing the set requires either setting the current menu set...\n# (notice that the menu set comamnds following specify no specific menu set)\ncmds.menuSet( currentMenuSet=animMS )\ncmds.menuSet( removeMenu=animMenus[0] )\n# : (other commands which pertain to the animation menu set)\n\n# .. or temporarily setting the menu set to work on (does not affect current menu set)\n# (notice that every command following specifies the specific set to apply operations to)\npolyMS = maya.mel.eval(\'findMenuSetFromLabel("Polygons")\')\npolyMenus = cmds.menuSet(polyMS, query=True, menuArray=True)\ncmds.menuSet( polyMS, removeMenu=polyMenus[0], insertMenu=(polyMenus[1], 0) )\n\n# .. where the following commands still affect the animation menu set\nanimMenus = cmds.menuSet(query=True, menuArray=True)\n\n# if you need to find a specific menu...\ndeformMenu = maya.mel.eval( (\'findMenuFromMenuSet(\\"\' + animMS + \'\\", "Deform")\') )\n\n# moving a menu from one spot to another\n# (ie. moving the Deform Menu to the front of the list)\ncmds.menuSet( moveMenu=(deformMenu, 0) )',
 'menuSetPref': 'import maya.cmds as cmds\n\n# saving the current menuSets\ncmds.menuSetPref( saveAll=True )\n\n# loading to the current menuSets if they exist\nif cmds.menuSetPref(exists=True) :\n\tcmds.menuSetPref(loadAll=True)\n\n# in certain cases, you may wish to remove previous preferences before saving\ncmds.menuSetPref( removeAll=True )',
 'meshIntersectTest': '',
 'messageLine': "import maya.cmds as cmds\n\nwindow = cmds.window()\nform = cmds.formLayout()\nframe = cmds.frameLayout(labelVisible=False)\ncmds.messageLine()\ncmds.formLayout( form, edit=True, attachNone=(frame, 'top'), attachForm=[(frame, 'left', 0), (frame, 'bottom', 0), (frame, 'right', 0)] )\ncmds.showWindow( window )",
 'mimicManipulation': 'import maya.cmds as cmds\n\ncmds.createNode(\'transform\')\ncmds.mimicManipulation(manipulations=\'{ "session": [[{"plug": "transform1.tx", "value": 1.0}]] }\')\n# Result: [False] #\n\n# Build a series of manipulation using Python objects\ncmds.setKeyframe(\'transform1\', attribute="translateX", time=1, value=1)\ncmds.setKeyframe(\'transform1\', attribute="translateX", time=10, value=10)\nmanipulations = dict(session=[[{"plug": "transform1.translateX", "value": i}] for i in range(10)])\nimport json\nmanips = json.dumps(manipulations)\ncmds.mimicManipulation(manipulations=manips)\n# Result: [True, True, True, True, True, True, True, True, True, True] #\ncmds.mimicManipulation(manipulations=manips, prevalidation=False)\n# Result: [False, True, True, True, True, True, True, True, True, True] #',
 'mimicMnipulation': '',
 'minimizeApp': 'import maya.cmds as cmds\n\ncmds.minimizeApp()',
 'mirrorJoint': 'import maya.cmds as cmds\n\n# Create a mirrored branch of the skeleton starting from the joint "jointName"\n# about the yz-plane.\n# Joint orientations on the mirrored side will be identical to the source side.\n#\ncmds.mirrorJoint( \'jointName\' )\n\n# Create a mirrored branch of the skeleton starting from the joint "jointName"\n# about the yz-plane.\n# Joint orientations on the mirrored side will be mirrored from the source side.\n#\ncmds.mirrorJoint(\'jointName\',mirrorBehavior=True,myz=True)\n\n# Create a mirrored branch of the skeleton starting from the selected joint\n# about the xy-plane.\n# Joint orientations on the mirrored side will be mirrored from the source side.\n# Joint names on the duplicated side will contain the string "right_" if\n# the corresponding joint on the original side contained the string "left_".\n#\ncmds.mirrorJoint(mirrorXY=True,mirrorBehavior=True,searchReplace=(\'left_\', \'right_\') )',
 'modelCurrentTimeCtx': 'import maya.cmds as cmds\n\ncmds.modelCurrentTimeCtx()',
 'modelEditor': 'import maya.cmds as cmds\n\n#    Create a window with a model editor and some buttons that\n#    change the editor\'s display of objects in the scene.\n#\nwindow = cmds.window(\'window\')\nform = cmds.formLayout()\neditor = cmds.modelEditor()\ncolumn = cmds.columnLayout(\'true\')\n\n#    Create some buttons that will alter the display appearance of\n#    objects in the model editor, eg. wireframe vs. shaded mode.\n#\ncmds.button(label=\'Wireframe\', command= "cmds.modelEditor(editor, edit=True, displayAppearance=\'wireframe\')")\ncmds.button(label=\'Points\', command= "cmds.modelEditor(editor, edit=True, displayAppearance=\'points\')")\ncmds.button(label=\'Bounding Box\', command= "cmds.modelEditor(editor, edit=True, displayAppearance=\'boundingBox\')")\ncmds.button(label=\'Smooth Shaded\', command= "cmds.modelEditor(editor, edit=True, displayAppearance=\'smoothShaded\')")\ncmds.button(label=\'Flat Shaded\', command= "cmds.modelEditor(editor, edit=True, displayAppearance=\'flatShaded\')")\n\n#    Set up the window layout attachments.\n#\ncmds.formLayout( form, edit=True, attachForm=[(column, \'top\', 0), (column, \'left\', 0), (editor, \'top\', 0), (editor, \'bottom\', 0), (editor, \'right\', 0)], attachNone=[(column, \'bottom\'), (column, \'right\')], attachControl=(editor, \'left\', 0, column))\n\n#    Create a camera for the editor.  This particular camera will\n#    have a close up perspective view of the centre of the ground plane.\n#\ncamera= cmds.camera(centerOfInterest=2.450351,\n\t\t\tposition = (1.535314, 1.135712, 1.535314),\n\t\t\trotation = (-27.612504, 45, 0),\n\t\t\tworldUp = (-0.1290301, 0.3488592, -0.1290301))\n\n#    Attach the camera to the model editor.\n#\ncmds.modelEditor( editor, edit=True, camera=camera[0] )\n\n#    Put an object in the scene.\n#\ncmds.cone()\n\ncmds.showWindow( window )\n\n#    The following two examples assume a custom model editor command\n#    defined via the MPxModelEditorCommand API class, named \'myEditor\'.\n#\n\n#    Create a custom editor, and use it as the model editor of Maya\'s\n#    default modelPanel4 (the perspective view).\n#\ncmds.myEditor( modelPanel=\'modelPanel4\' )\n\n#    Restore the default model editor.\n#\ncmds.modelEditor( modelPanel=\'modelPanel4\' )\n#\n#\t The following example shows usage of the render override flags\n#\t with model panel \'modelPanel4\'\n#\ncmds.modelEditor( \'modelPanel4\', q=True, rol=True ) # Query for non-UI names for any render overrides\ncmds.modelEditor( \'modelPanel4\', q=True, rou=True ) # Query for UI names for any render overrides\ncmds.modelEditor( \'modelPanel4\', q=True, rom=True ) # Query for any active override\ncmds.modelEditor( \'modelPanel4\', e=True, rom=\'myOverride\' ) # Set active override to \'myOverride\' if it exists\ncmds.modelEditor( \'modelPanel4\', e=True, rom=\'\' ) # Clear out the active override\n\ncmds.modelEditor( \'modelPanel4\', e=True, rnm=\'base_OpenGL_Renderer\' ) # Set the renderer used for a 3d modeling viewport\ncmds.modelEditor( \'modelPanel4\', q=True, rnm=True ) # Query for the renderer used for a 3d modeling viewport\ncmds.modelEditor( \'modelPanel4\', q=True, rdn=True ) # Query for device name for current renderer.',
 'modelPanel': 'import maya.cmds as cmds\n\n#    Example 1.\n#\n#    Create a model panel in a separate window.\n#\nwindow = cmds.window()\ncmds.paneLayout()\ncmds.modelPanel()\ncmds.showWindow( window )\n\n#    Example 2.\n#\n#    Set the panel configuration to show all 4 model views.\n#    Then swap the Perspective View and Front View panels.\n#\n\n# Since setNamePanelLayout is a MEL procedures, we need to call through MEL\nimport maya.mel\nmaya.mel.eval(\'setNamedPanelLayout("Four View")\')\nperspPanel = cmds.getPanel( withLabel=\'Persp View\')\nfrontPanel = cmds.getPanel( withLabel=\'Front View\')\ncmds.modelPanel( perspPanel, edit=True, replacePanel=frontPanel )',
 'modelingToolkitSuperCtx': '',
 'moduleInfo': "import maya.cmds as cmds\n\ncmds.moduleInfo(listModules=True)\ncmds.moduleInfo(definition=True, moduleName='myModule')\ncmds.moduleInfo(path=True, moduleName='myModule')\ncmds.moduleInfo(version=True, moduleName='myModule')",
 'mouldMesh': '',
 'mouldSrf': '',
 'mouldSubdiv': '',
 'mouse': 'import maya.cmds as cmds\n\ncmds.mouse( enableScrollWheel=False )\n\nmouseEnabled = cmds.mouse(scrollWheelStatus=True)\n\ncmds.mouse( mouseButtonTracking=1 )\n\nnumberOfMouseButtons = cmds.mouse(mouseButtonTrackingStatus=True)',
 'movIn': "import maya.cmds as cmds\n\ncmds.sphere( n='sph' )\n\n#    Start importing the data at time 45;\n#\ncmds.currentTime( 45 )\n\n#    Read in rotation, translation, and scale information from the\n#    test.mov file into the sphere. The order of data in the test.mov\n#    file must be: rx, ry, rz, tx, ty, tz.\n#\ncmds.movIn( 'sph.r', 'sph.t', f='sphereMotion.mov' )\n\n#    An equivalent way of importing data into the sphere.\n#\ncmds.movIn( 'sph.rx', 'sph.ry', 'sph.rz', 'sph.tx', 'sph.ty', 'sph.tz', f='sphereMotion.mov' )",
 'movOut': "import maya.cmds as cmds\n\n#    Create a sphere and set some keyframes.\n#\ncmds.sphere( n='sph' )\ncmds.currentTime( 0 )\ncmds.move( 0, 0, 0, 'sph' )\ncmds.setKeyframe( 'sph.t' )\ncmds.currentTime( 24 )\ncmds.move( 8, 9, 10, 'sph' )\ncmds.setKeyframe( 'sph.t' )\n\n#    Write the keys to a .mov file.\n#\ncmds.movOut( 'sph.t', f='sphereMotion.mov', t=(0,24) )\n\n#    Another way to write the same file.\n#\ncmds.movOut( 'sph.tx', 'sph.ty', 'sph.tz', f='sphereMotion.mov', t=(0,24) )",
 'move': "import maya.cmds as cmds\n\ncmds.polySphere()\ncmds.move( 1, 1, 1 )\ncmds.move( 5, y=True )\ncmds.move( '1in', '1in', '1in', relative=True, objectSpace=True, worldSpaceDistance=True )\ncmds.move( 0, 0, 0, 'pSphere1', absolute=True )",
 'moveKeyCtx': "import maya.cmds as cmds\n\n# Create a move key context which works in insert mode\n# for the graph editor\n#\nnewCtx = cmds.moveKeyCtx(option='insert')\n\n# Edit the context to over mode\n#\ncmds.moveKeyCtx( newCtx, e=True, option='over' )",
 'moveVertexAlongDirection': 'import maya.cmds as cmds\n\ncmds.moveVertexAlongDirection( "nurbsSurface1.cv[1][1]", "pPlane1.vtx[120]", d=[(1, 1, 1), (1, 0, 0)], m=[2.0, 1.0] )\n# Move the control vertex on the surface, mesh in the normalized\n# directions (1,1,1), (1,0,0) by magnitude 2.0, 1.0 respectively.\n\ncmds.moveVertexAlongDirection( "nurbsSurface1.cv[3][1]", "nurbsSurface2.cv[0][0]", "pPlane1.vtx[10]", n=[1, -1.9, 3] )\n# Move the control vertex on the NURBS surfaces, mesh along their\n# respective unit normals by a magnitudes 1.0, -1.9 and 3.0 respectively.\n\ncmds.moveVertexAlongDirection( "nurbsSurface1.cv[4][5]", "nurbsSurface2.cv[0][0]", u=[2.0, 1.0] )\n# Move the control vertex on the NURBS surfaces in the normalized\n# tangent along U by a magnitude 2.0 and 1.0 respectively.\n\ncmds.moveVertexAlongDirection( "nurbsSurface1.cv[2][3]", v=-1.0 )\n# Move the control vertex on the nurbsSurface in the normalized\n# tangent along V by -1.0\n\ncmds.moveVertexAlongDirection( "nurbsSurface1.cv[1][1]", uvn=(1, 2, -1) )\n# Move the control vertex on the nurbsSurface in the space defined\n# by triad [u,v,n] by 1,2,-1 respectively.\n# If the initial vertex position is o(ox,oy,oz) and u,v and n are\n# direction vectors then the new position p(px,py,pz) would be:\n# p = o + 1*u + 2*v + (-1)*n ;',
 'movieCompressor': '',
 'movieInfo': 'import maya.cmds as cmds\n\n\ncmds.movieInfo("C:/My Documents/myMovie.avi", frameCount=1)\n# 24',
 'mpBirailCtx': '',
 'multiProfileBirailSurface': "import maya.cmds as cmds\n\ncmds.multiProfileBirailSurface( 'curve1', 'curve2', 'curve3', 'surface1.vn[0.5]', 'surface1.vn[1.0]', ch=True )\n\n# tangent continuous surface across the first and last profile.\ncmds.multiProfileBirailSurface( 'surface1.vn[0.5]', 'curve1', 'surface1.vn[1.0]', 'curve3', 'curve4', ch=False, tp1=True, tp2=True )",
 'multiTouch': "import maya.cmds as cmds\n\n# Enable multi-touch gestures.\ncmds.multiTouch(gestures=True)\n\n# To query whether multi-touch gestures are enabled or not:\ncmds.multiTouch(q=True, gestures=True)\n\n# Set the trackpad mode to 'Cursor and Multi-touch'.\ncmds.multiTouch(trackpad=3)\n\n# To query the trackpad mode:\ncmds.multiTouch(q=True, trackpad=True)",
 'mute': "import maya.cmds as cmds\n\n# Mute playback of the ry channel of ty on the sphere\n#\nsph = cmds.polySphere()\ncmds.setKeyframe( '%s.translate' % sph[0] )\ncmds.mute( '%s.translateY' % sph[0] )\n\n# Query whether ty is muted\ncmds.mute('%s.translateY' % sph[0], q=True )\n\n# Disable muting on any muted attributes on the sphere\n#\ncmds.mute( sph[0], disable=True )",
 'myTestCmd': '',
 'nBase': "import maya.cmds as cmds\n\n# Stuff the current positions and velocities into nCloth1's startPositions and\n# startVelocities.\n#\ncmds.nBase( 'nCloth1', e=True, stuffStart=True )\n\n# Clear nCloth1's startPositions and startVelocities.\n#\ncmds.nBase( 'nCloth1', e=True, clearStart=True )\n\n# Transfer the texture map data for the thicknessMap attribute into the\n# thicknessPerVertex attribute.\n#\ncmds.nBase( 'nCloth1', e=True, textureToVertex='thicknessMap' )",
 'nParticle': 'import maya.cmds as cmds\n\n# Creates a particle object with four particles\ncmds.nParticle( p=[(0, 0, 0), (3, 5, 6), (5, 6, 7), (9, 9, 9)] )\n\n# Returns the age of the particle with id 2 in object particle1\ncmds.nParticle( \'particle1\', q=True, attribute=\'age\', id=2 )\n\n# Returns the velocity of the 3rd particle in the currently selected\n# particle object\ncmds.nParticle( attribute=\'velocity\', q=True, order=3  )\n\n# Edits the velocity of the 7th particle in the currently selected\n# particle object to be 0.0, 1.0, 0.0\ncmds.nParticle( e=True, attribute=\'velocity\', order=3, vectorValue=(0.0, 1.0, 0.0) )\n\n# Edits the mass of the particle in "particle1" with id 3 to be 0.7\ncmds.nParticle( \'nParticle1\', e=True, attribute=\'mass\', id=3, fv=0.7 )',
 'nSoft': 'import maya.cmds as cmds\n\ncmds.sphere()\ncmds.nSoft( \'nurbsSphere1\', c=True )\n\n# Creates a sphere named nurbsSphere1 and converts nurbSphere1 into\n# a nSoft object. The particle portion of the nSoft object will\n# be parented (with its own transform) under nurbsSphere1.\n\ncmds.sphere()\ncmds.nSoft( \'nurbsSphere1\', d=True )\n\n# Same as the previous example, except that the nSoft command will make\n# a duplicate of nurbsSphereShape1. The resulting nSoft body will be\n# completely independent of nurbSphere1 and its children. Input connections\n# to nurbsSphereShape1 will be duplicated, but not any upstream history\n# (in other words, just plain "duplicate").\n\ncmds.sphere()\ncmds.nSoft( \'nurbsSphere1\', dh=True )\n\n# Same as the previous example, except that upstream history on\n# nurbsSphereShape1 will be duplicated as well (equivalent to\n# "duplicate history").\n\ncmds.sphere()\ncmds.nSoft( \'nurbSphere1\', g=0.3 )\n\n# This will make a duplicate of the shape under nurbSphere1 (as for -d),\n# and use it as the shape for the newly created nSoft object.\n# The original nurbsSphereShape1 will be made a goal for the particles of\n# softy, with a goal weight of 0.3. This will make those particles try to\n# follow nurbSphere1 loosely as it moves around.\n\ncmds.nSoft( \'foobar\', q=True )\n# Returns true if foobar is a nSoft object.\n\ncmds.nSoft( \'foobar\', \'foobarParticles\', q=True )\n\n# Returns true if foobar and foobarParticles are parts of the same\n# nSoft object. This is useful because when you select a nSoft body,\n# both the overall transform and the particle transform get put into\n# the selection list.',
 'nameCommand': 'import maya.cmds as cmds\n\n# Create a nameCommand object.\n#\ncmds.nameCommand( \'circleToolNameCommand\', ann=\'The Circle Tool\', c=\'cmds.setToolTo("circleContext")\' )\n\n# Now map the nameCommand to a hotkey.\n#\ncmds.hotkey( keyShortcut=\'F5\', altModifier=True, name=\'circleToolNameCommand\' )',
 'nameField': "import maya.cmds as cmds\n\n#    Create a window containing a single name field. Associate\n#    the name field with a sphere.\n#\nwindow = cmds.window('window')\ncmds.columnLayout( adjustableColumn=True )\nsphereName = cmds.sphere()\nfield = cmds.nameField(object=sphereName[0])\ncmds.showWindow( window )\n\n#    Rename the sphere and notice that the name field updates.\n#\nobjectName = cmds.nameField(field, query=True, object=True)\ncmds.rename( objectName, 'NewName' )",
 'namespace': 'import maya.cmds as cmds\n\n# Create three namespaces\ncmds.namespace( add=\'FOO\' )\ncmds.namespace( add=\'BAR\' )\ncmds.namespace( add=\'FRED\' )\n\n# Create namespace with qualified name\ncmds.namespace( add="A:B" )\n\n# Create namespace with qualified name\ncmds.namespace( add="C:D", parent="A:B" )\n\n# Create namespace with qualified name\ncmds.namespace( add=":A:B:C:D:E" )\n\n# Set the current namespace to FOO\ncmds.namespace( set=\'FOO\' )\n\n# Create the namespace BAR Under FOO. Note there are\n# two "BAR" namespaces, :BAR and :FOO:BAR.\ncmds.namespace( add=\'BAR\' )\n\n# Validate the name\ncmds.namespace( validateName="name$space" );\n# Result: name_space\n\n# Check to see that the BAR namespace exists within the current\n# namespace (FOO)\ncmds.namespace( exists=\'BAR\' )\n# Result: 1 #\n\n# Check to see that the FRED namespace exists under the root namespace\ncmds.namespace( exists=\':FRED\' )\n# Result: 1 #\n\n# Create two objects. It gets added to the current namespace FOO;\ncmds.sphere( n=\'sphere1\' )\ncmds.sphere( n=\'sphere2\' )\n# Result: FOO:sphere2 #\n\n# Move sphere1 from namespace FOO to FOO:BAR. Note that we\n# need to qualify sphere1 with the namespace FOO because\n# "sphere1" identifies a non-existent object in the root namespace.\ncmds.rename( \'FOO:sphere1\', \'BAR:sphere1\' )\n# Result: FOO:BAR:sphere1 #\n\n# Move sphere2 from namespace FOO to BAR.  Note the leading\n# colon on the new name.\ncmds.rename( \'FOO:sphere2\', \':BAR:sphere2\' )\n# Result: BAR:sphere2 #\n\n# query the current namespace (using the namespaceInfo command)\ncmds.namespaceInfo( currentNamespace=True )\n# Result: FOO #\n\n# remove the namespace FRED (it must be empty)\ncmds.namespace( set=\':\' )\ncmds.namespace( rm=\'FRED\' )\n\n# Check to see that the FRED namespace has been removed\ncmds.namespace( exists=\':FRED\' )\n# Result: 0 #\n\n# Rename namespace BAR to JOE\n# Note: this is done by creating JOE, moving the contents of\n# BAR into JOE, and then removing the (now empty) BAR.\ncmds.namespace( set=\':\' )\ncmds.namespace( add=\'JOE\' )\ncmds.namespace( mv=(\'BAR\', \'JOE\') )\ncmds.namespace( rm=\'BAR\' )\n\n# JOE should now contain a single node: \'sphere2\'.\n# Move the contents of JOE into FRANK, when FRANK already\n# has a \'sphere2\' node. The \'-force\'\n# flag is needed.\ncmds.namespace( set=\':\' )\ncmds.namespace( add=\'FRANK\' )\ncmds.namespace( set=\'FRANK\' )\ncmds.sphere( n=\'sphere2\' )\ncmds.namespace( force=True, mv=(\':JOE\', \':FRANK\') )\n# In moving \'sphere2\' from JOE to FRANK it will be renamed to\n# \'sphere3\' to ensure uniqueness.\n# The namespace FRANK should now contain \'sphere2\', \'sphere2Shape\',\n# and \'sphere3\'.\n\n# Determine whether the given namespace is root\n#\ncmds.namespace( query=True, isRootNamespace="FOO" )\n\n#Set return value to be absolute namespace name\n#\nprint(cmds.namespace(add = "testAbsoluteName", absoluteName = True))\n\n#Create a sample hierachy that contains only empty namespaces, then collapse it\n#\ncmds.namespace( set = ":")\ncmds.namespace( add = "emptyLevel1")\ncmds.namespace( add = "emptyLevel2", parent = "emptyLevel1")\ncmds.namespace( add = "leaf", parent = "emptyLevel1:emptyLevel2")\ncmds.namespace( collapseAncestors = "emptyLevel1:emptyLevel2:leaf")\n\n# Create a sample for removing an existed namespace.\n# This command can also be used together with these options:\n# deleteNamespaceContent\n# mergeNamespaceWithParent\n# mergeNamespaceWithRoot\n# mergeNamespaceWithOther\n#\n# The functionality of the three option parameters will also be displayed in the\n# following sample.\n# Note: The three option parameters are mutually exclusive.\n#       Without any option parameters specified, the default way it performances that\n#       it can only remove a namespace that is empty. If you want to remove any namespace\n#       with contents, please add option parameter deleteNamespaceContent.\n#\ncmds.namespace( set = ":")\ncmds.namespace( add = ":RM_TEST_ROOT:FOO:BAR:JOE")\ncmds.sphere( name = ":RM_TEST_ROOT:FOO:obj1")\ncmds.sphere( name = ":RM_TEST_ROOT:FOO:BAR:obj2")\n\n# Trying to remove a namespace that is not empty without option parameter,\n# user will get an error message show that maya cannot remove a namespace that\n# is not empty.\n#\n#cmds.namespace( removeNamespace = ":RM_TEST_ROOT:FOO") # Run this command you\'ll get an error.\n\n# Trying to remove an empty namespace.\n# Namespace :RM_TEST_ROOT:FOO:BAR:JOE has been removed successfully by the command.\n#\ncmds.namespace( removeNamespace = ":RM_TEST_ROOT:FOO:BAR:JOE")\n\ncmds.undo()\n\n# Usage of deleteNamespaceContent option parameter:\n# Remove all the contents in the target namespace specified in the command and\n# remove the namespace\n#\ncmds.namespace( removeNamespace = ":RM_TEST_ROOT:FOO:BAR", deleteNamespaceContent = True)\n\ncmds.undo()\n\n# Usage of mergeNamespaceWithParent parameter:\n# Move the content of the target namespace specified in the command to its parent\n# namespace and remove the namespace.\n#\ncmds.namespace( removeNamespace = ":RM_TEST_ROOT:FOO:BAR", mergeNamespaceWithParent = True)\n\ncmds.undo()\n\n# Usage of mergeNamespaceWithRoot parameter:\n# Move the content of the target namespace specified in the command to the root\n# namespace and remove the namespace.\n#\ncmds.namespace( removeNamespace = ":RM_TEST_ROOT:FOO:BAR", mergeNamespaceWithRoot = True)',
 'namespaceInfo': 'import maya.cmds as cmds\n\n# List the contents of the current namespace\n#\ncmds.namespaceInfo( listNamespace=True )\n\n# List the parent of the current namespace\n#\ncmds.namespaceInfo( parent=True )\n\n# List the parent of the current namespace with short name\n#\ncmds.namespaceInfo( parent=True, shortName=True )\n\n# Determine if the current namespace is root\n#\ncmds.namespaceInfo( rootNamespace=True )\n\n# List the parent of the current namespace with absolute name\n#\ncmds.namespaceInfo( parent=True, absoluteName=True )\n\n# List dependency nodes including internal nodes\n#\ncmds.namespaceInfo(listOnlyDependencyNodes = True,  internal = True);\n\n# samples of query info of specified namespace\ncmds.namespace( set =":" )\ncmds.namespace( add ="sample" )\ncmds.namespace( set =":sample" )\ncmds.namespace( add ="sun" )\n\n# List the contents of the specified namespace\n#\ncmds.namespaceInfo( ":sample", listNamespace=True )\n# Result: sample:sun\n\n# List the parent of the specified namespace\n#\ncmds.namespaceInfo( ":sample:sun", parent=True )\n# result: sample\n\n# List the parent of the specified namespace with baseName name\n#\ncmds.namespaceInfo( ":sample:sun", parent=True, baseName=True )\n# result: sample\n\n# Determine if the specified namespace is root\n#\ncmds.namespaceInfo( ":", isRootNamespace=True )\n# result: True\n\n# List the parent of the specified namespace with absolute name\n#\ncmds.namespaceInfo( ":sample:sun", parent=True, absoluteName=True )\n# result: :sample\n\n# List dependency nodes including internal nodes\n#\ncmds.namespaceInfo(  ":sample", listOnlyNamespaces = True )\n# result: sample:sun\n\n# Query the namespace name and have it returned in different formats\n#\ncmds.namespaceInfo( ":sample:sun", baseName = True )\n# result: "sun"\n\ncmds.namespaceInfo( ":sample:sun", fullName = True )\n# result: "sample:sun"\n\ncmds.namespaceInfo( "sample:sun", absoluteName = True )\n# result: ":sample:sun"',
 'newton': 'import maya.cmds as cmds\n\ncmds.newton( \'particle1\', m=5.0, mxd=2.0 )\n# Creates a newton field with magnitude 5.0 and maximum distance 2.0,\n# and adds it to the list of fields particle1 owns.\n\ncmds.newton( pos=(-2, 0, 4) )\n# Creates a newton field at position (0,2,4) in world coordinates,\n# with default magnitude(1.0), attentuation (1.0),\n# and max distance (5.0).\n\ncmds.newton( \'newtonField1\', e=1, att=0.98 )\n# Edits the acceleration value of the field named newtonField1\n\ncmds.newton( \'newtonField1\', q=1, m=1 )\n# Queries newtonF ield1for its magnitude.\n\ncmds.newton( \'newtonField1\', e=1, mxd=10.0 )\n# Changes the maximum distance of the field called\n# "newtonField1" to 10.0.\n\ncmds.newton( m=2.0 )\n# Creates a newton field with magnitude 2.0 for every active selection.\n# If no there are active\n# selections, creates such a field at world position (0,0,0).',
 'nodeCast': 'import maya.cmds as cmds\n\n\ntr1 = cmds.createNode( \'transform\' )\ntr2 = cmds.createNode( \'transform\' )\ncmds.connectAttr( tr1 + ".t", tr2 + ".t" )\ncmds.connectAttr( tr2 + ".r", tr1 + ".r" )\n\ntheT = tr1\ncmds.select( theT, replace=1 )\ncmds.addAttr( ln="unmatched", at="long" )\nmiddle_man = cmds.createNode( \'transform\' )\ncmds.connectAttr( theT + ".unmatched", middle_man + ".tx" )\n\nswapNode = cmds.createNode( \'transform\' )\ncmds.nodeCast( theT, swapNode, disconnectUnmatchedAttrs=true )',
 'nodeEditor': 'import maya.cmds as cmds\n\ncmds.window()\nform = cmds.formLayout()\np = cmds.scriptedPanel(type="nodeEditorPanel", label="Node Editor")\ncmds.formLayout(form, e=True, af=[(p,s,0) for s in ("top","bottom","left","right")])\ncmds.showWindow()',
 'nodeGrapher': '',
 'nodeIconButton': 'import maya.cmds as cmds\n\nwindow = cmds.window( )\ncmds.columnLayout( adjustableColumn=True )\ncmds.nodeIconButton( style=\'textOnly\', command=\'cmds.shadingNode("lambert", asShader=True)\', label=\'lambert\' )\ncmds.nodeIconButton( style=\'iconOnly\', command=\'cmds.sphere()\', image1=\'sphere.png\' )\ncmds.nodeIconButton( style=\'iconAndTextHorizontal\', command=\'cmds.spotLight()\', image1=\'spotlight.png\', label=\'Spot Light\' )\ncmds.showWindow( window )',
 'nodeOutliner': "import maya.cmds as cmds\n\nmywindow = cmds.window()\nmyform = cmds.formLayout( numberOfDivisions=100 )\n\n# Create an outliner that will print the name of\n# every object added to it to history pane of the\n# script editor, then display all available input\n# plugs on the node.\ndef onAddNode(name):\n    print name\nmyoutliner = cmds.nodeOutliner( showInputs=True, addCommand=onAddNode )\n\n# Attach the nodeOutliner to the layout\ncmds.formLayout( myform, edit=True, attachForm=((myoutliner, 'top', 5), (myoutliner, 'left', 5), (myoutliner, 'bottom', 5), (myoutliner, 'right', 5)) )\n\n# Display the window with the node Outliner\ncmds.showWindow( mywindow )\n\n# Create a sphere\nobjectName = cmds.sphere()\n\n# Have the outliner display the sphere\ncmds.nodeOutliner( myoutliner, e=True, a='nurbsSphere1' )",
 'nodePreset': 'import maya.cmds as cmds\n\n# To determine if "My Special Settings" is a valid name for a preset (it\n# is not because it contains spaces):\n#\ncmds.nodePreset(isValidName="My Special Settings" )\n# Result: 0 #\n\n# To save the settings of nurbsSphereShape1 as a preset called "smithers":\n#\ncmds.nodePreset( save=("nurbsSphereShape1","smithers") )\n\n# To get a list of all presets available that could be applied to\n# nurbsSphereShape1:\n#\ncmds.nodePreset( list=\'nurbsSphereShape1\' )\n# Result: [u\'smithers\', u\'smoothSphere\', u\'roughSphere\', u\'atmoSphere\'] #\n\n# To load the preset named "smoothSphere" onto nurbsSphereShape1:\n#\ncmds.nodePreset( load=(\'nurbsSphereShape1\', \'smoothSphere\') )\n\n# To delete the preset named "smithers" which was formerly available for the\n# node nurbsSphereShape1 (and other nodes of the same type):\n#\ncmds.nodePreset( delete=(\'nurbsSphereShape1\', \'smithers\') )\n\n# To determine if a preset named "smithers" exists for the node\n# nurbsSphereShape1 (it does not because it has been deleted):\n#\ncmds.nodePreset( exists=(\'nurbsSphereShape1\', \'smithers\') )\n# Result: 0 #\n\n# Create a preset containing only the color and diffuse attributes:\n#\ncmds.nodePreset( save=("lambert1","colorAndDiffuse"), attributes=\'color diffuse\' )\n\n# Create a preset to map a checker texture to the applied node.\n# Because the "custom" callback is required to return an array of MEL commands,\n# each line of python in the array must be wrapped by the MEL "python" command.\n#\ndef customChecker():\n    doCheckerCmds = [\n\t\t# Get the name of the node to apply the checker to.\n\t \t"python( \\"selection = cmds.ls( selection=True )\\" );",\n\t    "python( \\"nodeName = selection[0]\\" );",\n\t    # Create a checker texture.\n\t    "python( \\"checkerName = cmds.shadingNode( \'checker\', asTexture=True )\\" );",\n\t    # Connect the checker to the node the preset is applied to.\n\t\t"python( \\"cmds.connectAttr( (checkerName+\\\\\\".outColor\\\\\\"), (nodeName+\\\\\\".color\\\\\\") )\\" );"\n\t\t]\n    return doCheckerCmds\n\n\tcmds.nodePreset(custom="python( \\"customChecker()\\" )", save=(\'lambert1\', \'checkered\') )',
 'nodeTreeLister': "import maya.cmds as cmds\n\ncmds.window(width=200)\ncmds.formLayout('theForm')\ncmds.nodeTreeLister('theTreeLister')\ncmds.formLayout('theForm', e=True,\n                af=(('theTreeLister', 'top', 0),\n                    ('theTreeLister', 'left', 0),\n                    ('theTreeLister', 'bottom', 0),\n                    ('theTreeLister', 'right', 0)))\ncmds.showWindow()",
 'nodeType': "import maya.cmds as cmds\n\ncmds.sphere( n='balloon' )\n\n# Find the type of node created by the sphere command\ncmds.nodeType( 'balloon' )\n# Result: transform #\n\n# What is the API type of the balloon node?\ncmds.nodeType( 'balloon', api=True )\n# Result: kTransform #\n\n# Which node types derive from camera?\ncmds.nodeType( 'camera', derived=True, isTypeName=True )\n# Result: [u'stereoRigCamera', u'camera'] #",
 'nonLinear': "import maya.cmds as cmds\n\n# To create a bend deformer with curvature 0.5\n#\ncmds.nonLinear( type='bend', curvature=0.5 )\n\n# To edit the curvature of the bend deformer\n#\ncmds.nonLinear( 'bend1', e=True, curvature=0.2 )\n\n# To query the curvature of the bend deformer\n#\ncmds.nonLinear( 'bend1', query=True, curvature=True )",
 'nop': '',
 'normalConstraint': "import maya.cmds as cmds\n\ncmds.normalConstraint( 'surf1', 'cube1' )\n# orients the aim vector of cube1 in it's local coordinate space,\n# to the normal vector of surf1 at the closest point to  cube1.\n\ncmds.normalConstraint( 'surf1', 'surf2', 'cube2', w=.1 )\n# uses the average of the normals from surf1 and surf2.\n\ncmds.normalConstraint( 'surf1', 'cube2', e=True, w=10. )\n# sets the weight for surf1's effect on cube2 to 10.\n\ncmds.normalConstraint( 'surf2', 'cube2', e=True, rm=True )\n# removes surf2 from cube2's normalConstraint.\n\ncmds.normalConstraint( 'surf3', 'cube2' )\n# adds surf3 to cube2's normalConstraint with the default weight.",
 'nurbsBoolean': "import maya.cmds as cmds\n\n# To do a union between two cubes.\ncmds.nurbsBoolean( 'nurbsCube1', 'nurbsCube2', nsf=1, op=0 )\n\n# To do a subtract between a cube and a sphere.\n# i.e cube - sphere\ncmds.nurbsBoolean( 'nurbsCube1', 'nurbsSphere1', op=1, nsf=1 )\n\n# To do an intersect between two spheres.\ncmds.nurbsBoolean( 'nurbsSphere1', 'nurbsSphere2', op=2, nsf=1 )",
 'nurbsCopyUVSet': 'import maya.cmds as cmds\n\ncmds.nurbsCopyUVSet()',
 'nurbsCube': 'import maya.cmds as cmds\n\ncmds.nurbsCube()\ncmds.nurbsCube( w=3, hr=5 )\ncmds.nurbsCube( w=10, p=(0, 0, 1) )\ncmds.nurbsCube( d=1, u=3, v=5, w=5 )',
 'nurbsCurveRebuildPref': '',
 'nurbsCurveToBezier': 'import maya.cmds as cmds\n\ncmds.nurbsCurveToBezier( )\n# Converts call selected NURBS curves to Bezier curves.',
 'nurbsEditUV': 'import maya.cmds as cmds\n\nresult = cmds.sphere()\nshape = result[0]\ncmds.select(shape, r=True)\n\ncmds.nurbsUVSet(create=True)\ncmds.nurbsUVSet(useExplicit=True)\n\ncmds.select(shape+".cv[3:5][2:4]", r=True)\n\n# Rotate the UVs by 45 degrees\ncmds.nurbsEditUV(angle=45)',
 'nurbsPlane': 'import maya.cmds as cmds\n\n# Create default plane\ncmds.nurbsPlane()\n\n# Create a degree 3 plane with 4 spans in each direction\ncmds.nurbsPlane( d=3, u=4, v=4 )\n\n# Create plane that is twice as long as it is wide\ncmds.nurbsPlane( w=3, lr=2 )',
 'nurbsSelect': 'import maya.cmds as cmds\n\n# Create a Nurbs plane.\ncmds.nurbsPlane( u=5, v=7 )\n\n# Select it top and bottom CVs.\ncmds.nurbsSelect( topBorder=True, bottomBorder=True )\n\n# Expand the selection to 3 rows.\ncmds.nurbsSelect( growSelection=3 )\n\n# Select only the outline of the rows.\ncmds.nurbsSelect( borderSelection=True )',
 'nurbsSquare': 'import maya.cmds as cmds\n\n# create degree 1 square with side length 2, center (0,0,0) on the\n# x-y plane\ncmds.nurbsSquare( nr=(0, 0, 1), d=1, c=(0, 0, 0), sl1=2, sl2=2 )\n\n# create degree 2 rectangle with length 2,4 at origin on the x-y plane\ncmds.nurbsSquare( d=2, nr=(0, 0, 1), c=(0, 0, 0), sl1=2, sl2=4 )\n\n# create square of degree 3,side lengths 3, 4 spans per side\ncmds.nurbsSquare( nr=(0, 0, 1), c=(0, 0, 0), d=3, sl1=3, sl2=3, sps=4 )',
 'nurbsToPoly': "import maya.cmds as cmds\n\n# To create a new polygonal surface from a NURBS surface:\ncmds.nurbsToPoly( 'nurbsSphere1' )\n\n# To create a new polygonal surface from a NURBS surface with\n# history so that the tesselation can be edited afterwards:\ncmds.nurbsToPoly( 'nurbsSphere1', ch=True )",
 'nurbsToPolygonsPref': 'import maya.cmds as cmds\n\n# To find out what the current format is:\ncmds.nurbsToPolygonsPref( q=True, f=True )',
 'nurbsToSubdiv': "import maya.cmds as cmds\n\n# To create a new subd surface from a NURBS surface:\ncmds.nurbsToSubdiv( 'nurbsSphere1' )\n\n# To create a new subd surface from a NURBS surface with history so that\n# the tesselation can be edited afterwards:\ncmds.nurbsToSubdiv( 'nurbsSphere1', ch=True )",
 'nurbsToSubdivPref': 'import maya.cmds as cmds\n\n# To find out what the current format is:\ncmds.nurbsToSubdivPref( q=True, maxPolyCount=True )',
 'nurbsUVSet': 'import maya.cmds as cmds\n\nresult = cmds.sphere()\nshape = result[0]\ncmds.select(shape, r=True)\n\n# Create and activate a UV set\ncmds.nurbsUVSet(create=True)\ncmds.nurbsUVSet(useExplicit=True)\n\ncmds.select(shape+".cv[3:5][2:4]", r=True)\n\n# Rotate the UVs by 45 degrees\ncmds.nurbsEditUV(angle=45)',
 'objExists': 'import maya.cmds as cmds\n\n# Select an object if and only if it exists.\n# Print a warning if it does not exist.\nif cmds.objExists(\'surface1\'):\n  cmds.select(\'surface1\')\nelse:\n  print("Warning: no surface exists.")',
 'objectCenter': "import maya.cmds as cmds\n\n# create a simple hierarchy\ncmds.polyCube( name='a' )\ncmds.polyCube( name='b' )\ncmds.parent( 'b', 'a' )\ncmds.move( 3, 0, 0, 'a', localSpace=True )\ncmds.move( 2, 2, 2, 'b', localSpace=True )\n\nX_COORD = cmds.objectCenter('b',x=True)\n# Result: 5 #\n\n# Get the center of the bounding box of b in local space\nXYZ = cmds.objectCenter('b', l=True)\n# Result: 2 2 2 #\n\n# Get the center of the bounding box of b in world space\nXYZ = cmds.objectCenter('b', gl=True)\n# Result: 5 2 2 #\n\n# Get the center of the bounding box of a in world space\nXYZ = cmds.objectCenter('a', gl=True)",
 'objectType': "import maya.cmds as cmds\n\n# create an object to query type of\ncmds.sphere( n='sphere1' )\n\n# To query the type of an object:\ncmds.objectType( 'sphere1Shape' )\n# Result: nurbsSurface #\n\n# To confirm that sphere1Shape really is a nurbs surface:\ncmds.objectType( 'sphere1Shape', isType='nurbsSurface' )\n# Result: 1 #",
 'objectTypeUI': 'import maya.cmds as cmds\n\nprint(cmds.objectTypeUI( \'viewPanes\' ))\n\n# show all commands as their types\nimport sys\nfor c,e in enumerate(cmds.objectTypeUI(listAll=True)):\n    c += 1\n    sys.stdout.write(e + " ")\n    if c % 3 == 0:\n        sys.stdout.write(\'\\n\')\n\n# show Qt inheritence hierachy for buttons\ncmds.window()\ncmds.rowColumnLayout()\nb = cmds.button()\ncmds.showWindow()\nprint(cmds.objectTypeUI(b,sc=True))',
 'offsetCurve': "import maya.cmds as cmds\n\n# offset all active curves to the specified distance:\ncmds.offsetCurve( d=4.0 )\n\n# create offsets for the specified curve and turn loop cutting off:\ncmds.offsetCurve( 'curve1', cl=False)\n\n# create offsets with circular arcs at the breaks in the curve and use\n# a cutting radius of 2.0 if there are any loops in the offsets:\ncmds.offsetCurve( 'curve1', cb=1, cl=True, cr=2.0 )",
 'offsetCurveOnSurface': "import maya.cmds as cmds\n\ncmds.nurbsPlane( ch=True, o=True, po=0, ax=(0, 1, 0), w=10, lr=2 )\ncmds.circle( ch=True, o=True, nr=(0, 1, 0), r=3 )\ncmds.projectCurve( 'nurbsCircle1', 'nurbsPlane1', ch=0, rn=False, un=False, tol=0.01 )\n\n# Offset given curve to the specified distance at the specified tolerance:\ncmds.offsetCurveOnSurface( 'nurbsPlaneShape1->projectionCurve1_1', d=0.12, tol=0.02 )\n\n# Create offsets for the specified curve and turn loop cutting off:\ncmds.offsetCurveOnSurface( 'nurbsPlaneShape1->projectionCurve1_1', cl=False )\n\n# Create offsets with circular arcs at the breaks in the curves and trim\n# away any loops in the offset curve:\ncmds.offsetCurveOnSurface( 'nurbsPlaneShape1->projectionCurve1_1', cb=1, cl=False )",
 'offsetSurface': "import maya.cmds as cmds\n\n# To offset the active surface to the specified distance:\ncmds.offsetSurface( d=4.0 )\n\n# To create an offset using the surface fit offset method:\ncmds.offsetSurface( 'surface1', m=0, d=2.0 )",
 'ogs': 'import maya.cmds as cmds\n\n// Reset the database for all panels running the OGS renderer.\n// Returns the number of panels affected.\ncmds.ogs( reset=True )\n// Result: [modelPanel1] //\n\n// Set the gpu memory limit to 2048 MB.  Memory management systems\n// will attempt to avoid going over this limit.  Can be used to reserve\n// memory for other applications.\ncmds.ogs( gpuMemoryTotal=2048 )\n\n// Output the current gpu memory limit in MB.\ncmds.ogs( query=True, gpuMemoryTotal=True )\n\n// Output an estimate of the amount of currently allocated gpu memory by\n// Maya in MB.\ncmds.ogs( gpu=True )',
 'ogsRender': 'import maya.cmds as cmds\n\n# Create a poly sphere.\ncmds.polySphere()\n\n# Render it\n# It will try to save the image with format according\n# to the file name saved in render globals.\ncmds.ogsRender(w=480,h=270)\ncmds.ogsRender(w=480,h=270)',
 'ogsdebug': '',
 'openCLInfo': 'import maya.cmds as cmds\n\n# Query if OpenCL is initialized or not\ncmds.openCLInfo(query=True, valid=True)\n# Result: True #\n\n# Set the minimum vertex buffer size\ncmds.openCLInfo(mvb=2000)\n\n# Query the minimum vertex buffer size\ncmds.openCLInfo(query=True, mvb=True)\n# Result: 2000 #\n\n# Query whether double precision is supported or not\ncmds.openCLInfo(query=True, dbl=True)\n# Result: True #',
 'openGLExtension': "import maya.cmds as cmds\n\n# Query for the multitexturing extension GL_ARB_multitexture\ncmds.openGLExtension( extension='GL_ARB_multitexture' )\n\n# Query for all the extensions\ncmds.openGLExtension( extension='' )\n\n# Query for the renderer name\ncmds.openGLExtension( renderer=True )\n\n# Query for the vendor\ncmds.openGLExtension( vendor=True )\n\n# Query for the OpenGL version\ncmds.openGLExtension( version=True )",
 'openMayaPref': 'import maya.cmds as cmds\n\n# Enable RTLD_LAZY binding when loading plug-ins\ncmds.openMayaPref( lz=True )\n\n# Force RTLD_NOW binding when loading plug-ins\ncmds.openMayaPref( lz=False )\n\n# Disable the warning about old plug-ins being loaded\ncmds.openMayaPref( ow=False )\n\n# Turn on the Error log\ncmds.openMayaPref( errlog=True )\n\n# Query the Error log\ncmds.openMayaPref( q=True, errlog=True )\n\n# Turn off the Error log\ncmds.openMayaPref( errlog=False )',
 'optionMenu': "import maya.cmds as cmds\n\ndef printNewMenuItem( item ):\n\tprint item\n\nwindow = cmds.window()\ncmds.columnLayout()\ncmds.optionMenu( label='Colors', changeCommand=printNewMenuItem )\ncmds.menuItem( label='Yellow' )\ncmds.menuItem( label='Purple' )\ncmds.menuItem( label='Orange' )\ncmds.showWindow( window )",
 'optionMenuGrp': "import maya.cmds as cmds\n\n#    Create a window with two option menu groups.\n#\nwindow = cmds.window( title='Example 1' )\ncmds.columnLayout()\n\n#    Create a couple of option menu groups.\n#\ncolors = cmds.optionMenuGrp(label='Colors')\ncmds.menuItem( label='Red' )\ncmds.menuItem( label='Green' )\ncmds.optionMenuGrp( l='Position' )\ncmds.menuItem( label='Left' )\ncmds.menuItem( label='Center' )\ncmds.menuItem( label='Right' )\n\n#    Now add an additional item to the first option menu.\n#\ncmds.menuItem(parent=(colors +'|OptionMenu'), label='Blue' )\ncmds.showWindow( window )\n\n#    Create another window with an option menu group.\n#\nwindow = cmds.window( title='Example 2' )\ncmds.columnLayout()\ncmds.optionMenuGrp( label='Size', extraLabel='cm', columnWidth=(2, 80) )\ncmds.menuItem( label='10' )\ncmds.menuItem( label='100' )\ncmds.menuItem( label='1000' )\ncmds.showWindow( window )",
 'optionVar': "import maya.cmds as cmds\n\ncmds.optionVar( iv=('defaultTriangles', 4), sv=('defaultFileName', 'buffalo.maya') )\ncmds.optionVar( exists='defaultTriangles' )\n# Result: 1 #\ncmds.optionVar( q='defaultFileName' )\n# Result: buffalo.maya #\ncmds.optionVar( list=True )\ncmds.optionVar( remove='defaultTriangles' )\ncmds.optionVar( exists='defaultTriangles' )\n# Result: 0 #",
 'orbit': "import maya.cmds as cmds\n\ncmds.camera()\ncmds.orbit( 'cameraShape1', ha=-30 )# Change the horizontal angle by -30 degrees\n\ncmds.orbit( 'cameraShape1', va=15 )# Change the vertical angle by 15 degrees\n\ncmds.orbit( 'cameraShape1', ra=(-30, 15) )# Change the horizontal angle by -30 degrees and the vertical angle by 15 degrees",
 'orbitCtx': "import maya.cmds as cmds\n\ncmds.orbitCtx( 'orbitContext', os=30.0, lo=False )",
 'orientConstraint': 'import maya.cmds as cmds\n\n# Orients cube1 to match cone1.\ncmds.orientConstraint( \'cone1\', \'cube1\' )\n\n# Uses the average of the orientations of cone1 and surf2.\ncmds.orientConstraint( \'cone1\', \'surf2\', \'cube2\', w=.1 )\n\n# Sets the weight for cone1\'s effect on cube2 to 10.\ncmds.orientConstraint( \'cone1\', \'cube2\', e=True, w=10. )\n\n# Removes surf2 from cube2\'s orientConstraint\ncmds.orientConstraint( \'surf2\', \'cube2\', e=True, rm=True )\n\n# Adds surf3 to cube2\'s orientConstraint with the default weight\ncmds.orientConstraint( \'surf3\', \'cube2\' )\n\n# Constrain the y and z rotation of sph2 to sph1\ncmds.orientConstraint( \'sph1\', \'sph2\', skip="x" )\n\n# Modify the constraint so that it constrains all axes of sph2\ncmds.orientConstraint( \'sph1\', \'sph2\', e=True, skip="none" )\n\n# Create a cache for the orient constraint controlling cube2\ncmds.orientConstraint( \'cube2\', e=True, cc=(1, 1000) )',
 'outlinerEditor': "import maya.cmds as cmds\n\n# Create a new regular outliner in its own window\n#\ncmds.window()\ncmds.frameLayout( labelVisible=False )\npanel = cmds.outlinerPanel()\noutliner = cmds.outlinerPanel(panel, query=True,outlinerEditor=True)\ncmds.outlinerEditor( outliner, edit=True, mainListConnection='worldList', selectionConnection='modelList', showShapes=False, showReferenceNodes=False, showReferenceMembers=False, showAttributes=False, showConnected=False, showAnimCurvesOnly=False, autoExpand=False, showDagOnly=True, ignoreDagHierarchy=False, expandConnections=False, showNamespace=True, showCompounds=True, showNumericAttrsOnly=False, highlightActive=True, autoSelectNewObjects=False, doNotSelectNewObjects=False, transmitFilters=False, showSetMembers=True, setFilter='defaultSetFilter', ignoreHiddenAttribute=False, ignoreOutlinerColor=False )\ncmds.showWindow()",
 'outlinerPanel': "import maya.cmds as cmds\n\n# Create a new regular outliner in its own window\n#\ncmds.window()\ncmds.frameLayout( labelVisible=False )\npanel = cmds.outlinerPanel()\noutliner = cmds.outlinerPanel(panel, query=True,outlinerEditor=True)\ncmds.outlinerEditor( outliner, edit=True, mainListConnection='worldList', selectionConnection='modelList', showShapes=False, showReferenceNodes=False, showReferenceMembers=False, showAttributes=False, showConnected=False, showAnimCurvesOnly=False, autoExpand=False, showDagOnly=True, ignoreDagHierarchy=False, expandConnections=False, showCompounds=True, showNumericAttrsOnly=False, highlightActive=True, autoSelectNewObjects=False, doNotSelectNewObjects=False, transmitFilters=False, showSetMembers=True, setFilter='defaultSetFilter', ignoreHiddenAttribute=False, ignoreOutlinerColor=False )\ncmds.showWindow()",
 'outputWindow': 'import maya.cmds as cmds\n\ncmds.outputWindow()\ncmds.outputWindow(show=True)',
 'overrideModifier': 'import maya.cmds as cmds\n\n#    Example 1.\n#\n#    Map the "a" key such that it behaves just like the "Alt" key.\n#\ncmds.nameCommand( \'alternateAltPressCommand\', annotation=\'"Alternate Alt-press modifier key"\', command=\'"overrideModifier -press Alt"\' )\ncmds.nameCommand( \'alternateAltReleaseCommand\', annotation=\'"Alternate Alt-release modifier key"\', command=\'"overrideModifier -release Alt"\' )\ncmds.hotkey( keyShortcut=\'a\', name=\'alternateAltPressCommand\' )\ncmds.hotkey( keyShortcut=\'a\', releaseName=\'alternateAltPressCommand\' )\n\n#    Example 2.\n#\n#    The following should restore the "a" hotkey to what it was\n#    previously.\n#\ncmds.overrideModifier( clear=True )\ncmds.hotkey( factorySettings=True )\ncmds.hotkey( sourceUserHotkeys=True )',
 'paint3d': '',
 'paintEffectsDisplay': 'import maya.cmds as cmds\n\ncmds.paintEffectsDisplay( meshDrawEnable=True )\nmeshDrawEnabled = cmds.paintEffectsDisplay(query=True, me=True)',
 'pairBlend': "import maya.cmds as cmds\n\n# Create a pairBlend node and connect sphere1's tx and ty to the pairBlend's input1\ncmds.nurbsSphere(n='sphere1')\ncmds.pairBlend( nd='sphere1', at=['tx','ty'] )\n\n# Query the nodes connected to input1.\n#\ninputs = cmds.pairBlend('pairBlend1' ,query=True, input1=True)",
 'palettePort': "import maya.cmds as cmds\n\ncmds.window()\ncmds.frameLayout(labelVisible=0)\n\n# create a palette of 20 columns and 15 rows\ncmds.palettePort( 'palette', dim=(20, 15) )\n\n# select cell #30\ncmds.palettePort( 'palette', edit=True, scc=30 )\n\n# return RGB value for this cell\ncmds.palettePort( 'palette', query=True, rgb=True )\n\n# make cell #100 transparent and blue\ncmds.palettePort( 'palette', edit=True, transparent=100, rgb=(100, 0.0, 0.0, 1.0) )\ncmds.palettePort( 'palette', edit=True, redraw=True )\n\n# returns the current transparent cell (there can be only one)\ncmds.palettePort( 'palette', query=True, transparent=True )\ncmds.showWindow()",
 'panZoom': "import maya.cmds as cmds\n\ncmds.camera()\n\ncmds.panZoom( 'cameraShape1', d=0.3 )\n\ncmds.panZoom( 'cameraShape1', abs=True, u=0.4 )\n\ncmds.panZoom( 'cameraShape1', z=0.5 )",
 'panZoomCtx': "import maya.cmds as cmds\n\ncmds.panZoomCtx( 'panZoomContext', zs=1.0 )",
 'paneLayout': "import maya.cmds as cmds\n\ncmds.window()\ncmds.paneLayout( configuration='quad' )\ncmds.button()\ncmds.textScrollList( append=['one', 'two', 'three'] )\ncmds.scrollField()\ncmds.scrollLayout()\ncmds.columnLayout()\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.showWindow()",
 'panel': "import maya.cmds as cmds\n\nMyLabel = 'My Panel'\ncmds.window()\ncmds.frameLayout( lv=0 )\ncmds.modelPanel( l=MyLabel )\ncmds.showWindow()\n\npanels = cmds.getPanel( all=True )\n\nfor panel in panels:\n\tif MyLabel == cmds.panel( panel, q=True, label=True ):\n\t\tmyPanel = panel\n\t\tprint( 'Found: '+MyLabel )",
 'panelConfiguration': 'import maya.cmds as cmds\n\n#    Create a custom panel configuration.\n#\nconfigName = cmds.panelConfiguration(\n\t\t\t\tlabel="Custom Panel Layout",\n\t\t\t\tsceneConfig=False,\n\t\t\t\tconfigString="paneLayout -e -cn \\"vertical2\\" -ps 1 39 100 -ps 2 61 100 $gMainPane;",\n\t\t\t\taddPanel=[\n\t\t\t\t\t(False,\n\t\t\t\t\t\'Outliner\',\n\t\t\t\t\t\'outlinerPanel\',\n\t\t\t\t\t("{global int $gUseMenusInPanels;\\\n\t\t\t\t\t$panelName = `outlinerPanel -mbv $gUseMenusInPanels -unParent -l \\"Outliner\\"`;\\\n\t\t\t\t\toutlinerEditor -e -highlightActive true $panelName;}"),\n\t\t\t\t\t"outlinerPanel -edit -l \\"Outliner\\"  $panelName"),\n\n\t\t\t\t\t(True,\n\t\t\t\t\t"Persp View",\n\t\t\t\t\t"modelPanel",\n\t\t\t\t\t("{global int $gUseMenusInPanels;\\\n\t\t\t\t\tmodelPanel -mbv $gUseMenusInPanels\\\n\t\t\t\t\t-unParent -l \\"Persp View\\" -cam persp;}" ),\n\t\t\t\t\t"modelPanel -edit -l \\"Persp View\\"  -cam \\"persp\\" $panelName")\n\t\t\t\t]\n\t\t\t)\n\n#    Update the main Maya window to reflect the custom panel configuration.\n#    Note also that your custom configuration may be selected from any\n#    panel\'s "Panels->Saved Layouts" menu.\n#\nmaya.mel.eval(\'setNamedPanelLayout( "Custom Panel Layout" )\')',
 'panelHistory': 'import maya.cmds as cmds\n\n#    Create a window containing a pane layout.  The window also contains\n#    an option menu for changing the layout configuration and two buttons\n#    for stepping through the configuration history.\n#\nwindow = cmds.window( title=\'panelHistory Example\' )\nform = cmds.formLayout()\n\n#    Create the option menu for panel configuration.\n#\nconfiguration = cmds.optionMenuGrp( label=\'Configuration\', columnWidth2=( 100, 150 ) )\n\nsingle = cmds.menuItem( label=\'Single\' )\nstacked = cmds.menuItem( label=\'2 Stacked\' )\nsideBySide = cmds.menuItem( label=\'2 Side by Side\' )\nfour = cmds.menuItem( label=\'Four\' )\n\n#    Create the buttons for stepping through configuration history.\n#\nhistory = cmds.rowLayout( numberOfColumns=3 , columnWidth3=( 100, 75, 75 ),\n\t\t\t\t\t\t  columnAttach=[( 2, \'both\', 0 ),( 3, \'both\', 0 )] )\ncmds.text( label=\'History\' )\nbackBtn = cmds.button( label=\'Back\' )\nforwardBtn = cmds.button( label=\'Forward\' )\ncmds.setParent( \'..\' )\n\n#    Create the pane layout.\n#\nframe = cmds.frameLayout( labelVisible=False )\npanes = cmds.paneLayout()\ncmds.text( label=\'Pane 1\' )\ncmds.text( label=\'Pane 2\' )\ncmds.text( label=\'Pane 3\' )\ncmds.text( label=\'Pane 4\' )\n\n#    Set up the attachments.\n#\ncmds.formLayout( form, edit=True,\n\t\t\t\t attachForm=[(configuration, \'top\', 5),\n\t\t\t\t\t\t\t (configuration, \'left\', 5),\n\t\t\t\t\t\t\t (history, \'left\', 5),\n\t\t\t\t\t\t\t (history, \'right\', 5),\n\t\t\t\t\t\t\t (frame, \'left\', 5),\n\t\t\t\t\t\t\t (frame, \'right\', 5),\n\t\t\t\t\t\t\t (frame, \'bottom\', 5)],\n\t\t\t\t attachControl=[(history, \'top\', 5, configuration),\n\t\t\t\t\t\t\t\t(frame, \'top\', 5, history)] )\n\n#    Create the panel history object.\n#\npanelHistory = cmds.panelHistory(targetPane=panes)\n\n#    Attach a command to the option menu to change the panel layout\n#    configuration accordingly.\n#\ncmds.optionMenuGrp( configuration,\n\t\t\t\t\tedit=True,\n\t\t\t\t\tchangeCommand=(\'ExampleUpdatePaneLayout( \\"\'+ configuration + \'\\", \\"\' + panes + \'\\" )\') )\n\n#    Attach commands to the buttons for stepping through the configuration\n#    history.  The commands should also update the value of the option menu.\n#\ncmds.button( backBtn, edit=True,\n\t\t\t command=\'cmds.panelHistory( panelHistory, edit=True, back=True ); ExampleUpdateConfiguration( \\"\' + configuration + \'\\", \\"\' + panes + \'\\" )\' )\ncmds.button( forwardBtn, edit=True,\n\t\t\t command=\'cmds.panelHistory( panelHistory, edit=True, forward=True ); ExampleUpdateConfiguration( \\"\' + configuration + \'\\", \\"\' + panes + \'\\" )\' )\n\ncmds.showWindow( window )\n\n#    Call this procedure whenever the option menu\'s configuration value\n#    changes.  This procedure will update the configuration of the\n#    pane layout to reflect the change.\n#\ndef ExampleUpdatePaneLayout( optionMenuGrp, paneLayout ):\n\tif optionMenuGrp == "" or paneLayout == "":\n\t\treturn\n\n\tvalue = cmds.optionMenuGrp( optionMenuGrp, query=True, value=True )\n\tif value == "Single":\n\t\tcmds.paneLayout( paneLayout, edit=True, configuration=\'single\' )\n\telif value == "2 Stacked":\n\t\tcmds.paneLayout( paneLayout, edit=True, configuration=\'horizontal2\' )\n\telif value == "2 Side by Side":\n\t\tcmds.paneLayout( paneLayout, edit=True, configuration=\'vertical2\' )\n\telif value == "Four":\n\t\tcmds.paneLayout( paneLayout, edit=True, configuration=\'quad\' )\n\n#    Call this procedure whenever the panel configuration changes due to\n#    stepping through the panel history (ie. pressing either the "Forward"\n#    or "Back" buttons.  This procedure will update the value of the\n#    option menu to reflect the new pane layout configuration.\n#\ndef ExampleUpdateConfiguration( optionMenuGrp, paneLayout ):\n\tif optionMenuGrp == "" or paneLayout == "":\n\t\treturn\n\n\tconfiguration = cmds.paneLayout( paneLayout, query=True, configuration=True );\n\n\tif configuration == \'single\':\n\t\tcmds.optionMenuGrp( optionMenuGrp, edit=True, value=\'Single\' )\n\telif configuration == \'horizontal2\':\n\t\tcmds.optionMenuGrp( optionMenuGrp, edit=True, value=\'2 Stacked\' )\n\telif configuration == \'vertical2\':\n\t\tcmds.optionMenuGrp( optionMenuGrp, edit=True, value=\'2 Side by Side\' )\n\telif configuration == \'quad\':\n\t\tcmds.optionMenuGrp( optionMenuGrp, edit=True, value=\'Four\' )',
 'paramDimContext': 'import maya.cmds as cmds\n\ncmds.paramDimContext()',
 'paramDimension': "import maya.cmds as cmds\n\ncmds.curve(d=3, p=((-9.3, 0, 3.2), (-4.2, 0, 5.0), (6.0, 0, 8.6), (2.1, 0, -1.9)), k=(0, 0, 0, 1, 2, 2));\ncmds.paramDimension( 'curveShape1.u[0.5]' )\n# displays where u = 0.5 is on the curve\ncmds.sphere();\ncmds.paramDimension( 'nurbsSphere1.uv[0.5][0.5]' )\n# displays where u = 0.5 and v = 0.5 is on the surface",
 'paramLocator': "import maya.cmds as cmds\n\n# Creates a locator on curve1 at parameter value 0.5.\ncmds.paramLocator( 'curve1.u[0.5]' )\n\n# Creates a locator on curve1 at its second edit point. (ep[0] is the 1st edit point).\ncmds.paramLocator( 'curve1.ep[1]' )\n\n# Creates a locator on curve1 at normalized parameter value 0.25.\ncmds.paramLocator( 'curve1.un[0.25]' )\n\n# Creates a locator on surface1 at parameter value (0.5,0.5).\ncmds.paramLocator( 'surface1.uv[0.5][0.5]' )",
 'parent': "import maya.cmds as cmds\n\n# Create some objects\ncmds.circle( name='circle1' )\ncmds.move( 5, 0, 0 )\ncmds.group( n='group1' )\ncmds.move( -5, 0, 0 )\ncmds.group( em=True, n='group2' )\n\n# Move the circle under group2.\n# Note that the circle remains where it is.\ncmds.parent( 'circle1', 'group2' )\n\n# Let's try that again with the -relative flag. This time\n# the circle will move.\ncmds.undo()\ncmds.parent( 'circle1', 'group2', relative=True )\n\n# Create an instance of the circle using the parent command.\n# This makes circle1 a child of group1 and group2.\ncmds.undo()\ncmds.parent( 'circle1', 'group2', add=True )\n\n# Remove group1 as a parent of the circle\ncmds.parent( 'group1|circle1', removeObject=True )\n\n# Move the circle to the top of the hierarchy\ncmds.parent( 'group2|circle1', world=True )\n\n# Remove an instance of a shape from a parent\ncmds.parent('nurbsSphere3|nurbsSphereShape1',shape=True,rm=True)",
 'parentConstraint': 'import maya.cmds as cmds\n\n# Position cube1 at the location of cone1\n# Rotate cube1 to the rotation of cone1\ncmds.parentConstraint( \'cone1\', \'cube1\' )\n\n\n# Position cube1 at the average of the locations of cone1 and surf2\n# Rotate cube1 to the average of the rotations of cone1 and surf2\ncmds.parentConstraint( \'cone1\', \'surf2\', \'cube2\', w=.1 )\n\n# Sets the weight for cone1\'s effect on cube2 to 10.\ncmds.parentConstraint( \'cone1\', \'cube2\', e=True, w=10.0 )\n\n# Removes surf2 from cube2\'s parentConstraint\ncmds.parentConstraint( \'surf2\', \'cube2\', e=True, rm=True )\n\n# Adds surf3 to cube2\'s parentConstraint with the default weight\ncmds.parentConstraint( \'surf3\', \'cube2\' )\n\n# Constrain position only in the y-axis with rotation\n# constraining in all axes\ncmds.parentConstraint( \'cone2\', \'cube2\', st=["x","z"] )',
 'particle': 'import maya.cmds as cmds\n\n# Creates a particle object with four particles\ncmds.particle( p=[(0, 0, 0), (3, 5, 6), (5, 6, 7), (9, 9, 9)] )\n\n# Returns the age of the particle with id 2 in object particle1\ncmds.particle( \'particle1\', q=True, attribute=\'age\', id=2 )\n\n# Returns the velocity of the 3rd particle in the currently selected\n# particle object\ncmds.particle( attribute=\'velocity\', q=True, order=3  )\n\n# Edits the velocity of the 7th particle in the currently selected\n# particle object to be 0.0, 1.0, 0.0\ncmds.particle( e=True, attribute=\'velocity\', order=3, vectorValue=(0.0, 1.0, 0.0) )\n\n# Edits the mass of the particle in "particle1" with id 3 to be 0.7\ncmds.particle( \'particle1\', e=True, attribute=\'mass\', id=3, fv=0.7 )',
 'particleExists': "import maya.cmds as cmds\n\n# If the object does not exist then false (0) is returned\ncmds.file( f=True, new=True )\ncmds.particleExists( 'particleShape1' )\n# Result: 0 #\n\n# Create a particle shape and then querying for\n# it will return true (1)\ncmds.emitter()\n# Result: emitter1 #\ncmds.particle()\n# Result: particle1 particleShape1 #\ncmds.connectDynamic( 'particle1', em='emitter1' )\n# Result: particleShape1 #\ncmds.particleExists( 'particleShape1' )\n# Result: 1 #\n\n# You may also query using the transform name\ncmds.particleExists( 'particle1' )\n# Result: 1 #\n\n# The name of a soft body object can be used to query as well\ncmds.polySphere( r=1, sx=20, sy=20, ax=(0, 1, 0), tx=2, ch=1 )\n# Result: pSphere1 polySphere1 #\ncmds.soft( c=True )\n# Result: pSphere1Particle #\ncmds.particleExists( 'pSphere1Particle' )\n# Result: 1 #",
 'particleFill': 'import maya.cmds as cmds\n\n# create a poly torus with particles filling interior\ncmds.polyTorus()\ncmds.particleFill()',
 'particleInstancer': "import maya.cmds as cmds\n\n\n# create a cube and a particle emitter\ncmds.polyCube()\ncmds.emitter(pos=(0,0,0), type='omni', r=100, sro=0, nuv=0, cye='none', cyi=1, spd=1, srn=0, nsp=1, tsp=0, mxd=0, mnd=0, dx=1, dy=0, dz=0, sp=0)\ncmds.particle()\ncmds.connectDynamic('particle1',em='emitter1')\n\n# instance the cube to each particle emitted\ncmds.particleInstancer( 'particleShape1', addObject=True, object='pCube1', cycle='None', cycleStep=1, cycleStepUnits='Frames', levelOfDetail='Geometry', rotationUnits='Degrees', rotationOrder='XYZ', position='worldPosition', age='age')\n\n# query the instancer associated with the particle\ncmds.particleInstancer( 'particle1', q=True, name=True )\n\n# query the particle attribute name corresponding to the position attribute for the instancer\ncmds.particleInstancer( 'particle1', name='instancer1', q=True, position=True )",
 'particleRenderInfo': 'import maya.cmds as cmds\n\n#Return the list of all render attributes\ncmds.particleRenderInfo(query=True, ala=True)',
 'partition': "import maya.cmds as cmds\n\n# To create a partition calls p1 which contains set1 and set2 ...\ncmds.partition( 'set1', 'set2', n='p1' )\n\n# To create an empty render partition ...\ncmds.partition( render=True )\n\n# To add/remove sets from partition p1 ...\ncmds.partition( 'set3', add='p1' )\ncmds.partition( 'set1', rm='p1' )\n\n# To get a list of all sets in a partition ...\ncmds.partition( 'p1', q=True )\n\n# To check if the partition is a render partition\ncmds.partition( 'p1', q=True, re=True )",
 'pasteKey': "import maya.cmds as cmds\n\n# Paste keyframes onto nurbsSphere1's translateX attribute at time 10\n#\ncmds.pasteKey( 'nurbsSphere1', time=(10,10), attribute='translateX' )\n\n# Paste to all active objects, preserving the timing from the clipboard.\n#\ncmds.pasteKey()",
 'pathAnimation': "import maya.cmds as cmds\n\n# Create a set of simple objects for the motion path animation\n\n# create a path, e,g, a curve\npath = cmds.curve(d=3,p=[(-10, 0, 0),(-6, 0, 10),(-3, 0, -10),(10, 0, 0)],k=[0, 0, 0, 1, 1, 1])\n\n# create an object, e.g. a sphere\nobject = cmds.sphere()\ncmds.scale( 0.5, 2.0, 0.2 )\n\n# 1. To animate the sphere along the curve, with one keyframe at\n# the current time:\n\ncmds.pathAnimation( object[0], c=path )\n\n# or:\n\ncmds.select( object[0], path )\ncmds.pathAnimation()\n\n# 2. To animate the sphere along the curve, from time 0 to time 30:\n\ncmds.pathAnimation( object[0], stu=0, etu=30, c=path )\n\n# 3. To align the sphere to its path:\n\ncmds.pathAnimation( object[0], stu=0, etu=30, follow=True, c=path )\n\n# 4. To align the Z axis of sphere to the tangent of the curve, and\n# to align the Y axis of the sphere to the up direction of the\n# motion curve:\n\ncmds.pathAnimation( object[0], stu=0, etu=30, fa='z', ua='y', c=path )\n\n# 5. To align the Z axis of sphere to the tangent of the motion curve,\n# to align the Y axis of sphere to the up direction of the motion\n# curve, and to bank with the curvature of the motion curve:\n\ncmds.pathAnimation( object[0], stu=0, etu=30, fa='z', ua='y', bank=True, c=path )\n\n# 6. To change the setting on the bankScale for the motionPath1\n# to negative 2.5 (i.e. bank out and multiply the computed\n# bank value by 2.5):\n\ncmds.pathAnimation( 'motionPath1', edit=True, bankScale=-2.5 )\n\n# Notes:\n# If the computed bank angles are not large enough, the user can\n# specify the bankScale to amplify them. The default value is 1.\n\n# Positive bankScale produces inward bank angle,\n# negative bankScale produces outward bank angle.\n\n# The user can also change the maximum bank angle through\n# the bankThreshold option. Default value is 90 degrees.",
 'pause': 'import maya.cmds as cmds\n\ncmds.pause( sec=10 )',
 'perCameraVisibility': "import maya.cmds as cmds\n\n# make 'pSphere1' exclusive to camera 'persp'\ncmds.perCameraVisibility( 'pSphere1', ex=True, c='persp' )\n# remove 'pSphere1' from camera 'persp''s exclusive objects\ncmds.perCameraVisibility( 'pSphere1', ex=True, rm=True, c='persp' )\n# query the objects that are exclusive to 'persp'\ncmds.perCameraVisibility( q=True, ex=True, c='persp' )\n# hide 'pSphere1' from camera 'persp'\ncmds.perCameraVisibility( 'pSphere1', hi=True, c='persp' )\n# remove 'pSphere1' from camera 'persp''s hidden objects\ncmds.perCameraVisibility( 'pSphere1', hi=True, rm=True, c='persp' )\n# query the objects that are hidden from 'persp'\ncmds.perCameraVisibility( q=True, hi=True, c='persp' )\n# remove all exclusive or hidden objects from 'persp'\ncmds.perCameraVisibility( rc=True, c='persp' )\n# remove all exclusive or hidden objects from all cameras\ncmds.perCameraVisibility( ra=True )",
 'percent': "import maya.cmds as cmds\n\n# set percents on the selected items to 0.6\n#\ncmds.percent( 'cluster1', v=0.6 )\n\n# set percents on the selected items dropping off along the\n# z-axis starting at the origin. Dropoff distance is 5, and\n# the initial value is 1. Dropoff type is linear.\n#\ncmds.percent( 'cluster1', dp=(0, 0, 0), dax=(0, 0, 1), dt='linear', dds=5, v=1 )\n\n# set percents on the selected items dropping off along\n# curve1. Dropoff distance is 5, and\n# the initial value is 0.3.\n#\ncmds.percent( 'cluster2', dc='curve2', dds=3, v=0.3 )\n\n# add 0.1 to the percents of the selected items\n#\ncmds.percent( 'cluster1', v=0.1, ap=True )",
 'performanceOptions': "import maya.cmds as cmds\n\n# Disable the generation of stitch surfaces\ncmds.performanceOptions( ds=1 )\n\n# Put sculpt deformers into pass-through mode during interaction/playback\ncmds.performanceOptions( ps='interactive' )",
 'pfxstrokes': "import maya.cmds as cmds\n\ncmds.pfxstrokes( fn='/tmp/output_file' )",
 'pickWalk': "import maya.cmds as cmds\n\n# Given the transforms A and B which are parented to a transform C,\n# and C is instanced with parents D and E.\n\ncmds.pickWalk( 'A', direction='right' )\n\ncmds.select('|E|C')\ncmds.pickWalk( type='instances', direction='left')\n\n# The pickWalk command also works on CVs and edit points\ncmds.select('nurbsPlaneShape1.cv[2][1]')\ncmds.pickWalk(direction='right' )\n# Result: nurbsPlaneShape1.cv[3][1] #\n\ncmds.pickWalk( direction='up' )\n# Result: nurbsPlaneShape1.cv[3][2] #\n\ncmds.select( 'curveShape2.ep[1]' )\ncmds.pickWalk( direction='left' )\n# Result: curveShape2.ep[0] #",
 'picture': "import maya.cmds as cmds\n\nwindow = cmds.window()\ncmds.columnLayout()\ncmds.picture( image='sphere.png' )\ncmds.showWindow( window )",
 'pixelMove': 'import maya.cmds as cmds\n\n# move selected objects to the right (in current view) by one "pixel"\ncmds.pixelMove( 1, 0 )\n\n# move selected objects up by one "pixel"\ncmds.pixelMove( 0, 1 )',
 'planarSrf': 'import maya.cmds as cmds\n\n# create linear planar trimmed surface given boundary curve(s)\ncmds.planarSrf( d=1 )\n\n# use boundary curve(s) to create a hole by\n# keeping the outside trimmed regions\ncmds.planarSrf( ko=True)',
 'plane': "import maya.cmds as cmds\n\n# Creates a plane of size (10x10) with center at (1,1,1)\ncmds.plane( p=(1, 1, 1), s=10 )\n\n# Creates a plane of size (10x10) with center at (1,1,1) using various units\ncmds.plane( p=('1ft', '1ft', '1ft'), s='10in', r=('30deg', '30deg', '45deg') )",
 'play': 'import maya.cmds as cmds\n\n# Begin playback from min to max\n#\ncmds.play( forward=True )\n\n# Begin playback from max to min\n#\ncmds.play( forward=False )\n\n# Stop (forward or backward) playback\n#\ncmds.play( state=False )\n\n# Record mode through one playback loop\n#\ncmds.play( record=True )\n\n# Are we playing back?  Returns 1 if yes, 0 if no.\n#\ncmds.play( q=True, state=True )',
 'playbackOptions': "import maya.cmds as cmds\n\ncmds.playbackOptions( loop='continuous' )\ncmds.playbackOptions( minTime='0sec', maxTime='1sec' )\ncmds.playbackOptions( selectionStartTime='0sec', selectionEndTime='1sec' )\ncmds.playbackOptions( selectionVisible=False )\n\n# Playback every 2nd frame\n#\ncmds.playbackOptions( by=2 )",
 'playblast': 'import maya.cmds as cmds\n\n# Run movieplayer on the currently playblasted range\n# (including sound) and save the movie to a file.\n#\ncmds.playblast( s="ohNo", f="myMovie.mv" )\n\n# Run movieplayer on the currently playblasted range\n# (at 60% of the size of the current view), and\n# save the movie to file "myMovie.mv" and don\'t\n# launch any viewing program.\n#\ncmds.playblast( p=60, s="ohNo", f="myMovie.mv", v=False )\n\n# Output frames 2, 3, 8 as images and launch the viewer;\n#\ncmds.playblast( frame=[8,3,2], format="image", viewer=True )\n\n# Output an image sequence in \'gif\' format\n#\ncmds.playblast( format="image", compression="gif" )\n\n# Output depth with image in \'iff\' format\n#\ncmds.playblast( format="image", compression="maya", saveDepth=True )',
 'pluginDisplayFilter': "import maya.cmds as cmds\n\n#    Register a plugin display filter.\n#\ncmds.pluginDisplayFilter('myDisplayFilter', register = 1, label = 'My Display Filter', classification = 'drawdb/geometry/myShape')\n\n#    Deregister a plugin display filter.\n#\ncmds.pluginDisplayFilter('myDisplayFilter', deregister = 1)\n\n#    List all plugin display filters.\n#\nfilters = cmds.pluginDisplayFilter(q = 1, listFilters = 1)\n\n#    Query the label of a display filter\n#\nlabel = cmds.pluginDisplayFilter('myDisplayFilter', q = 1, label = 1)",
 'pluginInfo': 'import maya.cmds as cmds\n\n# List the plug-ins that are currently loaded\ncmds.pluginInfo( query=True, listPlugins=True )\n\n# Find the vendor of a plug-in\ncmds.pluginInfo( \'newNode.py\', query=True, vendor=True )\n\n# Find the commands provided by a given plug-in\ncmds.pluginInfo( \'helloCmd.py\', query=True, command=True )\n\n# Turn on autoloading for a plug-in\ncmds.pluginInfo( \'newNode.py\', edit=True, autoload=True )\n\n# Make maya write requires command in the saved file for a plug-in\ncmds.pluginInfo( \'pluginName\', edit=True, writeRequires=True )\n\n# Return all custom locators registered by plug-ins.\ncmds.pluginInfo( query=True, dependNodeByType="kLocatorNode" )',
 'pointConstraint': 'import maya.cmds as cmds\n\n# Position cube1 at the location of cone1.\ncmds.pointConstraint( \'cone1\', \'cube1\' )\n\n# Uses the average of the position of cone1 and surf2.\ncmds.pointConstraint( \'cone1\', \'surf2\', \'cube2\', w=.1 )\n\n# Sets the weight for cone1\'s effect on cube2 to 10.\ncmds.pointConstraint( \'cone1\', \'cube2\', e=True, w=10.0 )\n\n# Removes surf2 from cube2\'s pointConstraint\ncmds.pointConstraint( \'surf2\', \'cube2\', e=True, rm=True )\n\n# Adds surf3 to cube2\'s pointConstraint with the default weight\ncmds.pointConstraint( \'surf3\', \'cube2\' )\n\n# Constrain the y &amp; z translation of sph2 to sph1\ncmds.pointConstraint( \'sph1\', \'sph2\', skip="x" )',
 'pointCurveConstraint': "import maya.cmds as cmds\n\n# Apply a constraint to manipulate the  position corresponding to\n# the 1st edit point on curve1.\ncmds.pointCurveConstraint( 'curve1.ep[1]', ch=True )\n\n# Apply a constraint to manipulate the end point on curve1.\ncmds.pointCurveConstraint( 'curve1.un[1.0]', ch=True, w=1.0 )\n\n# Apply a constraint around the midpoint in the parameter domain on curve1.\ncmds.pointCurveConstraint( 'curve1.un[0.5]', ch=True, w=-1.0 )",
 'pointLight': 'import maya.cmds as cmds\n\ncmds.pointLight()',
 'pointOnCurve': 'import maya.cmds as cmds\n\ncmds.pointOnCurve( \'curve1\', pr=0.5, p=True )\n# Returns the (x,y,z) position of curve1 at parameter 0.5.\n\ncmds.pointOnCurve( \'curve1\', pr=0.5 )\n# Returns the (x,y,z) position of curve1 at parameter 0.5, since\n# position is the default information.\n\ncmds.pointOnCurve( \'curve1\', pr=0.5, nn=True )\n# Returns the (x,y,z) normalized normal of curve1 at parameter 0.5.\n\ncmds.pointOnCurve( \'curve1\', pr=0.5, cr=True )\n# Returns the curvature radius of curve1 at parameter 0.5.\n\ninfoNode = cmds.pointOnCurve(\'curve1\', ch=True, pr=0.55)\ncmds.getAttr(infoNode + ".position")  # returns the position\ncmds.getAttr(infoNode + ".normal")    # returns the normal\n\n# Returns a string which is the name of a new pointOnCurveInfo\n# dependency node.  With this node connected to the curve,\n# the output values of the pointOnCurveInfo node are always current\n# even if, for example, the parameter is being animated.',
 'pointOnPolyConstraint': 'import maya.cmds as cmds\n\n# Position cube1 at the location of cone1.\ncmds.pointOnPolyConstraint( \'cone1\', \'cube1\' )\n\n# Uses the average of the position of cone1 and surf2.\ncmds.pointOnPolyConstraint( \'cone1\', \'surf2\', \'cube2\', w=.1 )\n\n# Sets the weight for cone1\'s effect on cube2 to 10.\ncmds.pointOnPolyConstraint( \'cone1\', \'cube2\', e=True, w=10.0 )\n\n# Removes surf2 from cube2\'s pointOnPolyConstraint\ncmds.pointOnPolyConstraint( \'surf2\', \'cube2\', e=True, rm=True )\n\n# Adds surf3 to cube2\'s pointOnPolyConstraint with the default weight\ncmds.pointOnPolyConstraint( \'surf3\', \'cube2\' )\n\n# Constrain the y &amp; z translation of sph2 to sph1\ncmds.pointOnPolyConstraint( \'sph1\', \'sph2\', skip="x" )',
 'pointOnSurface': 'import maya.cmds as cmds\n\ncmds.pointOnSurface( \'surface1\', u=0.5, v=1.0, position=True )\n# Returns the (x,y,z) position of the surface at parameter (u=0.5,v=1.0).\n\ninfoNode = cmds.pointOnSurface(\'surface1\', ch= True, u=0.55, v=0.33)\ncmds.getAttr(infoNode + ".position" )  # returns the position\n# The pointOnSurface command returns  a string which is the name of\n# a new pointOnSurfaceInfo dependency node.  With this node connected\n# to the surface, the output values of the pointOnSurfaceInfo node\n# are always current even if, for example, the surface parameters are\n# being animated.',
 'pointPosition': "import maya.cmds as cmds\n\ncmds.pointPosition( 'curve1.cv[3]' )\n# Returns the (x,y,z) world position of curve1's 3rd CV.\n\ncmds.pointPosition( 'particle1.pt[1]', l=True )\n# Returns the (x,y,z) local position of the particle point.",
 'poleVectorConstraint': "import maya.cmds as cmds\n\n# aims the pole vector of handle1 at cone1.\ncmds.poleVectorConstraint( 'cone1', 'handle1' )\n\n# uses the average of the position of cone1 and surf2.\ncmds.poleVectorConstraint( 'cone1', 'surf2', 'handle2', w=.1 )\n\n# sets the weight for cone1's effect on handle2's poleVector to 10.\ncmds.poleVectorConstraint( 'cone1', 'handle2', e=True, w=10. )\n\n# removes surf2 from handle2's poleVectorConstraint.\ncmds.poleVectorConstraint( 'surf2', 'handle2', e=True, rm=True )\n\n# adds surf3 to handle2's poleVectorConstraint with the default weight.\ncmds.poleVectorConstraint( 'surf3', 'handle2' )",
 'polyAppend': 'import maya.cmds as cmds\n\ncmds.polyCreateFacet( p=[(0, 0, 0), (10, 0, 0), (10, 10, 0), (0, 10, 0)] )\n\n#add a new triangular facet described by the edge #0, and a free point\ncmds.polyAppend( a=[0, (5, -5, 0)] )\n\n#add a new quadrangular facet with 2 triangular holes.\ncmds.polyAppend( a=[1, (20, 0, 0), (20, 10, 0), (), (12, 6, 0), (14, 5, 0), (12, 4, 0), (), (16, 5, 0), (18, 6, 0), (18, 4, 0)] )',
 'polyAppendFacetCtx': "import maya.cmds as cmds\n\n# Create a poly plane\ncmds.polyPlane(w=10, h=10, sx=10, sy=10, n='pPlane1')\n\n# Create a new poly append facet context, set it to add four vertices per new edge, and then switch to it\ncmds.polyAppendFacetCtx('polyAppendFacetCtx1', s=4)\ncmds.setToolTo('polyAppendFacetCtx1')",
 'polyAppendVertex': 'import maya.cmds as cmds\n\ncmds.polyPlane( sx=3, sy=3 )\n\n# add a new face\ncmds.polyAppendVertex( a=[6, 10, (.167, .3, -.167), (.167, .3, .167)] )\n\n# add a new holed face\ncmds.polyAppendVertex( a=[9, 5, (-.167, .3, .167), (-.167, .3, -.167), (), (-.167, .2, .1), (-.167, .1, 0), (-.167, .2, -.1)] )\n\n# connect the two new faces\ncmds.polyAppendVertex( a=[18, 17, 16, 19] )\n\n# add a new unconnected quad\ncmds.polyAppendVertex( a=[(-.5, .5, -.5), (.5, .5, -.5), (.5, .5, .5), (-.5, .5, .5)] )',
 'polyAutoProjection': "import maya.cmds as cmds\n\n# Create a plane with default UVs.\ncmds.polySphere( n='sph' )\n\n# Automatic projections with 6 planes.\ncmds.polyAutoProjection( 'sphShape.f[*]' )",
 'polyAverageNormal': 'import maya.cmds as cmds\n\n# To average normals when they are within 0.2 distance.\ncmds.polyAverageNormal( distance=0.2 )\n\n# To average normals when they are within 0.2 distance.\n# Normalize the normals before computing the average.\ncmds.polyAverageNormal( distance=0.2, prenormalize=True )\n\n# To averge normals when they are within 0.2 distance. Do not\n# normalize the normals before computing the average (so to get weighted\n# average). But do normalize the resulting normal.\ncmds.polyAverageNormal( distance=0.2, postnormalize=True )\n\n# To average normals when they are within 0.2 distance. Do not\n# allow zero normal and replace zero normal with (1 0 0).\ncmds.polyAverageNormal( distance=0.2, allowZeroNormal=False, replaceNormalXYZ=(1,0,0) )',
 'polyAverageVertex': "import maya.cmds as cmds\n\n# Create a cube with a 5x5x5 subdivision.\ncmds.polyCube( sx=5, sy=5, sz=5, n='plg' )\n\n# Average all the vertices\ncmds.polyAverageVertex( 'plg.vtx[*]' )",
 'polyAxis': 'import maya.cmds as cmds\n\n# Create a coordinate system shape with 16 subdivisions for the cylinders of the axis,\n# rounded end shapes, an overall scale of 2 and an x-asxis of length 1.5\ncmds.polyAxis(sa=16, arw=2, sca=2.0, lx=1.5)\n\n\n# Create a wedge shaped coordinate system named myFrame with an overall scale of 0.5\ncmds.polyAxis(ftp=1, sca=0.5, n=\'myFrame\')\n\n# Query the scale of "myFrame"\ns = cmds.polyAxis(\'myFrame\', q=True, sca=True)\n\n# Create a coordinate system shape with material assigned\ncmd.polyAxis(n=\'myColoredFrame\', mt=\'polyAxis_materialTemplate\')',
 'polyBevel': "import maya.cmds as cmds\n\n# Replace an edge by 1 face, the width of the new face is given by the offset value.\ncmds.polyCube( n='plg' )\ncmds.polyBevel( 'plg.e[7]', offset=0.2 )\ncmds.delete( 'plg' )\n\n# Replace an edge by 4 faces, the new faces are rounding a smooth angle.\ncmds.polyCube( n='plg' )\ncmds.polyBevel( 'plg.e[7]', segments=4, offset=0.4 )\ncmds.delete( 'plg' )\n\n# Replace an edge by 4 faces, the new faces are rounding an angle specified by the default value of roundness (i.e 0.5).\ncmds.polyCube( n='plg' )\ncmds.polyBevel( 'plg.e[7]', segments=4, autoFit=Flase )\ncmds.delete( 'plg' )",
 'polyBevel3': "import maya.cmds as cmds\n\n# Replace an edge by 1 face, the width of the new face is given by the offset value.\ncmds.polyCube( n='plg' )\ncmds.polyBevel3( 'plg.e[7]', offset=0.2 )\ncmds.delete( 'plg' )\n\n# Replace an edge by 4 faces, the new faces are rounding a smooth angle.\ncmds.polyCube( n='plg' )\ncmds.polyBevel3( 'plg.e[7]', segments=4, offset=0.4 )\ncmds.delete( 'plg' )\n\n# Replace an edge by 4 faces, the new faces are rounding an angle specified by the default value of roundness (i.e 0.5).\ncmds.polyCube( n='plg' )\ncmds.polyBevel3( 'plg.e[7]', segments=4, autoFit=Flase )\ncmds.delete( 'plg' )",
 'polyBlendColor': "import maya.cmds as cmds\n\n# This example creates two poly color sets for pPlane1.\n# Apply red and green to the vertices of pPlane1 using two separate color sets, then blend their colors to the second color set\n# After that, delete the first color set\n\n# Create a poly plane pPlane1\ncmds.polyPlane(w=10, h=10, sx=10, sy=10, n='pPlane1')\n\n# Create colorSet1, set to use RGBA channels\ncmds.polyColorSet(create=True, clamped=0, rpt='RGBA', colorSet='colorSet1')\n# Apply red color to the vertices of pPlane1\ncmds.polyColorPerVertex(r=1, g=0, b=0, a=1, cdo=True)\n\n# Create colorSet2, set to use RGBA channels\ncmds.polyColorSet(create=True, clamped=0, rpt='RGBA', colorSet='colorSet2')\n# Apply green color to the vertices of pPlane1\ncmds.polyColorPerVertex(r=0, g=1, b=0, a=1, cdo=True)\n\n# Blend the two color sets to colorSet2, set to use ColorChannel blend style, set all the blend weights to 0.5\ncmds.polyBlendColor(bcn='colorSet1', src='colorSet2', dst='colorSet2', bfn=6, bwa=0.5, bwb=0.5, bwc=0.5, bwd=0.5)\n# Delete colorSet1\ncmds.polyColorSet(delete=True, colorSet='colorSet1')",
 'polyBlindData': "import maya.cmds as cmds\n\ncmds.polyBlindData( 'pPlane1.vtx[2]', 'pPlane1.vtx[8]', id=9001, associationType='vertex', ldn='bdFloat', dbd=234 )",
 'polyBoolOp': "import maya.cmds as cmds\n\n# Union\ncmds.polyCube( n='Cube1', w=1, h=10, d=1 )\ncmds.polyCube( n='cub1', w=3, h=3, d=3 )\ncmds.polyBoolOp( 'cub1', 'Cube1', op=1, n='result1' )\n\n# Difference\ncmds.polyCube( n='Cube2', w=1, h=10, d=1 )\ncmds.polyCube( n='cub2', w=3, h=3, d=3 )\ncmds.polyBoolOp( 'cub2', 'Cube2', op=2, n='result2' )\ncmds.move( 5, 0, 0, 'result2' )\n\n# Intersection\ncmds.polyCube( n='Cube3', w=1, h=10, d=1 )\ncmds.polyCube( n='cub3', w=3, h=3, d=3 )\ncmds.polyBoolOp( 'cub3', 'Cube3', op=3, n='result3' )\ncmds.move( 10, 0, 0, 'result3' )",
 'polyBridgeEdge': "import maya.cmds as cmds\n\ncmds.file( f=True, new=True )\ncmds.polyCube( sx=3, sy=3, sz=3 )\ncmds.delete( 'pCube1.f[9:17]' )\ncmds.move( -2, 0, 0, r=True )\ncmds.rotate( 0, 0, -90, r=True, os=True )\ncmds.polyCube( sx=3, sy=3, sz=3 )\ncmds.delete( 'pCube2.f[9:17]' )\ncmds.move( 2, 0, 0, r=True )\ncmds.rotate( 0, 0, 90, r=True, os=True )\ncmds.polyUnite( 'pCube1', 'pCube2', ch=1 )\n\n# Now bridge the two sets of border edges\ncmds.polyBridgeEdge( 'polySurface1.e[9:14]', 'polySurface1.e[42:47]', 'polySurface1.e[105:110]', 'polySurface1.e[138:143]', sv1=12, sv2=67, divisions=10 )",
 'polyCBoolOp': "import maya.cmds as cmds\n\n# Union\ncmds.polyCube( n='Cube1', w=1, h=10, d=1 )\ncmds.polyCube( n='cub1', w=3, h=3, d=3 )\ncmds.polyCBoolOp( 'cub1', 'Cube1', op=1, n='result1' )\n\n# Difference\ncmds.polyCube( n='Cube2', w=1, h=10, d=1 )\ncmds.polyCube( n='cub2', w=3, h=3, d=3 )\ncmds.polyCBoolOp( 'cub2', 'Cube2', op=2, n='result2' )\ncmds.move( 5, 0, 0, 'result2' )\n\n# Intersection\ncmds.polyCube( n='Cube3', w=1, h=10, d=1 )\ncmds.polyCube( n='cub3', w=3, h=3, d=3 )\ncmds.polyCBoolOp( 'cub3', 'Cube3', op=3, n='result3' )\ncmds.move( 10, 0, 0, 'result3' )",
 'polyCacheMonitor': "import maya.cmds as cmds\n\n# increment cache counter on polyExtrudeFace1 node\ncmds.polyCacheMonitor( nodeName='polyExtrudeFace1' )\n\n# update/edit manipulate nodes which are present downstream\n# with respect to polyExtrudeFace1\n\n# decrement cache counter on polyExtrudeFace1 node\n# so that the cache is set free\ncmds.polyCacheMonitor( nodeName='polyExtrudeFace1', cacheValue=False )",
 'polyCanBridgeEdge': 'import maya.cmds as cmds\n\ncmds.polyCanBridgeEdge()',
 'polyCheck': 'import maya.cmds as cmds\n\ncmds.polyPlane()\ncmds.polyCheck()\ncmds.polyCheck( f=True )',
 'polyChipOff': "import maya.cmds as cmds\n\n# Duplicate\ncmds.polyPlane( n='plg', w=10, h=10 )\ncmds.polyChipOff( 'plg.f[71:72]', 'plg.f[81:82]', dup=True, ltz=1 )\n#facets are duplicated and translated in local space\n\n# Extract\ncmds.polyChipOff( 'plg.f[11:12]', 'plg.f[21:22]', dup=False, ty=1 )\n#facets are extracted and translated in world space\n\n# Separate\ncmds.polyChipOff( 'plg.f[15:16]', 'plg.f[23:24]', dup=False, kft=False, ls=(.5, .5, 0) )\n#facets are extracted then scaled separately\n\n# Together\ncmds.polyChipOff( 'plg.f[73:74]', 'plg.f[83:84]', dup=False, kft=True, ls=(.5, .5, 0) )\n#facets are extracted then scaled together",
 'polyCircularize': "import maya.cmds as cmds\n\ncmds.polyCube( name='poly1' )\ncmds.polyCircularize( 'poly1' )",
 'polyCircularizeEdge': "import maya.cmds as cmds\n\ncmds.polyCube( name='poly1' )\ncmds.polyCircularizeEdge( 'poly1' )",
 'polyCircularizeFace': "import maya.cmds as cmds\n\ncmds.polyCube( name='poly1' )\ncmds.polyCircularizeFace( 'poly1' )",
 'polyClean': 'import maya.cmds as cmds\n\nimport maya.cmds as cmds\n\ncmds.polyCube()\ncmds.polyClean()',
 'polyClipboard': 'import maya.cmds as cmds\n\n# Copy uv, color and shader attributes\ncmds.polyClipboard( copy=True, uv=True, color=True, shader=True )\n\n# Paste only shader attribute\ncmds.polyClipboard( paste=True, shader=True )\n\n# Copy color attribute only\ncmds.polyClipboard( copy=True, color=True )\n\n# Clear all the clipboard attributes\ncmds.polyClipboard( clear=True, uv=True, color=True, shader=True )',
 'polyCloseBorder': "import maya.cmds as cmds\n\n# Creation of a plane.\ncmds.polyPlane( n='plg', sx=10, sy=10, h=20, w=20 )\n\n# Display the poly Borders\ncmds.polyOptions( db=True )\n\n# Delete some facets of the plane.\ncmds.delete( 'plg.f[33:36]', 'plg.f[43:46]', 'plg.f[53:56]', 'plg.f[63:66]' )\n\n# Close the border on one of the edges of the hole\n# Note that only one edge for each hole needs to be given\ncmds.select( 'plg.e[89]', r=True )\ncmds.polyCloseBorder()\n# There is now a face where the hole was\n\n#Reset display\ncmds.polyOptions( db=False )",
 'polyCollapseEdge': "import maya.cmds as cmds\n\n# Create a plane.\ncmds.polyPlane( n='plg', sx=10, sy=10, h=20, w=20 )\n\n# Collapse one edge,\ncmds.polyCollapseEdge( 'plg.e[200]' )\n\n# Or multiple edges:\ncmds.select( 'plg.e[74]', 'plg.e[92]', 'plg.e[94:95]' )\n# Command works on selection list if\n# no command line arguments are given.\ncmds.polyCollapseEdge()\n\n# Note that the command works on one edge at a time, so the\n# resulting vertex from a selection of multiple edges will\n# not typically be in the center of the selection.",
 'polyCollapseFacet': "import maya.cmds as cmds\n\n# Create a plane.\ncmds.polyPlane( n='plg', sx=10, sy=10, h=20, w=20 )\n\n# You can collapse a facet,\ncmds.polyCollapseFacet( 'plg.f[54]' )\n\n# Or several ones.\ncmds.polyCollapseFacet( 'plg.f[33:35]', 'plg.f[43:45]', 'plg.f[53:55]' )",
 'polyCollapseTweaks': "import maya.cmds as cmds\n\n# Create a plane.\ncmds.polyPlane( sx=10, sy=10, h=20, w=20, ch=0 )\n\n# Query the existence of vertex tweaks for pPlane1\ncmds.polyCollapseTweaks ( 'pPlane1', q=True, hvt=True )\n# Result: 0\n\n# Move a vertex,\ncmds.select( 'pPlane1.vtx[8]', r=True )\ncmds.move( 10, 20, 30, r=True )\n\n# Query vertex tweaks for vertex id 8\ncmds.getAttr( 'pPlane1.vtx[8]' );\n# Result: [(10.0, 20.0, 30.0)]\n\n# Query the existence of vertex tweaks for pPlane1\ncmds.polyCollapseTweaks ( 'pPlane1', q=True, hvt=True )\n# Result: 1\n\n# Bake all vertex tweaks into their respective vertices.\ncmds.polyCollapseTweaks( 'pPlane1' )\n\n# Query vertex tweaks for vertex id 8\ncmds.getAttr( 'pPlane1.vtx[8]' );\n# Result: [(0.0, 0.0, 0.0)]\n\n# Query the existence of vertex tweaks for pPlane1\ncmds.polyCollapseTweaks ( 'pPlane1', q=True, hvt=True )\n# Result: 0",
 'polyColorBlindData': 'import maya.cmds as cmds\n\n# In these examples we have type 1000, with one double attribute\n# called "fluffy", and type 1001 with attributes "grimy" and "slimy".\n\n# Color all items of id 1000 red. Note that we must also specify\n# None color (black) and Clash color(cyan). Note that we must also\n# specify the names of the attributes, even if we don\'t care about\n# the attribute values:\ncmds.polyColorBlindData( ncr=0, ncg=0, ncb=0, ccr=0, ccg=1, ccb=1, id=1000, num=1, m=0, n=\'fluffy\', cr=1, cg=0, cb=0 )\n\n# Now color only those values of "fluffy" between 2 and 5:\ncmds.polyColorBlindData( ncr=0, ncg=0, ncb=0, ccr=0, ccg=1, ccb=1, id=1000, num=1, m=2, dt=\'double\', n=\'fluffy\', umn=1, mnv=2, umx=1, mxv=5, cr=1, cg=0, cb=0 )\n\n# Note for a continuous range query we must specify min, max and\n# out of range color instead of just color (here values between 2 and 5\n# are colored between white and gray, out of range values are yellow):\ncmds.polyColorBlindData( ncr=0, ncg=0, ncb=0, ccr=0, ccg=1, ccb=1, id=1000, num=1, m=6, dt=\'double\', n=\'fluffy\', bmr=1, bmg=1, bmb=0, amr=1, amg=1, amb=0, mnr=0.250980407, mng=0.250980407, mnb=0.250980407, mxr=1, mxg=1, mxb=1, mnv=2, mxv=5 )\n\n# Now, for attribute "fluffy", color values of 2 red and values of 2 green:\ncmds.polyColorBlindData( ncr=0, ncg=0, ncb=0, ccr=0, ccg=1, ccb=1, id=1000, num=1, m=1, dt=\'double\', n=\'fluffy\', v=\'2\', cr=1, cg=0, cb=0, id=1000, num=1, m=1, dt=\'double\', n=\'fluffy\', v=\'3\', cr=0, cg=1, cb=0 )\n\n# To just query and not color, filter the active selection list\n# and return the list of components that meet the criteria (in this\n# case having blind data of type 1000)\ncmds.polyColorBlindData( 1000, \'-num\', 1, \'-m\', 0, \'-n\', \'fluffy\', query=True, id=True )\n\n# Now if we have 2 attributes:\ncmds.polyColorBlindData( ncr=0, ncg=0, ncb=0, ccr=0, ccg=1, ccb=1, id=1001, num=2, m=0, n=\'grimy\', n=\'slimy\', cr=1, cg=0, cb=0 )\n\n# Note that when querying for value, values of all attrs must be specified\n# here we set (grimy = 22, slimy = 1) to be red, and (grimy = 55, slimy = 2)\n# to be green\n\ncmds.polyColorBlindData( ncr=0, ncg=0, ncb=0, ccr=0, ccg=1, ccb=1, id=1001, num=2, m=1, dt=\'double\', n=\'grimy\', v=\'22\', cr=1, cg=0, cb=0, dt=\'int\', n=\'slimy\', v=\'1\', cr=1, cg=0, cb=0, id=1001, num=2, m=1, dt=\'double\', n=\'grimy\', v=\'55\', cr=0, cg=1, cb=0, dt=\'int\', n=\'slimy\', v=\'2\', cr=0, cg=1, cb=0 )',
 'polyColorDel': "import maya.cmds as cmds\n\n# Create a plane.\ncmds.polyPlane( n='plg', sx=5, sy=5, w=20, h=20 )\npolyColorPerVertex -r 0 -g 0 -b 1 -a 1 -cdo;\n\n# Delete the color from the given faces.\ncmds.polyColorDel( 'plg.f[11:13]', 'plg.f[16:18]' )",
 'polyColorMod': "import maya.cmds as cmds\n\n# Create a poly plane pPlane1\ncmds.polyPlane(w=10, h=10, sx=10, sy=10, n='pPlane1')\n\n# Create colorSet1 , set to use RGBA channel\ncmds.polyColorSet(create=True, clamped=0, rpt='RGBA', colorSet='colorSet1')\n# Apply red color to the vertices of pPlane1\ncmds.polyColorPerVertex(r=1, g=0, b=0, a=1, cdo=True)\n\n# Modified the color of colorSet1 to green\ncmds.polyColorMod('pPlane1',huev=120, bcn='colorSet1')",
 'polyColorPerVertex': 'import maya.cmds as cmds\n\n# To set the rgb channels of selected vertices:\ncmds.polyColorPerVertex( rgb=(0.8, 0.0, 0.4) )\n\n# To set just the "g" channel of selected vertices:\ncmds.polyColorPerVertex( g =0.5 )\n\n# To add to the current value of just the "g" channel of selected vertices:\ncmds.polyColorPerVertex( rel=True, g =0.2 )\n\n# To query the "g" and "b" channels of color on selected vertices:\ncmds.polyColorPerVertex( query=True, g=True, b=True )',
 'polyColorSet': 'import maya.cmds as cmds\n\n\n# To set the current color set to be "color2".\ncmds.polyColorSet(currentColorSet=True, colorSet= \'color2\' )\n\n# To query the current color set.\ncmds.polyColorSet( query=True, currentColorSet=True )\n\n# To create a per-instance color set family with one set member\n# per selected instance.\ncmds.polyColorSet(create=True,colorSet=\'perInst\',perInstance=True,unshared=True)\n\n# To create a per-instance color set family with one set member\n# for all selected instances.\ncmds.polyColorSet(create=True,colorSet=\'perInst\',perInstance=True)\n\n# To rename a currently existing color set from "color3" to "color4".\ncmds.polyColorSet( rename=True, colorSet= \'color3\', newColorSet= \'color4\' )\n\n# Rename the current color set (if any) to "color3".\ncmds.polyColorSet( rename=True, newColorSet= \'color3\')\n\n# To delete a currently existing color set "color3".\ncmds.polyColorSet( delete= True, colorSet= \'color3\')\n\n# To delete the current color set (if any)\ncmds.polyColorSet( delete=True )\n\n# Copy values of color set "color1" to "color2"\n# Note if the second color set exist it will be overwriten by\n# the copy. Leaving the destination color blank and the command\n# will generate a new unique name based on the source name.\ncmds.polyColorSet( copy= True, colorSet=\'color1\', newColorSet =\'color2\')\n\n# Copy values of the current color set to "color2"\ncmds.polyColorSet( copy= True, newColorSet=\'color2\')\n\n# Make a copy of "color1" to a new color set. The\n# name of which is automatically generated and returned.\ncmds.polyColorSet( copy= True, colorSet=\'color1\' )\n\n# Create a new empty color set\ncmds.polyColorSet( create=True, colorSet=\'newColor\')\n\n# To query all of the color sets\ncmds.polyColorSet( query=True, allColorSets=True )\n\n# To query all of the color set names and their representation values\ncmds.polyColorSet( query=True, allColorSets=True, representation=True )\n\n# To query the clamped value of the current color set\ncmds.polyColorSet( query=True, currentColorSet=True, clamped=True )',
 'polyColorSetCmdWrapper': '',
 'polyCompare': "import maya.cmds as cmds\n\ncmds.polySphere()\ncmds.polySphere()\ncmds.select( cl=True )\ncmds.select( 'pSphere1', 'pSphere2', r=True )\ncmds.polyCompare()",
 'polyCone': 'import maya.cmds as cmds\n\n# Create a cone, with 10 subdivisions in the X direction,\n# 15 subdivisions in the Y direction and 20 subdivisions in the Z direction,\n# the radius of the cone is 20, the height of the cone is 10.\ncmds.polyCone( sx=10, sy=15, sz=5, r=20, h=10)\n\n# Create a cone, called "myCone", on each direction there are 5 subdivisions.\ncmds.polyCone( n=\'myCone\', sx=5, sy=5, sz=5)\n\n# Query the radius of "myCone"\nr = cmds.polyCone( \'myCone\', q=True, r=True )',
 'polyConnectComponents': "import maya.cmds as cmds\n\n# make a sphere\ncmds.polySphere( r=1, sx=20, sy=20, ax=(0,1,0), cuv=2, ch=1, name='sph' )\n# split two faces by specifying 3 vertices\ncmds.polyConnectComponents( 'sph.vtx[254]', 'sph.vtx[256]', 'sph.vtx[275]', ch=1 )\n# split two faces by specifying 3 edges\ncmds.polyConnectComponents( 'sph.e[278]', 'sph.e[637:638]', ch=1 )\n# split three faces\ncmds.polyConnectComponents( 'sph.f[66]', 'sph.f[215:217]', ch=1 )\n# a complex split involving vertices, edges and faces, in a loop\ncmds.polyConnectComponents( 'sph.f[270:271]', 'sph.vtx[273]', 'sph.e[232]', 'sph.e[252]',  'sph.e[592]', 'sph.f[210]', 'sph.vtx[229]', 'sph.e[249]', 'sph.e[269]', ch=1 )",
 'polyContourProjection': "import maya.cmds as cmds\n\n# Create a plane.\ncmds.polyPlane( n='plane', sx=10, sy=10 )\n\n# Deform the plane and planar project UVs onto it.\ncmds.softMod( 'plane', falloffRadius=1 )\ncmds.move( 0, 0, -0.5, r=True, os=True, wd=True )\ncmds.select( 'plane', r=True )\ncmds.delete( 'plane', ch=True )\ncmds.polyProjection( 'plane.f[0:99]', ch=1, type='Planar', ibd=0, md='y' )\n\n# Create a lambert node.\ncmds.shadingNode( 'lambert', n='myLambert', asShader=True )\ncmds.sets( renderable=True, noSurfaceShader=True, empty=True, name='myLambertSG' )\ncmds.connectAttr( 'myLambert.outColor', 'myLambertSG.surfaceShader', f=True )\n\n# Create a texture checker.\ncmds.shadingNode( 'checker', asTexture=True )\ncmds.shadingNode( 'place2dTexture', asUtility=True )\ncmds.connectAttr( 'place2dTexture1.outUV', 'checker1.uv' )\ncmds.setAttr( 'place2dTexture1.repeatU', 4 )\ncmds.setAttr( 'place2dTexture1.repeatV', 4 )\n\n# Assign the texture the the lambert node.\ncmds.connectAttr( 'checker1.outColor', 'myLambert.color', f=True )\n\n# Set the textured display mode.\ncurrentPanel = cmds.getPanel(withFocus= True)\nif currentPanel != '':\n\tcmds.modelEditor(currentPanel, edit=True, da='smoothShaded', displayTextures=True, dl='default')\n\n# Assign the lambert shader to the plane.\ncmds.sets('plane', edit=True, forceElement= 'myLambertSG' )\n\n# Use the contour stretch projection to assign 'rectangular' UVs to a strip of faces\ncmds.polyContourProjection( 'plane.f[30:69]', ch=1, m=0 )",
 'polyCopyUV': "import maya.cmds as cmds\n\n# Create a poly sphere, with default UVset.\ncmds.polySphere()\n\n# Create a second UV set\ncmds.select( 'pSphere1.f[0:399]', r=True )\ncmds.polyProjection( type='Planar', ra=0, isu=1, isv=1, cm=True, uvSetName='newUVs' )\n\n# Copy the UVs of the fisrt 200 faces from the new set to the default one\ncmds.polyCopyUV( 'pSphere1.f[0:199]', uvi='newUVs', uvs='map1' )",
 'polyCrease': 'import maya.cmds as cmds\n\n# To set a crease value of 0.9 on the selected edges or vertices\ncmds.polyCrease( value=0.9 )',
 'polyCreaseCtx': "import maya.cmds as cmds\n\n# Create a poly plane\ncmds.polyPlane(w=10, h=10, sx=1, sy=1, n='pPlane1')\n\n# Create a new poly crease context, then switch to it\ncmds.polyCreaseCtx('polyCreaseCtx1')\ncmds.setToolTo('polyCreaseCtx1')",
 'polyCreateFacet': 'import maya.cmds as cmds\n\n# Create a triangular facet\ncmds.polyCreateFacet( p=[(0.0, 0.0, 0.0), (10.0, 0.0, 0.0), (10.0, 10.0, 0.0)] )\n\n# Create a quadrangular facet with two triangular holes inside\n# Note that, in Python, specifying an empty tuple in the point list marks the\n# beginning of a hole specification\ncmds.polyCreateFacet( p=[(0, 0, 0), (10, 0, 0), (10, 10, 0), (0, 10, 0), (), (4, 2, 0), (5, 4, 0), (6, 2, 0), (), (5, 6, 0), (4, 8, 0), (6, 8, 0)] )\ncmds.move( 0, 0, 10, r=True )',
 'polyCreateFacetCtx': "import maya.cmds as cmds\n\n# Create a new poly facet create context, set it to add four vertices per new edge, then switch to it\ncmds.polyCreateFacetCtx('polyCreateFacetCtx1', s=4)\ncmds.setToolTo('polyCreateFacetCtx1')",
 'polyCube': "import maya.cmds as cmds\n\ncmds.polyCube( sx=10, sy=15, sz=5, h=20 )\n#result is a 20 units height rectangular box\n#with 10 subdivisions along X, 15 along Y and 20 along Z.\n\ncmds.polyCube( sx=5, sy=5, sz=5 )\n#result has 5 subdivisions along all directions, default size\n\n# query the width of a cube\nw = cmds.polyCube( 'polyCube1', q=True, w=True )",
 'polyCut': "import maya.cmds as cmds\n\n# Introduce new edges at the middle of a cylinder\n#\ncmds.polyCylinder( r=1, h=2, sx=20, sy=1, sz=1, ax=(0, 1, 0), cuv=1, ch=1, name='pCylA' )\ncmds.polyCut( 'pCylA.f[0:59]', cd='Y', ch=1 )\n\n# Delete the bottom half of the cylinder\n#\ncmds.select( cl=True )\ncmds.polyCylinder( r=1, h=2, sx=20, sy=1, sz=1, ax=(0, 1, 0), cuv=1, ch=1, name='pCylB' )\ncmds.move( 3, 0, 0, r=True )\ncmds.polyCut( 'pCylB.f[0:59]', cd='Y', df=1, ch=1 )\ncmds.select( cl=True )\n\n\n# Split the bottom half of the cylinder\n#\ncmds.select( cl=True )\ncmds.polyCylinder( r=1, h=2, sx=20, sy=1, sz=1, ax=(0, 1, 0), cuv=1, ch=1, name='pCylC' )\ncmds.move( 6, 0, 0, r=True )\ncmds.polyCut( 'pCylC.f[0:59]', cd='Y', ef=1, ch=1 )\n\n# select one of the cylinders, and select the polyCut node from the\n# channel box, and enter the showManipulator Tool, on the Toolbar.\n# You can interactively place the cutting plane, and the result of\n# cut operation will adjust accordingly.",
 'polyCutCtx': "import maya.cmds as cmds\n\n# Create a poly plane\ncmds.polyPlane(w=10, h=10, sx=1, sy=1, n='pPlane1')\n\n# Create a new cut facets context, then switch to it\ncmds.polyCutCtx('polyCutCtx1')\ncmds.setToolTo('polyCutCtx1')",
 'polyCutUVCtx': "import maya.cmds as cmds\n\n# Create a new cut facets context, then switch to it\ncmds.polyCutUVCtx('polyCutUVCtx1')\ncmds.setToolTo('polyCutUVCtx1')",
 'polyCylinder': 'import maya.cmds as cmds\n\n# Create a rectangle, with 10 subdivisions in the X direction,\n# 15 subdivisions in the Y direction and 20 subdivisions in the Z direction,\n# the height of the cylinder is 20.\ncmds.polyCylinder( sx=10, sy=15, sz=5, h=20)\n\n# Create a cylinder, called "myCylinder", on each direction there are 5 subdivisions.\ncmds.polyCylinder(n=\'myCylinder\', sx=5, sy=5, sz=5)\n\n# Query the radius of "myCylinder"\nr = cmds.polyCylinder( \'myCylinder\', q=True, r=True )',
 'polyCylindricalProjection': "import maya.cmds as cmds\n\n# Create a sphere with default UVs.\ncmds.polySphere( n='sphere', r=10 )\n\n# Create a lambert node.\ncmds.shadingNode( 'lambert', n='myLambert', asShader=True )\ncmds.sets( renderable=True, noSurfaceShader=True, empty=True, name='myLambertSG' )\ncmds.connectAttr( 'myLambert.outColor', 'myLambertSG.surfaceShader', f=True )\n\n# Create a texture checker.\ncmds.shadingNode( 'checker', asTexture=True )\ncmds.shadingNode( 'place2dTexture', asUtility=True )\ncmds.connectAttr( 'place2dTexture1.outUV', 'checker1.uv' )\n\n# Assign the texture the the lambert node.\ncmds.connectAttr( 'checker1.outColor', 'myLambert.color', f=True )\n\n# Set the textured display mode.\ncurrentPanel = cmds.getPanel(withFocus= True)\nif currentPanel != '':\n\tcmds.modelEditor(currentPanel, edit=True, da='smoothShaded', displayTextures=True, dl='default')\n\n# Assign the lambert shader to all faces of the sphere.\ncmds.sets('sphere.f[0:399]', edit=True, forceElement= 'myLambertSG' )\n\n# Replace default UVs on the top of the sphere :\n# Rotates the map of 90 degrees, reduces its U aperture to 36 degrees, and its V scale to 0.1\ncmds.polyCylindricalProjection( 'sphere.f[180:359]', 'sphere.f[380:399]', ra=90.0, pc=(0, 0, 0), psu=36, isv=0.1 )\n\n# Set the wireframe display mode.\ncurrentPanel = cmds.getPanel(withFocus= True)\nif currentPanel != '':\n\tcmds.modelEditor(currentPanel, edit=True, da='wireframe')",
 'polyDelEdge': "import maya.cmds as cmds\n\n# Without cleanup\ncmds.polyPlane( n='plg1', w=10, h=10 )\ncmds.move( -6, 0, 0 )\ncmds.select( 'plg1.e[26]', 'plg1.e[28]', 'plg1.e[30]', 'plg1.e[32]', 'plg1.e[34]', 'plg1.e[36]', 'plg1.e[38]', 'plg1.e[47]', 'plg1.e[49]', 'plg1.e[51]', 'plg1.e[53]', 'plg1.e[55]', 'plg1.e[57]', 'plg1.e[59]' )\ncmds.polyDelEdge( cv=False )\n\n# With cleanup\ncmds.polyPlane( n='plg2', w=10, h=10 )\ncmds.move( 6, 0, 0 )\ncmds.select( 'plg2.e[26]', 'plg2.e[28]', 'plg2.e[30]', 'plg2.e[32]', 'plg2.e[34]', 'plg2.e[36]', 'plg2.e[38]', 'plg2.e[47]', 'plg2.e[49]', 'plg2.e[51]', 'plg2.e[53]', 'plg2.e[55]', 'plg2.e[57]', 'plg2.e[59]' )\ncmds.polyDelEdge( cv=True )\n\ncmds.select( 'plg1', 'plg2' )\ncmds.polyOptions( ao=True, dv=True )",
 'polyDelFacet': "import maya.cmds as cmds\n\ncmds.polySphere( n='plg', sx=10, sy=20, r=10 )\ncmds.polyDelFacet( 'plg.f[115]', 'plg.f[125]', 'plg.f[117]', 'plg.f[127]', 'plg.f[55:57]', 'plg.f[65]', 'plg.f[67]' )",
 'polyDelVertex': "import maya.cmds as cmds\n\ncmds.polyPlane( n='plg' )\ncmds.select( 'plg.vtx[59:61]' )\n# These vertices are not winged, so they can not be deleted\ncmds.polyDelVertex()\n\ncmds.select( 'plg.e[93]', 'plg.e[95]', 'plg.e[97]', 'plg.e[114]', 'plg.e[116]', 'plg.e[118]' )\ncmds.delete()\ncmds.select( 'plg.vtx[59:61]' )\n# Now they are winged, as they are only connected to two edges.\ncmds.polyDelVertex()\n\n# Corners are winged, so they can be deleted\ncmds.select( 'plg.vtx[0]', 'plg.vtx[10]', 'plg.vtx[107]', 'plg.vtx[117]' )\ncmds.polyDelVertex()\n\ncmds.select( 'plg' )\ncmds.polyOptions( ao=True, dv=True )",
 'polyDuplicateAndConnect': "import maya.cmds as cmds\n\ncmds.polyDuplicateAndConnect( 'pPlane1' )",
 'polyDuplicateEdge': "import maya.cmds as cmds\n\ncmds.polyTorus()\ncmds.polyDuplicateEdge( 'pTorus1.e[121:126]', of=0.5 )",
 'polyEditEdgeFlow': "import maya.cmds as cmds\n\n# Create a sphere.\ncmds.polySphere( n='plg', r=5 )\n\ncmds.select( 'plg.e[200:219]' )\n# Flow selected edges by default\ncmds.polyEditEdgeFlow()\n\n# Flow selected edge (convex, 20)\ncmds.polyEditEdgeFlow( 'plg.e[200:219]', adjustEdgeFlow = 20 )",
 'polyEditUV': 'import maya.cmds as cmds\n\n# To query the u and v values of selected uvs:\ncmds.polyEditUV( query=True )\n\n# To tweak the u and v values of selected uvs:\ncmds.polyEditUV( relative=True, uValue=0.05925926, vValue=0.05555556 )\n\n# To set absolute values for u and v values of selected uvs:\ncmds.polyEditUV( relative=False, uValue=0.556, vValue=0.56 )\n\n# To rotate selected uv points about a pivot:\ncmds.polyEditUV( pivotU=0.5, pivotV=0.5, angle=-15 )\n\n# To scale selected uv points about a pivot:\ncmds.polyEditUV( pivotU=0.5, pivotV=0.5, scaleU=-0.06, scaleV=-0.06 )',
 'polyEditUVShell': 'import maya.cmds as cmds\n\n# To query the u and v values of selected uvs:\ncmds.polyEditUVShell( query=True )\n\n# To tweak the u and v values of selected uvs:\ncmds.polyEditUVShell( relative=True, uValue=0.05925926, vValue=0.05555556 )\n\n# To rotate selected uv points about a pivot:\ncmds.polyEditUVShell( pivotU=0.5, pivotV=0.5, angle=-15 )',
 'polyEvaluate': 'import maya.cmds as cmds\n\ncmds.polyPlane( n=\'plg\', sx=4, sy=4, w=5, h=5 )\ncmds.select( \'plg.f[2]\', \'plg.f[4]\' )\n\n# query the number of faces\ncmds.polyEvaluate( f=True )\n# Result: 16\n\n# query the number of triangles\ncmds.polyEvaluate( t=True )\n# Result: 32\n\n# query the number of selected faces\ncmds.polyEvaluate( faceComponent=True )\n# Result: 2\n\n# query the number of vertices and faces\ncmds.polyEvaluate( v=True, f=True )\n# Result: {\'vertex\': 25, \'face\': 16}\n\n# formatted query of the number of vertices and faces\ncmds.polyEvaluate( v=True, f=True, fmt=True )\n# Result: "face=16 vertex=25"\n\n# query all\ncmds.polyEvaluate()\n# Result: {\'edge\': 40, \'edgeComponent\': 0, \'face\': 16, \'faceComponent\': 2, \'shell\': 1, \'triangle\': 32, \'triangleComponent\': 0, \'uvComponent\': 0, \'uvShell\': 1, \'uvcoord\': 25, \'vertex\': 25,\'vertexComponent\': 0}\n\n#formatted query of all information\ncmds.polyEvaluate( fmt=True )\n# Result: vertex=25 edge=40 face=16 uvcoord=25 triangle=32 shell=1 uvShell=1\n#    vertexComponent=0 edgeComponent=0 faceComponent=2 uvComponent=0\n#    triangleComponent=4 activeShells= 0 activeUVShells= 0 uvShellIds= 0 0\n#    faceArea= 1.5625 1.5625 worldFaceArea= 1.5625 1.5625 uvFaceArea= 0.0625 0.0625\n#    boundingBox= X[-2.50,2.50] Y[-0.00,0.00] Z[-2.50,2.50]\n#    boundingBoxComponent= X[-2.50,1.25] Y[-0.00,0.00] Z[0.00,2.50]\n#    boundingBox2d= U[0.00,1.00] V[0.00,1.00]\n#    boundingBoxComponent2d= U[0.00,0.75] V[0.00,0.50]\n#    area=25.00 worldArea=25.00 uvArea=1.00\n\n# accurate bounding box evaluation\ncmds.polyCylinder( r=1, h=2, sx=20, sy=1, sz=1, ax=(0, 1, 0), tx=1, ch=1 )\n# Result: pCylinder1 polyCylinder1 #\ncmds.rotate( 38.340875, 0, 0, r=True, os=True )\ncmds.rotate( 0, 0, -36.177835, r=True, os=True )\n\ncmds.polyEvaluate( b=True )\n# Result: ((-1.3974823703620598, 1.39748217791327), (-1.7164316223605844, -1.7164316223605844), (-1.6512467204212007, 1.6512465272260637)) #\ncmds.polyEvaluate( b=True, ae=True )\n# Result: ((-1.3974823951721191, 1.39748215675354), (-1.4071073532104492, -1.4071073532104492), (-1.3598332405090332, 1.3598330020904541)) #\n\n# Local and World Space Area\ncmds.polyCube( w=1, h=1, d=1, sx=1, sy=1, sz=1, ax=(0, 0, 1), cuv=1, ch=1 )\ncmds.setAttr( \'pCube1.scaleY\', 2 )\ncmds.polyEvaluate( a=True )\n# Result: 6\ncmds.polyEvaluate( wa=True )\n# Result: 10\n\n# UV Shell information\ncmds.polySphere( sx=20, sy=20 )\ncmds.polyAutoProjection()\ncmds.hilite()\ncmds.select( \'pSphere1.f[282]\', \'pSphere1.f[189:192]\', replace = True )\n\n# number of UV shells\ncmds.polyEvaluate( uvShell=True )\n# Result: 6\n\n# active UV Shells\ncmds.polyEvaluate( activeUVShells=True )\n# Result: [1, 4, 5]\n\n# UV shell IDs for selected faces\ncmds.polyEvaluate( uvShellIds=True )\n# Result: [1, 1, 1, 4, 5]\n\n# UV edge pairs for selected edges\ncmds.polyEvaluate( \'pSphere1.e[642]\', uvEdgePairs=True )\n# Result: [u\'pSphereShape1.map[67] pSphereShape1.map[74] pSphereShape1.map[307] pSphereShape1.map[300] \']',
 'polyExtrudeEdge': "import maya.cmds as cmds\n\n# Separate\ncmds.polyPlane( n='plg', w=10, h=10 )\ncmds.polyExtrudeEdge( 'plg.e[71:72]', 'plg.e[81:82]', kft=False,, ltz=2, ls=(.5, .5, 0) )\n# Edges are extruded then scaled separately\ncmds.delete( 'plg' )\n\n\n# Together\ncmds.polyPlane( n='plg', w=10, h=10 )\ncmds.polyExtrudeEdge( 'plg.e[71:72]', 'plg.e[81:82]', kft=True, ltz=2, ls=(.5, .5, 0) )\n# Edges are extruded then scaled together\ncmds.delete( 'plg' )",
 'polyExtrudeFacet': "import maya.cmds as cmds\n\n# Separate\ncmds.polyPlane( n='plg', w=10, h=10 )\ncmds.polyExtrudeFacet( 'plg.f[71:72]', 'plg.f[81:82]', kft=False, ltz=2, ls=(.5, .5, 0) )\n# Facets are extruded then scaled separately\n\n\n# Together\ncmds.polyExtrudeFacet( 'plg.f[17:18]', 'plg.f[27:28]', kft=True, ltz=2, ls=(.5, .5, 0) )\n# Facets are extruded then scaled together",
 'polyExtrudeVertex': 'import maya.cmds as cmds\n\ncmds.polyCube( h=10, w=10, d=10 )\ncmds.polyExtrudeVertex( l=2, w=3, d=4 )\n# A cube is created and then all of its vertices are extruded into 4 divisions with length 2 and width 3',
 'polyFlipEdge': 'import maya.cmds as cmds\n\n# To flip the selected edge\ncmds.polyFlipEdge()',
 'polyFlipUV': "import maya.cmds as cmds\n\n# Create a poly sphere with default UVs.\ncmds.polySphere( n='sph' )\n\n# Flip uvs on all faces of the sphere shape.\ncmds.polyFlipUV( 'sphShape.f[*]' )",
 'polyForceUV': "import maya.cmds as cmds\n\ncmds.polyForceUV( uni=True )\n# unitize the UV values of the selected faces separately\n\ncmds.polyForceUV( cp=True )\n# create UVs on the selected faces based on the current camera\n\ncmds.polyForceUV( 'pCylinder1.f[11:14]', 'pCylinder1.vtx[33:34]', 'pCylinder1.vtx[13:14]', ni=1 )\n# create the UVs for the first item (ie, 4 polygonal faces, in this case)\n# in the selection list, by computing the plane using the rest of the\n# items in the list",
 'polyGeoSampler': 'import maya.cmds as cmds\n\n# Example 1. Sample for color values.\n\n#    a. No arguments. Will perform sampling of color + transparency at\n#     the vertex level, and store color values for affected vertices.\n#     No shadows will be computed.\n\ncmds.polyGeoSampler()\n\n# b. With shadows and illumination only\n\ncmds.polyGeoSampler( lightingOnly=True, computeShadows=True )\n\n# c. Sampling only complete selected faces\n\ncmds.polyGeoSampler( sampleByFace=True )\n\n# d. "Flat shading".\n\n# Example 2. Sample for displacement values.\n\n# a. Using displace option\n\ncmds.polyGeoSampler( displaceGeometry=True )\n\n# Example 3. Scaling the sampled data.\n\n# a. Scaling option\n\ncmds.polyGeoSampler( scaleFactor=0.1 )\n\n# Example 4. Don\'t force unshared UV value usage, and force\n# the storage of shared colors for vertices.\n\ncmds.polyGeoSampler( shareUV=True, averageColor=True )\n\n# Example 5. Clamping colors. In this example the alpha and\n# RGB channels of the colors are clamped between a min of 0,0,0,1\n# and a max of 1,2,1,0.5 .\n\ncmds.polyGeoSampler( amn=0.0, amx=0.5, cmn=[0.0,0.0,0.0], cmx=[1.0,2.0,1.0] )\n\n# Example 6. Multiply the new sample color values    with the existing\n# colors stored on the geometry, but leave the alpha values\n# as they were on the geometry.\n\ncmds.polyGeoSampler( colorBlend=\'multiply\', alphaBlend=\'none\' )',
 'polyHelix': 'import maya.cmds as cmds\n\n# Create a helix with radius 1.0 in anti clockwise direction with no UV\'s for texture.\ncmds.polyHelix(r=1, d=1, cuv=0)\n\n# Create a helix, called "myHelix" with default values.\ncmds.polyHelix(n=\'myHelix\')',
 'polyHole': 'import maya.cmds as cmds\n\n# To toggle hole on/off on the selected faces\ncmds.polyHole( )',
 'polyInfo': 'import maya.cmds as cmds\n\n# To find all non-manifold edges on a polygonal object called pPlane1\ncmds.polyInfo( nme=True )\n# Result: pPlane1.e[74] #\n\n# To find all non-manifold vertices on a polygonal object called pPlane1\ncmds.polyInfo( nmv=True )\n# Result: pPlane1.vtx[38] pPlane1.vtx[49] #',
 'polyInstallAction': "import maya.cmds as cmds\n\n# Will set pickmask to edges, install internal constraint\n# so that only border edges may be selected.\ncmds.polyInstallAction( 'polyCloseBorder', ic=True )\n\n# Same as previous, plus force the display of borders if the\n# user didn't asked explicitely for it before.\ncmds.polyInstallAction( 'polyCloseBorder', ic=True, id=True )\n\n# Shortcut for polyInstallAction -ic -id polyCloseBorder;\ncmds.polyInstallAction( 'polyCloseBorder' )\n\n# Assuming the previous install was for closeBorder,\n# will release internal border constraint, but go on displaying\n# borders if the user didn't asked explicitely for it before.\ncmds.polyInstallAction( uc=True )\n\n# Assuming the previous install was for closeBorder,\n# will release internal border constraint, stop displaying\n# borders if the user didn't asked explicitely for it before.\ncmds.polyInstallAction( uc=True, ud=True )\n\n# Shortcut for polyInstallAction -uc -ud;\ncmds.polyInstallAction()",
 'polyIterOnPoly': '',
 'polyLayoutUV': "import maya.cmds as cmds\n\n# Create a sphere.\ncmds.polySphere( n='sph' )\n\n# Use a plane projection on half the faces\ncmds.select( 'sph.f[0:200]' )\ncmds.polyProjection( type='Planar' )\n\n# Layout all UVs in the texture plane.\ncmds.polyLayoutUV( 'sph.f[*]', l=2, fr=True, se=2, sc=1 )",
 'polyListComponentConversion': "import maya.cmds as cmds\n\n# Convert the vertices to envolved poly face(s) and list results.\ncmds.polyListComponentConversion( 'plg.vtx[5:6]', 'plg.vtx[9:10]', fv=True, tf=True, internal=True )\n# Result: plg.f[4] #\n\n# Convert anything to related poly face(s) and list results.\ncmds.polyListComponentConversion( 'plg.vtx[0]', 'plg.vtx[3]', 'plg.vtx[8]', tf=True )\n# Result: plg.f[0] plg.f[2] plg.f[3] plg.f[6] #\n\n# Convert an object to faces and list results.\ncmds.polyListComponentConversion( 'plg', tf=True )\n# Result: plg.f[*] #\n\n# Convert vertices to faces on selectionList and list results.\ncmds.select( 'plg.vtx[0]', 'plg.vtx[3]', 'plg.vtx[8]', r=True )\ncmds.polyListComponentConversion( fv=True, tf=True )\n# Result: plg.f[0] plg.f[2] plg.f[3] plg.f[6] #\n\n# Use several calls of the command to list edges in the order\n# in which they appear in a face.\ncmds.polyPlane( w=1, h=1, sx=1, sy=1 )\n# Will return the edges in numeric order:\ncmds.polyListComponentConversion( 'pPlane1.f[0]', ff=True, te=True )\n# Result: pPlane1.e[0:3]\n# Now convert to vertexFace and then to edge to get the edges in the order they\n# appear within the face:\nvfList = cmds.polyListComponentConversion( 'pPlane1.f[0]', ff=True, tvf=True )\nvfList = cmds.ls( vfList, flatten=True )\n# Result: pPlane1.vtxFace[0][0] pPlane1.vtxFace[1][0] pPlane1.vtxFace[3][0] pPlane1.vtxFace[2][0]\nfor vf in vfList:\n\tedge = cmds.polyListComponentConversion( vf, fvf=True, te=True )\n\tprint edge\n# Prints out the edges in the order they show up in the face.\npPlane1.e[0]\npPlane1.e[2]\npPlane1.e[3]\npPlane1.e[1]\n\n# Illustrate the vertexFaceAllEdges flag\ncmds.polyPlane( w=1, h=1, sx=1, sy=1 )\ncmds.select( 'pPlane1.vtxFace[0][0]', r=True )\n# Get the edge that originates at the selected face vertex\nprint cmds.polyListComponentConversion( fvf=True, te=True )\n# Result: pPlane1.e[0]\n# Get both edges that adjoin the selected face vertex\nprint cmds.polyListComponentConversion( fvf=True, te=True, vfa=True )\n# Result: pPlane1.e[0:1]",
 'polyMapCut': "import maya.cmds as cmds\n\n# Opening up the textureView will make this example much easier to visualize.\n\n# Create a plane and select it.\ncmds.polyPlane( n='plg', sx=5, sy=5, w=10, h=10 )\ncmds.select( 'plg' )\n\n# Display map borders.\ncmds.polyOptions( ao=True, dmb=True )\n\n# Cut the map.\ncmds.polyMapCut( 'plg.e[44]', 'plg.e[46]', 'plg.e[48]', 'plg.e[50]', 'plg.e[52]' )\n# now that it's cut, we may move the row separately\n\n# Move some UVs\ncmds.polyMoveUV('plg.map[24:28]', 'plg.map[30:35]', 'plg.map[37]', tv=0.3 )",
 'polyMapDel': "import maya.cmds as cmds\n\n# Create a plane.\ncmds.polyPlane( n='plg', sx=5, sy=5, w=20, h=20 )\n\n# Delete the mapping from the given faces.\ncmds.polyMapDel( 'plg.f[11:13]', 'plg.f[16:18]' )",
 'polyMapSew': "import maya.cmds as cmds\n\n# Opening the texture view will make this example much clearer.\n\n# Create a plane and select it.\ncmds.polyPlane( n='plg', sx=5, sy=5, w=10, h=10 )\ncmds.select( 'plg' )\n\n# Display map borders.\ncmds.polyOptions( ao=True, dmb=True )\n\n# Cut the map.\ncmds.polyMapCut( 'plg.e[44]', 'plg.e[46]', 'plg.e[48]', 'plg.e[50]', 'plg.e[52]' )\n\n# Move the row\ncmds.polyMoveUV( 'plg.map[24:28]', 'plg.map[30:35]', 'plg.map[37]', t=(0.0, 0.5 ))\n\n# Now sew some border edges\ncmds.polyMapSew( 'plg.e[44]', 'plg.e[46]', 'plg.e[48]' )",
 'polyMapSewMove': "import maya.cmds as cmds\n\n# Build a plane\ncmds.polyPlane()\n\n# Map and move some faces. Scale them so that seams do not mathc any more\ncmds.select( 'pPlane1.f[0:49]', r=True )\ncmds.polyProjection( type='Planar' )\ncmds.setAttr( 'polyPlanarProj1.rotateX', -90 )\ncmds.setAttr( 'polyPlanarProj1.imageCenter', 0.630609, 0.38805)\ncmds.setAttr( 'polyPlanarProj1.rotationAngle', 10 )\ncmds.setAttr( 'polyPlanarProj1.imageScaleU', 1.2 )\ncmds.setAttr( 'polyPlanarProj1.imageScaleV', 1.2 )\n\n# Select the seams\ncmds.select( 'pPlane1.e[105]', 'pPlane1.e[107]', 'pPlane1.e[109]', 'pPlane1.e[111]', 'pPlane1.e[113]', 'pPlane1.e[115]', 'pPlane1.e[117]', 'pPlane1.e[119]', 'pPlane1.e[121]', 'pPlane1.e[123]' )\n# merge them back, with the appropriate move.\ncmds.polyMapSewMove()",
 'polyMergeEdge': "import maya.cmds as cmds\n\ncmds.polyPlane( sx=3, sy=3, n='plg1' )\ncmds.move( -2, 0, 0, 'plg1' )\ncmds.delete( 'plg1.f[3:5]' )\ncmds.polyPlane( sx=3, sy=3, n='plg2' )\ncmds.delete( 'plg2.f[3:5]' )\ncmds.polyPlane( sx=3, sy=3, n='plg3' )\ncmds.move( 2, 0, 0, 'plg3' )\ncmds.delete( 'plg3.f[3:5]' )\n\n# First\ncmds.polyMergeEdge( 'plg1', mm=0, fe=8, se=12 )\n\n# Between\ncmds.polyMergeEdge( 'plg2', mm=1, fe=8, se=12 )\n\n# Last\ncmds.polyMergeEdge( 'plg3', mm=2, fe=8, se=12 )",
 'polyMergeEdgeCtx': "import maya.cmds as cmds\n\ncmds.polyPlane( sx=3, sy=3, n='plg1' )\ncmds.move( -2, 0, 0, 'plg1' )\ncmds.delete( 'plg1.f[3:5]' )\ncmds.polyPlane( sx=3, sy=3, n='plg2' )\ncmds.delete( 'plg2.f[3:5]' )\ncmds.polyPlane( sx=3, sy=3, n='plg3' )\ncmds.move( 2, 0, 0, 'plg3' )\ncmds.delete( 'plg3.f[3:5]' )\n\n# First\ncmds.polyMergeEdge( 'plg1', mm=0, fe=8, se=12 )\n\n# Between\ncmds.polyMergeEdge( 'plg2', mm=1, fe=8, se=12 )\n\n# Last\ncmds.polyMergeEdge( 'plg3', mm=2, fe=8, se=12 )\n\n# Create a poly plane\ncmds.polyPlane(w=10, h=10, sx=10, sy=10, n='pPlane1')\n\n# Create a new poly merge edge context, set to use first selected edge as the new edge, then switch to it\ncmds.polyMergeEdgeCtx('polyMergeEdgeCtx1', mm=0)\ncmds.setToolTo('polyMergeEdgeCtx1')",
 'polyMergeFacet': "import maya.cmds as cmds\n\ncmds.polyPlane( n='plg', h=10, w=10, sx=5, sy=5 )\ncmds.polyChipOff( 'plg.f[16]', 'plg.f[18]', 'plg.f[7]', dup=1, ltz=1, ls=(.5, .5, .5) )\n\n# First\ncmds.polyMergeFacet( 'plg', mm=0, ff=16, sf=26 )\n# A new face with face #16 as an outer loop and face #26 as a hole\n# is replacing faces #16 and #26, and is located on face #16\n\n# Between\ncmds.polyMergeFacet( 'plg', mm=1, ff=7, sf=25 )\n# A new face with face #7 as an outer loop and face #25 as a hole\n# is replacing faces #7 and #25, and is located in between.\n\n# Last\ncmds.polyMergeFacet( 'plg', mm=2, ff=18, sf=25 )\n# A new face with face #18 as an outer loop and face #25 as a hole\n# is replacing faces #18 and #25, and is located on face #25",
 'polyMergeFacetCtx': "import maya.cmds as cmds\n\ncmds.polyPlane( n='plg', h=10, w=10, sx=5, sy=5 )\ncmds.polyChipOff( 'plg.f[16]', 'plg.f[18]', 'plg.f[7]', dup=1, ltz=1, ls=(.5, .5, .5) )\n\n# First\ncmds.polyMergeFacet( 'plg', mm=0, ff=16, sf=26 )\n# A new face with face #16 as an outer loop and face #26 as a hole\n# is replacing faces #16 and #26, and is located on face #16\n\n# Between\ncmds.polyMergeFacet( 'plg', mm=1, ff=7, sf=25 )\n# A new face with face #7 as an outer loop and face #25 as a hole\n# is replacing faces #7 and #25, and is located in between.\n\n# Last\ncmds.polyMergeFacet( 'plg', mm=2, ff=18, sf=25 )\n# A new face with face #18 as an outer loop and face #25 as a hole\n# is replacing faces #18 and #25, and is located on face #25\n\n# Create a poly plane\ncmds.polyPlane(w=10, h=10, sx=10, sy=10, n='pPlane1')\n\n# Create a new poly merge facet context, set the merge mode to merging the second face to the first face, then switch to it\ncmds.polyMergeFacetCtx('polyMergeFacetCtx1', mm=0)\ncmds.setToolTo('polyMergeFacetCtx1')",
 'polyMergeUV': "import maya.cmds as cmds\n\n# Create a poly cube\ncmds.polyCube()\ncmds.select( 'pCube1.map[4]', 'pCube1.map[13]', r=True )\n\n# Merge two UVs\ncmds.polyMergeUV()",
 'polyMergeVertex': "import maya.cmds as cmds\n\ncmds.polyPlane( sx=5, sy=5, n='plg1' )\ncmds.polyPlane( sx=5, sy=5, n='plg2' )\ncmds.move( 0.55, 0, -1.25, 'plg1', ws=True )\ncmds.move( -0.55, 0, -1.25, 'plg2', ws=True )\ncmds.polyPlane( sx=5, sy=5, n='plg3' )\ncmds.polyPlane( sx=5, sy=5, n='plg4' )\ncmds.polyPlane( sx=5, sy=5, n='plg5' )\ncmds.move( 0.55, 0, 1.25, 'plg4', ws=True )\ncmds.move( -0.55, 0, 1.25, 'plg5', ws=True )\n\n# First method:\ncmds.polyUnite( 'plg1Shape', 'plg2Shape' )\ncmds.select( 'polySurface1.vtx[6]', 'polySurface1.vtx[12]', 'polySurface1.vtx[18]', 'polySurface1.vtx[24]', 'polySurface1.vtx[47]', 'polySurface1.vtx[53]', 'polySurface1.vtx[59]', 'polySurface1.vtx[65]', r=True )\ncmds.polyMergeVertex( d=0.15 )\n\n# Second method:\ncmds.polyMergeVertex( 'plg3.vtx[24]', 'plg3.vtx[30:31]', 'plg3.vtx[8:10]', 'plg3.vtx[14:16]', 'plg3.vtx[20:22]', d=0.25 )\n\n# To create non-manifold geometry:\ncmds.polyUnite( 'plg4Shape', 'plg5Shape' )\ncmds.select( 'polySurface2.vtx[0]', 'polySurface2.vtx[6]', 'polySurface2.vtx[12]', 'polySurface2.vtx[18]', 'polySurface2.vtx[24]', 'polySurface2.vtx[30]', 'polySurface2.vtx[41]', 'polySurface2.vtx[47]', 'polySurface2.vtx[53]', 'polySurface2.vtx[59]', 'polySurface2.vtx[65]', 'polySurface2.vtx[71]', r=True )\ncmds.polyMergeVertex( d=0.25 )\n# Note that there is only one vertex at this merged point and the\n# resulting polygonal object is non-manifold;()",
 'polyMirrorFace': "import maya.cmds as cmds\n\n# Mirror about +X direction by merging the border vertices\ncmds.polyCube( name='poly1' )\ncmds.delete( 'poly1.f[4]' )\ncmds.polyMirrorFace( 'poly1', direction=0, mergeMode=1 )\n\n# Mirror about +Y direction by connecting the border edges\n# in world reference, by explicitly specifying a pivot point (0, 2, 0)\ncmds.polyCube( name='poly2' )\ncmds.delete( 'poly2.f[4]' )\ncmds.rotate( 0, 0, 45, 'poly2', r=True, os=True )\ncmds.polyMirrorFace( 'poly2', direction=2, p=(0, 2, 0), mergeMode=2, worldSpace=1 )",
 'polyMoveEdge': "import maya.cmds as cmds\n\n# Create a sphere.\ncmds.polySphere( n='plg', r=5 )\n\ncmds.select( 'plg.e[200:219]', 'plg.e[560:599]' )\n# Translate selected edges along Z in local coordinates.\ncmds.polyMoveEdge( ltz=1.0 )\n\n# Scale selected edges by (0.5 0.5 0.5)\ncmds.polyMoveEdge( 'plg.e[100:119]', s=(0.5, 0.5, 0.5) )",
 'polyMoveFacet': "import maya.cmds as cmds\n\n# Create a sphere.\ncmds.polySphere( n='plg', r=5 )\n\n# Translate selected facets along Y by 1.0 in world coordinates\ncmds.polyMoveFacet( 'plg.f[300:359]', 'plg.f[380:399]', ty=1.0 )\n\n# Scale selected facets by (0.5, 0.5, 0.5);\ncmds.polyMoveFacet( 'plg.f[0:59]', 'plg.f[360:379]', sx=0.5, sy=0.5, sz=0.5 )",
 'polyMoveFacetUV': "import maya.cmds as cmds\n\n# Opening up the textureView will make this example easier to visualize.\n\n# Create a plane and select it.\ncmds.polyPlane( n='plg', sx=5, sy=5, w=10, h=10 )\ncmds.select( 'plg' )\n\n# Display map borders.\ncmds.polyOptions( ao=True, dmb=True )\n\n# Translate selected UVs as the vector (0.0, 1.0).\ncmds.polyMoveFacetUV( 'plgShape.map[30:35]', tu=0.0, tv=1.0 )\n\n# Scale selected UVs as the scaling (0.5, 0.5);\ncmds.polyMoveFacetUV( 'plgShape.map[30:35]', su=0.5, sv=0.5 )",
 'polyMoveUV': "import maya.cmds as cmds\n\n# Opening up the textureView will make this example easier to visualize.\n\n# Create a plane and select it.\ncmds.polyPlane( n='plg', sx=5, sy=5, w=10, h=10 )\ncmds.select( 'plg' )\n\n# Display map borders.\ncmds.polyOptions( ao=True, dmb=True )\n\n# Translate selected UVs as the vector (0.0, 1.0).\ncmds.polyMoveUV( 'plgShape.map[30:35]', tu=0.0, tv=1.0 )\n\n# Scale selected UVs as the scaling (0.5, 0.5);\ncmds.polyMoveUV( 'plgShape.map[30:35]', su=0.5, sv=0.5 )",
 'polyMoveVertex': "import maya.cmds as cmds\n\n# Create a sphere.\ncmds.polySphere( r=5, n='plg' )\n\n# Move vertices as the scaling vector (1.0, 1.5, 1.0).\ncmds.polyMoveVertex( 'plg.vtx[200:379]', 'plg.vtx[381]', s=(1.0, 1.5, 1.0) )\n\n# Translate vertices as the vector (0.0, 2.0, 0.0).\ncmds.polyMoveVertex( 'plg.vtx[200:379]', 'plg.vtx[381]', ty=2.0 )",
 'polyMultiLayoutUV': 'import maya.cmds as cmds\n\n# Create 3 objects with overlapping UVs\nsphere = cmds.polySphere()\ncylinder = cmds.polyCylinder()\ntorus = cmds.polyTorus()\n\ncmds.polyAutoProjection( sphere[0], ibd=1, cm=0, l=2, sc=1, o=1, p=4, ps=0.2 )\ncmds.polyAutoProjection( cylinder[0], ibd=1, cm=0, l=2, sc=1, o=1, p=4, ps=0.2 )\ncmds.polyAutoProjection( torus[0], ibd=1, cm=0, l=2, sc=1, o=1, p=4, ps=0.2 )\n\ncmds.select( sphere[0], cylinder[0], torus[0] )\n\n# Layout the UVs in a square, allow free rotations, scale uniformly\ncmds.polyMultiLayoutUV( scale=1, rotateForBestFit=2, layout=2 )',
 'polyNormal': "import maya.cmds as cmds\n\ncmds.polyPlane( n='plg', w=3, h=3 )\ncmds.polyOptions( ao=True, dn=True, db=True, bc=True )\n\n#<I>reverse and cut</I>\ncmds.select( 'plg.f[40:59]' )\ncmds.polyNormal( nm=3 )\n\n#<I>reverse and propagate</I>\ncmds.polyNormal( 'plg.f[11]', nm=4 )\n# Notice that only the shell containing face 11 is reversed.\n\n# We can reverse all the shells by passing in the object\ncmds.polyNormal( 'plg', nm=3 )",
 'polyNormalPerVertex': 'import maya.cmds as cmds\n\n# To set the xyz values of normals of selected vertices:\ncmds.polyNormalPerVertex( xyz=(0.2, 0.3, 0.4) )\n\n# To set just the "x" value of normal of selected vertices:\ncmds.polyNormalPerVertex( x=.37 )\n\n# To add to the current value of the "y" normal value of selected vertices:\ncmds.polyNormalPerVertex( rel=True, y=.13 )\n\n# To query the normal values on selected vertices - This returns all normals\n# regardless of whether they are shared or not:\ncmds.polyNormalPerVertex( query=True, xyz=True )\n\n# To query if the normals on the selected vertices are locked or not\ncmds.polyNormalPerVertex( query=True, freezeNormal=True )\n\n# To query if all the normals on the selected vertices are locked or not\ncmds.polyNormalPerVertex( query=True, allLocked=True )\n\n# More examples\ncmds.file( f=True, new=True )\ncmds.polyCube()\ncmds.select( \'pCube1.vtxFace[2][1]\', r=True )\ncmds.polyNormalPerVertex( query=True, freezeNormal=True )\n# Result: 0 #\n# Now, lock the normal of a VertexFace on the cube\ncmds.select(\'pCube1.vtxFace[2][1]\', r=True )\ncmds.polyNormalPerVertex( xyz=(0.7071, 0, 0.7071) )\n\n# Query if the normal is locked for this vertexFace\ncmds.polyNormalPerVertex( query=True, freezeNormal=True )\n# Result: 1 #\n\n# Query if the normal is locked for all the normals on this vertex\n# Should return 0, because there are some other normals on\n# this vertex that are not locked.\ncmds.select(\'pCube1.vtx[2]\', r=True)\ncmds.polyNormalPerVertex( query=True, allLocked=True )\n# Result: 0 #',
 'polyNormalizeUV': "import maya.cmds as cmds\n\n# Create a poly sphere with default UVs.\ncmds.polySphere( n='sph' )\n\n# rescale it\ncmds.polyEditUV('sph.map[*]', pu=0.5, pv=0.5, su=1.5, sv=1.5)\n\n# normalize the UV values of all the faces\ncmds.polyNormalizeUV( 'sph.f[*]' )",
 'polyOptUvs': "import maya.cmds as cmds\n\n# Create a sphere and select it.\ncmds.polySphere()\n\n# Optimise the position of some Uvs\ncmds.polyOptUvs( 'pSphere1.map[189:398]' )",
 'polyOptions': "import maya.cmds as cmds\n\ncmds.polyCube( n='plg', sx=3, sy=3, sz=3, w=5, h=5, d=5 )\ncmds.delete( 'plg.f[9:17]' )\n\n# Vertices\ncmds.polyOptions( displayVertex=True )\n# Toggle vertices\ncmds.polyOptions( r=True, displayVertex=True )\n# Toggle, whatever the value given to the flag in this command.\n# It was previously true, it is set to false : vertices are not drawn.\n\n# Facet centers\ncmds.polyOptions( displayCenter=True )\ncmds.polyOptions( displayCenter=False )\n\n# Triangulation\ncmds.polyOptions( displayTriangle=True )\ncmds.polyOptions( displayTriangle=False )\n\n# Reusing Triangulation\ncmds.polyOptions( reuseTriangles=True )\ncmds.polyOptions( reuseTriangles=False )\n\n# Borders\ncmds.polyOptions( displayBorder=True )\n# Border size\ncmds.polyOptions( sb=3 )\n# Increase border size\ncmds.polyOptions( r=True, sb=2 )\ncmds.polyOptions( displayBorder=False, sb=3 )\n# Map borders\ncmds.polyOptions( displayMapBorder=True )\ncmds.polyOptions( displayMapBorder=False )\n\n# Normals\n# Normal type\ncmds.polyOptions( displayNormal=True )\ncmds.polyOptions( pt=True )# on vertices\ncmds.polyOptions( pf=True )# on vertices and facets\ncmds.polyOptions( f=True )# on facets\n# Normal size\ncmds.polyOptions( sn=2 )\n# Increase normal size\ncmds.polyOptions( r=True, sn=1.5 )\ncmds.polyOptions( displayNormal=False )\n\n# Edges\ncmds.polyOptions( softEdge=True )\ncmds.polyOptions( hardEdge=True )\ncmds.polyOptions( hardEdgeColor=True )\ncmds.polyOptions( allEdges=True )\n\n# Geometry\ncmds.polyOptions( displayGeometry=False )\ncmds.polyOptions( displayGeometry=True )\n\n# Backculling\ncmds.polyOptions( wireBackCulling=True )\ncmds.polyOptions( hardBack=True )\ncmds.polyOptions( fullBack=True )\ncmds.polyOptions( displayVertex=True, backCullVertex=True )\ncmds.polyOptions( backCullVertex=False )\ncmds.polyOptions( displayVertex=False )\ncmds.polyOptions( backCulling=True )\n\n# Color Shaded Display\ncmds.polyOptions( colorShadedDisplay=True )\ncmds.polyOptions( colorMaterialChannel='DIFFUSE' )",
 'polyOutput': "import maya.cmds as cmds\n\ncmds.polyPlane()\ncmds.polyOutput( a=True )\n\n# If a polygon operation is performed such as Add Divisions:\ncmds.polySubdivideFacet('pPlane1', dv=1, m=0, ch=1)\n\n# then the command can get information on geometry data feeding into the polySubdFace1 node.\ncmds.polyOutput( 'polySubdFace1.inputPolymesh' )\n\n# The command can also get information on geometry data coming out of the\n# polySubdFace1 node.\ncmds.polyOutput( 'polySubdFace1.output' )",
 'polyPinUV': 'import maya.cmds as cmds\n\n# To set a pin value of 0.9 on the selected UVs.\ncmds.polyPinUV( value=0.9 )\n\n# List all selected UVs which are not pinned.\ncmds.polyPinUV( q=True, unpinned=True )',
 'polyPipe': 'import maya.cmds as cmds\n\n# Create a pipe with height 20 radius 1.0 thickness 0.5 with\n# 10 subdivisions along height\ncmds.polyPipe( sh=10, h=20 )\n\n# Create a pipe, called "myPipe", on thickness cap there are 5\n# subdivisions.\ncmds.polyPipe( n=\'myPipe\', sc=5);',
 'polyPlanarProjection': "import maya.cmds as cmds\n\n# Create a plane with default UVs.\ncmds.polyPlane( n='plane', h=20, w=20 )\n\n# Create a lambert node.\ncmds.shadingNode( 'lambert', n= 'myLambert', asShader=True )\ncmds.sets( renderable=True, noSurfaceShader=True, empty=True, name='myLambertSG' )\ncmds.connectAttr( 'myLambert.outColor', 'myLambertSG.surfaceShader', f=True )\n\n# Create a texture checker.\ncmds.shadingNode( 'checker', asTexture=True )\ncmds.shadingNode( 'place2dTexture', asUtility=True )\ncmds.connectAttr( 'place2dTexture1.outUV', 'checker1.uv' )\n\n# Assign the texture the the lambert node.\ncmds.connectAttr( 'checker1.outColor', 'myLambert.color', f=True )\n\n# Set the textured display mode.\ncurrentPanel = cmds.getPanel(withFocus= True)\nif currentPanel != '':\n\tcmds.modelEditor(currentPanel, edit=True, da='smoothShaded', displayTextures=True, dl='default')\n\n# Assign the lambert shader to all facets of the plane.\ncmds.sets('planeShape.f[0:99]', edit=True, forceElement= 'myLambertSG' )\n\n# Replace default UVs on half of the plane :\n# Rotates projection around X, rotate the map of 45 degrees,\n# and reduces of half the projected map.\ncmds.polyPlanarProjection( 'plane.f[0:49]', rx=90, ra=45.0, pc= (0, 0, 0), imageScale=(0.5, 0.5))\n\n# Set the wireframe display mode.\ncurrentPanel = cmds.getPanel(withFocus= True)\nif currentPanel != '':\n\tcmds.modelEditor(currentPanel, edit=True, da='wireframe')",
 'polyPlane': 'import maya.cmds as cmds\n\n# Create a mesh (plane), with 10 subdivisions in the X direction,\n# 15 subdivisions in the Y direction,\n# the width of the mesh is 15, the height of the mesh is 20.\ncmds.polyPlane( sx=10, sy=15, w=15, h=20)\n\n# Create a mesh, called "myPlane", on each direction there are 5 subdivisions.\ncmds.polyPlane(n=\'myPlane\', sx=5, sy=5)',
 'polyPlatonicSolid': 'import maya.cmds as cmds\n\n# Create a icosahedron with radius 2 side length 2\ncmds.polyPlatonicSolid( r=2, l=2, st=1)\n\n# Create a platonic solid, called "myPlatonicsolid", of type octahedron.\ncmds.polyPlatonicSolid( n=\'myPlatonicsolid\', st=2 )',
 'polyPoke': "import maya.cmds as cmds\n\n# To poke all the faces of a polyCube...\n#\ncmds.polyCube( w=1, h=1, d=1, sx=1, sy=1, sz=1, ax=(0, 1, 0), tx=1, ch=1, n='pCube' )\ncmds.polyPoke( 'pCube.f[0:5]', ch=1 )\n\n# To poke all the faces of a polyCube, and pull the\n# new vertices by one unit along the face normal\n#\ncmds.polyCube( w=1, h=1, d=1, sx=1, sy=1, sz=1, ax=(0, 1, 0), tx=1, ch=1, n='pCubePull' )\ncmds.polyPoke( 'pCubePull.f[0:5]', ltx=0, lty=0, ltz=1, ch=1 )",
 'polyPrimitive': 'import maya.cmds as cmds\n\n# Create a soccerBall with radius 1 side length 0.4037\ncmds.polyPrimitive( r=1, l=0.4036, pt=0)',
 'polyPrimitiveMisc': '',
 'polyPrism': 'import maya.cmds as cmds\n\n# Create a prism, with 10 subdivisions on the caps,\n# and 15 subdivisions along the length,\n# the edge length of the prism is 20.\ncmds.polyPrism ( sc=10, sh=15, w=20)\n\n# Create a prism, called "myprism", on each direction there are 5 subdivisions.\ncmds.polyPrism( n=\'myprism\', sc=5, sh=5)',
 'polyProjectCurve': 'import maya.cmds as cmds\n\n# create a poly plane in the z axis\npoly = cmds.polyPlane(w=10, h=10, sx=10, sy=10, ax=(0,0,1), cuv=2, ch=1)\n\n# create a nurbs circle also in the z axis\nnurbs = cmds.circle(ch=1, o=1, r=2, nr=(0,0,1))\n\n# and project it onto the poly plane along the z axis\nresults = cmds.polyProjectCurve(poly[0], nurbs[0], direction=(0,0,1))',
 'polyProjection': "import maya.cmds as cmds\n\ncmds.file( f=True, new=True )\n# To create a planar projection\n#\ncmds.polyPlane( sx=10, sy=10 )\ncmds.move( 0, 0, r=3 )\ncmds.polyProjection( 'pPlane1.f[0:99]', type='Planar', md='y' )\n# Result: polyPlanarProj1 #\n\n# To create a cylindrical projection\n#\ncmds.polyCylinder()\ncmds.polyProjection( 'pCylinder1.f[0:21]', type='Cylindrical' )\n# Result: polyCylProj1 #\n\n# To create a spherical projection\n#\ncmds.polySphere()\ncmds.move( 0, 0, r=-3 )\ncmds.polyProjection( 'pSphere1.f[0:399]', type='Spherical' )\n# Result: polySphProj1 #",
 'polyPyramid': 'import maya.cmds as cmds\n\n# Create a pyramid, with 10 subdivisions on the caps,\n# 15 subdivisions along the height and num ber of sides 5,\n# the side length of the pyramid is 20, the height of the pyramid is 10.\ncmds.polyPyramid( sc=10, sh=15, ns=5, w=20)\n\n# Create a pyramid, called "mypyramid", olong height there are 5 subdivisions\n# and with 5 sides.\ncmds.polyPyramid( n=\'mypyramid\', sh=5, ns=5, sc=5)\n\n# Query the side length of "mypyramid"\nw = cmds.polyPyramid( \'mypyramid\', q=True, w=True )',
 'polyQuad': "import maya.cmds as cmds\n\ncmds.polyCube( n='plg1', sx=3, sy=3, sz=3, w=5, h=5, d=5 )\ncmds.move( -5, 0, 0 )\ncmds.polyCube( n='plg2', sx=3, sy=3, sz=3, w=5, h=5, d=5 )\ncmds.move( 5, 0, 0 )\ncmds.delete( 'plg1.f[9:17]' )\ncmds.polyTriangulate( 'plg1.f[0:44]' )\ncmds.delete( 'plg2.f[9:17]' )\ncmds.polyTriangulate( 'plg2.f[0:44]' )\ncmds.polyMoveVertex( 'plg1.vtx[20:35]', ltz=2.5 )\ncmds.polyMoveVertex( 'plg2.vtx[20:35]', ltz=2.5 )\n\n#Only coplanar triangles will be merged.\ncmds.polyQuad( 'plg1.f[0:89]', a=0.0 )\n\n#All possible triangles will be merged.\ncmds.polyQuad( 'plg2.f[0:89]', a=180.0 )",
 'polyQueryBlindData': "import maya.cmds as cmds\n\ncmds.polyQueryBlindData( 'pPlane1.vtx[2]', 'pPlane1.vtx[8]', id=9001, associationType='vertex', ldn='bdFloat', dbd=234 )\n\ncmds.polyQueryBlindData( id=9005, sc='pPlane1.vtx[0:100]' )\n\ncmds.polyQueryBlindData( 'pPlane1.f[0:10]', sc='pPlane1.vtx[0:100]' )",
 'polyReduce': "import maya.cmds as cmds\n\ncmds.polySphere( ver=1, n='plg' )\ncmds.polyReduce( ver=1, p=35, 'plg.f[0:399]' )",
 'polyRemesh': 'import maya.cmds as cmds\n\ncmds.polySphere( r=10 )\ncmds.polyRemesh( maxEdgeLength=1 )',
 'polyRetopo': 'import maya.cmds as cmds\n\ncmds.polyRetopo',
 'polyRetopoCtx': '',
 'polySelect': "import maya.cmds as cmds\n\ncmds.polySelect( 'pCube1', edgeRing=1 )\ncmds.polySelect( 'pCube1', toggle=True, edgeRingPath=(1, 10) )\ncmds.polySelect( 'pCube1', ns=True, edgeRingPath=(1, 10) )\ncmds.polySelect( 'pCube1', edgeRingPath=((1, 10), (11, 20)) )\ncmds.polySelect( 'pPlane1', shortestEdgePath=(10, 100) )",
 'polySelectConstraint': "import maya.cmds as cmds\n\ncmds.selectMode( co=True )\n\n# <b>Propagation</b>\n\ncmds.polyPlane( n='plg', w=5, h=5 )\ncmds.delete( 'plg.f[20:29]' )\ncmds.selectType( pf=True )\ncmds.polySelectConstraint( sh=True ) # next mouse selections will propagate to all shell\ncmds.polySelectConstraint( sh=False )\ncmds.polySelectConstraint( bo=True ) # next mouse selections will propagate along border\ncmds.polySelectConstraint( bo=False )\ncmds.polySelectConstraint( cr=True ) # next mouse selections will propagate to all connected creased components\ncmds.polySelectConstraint( cr=False )\n\ncmds.select( 'plg.f[54:55]' )\ncmds.polySelectConstraint( pp=1 )\ncmds.polySelectConstraint( pp=1 ) # to get more and more\ncmds.polySelectConstraint( pp=1 )\ncmds.polySelectConstraint( pp=2 ) # to get less\ncmds.polySelectConstraint( pp=3 ) # to get selection border\ncmds.delete( 'plg' )\n\n# <b>Propagation along loop</b>\n\ncmds.polyPlane( n='plg', w=5, h=5 )\ncmds.selectType( pf=True )\ncmds.select( 'plg.f[42:43]', 'plg.f[53]', 'plg.f[76]' )\ncmds.polySelectConstraint( pp=5 ) # grow face selection along loop\ncmds.polySelectConstraint( pp=6 ) # shrink face selection along loop\ncmds.delete( 'plg' )\n\ncmds.polyPlane( n='plg', w=5, h=5 )\ncmds.selectType( pe=True )\ncmds.select( 'plg.e[113]', 'plg.e[115:116]' )\ncmds.polySelectConstraint( pp=5 ) # grow edge selection along loop\ncmds.polySelectConstraint( pp=6 ) # shrink edge selection along loop\ncmds.delete( 'plg' )\n\ncmds.polyPlane( n='plg', w=5, h=5 )\ncmds.selectType( pv=True )\ncmds.select( 'plg.vtx[59:61]' )\ncmds.polySelectConstraint( pp=5 ) # grow vertex selection along loop\ncmds.polySelectConstraint( pp=6 ) # shrink vertex selection along loop\ncmds.delete( 'plg' )\n\ncmds.polyPlane( n='plg', w=5, h=5 )\ncmds.selectType( puv=True )\ncmds.select( 'plg.map[71]', 'plg.map[59:60]' )\ncmds.polySelectConstraint( pp=5 ) # grow UV selection along loop\ncmds.polySelectConstraint( pp=6 ) # shrink UV selection along loop\ncmds.delete( 'plg' )\n\n#<b>Properties</b>\n\n#location\ncmds.polyPlane( n='plg', w=5, h=5 )\ncmds.selectType( pv=True )\ncmds.polySelectConstraint( m=3, t=1, w=1 ) # to get border vertices\ncmds.polySelectConstraint( m=3, t=1, w=2 ) # to get inner vertices\ncmds.polySelectConstraint( w=0 ) # turn off location constraint\ncmds.delete( 'plg' )\n\n#edge smoothness\ncmds.polyCylinder( n='plg' )\ncmds.selectType( pe=True )\ncmds.polySelectConstraint( m=3, t=0x8000, sm=1 ) # to get hard edges\ncmds.polySelectConstraint( m=3, t=0x8000, sm=2 ) # to get soft edges\ncmds.polySelectConstraint( sm=0 ) # turn off edge smoothness constraint\ncmds.delete( 'plg' )\n\n#face size\ncmds.polyCylinder( n='plg', sz=1 )\ncmds.delete( 'plg.f[40:59]' )\ncmds.polyCloseBorder( 'plg.e[27]' )\ncmds.selectType( pf=True )\ncmds.polySelectConstraint( m=3, t=8, sz=1 ) # to get triangles\ncmds.polySelectConstraint( m=3, t=8, sz=2 ) # to get quads\ncmds.polySelectConstraint( m=3, t=8, sz=3 ) # to get N-sided\ncmds.polySelectConstraint( sz=0 ) # turn off face size constraint\ncmds.delete( 'plg' )\n\n#face planarity\n#    polyPlane -n plg -w 5 -h 5; polyMoveVertex -ltz 1 plg.vtx[79] plg.vtx[85];\ncmds.selectType( pf=True )\ncmds.polySelectConstraint( m=3, t=8, p=1 ) # to get non-planar faces\ncmds.polySelectConstraint( m=3, t=8, p=2 ) # to get planar faces\ncmds.polySelectConstraint( p=0 ) # turn off face planarity constraint\ncmds.delete( 'plg' )\n\n#face convexity\ncmds.polyPlane( n='plg', w=5, h=5 )\ncmds.delete( 'plg.f[51]', 'plg.f[61]', 'plg.f[52:53]' )\ncmds.polyCloseBorder( 'plg.e[146]' )\ncmds.selectType( pf=True )\ncmds.polySelectConstraint( m=3, t=8, c=1 )# to get non-convex faces\ncmds.polySelectConstraint( m=3, t=8, c=2 )# to get convex faces\ncmds.polySelectConstraint( c=0 )#  turn off face convexity constraint\ncmds.delete( 'plg' )\n\n#face holes\ncmds.polyCreateFacet( n='plg', p=[(-2, 2, 0), (-2, -2, 0), (2, -2, 0), (2, 2, 0)] )\ncmds.polyAppend( a=[2, (6, -2, 0), (6, 2, 0), (), (3, 1, 0), (3, -1, 0), (5, 0, 0)] )\ncmds.selectType( pf=True )\ncmds.polySelectConstraint( m=3, t=8, h=1 )# to get holed faces\ncmds.polySelectConstraint( m=3, t=8, h=2 )# to get non-holed faces\ncmds.polySelectConstraint( h=0 )# turn off hole constraint\ncmds.delete( 'plg' )\n\n#face mapping\ncmds.polyPlane( n='plg', w=5, h=5 )\ncmds.polyMapDel( 'plg.f[60:69]' )\ncmds.selectType( pf=True )\ncmds.polySelectConstraint( m=3, t=8, tx=1 ) # to get mapped faces\ncmds.polySelectConstraint( m=3, t=8, tx=2 ) # to get non-mapped faces\ncmds.polySelectConstraint( tx=0 ) # turn off face mapping constraint\ncmds.delete( 'plg' )\n\n#face topology\ncmds.polyCreateFacet( n='plg', p=((-3, 3, 0),(-3, -3, 0),(3, -3, 0),(3, 3, 0)) )\ncmds.polyAppend( a= [2, (8, -3, 0), (8, 3, 0)] )\ncmds.polyAppend( a= (4, 6, 5 ) )\ncmds.polyAppend( a =[0, (-7, 2, 0),(-7, -1, 0),(-8, 2, 0),(-5, 4, 0)] )\ncmds.selectType( pf=True)\ncmds.polySelectConstraint( m=3, t=8, tp=1 ) # to get non triangulatable faces\ncmds.polySelectConstraint( m=3, t=8, tp=2 ) # to get lamina faces\ncmds.polySelectConstraint( tp=0 ) # turn off the face topology constraint\ncmds.delete( 'plg' )\n\n#<b>Length</b>\ncmds.polyCylinder( n='plg', sz=1, h=3 )\ncmds.selectType( pe=True )\ncmds.polySelectConstraint( m=3, t=0x8000, l=True, lb=(2, 4) ) # to get edges of length 2 to 4 units\ncmds.polySelectConstraint( m=3, t=0x8000, l=True, lb=(1, 2) ) # to get edges of length 1 to 2 units\ncmds.polySelectConstraint( l=False ) # turn off the length constraint\ncmds.delete( 'plg' )\n\n#<b>Angle</b>\ncmds.polyCube( n='plg', w=5, h=5, d=5 )\ncmds.polyBevel( 'plg.e[7]', sg=1 )\ncmds.polyBevel( 'plg.e[9]', sg=3 )\ncmds.selectType( pe=True )\ncmds.polySelectConstraint( m=3, t=0x8000, a=True, ab=(0, 89) ) # to get edges with angle between 0-89\ncmds.polySelectConstraint( m=3, t=0x8000, a=True, ab=(45, 89) ) # to get edges with angle between 45-89\ncmds.polySelectConstraint( a=False ) # turn off angle constraint\ncmds.delete( 'plg' )\n\n#<b>3D Area</b>\ncmds.polyPlane( n='plg', w=5, h=5 )\ncmds.polyMoveFacet( 'plg.f[70:79]', ls=(.5, .5, 0) )\ncmds.selectType( pf=True )\ncmds.polySelectConstraint( m=3, t=8, ga=True, gab=(0, 0.2) ) # to get faces with area between 0 and 0.2\ncmds.polySelectConstraint( m=3, t=8, ga=True, gab=(0.2, 0.3) ) # to get faces with area between 0 and 0.2\ncmds.polySelectConstraint( ga=False ) # turn off 3D area constraint\ncmds.delete( 'plg' )\n\n#<b>2D area</b>\ncmds.polyCylinder( n='plg' )\ncmds.selectType( pf=True )\ncmds.polySelectConstraint( m=3, t=8, ta=True, tab=(0, 0.5) ) # to get face with texture area between 0-0.5\ncmds.polySelectConstraint( ta=True ) # turn off the 2D area constraint\ncmds.delete( 'plg' )\n\n#<b>Distance</b>\ncmds.polyPlane( n='plg', w=5, h=5 )\ncmds.selectType( pv=True )\ncmds.polySelectConstraint( m=3, t=1, d=1, db=(0, 5), dp=(5, 0, 0) ) # to get vertices located\n# between 0-5 units from a given point\ncmds.polySelectConstraint( m=3, t=1, d=1, db=(5, 5), dp=(5, 0, 0) ) # to get vertices located\n# at exactly 5 units from a given point\ncmds.polySelectConstraint( m=3, t=1, d=2, db=(5, 6), dp=(5, 0, 0) ) # to get vertices located\n# between 5-6 units from a given axis\ncmds.polySelectConstraint( d=0 )# turn off the distance constraint\ncmds.delete( 'plg' )\n\n#<b>Orientation</b>\ncmds.polySphere( n='plg' )\ncmds.selectType( pv=True' )\ncmds.polySelectConstraint( m=3, t=1, o=1, ob=(0, 30), oa=(0, 1, 0) )# to get vertices oriented between\n# 0-30 degree to a given axis\ncmds.polySelectConstraint( m=3, t=1, o=2, ob=(0, 30), oa=(0, 1, 0) )\ncmds.polySelectConstraint( o=0 )# turn off the orintation constraint\ncmds.delete( 'plg' )\n\n#<b>Order (Neighbor)</b>\ncmds.polyPlane( n='plg', w=5, h=5 )\ncmds.selectType( pv=True )\ncmds.polySelectConstraint( m=3, t=1, order=True, orb=(0, 2) ) # to get vertices with 0 to 2 neighbors\ncmds.polySelectConstraint( order=False ) # turn off the order (neighbor) constraint\ncmds.delete( 'plg' )\n\n#<b>Visibility</b>\ncmds.polySphere( n='plg' )\ncmds.selectType( pv=True )\ncmds.polySelectConstraint( m=3, t=1, v=True, va=60, vp=(10, 0, 0) ) # to get vertices in the 60 degree angle from a given point\ncmds.polySelectConstraint( v=False ) # turn off the visbility constraint\ncmds.delete( 'plg' )\n\n#<b>Random</b>\ncmds.polyPlane( n='plg', w=5, h=5 )\ncmds.selectType( pv=True )\ncmds.polySelectConstraint( m=3, t=1, r=True, rr=.5 )\ncmds.polySelectConstraint( r= False ) # turn off the random constraint\ncmds.delete( 'plg' )\n\n# NOTE: Make sure you turn off the constraint you have used. Otherwise it may\n# affect your next selection (if <i>mode</i> flag is ON).",
 'polySelectConstraintMonitor': "import maya.cmds as cmds\n\n# create Monitor\ncmds.polySelectConstraintMonitor( create=True )\n\n# set up a callback for when the constraints are changed\ncmds.polySelectConstraintMonitor( changeCommand=('polygonConstraintUpdate', 'MyPanel'));\n\n# delete Monitor\ncmds.polySelectConstraintMonitor( delete=True )",
 'polySelectCtx': "import maya.cmds as cmds\n\n# Create a poly plane\ncmds.polyPlane(w=10, h=10, sx=10, sy=10, n='pPlane1')\n\n# Create a new poly select context, then switch to it\ncmds.polySelectCtx('polySelectCtx1')\ncmds.setToolTo('polySelectCtx1')",
 'polySelectEditCtx': "import maya.cmds as cmds\n\n# Create a poly plane\ncmds.polyPlane(w=10, h=10, sx=5, sy=5, n='pPlane1')\n\n# Create a new poly select and edit context, then switch to it\ncmds.polySelectEditCtx('polySelectEditCtx1')\ncmds.setToolTo('polySelectEditCtx1')",
 'polySelectEditCtxDataCmd': '',
 'polySelectSp': '',
 'polySeparate': "import maya.cmds as cmds\n\ncmds.polyPlane( n='plg', w=5, h=5 )\ncmds.delete( 'plg.f[20:29]' )\n\ncmds.polySeparate( 'plg' )",
 'polySetToFaceNormal': 'import maya.cmds as cmds\n\n# Create user normals and set them to the face normals\ncmds.polySetToFaceNormal( setUserNormal=True )\n\n# Set the normals to the default normal values (internally computed)\ncmds.polySetToFaceNormal()',
 'polySetVertices': '',
 'polySewEdge': "import maya.cmds as cmds\n\ncmds.polyPlane( sx=1, sy=1, n='plg1' )\ncmds.polyPlane( sx=1, sy=1, n='plg2' )\ncmds.rotate( 0, 0, 30, 'plg1' )\ncmds.rotate( 0, 0, -30, 'plg2' )\ncmds.move( -0.5, 0, 0, 'plg1', ws=True )\ncmds.move( 0.5, 0, 0, 'plg2', ws=True )\n# For the polyUnite we assume that plg1's shape node is named\n#  plg1Shape, plg2's shape node is plg2Shape, and the resulting\n#  transform is named polySurface1. One or more of these may not\n#  hold true if objects have previously been created and\n#  manipulated in the scene.\ncmds.polyUnite( 'plg1Shape', 'plg2Shape' )\ncmds.polySewEdge( 'polySurface1.e[2]', 'polySurface1.e[5]', t=0.25 )",
 'polyShortestPathCtx': "import maya.cmds as cmds\n\n# To create a new poly shortest edge path context:\n#\ncmds.polyShortestPathCtx( 'PolyViewPortShortestPath' )",
 'polySlideEdge': 'import maya.cmds as cmds\n\n# Moves the selected edge loops to the left by 50% of their neighbouring left edges\ncmds.polySlideEdge(edgeDirection=0.5, direction=1)\n\n# Moves the selected edge loops to the right by 200% of the length of the shortest neighbouring right edge\ncmds.polySlideEdge(edgeDirection=2, absolute=True)',
 'polySlideEdgeCtx': '',
 'polySmooth': "import maya.cmds as cmds\n\ncmds.polyCube( n='plg1' )\ncmds.move( -3, 0, 2 )\ncmds.polyCube( n='plg2' )\ncmds.move( -3, 0, -2 )\ncmds.polyCube( n='plg3' )\ncmds.move( 0, 0, 2 )\ncmds.delete( 'plg3.f[1]' )\ncmds.polyCube( n='plg4' )\ncmds.move( 0, 0, -2 )\ncmds.delete( 'plg4.f[1]' )\ncmds.polyCube( n='plg5' )\ncmds.move( 3, 0, 2 )\ncmds.polyCube( n='plg6' )\ncmds.move( 3, 0, -2 )\n\ncmds.polyOptions( ao=True, db=1 )\n\n# only one division:\ncmds.polySmooth( 'plg1.f[0:5]', dv=1 )\n\n# 2 divisions produces a round-ish object\ncmds.polySmooth( 'plg2.f[0:5]', dv=2 )\n\n# keep border edges\ncmds.select( 'plg3.f[0:4]' )\ncmds.polySmooth( kb=1 )\n\n# don't keep border edges\ncmds.select( 'plg4.f[0:4]' )\ncmds.polySmooth( kb=0 )\n\n# 1 division, continuity 0.2\ncmds.select( 'plg5' )\ncmds.polySmooth( c=0.2 )\n\n# 1 division, continuity 0.8\ncmds.polySmooth( 'plg6.f[0:5]', c=0.8 )",
 'polySoftEdge': "import maya.cmds as cmds\n\n# Turn smooth shading on\n# Soft and hard edges are much easier to see with smooth shading on\ncurrentPanel = cmds.getPanel(withFocus= True)\nif currentPanel != '':\n\tcmds.modelEditor(currentPanel, edit=True, da='smoothShaded', dl='default')\n\ncmds.polySphere(n= 'plg', sx= 15, sy= 10 )\n# hard bottom\ncmds.select( 'plgShape.e[0:59]', 'plgShape.e[135:194]', 'plgShape.e[255:269]', r=True )\ncmds.polySoftEdge( a=0 )\n# smooth top\ncmds.select( 'plg.e[75:134]', 'plg.e[195:254]', 'plg.e[270:284]', r=True )\ncmds.polySoftEdge( a=180 )\ncmds.select( 'plg' )\ncmds.polyOptions( ao=True, se=True )\n\n# Set display mode back to wireframe (default mode)\ncurrentPanel = cmds.getPanel(withFocus= True)\nif currentPanel != '':\n\tcmds.modelEditor(currentPanel, edit=True, da='wireframe')",
 'polySphere': 'import maya.cmds as cmds\n\n# Create a sphere, with 10 subdivisions in the X direction,\n# and 15 subdivisions in the Y direction,\n# the radius of the sphere is 20.\ncmds.polySphere(sx=10, sy=15, r=20)\n\n# Create a sphere, called "mySphere", on each direction there are 5 subdivisions.\ncmds.polySphere( n=\'mySphere\', sx=5, sy=5)\n\n# Query the radius of the new sphere\nr = cmds.polySphere( \'mySphere\', q=True, sx=True )',
 'polySphericalProjection': "import maya.cmds as cmds\n\n# Create a sphere with default UVs.\ncmds.polySphere( n='sphere', r=10 )\n\n# Create a lambert node.\ncmds.shadingNode( 'lambert', '-n', 'myLambert', asShader=True )\ncmds.sets( renderable=True, noSurfaceShader=True, empty=True, name='myLambertSG' )\ncmds.connectAttr( 'myLambert.outColor', 'myLambertSG.surfaceShader', f=True )\n\n# Create a texture checker.\ncmds.shadingNode( 'checker', asTexture=True )\ncmds.shadingNode( 'place2dTexture', asUtility=True )\ncmds.connectAttr( 'place2dTexture1.outUV', 'checker1.uv' )\n\n# Assign the texture the the lambert node.\ncmds.connectAttr( 'checker1.outColor', 'myLambert.color', f=True )\n\n# Set the textured display mode.\ncurrentPanel = cmds.getPanel(withFocus= True)\nif currentPanel != '':\n\tcmds.modelEditor(currentPanel, edit=True, da='smoothShaded', displayTextures=True, dl='default')\n\n# Assign the lambert shader to all faces of the sphere.\ncmds.sets('sphere.f[0:399]', edit=True, forceElement= 'myLambertSG' )\n\n# Replace default UVs on the top of the sphere :\n# Rotates the map of 45 degrees and reduces its aperture to 20 degrees in both directions\ncmds.polySphericalProjection( 'sphere.f[180:359]', 'sphere.f[380:399]', ra=45.0, pc=(0, 0, 0), ps=(20, 20) )\n\n# Set the wireframe display mode.\ncurrentPanel = cmds.getPanel(withFocus= True)\nif currentPanel != '':\n\tcmds.modelEditor(currentPanel, edit=True, da='wireframe')",
 'polySpinEdge': '',
 'polySplit': 'import maya.cmds as cmds\n\n# Note that in Python, you must use the ip/insertpoint flag which determines\n# whether you are splitting an edge or a face based on the number of\n# arguments to the flag (2 for an edge, and 4 for a face)\ncmds.polyCreateFacet( p=[(0, 2, 0), (0, -2, 0), (4, -2, 0), (4, 2, 0)] )\ncmds.polySplit( ip=[(2, 0.1), (3, 0.5), (0, 2, -1, 0.0), (0, 0.9)] )',
 'polySplitCtx': "import maya.cmds as cmds\n\n# Create a poly plane\ncmds.polyPlane(w=10, h=10, sx=1, sy=1, n='pPlane1')\n\n# Create a new poly split context, then switch to it\ncmds.polySplitCtx('polySplitCtx1')\ncmds.setToolTo('polySplitCtx1')",
 'polySplitCtx2': "import maya.cmds as cmds\n\n# Create a poly plane\ncmds.polyPlane(w=10, h=10, sx=1, sy=1, n='pPlane1')\n\n# Create a new poly split context, then switch to it\ncmds.polySplitCtx2('polySplitCtx2')\ncmds.setToolTo('polySplitCtx2')",
 'polySplitEdge': "import maya.cmds as cmds\n\n# An example taking a non-manifold edge and splitting it to\n# make it manifold\ncmds.polyPlane( w=1, h=1, sx=10, sy=10, ax=(0, 1, 0), cuv=1, ch=1 )\ncmds.scale( 15, 15, 15, r=True )\ncmds.move( -8, 0, 6, r=True )\n\ncmds.select( 'polyPlane1', addFirst=True )\ncmds.setAttr( 'polyPlane1.subdivisionsWidth', 3 )\ncmds.setAttr( 'polyPlane1.subdivisionsHeight', 3 )\ncmds.select( 'pPlane1.e[12]', r=True )\ncmds.polyExtrudeEdge( 'pPlane1.e[12]', ch=1, kft=0, pvx=-5.5, pvy=0.0, pvz=6.0 )\n# Result: polyExtrudeEdge1 #\ncmds.setAttr( 'polyExtrudeEdge1.localTranslate', 0, 0, 5.093611)\ncmds.select( 'pPlane1.e[12]', r=True )\ncmds.polySplitEdge(op=0)\n# Result: polySplitEdge1 #\n\n# The edge is now split..\ncmds.select( 'pPlane1.f[9]', r=True)\ncmds.move(0, 0.5, 0, r=True)\n\n\n# An example which splits loops of manifold edges\ncmds.polyPlane(w=10, h=10, sx=4, sy=4, ch=1, name='ManifoldTest')\ncmds.select('ManifoldTest.e[3]', 'ManifoldTest.e[12:15]', 'ManifoldTest.e[21]', 'ManifoldTest.e[23]', 'ManifoldTest.e[29]')\n\ncmds.polySplitEdge(operation=1)\n\ncmds.select('ManifoldTest.f[1:3]', 'ManifoldTest.f[5]', 'ManifoldTest.f[9]')\ncmds.move(0, 0, 5, r=True)\n\ncmds.select('ManifoldTest.f[0]', 'ManifoldTest.f[4]', 'ManifoldTest.f[6:8]', 'ManifoldTest.f[10:15]')\ncmds.move(0, 0, -5, r=True)",
 'polySplitRing': "import maya.cmds as cmds\n\ncmds.polyCube()\ncmds.select('pCube1.e[0:3]')\ncmds.polySplitRing( sma=180, wt=0.2)",
 'polySplitVertex': "import maya.cmds as cmds\n\n# Objective: split the four middle vertices of a 3x3 plane so\n# that the middle face can be moved seperately\n\n# Create a 3x3 plane\n#\ncmds.polyPlane( sx=3, sy=3, name='polyPlane' )\n# Result: polyPlane polyPlane1\n\n# Count the number of vertices we start out with\n#\ncmds.polyEvaluate( 'polyPlane', vertex=True )\n# Result: 16\n\n# Split the four middle vertices\n#\ncmds.polySplitVertex( 'polyPlane.vtx[5]', 'polyPlane.vtx[6]', 'polyPlane.vtx[9]', 'polyPlane.vtx[10]' )\n# Result: polySplitVert1\n\n# Count the number of vertices we have now\n#\ncmds.polyEvaluate( 'polyPlane', vertex=True )\n# Result: 28\n\n# Note that because we split the 4 middle vertices, the 8\n# surrounding faces have become non-manifold",
 'polyStraightenUVBorder': "import maya.cmds as cmds\n\n# Create a plane and select it.\ncmds.polyPlane()\ncmds.select( 'pPlane1.map[0:65]', r=True )\n\n# Straighten half the border\ncmds.polyStraightenUVBorder()",
 'polySubdivideEdge': "import maya.cmds as cmds\n\ncmds.polyCube( n='plg', w=5, h=5, d=5 )\ncmds.scale( 2, 2, 2 )\ncmds.select( 'plg' )\ncmds.polyOptions( ao=True, dv='true' )\ncmds.select( cl=True )\n\n# Simple subdivision\ncmds.select( 'plg.e[1]' )\ncmds.polySubdivideEdge( dv=4 )\n# The selected edges are subdivided by 4 vertices (5 subedges).\n\n# Local bound\ncmds.select( 'plg.e[7]' )\ncmds.polySubdivideEdge( dv=4, s=1.5 )\n# The length of each subedge must be greater or equal to 1.5\n# in local space. Length of original edge is 5 in local space.\n# Min size indicates that only 3 subedges can be created.\n\n# World bound\ncmds.select( 'plg.e[5]' )\ncmds.polySubdivideEdge( dv=4, s=2, ws=True )\n# The length of each subedge has to be greater or equal to 2\n# in world space. Length of original edge is 10 in world space.\n# All required subdivisions are done.",
 'polySubdivideFacet': "import maya.cmds as cmds\n\ncmds.polyPlane( n='plg', w=10, h=10, sx=1, sy=3 )\n\n# Quads\ncmds.polySubdivideFacet( 'plg.f[0]', dv=2 )  # becomes 16 quads.\n\n# Triangles\ncmds.polySubdivideFacet( 'plg.f[2]', dv=1, m=1 )  # becomes 4 triangles",
 'polySuperCtx': '',
 'polyTestPop': '',
 'polyToCurve': '',
 'polyToSubdiv': "import maya.cmds as cmds\n\n# To create a new subdivision surface from a polygon:\ncmds.polyToSubdiv( 'polySphere1' )\n\n# To create a new subdivision surface from a polygon with history so that\n# the tesselation can be edited afterwards:\ncmds.polyToSubdiv( 'polySphere1', ch=True )",
 'polyTorus': "import maya.cmds as cmds\n\ncmds.polyTorus( sx=8, sy=16, r=10, sr=1 )\n#result has 8 sections of 16 segments,\n#the main radius is 10, the section radius is 1.\n\ncmds.polyTorus( sx=5, sy=4, tx=False )\ncmds.move( -3, 0, 0 )\n#result has 5 sections of 4 segments, default sizes.\n#no texture offsets are generated.\n\ncmds.polyTorus( sx=5, sy=4, tw=45 )\ncmds.move( 3, 0, 0 )\n#result has 5 sections of 4 segments, default sizes.\n#The sections are rotated.\n\n#Query the radius of the torus\nr = cmds.polyTorus( 'polyTorus1' ,q=True, r=True )",
 'polyTransfer': "import maya.cmds as cmds\n\n# Create two objects with same a cube.\ncmds.polyCube( sx=5, sy=5, sz=5, n='plg' )\ncmds.polyCube( sx=5, sy=5, sz=5, n='atlPlg' )\n\n# Tweak the geometry of the first object\ncmds.select( 'plg.vtx[0:50]', r=True )\ncmds.move( .1, .2, .3, r=True )\n\n# Spherical mapping on the alternate object\ncmds.polyProjection( 'atlPlg.f[0:149]', type='Spherical' )\n\n# Copy the UVs from the alternate to the first object.\ncmds.polyTransfer( 'plg', uv=1, ao='atlPlg' )",
 'polyTriangulate': "import maya.cmds as cmds\n\n# Non-planar faces\ncmds.polyPlane( n='plg1', sx=5, sy=5, w=5, h=5 )\ncmds.move( -6, 0, 0 )\ncmds.polyMoveVertex( 'plg1.vtx[7]', 'plg1.vtx[10]', 'plg1.vtx[25]', 'plg1.vtx[28]', ltz=1 )\ncmds.polyTriangulate( 'plg1.f[0:1]', 'plg1.f[5:6]', 'plg1.f[3:4]', 'plg1.f[8:9]', 'plg1.f[15:16]', 'plg1.f[20:21]', 'plg1.f[18:19]', 'plg1.f[23:24]' )\n\n# Holed faces\nmaya.cmds.polyCreateFacet( p=[(2.5, 0, 2.5), (2.5, 0, -2.5), (-2.5, 0, -2.5), (-2.5, 0, 2.5), (), (1, 0, -1), (-1, 0, -1), (-1, 0, 1), (1, 0, 1)],  n='plg2' )\ncmds.polyTriangulate( 'plg2.f[0]' )\n\n# Both holed and non-planar facets\ncmds.polyPlane( n='plg3', sx=3, sy=3, h=5, w=5 )\ncmds.move( 6, 0, 0 )\ncmds.polyChipOff( 'plg3.f[4]', dup=1, ltz=1, ls=(.25, .25, .25) )\ncmds.polyMergeFacet( 'plg3', ch=True, ff=4, sf=9 )\ncmds.polyTriangulate( 'plg3.f[4]' )",
 'polyUVCoverage': "import maya.cmds as cmds\n\n# Return UV coverage from selection list\ncmds.polyUVCoverage()\n# Result: [0.3799999952316284] #\n\n# Return UV coverage from specified components with specified range\ncmds.polyUVCoverage('pCube1.f[0:5]', usr=(0,0,2,2));\n# Result: [0.09749999642372131] #",
 'polyUVOverlap': "import maya.cmds as cmds\n\n# Return UV overlapping components from selection list\ncmds.polyUVOverlap( oc=True )\n# Result: [pCubeShape1.f[1], pCubeShape1.f[2]] #\n\n# Return UV non-overlapping components from specified components\ncmds.polyUVOverlap('pCube1.f[0:5]', noc=True)\n# Result: [pCubeShape1.f[0], pCubeShape1.f[3], pCubeShape1.f[4], pCubeShape1.f[5]] #",
 'polyUVRectangle': "import maya.cmds as cmds\n\n# Opening up the textureView will make this example much easier to visualize.\n\n# make a cylinder\ncmds.polyCylinder( r=1, h=2, sx=20, sy=10, sz=1, ax=(0,1,0), rcp=0, cuv=3, ch=1 )\n\n# map a 3x2 area of faces to the 0-1 UV square\ncmds.polyUVRectangle( 'pCylinderShape1.vtx[115]', 'pCylinderShape1.vtx[57]' )\n\n# map a 2x20 ring of faces to the 0-1 UV square\ncmds.polyUVRectangle( 'pCylinderShape1.vtx[136]', 'pCylinderShape1.vtx[176]' )",
 'polyUVSet': 'import maya.cmds as cmds\n\n\n# start with poly object\ncmds.polySphere(n=\'plg\', cuv=1, r=10.0)\n\n# Make a copy of "map1" to a new uvset. The\n# name of which is automatically generated and returned.\ncmds.polyUVSet( copy=True, uvSet=\'map1\' )\n\n# Create a new empty uv set\ncmds.polyUVSet( create=True, uvSet=\'map2\' )\n\n# To set the current uv set to be "map2".\ncmds.polyUVSet( currentUVSet=True,  uvSet=\'map2\')\n\n# To set the current uv set to the last uv set added to an object.\ncmds.polyUVSet( currentLastUVSet=True )\n\n# To query the current uv set.\ncmds.polyUVSet( query=True, currentUVSet=True )\n\n# To rename a currently existing uv set from "map2" to "map3".\ncmds.polyUVSet(rename=True, newUVSet=\'map3\', uvSet= \'map2\')\n\n# Rename the current uv set (if any) to "map4".\ncmds.polyUVSet(rename=True, newUVSet=\'map4\' )\n\n# To delete a currently existing uv set "map4".\ncmds.polyUVSet( delete=True, uvSet=\'map4\')\n\n# To delete the current uv set (if any)\ncmds.polyUVSet( delete=True )\n\n# Copy values of uvset "map1" to "map2"\ncmds.polyUVSet( copy=True, nuv=\'map2\', uvSet=\'map1\' )\n\n# Copy values of the current uvset to "map2"\ncmds.polyUVSet( copy=True, nuv=\'map2\' )\n\n# Reorder uvsets "map1" and "map2"\ncmds.polyUVSet( reorder=True, nuv=\'map2\', uvSet=\'map1\' )\n\n# Create a new empty uv set with a generate new name\n# The newly generated name is returned.\ncmds.polyUVSet( create=True )\n\n# To query all of the uv sets\ncmds.polyUVSet( query=True, allUVSets=True )\n\n# To query the logical indices of the uv sets in the\n# uv set array of the node\nnode = "plg"\nindices = cmds.polyUVSet(node, query=True, allUVSetsIndices=True)\n\nfor i in indices[:]:\n\tname = cmds.getAttr(node+".uvSet["+str(i)+"].uvSetName")\n\tprint("Found uv set called " + name )\n\n# To create a new per-instance uv set named "myMap"\ncmds.polyUVSet(create=True,perInstance=True,uvSet=\'myMap\');',
 'polyUVStackSimilarShells': 'import maya.cmds as cmds\n\n// Stack Similar UV Shells with tolerance.\ncmds.polyUVStackSimilarShells(to = 0.001)',
 'polyUVStackSimilarShellsCmd': '',
 'polyUnite': "import maya.cmds as cmds\n\ncmds.polySphere( n='plg1' )\ncmds.polyCube( w=2, h=.2, d=2, n='plg2' )\ncmds.move( 0, -1.1, 0 )\ncmds.polyCube( w=2, h=.2, d=2, n='plg3' )\ncmds.move( 0, 1.1, 0 )\ncmds.polyUnite( 'plg1', 'plg2', 'plg3', n='result' )\ncmds.rotate( 0, 0, 90, 'result' )",
 'polyUniteSkinned': "import maya.cmds as cmds\n\ncmds.polyUniteSkinned( 'pSphere1', 'pSphere2', ch=0 )",
 'polyUnsmooth': "import maya.cmds as cmds\n\n# Create a default Maya cube:\ncmds.polyCube()\ncmds.polyEvaluate( 'pCube1', face=True )\n# Result: 6\n\n# Run Catmull-Clark subdivision 4 times to create a higher poly count object, and then\n# delete construction history.\ncmds.polySmooth( 'pCube1', dv=4 )\ncmds.delete( 'pCube1', ch=True )\ncmds.polyEvaluate( 'pCube1', face=True )\n# Result: 1536\n\n# Attempt to figure out the lowest original level before Catmull-Clark subdivision was run.\ncmds.polyUnsmooth( 'pCube1', divisionLevels=4 )\ncmds.polyEvaluate( 'pCube1', face=True )\n# Result: 6",
 'polyVertexNormalCtx': '',
 'polyWarpImage': '',
 'polyWedgeFace': "import maya.cmds as cmds\n\ncmds.polyPlane( n='plg', w=10, h=10 )\n\n# Wedge about a single axis\ncmds.polyWedgeFace( 'plg.f[24:29]', 'plg.f[34]', 'plg.f[44]', 'plg.f[54]', 'plg.f[64]', 'plg.f[74:79]', ws=1, wedgeAngle=90, divisions=8, ed=(62,167), ch=1 )\n\n# Wedge about multiple axes (one axis for each command)\ncmds.polyCube( n='plg', w=1, h=1, d=1, sx=4, sy=4, sz=4, ax=(0, 1, 0), tx=1, ch=1 )\ncmds.polyWedgeFace( 'plg.f[64:79]', ws=1, wedgeAngle=90, divisions=9, ed=(128, 133, 138, 143), ch=1 )\ncmds.polyWedgeFace( 'plg.f[0:15]', ws=1, wedgeAngle=90, divisions=9, ed=(0, 1, 2, 3), ch=1 )\ncmds.polyWedgeFace( 'plg.f[80:95]', ws=1, wedgeAngle=90, divisions=9, ed=(100, 105, 110, 115), ch=1 )\ncmds.polyWedgeFace( 'plg.f[32:47]', ws=1, wedgeAngle=90, divisions=9, ed=(36, 37, 38, 39), ch=1 )",
 'popupMenu': "import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout()\ncmds.button()\ncmds.popupMenu()\ncmds.menuItem()\ncmds.menuItem()\ncmds.menuItem()\ncmds.text()\ncmds.popupMenu( button=1 )\ncmds.menuItem()\ncmds.menuItem()\ncmds.menuItem()\ncmds.checkBox( 'aCheckBox' )\ncmds.popupMenu( parent='aCheckBox', alt=True, ctl=True )\ncmds.menuItem()\ncmds.menuItem()\ncmds.menuItem()\ncmds.showWindow()",
 'pose': 'import maya.cmds as cmds\n\n# First, create a character to hold the pose. The character will be\n# a 3-bone skeleton named "arm".\n#\ncmds.select( d=True )\ncmds.joint( p=(0, 0, 0) )\ncmds.joint( p=(0, 4, 0) )\ncmds.joint( \'joint1\', e=True, zso=True, oj=\'xyz\' )\ncmds.joint( p=(0, 8, -1) )\ncmds.joint( \'joint2\', e=True, zso=True, oj=\'xyz\' )\ncmds.joint( p=(0, 9, -2) )\ncmds.joint( \'joint3\', e=True, zso=True, oj=\'xyz\' )\ncmds.select( \'joint2\', \'joint3\', \'joint1\', r=True )\ncmds.character( name=\'arm\' )\n\n\n# Create a pose for the current joint position named "handWave"\n#\ncmds.pose( \'arm\', name=\'handWave\' )\n\n# Query the existing poses\n#\ncmds.pose( \'arm\', query=True, n=True )\n\n# Restore the pose onto the character\n#\ncmds.pose( \'arm\', name=\'handWave\', apply=True )',
 'poseEditor': "import maya.cmds as cmds\n\ncmds.poseEditor( 'poseEd' )",
 'posePanel': "import maya.cmds as cmds\n\ncmds.posePanel( 'pP' )",
 'preferredRenderer': 'import maya.cmds as cmds\n\n# To set the preferred renderer to a renderer called "myRenderer":\n#\ncmds.preferredRenderer( \'myRenderer\' )\n\n# To query the preferred renderer\n#\ncmds.preferredRenderer( query=True )\n\n# To set the current renderer as the preferred one\n#\ncmds.preferredRenderer( makeCurrent=True )\n\n# To set the preferred fallback renderer\n#\ncmds.preferredRenderer( fallback=\'myRenderer\' )',
 'preloadRefEd': 'import maya.cmds as cmds\n\nwindow = cmds.window()\ncmds.paneLayout()\ncmds.preloadRefEd()\ncmds.showWindow(window)',
 'prepareRender': "import maya.cmds as cmds\n\n\n# Query what the default render traversal set is.\ncmds.prepareRender(query=True, defaultTraversalSet=True)\n\n# Set the render traversal set to 'MyPrepareRender'.\ncmd.prepareRender(edit=True, defaultTraversalSet='MyPrepareRender')\n\n# Set the preRender traversal to the adskPrepareRender.preRender function,\n# for the default render traversal set.\ncmd.prepareRender(edit=True, preRender=adskPrepareRender.preRender)\n\n# Set the default render traversal set to require saving the assembly node\n# configuration before render, and restore it once rendering completes.\ncmd.prepareRender(edit=True, saveAssemblyConfig=True)\n\n# Set the label of traversal set 'MyPrepareRender' to be 'Custom Render'.\ncmd.prepareRender(edit=True, label='Custom Render', traversalSet='MyPrepareRender')",
 'profiler': 'import maya.cmds as cmds\n\n# Start profiling\ncmds.profiler(sampling = True)\n\n# Wait for events to be profiled\n# Stop profiling\ncmds.profiler(sampling = False)\n\n# Output the result to a file\ncmds.profiler(output = "test.txt")\n\n# Load a recording from a file to the buffer\ncmds.profiler(load = "test.txt")\n\n# Reset the tool\ncmds.profiler(reset = True)\n\n# Set the profiler\'s buffer size to fit 5 megaBytes\ncmds.profiler(bufferSize = 5)\n\n# Query the profiler\'s buffer size\ncmds.profiler(query = True, bufferSize = True)\n\n# Add a new category\ncmds.profiler(addCategory = "Test Category", categoryInfo="Events related to my special test")\n\n# Remove an existing category\ncmds.profiler(removeCategory = "Test Category")\n\n# Query the number of categories\ncmds.profiler(query = True, categoryCount = True)\n\n# Query the name of the category at the given index\ncmds.profiler(query = True, categoryIndexToName = 5)\n\n# Query the info of the category at the given index\ncmds.profiler(query = True, categoryIndex = 5, categoryInfo = True)\n\n# Query the index of the category with the given name\ncmds.profiler(query = True, categoryNameToIndex = "Maya Qt")\n\n# Query the info of the category with the given name\ncmds.profiler(query = True, categoryName = "Maya Qt", categoryInfo = True)\n\n# Query if it is enabled for the recording of the category at the given index\ncmds.profiler(query = True, categoryRecording = True, categoryIndex = 5)\n\n# Query if it is enabled for the recording of the category with the given name\ncmds.profiler(query = True, categoryRecording = True, categoryName = "Maya Qt")\n\n# Enable/Disable the recording of the category at the given index\ncmds.profiler(categoryRecording = False, categoryIndex = 5)\n\n# Query the number of the events in the buffer\ncmds.profiler(query = True, eventCount = True)\n\n# Query the time at which the event at the given index start\ncmds.profiler(query = True, eventStartTime = True, eventIndex = 100)\n\n# Query the duration of the event at the given index\ncmds.profiler(query = True, eventDuration = True, eventIndex = 100)\n\n# Query the name of the event at the given index\ncmds.profiler(query = True, eventName = True, eventIndex = 100)\n\n# Query the description of the event at the given index\ncmds.profiler(query = True, eventDescription = True, eventIndex = 100)\n\n# Query the category the the event at the given index belongs to\ncmds.profiler(query = True, eventCategory = True, eventIndex = 100)\n\n# Query the color of the event at the given index\ncmds.profiler(query = True, eventColor = True, eventIndex = 100)\n\n# Query the thread ID of the event at the given index\ncmds.profiler(query = True, eventThreadId = True, eventIndex = 100)\n\n# Query the CPU ID of the event at the given index\ncmds.profiler(query = True, eventCPUId = True, eventIndex = 100)\n\n# Query if the event at the given index is a signal event\ncmds.profiler(query = True, signalEvent = True, eventIndex = 100)',
 'profilerTool': 'import maya.cmds as cmds\n\n\n#First record/load a profile\n#Frame the tool\'s view on all recorded events.\ncmds.profilerTool( edit = True, frameAll = True )\n\n#Frame selected events\ncmds.profilerTool( edit = True, frameSelected = True )\n\n#Change to cpu view\ncmds.profilerTool( edit = True, cpuView = True )\n\n#Show only selected events\ncmds.profilerTool( edit = True, showSelectedEvents = True )\n\n#Show all events\ncmds.profilerTool( edit = True, showAllEvent = True )\n\n#Hide all events that have same comment as selected events\ncmds.profilerTool( edit = True, showSelectedEventsRepetition = False )\n\n#Show hotspot\ncmds.profilerTool( edit = True, showHotspot = True )\n\n#Find all events whose name contains "abc"\ncmds.profilerTool( query = True, searchEvent = "abc" )\n\n#Find the first event, whose name exactly matches with "def", next to current selected event\ncmds.profilerTool( edit = True, matchWholeWord = True )\ncmds.profilerTool( query = True, searchEvent = "def", findNext = True )\n\n#Query the active event types\ncmds.profilerTool( query = True, eventTypes = True )\n\n#Query segment count in buffer\ncmds.profilerTool( query = True, segmentCount = True )\n\n#Isolate the first segment\ncmds.profilerTool( edit = True, isolateSegment = 0 )\n\n#Unisolate segment\ncmds.profilerTool( edit = True, unisolateSegment = True )',
 'progressBar': "import maya.cmds as cmds\n\n# Create a custom progressBar in a windows ...\n\nwindow = cmds.window()\ncmds.columnLayout()\n\nprogressControl = cmds.progressBar(maxValue=10, width=300)\ncmds.button( label='Make Progress!', command='cmds.progressBar(progressControl, edit=True, step=1)' )\n\ncmds.showWindow( window )\n\n# Or, to use the progress bar in the main window ...\n\nimport maya.mel\ngMainProgressBar = maya.mel.eval('$tmp = $gMainProgressBar')\n\ncmds.progressBar( gMainProgressBar,\n\t\t\t\tedit=True,\n\t\t\t\tbeginProgress=True,\n\t\t\t\tisInterruptable=True,\n\t\t\t\tstatus='Example Calculation ...',\n\t\t\t\tmaxValue=5000 )\n\nfor i in range(5000) :\n\tif cmds.progressBar(gMainProgressBar, query=True, isCancelled=True ) :\n\t\tbreak\n\n\tcmds.progressBar(gMainProgressBar, edit=True, step=1)\n\ncmds.progressBar(gMainProgressBar, edit=True, endProgress=True)",
 'progressWindow': "import maya.cmds as cmds\n\n# +-+------------------+\n# |-|  Doing Nothing   |\n# +--------------------+\n# | Sleeping: 40%      |\n# |                    |\n# | +----------------+ |\n# | |||||||          | |\n# | +----------------+ |\n# |                    |\n# | Hit ESC to Cancel  |\n# +--------------------+\n\n# Always use the progress dialog from a script, never directly\n# from the Script Editor.\n\namount = 0\n\ncmds.progressWindow(\ttitle='Doing Nothing',\n\t\t\t\t\tprogress=amount,\n\t\t\t\t\tstatus='Sleeping: 0%',\n\t\t\t\t\tisInterruptable=True )\nwhile True :\n\t# Check if the dialog has been cancelled\n\tif cmds.progressWindow( query=True, isCancelled=True ) :\n\t\tbreak\n\n\t# Check if end condition has been reached\n\tif cmds.progressWindow( query=True, progress=True ) >= 100 :\n\t\tbreak\n\n\tamount += 5\n\n\tcmds.progressWindow( edit=True, progress=amount, status=('Sleeping: ' + `amount` + '%' ) )\n\n\tcmds.pause( seconds=1 )\n\ncmds.progressWindow(endProgress=1)",
 'projectCurve': "import maya.cmds as cmds\n\n# Project the active curve onto the active surface using the surface\n# normals:\ncmds.projectCurve( un=True )\n\n# Project this curve onto the nurbs sphere using the specified direction:\ncmds.projectCurve( 'curve1', 'nurbsSphere1', d=(0.0, 6.0, 0.0) )",
 'projectTangent': "import maya.cmds as cmds\n\n# Do project tangent with curvature continuity between a curve and a\n# nurbs plane surface\ncmds.projectTangent( 'curve1', 'nurbsPlane1', c=True )\n\n# Do project tangent between the 3 curves and tangent align the curve\n# with the reverse tangent of the second of the other 2 curves\n# (i.e. with curve3)\ncmds.projectTangent( 'curve1', 'curve2', 'curve3', td=2, rt=True )",
 'projectionContext': '',
 'projectionManip': 'import maya.cmds as cmds\n\ncmds.projectionManip( fb=True )\ncmds.projectionManip( pt=3 )',
 'promptDialog': "import maya.cmds as cmds\n\n# Create an OK/Cancel prompt dialog.\n#\n# +-+---------------------+\n# |-|    Rename Object    |\n# +-----------------------+\n# | Enter Name:           |\n# | +-------------------+ |\n# | |                   | |\n# | |                   | |\n# | +-------------------+ |\n# +-----------------------+\n# | +-------+  +--------+ |\n# | |  OK   |  | Cancel | |\n# | +-------+  +--------+ |\n# +-----------------------+\n#\n\nresult = cmds.promptDialog(\n\t\ttitle='Rename Object',\n\t\tmessage='Enter Name:',\n\t\tbutton=['OK', 'Cancel'],\n\t\tdefaultButton='OK',\n\t\tcancelButton='Cancel',\n\t\tdismissString='Cancel')\n\nif result == 'OK':\n\ttext = cmds.promptDialog(query=True, text=True)",
 'propModCtx': "import maya.cmds as cmds\n\n# Edit type of propmod context.\ncmds.propModCtx( 'PropMod', e=True, t=1 )\n\n# Activate propmod context.\ncmds.setToolTo( 'PropMod' )\n\n# Change the type and dropoff.\ncmds.propModCtx( 'PropMod', e=True, d=(0, 1, 0) )",
 'propMove': 'import maya.cmds as cmds\n\ncmds.propMove( 3, 6, 0, \'surface1\', \'surface2\', \'surface3\', \'surface4\', \'surface5\', \'surface6\', \'surface7\', p=[0.1, 0.5, 0.7, 1.0, 0.7, 0.5, 0.1] )\n# This performs a proportional translate of (3,6,0) on seven surfaces.\n# Note that there are 7 "-p" flags, one for each surface.\n\ncmds.propMove( \'surface1\', \'surface2\', \'surface3\', \'surface4\', \'surface5\', \'surface6\', \'surface7\', p=[0.1, 0.5, 0.7, 1.0, 0.7, 0.5, 0.1], pivot=(1, 1, 1), s=(3, 3, 3) )\n# This performs a proportional scale of (3,3,3) on seven surfaces.\n# Note that there are 7 "-p" flags, one for each surface. The scale\n# happened about the specified pivot (1,1,1).\n\ncmds.propMove( \'surface1\', \'surface2\', \'surface3\', \'surface4\', \'surface5\', \'surface6\', \'surface7\', p=[0.1, 0.5, 0.7, 1.0, 0.7, 0.5, 0.1], r=(30, 60, 90) )\n# This performs a proportional rotate of (30,60,90) on seven surfaces.\n# Note that there are 7 "-p" flags, one for each surface.\n\ncmds.propMove( \'surface1\', \'surface2\', \'surface3\', \'surface4\', \'surface5\', \'surface6\', \'surface7\', px=[0.1, 0.5, 0.7, 1.0, 0.7, 0.5, 0.1], r=(30, 60, 90) )\n# This performs a proportional rotate of (30,60,90) on seven surfaces.\n# The percentages are only applied on the rotation 30 about the X axis. The\n# percentages along Y and Z are  1.0. Note that there are 7 "-px" flags, one\n# for each surface. The surfaces are rotated by 60, 90 in Y and Z.',
 'proximityWrap': "import maya.cmds as cmds\n\n# Add drivers to the proximityWrap\ncmds.proximityWrap('proximityWrap1', edit=True, addDrivers=['driverShape1', 'driverShape2'])\n\n# Add driver to the proximityWrap and skip setting the initial attributes\ncmds.proximityWrap('proximityWrap1', edit=True, applyUserDefaults=True, addDrivers=['driverShape2'])\n\n# Remove drivers\ncmds.proximityWrap('proximityWrap1', edit=True, removeDrivers=['driverShape1', 'driverShape2')\n\n# List driver indices (returns [0, 1])\ncmds.proximityWrap('proximityWrap1', query=True, driverIndices=True)\n\n# List free driver index (returns 2)\ncmds.proximityWrap('proximityWrap1', query=True, freeDriverIndex=True)\n\n# Query can be added\ncmds.proximityWrap('proximityWrap1', query=True, canBeAdded=['driverShape1'])\n\n# Dump info\ncmds.proximityWrap('proximityWrap1', query=True, dumpInfo= proximityWrap1)",
 'psdChannelOutliner': "import maya.cmds as cmds\n\ncmds.window()\ncmds.formLayout()\ncmds.psdChannelOutliner('materialList', height=175, psdParent='lambert1',\n                        addChild=(('color', ''), ('diffuse', ''), ('transparency', '')) )\ncmds.showWindow()",
 'psdConvSolidTxOptions': '',
 'psdEditTextureFile': 'import maya.cmds as cmds\n\n# Create a Photoshop file with an image layer from a disk image file\ncmds.psdTextureFile(xr=512, yr=512, ifn=(\'C:\\\\tex.jpg\', \'layerSet1\', 1), psf=\'C:\\\\final.psd\')\n# // Saved file: C:\\final.psd #\n\n# Create a poly plane\ncmds.polyPlane(w=10, h=10, sx=10, sy=10, n=\'pPlane1\')\ncmds.select(\'pPlane1\')\n\n# Create a snapshot file containing the UVs of pPlane1\ncmds.uvSnapshot(n=\'C:\\\\uvSnapshot.iff\', xr=512, yr=512, o=True)\n# // Saved file: C:\\uvSnapshot.iff #\n\n# Edit the "final.psd" file which we have created, add a UV snapshot layer from snapshot file and an image layer from disk image file\ncmds.psdEditTextureFile(aci=(\'layerSet2\', \'C:\\\\tex1.jpg\'), ssi=\'C:\\\\uvSnapshot.iff\', uvt=1, psf=\'C:\\\\final.psd\')',
 'psdExport': 'import maya.cmds as cmds\n\n# Write the layer set 1 of psd file as 16 bit tif file\ncmds.psdExport( ifn=\'/tmp/test.psd\', ofn=\'/tmp/test.set1.tif\', lsn=\'Set 1\', format=\'tif\', bpc=2 )\n\n# Query if the layer set "Set 2" is empty.\ncmds.psdExport( ifn=\'/tmp/test.psd\', lsn=\'Set 2\', q=True, els=True )',
 'psdTextureFile': "import maya.cmds as cmds\n\n# Create a poly plane\ncmds.polyPlane(w=10, h=10, sx=10, sy=10, n='pPlane1')\ncmds.select('pPlane1')\n\n# Create a snapshot file containing the UVs of pPlane1\ncmds.uvSnapshot(n='C:\\\\uvSnapshot.iff', xr=512, yr=512, o=True)\n# // Saved file: C:\\uvSnapshot.iff #\n\n# Create a Photoshop file containing a UV snapshot layer from UV snapshot file we have just created and an image layer from a disk image file\ncmds.psdTextureFile(xr=512, yr=512, ifn=('C:\\\\tex.jpg', 'layerSet1', 1), ssi='C:\\\\uvSnapshot.iff', uvt=1, psf='C:\\\\final.psd')\n# // Saved file: C:\\final.psd #",
 'python': '',
 'querySubdiv': "import maya.cmds as cmds\n\n# find all tweaked verticies at current level\ncmds.querySubdiv( a=1 )\n\n# find all tweaked verticies one level finer than current level\ncmds.querySubdiv( a=1, l=1, r=True )\n\n# find all creased verticies at current level\ncmds.querySubdiv( a=2 )\n\n# find all creased edges at current level\ncmds.querySubdiv( a=3 )\n\n# find all faces at current level.\n# You should work with the subdivision surface shape.\n#\ncmds.querySubdiv( 'subdivShape1', a=4 )\n\n# find all faces at level 1.\n#\ncmds.querySubdiv( 'subdivShape1', a=4, level=1, relative=False )\n\n# find all faces at the next finest level from the current one.\n#\ncmds.querySubdiv( 'subdivShape1', a=4, level=1, relative=True )",
 'quit': 'import maya.cmds as cmds\n\ncmds.quit()\ncmds.quit(force=True)',
 'radial': 'import maya.cmds as cmds\n\ncmds.radial( \'particle1\', m=5.0, mxd=2.0 )\n# Creates a radial field with magnitude 5.0 and maximum distance 2.0,\n# and adds it to the list of fields particle1 owns.\n\ncmds.radial( pos=(2, 0, 4 ))\n# Creates a radial field at position (0,2,4) in world coordinates,\n# with default magnitude(1.0), attentuation (1.0),\n# and max distance (5.0).\n\ncmds.radial( \'radialField1\', e=True, att=0.98 )\n# Edits the attenuation value of the field named radialField1\n\ncmds.radial( \'radialField1\', q=True, m=True )\n# Queries radialField1 for its magnitude.\n\ncmds.radial( \'radialField1\', e=True, mxd=10.0 )\n# Changes the maximum distance of the field called\n# "radialField1" to 10.0.\n\ncmds.radial( m=2.0 )\n# Creates a radial field with magnitude 2.0 for every active selection.\n# If no there are active\n# selections, creates such a field at world position (0,0,0).',
 'radioButton': "import maya.cmds as cmds\n\ncmds.window( width=150 )\ncmds.columnLayout( adjustableColumn=True )\ncmds.radioCollection()\ncmds.radioButton( label='One' )\ncmds.radioButton( label='Two' )\ncmds.radioButton( label='Three' )\ncmds.radioButton( label='Four' )\ncmds.showWindow()",
 'radioButtonGrp': "import maya.cmds as cmds\n\n#    Create a window with two separate radio button groups.\n#\nwindow = cmds.window()\ncmds.columnLayout()\ncmds.radioButtonGrp( label='Three Buttons', labelArray3=['One', 'Two', 'Three'], numberOfRadioButtons=3 )\ncmds.radioButtonGrp( label='Four Buttons', labelArray4=['I', 'II', 'III', 'IV'], numberOfRadioButtons=4 )\ncmds.showWindow( window )\n\n#    Create a window with two radio button groups that are\n#    linked together.\n#\nwindow = cmds.window()\ncmds.columnLayout()\ngroup1 = cmds.radioButtonGrp( numberOfRadioButtons=3, label='Colors', labelArray3=['Red', 'Blue', 'Green'] )\ncmds.radioButtonGrp( numberOfRadioButtons=3, shareCollection=group1, label='', labelArray3=['Yellow', 'Orange', 'Purple'] )\ncmds.showWindow( window )",
 'radioCollection': "import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout( adjustableColumn=True, rowSpacing=10 )\ncmds.frameLayout( label='Colors' )\ncmds.columnLayout()\ncollection1 = cmds.radioCollection()\nrb1 = cmds.radioButton( label='Red' )\nrb2 = cmds.radioButton( label='Blue' )\nrb3 = cmds.radioButton( label='Green' )\ncmds.setParent( '..' )\ncmds.setParent( '..' )\n\ncmds.frameLayout( label='Position' )\ncmds.columnLayout()\ncollection2 = cmds.radioCollection()\nrb4 = cmds.radioButton( label='Top' )\nrb5 = cmds.radioButton( label='Middle' )\nrb6 = cmds.radioButton( label='Bottom' )\ncmds.setParent( '..' )\ncmds.setParent( '..' )\n\ncmds.radioCollection( collection1, edit=True, select=rb2 )\ncmds.radioCollection( collection2, edit=True, select=rb6 )\ncmds.showWindow()",
 'radioMenuItemCollection': "import maya.cmds as cmds\n\ncmds.window( menuBar=True )\ncmds.menu( label='Position' )\ncmds.radioMenuItemCollection()\ncmds.menuItem( label='Top', radioButton=False )\ncmds.menuItem( label='Middle', radioButton=False )\ncmds.menuItem( label='Bottom', radioButton=True )\ncmds.menu( label='Number' )\ncmds.radioMenuItemCollection()\ncmds.menuItem( label='One', radioButton=True )\ncmds.menuItem( label='Two', radioButton=False )\ncmds.menuItem( label='Three', radioButton=False )\ncmds.showWindow()",
 'rampColorPort': "import maya.cmds as cmds\n\nramp = cmds.createNode('ramp')\ncmds.window()\ncmds.columnLayout()\ncmds.rampColorPort( node=ramp )\ncmds.showWindow()",
 'rampWidget': '',
 'rampWidgetAttrless': '',
 'rangeControl': "import maya.cmds as cmds\n\n# This will create a window with a scrollable playback range control. The initial\n# range is set up to be from 0 to 30, and the maximum values the\n# slider can access are 0 to 60.  Dragging the control's slider sets the\n# 30-frame-long playback range within the bounded values of\n# 0 to 60.\n#\ncmds.window()\ncmds.frameLayout( lv=False )\ncmds.playbackOptions( minTime=0, maxTime=30 )\ncmds.rangeControl( 'myRangeSlider', minRange=0, maxRange=60 )\ncmds.showWindow()",
 'readPDC': '',
 'readTake': "import maya.cmds as cmds\n\n#    Read data info the clock device and apply.\ncmds.readTake( device='clock', take='clock.mov' )\ncmds.applyTake( device='clock' )",
 'rebuildCurve': "import maya.cmds as cmds\n\n# rebuild curve to 5 uniform spans\ncmds.rebuildCurve( rt=0, s=5 )\n\n# rebuild curve by reducing redundant spans\ncmds.rebuildCurve( rt=1 )\n\n# rebuild curve by matching the parameterization of another curve\n# curve1 is the curve to rebuild\n# curve2 is the reference curve\ncmds.rebuildCurve( 'curve1', 'curve2', rt=2 )\n\n# rebuild curve by removing all multiple interior knots\ncmds.rebuildCurve( rt=3 )\n\n# rebuild curve using the curvature of the curve\n# to create more spans where curvature is higher\ncmds.rebuildCurve( rt=4 )",
 'rebuildSurface': "import maya.cmds as cmds\n\n# rebuild the surface using uniform parameterization\n# The rebuilt surface will have 5 spans in u and\n# 10 spans in v\ncmds.rebuildSurface( rt=0, dir=2, su=5, sv=10 )\n\n# rebuild the surface by removing its redundant spans\ncmds.rebuildSurface( rt=1 )\n\n# rebuild the surface by matching the u parameterization\n# of another surface. surface1 is the surface to rebuild\n# surface2 is the reference surface\ncmds.rebuildSurface( 'surface1', 'surface2', rt=2, dir=0 )\n\n# rebuild the surface by removing all multiple interior knots\ncmds.rebuildSurface( rt=3 )\n\n# rebuild the surface using uniform parameterization\ncmds.rebuildSurface( rt=4 )",
 'recordAttr': "import maya.cmds as cmds\n\n# This command will setup the translateX and translateY\n# attributes for recording.\ncmds.recordAttr( at=['translateX', 'translateZ'] )",
 'recordDevice': "import maya.cmds as cmds\n\n#    Record the clock device for 30 seconds and apply the data.\n#\nimport time\ncmds.recordDevice( device='clock', duration=30 )\ntime.sleep( 30 )\ncmds.recordDevice( device='clock', state=False )\ncmds.applyTake( device='clock' )",
 'redo': "import maya.cmds as cmds\n\n# In this particular example, each line needs to be executed\n# separately one after the other. Executing lines separately\n# guaranties that commands are properly registered in the undo\n# stack.\n\ncmds.polyCube()\n# Result: [u'pCube1', u'polyCube1'] #\n\ncmds.undo()\n# Undo: cmds.polyCube()\n #\n\ncmds.redo()\n# Redo: cmds.polyCube()\n #\n# Result: [u'pCube1', u'polyCube1'] #",
 'reference': '',
 'referenceEdit': 'import maya.cmds as cmds\n\n#\n# EXAMPLE FOR -removeEdits\n#\n# Assume:\n# main.ma contains a reference to mid.ma.\n# mid.ma contains a reference to bot.ma.\n\n# NOTE: The target reference must be unloaded for the\n# following commands to work.\n\n# Remove all the edits which apply to mid.ma.\n# This can be done by specifying either the reference\n# node or the reference file.\ncmds.referenceEdit( \'midRN\', removeEdits=True )\ncmds.referenceEdit( \'mid.ma\', removeEdits=True )\n\n# Remove all "setAttr" edits which apply to mid.ma.\n# This can be done by specifying either the reference\n# node or the reference file.\ncmds.referenceEdit( \'midRN\', editCommand=\'setAttr\', removeEdits=True )\ncmds.referenceEdit( \'mid.ma\', editCommand=\'setAttr\', removeEdits=True )\n\n# Remove all the "parent" edits which apply to mid:pSphere1.\ncmds.referenceEdit( \'mid:pSphere1\', editCommand=\'parent\', removeEdits=True )\n\n# Remove all the "connectAttr" edits which apply to mid:pSphere1.translateX.\ncmds.referenceEdit( \'mid:pSphere1.translateX\', editCommand=\'connectAttr\', removeEdits=True )\n\n#Remove the "connectAttr" edit having mid:pSphere1.translateX as a source and mid:pSphere2.translateX as a destination.\ncmds.referenceEdit( ["|mid:pSphere1.translateX", "|mid:pSphere2.translateX"], failedEdits = True, successfulEdits = True, editCommand = \'connectAttr\', removeEdits = True )\n\n# Remove all the edits which apply to bot.ma and are stored on midRN.\n# The referenceEdit command is only capable of removing edits which\n# are stored on a top level reference node. The only edits which\n# are stored on a top level reference node are those which were made\n# from the main scene. If the file mid.ma was previously opened and\n# modifications were made to bot.ma, those edits can only be removed\n# by opening mid.ma and issuing a referenceEdit command.\n#\ncmds.referenceEdit( \'mid:botRN\', removeEdits=True )\ncmds.referenceEdit( \'bot.ma\', removeEdits=True )\n\n#\n# EXAMPLE FOR -changeEditTarget\n#\ntempDir = cmds.internalVar(utd=True)\n\n# Create a reference containing pSphere1.\n#\ncmds.file( f=True, new=True )\ncmds.polySphere( ch=1, r=1, sx=20, sy=20, ax=(0, 1, 0) )\nnewFileName = \'%sref.ma\' % tempDir\ncmds.file( rename=newFileName )\ncmds.file( f=True, s=True, type=\'mayaAscii\')\n\n# Reference the file in and position pSphere1\n#\ncmds.file( f=True, new=True )\ncmds.file( newFileName, r=True, ns=\'ref\' )\ncmds.select( \'ref:pSphere1\', r=True )\ncmds.move( 5, 5, 5 )\ntopFileName = \'%stop.ma\' % tempDir\ncmds.file( rename=topFileName )\ncmds.file( f=True, s=True, type=\'mayaAscii\')\n\n# Later on its determined that pSphere1 is actually\n# BobMrozowski.\n#\ncmds.file( newFileName, f=True, o=True )\ncmds.rename( \'pSphere1\', \'BobMrozowski\' )\ncmds.file( f=True, s=True, type=\'mayaAscii\')\n\n# Now go to open your main scene again...\n#\ncmds.file( topFileName, f=True, o=True )\n# ... and notice that BobMrozowski is back at\n# the origin.\n#\n# So remap all edits so that anything that used to\n# affect ref:pSphere1 now affects ref:BobMrozowski...\n#\ncmds.referenceEdit( \'refRN\', changeEditTarget=(\'ref:pSphere1\',\'ref:BobMrozowski\') )\n# ... and then force all previously failing edits affecting\n# refRN to be re-applied.\n#\ncmds.referenceEdit( \'refRN\', applyFailedEdits=True )\n# BobMrozowski should now be back at 5 5 5.\n#',
 'referenceQuery': "import maya.cmds as cmds\n\n# Build a sample scene:\n# main scene contains a reference to mid.ma.\n# mid.ma contains a reference to bot.ma.\n\n# Create bot.ma with a poly sphere.\n#\ncmds.polySphere()\ncmds.file( rename='bot.ma' )\ncmds.file( f=True, s=True, type='mayaAscii')\n\n# Create mid.ma with a poly cone.\n# Reference bot.ma into mid.ma and group\n# the sphere in bot.ma\n#\ncmds.file( f=True, new=True )\ncmds.file( 'bot.ma', r=True,ns='bot' )\ncmds.polyCone()\ncmds.group( 'bot:pSphere1' )\ncmds.file( rename='mid.ma' )\ncmds.file( f=True, s=True, type='mayaAscii')\n\n# Create a poly plane.\n# Reference mid.ma into the main scene,\n# move the cone in mid.ma, and connect\n# the plane to the sphere in bot.ma.\n#\ncmds.file( f=True, new=True )\ncmds.file( 'mid.ma', r=True, ns='mid' )\ncmds.select( 'mid:pCone1', r=True )\ncmds.move( 5, 5, 5, r=True )\ncmds.polyPlane()\ncmds.connectAttr( 'pPlane1.ty', 'mid:bot:polySphere1.radius' )\n\n# Now perform some queries:\n#\ncmds.referenceQuery( 'midRN',filename=True )\n# Result: C:/Documents and Settings/user/My Documents/maya/projects/default/scenes/mid.ma\ncmds.referenceQuery( 'mid:pCone1', filename=True, shortName=True )\n# Result: mid.ma\ncmds.referenceQuery( 'mid:botRN', filename=True, parent=True )\n# Result: C:/Documents and Settings/user/My Documents/maya/projects/default/scenes/mid.ma\n\ncmds.referenceQuery( 'mid.ma', referenceNode=True )\n# Result: midRN\ncmds.referenceQuery( 'C:/Documents and Settings/user/My Documents/maya/projects/default/scenes/bot.ma', referenceNode=True)\n# Result: mid:botRN\ncmds.referenceQuery( 'bot.ma', referenceNode=True, parent=True )\n# Result: midRN\ncmds.referenceQuery( 'bot.ma', referenceNode=True, topReference=True )\n# Result: midRN\n\ncmds.referenceQuery( 'mid:botRN',nodes=True )\n# Result:[u'mid:bot:pPlane1', u'mid:bot:pPlaneShape1', u'mid:bot:outputCloth1', u'mid:bot:nCloth1', u'mid:bot:nClothShape1', u'mid:bot:dynamicConstraint1', u'mid:bot:dynamicConstraintShape1', u'mid:bot:nurbsSphere1', u'mid:bot:nurbsSphereShape1', u'mid:bot:pSphere1', u'mid:bot:pSphereShape1', u'mid:bot:lightLinker1', u'mid:bot:layerManager', u'mid:bot:defaultLayer', u'mid:bot:renderLayerManager', u'mid:bot:defaultRenderLayer', u'mid:bot:polyPlane1', u'mid:bot:nucleus1', u'mid:bot:nComponent1', u'mid:bot:uiConfigurationScriptNode', u'mid:bot:sceneConfigurationScriptNode', u'mid:bot:nClothShape1Cache1Start', u'mid:bot:cacheBlend1', u'mid:bot:nClothShape1Cache2', u'mid:bot:nClothShape1Cache1End', u'mid:bot:makeNurbSphere1', u'mid:bot:polySphere1'] #\n\ncmds.referenceQuery( 'pPlane1', isNodeReferenced=True )\n# Result: 0\ncmds.referenceQuery( 'mid:pCone1', isNodeReferenced=True )\n# Result: 1\n\ncmds.referenceQuery( 'mid:botRN', parentNamespace=True )\n# Result: mid\n\ncmds.referenceQuery( 'mid:bot:pSphere1', parentNamespace=True )\n# Result: mid\n\ncmds.referenceQuery( 'C:/Documents and Settings/user/My Documents/maya/projects/default/scenes/bot.ma', parentNamespace=True )\n# Result: mid\n\nprint cmds.referenceQuery( 'bot.ma', namespace=True )\n# Result: :mid:bot\n\nprint cmds.referenceQuery( 'mid:botRN', namespace=True )\n# Result: :mid:bot\n\nprint cmds.referenceQuery( 'bot.ma', namespace=True, shortName=True )\n# Result: bot\n\nprint cmds.referenceQuery( 'mid.ma', namespace=True )\n# Result: :mid\n\nprint cmds.referenceQuery( 'mid.ma', namespace=True, shortName=True )\n# Result: mid",
 'refineSubdivSelectionList': 'import maya.cmds as cmds\n\n# after selecting components of a subdivision surface\ncmds.refineSubdivSelectionList()',
 'refresh': 'import maya.cmds as cmds\n\ncmds.refresh()\n\n\n# The refresh command can also be used to take a snapshot of the current scene view and\n# save it as an image file. See example below.\n\nimport maya.cmds as cmds\n# Set up workspace for images in current project\nws = cmds.workspace(q = True, fullName = True)\nwsp = ws + "/" + "images"\ncmds.sysFile(wsp, makeDir=True)\n\n# Prepare unique image name for snapshot\nimageSnapshot = wsp + "/" + "endSnapshot.jpg"\n\n# Take a snapshot of the viewport and save to file\ncmds.refresh(cv=True, fe = "jpg", fn = imageSnapshot)',
 'refreshEditorTemplates': 'import maya.cmds as cmds\n\n# The following command will cause the currently\n# selected AE tab and all copied AE tab windows\n# to be refreshed.\n#\ncmds.refreshEditorTemplates',
 'regionSelectKeyCtx': "import maya.cmds as cmds\n\n# Create a manipulator style scale key context for the graph editor\n#\ncmds.regionSelectKeyCtx( 'regionSelectKeyContext' )",
 'rehash': '',
 'relationship': "import maya.cmds as cmds\n\n\ncmds.relationship('ignore', 'lightLinker1', 'pCube1', 'pointLight1')",
 'reloadImage': "import maya.cmds as cmds\n\ncmds.reloadImage( 'image.xpm', 'iconTextButtonName' )\ncmds.reloadImage( 'image', 'shelfButtonName' )\ncmds.reloadImage( '~/bitmaps/maya/image.xpm', 'toolButtonName' )",
 'rememberCtxSettings': "import maya.cmds as cmds\n\ncmds.rememberCtxSettings('Move')",
 'removeJoint': "import maya.cmds as cmds\n\n# joint5 will be removed. Child joints of joint5 will be reparented under\n# joint5's parent joint.\ncmds.removeJoint( 'joint5' )",
 'removeMultiInstance': "import maya.cmds as cmds\n\ncmds.createNode('choice',n='choice')\ncmds.setAttr('choice.input[0]',2.0)\ncmds.setAttr('choice.input[4]',4.0)\ncmds.connectAttr('choice.input[8]','choice.input[100]')\n\n# This will remove the element with index 4 from the input of\n# the choice node as long as there are no incoming or outgoing\n# connections to the attribute.\n#\ncmds.removeMultiInstance( 'choice.input[4]' )\n\n# This will remove the element with index 100 from the input of\n# the choice node, breaking any existing connections first.\n#\ncmds.removeMultiInstance( 'choice.input[100]', b=True )",
 'rename': 'import maya.cmds as cmds\n\n# create two namespaces under the root namespace and create\n# a sphere under the root namespace and a sphere under one\n# of the new namespaces.\ncmds.namespace( set=\':\' )\ncmds.sphere( n=\'sphere1\' )\ncmds.namespace( add=\'nsA\' )\ncmds.namespace( add=\'nsB\' )\ncmds.namespace( set=\'nsA\' )\ncmds.sphere( n=\'sphere2\' )\ncmds.namespace( set=\':\' )\n# change name of sphere1\ncmds.rename(\'sphere1\', \'spinning_ball\')\n\n# change name of spinning_ball back to sphere1\ncmds.select( \'spinning_ball\', r=True )\ncmds.rename( \'sphere1\' )\n\n# move sphere2 to namespace nsB\ncmds.rename( \'nsA:sphere2\', \'nsB:sphere2\' )\n# Result: nsB:sphere2 #\n\n# move sphere2 back to namespace nsA when not in the root namespace\n# Note the ":" appearing in front of the new name to indicate\n# we want to move the object to namespace nsA under the root namespace.\ncmds.namespace( set=\'nsB\' )\ncmds.rename( \'nsB:sphere2\', \':nsA:sphere2\' )\n# Result: nsA:sphere2 #\n\n# Let\'s try this without the leading ":" in the new name.\n# Since we are namespace nsA, in affect, what we are trying to do\n# is rename :nsB:sphere2 to :nsA:nsB:sphere3. Since there isn\'t a\n# nsB namespace under the namespace nsA, the namespace specification\n# on new name is ignored and a warning is issued.\ncmds.namespace( set=\':nsA\' )\ncmds.rename( \'nsA:sphere2\', \'nsB:sphere3\' )\n# Warning: Removing invalid characters from name. #\n# Result: nsA:sphere3 #\n\n# rename an object when not in the root namespace\n# and move the object to current namespace\ncmds.namespace( set=\':nsB\' )\ncmds.rename( \'nsA:sphere3\', \'sphere4\' )\n# Result: nsB:sphere4 #\n\n# rename an object with an absolute name to move it into a new namespace.\n# The namespace does not exist so will be created.\ncmds.namespace( set=\':nsB\' )\ncmds.rename( \'nsA:sphere3\', \':nsC:sphere4\' )\n# Result: nsC:sphere4 #',
 'renameAttr': "import maya.cmds as cmds\n\n\ncmds.sphere( n='sph' )\ncmds.addAttr( sn='ms', ln='mass', dv=1.0, min=0.001, max=10000 )\n# Rename the long and short names separately\ncmds.renameAttr( 'sph.mass', 'length' )\ncmds.renameAttr( 'sph.ms', 'ln' )",
 'renameUI': "import maya.cmds as cmds\n\n#    Create a window with a single button.\n#\nwindow = cmds.window()\ncmds.columnLayout()\ncmds.button( 'exampleButton', label='Example' )\ncmds.showWindow( window )\n\n#    Edit the button label.\n#\ncmds.button( 'exampleButton', edit=True, label='New Label' )\n\n#    Rename the button.\n#\ncmds.renameUI( 'exampleButton', 'newButton' )\n\n#    Query the button label using the new object name.\n#\ncmds.button( 'newButton', query=True, label=True )",
 'render': 'import maya.cmds as cmds\n\ncmds.render()\n\ncam = cmds.camera()\ncmds.render( cam[0], x=768, y=576 )',
 'renderGlobalsNode': "import maya.cmds as cmds\n\ncmds.createNode( 'transform', n='transform1' )\ncmds.createNode( 'nurbsSurface', n='surface1', p='transform1' )\ncmds.createNode( 'camera', shared=True, n='top' )\n\n# This transform will be selected when created\ncmds.createNode( 'transform', n='selectedTransform' )\n\n# This will create a new transform node, but 'selectedTransform'\n# will still be selected.\ncmds.createNode( 'transform', ss=True )\n\n# Create node under new namespace\ncmds.createNode( 'transform', n='newNS:transform1' )\n\ncmds.renderGlobalsNode('bob')\n\n# this one will use defaults for resolution and quality\ncmds.renderGlobalsNode('bob', name='bob' )\n\ncmds.renderGlobalsNode('bob', rq='myTestQuality1', name='abekasTestGlobals' )",
 'renderInfo': 'import maya.cmds as cmds\n\ncmds.renderInfo( doubleSided=False, opposite=True )',
 'renderLayerPostProcess': 'import maya.cmds as cmds\n\ncmds.renderLayerPostProcess()',
 'renderManip': "import maya.cmds as cmds\n\ncmds.camera()\n\ncmds.renderManip( 'cameraShape1' )\n\ncmds.renderManip( 'cameraShape1', e=True, st=True )\n\ncmds.renderManip( 'cameraShape1', q=True, st=True )",
 'renderPartition': 'import maya.cmds as cmds\n\n# Query the current render partition\ncmds.renderPartition( q=True )\n\n# Set the current render partition to "foofoo"\ncmds.renderPartition( \'foofoo\' )',
 'renderPassRegistry': 'import maya.cmds as cmds\n\n\n# Get supported channel counts supported by your renderer and the passID "DIFF".\n\ncmds.renderPassRegistry(passID=\'DIFF\',renderer=\'yourRenderer\', supportedChannelCounts=True)\n#\n# Get supported data types supported by your renderer, the passID "DIFF" and the channels "3".\n\ncmds.renderPassRegistry(passID=\'DIFF\', renderer=\'yourRenderer\', channels=3, supportedDataTypes=True)',
 'renderQualityNode': "import maya.cmds as cmds\n\ncmds.createNode( 'transform', n='transform1' )\ncmds.createNode( 'nurbsSurface', n='surface1', p='transform1' )\ncmds.createNode( 'camera', shared=True, n='top' )\n\n# This transform will be selected when created\ncmds.createNode( 'transform', n='selectedTransform' )\n\n# This will create a new transform node, but 'selectedTransform'\n# will still be selected.\ncmds.createNode( 'transform', ss=True )\n\n# Create node under new namespace\ncmds.createNode( 'transform', n='newNS:transform1' )\n\ncmds.renderQualityNode()\ncmds.renderQualityNode( name='loResTestQuality' )",
 'renderSettings': "import maya.cmds as cmds\n\n# Get the name of the first and last image for the current layer\nfl = cmds.renderSettings(firstImageName=True, lastImageName=True)\n\nprint( 'First image is '+fl[0] )\n\n# This is the empty string if the scene is not set for animation\nif fl[1] == '':\n    print('Not rendering animation');\nelse:\n    print( 'Last image is '+fl[1] )",
 'renderThumbnailUpdate': 'import maya.cmds as cmds\n\n# Turns on thumbnail updates.\ncmds.renderThumbnailUpdate(True)\n\n# Turns off thumbnail updates.\ncmds.renderThumbnailUpdate(False)\n\n# Force update of a thumbnail\ncmds.renderThumbnailUpdate(fu = "lambert1")',
 'renderWindowEditor': 'import maya.cmds as cmds\n\nimport maya.cmds as cmds\n\n# There can only be one renderWindowEditor.\n# Check if it already exists or create it otherwise.\n#\neditor = cmds.renderWindowEditor(q=True, editorName=True )\nif( len(editor) == 0  ):\n\teditor = cmds.renderWindowEditor( "renderView" )\n\ncmds.renderWindowEditor( editor, e=True, mq=(0.7, 0.3, 0.3, 0.5) )\n\ncmds.renderWindowEditor( editor, e=True, ar=True )\n\ncmds.renderWindowEditor( editor, e=True, snapshot=(\'persp\', 256, 256) )\n\ncmds.renderWindowEditor( editor, e=True, crc=\'persp\' )\ncmds.renderWindowEditor( editor, q=True, crc=True )',
 'renderWindowSelectContext': '',
 'renderer': 'import maya.cmds as cmds\n\n# To register a renderer called "myRenderer":\n#\ncmds.renderer( \'myRenderer\' )\n\n# To edit a renderer called "myRenderer" with its rendererUIName\n# being "My Renderer":\n#\ncmds.renderer( \'myRenderer\', edit=True, rendererUIName=\'My Renderer\' )\n\n# To register a renderer called "anotherRenderer" with all\n# its parameters specified.\n#\ncmds.renderer( \'anotherRenderer\', rendererUIName=\'Another Renderer\', iprRenderProcedure=\'mayaSoftwareIprRender\', -iprOptionsProcedure=\'\', isRunningIprProcedure=\'mayaSoftwareIsRunningIpr\', startIprRenderProcedure=\'mayaSoftwareStartIprRender\', stopIprRenderProcedure=\'mayaSoftwareStopIprRender\', refreshIprRenderProcedure=\'mayaSoftwareRefreshIprImage\', pauseIprRenderProcedure=\'mayaSoftwarePauseIprRender\', changeIprRegionProcedure=\'mayaSoftwareChangeIprRegion\', iprOptionsMenuLabel=\'IPR Tuning Options\', iprOptionsSubMenuProcedure=\'mayaSoftwareIprUpdateOptionsSubMenu\', iprRenderSubMenuProcedure=\'mayaSoftwareIprUpdateRenderSubMenu\', renderProcedure=\'mayaSoftwareRender\', renderOptionsProcedure=\'RenderOptions\', renderDiagnosticsProcedure=\'RenderDiagnostics\', commandRenderProcedure=\'render -batch\', batchRenderProcedure=\'BatchRender\', batchRenderOptionsProcedure=\'BatchRenderOptions\', batchRenderOptionsStringProcedure="mayaSoftwareBatchRenderOptionsString", cancelBatchRenderProcedure=\'CancelBatchRender\', showBatchRenderProcedure=\'ShowBatchRender\', showRenderLogProcedure=\'\', showBatchRenderLogProcedure=\'\', renderRegionProcedure=\'mayaRenderRegion\', textureBakingProcedure=\'performConvertSolidTx\', polyPrelightProcedure=\'performPrelight\', renderingEditorsSubMenuProcedure=\'\', logoImageName=\'\', logoCallbackProcedure=\'\' )\n\n# To add a render globals node the renderer uses:\n#\ncmds.renderer( \'anotherRenderer\', edit=True, addGlobalsNode=\'defaultRenderGlobals\' )\n\n# To add the tabs associated with the specified renderer\n# for the unified render globals window, use the syntax\n#\n#      renderer -edit\n#               -addGlobalsTab globalsTabLabel\n#                              globalsTabCreateProcName\n#                              globalsTabUpdateProcName\n#               renderer;\n#\n# where "globalsTabLabel" is the label of the tab,\n# "globalsTabCreatedProcName" is the name of the mel procedure\n# which is used to create the content in the tab.\n# and "globalsTabCreatedProcName" is the name of the mel procedure\n# which is used to update the content in the tab.\n#\n# Note that if you want to add a number of tabs, you need to repeat\n# this renderer command for each tab you wish to add, as shown below.\n#\ncmds.renderer( \'anotherRenderer\', edit=True, addGlobalsTab=(\'Maya Software\', \'createMayaSoftwareGlobalsTab\', \'updateMayaSoftwareGlobalsTab\') )\n\n\n# To get a list of unified render globals window tab labels associated\n# with the specified renderer.\n#\ncmds.renderer( \'anotherRenderer\', query=True, globalsTabLabels=True )\n\n# To get a list of names of mel procedures that are used to\n# create the unified render globals window tabs associated with\n# the specified renderer.\n#\ncmds.renderer( \'anotherRenderer\', query=True, globalsTabCreateProcNames=True )\n\n# To get a list of names of mel procedures that are used to\n# update the unified render globals window tabs associated with\n# the specified renderer.\n#\ncmds.renderer( \'anotherRenderer\', query=True, globalsTabUpdateProcNames=True )\n\n# To view a list of registered renderers.\n#\ncmds.renderer( query=True, namesOfAvailableRenderers=True )\n\n# To check if anotherRenderer exists.\n#\ncmds.renderer( \'anotherRenderer\', exists=True )\n\n# To view a list of render globals nodes used by the specified\n# renderer:\n#\ncmds.renderer( \'anotherRenderer\', query=True, globalsNodes=True )',
 'reorder': "import maya.cmds as cmds\n\n# create a hierarchy\ncmds.sphere( n='sphere1' )\ncmds.sphere( n='sphere2' )\ncmds.sphere( n='sphere3' )\ncmds.sphere( n='sphere4' )\ncmds.group( 'sphere1', 'sphere2', 'sphere3', 'sphere4', n='group1' )\n\n# The hierarchy group1 contains sphere1, sphere2, sphere3 and sphere4.\n# The command below moves sphere2 before sphere1.\ncmds.reorder( 'sphere2', r=-1 )\n\n# make sphere1 the first sibling\ncmds.reorder( 'sphere1', front=True )\n\n# move sphere3 forward 2 siblings. Moving it forward one\n# sibling would put it at the end. Moving it forward again\n# puts it at the beginning.\ncmds.reorder( 'sphere3', r=2 )",
 'reorderContainer': "import maya.cmds as cmds\n\n\n# create a container\ncmds.sphere( n='sphere1' )\ncmds.sphere( n='sphere2' )\ncmds.sphere( n='sphere3' )\ncmds.sphere( n='sphere4' )\ncmds.container( addNode=['sphere1', 'sphere2', 'sphere3', 'sphere4'], n='sphereCon' )\n\n# The container sphereCon contains sphere1, sphere2, sphere3 and sphere4.\n# The command below moves sphere2 before sphere1.\ncmds.reorderContainer( 'sphere2', r=-1 )\n\n# make sphere1 the first sibling\ncmds.reorderContainer( 'sphere1', front=True )\n\n# move sphere3 forward 2 siblings. Moving it forward one\n# sibling would put it at the end. Moving it forward again\n# puts it at the beginning.\ncmds.reorderContainer( 'sphere3', r=2 )",
 'reorderDeformers': "import maya.cmds as cmds\n\n# Create some geometry to deform\ncmds.sphere( name='sphere1' )\ncmds.sphere( name='sphere2' )\n\n# Create a couple of deformers\ncmds.select( 'sphere1Shape', 'sphere2Shape' )\ncmds.sculpt( name='sculpt1' )\ncmds.select( 'sphere1Shape', 'sphere2Shape' )\ncmds.cluster( name='cluster1' )\n\n# Change their order\ncmds.reorderDeformers( 'sculpt1', 'cluster1', 'sphere1Shape', 'sphere2Shape' )",
 'repeatLast': '',
 'requires': "import maya.cmds as cmds\n\ncmds.requires( 'maya', '7.0' )\ncmds.requires( 'simpleLoftNode.so', '1.0' )\ncmds.requires( 'gpuCache', '1.0', nodeType='gpuCache')",
 'reroot': "import maya.cmds as cmds\n\n# joint5 will be a new root joint of the skeleton.\ncmds.reroot( 'joint5' )",
 'resampleFluid': 'import maya.cmds as cmds\n\n# set width resolution to 3\ncmds.resampleFluid( rw=3 )\n\n# set height resolution to 12\ncmds.resampleFluid( rh=12 )\n\n# set all  resolutions to 20\ncmds.resampleFluid( rw=20, rh=20, rd=20 )',
 'resetTool': "import maya.cmds as cmds\n\ncmds.resetTool( 'moveSuperContext' )",
 'resolutionNode': "import maya.cmds as cmds\n\ncmds.createNode( 'transform', n='transform1' )\ncmds.createNode( 'nurbsSurface', n='surface1', p='transform1' )\ncmds.createNode( 'camera', shared=True, n='top' )\n\n# This transform will be selected when created\ncmds.createNode( 'transform', n='selectedTransform' )\n\n# This will create a new transform node, but 'selectedTransform'\n# will still be selected.\ncmds.createNode( 'transform', ss=True )\n\n# Create node under new namespace\ncmds.createNode( 'transform', n='newNS:transform1' )\n\ncmds.resolutionNode( 'customRes' )\ncmds.resolutionNode( 'customRes', name='customRes' )",
 'resourceManager': 'import maya.cmds as cmds\n\n# List all resources starting with an "a"\ncmds.resourceManager(nameFilter="a*")',
 'retimeHelper': '',
 'retimeKeyCtx': "import maya.cmds as cmds\n\n# Create a manipulator style scale key context for the graph editor\n#\ncmds.retimeKeyCtx( 'retimeKeyContext' )",
 'reverseCurve': "import maya.cmds as cmds\n\ncmds.reverseCurve( 'curve1', constructionHistory=True )\n# Reverses curve1 with construction history on.  The result will\n# be a string array, where the first string is the name of the new\n# reversed curve and the second string is the name of the new\n# dependency node.\n\ncmds.reverseCurve( 'curve1', ch=False, replaceOriginal=True )\n# Reverses curve1 without construction history, replacing the original.\n# The result will be a string array, where the first string\n# is the name of the curve (curve1).  Because history is off,\n# no dependency node will be created.  The reversed curve will\n# replace the original curve.\n\ncmds.reverseCurve( 'curve1', ch=True, rpo=True )\n# Reverses curve1 with history, trying to replace the original.\n# If curve1 was not a result of construction history, then this command\n# will simply replace curve1 with the reversed curve.  No dependency\n# node will be created.\n\n# If curve1 was a result of construction history, then this command\n# will insert a reverse dependency node before the curve.  eg.\n# Before reverseCurve cmd:   curve0 ---> closeCurve DN ---> curve1\n# After cmd:  curve0 ---> closeCurve DN ---> reverseCurve DN ---> curve1\n\n# The result will be a string array , where the first string\n# is the name of the curve (curve1) and the second name is the\n# new dependency node.",
 'reverseSurface': 'import maya.cmds as cmds\n\ncmds.reverseSurface( \'surface1\', ch=True, d=0 )\ncmds.reverseSurface( \'surface1.v[0.1]\', ch=True )\n# Reverses surface1 with construction history in the U direction.\n# The name of the new surface and the name of the new dependency node\n# are returned.\n\ncmds.reverseSurface( \'surface1\', ch=False, rpo=True, d=1 )\ncmds.reverseSurface( \'surface1.u[0.1]\', ch=True )\n# Reverses surface1 without history, with replace original on,\n# in the V direction.  Because the "-rpo" flag is on, the name of\n# the original surface is returned as well as the new dependency node.\n# The reversed surface will <em>replace</em> the original surface.\n\ncmds.reverseSurface( \'surface1\', ch=False, rpo=True, d=2 )\n# Reverses surface1 without history, with replace original on,\n# in both the U and V directions.\n\ncmds.reverseSurface( \'surface1\', ch=False, rpo=True, d=3 )\n# Swaps the U and V directions of surface1 with history, with replace\n# original on.  This has the effect of reversing the surface normal.',
 'revolve': "import maya.cmds as cmds\n\n# To revolve a curve about the X axis at the origin. The profile curve is\n# revolved by 360 degrees by default.\ncmds.revolve( 'curve1', ax=(1, 0, 0), p=(0, 0, 0) )\n\n# To revolve a curve about the Y axis at 1,0,1:\ncmds.revolve( 'curve1', ax=(0, 1, 0), p=(1, 0, 1) )",
 'rigidBody': "import maya.cmds as cmds\n\n# Creates a rigid body with a initial velocity of 10 in the x\n# direction, a bounciness of 0.5 and a static friction coefficent\n# of 0.4.\n#\ncmds.rigidBody( n='myRigidBody', active=True, iv=(10, 0, 0), b=0.5, sf=0.4 )",
 'rigidSolver': 'import maya.cmds as cmds\n\n# Set the playback time range to [1, 100]\ncmds.playbackOptions(min=1, max=100)\n# Create a poly cube named "floor"\ncmds.polyCube(w=10, h=0.10, d=10, sx=10, sy=1, sz=10, ax=(0, 1, 0), name=\'floor\')\n# Create a poly sphere named "ball", then move it to 0 9 0\ncmds.polySphere(r=1, sx=20, sy=20, ax=(0, 1, 0), name=\'ball\')\ncmds.move(0, 9.0, 0, r=True)\n# Create a new rigid body solver\ncmds.rigidSolver(create=True, name=\'rigidSolver1\')\n# Set the floor to passive rigid body\ncmds.select(\'floor\')\ncmds.rigidBody(passive=True, solver=\'rigidSolver1\', name=\'passiveRigidBody\')\n# Set the ball to active rigid body\ncmds.select(\'ball\')\ncmds.rigidBody(active=True, solver=\'rigidSolver1\', name=\'activeRigidBody\')\n# Add a gravity field, and connect it to ball\ncmds.gravity(pos=(0, 0, 0), m=9.8, dx=0, dy=-1, dz=0, name=\'gravityField\')\ncmds.connectDynamic(\'activeRigidBody\', f=\'gravityField\')\n# Play\ncmds.play(w=True)\n\n# Set the rigid solver to allow the ball to interpenetrate the floor, then replay\ncmds.currentTime(1, e=True)\ncmds.rigidSolver(\'passiveRigidBody\', \'activeRigidBody\', \'rigidSolver1\', e=True, interpenetrate=True)\ncmds.play(w=True)\n\n# Set the rigid solver to disallow the ball to interpenetrate the floor, replay\ncmds.currentTime(1, e=True)\ncmds.rigidSolver(\'passiveRigidBody\', \'activeRigidBody\', \'rigidSolver1\', e=True, collide=True)\ncmds.play(w=True)\n\n# Set the rigid solver to turn off the bounciness, replay\ncmds.currentTime(1, e=True)\ncmds.rigidSolver(\'rigidSolver1\', e=True, bounciness=False)\ncmds.play(w=True)',
 'roll': "import maya.cmds as cmds\n\ncmds.camera()\n\n# Align the horizontal direction with the world horizon\ncmds.roll( 'cameraShape1', abs=True, d=0 )\n\n# Roll the camera 15 degrees clockwise\ncmds.roll( 'cameraShape1', d=15 )\n\ncmds.roll( d=15 )",
 'rollCtx': "import maya.cmds as cmds\n\ncmds.rollCtx( 'rollContext', rs=30.0 )",
 'rotate': "import maya.cmds as cmds\n\n# create a circle and grouped cone to rotate;\ncmds.circle( n='circle1' )\ncmds.cone( ax=(0, 1, 0), n='cone1' )\ncmds.group( 'cone1', n='group1' )\n\n# rotate the active objects 45 degrees about the world space X axis\n# centered at each object's rotate pivot point.\ncmds.select( 'cone1' )\ncmds.rotate( '45deg', 0, 0, r=True )\n\n# Set the rotation values for group1 to (90, 0, 0). This is\n# equivalent to:\n#   cmds.setAttr('group1.rx',90)\n#   cmds.setAttr('group1.ry',0)\n#   cmds.setAttr('group1.rz',0)\ncmds.rotate( '90deg', 0, 0, 'group1' )\n\n# rotate the circle 180 degrees about its local space Y axis\n# centered at the rotate pivot point 1 0 0.\ncmds.rotate( 0, '180deg', 0, 'circle1', pivot=(1, 0, 0) )",
 'rotationInterpolation': 'import maya.cmds as cmds\n\n\n# Converts "nurbsCone1_rotateX" and its sibling curves to quaternion tangent dependent format.\ncmds.rotationInterpolation( \'nurbsCone1_rotateX\', convert=\'quaternion\' )',
 'roundCRCtx': '',
 'roundConstantRadius': 'import maya.cmds as cmds\n\n# This rounds four edges of a cube with radius 0.9.  Because a single\n# radius is specified, it is used for all edges.  The edges must\n# be specified in matching pairs if no "sidea" or "sideb" flags\n# are used.\n#\ncube = cmds.nurbsCube(w=5, lr=1, hr=1, d=3, ch=0)\nsides = cmds.listRelatives( cube[0], c=True )\nrnd = cmds.roundConstantRadius(\n    (sides[0] + ".v[0]"), (sides[2] + ".v[1]"),\n    (sides[0] + ".u[1]"), (sides[4] + ".v[1]"),\n    (sides[0] + ".v[1]"), (sides[3] + ".u[1]"),\n    (sides[0] + ".u[0]"), (sides[5] + ".u[1]"),\n    rad=0.9 )\n\n# This adds a pair of isoparms to an existing round operation,\n# named $rnd[3] (from previous example)\n#\ncmds.roundConstantRadius( (sides[3] + \'.v[0]\'), (sides[5] + \'.v[1]\'),\n                          rnd[3], append=True, rad=0.8 )\n\n# This rounds 6 edges of a cube with different radius values.\n# The first four edges have radius 0.9 and the others have radius 1.1.\n# In this case the edges are specified in matching pairs\n# since no "sidea" or "sideb" flags are used.\n#\ncube = cmds.nurbsCube( w=5, lr=1, hr=1, d=3, ch=0 )\nsides = cmds.listRelatives( cube[0], c=True )\ncmds.roundConstantRadius( (sides[0]+".v[0]"), (sides[2]+".v[1]"),\n                          (sides[0]+".u[1]"), (sides[4]+".v[1]"),\n                          (sides[0]+".v[1]"), (sides[3]+".u[1]"),\n                          (sides[0]+".u[0]"), (sides[5]+".u[1]"),\n                          (sides[3]+".v[0]"), (sides[5]+".v[1]"),\n                          (sides[2]+".u[1]"), (sides[4]+".u[0]"),\n                          rad=[0.9, 0.9, 0.9, 0.9, 1.1, 1.1] )\n\n# This rounds a 2-to-1 compound edge.  The sidea flag indicates\n# that there two edges on side A, and one on side B.\n# The edges must be specified in the corresponding order.\n#\npln1 = cmds.nurbsPlane(w=5, ch=0, ax=(0, 1, 0))\npln2 = cmds.nurbsPlane( p=(2.5, 2.5, 1.25), ax=(1, 0, 0), w=2.5, lr=2, d=3, u=1, v=1, ch=0 )\npln3 = cmds.nurbsPlane( p=(2.5, 2.5, -1.25), ax=(1, 0, 0), w=2.5, lr=2, d=3, u=1, v=1, ch=0 )\npln4 = cmds.nurbsPlane( p=(0, 2.5, -2.5), ax=(0, 0, 1), w=5, lr=1, d=3, u=1, v=1, ch=0 )\ncmds.roundConstantRadius( (pln2[0]+\'.v[0]\'), (pln3[0]+\'.v[0]\'),\n                          (pln1[0]+\'.u[1]\'), (pln3[0]+\'.u[1]\'),\n                          (pln4[0]+\'.u[1]\'), rad=0.9,\n                          side=[(\'a\',2), (\'b\', 1), (\'a\', 1), (\'b\', 1)] )',
 'rowColumnLayout': 'import maya.cmds as cmds\n\n#    The following script will position the buttons in a single column.\n#\n#    +----+\n#    | b1 |\n#    +----+\n#    +----+\n#    | b2 |\n#    +----+\n#    +----+\n#    | b3 |\n#    +----+\n#\ncmds.window()\ncmds.rowColumnLayout( numberOfColumns=1 )\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.showWindow()\n\n#    The following script will position the buttons in a single row.\n#\n#    +----++----++----+\n#    | b1 || b2 || b3 |\n#    +----++----++----+\n#\ncmds.window()\ncmds.rowColumnLayout( numberOfRows=1 )\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.showWindow()\n\n#    The following script will position the buttons in 3 columns, each\n#    column a different width.\n#\n#    +----++--------++------------+\n#    | b1 ||   b2   ||     b3     |\n#    +----++--------++------------+\n#    +----++--------++------------+\n#    | b4 ||   b5   ||     b6     |\n#    +----++--------++------------+\n#    +----+\n#    | b7 |\n#    +----+\n#\ncmds.window()\ncmds.rowColumnLayout( numberOfColumns=3, columnWidth=[(1, 60), (2, 80), (3, 100)] )\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.showWindow()\n\n#    The following script will position the buttons in 2 rows, each\n#    row a different height.\n#\n#    +----++----++----++----+\n#    | b1 || b3 || b5 || b7 |\n#    +----++----++----++----+\n#    +----++----++----+\n#    |    ||    ||    |\n#    | b2 || b4 || b6 |\n#    |    ||    ||    |\n#    +----++----++----+\n#\ncmds.window()\ncmds.rowColumnLayout( numberOfRows=2, rowHeight=[(1, 30), (2, 60)] )\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.showWindow()',
 'rowLayout': "import maya.cmds as cmds\n\n#    Layout a label, field and slider such that the label is right\n#    justified and the field adjusts in size as the window is resized.\n#\ncmds.window()\ncmds.rowLayout( numberOfColumns=3, columnWidth3=(80, 75, 150), adjustableColumn=2, columnAlign=(1, 'right'), columnAttach=[(1, 'both', 0), (2, 'both', 0), (3, 'both', 0)] )\ncmds.text()\ncmds.intField()\ncmds.intSlider()\ncmds.showWindow()",
 'runTimeCommand': 'import maya.cmds as cmds\n\n#    Create a command that simply prints a message.  After executing\n#    the following lines enter the command name <i>MyHelloCommand</i>\n#    in the Command Line.\n#\nif maya.cmds.runTimeCommand( \'MyHelloCommand\', exists=True ):\n    cmds.runTimeCommand( annotation=\'Print the word "Hello"\', command=\'print "Hello\\\\n"\', MyHelloCommand )\n\n#    Create a window with a button that invokes the <i>MyHelloCommand</i>\n#    command.\n#\ncmds.window()\ncmds.paneLayout()\n# Some commands support different language source types. Since the button command does not, it\n# assumes Python and the command has to be explicitly forwarded to MEL, which is what the runTimeCommand creates.\ncmds.button( command=\'import maya.mel; mel.eval("MyHelloCommand")\' )\ncmds.showWindow();',
 'runup': 'import maya.cmds as cmds\n\ncmds.runup( mxf=10, cache=True )\n\n# Starts at the minimum start frame of all dynamic objects\n# and plays through to frame 10.  This guarantees that the system\n# is in the same state it would be as if you had rewound and played\n# forward from frame 0.  The state of the dynamic object(s) will be\n# cached after the runup.',
 'safemodecheckhash': '',
 'sampleImage': "import maya.cmds as cmds\n\n# From now on, render sample images at high quality.\n#\ncmds.sampleImage( f=False )\n\n# Render the sample image associated with lambert1 at a resolution of\n# 128 pixels by 128 pixels.\n#\ncmds.sampleImage( r=(128, 'lambert1') )",
 'saveAllShelves': "import maya.cmds as cmds\n\nimport maya.mel\ngShelfTopLevel = maya.mel.eval('$tmpVar=$gShelfTopLevel')\ncmds.saveAllShelves( gShelfTopLevel )",
 'saveFluid': 'import maya.cmds as cmds\n\n# save the current state to the initial conditions cache\ncmds.saveFluid()',
 'saveImage': 'import maya.cmds as cmds\n\n#    Note that for this example to work you must substitute\n#    "image" below with the full path name to a valid image.\n#\nwindow = cmds.window()\ncmds.paneLayout()\ncmds.image( image=\'image\' )\ncmds.showWindow( window )\n\nwindow = cmds.window(\'window\')\ncmds.paneLayout()\ncmds.saveImage( currentView=True )\ncmds.showWindow( window )\n\n# When rendering shaded images, in lieu of using the saveImage command, execute the following\n# script to take a snapshot of the current scene view and save it as an endSnapshot.jpg file\n# to the images directory of your project directory.\n# This workaround can be used for both the default viewport and Viewport 2.0.\n\nimport maya.cmds as cmds\n# Set up workspace for images in current project\nws = cmds.workspace(q = True, fullName = True)\nwsp = ws + "/" + "images"\ncmds.sysFile(wsp, makeDir=True)\n\n# Prepare unique image name for snapshot\nimageSnapshot = wsp + "/" + "endSnapshot.jpg"\n\n# Take a snapshot of the viewport and save to file\ncmds.refresh(cv=True, fe = "jpg", fn = imageSnapshot)',
 'saveInitialState': "import maya.cmds as cmds\n\ncmds.saveInitialState( 'particle1' )\n# Saves current state as initial state for particle1.\n\ncmds.saveInitialState( all=True )\n# Saves current state as initial state for all dynamics objects.",
 'saveMenu': 'import maya.cmds as cmds\n\n# Create a window with two frames.\n#\nwin = cmds.window(title=\'saveMenu Example\')\ncmds.columnLayout()\nframe1 = cmds.frameLayout( h=90, l=\'Original Menu (LMB)\' )\ncmds.text( l=\'(click here)\' )\ncmds.setParent( \'..\' )\nframe2 = cmds.frameLayout( h=90, l=\'Copy of Original (LMB)\' )\ncmds.text( l=\'(click here)\' )\ncmds.setParent( \'..\' )\n\n# Create a menu.\n#\nmenu1 = cmds.popupMenu( parent=frame1, b=1, mm=True )\n\ncmds.menuItem( rp=\'N\', l=\'Up\' )\ncmds.menuItem( rp=\'S\', l=\'Down\' )\ncmds.menuItem( rp=\'E\', l=\'Right\' )\ncmds.menuItem( rp=\'W\', l=\'Left\' )\ncmds.menuItem( label=\'Warm\', sm=True )\ncmds.menuItem( l=\'Red\' )\ncmds.menuItem( l=\'Orange\' )\ncmds.menuItem( l=\'Yellow\' )\ncmds.setParent( \'..\', m=True )\ncmds.menuItem( label=\'Cold\', sm=True )\ncmds.menuItem( l=\'Green\' )\ncmds.menuItem( l=\'Blue\' )\ncmds.menuItem( l=\'Indigo\' )\ncmds.menuItem( l=\'Violet\' )\ncmds.setParent( \'..\', m=True )\ncmds.setParent( \'..\', m=True )\n\n# Save the menu to a file.\n#\nresult = cmds.saveMenu(menu1, \'menu_example\')\n\n# Use the file to rebuild another instance of the menu.\n#\nmenu1 = cmds.popupMenu( parent=frame2, b=1, mm=True )\nmaya.mel.eval( \'source \\"\' + cmds.internalVar(userMarkingMenuDir=True) + \'menu_example.mel\\"\' )\n\n# Finish up.\nprint ("The menu was saved in [" + cmds.internalVar(userMarkingMenuDir=True) + result + "]\\n" )\ncmds.showWindow( win )',
 'savePrefObjects': 'import maya.cmds as cmds\n\ncmds.savePrefObjects()',
 'savePrefs': 'import maya.cmds as cmds\n\n# only save the hotkeys\ncmds.savePrefs( hotkeys=True )\n\n# save everything\ncmds.savePrefs()\n\n# only save ui layout prefs\ncmds.savePrefs( uiLayout=True )',
 'saveShelf': 'import maya.cmds as cmds\n\n#    Create a window with a shelf in it.\n#\nwindow = cmds.window()\ntabs = cmds.tabLayout()\nshelf = cmds.shelfLayout()\ncmds.shelfButton( \'\\"Hello\\\\n\\"")\', image1=\'commandButton.png\', command=\'("print\' )\ncmds.tabLayout( tabs, edit=True, tabLabel=(str(shelf),\'Example Shelf\')  )\ncmds.showWindow( window )\n\n#    At this point the example would be made more interesting if you\n#    put some additional items on this shelf.\n\n#    Now save the shelf in the temp directory.\n#\ntempDir = cmds.internalVar( userTmpDir=True )\ncmds.saveShelf( shelf, (tempDir + \'ExampleShelf\') );',
 'saveToolSettings': 'import maya.cmds as cmds\n\ncmds.saveToolSettings()',
 'saveViewportSettings': 'import maya.cmds as cmds\n\ncmds.saveViewportSettings()',
 'scale': "import maya.cmds as cmds\n\ncmds.scale( 1, 1, 1 )\ncmds.scale( 3, 3, 3, 'curve1', pivot=(1, 0, 0), absolute=True )",
 'scaleComponents': 'import maya.cmds as cmds\n\ncmds.scaleComponents( 2, 2, 2, pivot=(0, 10, 0), rotation=(30, 40, 50) )',
 'scaleConstraint': 'import maya.cmds as cmds\n\n# Scale cube1 at the scale of cone1.\ncmds.scaleConstraint( \'cone1\', \'cube1\' )\n\n# Uses the average of the scale of cone1 and surf2.\ncmds.scaleConstraint( \'cone1\', \'surf2\', \'cube2\', w=.1 )\n\n# Sets the weight for cone1\'s effect on cube2 to 10.\ncmds.scaleConstraint( \'cone1\', \'cube2\', e=True, w=10.0 )\n\n# Removes surf2 from cube2\'s scaleConstraint\ncmds.scaleConstraint( \'surf2\', \'cube2\', e=True, rm=True )\n\n# Adds surf3 to cube2\'s scaleConstraint with the default weight\ncmds.scaleConstraint( \'surf3\', \'cube2\' )\n\n# Constrain the x and z scale of sph2 to sph1\ncmds.scaleConstraint( \'sph1\', \'sph2\', skip="y" )',
 'scaleKey': 'import maya.cmds as cmds\n\n# Keys on animation curves are identified by either\n# their time values or their indices.  Times and indices can\n# be given as a range or list of ranges.\n\n# time=(\'10pal\',\'10pal\') means the key at frame 10 (PAL format).\n# time=[(\'1.0sec\',\'1.0sec\'),(\'15ntsc\',\'15ntsc\'),(20,20)] means the keys at time 1.0 second, frame 15 (in NTSC format), and time 20 (in the currently defined global time unit).\n# time=(10,20) means all keys in the range from 10 to 20, inclusive, in the current time unit.\n# Omitting one end of a range means "go to infinity", as in the following examples:\n# time=(10,None) means all keys from time 10 (in the current time unit) onwards.\n# time=(10,) means the same as (10,10)\n# time=(0,10) means all keys up to (and including) time 10 (in the current time unit).\n# time=(None,None) is a short form to specify all keys.\n# index=(0,0) means the first key of each animation curve. (Indices are 0-based.)\n# index=[(2,2),(5,5),(7,7)] means the 3rd, 6th, and 8th keys.\n# index=(1,5) means the 2nd, 3rd, 4th, 5th, and 6th keys of each animation curve.\n\n# Scale keyframes from frame 10 to 20 of nurbsSphere1\'s translateX\n# to fill frames 10 to 30.\n#\ncmds.scaleKey( \'nurbsSphere1\', time=(10,20), newStartTime=10, newEndTime=30, attribute=\'tx\' )\n\n# Scale all the animation of the active objects\n# (range 0-30) to fill range 0 to 60.\n#\ncmds.scaleKey( time=(0,30), timeScale=2, timePivot=0 )',
 'scaleKeyCtx': "import maya.cmds as cmds\n\n# Create a manipulator style scale key context for the graph editor\n#\ncmds.scaleKeyCtx( 'scaleKeyContext', type='rect' )",
 'sceneEditor': 'import maya.cmds as cmds\n\nwindow = cmds.window()\ncmds.paneLayout()\ncmds.sceneEditor()\ncmds.showWindow(window)',
 'sceneLint': 'import maya.cmds as cmds\n\n# Query the list of available issue types\ncmds.sceneLint( query=True )\n# Return: [\'FOO\', \'BAR\', \'BAZ\'] #\n\n# Find all scene issues\ncmds.sceneLint()\n# Return: \'{ "sceneLint" : ... }\' #\n\n# Get more information on the "FOO" issue type\ncmds.sceneLint( issueTye=[\'FOO\',\'BAR\'], query=True )\n# Return: [\'FOO\', \'FOO_DESCRIPTION\', \'BAR\', \'BAR_DESCRIPTION\'] #\n\n# Run only the "FOO" issue check\ncmds.sceneLint( issueTye=\'FOO\' )\n# Return: \'{ "sceneLint" : ... }\' #',
 'sceneUIReplacement': "import maya.cmds as cmds\n\nimport maya.mel as mm\ngMainPane = mm.eval( 'global string $gMainPane; $temp = $gMainPane;' )\ncmds.sceneUIReplacement( update=gMainPane )\n\n# Try to find the modelPanel named Top View\ncmds.sceneUIReplacement( getNextPanel=('modelPanel','Top View') )\n# Result: modelPanel1 #\ncmds.modelPanel( 'modelPanel1', q=True, label=True )\n# Result: Top View #\n\n# Try to find Front View\ncmds.sceneUIReplacement( getNextPanel=('modelPanel', 'Front View') )\n# Result: modelPanel3 #\ncmds.modelPanel( 'modelPanel3', q=True, label=True )\n# Result: Front View #\n\n# Is there another Front View?  (No: all we find is a model panel called Persp View)\ncmds.sceneUIReplacement( getNextPanel=('modelPanel', 'Front View') )\n# Result: modelPanel4\ncmds.modelPanel( 'modelPanel4', q=True, label=True )\n# Result: Persp View",
 'scmh': "import maya.cmds as cmds\n\n# Create a new move manip context, set the active handle to X axis handle, then swith to it\ncmds.manipMoveContext('manipMoveContext1', ah=0)\ncmds.setToolTo('manipMoveContext1')\n\n# Set the active handle value to 10.(Translate the pSphere1 by (10, 0, 0))\ncmds.scmh(10, r=True)",
 'scriptCtx': 'import maya.cmds as cmds\n\n# Simple example of "attach curve" tool created using scriptCtx. This tool\n# prompts the user to select two curves to attach. As soon as two curves\n# are selected, the attach is performed. It uses the selection type\n# flag \'curveParameterPoint\' from "selectType" command to specify the\n# selection mask for this tool.\n\ncmds.scriptCtx( title=\'Attach Curve\', totalSelectionSets=1, fcs="select -r $Selection1; performAttachCrv 0 \\"\\"", cumulativeLists=True, expandSelectionList=True, setNoSelectionPrompt=\'Select two curves close to the attachment points\', setSelectionPrompt=\'Select a second curve close to the attachment point\', setDoneSelectionPrompt=\'Never used because setAutoComplete is set\', setAutoToggleSelection=True, setSelectionCount=2, setAutoComplete=True, curveParameterPoint=True )\n\n# And a more complex example of fillet blend tool (two sets of any number\n# of "surface curves").  Notice how the selection lists are passed as\n# arguments to the callback function, performBlendGiven.\n\ncmds.scriptCtx( i1=\'birail3Gen.xpm\', title=\'"Birail 3+ Tool\', toolCursorType=\'edit\', totalSelectionSets=2, cumulativeLists=True, expandSelectionList=True, fcs=\'select -r $Selection2; performBirail 0 3 \\"birailThreePlusProfileContext\\" \', setAutoToggleSelection=[True,True], setAutoComplete=[False, False], setSelectionCount=[0,2], nurbsCurve=[True,True], isoparm=[True,True], curveOnSurface=[True,True], surfaceEdge=[True,True], polymeshEdge=[True,True], setNoSelectionPrompt=[\'Select any number of profiles\',\'Select two rails\'], setSelectionPrompt=[\'Select additional profiles or hit ENTER\', \'Select the second rail\'], setDoneSelectionPrompt=[\'Profiles selected. Hit ENTER to start rail selection.\', \'Rails selected. Hit ENTER to compute birail. \'] )\n\n# Here\'s Birail 3+ where you select any number of curves, then 2 rails:\n\ncmds.scriptCtx( i1=\'birail3Gen.xpm\', title=\'"Birail 3+ Tool\', toolCursorType=\'edit\', totalSelectionSets=2, cumulativeLists=True, expandSelectionList=True, fcs=\'select -r $Selection2; performBirail 0 3 \\"birailThreePlusProfileContext\\" \', setAutoToggleSelection=[True,True], setAutoComplete=[False, False], setSelectionCount=[0,2], nurbsCurve=[True,True], isoparm=[True,True], curveOnSurface=[True,True], surfaceEdge=[True,True], polymeshEdge=[True,True], setNoSelectionPrompt=[\'Select any number of profiles\',\'Select two rails\'], setSelectionPrompt=[\'Select additional profiles or hit ENTER\', \'Select the second rail\'], setDoneSelectionPrompt=[\'Profiles selected. Hit ENTER to start rail selection.\', \'Rails selected. Hit ENTER to compute birail. \'] )\n\n# userBirailContextCallback has "true" as the first argument, which suggests\n# that $Selection2 contains all of $Selection1 items (as -cumulativeLists\n# true is specified in the tool creation.)',
 'scriptEditorInfo': 'import maya.cmds as cmds\n\n# Set the text of the input area of the Script Editor.\ncmds.scriptEditorInfo(input=\'// select -all; delete;\')\n# Clear the input area of the Script Editor.\ncmds.scriptEditorInfo(input="")\n\n# Begin recording the Script Editor history to a file called\n# tempHistoryLog.txt in your maya directory.\ncmds.scriptEditorInfo( historyFilename=\'tempHistoryLog.txt\', writeHistory=True )\n\n# Stop recording the Script Editor history\ncmds.scriptEditorInfo(writeHistory=False )\n\n# On Windows the following line would print something like "C:/maya/tempHistoryLog.txt"\n# On Linux it would be "~/maya/tempHistoryLog.txt"\ncmds.scriptEditorInfo(query=True, historyFilename=True)\n\n# Suppress all warning and info messages\ncmds.scriptEditorInfo(suppressWarnings=True)\ncmds.scriptEditorInfo(suppressInfo=True)',
 'scriptJob': 'import maya.cmds as cmds\n\n# create a job that deletes things when they are seleted\njobNum = cmds.scriptJob( ct= ["SomethingSelected","cmds.delete()"], protected=True)\n\n# Now display the job\njobs = cmds.scriptJob( listJobs=True )\n\n# Now kill it (need to use -force flag since it\'s protected)\ncmds.scriptJob( kill=jobNum, force=True)\n\n# create a sphere, but print a warning the next time it\n# is raised over 10 units high\ndef warn():\n\theight = cmds.getAttr( \'mySphere.ty\' )\n\tif height > 10.0:\n\t\tprint \'Sphere is too high!\'\ncmds.sphere( n=\'mySphere\' )\n\ncmds.scriptJob( runOnce=True, attributeChange=[\'mySphere.ty\', warn] )\n\n# create a job to detect a new attribute named "tag"\n#\ndef detectNewTagAttr():\n\tprint "New tag attribute was added"\n\ncmds.scriptJob( runOnce=True, attributeAdded=[\'mySphere.tag\',detectNewTagAttr] )\ncmds.addAttr( \'mySphere\', ln=\'tag\', sn=\'tg\', dt=\'string\')\n\n# list all the existing conditions and print them\n# nicely\nconds2 = cmds.scriptJob( listConditions=True )\nfor cond in sorted(conds2):\n\tprint cond',
 'scriptNode': "import maya.cmds as cmds\n\n#    Create a scriptNode named script that creates a sphere when a file\n#    containing this node is loaded.\n#\nnodeName = cmds.scriptNode( st=2, bs='cmds.sphere()', n='script', stp='python')\n\n#    Test the before script.\n#\ncmds.scriptNode( nodeName, executeBefore=True )\n\n#    Add a script to create a cone when the script node is deleted.\n#\ncmds.scriptNode( nodeName, e=True, as='cmds.cone()', stp='python' )\n\n#    Test the after script\n#\ncmds.scriptNode( nodeName, executeAfter=True )",
 'scriptTable': 'import maya.cmds as cmds\n\ndef edit_cell(row, column, value):\n    return 1\n\nwindow = cmds.window(widthHeight=(400, 300))\nform = cmds.formLayout()\ntable = cmds.scriptTable(rows=4, columns=2, label=[(1,"Column 1"), (2,"Column 2")], cellChangedCmd=edit_cell)\n\naddButton = cmds.button(label="Add Row",command="cmds.scriptTable(table, edit=True,insertRow=1)")\ndeleteButton = cmds.button(label="Delete Row",command="cmds.scriptTable(table, edit=True,deleteRow=1)")\n\ncmds.formLayout(form, edit=True, attachForm=[(table, \'top\', 0), (table, \'left\', 0), (table, \'right\', 0), (addButton, \'left\', 0), (addButton, \'bottom\', 0), (deleteButton, \'bottom\', 0), (deleteButton, \'right\', 0)], attachControl=(table, \'bottom\', 0, addButton), attachNone=[(addButton, \'top\'),(deleteButton, \'top\')],  attachPosition=[(addButton, \'right\', 0, 50), (deleteButton, \'left\', 0, 50)] )\n\ncmds.showWindow( window )\n\n# Set and query cells\ncmds.scriptTable(table, cellIndex=(1,1), edit=True, cellValue="MyValue")\nprint cmds.scriptTable(table, cellIndex=(1,1), query=True, cellValue=True)\n\n# Select and query rows, columns and cells\ncmds.scriptTable(table, edit=True, selectedRows=[1, 3])\nprint cmds.scriptTable(table, query=True, selectedRows=True)\ncmds.scriptTable(table, edit=True, selectedColumns=[1])\nprint cmds.scriptTable(table, query=True, selectedColumns=True)\ncmds.scriptTable(table, edit=True, selectedCells=[1,2,2,1,3,2,4,1])\nprint cmds.scriptTable(table, query=True, selectedCells=True)\n\n# Set a filter for the first column\ncmds.scriptTable(table, edit=True, columnFilter=(1,"MyValue"))\n# Set a filter for all columns\ncmds.scriptTable(table, edit=True, columnFilter=(0,"MyValue"))',
 'scriptedPanel': 'import maya.cmds as cmds\n\n// NOTE: The scriptedPanelType command does not support python\n// \t\t callbacks; these callbacks must be MEL.\n\n\nglobal proc sampleCreateCallback(string $panelName) {\n//\n//  Description:\n//      Create any editors unparented here and do\n//      any other initialization required.\n//\n//      In this example we will only declare a global array to\n//        maintain some state information.\n//\n    global float $gSampleState[5];\n\n}\n\n\nglobal proc sampleInitCallback(string $panelName) {\n//\n//  Description:\n//      Re-initialize the panel on file -new or file -open.\n//\n//      In this example we will only re-init the global array.\n//\n    global float $gSampleState[];\n\n       $gSampleState[0] = 20.2;\n       $gSampleState[1] = 50.5;\n       $gSampleState[2] = 34.7;\n       $gSampleState[3] = 2.0;\n       $gSampleState[4] = 1.0;\n\n}\n\nglobal proc sampleAddCallback(string $panelName) {\n//\n//  Description:  Create UI and parent any editors.\n//\n    global float $gSampleState[];\n\n    columnLayout -adj true topCol;\n    separator -style "none" -h 10;\n        frameLayout -l "Sliders" -mw 10;\n            columnLayout -adj true sampleCol;\n                separator -style "none" -h 10;\n\n                floatSliderGrp -l "Property A" -f true\n                    -v $gSampleState[0]\n                    fsg1;\n                floatSliderGrp -l "Property B" -f true\n                    -v $gSampleState[1]\n                    fsg2;\n                floatSliderGrp -l "Property C" -f true\n                    -v $gSampleState[2]\n                    fsg3;\n                separator -style "none" -h 10;\n            setParent ..;\n        setParent ..;\n\n        separator -style "none" -h 10;\n        frameLayout -l "Radio Buttons" -mw 10;\n            columnLayout sampleCol2;\n                separator -style "none" -h 10;\n                radioButtonGrp -nrb 3\n                    -l "Big Options"\n                    -la3 "Option 1" "Option 2" "Option 3"\n                    -select $gSampleState[3]\n                    rbg;\n                radioButtonGrp -nrb 3\n                    -l "Little Options"\n                    -la3 "Option 4" "Option 5" "Option 6"\n                    -select $gSampleState[4]\n                    rbg2;\n                separator -style "none" -h 10;\n\n}\n\nglobal proc sampleRemoveCallback(string $panelName) {\n//\n//  Description:\n//        Unparent any editors and save state if required.\n//\n        global float $gSampleState[];\n       //  Scope the control names to this panel.\n       //\n       string $control = `scriptedPanel -q -control $panelName`;\n       setParent $control;\n\n       $gSampleState[0] = `floatSliderGrp -q -v fsg1`;\n       $gSampleState[1] = `floatSliderGrp -q -v fsg2`;\n       $gSampleState[2] = `floatSliderGrp -q -v fsg3`;\n       $gSampleState[3] = `radioButtonGrp -q -sl rbg`;\n       $gSampleState[4] = `radioButtonGrp -q -sl rbg2`;\n}\n\nglobal proc sampleDeleteCallback(string $panelName) {\n//\n//  Description:\n//        Delete any editors and do any other cleanup required.\n\n}\n\nglobal proc string sampleSaveStateCallback(string $panelName) {\n//\n//  Description:\n//        Return a string that will restore the current state\n//        when it is executed.\n\n        global float $gSampleState[];\n       $indent = "\\n\\t\\t\\t";\n\n       return ($indent+"$gSampleState[0]="+$gSampleState[0]+";" +\n               $indent+"$gSampleState[1]="+$gSampleState[1]+";" +\n               $indent+"$gSampleState[2]="+$gSampleState[2]+";" +\n               $indent+"$gSampleState[3]="+$gSampleState[3]+";" +\n               $indent+"$gSampleState[4]="+$gSampleState[4]+";" +\n               $indent+"setSamplePanelState $panelName;\\n" );\n}\n\nglobal proc setSamplePanelState( string $whichPanel ) {\n//\n//  Description:\n//        This is a convenience proc to set the panel state from the\n//        global array\n\n        global float $gSampleState[];\n\n       //  Scope the control names to this panel.\n       //\n       string $control = `scriptedPanel -q -control $whichPanel`;\n       if ("" != $control) {\n              setParent $control;\n\n              floatSliderGrp -e -v $gSampleState[0] fsg1;\n              floatSliderGrp -e -v $gSampleState[1] fsg2;\n              floatSliderGrp -e -v $gSampleState[2] fsg3;\n              if (0 != $gSampleState[3]) {\n               radioButtonGrp -e -sl $gSampleState[3] rbg;\n              };\n           if (0 != $gSampleState[4]) {\n               radioButtonGrp -e -sl $gSampleState[4] rbg2;\n           }\n       }\n}\n\n# Below is the python code to create and use scriptedPanelType and scriptedPanel using the MEL\n# callbacks defined above.\n\n# Use unique flag as we don\'t want two panels sharing the same global data.\ncmds.scriptedPanelType( \'sampleScriptedPanelType\', ccb=\'sampleCreateCallback\', icb=\'sampleInitCallback\', acb=\'sampleAddCallback\', rcb=\'sampleRemoveCallback\', dcb=\'sampleDeleteCallback\', scb=\'sampleSaveStateCallback\', unique=True )\n\n#  This script will create an unparented scripted panel, place it\n#  in one window, remove it, and place it in another window then\n#  return it to the first window.\n#\n#\n#  Create unparented scripted panel\n#\ncmds.scriptedPanel( \'sampleScriptedPanel\', unParent=True, type=\'sampleScriptedPanelType\', label=\'Sample\' )\n\n#    Create a couple of windows and parent the scripted panel to the first.\n#\ncmds.window( \'sampleWin\' )\ncmds.frameLayout( \'frm\', lv=False, bv=False )\ncmds.scriptedPanel( \'sampleScriptedPanel\', e=True, parent=\'sampleWin|frm\' )\ncmds.showWindow()\n\ncmds.window( \'sampleWin2\', w=cmds.window(\'sampleWin\', q=True, w=True), h=cmds.window(\'sampleWin\', q=True, h=True) )\ncmds.frameLayout( \'frm\', lv=False, bv=False )\ncmds.showWindow()\n\n#    Reparent the scripted panel to the second window.\n#\ncmds.scriptedPanel( \'sampleScriptedPanel\', e=True, unParent=True )\ncmds.scriptedPanel( \'sampleScriptedPanel\', e=True, parent=\'sampleWin2|frm\' )\n\n#    Reparent the scripted panel back to the first window.\n#\ncmds.scriptedPanel( \'sampleScriptedPanel\', e=True, unParent=True )\ncmds.scriptedPanel( \'sampleScriptedPanel\', e=True, parent=\'sampleWin|frm\' )\n\n#    Close both windows\n#\ncmds.window( \'sampleWin\', e=True, visible=False )\ncmds.window( \'sampleWin2\', e=True, visible=False )\n\n#    The scripted panel should appear in the Panel menu.  Select\n#    Panels->Panel->Sample and the panel should appear in the main window.\n#',
 'scriptedPanelType': 'import maya.cmds as cmds\n\n// NOTE: The scriptedPanelType command does not support python\n// \t\t callbacks; these callbacks must be MEL.\n\n\nglobal proc sampleCreateCallback(string $panelName) {\n//\n//  Description:\n//      Create any editors unparented here and do\n//      any other initialization required.\n//\n//      In this example we will only declare a global array to\n//        maintain some state information.\n//\n    global float $gSampleState[5];\n\n}\n\n\nglobal proc sampleInitCallback(string $panelName) {\n//\n//  Description:\n//      Re-initialize the panel on file -new or file -open.\n//\n//      In this example we will only re-init the global array.\n//\n    global float $gSampleState[];\n\n       $gSampleState[0] = 20.2;\n       $gSampleState[1] = 50.5;\n       $gSampleState[2] = 34.7;\n       $gSampleState[3] = 2.0;\n       $gSampleState[4] = 1.0;\n\n}\n\nglobal proc sampleAddCallback(string $panelName) {\n//\n//  Description:  Create UI and parent any editors.\n//\n    global float $gSampleState[];\n\n    columnLayout -adj true topCol;\n    separator -style "none" -h 10;\n        frameLayout -l "Sliders" -mw 10;\n            columnLayout -adj true sampleCol;\n                separator -style "none" -h 10;\n\n                floatSliderGrp -l "Property A" -f true\n                    -v $gSampleState[0]\n                    fsg1;\n                floatSliderGrp -l "Property B" -f true\n                    -v $gSampleState[1]\n                    fsg2;\n                floatSliderGrp -l "Property C" -f true\n                    -v $gSampleState[2]\n                    fsg3;\n                separator -style "none" -h 10;\n            setParent ..;\n        setParent ..;\n\n        separator -style "none" -h 10;\n        frameLayout -l "Radio Buttons" -mw 10;\n            columnLayout sampleCol2;\n                separator -style "none" -h 10;\n                radioButtonGrp -nrb 3\n                    -l "Big Options"\n                    -la3 "Option 1" "Option 2" "Option 3"\n                    -select $gSampleState[3]\n                    rbg;\n                radioButtonGrp -nrb 3\n                    -l "Little Options"\n                    -la3 "Option 4" "Option 5" "Option 6"\n                    -select $gSampleState[4]\n                    rbg2;\n                separator -style "none" -h 10;\n\n}\n\nglobal proc sampleRemoveCallback(string $panelName) {\n//\n//  Description:\n//        Unparent any editors and save state if required.\n//\n        global float $gSampleState[];\n       //  Scope the control names to this panel.\n       //\n       string $control = `scriptedPanel -q -control $panelName`;\n       setParent $control;\n\n       $gSampleState[0] = `floatSliderGrp -q -v fsg1`;\n       $gSampleState[1] = `floatSliderGrp -q -v fsg2`;\n       $gSampleState[2] = `floatSliderGrp -q -v fsg3`;\n       $gSampleState[3] = `radioButtonGrp -q -sl rbg`;\n       $gSampleState[4] = `radioButtonGrp -q -sl rbg2`;\n}\n\nglobal proc sampleDeleteCallback(string $panelName) {\n//\n//  Description:\n//        Delete any editors and do any other cleanup required.\n\n}\n\nglobal proc string sampleSaveStateCallback(string $panelName) {\n//\n//  Description:\n//        Return a string that will restore the current state\n//        when it is executed.\n\n        global float $gSampleState[];\n       $indent = "\\n\\t\\t\\t";\n\n       return ($indent+"$gSampleState[0]="+$gSampleState[0]+";" +\n               $indent+"$gSampleState[1]="+$gSampleState[1]+";" +\n               $indent+"$gSampleState[2]="+$gSampleState[2]+";" +\n               $indent+"$gSampleState[3]="+$gSampleState[3]+";" +\n               $indent+"$gSampleState[4]="+$gSampleState[4]+";" +\n               $indent+"setSamplePanelState $panelName;\\n" );\n}\n\nglobal proc setSamplePanelState( string $whichPanel ) {\n//\n//  Description:\n//        This is a convenience proc to set the panel state from the\n//        global array\n\n        global float $gSampleState[];\n\n       //  Scope the control names to this panel.\n       //\n       string $control = `scriptedPanel -q -control $whichPanel`;\n       if ("" != $control) {\n              setParent $control;\n\n              floatSliderGrp -e -v $gSampleState[0] fsg1;\n              floatSliderGrp -e -v $gSampleState[1] fsg2;\n              floatSliderGrp -e -v $gSampleState[2] fsg3;\n              if (0 != $gSampleState[3]) {\n               radioButtonGrp -e -sl $gSampleState[3] rbg;\n              };\n           if (0 != $gSampleState[4]) {\n               radioButtonGrp -e -sl $gSampleState[4] rbg2;\n           }\n       }\n}\n\n# Below is the python code to create and use scriptedPanelType and scriptedPanel using the MEL\n# callbacks defined above.\n\n# Use unique flag as we don\'t want two panels sharing the same global data.\ncmds.scriptedPanelType( \'sampleScriptedPanelType\', ccb=\'sampleCreateCallback\', icb=\'sampleInitCallback\', acb=\'sampleAddCallback\', rcb=\'sampleRemoveCallback\', dcb=\'sampleDeleteCallback\', scb=\'sampleSaveStateCallback\', unique=True )\n\n#  This script will create an unparented scripted panel, place it\n#  in one window, remove it, and place it in another window then\n#  return it to the first window.\n#\n#\n#  Create unparented scripted panel\n#\ncmds.scriptedPanel( \'sampleScriptedPanel\', unParent=True, type=\'sampleScriptedPanelType\', label=\'Sample\' )\n\n#    Create a couple of windows and parent the scripted panel to the first.\n#\ncmds.window( \'sampleWin\' )\ncmds.frameLayout( \'frm\', lv=False, bv=False )\ncmds.scriptedPanel( \'sampleScriptedPanel\', e=True, parent=\'sampleWin|frm\' )\ncmds.showWindow()\n\ncmds.window( \'sampleWin2\', w=cmds.window(\'sampleWin\', q=True, w=True), h=cmds.window(\'sampleWin\', q=True, h=True) )\ncmds.frameLayout( \'frm\', lv=False, bv=False )\ncmds.showWindow()\n\n#    Reparent the scripted panel to the second window.\n#\ncmds.scriptedPanel( \'sampleScriptedPanel\', e=True, unParent=True )\ncmds.scriptedPanel( \'sampleScriptedPanel\', e=True, parent=\'sampleWin2|frm\' )\n\n#    Reparent the scripted panel back to the first window.\n#\ncmds.scriptedPanel( \'sampleScriptedPanel\', e=True, unParent=True )\ncmds.scriptedPanel( \'sampleScriptedPanel\', e=True, parent=\'sampleWin|frm\' )\n\n#    Close both windows\n#\ncmds.window( \'sampleWin\', e=True, visible=False )\ncmds.window( \'sampleWin2\', e=True, visible=False )\n\n#    The scripted panel should appear in the Panel menu.  Select\n#    Panels->Panel->Sample and the panel should appear in the main window.\n#',
 'scrollField': "import maya.cmds as cmds\n\ncmds.window()\ncmds.paneLayout( configuration='horizontal4' )\ncmds.scrollField( editable=False, wordWrap=True, text='Non editable with word wrap' )\ncmds.scrollField( editable=False, wordWrap=False, text='Non editable with no word wrap' )\ncmds.scrollField( editable=True, wordWrap=True, text='Editable with word wrap' )\ncmds.scrollField( editable=True, wordWrap=False, text='Editable with no word wrap' )\ncmds.showWindow()",
 'scrollLayout': 'import maya.cmds as cmds\n\ncmds.window( widthHeight=(350, 150) )\nscrollLayout = cmds.scrollLayout(\n\thorizontalScrollBarThickness=16,\n\tverticalScrollBarThickness=16)\ncmds.rowColumnLayout( numberOfColumns=3 )\n\nfor index in range(10):\n\tcmds.text()\n\tcmds.intField()\n\tcmds.intSlider()\n\ncmds.showWindow()\n\nvalue = cmds.scrollLayout(scrollLayout, query=True, scrollAreaValue=True)\ntop = value[0]\nleft = value[1]',
 'sculpt': "import maya.cmds as cmds\n\ncmds.polyPlane(w=24,h=24,sx=20,sy=20)\n\n# Deforms whatever is currently on the selection list\ncmds.sculpt()\n\n# Increase the effect of the deformation\ncmds.sculpt( 'sculpt1', edit=True, maxDisplacement=3.0 )\n\n# Try another faster deformation mode\ncmds.sculpt( 'sculpt1', edit=True, mode='flip', insideMode='ring' )",
 'sculptKeyCtx': "import maya.cmds as cmds\n\n# Create a sculpt key context in grab mode.\ncmds.sculptKeyCtx('sculptKeyContext', mode=0)\n\n# Switch to smooth mode and set the sculpt radius to 50.\ncmds.sculptKeyCtx('sculptKeyContext', edit=True, mode=1, radius=50)\n\n# Set the strength for the grab and smooth modes to 50.\ncmds.sculptKeyCtx('sculptKeyContext', edit=True, modeStrength=((0,50),(1,50)))\n\n# Set the strength for all modes to 80.\ncmds.sculptKeyCtx('sculptKeyContext', edit=True, strengthAll=(80, 80, 80))",
 'sculptMeshCacheChangeCloneSource': "import maya.cmds as cmds\n\ncmds.sculptMeshCacheChangeCloneSource( bs='blendShape1', t='pSphere4' )",
 'sculptMeshCacheCtx': "import maya.cmds as cmds\n\n# Create a new sculpting context, then switch to it\ncmds.sculptMeshCacheCtx('sculptMeshCacheContext')\ncmds.setToolTo('sculptMeshCacheContext')\n\n# Set sculptMeshCacheContext's brush size to 10.0\ncmds.sculptMeshCacheCtx('sculptMeshCacheContext', edit=True, sz=10.0)",
 'sculptTarget': "import maya.cmds as cmds\n\n# To set the current editable target to target 3\ncmds.sculptTarget( 'blendShape1', e=True, t=3 )\n\n# To set the current editable target to none\ncmds.sculptTarget( 'blendShape1', e=True, t=-1 )",
 'selLoadSettings': "import maya.cmds as cmds\n\n# Given the scene:\n#\n#\n#        a [+]\n#       /     \\\n#      b [-]   c [+]\n#             /     \\\n#            d [-]   e [+]\n#\n# With the IDs:\n#    a = 0\n#    b = 1\n#    c = 2\n#    d = 3\n#    e = 4\n\n# set c, d, and e to the unloaded state\ncmds.selLoadSettings( '2', '3', '4', e=True, deferReference=1 )\n\n# this will also set c, d, and e to the unloaded state\ncmds.selLoadSettings( '2', e=True, deferReference=1 )\n\n# set b to the loaded state\ncmds.selLoadSettings( '1', e=True, deferReference=0 )\n\n# set b and d to the loaded state\ncmds.selLoadSettings( '1', '3', e=True, deferReference=0 )",
 'select': 'import maya.cmds as cmds\n\n# create some objects and add them to a set\ncmds.sphere( n=\'sphere1\' )\ncmds.sphere( n=\'sphere2\' )\ncmds.sets( \'sphere1\', \'sphere2\', n=\'set1\' )\n\n# select all dag objects and all dependency nodes\ncmds.select( all=True )\n\n# clear the active list\ncmds.select( clear=True )\n\n# select sphere2 only if it is visible\ncmds.select( \'sphere2\', visible=True )\n\n# select a couple of objects regardless of visibilty\ncmds.select( \'sphere1\', r=True )\ncmds.select( \'sphere2\', add=True )\n\n# remove one of the spheres from the active list (using toggle)\ncmds.select( \'sphere1\', tgl=True )\n\n# remove the other sphere from the active list\ncmds.select( \'sphere2\', d=True )\n\n# the following selects all the members of set1\ncmds.select( \'set1\' )\n\n# this selects set1 itself\ncmds.select( \'set1\', ne=True )\n\n\n# Some examples selecting with namespaces:\n\n# create a namespace and an object in the namespace\ncmds.namespace( add=\'foo\' )\ncmds.namespace( set=\'foo\' )\ncmds.sphere( n=\'bar\' )\n\n# \'select bar\' will not select "bar" unless bar is in the\n# root namespace. You need to qualify the name with the\n# namespace (shown below).\ncmds.select( \'foo:bar\' )\n\n# select all the objects in a namespace\ncmds.select( \'foo:*\' )',
 'selectContext': "import maya.cmds as cmds\n\n# Create a new select context, then switch to it\ncmds.selectContext('selectContext1')\ncmds.setToolTo('selectContext1')",
 'selectKey': 'import maya.cmds as cmds\n\n# Keys on animation curves are identified by either\n# their time values or their indices.  Times and indices can\n# be given as a range or list of ranges.\n\n# time=(\'10pal\',\'10pal\') means the key at frame 10 (PAL format).\n# time=[(\'1.0sec\',\'1.0sec\'),(\'15ntsc\',\'15ntsc\'),(20,20)] means the keys at time 1.0 second, frame 15 (in NTSC format), and time 20 (in the currently defined global time unit).\n# time=(10,20) means all keys in the range from 10 to 20, inclusive, in the current time unit.\n# Omitting one end of a range means "go to infinity", as in the following examples:\n# time=(10,None) means all keys from time 10 (in the current time unit) onwards.\n# time=(10,) means the same as (10,10)\n# time=(0,10) means all keys up to (and including) time 10 (in the current time unit).\n# time=(None,None) is a short form to specify all keys.\n# index=(0,0) means the first key of each animation curve. (Indices are 0-based.)\n# index=[(2,2),(5,5),(7,7)] means the 3rd, 6th, and 8th keys.\n# index=(1,5) means the 2nd, 3rd, 4th, 5th, and 6th keys of each animation curve.\n\n# Select all translateX keyframes on nurbsSphere1 in the range 10 to 20.\n#\ncmds.selectKey( \'nurbsSphere1\', time=(10,20), attribute=\'translateX\' )\n\n# select all the animation of the active objects, range 0-30\n#\ncmds.selectKey( time=(0,30) )',
 'selectKeyCtx': "import maya.cmds as cmds\n\n# Create a select key context for the graph editor\n#\ncmds.selectKeyCtx( 'selectKeyContext' )",
 'selectKeyframe': '',
 'selectKeyframeRegionCtx': "import maya.cmds as cmds\n\n# Create a select key context for the dope sheet editor\n#\ncmds.selectKeyframeRegionCtx( 'selectKeyframeRegionContext' )",
 'selectMode': 'import maya.cmds as cmds\n\ncmds.selectMode( object=True )\ncmds.selectMode( q=True, component=True )',
 'selectPref': 'import maya.cmds as cmds\n\ncmds.selectPref(popupMenuSelection=True,disableComponentPopups=True)',
 'selectPriority': 'import maya.cmds as cmds\n\ncmds.selectPriority( q=True, nurbsCurve=True )\ncmds.selectPriority( nurbsCurve=10 )\ncmds.selectPriority( handle=9, ikHandle=8 )',
 'selectType': 'import maya.cmds as cmds\n\ncmds.selectType( allObjects=True )\ncmds.selectType( q=True, cv=True )\ncmds.selectType( allObjects=True, allComponents=False )',
 'selectedNodes': '',
 'selectionConnection': 'import maya.cmds as cmds\n\n#    Example 1.\n#\n#    Create a window with two Outliner editors and a\n#    selection connection network.  Editor 1 will display the\n#    current scene\'s active list.  Editor 2 will display the items\n#    selected in Editor 1.\n#\nwindow = cmds.window(\'window\', wh=(400, 300))\ncmds.paneLayout( configuration=\'vertical2\' )\neditor1 = cmds.outlinerEditor()\neditor2 = cmds.outlinerEditor()\n\n#    Create the selection connection network.\n#\ninputList = cmds.selectionConnection( activeList=True )\nfromEditor1 = cmds.selectionConnection()\nfromEditor2 = cmds.selectionConnection()\ncmds.editor( editor1, edit=True, mainListConnection=inputList )\ncmds.editor( editor1, edit=True, selectionConnection=fromEditor1 )\ncmds.editor( editor2, edit=True, mainListConnection=fromEditor1 )\ncmds.editor( editor2, edit=True, selectionConnection=fromEditor2 )\n\ncmds.showWindow( window )\n\n#    Create some objects and select them.\n#\ncmds.sphere()\ncmds.cone()\ncmds.cylinder()\ncmds.select( all=True )\n\n# Now as you select objects on the left side, they will be\n# displayed on the right side.  You can also add a callback\n# script to do further processing on the list when objects\n# are added. (Use -removeScript for when objects are removed.)\n\ndef addScriptCallback( array ):\n    print "Contents of callback array: %s\\n" % array\n\ncmds.selectionConnection( fromEditor1, e=True, addScript=addScriptCallback )\n\n\n#    Example 2.\n#\n#    Create a selection connection for a paritcular object.  Delete\n#    the selection connection and the object.\n#\ncmds.sphere( name=\'sphere\' )\n\n#    Create a selection connection to wrap the sphere.\n#\ncmds.selectionConnection( \'holder\', object=\'sphere\' )\n\n#    Select the sphere using the selection connection.\n#\ncmds.select( \'holder\' )\n\n#    Delete the members (sphere) of the selection connection\n#\ncmds.delete( \'holder\' )\n\n#    Delete the selection connection (does not delete the members of\n#    the selection connection.\n#\ncmds.deleteUI( \'holder\' )',
 'separator': "import maya.cmds as cmds\n\ncmds.window()\ncmds.rowColumnLayout( numberOfColumns=2, columnAlign=(1, 'right'), columnAttach=(2, 'both', 0), columnWidth=(2, 150) )\n\ncmds.text( label='Default' )\ncmds.separator()\ncmds.text( label='None' )\ncmds.separator( style='none' )\ncmds.text( label='Single' )\ncmds.separator( style='single' )\ncmds.text( label='Etched In' )\ncmds.separator( height=40, style='in' )\ncmds.text( label='Etched Out' )\ncmds.separator( height=40, style='out' )\ncmds.setParent( '..' )\ncmds.showWindow()",
 'sequenceManager': 'import maya.cmds as cmds\n\n// Get the current Maya time, based on the Sequence time\ncmds.sequenceManager(q=True, currentTime=True);',
 'setAttr': 'import maya.cmds as cmds\n\ncmds.sphere( n="sphere" )\n\n# Set a simple numeric value\ncmds.setAttr( \'sphere.translateX\', 5 )\n\n# Lock an attribute to prevent further modification\ncmds.setAttr( \'sphere.translateX\', lock=True )\n\n# Make an attribute unkeyable\ncmds.setAttr( \'sphere.translateZ\', keyable=False )\n\n# Set an entire list of multi-attribute values in one command\ncmds.setAttr( \'sphereShape.weights[0:6]\',1, 1, 2, 1, 1, 1, 2,size=7)\n# Set an attribute with a compound numeric type\ncmds.setAttr(\'sphere.rotate\', 0, 45, 90, type="double3")\n\n# Clamp the value of the attribute to the min/max\n# Useful floating point math leaves the value just\n# a little out of range - here the min is .01\ncmds.setAttr( \'anisotropic1.roughness\', 0.0099978, clamp=True )\n\n# Set a multi-attribute with a compound numeric type\ncmds.setAttr( \'sphereShape.controlPoints[0:2]\', 0, 0, 0, 1, 1, 1, 2, 2, 2,type="double3" )',
 'setAttrMapping': "import maya.cmds as cmds\n\ncmds.attachDeviceAttr( d='spaceball', ax='XAxis', at='translateX' )\ncmds.setAttrMapping( d='spaceball', ax='XAxis', at='translateX', scale=0.01 )\n\n# The first command will assign the XAxis of the spaceball to\n# the translateX attribute of the selected objects.\n# The second command sets the scaling of attribute value to\n# 0.01 of the value of the axis. This results in finer control\n# since the motions of the spaceball are damped.",
 'setDefaultShadingGroup': 'import maya.cmds as cmds\n\n# Create a new blue shader\nblinn = cmds.shadingNode( \'blinn\', asShader=True )\ncmds.setAttr( blinn+".color", 0.15, 0.35, 1.0,  type=\'double3\' )\nblinnSG = cmds.sets( renderable=True, noSurfaceShader=True, empty=True, name=\'blinnSG\' );\ncmds.connectAttr( blinn+".outColor", blinnSG+".surfaceShader", force=True)\n\n# Make it the default\ncmds.setDefaultShadingGroup( blinnSG )',
 'setDrivenKeyframe': "import maya.cmds as cmds\n\n# Create a curve and a cone\n#\ncmds.curve(d=3,p=[(-10, 0, 0),(-6, 0, 10),(-3, 0, -10),(10, 0, 0)],k=[0, 0, 0, 1, 1, 1])\ncmds.polyCone()\n\n# To set the keyframe on the selected object's translateX based on\n# curve1's rotateZ:\ncmds.setDrivenKeyframe( at='translateX', cd='curve1.rz' )\n\n# To set the keyframe on pCone1.tx based on the value of curve1.rz:\ncmds.setDrivenKeyframe( 'pCone1.tx', cd='curve1.rz' )\n\n# To query the current driver of pCone1.tx:\ncmds.setDrivenKeyframe( 'pCone1.tx', q=True, cd=True )\n\n# To query the current driver count of pCone1.tx:\ncmds.setDrivenKeyframe( 'pCone1.tx', q=True, cnt=True, cd=True )\n\n# To query the available drivers of pCone1.tx:\ncmds.setDrivenKeyframe( 'pCone1.tx', q=True, dr=True )\n\n# To query the count of available drivers of pCone1.tx:\ncmds.setDrivenKeyframe( 'pCone1.tx', q=True, cnt=True, dr=True )",
 'setDynamic': "import maya.cmds as cmds\n\ncmds.setDynamic( 'myParticles', on=True )\n# Sets myParticles.isDynamic true.\n\ncmds.setDynamic( all=True, off=True )\n# Sets isDynamic false for all particle objects in the scene.",
 'setEditCtx': "import maya.cmds as cmds\n\ncmds.setEditCtx( 'setEditContext' )",
 'setFluidAttr': "import maya.cmds as cmds\n\n# set density for entire fluid\ncmds.setFluidAttr( at='density', fv=1.0 )\n\n# add 3.5 to the density at the cell x=1, y=2, z=3\ncmds.setFluidAttr( at='density', ad=True, fv-3.5, xi=1, yi=2, zi=3 )\n\n# clear the density for the whole fluid\ncmds.setFluidAttr( at='density', cl=True )\n\n# reset the velocity at the cell x=1, y=2, z=3\ncmds.setFluidAttr( at='velocity', re=True, xi=1, yi=2, zi=3 )\n\n# set the velocity at the centers of the voxels on plane y=5\n# to approximately (-1, 0, 0)\ncmds.setFluidAttr( at='velocity', vv=(-1, 0, 0), yi=5 )\n\n# set the Z-component of the velocity at the bottom of cell [0, 0, 0]\n# to exactly 1.3\ncmds.setFluidAttr( at='velocity', z=True, xi=0, yi=0, zi=0, fv=1.3 )\n\n# set the X-component of the velocity at the right of cell [5, 3, 2]\n# (which is also the left of cell [6, 3, 2]) to exactly 4.8\ncmds.setFluidAttr( at='velocity', x=True, xi=5, yi=3, zi=2, fv=4.8 )\n\n# set the density to a random value in the range 0.1 to 0.9\n# the fv flag specfies the base value, and then we add a a\n# random value in the range of -fr to +fr\ncmds.setFluidAttr( at='density', fv=0.5, fr=0.4 )",
 'setFocus': 'import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout()\ncmds.textField(\'tf0\', changeCommand=\'cmds.setFocus("tf1")\' )\ncmds.textField(\'tf1\', changeCommand=\'cmds.setFocus("tf2")\' )\ncmds.textField(\'tf2\', changeCommand=\'cmds.setFocus("tf0")\' )\ncmds.showWindow()',
 'setInfinity': 'import maya.cmds as cmds\n\n# Set preInfinite and postInfinite type on curves of currently selected objects\n#\ncmds.setInfinity( pri=\'linear\', poi=\'constant\' )\n\n# Set postInfinite type of cube1\'s curves\n#\ncmds.setInfinity( \'cube1\', poi=\'oscillate\' )\n\n# Set preInfinite type of cube1\'s "Translate X" curve\n#\ncmds.setInfinity( \'cube1\', pri=\'linear\', attribute=\'translateX\' )',
 'setInputDeviceMapping': 'import maya.cmds as cmds\n\ncmds.assignInputDevice( \'"move -r XAxis YAxis ZAxis"\', d=\'spaceball\' )\ncmds.setInputDeviceMapping( d=\'spaceball\', ax=[\'XAxis\', \'YAxis\', \'ZAxis\'], scale=0.01, r=True )\n\n# The first command will assign the move command to the spaceball.\n# The second command will scale the three named axes by 0.01 and\n# only return the changes in device position.',
 'setKeyCtx': "import maya.cmds as cmds\n\n# Create a set key context for the graph editor\n#\ncmds.setKeyCtx( 'setKeyContext' )",
 'setKeyPath': 'import maya.cmds as cmds\n\n# Apply setKeyPath command on the currently selected object at current time:\ncmds.setKeyPath()\n\n# Apply setKeyPath command on an object named "ball" at current time:\ncmds.setKeyPath( \'ball\' )',
 'setKeyframe': 'import maya.cmds as cmds\n\n# Set a keyframe at the current time on all "keyable"\n# attributes of the selected objects.\n#\ncmds.setKeyframe()\n\n# Set a keyframe so that translateX has a value of 10\n# at the current time, regardless of its current position\n#\ncmds.setKeyframe( v=10, at=\'translateX\' )\n\n# Set keyframes for translateX on two objects at t=0 and\n# t=10 seconds.  (Note that if mysteryObject has no\n# attribute named translateX, no keyframe is set for mysteryObject.)\n#\ncmds.setKeyframe( \'nurbsSphere1\', \'mysteryObject\', attribute=\'translateX\', t=[\'0sec\',\'10sec\'] )',
 'setKeyframeBlendshapeTargetWts': "import maya.cmds as cmds\n\n# first create a blendShape\n#\ncmds.polySphere()\ncmds.duplicate()\ncmds.duplicate()\ncmds.select( 'pSphere2', 'pSphere1', 'pSphere3', r=True )\ncmds.blendShape()\n\n# Select one of the targets, and key its per-point weights.\n# Typically this would be done after painting per-point weights\n# for the target.\n#\ncmds.select( 'pSphere2', r=True )\ncmds.setKeyframeBlendshapeTargetWts()",
 'setMenuMode': 'import maya.cmds as cmds\n\n# Use the "Rendering" Menu Set, and at the same time get the one currently used.\nprevMenuMode = cmds.setMenuMode(\'renderingMenuSet\')\n\n# Print the current Menu Set: "renderingMenuSet".\nprint( cmds.setMenuMode() )',
 'setNodeTypeFlag': 'import maya.cmds as cmds\n\n# don\'t display unit conversion nodes\ncmds.setNodeTypeFlag( cmds.objectType(tagFromType=\'unitConversion\'), display=False )\n# Returns True\n\n# don\'t display legacy render layers\ncmds.setNodeTypeFlag("renderLayer", display=False)\n# Returns True\n\n# ask for the value of the display flag of unit conversion nodes\ncmds.setNodeTypeFlag(cmds.objectType(tagFromType=\'unitConversion\'), query=True, display=True)\n# Returns False\n\n# ask for the value of the display flag of legacy render layers nodes\ncmds.setNodeTypeFlag("renderLayer", query=True, display=True)\n# Returns False',
 'setParent': 'import maya.cmds as cmds\n\n#  Create a window with a menu bar and two menu bar layouts.\n#\nwindow = cmds.window(menuBar=True, widthHeight=(300, 200) )\nfileMenu = cmds.menu( label=\'File\')\ncmds.menuItem( label=\'Open\' )\n\ncmds.paneLayout( configuration=\'vertical2\' )\n\nleftMenuBarLayout = cmds.menuBarLayout()\nleftMenu = cmds.menu( label=\'Left\' )\ncmds.menuItem( label=\'One\' )\ncmds.setParent( \'..\' )\n\ncmds.menuBarLayout()\ncmds.menu( label=\'Right\' )\nrightSubMenu = cmds.menuItem(subMenu=True, label=\'Colors\' )\ncmds.setParent( \'..\' )\ncmds.showWindow( window )\n\n#  Add item to the "File" menu.\n#\ncmds.setParent( fileMenu, menu=True )\ncmds.menuItem( label=\'Save\' )\n\n#  Add item to the "Left" menu, explicitly ignore default parent\n#    by setting -p/parent flag.\n#\ncmds.menuItem( parent=leftMenu, label=\'Two\' )\n\n#  Add more items to the "File" menu because it is still the\n#    default parent.\n#\ncmds.menuItem( divider=True )\ncmds.menuItem( label=\'Close\' )\n\n#  Add another menu to the left menu bar layout.\n#\ncmds.setParent( leftMenuBarLayout )\ncmds.menu( label=\'Middle\' )\ncmds.menuItem( label=\'Three\' )\n\n#  Add items to right sub menu.\n#\ncmds.setParent( rightSubMenu, menu=True )\ncmds.menuItem( label=\'Red\' )\ncmds.menuItem( label=\'Blue\' )\ncmds.menuItem( label=\'Green\' )',
 'setParticleAttr': "import maya.cmds as cmds\n\ncmds.setParticleAttr( 'particle1', at='velocity', vv=(1, 2, 3) )\n# This will set the velocity of all of the particles in particle1\n# to << 1, 2, 3 >>.\n\ncmds.select( 'particleShape1.pt[0:7]', 'particleShape1.pt[11]' )\ncmds.setParticleAttr( vv=(1, 2, 3), at='velocity' )\ncmds.setParticleAttr( 'particleShape1', at='velocity' )\n\n# This will set the velocity of particles 0-7 and 11 of\n# particleShape1 to << 1, 2, 3 >>.  The rest of the particles are\n# not changed.",
 'setRenderPassType': "import maya.cmds as cmds\n\n# create a render pass for diffuse reflection\n#\ncmds.createNode( 'renderPass', name='myDiffusePass' );\n# Result: myDiffusePass #\n\ncmds.setRenderPassType( 'myDiffusePass', type='diffuse' );\n# Result: true #",
 'setStartupMessage': "import maya.cmds as cmds\n\ncmds.setStartupMessage( 'Initializing Main View' )",
 'setToolTo': "import maya.cmds as cmds\n\ncmds.setToolTo( 'moveSuperContext' )",
 'setUITemplate': "import maya.cmds as cmds\n\n#    Create a new template.\n#\nif cmds.uiTemplate( 'ExampleTemplate', exists=True ):\n\tcmds.deleteUI( 'ExampleTemplate', uiTemplate=True )\n\ncmds.uiTemplate( 'ExampleTemplate' )\n\ncmds.button( defineTemplate='ExampleTemplate', width=100, height=40, align='left' )\ncmds.frameLayout( defineTemplate='ExampleTemplate', borderVisible=True, labelVisible=False )\n\n#    Create a window and apply the template.\n#\nwindow = cmds.window()\ncmds.setUITemplate( 'ExampleTemplate', pushTemplate=True )\ncmds.columnLayout( rowSpacing=5 )\n\ncmds.frameLayout()\ncmds.columnLayout()\ncmds.button( label='One' )\ncmds.button( label='Two' )\ncmds.button( label='Three' )\ncmds.setParent( '..' )\ncmds.setParent( '..' )\n\ncmds.frameLayout()\ncmds.columnLayout()\ncmds.button( label='Red' )\ncmds.button( label='Green' )\ncmds.button( label='Blue' )\ncmds.setParent( '..' )\ncmds.setParent( '..' )\n\ncmds.setUITemplate( popTemplate=True )\n\ncmds.showWindow( window )",
 'setXformManip': 'import maya.cmds as cmds\n\n# makes manip disappear\ncmds.setXformManip( suppress=True )\n\n# set manip to object space\ncmds.setXformManip( worldSpace=False )\n\n# returns false\ncmds.setXformManip( q=True, ws=True )',
 'sets': 'import maya.cmds as cmds\n\n# create some objects\ncmds.sphere( n="sphere1" )\ncmds.cone( n="cone1" )\n\n# create a set with whatever is currently active\ncmds.select( \'sphere1\' )\nnewSet1 = cmds.sets()\ncmds.select( \'cone1\' )\nnewSet2 = cmds.sets()\n\n# Query the members of a set\ncmds.sets( newSet1, q=True )\n\n# create a set which contains two sets\ncmds.sets( newSet1, newSet2, n="setOfSets" )\n\n# To select a set, the -noExpand flag must be used. Otherwise\n# the members of a set are selected instead.\ncmds.select( newSet1, noExpand=True )\ncmds.ls( selection=True )\n\n# Select the members of a set\ncmds.select( newSet1 )\ncmds.ls( selection=True )\n\n# Create a vertex set named ballVertices. This will contain\n# all the vertices of the sphere.\ncmds.sets( \'sphere1\', n="ballVertices", v=1 )\ncmds.select( \'ballVertices\' )\n\n# Return the union of two sets\ncmds.sets( newSet2, un=newSet1 )\n\n# Test whether a list of sets have common members\ncmds.sets( \'ballVertices\',ii=newSet1)\n\n# Test whether the sphere is a member of the set\ncmds.sets(\'sphere1\',im=newSet1)\n\n# Remove the sphere from a set\ncmds.sets( \'sphere1\', rm=newSet1 )\n\n# Test again whether the sphere is a member of the set\ncmds.sets( \'sphere1\', im=newSet1 )',
 'shadingConnection': "import maya.cmds as cmds\n\ncmds.shadingConnection( 'lambert1.color', e=True, cs=0 )\ncmds.shadingConnection( 'spotLightShape1.intensity', q=True, cs=True )",
 'shadingGeometryRelCtx': 'import maya.cmds as cmds\n\ncmds.shadingGeometryRelCtx()',
 'shadingLightRelCtx': 'import maya.cmds as cmds\n\ncmds.shadingLightRelCtx()',
 'shadingNetworkCompare': "import maya.cmds as cmds\n\n\ncmds.shadingNetworkCompare( 'blinn1SG', 'blinn2SG' )\n# Result: shadingNetworkComparison1\n\ncmds.shadingNetworkCompare( 'shadingNetworkComparison1', query=True, equivalent=True )\n# Result: 1\n\ncmds.shadingNetworkCompare( 'shadingNetworkComparison1', query=True, network1=True )\n# Result: blinn1SG blinn1\n\ncmds.shadingNetworkCompare( 'shadingNetworkComparison1', delete=True )",
 'shadingNode': "import maya.cmds as cmds\n\ncmds.createNode( 'transform', n='transform1' )\ncmds.createNode( 'nurbsSurface', n='surface1', p='transform1' )\ncmds.createNode( 'camera', shared=True, n='top' )\n\n# This transform will be selected when created\ncmds.createNode( 'transform', n='selectedTransform' )\n\n# This will create a new transform node, but 'selectedTransform'\n# will still be selected.\ncmds.createNode( 'transform', ss=True )\n\n# Create node under new namespace\ncmds.createNode( 'transform', n='newNS:transform1' )\n\nmyShader = cmds.shadingNode('anisotropic', asShader=True)",
 'shapeCompare': "import maya.cmds as cmds\n\ncmds.polySphere()\ncmds.polySphere()\ncmds.select( cl=True )\ncmds.select( 'pSphere1', 'pSphere2', r=True )\ncmds.shapeCompare()",
 'shapeEditor': "import maya.cmds as cmds\n\ncmds.shapeEditor( 'shapeEd' )",
 'shapePanel': "import maya.cmds as cmds\n\ncmds.shapePanel( 'bsP' )",
 'shelfButton': 'import maya.cmds as cmds\n\n#    Create a window with a shelf in it.  You can add more items to\n#    this shelf by creating more \'shelfButton\' objects or by dragging\n#    other shelf items to the window.  Similarly, you can delete the\n#    shelf items with the \'deleteUI\' command or by dragging the items\n#    to the trash can located on the main Maya window shelf.\n#\nwindow = cmds.window( title = \'shelfButton Example\')\ntabs = cmds.tabLayout()\nshelf = cmds.shelfLayout()\n\n#    Create some shelf buttons...\n#\n#    1.  A button that prints a message to the Command Line.\n#\ncmds.shelfButton( annotation=\'Print "Hello".\', image1=\'commandButton.png\', command=\'print "Hello\\\\n"\' )\n\n#    2.  A button that will create a sphere.\n#\ncmds.shelfButton( annotation=\'Create a sphere.\', image1=\'sphere.png\', command=\'cmds.sphere()\' )\n\n#    3.  A button that will open the Attribute Editor window.\n#\ncmds.shelfButton(annotation=\'Show the Attribute Editor.\', image1=\'menuIconWindow.png\', command=\'import maya.mel; maya.mel.eval("openAEWindow")\' )\n\n#    4.  A button with a label that will create a cone\n#\ncmds.shelfButton(annotation=\'Create a cone.\', image1=\'cone.png\', command=\'cmds.cone()\', imageOverlayLabel=\'4th\')\n\n#    5.  A button with a label and color that will call undo\n#\ncmds.shelfButton(annotation="Undo last operation.",\n    image1="undo.png", command="undo", imageOverlayLabel="undo",\n    overlayLabelColor=(1, .25, .25))\n\n#    6.  A button with a label, color and background that will call redo\n#\ncmds.shelfButton(annotation="Redo last operation.",\n    image1="redo.png", command="redo", imageOverlayLabel="redo",\n    overlayLabelColor=(1, 1, .25), overlayLabelBackColor=(.15, .9, .1, .4))\n\ncmds.tabLayout( tabs, edit=True, tabLabel=(shelf, \'Example Shelf\') )\n\ncmds.showWindow( window )',
 'shelfLayout': 'import maya.cmds as cmds\n\n# Create 4 shelves with 3 icons\ncmds.window()\ncmds.tabLayout()\n\nsh1 = cmds.shelfLayout("First", style="iconOnly",\n\t\t\t\t\t   backgroundColor=(.9, .2, .2))\nsh1b1 = cmds.shelfButton(image1="textureEditor.png",\n\t\t\t\t\t\t label="textureEditor", annotation="textureEditor",\n\t\t\t\t\t\t command="TextureViewWindow",\n\t\t\t\t\t\t imageOverlayLabel="1",\n\t\t\t\t\t\t overlayLabelColor=(.1, .1, .1),\n\t\t\t\t\t\t overlayLabelBackColor=(1, .25, .25, .5))\nsh1b2 = cmds.shelfButton(image1="undo.png",\n\t\t\t\t\t\t label="undo", annotation="undo",\n\t\t\t\t\t\t command="undo",\n\t\t\t\t\t\t imageOverlayLabel="1",\n\t\t\t\t\t\t overlayLabelColor=(.1, .1, .1),\n\t\t\t\t\t\t overlayLabelBackColor=(1, .25, .25, .5))\nsh1b3 = cmds.shelfButton(image1="redo.png",\n\t\t\t\t\t\t label="redo", annotation="redo",\n\t\t\t\t\t\t command="redo",\n\t\t\t\t\t\t imageOverlayLabel="1",\n\t\t\t\t\t\t overlayLabelColor=(.1, .1, .1),\n\t\t\t\t\t\t overlayLabelBackColor=(1, .25, .25, .5))\ncmds.setParent(\'..\')\n\nsh2 = cmds.shelfLayout("Second", style="textOnly",\n\t\t\t\t\t   backgroundColor=(.2, .9, .2))\nsh2b1 = cmds.shelfButton(image1="textureEditor.png",\n\t\t\t\t\t\t label="textureEditor", annotation="textureEditor",\n\t\t\t\t\t\t command="TextureViewWindow",\n\t\t\t\t\t\t imageOverlayLabel="2",\n\t\t\t\t\t\t overlayLabelColor=(.1, .1, .1),\n\t\t\t\t\t\t overlayLabelBackColor=(.25, 1, .25, .5))\nsh2b2 = cmds.shelfButton(image1="undo.png",\n\t\t\t\t\t\t label="undo", annotation="undo",\n\t\t\t\t\t\t command="undo",\n\t\t\t\t\t\t imageOverlayLabel="2",\n\t\t\t\t\t\t overlayLabelColor=(.1, .1, .1),\n\t\t\t\t\t\t overlayLabelBackColor=(.25, 1, .25, .5))\nsh2b3 = cmds.shelfButton(image1="redo.png",\n\t\t\t\t\t\t label="redo", annotation="redo",\n\t\t\t\t\t\t command="redo",\n\t\t\t\t\t\t imageOverlayLabel="2",\n\t\t\t\t\t\t overlayLabelColor=(.1, .1, .1),\n\t\t\t\t\t\t overlayLabelBackColor=(.25, 1, .25, .5))\ncmds.setParent(\'..\')\n\nsh3 = cmds.shelfLayout("Third", style="iconAndTextHorizontal",\n\t\t\t\t\t   backgroundColor=(.2, .2, .9))\nsh3b1 = cmds.shelfButton(image1="textureEditor.png",\n\t\t\t\t\t\t label="textureEditor", annotation="textureEditor",\n\t\t\t\t\t\t command="TextureViewWindow",\n\t\t\t\t\t\t imageOverlayLabel="3",\n\t\t\t\t\t\t overlayLabelColor=(.1, .1, .1),\n\t\t\t\t\t\t overlayLabelBackColor=(.25, .25, 1, .5))\nsh3b2 = cmds.shelfButton(image1="undo.png",\n\t\t\t\t\t\t label="undo", annotation="undo",\n\t\t\t\t\t\t command="undo",\n\t\t\t\t\t\t imageOverlayLabel="3",\n\t\t\t\t\t\t overlayLabelColor=(.1, .1, .1),\n\t\t\t\t\t\t overlayLabelBackColor=(.25, .25, 1, .5))\nsh3b3 = cmds.shelfButton(image1="redo.png",\n\t\t\t\t\t\t label="redo", annotation="redo",\n\t\t\t\t\t\t command="redo",\n\t\t\t\t\t\t imageOverlayLabel="3",\n\t\t\t\t\t\t overlayLabelColor=(.1, .1, .1),\n\t\t\t\t\t\t overlayLabelBackColor=(.25, .25, 1, .5))\ncmds.setParent(\'..\')\n\n\nsh4 = cmds.shelfLayout("Fourth", style="iconAndTextVertical")\nsh4b1 = cmds.shelfButton(image1="textureEditor.png",\n\t\t\t\t\t\t label="textureEditor", annotation="textureEditor",\n\t\t\t\t\t\t command="TextureViewWindow",\n\t\t\t\t\t\t imageOverlayLabel="4",\n\t\t\t\t\t\t overlayLabelColor=(.1, .1, .1),\n\t\t\t\t\t\t overlayLabelBackColor=(.25, 1, 1, .5))\nsh4b2 = cmds.shelfButton(image1="undo.png",\n\t\t\t\t\t\t label="undo", annotation="undo",\n\t\t\t\t\t\t command="undo",\n\t\t\t\t\t\t imageOverlayLabel="4",\n\t\t\t\t\t\t overlayLabelColor=(.1, .1, .1),\n\t\t\t\t\t\t overlayLabelBackColor=(.25, 1, 1, .5))\nsh4b3 = cmds.shelfButton(image1="redo.png",\n\t\t\t\t\t\t label="redo", annotation="redo",\n\t\t\t\t\t\t command="redo",\n\t\t\t\t\t\t imageOverlayLabel="4",\n\t\t\t\t\t\t overlayLabelColor=(.1, .1, .1),\n\t\t\t\t\t\t overlayLabelBackColor=(.25, 1, 1, .5))\ncmds.setParent(\'..\')\n\ncmds.setParent(\'..\')\ncmds.showWindow()\n\n# Move some icons around\n\n# Move undo to the first position in shelf 1\ncmds.shelfLayout(sh1, edit=True, position=(sh1b2, 1))\n\n# This does nothing\ncmds.shelfLayout(sh2, edit=True, position=(sh2b2, 2))\n\n# Move undo to the last position in shelf 3\ncmds.shelfLayout(sh3, edit=True, position=(sh3b2, 3))\n\n# Swap textureEditor and redo in shelf 4\ncmds.shelfLayout(sh4, edit=True, position=[(sh4b1, 3), (sh4b3, 1)])',
 'shelfTabLayout': "import maya.cmds as cmds\n\ncmds.window()\ncmds.shelfTabLayout( 'mainShelfTab', image='smallTrash.png', imageVisible=True )\ncmds.shelfLayout( 'Dynamics' )\ncmds.setParent( '..' )\ncmds.shelfLayout( 'Rendering' )\ncmds.setParent( '..' )\ncmds.shelfLayout( 'Animation' )\ncmds.setParent( '..' )\ncmds.showWindow()",
 'shot': "import maya.cmds as cmds\n\nmyShot = cmds.shot('myShot', st=10, et=19);\ncmds.shot(myShot, e=True, sst=100, set=119);\n\ncmds.shot(myShot, q=True, st=True);\n# Result: 10.0 #\n\ncmds.shot(myShot, q=True, sst=True);\n# Result: 100.0 #\n\ncmds.shot(myShot, e=True, pst=10);\ncmds.shot(myShot, q=True, set=True);\n# Result: 119.0 #\n\ncmds.shot(myShot, e=True, prt=5);\ncmds.shot(myShot, q=True, set=True);\n# Result: 124.0 #\n\ncmds.shot(myShot, q=True, sd=True);\n# Result: 25.0 #",
 'shotRipple': 'import maya.cmds as cmds\n\n\n\n// A shot initially starting at sequence time 0 was edited to start 10 frames later.\n// adjust the rest of the shots accordingly\ncmds.shotRipple(shotName, startTime=0, startDelta=10)\n\n// A shot initially ending at frame 10 was edited to start 5 frames earlier.\n// adjust the rest of the shots accordingly\ncmds.shotRipple(shotName, endTime=10, endDelta=-5)\n\n// A shot starting at frame 10 and ending at frame 20 was just deleted\n// adjust the rest of the shots accordingly (if necessary)\ncmds.shotRipple(shotName, delete=1,startTime=10,endTime=20)',
 'shotTrack': 'import maya.cmds as cmds\n\n\n# Create 3 sequencer tracks with appropriate names.\n# Note that sequencer tracks are 1-indexed.\n#\ncmds.file(f=True,new=True)\nfor i in xrange(1,4):\n    cmds.shotTrack(insertTrack=i, title="Track %d"%i)\n\n# Add some shots to the tracks.\n# By default, shots get added to the active track,\n# which is currently track 1. If tracks overlap in sequence time\n# they will be put onto a different track.\n#\ncmds.shot("shot1", sequenceStartTime=10, startTime=20, endTime=39)\ncmds.shot("shot2", sequenceStartTime=30, startTime=10, endTime=29)\ncmds.shot("shot3", sequenceStartTime=50, startTime=60, endTime=79)\n\n# Use the shot command to move shots to different tracks\ncmds.shot("shot1", e=True, track=1)\ncmds.shot("shot2", e=True, track=2)\ncmds.shot("shot3", e=True, track=3)\n\n# Insert an empty track at index 2\ncmds.shotTrack(insertTrack=2)\n\n# Lock the track containing shot3\ncmds.shotTrack("shot3", lock=True)\n\n# Mute the track containing shot1\ncmds.shotTrack("shot1", mute=True)\n\n# Remove track 2\ncmds.shotTrack(removeTrack=2);\n\n# Query the track title for the first track\ncmds.shotTrack(q=True, track=2, title=True)',
 'showHelp': 'import maya.cmds as cmds\n\n# View the documentation for the launchBrowser command\n#\ncmds.showHelp( \'Commands/showHelp.html\', docs=True )\n\n# View the Autodesk home page\n#\ncmds.showHelp( \'http://www.autodesk.com/\', absolute=True )\n\n# Query for the full path to the help page on the Align Tool\n#\ncmds.showHelp( \'AlignTool\', q=True )\n\n# Set the help lookup-table to $MAYA_APP_DIR/customHelpTable\n#\ncmds.showHelp( \'customHelpTable\', helpTable=True )\n\n# View the help topic "Particle" found in customHelpTable.dat\n#\ncmds.showHelp( \'Particle\' )',
 'showHidden': "import maya.cmds as cmds\n\n# create a sphere and group it, then hide the sphere and the group.\ncmds.sphere( n='sphere1' )\ncmds.group( n='group1' )\ncmds.hide( 'group1', 'sphere1' )\n\n# make the sphere visible. Note that you still can't see it\n# because the group is invisible.\ncmds.showHidden( 'sphere1' )\n\n# make the sphere and the group visible.\ncmds.showHidden( 'sphere1', above=True )\n\n# make everything visible. This will make the cameras (which are\n# normally invisible) visible as well.\ncmds.showHidden( all=True )",
 'showManipCtx': 'import maya.cmds as cmds\n\n# Creates a new show manip context.\ncmds.showManipCtx()',
 'showMetadata': 'import maya.cmds as cmds\n\nimport maya.cmds as cmds\n\n#Create a scene\ncmds.file(force=True, new=True)\ncmds.dataStructure(format="raw", asString="name=StructOne:int32=MemberOne")\ncmds.polyPlane(constructionHistory=False, name="mesh")\n\n#Add Metadata\ncmds.addMetadata(\'meshShape\', streamName="StreamOne", channelName="vertex", structure="StructOne")\ncmds.editMetadata(\'meshShape.vtx[1]\', streamName="StreamOne", channelName="vertex", memberName="MemberOne", value=1)\ncmds.select(clear=True)\n\ncmds.showMetadata(\'meshShape\', member="MemberOne", dataType="int32", stream="StreamOne")\n#Show metadata for which the member is "MemberOne" and the stream is "StreamOne"\n\ncmds.showMetadata(\'meshShape\', stream="StreamOne", member="MemberOne", dataType="int32", method="color")\n#StreamOne will be visualized by Component Color method. The other two visualization methods are\n#"string" and "ray". If "-method" flag is not defined, "color" will be used by default.\n\ncmds.showMetadata(off=True)\n#Deactivate all streams to turn off metadata visualization\n\ncmds.showMetadata(stream="StreamOne", member="MemberOne", dataType="int32", method="color", interpolation=True)\n#Enable interpolation on "color" mode. Interpolation must be used with "color" method\n\ncmds.showMetadata(range=[0, 10], stream="StreamOne", member="MemberOne", dataType="int32")\n#Show metadata between a specified range from 0 to 10. If the method is "color",\n# the value 0 will be displayed in black, while the value 10 will be displayed\n# in white. The value beyond the range will be clamped to 0 or 10.\n\ncmds.showMetadata(\'meshShape\', auto=True, stream="StreamOne", member="MemberOne", dataType="int32")\n#Show metadata between the dynamic range, which is computed by the current min/max value\n\ncmds.showMetadata(query=True, listAllStreams=True)\n#Return all streams in the scene, no matter if they are activated\n\ncmds.showMetadata(\'meshShape\', query=True, listAllStreams=True)\n#Return all streams of meshShape, no matter if they are activated\n\ncmds.showMetadata(query=True, listVisibleStreams=True)\n#Return the stream name(s) being visualized in the scene\n\ncmds.showMetadata(\'meshShape\', query=True, listVisibleStreams=True)\n#Return the stream name being visualized that is attached to meshShape\n\ncmds.showMetadata(query=True, stream="StreamOne", listMembers=True)\n#Return the member names and types in the specified stream\n#The names and types are returned in pair, such as "MemberOne int32 MemberTwo float"\n\ncmds.showMetadata(query=True, stream="StreamOne", member="MemberOne", dataType="int32", method=True)\n#Return the visualization method of the visualized StreamOne\n\ncmds.showMetadata(query=True, stream="StreamOne", member="MemberOne", dataType="int32", listValidMethods=True)\n#Return the valid visual methods of the activated stream that can be set\n\ncmds.showMetadata(query=True, stream="StreamOne", member="MemberOne", dataType="int32", range=True)\n#Return the current range of visible metadata\n\ncmds.showMetadata(query=True, stream="StreamOne", member="MemberOne", dataType="int32", auto=True)\n#Return the current state of the auto flag',
 'showSelectionInTitle': "import maya.cmds as cmds\n\nwindow = cmds.window(widthHeight=(400, 100))\ncmds.paneLayout()\ncmds.scrollField(wordWrap=True, text='The title of this window will reflect the current object selection.')\ncmds.showWindow(window)\n\ncmds.showSelectionInTitle(window)\ncmds.sphere()",
 'showShadingGroupAttrEditor': 'import maya.cmds as cmds\n\ncmds.showShadingGroupAttrEditor()',
 'showWindow': "import maya.cmds as cmds\n\ncmds.showWindow( 'myWindow1' )",
 'simplify': 'import maya.cmds as cmds\n\n# Keys on animation curves are identified by either\n# their time values or their indices.  Times and indices can\n# be given as a range or list of ranges.\n\n# time=(\'10pal\',\'10pal\') means the key at frame 10 (PAL format).\n# time=[(\'1.0sec\',\'1.0sec\'),(\'15ntsc\',\'15ntsc\'),(20,20)] means the keys at time 1.0 second, frame 15 (in NTSC format), and time 20 (in the currently defined global time unit).\n# time=(10,20) means all keys in the range from 10 to 20, inclusive, in the current time unit.\n# Omitting one end of a range means "go to infinity", as in the following examples:\n# time=(10,None) means all keys from time 10 (in the current time unit) onwards.\n# time=(10,) means the same as (10,10)\n# time=(0,10) means all keys up to (and including) time 10 (in the current time unit).\n# time=(None,None) is a short form to specify all keys.\n# index=(0,0) means the first key of each animation curve. (Indices are 0-based.)\n# index=[(2,2),(5,5),(7,7)] means the 3rd, 6th, and 8th keys.\n# index=(1,5) means the 2nd, 3rd, 4th, 5th, and 6th keys of each animation curve.\n\ncmds.polySphere()\ncmds.setKeyframe( \'.tx\' )\ncmds.simplify( time=(1,10) )',
 'singleProfileBirailSurface': 'import maya.cmds as cmds\n\n#Create a surface by sweeping profile "curve1" along the two rails\n#given by isoparms surface1.u[0] and surface2.u[0.5].\ncmds.singleProfileBirailSurface( \'curve1\', \'surface1.u[0]\', \'surface2.u[0.5]\', ch=True )\n\n# create a tangent continuous surface across the profile.\ncmds.singleProfileBirailSurface( \'surface1.u[0]\', \'curve1\', \'curve2\', ch=True, tp1=True )',
 'skeletonEmbed': "import maya.cmds as cmds\n\n\n# First select the shape, not the transform.\ncmds.select( 'characterShape' , r=True )\n\n# Embed skeleton using default parameter.\ncmds.skeletonEmbed( )\n# Result: u'{ [...] (A JSON dictionary with the description of the embedding. }' #\n\n# For debugging: get the merged mesh that will be used\ncmds.skeletonEmbed( query=True , mergedMesh=True )\n# Result: u'{ [...] (A JSON dictionary with the description of the merged mesh. }' #\n\n# Embed skeleton using polygon soup and 512 resolution.\ncmds.skeletonEmbed( segmentationMethod=3 , segmentationResolution=512 )\n\n\n# This method creates a few joints to see the embedding.\nimport json\ndef createJointsFromEmbedding( embeddingString ):\n    embedding = json.loads( embeddingString )\n    for name , position in embedding[ 'joints' ].items( ):\n        joint = cmds.createNode( 'joint' , name=name )\n        cmds.xform( joint , worldSpace=True , translation=position )\n\nresult = cmds.skeletonEmbed( )\ncreateJointsFromEmbedding( result )\n\n\n# This method creates a mesh from the merged mesh to see it.\nimport json\nimport maya.OpenMaya as OpenMaya\ndef createMeshFromDescription( meshString ):\n    mesh = json.loads( meshString )\n\n    meshPoints = mesh[ 'points' ]\n    meshFaces  = mesh[ 'faces' ]\n    factor     = 1.0 / mesh[ 'conversionFactor' ]\n\n    # Vertices\n    vertexArray = OpenMaya.MFloatPointArray()\n    for i in range( 0 , len( meshPoints ) , 3 ):\n        vertex = OpenMaya.MFloatPoint( meshPoints[ i ] * factor , meshPoints[ i + 1 ] * factor , meshPoints[ i + 2 ] * factor )\n        vertexArray.append( vertex )\n    numVertices = vertexArray.length()\n\n    # Faces\n    polygonCounts   = OpenMaya.MIntArray()\n    polygonConnects = OpenMaya.MIntArray()\n    for face in meshFaces:\n        for i in face:\n            polygonConnects.append( i )\n        polygonCounts.append( len( face ) )\n    numPolygons = polygonCounts.length()\n\n    fnMesh = OpenMaya.MFnMesh()\n    newMesh = fnMesh.create( numVertices , numPolygons , vertexArray , polygonCounts , polygonConnects )\n    fnMesh.updateSurface()\n\n    # Assign new mesh to default shading group\n    nodeName = fnMesh.name()\n    cmds.sets( nodeName , e=True , fe='initialShadingGroup' )\n\n    return nodeName\n\nresult = cmds.skeletonEmbed( query=True , mergedMesh=True )\ncreateMeshFromDescription( result )",
 'skinBindCtx': "import maya.cmds as cmds\n\ncmds.skinBindCtx( 'skinBindContext' )",
 'skinCluster': "import maya.cmds as cmds\n\n# Create a joint chain and a polygonal plane.\ncmds.select(d=True)\ncmds.joint(p=(-3.0, 0.0,-12.0))\ncmds.joint(p=(-3.0, 0.0, -5.0))\ncmds.joint(p=(1.0, 0.0, 5.5))\ncmds.joint(p=(6.0, 0.0, 10.0))\ncmds.polyPlane(w=20.0,h=20.0,sx=25,sy=25)\n\n# Bind the joint chain that contains joint1 to pPlane1\n# and assign a dropoff of 4.5 to all the joints\n#\ncmds.skinCluster( 'joint1', 'pPlane1', dr=4.5)\n\n# Undo the previous command and bind only joint1 and joint3 to pPlane1\n#\ncmds.undo();\ncmds.skinCluster('joint1', 'joint3', 'pPlane1',tsb=True)\n\n# Set the maximum number of transforms influencing each\n# point to 3\ncmds.skinCluster('skinCluster1',e=True,mi=3)\n\n# Add transform joint2 to the list of transforms\n# that influence the bound skin\n#\ncmds.select('pPlane1')\ncmds.skinCluster(edit=True,ai='joint2')\n\n# Query the influences for the skinCluster\n#\ncmds.skinCluster('skinCluster1',query=True,inf=True)\n\n# Add a curve influence object\n#\ncmds.curve(d=3,p=[(2.0, 0.0, -7.0),(5.0, 0.0, -4.0),(6.0, 0.0, 1.0),(6.0, 0.0, 4.0),(5.0, 0.0, 6.0)],k=[0,0,0,1,2,2,2])\n\n# Get the number of nurbsSamples taken along curve1\n#\ncmds.skinCluster('skinCluster1',edit=True,ai='curve1')\ncmds.skinCluster('skinCluster1',inf='curve1',query=True,ns=True)\n\n# Set the dropoff for joint3 to 5.0\n#\ncmds.skinCluster('skinCluster1',e=True,inf='joint3',dr=5.0)\n\n# Query for the dropoff for joint3\n#\ncmds.skinCluster('skinCluster1',inf='joint3',q=True,dr=True)",
 'skinPercent': "import maya.cmds as cmds\n\n# Create a joint chain and a polygonal plane and bind them as skin\ncmds.select(d=True)\ncmds.joint(p=(-3.0, 0.0,-12.0))\ncmds.joint(p=(-3.0, 0.0, -5.0))\ncmds.joint(p=(1.0, 0.0, 5.5))\ncmds.joint(p=(6.0, 0.0, 10.0))\ncmds.polyPlane(w=20.0,h=20.0,sx=25,sy=25)\ncmds.skinCluster( 'joint1', 'pPlane1' )\n\n# For vtx[100], set the weight wrt joint1 to 0.2, the weight\n# wrt joint3 to 0.8 and adjust the remaining weights to keep\n# the overall weight normalized (i.e. set all other joints to zero,\n# since the weights we are setting sum to 1.0)\n#\ncmds.skinPercent( 'skinCluster1', 'pPlane1.vtx[100]', transformValue=[('joint1', 0.2), ('joint3', 0.8)])\n\n# Get the weight values corresponding to all of the influences\n#\ncmds.skinPercent( 'skinCluster1', 'pPlane1.vtx[100]', query=True, value=True )\n\n# Get the weight values that are above 0.5\n#\ncmds.skinPercent( 'skinCluster1', 'pPlane1.vtx[100]', ignoreBelow=0.5, query=True, value=True )\n\n# Get the weight of vtx[100] corresponding to joint3\n#\ncmds.skinPercent( 'skinCluster1', 'pPlane1.vtx[100]', transform='joint3', query=True )\n\n# Get the names of the joints influencing vtx[100]\n#\ncmds.skinPercent( 'skinCluster1', 'pPlane1.vtx[100]', transform=None, query=True )\n\n# Normalize the existing weights for vtx[100]\n#\ncmds.skinPercent( 'skinCluster1', 'pPlane1.vtx[100]', normalize=True )\n\n# Reset the weights for vtx[100] to their default values\n#\ncmds.skinPercent( 'skinCluster1', 'pPlane1.vtx[100]', resetToDefault=True )\n\n# Zero all the weights that are below 0.1\n#\ncmds.skinPercent( 'skinCluster1', 'pPlane1', pruneWeights=0.1 )\n\n# Zero all the weights\n#\ncmds.skinPercent( 'skinCluster1', 'pPlane1', pruneWeights=100, normalize=False )\n\n# Assign weights to a large number of vertices,\n# several at a time to reduce the number of calls\n# to the skinPercent command.\n#\nfor i in range(0,675,10):\n   cmds.select('pPlane1.vtx[%i]' % i,'pPlane1.vtx[%i]' % (i+1), 'pPlane1.vtx[%i]' % (i+2), 'pPlane1.vtx[%i]' % (i+3), 'pPlane1.vtx[%i]' % (i+4), 'pPlane1.vtx[%i]' % (i+5), 'pPlane1.vtx[%i]' % (i+6), 'pPlane1.vtx[%i]' % (i+7), 'pPlane1.vtx[%i]' % (i+8), 'pPlane1.vtx[%i]' % (i+9))\n   cmds.skinPercent( 'skinCluster1',transformValue=[('joint1', 0.5),('joint2', 0.5)] )",
 'smoothCurve': "import maya.cmds as cmds\n\n#Create a curve, then smooth it\ncmds.curve(p=[(0, 0, 0), (3, 5, 6), (5, 6, 7), (9, 9, 9)], n='curve1')\ncmds.smoothCurve('curve1.cv[*]', s=10)",
 'smoothTangentSurface': 'import maya.cmds as cmds\n\ncmds.smoothTangentSurface( \'surface1\', ch=True, p=0.3, d=0 )\ncmds.smoothTangentSurface( \'surface1.v[0.3]\', ch=True )\n# Smoothes surface1 along parameter value v = 0.3. When the\n# isoparm is specified, the direction and parameter value is\n# implied and the "p" and "d" flags can be omitted.\n\ncmds.smoothTangentSurface( \'surface1\', ch= True, p= (0.3, 0.5, 0.8), nk=2, d=0 )\n# Smoothes along parameter values v = 0.3, 0.5 and 0.8.',
 'snapKey': 'import maya.cmds as cmds\n\n# Keys on animation curves are identified by either\n# their time values or their indices.  Times and indices can\n# be given as a range or list of ranges.\n\n# time=(\'10pal\',\'10pal\') means the key at frame 10 (PAL format).\n# time=[(\'1.0sec\',\'1.0sec\'),(\'15ntsc\',\'15ntsc\'),(20,20)] means the keys at time 1.0 second, frame 15 (in NTSC format), and time 20 (in the currently defined global time unit).\n# time=(10,20) means all keys in the range from 10 to 20, inclusive, in the current time unit.\n# Omitting one end of a range means "go to infinity", as in the following examples:\n# time=(10,None) means all keys from time 10 (in the current time unit) onwards.\n# time=(10,) means the same as (10,10)\n# time=(0,10) means all keys up to (and including) time 10 (in the current time unit).\n# time=(None,None) is a short form to specify all keys.\n# index=(0,0) means the first key of each animation curve. (Indices are 0-based.)\n# index=[(2,2),(5,5),(7,7)] means the 3rd, 6th, and 8th keys.\n# index=(1,5) means the 2nd, 3rd, 4th, 5th, and 6th keys of each animation curve.\n\n# Two ways to snap all keys on nurbsSphere1 to integer values.\n#\ncmds.snapKey( \'nurbsSphere1\', tm=1.0 )\ncmds.snapKey( \'nurbsSphere1\' )\n\n# Snap active objects\' keys between times 10 and 20 so that\n# they have times that are multiples of 0.5.\n#\ncmds.snapKey( t=(10,20), tm=0.5 )\n\n# Snap active objects\' keys between times 10 and 20 so that\n# they have times that are multiples of 0.5 and values that\n# are multiples of 1.0.\n#\ncmds.snapKey( t=(10,20), tm=0.5, vm=1.0 )',
 'snapMode': 'import maya.cmds as cmds\n\n# Turn curve snapping on\ncmds.snapMode( curve=True )\n\n# Returns true if point snapping is on\ncmds.snapMode( q=True, point=True )',
 'snapTogetherCtx': "import maya.cmds as cmds\n\n# Create two nurbs spheres, then move them apart\ncmds.sphere(r=3, n='nurbsSphere1')\ncmds.move(5, 0, 0)\ncmds.sphere(r=3, n='nurbsSphere2')\ncmds.move(-5, 0, 0)\n\n# Create a new snap together tool context, set it to move objects only, then switch to it\n# You can use this tool to snap two spheres together\ncmds.snapTogetherCtx('snapTogetherCtx1', so=False)\ncmds.setToolTo('snapTogetherCtx1')",
 'snapshot': 'import maya.cmds as cmds\n\n# animate a sphere\ncmds.sphere(n=\'sphere1\')\ncmds.currentTime(\'0\')\ncmds.setKeyframe(\'.t\')\ncmds.currentTime(\'30\')\ncmds.move(10,0,1)\ncmds.setKeyframe(\'.t\')\n\n# Evaluate and display "sphere1" as it appears\n# at times 0, 10, 20, and 30.  Modifications to sphere1\n# will update the copies.\n#\ncmds.snapshot( \'sphere1\', constructionHistory=True, startTime=0, endTime=30, increment=10 )\n\n# Evaluate and display "sphere1" as it appears\n# at times 0, 10, 20, and 30.  Further modifications to sphere1\n# should have no affect on the copies since constructionHistory is off.\n#\ncmds.snapshot( \'sphere1\', constructionHistory=False, startTime=0, endTime=30, increment=10 )',
 'snapshotBeadContext': '',
 'snapshotBeadCtx': 'import maya.cmds as cmds\n\n# Create a snapshot bead context that will show in tangents\nctx = cmds.snapshotBeadCtx(inTangent = True)\ncmds.setToolTo(ctx)',
 'snapshotModifyKeyCtx': 'import maya.cmds as cmds\n\n# Create an insert key context\nctx = cmds.snapshotModifyKeyCtx()\ncmds.setToolTo(ctx)',
 'soft': 'import maya.cmds as cmds\n\ncmds.sphere()\ncmds.soft( \'nurbsSphere1\', c=True )\n\n# Creates a sphere named nurbsSphere1 and converts nurbSphere1 into\n# a soft object.  The particle portion of the soft object will\n# be parented (with its own transform) under nurbsSphere1.\n\ncmds.sphere()\ncmds.soft( \'nurbsSphere1\', d=True )\n\n# Same as the previous example, except that the soft command will make\n# a duplicate of nurbsSphereShape1.  The resulting soft body will be\n# completely independent of nurbSphere1 and its children.  Input connections\n# to nurbsSphereShape1 will be duplicated, but not any upstream history\n# (in other words, just plain "duplicate").\n\ncmds.sphere()\ncmds.soft( \'nurbsSphere1\', dh=True )\n\n# Same as the previous example, except that upstream history on\n# nurbsSphereShape1 will be duplicated as well (equivalent to\n# "duplicate history").\n\ncmds.sphere()\ncmds.soft( \'nurbSphere1\', g=0.3 )\n\n# This will make a duplicate of the shape under nurbSphere1 (as for -d),\n# and  use it as the shape for the newly created soft object.\n# The original nurbsSphereShape1 will be made a goal for the particles of\n# softy, with a goal weight of 0.3.  This will make those particles try to\n# follow nurbSphere1 loosely as it moves around.\n\ncmds.soft( \'foobar\', q=True )\n# Returns true if foobar is a soft object.\n\ncmds.soft( \'foobar\', \'foobarParticles\', q=True )\n\n# Returns true if foobar and foobarParticles are parts of the same\n# soft object.  This is useful because when you select a soft body,\n# both the overall transform and the particle transform get put into\n# the selection list.',
 'softMod': 'import maya.cmds as cmds\n\n# Create a softMod which uses the transformation of elbow1\n#\ncmds.joint(p=(2,0,0),name="elbow1")\ncmds.joint(p=(4,0,0),name="wrist1")\n\ncmds.sphere()\ncmds.softMod( wn=(\'elbow1\', \'elbow1\') )\n\n# Edit softMod1 to use the transformation of wrist1.\n#\ncmds.softMod( \'softMod1\', e=True, wn=(\'wrist1\', \'wrist1\') )\n\n# Create a relative softMod with its own softMod handle. The\n# softMod handle is drawn as the letter "S".\n#\ncmds.polyCube();\ncmds.softMod( rel=True )\n\n# Modify the membership of an existing softMod. First, find\n# the name of the softMod\'s associated set, then use the sets\n# command to edit the set membership (add a cube and remove a plane).\n#\ncmds.listConnections( \'softMod1\', type=\'objectSet\' )\n# Result:[u\'softMod1Set\'] #\ncmds.sets( \'pCube2\', add=\'softMod1Set\' )\ncmds.sets( \'pCube1\', rm=\'softMod1Set\' )',
 'softModContext': '',
 'softModCtx': 'import maya.cmds as cmds\n\ncmds.softModCtx()',
 'softSelect': "import maya.cmds as cmds\n\n# Enable soft selection\ncmds.softSelect(sse=1)\n\n# Setup global soft select with radius and curve\ncmds.softSelect(sse=1,ssd=2.0,ssc='0,1,2,1,0,2',ssf=2)",
 'softSelectOptionsCtx': '',
 'soloMaterial': 'import maya.cmds as cmds\n\n\ncmds.soloMaterial( node="file1", attr="outAlpha" )\ncmds.soloMaterial( unsolo=True )\ncmds.soloMaterial( last=True )',
 'sortCaseInsensitive': 'import maya.cmds as cmds\n\n\ncmds.sortCaseInsensitive( stringArray );\n# Returns the sorted string from stringArray',
 'sound': 'import maya.cmds as cmds\n\n# Create an audio node for a sound file, and have it\n# start at time 10.  This command will return the name\n# of the created node, something like "audio1".\n#\ncmds.sound( offset=10, file=\'ohNo.aiff\' )\n\n# In order to have this sound displayed in a\n# timeControl widget (like the timeSlider) use a\n# command like this one, where the global MEL variable\n# $gPlayBackSlider is the name of the widget to display\n# the sound in.\n#\nimport maya.mel\ngPlayBackSlider = maya.mel.eval( \'$tmpVar=$gPlayBackSlider\' )\ncmds.timeControl( gPlayBackSlider, edit=True, sound=\'audio1\' )',
 'soundControl': 'import maya.cmds as cmds\n\n# To display sound in a soundControl, there must first be a sound\n# node in the scene. We\'ll create one and give it the name "ohNo".\n# Note that the argument to the -file flag must be a path to a valid\n# soundfile.\n#\ncmds.sound( file=\'ohNo.aiff\', name=\'ohNo\' )\n\n# Create a sound control (named "soundScrubber")\n# and have it display the sound associated with audio node "ohNo".\n#\ncmds.window()\ncmds.frameLayout( lv=False )\ncmds.soundControl( \'soundScrubber\', width=600, height=45, sound=\'ohNo\', displaySound=True, waveform=\'both\' )\ncmds.showWindow()\n\n# Now setup "soundScrubber" to actually scrub with\n# mouse drags.\n#\npressCmd = "soundControl -e -beginScrub soundScrubber"\nreleaseCmd = "soundControl -e -endScrub soundScrubber"\ncmds.soundControl( \'soundScrubber\', e=True, pc=cmds.soundControl(\'soundScrubber\',e=True,beginScrub=True, rc=cmds.sound(\'soundScrubber\',e=True,endScrub=True)))',
 'soundPopup': 'import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout( adjustableColumn=True )\ncmds.soundPopup()',
 'spBirailCtx': '',
 'spaceLocator': "import maya.cmds as cmds\n\n# Creates a space locator at (1, 1, 1).\ncmds.spaceLocator( p=(1, 1, 1) )\n# Creates a space locator at (1, 1, 1) in inches.\ncmds.spaceLocator( p=('1in', '1in', '1in') )\n# Creates a space locator at the default position (0, 0, 0).\ncmds.spaceLocator()",
 'sphere': "import maya.cmds as cmds\n\n# Create sphere with radius 10\ncmds.sphere( r=10 )\n\n# Query the radius of the new sphere\nr = cmds.sphere( 'nurbsSphere1', q=True, r=True )\n\n# Create half sphere\ncmds.sphere( ssw=0, esw=180 )\n\n# Use tolerance to determine how many spans the new sphere has\ncmds.sphere( ut=True, tol=0.01 )\n\n# Use sections to determine how many spans the new sphere has\ncmds.sphere( ut=False, s=8 )",
 'spotLight': 'import maya.cmds as cmds\n\n# Create a spot light\nlight = cmds.spotLight(coneAngle=45)\n\n# Change the cone angle value\ncmds.spotLight( light, e=True, coneAngle=33 )\n\n# Query it\ncmds.spotLight( light, q=True, coneAngle=True )\n# Result:33#',
 'spotLightPreviewPort': "import maya.cmds as cmds\n\nlight = cmds.spotLight()\ncmds.window()\ncmds.columnLayout('r')\ncmds.spotLightPreviewPort('slPP', widthHeight=(256, 256), spotLight=light)\ncmds.showWindow()",
 'spreadSheetEditor': 'import maya.cmds as cmds\n\nwindow = cmds.window( widthHeight=(400, 300) )\ncmds.paneLayout()\nactiveList = cmds.selectionConnection( activeList=True )\ncmds.spreadSheetEditor( mainListConnection=activeList )\ncmds.showWindow( window )',
 'spring': "import maya.cmds as cmds\n\ncmds.spring( 'particle1', s=1.5, d=.3, mnd=0, mxd=5, n='spring1' )\n# Creates a spring object named spring1 with a strength of 1.5 and a\n# damping factor of 0.3 containing a spring between every pair of points in\n# particle1 that are within 0.0 and 5.0 units apart (except those already\n# connected by a spring).\n\ncmds.spring( 'particle1', 'spring1', add=True, mnd=0, mxd=5 )\n# Creates between every pair of points in particle1 that are within 0.0\n# and 5.0 units apart (except those already connected by a spring), and adds\n# them to the existing spring object spring1.\n\ncmds.spring( 'particle1', 'spring1', add=True, mnd=0, mxd=5, ce='false' )\n# Same as the previous example, but will not check for existing springs\n# in order to avoid duplication, and will create a new spring even between\n# pairs of particles which already have one.\n\ncmds.spring( 'particle1', 'particle2', exclusive=1, all=1 )\n# Creates a spring between every pair of particles such that one\n# particle is in particle1 and the other is in particle2.  Does not create\n# any springs between pairs in the same object.  Does not create springs\n# between particles already connected by a spring.",
 'squareSurface': 'import maya.cmds as cmds\n\n# Creating square surfaces with three curves and fixed continuity type:\n\ncrv1 = cmds.curve( d=3, p=( (8, 0, 3), (5, 0, 3), (2, 0, 2), (0, 0, 0)) )\ncrv2 = cmds.curve( d=3, p=( (8, 0, -4), (5, 0, -3), (2, 0, -2), (0, 0, 0)) )\ncrv3 = cmds.curve( d=3, p=( (8, 0, 3), (9, 3, 2), (11, 3, 1), (8, 0, -4)) )\n\n# These curves form a rough triangle shape pointing at the origin.\n\ncmds.squareSurface( crv3, crv1, crv2, ct1=1, ct2=1, ct3=1 )\n\n# Creating square surfaces with four curves, tangent continuity\n# type and to use 6 points per span in checking the continuity:\n\ncrv1 = cmds.curve( d=3, p=( (-2, 0, 4), (-2, 0, 5), (1, 0, 3), (3, 0, 4), (6, 0, 5) ) )\ncrv2 = cmds.curve( d=3, p=( (6, 0, 5), (8, 0, 2), (8, 0, -3), (7, 0, -4 ) ) )\ncrv3 = cmds.curve( d=3, p=( (7, 0, -4), (2, 0, -3), (-1, 0, -5), (-2, 0, -4) ) )\ncrv4 = cmds.curve( d=3, p=( (-2, 0, 4), (-4, 0, 1), (-4, 0, -3), (-2, 0, -4) ) )\n\n# These curves form a rough square shape around the origin.\n\ncmds.squareSurface( crv1, crv2, crv3, crv4, cfc=6, ct1=2, ct2=2, ct3=2, ct4=2 )',
 'srtContext': 'import maya.cmds as cmds\n\n# To see if an srtContext named "Transform" exists:\ncmds.srtContext( \'Transform\', q=True, exists=True )',
 'stackTrace': '',
 'stitchSurface': "import maya.cmds as cmds\n\n# Stitch the two surfaces along the two specified surface isoparam with C0 continuity.\n# Since wt0 = 0.0, both the surfaces are stitched to surface2.vn[0] really.\ncmds.stitchSurface( 'surface1.vn[1.0]', 'surface2.vn[0.0]', kg0=False, kg1=True, cascade=False, ns=100, wt0=0.0, wt1=1.0 )",
 'stitchSurfaceCtx': '',
 'stitchSurfacePoints': "import maya.cmds as cmds\n\n# stitch together four corner control vertices to the average of the four corners.\ncmds.stitchSurfacePoints( 'nurbsPlane2.cv[0][0]', 'nurbsPlane1.cv[3][0]', 'nurbsPlane4.cv[0][3]', 'nurbsPlane3.cv[3][3]', ewt=True )\n\n# stitch together two edit points to the edit point nurbsPlane2.ep[0][0].\ncmds.stitchSurfacePoints( 'nurbsPlane2.ep[0][0]', 'nurbsPlane1.ep[1][0]', ewt=False )",
 'stringArrayIntersector': "import maya.cmds as cmds\n\n# Create an intersector\n#\nmyIntersector = cmds.stringArrayIntersector('stringArrayIntersector')\n\n# Intersect some string arrays using the intersector\n#\ninitialArray = ['Excellent', 'Smithers', 'doh']\ncmds.stringArrayIntersector( myIntersector, edit=True, intersect=initialArray )\ncmds.stringArrayIntersector( myIntersector, edit=True, intersect=['Smithers', 'Homer'] )\n\n# Query the intersector to see what the intersection is so far\n#\ncmds.stringArrayIntersector( myIntersector, query=True )\n# Result: Smithers #\n\n# Reset the intersector so that you can use it again with new string\n# arrays\n#\ncmds.stringArrayIntersector( myIntersector, edit=True, reset=True )\n\n# Delete the intersector as we are now done with it\n#\ncmds.deleteUI( myIntersector )",
 'stroke': "import maya.cmds as cmds\n\ncmds.stroke( s=10, n='armScar' )",
 'subdAutoProjection': 'import maya.cmds as cmds\n\n# Create a subd sphere with default UVs.\nmel.eval( "createSubdSphereProc" )\n\n# Automatic projections with 6 planes.\ncmds.subdAutoProjection( \'subdivSphere1.smf[*][*]\' )',
 'subdCleanTopology': "import maya.cmds as cmds\n\n# To clean topology of two subdiv surfaces.\ncmds.subdCleanTopology( 'surface', 'surface2' )",
 'subdCollapse': "import maya.cmds as cmds\n\n# To create a new subd surface whose level 0 (base mesh) matches\n# the level 3 vertices of the given surface.\ncmds.subdCollapse( 'subdivShape1', level=3 )",
 'subdDisplayMode': '',
 'subdDuplicateAndConnect': "import maya.cmds as cmds\n\ncmds.subdDuplicateAndConnect( 'pSubd1' )",
 'subdEditUV': 'import maya.cmds as cmds\n\n# To tweak the u and v values of selected uvs:\ncmds.subdEditUV( relative=True, uValue=0.05925926, vValue=0.05555556 )\n\n# To set absolute values for u and v values of selected uvs:\ncmds.subdEditUV( relative=False, uValue=0.556, vValue=0.56 )\n\n# To rotate selected uv points about a pivot:\ncmds.subdEditUV( pivotU=0.5, pivotV=0.5, angle=-15 )\n\n# To scale selected uv points about a pivot:\ncmds.subdEditUV( pivotU=0.5, pivotV=0.5, scaleU=-0.06, scaleV=-0.06 )',
 'subdLayoutUV': 'import maya.cmds as cmds\n\n# Create a cube\nmel.eval( "createSubdCubeProc" )\n\n# Layout all UVs in the texture plane.\ncmds.subdLayoutUV( \'subdivCube1.smf[*][*]\', l=2, fr=True, se=2, sc=1 )',
 'subdListComponentConversion': "import maya.cmds as cmds\n\ncmds.subdListComponentConversion( 'subdShape.smp[5][6]', 'subdShape.smp[9][10]', fv=True, tf=True )\n# Returns a list of faces that are connected to the given vertices.\n\ncmds.subdListComponentConversion( 'subdShape.sme[0][0]', 'subdShape.smp[3][0]', 'subdShape.smp[8][0]', tf=True )\n# Returns a list of faces that are connected to the given components.\n\ncmds.subdListComponentConversion( 'subdShape.smp[5][9]', fv=True, tf=True, in=True )\n# Returns a list of only those faces that are completely contained\n# by the given vertices.\n\ncmds.select( 'subdShape.smp[0][0]', 'subdShape.smp[3][0]', 'subdShape.smp[8][0]', r=True )\ncmds.subdListComponentConversion( fv=True, tf=True )\n# Returns the conversion of selected vertices to faces.\n\ncmds.subdListComponentConversion( 'subdShape.smm[3]', fuv=True, tuv=True, uvs=True )\n# Returns a list of all UV map components in the\n# same UV shell (contiguous region in texture space).\n# (You can view these regions in the UV Editor.)\n\ncmds.subdListComponentConversion( 'subdShape.smm[3]', fuv=True, tuv=True, uvb=True )\n# Returns a list of the UV map components on the border of the\n# same UV shell (contiguous region in texture space).  (You can\n# view these regions in the UV Editor.)",
 'subdMapCut': 'import maya.cmds as cmds\n\n# Opening up the textureView will make this example much easier to visualize.\n\n# Create a cube\nmel.eval( "createSubdCube" )\n\n# Cut the map.\ncmds.subdMapCut( \'subdivCube1.sme[2560][2]\', \'subdivCube1.sme[2816][2]\' )\n# now that it\'s cut, we may move the row separately\n\n# Move some UVs\ncmds.subdEditUV( \'subdivCube1.smm[21:22]\', \'subdivCube1.smm[25]\', u=0, v=0.05 )',
 'subdMapSewMove': 'import maya.cmds as cmds\n\n# Create a subd sphere with default UVs.\nimport maya.mel as mel\nmel.eval( "createSubdSphere" )\n\n# Automatic projections with 6 planes.\ncmds.subdAutoProjection( \'subdivSphere1.smf[*][*]\' )\n\n# Select the seams\ncmds.select( \'subdivSphere1.sme[0:1][67108864]\', \'subdivSphere1.sme[256][67108867]\', \'subdivSphere1.sme[513][67108864]\' )\n\n# merge them, with the appropriate move.\ncmds.subdMapSewMove()',
 'subdMatchTopology': "import maya.cmds as cmds\n\n# To match topology across two subdiv surfaces.\ncmds.subdMatchTopology( 'surface', 'surface2' )",
 'subdMirror': "import maya.cmds as cmds\n\n# To create a new subd surface mirrored in the X direction.\ncmds.subdMirror( 'subdivShape1', xMirror=True )",
 'subdPlanarProjection': 'import maya.cmds as cmds\n\n# Create a cube\nmel.eval( "createSubdCubeProc" )\n\n# Layout all UVs in the texture plane.\ncmds.subdPlanarProjection( \'subdivCube1.smf[*][*]\',  rx=90, ra=45.0, pc= (0, 0, 0), imageScale=(0.5, 0.5))',
 'subdToBlind': "import maya.cmds as cmds\n\ncmds.subdToBlind( 'subdShape1', 'polyShape4' )",
 'subdToNurbs': '',
 'subdToPoly': "import maya.cmds as cmds\n\n# To create a new polygon from a subdivision surface:\ncmds.subdToPoly( 'subd1' )",
 'subdTransferUVsToCache': "import maya.cmds as cmds\n\ncmds.subdTransferUVsToCache( 'subdShape1', 'polyShape4' )",
 'subdiv': "import maya.cmds as cmds\n\n# To find the deepest subdivided level of polyToSubdShape1\n#\ncmds.subdiv( 'polyToSubdShape1', query=True, deepestLevel=True )\n\n# To find the level of the  selected subdiv CV\n#\ncmds.select( 'polyToSubdShape1.smp[2][67108865]', r=True)\ncmds.subdiv( currentLevel=True )\n# Result: 1 #",
 'subdivCrease': 'import maya.cmds as cmds\n\n# after selecting components of a subdivision surface\ncmds.subdivCrease()',
 'subdivDisplaySmoothness': 'import maya.cmds as cmds\n\ncmds.subdivDisplaySmoothness( s=0 )# Set smoothness to hull for selected subdivs\ncmds.subdivDisplaySmoothness( s=1 )# Set smoothness to rough for selected subdivs\ncmds.subdivDisplaySmoothness( s=2 )# Set smoothness to medium for selected subdivs\ncmds.subdivDisplaySmoothness( s=3 )# Set smoothness to fine for selected subdivs\ncmds.subdivDisplaySmoothness( s=1, all=True )# Set smoothness to rough for all subdivs\ncmds.subdivDisplaySmoothness( query=True )# Query display smoothness for selected subdivs',
 'subgraph': '',
 'substituteGeometry': "import maya.cmds as cmds\n\n\n# substitute the smooth skinned outPutGeom with newInputShape.\n#\ncmds.substituteGeometry( 'outPutGeom', 'newInputShape' )",
 'suitePrefs': 'import maya.cmds as cmds\n\nimport maya.cmds as cmds\n\n# Check if Maya is part of a Suites install\nisSuiteInstall = cmds.suitePrefs(q=True, installedAsSuite=True)\nif isSuiteInstall:\n#   Check whether Maya mouse and keyboard interaction\n#   has been applied to the Suite.\n    applyMayaToSuite = cmds.suitePrefs(q=True, applyToSuite=True)\n    if applyMayaToSuite:\n#       Apply Maya mouse and keyboard interaction to\n#       the Suite.\n        cmds.suitePrefs(applyToSuite=True)',
 'superCtx': '',
 'surface': "import maya.cmds as cmds\n\n# This following command produces a flat, rectangular surface that is degree 3\n# in both directions.  This means that there must be at least 4 x 4\n# points to define the surface, since 4 is the (degree + 1).  There\n# must be 6 knots in each direction, because the knot vector must\n# be (number of points + degree - 1), ie. (4 points + degree 3 - 1).\n# The CVs are specified in rows of U and columns of V, as you\n# would read a book from left to right, up to down. ie. in this order:\n# surface.cv[0][0] surface.cv[0][1] surface.cv[0][2] surface.cv[0][3]\n# surface.cv[1][0] surface.cv[1][1] surface.cv[1][2] surface.cv[1][3]\n# surface.cv[2][0] surface.cv[2][1] surface.cv[2][2] surface.cv[2][3]\n# surface.cv[3][0] surface.cv[3][1] surface.cv[3][2] surface.cv[3][3]\n\ncmds.surface( du=3, dv=3, ku=(0, 0, 0, 1, 1, 1), kv=(0, 0, 0, 1, 1, 1), p=((-0.5, 0, 0.5), (-0.5, 0, 0.16), (-0.5, 0, -0.16), (-0.5, 0, -0.5), (-0.16, 0, 0.5), (-0.16, 0, 0.16), (-0.16, 0, -0.16), (-0.16, 0, -0.5), (0.16, 0, 0.5), (0.16, 0, 0.16), (0.16, 0, -0.16), (0.16, 0, -0.5), (0.5, 0, 0.5), (0.5, 0, 0.16), (0.5, 0, -0.16), (0.1, 0, -0.1)) )\n\n# This following command produces a surface that is degree 3 and periodic in\n# the U direction, and degree 1 in the V direction.  Notice that\n# the first 3 pairs of points match the last 3 pairs of\n# points, which is required for a degree 3 periodic surface.\n\ncmds.surface( du=3, dv=1, fu='periodic', fv='open', ku=(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12), kv=(0, 1), pw=((4, -4, 0, 1), (4, -4, -2.5, 1), (5.5, 0, 0, 1), (5.5, 0, -2.5, 1), (4, 4, 0, 1), (4, 4, -2.5, 1), (0, 5.5, 0, 1), (0, 5.5, -2.5, 1), (-4, 4, 0, 1), (-4, 4, -2.5, 1), (-5.5, 0, 0, 1), (-5.5, 0, -2.5, 1), (-4, -4, 0, 1), (-4, -4, -2.5, 1), (0, -5.5, 0, 1), (0, -5.5, -2.5, 1), (4, -4, 0, 1), (4, -4, -2.5, 1), (5.5, 0, 0, 1), (5.5, 0, -2.5, 1), (4, 4, 0, 1), (4, 4, -2.5, 1)) )\n\n# This following command produces a surface that is degree 5 in both directions.\n\ncmds.surface( du=5, dv=5, fu='open', fv='open', p=((-7, 0, 1), (-6, 0, 4), (-3, 0, 6), (0, 0, 7), (4, 0, 5), (6, 0, 3), (-7, 2, 1), (-6, 2, 4), (-3, 2, 7), (0, 2, 8), (4, 2, 5), (6, 2, 3), (-7, 3, 1), (-6, 3, 4), (-3, 3, 8), (0, 3, 9), (4, 3, 5), (6, 3, 3), (-7, 4, 1), (-6, 4, 4), (-3, 4, 9), (0, 4, 8), (4, 4, 5), (6, 4, 3), (-7, 5, 1), (-6, 5, 4), (-3, 5, 8), (0, 5, 7.5), (4, 5, 5), (6, 5, 3), (-7, 6, 1), (-6, 6, 4), (-3, 6, 6), (0, 6, 7), (4, 6, 5), (6, 6, 3)), ku=(0, 0, 0, 0, 0, 1, 1, 1, 1, 1), kv=(0, 0, 0, 0, 0, 1, 1, 1, 1, 1) )\n\n\n# How to query surface properties:\n\ncmds.getAttr( 'surface1.degreeU' )\n# Returns an integer that is the surface degree in U\n\ncmds.getAttr( 'surface1.degreeV' )\n# Returns an integer that is the surface degree in V\n\ncmds.getAttr( 'surface1.spansU' )\n# Returns an integer that is the # spans in U\n\ncmds.getAttr( 'surface1.spansV' )\n# Returns an integer that is the # spans in V\n\ncmds.getAttr( 'surface1.formU' )\n# Return 0 = open, 1 = closed, 2 = periodic\n\ncmds.getAttr( 'surface1.formV' )\n# Returns 0 = open, 1 = closed, 2 = periodic\n\ncmds.getAttr( 'surface1.minValueU' )\ncmds.getAttr( 'surface1.maxValueU' )\ncmds.getAttr( 'surface1.minValueV' )\ncmds.getAttr( 'surface1.maxValueV' )\n# These return the minimum and maximum parameter ranges in each direction.\n\ncmds.getAttr( 'surface1.cv[0][0]' )\n# Returns the position of a CV of surface1 in local space.  If the\n# surface is a result of construction history, use a surface info\n# node instead to get the CV position.\n\ncmds.getAttr( 'surface1.cv[*][0]' )\n# Returns the positions of a row of CVs of surface1 in local space.\n# If the surface is a result of construction history, use a surface info\n# node instead to get the CV positions.\n\ncmds.createNode( 'surfaceInfo' )\ncmds.connectAttr( 'surfaceShape1.worldSpace', 'surfaceInfo1.inputSurface', f=True )\ncmds.getAttr( 'surfaceInfo1.controlPoints[*]' )\n# Returns the surface CVs in world space.   A surface info node can\n# also be used to query the surface knot vectors.",
 'surfaceSampler': "import maya.cmds as cmds\n\n# Generate an object space normal map of a cube onto a sphere called test.dds\ncmds.surfaceSampler( mapOutput='normal', filename='C:/test', fileFormat='dds', source='pCube1', target='pSphere1', uv='map1' )",
 'surfaceShaderList': "import maya.cmds as cmds\n\n# Create a NURBS plane.\ncmds.nurbsPlane( d=3, p=(0, 0, 0), lr=1, axis=(0, 0, 0), n='plane1' )\n\n# Make it red.\ncmds.sets( name='redMaterialGroup', renderable=True, empty=True )\ncmds.shadingNode( 'phong', name='redShader', asShader=True )\ncmds.setAttr( 'redShader.color', 1, 0, 0, type='double3' )\ncmds.surfaceShaderList( 'redShader', add='redMaterialGroup' )\ncmds.sets( 'plane1', e=True, forceElement='redMaterialGroup' )",
 'swatchDisplayPort': "import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout('r')\nmyShader = cmds.shadingNode('anisotropic', asShader=True)\ncmds.swatchDisplayPort('slPP', wh=(256, 256), sn=myShader)\ncmds.showWindow()",
 'swatchRefresh': "import maya.cmds as cmds\n\n\n# Refresh the swatch for the layer1 node\ncmds.swatchRefresh('layer1')",
 'switchTable': "import maya.cmds as cmds\n\ncmds.window(width=200)\ncmds.formLayout('theForm')\ncmds.switchTable('theSwitch')\ncmds.formLayout('theForm', e=True,\n                af=(('theSwitch', 'top', 0),\n                    ('theSwitch', 'left', 0),\n                    ('theSwitch', 'bottom', 0),\n                    ('theSwitch', 'right', 0)))\ncmds.showWindow()",
 'symbolButton': "import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout()\ncmds.symbolButton( image='circle.png' )\ncmds.symbolButton( image='sphere.png' )\ncmds.symbolButton( image='cube.png' )\ncmds.showWindow()",
 'symbolCheckBox': "import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout()\ncmds.symbolCheckBox( image='circle.png' )\ncmds.symbolCheckBox( image='sphere.png' )\ncmds.symbolCheckBox( image='cube.png' )\ncmds.showWindow()",
 'symmetricModelling': "import maya.cmds as cmds\n\n# What is the current reflection setting\ncmds.symmetricModelling(query=True, symmetry=True)\n\n# What is the current reflection axis\ncmds.symmetricModelling(query=True, axis=True)\n\n# Change the space to apply reflection to (object or world)\ncmds.symmetricModelling(about='world')\n\n# Change the current tolerance to 0.34\ncmds.symmetricModelling(tolerance=0.34)",
 'syncSculptCache': '',
 'sysFile': 'import maya.cmds as cmds\n\n# Create a new directory path\ncmds.sysFile( \'C:/temp/mayaStuff\', makeDir=True )# Windows\ncmds.sysFile( \'/tmp/mayaStuff\', makeDir=True )# Unix\n\n# Move a scene to the new directory (we can rename it at the same time).\ncmds.sysFile( \'C:/maya/projects/default/scenes/myScene.mb\', rename=\'C:/temp/mayaStuff/myScene.mb.trash\' )# Windows\ncmds.sysFile( \'/maya/projects/default/scenes/myScene.mb\', rename=\'/tmp/mayaStuff/myScene.mb.trash\' )# Unix\n\n\n# Rename the scene to "myScene.will.be.deleted"\ncmds.sysFile( \'C:/temp/mayaStuff/myScene.mb.trash\', rename=\'C:/temp/mayaStuff/myScene.will.be.deleted\' )# Windows\ncmds.sysFile( \'/tmp/mayaStuff/myScene.mb.trash\', rename=\'/tmp/mayaStuff/myScene.will.be.deleted\' )# Unix\n\n# Copy a scene to the new directory\ndestWindows = "C:/temp/mayaStuff/myScene.mb.trash"\nsrcWindows = "C:/maya/projects/default/scenes/myScene.mb"\ncmds.sysFile( srcWindows, copy=destWindows )# Windows\n\ndestUnix = "/tmp/mayaStuff/myScene.mb.trash"\nsrcUnix = "maya/projects/default/scenes/myScene.mb"\ncmds.sysFile( srcUnix, copy=destUnix )# Unix\n\n# Delete the scene\ncmds.sysFile( \'C:/temp/mayaStuff/myScene.will.be.deleted\', delete=True )# Windows\ncmds.sysFile( \'/tmp/mayaStuff/myScene.will.be.deleted\', delete=True )# Unix',
 'tabLayout': "import maya.cmds as cmds\n\ncmds.window( widthHeight=(200, 150) )\nform = cmds.formLayout()\ntabs = cmds.tabLayout(innerMarginWidth=5, innerMarginHeight=5)\ncmds.formLayout( form, edit=True, attachForm=((tabs, 'top', 0), (tabs, 'left', 0), (tabs, 'bottom', 0), (tabs, 'right', 0)) )\n\nchild1 = cmds.rowColumnLayout(numberOfColumns=2)\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.setParent( '..' )\n\nchild2 = cmds.rowColumnLayout(numberOfColumns=2)\ncmds.button()\ncmds.button()\ncmds.button()\ncmds.setParent( '..' )\n\ncmds.tabLayout( tabs, edit=True, tabLabel=((child1, 'One'), (child2, 'Two')) )\n\ncmds.showWindow()",
 'tangentConstraint': "import maya.cmds as cmds\n\n# orients the aim vector of cube1 in it's local coordinate space,\n# to the tangent vector of curve1 at the closest point to  cube1.\ncmds.tangentConstraint( 'curve1', 'cube1' )\n\n# uses the average of the tangents from curve1 and curve2.\ncmds.tangentConstraint( 'curve1', 'curve2', 'cube2', w=.1 )\n\n# sets the weight for curve1's effect on cube2 to 10.\ncmds.tangentConstraint( 'curve1', 'cube2', e=True, w=10. )\n\n# removes curve2 from cube2's tangentConstraint\ncmds.tangentConstraint( 'curve2', 'cube2', e=True, rm=True )\n\n# adds curve3 to cube2's tangent constraint with the default weight\ncmds.tangentConstraint( 'curve3', 'cube2' )",
 'targetWeldCtx': "import maya.cmds as cmds\n\n# To create a new target weld context:\ncmds.targetWeldCtx()\n\n# To query if it is set to merge to the center:\ncmds.targetWeldCtx('targetWeldCtx1', q=True, mergeToCenter=True )\n\n# To set it to merge at the target:\ncmds.targetWeldCtx('targetWeldCtx1', e=True, mergeToCenter=False )",
 'tension': 'import maya.cmds as cmds\n\nimport maya.cmds as cmds\n\n# Create a poly sphere\ncmds.polySphere()\n\n# Attach a tension deformer to the sphere performing\n# 20 smoothing iterations with a step of 0.8\ncmds.tension( smoothingIterations=20, smoothingStep=0.8 )',
 'testPa': '',
 'testPassContribution': '',
 'texCutContext': "import maya.cmds as cmds\n\n// Create a new cut UV tool context, then switch to it\n// In order to use this tool, you must open the UV editor\ncmds.texCutContext('texCutContext1')\ncmds.setToolTo('texCutContext1')",
 'texLatticeDeformContext': "import maya.cmds as cmds\n\n# Create a lattice manipulator with 4 x 4 lattice.\n#\ncmds.texLatticeDeformContext( 'latticeContext', latticeColumns=4, latticeRows=4 )",
 'texManipContext': 'import maya.cmds as cmds\n\ncmds.texSelectContext()\n\ncmds.texManipContext()',
 'texMoveContext': "import maya.cmds as cmds\n\n# To create a new move context:\ncmds.texMoveContext()\n\n# To query the position of the manipulator\ncmds.texMoveContext( 'texMoveContext', q=True, position=True )",
 'texMoveUVShellContext': "import maya.cmds as cmds\n\n# To create a new move context:\ncmds.texMoveUVShellContext()\n\n# To query the position of the manipulator\ncmds.texMoveUVShellContext( 'texMoveUVShellContext', q=True, position=True )",
 'texRotateContext': "import maya.cmds as cmds\n\n# To create a new rotate context:\ncmds.texRotateContext()\n\n# To query the position of the manipulator\ncmds.texRotateContext( 'texRotateContext', q=True, position=True )",
 'texScaleContext': "import maya.cmds as cmds\n\n# To create a new scale context:\ncmds.texScaleContext()\n\n# To query the position of the manipulator\ncmds.texScaleContext( 'texScaleContext', q=True, position=True )",
 'texSculptCacheContext': "import maya.cmds as cmds\n\n# Create a new sculpting context, then switch to it\ncmds.texSculptCacheContext('uvSculptCtx')\ncmds.setToolTo('uvSculptCtx')\n\n# Set uvSculptCtx's brush size to 10.0\ncmds.texSculptCacheContext('uvSculptCtx', edit=True, bs=10.0)",
 'texSculptCacheSync': '',
 'texSelectContext': 'import maya.cmds as cmds\n\ncmds.texSelectContext()',
 'texSelectShortestPathCtx': "import maya.cmds as cmds\n\n# To create a new poly shortest edge path context:\n#\ncmds.texSelectShortestPathCtx( 'PolyTexShortestPath' )",
 'texSmoothContext': '',
 'texSmudgeUVContext': "import maya.cmds as cmds\n\n# Create a poly plane\ncmds.polyPlane(w=10, h=10, sx=10, sy=10, n='pPlane1')\n\n# Select all UVs\ncmds.select('pPlane1.map[0:120]', r=True)\n\n# Create a new smudge UV tool context, set the effect type to smudge mode, set the radius to 0.1 and pressure to 0.2, then switch to it\n# In order to use this tool to smudge the UVs of pPlane1, you must open the texture UV editor\ncmds.texSmudgeUVContext('texSmudgeUVContext1', effectType='smudge', r=0.1, prs=0.2)\ncmds.setToolTo('texSmudgeUVContext1')",
 'texTweakUVContext': "import maya.cmds as cmds\n\n# To create a new move context:\ncmds.texTweakUVContext()\n\n# To query the position of the manipulator\ncmds.texTweakUVContext( 'texMoveUVShellContext', q=True, position=True )",
 'texWinToolCtx': "import maya.cmds as cmds\n\n# Create a new texture window tool context, set this tool to dolly in the texture window, then switch to it\ncmds.texWinToolCtx('texWinToolCtx1', do=True)\ncmds.setToolTo('texWinToolCtx1')",
 'text': "import maya.cmds as cmds\n\ncmds.window( width=150 )\ncmds.columnLayout( adjustableColumn=True )\ncmds.text( label='Default' )\ncmds.text( label='Left', align='left' )\ncmds.text( label='Centre', align='center' )\ncmds.text( label='Right', align='right' )\ncmds.showWindow()",
 'textCurves': 'import maya.cmds as cmds\n\n# Create curves for text string "Maya" in the "Times-Roman" font:\ncmds.textCurves( f=\'Times-Roman\', t=\'Maya\' )\n\n# Create curves for text "hello world" in the "Courier" font.\n# The "-n" flag specifies the name of the resulting transform\n# and shape.\ncmds.textCurves( n= \'first\', f=\'Courier\', t=\'hello world\' )',
 'textField': 'import maya.cmds as cmds\n\n#    Create a window with a some fields for entering text.\n#\nwindow = cmds.window()\ncmds.rowColumnLayout( numberOfColumns=2, columnAttach=(1, \'right\', 0), columnWidth=[(1, 100), (2, 250)] )\ncmds.text( label=\'Name\' )\nname = cmds.textField()\ncmds.text( label=\'Address\' )\naddress = cmds.textField()\ncmds.text( label=\'Phone Number\' )\nphoneNumber = cmds.textField()\ncmds.text( label=\'Email\' )\nemail = cmds.textField()\n\n#    Attach commands to pass focus to the next field if the Enter\n#    key is pressed. Hitting just the Return key will keep focus\n#    in the current field.\n#\ncmds.textField( name, edit=True, enterCommand=(\'cmds.setFocus(\\"\' + address + \'\\")\') )\ncmds.textField( address, edit=True, enterCommand=(\'cmds.setFocus(\\"\' + phoneNumber + \'\\")\') )\ncmds.textField( phoneNumber, edit=True, enterCommand=(\'cmds.setFocus(\\"\' + email + \'\\")\') )\ncmds.textField( email, edit=True, enterCommand=(\'cmds.setFocus(\\"\' + name + \'\\")\') )\n\ncmds.showWindow( window )',
 'textFieldButtonGrp': "import maya.cmds as cmds\n\nwindow = cmds.window()\ncmds.columnLayout()\ncmds.textFieldButtonGrp( label='Label', text='Text', buttonLabel='Button' )\ncmds.showWindow( window )",
 'textFieldGrp': "import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout()\ncmds.textFieldGrp( label='Group 1', text='Editable' )\ncmds.textFieldGrp( label='Group 2', text='Non-editable', editable=False )\ncmds.showWindow()",
 'textManip': "import maya.cmds as cmds\n\n# Hide the text manip, then call headsUpMessage to draw a message in the 3d view. You can't see the message now because it's invisible\ncmds.textManip(v=False)\ncmds.headsUpMessage('Ouch!', time=5.0)\n\n# Show the text manip\ncmds.textManip(v=True)",
 'textScrollList': 'import maya.cmds as cmds\n\ncmds.window()\ncmds.paneLayout()\ncmds.textScrollList( numberOfRows=8, allowMultiSelection=True,\n            append=[\'one\', \'two\', \'three\', \'four\', \'five\', \'six\', \'seven\', \'eight\', \'nine\', \'ten\',\n                    \'eleven\', \'twelve\', \'thirteen\', \'fourteen\', \'fifteen\'],\n            selectItem=\'six\', showIndexedItem=4 )\ncmds.showWindow()\n\ncmds.window()\ncmds.paneLayout()\ncmds.textScrollList( "myControlObj", allowMultiSelection=True,\n            append=[ "Only two things are infinite, the universe and human stupidity, and I\'m not sure about the former.",\n                     "Each problem that I solved became a rule, which served afterwards to solve other problems."],\n            uniqueTag=["Albert Einstein","Rene Descartes"])\ncmds.showWindow()\ncmds.textScrollList( "myControlObj", edit=True, selectUniqueTagItem=["Albert Einstein"])\ncmds.textScrollList( "myControlObj", query=True, selectUniqueTagItem=True)\ncmds.textScrollList( "myControlObj", edit=True, append=["Your theory is crazy, but it\'s not crazy enough to be true."],\n                                                uniqueTag=["Niels Bohr"] )\ncmds.textScrollList( "myControlObj", edit=True, selectUniqueTagItem=["Rene Descartes", "Niels Bohr"])\ncmds.textScrollList( "myControlObj", query=True, selectUniqueTagItem=True)',
 'textureDeformer': 'import maya.cmds as cmds\n\ncmds.polySphere(constructionHistory=True, object=True, radius=3.0)\n\n# Deforms whatever is currently on the selection list\n# and set the attributes value for the deformer node\ncmds.textureDeformer(envelope=0.8, strength=1.0, offset=1.0, direction="Normal", pointSpace="World")',
 'textureLassoContext': '',
 'texturePlacementContext': 'import maya.cmds as cmds\n\ncmds.texturePlacementContext()',
 'textureWindow': "import maya.cmds as cmds\n\n# As a UV Editor typically exists on start-up, you normally\n# will not need to create one.. Hence all the examples that follow\n# explain how to query and edit the editor settings.\n\n# Get the panel that the editor belongs to.\ntexWinName = cmds.getPanel(sty='polyTexturePlacementPanel')\n\n# Get the space between main grid lines\ncmds.textureWindow(texWinName[0], q=True, sp=True)\n# Result: 0.05 #\n\n# Change the space between main grid lines\ncmds.textureWindow( texWinName[0], e=True, sp=0.1 )\n\n# Get the size of the grid\ncmds.textureWindow( texWinName[0], q=True, s=True )\n# Result: 12 #\n\n# Change the size of the grid\ncmds.textureWindow( texWinName[0], e=True, s=0.8 )\n\n# Zoom on the whole scene\ncmds.textureWindow( texWinName[0], e=True, fa=True )\n\n# Set display mode to related (connected) faces\ncmds.textureWindow(texWinName[0], e=True, rf=True )",
 'threadCount': 'import maya.cmds as cmds\n\n# sets Maya to use 4 threads for multithreaded evaluation\ncmds.threadCount( n=4 )\n\n# sets Maya to use one thread per logical CPU\ncmds.threadCount( n=0 )\n\n# query number of threads currently set\ncmds.threadCount( q=True, n=True )',
 'threePointArcCtx': 'import maya.cmds as cmds\n\n# To create a new context that will create curves of degree 1:\ncmds.threePointArcCtx( "arcContext", degree=1 )\ncmds.setToolTo("arcContext")\n\n# To query the degree of an existing context:\ncmds.threePointArcCtx( "arcContext", q=True, degree=True )\n\n# To edit the degree of an existing context:\ncmds.threePointArcCtx( "arcContext", e=True, degree=3 )',
 'thumbnailCaptureComponent': 'import maya.cmds as cmds\n\nimport maya.cmds as cmds\n\n\n#    Launch an option box used to capture the scene between frame 20 and 60\n\n\ncmds.thumbnailCaptureComponent(capture=True, startFrame=20, endFrame=60)\n\n\n#    Save the generated image sequence for "mesh.mb"\n\n\ncmds.thumbnailCaptureComponent(save=\'C:/maya/projects/default/scenes/mesh.mb\')\n\n\n#    Delete generated thumbnails for current capture session\n\ncmds.thumbnailCaptureComponent(delete=True)\n\n\n#    Return the path of generated sequence preview.\n\n\ncmds.thumbnailCaptureComponent(q=True, previewPath=True)\n# Result: C:/Users/perradw/Documents/maya/projects/default/images/.MayaTempCaptureComponent/tmp.preview #',
 'timeCode': 'import maya.cmds as cmds\n\n\n\n# set the production start time to 1 hour, 33 min, 52 seconds, and 23 frames\ncmds.timeCode(productionStartHour=1,productionStartMinute=33,productionStartSecond=52,productionStartFrame=23)\n\n# query the production start time\n#\ncmds.timeCode(query=1,productionStartHour=True)\n// result: 1\ncmds.timeCode(query=1,productionStartMinute=True)\n// result: 33',
 'timeControl': 'import maya.cmds as cmds\n\n# To display sound in the time slider, there must first be a sound\n# node in the scene. We\'ll create one and give it the name "ohNo".\n# Note that the argument to the -file flag must be a path to a valid\n# soundfile.\n#\ncmds.sound( file=\'C:/My Documents/maya/projects/default/sound/ohNo.aiff\', name=\'ohNo\' )\n\n\n# To display sound in the time slider, you must specify\n# the sound node to display and turn display of sound "on."\n# First we need to get the name of the playback slider from\n# the global mel variable called gPlayBackSlider\n#\nimport maya.mel\naPlayBackSliderPython = maya.mel.eval(\'$tmpVar=$gPlayBackSlider\')\ncmds.timeControl( aPlayBackSliderPython, e=True, sound=\'ohNo\', displaySound=True )\n\n# To hear sound while scrubbing in the time slider, set the press and\n# release commands to begin and end sound scrubbing.\n#\ncmds.timeControl( aPlayBackSliderPython,edit=True,pressCommand=\'cmds.timeControl(aPlayBackSliderPython,edit=True,beginScrub=True)\')\ncmds.timeControl( aPlayBackSliderPython,edit=True,releaseCommand=\'cmds.timeControl(aPlayBackSliderPython,edit=True,endScrub=True)\')',
 'timeEditor': "import maya.cmds as cmds\n\ncmds.timeEditor(mute=True)\n\n# Get clip IDs of current selected group clips\ncmds.timeEditor(selectedClips='group')\n\n# Get clip IDs of all selected clips\ncmds.timeEditor(selectedClips='')\n\n# Get all top-level group clip IDs in the active composition\ncmds.timeEditor(topLevelClips='group')\n\n# Recursively get all container clip IDs in the active composition\ncmds.timeEditor(allClips='container')\n\n# Recursively get all clip IDs under the specified group clip (id=2)\ncmds.timeEditor(allClips='', clipId=2)\n\n# Get all group clips directly under the specified group clip (id=21)\ncmds.timeEditor(topLevelClips='group', clipId=21)\n\n# Find the common parent track of the given clip IDs\ncmds.timeEditor(commonParentTrack=True, clipId=[1,2,3])",
 'timeEditorAnimSource': 'import maya.cmds as cmds\n\n\nimport maya.cmds as cmds\ndef setKey(time, value):\n    cmds.currentTime(time)\n    cmds.setAttr(\'cube.tx\', value)\n    cmds.setKeyframe(\'cube.tx\')\n\ncmds.file(f=True, new=True)\ncmds.polyCube(name=\'cube\')\nsetKey( 1,  0)\nsetKey( 5, -5)\nsetKey(10,  5)\n\n# Add cube.translateX with its animation to the anim source and calculate and save timing afterwards\ncmds.timeEditorAnimSource("AnimSourceNode", edit=1, addSource="cube.translateX", calculateTiming=1)\n\n# Add cube.translateX with a copy of its animation to the anim source\ncmds.timeEditorAnimSource("AnimSourceNode", edit=1, addSource="cube.translateX", copyAnimation=1)\n\n# Remove cube.translateX from the anim source\ncmds.timeEditorAnimSource("AnimSourceNode", edit=1, removeSource="cube.translateX")',
 'timeEditorBakeClips': 'import maya.cmds as cmds\n\n# Bakes the currently selected clips to a new clip named "testClip"\ncmds.timeEditorBakeClips(bakeToClip="testClip")',
 'timeEditorClip': 'import maya.cmds as cmds\n\n\n# Move clips 1 and 2\ncmds.timeEditorClip(edit=True, moveClip=20, clipId=[1,2])\n\n# Create new container clip on track 4 of Container_A tracks\ncmds.timeEditorClip("ClipNodeName", track="Container_A_Tracks:4")\n\n# Create new container clip on track path\ncmds.timeEditorClip("ClipNodeName", track="composition1|track1")\n\n# Populate selected objects with attributes driven by specific types of animation sources\ncmds.timeEditorClip("teClip1", addSelectedObjects=True, type=["animCurveTL","animCurveTA"], track="Composition1:1")\n\n# Populate selected objects and their associated keying groups (normally used for populating complete HIK rig)\ncmds.timeEditorClip("teClip1", addSelectedObjects=True, addRelatedKG=True, track="Composition1:1")\n\n# Populate selected objects into a newly created container\ncmds.timeEditorClip("ContainerName", track="Container_A_Tracks:0", addSelectedObjects=True)\n\n# Move a container(s) to a different track\n# The "New_Track:2" has the same format as when creating a new clip,\n# where "New_Track" is the TimeEditor "Tracks node" and "2" is the track index in that node.\n# A "Tracks" node maintains a list of tracks at a given level in the TimeEditor hierarchy\n# and is either a composition or a group clip.\ncmds.timeEditorClip(edit=True, track="New_Track:2", clipId=[1,2,3])\n\n# Move a container(s) to a different track by clip path\ncmds.timeEditorClip(edit=True, track="composition1|track1", path=["composition1|track2|clip1","composition1|track2|clip2","composition1|track2|clip3"])\n\n# Create a group from specified containers\ncmds.timeEditorClip("GroupName", track="New_Track:1", group=True, clipId=[1,2,3])\n\n# Import animation from selected object into the TimeEditor.\ncmds.timeEditorClip("container_A", aso=True, track="composition1|track1")\n\n# Return the Anim Source for a given clip ID 1\ncmds.timeEditorClip(1, query=True, animSource=True)\n\n# Create a clip from an Anim Source starting at frame 30 into track2 of composition1\ncmds.timeEditorClip("Container_B", track="composition1|track2", animSource="someAnimSourceName", startTime=30)\n\n# Return the start time of the clip with clip ID 1\ncmds.timeEditorClip(1, query=True, startTime=True, absolute=True)\n\n# Return the duration of the clip with clip ID 1\ncmds.timeEditorClip(1, query=True, duration=True, absolute=True)\n\n# Remap cube 1 translate X attribute to cube 1 translate Y attribute\ncmds.timeEditorClip(edit=True, remapSource=["cube1.translateY", "cube1.translateX"], clipId=1)\ncmds.timeEditorClip(edit=True, animSource="AnimSourceName", clipId=1)\n\n# Setup the crossfading mode between 2 clips to linear\ncmds.timeEditorClip(edit=True, crossfadeMode=-1, clipId=[1,2])\n\n# Remove clips with clip ID 1 and 2.\ncmds.timeEditorClip(edit=True, removeClip=True, clipId=[1,2])',
 'timeEditorClipLayer': 'import maya.cmds as cmds\n\n# Add an additive clip layer  by clip ID\ncmds.timeEditorClipLayer(e=True, clipId=1, addLayer="Layer A", mode=0)\n\n# Add an additive clip layer by clip path\ncmds.timeEditorClipLayer(e=True, path=\'Composition1|track1|Group|track1|Clip1\', addLayer="Layer A", mode=0)\n\n# Add an attribute to the given layer by clip ID and layer ID\ncmds.timeEditorClipLayer(e=True, clipId=1, layerId=1, addAttribute="cube.tx")\n\n# Add an attribute to the given layer by layer path\ncmds.timeEditorClipLayer(e=True, path=\'Composition1|track1|Clip1|Layer1\', addAttribute="cube.tx")\n\n# Set key in the given layer\ncmds.select("cube")\ncmds.move(10, 0, 0, r=True)\ncmds.timeEditorClipLayer(e=True, clipId=1, layerId=1, setKeyframe=True, attribute="cube.tx")\n\n# Remove layer attribute\ncmds.timeEditorClipLayer(e=True, clipId=1, layerId=1, removeAttribute="cube.tx")\n\n# Query the layer name\ncmds.timeEditorClipLayer(clipId=1, layerId=1, layerName=True, q=True)\n\n# Remove the specified layer by clip ID and layer ID\ncmds.timeEditorClipLayer(e=True, clipId=1, removeLayer=True, layerId=1);\n\n# Remove the specified layer by layer path\ncmds.timeEditorClipLayer(e=True, path=\'Composition1|track1|Clip1|Layer1\', removeLayer=True);',
 'timeEditorClipOffset': 'import maya.cmds as cmds\n\n\n# Match position and rotation\n#\ncmds.timeEditorClipOffset( clipId=1, matchClipId=2, matchObj="cube", matchSrcTime=45, matchDstTime=45, matchTransOp=0, matchRotOp=1, applyToAllRoots=1 )\n\n# Match position and rotation by clip paths\n#\ncmds.timeEditorClipOffset( path=\'composition1|track1|clip1\', matchPath=\'composition1|track1|clip2\', matchObj="cube", matchSrcTime=45, matchDstTime=45, matchTransOp=0, matchRotOp=1, applyToAllRoots=1 )',
 'timeEditorComposition': 'import maya.cmds as cmds\n\n\n# To create composition "Take1"\ncmds.timeEditorComposition("Take1")\n\n# To query active composition (returns name of the tracks node for that composition)\ncmds.timeEditorComposition(query=1, active=1)\n\n# To set active composition by specifying the associated tracks node\ncmds.timeEditorComposition("TE_Tracks_Take2", edit=1, active=1)',
 'timeEditorPanel': 'import maya.cmds as cmds\n\n# Check to see if the "default" time editor has been created\n#\ncmds.timeEditorPanel( \'timeEditorPanel1TimeEd\', exists=True )\n\n# Open the group(id=1) in local time tab\n#\ncmds.timeEditorPanel( \'timeEditorPanel1TimeEd\', e=True, tabView=1 );\n\n# Query the current active tab view\n#\ncmds.timeEditorPanel( \'timeEditorPanel1TimeEd\', q=True, activeTabView=True ) ;\n\n# Query the corresponding group given the tab view index\n#\ncmds.timeEditorPanel( \'timeEditorPanel1TimeEd\', q=True, activeTabTime=True ) ;\n\n# Query the corresponding group given the tab view index\n#\ncmds.timeEditorPanel( \'timeEditorPanel1TimeEd\', groupIdForTabView=1, q=True );',
 'timeEditorTracks': 'import maya.cmds as cmds\n\n#  Insert a track at the end\n#\ncmds.timeEditorTracks( \'container1_tracks\', e=1, addTrack=-1 )\n\n#  Insert a track at the end by path, inside a composition\n#\ncmds.timeEditorTracks( path=\'composition1\', e=1, addTrack=-1 )\n\n#  Insert a track at the end by path, inside a group clip\n#\ncmds.timeEditorTracks( path=\'composition1|track1|groupClip\', e=1, addTrack=-1 )\n\n# Remove the track from "container1_tracks"\n#\ncmds.timeEditorTracks( \'container1_tracks\', e=1, removeTrack=1 )\n\n# Remove the track by paths\n#\ncmds.timeEditorTracks( e=1, removeTrackByPath=[\'composition1|track2\', \'composition1|track1|group|track3\'] )\n\n# Move track 0 forward 1 siblings\n#\ncmds.timeEditorTracks( \'container1_tracks\', e=1, reorderTrack=(0, 1) )\n\n# Set the track name\n#\ncmds.timeEditorTracks( \'container1_tracks\', e=1, trackName="Test", trackIndex=0 )\n\n# Set the track name by path\n#\ncmds.timeEditorTracks( e=1, trackName="Test", path=\'composition1|track2\' )\n\n# Mute the track\n#\ncmds.timeEditorTracks( \'container1_tracks\', e=1, trackMuted=True, trackIndex=0 )',
 'timeField': 'import maya.cmds as cmds\n\nwindow = cmds.window()\ncmds.columnLayout()\ncmds.timeField()\ncmds.timeField( editable=False )\ncmds.timeField( value=0 )\ncmds.timeField( precision=2 )\ncmds.timeField( precision=4, step=.01 )\ncmds.timeField( autoUnitWidth=6, value=123 )\ncmds.showWindow( window )',
 'timeFieldGrp': "import maya.cmds as cmds\n\nwindow = cmds.window()\ncmds.columnLayout()\ncmds.timeFieldGrp( numberOfFields=3, label='Scale', extraLabel='cm', value1=0.3, value2=0.5, value3=0.1 )\ncmds.showWindow( window )",
 'timePort': "import maya.cmds as cmds\n\n# Create a window that has a timePort in it\n#\ncmds.window( w=500, h=35 )\ncmds.columnLayout()\ncmds.timePort( 'myTimePort', w=500, h=35)\ncmds.showWindow()\n\n# Turn snapping off on the above timePort\n#\ncmds.timePort( 'myTimePort', e=True, snap=False )",
 'timeRangeInfo': '',
 'timeSliderCustomDraw': '',
 'timeWarp': "import maya.cmds as cmds\n\n# Create a time warp on the animation curves driving a cylinder and a sphere,\n# and specify the warping is to occur at frames 1 and 20.\n# Note: Time warps are only applied to animated objects.\n#\nwarp = cmds.timeWarp( 'pCylinder1', 'pSphere1',f=[1,20])\n\n# Move the first warp to frame 5\n#\ncmds.timeWarp(warp,e=1,mf=(0,5))\n\n# Move the 2nd warp to frame 10\n#\ncmds.timeWarp(warp,e=1,mf=(1,10))\n\n# Modify the interpolation between the 1st and 2nd warp to easeIn\n#\ncmds.timeWarp(warp,e=1,it=(0,'easeIn'))\n\n# query the original frames\n#\ncmds.timeWarp(warp,q=1,f=1)\n# Result: [1.0, 20.0, 30.0] #\n\n# query the modified frames\n#\ncmds.timeWarp(warp,q=1,mf=1)\n# Result: [5.0, 10.0, 30.0] #\n\n# query the interpolation\n#\ncmds.timeWarp(warp,q=1,it=1)\n# Result: [u'easeIn', u'linear'] #",
 'timer': 'import maya.cmds as cmds\n\n\ncmds.timer( s=True )\n# code being timed\nprint "START: time this"\nfor i in range (0, 50):\n\tprint ("time this "+str(i))\nprint "END: time this"\ncmds.timer( e=True )\n\n# Named timers can be used for nesting\ncmds.timer( s=True, name="outerLoop" )\nprint "START: macro loop timing"\nfor i in range(0,50):\n\tcmds.timer( s=True )\n\tfor j in range(5,50):\n\t\tnewObjs = cmds.sphere( spans=j )\n\t\tcmds.delete( newObjs )\n\tinnerTime = cmds.timer( e=True )\n\tlapTime = cmds.timer( lap=True, name="outerLoop" )\n\tprint "\\tInner loop %d = %g" % (i, innerTime)\n\tprint "\\t       SUB = %g" % lapTime\nfullTime = cmds.timer( e=True, name="outerLoop" )\nprint "END: Full timing was %g" % fullTime',
 'timerX': 'import maya.cmds as cmds\n\n# Example 1: Simple timing\n#\nstart = cmds.timerX()\n# code that is being timed\ntotalTime = cmds.timerX(startTime=start)\nprint "Total time: ", totalTime\n\n# Example 2: Iterative timing\n#\nstartTime = cmds.timerX()\nfor i in range(0,5):\n  elapsedTime = cmds.timerX()\n  print "Elapsed Time: ", elapsedTime\n\n# Example 3: Stacked timing calls\n#\nstartTime1 = cmds.timerX()\nstartTime2 = cmds.timerX()\nfor i in range(0,5):\n  elapsedTime = cmds.timerX()\n  print "Elapsed Time: ", elapsedTime\n\ntotalTime = cmds.timerX(startTime=startTime1)\nprint "Total Time: ", totalTime',
 'toggle': 'import maya.cmds as cmds\n\nsurface1 = cmds.sphere()\ncmds.toggle( surface1, cv=True )\ncmds.toggle( g=True, cv=True )\ncmds.toggle( q=True, cv=True )\n# Returns 0 if the queried state is false.\n# Returns 1 if the queried state is true.',
 'toggleAxis': 'import maya.cmds as cmds\n\n# Turns origin axis on\ncmds.toggleAxis( o=True )\n\n# Turns origin axis off.\ncmds.toggleAxis( o=False )\n\n# Returns true if the axis at the origin is on.\ncmds.toggleAxis( q=True, o=True )\n\n# Toggles the display of the axis\ncmds.toggleAxis()',
 'toggleDisplacement': 'import maya.cmds as cmds\n\n# Toggle the displacement preview of the selected polygons.\ncmds.toggleDisplacement()',
 'toggleWindowVisibility': 'import maya.cmds as cmds\n\nwindow1 = cmds.window( retain=True )\ncmds.columnLayout()\ncmds.checkBox()\ncmds.checkBox()\ncmds.checkBox()\ncmds.button( label=\'Close\', command=\'cmds.window( window1, edit=True, visible=False )\' )\n\n#    Create another window with a button that will toggle the visibility\n#    of the first window.\n#\nwindow2 = cmds.window()\ncmds.columnLayout()\ncmds.button( label=\'Toggle Window Visibility\', command=(\'cmds.toggleWindowVisibility(\\"\' + window1 +\'\\")\' ) )\n\ncmds.showWindow( window1 )\ncmds.showWindow( window2 )',
 'tolerance': "import maya.cmds as cmds\n\ncmds.tolerance( linear=0.02 )# sets the tolerance to 0.02, in the current unit\ncmds.tolerance( linear='0.02cm' )# sets the tolerance to 0.02 cm\ncmds.tolerance( angular='0.02rad' )# sets the angle tolerance to 0.02 radians\ncmds.tolerance( q=True, linear=True )# returns the current tolerance in the current unit\ncmds.tolerance( q=True, angular=True )# returns the current tolerance in the current unit",
 'toolBar': "import maya.cmds as cmds\n\nmyWindow = cmds.window()\nbuttonForm = cmds.formLayout( parent = myWindow )\ncmds.button( parent = buttonForm )\nallowedAreas = ['top', 'bottom']\ncmds.toolBar( area='top', content=myWindow, allowedArea=allowedAreas )",
 'toolButton': "import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout()\ncmds.toolCollection()\ncmds.toolButton( tool='selectSuperContext', toolImage1=('selectSuperContext', 'aselect.xpm') )\ncmds.toolButton( tool='moveSuperContext', toolImage1=('moveSuperContext', 'move_M.xpm') )\ncmds.toolButton( tool='scaleSuperContext', toolImage1=('scaleSuperContext', 'scale_M.png') )\ncmds.showWindow()\n\n# example showing how to create tool buttons for artisan tools\n#\n# create the contexts\nselectCtx = cmds.artSelectCtx()\nputtyCtx = cmds.artPuttyCtx()\nsetPaintCtx = cmds.artSetPaintCtx()\n\ncmds.window()\ncmds.gridLayout()\ncmds.toolCollection()\n# create the tool buttons using the contexts returned\ncmds.toolButton(\n\t\tamt=True, piv=True,\n\t\tdoubleClickCommand='cmds.toolPropertyWindow()',\n\t\ttool=(selectCtx, puttyCtx, setPaintCtx),\n\t\ttoolImage1=(selectCtx, 'artSelect.xpm'),\n\t\ttoolImage2=(puttyCtx, 'putty.png'),\n\t\ttoolImage3=(setPaintCtx, 'paintSetMembership.png') )\ncmds.showWindow()",
 'toolCollection': "import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout()\ncmds.toolCollection()\ncmds.toolButton( tool='selectSuperContext', toolImage1=('selectSuperContext', 'aselect.xpm') )\ncmds.toolButton( tool='moveSuperContext', toolImage1=('moveSuperContext', 'move_M.png') )\ncmds.toolButton( tool='scaleSuperContext', toolImage1=('scaleSuperContext', 'scale_M.png') )\ncmds.showWindow()",
 'toolDropped': "import maya.cmds as cmds\n\n# Create move tool button and scale tool button in a new window\ncmds.window()\ncmds.columnLayout()\ncmds.toolCollection()\ncmds.toolButton( tool='moveSuperContext', toolImage1=('moveSuperContext', 'move_M.png') )\ncmds.toolButton( tool='scaleSuperContext', toolImage1=('scaleSuperContext', 'scale_M.png') )\ncmds.showWindow()\n\n# Drop select tool to the created window\ncmds.toolDropped('selectTool')",
 'toolHasOptions': "import maya.cmds as cmds\n\nif cmds.toolHasOptions('moveSuperContext'):\n\tprint 'moveSuperContext tool has options'",
 'toolPropertyWindow': 'import maya.cmds as cmds\n\ncmds.toolPropertyWindow()\npictureObject = cmds.toolPropertyWindow(q=True, icon=True)',
 'torus': "import maya.cmds as cmds\n\ncmds.torus()\ncmds.torus( ch=True, radius=10, hr=3 )\ncmds.torus( r=5, axis=(1, 1, 1), pivot=(0, 0, 1), ssw='0deg', esw='90deg', msw='45deg' )\ncmds.torus( ut=True, tol=0.01 )\n# query the torus radius\nr = cmds.torus( 'nurbsTorus1', r=True, q=True )",
 'track': "import maya.cmds as cmds\n\ncmds.camera()\n\ncmds.track( 'cameraShape1', d=10 )# To track the camera down\n\ncmds.track( 'cameraShape1', u=-10 )\n\ncmds.track( u=-10 )",
 'trackCtx': "import maya.cmds as cmds\n\ncmds.trackCtx( 'trackContext', ac=False, tg=False, ts=1.0 )",
 'transferAttributes': "import maya.cmds as cmds\n\n# Transfer all UV and color sets from pCube1 onto pSphere1\ncmds.transferAttributes( 'pCube1', 'pSphere1', transferUVs=2, transferColors=2 )",
 'transferShadingSets': 'import maya.cmds as cmds\n\n# make a low res sphere with shaders\nlow = cmds.polySphere( sx=6, sy=6 )[0]\nlowShape = cmds.listRelatives( low, fullPath=True, shapes=True )[0]\nredSG = cmds.sets( r=True, em=True )\nredMat = cmds.shadingNode( "lambert", asShader=True )\ncmds.setAttr( redMat + ".color", 1, 0, 0, type=\'double3\' )\ncmds.connectAttr( redMat + ".outColor", redSG + ".surfaceShader", f=True )\ngreenSG = cmds.sets( r=True, em=True )\ngreenMat = cmds.shadingNode( "lambert", asShader=True )\ncmds.setAttr( greenMat + ".color", 0, 1, 0, type=\'double3\' )\ncmds.connectAttr( greenMat + ".outColor", greenSG + ".surfaceShader", f=True )\ncmds.sets( lowShape + \'.f[0:17]\', e=True, fe=redSG )\ncmds.sets( lowShape + \'.f[18:36]\', e=True, fe=greenSG )\n\n# make a high res sphere\nhigh = cmds.polySphere( sx=20, sy=20 )[0]\nhighShape = cmds.listRelatives( high, fullPath=True, shapes=True )[0]\ncmds.xform( high, ws=True, t=(2, 0, 0) )\n\n# transfer the shading sets\ncmds.select( low, r=True )\ncmds.select( high, tgl=True )\ncmds.transferShadingSets( sampleSpace=1 )',
 'transformCompare': "import maya.cmds as cmds\n\n# Create some joints\n#\ncmds.select( d=True )\ncmds.joint( p=(-3.226531, 0, -4.866136) )\ncmds.joint( p=(2.817897, 0, -4.016915) )\ncmds.joint( 'joint1', e=True, zso=True, oj='xyz', sao='yup' )\n\n# Compare 2 different joints, a 1 will be returned\n#\ncmds.select( 'joint1', 'joint2', r=True )\ncmds.transformCompare()\n\n# Duplicate joint1 and compare the duplicate\n#\ncmds.select( 'joint1', r=True )\ncmds.duplicate()\ncmds.select( cl=True )\ncmds.select( 'joint1', 'joint3', r=True )\ncmds.transformCompare()",
 'transformLimits': 'import maya.cmds as cmds\n\n# Create an object, e.g.\ncmds.cone()\n\n# 1. To set the limits for the translation of the cone to within\n# a unit volume centered at the origin\ncmds.transformLimits( tx=(-1, 1), ty=(-1, 1), tz=(-1, 1) )\n\n# 2. To disable the lower limits\ncmds.transformLimits( etx=(False, True), ety=(False, True), etz=(False, True ) )',
 'translator': "import maya.cmds as cmds\n\n# Returns true if dxf files can be read.\ncmds.translator( 'dxf', q=True, rs=True )",
 'treeLister': "import maya.cmds as cmds\n\nw = cmds.window(width=200)\nfl = cmds.formLayout()\ntl = cmds.treeLister()\ncmds.formLayout(fl, e=True,\n                af=((tl, 'top', 0),\n                    (tl, 'left', 0),\n                    (tl, 'bottom', 0),\n                    (tl, 'right', 0)))\ncmds.showWindow(w)\nitems=['root/branchone/leafone',\n       'root/branchone/leaftwo',\n       'root/branchtwo/leafthree']\ncmds.treeLister(tl, e=True, add=[(i, 'sphere.png', cmds.sphere) for i in items])",
 'treeView': 'import maya.cmds as cmds\n\ndef selectTreeCallBack(*args):\n  print \'selection :- str= \' + args[0] + \' onoff= \' + str(args[1])\n  return True\n\ndef pressTreeCallBack(*args):\n  print \'press :- str= \' + args[0] + \' onoff= \' + str(args[1])\n\nfrom maya import cmds\nwindow = cmds.window()\nlayout = cmds.formLayout()\n\ncontrol = cmds.treeView( parent = layout, numberOfButtons = 3, abr = False )\n\ncmds.formLayout(layout,e=True, attachForm=(control,\'top\', 2))\ncmds.formLayout(layout,e=True, attachForm=(control,\'left\', 2))\ncmds.formLayout(layout,e=True, attachForm=(control,\'bottom\', 2))\ncmds.formLayout(layout,e=True, attachForm=(control,\'right\', 2))\n\ncmds.showWindow( window )\n\ncmds.treeView( control, e=True, addItem = ("layer 1", ""))\ncmds.treeView( control, e=True, addItem = ("layer 2", ""))\ncmds.treeView( control, e=True, addItem = ("layer 3", ""))\ncmds.treeView( control, e=True, addItem = ("layer 4", ""))\ncmds.treeView( control, e=True, addItem = ("layer 5", ""))\ncmds.treeView( control, e=True, addItem = ("layer 6", ""))\ncmds.treeView( control, e=True, addItem = ("layer 7", "layer 2"))\ncmds.treeView( control, e=True, addItem = ("layer 8", "layer 2"))\ncmds.treeView( control, e=True, addItem = ("layer 9", "layer 2"))\ncmds.treeView( control, e=True, addItem = ("layer 10", "layer 8"))\ncmds.treeView( control, e=True, addItem = ("layer 11", "layer 2"))\ncmds.treeView( control, e=True, addItem = ("layer 12", ""))\ncmds.treeView( control, e=True, addItem = ("layer 13", "layer 10"))\ncmds.treeView(control,edit=True,pressCommand=[(1,pressTreeCallBack),(2,pressTreeCallBack),(3,pressTreeCallBack)])\ncmds.treeView(control,edit=True,selectCommand=selectTreeCallBack)\n\n\ncmds.treeView( control, edit=True, removeAll = True )',
 'trim': 'import maya.cmds as cmds\n\n# Keep all selected regions\ncmds.trim( sl=0 )\n\n# Discard all selected regions\ncmds.trim( sl=1 )\n\n# shrink the underlying surface to just outside the\n# outermost boundary curve\ncmds.trim( sh=1 )',
 'trimCtx': '',
 'truncateFluidCache': 'import maya.cmds as cmds\n\n# Truncate a fluid cache that has a start time of 1\n# and an end time of 25 so that only the first 10\n# frames are preserved and the end time of the\n# cache is set to 10.\n#\ncmds.currentTime( 10 )\ncmds.truncateFluidCache()',
 'truncateHairCache': 'import maya.cmds as cmds\n\n# Truncate a hair cache that has a start time of 1\n# and an end time of 25 so that only the first 10\n# frames are preserved and the end time of the\n# cache is set to 10.\n#\ncmds.currentTime( 10 )\ncmds.truncateHairCache()',
 'tumble': "import maya.cmds as cmds\n\ncmds.camera()\ncmds.tumble( 'cameraShape1', aa=-30 )# To change the azimuth angle\n\ncmds.tumble( 'cameraShape1', ea=15 )# To change the elevation angle\n\ncmds.tumble( ra=(-30, 15) )# To change the azimuth angle and the elevation angle",
 'tumbleCtx': "import maya.cmds as cmds\n\ncmds.tumbleCtx( 'tumbleContext', ts=1.0, lt=False, ac=False, ol=True )",
 'turbulence': "import maya.cmds as cmds\n\n# Creates a new field\ncmds.turbulence( n='turbulenceF', m=5.0, pos=(0.25, 0, 0) )\n\n# Edits the frequency value of the field named turbulenceF\ncmds.turbulence( 'turbulenceF', e=True, f=0.5 )\n\n# Queries turbulenceF for its frequency value\ncmds.turbulence( 'turbulenceF', q=True, f=1 )",
 'twoPointArcCtx': "import maya.cmds as cmds\n\n# To create a new context that will create curves of degree 1:\ncmds.twoPointArcCtx( degree=1 )\n\n# To query the degree of an existing context:\ncmds.twoPointArcCtx( 'arcContext1', q=True, degree=True )",
 'ubercam': "import maya.cmds as cmds\n\ncamera = cmds.shot('myUbercam');",
 'uiTemplate': "import maya.cmds as cmds\n\n#    Create a new template.\n#\nif cmds.uiTemplate( 'ExampleTemplate', exists=True ):\n\tcmds.deleteUI( 'ExampleTemplate', uiTemplate=True )\n\ncmds.uiTemplate( 'ExampleTemplate' )\n\ncmds.button( defineTemplate='ExampleTemplate', width=100, height=40, align='left' )\ncmds.frameLayout( defineTemplate='ExampleTemplate', borderVisible=True, labelVisible=False )\n\n#    Create a window and apply the template.\n#\nwindow = cmds.window()\ncmds.setUITemplate( 'ExampleTemplate', pushTemplate=True )\ncmds.columnLayout( rowSpacing=5 )\n\ncmds.frameLayout()\ncmds.columnLayout()\ncmds.button( label='One' )\ncmds.button( label='Two' )\ncmds.button( label='Three' )\ncmds.setParent( '..' )\ncmds.setParent( '..' )\n\ncmds.frameLayout()\ncmds.columnLayout()\ncmds.button( label='Red' )\ncmds.button( label='Green' )\ncmds.button( label='Blue' )\ncmds.setParent( '..' )\ncmds.setParent( '..' )\n\ncmds.setUITemplate( popTemplate=True )\n\ncmds.showWindow( window )",
 'unassignInputDevice': "import maya.cmds as cmds\n\n# This deletes all command strings associated with the spaceball.\ncmds.unassignInputDevice( d='spaceball' )",
 'undo': "import maya.cmds as cmds\n\n# In this particular example, each line needs to be executed\n# separately one after the other. Executing lines separately\n# guaranties that commands are properly registered in the undo\n# stack.\n\ncmds.polyCube()\n# Result: [u'pCube1', u'polyCube1'] #\n\ncmds.polySphere()\n# Result: [u'pSphere1', u'polySphere1'] #\n\ncmds.undo()\n# Undo: cmds.polySphere()\n #\n\ncmds.undo()\n# Undo: cmds.polyCube()\n #",
 'undoInfo': 'import maya.cmds as cmds\n\n# Turn undo on, with an infinite queue length\ncmds.undoInfo( state=True, infinity=True )\n# Turn undo on, with a queue length of 200\ncmds.undoInfo( state=True, infinity=False, length=200 )\n# Turn undo off\ncmds.undoInfo( state=False )\n# Query the queue length\ncmds.undoInfo( q=True, length=True )\n# Query the number of items currently on the queue.\ncmds.undoInfo( q=True )',
 'unfold': "import maya.cmds as cmds\n\n# Create a sphere and select it.\ncmds.polySphere()\n\n# Optimise the position of some Uvs\ncmds.unfold( 'pSphere1.map[189:398]' )",
 'ungroup': "import maya.cmds as cmds\n\n# Create a simple hierarchy\ncmds.sphere( n='sphere1' )\ncmds.move( 2, 0, 0 )\ncmds.sphere( n='sphere2' )\ncmds.move( -2, 0, 0 )\ncmds.group( 'sphere1', 'sphere2', n='group1' )\ncmds.move( 0, 2, 0 )\ncmds.sphere( n='sphere3' )\ncmds.move( 0, 0, 2 )\ncmds.group( 'group1', 'sphere3', n='group2' )\ncmds.group( em=True, n='group3' )\n\n# Remove group1 from the hierarchy. What should remain\n# is group2 with sphere3, sphere1, and sphere2 as children.\n# Note that the objects don't move since the absolute flag\n# is implied.\n#\ncmds.ungroup( 'group1' )\n\n# Try the same ungroup with the -relative flag.\n# Now sphere1 and sphere2 will move down 2 units in Y.\n#\ncmds.undo()\ncmds.ungroup( 'group1', relative=True )\n\n# Now try the same ungroup operation with the -parent flag.\n# This will move the children of group1 under group3.\ncmds.undo()\ncmds.ungroup( 'group1', parent='group3' )",
 'uniform': "import maya.cmds as cmds\n\ncmds.uniform( dx=0, dy=1.0, dz=0.5 )\n# Creates a uniform field pushing in direction (0,1,0.5) for every\n# active selection. If there is no active selection, it creates this\n# field at world position (0,0,0).\n\ncmds.uniform( 'uniformF', e=True, att=0.98 )\n# edits the acceleration value of the field uniformF\ncmds.uniform( 'uniformF', q=True, att=1 )\n# queries uniformF for its acceleration value",
 'unknownNode': "import maya.cmds as cmds\n\n# query the unknown node's real class name\n#\ncmds.unknownNode( 'testIterator1', q=True, rcn=True )\n# Result: testIterator #\n\n# query the unknown node's class IFF tag\n# if the node was loaded from a Maya ASCII file\n#\ncmds.unknownNode( 'testIterator1', q=True, rct=True )\n# Warning: line 1: No class tag available for node 'testIterator1'. #\n# Result: 0 #\n\n# if the node was loaded from a Maya Binary file\n#\ncmds.unknownNode( 'testIterator1', q=True, rct=True )\n# Result: 10 #\n\n# query the plug-in that defined the unknown node\n#\ncmds.unknownNode( 'testIterator1', q=True, p=True )\n# Result: testIteratorNode #",
 'unknownPlugin': 'import maya.cmds as cmds\n\n# list the unknown plug-ins\n#\ncmds.unknownPlugin( q=True, l=True )\n# Result: foo #\n\n# query the version of the unknown plug-in\n#\ncmds.unknownPlugin( "foo", q=True, v=True )\n# Result: 1.0 #\n\n# attempt to remove the unknown plug-in\n#\ncmds.unknownPlugin( "foo", r=True )',
 'unloadPlugin': 'import maya.cmds as cmds\n\n# Unload the plugin that has the internal name "newNode"\n#\ncmds.unloadPlugin( \'newNode.py\' )',
 'untangleUV': "import maya.cmds as cmds\n\ncmds.untangleUV( mb='shape_square' )\n# map the border associated with the selected UV trying to retain the\n# shape of the object and use a square mapping to iron out crossings\n\ncmds.untangleUV( r='one_over_length', pb=True, ps=False, pu=False, rt=0.1 )\n# relax the shell associated with the selected UV using edge weights\n# that are inversely proportional to length of world space lengths\n# pin the UV on borders and use a tolerance of 0.1",
 'untrim': "import maya.cmds as cmds\n\n# Untrim surface with history.\ncmds.untrim( 'surface', ch=True )\n\n# Untrims surface without history.\ncmds.untrim( 'surface', ch=False )",
 'upAxis': 'import maya.cmds as cmds\n\n# 1. to make the Y-axis of the world to be the up axis:\ncmds.upAxis( ax=\'y\' )\n\n# 2. to make the Z-axis of the world to be the up axis,\n# and rotate the view:\ncmds.upAxis( ax=\'z\', rv=True )\n\n# 3. to query which axis is the current up axis\n# (returns a string: a "y" or a "z"):\ncmds.upAxis( q=True, axis=True )',
 'userCtx': '',
 'uvLink': "import maya.cmds as cmds\n\ncmds.uvLink( uvSet='pSphereShape1.uvSet[2].uvSetName', texture='checker1' )\n# causes a UV link to be created between uvSet[2] on pSphereShape1\n# and the checker1 texture.\n# Note that no make, break or query flag is specified so make is\n# assumed since both uvSet and texture are specified.\n\ncmds.uvLink( make=True, uvSet='pCubeShape2.uvSet[0].uvSetName', texture='file8' )\n# causes a UV link to be created between uvSet[0] of pCubeShape2 and\n# the file8 file texture.\n\ncmds.uvLink( uvSet='pCubeShape2.uvSet[0].uvSetName', texture='file8' )\n# causes a UV link to be created between uvSet[0] of pCubeShape2 and\n# the file8 file texture. Note: no make, break or query flag is\n# specified so the make flag is assumed since both uvSet\n# and texture are specified.\n\ncmds.uvLink( query=True, uvSet='pCubeShape2.uvSet[0].uvSetName' )\n# will return a string array of textures which use the UV set\n# pCubeShape2.uvSet[0].setName. For example, the return value might\n# be:\n# file8 file9 checker4 slimeMap\n\ncmds.uvLink( query=True, texture='checker4' )\n# will return a string array of the UV sets that are used by the\n# texture. For example, the return value might be\n# pCubeShape2.uvSet[0].setName pCylinderShape1.uvSet[4].setName\n# pCylinderShape2.uvSet[3].setName\n\ncmds.uvLink( texture='checker4' )\n# will return a string array of the UV sets that are used by the\n# texture. For example, the return value might be\n# pCubeShape2.uvSet[0].setName pCylinderShape1.uvSet[4].setName\n# pCylinderShape2.uvSet[3].setName\n# Note that no make, break or query flag is specified, so query is\n# assumed since no uvSet was specified.\n\ncmds.uvLink( b=True, uvSet='pCylinderShape2.uvSet[3].uvSetName', texture='checker4' )\n# causes the checker4 texture to no longer use the UV set\n# pCylinderShape2.uvSet[3].setName.\n# The texture will use the default UV set on pCylinderShape2 instead.\n# If checker4 wasn't using pCylinderShape2.uvSet[3].setName,\n# nothing changes and a warning is produced.\n\ncmds.uvLink( isValid=True, texture='myTexture' )\n# Returns true if myTexture is a texture to which a UV set can be\n# linked, or false otherwise.\n\nmyPlug = getSomePlugFromSomewhere()\ncmds.uvLink( isValid=True, uvSet=myPlug )\n# Returns true if $myPlug is a UV set, or false otherwise.",
 'uvSnapshot': "import maya.cmds as cmds\n\n# Create a polygonal sphere\ncmds.polySphere()\n\n# Save the UVs in a image\ncmds.uvSnapshot( o=True, n='/tmp/uvImage2.iff', xr=256, yr=256 )",
 'view2dToolCtx': "import maya.cmds as cmds\n\n# Create a new view2dTool context, set it to do dolly in the Hypergraph window, then switch to this tool\ncmds.view2dToolCtx('view2dToolCtx1', dolly=True)\ncmds.setToolTo('view2dToolCtx1')",
 'viewCamera': "import maya.cmds as cmds\n\ncmds.viewCamera( 'cameraShape2', m='cameraShape1' )\n\n# Move current view camera to top of camera1\ncmds.viewCamera( 'camera1' )",
 'viewClipPlane': "import maya.cmds as cmds\n\ncmds.viewClipPlane( 'perspShape', acp=True )\n\ncmds.viewClipPlane( acp=True )\n\ncmds.viewClipPlane( acp=True, ncp=3.0 )\n\ncmds.viewClipPlane( ncp='3.0cm' )\n\ncmds.viewClipPlane( 'perspShape', q=True, ncp=True )",
 'viewFit': "import maya.cmds as cmds\n\n# Position the active camera to view the active objects\ncmds.viewFit()\n\n# Position cameraShape-1 to view all objects\ncmds.viewFit( 'cameraShape1', all=True )\n\n# Fill 50 percent of the active view with active objects\ncmds.viewFit( f=0.5 )\n\ncmds.viewFit( all=True )",
 'viewHeadOn': 'import maya.cmds as cmds\n\n# Create a new camera\ncam = cmds.camera()\ncamera = cam[0]\n\n# Create a polygonal cone, rotate it, make it live\nobject = cmds.polyCone( ax=(0, 1, 0) )\ncmds.rotate( 15, 30, 45 )\ncmds.makeLive( object[0] )\n\ncmds.viewHeadOn( camera )\n\ncmds.makeLive( none=True )',
 'viewLookAt': 'import maya.cmds as cmds\n\n# Create a new camera\ncam = cmds.camera()\ncamera = cam[0]\n\ncmds.viewLookAt( camera, pos=(0.0, 1.0, 0.0) )',
 'viewManip': 'import maya.cmds as cmds\n\n#Position the view cube in the top left of the screen and set it to fully opaque\ncmds.viewManip(topLeft=True, minOpacity=1)',
 'viewPlace': 'import maya.cmds as cmds\n\n# Create a new camera\ncam = cmds.camera();\ncamShape = cam[1];\n\ncmds.viewPlace( camShape, p=True, fov=20 )\n\ncmds.viewPlace( camShape, eye=(0, 0, 20) )\n\ncmds.viewPlace( camShape, la=(0, 0, 0) )',
 'viewSet': 'import maya.cmds as cmds\n\n# Create a new camera\ncam = cmds.camera();\ncamShape = cam[1];\n\n# Set cameraShape1 to the persp position\ncmds.viewSet( camShape, p=True )\n\n# Set the camera in the active view to the top position\ncmds.viewSet( t=True )',
 'visor': 'import maya.cmds as cmds\n\n# The visor command is not one which would commonly be used by the user.\n# For examples of its use, refer to visorPanel.mel and addVisorFolders.mel.',
 'volumeAxis': 'import maya.cmds as cmds\n\ncmds.volumeAxis( pos=(0, 0, 0), afc=1.0, afx=2.0, arx=3.0, alx=4.0, drs=6.0 )\n\n# Creates a volume axis field with the following attribute values:\n# awayFromCenter = 1.0, awayFromAxis = 2.0, aroundAxis = 3.0, alongAxis = 4.0,\n# directionalSpeed = 6.0.',
 'volumeBind': 'import maya.cmds as cmds\n\ncmds.volumeBind();',
 'vortex': 'import maya.cmds as cmds\n\ncmds.vortex( ax=0, ay=1.0, az=0.5 )\n# Creates a vortex field with axis (0,1,0.5) for every active\n# selection. If there is no active\n# selection, it creates this field at world position (0,0,0).',
 'waitCursor': 'import maya.cmds as cmds\n\ncmds.waitCursor( state=True )\ncmds.waitCursor( state=False )',
 'walkCtx': "import maya.cmds as cmds\n\ncmds.walkCtx( 'walkContext', ws=2.0 )",
 'warnUserDialog': '',
 'warning': 'import maya.cmds as cmds\n\n\nimport maya.cmds as cmds\ndef lightWarning():\n    l = cmds.ls( lights=True )\n    if len(l) == 0:\n        cmds.warning( "No Lights" )\nlightWarning()\n\n#\n# The above will produce the following output:\n#\n#   # Warning: No Lights #\n#\n# When the option to show line numbers in errors is enabled the output will\n# be the following:\n#\n#   # Warning: line 4 of \'lightWarning\' in \'<maya console\'>: No Lights #\n#',
 'webBrowser': "import maya.cmds as cmds\n\ncmds.window()\ncmds.columnLayout()\nbrowser = cmds.webBrowser(width=800, height=600, url='www.alias.com')\ncmds.showWindow()",
 'webBrowserPrefs': '',
 'weightsColor': "import maya.cmds as cmds\n\n# Turn on weight visualization for the cluster1 deformer on pSphere1\ncmds.weightsColor('pSphere1', fc=True, dfm='cluster1')\n\n# Turn off weight visualization for pSphere1\ncmds.weightsColor('pSphere1', fc=False)\n\n# Turn of the colorRamp\ncmds.weightsColor(useColorRamp=False)\n\n# Use a purple min color and green max color\ncmds.weightsColor(umc=True, rmc=(1.0,0.0,1.0), rxc=(0.0,1.0,0.0))\n\n# Set the outOfRange color for verts outside the deformers subset\ncmds.weightsColor(orc=(0.0,1.0,1.0))",
 'whatsNewHighlight': "import maya.cmds as cmds\n\n#    Turn on What's New highlighting if not already on.\n#\nif not cmds.whatsNewHighlight(query=True, highlightOn=True):\n    cmds.whatsNewHighlight(highlightOn=True)\n\n#    Turn off What's New highlighting startup dialog if it is set to appear.\n#\nif cmds.whatsNewHighlight(query=True, showStartupDialog=True):\n    cmds.whatsNewHighlight(showStartupDialog=False)",
 'window': 'import maya.cmds as cmds\n\n# Make a new window\n#\nwindow = cmds.window( title="Long Name", iconName=\'Short Name\', widthHeight=(200, 55) )\ncmds.columnLayout( adjustableColumn=True )\ncmds.button( label=\'Do Nothing\' )\ncmds.button( label=\'Close\', command=(\'cmds.deleteUI(\\"\' + window + \'\\", window=True)\') )\ncmds.setParent( \'..\' )\ncmds.showWindow( window )\n\n# Resize the main window\n#\n\n# This is a workaround to get MEL global variable value in Python\ngMainWindow = maya.mel.eval(\'$tmpVar=$gMainWindow\')\ncmds.window( gMainWindow, edit=True, widthHeight=(900, 777) )\n\n# Add a menu to the right of the main window\'s menu bar.\n#\nimport maya.cmds as cmds;\n\ncmds.setParent ( "" )\nmenuName = "menuTest"\ncmds.optionMenu( menuName, label=\'test menu\')\ncmds.menuItem( label=\'item 1\', parent = menuName )\ncmds.menuItem( label=\'item 2\', parent = menuName )\ncmds.menuItem( label=\'item 3\', parent = menuName )\n\ncmds.window ("MayaWindow", edit=True, menuBarCornerWidget = (menuName, "topRight") )',
 'windowPref': 'import maya.cmds as cmds\n\n#    Check if the window exists.\n#\nif cmds.window(\'ExampleWindow\', exists=True):\n\tcmds.deleteUI(\'ExampleWindow\', window=True)\n\n#    Create a window.\n#\ncmds.window( \'ExampleWindow\' )\ncmds.columnLayout()\ncmds.text( label=\'Size and position the window before closing it.\' )\ncmds.button( label=\'Close\', command=\'cmds.deleteUI("ExampleWindow", window=True)\' )\ncmds.showWindow( \'ExampleWindow\' )\n\n#    When the window is closed a window preference object is\n#    created for the window. It has the same name as the window\n#    object.\n#\ncmds.windowPref( \'ExampleWindow\', exists=True )\n\n#    Query the window preference size and position.\n#\ncmds.windowPref( \'ExampleWindow\', query=True, topLeftCorner=True )\ncmds.windowPref( \'ExampleWindow\', query=True, widthHeight=True )\n\n#    Create a window with the same name. When it is shown\n#    it will be sized and positioned according to the\n#    window preference.\n#\nif cmds.window(\'ExampleWindow\', exists=True):\n\tcmds.deleteUI(\'ExampleWindow\', window=True)\n\ncmds.window( \'ExampleWindow\' )\ncmds.columnLayout()\ncmds.text( label=\'Size and position the window before closing it.\' )\ncmds.button( label=\'Close\', command=\'cmds.deleteUI("ExampleWindow", window=True)\' )\ncmds.showWindow( \'ExampleWindow\' )\n\n#    Delete the window preference and the window will have a\n#    default size and position.\n#\ncmds.windowPref( \'ExampleWindow\', remove=True )\n\n#    Create the window one last time.\n#\nif cmds.window(\'ExampleWindow\', exists=True):\n\tcmds.deleteUI(\'ExampleWindow\', window=True)\n\ncmds.window( \'ExampleWindow\' )\ncmds.columnLayout()\ncmds.text( label=\'Size and position the window before closing it.\' )\ncmds.button( label=\'Close\', command=\'cmds.deleteUI("ExampleWindow", window=True)\' )\ncmds.showWindow( \'ExampleWindow\' )',
 'wire': "import maya.cmds as cmds\n\n# select a surface and a curve that you want to be a wire, then enter\ncmds.wire()\n\n# create a wire deformer on surface1 using curve1 and curve2\ncmds.wire( 'surface1', 'curve1', 'curve2' )\n\n# modify the dropoff distance and envelope on wire1\ncmds.wire( 'wire1', edit=True, en=0.8, dds=[(0, 6),(1, 3.2)] )",
 'wireContext': "import maya.cmds as cmds\n\ncmds.wireContext( 'wireCtx' )",
 'workspace': 'import maya.cmds as cmds\n\n# Set the current workspace to "alphabet".\ncmds.workspace( \'alphabet\', openWorkspace=True )\n\n# Save the current workspace settings (for "alphabet").\ncmds.workspace( saveWorkspace=True )\n\n# Change current directory to project directory\ncmds.workspace( directory="/h/userName/maya/projects/" )\n\n# Create a directory for a new workspace\ncmds.workspace( create="newWorkspace" )\n\n# Create a new workspace named "newWorkspace".\ncmds.workspace( \'newWorkspace\', newWorkspace=True )\n\n# The file rules and variables of "newWorkspace" are based on "default" workspace\ncmds.workspace( baseWorkspace=\'default\' )\n\n# Return the list of existing workspaces\ncmds.workspace( listWorkspaces=True )\n# Result: default   newWorkspace\n\n# Add a scriptJob to run on workspaceChanged events\ndef workspaceChangedCallback():\nprint \'My workspaceChangedCallback was called\'\n\nworkspaceChangedID = cmds.scriptJob( event = ["workspaceChanged", workspaceChangedCallback] )\n\n# add a file rule to the current workspace\ncmds.workspace(fileRule = [\'newFileRuleName\', \'newFileRuleValue\'])\nMy workspaceChangedCallback was called            #workspaceChangedCallback was called\n\n# look up the value of the file rule entry\ncmds.workspace(fileRuleEntry = \'newFileRuleName\')\n# Result: newFileRuleValue\n\n# remove specified file rule entry\ncmds.workspace(removeFileRuleEntry = \'newFileRuleName\')\nMy workspaceChangedCallback was called            #workspaceChangedCallback is called\n\n# kill the scriptJob with the number\ncmds.scriptJob(kill = workspaceChangedID)\n\n# The following example shows how to expand environment and workspace variables\n\n# expand a path value to be a full path relative to the project directory\n# relative path example\ncmds.workspace( expandName = \'relativePathName\')\n# Result: /h/userName/maya/projects/newWorkspace/relativePathName\n# full path example\ncmds.workspace( expandName = \'/h/userName/maya/projects/default/\')\n# Result: /h/userName/maya/projects/default/\n\n# The following examples show various formats for expanding workspace and\n# environment variables.\n\n# add a variable to the current workspace\ncmds.workspace(variable = [\'newVariableName\', \'newVariableValue\'])\ncmds.workspace( expandName = \'%newVariableName%\')\n# Result: /h/userName/maya/projects/newWorkspace/newVariableValue\n\n# add an environment variable\nos.environ[\'newEnvVariableName\'] = "newEnvVariableValue"\ncmds.workspace( expandName = os.environ[\'newEnvVariableName\'])\n# Result: /h/userName/maya/projects/newWorkspace/newEnvVariableValue\n\n# When a tilde is used, maya will only consider the environment variable\n# not the workspace variable.\ncmds.workspace( expandName = \'~%newVariableName%\')\n# Result: /h/userName/maya/projects/newWorkspace/~newEnvVariableValue\n\n# The following example shows how to set multiple paths into a fileRule value\ncmds.workspace(fileRule = [\'newMultiPathFileRuleName\', \'/h/userName/maya/projects/default;newFileRuleValue\'])\nmultipath = cmds.workspace(fileRuleEntry = \'newMultiPathFileRuleName\')\n# Result : /h/userName/maya/projects/default;newFileRuleValue\n\n# Note that white space at the beginning or end of each path is significant.\n# Add a file rule that uses multiple paths with the white space at the beginning and end of each path\ncmds.workspace(fileRule = [\'newMultiPathFileRuleName\', \' /h/userName/maya/projects/default ; newFileRuleValue \'])\n# Querying and expanding the path value shows that the white space is still included.\nmultipath = cmds.workspace(fileRuleEntry = \'newMultiPathFileRuleName\')\n# Result :  /h/userName/maya/projects/default ; newFileRuleValue\n\n# Find the current workspace area.\ncmds.workspace( q=True, directory=True )\n# Result : /h/userName/maya/projects/\n\n# Note that the "current working directory" as defined by the\n# \'pwd\' and \'chdir\' commands is unrelated to the directories\n# used by the workspace command\n#\nos.getcwd()\n# Result : /usr/tmp\n\nos.chdir( \'/tmp\' )\nos.getcwd()\n# Result : /tmp\ncmds.workspace( q=True, directory=True )\n# Result : /h/userName/maya/projects/\n\ncmds.workspace( directory=\'/h/userName/maya/projects/commercial\' )\nos.getcwd()\n# Result : /tmp',
 'workspaceControl': 'import maya.cmds as cmds\n\ndef createCustomWorkspaceControlUI(*args):\n  cmds.columnLayout()\n  cmds.button()\n  cmds.button()\n  cmds.button()\n\ncmds.workspaceControl("myCustomWorkspaceControl", retain=False, floating=True, uiScript="createCustomWorkspaceControlUI()");',
 'workspaceControlState': 'import maya.cmds as cmds\n\n#    Check if the window exists.\n#\nif cmds.window(\'ExampleWindow\', exists=True):\n\tcmds.deleteUI(\'ExampleWindow\', window=True)\n\n#    Create a window.\n#\ncmds.window( \'ExampleWindow\' )\ncmds.columnLayout()\ncmds.text( label=\'Size and position the window before closing it.\' )\ncmds.button( label=\'Close\', command=\'cmds.deleteUI("ExampleWindow", window=True)\' )\ncmds.showWindow( \'ExampleWindow\' )\n\n#    When the window is closed a window preference object is\n#    created for the window. It has the same name as the window\n#    object.\n#\ncmds.workspaceControlState( \'ExampleWindow\', exists=True )\n\n#    Query the window preference size and position.\n#\ncmds.workspaceControlState( \'ExampleWindow\', query=True, topLeftCorner=True )\ncmds.workspaceControlState( \'ExampleWindow\', query=True, widthHeight=True )\n\n#    Create a window with the same name. When it is shown\n#    it will be sized and positioned according to the\n#    window preference.\n#\nif cmds.window(\'ExampleWindow\', exists=True):\n\tcmds.deleteUI(\'ExampleWindow\', window=True)\n\ncmds.window( \'ExampleWindow\' )\ncmds.columnLayout()\ncmds.text( label=\'Size and position the window before closing it.\' )\ncmds.button( label=\'Close\', command=\'cmds.deleteUI("ExampleWindow", window=True)\' )\ncmds.showWindow( \'ExampleWindow\' )\n\n#    Delete the window preference and the window will have a\n#    default size and position.\n#\ncmds.workspaceControlState( \'ExampleWindow\', remove=True )\n\n#    Create the window one last time.\n#\nif cmds.window(\'ExampleWindow\', exists=True):\n\tcmds.deleteUI(\'ExampleWindow\', window=True)\n\ncmds.window( \'ExampleWindow\' )\ncmds.columnLayout()\ncmds.text( label=\'Size and position the window before closing it.\' )\ncmds.button( label=\'Close\', command=\'cmds.deleteUI("ExampleWindow", window=True)\' )\ncmds.showWindow( \'ExampleWindow\' )',
 'workspaceLayoutManager': 'import maya.cmds as cmds\n\ncmds.workspaceLayoutManager( listLayouts=True )',
 'workspacePanel': 'import maya.cmds as cmds\n\ncmds.workspacePanel(mainWindow=True)',
 'wrinkle': "import maya.cmds as cmds\n\n# Apply radial wrinkles to a sphere:\n\nmySph = cmds.sphere()\ncmds.wrinkle( mySph, st='radial', wc=3, brc=2, bd=0, th=1, rnd=0.2, wi=0.5, uv=(2.0, 4.0, 0.0, 2.0, 4.0) )\n\n# Apply a 5-line tangential wrinkle to a plane:\n\nmyPlane = cmds.nurbsPlane( w=50, u=20, v=20 )\ncmds.wrinkle( myPlane, st='lines', wc=5, th=1.0, rnd=0.2, wi=0.5, uv=(1.0, 1.0, 0.0, 0.5, 0.5) )",
 'wrinkleContext': "import maya.cmds as cmds\n\ncmds.wrinkleContext( 'wrinkleCtx' )",
 'writeTake': 'import maya.cmds as cmds\n\n#    Record data from the clock device and write out the virtual\n#    device definition and take file.\ncmds.recordDevice( device=\'clock\' )\ncmds.recordDevice( device=\'clock\', stop=True )\ncmds.writeTake( device=\'clock\', take=\'clock.mov\', virtualDevice=\'virtualClock.mel\' )\n\n#    Read the virtualClock and virtualClock take data.\nmaya.mel.eval("virtualClock")\ncmds.readTake( device=\'virtualClock\', take=\'clock.mov\' )',
 'xform': "import maya.cmds as cmds\n\n# create object to manipulate\ncmds.sphere( n='sphere1' )\n\n# set rotation of sphere\ncmds.xform( r=True, ro=(0, 90, 0) )\n\n# change the rotate order but preserve the overall transformation\ncmds.xform( p=True, roo='yzx' )",
 'xformConstraint': 'import maya.cmds as cmds\n\n# Return the current transform constraint\ncmds.xformConstraint(query=True, type=True)\n\n# Constrain moving components to the surface\ncmds.symmetricModelling(type="surface")',
 'xpmPicker': 'import maya.cmds as cmds\n\ncmds.xpmPicker()'}