from pymel.util.objectParser import *
from _typeshed import Incomplete

class NameBaseParser(Parser):
    t_Alpha: str
    t_Num: str
    start: Incomplete

class NameAlphaPartParser(NameBaseParser):
    start: str
    def p_apart(self, p) -> None: ...

class NameNumPartParser(NameBaseParser):
    start: str
    def p_npart(self, p) -> None: ...

class NamePartParser(NameAlphaPartParser, NameNumPartParser):
    start: str
    def p_part(self, p) -> None: ...

class NameAlphaGroupParser(NameAlphaPartParser, NameNumPartParser):
    start: str
    def p_agroup_concat(self, p) -> None: ...
    def p_agroup(self, p) -> None: ...

class NameNumGroupParser(NameAlphaPartParser, NameNumPartParser):
    start: str
    def p_ngroup_concat(self, p) -> None: ...
    def p_ngroup(self, p) -> None: ...

class NameGroupParser(NameAlphaGroupParser, NameNumGroupParser):
    start: str
    def p_group(self, p) -> None: ...

class NameSepParser(Parser):
    t_Underscore: str
    start: str
    def p_sep_concat(self, p) -> None: ...
    def p_sep(self, p) -> None: ...
    precedence: Incomplete

class MayaNameParser(NameSepParser, NameGroupParser):
    start: str
    def p_name_error(self, p) -> None: ...
    def p_name_concat(self, p) -> None: ...
    def p_name(self, p) -> None: ...

class NamespaceSepParser(Parser):
    t_Colon: str
    start: str
    def p_nspace_sep(self, p) -> None: ...
    precedence: Incomplete

class NamespaceParser(NamespaceSepParser, MayaNameParser, EmptyParser):
    start: str
    def p_nspace_concat(self, p) -> None: ...
    def p_nspace(self, p) -> None: ...

class MayaShortNameParser(NamespaceParser, MayaNameParser):
    start: str
    def p_sname(self, p) -> None: ...

class DagPathSepParser(Parser):
    t_Pipe: str
    start: str
    def p_dpath_sep(self, p) -> None: ...
    precedence: Incomplete

class MayaNodePathParser(DagPathSepParser, MayaShortNameParser):
    start: str
    def p_node_concat(self, p) -> None: ...
    def p_node(self, p) -> None: ...

class AttrSepParser(Parser):
    t_Dot: str
    start: str
    def p_attr_sep(self, p) -> None: ...
    precedence: Incomplete

class NameIndexParser(Parser):
    t_Index: str
    start: str
    def p_index(self, p) -> None: ...
    precedence: Incomplete

class NameRangeIndexParser(Parser):
    t_RangeIndex: str
    start: str
    def p_rindex(self, p) -> None: ...
    precedence: Incomplete

class SingleComponentNameParser(NameRangeIndexParser, NameIndexParser, MayaNameParser): ...
class DoubleComponentNameParser(NameRangeIndexParser, NameIndexParser, MayaNameParser): ...
class TripleComponentNameParser(NameRangeIndexParser, NameIndexParser, MayaNameParser): ...
class ComponentNameParser(SingleComponentNameParser, DoubleComponentNameParser, TripleComponentNameParser): ...

class NodeAttributeNameParser(NameIndexParser, MayaNameParser):
    start: str
    def p_nodeattr_error(self, p) -> None: ...
    def p_nodeattr(self, p) -> None: ...

class NodeAttributePathParser(AttrSepParser, NodeAttributeNameParser):
    start: str
    def p_nodeattrpath_concat(self, p) -> None: ...
    def p_nodeattrpath(self, p) -> None: ...

class AttributeNameParser(NodeAttributePathParser, MayaNodePathParser):
    start: str
    def p_attribute(self, p) -> None: ...

class MayaObjectNameParser(AttributeNameParser):
    start: str
    def p_mobject(self, p) -> None: ...

class NameParsed(Parsed):
    def isNodeName(self): ...
    def isAttributeName(self): ...
    def isComponentName(self): ...

class NamePart(NameParsed):
    def isAlpha(self): ...
    def isNum(self): ...

class NameAlphaPart(NamePart):
    def isAlpha(self): ...
    def isNum(self): ...

class NameNumPart(NamePart):
    def __new__(cls, *args, **kwargs): ...
    @property
    def value(self): ...
    def isAlpha(self): ...
    def isNum(self): ...

class NameGroup(NameParsed):
    def isNum(self): ...
    def isAlpha(self): ...
    @property
    def parts(self): ...
    @property
    def first(self): ...
    @property
    def last(self): ...
    @property
    def tail(self): ...
    def nextName(self) -> None: ...
    def prevName(self) -> None: ...

class NameAlphaGroup(NameGroup):
    def isNum(self): ...
    def isAlpha(self): ...

class NameNumGroup(NameGroup):
    def isNum(self): ...
    def isAlpha(self): ...

class NameSep(NameParsed):
    @classmethod
    def default(cls): ...
    def reduced(self): ...

class MayaName(NameParsed):
    @property
    def parts(self): ...
    @property
    def groups(self): ...
    @property
    def first(self): ...
    @property
    def last(self): ...
    @property
    def tail(self): ...
    def reduced(self): ...
    def extractNum(self): ...
    def nextUniqueName(self): ...
    def nextName(self) -> None: ...
    def prevName(self) -> None: ...

class NamespaceSep(NameParsed):
    @classmethod
    def default(cls): ...

class Namespace(NameParsed):
    @classmethod
    def default(cls): ...
    @property
    def parts(self): ...
    @property
    def spaces(self): ...
    def setSpace(self, index, space) -> None: ...
    def pop(self, index: int = ...): ...
    def append(self, namespace) -> None: ...
    @property
    def separator(self): ...
    @property
    def path(self): ...
    @property
    def space(self): ...
    @property
    def parents(self): ...
    @property
    def parent(self): ...
    @property
    def first(self): ...
    @property
    def last(self): ...
    def isAbsolute(self): ...

class MayaShortName(NameParsed):
    @property
    def parts(self): ...
    def getBaseName(self): ...
    def setBaseName(self, name): ...
    basename: Incomplete
    def addPrefix(self, prefix) -> None: ...
    def addSuffix(self, suffix) -> None: ...
    def getBaseNamespace(self): ...
    def setNamespace(self, namespace) -> None: ...
    namespace: Incomplete
    def isAbsoluteNamespace(self): ...
    @property
    def first(self): ...
    @property
    def last(self): ...

class DagPathSep(NameParsed):
    @classmethod
    def default(cls): ...

class MayaNodePath(NameParsed):
    @property
    def parts(self) -> Sequence[Parsed]: ...
    @property
    def nodes(self): ...
    def shortName(self): ...
    node: Incomplete
    @property
    def separator(self): ...
    @property
    def nodePaths(self): ...
    @property
    def parents(self): ...
    @property
    def parent(self): ...
    @property
    def first(self): ...
    @property
    def root(self): ...
    @property
    def last(self): ...
    def addPrefix(self, prefix) -> None: ...
    def addSuffix(self, suffix) -> None: ...
    def setNamespace(self, namespace) -> None: ...
    def addNamespace(self, namespace) -> None: ...
    def popNamespace(self, index: int = ...): ...
    def popNode(self, index: int = ...): ...
    def addNode(self, node) -> None: ...
    def isShortName(self): ...
    def isDagName(self): ...
    def isLongName(self): ...
    isAbsolute = isLongName

class AttrSep(NameParsed):
    @classmethod
    def default(cls): ...

class NameIndex(NameParsed):
    def __new__(cls, *args, **kwargs): ...
    @property
    def value(self): ...

class NameRangeIndex(NameParsed):
    @classmethod
    def default(cls): ...
    def __new__(cls, *args, **kwargs): ...
    @property
    def start(self): ...
    @property
    def end(self): ...
    @property
    def bounds(self): ...
    @property
    def range(self): ...

class Component(NameParsed): ...

class Attribute(NameParsed):
    @property
    def parts(self): ...
    @property
    def name(self): ...
    @property
    def bracketedIndex(self): ...
    @property
    def index(self): ...
    def isCompound(self): ...

class AttributePath(NameParsed):
    @property
    def parts(self): ...
    @property
    def attributes(self): ...
    @property
    def separator(self): ...
    @property
    def path(self): ...
    @property
    def parents(self): ...
    @property
    def parent(self): ...
    @property
    def first(self): ...
    @property
    def last(self): ...
    def isCompound(self): ...

class NodeAttribute(NameParsed):
    @property
    def parts(self): ...
    @property
    def separator(self): ...
    @property
    def nodePath(self): ...
    @property
    def attribute(self): ...
    def shortName(self): ...
    @property
    def attributes(self): ...
    def popNode(self) -> None: ...

class MayaObjectName(NameParsed):
    @property
    def object(self): ...
    @property
    def type(self): ...
    @property
    def parts(self): ...
    @property
    def nodes(self): ...
    @property
    def node(self): ...
    @property
    def attributes(self): ...
    @property
    def attribute(self): ...
    @property
    def component(self): ...
    def isNodeName(self): ...
    def isAttributeName(self): ...
    def isComponentName(self): ...

class Empty(NameParsed):
    @classmethod
    def default(cls): ...

def getBasicPartList(name): ...
def parse(name): ...
