from typing import *
import abc
from . import plogging as plogging
from _typeshed import Incomplete
from abc import abstractmethod
from collections.abc import Generator
from html.parser import HTMLParser
from pymel.mayautils import getMayaLocation as getMayaLocation

TYPE_CHECKING: bool
FLAGMODES: Incomplete

class MethodParseError(ValueError): ...
class UnmatchedNameError(ValueError): ...

def mayaIsRunning() -> bool: ...
def mayaDocsLocation(version: Optional[str] = ...) -> str: ...
def decodeEntity(tagname): ...
def iterXmlTextAndElem(element) -> Generator[Incomplete, None, None]: ...
def getFirstText(element, ignore=...): ...
def xmlText(element, strip: bool = ..., allowNone: bool = ...): ...
def standardizeWhitespace(text): ...

class MLStripper(HTMLParser):
    fed: Incomplete
    def __init__(self) -> None: ...
    def handle_data(self, d) -> None: ...
    def handle_startendtag(self, tag, attrs) -> None: ...
    def get_data(self): ...

def strip_tags(html): ...
def standardizeUnicodeChars(input): ...
def standardizeDoc(input): ...

class CommandDocParser(HTMLParser):
    command: Incomplete
    flags: Incomplete
    currFlag: str
    iData: int
    pcount: int
    active: bool
    description: str
    example: str
    emptyModeFlags: Incomplete
    internal: bool
    def __init__(self, command) -> None: ...
    def startFlag(self, data) -> None: ...
    def addFlagData(self, data) -> None: ...
    def endFlag(self) -> None: ...
    def handle_starttag(self, tag, attrs) -> None: ...
    def handle_endtag(self, tag) -> None: ...
    def handle_data(self, data) -> None: ...

class NodeHierarchyDocParser(HTMLParser):
    def parse(self): ...
    version: Incomplete
    currentTag: Incomplete
    depth: int
    lastDepth: int
    tree: Incomplete
    currentLeaves: Incomplete
    def __init__(self, version: Incomplete | None = ...) -> None: ...
    def handle_starttag(self, tag, attrs) -> None: ...
    def handle_data(self, data) -> None: ...

def printTree(tree, depth: int = ...) -> None: ...

class CommandModuleDocParser(HTMLParser):
    def parse(self): ...
    cmdList: Incomplete
    category: Incomplete
    version: Incomplete
    docloc: Incomplete
    def __init__(self, category, version: Incomplete | None = ...) -> None: ...
    def handle_starttag(self, tag, attrs) -> None: ...

class NO_DEFAULT: ...

class ParamInfo:
    defName: Incomplete
    declName: Incomplete
    type: Incomplete
    typeQualifiers: Incomplete
    default: Incomplete
    direction: Incomplete
    def __init__(self, defName: Incomplete | None = ..., declName: Incomplete | None = ..., type: Incomplete | None = ..., typeQualifiers=..., default=..., direction: str = ..., doc: str = ...) -> None: ...
    @property
    def name(self): ...
    @name.setter
    def name(self, val) -> None: ...
    @property
    def doc(self): ...
    @doc.setter
    def doc(self, rawVal) -> None: ...
    def qualifiedTypeName(self): ...

class ApiDocParser(metaclass=abc.ABCMeta):
    NO_PYTHON_MSG: Incomplete
    DEPRECATED_MSG: Incomplete
    PYMEL_ENUM_DEFAULTS: Incomplete
    MISSING_TYPES: Incomplete
    OTHER_TYPES: Incomplete
    NOT_TYPES: Incomplete
    BASIC_NUMERIC_TYPES: Incomplete
    NON_MFN_FULL_PARSE_CLASSES: Incomplete
    SKIP_PARSING_METHODS: Incomplete
    CPP_OPERATOR_TO_PY: Incomplete
    PY_OPERATOR_DEFAULT_NAMES: Incomplete
    DEFNAMES: Incomplete
    def __new__(cls, apiModule, version: Incomplete | None = ..., *args, **kwargs): ...
    version: Incomplete
    apiModule: Incomplete
    verbose: Incomplete
    docloc: Incomplete
    enumClass: Incomplete
    strict: Incomplete
    enums: Incomplete
    pymelEnums: Incomplete
    methods: Incomplete
    currentMethodName: Incomplete
    badEnums: Incomplete
    def __init__(self, apiModule, version: Incomplete | None = ..., verbose: bool = ..., enumClass=..., docLocation: Incomplete | None = ..., strict: bool = ...) -> None: ...
    @classmethod
    def shouldSkip(cls, apiClsName): ...
    @classmethod
    def shouldParseEnumOnly(cls, apiClsName): ...
    @classmethod
    def splitArrayType(cls, origType: Union[str, ApiEnum]) -> Tuple[str, Optional[int]]: ...
    @classmethod
    def isGettableArg(cls, param: ParamInfo) -> bool: ...
    @property
    def currentRawMethod(self): ...
    @currentRawMethod.setter
    def currentRawMethod(self, val) -> None: ...
    @staticmethod
    def methodcached(getter): ...
    def fullMethodName(self, paramInfos: Incomplete | None = ...): ...
    def formatMsg(self, *args): ...
    def xprint(self, *args) -> None: ...
    def getPymelMethodNames(self): ...
    def getClassFilename(self): ...
    def isBadEnum(self, type): ...
    def handleEnums(self, type): ...
    def handleEnumDefaults(self, default, type): ...
    def getOperatorName(self, methodName): ...
    def isSetMethod(self): ...
    def isGetMethod(self): ...
    def parseValue(self, rawValue, valueType): ...
    def parseType(self, tokens): ...
    def parseEnum(self, enumData) -> None: ...
    def parseMethod(self, rawMethod): ...
    constants: Incomplete
    apiClassName: Incomplete
    apiClass: Incomplete
    docfile: Incomplete
    def setClass(self, apiClassName) -> None: ...
    def parse(self, apiClassName): ...
    @abstractmethod
    def parseArgTypes(self): ...
    @abstractmethod
    def hasNoPython(self): ...
    @abstractmethod
    def isStaticMethod(self): ...
    @abstractmethod
    def isDeprecated(self): ...
    @abstractmethod
    def getMethodDoc(self): ...
    @abstractmethod
    def parseMethodArgs(self, paramInfos, returnInfo): ...
    @abstractmethod
    def getMethodNameAndOutput(self): ...
    @abstractmethod
    def getClassPath(self): ...
    @abstractmethod
    def parseBody(self): ...

class XmlApiDocParser(ApiDocParser):
    def fullMethodName(self, paramInfos: Incomplete | None = ...): ...
    tree: Incomplete
    root: Incomplete
    cdef: Incomplete
    numAnonymousEnums: int
    def setClass(self, apiClassName) -> None: ...
    def parseArgTypes(self): ...
    def isMayaEnumFunc(self, element): ...
    currentMethodName: Incomplete
    def hasNoPython(self): ...
    def isDeprecated(self): ...
    def isStaticMethod(self): ...
    @classmethod
    def iterBackslashTags(cls, text, subTags=...) -> Generator[Incomplete, None, None]: ...
    @classmethod
    def parseBackslashTags(cls, text, allTags: bool = ...): ...
    def findDetailedDescription(self): ...
    def getMethodDoc(self): ...
    def parseMethodArgs(self, oldParamInfos, returnInfo): ...
    def getMethodNameAndOutput(self): ...
    baseFilename: Incomplete
    def getClassPath(self): ...
    def parseBody(self) -> None: ...

class HtmlApiDocParser(ApiDocParser):
    def parseArgTypes(self): ...
    currentMethodName: Incomplete
    def hasNoPython(self): ...
    def isStaticMethod(self): ...
    def findAddendum(self): ...
    def isDeprecated(self): ...
    def getMethodDoc(self): ...
    def parseMethodArgs(self, returnType, names, types, typeQualifiers): ...
    TYPEDEF_RE: Incomplete
    def getMethodNameAndOutput(self): ...
    DOXYGEN_VER_RE: Incomplete
    def getDoxygenVersion(self, soup): ...
    def getClassPath(self): ...
    soup: Incomplete
    doxygenVersion: Incomplete
    def setClass(self, apiClassName) -> None: ...
    def parseBody(self) -> None: ...
