from typing import *
import pymel.core.uitypes
import types
import pymel.util as util
from . import apicache as apicache, cmdcache as cmdcache, docstrings as docstrings, plogging as plogging, pmcmds as pmcmds
from _typeshed import Incomplete
from pymel.internal.pwarnings import deprecated as deprecated, maya_deprecated as maya_deprecated
from pymel.util.conditions import Always as Always, Condition as Condition
from typing import Any, NamedTuple, TypeVar

T = TypeVar('T')
U = TypeVar('U')
CallableT = TypeVar('CallableT', bound=Callable)
Decorator = Callable[[CallableT], CallableT]
Annotations: Incomplete
apiTypesToApiEnums: Dict[str, int]
apiEnumsToApiTypes: Dict[int, str]
mayaTypesToApiTypes: Dict[str, str]
apiTypesToApiClasses: Dict[str, Type]
apiClassInfo: Incomplete
mayaTypesToApiEnums: Dict[str, int]
apiToMelData: Incomplete
apiClassOverrides: Incomplete
cmdlist: Dict[str, cmdcache.CommandInfo]
nodeHierarchy: Incomplete
uiClassList: List[str]
nodeCommandList: List[str]
moduleCmds: Dict[str, List[str]]
building: bool

class MissingInCacheError(Exception): ...

class MelCommandMissingError(MissingInCacheError):
    cmdName: Incomplete
    def __init__(self, cmdName) -> None: ...
    def str(self): ...

class ApiMethodMissingError(MissingInCacheError):
    apiClassName: Incomplete
    methodName: Incomplete
    def __init__(self, apiClassName, methodName) -> None: ...
    def str(self): ...

def loadApiCache() -> None: ...
def loadCmdCache() -> None: ...
def saveApiCache() -> None: ...
def saveApiMelBridgeCache() -> None: ...
def mergeApiClassOverrides() -> None: ...

EXCLUDE_METHODS: Incomplete
docstringMode: Incomplete
pyNodeNamesToPyNodes: Dict[str, Type[pymel.core.general.PyNode]]
apiClassNamesToPyNodeNames: Dict[str, str]
apiClassNamesToPymelTypes: Dict[str, Type]
mayaTypeNameToPymelTypeName: Dict[str, str]
pymelTypeNameToMayaTypeName: Dict[str, str]
apiEnumsToPyComponents: Incomplete
pyNodeTypesHierarchy: Dict[Type[pymel.core.general.PyNode], Type[pymel.core.general.PyNode]]
nodeTypeToInfoCommand: Incomplete

def toPyNode(res: Optional[str]) -> Optional[pymel.core.general.PyNode]: ...
def unwrapToPyNode(res: List[str]) -> Optional[pymel.core.general.PyNode]: ...
def toPyUI(res: Optional[str]) -> Optional[pymel.core.uitypes.PyUI]: ...
def toPyType(moduleName: str, objectName: str) -> Callable[[Any], Any]: ...
def toPyNodeList(res: Optional[List[str]]) -> List[pymel.core.general.PyNode]: ...
def splitToPyNodeList(res: str) -> List[pymel.core.general.PyNode]: ...
def toPyUIList(res: str) -> List[pymel.core.uitypes.PyUI]: ...
def toPyTypeList(moduleName: str, objectName: str) -> Callable[[Any], List[Any]]: ...
def raiseError(typ, *args): ...

class Flag(Condition):
    shortName: Incomplete
    longName: Incomplete
    truthValue: Incomplete
    def __init__(self, longName, shortName, truthValue: bool = ...) -> None: ...
    def eval(self, kwargs): ...

simpleCommandWraps: Incomplete
examples: Incomplete

def getUncachedCmds(): ...

docCacheLoaded: bool

def loadCmdDocCache(ignoreError: bool = ...) -> None: ...
def getCmdFunc(cmdName: str) -> Decorator: ...
def addCmdDocs(func: CallableT, cmdName: Optional[str] = ..., excludeFlags: Optional[Iterable[str]] = ...) -> CallableT: ...
def addCmdDocsCallback(cmdName, docstring: str = ..., excludeFlags: Incomplete | None = ...): ...
docBuilderCls = docstrings.RstDocstringBuilder
docBuilderCls = docstrings.NumpyDocstringBuilder
docBuilderCls = docstrings.PyDocstringBuilder

def addFlagCmdDocsCallback(cmdName, flag, docstring): ...

class Callback:
    MAX_RECENT_ERRORS: int
    recentErrors: Incomplete

    class CallbackErrorLog(NamedTuple):
        callback: Incomplete
        exception: Incomplete
        trace: Incomplete
        creationTrace: Incomplete
    @classmethod
    def logCallbackError(cls, callback, exception: Incomplete | None = ..., trace: Incomplete | None = ..., creationTrace: Incomplete | None = ...) -> None: ...
    @classmethod
    def formatRecentError(cls, index: int = ...): ...
    @classmethod
    def printRecentError(cls, index: int = ...) -> None: ...
    func: Incomplete
    args: Incomplete
    kwargs: Incomplete
    traceback: Incomplete
    def __init__(self, func, *args, **kwargs) -> None: ...
    def __call__(self, *args): ...

class CallbackWithArgs(Callback):
    def __call__(self, *args, **kwargs): ...

def makeUICallback(origCallback: Callable, args: Tuple[Any, ...], doPassSelf: bool) -> Callable: ...
def fixCallbacks(inFunc, commandFlags, funcName: Incomplete | None = ...): ...
def convertTimeValues(rawVal): ...
def maybeConvert(val: U, castFunc: Callable[..., T]) -> Union[T, U]: ...
def functionFactory(funcNameOrObject, returnFunc: Incomplete | None = ..., module: Incomplete | None = ..., rename: Incomplete | None = ..., uiWidget: bool = ...): ...
def makeCreateFlagMethod(inFunc: CallableT, flag: str, newMethodName: Optional[str] = ..., docstring: str = ..., cmdName: Optional[str] = ..., returnFunc: Optional[Callable] = ...) -> CallableT: ...
def createflag(cmdName: str, flag: str) -> Decorator: ...
def makeQueryFlagMethod(inFunc: CallableT, flag: str, newMethodName: Optional[str] = ..., docstring: str = ..., cmdName: Optional[str] = ..., returnFunc: Optional[Callable] = ...) -> CallableT: ...
def queryflag(cmdName: str, flag: str) -> Decorator: ...
def handleCallbacks(args: Tuple[Any, ...], kwargs: Dict[str, Any], callbackFlags: Iterable[Any]) -> None: ...
def asEdit(self, func: Callable[..., T], kwargs: Dict[str, Any], flag: str, val: Any) -> T: ...
def asQuery(self, func: Callable[..., T], kwargs: Dict[str, Any], flag: str) -> T: ...
def makeEditFlagMethod(inFunc: CallableT, flag: str, newMethodName: Optional[str] = ..., docstring: str = ..., cmdName: Optional[str] = ...) -> CallableT: ...
def editflag(cmdName: str, flag: str) -> Decorator: ...
def addMelDocs(cmdName: str, flag: Optional[str] = ..., excludeFlags: Optional[Iterable[str]] = ...) -> Decorator: ...
def listForNoneQuery(res, kwargs, flags): ...

class ApiTypeRegister:
    types: Dict[str, str]
    inCast: Dict[str, Callable[[Any], Any]]
    outCast: Dict[str, Callable[[Any, Any], Any]]
    refInit: Incomplete
    refCast: Incomplete
    arrayItemTypes: Incomplete
    doc: Incomplete
    @classmethod
    def getPymelType(cls, apiType: Any, allowGuess: Any = ...) -> Optional[str]: ...
    @classmethod
    def isRegistered(cls, apiTypeName): ...
    @classmethod
    def register(cls, apiTypeName: str, pymelType: Type, inCast: Optional[Callable[[Any], Any]] = ..., outCast: Optional[Callable[[Any], Any]] = ..., apiArrayItemType: Optional[Type] = ...) -> None: ...

class ApiArgUtil:
    apiClassName: Incomplete
    methodName: Incomplete
    basePymelName: Incomplete
    methodInfo: Incomplete
    methodIndex: Incomplete
    def __init__(self, apiClassName: str, methodName: str, methodIndex: int = ...) -> None: ...
    def iterArgs(self, inputs: bool = ..., outputs: bool = ..., infoKeys=...): ...
    def inArgs(self) -> List[str]: ...
    def outArgs(self) -> List[str]: ...
    def argList(self) -> List[str]: ...
    def argInfo(self): ...
    def getGetterInfo(self) -> Optional[ApiArgUtil]: ...
    @staticmethod
    def isValidEnum(enumTuple): ...
    def hasOutput(self): ...
    def canBeWrapped(self): ...
    def getInputTypes(self) -> List[str]: ...
    def getOutputTypes(self) -> List[str]: ...
    def getReturnType(self): ...
    def getPymelName(self): ...
    def getMethodDocs(self): ...
    def getPrototype(self, className: bool = ..., methodName: bool = ..., outputs: bool = ..., defaults: bool = ...): ...
    def getAnnotations(self) -> Annotations: ...
    def castInput(self, argName: str, input: Any) -> Any: ...
    @classmethod
    def castInputEnum(cls, apiClassName, enumName, input): ...
    @staticmethod
    def fromInternalUnits(result, returnType, unit: Incomplete | None = ...): ...
    @staticmethod
    def toInternalUnits(input, unit): ...
    def castResult(self, pynodeInstance, result): ...
    @staticmethod
    def initReference(argtype): ...
    @classmethod
    def castReferenceResult(cls, argtype, outArg): ...
    def getDefaults(self): ...
    def isStatic(self): ...
    def isDeprecated(self): ...

class ApiUndo:
    node_name: str
    cb_enabled: bool
    undo_queue: Incomplete
    redo_queue: Incomplete
    undoStateCallbackId: Incomplete
    def __init__(self) -> None: ...
    def installUndoStateCallbacks(self) -> None: ...
    def flushCallback(self, undoOrRedoAvailable, *args) -> None: ...
    def append(self, cmdObj, undoName: Incomplete | None = ...) -> None: ...
    def execute(self, cmdObj, *args): ...
    def flushUndo(self, *args) -> None: ...

apiUndo: Incomplete

class ApiUndoItem:
    def __init__(self, setter, redoArgs, undoArgs, redoKwargs: Incomplete | None = ..., undoKwargs: Incomplete | None = ...) -> None: ...
    def redoIt(self) -> None: ...
    doIt = redoIt
    def undoIt(self) -> None: ...

class ApiRedoUndoItem(ApiUndoItem):
    def __init__(self, redoer, redoArgs, undoer, undoArgs, redoKwargs: Incomplete | None = ..., undoKwargs: Incomplete | None = ...) -> None: ...
    def undoIt(self) -> None: ...

class MAnimCurveChangeUndoItem(ApiRedoUndoItem):
    def __init__(self, curveChangeObj) -> None: ...

def getUndoArgs(args: List[Any], argList: List[Tuple[str, Union[str, Tuple[str, str]], str, Optional[str]]], getter: Callable, getterInArgs: List[str]) -> List[Any]: ...
def getDoArgs(args: List[Any], argList: List[Tuple[str, Union[str, Tuple[str, str]], str, Optional[str]]]) -> Tuple[List[Any], List[Any], List[Tuple[str, int]]]: ...
def getDoArgsGetterUndo(args: List[Any], argList: List[Tuple[str, Union[str, Tuple[str, str]], str, Optional[str]]], getter: Callable, setter: Callable, getterInArgs: List[str]) -> Tuple[List[Any], List[Any], List[Tuple[str, int]], ApiUndoItem]: ...
def getDoArgsAnimCurveUndo(args: List[Any], argList: List[Tuple[str, Union[str, Tuple[str, str]], str, Optional[str]]]) -> Tuple[List[Any], List[Any], List[Tuple[str, int]], ApiUndoItem]: ...
def processApiResult(result: Any, outTypeList: List[Tuple[str, int]], do_args: List[Any]) -> Any: ...
def getProxyResult(self, apiClass, method, final_do=...): ...
def wrapApiMethod(apiClass: Type, methodName: str, newName: str = ..., proxy: bool = ..., overloadIndex: Optional[int] = ...) -> None: ...
def addApiDocs(apiClass: Type, methodName: str, overloadIndex: Optional[int] = ..., undoable: bool = ...) -> Decorator: ...
def addApiDocsCallback(apiClass: Type, methodName: str, overloadIndex: Optional[int] = ..., undoable: bool = ..., origDocstring: str = ...) -> str: ...

class ClassConstant:
    value: Incomplete
    def __init__(self, value) -> None: ...
    def __get__(self, instance, owner): ...
    def __set__(self, instance, value) -> None: ...
    def __delete__(self, instance) -> None: ...

class MetaMayaTypeRegistry(util.metaReadOnlyAttr):
    def __new__(cls, classname, bases, classdict): ...

class MetaMayaTypeWrapper(MetaMayaTypeRegistry):
    class ClassConstant:
        value: Incomplete
        def __init__(self, value) -> None: ...
        def __get__(self, instance, owner): ...
        def __set__(self, instance, value) -> None: ...
        def __delete__(self, instance) -> None: ...
    def __new__(cls, classname: str, bases: Tuple[Type, ...], classdict: Mapping[str, Any]) -> MetaMayaTypeWrapper: ...
    @staticmethod
    def setattr_fixed_forDataDescriptorBug(self, name, value): ...

class _MetaMayaCommandWrapper(MetaMayaTypeWrapper):
    def __new__(cls, classname: str, bases: Tuple[Type, ...], classdict: Mapping[str, Any]) -> _MetaMayaCommandWrapper: ...
    @classmethod
    def getMelCmd(cls, classdict: Mapping[str, Any]) -> Tuple[str, bool]: ...
    @classmethod
    def docstring(cls, melCmdName: str) -> str: ...

class MetaMayaNodeWrapper(_MetaMayaCommandWrapper):
    def __new__(cls, classname: str, bases: Tuple[Type, ...], classdict: Mapping[str, Any]) -> MetaMayaNodeWrapper: ...
    @classmethod
    def getMelCmd(cls, classdict: Mapping[str, Any]) -> Tuple[str, bool]: ...

class MetaMayaUIWrapper(_MetaMayaCommandWrapper):
    def __new__(cls, classname, bases, classdict): ...
    @classmethod
    def getMelCmd(cls, classdict: Mapping[str, Any]) -> Tuple[str, bool]: ...

def addCustomPyNode(module: types.ModuleType, mayaType: str, extraAttrs: Optional[Mapping[str, Any]] = ...) -> Optional[str]: ...
def getPymelTypeName(mayaTypeName: str, create: bool = ...) -> str: ...
def removePyNode(module: types.ModuleType, mayaType: str) -> None: ...
def addPyNodeType(pyNodeType: Type[pymel.core.general.PyNode], parentPyNode: Type[pymel.core.general.PyNode]) -> None: ...
def removePyNodeType(pyNodeTypeName: str) -> None: ...
def clearPyNodeTypes() -> None: ...
def addMayaType(mayaType: str, apiType: Optional[str] = ...) -> None: ...
def removeMayaType(mayaType: str) -> None: ...

class VirtualClassInfo(NamedTuple):
    vclass: Incomplete
    parent: Incomplete
    nameRequired: Incomplete
    isVirtual: Incomplete
    preCreate: Incomplete
    create: Incomplete
    postCreate: Incomplete

class VirtualClassError(Exception): ...

class VirtualClassManager:
    INVALID_ATTRS: Incomplete
    def __init__(self) -> None: ...
    def register(self, vclass: Any, nameRequired: bool = ..., isVirtual: Union[str, Callable] = ..., preCreate: Union[str, Callable] = ..., create: Union[str, Callable] = ..., postCreate: Union[str, Callable] = ...) -> None: ...
    def unregister(self, vcls) -> None: ...
    def getVirtualClass(self, baseClass, obj, name: Incomplete | None = ..., fnDepend: Incomplete | None = ...): ...
    def getVirtualClassInfo(self, vclass): ...

virtualClasses: Incomplete
registerVirtualClass: Incomplete

def isValidPyNode(arg: str) -> bool: ...
def isValidPyNodeName(arg: str) -> bool: ...
def toApiTypeStr(obj: Union[int, str, util.ProxyUnicode], default: Optional[str] = ...) -> Optional[str]: ...
def toApiTypeEnum(obj: Union[str, util.ProxyUnicode], default: Optional[int] = ...) -> Optional[int]: ...
def toApiFunctionSet(obj: Union[str, int]) -> Optional[Type]: ...
def apiClassNameToPymelClassName(apiName: str, allowGuess: bool = ...) -> Optional[str]: ...
def isMayaType(mayaType: str) -> bool: ...
def getComponentTypes() -> Dict[str, List[int]]: ...
