from typing import *
from . import cachebase as cachebase, startup as startup
from _typeshed import Incomplete
from pymel.api.plugins import mpxNamesToApiEnumNames as mpxNamesToApiEnumNames
from typing import Any

TYPE_CHECKING: bool

class ApiEnum(tuple):
    def pymelName(self) -> str: ...

class GhostObjsOkHere:
    @classmethod
    def OK(cls): ...
    oldOK: Incomplete
    def __enter__(self): ...
    def __exit__(self, exc_type, exc_value, traceback) -> None: ...

class InvalidNodeTypeError(Exception): ...
class ManipNodeTypeError(InvalidNodeTypeError): ...

class _GhostObjMaker:
    multi: Incomplete
    mayaTypes: Incomplete
    dagMod: Incomplete
    dgMod: Incomplete
    dagGhosts: bool
    dgGhosts: bool
    manipError: Incomplete
    byMayaType: Incomplete
    ghosts: Incomplete
    def __init__(self, mayaTypes, dagMod: Incomplete | None = ..., dgMod: Incomplete | None = ..., manipError: bool = ..., multi: bool = ...) -> None: ...
    def __enter__(self): ...
    def __exit__(self, exc_type, exc_value, traceback) -> None: ...

def isPluginNode(nodeName): ...
def getInheritance(mayaType: str, checkManip3D: bool = ..., checkCache: bool = ..., updateCache: bool = ...) -> List[str]: ...
def nodeToApiName(nodeName: str) -> str: ...
def getLowerCaseMapping(names: Iterable[str]) -> Tuple[Dict[str, str], Dict[str, Tuple[str, str]]]: ...

API_NAME_MODIFIERS: Incomplete
apiSuffixes: Incomplete

class BaseApiClassInfoCache(cachebase.SubItemCache):
    CLASSINFO_SUBCACHE_NAME: Incomplete
    def fromRawData(self, data): ...
    def toRawData(self, data): ...

class ApiMelBridgeCache(BaseApiClassInfoCache):
    NAME: str
    DESC: str
    USE_VERSION: bool
    CLASSINFO_SUBCACHE_NAME: str
    def rebuild(self) -> None: ...
    @classmethod
    def stripComments(cls, sourcelines): ...
    @classmethod
    def applyComments(cls, origText, origTextNoComments, newPath): ...
    def write(self, data: T, ext: Optional[str] = ...) -> None: ...

class ApiCache(BaseApiClassInfoCache):
    NAME: str
    DESC: str
    USE_VERSION: bool
    CLASSINFO_SUBCACHE_NAME: str
    EXTRA_GLOBAL_NAMES: Incomplete
    apiTypesToApiEnums: Dict[str, int]
    apiEnumsToApiTypes: Dict[int, str]
    mayaTypesToApiTypes: Dict[str, str]
    apiTypesToApiClasses: Dict[str, Type]
    apiClassInfo: Dict[str, Any]
    mayaTypesToApiEnums: Dict[str, int]
    CRASH_TYPES: Incomplete
    MAYA_TO_API_OVERRIDES: Incomplete
    MFN_TO_API_OVERRIDES: Incomplete
    API_TO_MFN_OVERRIDES: Incomplete
    DEFAULT_API_TYPE: str
    @classmethod
    def allVersions(cls, allowEmpty: bool = ...) -> List[str]: ...
    docLocation: Incomplete
    strict: Incomplete
    def __init__(self, docLocation: Incomplete | None = ..., strict: Incomplete | None = ...) -> None: ...
    def fromRawData(self, data): ...
    def toRawData(self, data): ...
    def getMfnClsToApiEnum(self, mfnCls): ...
    def getApiEnumToApiType(self, enumInt: int) -> str: ...
    def getMfnClsToApiType(self, mfnCls): ...
    def addMayaType(self, mayaType, apiType, updateObj: Incomplete | None = ...) -> None: ...
    def removeMayaType(self, mayaType, updateObj: Incomplete | None = ...) -> None: ...
    def mayaTypeToApiType(self, mayaType: str, useCache: bool = ..., ghostObjs: bool = ...) -> str: ...
    def filterPluginNodes(self) -> None: ...
    def rebuild(self) -> None: ...
    def melBridgeContents(self): ...
    def extraDicts(self): ...
