import maya.OpenMaya as _api
import pymel.util as _util
import pymel.core.datatypes as datatypes
import pymel.core.general as general
from _typeshed import Incomplete
from builtins import str
from pymel.core import animation as animation, effects as effects, modeling as modeling, other as other, rendering as rendering, system as system, windows as windows
from pymel.core.system import FileReference as _FileReference
from pymel.util.enum import Enum as Enum
from typing import Any, Callable, Iterable, List, Optional, Sequence, Set, Tuple, Type, TypeVar, Union, overload
from typing_extensions import Literal

TYPE_CHECKING: bool
DependNodeT = TypeVar('DependNodeT', bound=DependNode)
DagNodeT = TypeVar('DagNodeT', bound=DagNode)
ShapeT = TypeVar('ShapeT', bound=Shape)
mayaTypeNameToPymelTypeName: Incomplete
pymelTypeNameToMayaTypeName: Incomplete

class NodetypesLazyLoadModule(_util.LazyLoadModule):
    def __getattr__(self, name): ...

class DependNode(general.PyNode):
    __apicls__: Incomplete
    def __melobject__(self) -> str: ...
    def name(self, update: bool = ..., stripNamespace: bool = ..., levels: int = ..., long: bool = ..., stripUnderWorld: bool = ...) -> str: ...
    def namespace(self, root: bool = ...) -> str: ...
    def shortName(self, update: bool = ..., stripNamespace: bool = ..., levels: int = ..., long: bool = ..., stripUnderWorld: bool = ...) -> str: ...
    def longName(self, update: bool = ..., stripNamespace: bool = ..., levels: int = ..., long: bool = ..., stripUnderWorld: bool = ...) -> str: ...
    def nodeName(self, update: bool = ..., stripNamespace: bool = ..., levels: int = ..., long: bool = ..., stripUnderWorld: bool = ...) -> str: ...
    @overload
    def rename(self, name: Any, preserveNamespace: bool = ..., ignoreShape: bool | int = ..., uuid: bool | int = ..., uid: bool | int = ...) -> DependNode: ...
    def __apiobject__(self) -> Any: ...
    def __apimobject__(self) -> _api.MObject: ...
    def __apihandle__(self) -> _api.MObjectHandle: ...
    def __hash__(self) -> int: ...
    def node(self) -> DependNode: ...
    def lock(self) -> None: ...
    def unlock(self) -> None: ...
    def cast(self, swapNode, copyDynamicAttrs: bool | int = ..., cda: bool | int = ..., disableAPICallbacks: bool | int = ..., dsa: bool | int = ..., disableScriptJobCallbacks: bool | int = ..., dsj: bool | int = ..., disconnectUnmatchedAttrs: bool | int = ..., dua: bool | int = ..., force: bool | int = ..., f: bool | int = ..., swapNames: bool | int = ..., sn: bool | int = ..., swapValues: bool | int = ..., sv: bool | int = ...): ...
    duplicate: Incomplete
    def savePreset(self, presetName: str, custom: Optional[str] = ..., attributes: Iterable[str] = ...) -> None: ...
    def loadPreset(self, presetName): ...
    def deletePreset(self, presetName): ...
    def listPresets(self): ...
    type = general.nodeType
    @classmethod
    def typeName(cls) -> str: ...
    @overload
    def referenceFile(self, allowNone: Literal[False]) -> _FileReference: ...
    @overload
    def referenceFile(self) -> Optional[_FileReference]: ...
    def referencePath(self) -> system.Path: ...
    def classification(self, **kwargs: Any) -> str: ...
    @overload
    def inputs(self, connections: Literal[True], plugs: Literal[True], sourceFirst: bool = ..., type: general.TypeArgTypes = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[Tuple[general.Attribute, general.Attribute]]: ...
    @overload
    def inputs(self, connections: Literal[True], type: Type[DependNodeT], plugs: Literal[False] = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[Tuple[general.Attribute, DependNodeT]]: ...
    @overload
    def inputs(self, connections: Literal[True], plugs: Literal[False] = ..., type: general.LimitedTypeArgTypes = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[Tuple[general.Attribute, DependNode]]: ...
    @overload
    def inputs(self, plugs: Literal[True], connections: Literal[False] = ..., type: general.TypeArgTypes = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[general.Attribute]: ...
    @overload
    def inputs(self, type: Type[DependNodeT], plugs: Literal[False] = ..., connections: Literal[False] = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[DependNodeT]: ...
    @overload
    def inputs(self, type: general.LimitedTypeArgTypes = ..., connections: bool | int = ..., c: bool | int = ..., exactType: bool | int = ..., et: bool | int = ..., plugs: bool | int = ..., p: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[DependNode]: ...
    @overload
    def outputs(self, connections: Literal[True], plugs: Literal[True], sourceFirst: bool = ..., type: general.TypeArgTypes = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[Tuple[general.Attribute, general.Attribute]]: ...
    @overload
    def outputs(self, connections: Literal[True], type: Type[DependNodeT], plugs: Literal[False] = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[Tuple[general.Attribute, DependNodeT]]: ...
    @overload
    def outputs(self, connections: Literal[True], plugs: Literal[False] = ..., type: general.LimitedTypeArgTypes = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[Tuple[general.Attribute, DependNode]]: ...
    @overload
    def outputs(self, plugs: Literal[True], connections: Literal[False] = ..., type: general.TypeArgTypes = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[general.Attribute]: ...
    @overload
    def outputs(self, type: Type[DependNodeT], plugs: Literal[False] = ..., connections: Literal[False] = ..., exactType: bool | int = ..., et: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[DependNodeT]: ...
    @overload
    def outputs(self, type: general.LimitedTypeArgTypes = ..., connections: bool | int = ..., c: bool | int = ..., exactType: bool | int = ..., et: bool | int = ..., plugs: bool | int = ..., p: bool | int = ..., shapes: bool | int = ..., sh: bool | int = ..., skipConversionNodes: bool | int = ..., scn: bool | int = ...) -> List[DependNode]: ...
    sources = inputs
    destinations = outputs
    def shadingGroups(self) -> List[ShadingEngine]: ...
    def __getattr__(self, attr: str) -> general.Attribute: ...
    def attrSpec(obj: Any, attr: Any) -> general.AttributeSpec: ...
    attrDefaults = attrSpec
    def attr(self, attr: str) -> general.Attribute: ...
    hasAttr = general.hasAttr
    def setAttr(self, attr: str, *args: Any, alteredValue: bool | int = ..., av: bool | int = ..., caching: bool | int = ..., ca: bool | int = ..., capacityHint: int = ..., ch: int = ..., channelBox: bool | int = ..., cb: bool | int = ..., clamp: bool | int = ..., c: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., keyable: bool | int = ..., k: bool | int = ..., lock: bool | int = ..., l: bool | int = ..., query: bool | int = ..., q: bool | int = ..., size: int = ..., s: int = ..., type: _util.ProxyUnicode | str = ..., typ: _util.ProxyUnicode | str = ...) -> Any: ...
    def setDynamicAttr(self, attr: str, *args: Any, alteredValue: bool | int = ..., av: bool | int = ..., caching: bool | int = ..., ca: bool | int = ..., capacityHint: int = ..., ch: int = ..., channelBox: bool | int = ..., cb: bool | int = ..., clamp: bool | int = ..., c: bool | int = ..., edit: bool | int = ..., e: bool | int = ..., keyable: bool | int = ..., k: bool | int = ..., lock: bool | int = ..., l: bool | int = ..., query: bool | int = ..., q: bool | int = ..., size: int = ..., s: int = ..., type: _util.ProxyUnicode | str = ..., typ: _util.ProxyUnicode | str = ...) -> Any: ...
    def getAttr(self, attr: str, *args: Any, asString: bool | int = ..., caching: bool | int = ..., ca: bool | int = ..., channelBox: bool | int = ..., cb: bool | int = ..., expandEnvironmentVariables: bool | int = ..., x: bool | int = ..., keyable: bool | int = ..., k: bool | int = ..., lock: bool | int = ..., l: bool | int = ..., multiIndices: bool | int = ..., mi: bool | int = ..., settable: bool | int = ..., se: bool | int = ..., silent: bool | int = ..., sl: bool | int = ..., size: bool | int = ..., s: bool | int = ..., time: int | float = ..., t: int | float = ..., type: bool | int = ..., typ: bool | int = ...) -> Any: ...
    @overload
    def addAttr(self, attr: str, type: Union[str, Type] = ..., childSuffixes: Sequence[str] = ..., enumName: general.EnumArgTypes = ..., attributeType: bool | int | _util.ProxyUnicode | str = ..., at: bool | int | _util.ProxyUnicode | str = ..., binaryTag: bool | int | _util.ProxyUnicode | str = ..., bt: bool | int | _util.ProxyUnicode | str = ..., cachedInternally: bool | int = ..., ci: bool | int = ..., category: bool | int | str | List[str] = ..., ct: bool | int | str | List[str] = ..., dataType: bool | int | str | List[str] = ..., dt: bool | int | str | List[str] = ..., defaultValue: bool | int | float = ..., dv: bool | int | float = ..., disconnectBehaviour: bool | int | int = ..., dcb: bool | int | int = ..., edit: bool | int = ..., e: bool | int = ..., exists: bool | int = ..., ex: bool | int = ..., fromPlugin: bool | int = ..., fp: bool | int = ..., hasMaxValue: bool | int = ..., hxv: bool | int = ..., hasMinValue: bool | int = ..., hnv: bool | int = ..., hasSoftMaxValue: bool | int = ..., hsx: bool | int = ..., hasSoftMinValue: bool | int = ..., hsn: bool | int = ..., hidden: bool | int = ..., h: bool | int = ..., indexMatters: bool | int = ..., im: bool | int = ..., internalSet: bool | int = ..., keyable: bool | int = ..., k: bool | int = ..., longName: bool | int | _util.ProxyUnicode | str = ..., ln: bool | int | _util.ProxyUnicode | str = ..., maxValue: bool | int | float = ..., max: bool | int | float = ..., minValue: bool | int | float = ..., min: bool | int | float = ..., multi: bool | int = ..., m: bool | int = ..., niceName: bool | int | _util.ProxyUnicode | str = ..., nn: bool | int | _util.ProxyUnicode | str = ..., numberOfChildren: bool | int | int = ..., nc: bool | int | int = ..., parent: bool | int | _util.ProxyUnicode | str = ..., p: bool | int | _util.ProxyUnicode | str = ..., proxy: bool | int | _util.ProxyUnicode | str = ..., pxy: bool | int | _util.ProxyUnicode | str = ..., query: bool | int = ..., q: bool | int = ..., readable: bool | int = ..., r: bool | int = ..., shortName: bool | int | _util.ProxyUnicode | str = ..., sn: bool | int | _util.ProxyUnicode | str = ..., softMaxValue: bool | int | float = ..., smx: bool | int | float = ..., softMinValue: bool | int | float = ..., smn: bool | int | float = ..., storable: bool | int = ..., s: bool | int = ..., usedAsColor: bool | int = ..., uac: bool | int = ..., usedAsFilename: bool | int = ..., uaf: bool | int = ..., usedAsProxy: bool | int = ..., uap: bool | int = ..., worldSpace: bool | int = ..., ws: bool | int = ..., writable: bool | int = ..., w: bool | int = ...) -> Any: ...
    def deleteAttr(self, attr: str, *args: Any, attribute: _util.ProxyUnicode | str = ..., at: _util.ProxyUnicode | str = ..., edit: bool | int = ..., e: bool | int = ..., query: bool | int = ..., q: bool | int = ...) -> None: ...
    removeAttribute = deleteAttr
    def connectAttr(self, attr: str, destination: Union[str, general.Attribute], force: bool | int = ..., f: bool | int = ..., lock: bool | int = ..., l: bool | int = ..., nextAvailable: bool | int = ..., na: bool | int = ..., referenceDest: _util.ProxyUnicode | str = ..., rd: _util.ProxyUnicode | str = ...) -> None: ...
    def disconnectAttr(self, attr: str, destination: Union[str, general.Attribute, None] = ..., nextAvailable: bool | int = ..., na: bool | int = ...) -> None: ...
    listAnimatable: Incomplete
    def listAttr(self, topLevel: bool = ..., descendants: bool = ..., alias: bool = ..., array: bool | int = ..., a: bool | int = ..., caching: bool | int = ..., ca: bool | int = ..., category: str | List[str] = ..., ct: str | List[str] = ..., changedSinceFileOpen: bool | int = ..., cfo: bool | int = ..., channelBox: bool | int = ..., cb: bool | int = ..., connectable: bool | int = ..., c: bool | int = ..., extension: bool | int = ..., ex: bool | int = ..., fromPlugin: bool | int = ..., fp: bool | int = ..., hasData: bool | int = ..., hd: bool | int = ..., hasNullData: bool | int = ..., hnd: bool | int = ..., inUse: bool | int = ..., iu: bool | int = ..., keyable: bool | int = ..., k: bool | int = ..., leaf: bool | int = ..., lf: bool | int = ..., locked: bool | int = ..., l: bool | int = ..., multi: bool | int = ..., m: bool | int = ..., output: bool | int = ..., o: bool | int = ..., ramp: bool | int = ..., ra: bool | int = ..., read: bool | int = ..., r: bool | int = ..., readOnly: bool | int = ..., ro: bool | int = ..., scalar: bool | int = ..., s: bool | int = ..., scalarAndArray: bool | int = ..., sa: bool | int = ..., settable: bool | int = ..., se: bool | int = ..., shortNames: bool | int = ..., sn: bool | int = ..., string: str | List[str] = ..., st: str | List[str] = ..., unlocked: bool | int = ..., u: bool | int = ..., usedAsFilename: bool | int = ..., uf: bool | int = ..., userDefined: bool | int = ..., ud: bool | int = ..., visible: bool | int = ..., v: bool | int = ..., write: bool | int = ..., w: bool | int = ...) -> List[general.Attribute]: ...
    def listAliases(self) -> List[Tuple[str, general.Attribute]]: ...
    def attrInfo(self, allAttributes: bool | int = ..., all: bool | int = ..., bool: bool | int = ..., b: bool | int = ..., enumerated: bool | int = ..., e: bool | int = ..., hidden: bool | int = ..., h: bool | int = ..., inherited: bool | int = ..., internal: bool | int = ..., i: bool | int = ..., leaf: bool | int = ..., l: bool | int = ..., logicalAnd: bool | int = ..., multi: bool | int = ..., m: bool | int = ..., short: bool | int = ..., s: bool | int = ..., type: _util.ProxyUnicode | str = ..., t: _util.ProxyUnicode | str = ..., userInterface: bool | int = ..., ui: bool | int = ..., writable: bool | int = ..., w: bool | int = ...) -> List[general.Attribute]: ...
    def stripNum(self) -> str: ...
    def extractNum(self) -> str: ...
    def nextUniqueName(self) -> other.DependNodeName: ...
    def nextName(self) -> other.DependNodeName: ...
    def prevName(self) -> other.DependNodeName: ...
    @classmethod
    def registerVirtualSubClass(cls, nameRequired: bool = ...) -> None: ...
    __melnode__: str
    MAttrClass: Incomplete
    MdgTimerMetric: Incomplete
    MdgTimerState: Incomplete
    MdgTimerType: Incomplete
    def absoluteName(self) -> str: ...
    @classmethod
    def allocateFlag(self, pluginName: str) -> int: ...
    def attributeClass(self, attribute: Union[str, DependNode]) -> DependencyNode.MAttrClass: ...
    def attributeCount(self) -> int: ...
    def canBeWritten(self) -> bool: ...
    @classmethod
    def deallocateAllFlags(self, pluginName: str) -> None: ...
    @classmethod
    def deallocateFlag(self, pluginName: str, flag: int) -> None: ...
    def dgCallbacks(self, timerType: DependencyNode.MdgTimerType, callbackName: List[str], value: List[float]) -> None: ...
    def dgTimer(self, timerMetric: DependencyNode.MdgTimerMetric, timerType: DependencyNode.MdgTimerType) -> float: ...
    def dgTimerOff(self) -> None: ...
    def dgTimerOn(self) -> None: ...
    def dgTimerQueryState(self) -> DependencyNode.MdgTimerState: ...
    def dgTimerReset(self) -> None: ...
    @classmethod
    def enableDGTiming(self, enable: bool) -> None: ...
    def getAffectsAnimation(self) -> bool: ...
    def getAliasAttr(self, force: bool) -> DependNode: ...
    def getIcon(self) -> str: ...
    def getName(self) -> str: ...
    def hasAttribute(self, attrName: str) -> bool: ...
    def hasUniqueName(self) -> bool: ...
    isUniquelyNamed = hasUniqueName
    def isDefaultNode(self) -> bool: ...
    def isFlagSet(self, flag: int) -> bool: ...
    def isFromReferencedFile(self) -> bool: ...
    isReadOnly = isFromReferencedFile
    isReferenced = isFromReferencedFile
    def isLocked(self) -> bool: ...
    def isNewAttribute(self, attr: Union[str, DependNode]) -> bool: ...
    def isShared(self) -> bool: ...
    def isTrackingEdits(self) -> bool: ...
    def parentNamespace(self) -> str: ...
    def pluginName(self) -> str: ...
    def setAffectsAnimation(self) -> None: ...
    def setDoNotWrite(self, flag: bool) -> None: ...
    def setFlag(self, flag: int, state: bool) -> None: ...
    def setIcon(self, filename: str) -> None: ...
    def setLocked(self, lock: bool) -> None: ...
    def setName(self, name: str, createNamespace: bool = ...) -> str: ...
    def uniqueName(self) -> str: ...

class ContainerBase(DependNode):
    __melnode__: str

class Entity(ContainerBase):
    __melnode__: str

class DagNode(Entity):
    __apicls__: Incomplete
    def comp(self, compName: str) -> Optional[general.Component]: ...
    def listComp(self, names: bool = ...) -> List[str]: ...
    def name(self, update: bool = ..., long: Optional[bool] = ..., stripNamespace: bool = ..., levels: int = ..., stripUnderWorld: bool = ...) -> str: ...
    def longName(self, **kwargs: Any) -> str: ...
    fullPath = longName
    def shortName(self, **kwargs: Any) -> str: ...
    def nodeName(self, stripUnderWorld: Any = ..., **kwargs: Any) -> str: ...
    def __apiobject__(self): ...
    def __apimdagpath__(self): ...
    def __apihandle__(self): ...
    def root(self) -> DagNode: ...
    def hasParent(self, parent: Union[str, DagNode]) -> bool: ...
    def hasChild(self, child: Union[str, DagNode]) -> bool: ...
    def isChildOf(self, parent: Union[str, DagNode]) -> bool: ...
    def isParentOf(self, child: Union[str, DagNode]) -> bool: ...
    def isInstanceOf(self, other: Union[str, DagNode]) -> bool: ...
    def instanceNumber(self) -> int: ...
    def getInstances(self, includeSelf: bool = ...) -> List[DagNode]: ...
    def getOtherInstances(self) -> List[DagNode]: ...
    def firstParent(self) -> DagNode: ...
    def firstParent2(self, allDescendents: bool | int = ..., ad: bool | int = ..., allParents: bool | int = ..., ap: bool | int = ..., children: bool | int = ..., c: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., path: bool | int = ..., pa: bool | int = ..., shapes: bool | int = ..., s: bool | int = ..., type: str | List[str] = ..., typ: str | List[str] = ...) -> Optional[DagNode]: ...
    @overload
    def getParent(self, generations: Union[Literal[-1], Literal[-2]]) -> Transform: ...
    @overload
    def getParent(self, generations: int = ...) -> Optional[Transform]: ...
    @overload
    def getParent(self, generations: None) -> List[Transform]: ...
    def getAllParents(self) -> List[DagNode]: ...
    @overload
    def getChildren(self, type: Type[general.DagNodeT], allDescendents: bool | int = ..., ad: bool | int = ..., allParents: bool | int = ..., ap: bool | int = ..., fullPath: bool | int = ..., f: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., parent: bool | int = ..., p: bool | int = ..., path: bool | int = ..., pa: bool | int = ..., shapes: bool | int = ..., s: bool | int = ...) -> List[general.DagNodeT]: ...
    @overload
    def getChildren(self, shapes: Literal[True], allDescendents: bool | int = ..., ad: bool | int = ..., allParents: bool | int = ..., ap: bool | int = ..., fullPath: bool | int = ..., f: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., parent: bool | int = ..., p: bool | int = ..., path: bool | int = ..., pa: bool | int = ..., type: str | List[str] = ..., typ: str | List[str] = ...) -> List[Shape]: ...
    @overload
    def getChildren(self, type: Union[str, Iterable[Union[str, Type[DagNode]]]] = ..., allDescendents: bool | int = ..., ad: bool | int = ..., allParents: bool | int = ..., ap: bool | int = ..., fullPath: bool | int = ..., f: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., parent: bool | int = ..., p: bool | int = ..., path: bool | int = ..., pa: bool | int = ..., shapes: bool | int = ..., s: bool | int = ...) -> List[DagNode]: ...
    def getSiblings(self, allDescendents: bool | int = ..., ad: bool | int = ..., allParents: bool | int = ..., ap: bool | int = ..., fullPath: bool | int = ..., f: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., parent: bool | int = ..., p: bool | int = ..., path: bool | int = ..., pa: bool | int = ..., shapes: bool | int = ..., s: bool | int = ..., type: str | List[str] = ..., typ: str | List[str] = ...) -> List[DagNode]: ...
    @overload
    def listRelatives(self, type: Type[DagNodeT], allDescendents: bool | int = ..., ad: bool | int = ..., allParents: bool | int = ..., ap: bool | int = ..., children: bool | int = ..., c: bool | int = ..., fullPath: bool | int = ..., f: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., parent: bool | int = ..., p: bool | int = ..., path: bool | int = ..., pa: bool | int = ..., shapes: bool | int = ..., s: bool | int = ...) -> List[DagNodeT]: ...
    @overload
    def listRelatives(self, shapes: Literal[True], allDescendents: bool | int = ..., ad: bool | int = ..., allParents: bool | int = ..., ap: bool | int = ..., children: bool | int = ..., c: bool | int = ..., fullPath: bool | int = ..., f: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., parent: bool | int = ..., p: bool | int = ..., path: bool | int = ..., pa: bool | int = ..., type: str | List[str] = ..., typ: str | List[str] = ...) -> List[Shape]: ...
    @overload
    def listRelatives(self, type: Union[str, Iterable[Union[str, Type[DagNode]]]] = ..., allDescendents: bool | int = ..., ad: bool | int = ..., allParents: bool | int = ..., ap: bool | int = ..., children: bool | int = ..., c: bool | int = ..., fullPath: bool | int = ..., f: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., parent: bool | int = ..., p: bool | int = ..., path: bool | int = ..., pa: bool | int = ..., shapes: bool | int = ..., s: bool | int = ...) -> List[DagNode]: ...
    def setParent(self, *args, absolute: bool | int = ..., a: bool | int = ..., addObject: bool | int = ..., add: bool | int = ..., noConnections: bool | int = ..., nc: bool | int = ..., noInvScale: bool | int = ..., nis: bool | int = ..., relative: bool | int = ..., r: bool | int = ..., removeObject: bool | int = ..., rm: bool | int = ..., shape: bool | int = ..., s: bool | int = ..., world: bool | int = ..., w: bool | int = ...): ...
    def addChild(self, child: Union[str, DagNode], absolute: bool | int = ..., a: bool | int = ..., addObject: bool | int = ..., add: bool | int = ..., noConnections: bool | int = ..., nc: bool | int = ..., noInvScale: bool | int = ..., nis: bool | int = ..., relative: bool | int = ..., r: bool | int = ..., removeObject: bool | int = ..., rm: bool | int = ..., shape: bool | int = ..., s: bool | int = ..., world: bool | int = ..., w: bool | int = ...) -> DagNode: ...
    def __or__(self, child: DagNode, **kwargs: Any) -> DagNode: ...
    def isDisplaced(self) -> bool: ...
    def hide(self) -> None: ...
    def show(self) -> None: ...
    def isVisible(self, checkOverride: bool = ...) -> bool: ...
    def setObjectColor(self, color: Incomplete | None = ...) -> None: ...
    def makeLive(self, state: bool = ...) -> None: ...
    __melnode__: str
    MObjectColorType: Incomplete
    def activeColor(self) -> datatypes.Color: ...
    def boundingBox(self) -> datatypes.BoundingBox: ...
    def child(self, i: int) -> DependNode: ...
    childAtIndex = child
    def childCount(self) -> int: ...
    numChildren = childCount
    def dagRoot(self) -> DependNode: ...
    root = dagRoot
    def dormantColor(self) -> datatypes.Color: ...
    def drawOverrideColor(self) -> Tuple[bool, datatypes.Color]: ...
    def drawOverrideEnabled(self) -> bool: ...
    def drawOverrideIsReference(self) -> bool: ...
    def drawOverrideIsTemplate(self) -> bool: ...
    def fullPathName(self) -> str: ...
    def getAllPaths(self) -> List[DagNode]: ...
    def getConnectedSetsAndMembers(self, instanceNumber: int, renderableSetsOnly: bool) -> Tuple[List[DependNode], List[DependNode]]: ...
    def getObjectColor(self) -> int: ...
    def getObjectColorType(self) -> DagNode.MObjectColorType: ...
    def hiliteColor(self) -> datatypes.Color: ...
    def inModel(self) -> bool: ...
    def inUnderWorld(self) -> bool: ...
    def instanceCount(self, total: bool = ...) -> int: ...
    def isInstanceable(self) -> bool: ...
    def isInstanced(self, indirect: bool = ...) -> bool: ...
    def isInstancedAttribute(self, attribute: Union[str, DependNode]) -> bool: ...
    def isIntermediateObject(self) -> bool: ...
    isIntermediate = isIntermediateObject
    def objectColorIndex(self) -> int: ...
    def objectColorRGB(self) -> datatypes.Color: ...
    def objectGroupComponent(self, groupId: int, compList: List[str]) -> None: ...
    def parent(self, i: int) -> DependNode: ...
    parentAtIndex = parent
    def parentCount(self) -> int: ...
    def partialPathName(self) -> str: ...
    def setInstanceable(self, how: bool) -> None: ...
    def setIntermediateObject(self, isIntermediate: bool) -> None: ...
    setIntermediate = setIntermediateObject
    def setObjectColorType(self, type: DagNode.MObjectColorType) -> None: ...
    def setUseObjectColor(self, useObjectColor: bool) -> None: ...
    def transformationMatrix(self) -> datatypes.Matrix: ...
    def usingHiliteColor(self) -> bool: ...
    def usingObjectColor(self) -> bool: ...
    isUsingObjectColor = usingObjectColor

class Shape(DagNode):
    @overload
    def getParent(self) -> Transform: ...
    @overload
    def getParent(self, generations: Optional[int]) -> Optional[Transform]: ...
    def getTransform(self): ...
    def setParent(self, *args, **kwargs) -> None: ...
    __melnode__: str

class Camera(Shape):
    orbit: Incomplete
    track: Incomplete
    tumble: Incomplete
    def applyBookmark(self, bookmark) -> None: ...
    def addBookmark(self, bookmark: Incomplete | None = ...) -> None: ...
    def removeBookmark(self, bookmark) -> None: ...
    def updateBookmark(self, bookmark) -> None: ...
    def listBookmarks(self): ...
    def dolly(self, distance, relative: bool = ...) -> None: ...
    def roll(self, degree, relative: bool = ...) -> None: ...
    def setNearFarClippingPlanes(self, dNear, dFar) -> None: ...
    setNearFarClipPlanes = setNearFarClippingPlanes
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    FilmFit: Incomplete
    RollOrder: Incomplete
    def computeDepthOfField(self) -> None: ...
    def copyViewFrom(self, otherCamera: DagNode) -> None: ...
    def getAspectRatio(self) -> float: ...
    def getAspectRatioLimits(self) -> Tuple[float, float]: ...
    def getCameraScale(self) -> float: ...
    def getCenterOfInterest(self) -> float: ...
    def getCenterOfInterestPoint(self, space: datatypes.Space.Space = ...) -> datatypes.Point: ...
    def getDisplayFieldChart(self, **kwargs) -> bool: ...
    def getDisplayFilmOrigin(self, **kwargs) -> bool: ...
    def getDisplayFilmPivot(self, **kwargs) -> bool: ...
    def getDisplayGateMask(self, **kwargs) -> bool: ...
    def getDisplayResolution(self, **kwargs) -> bool: ...
    def getDisplaySafeAction(self, **kwargs) -> bool: ...
    def getDisplaySafeTitle(self, **kwargs) -> bool: ...
    def getEyePoint(self, space: datatypes.Space.Space = ...) -> datatypes.Point: ...
    def getFStop(self) -> float: ...
    def getFarClippingPlane(self) -> float: ...
    getFarClipPlane = getFarClippingPlane
    def getFarFocusDistance(self) -> float: ...
    def getFilmApertureLimits(self) -> Tuple[float, float]: ...
    def getFilmFit(self) -> Camera.FilmFit: ...
    def getFilmFitOffset(self) -> float: ...
    def getFilmFrustum(self, distance: float, applyPanZoom: bool = ...) -> List[datatypes.Point]: ...
    def getFilmRollOrder(self) -> Camera.RollOrder: ...
    def getFilmRollValue(self) -> float: ...
    def getFilmTranslateH(self) -> float: ...
    def getFilmTranslateV(self) -> float: ...
    def getFocalLength(self) -> float: ...
    def getFocalLengthLimits(self) -> Tuple[float, float]: ...
    def getFocusDistance(self) -> float: ...
    def getHomeCommand(self, **kwargs) -> str: ...
    def getHorizontalFieldOfView(self) -> float: ...
    def getHorizontalFilmAperture(self) -> float: ...
    def getHorizontalFilmOffset(self) -> float: ...
    def getHorizontalPan(self) -> float: ...
    def getHorizontalRollPivot(self) -> float: ...
    def getHorizontalShake(self) -> float: ...
    def getJournalCommand(self, **kwargs) -> bool: ...
    def getLensSqueezeRatio(self) -> float: ...
    def getLockTransform(self, **kwargs) -> bool: ...
    def getNearClippingPlane(self) -> float: ...
    getNearClipPlane = getNearClippingPlane
    def getNearFocusDistance(self) -> float: ...
    def getOrthoWidth(self) -> float: ...
    def getOverscan(self) -> float: ...
    def getPanZoomEnabled(self) -> bool: ...
    def getPortFieldOfView(self, width: int, height: int) -> Tuple[float, float]: ...
    def getPostScale(self) -> float: ...
    def getPreScale(self) -> float: ...
    def getRenderPanZoom(self) -> bool: ...
    def getRenderingFrustum(self, windowAspect: float) -> Tuple[float, float, float, float]: ...
    def getShakeEnabled(self) -> bool: ...
    def getShakeOverscan(self) -> float: ...
    def getShakeOverscanEnabled(self) -> bool: ...
    def getShutterAngle(self) -> float: ...
    def getStartupCamera(self, **kwargs) -> bool: ...
    def getStereoHIT(self) -> float: ...
    def getStereoHITEnabled(self) -> bool: ...
    def getTumblePivot(self) -> datatypes.Point: ...
    def getUsePivotAsLocalSpace(self) -> bool: ...
    def getVerticalFieldOfView(self) -> float: ...
    def getVerticalFilmAperture(self) -> float: ...
    def getVerticalFilmOffset(self) -> float: ...
    def getVerticalPan(self) -> float: ...
    def getVerticalRollPivot(self) -> float: ...
    def getVerticalShake(self) -> float: ...
    def getViewParameters(self, windowAspect: float, applyOverscan: bool = ..., applySqueeze: bool = ..., applyPanZoom: bool = ...) -> Tuple[float, float, float, float]: ...
    def getViewingFrustum(self, windowAspect: float, applyOverscan: bool = ..., applySqueeze: bool = ..., applyPanZoom: bool = ...) -> Tuple[float, float, float, float]: ...
    def getWorldCenterOfInterest(self, **kwargs) -> Tuple[float, float, float]: ...
    def getWorldUp(self, **kwargs) -> Tuple[float, float, float]: ...
    def getZoom(self) -> float: ...
    def hasSamePerspective(self, otherCamera: DagNode) -> bool: ...
    def isClippingPlanes(self) -> bool: ...
    def isDepthOfField(self) -> bool: ...
    def isDisplayFilmGate(self) -> bool: ...
    def isDisplayGateMask(self) -> bool: ...
    def isMotionBlur(self) -> bool: ...
    isMotionBlurred = isMotionBlur
    def isOrtho(self) -> bool: ...
    def isVerticalLock(self) -> bool: ...
    def postProjectionMatrix(self) -> datatypes.FloatMatrix: ...
    def projectionMatrix(self) -> datatypes.FloatMatrix: ...
    def rightDirection(self, space: datatypes.Space.Space = ...) -> datatypes.Vector: ...
    def set(self, wsEyeLocation: datatypes.Point, wsViewDirection: datatypes.Vector, wsUpDirection: datatypes.Vector, horizFieldOfView: float, aspectRatio: float) -> None: ...
    setupCamera = set
    def setAspectRatio(self, aspectRatio: float) -> None: ...
    def setCameraScale(self, scale: float) -> None: ...
    def setCenterOfInterest(self, dist: float) -> None: ...
    def setCenterOfInterestPoint(self, centerOfInterest: datatypes.Point, space: datatypes.Space.Space = ...) -> None: ...
    def setClippingPlanes(self, ClippingPlanes: bool) -> None: ...
    def setDepthOfField(self, depthOfField: bool) -> None: ...
    def setDisplayFieldChart(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDisplayFilmGate(self, displayFilmGate: bool) -> None: ...
    def setDisplayFilmOrigin(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDisplayFilmPivot(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDisplayGateMask(self, displayGateMask: bool) -> None: ...
    def setDisplayResolution(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDisplaySafeAction(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDisplaySafeTitle(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setEyePoint(self, eyeLocation: datatypes.Point, space: datatypes.Space.Space = ...) -> None: ...
    def setFStop(self, fStop: float) -> None: ...
    def setFarClippingPlane(self, dFar: float) -> None: ...
    setFarClipPlane = setFarClippingPlane
    def setFarFocusDistance(self, farFocusDistance: float) -> None: ...
    def setFilmFit(self, filmFit: Camera.FilmFit) -> None: ...
    def setFilmFitOffset(self, filmFitOffset: float) -> None: ...
    def setFilmRollOrder(self, filmRollOrder: Camera.RollOrder) -> None: ...
    def setFilmRollValue(self, filmRollValue: float) -> None: ...
    def setFilmTranslateH(self, translate: float) -> None: ...
    def setFilmTranslateV(self, translate: float) -> None: ...
    def setFocalLength(self, focalLength: float) -> None: ...
    def setFocusDistance(self, distance: float) -> None: ...
    def setHomeCommand(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setHorizontalFieldOfView(self, fov: float) -> None: ...
    def setHorizontalFilmAperture(self, hFilmAperture: float) -> None: ...
    def setHorizontalFilmOffset(self, hOffset: float) -> None: ...
    def setHorizontalPan(self, hPan: float) -> None: ...
    def setHorizontalRollPivot(self, horizontalRollPivot: float) -> None: ...
    def setHorizontalShake(self, hOffset: float) -> None: ...
    def setJournalCommand(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setLensSqueezeRatio(self, aspectRatio: float) -> None: ...
    def setLockTransform(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setMotionBlur(self, motionBlur: bool) -> None: ...
    setMotionBlurred = setMotionBlur
    def setNearClippingPlane(self, dNear: float) -> None: ...
    setNearClipPlane = setNearClippingPlane
    def setNearFocusDistance(self, nearFocusDistance: float) -> None: ...
    def setOrtho(self, orthoState: bool) -> None: ...
    def setOrthoWidth(self, orthoWidth: float) -> None: ...
    def setOverscan(self, overscan: float) -> None: ...
    def setPanZoomEnabled(self, enabled: bool) -> None: ...
    def setPostScale(self, sf: float) -> None: ...
    def setPreScale(self, sf: float) -> None: ...
    def setRenderPanZoom(self, render: bool) -> None: ...
    def setShakeEnabled(self, enabled: bool) -> None: ...
    def setShakeOverscan(self, overscan: float) -> None: ...
    def setShakeOverscanEnabled(self, enabled: bool) -> None: ...
    def setShutterAngle(self, shutterAngle: float) -> None: ...
    def setStartupCamera(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setStereoHIT(self, hit: float) -> None: ...
    def setStereoHITEnabled(self, enabled: bool) -> None: ...
    def setTumblePivot(self, point: datatypes.Point) -> None: ...
    def setUsePivotAsLocalSpace(self, how: bool) -> None: ...
    def setVerticalFieldOfView(self, fov: float) -> None: ...
    def setVerticalFilmAperture(self, vFilmAperture: float) -> None: ...
    def setVerticalFilmOffset(self, vOffset: float) -> None: ...
    def setVerticalLock(self, lockFlag: bool) -> None: ...
    def setVerticalPan(self, vPan: float) -> None: ...
    def setVerticalRollPivot(self, verticalRollPivot: float) -> None: ...
    def setVerticalShake(self, vOffset: float) -> None: ...
    def setWorldCenterOfInterest(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setWorldUp(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setZoom(self, zoom: float) -> None: ...
    def unnormalizedFarClippingPlane(self) -> float: ...
    def unnormalizedNearClippingPlane(self) -> float: ...
    def upDirection(self, space: datatypes.Space.Space = ...) -> datatypes.Vector: ...
    def viewDirection(self, space: datatypes.Space.Space = ...) -> datatypes.Vector: ...

class Transform(DagNode):
    rotatePivot: general.Pivot
    scalePivot: general.Pivot
    def __getattr__(self, attr): ...
    def __setattr__(self, attr: str, val: Any) -> None: ...
    def attr(self, attr: str, checkShape: bool = ...) -> general.Attribute: ...
    def getShape(self, **kwargs: Any) -> Shape: ...
    @overload
    def getShapes(self, type: Type[general.DagNodeT], allDescendents: bool | int = ..., ad: bool | int = ..., allParents: bool | int = ..., ap: bool | int = ..., fullPath: bool | int = ..., f: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., parent: bool | int = ..., p: bool | int = ..., path: bool | int = ..., pa: bool | int = ...) -> List[general.ShapeT]: ...
    @overload
    def getShapes(self, type: Union[str, Iterable[Union[str, Type[Shape]]]] = ..., allDescendents: bool | int = ..., ad: bool | int = ..., allParents: bool | int = ..., ap: bool | int = ..., fullPath: bool | int = ..., f: bool | int = ..., noIntermediate: bool | int = ..., ni: bool | int = ..., parent: bool | int = ..., p: bool | int = ..., path: bool | int = ..., pa: bool | int = ...) -> List[Shape]: ...
    def ungroup(self, **kwargs): ...
    def setMatrix(self, val, **kwargs) -> None: ...
    def setTranslation(self, vector, space: str = ..., **kwargs): ...
    def getTranslation(self, space: str = ..., **kwargs): ...
    def translateBy(self, vector, space: str = ..., **kwargs) -> None: ...
    def setScale(self, scale, **kwargs): ...
    def scaleBy(self, scale, **kwargs) -> None: ...
    def setShear(self, shear, **kwargs): ...
    def shearBy(self, shear, **kwargs) -> None: ...
    def setRotatePivot(self, point, space: str = ..., balance: bool = ..., **kwargs): ...
    def getRotatePivot(self, space: str = ..., **kwargs): ...
    def setRotatePivotTranslation(self, vector, space: str = ..., **kwargs): ...
    def getRotatePivotTranslation(self, space: str = ..., **kwargs): ...
    def setRotation(self, rotation, space: str = ..., **kwargs): ...
    def getRotation(self, space: str = ..., quaternion: bool = ..., **kwargs): ...
    def rotateBy(self, rotation, space: str = ..., **kwargs) -> None: ...
    def rotateByQuaternion(self, xOrQuaternion: Union[float, Quaternion, List[float], Tuple[float]], y: float = ..., z: float = ..., w: float = ..., space: datatypes.Space.Space = ...) -> None: ...
    def setScalePivot(self, point, space: str = ..., balance: bool = ..., **kwargs): ...
    def getScalePivot(self, space: str = ..., **kwargs): ...
    def setScalePivotTranslation(self, vector, space: str = ..., **kwargs): ...
    def getScalePivotTranslation(self, space: str = ..., **kwargs): ...
    def getPivots(self, **kwargs): ...
    def getRotateAxis(self, **kwargs): ...
    def getRotateOrientation(self, space: str = ...): ...
    def setRotateOrientation(self, quat, space: str = ..., balance: bool = ...): ...
    def getMatrix(self, **kwargs): ...
    def getBoundingBox(self, invisible: Any = ..., space: Any = ...) -> datatypes.BoundingBox: ...
    def getBoundingBoxMin(self, invisible: Any = ..., space: Any = ...) -> datatypes.Vector: ...
    def getBoundingBoxMax(self, invisible: Any = ..., space: Any = ...) -> datatypes.Vector: ...
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    LimitType: Incomplete
    @classmethod
    def balanceTransformation(self, mtx: datatypes.TransformationMatrix, rotateAxis: datatypes.Quaternion = ..., jointOrient: datatypes.Quaternion = ..., segmentScaleCompensate: bool = ..., inverseScale: datatypes.Vector = ..., rotateOrder: datatypes.EulerRotation.RotationOrder = ...) -> Tuple[datatypes.Vector, datatypes.EulerRotation, datatypes.Vector]: ...
    def centerPivots(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def centerPivotsOnComponents(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def clearRestPosition(self) -> None: ...
    def deletePriorHistory(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def enableLimit(self, type: Transform.LimitType, flag: bool) -> None: ...
    setLimited = enableLimit
    def getBoundingBoxInvisible(self, **kwargs) -> Any: ...
    def getRestPosition(self) -> datatypes.TransformationMatrix: ...
    def getRotationOrder(self) -> datatypes.TransformationMatrix.RotationOrder: ...
    def getScale(self) -> Tuple[float, float, float]: ...
    def getShear(self) -> Tuple[float, float, float]: ...
    def isLimited(self, type: Transform.LimitType) -> bool: ...
    def limitValue(self, type: Transform.LimitType) -> float: ...
    getLimit = limitValue
    def preserveUV(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def reflection(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def reflectionAboutBBox(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def reflectionAboutOrigin(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def reflectionAboutX(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def reflectionAboutY(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def reflectionAboutZ(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def reflectionTolerance(self, val: float = ..., **kwargs: Any) -> None: ...
    def resetFromRestPosition(self) -> None: ...
    def resetTransformation(self, transform: datatypes.Matrix) -> None: ...
    def set(self, transform: datatypes.TransformationMatrix) -> None: ...
    setTransformation = set
    def setLimit(self, type: Transform.LimitType, value: float) -> None: ...
    def setPivots(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setRestPosition(self, matrix: datatypes.TransformationMatrix) -> None: ...
    def setRotateAxis(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setRotationOrder(self, order: datatypes.TransformationMatrix.RotationOrder, reorder: bool) -> None: ...
    def transformation(self) -> datatypes.TransformationMatrix: ...
    getTransformation = transformation
    def zeroTransformPivots(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class Joint(Transform):
    connect: Incomplete
    disconnect: Incomplete
    insert: Incomplete
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    Axis: Incomplete
    def assumePreferredAngles(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def children(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def component(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getAngleX(self, **kwargs) -> float: ...
    def getAngleY(self, **kwargs) -> float: ...
    def getAngleZ(self, **kwargs) -> float: ...
    def getDegreeOfFreedom(self, **kwargs) -> str: ...
    def getDegreesOfFreedom(self) -> Tuple[bool, bool, bool]: ...
    def getExists(self, **kwargs) -> Any: ...
    def getLimitSwitchX(self, **kwargs) -> bool: ...
    def getLimitSwitchY(self, **kwargs) -> bool: ...
    def getLimitSwitchZ(self, **kwargs) -> bool: ...
    def getLimitX(self, **kwargs) -> Tuple[float, float]: ...
    def getLimitY(self, **kwargs) -> Tuple[float, float]: ...
    def getLimitZ(self, **kwargs) -> Tuple[float, float]: ...
    def getMaxRotateDampXRange(self) -> float: ...
    def getMaxRotateDampXStrength(self) -> float: ...
    def getMaxRotateDampYRange(self) -> float: ...
    def getMaxRotateDampYStrength(self) -> float: ...
    def getMaxRotateDampZRange(self) -> float: ...
    def getMaxRotateDampZStrength(self) -> float: ...
    def getMinRotateDampXRange(self) -> float: ...
    def getMinRotateDampXStrength(self) -> float: ...
    def getMinRotateDampYRange(self) -> float: ...
    def getMinRotateDampYStrength(self) -> float: ...
    def getMinRotateDampZRange(self) -> float: ...
    def getMinRotateDampZStrength(self) -> float: ...
    def getOrientation(self) -> datatypes.Quaternion: ...
    def getPreferedAngle(self) -> Tuple[float, float, float]: ...
    def getPreferredAngle(self) -> Tuple[float, float, float]: ...
    def getRadius(self, **kwargs) -> float: ...
    def getScaleCompensate(self, **kwargs) -> bool: ...
    def getScaleOrientation(self) -> datatypes.Quaternion: ...
    def getSegmentScale(self) -> Tuple[float, float, float]: ...
    def getStiffness(self) -> Tuple[float, float, float]: ...
    def getStiffnessX(self, **kwargs) -> float: ...
    def getStiffnessY(self, **kwargs) -> float: ...
    def getStiffnessZ(self, **kwargs) -> float: ...
    def hikJointName(self) -> str: ...
    def orientJoint(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def secondaryAxisOrient(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setAngleX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setAngleY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setAngleZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDegreeOfFreedom(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setDegreesOfFreedom(self, freeInX: bool, freeInY: bool, freeInZ: bool) -> None: ...
    def setLimitSwitchX(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setLimitSwitchY(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setLimitSwitchZ(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setLimitX(self, val: Tuple[float, float] = ..., **kwargs: Any) -> None: ...
    def setLimitY(self, val: Tuple[float, float] = ..., **kwargs: Any) -> None: ...
    def setLimitZ(self, val: Tuple[float, float] = ..., **kwargs: Any) -> None: ...
    def setMaxRotateDampXRange(self, angle: float) -> None: ...
    def setMaxRotateDampXStrength(self, angle: float) -> None: ...
    def setMaxRotateDampYRange(self, angle: float) -> None: ...
    def setMaxRotateDampYStrength(self, angle: float) -> None: ...
    def setMaxRotateDampZRange(self, angle: float) -> None: ...
    def setMaxRotateDampZStrength(self, angle: float) -> None: ...
    def setMinRotateDampXRange(self, angle: float) -> None: ...
    def setMinRotateDampXStrength(self, angle: float) -> None: ...
    def setMinRotateDampYRange(self, angle: float) -> None: ...
    def setMinRotateDampYStrength(self, angle: float) -> None: ...
    def setMinRotateDampZRange(self, angle: float) -> None: ...
    def setMinRotateDampZStrength(self, angle: float) -> None: ...
    def setOrientation(self, quaternion: datatypes.Quaternion) -> None: ...
    def setPreferedAngle(self, rotation: Tuple[float, float, float]) -> None: ...
    def setPreferredAngle(self, rotation: Tuple[float, float, float]) -> None: ...
    def setPreferredAngles(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setScaleCompensate(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setScaleOrientation(self, quaternion: datatypes.Quaternion) -> None: ...
    def setSegmentScale(self, scale: Tuple[float, float, float]) -> None: ...
    def setStiffness(self, stiffness: Tuple[float, float, float]) -> None: ...
    def setStiffnessX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setStiffnessY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setStiffnessZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def symmetry(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def symmetryAxis(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def zeroScaleOrient(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class DynBase(Transform):
    __melnode__: str
    def getRotationQuaternion(self, space: datatypes.Space.Space = ...) -> Tuple[float, float, float, float]: ...
    def setRotationQuaternion(self, x: float, y: float, z: float, w: float, space: datatypes.Space.Space = ...) -> None: ...

class PointEmitter(DynBase):
    __melnode__: str

class FluidEmitter(PointEmitter):
    fluidVoxelInfo: Incomplete
    loadFluid: Incomplete
    resampleFluid: Incomplete
    saveFluid: Incomplete
    setFluidAttr: Incomplete
    getFluidAttr: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCycleEmission(self, **kwargs) -> str: ...
    def getCycleInterval(self, **kwargs) -> int: ...
    def getDensityEmissionRate(self, **kwargs) -> float: ...
    def getFluidDropoff(self, **kwargs) -> float: ...
    def getFuelEmissionRate(self, **kwargs) -> float: ...
    def getHeatEmissionRate(self, **kwargs) -> float: ...
    def getMaxDistance(self, **kwargs) -> float: ...
    def getMinDistance(self, **kwargs) -> float: ...
    def getPosition(self, **kwargs) -> Tuple[float, float, float]: ...
    def getRate(self, **kwargs) -> float: ...
    def getTorusSectionRadius(self, **kwargs) -> float: ...
    def getType(self, **kwargs) -> str: ...
    def getVolumeOffset(self, **kwargs) -> Tuple[float, float, float]: ...
    def getVolumeShape(self, **kwargs) -> str: ...
    def getVolumeSweep(self, **kwargs) -> float: ...
    def setCycleEmission(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setCycleInterval(self, val: int = ..., **kwargs: Any) -> None: ...
    def setDensityEmissionRate(self, val: float = ..., **kwargs: Any) -> None: ...
    def setFluidDropoff(self, val: float = ..., **kwargs: Any) -> None: ...
    def setFuelEmissionRate(self, val: float = ..., **kwargs: Any) -> None: ...
    def setHeatEmissionRate(self, val: float = ..., **kwargs: Any) -> None: ...
    def setMaxDistance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setMinDistance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPosition(self, val: Union[Tuple[float, float, float], List[Tuple[float, float, float]]] = ..., **kwargs: Any) -> None: ...
    def setRate(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTorusSectionRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setType(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setVolumeOffset(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setVolumeShape(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setVolumeSweep(self, val: float = ..., **kwargs: Any) -> None: ...

class RenderLayer(DependNode):
    __melcmdname__: str
    def __new__(cls, *args, **kwargs): ...
    def listMembers(self, fullNames: bool = ...): ...
    def addMembers(self, members, noRecurse: bool = ...) -> None: ...
    def removeMembers(self, members) -> None: ...
    def listAdjustments(self): ...
    def addAdjustments(self, members): ...
    def removeAdjustments(self, members): ...
    def setCurrent(self) -> None: ...
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melnode__: str
    def adjustmentPlug(self, scenePlug: Union[str, general.Attribute]) -> general.Attribute: ...
    @classmethod
    def currentLayer(self) -> DependNode: ...
    @classmethod
    def defaultRenderLayer(self) -> DependNode: ...
    def externalRenderPasses(self) -> List[DependNode]: ...
    @classmethod
    def findLayerByName(self, renderLayer: str) -> DependNode: ...
    def inCurrentRenderLayer(self, objectPath: DagNode) -> bool: ...
    def inLayer(self, transform: Union[str, DependNode]) -> bool: ...
    def isPlugAdjusted(self, scenePlug: Union[str, general.Attribute]) -> bool: ...
    def layerChildren(self, recurse: bool = ...) -> List[DependNode]: ...
    @classmethod
    def listAllRenderLayers(self) -> List[DependNode]: ...
    def passHasLight(self, renderPass: Union[str, DependNode], light: Union[str, DependNode]) -> bool: ...
    def passHasObject(self, renderPass: Union[str, DependNode], objectInstance: DagNode) -> bool: ...

class DisplayLayer(DependNode):
    __melcmdname__: str
    def __new__(cls, *args, **kwargs): ...
    def listMembers(self, fullNames: bool = ...): ...
    def addMembers(self, members, noRecurse: bool = ...) -> None: ...
    def removeMembers(self, members, noRecurse: bool = ...) -> None: ...
    def setCurrent(self) -> None: ...
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class Constraint(Transform):
    def setWeight(self, weight, *targetObjects): ...
    def getWeight(self, *targetObjects): ...
    __melnode__: str
    def getRotationQuaternion(self, space: datatypes.Space.Space = ...) -> Tuple[float, float, float, float]: ...
    def setRotationQuaternion(self, x: float, y: float, z: float, w: float, space: datatypes.Space.Space = ...) -> None: ...

class GeometryShape(Shape):
    def __getattr__(self, attr): ...
    __melnode__: str

class DeformableShape(GeometryShape):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str

class ControlPoint(DeformableShape):
    __melnode__: str

class CurveShape(DeformableShape):
    __melnode__: str

class NurbsCurve(CurveShape):
    u: general.NurbsCurveParameter
    cv: general.NurbsCurveCV
    controlVerts: general.NurbsCurveCV
    ep: general.NurbsCurveEP
    editPoints: general.NurbsCurveEP
    knot: general.NurbsCurveKnot
    knots: general.NurbsCurveKnot
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    Form: Incomplete
    def area(self, tolerance: float = ...) -> float: ...
    def closestPoint(self, toThisPoint: datatypes.Point, param: float = ..., tolerance: float = ..., space: datatypes.Space.Space = ...) -> datatypes.Point: ...
    def copy(self, source: Union[str, DependNode], parentOrOwner: Union[str, DependNode] = ...) -> DependNode: ...
    def createWithEditPoints(self, editPoints: List[datatypes.Point], degree: int, form: NurbsCurve.Form, create2D: bool, createRational: bool, uniformParam: bool, parentOrOwner: Union[str, DependNode] = ...) -> DependNode: ...
    def cvs(self, startIndex: int, endIndex: int) -> DependNode: ...
    def degree(self) -> int: ...
    def distanceToPoint(self, pt: datatypes.Point, space: datatypes.Space.Space = ...) -> float: ...
    def findLengthFromParam(self, param: float) -> float: ...
    def findParamFromLength(self, partLength: float) -> float: ...
    def form(self) -> NurbsCurve.Form: ...
    def getCV(self, index: int, space: datatypes.Space.Space = ...) -> datatypes.Point: ...
    def getCVs(self, space: datatypes.Space.Space = ...) -> List[datatypes.Point]: ...
    def getDerivativesAtParm(self, param: float, space: datatypes.Space.Space) -> Tuple[datatypes.Point, datatypes.Vector, datatypes.Vector]: ...
    def getKnot(self, index: int) -> float: ...
    def getKnotDomain(self) -> Tuple[float, float]: ...
    def getKnots(self) -> List[float]: ...
    def getParamAtPoint(self, atThisPoint: datatypes.Point, space: datatypes.Space.Space = ...) -> float: ...
    def getPointAtParam(self, param: float, space: datatypes.Space.Space = ...) -> datatypes.Point: ...
    def hasHistoryOnCreate(self) -> bool: ...
    def isParamOnCurve(self, param: float) -> bool: ...
    def isPlanar(self, planeNormal: datatypes.Vector = ...) -> bool: ...
    def isPointOnCurve(self, point: datatypes.Point, tolerance: float = ..., space: datatypes.Space.Space = ...) -> bool: ...
    def length(self, tolerance: float = ...) -> float: ...
    def makeMultipleEndKnots(self) -> None: ...
    def normal(self, param: float, space: datatypes.Space.Space = ...) -> datatypes.Vector: ...
    def numKnots(self) -> int: ...
    def numSpans(self) -> int: ...
    def rebuild(self, endKnots: int = ..., keepEndPoints: bool = ..., keepTangents: bool = ..., keepControlPoints: bool = ..., tolerance: float = ...) -> Tuple[DependNode, int, int, int]: ...
    def removeKnot(self, atThisParam: float, removeAll: bool = ...) -> None: ...
    def reverse(self, constructionHistory: bool = ...) -> None: ...
    def setCV(self, index: int, pt: datatypes.Point, space: datatypes.Space.Space = ...) -> None: ...
    def setCVs(self, array: List[datatypes.Point], space: datatypes.Space.Space = ...) -> None: ...
    def setKnot(self, index: int, param: float) -> None: ...
    def setKnots(self, array: List[float], startIndex: int, endIndex: int) -> None: ...
    def tangent(self, param: float, space: datatypes.Space.Space = ...) -> datatypes.Vector: ...
    def updateCurve(self) -> None: ...

class SurfaceShape(ControlPoint):
    __melnode__: str

class NurbsSurface(SurfaceShape):
    u: general.NurbsSurfaceRange
    uIsoparm: general.NurbsSurfaceRange
    v: general.NurbsSurfaceRange
    vIsoparm: general.NurbsSurfaceRange
    uv: general.NurbsSurfaceRange
    cv: general.NurbsSurfaceCV
    controlVerts: general.NurbsSurfaceCV
    ep: general.NurbsSurfaceEP
    editPoints: general.NurbsSurfaceEP
    knot: general.NurbsSurfaceKnot
    knots: general.NurbsSurfaceKnot
    sf: general.NurbsSurfaceFace
    faces: general.NurbsSurfaceFace
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    BoundaryType: Incomplete
    Form: Incomplete
    def area(self, tolerance: float = ...) -> float: ...
    def assignUV(self, patchId: int, cornerIndex: int, uvId: int) -> None: ...
    def assignUVs(self, uvCounts: List[int], uvIds: List[int]) -> None: ...
    def boundaryType(self, region: int, boundary: int) -> NurbsSurface.BoundaryType: ...
    def clearUVs(self) -> None: ...
    def closestPoint(self, toThisPoint: datatypes.Point, ignoreTrimBoundaries: bool = ..., tolerance: float = ..., space: datatypes.Space.Space = ...) -> Tuple[datatypes.Point, float, float]: ...
    def copy(self, source: Union[str, DependNode], parentOrOwner: Union[str, DependNode] = ...) -> DependNode: ...
    def cvsInU(self, startIndex: int, endIndex: int, rowIndex: int) -> DependNode: ...
    def cvsInV(self, startIndex: int, endIndex: int, rowIndex: int) -> DependNode: ...
    def degreeU(self) -> int: ...
    def degreeV(self) -> int: ...
    def distanceToPoint(self, pt: datatypes.Point, space: datatypes.Space.Space = ...) -> float: ...
    def edge(self, region: int, boundary: int, edge: int, paramEdge: bool = ...) -> List[DependNode]: ...
    def formInU(self) -> NurbsSurface.Form: ...
    def formInV(self) -> NurbsSurface.Form: ...
    def getAssignedUVs(self) -> Tuple[List[int], List[int]]: ...
    def getCV(self, indexU: int, indexV: int, space: datatypes.Space.Space = ...) -> datatypes.Point: ...
    def getCVs(self, space: datatypes.Space.Space = ...) -> List[datatypes.Point]: ...
    def getConnectedShaders(self, instanceNumber: int) -> Tuple[List[DependNode], List[int]]: ...
    def getDataObject(self) -> DependNode: ...
    def getDerivativesAtParm(self, paramInU: float, paramInV: float, space: datatypes.Space.Space) -> Tuple[datatypes.Point, datatypes.Vector, datatypes.Vector, datatypes.Vector, datatypes.Vector, datatypes.Vector]: ...
    def getKnotDomain(self) -> Tuple[float, float, float, float]: ...
    def getKnotInU(self, index: int) -> float: ...
    def getKnotInV(self, index: int) -> float: ...
    def getKnotsInU(self) -> List[float]: ...
    def getKnotsInV(self) -> List[float]: ...
    def getParamAtPoint(self, atThisPoint: datatypes.Point, space: datatypes.Space.Space = ...) -> Tuple[float, float]: ...
    def getPatchUV(self, patchId: int, cornerIndex: int) -> Tuple[float, float]: ...
    def getPatchUVid(self, patchId: int, cornerIndex: int) -> int: ...
    def getPatchUVs(self, patchId: int) -> Tuple[List[float], List[float]]: ...
    def getPointAtParam(self, paramU: float, paramV: float, space: datatypes.Space.Space = ...) -> datatypes.Point: ...
    def getTangents(self, paramInU: float, paramInV: float, space: datatypes.Space.Space = ...) -> Tuple[datatypes.Vector, datatypes.Vector]: ...
    def hasHistoryOnCreate(self) -> bool: ...
    def intersect(self, rayStartingPoint: datatypes.Point, alongThisDirection: datatypes.Vector, tolerance: float = ..., space: datatypes.Space.Space = ..., calculateDistance: bool = ..., calculateExactHit: bool = ...) -> Tuple[bool, float, float, datatypes.Point, float, bool]: ...
    def isBezier(self) -> bool: ...
    def isFlipNorm(self, region: int) -> bool: ...
    def isFoldedOnBispan(self) -> bool: ...
    def isKnotU(self, param: float) -> bool: ...
    def isKnotV(self, param: float) -> bool: ...
    def isParamOnSurface(self, paramU: float, paramV: float) -> bool: ...
    def isPointInTrimmedRegion(self, u: float, v: float) -> bool: ...
    def isPointOnSurface(self, point: datatypes.Point, tolerance: float = ..., space: datatypes.Space.Space = ...) -> bool: ...
    def isTrimmedSurface(self) -> bool: ...
    def isUniform(self) -> bool: ...
    def normal(self, paramInU: float, paramInV: float, space: datatypes.Space.Space = ...) -> datatypes.Vector: ...
    def numBoundaries(self, region: int) -> int: ...
    def numEdges(self, region: int, boundary: int) -> int: ...
    def numKnotsInU(self) -> int: ...
    def numKnotsInV(self) -> int: ...
    def numNonZeroSpansInU(self) -> int: ...
    def numNonZeroSpansInV(self) -> int: ...
    def numPatches(self) -> int: ...
    def numPatchesInU(self) -> int: ...
    def numPatchesInV(self) -> int: ...
    def numRegions(self) -> int: ...
    def numSpansInU(self) -> int: ...
    def numSpansInV(self) -> int: ...
    def numUVs(self) -> int: ...
    def projectCurve(self, curve: DagNode, direction: datatypes.Vector = ..., constructionHistory: bool = ...) -> None: ...
    def removeKnotInU(self, atThisParam: float, removeAll: bool = ...) -> None: ...
    def removeKnotInV(self, atThisParam: float, removeAll: bool = ...) -> None: ...
    def removeOneKnotInU(self, atThisParam: float) -> None: ...
    def removeOneKnotInV(self, atThisParam: float) -> None: ...
    def setCV(self, indexU: int, indexV: int, pt: datatypes.Point, space: datatypes.Space.Space = ...) -> None: ...
    def setCVs(self, array: List[datatypes.Point], space: datatypes.Space.Space = ...) -> None: ...
    def setKnotInU(self, index: int, param: float) -> None: ...
    def setKnotInV(self, index: int, param: float) -> None: ...
    def setKnotsInU(self, array: List[float], startIndex: int, endIndex: int) -> None: ...
    def setKnotsInV(self, array: List[float], startIndex: int, endIndex: int) -> None: ...
    def tesselate(self, parms: datatypes.TesselationParams = ..., parentOrOwner: Union[str, DependNode] = ...) -> DependNode: ...
    def trim(self, locatorU: List[float], locatorV: List[float], constructionHistory: bool = ...) -> None: ...
    def updateSurface(self) -> None: ...

class Mesh(SurfaceShape):
    vtx: general.MeshVertex
    verts: general.MeshVertex
    e: general.MeshEdge
    edges: general.MeshEdge
    f: general.MeshFace
    faces: general.MeshFace
    map: general.MeshUV
    uvs: general.MeshUV
    vtxFace: general.MeshVertexFace
    faceVerts: general.MeshVertexFace
    numVertices: Incomplete
    numEdges: Incomplete
    numFaces: Incomplete
    numTriangles: Incomplete
    numSelectedTriangles: Incomplete
    numSelectedFaces: Incomplete
    numSelectedEdges: Incomplete
    numSelectedVertices: Incomplete
    area: Incomplete
    worldArea: Incomplete
    def getUVAtPoint(self, uvPoint, space=..., uvSet: Incomplete | None = ..., returnClosestPolygon: bool = ...): ...
    def getCurrentUVSetName(self): ...
    def getCurrentColorSetName(self): ...
    def getVertexColors(self, colorSet: Incomplete | None = ..., defaultUnsetColor: Incomplete | None = ...): ...
    def numColors(self, colorSet: Incomplete | None = ...): ...
    __apicls__: Incomplete
    __melnode__: str
    BoolClassification: Incomplete
    BoolOperation: Incomplete
    BorderInfo: Incomplete
    MColorRepresentation: Incomplete
    SplitPlacement: Incomplete
    def addHoles(self, faceIndex: int, vertexArray: List[datatypes.Point], loopCounts: List[int], mergeVertices: bool = ..., pointTolerance: float = ...) -> None: ...
    def assignColor(self, polygonId: int, vertexIndex: int, colorId: int, colorSet: str = ...) -> None: ...
    def assignColors(self, colorIds: List[int], colorSet: str = ...) -> None: ...
    def assignUV(self, polygonId: int, vertexIndex: int, uvId: int, uvSet: str = ...) -> None: ...
    def assignUVs(self, uvCounts: List[int], uvIds: List[int], uvSet: str = ...) -> None: ...
    def booleanOps(self, op: Mesh.BoolOperation, meshes: List[Union[str, DependNode]], classification: Mesh.BoolClassification = ...) -> bool: ...
    def cleanupEdgeSmoothing(self) -> None: ...
    def clearColors(self, colorSet: str = ...) -> None: ...
    def clearUVs(self, uvSet: str = ...) -> None: ...
    @classmethod
    def componentTypeFromName(self, assocName: str) -> datatypes.Fn.Type: ...
    @classmethod
    def componentTypeName(self, compType: datatypes.Fn.Type) -> str: ...
    def createColorSetDataMesh(self, colorSetName: str, clamped: bool = ..., rep: Mesh.MColorRepresentation = ...) -> None: ...
    def createColorSetWithName(self, colorSetName: str, modifier: datatypes.DGModifier = ..., instances: datatypes.UintArray = ...) -> str: ...
    createColorSet = createColorSetWithName
    def createColorSetWithNameDataMesh(self, colorSetName: str, clamped: bool, rep: Mesh.MColorRepresentation) -> str: ...
    def createUVSetDataMeshWithName(self, uvSetName: str) -> str: ...
    def createUVSetWithName(self, uvSetName: str, modifier: datatypes.DGModifier = ..., instances: datatypes.UintArray = ...) -> str: ...
    createUVSet = createUVSetWithName
    def deleteColorSet(self, colorSetName: str, modifier: datatypes.DGModifier = ..., currentSelection: SelectionSet = ...) -> None: ...
    def deleteUVSet(self, setName: str, modifier: datatypes.DGModifier = ..., currentSelection: SelectionSet = ...) -> None: ...
    def edgeBorderInfo(self, edgeId: int) -> Tuple[Mesh.BorderInfo, int]: ...
    def getAssignedUVs(self, uvSet: str = ...) -> Tuple[List[int], List[int]]: ...
    def getAssociatedColorSetInstances(self, colorSetName: str) -> List[int]: ...
    def getAssociatedUVSetInstances(self, uvSetName: str) -> List[int]: ...
    def getAssociatedUVSetTextures(self, uvSetName: str) -> List[DependNode]: ...
    def getAxisAtPoint(self, pt: datatypes.Point, space: datatypes.Space.Space = ..., uvSet: str = ...) -> Tuple[datatypes.Vector, datatypes.Vector, datatypes.Vector, int]: ...
    def getBinormals(self, space: datatypes.Space.Space = ..., uvSet: str = ...) -> List[datatypes.FloatVector]: ...
    def getCheckSamePointTwice(self) -> bool: ...
    def getClosestNormal(self, toThisPoint: datatypes.Point, space: datatypes.Space.Space = ..., accelParams: datatypes.MeshIsectAccelParams = ...) -> Tuple[datatypes.Vector, int]: ...
    def getClosestPoint(self, toThisPoint: datatypes.Point, space: datatypes.Space.Space = ..., accelParams: datatypes.MeshIsectAccelParams = ...) -> Tuple[datatypes.Point, int]: ...
    def getClosestPointAndNormal(self, toThisPoint: datatypes.Point, space: datatypes.Space.Space = ..., accelParams: datatypes.MeshIsectAccelParams = ...) -> Tuple[datatypes.Point, datatypes.Vector, int]: ...
    def getClosestUVs(self, toThisUVPoint: Tuple[float, float], uvSet: str = ...) -> List[int]: ...
    def getColor(self, colorId: int, colorSet: str = ..., defaultUnsetColor: datatypes.Color = ...) -> datatypes.Color: ...
    def getColorRepresentation(self, colorSet: str) -> Mesh.MColorRepresentation: ...
    def getColorSetFamilyNames(self) -> List[str]: ...
    def getColorSetNames(self) -> List[str]: ...
    def getColors(self, colorSet: str = ..., defaultUnsetColor: datatypes.Color = ...) -> List[datatypes.Color]: ...
    def getDisplayColors(self) -> bool: ...
    def getEdgeVertices(self, edgeId: int) -> Tuple[int, int]: ...
    def getFaceNormalIds(self, faceIndex: int) -> List[int]: ...
    def getFaceUVSetNames(self, polygonId: int) -> List[str]: ...
    def getFaceVertexBinormal(self, faceIndex: int, vertexIndex: int, space: datatypes.Space.Space = ..., uvSet: str = ...) -> datatypes.Vector: ...
    def getFaceVertexBinormals(self, faceIndex: int, space: datatypes.Space.Space = ..., uvSet: str = ...) -> List[datatypes.FloatVector]: ...
    def getFaceVertexColorIndex(self, faceIndex: int, localVertexIndex: int, colorSet: str = ...) -> int: ...
    def getFaceVertexColors(self, colorSet: str = ..., defaultUnsetColor: datatypes.Color = ...) -> List[datatypes.Color]: ...
    def getFaceVertexNormal(self, faceIndex: int, vertexIndex: int, space: datatypes.Space.Space = ...) -> datatypes.Vector: ...
    def getFaceVertexNormals(self, faceIndex: int, space: datatypes.Space.Space = ...) -> List[datatypes.FloatVector]: ...
    def getFaceVertexTangent(self, faceIndex: int, vertexIndex: int, space: datatypes.Space.Space = ..., uvSet: str = ...) -> datatypes.Vector: ...
    def getFaceVertexTangents(self, faceIndex: int, space: datatypes.Space.Space = ..., uvSet: str = ...) -> List[datatypes.FloatVector]: ...
    def getHoles(self) -> Tuple[int, List[int], List[int]]: ...
    def getMeshShellsIds(self, compType: datatypes.Fn.Type) -> Tuple[List[int], int]: ...
    def getNormalIds(self) -> Tuple[List[int], List[int]]: ...
    def getNormals(self, space: datatypes.Space.Space = ...) -> List[datatypes.FloatVector]: ...
    def getPoint(self, vertexId: int, space: datatypes.Space.Space = ...) -> datatypes.Point: ...
    def getPointAtUV(self, polygonId: int, uvPoint: Tuple[float, float], space: datatypes.Space.Space = ..., uvSet: str = ..., tolerance: float = ...) -> datatypes.Point: ...
    def getPoints(self, space: datatypes.Space.Space = ...) -> List[datatypes.Point]: ...
    def getPointsAtUV(self, uvPoint: Tuple[float, float], space: datatypes.Space.Space = ..., uvSet: str = ..., tolerance: float = ...) -> Tuple[List[int], List[datatypes.Point]]: ...
    def getPolygonNormal(self, polygonId: int, space: datatypes.Space.Space = ...) -> datatypes.Vector: ...
    def getPolygonTriangleVertices(self, polygonId: int, triangleId: int) -> Tuple[int, int, int]: ...
    def getPolygonUV(self, polygonId: int, vertexIndex: int, uvSet: str = ...) -> Tuple[float, float]: ...
    def getPolygonUVid(self, polygonId: int, vertexIndex: int, uvSet: str = ...) -> int: ...
    def getPolygonVertices(self, polygonId: int) -> List[int]: ...
    def getRawUVs(self, uvSet: str = ...) -> float: ...
    def getTangentId(self, faceIndex: int, vertexIndex: int) -> int: ...
    def getTangents(self, space: datatypes.Space.Space = ..., uvSet: str = ...) -> List[datatypes.FloatVector]: ...
    def getTriangleOffsets(self) -> Tuple[List[int], List[int]]: ...
    def getTriangles(self) -> Tuple[List[int], List[int]]: ...
    def getUV(self, uvId: int, uvSet: str = ...) -> Tuple[float, float]: ...
    def getUVBorderEdges(self, setId: int) -> List[int]: ...
    def getUVSetFamilyNames(self) -> List[str]: ...
    def getUVSetNames(self) -> List[str]: ...
    def getUVSetsInFamily(self, familyName: str) -> List[str]: ...
    def getUVs(self, uvSet: str = ...) -> Tuple[List[float], List[float]]: ...
    def getUvShellsIds(self, uvSet: str = ...) -> Tuple[List[int], int]: ...
    def getVertexNormal(self, vertexId: int, angleWeighted: bool, space: datatypes.Space.Space = ...) -> datatypes.Vector: ...
    def getVertexNormals(self, angleWeighted: bool, space: datatypes.Space.Space = ...) -> List[datatypes.FloatVector]: ...
    def getVertices(self) -> Tuple[List[int], List[int]]: ...
    def hasAlphaChannels(self, colorSet: str) -> bool: ...
    def hasColorChannels(self, colorSet: str) -> bool: ...
    def intersect(self, raySource: datatypes.Point, rayDirection: datatypes.Vector, tolerance: float = ..., space: datatypes.Space.Space = ...) -> Tuple[bool, List[datatypes.Point], List[int]]: ...
    def intersectFaceAtUV(self, toThisUVPoint: Tuple[float, float], uvSet: str = ...) -> int: ...
    def isColorClamped(self, colorSet: str) -> bool: ...
    def isColorSetPerInstance(self, name: str) -> bool: ...
    def isEdgeSmooth(self, edgeId: int) -> bool: ...
    def isNormalLocked(self, normalId: int) -> bool: ...
    def isPolygonConvex(self, faceIndex: int) -> bool: ...
    def isPolygonUVReversed(self, polygonId: int, uvSet: str = ...) -> bool: ...
    def isRightHandedTangent(self, tangentId: int, uvSetName: str = ...) -> bool: ...
    def isUVSetPerInstance(self, name: str) -> bool: ...
    def lockFaceVertexNormals(self, faceList: List[int], vertexList: List[int]) -> None: ...
    def lockVertexNormals(self, vertexList: List[int]) -> None: ...
    def numPolygons(self) -> int: ...
    def onBoundary(self, polygonId: int) -> bool: ...
    @classmethod
    def polyTriangulate(self, pointsAndHoles: float, pointsCount: int, outerPointsCount: int, holesCount: int, considerNormal: bool, normals: float) -> Tuple[int, int]: ...
    def polygonVertexCount(self, polygonId: int) -> int: ...
    numPolygonVertices = polygonVertexCount
    def removeFaceColors(self, faceList: List[int]) -> None: ...
    def removeFaceVertexColors(self, faceList: List[int], vertexList: List[int]) -> None: ...
    def removeVertexColors(self, vertexList: List[int]) -> None: ...
    def renameUVSet(self, origName: str, newName: str, modifier: datatypes.DGModifier = ...) -> None: ...
    def setCheckSamePointTwice(self, check: bool = ...) -> None: ...
    def setColor(self, colorId: int, color: datatypes.Color, colorSet: str = ...) -> None: ...
    def setColorClamped(self, colorSet: str, clamped: bool) -> None: ...
    def setColors(self, colorArray: List[datatypes.Color], colorSet: str = ...) -> None: ...
    def setCurrentColorSetName(self, setName: str, modifier: datatypes.DGModifier = ..., currentSelection: SelectionSet = ...) -> None: ...
    def setCurrentUVSetName(self, setName: str, modifier: datatypes.DGModifier = ..., currentSelection: SelectionSet = ...) -> None: ...
    def setDisplayColors(self, enable: bool) -> None: ...
    def setEdgeSmoothing(self, edgeId: int, smooth: bool = ...) -> None: ...
    def setEdgeSmoothings(self, edgeIds: List[int], smooths: List[int]) -> None: ...
    def setFaceColor(self, color: datatypes.Color, faceIndex: int) -> None: ...
    def setFaceColors(self, colors: List[datatypes.Color], faceList: List[int]) -> None: ...
    def setFaceVertexColor(self, color: datatypes.Color, faceIndex: int, vertexIndex: int, modifier: datatypes.DGModifier = ...) -> None: ...
    def setFaceVertexNormal(self, normalIn: datatypes.Vector, faceId: int, vertexId: int, space: datatypes.Space.Space = ..., modifier: datatypes.DGModifier = ...) -> None: ...
    def setNormals(self, normals: List[datatypes.FloatVector], space: datatypes.Space.Space = ...) -> None: ...
    def setPoint(self, vertexId: int, pos: datatypes.Point, space: datatypes.Space.Space = ...) -> None: ...
    def setPoints(self, vertexArray: List[datatypes.Point], space: datatypes.Space.Space = ...) -> None: ...
    def setSomeColors(self, colorIds: List[int], colorArray: List[datatypes.Color], colorSet: str = ...) -> None: ...
    def setSomeUVs(self, uvIds: List[int], uArray: List[float], vArray: List[float], uvSet: str = ...) -> None: ...
    def setUV(self, uvId: int, u: float, v: float, uvSet: str = ...) -> None: ...
    def setUVs(self, uArray: List[float], vArray: List[float], uvSet: str = ...) -> None: ...
    def setVertexColor(self, color: datatypes.Color, vertexIndex: int, modifier: datatypes.DGModifier = ...) -> None: ...
    def setVertexNormal(self, normalIn: datatypes.Vector, vertexId: int, space: datatypes.Space.Space = ..., modifier: datatypes.DGModifier = ...) -> None: ...
    def syncObject(self) -> None: ...
    def unlockFaceVertexNormals(self, faceList: List[int], vertexList: List[int]) -> None: ...
    def unlockVertexNormals(self, vertexList: List[int]) -> None: ...
    def updateSurface(self) -> None: ...

class Subdiv(SurfaceShape):
    smp: general.SubdVertex
    verts: general.SubdVertex
    sme: general.SubdEdge
    edges: general.SubdEdge
    smf: general.SubdFace
    faces: general.SubdFace
    smm: general.SubdUV
    uvs: general.SubdUV
    def getTweakedVerts(self, **kwargs): ...
    def getSharpenedVerts(self, **kwargs): ...
    def getSharpenedEdges(self, **kwargs): ...
    def getEdges(self, **kwargs): ...
    def cleanTopology(self) -> None: ...
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def collapse(self, level: int, makeNewNodeInvisible: bool) -> DependNode: ...
    def convertToNurbs(self) -> List[DependNode]: ...
    def copy(self, source: Union[str, DependNode], parentOrOwner: Union[str, DependNode] = ...) -> DependNode: ...
    def creasesClearAll(self) -> None: ...
    def createBaseMesh(self, reverseNormal: bool, numVertices: int, numPolygons: int, vertexArray: List[datatypes.Point], polygonCounts: List[int], polygonConnects: List[int], parentOrOwner: Union[str, DependNode] = ...) -> DependNode: ...
    def editsPending(self) -> int: ...
    def editsUpdateAll(self) -> None: ...
    def getCurrentLevel(self, **kwargs) -> Any: ...
    def getCurrentSubdLevel(self, **kwargs) -> Any: ...
    def getDeepestLevel(self, **kwargs) -> Any: ...
    def getDisplayLoad(self, **kwargs) -> Any: ...
    def getEdgeStats(self, **kwargs) -> Any: ...
    def getFaceStats(self, **kwargs) -> Any: ...
    def getMaxPossibleLevel(self, **kwargs) -> Any: ...
    def getProxyMode(self, **kwargs) -> Any: ...
    def getSmallOffsets(self, **kwargs) -> Any: ...
    def levelFullySubdivideTo(self, level: int) -> None: ...
    def levelMaxAllowed(self) -> int: ...
    def levelMaxCurrent(self) -> int: ...
    def numEdges(self, level: int = ...) -> int: ...
    def numFaces(self, level: int = ...) -> int: ...
    def numVertices(self, level: int = ...) -> int: ...
    def polygonCountMaxWithGivenBaseMesh(self, level: int = ...) -> int: ...
    def tesselate(self, uniform: bool, depth: int, sample: int, parentOrOwner: Union[str, DependNode] = ...) -> DependNode: ...
    def tessellateViaNurbs(self, parentOrOwner: Union[str, DependNode] = ...) -> DependNode: ...
    def updateAllEditsAndCreases(self) -> None: ...
    def updateSubdSurface(self) -> None: ...
    def vertexBaseMeshAdd(self, x: float, y: float, z: float) -> int: ...
    def vertexBaseMeshAddWithIndex(self, x: float, y: float, z: float, index: int) -> None: ...
    def vertexBaseMeshGet(self, space: datatypes.Space.Space = ...) -> List[datatypes.Point]: ...
    def vertexBaseMeshSet(self, space: datatypes.Space.Space = ...) -> List[datatypes.Point]: ...
    def vertexEditsClearAllNonBase(self) -> None: ...

class Lattice(ControlPoint):
    pt: general.LatticePoint
    points: general.LatticePoint
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def after(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def afterReference(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def before(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def frontOfChain(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getDeformerTools(self, **kwargs) -> Any: ...
    def getDivisions(self) -> Tuple[int, int, int]: ...
    def getExclusive(self, **kwargs) -> Any: ...
    def getFreezeMapping(self, **kwargs) -> bool: ...
    def getGeometry(self, **kwargs) -> str: ...
    def getGeometryIndices(self, **kwargs) -> Any: ...
    def getLdivisions(self, **kwargs) -> Tuple[int, int, int]: ...
    def getUseComponentTags(self, **kwargs) -> Any: ...
    def latticeReset(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def parallel(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def point(self, s: int, t: int, u: int) -> datatypes.Point: ...
    def prune(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int, List[Union[bool, int]]] = ..., **kwargs: Any) -> None: ...
    def removeTweaks(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def reset(self, sSize: float = ..., tSize: float = ..., uSize: float = ...) -> None: ...
    def setDivisions(self, s: int, t: int, u: int) -> None: ...
    def setFreezeMapping(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setGeometry(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def setLdivisions(self, val: Tuple[int, int, int] = ..., **kwargs: Any) -> None: ...

class Particle(DeformableShape):
    __apicls__: Incomplete
    pt: general.ParticleComponent
    points: general.ParticleComponent
    Point = general.ParticleComponent
    def pointCount(self): ...
    num = pointCount
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    RenderType: Incomplete
    def acceleration(self) -> List[datatypes.Vector]: ...
    def age(self, ages: List[float]) -> None: ...
    def betterIllum(self) -> bool: ...
    def castsShadows(self) -> bool: ...
    def deformedParticleShape(self) -> DependNode: ...
    def disableCloudAxis(self) -> bool: ...
    def emission(self, emissions: List[datatypes.Vector]) -> None: ...
    def emit(self, v: datatypes.Point) -> None: ...
    def evaluateDynamics(self, to: datatypes.Time, runupFromStart: bool) -> None: ...
    def flatShaded(self) -> bool: ...
    def floatValue(self, val: float = ..., **kwargs: Any) -> None: ...
    def getAttribute(self, **kwargs) -> str: ...
    def getCache(self, **kwargs) -> bool: ...
    def getConserve(self, **kwargs) -> float: ...
    def getCount(self) -> int: ...
    def getDynamicAttrList(self, **kwargs) -> Any: ...
    def getGridSpacing(self, **kwargs) -> Any: ...
    def getInherit(self, **kwargs) -> float: ...
    def getJitterBasePoint(self, **kwargs) -> Any: ...
    def getJitterRadius(self, **kwargs) -> Any: ...
    def getLowerLeft(self, **kwargs) -> Any: ...
    def getNumJitters(self, **kwargs) -> Any: ...
    def getOrder(self, **kwargs) -> int: ...
    def getParticleId(self, **kwargs) -> int: ...
    def getPerParticleAttribute(self, attrName: str) -> Tuple[int, List[int]]: ...
    def getPerParticleDouble(self, **kwargs) -> Any: ...
    def getPerParticleVector(self, **kwargs) -> Any: ...
    def getShapeName(self, **kwargs) -> str: ...
    def getUpperRight(self, **kwargs) -> Any: ...
    def hasEmission(self) -> bool: ...
    def hasLifespan(self) -> bool: ...
    def hasOpacity(self) -> bool: ...
    def hasRgb(self) -> bool: ...
    def isDeformedParticleShape(self) -> bool: ...
    def isPerParticleDoubleAttribute(self, attrName: str) -> bool: ...
    def isPerParticleIntAttribute(self, attrName: str) -> bool: ...
    def isPerParticleVectorAttribute(self, attrName: str) -> bool: ...
    def isValid(self) -> bool: ...
    def lifespan(self, lifespans: List[float]) -> None: ...
    def mass(self) -> List[float]: ...
    def opacity(self, opacities: List[float]) -> None: ...
    def originalParticleShape(self) -> DependNode: ...
    def particleIds(self) -> List[int]: ...
    def particleName(self) -> str: ...
    def position(self, positions: List[datatypes.Vector]) -> None: ...
    def position0(self, positions: List[datatypes.Vector]) -> None: ...
    def position1(self, positions: List[datatypes.Vector]) -> None: ...
    def primaryVisibility(self) -> bool: ...
    def radius(self, radii: List[float]) -> None: ...
    def radius0(self, radii: List[float]) -> None: ...
    def radius1(self, radii: List[float]) -> None: ...
    def receiveShadows(self) -> bool: ...
    def renderType(self) -> ParticleSystem.RenderType: ...
    def rgb(self, colors: List[datatypes.Vector]) -> None: ...
    def saveInitialState(self) -> None: ...
    def setAttribute(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setCache(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setConserve(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCount(self, count: int) -> None: ...
    def setInherit(self, val: float = ..., **kwargs: Any) -> None: ...
    def setOrder(self, val: int = ..., **kwargs: Any) -> None: ...
    def setParticleId(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPerParticleAttribute(self, attrName: str, array: List[datatypes.Vector]) -> None: ...
    def setShapeName(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def surfaceShading(self) -> float: ...
    def tailSize(self) -> float: ...
    def threshold(self) -> float: ...
    def vectorValue(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def velocity(self) -> List[datatypes.Vector]: ...
    def visibleInReflections(self) -> bool: ...
    def visibleInRefractions(self) -> bool: ...

class SelectionSet:
    apicls: Incomplete
    def __init__(self, objs: Union[_api.MSelectionList, SelectionSet, ObjectSet]) -> None: ...
    def __melobject__(self): ...
    def __len__(self) -> int: ...
    def __contains__(self, item: Any) -> bool: ...
    def __getitem__(self, index: Any) -> general.SelectableTypes: ...
    def __setitem__(self, index, item): ...
    def __and__(self, s): ...
    def __iand__(self, s): ...
    def __or__(self, s): ...
    def __ior__(self, s): ...
    def __lt__(self, s): ...
    def __gt__(self, s): ...
    def __sub__(self, s): ...
    def __isub__(self, s): ...
    def __xor__(self, s): ...
    def __ixor__(self, s): ...
    def add(self, item): ...
    def pop(self, index: int) -> general.SelectableTypes: ...
    def isSubSet(self, other: Any) -> bool: ...
    def isSuperSet(self, other: Any, flatten: Any = ...) -> bool: ...
    def getIntersection(self, other: Any) -> SelectionSet: ...
    def intersection(self, other: Any) -> None: ...
    def getDifference(self, other: Any) -> SelectionSet: ...
    def difference(self, other: Any) -> None: ...
    def getUnion(self, other: Any) -> SelectionSet: ...
    def union(self, other: Any) -> None: ...
    def getSymmetricDifference(self, other: Any) -> SelectionSet: ...
    def symmetricDifference(self, other: Any) -> None: ...
    def asObjectSet(self): ...
    MergeStrategy: Incomplete
    def clear(self) -> None: ...
    def getSelectionStrings(self) -> List[str]: ...
    def intersect(self, other: SelectionSet, expandToLeaves: bool = ...) -> None: ...
    def isEmpty(self) -> bool: ...
    def removeAtIndex(self, index: int) -> None: ...

class ObjectSet(Entity):
    def __contains__(self, item: Any) -> bool: ...
    def __getitem__(self, index): ...
    def __len__(self) -> int: ...
    def __and__(self, s: Union[str, ObjectSet]) -> SelectionSet: ...
    def __iand__(self, s: Union[str, ObjectSet]) -> SelectionSet: ...
    def __or__(self, s: Union[str, ObjectSet]) -> SelectionSet: ...
    def __ior__(self, s: Union[str, ObjectSet]) -> SelectionSet: ...
    def __sub__(self, s): ...
    def __isub__(self, s): ...
    def __xor__(self, s): ...
    def __ixor__(self, s): ...
    def forceElement(self, member) -> None: ...
    def members(self, flatten: Any = ...) -> List[general.SelectableTypes]: ...
    def elements(self, flatten: bool = ...) -> List[general.SelectableTypes]: ...
    def flattened(self) -> List[general.SelectableTypes]: ...
    def resetTo(self, newContents) -> None: ...
    def add(self, item): ...
    addMember = add
    def remove(self, item): ...
    removeMember = remove
    def isSubSet(self, other: Union[str, ObjectSet]) -> bool: ...
    def isSuperSet(self, other: Union[str, ObjectSet]) -> bool: ...
    def isEqual(self, other: Union[str, ObjectSet]) -> bool: ...
    def getDifference(self, other: Union[str, ObjectSet]) -> SelectionSet: ...
    def difference(self, other: Union[str, ObjectSet]) -> None: ...
    def getSymmetricDifference(self, other: Union[str, ObjectSet]) -> SelectionSet: ...
    def symmetricDifference(self, other) -> None: ...
    def getIntersection(self, other: Union[str, ObjectSet]) -> SelectionSet: ...
    def intersection(self, other: Union[str, ObjectSet]) -> None: ...
    def getUnion(self, other: Union[str, ObjectSet]) -> SelectionSet: ...
    def union(self, other: Union[str, ObjectSet]) -> None: ...
    def isRenderable(self): ...
    __apicls__: Incomplete
    __melnode__: str
    Restriction: Incomplete
    def addMembers(self, list: SelectionSet) -> None: ...
    def asSelectionSet(self, flatten: bool = ...) -> SelectionSet: ...
    def clear(self) -> None: ...
    def getAnnotation(self) -> str: ...
    def getMemberPaths(self, shading: bool = ...) -> List[DagNode]: ...
    def hasRestrictions(self) -> bool: ...
    def intersectsWith(self, otherSet: Union[str, DependNode]) -> bool: ...
    def isMember(self, object: Union[str, DependNode]) -> bool: ...
    def removeMembers(self, list: SelectionSet) -> None: ...
    def restriction(self) -> Set.Restriction: ...
    def setAnnotation(self, annotation: str) -> None: ...

class ShadingEngine(ObjectSet):
    __melnode__: str

class AnimLayer(ObjectSet):
    def getAttribute(self): ...
    getAttributes = getAttribute
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def copy(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def copyAnimation(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def copyNoAnimation(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def extractAnimation(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def getAddRelatedKG(self, **kwargs) -> bool: ...
    def getAddSelectedObjects(self, **kwargs) -> bool: ...
    def getAffectedLayers(self, **kwargs) -> Any: ...
    def getAnimCurves(self, **kwargs) -> bool: ...
    def getBaseAnimCurves(self, **kwargs) -> bool: ...
    def getBestAnimLayer(self, **kwargs) -> bool: ...
    def getBestLayer(self, **kwargs) -> Any: ...
    def getBlendNodes(self, **kwargs) -> bool: ...
    def getChildren(self, **kwargs) -> Any: ...
    def getCollapse(self, **kwargs) -> bool: ...
    def getExcludeBoolean(self, **kwargs) -> bool: ...
    def getExcludeDynamic(self, **kwargs) -> bool: ...
    def getExcludeEnum(self, **kwargs) -> bool: ...
    def getExcludeRotate(self, **kwargs) -> bool: ...
    def getExcludeScale(self, **kwargs) -> bool: ...
    def getExcludeTranslate(self, **kwargs) -> bool: ...
    def getExcludeVisibility(self, **kwargs) -> bool: ...
    def getExists(self, **kwargs) -> Any: ...
    def getFindCurveForPlug(self, **kwargs) -> str: ...
    def getLayeredPlug(self, **kwargs) -> Any: ...
    def getLock(self, **kwargs) -> bool: ...
    def getMaxLayers(self, **kwargs) -> Any: ...
    def getMute(self, **kwargs) -> bool: ...
    def getOverride(self, **kwargs) -> bool: ...
    def getParent(self, **kwargs) -> str: ...
    def getPassthrough(self, **kwargs) -> bool: ...
    def getPreferred(self, **kwargs) -> bool: ...
    def getRoot(self, **kwargs) -> Any: ...
    def getSelected(self, **kwargs) -> bool: ...
    def getSolo(self, **kwargs) -> bool: ...
    def getWeight(self, **kwargs) -> float: ...
    def moveLayerAfter(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def moveLayerBefore(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def removeAllAttributes(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setAddRelatedKG(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setAddSelectedObjects(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setAnimCurves(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setAttribute(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def setBaseAnimCurves(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setBestAnimLayer(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setBlendNodes(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCollapse(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setExcludeBoolean(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setExcludeDynamic(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setExcludeEnum(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setExcludeRotate(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setExcludeScale(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setExcludeTranslate(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setExcludeVisibility(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFindCurveForPlug(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setLock(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setMute(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setOverride(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setParent(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setPassthrough(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setPreferred(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSelected(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSolo(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setWeight(self, val: float = ..., **kwargs: Any) -> None: ...
    def writeBlendnodeDestinations(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class AnimCurve(DependNode):
    def addKeys(self, time, values, tangentInType: str = ..., tangentOutType: str = ..., unit: Incomplete | None = ..., keepExistingKeys: bool = ...): ...
    def addKeyTU(self, time: Union[datatypes.Time, float], value: float, tangentInType: AnimCurve.TangentType = ..., tangentOutType: AnimCurve.TangentType = ...) -> int: ...
    def addKeyTT(self, timeInput: Union[datatypes.Time, float], timeValue: Union[datatypes.Time, float], tangentInType: AnimCurve.TangentType = ..., tangentOutType: AnimCurve.TangentType = ...) -> int: ...
    def addKeyUU(self, unitlessInput: float, value: float, tangentInType: AnimCurve.TangentType = ..., tangentOutType: AnimCurve.TangentType = ...) -> int: ...
    def addKeyUT(self, unitlessInput: float, timeValue: Union[datatypes.Time, float], tangentInType: AnimCurve.TangentType = ..., tangentOutType: AnimCurve.TangentType = ...) -> int: ...
    def addKeyframe(self, *args, **kwargs): ...
    def evaluateTU(self, atTime: datatypes.Time) -> float: ...
    def evaluateTT(self, atTime: datatypes.Time) -> datatypes.Time: ...
    def evaluateUU(self, atUnitlessInput: float) -> float: ...
    def evaluateUT(self, atUnitlessInput: float) -> datatypes.Time: ...
    def findClosestT(self, time: datatypes.Time) -> int: ...
    def findClosestU(self, unitlessInput: float) -> int: ...
    def numKeyframes(self): ...
    @classmethod
    def timedAnimCurveTypeForPlug(cls, plug: general.Attribute) -> AnimCurve.AnimCurveType: ...
    @classmethod
    def unitlessAnimCurveTypeForPlug(cls, plug: general.Attribute) -> AnimCurve.AnimCurveType: ...
    __apicls__: Incomplete
    __melnode__: str
    AnimCurveType: Incomplete
    InfinityType: Incomplete
    TangentType: Incomplete
    def addKeysWithTangents(self, timeArray: List[datatypes.Time], valueArray: List[float], tangentInType: AnimCurve.TangentType = ..., tangentOutType: AnimCurve.TangentType = ..., tangentInTypeArray: List[int] = ..., tangentOutTypeArray: List[int] = ..., tangentInXArray: List[float] = ..., tangentInYArray: List[float] = ..., tangentOutXArray: List[float] = ..., tangentOutYArray: List[float] = ..., tangentsLockedArray: List[int] = ..., weightsLockedArray: List[int] = ..., convertUnits: bool = ..., keepExistingKeys: bool = ...) -> None: ...
    def animCurveType(self) -> AnimCurve.AnimCurveType: ...
    def getInTangentType(self, index: int) -> AnimCurve.TangentType: ...
    def getOutTangentType(self, index: int) -> AnimCurve.TangentType: ...
    def getPostInfinityType(self) -> AnimCurve.InfinityType: ...
    def getPreInfinityType(self) -> AnimCurve.InfinityType: ...
    def getQuaternionW(self, index: int) -> float: ...
    def getTangentsLocked(self, index: int) -> bool: ...
    def getTime(self, index: int) -> datatypes.Time: ...
    def getUnitlessInput(self, index: int) -> float: ...
    def getValue(self, index: int) -> float: ...
    def getWeightsLocked(self, index: int) -> bool: ...
    def insertKey(self, time: datatypes.Time, breakdown: bool = ...) -> int: ...
    def isBreakdown(self, index: int) -> bool: ...
    def isStatic(self) -> bool: ...
    def isTimeInput(self) -> bool: ...
    def isUnitlessInput(self) -> bool: ...
    def isWeighted(self) -> bool: ...
    def numKeys(self) -> int: ...
    def remove(self, index: int) -> None: ...
    def setAngle(self, index: int, angle: datatypes.Angle, inTangent: bool) -> None: ...
    def setBreakdown(self, index: int, isBreakdown: bool) -> None: ...
    def setInTangentType(self, index: int, tangentType: AnimCurve.TangentType) -> None: ...
    def setOutTangentType(self, index: int, tangentType: AnimCurve.TangentType) -> None: ...
    def setPostInfinityType(self, infinityType: AnimCurve.InfinityType) -> None: ...
    def setPreInfinityType(self, infinityType: AnimCurve.InfinityType) -> None: ...
    def setQuaternionW(self, index: int, quaternionW: float) -> None: ...
    def setTangentTypes(self, indexArray: List[int], inTangentType: AnimCurve.TangentType = ..., outTangentType: AnimCurve.TangentType = ...) -> None: ...
    def setTangentsLocked(self, index: int, locked: bool) -> None: ...
    def setTime(self, index: int, time: datatypes.Time) -> None: ...
    def setUnitlessInput(self, index: int, unitlessInput: float) -> None: ...
    def setValue(self, index: int, value: float) -> None: ...
    def setWeight(self, index: int, weight: float, inTangent: bool) -> None: ...
    def setWeighted(self, isWeighted: bool) -> None: ...
    def setWeightsLocked(self, index: int, locked: bool) -> None: ...

class AnimCurveTA(AnimCurve):
    addKey: Incomplete
    evaluate: Incomplete
    findClosest: Incomplete
    __melnode__: str

class AnimCurveTL(AnimCurve):
    addKey: Incomplete
    evaluate: Incomplete
    findClosest: Incomplete
    __melnode__: str

class AnimCurveTT(AnimCurve):
    addKey: Incomplete
    evaluate: Incomplete
    findClosest: Incomplete
    __melnode__: str

class AnimCurveTU(AnimCurve):
    addKey: Incomplete
    evaluate: Incomplete
    findClosest: Incomplete
    __melnode__: str

class AnimCurveUA(AnimCurve):
    addKey: Incomplete
    evaluate: Incomplete
    findClosest: Incomplete
    __melnode__: str

class AnimCurveUL(AnimCurve):
    addKey: Incomplete
    evaluate: Incomplete
    findClosest: Incomplete
    __melnode__: str

class AnimCurveUT(AnimCurve):
    addKey: Incomplete
    evaluate: Incomplete
    findClosest: Incomplete
    __melnode__: str

class AnimCurveUU(AnimCurve):
    addKey: Incomplete
    evaluate: Incomplete
    findClosest: Incomplete
    __melnode__: str

class ResultCurve(AnimCurve):
    __melnode__: str

class ResultCurveTimeToAngular(ResultCurve):
    addKey: Incomplete
    evaluate: Incomplete
    findClosest: Incomplete
    __melnode__: str

class ResultCurveTimeToLinear(ResultCurve):
    addKey: Incomplete
    evaluate: Incomplete
    findClosest: Incomplete
    __melnode__: str

class ResultCurveTimeToTime(ResultCurve):
    addKey: Incomplete
    evaluate: Incomplete
    findClosest: Incomplete
    __melnode__: str

class ResultCurveTimeToUnitless(ResultCurve):
    addKey: Incomplete
    evaluate: Incomplete
    findClosest: Incomplete
    __melnode__: str

class GeometryFilter(DependNode):
    __apicls__: Incomplete
    __melnode__: str
    def deformerSet(self) -> DependNode: ...
    def getComponentAtIndex(self, index: int) -> DependNode: ...
    def getEnvelope(self) -> float: ...
    def getInputGeometry(self) -> List[DependNode]: ...
    def getOutputGeometry(self) -> List[DependNode]: ...
    def getPathAtIndex(self, index: int) -> DagNode: ...
    def groupIdAtIndex(self, index: int) -> int: ...
    def indexForGroupId(self, groupId: int) -> int: ...
    def indexForOutputConnection(self, connectionIndex: int) -> int: ...
    def indexForOutputShape(self, shape: Union[str, DependNode]) -> int: ...
    def inputShapeAtIndex(self, index: int) -> DependNode: ...
    def numOutputConnections(self) -> int: ...
    def outputShapeAtIndex(self, index: int) -> DependNode: ...
    def setEnvelope(self, envelope: float) -> None: ...

class SkinCluster(GeometryFilter):
    def getWeights(self, geometry, influenceIndex: Incomplete | None = ...): ...
    def setWeights(self, geometry, influnces, weights, normalize: bool = ...): ...
    def influenceObjects(self): ...
    def numInfluenceObjects(self): ...
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def addInfluence(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def addToSelection(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def after(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def afterReference(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def baseShape(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def before(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def forceNormalizeWeights(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def frontOfChain(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getBindMethod(self, **kwargs) -> Any: ...
    def getBlendWeights(self, path: DagNode, components: Union[str, DependNode]) -> List[float]: ...
    def getDeformerTools(self, **kwargs) -> Any: ...
    def getDropoffRate(self, **kwargs) -> float: ...
    def getExclusive(self, **kwargs) -> Any: ...
    def getGeometry(self, **kwargs) -> str: ...
    def getGeometryIndices(self, **kwargs) -> Any: ...
    def getIgnoreHierarchy(self, **kwargs) -> Any: ...
    def getInfluence(self, **kwargs) -> str: ...
    def getLockWeights(self, **kwargs) -> bool: ...
    def getMaximumInfluences(self, **kwargs) -> int: ...
    def getNormalizeWeights(self, **kwargs) -> int: ...
    def getObeyMaxInfluences(self, **kwargs) -> bool: ...
    def getPointsAffectedByInfluence(self, path: DagNode) -> Tuple[SelectionSet, List[float]]: ...
    def getSkinMethod(self, **kwargs) -> int: ...
    def getUseComponentTags(self, **kwargs) -> Any: ...
    def getWeightDistribution(self, **kwargs) -> int: ...
    def getWeightedInfluence(self, **kwargs) -> Any: ...
    def ignoreBindPose(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def indexForInfluenceObject(self, mpath: DagNode) -> int: ...
    def moveJointsMode(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def nurbsSamples(self, val: int = ..., **kwargs: Any) -> None: ...
    def parallel(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def polySmoothness(self, val: float = ..., **kwargs: Any) -> None: ...
    def prune(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def recacheBindMatrices(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int, List[Union[bool, int]]] = ..., **kwargs: Any) -> None: ...
    def removeFromSelection(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def removeInfluence(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def selectInfluenceVerts(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setBlendWeights(self, path: DagNode, components: Union[str, DependNode], weights: List[float]) -> None: ...
    def setDropoffRate(self, val: float = ..., **kwargs: Any) -> None: ...
    def setGeometry(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def setInfluence(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setLockWeights(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setMaximumInfluences(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNormalizeWeights(self, val: int = ..., **kwargs: Any) -> None: ...
    def setObeyMaxInfluences(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSkinMethod(self, val: int = ..., **kwargs: Any) -> None: ...
    def setWeightDistribution(self, val: int = ..., **kwargs: Any) -> None: ...
    def smoothWeights(self, val: float = ..., **kwargs: Any) -> None: ...
    def smoothWeightsMaxIterations(self, val: int = ..., **kwargs: Any) -> None: ...
    def unbind(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def unbindKeepHistory(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def useGeometry(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def weight(self, val: float = ..., **kwargs: Any) -> None: ...

class HikHandle(Transform):
    __melnode__: str
    def getRotationQuaternion(self, space: datatypes.Space.Space = ...) -> Tuple[float, float, float, float]: ...
    def setRotationQuaternion(self, x: float, y: float, z: float, w: float, space: datatypes.Space.Space = ...) -> None: ...

class JointFfd(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class AngleBetween(DependNode):
    @staticmethod
    def __melcmd__(*args, **kwargs): ...
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class UfeProxyCameraShape(Camera):
    __apicls__: Incomplete
    __melnode__: str

class THdependNode(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class TadskAssetInstanceNode_TdependNode(DependNode):
    __melnode__: str

class AdskMaterial(TadskAssetInstanceNode_TdependNode):
    __melnode__: str

class AboutToSetValueTestNode(DependNode):
    __melnode__: str

class AbstractBaseCreate(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class AbstractBaseNurbsConversion(AbstractBaseCreate):
    __melnode__: str

class NurbsToSubdiv(AbstractBaseNurbsConversion):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAddUnderTransform(self, **kwargs) -> bool: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getCollapsePoles(self, **kwargs) -> bool: ...
    def getMatchPeriodic(self, **kwargs) -> bool: ...
    def getMaxPolyCount(self, **kwargs) -> int: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getReverseNormal(self, **kwargs) -> bool: ...
    def setAddUnderTransform(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCollapsePoles(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setMatchPeriodic(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setMaxPolyCount(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setReverseNormal(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class NurbsToSubdivProc(NurbsToSubdiv):
    __melnode__: str

class ParentTessellate(AbstractBaseNurbsConversion):
    __melnode__: str

class NurbsTessellate(ParentTessellate):
    __melnode__: str

class ShellTessellate(ParentTessellate):
    __melnode__: str

class RebuildSurface(AbstractBaseNurbsConversion):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getDegreeU(self, **kwargs) -> int: ...
    def getDegreeV(self, **kwargs) -> int: ...
    def getDirection(self, **kwargs) -> int: ...
    def getEndKnots(self, **kwargs) -> int: ...
    def getFitRebuild(self, **kwargs) -> int: ...
    def getKeepControlPoints(self, **kwargs) -> bool: ...
    def getKeepCorners(self, **kwargs) -> bool: ...
    def getKeepRange(self, **kwargs) -> int: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getRebuildType(self, **kwargs) -> int: ...
    def getSpansU(self, **kwargs) -> int: ...
    def getSpansV(self, **kwargs) -> int: ...
    def getTolerance(self, **kwargs) -> float: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDegreeU(self, val: int = ..., **kwargs: Any) -> None: ...
    def setDegreeV(self, val: int = ..., **kwargs: Any) -> None: ...
    def setDirection(self, val: int = ..., **kwargs: Any) -> None: ...
    def setEndKnots(self, val: int = ..., **kwargs: Any) -> None: ...
    def setFitRebuild(self, val: int = ..., **kwargs: Any) -> None: ...
    def setKeepControlPoints(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeepCorners(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeepRange(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setRebuildType(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSpansU(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSpansV(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTolerance(self, val: float = ..., **kwargs: Any) -> None: ...

class AlignCurve(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getCurvatureContinuity(self, **kwargs) -> bool: ...
    def getCurvatureScale1(self, **kwargs) -> float: ...
    def getCurvatureScale2(self, **kwargs) -> float: ...
    def getJoinParameter(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getPositionalContinuity(self, **kwargs) -> bool: ...
    def getPositionalContinuityType(self, **kwargs) -> int: ...
    def getReverse1(self, **kwargs) -> bool: ...
    def getReverse2(self, **kwargs) -> bool: ...
    def getTangentContinuity(self, **kwargs) -> bool: ...
    def getTangentContinuityType(self, **kwargs) -> int: ...
    def getTangentScale1(self, **kwargs) -> float: ...
    def getTangentScale2(self, **kwargs) -> float: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCurvatureContinuity(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCurvatureScale1(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCurvatureScale2(self, val: float = ..., **kwargs: Any) -> None: ...
    def setJoinParameter(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPositionalContinuity(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setPositionalContinuityType(self, val: int = ..., **kwargs: Any) -> None: ...
    def setReverse1(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setReverse2(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setTangentContinuity(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setTangentContinuityType(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTangentScale1(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTangentScale2(self, val: float = ..., **kwargs: Any) -> None: ...

class AlignSurface(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getCurvatureContinuity(self, **kwargs) -> bool: ...
    def getCurvatureScale1(self, **kwargs) -> float: ...
    def getCurvatureScale2(self, **kwargs) -> float: ...
    def getDirectionU(self, **kwargs) -> bool: ...
    def getJoinParameter(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getPositionalContinuity(self, **kwargs) -> bool: ...
    def getPositionalContinuityType(self, **kwargs) -> int: ...
    def getReverse1(self, **kwargs) -> bool: ...
    def getReverse2(self, **kwargs) -> bool: ...
    def getSwap1(self, **kwargs) -> bool: ...
    def getSwap2(self, **kwargs) -> bool: ...
    def getTangentContinuity(self, **kwargs) -> bool: ...
    def getTangentContinuityType(self, **kwargs) -> int: ...
    def getTangentScale1(self, **kwargs) -> float: ...
    def getTangentScale2(self, **kwargs) -> float: ...
    def getTwist(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCurvatureContinuity(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCurvatureScale1(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCurvatureScale2(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDirectionU(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setJoinParameter(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPositionalContinuity(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setPositionalContinuityType(self, val: int = ..., **kwargs: Any) -> None: ...
    def setReverse1(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setReverse2(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSwap1(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSwap2(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setTangentContinuity(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setTangentContinuityType(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTangentScale1(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTangentScale2(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTwist(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class ArubaTessellate(AbstractBaseCreate):
    __melnode__: str

class AttachCurve(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getBlendBias(self, **kwargs) -> float: ...
    def getBlendKnotInsertion(self, **kwargs) -> bool: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getKeepMultipleKnots(self, **kwargs) -> bool: ...
    def getMethod(self, **kwargs) -> int: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getParameter(self, **kwargs) -> float: ...
    def getReverse1(self, **kwargs) -> bool: ...
    def getReverse2(self, **kwargs) -> bool: ...
    def setBlendBias(self, val: float = ..., **kwargs: Any) -> None: ...
    def setBlendKnotInsertion(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeepMultipleKnots(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setMethod(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setParameter(self, val: float = ..., **kwargs: Any) -> None: ...
    def setReverse1(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setReverse2(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class AttachSurface(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getBlendBias(self, **kwargs) -> float: ...
    def getBlendKnotInsertion(self, **kwargs) -> bool: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getDirectionU(self, **kwargs) -> bool: ...
    def getKeepMultipleKnots(self, **kwargs) -> bool: ...
    def getMethod(self, **kwargs) -> int: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getParameter(self, **kwargs) -> float: ...
    def getReverse1(self, **kwargs) -> bool: ...
    def getReverse2(self, **kwargs) -> bool: ...
    def getSwap1(self, **kwargs) -> bool: ...
    def getSwap2(self, **kwargs) -> bool: ...
    def getTwist(self, **kwargs) -> bool: ...
    def setBlendBias(self, val: float = ..., **kwargs: Any) -> None: ...
    def setBlendKnotInsertion(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDirectionU(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeepMultipleKnots(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setMethod(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setParameter(self, val: float = ..., **kwargs: Any) -> None: ...
    def setReverse1(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setReverse2(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSwap1(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSwap2(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setTwist(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class AvgCurves(AbstractBaseCreate):
    __melnode__: str

class AvgNurbsSurfacePoints(AbstractBaseCreate):
    __melnode__: str

class AvgSurfacePoints(AbstractBaseCreate):
    __melnode__: str

class Bevel(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getBevelShapeType(self, **kwargs) -> int: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getCornerType(self, **kwargs) -> int: ...
    def getDepth(self, **kwargs) -> float: ...
    def getExtrudeDepth(self, **kwargs) -> float: ...
    def getJoinSurfaces(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getNumberOfSides(self, **kwargs) -> int: ...
    def getTolerance(self, **kwargs) -> float: ...
    def getWidth(self, **kwargs) -> float: ...
    def setBevelShapeType(self, val: int = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCornerType(self, val: int = ..., **kwargs: Any) -> None: ...
    def setDepth(self, val: float = ..., **kwargs: Any) -> None: ...
    def setExtrudeDepth(self, val: float = ..., **kwargs: Any) -> None: ...
    def setJoinSurfaces(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNumberOfSides(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTolerance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setWidth(self, val: float = ..., **kwargs: Any) -> None: ...

class BevelPlus(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getBevelInside(self, **kwargs) -> bool: ...
    def getCapSides(self, **kwargs) -> Any: ...
    def getInnerStyle(self, **kwargs) -> int: ...
    def getJoinSurfaces(self, **kwargs) -> bool: ...
    def getNormalsOutwards(self, **kwargs) -> bool: ...
    def getNumberOfSides(self, **kwargs) -> int: ...
    def getOuterStyle(self, **kwargs) -> int: ...
    def setBevelInside(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setInnerStyle(self, val: int = ..., **kwargs: Any) -> None: ...
    def setJoinSurfaces(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNormalsOutwards(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNumberOfSides(self, val: int = ..., **kwargs: Any) -> None: ...
    def setOuterStyle(self, val: int = ..., **kwargs: Any) -> None: ...

class BezierCurveToNurbs(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str

class BirailSrf(AbstractBaseCreate):
    __melnode__: str

class DpBirailSrf(BirailSrf):
    __melnode__: str

class MpBirailSrf(BirailSrf):
    __melnode__: str

class SpBirailSrf(BirailSrf):
    __melnode__: str

class Boolean(AbstractBaseCreate):
    __melnode__: str

class BoundaryBase(AbstractBaseCreate):
    __melnode__: str

class Boundary(BoundaryBase):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getEndPoint(self, **kwargs) -> bool: ...
    def getEndPointTolerance(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getOrder(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setEndPoint(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setEndPointTolerance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setOrder(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class SquareSrf(BoundaryBase):
    __melnode__: str

class CloseCurve(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getBlendBias(self, **kwargs) -> float: ...
    def getBlendKnotInsertion(self, **kwargs) -> bool: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getParameter(self, **kwargs) -> float: ...
    def getPreserveShape(self, **kwargs) -> int: ...
    def setBlendBias(self, val: float = ..., **kwargs: Any) -> None: ...
    def setBlendKnotInsertion(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setParameter(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPreserveShape(self, val: int = ..., **kwargs: Any) -> None: ...

class CloseSurface(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getBlendBias(self, **kwargs) -> float: ...
    def getBlendKnotInsertion(self, **kwargs) -> bool: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getDirection(self, **kwargs) -> int: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getParameter(self, **kwargs) -> float: ...
    def getPreserveShape(self, **kwargs) -> int: ...
    def setBlendBias(self, val: float = ..., **kwargs: Any) -> None: ...
    def setBlendKnotInsertion(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDirection(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setParameter(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPreserveShape(self, val: int = ..., **kwargs: Any) -> None: ...

class ClosestPointOnSurface(AbstractBaseCreate):
    __melnode__: str

class CurveInfo(AbstractBaseCreate):
    __melnode__: str

class CurveIntersect(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getDirection(self, **kwargs) -> Tuple[float, float, float]: ...
    def getDirectionX(self, **kwargs) -> float: ...
    def getDirectionY(self, **kwargs) -> float: ...
    def getDirectionZ(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getTolerance(self, **kwargs) -> float: ...
    def getUseDirection(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDirection(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setDirectionX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDirectionY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDirectionZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTolerance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setUseDirection(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class CurveRange(AbstractBaseCreate):
    __melnode__: str

class CurveFromSubdiv(CurveRange):
    __melnode__: str

class CurveFromSubdivEdge(CurveFromSubdiv):
    __melnode__: str

class CurveFromSubdivFace(CurveFromSubdiv):
    __melnode__: str

class CurveFromSurface(CurveRange):
    __melnode__: str

class CurveFromSurfaceBnd(CurveFromSurface):
    __melnode__: str

class CurveFromSurfaceCoS(CurveFromSurface):
    __melnode__: str

class CurveFromSurfaceIso(CurveFromSurface):
    __melnode__: str

class SubCurve(CurveRange):
    __melnode__: str

class DetachCurve(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getKeep(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getParameter(self, **kwargs) -> float: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeep(self, val: Union[bool, int, List[Union[bool, int]]] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setParameter(self, val: Union[float, List[float]] = ..., **kwargs: Any) -> None: ...

class DetachSurface(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getDirection(self, **kwargs) -> int: ...
    def getKeep(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getParameter(self, **kwargs) -> float: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDirection(self, val: int = ..., **kwargs: Any) -> None: ...
    def setKeep(self, val: Union[bool, int, List[Union[bool, int]]] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setParameter(self, val: Union[float, List[float]] = ..., **kwargs: Any) -> None: ...

class ExplodeNurbsShell(AbstractBaseCreate):
    __melnode__: str

class ExtendCurve(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getDistance(self, **kwargs) -> float: ...
    def getExtendMethod(self, **kwargs) -> int: ...
    def getExtensionType(self, **kwargs) -> int: ...
    def getInputPoint(self, **kwargs) -> Tuple[float, float, float]: ...
    def getJoin(self, **kwargs) -> bool: ...
    def getNoChanges(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getPointX(self, **kwargs) -> float: ...
    def getPointY(self, **kwargs) -> float: ...
    def getPointZ(self, **kwargs) -> float: ...
    def getRemoveMultipleKnots(self, **kwargs) -> bool: ...
    def getStart(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDistance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setExtendMethod(self, val: int = ..., **kwargs: Any) -> None: ...
    def setExtensionType(self, val: int = ..., **kwargs: Any) -> None: ...
    def setInputPoint(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setJoin(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNoChanges(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPointX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPointY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPointZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRemoveMultipleKnots(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setStart(self, val: int = ..., **kwargs: Any) -> None: ...

class ExtendSurface(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getDistance(self, **kwargs) -> float: ...
    def getExtendDirection(self, **kwargs) -> int: ...
    def getExtendMethod(self, **kwargs) -> int: ...
    def getExtendSide(self, **kwargs) -> int: ...
    def getExtensionType(self, **kwargs) -> int: ...
    def getJoin(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDistance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setExtendDirection(self, val: int = ..., **kwargs: Any) -> None: ...
    def setExtendMethod(self, val: int = ..., **kwargs: Any) -> None: ...
    def setExtendSide(self, val: int = ..., **kwargs: Any) -> None: ...
    def setExtensionType(self, val: int = ..., **kwargs: Any) -> None: ...
    def setJoin(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...

class Extrude(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getDegreeAlongLength(self, **kwargs) -> int: ...
    def getDirection(self, **kwargs) -> Tuple[float, float, float]: ...
    def getDirectionX(self, **kwargs) -> float: ...
    def getDirectionY(self, **kwargs) -> float: ...
    def getDirectionZ(self, **kwargs) -> float: ...
    def getExtrudeType(self, **kwargs) -> int: ...
    def getFixedPath(self, **kwargs) -> bool: ...
    def getLength(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getPivot(self, **kwargs) -> Tuple[float, float, float]: ...
    def getReverseSurfaceIfPathReversed(self, **kwargs) -> bool: ...
    def getRotation(self, **kwargs) -> float: ...
    def getScale(self, **kwargs) -> float: ...
    def getSubCurveSubSurface(self, **kwargs) -> bool: ...
    def getUseComponentPivot(self, **kwargs) -> int: ...
    def getUseProfileNormal(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDegreeAlongLength(self, val: int = ..., **kwargs: Any) -> None: ...
    def setDirection(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setDirectionX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDirectionY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDirectionZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setExtrudeType(self, val: int = ..., **kwargs: Any) -> None: ...
    def setFixedPath(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setLength(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPivot(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setReverseSurfaceIfPathReversed(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setRotation(self, val: float = ..., **kwargs: Any) -> None: ...
    def setScale(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSubCurveSubSurface(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setUseComponentPivot(self, val: int = ..., **kwargs: Any) -> None: ...
    def setUseProfileNormal(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class FfBlendSrf(AbstractBaseCreate):
    __melnode__: str

class FfBlendSrfObsolete(AbstractBaseCreate):
    __melnode__: str

class FfFilletSrf(AbstractBaseCreate):
    __melnode__: str

class FilletCurve(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getBias(self, **kwargs) -> float: ...
    def getBlendControl(self, **kwargs) -> bool: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getCircular(self, **kwargs) -> bool: ...
    def getCurveParameter1(self, **kwargs) -> float: ...
    def getCurveParameter2(self, **kwargs) -> float: ...
    def getDepth(self, **kwargs) -> float: ...
    def getFreeformBlend(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getRadius(self, **kwargs) -> float: ...
    def setBias(self, val: float = ..., **kwargs: Any) -> None: ...
    def setBlendControl(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCircular(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCurveParameter1(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCurveParameter2(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDepth(self, val: float = ..., **kwargs: Any) -> None: ...
    def setFreeformBlend(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setRadius(self, val: float = ..., **kwargs: Any) -> None: ...

class FitBspline(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getTolerance(self, **kwargs) -> float: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTolerance(self, val: float = ..., **kwargs: Any) -> None: ...

class GlobalStitch(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getLockSurface(self, **kwargs) -> bool: ...
    def getMaxSeparation(self, **kwargs) -> float: ...
    def getModificationResistance(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getSampling(self, **kwargs) -> int: ...
    def getStitchCorners(self, **kwargs) -> int: ...
    def getStitchEdges(self, **kwargs) -> int: ...
    def getStitchPartialEdges(self, **kwargs) -> bool: ...
    def getStitchSmoothness(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setLockSurface(self, val: Union[bool, int, List[Union[bool, int]]] = ..., **kwargs: Any) -> None: ...
    def setMaxSeparation(self, val: float = ..., **kwargs: Any) -> None: ...
    def setModificationResistance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSampling(self, val: int = ..., **kwargs: Any) -> None: ...
    def setStitchCorners(self, val: int = ..., **kwargs: Any) -> None: ...
    def setStitchEdges(self, val: int = ..., **kwargs: Any) -> None: ...
    def setStitchPartialEdges(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setStitchSmoothness(self, val: int = ..., **kwargs: Any) -> None: ...

class HardenPoint(AbstractBaseCreate):
    __melnode__: str

class InsertKnotCurve(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAddKnots(self, **kwargs) -> bool: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getInsertBetween(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getNumberOfKnots(self, **kwargs) -> int: ...
    def getParameter(self, **kwargs) -> float: ...
    def setAddKnots(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setInsertBetween(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNumberOfKnots(self, val: Union[int, List[int]] = ..., **kwargs: Any) -> None: ...
    def setParameter(self, val: Union[float, List[float]] = ..., **kwargs: Any) -> None: ...

class InsertKnotSurface(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAddKnots(self, **kwargs) -> bool: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getDirection(self, **kwargs) -> int: ...
    def getInsertBetween(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getNumberOfKnots(self, **kwargs) -> int: ...
    def getParameter(self, **kwargs) -> float: ...
    def setAddKnots(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDirection(self, val: int = ..., **kwargs: Any) -> None: ...
    def setInsertBetween(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNumberOfKnots(self, val: Union[int, List[int]] = ..., **kwargs: Any) -> None: ...
    def setParameter(self, val: Union[float, List[float]] = ..., **kwargs: Any) -> None: ...

class IntersectSurface(AbstractBaseCreate):
    __melnode__: str

class LeastSquaresModifier(AbstractBaseCreate):
    __melnode__: str

class Loft(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAutoReverse(self, **kwargs) -> bool: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getClose(self, **kwargs) -> bool: ...
    def getCreateCusp(self, **kwargs) -> bool: ...
    def getDegree(self, **kwargs) -> int: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getReverse(self, **kwargs) -> bool: ...
    def getReverseSurfaceNormals(self, **kwargs) -> bool: ...
    def getSectionSpans(self, **kwargs) -> int: ...
    def getUniform(self, **kwargs) -> bool: ...
    def setAutoReverse(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setClose(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCreateCusp(self, val: Union[bool, int, List[Union[bool, int]]] = ..., **kwargs: Any) -> None: ...
    def setDegree(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setReverse(self, val: Union[bool, int, List[Union[bool, int]]] = ..., **kwargs: Any) -> None: ...
    def setReverseSurfaceNormals(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSectionSpans(self, val: int = ..., **kwargs: Any) -> None: ...
    def setUniform(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class MakeCircularArc(AbstractBaseCreate):
    __melnode__: str

class MakeThreePointCircularArc(MakeCircularArc):
    __melnode__: str

class MakeTwoPointCircularArc(MakeCircularArc):
    __melnode__: str

class MakeIllustratorCurves(AbstractBaseCreate):
    __melnode__: str

class MakeNurbCircle(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getCenter(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCenterX(self, **kwargs) -> float: ...
    def getCenterY(self, **kwargs) -> float: ...
    def getCenterZ(self, **kwargs) -> float: ...
    def getDegree(self, **kwargs) -> int: ...
    def getFirst(self, **kwargs) -> Tuple[float, float, float]: ...
    def getFirstPointX(self, **kwargs) -> float: ...
    def getFirstPointY(self, **kwargs) -> float: ...
    def getFirstPointZ(self, **kwargs) -> float: ...
    def getFixCenter(self, **kwargs) -> bool: ...
    def getFrozen(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getNormal(self, **kwargs) -> Tuple[float, float, float]: ...
    def getNormalX(self, **kwargs) -> float: ...
    def getNormalY(self, **kwargs) -> float: ...
    def getNormalZ(self, **kwargs) -> float: ...
    def getRadius(self, **kwargs) -> float: ...
    def getSections(self, **kwargs) -> int: ...
    def getSweep(self, **kwargs) -> float: ...
    def getTolerance(self, **kwargs) -> float: ...
    def getUseTolerance(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCenter(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCenterX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCenterY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCenterZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDegree(self, val: int = ..., **kwargs: Any) -> None: ...
    def setFirst(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setFirstPointX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setFirstPointY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setFirstPointZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setFixCenter(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFrozen(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNormal(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setNormalX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNormalY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNormalZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSections(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSweep(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTolerance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setUseTolerance(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class MakeNurbsSquare(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getCenter(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCenterX(self, **kwargs) -> float: ...
    def getCenterY(self, **kwargs) -> float: ...
    def getCenterZ(self, **kwargs) -> float: ...
    def getDegree(self, **kwargs) -> int: ...
    def getFrozen(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getNormal(self, **kwargs) -> Tuple[float, float, float]: ...
    def getNormalX(self, **kwargs) -> float: ...
    def getNormalY(self, **kwargs) -> float: ...
    def getNormalZ(self, **kwargs) -> float: ...
    def getSideLength1(self, **kwargs) -> float: ...
    def getSideLength2(self, **kwargs) -> float: ...
    def getSpansPerSide(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCenter(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCenterX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCenterY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCenterZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDegree(self, val: int = ..., **kwargs: Any) -> None: ...
    def setFrozen(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNormal(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setNormalX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNormalY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNormalZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSideLength1(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSideLength2(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSpansPerSide(self, val: int = ..., **kwargs: Any) -> None: ...

class MakeTextCurves(AbstractBaseCreate):
    __melnode__: str

class NearestPointOnCurve(AbstractBaseCreate):
    __melnode__: str

class NurbsCurveToBezier(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str

class OffsetCos(AbstractBaseCreate):
    __melnode__: str

class OffsetCurve(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConnectBreaks(self, **kwargs) -> int: ...
    def getCutLoop(self, **kwargs) -> bool: ...
    def getCutRadius(self, **kwargs) -> float: ...
    def getDistance(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getNormal(self, **kwargs) -> Tuple[float, float, float]: ...
    def getReparameterize(self, **kwargs) -> bool: ...
    def getStitch(self, **kwargs) -> bool: ...
    def getSubdivisionDensity(self, **kwargs) -> int: ...
    def getTolerance(self, **kwargs) -> float: ...
    def getUseGivenNormal(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setConnectBreaks(self, val: int = ..., **kwargs: Any) -> None: ...
    def setCutLoop(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCutRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDistance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNormal(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setReparameterize(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setStitch(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSubdivisionDensity(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTolerance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setUseGivenNormal(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class OffsetSurface(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getDistance(self, **kwargs) -> float: ...
    def getMethod(self, **kwargs) -> int: ...
    def getNodeState(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDistance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setMethod(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...

class PlanarTrimSurface(AbstractBaseCreate):
    __melnode__: str

class PointOnCurveInfo(AbstractBaseCreate):
    __melnode__: str

class PointOnSurfaceInfo(AbstractBaseCreate):
    __melnode__: str

class PolyEdgeToCurve(AbstractBaseCreate):
    __melnode__: str

class PolyProjectCurve(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getDirection(self, **kwargs) -> Tuple[float, float, float]: ...
    def getDirectionX(self, **kwargs) -> float: ...
    def getDirectionY(self, **kwargs) -> float: ...
    def getDirectionZ(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getTolerance(self, **kwargs) -> float: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDirection(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setDirectionX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDirectionY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDirectionZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTolerance(self, val: float = ..., **kwargs: Any) -> None: ...

class Primitive(AbstractBaseCreate):
    __melnode__: str

class MakeNurbCube(Primitive):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAxis(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getDegree(self, **kwargs) -> int: ...
    def getFrozen(self, **kwargs) -> bool: ...
    def getHeightRatio(self, **kwargs) -> float: ...
    def getLengthRatio(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getPatchesU(self, **kwargs) -> int: ...
    def getPatchesV(self, **kwargs) -> int: ...
    def getPivot(self, **kwargs) -> Tuple[float, float, float]: ...
    def getWidth(self, **kwargs) -> float: ...
    def setAxis(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDegree(self, val: int = ..., **kwargs: Any) -> None: ...
    def setFrozen(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setHeightRatio(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLengthRatio(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPatchesU(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPatchesV(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPivot(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setWidth(self, val: float = ..., **kwargs: Any) -> None: ...

class MakeNurbPlane(Primitive):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAxis(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getDegree(self, **kwargs) -> int: ...
    def getFrozen(self, **kwargs) -> bool: ...
    def getLengthRatio(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getPatchesU(self, **kwargs) -> int: ...
    def getPatchesV(self, **kwargs) -> int: ...
    def getPivot(self, **kwargs) -> Tuple[float, float, float]: ...
    def getWidth(self, **kwargs) -> float: ...
    def setAxis(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDegree(self, val: int = ..., **kwargs: Any) -> None: ...
    def setFrozen(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setLengthRatio(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPatchesU(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPatchesV(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPivot(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setWidth(self, val: float = ..., **kwargs: Any) -> None: ...

class RevolvedPrimitive(Primitive):
    __melnode__: str

class MakeNurbCone(RevolvedPrimitive):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAxis(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getDegree(self, **kwargs) -> int: ...
    def getEndSweep(self, **kwargs) -> float: ...
    def getFrozen(self, **kwargs) -> bool: ...
    def getHeightRatio(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getPivot(self, **kwargs) -> Tuple[float, float, float]: ...
    def getRadius(self, **kwargs) -> float: ...
    def getSections(self, **kwargs) -> int: ...
    def getSpans(self, **kwargs) -> int: ...
    def getStartSweep(self, **kwargs) -> float: ...
    def getTolerance(self, **kwargs) -> float: ...
    def getUseOldInitBehaviour(self, **kwargs) -> bool: ...
    def getUseTolerance(self, **kwargs) -> bool: ...
    def setAxis(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDegree(self, val: int = ..., **kwargs: Any) -> None: ...
    def setEndSweep(self, val: float = ..., **kwargs: Any) -> None: ...
    def setFrozen(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setHeightRatio(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPivot(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSections(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSpans(self, val: int = ..., **kwargs: Any) -> None: ...
    def setStartSweep(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTolerance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setUseOldInitBehaviour(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setUseTolerance(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class MakeNurbCylinder(RevolvedPrimitive):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAxis(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getDegree(self, **kwargs) -> int: ...
    def getEndSweep(self, **kwargs) -> float: ...
    def getFrozen(self, **kwargs) -> bool: ...
    def getHeightRatio(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getPivot(self, **kwargs) -> Tuple[float, float, float]: ...
    def getRadius(self, **kwargs) -> float: ...
    def getSections(self, **kwargs) -> int: ...
    def getSpans(self, **kwargs) -> int: ...
    def getStartSweep(self, **kwargs) -> float: ...
    def getTolerance(self, **kwargs) -> float: ...
    def getUseTolerance(self, **kwargs) -> bool: ...
    def setAxis(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDegree(self, val: int = ..., **kwargs: Any) -> None: ...
    def setEndSweep(self, val: float = ..., **kwargs: Any) -> None: ...
    def setFrozen(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setHeightRatio(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPivot(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSections(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSpans(self, val: int = ..., **kwargs: Any) -> None: ...
    def setStartSweep(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTolerance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setUseTolerance(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class MakeNurbSphere(RevolvedPrimitive):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAxis(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getDegree(self, **kwargs) -> int: ...
    def getEndSweep(self, **kwargs) -> float: ...
    def getFrozen(self, **kwargs) -> bool: ...
    def getHeightRatio(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getPivot(self, **kwargs) -> Tuple[float, float, float]: ...
    def getRadius(self, **kwargs) -> float: ...
    def getSections(self, **kwargs) -> int: ...
    def getSpans(self, **kwargs) -> int: ...
    def getStartSweep(self, **kwargs) -> float: ...
    def getTolerance(self, **kwargs) -> float: ...
    def getUseTolerance(self, **kwargs) -> bool: ...
    def setAxis(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDegree(self, val: int = ..., **kwargs: Any) -> None: ...
    def setEndSweep(self, val: float = ..., **kwargs: Any) -> None: ...
    def setFrozen(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setHeightRatio(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPivot(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSections(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSpans(self, val: int = ..., **kwargs: Any) -> None: ...
    def setStartSweep(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTolerance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setUseTolerance(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class MakeNurbTorus(RevolvedPrimitive):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAxis(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getDegree(self, **kwargs) -> int: ...
    def getEndSweep(self, **kwargs) -> float: ...
    def getFrozen(self, **kwargs) -> bool: ...
    def getHeightRatio(self, **kwargs) -> float: ...
    def getMinorSweep(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getPivot(self, **kwargs) -> Tuple[float, float, float]: ...
    def getRadius(self, **kwargs) -> float: ...
    def getSections(self, **kwargs) -> int: ...
    def getSpans(self, **kwargs) -> int: ...
    def getStartSweep(self, **kwargs) -> float: ...
    def getTolerance(self, **kwargs) -> float: ...
    def getUseTolerance(self, **kwargs) -> bool: ...
    def setAxis(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDegree(self, val: int = ..., **kwargs: Any) -> None: ...
    def setEndSweep(self, val: float = ..., **kwargs: Any) -> None: ...
    def setFrozen(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setHeightRatio(self, val: float = ..., **kwargs: Any) -> None: ...
    def setMinorSweep(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPivot(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSections(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSpans(self, val: int = ..., **kwargs: Any) -> None: ...
    def setStartSweep(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTolerance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setUseTolerance(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class ProjectCurve(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getDirection(self, **kwargs) -> Tuple[float, float, float]: ...
    def getDirectionX(self, **kwargs) -> float: ...
    def getDirectionY(self, **kwargs) -> float: ...
    def getDirectionZ(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getTolerance(self, **kwargs) -> float: ...
    def getUseNormal(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDirection(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setDirectionX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDirectionY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDirectionZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTolerance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setUseNormal(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class ProjectTangent(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getCurvature(self, **kwargs) -> bool: ...
    def getCurvatureScale(self, **kwargs) -> float: ...
    def getIgnoreEdges(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getReverseTangent(self, **kwargs) -> bool: ...
    def getRotate(self, **kwargs) -> float: ...
    def getTangentDirection(self, **kwargs) -> int: ...
    def getTangentScale(self, **kwargs) -> float: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCurvature(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCurvatureScale(self, val: float = ..., **kwargs: Any) -> None: ...
    def setIgnoreEdges(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setReverseTangent(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setRotate(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTangentDirection(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTangentScale(self, val: float = ..., **kwargs: Any) -> None: ...

class RbfSrf(AbstractBaseCreate):
    __melnode__: str

class RebuildCurve(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getDegree(self, **kwargs) -> int: ...
    def getEndKnots(self, **kwargs) -> int: ...
    def getFitRebuild(self, **kwargs) -> bool: ...
    def getKeepControlPoints(self, **kwargs) -> bool: ...
    def getKeepEndPoints(self, **kwargs) -> bool: ...
    def getKeepRange(self, **kwargs) -> int: ...
    def getKeepTangents(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getRebuildType(self, **kwargs) -> int: ...
    def getSmartSurfaceCurveRebuild(self, **kwargs) -> bool: ...
    def getSpans(self, **kwargs) -> int: ...
    def getTolerance(self, **kwargs) -> float: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDegree(self, val: int = ..., **kwargs: Any) -> None: ...
    def setEndKnots(self, val: int = ..., **kwargs: Any) -> None: ...
    def setFitRebuild(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeepControlPoints(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeepEndPoints(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeepRange(self, val: int = ..., **kwargs: Any) -> None: ...
    def setKeepTangents(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setRebuildType(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSmartSurfaceCurveRebuild(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSpans(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTolerance(self, val: float = ..., **kwargs: Any) -> None: ...

class ReverseCurve(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...

class ReverseSurface(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getDirection(self, **kwargs) -> int: ...
    def getNodeState(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDirection(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...

class Revolve(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAutoCorrectNormal(self, **kwargs) -> bool: ...
    def getAxis(self, **kwargs) -> Tuple[float, float, float]: ...
    def getAxisChoice(self, **kwargs) -> int: ...
    def getAxisX(self, **kwargs) -> float: ...
    def getAxisY(self, **kwargs) -> float: ...
    def getAxisZ(self, **kwargs) -> float: ...
    def getBridge(self, **kwargs) -> bool: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getComputePivotAndAxis(self, **kwargs) -> int: ...
    def getDegree(self, **kwargs) -> int: ...
    def getEndSweep(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getPivot(self, **kwargs) -> Tuple[float, float, float]: ...
    def getPivotX(self, **kwargs) -> float: ...
    def getPivotY(self, **kwargs) -> float: ...
    def getPivotZ(self, **kwargs) -> float: ...
    def getRadius(self, **kwargs) -> float: ...
    def getRadiusAnchor(self, **kwargs) -> float: ...
    def getSections(self, **kwargs) -> int: ...
    def getStartSweep(self, **kwargs) -> float: ...
    def getTolerance(self, **kwargs) -> float: ...
    def getUseLocalPivot(self, **kwargs) -> bool: ...
    def getUseTolerance(self, **kwargs) -> bool: ...
    def setAutoCorrectNormal(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setAxis(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setAxisChoice(self, val: int = ..., **kwargs: Any) -> None: ...
    def setAxisX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setAxisY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setAxisZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setBridge(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setComputePivotAndAxis(self, val: int = ..., **kwargs: Any) -> None: ...
    def setDegree(self, val: int = ..., **kwargs: Any) -> None: ...
    def setEndSweep(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPivot(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setPivotX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPivotY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPivotZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRadiusAnchor(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSections(self, val: int = ..., **kwargs: Any) -> None: ...
    def setStartSweep(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTolerance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setUseLocalPivot(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setUseTolerance(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class RoundConstantRadius(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str

class SmoothCurve(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getSmoothness(self, **kwargs) -> float: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSmoothness(self, val: float = ..., **kwargs: Any) -> None: ...

class SmoothTangentSrf(AbstractBaseCreate):
    __melnode__: str

class StitchAsNurbsShell(AbstractBaseCreate):
    __melnode__: str

class StitchSrf(AbstractBaseCreate):
    __melnode__: str

class StyleCurve(AbstractBaseCreate):
    __melnode__: str

class SubSurface(AbstractBaseCreate):
    __melnode__: str

class SubdivToNurbs(AbstractBaseCreate):
    __melnode__: str

class SurfaceInfo(AbstractBaseCreate):
    __melnode__: str

class TransformGeometry(AbstractBaseCreate):
    __melnode__: str

class Trim(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getLocatorU(self, **kwargs) -> float: ...
    def getLocatorV(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getSelected(self, **kwargs) -> int: ...
    def getShrink(self, **kwargs) -> bool: ...
    def getTolerance(self, **kwargs) -> float: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setLocatorU(self, val: Union[float, List[float]] = ..., **kwargs: Any) -> None: ...
    def setLocatorV(self, val: Union[float, List[float]] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSelected(self, val: int = ..., **kwargs: Any) -> None: ...
    def setShrink(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setTolerance(self, val: float = ..., **kwargs: Any) -> None: ...

class TrimWithBoundaries(AbstractBaseCreate):
    __melnode__: str

class Untrim(AbstractBaseCreate):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getNoChanges(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getUntrimAll(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNoChanges(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setUntrimAll(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class AddDoubleLinear(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class AddMatrix(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class AimMatrix(DependNode):
    __melnode__: str

class AnimBlend(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class AnimBlendInOut(AnimBlend):
    __melnode__: str

class AnimBlendNodeBase(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class AnimBlendNodeAdditive(AnimBlendNodeBase):
    __melnode__: str

class AnimBlendNodeAdditiveDA(AnimBlendNodeBase):
    __melnode__: str

class AnimBlendNodeAdditiveDL(AnimBlendNodeBase):
    __melnode__: str

class AnimBlendNodeAdditiveF(AnimBlendNodeBase):
    __melnode__: str

class AnimBlendNodeAdditiveFA(AnimBlendNodeBase):
    __melnode__: str

class AnimBlendNodeAdditiveFL(AnimBlendNodeBase):
    __melnode__: str

class AnimBlendNodeAdditiveI16(AnimBlendNodeBase):
    __melnode__: str

class AnimBlendNodeAdditiveI32(AnimBlendNodeBase):
    __melnode__: str

class AnimBlendNodeAdditiveRotation(AnimBlendNodeBase):
    __melnode__: str

class AnimBlendNodeAdditiveScale(AnimBlendNodeBase):
    __melnode__: str

class AnimBlendNodeBoolean(AnimBlendNodeBase):
    __melnode__: str

class AnimBlendNodeEnum(AnimBlendNodeBase):
    __melnode__: str

class AnimBlendNodeTime(AnimBlendNodeBase):
    __melnode__: str

class AnimClip(DependNode):
    __apicls__: Incomplete
    __melnode__: str
    def getAbsoluteChannelSettings(self) -> List[int]: ...
    def getEnabled(self) -> bool: ...
    def getMemberAnimCurves(self) -> Tuple[List[DependNode], List[general.Attribute]]: ...
    def getPostCycle(self) -> float: ...
    def getPreCycle(self) -> float: ...
    def getScale(self) -> float: ...
    def getSourceDuration(self) -> datatypes.Time: ...
    def getSourceStart(self) -> datatypes.Time: ...
    def getStartFrame(self) -> datatypes.Time: ...
    def getWeight(self) -> float: ...
    def isInstancedClip(self) -> bool: ...
    def isPose(self) -> bool: ...
    def setAbsoluteChannelSettings(self, absoluteChannels: List[int], mod: datatypes.DGModifier = ...) -> None: ...
    def setEnabled(self, val: bool, mod: datatypes.DGModifier = ...) -> None: ...
    def setPoseClip(self, state: bool, mod: datatypes.DGModifier = ...) -> None: ...
    def setPostCycle(self, cycle: float, mod: datatypes.DGModifier = ...) -> None: ...
    def setPreCycle(self, cycle: float, mod: datatypes.DGModifier = ...) -> None: ...
    def setScale(self, scale: float, mod: datatypes.DGModifier = ...) -> None: ...
    def setSourceData(self, start: datatypes.Time, duration: datatypes.Time, mod: datatypes.DGModifier = ...) -> None: ...
    def setStartFrame(self, start: datatypes.Time, mod: datatypes.DGModifier = ...) -> None: ...
    def setWeight(self, wt: float, mod: datatypes.DGModifier = ...) -> None: ...
    def sourceClip(self) -> DependNode: ...

class ArrayMapper(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class THarrayMapper(ArrayMapper):
    __melnode__: str

class AttrHierarchyTest(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class Audio(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class Blend(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class BlendDevice(Blend):
    __melnode__: str

class BlendTwoAttr(Blend):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAttribute0(self, **kwargs) -> general.PyNode: ...
    def getAttribute1(self, **kwargs) -> general.PyNode: ...
    def getBlender(self, **kwargs) -> general.PyNode: ...
    def getDriver(self, **kwargs) -> int: ...
    def setAttribute0(self, val: Union[general.PyNode, str] = ..., **kwargs: Any) -> None: ...
    def setAttribute1(self, val: Union[general.PyNode, str] = ..., **kwargs: Any) -> None: ...
    def setBlender(self, val: Union[general.PyNode, str] = ..., **kwargs: Any) -> None: ...
    def setDriver(self, val: int = ..., **kwargs: Any) -> None: ...

class BlendWeighted(Blend):
    __melnode__: str

class BlendColors(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class BlendFalloff(DependNode):
    __melnode__: str

class BlendMatrix(DependNode):
    __melnode__: str

class BlindDataTemplate(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class SubdHierBlind(BlindDataTemplate):
    __melnode__: str

class Brush(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class Bump3d(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class CacheBase(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class CacheBlend(CacheBase):
    __melnode__: str

class CacheFile(CacheBase):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCacheFormat(self, **kwargs) -> Any: ...
    def getCacheInfo(self, **kwargs) -> Any: ...
    def getCacheableAttrs(self, **kwargs) -> Any: ...
    def getChannelIndex(self, **kwargs) -> Any: ...
    def getChannelName(self, **kwargs) -> Any: ...
    def getDataSize(self, **kwargs) -> Any: ...
    def getDescriptionFileName(self, **kwargs) -> Any: ...
    def getDirectory(self, **kwargs) -> Any: ...
    def getFileName(self, **kwargs) -> Any: ...
    def getGeometry(self, **kwargs) -> Any: ...
    def getPointCount(self, **kwargs) -> Any: ...
    def getRunupFrames(self, **kwargs) -> int: ...
    def getSampleMultiplier(self, **kwargs) -> int: ...
    def getSimulationRate(self, **kwargs) -> Union[int, float]: ...
    def getStaticCache(self, **kwargs) -> Any: ...
    def replaceWithoutSimulating(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setRunupFrames(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSampleMultiplier(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSimulationRate(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...

class CameraSet(DependNode):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def appendLayer(self, camera: DagNode, set: Union[str, DependNode]) -> None: ...
    def appendTo(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def clear(self) -> None: ...
    def deleteAll(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def deleteLayer(self, index: int) -> None: ...
    def getActive(self, **kwargs) -> bool: ...
    def getCamera(self, **kwargs) -> str: ...
    def getClearDepth(self, **kwargs) -> bool: ...
    def getLayer(self, **kwargs) -> int: ...
    def getLayerCamera(self, index: int) -> DagNode: ...
    def getLayerClearDepthValue(self, index: int) -> bool: ...
    def getLayerOrder(self, index: int) -> int: ...
    def getLayerSceneData(self, index: int) -> DependNode: ...
    def getNumLayers(self) -> int: ...
    def getObjectSet(self, **kwargs) -> str: ...
    def getOrder(self, **kwargs) -> int: ...
    def insertAt(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def insertLayer(self, index: int, camera: DagNode, set: Union[str, DependNode]) -> None: ...
    def isLayerActive(self, index: int) -> bool: ...
    def setActive(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCamera(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setClearDepth(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setLayer(self, val: int = ..., **kwargs: Any) -> None: ...
    def setLayerActive(self, index: int, isActive: bool) -> None: ...
    def setLayerCamera(self, index: int, camera: DagNode) -> None: ...
    def setLayerClearDepthValue(self, index: int, depth: bool) -> None: ...
    def setLayerOrder(self, index: int, order: int) -> None: ...
    def setLayerSceneData(self, index: int, set: Union[str, DependNode]) -> None: ...
    def setObjectSet(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setOrder(self, val: int = ..., **kwargs: Any) -> None: ...

class THcameraSet(CameraSet):
    __melnode__: str

class CameraView(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def addBookmark(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def animate(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def camera(self, val: Union[general.PyNode, str] = ..., **kwargs: Any) -> None: ...
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def removeBookmark(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...
    def setCamera(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setView(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class CharacterMap(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def getMapAttr(self, **kwargs) -> Tuple[str, str]: ...
    def getMapNode(self, **kwargs) -> Any: ...
    def getMapping(self, **kwargs) -> Any: ...
    def getProposedMapping(self, **kwargs) -> Any: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...
    def setMapAttr(self, val: Tuple[str, str] = ..., **kwargs: Any) -> None: ...
    def unmapAttr(self, val: Tuple[str, str] = ..., **kwargs: Any) -> None: ...

class CharacterOffset(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class Choice(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def getIndex(self, **kwargs) -> Any: ...
    def getSelector(self, **kwargs) -> Any: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class Chooser(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class Clamp(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class ClipLibrary(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class ClipScheduler(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class ClipToGhostData(DependNode):
    __melnode__: str

class ClosestPointOnMesh(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class ColorManagementGlobals(DependNode):
    __melnode__: str

class ColorProfile(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class CombinationShape(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAllDrivers(self, **kwargs) -> Any: ...
    def getCombineMethod(self, **kwargs) -> int: ...
    def getExist(self, **kwargs) -> Any: ...
    def setCombineMethod(self, val: int = ..., **kwargs: Any) -> None: ...

class CompactPlugArrayTest(DependNode):
    __melnode__: str

class ComponentFalloff(DependNode):
    __melnode__: str

class ComponentMatch(DependNode):
    __melnode__: str

class ComposeMatrix(DependNode):
    __melnode__: str

class Condition(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class Container(ContainerBase):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    MPublishNodeType: Incomplete
    def addNode(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def clear(self) -> None: ...
    def force(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getAsset(self, **kwargs) -> Any: ...
    def getAssetMember(self, **kwargs) -> Any: ...
    def getBindAttr(self, **kwargs) -> Tuple[str, str]: ...
    def getConnectionList(self, **kwargs) -> Any: ...
    @classmethod
    def getCurrent(self) -> DependNode: ...
    def getFileName(self, **kwargs) -> Any: ...
    def getFindContainer(self, **kwargs) -> Any: ...
    def getIsContainer(self, **kwargs) -> Any: ...
    def getMembers(self) -> List[DependNode]: ...
    def getNodeList(self, **kwargs) -> Any: ...
    def getParentContainer(self) -> DependNode: ...
    def getPublishAsChild(self, **kwargs) -> Tuple[str, str]: ...
    def getPublishAsParent(self, **kwargs) -> Tuple[str, str]: ...
    def getPublishAsRoot(self, **kwargs) -> Tuple[str, bool]: ...
    def getPublishAttr(self, **kwargs) -> Any: ...
    def getPublishName(self, **kwargs) -> str: ...
    def getPublishedNames(self, unboundOnly: bool) -> List[str]: ...
    def getPublishedNodes(self, type: ContainerNode.MPublishNodeType) -> Tuple[List[str], List[DependNode]]: ...
    def getPublishedPlugs(self) -> Tuple[List[general.Attribute], List[str]]: ...
    def getRootTransform(self) -> DependNode: ...
    def getSubcontainers(self) -> List[DependNode]: ...
    def getType(self, **kwargs) -> Any: ...
    def getUnbindAttr(self, **kwargs) -> Tuple[str, str]: ...
    def getUnsortedOrder(self, **kwargs) -> Any: ...
    def includeHierarchyAbove(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def includeHierarchyBelow(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def includeNetwork(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def includeNetworkDetails(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def includeShaders(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def includeShapes(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def includeTransform(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def isCurrent(self) -> bool: ...
    def makeCurrent(self, isCurrent: bool = ...) -> None: ...
    def nodeNamePrefix(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def publishAndBind(self, val: Tuple[str, str] = ..., **kwargs: Any) -> None: ...
    def publishConnections(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def removeContainer(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def removeNode(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setBindAttr(self, val: Tuple[str, str] = ..., **kwargs: Any) -> None: ...
    def setCurrent(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setPublishAsChild(self, val: Tuple[str, str] = ..., **kwargs: Any) -> None: ...
    def setPublishAsParent(self, val: Tuple[str, str] = ..., **kwargs: Any) -> None: ...
    def setPublishAsRoot(self, val: Tuple[str, Union[bool, int]] = ..., **kwargs: Any) -> None: ...
    def setPublishName(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setUnbindAttr(self, val: Tuple[str, str] = ..., **kwargs: Any) -> None: ...
    def unbindAndUnpublish(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def unbindChild(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def unbindParent(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def unpublishChild(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def unpublishName(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def unpublishParent(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...

class BaseLattice(Shape):
    __melnode__: str

class StereoRigCamera(Camera):
    __melnode__: str

class ClusterHandle(Shape):
    __melnode__: str

class DeformFunc(Shape):
    __melnode__: str

class DeformBend(DeformFunc):
    __melnode__: str

class DeformFlare(DeformFunc):
    __melnode__: str

class DeformSine(DeformFunc):
    __melnode__: str

class DeformSquash(DeformFunc):
    __melnode__: str

class DeformTwist(DeformFunc):
    __melnode__: str

class DeformWave(DeformFunc):
    __melnode__: str

class DimensionShape(Shape):
    __melnode__: str

class AngleDimension(DimensionShape):
    __melnode__: str

class AnnotationShape(DimensionShape):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str

class DistanceDimShape(DimensionShape):
    __melnode__: str

class NurbsDimShape(DimensionShape):
    __melnode__: str

class ArcLengthDimension(NurbsDimShape):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str

class ParamDimension(NurbsDimShape):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str

class DynHolder(Shape):
    __melnode__: str

class DynamicConstraint(Shape):
    __melnode__: str

class FlexorShape(Shape):
    __melnode__: str

class ClusterFlexorShape(FlexorShape):
    __melnode__: str

class Follicle(Shape):
    __melnode__: str

class GeoConnectable(Shape):
    __melnode__: str

class BezierCurve(NurbsCurve):
    __melnode__: str

class SnapshotShape(ControlPoint):
    __melnode__: str

class MotionTrailShape(SnapshotShape):
    __melnode__: str

class THsurfaceShape(SurfaceShape):
    __melnode__: str

class FluidShape(SurfaceShape):
    __apicls__: Incomplete
    __melnode__: str
    ColorMethod: Incomplete
    CoordinateMethod: Incomplete
    FalloffMethod: Incomplete
    FluidGradient: Incomplete
    FluidMethod: Incomplete
    def create2D(self, Xres: int, Yres: int, Xdim: float, Ydim: float, parent: Union[str, DependNode] = ...) -> DependNode: ...
    def create3D(self, Xres: int, Yres: int, Zres: int, Xdim: float, Ydim: float, Zdim: float, parent: Union[str, DependNode] = ...) -> DependNode: ...
    def density(self) -> float: ...
    def emitIntoArrays(self, val: float, x: int, y: int, z: int, density: float, heat: float, fuel: float, doColor: bool, emitColor: datatypes.Color) -> None: ...
    def expandToInclude(self, min: datatypes.Point, max: datatypes.Point) -> None: ...
    def falloff(self) -> float: ...
    def fuel(self) -> float: ...
    def getColorMode(self) -> Fluid.ColorMethod: ...
    def getColors(self) -> Tuple[float, float, float]: ...
    def getCoordinateMode(self) -> Fluid.CoordinateMethod: ...
    def getCoordinates(self) -> Tuple[float, float, float]: ...
    def getDensityMode(self) -> Tuple[Fluid.FluidMethod, Fluid.FluidGradient]: ...
    def getDimensions(self) -> Tuple[float, float, float]: ...
    def getFalloffMode(self) -> Fluid.FalloffMethod: ...
    def getForceAtPoint(self, point: List[datatypes.Point], velocity: List[datatypes.Vector], mass: List[float], deltaTime: float = ...) -> List[datatypes.Vector]: ...
    def getFuelMode(self) -> Tuple[Fluid.FluidMethod, Fluid.FluidGradient]: ...
    def getResolution(self) -> Tuple[int, int, int]: ...
    def getTemperatureMode(self) -> Tuple[Fluid.FluidMethod, Fluid.FluidGradient]: ...
    def getVelocity(self) -> Tuple[float, float, float]: ...
    def getVelocityMode(self) -> Tuple[Fluid.FluidMethod, Fluid.FluidGradient]: ...
    def gridSize(self) -> int: ...
    def isAutoResize(self) -> bool: ...
    def isResizeToEmitter(self) -> bool: ...
    def pressure(self) -> float: ...
    def setColorMode(self, method: Fluid.ColorMethod) -> None: ...
    def setCoordinateMode(self, method: Fluid.CoordinateMethod) -> None: ...
    def setDensityMode(self, method: Fluid.FluidMethod, gradient: Fluid.FluidGradient) -> None: ...
    def setFalloffMode(self, method: Fluid.FalloffMethod) -> None: ...
    def setFuelMode(self, method: Fluid.FluidMethod, gradient: Fluid.FluidGradient) -> None: ...
    def setSize(self, Xres: int, Yres: int, Zres: int, Xdim: float, Ydim: float, Zdim: float, resample: bool) -> None: ...
    def setTemperatureMode(self, method: Fluid.FluidMethod, gradient: Fluid.FluidGradient) -> None: ...
    def setVelocityMode(self, method: Fluid.FluidMethod, gradient: Fluid.FluidGradient) -> None: ...
    def temperature(self) -> float: ...
    def toGridIndex(self, objectSpacePoint: datatypes.Point) -> Tuple[bool, Tuple[int, int, int]]: ...
    def updateGrid(self) -> None: ...
    def velocityGridSizes(self) -> Tuple[int, int, int]: ...
    def voxelCenterPosition(self, xi: int, yi: int, zi: int) -> datatypes.Point: ...

class FluidTexture2D(FluidShape):
    __melnode__: str

class FluidTexture3D(FluidShape):
    __melnode__: str

class HeightField(SurfaceShape):
    __melnode__: str

class GreasePlaneRenderShape(Mesh):
    __melnode__: str

class NBase(Particle):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def clearCachedTextureMap(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def clearStart(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def stuffStart(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def textureToVertex(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...

class NCloth(NBase):
    __melnode__: str

class NParticle(NBase):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def floatValue(self, val: float = ..., **kwargs: Any) -> None: ...
    def getAttribute(self, **kwargs) -> str: ...
    def getCache(self, **kwargs) -> bool: ...
    def getConserve(self, **kwargs) -> float: ...
    def getDynamicAttrList(self, **kwargs) -> Any: ...
    def getGridSpacing(self, **kwargs) -> Any: ...
    def getInherit(self, **kwargs) -> float: ...
    def getJitterBasePoint(self, **kwargs) -> Any: ...
    def getJitterRadius(self, **kwargs) -> Any: ...
    def getLowerLeft(self, **kwargs) -> Any: ...
    def getNumJitters(self, **kwargs) -> Any: ...
    def getOrder(self, **kwargs) -> int: ...
    def getParticleId(self, **kwargs) -> int: ...
    def getPerParticleDouble(self, **kwargs) -> Any: ...
    def getPerParticleVector(self, **kwargs) -> Any: ...
    def getShapeName(self, **kwargs) -> str: ...
    def getUpperRight(self, **kwargs) -> Any: ...
    def setAttribute(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setCache(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setConserve(self, val: float = ..., **kwargs: Any) -> None: ...
    def setInherit(self, val: float = ..., **kwargs: Any) -> None: ...
    def setOrder(self, val: int = ..., **kwargs: Any) -> None: ...
    def setParticleId(self, val: int = ..., **kwargs: Any) -> None: ...
    def setShapeName(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def vectorValue(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...

class NRigid(NBase):
    __melnode__: str

class DirectedDisc(GeometryShape):
    __melnode__: str

class EnvironmentFog(GeometryShape):
    __melnode__: str

class ImplicitBox(GeometryShape):
    __melnode__: str

class RenderBox(ImplicitBox):
    __melnode__: str

class ImplicitCone(GeometryShape):
    __melnode__: str

class RenderCone(ImplicitCone):
    __melnode__: str

class ImplicitSphere(GeometryShape):
    __melnode__: str

class RenderSphere(ImplicitSphere):
    __melnode__: str

class Locator(GeometryShape):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def absolute(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getPosition(self, **kwargs) -> Tuple[float, float, float]: ...
    def relative(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setPosition(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...

class THlocatorShape(Locator):
    __melnode__: str

class DropoffLocator(Locator):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str

class HikFloorContactMarker(Locator):
    __melnode__: str

class PositionMarker(Locator):
    __melnode__: str

class OrientationMarker(PositionMarker):
    __melnode__: str

class Plane(GeometryShape):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str

class SketchPlane(Plane):
    __melnode__: str

class GroundPlane(SketchPlane):
    __melnode__: str

class OrthoGrid(SketchPlane):
    __melnode__: str

class RenderRect(GeometryShape):
    __melnode__: str

class HairConstraint(Shape):
    __melnode__: str

class HairSystem(Shape):
    __melnode__: str

class ImagePlane(Shape):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def detach(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def fileName(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def getCamera(self, **kwargs) -> str: ...
    def getDropFrame(self, **kwargs) -> Any: ...
    def getFrameDuration(self, **kwargs) -> Any: ...
    def getHeight(self, **kwargs) -> float: ...
    def getImageSize(self, **kwargs) -> Any: ...
    def getLookThrough(self, **kwargs) -> str: ...
    def getMaintainRatio(self, **kwargs) -> bool: ...
    def getNegTimesOK(self, **kwargs) -> Any: ...
    def getNumFrames(self, **kwargs) -> Any: ...
    def getQuickTime(self, **kwargs) -> Any: ...
    def getShowInAllViews(self, **kwargs) -> bool: ...
    def getTimeCode(self, **kwargs) -> Any: ...
    def getTimeCodeTrack(self, **kwargs) -> Any: ...
    def getTimeScale(self, **kwargs) -> Any: ...
    def getTwentyFourHourMax(self, **kwargs) -> Any: ...
    def getWidth(self, **kwargs) -> float: ...
    def setCamera(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setHeight(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLookThrough(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setMaintainRatio(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setShowInAllViews(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setWidth(self, val: float = ..., **kwargs: Any) -> None: ...

class THimagePlane(ImagePlane):
    __melnode__: str

class GreasePlane(ImagePlane):
    __melnode__: str

class Light(Shape):
    __apicls__: Incomplete
    __melnode__: str
    def getCenterOfIllumination(self) -> float: ...
    def getColor(self) -> datatypes.Color: ...
    def getIntensity(self) -> float: ...
    def getNumShadowSamples(self) -> int: ...
    def getOpticalFXvisibility(self) -> datatypes.Color: ...
    def getRayDepthLimit(self) -> int: ...
    def getShadowColor(self) -> datatypes.Color: ...
    def getUseRayTraceShadows(self) -> bool: ...
    def lightAmbient(self) -> bool: ...
    def lightDiffuse(self) -> bool: ...
    def lightDirection(self, instance: int, space: datatypes.Space.Space = ...) -> datatypes.FloatVector: ...
    def lightIntensity(self) -> datatypes.Color: ...
    def lightSpecular(self) -> bool: ...
    def setCenterOfIllumination(self, dist: float) -> None: ...
    def setColor(self, col: datatypes.Color) -> None: ...
    def setIntensity(self, intens: float) -> None: ...
    def setNumShadowSamples(self, num_shadow_samples: int) -> None: ...
    def setOpticalFXvisibility(self, visibility: datatypes.Color) -> None: ...
    def setRayDepthLimit(self, ray_depth_limit: int) -> None: ...
    def setShadowColor(self, shadow_color: datatypes.Color) -> None: ...
    def setUseRayTraceShadows(self, useRayTraceShadows: bool) -> None: ...

class TadskAssetInstanceNode_TlightShape(Light):
    __melnode__: str

class RenderLight(Light):
    __melnode__: str

class AmbientLight(RenderLight):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAmbientShade(self) -> float: ...
    def getCastSoftShadows(self) -> bool: ...
    def getDiscRadius(self, **kwargs) -> float: ...
    def getExclusive(self, **kwargs) -> Any: ...
    def getPosition(self, **kwargs) -> Any: ...
    def getRgb(self, **kwargs) -> Any: ...
    def getRotation(self, **kwargs) -> Any: ...
    def getShadowDither(self, **kwargs) -> float: ...
    def getShadowRadius(self) -> float: ...
    def getShadowSamples(self, **kwargs) -> int: ...
    def getSoftShadow(self, **kwargs) -> bool: ...
    def setAmbientShade(self, ambient_shade: float) -> None: ...
    def setCastSoftShadows(self, cast_soft_shadows: bool) -> None: ...
    def setDiscRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setShadowDither(self, val: float = ..., **kwargs: Any) -> None: ...
    def setShadowRadius(self, shadow_radius: float) -> None: ...
    def setShadowSamples(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSoftShadow(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class NonAmbientLightShapeNode(RenderLight):
    __apicls__: Incomplete
    __melnode__: str
    def getDecayRate(self) -> int: ...
    def setDecayRate(self, decay_rate: int) -> None: ...

class NonExtendedLightShapeNode(NonAmbientLightShapeNode):
    __apicls__: Incomplete
    __melnode__: str
    def getCastSoftShadows(self) -> bool: ...
    def getDepthMapBias(self) -> float: ...
    def getDepthMapFilterSize(self) -> int: ...
    def getDepthMapFocus(self) -> float: ...
    def getDepthMapResolution(self) -> int: ...
    def getDepthMapWidthFocus(self) -> float: ...
    def getShadowRadius(self) -> float: ...
    def getUseDepthMapAutoFocus(self) -> bool: ...
    def getUseDepthMapShadows(self) -> bool: ...
    def setCastSoftShadows(self, cast_soft_shadows: bool) -> None: ...
    def setDepthMapBias(self, depth_map_bias: float) -> None: ...
    def setDepthMapFilterSize(self, depth_map_filter_size: int) -> None: ...
    def setDepthMapFocus(self, depth_map_focus: float) -> None: ...
    def setDepthMapResolution(self, depth_map_resolution: int) -> None: ...
    def setDepthMapWidthFocus(self, depth_map_width_focus: float) -> None: ...
    def setShadowRadius(self, shadow_radius: float) -> None: ...
    def setUseDepthMapAutoFocus(self, use_depth_map_auto_focus: bool) -> None: ...
    def setUseDepthMapShadows(self, use_depth_map: bool) -> None: ...

class AreaLight(NonExtendedLightShapeNode):
    __apicls__: Incomplete
    __melnode__: str

class DirectionalLight(NonExtendedLightShapeNode):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getDiscRadius(self, **kwargs) -> Any: ...
    def getExclusive(self, **kwargs) -> Any: ...
    def getRgb(self, **kwargs) -> Any: ...
    def getShadowAngle(self) -> float: ...
    def getShadowDither(self, **kwargs) -> Any: ...
    def getShadowSamples(self, **kwargs) -> Any: ...
    def getSoftShadow(self, **kwargs) -> Any: ...
    def getUseLightPosition(self) -> bool: ...
    def setShadowAngle(self, shadow_angle: float) -> None: ...
    def setUseLightPosition(self, use_light_position: bool) -> None: ...

class PointLight(NonExtendedLightShapeNode):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getDiscRadius(self, **kwargs) -> float: ...
    def getExclusive(self, **kwargs) -> bool: ...
    def getRgb(self, **kwargs) -> Tuple[float, float, float]: ...
    def getShadowDither(self, **kwargs) -> float: ...
    def getShadowSamples(self, **kwargs) -> int: ...
    def getSoftShadow(self, **kwargs) -> bool: ...
    def setDiscRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setExclusive(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setRgb(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setShadowDither(self, val: float = ..., **kwargs: Any) -> None: ...
    def setShadowSamples(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSoftShadow(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class VolumeLight(PointLight):
    __apicls__: Incomplete
    __melnode__: str
    MLightDirection: Incomplete
    MLightShape: Incomplete
    def getArc(self) -> float: ...
    def getConeEndRadius(self) -> float: ...
    def getEmitAmbient(self) -> bool: ...
    def getLightShape(self) -> VolumeLight.MLightShape: ...
    def getShadowAngle(self) -> float: ...
    def getVolumeLightDirection(self) -> VolumeLight.MLightDirection: ...
    def setArc(self, arc: float) -> None: ...
    def setConeEndRadius(self, cone_end_radius: float) -> None: ...
    def setEmitAmbient(self, emit_ambient: bool) -> None: ...
    def setLightShape(self, light_shape: VolumeLight.MLightShape) -> None: ...
    def setShadowAngle(self, shadow_angle: float) -> None: ...
    def setVolumeLightDirection(self, volume_light_direction: VolumeLight.MLightDirection) -> None: ...

class SpotLight(NonExtendedLightShapeNode):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    MBarnDoor: Incomplete
    MDecayRegion: Incomplete
    def getBarnDoorAngle(self, which_door: SpotLight.MBarnDoor) -> float: ...
    def getBarnDoors(self) -> bool: ...
    def getBottomBarnDoorAngle(self, **kwargs) -> float: ...
    def getConeAngle(self) -> float: ...
    def getDiscRadius(self, **kwargs) -> Any: ...
    def getDropOff(self) -> float: ...
    def getEndDistance(self, which_region: SpotLight.MDecayRegion) -> float: ...
    def getExclusive(self, **kwargs) -> Any: ...
    def getLeftBarnDoorAngle(self, **kwargs) -> float: ...
    def getPenumbra(self) -> float: ...
    def getRgb(self, **kwargs) -> Any: ...
    def getRightBarnDoorAngle(self, **kwargs) -> float: ...
    def getShadowDither(self, **kwargs) -> Any: ...
    def getShadowSamples(self, **kwargs) -> Any: ...
    def getSoftShadow(self, **kwargs) -> Any: ...
    def getStartDistance(self, which_region: SpotLight.MDecayRegion) -> float: ...
    def getTopBarnDoorAngle(self, **kwargs) -> float: ...
    def getUseDecayRegions(self) -> bool: ...
    def setBarnDoorAngle(self, which_door: SpotLight.MBarnDoor, barn_door_angle: float) -> None: ...
    def setBarnDoors(self, barn_doors: bool) -> None: ...
    def setBottomBarnDoorAngle(self, val: float = ..., **kwargs: Any) -> None: ...
    def setConeAngle(self, cone_angle: float) -> None: ...
    def setDropOff(self, drop_off: float) -> None: ...
    def setEndDistance(self, which_region: SpotLight.MDecayRegion, end_distance: float) -> None: ...
    def setLeftBarnDoorAngle(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPenumbra(self, penumbra_angle: float) -> None: ...
    def setRightBarnDoorAngle(self, val: float = ..., **kwargs: Any) -> None: ...
    def setStartDistance(self, which_region: SpotLight.MDecayRegion, start_distance: float) -> None: ...
    def setTopBarnDoorAngle(self, val: float = ..., **kwargs: Any) -> None: ...
    def setUseDecayRegions(self, use_decay_regions: bool) -> None: ...

class LineModifier(Shape):
    __melnode__: str

class PfxGeometry(Shape):
    __apicls__: Incomplete
    __melnode__: str
    def getBoundingBox(self) -> Tuple[float, float]: ...

class PfxHair(PfxGeometry):
    __melnode__: str

class PfxToon(PfxGeometry):
    __melnode__: str

class Stroke(PfxGeometry):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str

class RigidBody(Shape):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def deleteCache(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getActive(self, **kwargs) -> bool: ...
    def getAngularVelocity(self, **kwargs) -> Any: ...
    def getApplyForceAt(self, **kwargs) -> str: ...
    def getBounciness(self, **kwargs) -> float: ...
    def getCache(self, **kwargs) -> bool: ...
    def getCenterOfMass(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCollisions(self, **kwargs) -> bool: ...
    def getContactCount(self, **kwargs) -> Any: ...
    def getContactName(self, **kwargs) -> Any: ...
    def getContactPosition(self, **kwargs) -> Any: ...
    def getDamping(self, **kwargs) -> float: ...
    def getDynamicFriction(self, **kwargs) -> float: ...
    def getForce(self, **kwargs) -> Any: ...
    def getIgnore(self, **kwargs) -> bool: ...
    def getInitialAngularVelocity(self, **kwargs) -> Tuple[float, float, float]: ...
    def getInitialVelocity(self, **kwargs) -> Tuple[float, float, float]: ...
    def getLayer(self, **kwargs) -> int: ...
    def getLockCenterOfMass(self, **kwargs) -> bool: ...
    def getMass(self, **kwargs) -> float: ...
    def getOrientation(self, **kwargs) -> Tuple[float, float, float]: ...
    def getParticleCollision(self, **kwargs) -> bool: ...
    def getPassive(self, **kwargs) -> bool: ...
    def getPosition(self, **kwargs) -> Tuple[float, float, float]: ...
    def getRemoveShape(self, **kwargs) -> str: ...
    def getSolver(self, **kwargs) -> str: ...
    def getStandInObject(self, **kwargs) -> str: ...
    def getStaticFriction(self, **kwargs) -> float: ...
    def getTesselationFactor(self, **kwargs) -> Any: ...
    def getVelocity(self, **kwargs) -> Any: ...
    def impulse(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def impulsePosition(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setActive(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setApplyForceAt(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setBounciness(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCache(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCenterOfMass(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCollisions(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDamping(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDynamicFriction(self, val: float = ..., **kwargs: Any) -> None: ...
    def setIgnore(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setInitialAngularVelocity(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setInitialVelocity(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setLayer(self, val: int = ..., **kwargs: Any) -> None: ...
    def setLockCenterOfMass(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setMass(self, val: float = ..., **kwargs: Any) -> None: ...
    def setOrientation(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setParticleCollision(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setPassive(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setPosition(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setRemoveShape(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setSolver(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setStandInObject(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setStaticFriction(self, val: float = ..., **kwargs: Any) -> None: ...
    def spinImpulse(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...

class SoftModHandle(Shape):
    __melnode__: str

class Spring(Shape):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def allPoints(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getCount(self, **kwargs) -> Any: ...
    def getDamping(self, **kwargs) -> float: ...
    def getDampingPS(self, **kwargs) -> float: ...
    def getEndForceWeight(self, **kwargs) -> float: ...
    def getLength(self, **kwargs) -> float: ...
    def getRestLength(self, **kwargs) -> float: ...
    def getRestLengthPS(self, **kwargs) -> float: ...
    def getStartForceWeight(self, **kwargs) -> float: ...
    def getStiffness(self, **kwargs) -> float: ...
    def getStiffnessPS(self, **kwargs) -> float: ...
    def getUseDampingPS(self, **kwargs) -> bool: ...
    def getUseRestLengthPS(self, **kwargs) -> bool: ...
    def getUseStiffnessPS(self, **kwargs) -> bool: ...
    def maxDistance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDamping(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDampingPS(self, val: float = ..., **kwargs: Any) -> None: ...
    def setEndForceWeight(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLength(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRestLength(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRestLengthPS(self, val: float = ..., **kwargs: Any) -> None: ...
    def setStartForceWeight(self, val: float = ..., **kwargs: Any) -> None: ...
    def setStiffness(self, val: float = ..., **kwargs: Any) -> None: ...
    def setStiffnessPS(self, val: float = ..., **kwargs: Any) -> None: ...
    def setUseDampingPS(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setUseRestLengthPS(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setUseStiffnessPS(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class THdynSpring(Spring):
    __melnode__: str

class THcustomTransform(Transform):
    __melnode__: str

class BaseGeometryVarGroup(Transform):
    __melnode__: str
    def getRotationQuaternion(self, space: datatypes.Space.Space = ...) -> Tuple[float, float, float, float]: ...
    def setRotationQuaternion(self, x: float, y: float, z: float, w: float, space: datatypes.Space.Space = ...) -> None: ...

class CurveVarGroup(BaseGeometryVarGroup):
    __melnode__: str

class GeometryVarGroup(BaseGeometryVarGroup):
    __melnode__: str

class MeshVarGroup(BaseGeometryVarGroup):
    __melnode__: str

class SubdivSurfaceVarGroup(BaseGeometryVarGroup):
    __melnode__: str

class SurfaceVarGroup(BaseGeometryVarGroup):
    __melnode__: str

class ClipGhostShape(Transform):
    __melnode__: str

class THconstraint(Constraint):
    __melnode__: str

class AimConstraint(Constraint):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAimVector(self, **kwargs) -> Tuple[float, float, float]: ...
    def getOffset(self, **kwargs) -> Tuple[float, float, float]: ...
    def getTargetList(self, **kwargs) -> Any: ...
    def getUpVector(self, **kwargs) -> Tuple[float, float, float]: ...
    def getWeightAliasList(self, **kwargs) -> Any: ...
    def getWorldUpObject(self, **kwargs) -> general.PyNode: ...
    def getWorldUpType(self, **kwargs) -> str: ...
    def getWorldUpVector(self, **kwargs) -> Tuple[float, float, float]: ...
    def layer(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setAimVector(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setOffset(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setUpVector(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setWorldUpObject(self, val: Union[general.PyNode, str] = ..., **kwargs: Any) -> None: ...
    def setWorldUpType(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setWorldUpVector(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def skip(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...

class LookAt(AimConstraint):
    __melnode__: str

class GeometryConstraint(Constraint):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getTargetList(self, **kwargs) -> Any: ...
    def getWeightAliasList(self, **kwargs) -> Any: ...
    def layer(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class NormalConstraint(Constraint):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAimVector(self, **kwargs) -> Tuple[float, float, float]: ...
    def getTargetList(self, **kwargs) -> Any: ...
    def getUpVector(self, **kwargs) -> Tuple[float, float, float]: ...
    def getWeightAliasList(self, **kwargs) -> Any: ...
    def getWorldUpObject(self, **kwargs) -> general.PyNode: ...
    def getWorldUpType(self, **kwargs) -> str: ...
    def getWorldUpVector(self, **kwargs) -> Tuple[float, float, float]: ...
    def layer(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setAimVector(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setUpVector(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setWorldUpObject(self, val: Union[general.PyNode, str] = ..., **kwargs: Any) -> None: ...
    def setWorldUpType(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setWorldUpVector(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...

class OldNormalConstraint(Constraint):
    __melnode__: str

class OldTangentConstraint(Constraint):
    __melnode__: str

class OrientConstraint(Constraint):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def createCache(self, val: Tuple[float, float] = ..., **kwargs: Any) -> None: ...
    def deleteCache(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getOffset(self, **kwargs) -> Tuple[float, float, float]: ...
    def getTargetList(self, **kwargs) -> Any: ...
    def getWeightAliasList(self, **kwargs) -> Any: ...
    def layer(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setOffset(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def skip(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...

class ParentConstraint(Constraint):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def createCache(self, val: Tuple[float, float] = ..., **kwargs: Any) -> None: ...
    def deleteCache(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getTargetList(self, **kwargs) -> Any: ...
    def getWeightAliasList(self, **kwargs) -> Any: ...
    def layer(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PointConstraint(Constraint):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getOffset(self, **kwargs) -> Tuple[float, float, float]: ...
    def getTargetList(self, **kwargs) -> Any: ...
    def getWeightAliasList(self, **kwargs) -> Any: ...
    def layer(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setOffset(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def skip(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...

class PoleVectorConstraint(PointConstraint):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getTargetList(self, **kwargs) -> Any: ...
    def getWeightAliasList(self, **kwargs) -> Any: ...
    def layer(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PointOnPolyConstraint(Constraint):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getOffset(self, **kwargs) -> Tuple[float, float, float]: ...
    def getTargetList(self, **kwargs) -> Any: ...
    def getWeightAliasList(self, **kwargs) -> Any: ...
    def layer(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setOffset(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def skip(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...

class ScaleConstraint(Constraint):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getOffset(self, **kwargs) -> Tuple[float, float, float]: ...
    def getTargetList(self, **kwargs) -> Any: ...
    def getWeightAliasList(self, **kwargs) -> Any: ...
    def layer(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def scaleCompensate(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setOffset(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def skip(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...

class SymmetryConstraint(Constraint):
    __melnode__: str

class TangentConstraint(Constraint):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAimVector(self, **kwargs) -> Tuple[float, float, float]: ...
    def getTargetList(self, **kwargs) -> Any: ...
    def getUpVector(self, **kwargs) -> Tuple[float, float, float]: ...
    def getWeightAliasList(self, **kwargs) -> Any: ...
    def getWorldUpObject(self, **kwargs) -> general.PyNode: ...
    def getWorldUpType(self, **kwargs) -> str: ...
    def getWorldUpVector(self, **kwargs) -> Tuple[float, float, float]: ...
    def layer(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setAimVector(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setUpVector(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setWorldUpObject(self, val: Union[general.PyNode, str] = ..., **kwargs: Any) -> None: ...
    def setWorldUpType(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setWorldUpVector(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...

class DagContainer(Transform):
    __melnode__: str
    def getRotationQuaternion(self, space: datatypes.Space.Space = ...) -> Tuple[float, float, float, float]: ...
    def setRotationQuaternion(self, x: float, y: float, z: float, w: float, space: datatypes.Space.Space = ...) -> None: ...

class Assembly(DagContainer):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def activate(self, representation: str) -> None: ...
    def activateNonRecursive(self, representation: str) -> None: ...
    def canActivate(self) -> bool: ...
    def canRepApplyEdits(self, representation: str) -> bool: ...
    def createRepresentation(self, input: str, type: str, undoRedo: datatypes.DagModifier = ...) -> str: ...
    def deleteAllRepresentations(self) -> None: ...
    def deleteRepresentation(self, representation: str) -> None: ...
    def deregister(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def getAbsoluteRepNamespace(self) -> str: ...
    def getActive(self) -> str: ...
    def getActiveLabel(self, **kwargs) -> str: ...
    def getCanCreate(self, **kwargs) -> Any: ...
    def getCreateOptionBoxProc(self, **kwargs) -> Union[str, Callable]: ...
    def getDefaultType(self, **kwargs) -> str: ...
    def getInitialRep(self) -> str: ...
    def getIsAType(self, **kwargs) -> Any: ...
    def getIsTrackingMemberEdits(self, **kwargs) -> Any: ...
    def getLabel(self, **kwargs) -> str: ...
    def getListRepTypes(self, **kwargs) -> Any: ...
    def getListRepTypesProc(self, **kwargs) -> Union[str, Callable]: ...
    def getListRepresentations(self, **kwargs) -> Any: ...
    def getListTypes(self, **kwargs) -> Any: ...
    def getParentAssembly(self) -> DependNode: ...
    def getPostCreateUIProc(self, **kwargs) -> Union[str, Callable]: ...
    def getRepLabel(self, representation: str) -> str: ...
    def getRepNamespace(self) -> str: ...
    def getRepPostCreateUIProc(self, **kwargs) -> str: ...
    def getRepPreCreateUIProc(self, **kwargs) -> str: ...
    def getRepType(self, representation: str) -> str: ...
    def getRepTypeLabel(self, **kwargs) -> Any: ...
    def getRepTypeLabelProc(self, **kwargs) -> Union[str, Callable]: ...
    def getRepresentations(self) -> List[str]: ...
    def getSubAssemblies(self) -> List[DependNode]: ...
    @classmethod
    def getTopLevelAssemblies(self) -> List[DependNode]: ...
    def getType(self, **kwargs) -> str: ...
    def handlesAddEdits(self) -> bool: ...
    def importFile(self, fileName: str, type: str = ..., preserveReferences: bool = ..., nameSpace: str = ..., ignoreVersion: bool = ...) -> None: ...
    def input(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def isActive(self, representation: str) -> bool: ...
    def isTopLevel(self) -> bool: ...
    def newRepLabel(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def postLoad(self) -> None: ...
    def proc(self, val: Union[str, Callable] = ..., **kwargs: Any) -> None: ...
    def renameRepresentation(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def repName(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def repTypes(self) -> List[str]: ...
    def setActive(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setActiveLabel(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setCreateOptionBoxProc(self, val: Union[str, Callable] = ..., **kwargs: Any) -> None: ...
    def setDefaultType(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setLabel(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setListRepTypesProc(self, val: Union[str, Callable] = ..., **kwargs: Any) -> None: ...
    def setPostCreateUIProc(self, val: Union[str, Callable] = ..., **kwargs: Any) -> None: ...
    def setRepLabel(self, representation: str, label: str) -> None: ...
    def setRepName(self, representation: str, newName: str) -> str: ...
    def setRepPostCreateUIProc(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setRepPreCreateUIProc(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setRepTypeLabelProc(self, val: Union[str, Callable] = ..., **kwargs: Any) -> None: ...
    def setType(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def supportsEdits(self) -> bool: ...
    def supportsMemberChanges(self) -> bool: ...

class THassembly(Assembly):
    __melnode__: str

class CollisionModel(DynBase):
    __melnode__: str

class Field(DynBase):
    __apicls__: Incomplete
    __melnode__: str
    def falloffCurve(self, param: float) -> float: ...
    def getAttenuation(self) -> float: ...
    def getForceAtPoint(self, point: List[datatypes.Point], velocity: List[datatypes.Vector], mass: List[float], deltaTime: float = ...) -> List[datatypes.Vector]: ...
    def getMagnitude(self) -> float: ...
    def getMaxDistance(self) -> float: ...
    def getPerVertex(self) -> bool: ...
    def getUseMaxDistance(self) -> bool: ...
    def isFalloffCurveConstantOne(self) -> bool: ...
    def setAttenuation(self, atten: float) -> None: ...
    def setMagnitude(self, mag: float) -> None: ...
    def setMaxDistance(self, dist: float) -> None: ...
    def setPerVertex(self, enable: bool) -> None: ...
    def setUseMaxDistance(self, enable: bool) -> None: ...

class THdynField(Field):
    __melnode__: str

class AirField(Field):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def fanSetup(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getComponentOnly(self) -> bool: ...
    def getDirection(self) -> datatypes.Vector: ...
    def getDirectionX(self, **kwargs) -> float: ...
    def getDirectionY(self, **kwargs) -> float: ...
    def getDirectionZ(self, **kwargs) -> float: ...
    def getEnableSpread(self) -> bool: ...
    def getInheritRotation(self) -> bool: ...
    def getInheritVelocity(self) -> float: ...
    def getPosition(self, **kwargs) -> Tuple[float, float, float]: ...
    def getSpeed(self) -> float: ...
    def getSpread(self) -> float: ...
    def getTorusSectionRadius(self, **kwargs) -> float: ...
    def getVelocityComponentOnly(self, **kwargs) -> bool: ...
    def getVolumeExclusion(self, **kwargs) -> bool: ...
    def getVolumeOffset(self, **kwargs) -> Tuple[float, float, float]: ...
    def getVolumeShape(self, **kwargs) -> str: ...
    def getVolumeSweep(self, **kwargs) -> float: ...
    def setComponentOnly(self, enable: bool) -> None: ...
    def setDirection(self, airDirection: datatypes.Vector) -> None: ...
    def setDirectionX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDirectionY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDirectionZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setEnableSpread(self, enable: bool) -> None: ...
    def setInheritRotation(self, enable: bool) -> None: ...
    def setInheritVelocity(self, velocity: float) -> None: ...
    def setPosition(self, val: Union[Tuple[float, float, float], List[Tuple[float, float, float]]] = ..., **kwargs: Any) -> None: ...
    def setSpeed(self, value: float) -> None: ...
    def setSpread(self, value: float) -> None: ...
    def setTorusSectionRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setVelocityComponentOnly(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setVolumeExclusion(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setVolumeOffset(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setVolumeShape(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setVolumeSweep(self, val: float = ..., **kwargs: Any) -> None: ...
    def wakeSetup(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def windSetup(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class DragField(Field):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getDirection(self) -> datatypes.Vector: ...
    def getDirectionX(self, **kwargs) -> float: ...
    def getDirectionY(self, **kwargs) -> float: ...
    def getDirectionZ(self, **kwargs) -> float: ...
    def getTorusSectionRadius(self, **kwargs) -> float: ...
    def getUseDirection(self) -> bool: ...
    def getVolumeExclusion(self, **kwargs) -> bool: ...
    def getVolumeOffset(self, **kwargs) -> Tuple[float, float, float]: ...
    def getVolumeShape(self, **kwargs) -> str: ...
    def getVolumeSweep(self, **kwargs) -> float: ...
    def setDirection(self, dragDirection: datatypes.Vector) -> None: ...
    def setDirectionX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDirectionY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDirectionZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTorusSectionRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setUseDirection(self, enable: bool) -> None: ...
    def setVolumeExclusion(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setVolumeOffset(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setVolumeShape(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setVolumeSweep(self, val: float = ..., **kwargs: Any) -> None: ...

class GravityField(Field):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getDirection(self) -> datatypes.Vector: ...
    def getDirectionX(self, **kwargs) -> float: ...
    def getDirectionY(self, **kwargs) -> float: ...
    def getDirectionZ(self, **kwargs) -> float: ...
    def getTorusSectionRadius(self, **kwargs) -> float: ...
    def getVolumeExclusion(self, **kwargs) -> bool: ...
    def getVolumeOffset(self, **kwargs) -> Tuple[float, float, float]: ...
    def getVolumeShape(self, **kwargs) -> str: ...
    def getVolumeSweep(self, **kwargs) -> float: ...
    def setDirection(self, gravityDirection: datatypes.Vector) -> None: ...
    def setDirectionX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDirectionY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDirectionZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTorusSectionRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setVolumeExclusion(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setVolumeOffset(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setVolumeShape(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setVolumeSweep(self, val: float = ..., **kwargs: Any) -> None: ...

class NewtonField(Field):
    __apicls__: Incomplete
    __melnode__: str
    def getMinDistance(self) -> float: ...
    def setMinDistance(self, distance: float) -> None: ...

class RadialField(Field):
    __apicls__: Incomplete
    __melnode__: str
    def getRadialType(self) -> float: ...
    def setRadialType(self, value: float) -> None: ...

class TurbulenceField(Field):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getFrequency(self) -> float: ...
    def getNoiseLevel(self, **kwargs) -> int: ...
    def getNoiseRatio(self, **kwargs) -> float: ...
    def getPhase(self) -> float: ...
    def getPhaseX(self, **kwargs) -> float: ...
    def getPhaseY(self, **kwargs) -> float: ...
    def getPhaseZ(self, **kwargs) -> float: ...
    def getTorusSectionRadius(self, **kwargs) -> float: ...
    def getVolumeExclusion(self, **kwargs) -> bool: ...
    def getVolumeOffset(self, **kwargs) -> Tuple[float, float, float]: ...
    def getVolumeShape(self, **kwargs) -> str: ...
    def getVolumeSweep(self, **kwargs) -> float: ...
    def setFrequency(self, value: float) -> None: ...
    def setNoiseLevel(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNoiseRatio(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPhase(self, value: float) -> None: ...
    def setPhaseX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPhaseY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPhaseZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTorusSectionRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setVolumeExclusion(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setVolumeOffset(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setVolumeShape(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setVolumeSweep(self, val: float = ..., **kwargs: Any) -> None: ...

class UniformField(Field):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getDirection(self) -> datatypes.Vector: ...
    def getDirectionX(self, **kwargs) -> float: ...
    def getDirectionY(self, **kwargs) -> float: ...
    def getDirectionZ(self, **kwargs) -> float: ...
    def getTorusSectionRadius(self, **kwargs) -> float: ...
    def getVolumeExclusion(self, **kwargs) -> bool: ...
    def getVolumeOffset(self, **kwargs) -> Tuple[float, float, float]: ...
    def getVolumeShape(self, **kwargs) -> str: ...
    def getVolumeSweep(self, **kwargs) -> float: ...
    def setDirection(self, uniformDirection: datatypes.Vector) -> None: ...
    def setDirectionX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDirectionY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDirectionZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTorusSectionRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setVolumeExclusion(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setVolumeOffset(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setVolumeShape(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setVolumeSweep(self, val: float = ..., **kwargs: Any) -> None: ...

class VolumeAxisField(Field):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def detailTurbulence(self) -> float: ...
    def getDetailTurbulence(self, **kwargs) -> float: ...
    def getDirection(self) -> datatypes.Vector: ...
    def getDirectionX(self, **kwargs) -> float: ...
    def getDirectionY(self, **kwargs) -> float: ...
    def getDirectionZ(self, **kwargs) -> float: ...
    def getDirectionalSpeed(self) -> float: ...
    def getInvertAttenuation(self) -> bool: ...
    def getSpeedAlongAxis(self) -> float: ...
    def getSpeedAroundAxis(self) -> float: ...
    def getSpeedAwayFromAxis(self) -> float: ...
    def getSpeedAwayFromCenter(self) -> float: ...
    def getTorusSectionRadius(self, **kwargs) -> float: ...
    def getTurbulence(self) -> float: ...
    def getTurbulenceFrequency(self) -> datatypes.Vector: ...
    def getTurbulenceFrequencyX(self, **kwargs) -> float: ...
    def getTurbulenceFrequencyY(self, **kwargs) -> float: ...
    def getTurbulenceFrequencyZ(self, **kwargs) -> float: ...
    def getTurbulenceOffset(self) -> datatypes.Vector: ...
    def getTurbulenceOffsetX(self, **kwargs) -> float: ...
    def getTurbulenceOffsetY(self, **kwargs) -> float: ...
    def getTurbulenceOffsetZ(self, **kwargs) -> float: ...
    def getTurbulenceSpeed(self) -> float: ...
    def getVolumeExclusion(self, **kwargs) -> bool: ...
    def getVolumeOffset(self, **kwargs) -> Tuple[float, float, float]: ...
    def getVolumeShape(self, **kwargs) -> str: ...
    def getVolumeSweep(self, **kwargs) -> float: ...
    def setDetailTurbulence(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDirection(self, direction: datatypes.Vector) -> None: ...
    def setDirectionX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDirectionY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDirectionZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDirectionalSpeed(self, speed: float) -> None: ...
    def setInvertAttenuation(self, enable: bool) -> None: ...
    def setSpeedAlongAxis(self, speed: float) -> None: ...
    def setSpeedAroundAxis(self, speed: float) -> None: ...
    def setSpeedAwayFromAxis(self, speed: float) -> None: ...
    def setSpeedAwayFromCenter(self, speed: float) -> None: ...
    def setTorusSectionRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTurbulence(self, value: float) -> None: ...
    def setTurbulenceFrequency(self, value: datatypes.Vector) -> None: ...
    def setTurbulenceFrequencyX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTurbulenceFrequencyY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTurbulenceFrequencyZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTurbulenceOffset(self, value: datatypes.Vector) -> None: ...
    def setTurbulenceOffsetX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTurbulenceOffsetY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTurbulenceOffsetZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTurbulenceSpeed(self, value: float) -> None: ...
    def setVolumeExclusion(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setVolumeOffset(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setVolumeShape(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setVolumeSweep(self, val: float = ..., **kwargs: Any) -> None: ...

class VortexField(Field):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAxis(self) -> datatypes.Vector: ...
    def getAxisX(self, **kwargs) -> float: ...
    def getAxisY(self, **kwargs) -> float: ...
    def getAxisZ(self, **kwargs) -> float: ...
    def getTorusSectionRadius(self, **kwargs) -> float: ...
    def getVolumeExclusion(self, **kwargs) -> bool: ...
    def getVolumeOffset(self, **kwargs) -> Tuple[float, float, float]: ...
    def getVolumeShape(self, **kwargs) -> str: ...
    def getVolumeSweep(self, **kwargs) -> float: ...
    def setAxis(self, axisVector: datatypes.Vector) -> None: ...
    def setAxisX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setAxisY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setAxisZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTorusSectionRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setVolumeExclusion(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setVolumeOffset(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setVolumeShape(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setVolumeSweep(self, val: float = ..., **kwargs: Any) -> None: ...

class THdynEmitter(PointEmitter):
    __melnode__: str

class THfluidEmitter(FluidEmitter):
    __melnode__: str

class FosterParent(Transform):
    __melnode__: str

class HikEffector(Transform):
    __apicls__: Incomplete
    __melnode__: str
    def getAuxiliaryEffectors(self) -> List[DependNode]: ...
    def getEffColor(self) -> datatypes.Color: ...
    def getPivotOffset(self) -> datatypes.Vector: ...
    def setEffColor(self, color: datatypes.Color) -> None: ...
    def setPivotOffset(self, vector: datatypes.Vector) -> None: ...

class HikGroundPlane(Transform):
    __melnode__: str
    def getRotationQuaternion(self, space: datatypes.Space.Space = ...) -> Tuple[float, float, float, float]: ...
    def setRotationQuaternion(self, x: float, y: float, z: float, w: float, space: datatypes.Space.Space = ...) -> None: ...

class HikIKEffector(Transform):
    __melnode__: str
    def getRotationQuaternion(self, space: datatypes.Space.Space = ...) -> Tuple[float, float, float, float]: ...
    def setRotationQuaternion(self, x: float, y: float, z: float, w: float, space: datatypes.Space.Space = ...) -> None: ...

class IkEffector(Transform):
    __apicls__: Incomplete
    __melnode__: str

class IkHandle(Transform):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    Stickiness: Incomplete
    def autoPriority(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def connectEffector(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def disableHandles(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def enableHandles(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def freezeJoints(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getCurve(self, **kwargs) -> general.PyNode: ...
    def getEffector(self) -> DagNode: ...
    def getEndEffector(self, **kwargs) -> str: ...
    def getForceSolver(self, **kwargs) -> bool: ...
    def getPositionWeight(self, **kwargs) -> float: ...
    def getPriority(self) -> int: ...
    def getRootOnCurve(self, **kwargs) -> bool: ...
    def getRootTwistMode(self, **kwargs) -> bool: ...
    def getSnapHandleFlagToggle(self, **kwargs) -> bool: ...
    def getSolver(self) -> DependNode: ...
    def getStartJoint(self) -> DagNode: ...
    def getStickiness(self) -> IkHandle.Stickiness: ...
    def getSticky(self, **kwargs) -> str: ...
    def getTwistType(self, **kwargs) -> str: ...
    def getWeight(self) -> float: ...
    def jointList(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def poWeight(self) -> float: ...
    def setCurve(self, val: Union[general.PyNode, str] = ..., **kwargs: Any) -> None: ...
    def setEffector(self, effectorPath: DagNode) -> None: ...
    def setEndEffector(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setForceSolver(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setPOWeight(self, poWeight: float) -> None: ...
    def setPositionWeight(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPriority(self, priority: int) -> None: ...
    def setRootOnCurve(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setRootTwistMode(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSnapHandleFlagToggle(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSolver(self, solver: Union[str, DependNode]) -> None: ...
    def setStartJoint(self, jointPath: DagNode) -> None: ...
    def setStartJointAndEffector(self, jointPath: DagNode, effectorPath: DagNode) -> None: ...
    def setStickiness(self, stickiness: IkHandle.Stickiness) -> None: ...
    def setSticky(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setTwistType(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setWeight(self, weight: float) -> None: ...
    def setupForRPsolver(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def snapHandleToEffector(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class Instancer(Transform):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def addObject(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def allInstances(self) -> Tuple[List[DagNode], List[datatypes.Matrix], List[int], List[int]]: ...
    def getCycle(self, **kwargs) -> str: ...
    def getCycleStep(self, **kwargs) -> float: ...
    def getCycleStepUnits(self, **kwargs) -> str: ...
    def getIndex(self, **kwargs) -> Any: ...
    def getLevelOfDetail(self, **kwargs) -> str: ...
    def getObject(self, **kwargs) -> str: ...
    def getObjectPosition(self, **kwargs) -> Any: ...
    def getObjectRotation(self, **kwargs) -> Any: ...
    def getObjectScale(self, **kwargs) -> Any: ...
    def getPointDataSource(self, **kwargs) -> Any: ...
    def getRotationUnits(self, **kwargs) -> str: ...
    def getValueName(self, **kwargs) -> Any: ...
    def instancesForParticle(self, p: int) -> Tuple[int, List[DagNode], datatypes.Matrix]: ...
    def particleCount(self) -> int: ...
    def removeObject(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCycle(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setCycleStep(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCycleStepUnits(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setLevelOfDetail(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setObject(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def setRotationUnits(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...

class HikFKJoint(Joint):
    __melnode__: str

class LodGroup(Transform):
    __melnode__: str
    def getRotationQuaternion(self, space: datatypes.Space.Space = ...) -> Tuple[float, float, float, float]: ...
    def setRotationQuaternion(self, x: float, y: float, z: float, w: float, space: datatypes.Space.Space = ...) -> None: ...

class Nucleus(Transform):
    __melnode__: str
    def getRotationQuaternion(self, space: datatypes.Space.Space = ...) -> Tuple[float, float, float, float]: ...
    def setRotationQuaternion(self, x: float, y: float, z: float, w: float, space: datatypes.Space.Space = ...) -> None: ...

class Place3dTexture(Transform):
    __melnode__: str
    def getRotationQuaternion(self, space: datatypes.Space.Space = ...) -> Tuple[float, float, float, float]: ...
    def setRotationQuaternion(self, x: float, y: float, z: float, w: float, space: datatypes.Space.Space = ...) -> None: ...

class PrimitiveFalloff(Transform):
    __melnode__: str

class RigidConstraint(Transform):
    __melnode__: str
    def getRotationQuaternion(self, space: datatypes.Space.Space = ...) -> Tuple[float, float, float, float]: ...
    def setRotationQuaternion(self, x: float, y: float, z: float, w: float, space: datatypes.Space.Space = ...) -> None: ...

class TextureDeformerHandle(Transform):
    __melnode__: str

class UfeProxyTransform(Transform):
    __melnode__: str

class UnknownTransform(Transform):
    __melnode__: str
    def getRotationQuaternion(self, space: datatypes.Space.Space = ...) -> Tuple[float, float, float, float]: ...
    def setRotationQuaternion(self, x: float, y: float, z: float, w: float, space: datatypes.Space.Space = ...) -> None: ...

class UnknownDag(DagNode):
    __melnode__: str

class THobjectSet(ObjectSet):
    __melnode__: str

class BakeSet(ObjectSet):
    __melnode__: str

class TextureBakeSet(BakeSet):
    __melnode__: str

class VertexBakeSet(BakeSet):
    __melnode__: str

class Character(ObjectSet):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def addElement(self, val: Union[general.PyNode, str] = ..., **kwargs: Any) -> None: ...
    def blendExists(self, instancedClip1: Union[str, DependNode], instancedClip2: Union[str, DependNode], blendResult: Union[str, DependNode]) -> bool: ...
    def flatten(self, val: Union[general.PyNode, str] = ..., **kwargs: Any) -> None: ...
    def getAddOffsetObject(self, **kwargs) -> str: ...
    def getBlend(self, index: int) -> DependNode: ...
    def getBlendClips(self, index: int) -> Tuple[DependNode, DependNode]: ...
    def getBlendCount(self) -> int: ...
    def getCharacterPlug(self, **kwargs) -> Any: ...
    def getCharacterThatOwnsPlug(self, plug: Union[str, general.Attribute], result: Union[str, DependNode]) -> bool: ...
    def getClipScheduler(self) -> DependNode: ...
    def getIsIntersecting(self, **kwargs) -> Any: ...
    def getIsMember(self, **kwargs) -> Any: ...
    def getLibrary(self, **kwargs) -> Any: ...
    def getMemberIndex(self, **kwargs) -> Any: ...
    def getMemberPlugs(self) -> List[general.Attribute]: ...
    def getNodesOnly(self, **kwargs) -> Any: ...
    def getOffsetNode(self, **kwargs) -> Any: ...
    def getScheduledClip(self, index: int) -> DependNode: ...
    def getScheduledClipCount(self) -> int: ...
    def getScheduler(self, **kwargs) -> Any: ...
    def getSourceClip(self, index: int) -> DependNode: ...
    def getSourceClipCount(self) -> int: ...
    def getSubCharacters(self) -> SelectionSet: ...
    def getSubtract(self, **kwargs) -> Any: ...
    def getText(self, **kwargs) -> str: ...
    def getUserAlias(self, **kwargs) -> Any: ...
    def include(self, val: Union[general.PyNode, str] = ..., **kwargs: Any) -> None: ...
    def removeOffsetObject(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setAddOffsetObject(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setText(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...

class CreaseSet(ObjectSet):
    __melnode__: str

class KeyingGroup(ObjectSet):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def addElement(self, val: Union[general.PyNode, str] = ..., **kwargs: Any) -> None: ...
    def afterFilters(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def flatten(self, val: Union[general.PyNode, str] = ..., **kwargs: Any) -> None: ...
    def getActivator(self, **kwargs) -> general.PyNode: ...
    def getCategory(self, **kwargs) -> str: ...
    def getColor(self, **kwargs) -> int: ...
    def getEdges(self, **kwargs) -> Any: ...
    def getEditPoints(self, **kwargs) -> Any: ...
    def getFacets(self, **kwargs) -> Any: ...
    def getMinimizeRotation(self, **kwargs) -> bool: ...
    def getNoIntermediate(self, **kwargs) -> Any: ...
    def getNodesOnly(self, **kwargs) -> Any: ...
    def getRenderable(self, **kwargs) -> Any: ...
    def getSetActiveFilter(self, **kwargs) -> str: ...
    def getSize(self, **kwargs) -> Any: ...
    def getText(self, **kwargs) -> str: ...
    def getVertices(self, **kwargs) -> Any: ...
    def include(self, val: Union[general.PyNode, str] = ..., **kwargs: Any) -> None: ...
    def removeActivator(self, val: Union[general.PyNode, str] = ..., **kwargs: Any) -> None: ...
    def setActivator(self, val: Union[general.PyNode, str] = ..., **kwargs: Any) -> None: ...
    def setCategory(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setColor(self, val: int = ..., **kwargs: Any) -> None: ...
    def setMinimizeRotation(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSetActiveFilter(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setText(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...

class Partition(Entity):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    Restriction: Incomplete
    def addMember(self, set: Union[str, DependNode]) -> None: ...
    def getRender(self, **kwargs) -> Any: ...
    def isRenderPartition(self) -> bool: ...
    def removeMember(self, set: Union[str, DependNode]) -> None: ...

class Contrast(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class Controller(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAllControllers(self, **kwargs) -> Any: ...
    def getChildren(self, **kwargs) -> Any: ...
    def getGroup(self, **kwargs) -> Any: ...
    def getIndex(self, **kwargs) -> int: ...
    def getIsController(self, **kwargs) -> Any: ...
    def getParent(self, **kwargs) -> bool: ...
    def getPickWalkDown(self, **kwargs) -> Any: ...
    def getPickWalkLeft(self, **kwargs) -> Any: ...
    def getPickWalkRight(self, **kwargs) -> Any: ...
    def getPickWalkUp(self, **kwargs) -> Any: ...
    def setIndex(self, val: int = ..., **kwargs: Any) -> None: ...
    def setParent(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def unparent(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class CopyColorSet(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class CopyUVSet(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class CreateColorSet(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class CreateUVSet(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class CurveFromMesh(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class CurveFromMeshCoM(CurveFromMesh):
    __melnode__: str

class CurveFromMeshEdge(CurveFromMesh):
    __melnode__: str

class CurveNormalizer(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class CurveNormalizerAngle(CurveNormalizer):
    __melnode__: str

class CurveNormalizerLinear(CurveNormalizer):
    __melnode__: str

class DagPose(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getAtPose(self, **kwargs) -> Any: ...
    def getBindPose(self, **kwargs) -> Any: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def getMembers(self, **kwargs) -> Any: ...
    def getSelection(self, **kwargs) -> Any: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class DataBlockTest(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class DecomposeMatrix(DependNode):
    __melnode__: str

class DefaultLightList(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class DefaultRenderUtilityList(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class DefaultRenderingList(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class DefaultShaderList(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class DefaultTextureList(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class DeleteColorSet(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class DeleteComponent(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class DeleteUVSet(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class DiskCache(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getAppend(self, **kwargs) -> Any: ...
    def getCacheType(self, **kwargs) -> Any: ...
    def getClose(self, **kwargs) -> Any: ...
    def getCloseAll(self, **kwargs) -> Any: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def getDelete(self, **kwargs) -> Any: ...
    def getDeleteAll(self, **kwargs) -> Any: ...
    def getEmpty(self, **kwargs) -> Any: ...
    def getEmptyAll(self, **kwargs) -> Any: ...
    def getEnabledCachesOnly(self, **kwargs) -> Any: ...
    def getEndTime(self, **kwargs) -> Any: ...
    def getFrameRangeType(self, **kwargs) -> Any: ...
    def getOverSample(self, **kwargs) -> Any: ...
    def getSamplingRate(self, **kwargs) -> Any: ...
    def getStartTime(self, **kwargs) -> Any: ...
    def getTempDir(self, **kwargs) -> Any: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class DisplacementShader(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class DisplayLayerManager(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class DistanceBetween(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class Dof(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class DynController(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class DynGlobals(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getActive(self, **kwargs) -> Any: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def getListAll(self, **kwargs) -> Any: ...
    def getOverSampling(self, **kwargs) -> int: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...
    def setOverSampling(self, val: int = ..., **kwargs: Any) -> None: ...

class EditMetadata(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getChannelName(self, **kwargs) -> Any: ...
    def getChannelType(self, **kwargs) -> Any: ...
    def getIndex(self, **kwargs) -> Any: ...
    def getIndexType(self, **kwargs) -> Any: ...
    def getScene(self, **kwargs) -> Any: ...
    def getStreamName(self, **kwargs) -> Any: ...

class EditsManager(DependNode):
    __melnode__: str

class Expression(DependNode):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    UnitConversion: Incomplete
    def evaluate(self) -> List[float]: ...
    def getAlwaysEvaluate(self, **kwargs) -> int: ...
    def getAnimated(self, **kwargs) -> int: ...
    def getAttribute(self, **kwargs) -> str: ...
    def getDefaultObject(self) -> DependNode: ...
    def getExpression(self) -> str: ...
    def getObject(self, **kwargs) -> str: ...
    def getSafe(self, **kwargs) -> Any: ...
    def getShortNames(self, **kwargs) -> bool: ...
    def getString(self, **kwargs) -> str: ...
    def getTimeDependent(self, **kwargs) -> Any: ...
    def getUnitConversion(self) -> Expression.UnitConversion: ...
    def isAnimated(self) -> bool: ...
    def setAlwaysEvaluate(self, val: int = ..., **kwargs: Any) -> None: ...
    def setAnimated(self, value: bool = ...) -> None: ...
    def setAttribute(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setDefaultObject(self, object: Union[str, DependNode]) -> None: ...
    def setExpression(self, expression: str) -> None: ...
    def setObject(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setShortNames(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setString(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setUnitConversion(self, conversion: Expression.UnitConversion) -> None: ...

class Facade(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class EnvFacade(Facade):
    __melnode__: str

class AISEnvFacade(EnvFacade):
    __melnode__: str

class MaterialFacade(Facade):
    __melnode__: str

class FalloffEval(DependNode):
    __melnode__: str

class Flow(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def getDivisions(self, **kwargs) -> Any: ...
    def getLocalCompute(self, **kwargs) -> Any: ...
    def getLocalDivisions(self, **kwargs) -> Any: ...
    def getObjectCentered(self, **kwargs) -> Any: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class FourByFourMatrix(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class FrameCache(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class GammaCorrect(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class GeoConnector(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class GeomBind(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getFalloff(self, **kwargs) -> float: ...
    def getGeodesicVoxelParams(self, **kwargs) -> Tuple[int, bool]: ...
    def getMaxInfluences(self, **kwargs) -> int: ...
    def setFalloff(self, val: float = ..., **kwargs: Any) -> None: ...
    def setGeodesicVoxelParams(self, val: Tuple[int, Union[bool, int]] = ..., **kwargs: Any) -> None: ...
    def setMaxInfluences(self, val: int = ..., **kwargs: Any) -> None: ...

class THgeometryFilter(GeometryFilter):
    __melnode__: str

class BlendShape(GeometryFilter):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    HistoryLocation: Incomplete
    Origin: Incomplete
    TargetType: Incomplete
    def addBaseObject(self, object: Union[str, DependNode]) -> None: ...
    def addTarget(self, baseObject: Union[str, DependNode], weightIndex: int, newTarget: Union[str, DependNode], fullWeight: float, targetType: BlendShapeDeformer.TargetType = ...) -> None: ...
    def after(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def afterReference(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def automatic(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def before(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def copyDelta(self, val: Tuple[int, int, int] = ..., **kwargs: Any) -> None: ...
    def copyInBetweenDelta(self, val: Tuple[int, int, int, int] = ..., **kwargs: Any) -> None: ...
    def export(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def exportTarget(self, val: Union[Tuple[int, int], List[Tuple[int, int]]] = ..., **kwargs: Any) -> None: ...
    def flipTarget(self, val: Union[Tuple[int, int], List[Tuple[int, int]]] = ..., **kwargs: Any) -> None: ...
    def frontOfChain(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getBaseObjects(self) -> List[DependNode]: ...
    def getDeformerTools(self, **kwargs) -> Any: ...
    def getEnvelope(self) -> float: ...
    def getExclusive(self, **kwargs) -> Any: ...
    def getGeometry(self, **kwargs) -> str: ...
    def getGeometryIndices(self, **kwargs) -> Any: ...
    def getNormalizationGroups(self, **kwargs) -> Any: ...
    def getOrigin(self) -> BlendShapeDeformer.Origin: ...
    def getSymmetryAxis(self, **kwargs) -> str: ...
    def getSymmetryEdge(self, **kwargs) -> str: ...
    def getSymmetrySpace(self, **kwargs) -> int: ...
    def getTarget(self, **kwargs) -> Tuple[str, int, str, float]: ...
    def getTargets(self, baseObject: Union[str, DependNode], weightIndex: int) -> List[DependNode]: ...
    def getTransform(self, **kwargs) -> str: ...
    def getUseComponentTags(self, **kwargs) -> Any: ...
    def getWeight(self, index: int) -> float: ...
    def getWeightCount(self, **kwargs) -> int: ...
    def historyLocation(self) -> BlendShapeDeformer.HistoryLocation: ...
    def inBetween(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def inBetweenIndex(self, val: int = ..., **kwargs: Any) -> None: ...
    def inBetweenType(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def ip(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def mergeSource(self, val: Union[int, List[int]] = ..., **kwargs: Any) -> None: ...
    def mergeTarget(self, val: int = ..., **kwargs: Any) -> None: ...
    def mirrorDirection(self, val: int = ..., **kwargs: Any) -> None: ...
    def mirrorTarget(self, val: Union[Tuple[int, int], List[Tuple[int, int]]] = ..., **kwargs: Any) -> None: ...
    def numWeights(self) -> int: ...
    def parallel(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def prune(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int, List[Union[bool, int]]] = ..., **kwargs: Any) -> None: ...
    def removeTarget(self, baseObject: Union[str, DependNode], weightIndex: int, target: Union[str, DependNode], fullWeight: float) -> None: ...
    def resetTargetDelta(self, val: Union[Tuple[int, int], List[Tuple[int, int]]] = ..., **kwargs: Any) -> None: ...
    def setEnvelope(self, envelope: float) -> None: ...
    def setGeometry(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def setOrigin(self, space: BlendShapeDeformer.Origin) -> None: ...
    def setSymmetryAxis(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setSymmetryEdge(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def setSymmetrySpace(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTarget(self, val: Union[Tuple[str, int, str, float], List[Tuple[str, int, str, float]]] = ..., **kwargs: Any) -> None: ...
    def setTransform(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setWeight(self, index: int, weight: float) -> None: ...
    def setWeightCount(self, val: int = ..., **kwargs: Any) -> None: ...
    def suppressDialog(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def tangentSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def targetItemIndexList(self, weightIndex: int, baseObject: Union[str, DependNode]) -> List[int]: ...
    def weightIndexList(self) -> List[int]: ...

class THblendShape(BlendShape):
    __melnode__: str

class BoneLattice(GeometryFilter):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def after(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def afterReference(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def before(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def frontOfChain(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getBicep(self, **kwargs) -> float: ...
    def getDeformerTools(self, **kwargs) -> Any: ...
    def getExclusive(self, **kwargs) -> Any: ...
    def getGeometry(self, **kwargs) -> str: ...
    def getGeometryIndices(self, **kwargs) -> Any: ...
    def getJoint(self, **kwargs) -> str: ...
    def getLengthIn(self, **kwargs) -> float: ...
    def getLengthOut(self, **kwargs) -> float: ...
    def getTricep(self, **kwargs) -> float: ...
    def getUseComponentTags(self, **kwargs) -> Any: ...
    def getWidthLeft(self, **kwargs) -> float: ...
    def getWidthRight(self, **kwargs) -> float: ...
    def parallel(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def prune(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int, List[Union[bool, int]]] = ..., **kwargs: Any) -> None: ...
    def setBicep(self, val: float = ..., **kwargs: Any) -> None: ...
    def setGeometry(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def setJoint(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setLengthIn(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLengthOut(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTricep(self, val: float = ..., **kwargs: Any) -> None: ...
    def setWidthLeft(self, val: float = ..., **kwargs: Any) -> None: ...
    def setWidthRight(self, val: float = ..., **kwargs: Any) -> None: ...

class HistorySwitch(GeometryFilter):
    __melnode__: str

class JointLattice(GeometryFilter):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def after(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def afterReference(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def before(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def frontOfChain(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getCreasing(self, **kwargs) -> float: ...
    def getDeformerTools(self, **kwargs) -> Any: ...
    def getExclusive(self, **kwargs) -> Any: ...
    def getGeometry(self, **kwargs) -> str: ...
    def getGeometryIndices(self, **kwargs) -> Any: ...
    def getLengthIn(self, **kwargs) -> float: ...
    def getLengthOut(self, **kwargs) -> float: ...
    def getRounding(self, **kwargs) -> float: ...
    def getUseComponentTags(self, **kwargs) -> Any: ...
    def getWidthLeft(self, **kwargs) -> float: ...
    def getWidthRight(self, **kwargs) -> float: ...
    def parallel(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def prune(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int, List[Union[bool, int]]] = ..., **kwargs: Any) -> None: ...
    def setCreasing(self, val: float = ..., **kwargs: Any) -> None: ...
    def setGeometry(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def setLengthIn(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLengthOut(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRounding(self, val: float = ..., **kwargs: Any) -> None: ...
    def setWidthLeft(self, val: float = ..., **kwargs: Any) -> None: ...
    def setWidthRight(self, val: float = ..., **kwargs: Any) -> None: ...

class Sculpt(GeometryFilter):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def after(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def afterReference(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def before(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def frontOfChain(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getDeformerTools(self, **kwargs) -> Any: ...
    def getDropoffDistance(self, **kwargs) -> float: ...
    def getDropoffType(self, **kwargs) -> str: ...
    def getExclusive(self, **kwargs) -> Any: ...
    def getGeometry(self, **kwargs) -> str: ...
    def getGeometryIndices(self, **kwargs) -> Any: ...
    def getInsideMode(self, **kwargs) -> str: ...
    def getMaxDisplacement(self, **kwargs) -> float: ...
    def getMode(self, **kwargs) -> str: ...
    def getUseComponentTags(self, **kwargs) -> Any: ...
    def parallel(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def prune(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int, List[Union[bool, int]]] = ..., **kwargs: Any) -> None: ...
    def setDropoffDistance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDropoffType(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setGeometry(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def setInsideMode(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setMaxDisplacement(self, val: float = ..., **kwargs: Any) -> None: ...
    def setMode(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...

class THskinCluster(SkinCluster):
    __melnode__: str

class Tweak(GeometryFilter):
    __melnode__: str

class WeightGeometryFilter(GeometryFilter):
    __apicls__: Incomplete
    __melnode__: str
    def getWeightPlugStrings(self, list: SelectionSet) -> List[str]: ...
    def getWeights(self, index: int) -> Tuple[DependNode, List[float]]: ...
    def setWeight(self, path: DagNode, index: int, components: Union[str, DependNode], weight: float, oldValues: List[float] = ...) -> None: ...
    def weightPlugStrings(self, list: SelectionSet) -> str: ...

class THdeformer(WeightGeometryFilter):
    __melnode__: str

class Cluster(WeightGeometryFilter):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def after(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def afterReference(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def before(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def frontOfChain(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getDeformerTools(self, **kwargs) -> Any: ...
    def getExclusive(self, **kwargs) -> Any: ...
    def getGeometry(self, **kwargs) -> str: ...
    def getGeometryIndices(self, **kwargs) -> Any: ...
    def getUseComponentTags(self, **kwargs) -> Any: ...
    def getWeightedNode(self, **kwargs) -> Tuple[str, str]: ...
    def parallel(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def prune(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int, List[Union[bool, int]]] = ..., **kwargs: Any) -> None: ...
    def resetGeometry(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setGeometry(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def setWeightedNode(self, val: Tuple[str, str] = ..., **kwargs: Any) -> None: ...

class JointCluster(Cluster):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAboveBound(self, **kwargs) -> float: ...
    def getAboveCluster(self, **kwargs) -> Any: ...
    def getAboveDropoffType(self, **kwargs) -> str: ...
    def getAboveValue(self, **kwargs) -> float: ...
    def getBelowBound(self, **kwargs) -> float: ...
    def getBelowCluster(self, **kwargs) -> Any: ...
    def getBelowDropoffType(self, **kwargs) -> str: ...
    def getBelowValue(self, **kwargs) -> float: ...
    def getDeformerTools(self, **kwargs) -> Any: ...
    def setAboveBound(self, val: float = ..., **kwargs: Any) -> None: ...
    def setAboveDropoffType(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setAboveValue(self, val: float = ..., **kwargs: Any) -> None: ...
    def setBelowBound(self, val: float = ..., **kwargs: Any) -> None: ...
    def setBelowDropoffType(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setBelowValue(self, val: float = ..., **kwargs: Any) -> None: ...

class DeltaMush(WeightGeometryFilter):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def after(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def afterReference(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def before(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def frontOfChain(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getDeformerTools(self, **kwargs) -> Any: ...
    def getExclusive(self, **kwargs) -> Any: ...
    def getGeometry(self, **kwargs) -> str: ...
    def getGeometryIndices(self, **kwargs) -> Any: ...
    def getInwardConstraint(self, **kwargs) -> float: ...
    def getOutwardConstraint(self, **kwargs) -> float: ...
    def getPinBorderVertices(self, **kwargs) -> bool: ...
    def getSmoothingIterations(self, **kwargs) -> int: ...
    def getSmoothingStep(self, **kwargs) -> float: ...
    def getUseComponentTags(self, **kwargs) -> Any: ...
    def parallel(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def prune(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int, List[Union[bool, int]]] = ..., **kwargs: Any) -> None: ...
    def setGeometry(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def setInwardConstraint(self, val: float = ..., **kwargs: Any) -> None: ...
    def setOutwardConstraint(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPinBorderVertices(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSmoothingIterations(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSmoothingStep(self, val: float = ..., **kwargs: Any) -> None: ...

class Ffd(WeightGeometryFilter):
    __apicls__: Incomplete
    __melnode__: str
    def addGeometry(self, object: Union[str, DependNode]) -> None: ...
    def baseLattice(self) -> DependNode: ...
    def deformLattice(self) -> DependNode: ...
    def getAffectedGeometry(self) -> List[DependNode]: ...
    def getDivisions(self) -> Tuple[int, int, int]: ...
    def removeGeometry(self, object: Union[str, DependNode]) -> None: ...
    def resetLattice(self, centerLattice: bool = ...) -> None: ...
    def setDivisions(self, x: int, y: int, z: int) -> None: ...

class Jiggle(WeightGeometryFilter):
    __melnode__: str

class Morph(WeightGeometryFilter):
    __melnode__: str

class NonLinear(WeightGeometryFilter):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def after(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def afterReference(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def before(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def frontOfChain(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getDeformerTools(self, **kwargs) -> Any: ...
    def getExclusive(self, **kwargs) -> Any: ...
    def getGeometry(self, **kwargs) -> str: ...
    def getGeometryIndices(self, **kwargs) -> Any: ...
    def getUseComponentTags(self, **kwargs) -> Any: ...
    def parallel(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def prune(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int, List[Union[bool, int]]] = ..., **kwargs: Any) -> None: ...
    def setGeometry(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...

class ProximityWrap(WeightGeometryFilter):
    __melnode__: str

class ShrinkWrap(WeightGeometryFilter):
    __melnode__: str

class SoftMod(WeightGeometryFilter):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def after(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def afterReference(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def before(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def frontOfChain(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getDeformerTools(self, **kwargs) -> Any: ...
    def getExclusive(self, **kwargs) -> Any: ...
    def getGeometry(self, **kwargs) -> str: ...
    def getGeometryIndices(self, **kwargs) -> Any: ...
    def getUseComponentTags(self, **kwargs) -> Any: ...
    def getWeightedNode(self, **kwargs) -> Tuple[str, str]: ...
    def parallel(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def prune(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int, List[Union[bool, int]]] = ..., **kwargs: Any) -> None: ...
    def resetGeometry(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setGeometry(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def setWeightedNode(self, val: Tuple[str, str] = ..., **kwargs: Any) -> None: ...

class Solidify(WeightGeometryFilter):
    __melnode__: str

class Tension(WeightGeometryFilter):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def after(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def afterReference(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def before(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def frontOfChain(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getDeformerTools(self, **kwargs) -> Any: ...
    def getExclusive(self, **kwargs) -> Any: ...
    def getGeometry(self, **kwargs) -> str: ...
    def getGeometryIndices(self, **kwargs) -> Any: ...
    def getInwardConstraint(self, **kwargs) -> float: ...
    def getOutwardConstraint(self, **kwargs) -> float: ...
    def getPinBorderVertices(self, **kwargs) -> bool: ...
    def getSmoothingIterations(self, **kwargs) -> int: ...
    def getSmoothingStep(self, **kwargs) -> float: ...
    def getUseComponentTags(self, **kwargs) -> Any: ...
    def parallel(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def prune(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int, List[Union[bool, int]]] = ..., **kwargs: Any) -> None: ...
    def setGeometry(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def setInwardConstraint(self, val: float = ..., **kwargs: Any) -> None: ...
    def setOutwardConstraint(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPinBorderVertices(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSmoothingIterations(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSmoothingStep(self, val: float = ..., **kwargs: Any) -> None: ...

class TextureDeformer(WeightGeometryFilter):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def after(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def afterReference(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def before(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def frontOfChain(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getDeformerTools(self, **kwargs) -> Any: ...
    def getExclusive(self, **kwargs) -> Any: ...
    def getGeometry(self, **kwargs) -> str: ...
    def getGeometryIndices(self, **kwargs) -> Any: ...
    def getUseComponentTags(self, **kwargs) -> Any: ...
    def parallel(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def prune(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int, List[Union[bool, int]]] = ..., **kwargs: Any) -> None: ...
    def setGeometry(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...

class TransferAttributes(WeightGeometryFilter):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def after(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def afterReference(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def before(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def colorBorders(self, val: int = ..., **kwargs: Any) -> None: ...
    def flipUVs(self, val: int = ..., **kwargs: Any) -> None: ...
    def frontOfChain(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getDeformerTools(self, **kwargs) -> Any: ...
    def getExclusive(self, **kwargs) -> Any: ...
    def getGeometry(self, **kwargs) -> str: ...
    def getGeometryIndices(self, **kwargs) -> Any: ...
    def getUseComponentTags(self, **kwargs) -> Any: ...
    def matchChoice(self, val: int = ..., **kwargs: Any) -> None: ...
    def parallel(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def prune(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int, List[Union[bool, int]]] = ..., **kwargs: Any) -> None: ...
    def sampleSpace(self, val: int = ..., **kwargs: Any) -> None: ...
    def searchMethod(self, val: int = ..., **kwargs: Any) -> None: ...
    def searchScaleX(self, val: float = ..., **kwargs: Any) -> None: ...
    def searchScaleY(self, val: float = ..., **kwargs: Any) -> None: ...
    def searchScaleZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setGeometry(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def transferColors(self, val: int = ..., **kwargs: Any) -> None: ...
    def transferNormals(self, val: int = ..., **kwargs: Any) -> None: ...
    def transferPositions(self, val: int = ..., **kwargs: Any) -> None: ...
    def transferUVs(self, val: int = ..., **kwargs: Any) -> None: ...

class Wire(WeightGeometryFilter):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def addGeometry(self, object: Union[str, DependNode]) -> None: ...
    def addWire(self, object: Union[str, DependNode]) -> None: ...
    def after(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def afterReference(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def before(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def frontOfChain(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getAffectedGeometry(self) -> List[DependNode]: ...
    def getCrossingEffect(self) -> float: ...
    def getDeformerTools(self, **kwargs) -> Any: ...
    def getDropoffDistance(self, **kwargs) -> Tuple[int, float]: ...
    def getEnvelope(self) -> float: ...
    def getExclusive(self, **kwargs) -> Any: ...
    def getGeometry(self, **kwargs) -> str: ...
    def getGeometryIndices(self, **kwargs) -> Any: ...
    def getHolder(self, **kwargs) -> Tuple[int, str]: ...
    def getHoldingShape(self, wireIndex: int) -> DependNode: ...
    def getLocalInfluence(self, **kwargs) -> float: ...
    def getLocalIntensity(self) -> float: ...
    def getRotation(self) -> float: ...
    def getUseComponentTags(self, **kwargs) -> Any: ...
    def getWire(self, **kwargs) -> str: ...
    def getWireCount(self, **kwargs) -> int: ...
    def getWireDropOffDistance(self, wireIndex: int) -> float: ...
    def getWireScale(self, wireIndex: int) -> float: ...
    def numDropoffLocators(self, wireIndex: int) -> int: ...
    def numWires(self) -> int: ...
    def parallel(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def prune(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def remove(self, val: Union[bool, int, List[Union[bool, int]]] = ..., **kwargs: Any) -> None: ...
    def removeGeometry(self, object: Union[str, DependNode]) -> None: ...
    def setCrossingEffect(self, crossingEffect: float) -> None: ...
    def setDropoffDistance(self, val: Union[Tuple[int, float], List[Tuple[int, float]]] = ..., **kwargs: Any) -> None: ...
    def setEnvelope(self, envelope: float) -> None: ...
    def setGeometry(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def setHolder(self, val: Union[Tuple[int, str], List[Tuple[int, str]]] = ..., **kwargs: Any) -> None: ...
    def setHoldingShape(self, wireIndex: int, holdingShape: Union[str, DependNode]) -> None: ...
    def setLocalInfluence(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalIntensity(self, localIntensity: float) -> None: ...
    def setRotation(self, rotation: float) -> None: ...
    def setWire(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def setWireCount(self, val: int = ..., **kwargs: Any) -> None: ...
    def setWireDropOffDistance(self, wireIndex: int, dropOff: float) -> None: ...
    def setWireScale(self, wireIndex: int, scale: float) -> None: ...
    def wire(self, wireIndex: int) -> DependNode: ...

class Wrap(GeometryFilter):
    __melnode__: str

class GlobalCacheControl(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class GreasePencilSequence(DependNode):
    __melnode__: str

class GroupId(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class GroupParts(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class Guide(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class HardwareRenderGlobals(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class HardwareRenderingGlobals(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class HierarchyTestNode1(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class HierarchyTestNode2(HierarchyTestNode1):
    __melnode__: str

class HierarchyTestNode3(HierarchyTestNode2):
    __melnode__: str

class HoldMatrix(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class HsvToRgb(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class HwReflectionMap(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getBackTextureName(self, **kwargs) -> Any: ...
    def getBottomTextureName(self, **kwargs) -> Any: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def getCubeMap(self, **kwargs) -> Any: ...
    def getDecalMode(self, **kwargs) -> Any: ...
    def getEnable(self, **kwargs) -> Any: ...
    def getFrontTextureName(self, **kwargs) -> Any: ...
    def getLeftTextureName(self, **kwargs) -> Any: ...
    def getRightTextureName(self, **kwargs) -> Any: ...
    def getSphereMapTextureName(self, **kwargs) -> Any: ...
    def getTopTextureName(self, **kwargs) -> Any: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class HwRenderGlobals(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class HyperGraphInfo(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class HyperLayout(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class HyperView(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class IkSolver(DependNode):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getEpsilon(self, **kwargs) -> float: ...
    def getMaxIterations(self) -> int: ...
    def getSolverType(self, **kwargs) -> str: ...
    def getTolerance(self) -> float: ...
    def setEpsilon(self, val: float = ..., **kwargs: Any) -> None: ...
    def setMaxIterations(self, maxIters: int) -> None: ...
    def setSolverType(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setTolerance(self, tolerance: float) -> None: ...

class THikSolverNode(IkSolver):
    __melnode__: str

class HikSolver(IkSolver):
    __melnode__: str

class IkMCsolver(IkSolver):
    __melnode__: str

class IkPASolver(IkSolver):
    __melnode__: str

class IkSCsolver(IkSolver):
    __melnode__: str

class IkRPsolver(IkSCsolver):
    __melnode__: str

class IkSplineSolver(IkSolver):
    __melnode__: str

class IkSystem(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def autoPriority(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def autoPriorityMC(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def autoPrioritySC(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getAllowRotation(self, **kwargs) -> bool: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def getList(self, **kwargs) -> Tuple[int, int]: ...
    def getSnap(self, **kwargs) -> bool: ...
    def getSolve(self, **kwargs) -> bool: ...
    def getSolverTypes(self, **kwargs) -> Any: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...
    def setAllowRotation(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setList(self, val: Tuple[int, int] = ..., **kwargs: Any) -> None: ...
    def setSnap(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSolve(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class ImageSource(DependNode):
    __apicls__: Incomplete
    __melnode__: str
    def sourceCamera(self, currentCamera: Union[str, DependNode]) -> DependNode: ...
    def sourceLayer(self, currentLayer: Union[str, DependNode]) -> DependNode: ...

class RenderPass(ImageSource):
    __apicls__: Incomplete
    __melnode__: str
    def customTokenString(self) -> str: ...
    def frameBufferChannels(self) -> int: ...
    def passID(self) -> str: ...
    def usesFiltering(self) -> bool: ...

class RenderTarget(ImageSource):
    __melnode__: str

class RenderedImageSource(ImageSource):
    __melnode__: str

class LightInfo(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class LightLinker(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class LightList(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class LodThresholds(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class Luminance(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class MakeGroup(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class MaterialInfo(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class MaterialTemplate(DependNode):
    __melnode__: str

class Membrane(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class MotionPath(DependNode):
    __apicls__: Incomplete
    __melnode__: str
    Axis: Incomplete
    def addAnimatedObject(self, objectToAnimate: DagNode, modifier: datatypes.DGModifier = ...) -> None: ...
    def getAnimatedObjects(self) -> List[DagNode]: ...
    def getBank(self) -> bool: ...
    def getBankScale(self) -> float: ...
    def getBankThreshold(self) -> float: ...
    def getFollow(self) -> bool: ...
    def getFollowAxis(self) -> MotionPath.Axis: ...
    def getInverseNormal(self) -> bool: ...
    def getOrientationMarker(self, markerNum: int) -> DependNode: ...
    def getPathObject(self) -> DagNode: ...
    def getPositionMarker(self, markerNum: int) -> DependNode: ...
    def getUEnd(self) -> float: ...
    def getUStart(self) -> float: ...
    def getUTimeEnd(self) -> datatypes.Time: ...
    def getUTimeStart(self) -> datatypes.Time: ...
    def getUpAxis(self) -> MotionPath.Axis: ...
    def getUseNormal(self) -> bool: ...
    def numOrientationMarkers(self) -> int: ...
    def numPositionMarkers(self) -> int: ...
    def setBank(self, bank: bool) -> None: ...
    def setBankScale(self, bankScale: float) -> None: ...
    def setBankThreshold(self, bankThreshold: float) -> None: ...
    def setFollow(self, on: bool, modifier: datatypes.DGModifier = ...) -> None: ...
    def setFollowAxis(self, axis: MotionPath.Axis) -> None: ...
    def setInverseNormal(self, invert: bool) -> None: ...
    def setPathObject(self, pathObject: DagNode, modifier: datatypes.DGModifier = ...) -> None: ...
    def setUEnd(self, end: float) -> None: ...
    def setUStart(self, start: float) -> None: ...
    def setUTimeEnd(self, end: datatypes.Time) -> None: ...
    def setUTimeStart(self, start: datatypes.Time) -> None: ...
    def setUpAxis(self, axis: MotionPath.Axis) -> None: ...
    def setUseNormal(self, use: bool) -> None: ...

class THmotionPath(MotionPath):
    __melnode__: str

class MultDoubleLinear(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class MultMatrix(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class MultilisterLight(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class Mute(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class NComponent(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class Network(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class NodeGraphEditorBookmarkInfo(DependNode):
    __melnode__: str

class NodeGraphEditorBookmarks(DependNode):
    __melnode__: str

class NodeGraphEditorInfo(DependNode):
    __melnode__: str

class ObjectFilter(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class ObjectAttrFilter(ObjectFilter):
    __melnode__: str

class ObjectBinFilter(ObjectFilter):
    __melnode__: str

class ObjectMultiFilter(ObjectFilter):
    __melnode__: str

class ObjectNameFilter(ObjectFilter):
    __melnode__: str

class ObjectRenderFilter(ObjectFilter):
    __melnode__: str

class ObjectScriptFilter(ObjectFilter):
    __melnode__: str

class ObjectTypeFilter(ObjectFilter):
    __melnode__: str

class OldBlindDataBase(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class OldGeometryConstraint(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class OpticalFX(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class PairBlend(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def getInput1(self, **kwargs) -> Any: ...
    def getInput2(self, **kwargs) -> Any: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class ParticleAgeMapper(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class ParticleColorMapper(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class ParticleIncandMapper(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class ParticleTranspMapper(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class PassContributionMap(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class PassMatrix(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class PickMatrix(DependNode):
    __melnode__: str

class PointMatrixMult(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class PolyBase(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class PolyCreator(PolyBase):
    __melnode__: str

class PolyCreateFace(PolyCreator):
    __melnode__: str

class PolyPrimitive(PolyCreator):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAxis(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getComponentTagCreate(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getCreateUVs(self, **kwargs) -> int: ...
    def getFrozen(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getRadius(self, **kwargs) -> float: ...
    def getSideLength(self, **kwargs) -> float: ...
    def getTexture(self, **kwargs) -> int: ...
    def setAxis(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setComponentTagCreate(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCreateUVs(self, val: int = ..., **kwargs: Any) -> None: ...
    def setFrozen(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSideLength(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTexture(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyCone(PolyPrimitive):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAxis(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getComponentTagCreate(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getCreateUVs(self, **kwargs) -> int: ...
    def getFrozen(self, **kwargs) -> bool: ...
    def getHeight(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getRadius(self, **kwargs) -> float: ...
    def getRoundCap(self, **kwargs) -> bool: ...
    def getSubdivisionsAxis(self, **kwargs) -> int: ...
    def getSubdivisionsCap(self, **kwargs) -> int: ...
    def getSubdivisionsHeight(self, **kwargs) -> int: ...
    def getSubdivisionsX(self, **kwargs) -> int: ...
    def getSubdivisionsY(self, **kwargs) -> int: ...
    def getSubdivisionsZ(self, **kwargs) -> int: ...
    def getTexture(self, **kwargs) -> bool: ...
    def setAxis(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setComponentTagCreate(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCreateUVs(self, val: int = ..., **kwargs: Any) -> None: ...
    def setFrozen(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setHeight(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRoundCap(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsAxis(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsCap(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsHeight(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsX(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsY(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsZ(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTexture(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyCube(PolyPrimitive):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAxis(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getComponentTagCreate(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getCreateUVs(self, **kwargs) -> int: ...
    def getDepth(self, **kwargs) -> float: ...
    def getFrozen(self, **kwargs) -> bool: ...
    def getHeight(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getSubdivisionsDepth(self, **kwargs) -> int: ...
    def getSubdivisionsHeight(self, **kwargs) -> int: ...
    def getSubdivisionsWidth(self, **kwargs) -> int: ...
    def getSubdivisionsX(self, **kwargs) -> int: ...
    def getSubdivisionsY(self, **kwargs) -> int: ...
    def getSubdivisionsZ(self, **kwargs) -> int: ...
    def getTexture(self, **kwargs) -> int: ...
    def getWidth(self, **kwargs) -> float: ...
    def setAxis(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setComponentTagCreate(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCreateUVs(self, val: int = ..., **kwargs: Any) -> None: ...
    def setDepth(self, val: float = ..., **kwargs: Any) -> None: ...
    def setFrozen(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setHeight(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsDepth(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsHeight(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsWidth(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsX(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsY(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsZ(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTexture(self, val: int = ..., **kwargs: Any) -> None: ...
    def setWidth(self, val: float = ..., **kwargs: Any) -> None: ...

class PolyCylinder(PolyPrimitive):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAxis(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getComponentTagCreate(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getCreateUVs(self, **kwargs) -> int: ...
    def getFrozen(self, **kwargs) -> bool: ...
    def getHeight(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getRadius(self, **kwargs) -> float: ...
    def getRoundCap(self, **kwargs) -> bool: ...
    def getSubdivisionsAxis(self, **kwargs) -> int: ...
    def getSubdivisionsCaps(self, **kwargs) -> int: ...
    def getSubdivisionsHeight(self, **kwargs) -> int: ...
    def getSubdivisionsX(self, **kwargs) -> int: ...
    def getSubdivisionsY(self, **kwargs) -> int: ...
    def getSubdivisionsZ(self, **kwargs) -> int: ...
    def getTexture(self, **kwargs) -> int: ...
    def setAxis(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setComponentTagCreate(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCreateUVs(self, val: int = ..., **kwargs: Any) -> None: ...
    def setFrozen(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setHeight(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRoundCap(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsAxis(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsCaps(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsHeight(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsX(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsY(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsZ(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTexture(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyHelix(PolyPrimitive):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAxis(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getCoils(self, **kwargs) -> float: ...
    def getComponentTagCreate(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getCreateUVs(self, **kwargs) -> int: ...
    def getDirection(self, **kwargs) -> int: ...
    def getFrozen(self, **kwargs) -> bool: ...
    def getHeight(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getRadius(self, **kwargs) -> float: ...
    def getRoundCap(self, **kwargs) -> bool: ...
    def getSubdivisionsAxis(self, **kwargs) -> int: ...
    def getSubdivisionsCaps(self, **kwargs) -> int: ...
    def getSubdivisionsCoil(self, **kwargs) -> int: ...
    def getTexture(self, **kwargs) -> int: ...
    def getUseOldInitBehaviour(self, **kwargs) -> bool: ...
    def getWidth(self, **kwargs) -> float: ...
    def setAxis(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCoils(self, val: float = ..., **kwargs: Any) -> None: ...
    def setComponentTagCreate(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCreateUVs(self, val: int = ..., **kwargs: Any) -> None: ...
    def setDirection(self, val: int = ..., **kwargs: Any) -> None: ...
    def setFrozen(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setHeight(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRoundCap(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsAxis(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsCaps(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsCoil(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTexture(self, val: int = ..., **kwargs: Any) -> None: ...
    def setUseOldInitBehaviour(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setWidth(self, val: float = ..., **kwargs: Any) -> None: ...

class PolyPipe(PolyPrimitive):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAxis(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getComponentTagCreate(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getCreateUVs(self, **kwargs) -> bool: ...
    def getFrozen(self, **kwargs) -> bool: ...
    def getHeight(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getRadius(self, **kwargs) -> float: ...
    def getRoundCap(self, **kwargs) -> bool: ...
    def getSubdivisionsAxis(self, **kwargs) -> int: ...
    def getSubdivisionsCaps(self, **kwargs) -> int: ...
    def getSubdivisionsHeight(self, **kwargs) -> int: ...
    def getTexture(self, **kwargs) -> bool: ...
    def getThickness(self, **kwargs) -> float: ...
    def setAxis(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setComponentTagCreate(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCreateUVs(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFrozen(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setHeight(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRoundCap(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsAxis(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsCaps(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsHeight(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTexture(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setThickness(self, val: float = ..., **kwargs: Any) -> None: ...

class PolyPlane(PolyPrimitive):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAxis(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getComponentTagCreate(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getCreateUVs(self, **kwargs) -> int: ...
    def getFrozen(self, **kwargs) -> bool: ...
    def getHeight(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getSubdivisionsHeight(self, **kwargs) -> int: ...
    def getSubdivisionsWidth(self, **kwargs) -> int: ...
    def getSubdivisionsX(self, **kwargs) -> int: ...
    def getSubdivisionsY(self, **kwargs) -> int: ...
    def getTexture(self, **kwargs) -> int: ...
    def getWidth(self, **kwargs) -> float: ...
    def setAxis(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setComponentTagCreate(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCreateUVs(self, val: int = ..., **kwargs: Any) -> None: ...
    def setFrozen(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setHeight(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsHeight(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsWidth(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsX(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsY(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTexture(self, val: int = ..., **kwargs: Any) -> None: ...
    def setWidth(self, val: float = ..., **kwargs: Any) -> None: ...

class PolyPlatonicSolid(PolyPrimitive):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAxis(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getComponentTagCreate(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getFrozen(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getRadius(self, **kwargs) -> float: ...
    def getSideLength(self, **kwargs) -> float: ...
    def setAxis(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setComponentTagCreate(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFrozen(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSideLength(self, val: float = ..., **kwargs: Any) -> None: ...

class PolyPrimitiveMisc(PolyPrimitive):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str

class PolyPrism(PolyPrimitive):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAxis(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getComponentTagCreate(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getFrozen(self, **kwargs) -> bool: ...
    def getLength(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getNumberOfSides(self, **kwargs) -> int: ...
    def getNumderOfSides(self, **kwargs) -> int: ...
    def getSideLength(self, **kwargs) -> float: ...
    def getSubdivisionsCaps(self, **kwargs) -> int: ...
    def getSubdivisionsHeight(self, **kwargs) -> int: ...
    def setAxis(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setComponentTagCreate(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFrozen(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setLength(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNumberOfSides(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNumderOfSides(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSideLength(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsCaps(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsHeight(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyPyramid(PolyPrimitive):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAxis(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getComponentTagCreate(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getCreateUVs(self, **kwargs) -> int: ...
    def getFrozen(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getNumberOfSides(self, **kwargs) -> int: ...
    def getNumderOfSides(self, **kwargs) -> int: ...
    def getSideLength(self, **kwargs) -> float: ...
    def getSubdivisionsCaps(self, **kwargs) -> int: ...
    def getSubdivisionsHeight(self, **kwargs) -> int: ...
    def getTexture(self, **kwargs) -> bool: ...
    def setAxis(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setComponentTagCreate(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCreateUVs(self, val: int = ..., **kwargs: Any) -> None: ...
    def setFrozen(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNumberOfSides(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNumderOfSides(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSideLength(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsCaps(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsHeight(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTexture(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolySphere(PolyPrimitive):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAxis(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getComponentTagCreate(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getFrozen(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getRadius(self, **kwargs) -> float: ...
    def getSubdivisionsAxis(self, **kwargs) -> int: ...
    def getSubdivisionsHeight(self, **kwargs) -> int: ...
    def getSubdivisionsX(self, **kwargs) -> int: ...
    def getSubdivisionsY(self, **kwargs) -> int: ...
    def setAxis(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setComponentTagCreate(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFrozen(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsAxis(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsHeight(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsX(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsY(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyTorus(PolyPrimitive):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAxis(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getComponentTagCreate(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getCreateUVs(self, **kwargs) -> bool: ...
    def getFrozen(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getRadius(self, **kwargs) -> float: ...
    def getSectionRadius(self, **kwargs) -> float: ...
    def getSubdivisionsAxis(self, **kwargs) -> int: ...
    def getSubdivisionsHeight(self, **kwargs) -> int: ...
    def getSubdivisionsX(self, **kwargs) -> int: ...
    def getSubdivisionsY(self, **kwargs) -> int: ...
    def getTexture(self, **kwargs) -> bool: ...
    def getTwist(self, **kwargs) -> float: ...
    def setAxis(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setComponentTagCreate(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCreateUVs(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFrozen(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSectionRadius(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsAxis(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsHeight(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsX(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSubdivisionsY(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTexture(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setTwist(self, val: float = ..., **kwargs: Any) -> None: ...

class PolyUnite(PolyCreator):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyBoolOp(PolyUnite):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getFaceAreaThreshold(self, **kwargs) -> float: ...
    def getMergeUVSets(self, **kwargs) -> int: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getOperation(self, **kwargs) -> int: ...
    def getPreserveColor(self, **kwargs) -> bool: ...
    def getUseThresholds(self, **kwargs) -> bool: ...
    def getVertexDistanceThreshold(self, **kwargs) -> float: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFaceAreaThreshold(self, val: float = ..., **kwargs: Any) -> None: ...
    def setMergeUVSets(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setOperation(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPreserveColor(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setUseThresholds(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setVertexDistanceThreshold(self, val: float = ..., **kwargs: Any) -> None: ...

class PolyCBoolOp(PolyBoolOp):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getClassification(self, **kwargs) -> int: ...
    def getFaceAreaThreshold(self, **kwargs) -> float: ...
    def getMergeUVSets(self, **kwargs) -> int: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getOperation(self, **kwargs) -> int: ...
    def getPreserveColor(self, **kwargs) -> bool: ...
    def getTagIntersection(self, **kwargs) -> bool: ...
    def getUseCarveBooleans(self, **kwargs) -> bool: ...
    def getUseThresholds(self, **kwargs) -> bool: ...
    def getVertexDistanceThreshold(self, **kwargs) -> float: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setClassification(self, val: int = ..., **kwargs: Any) -> None: ...
    def setFaceAreaThreshold(self, val: float = ..., **kwargs: Any) -> None: ...
    def setMergeUVSets(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setOperation(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPreserveColor(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setTagIntersection(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setUseCarveBooleans(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setUseThresholds(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setVertexDistanceThreshold(self, val: float = ..., **kwargs: Any) -> None: ...

class PolyModifier(PolyBase):
    __melnode__: str

class BlendColorSets(PolyModifier):
    __melnode__: str

class PolyAppend(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getSubdivision(self, **kwargs) -> int: ...
    def getTexture(self, **kwargs) -> int: ...
    def setSubdivision(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTexture(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyAppendVertex(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getTexture(self, **kwargs) -> int: ...
    def setTexture(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyClean(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getCleanEdges(self, **kwargs) -> bool: ...
    def getCleanPartialUVMapping(self, **kwargs) -> bool: ...
    def getCleanUVs(self, **kwargs) -> bool: ...
    def getCleanVertices(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getFrozen(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCleanEdges(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCleanPartialUVMapping(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCleanUVs(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCleanVertices(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFrozen(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyCloseBorder(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyCollapseEdge(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyCollapseF(PolyModifier):
    __melnode__: str

class PolyColorDel(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getColorSetName(self, **kwargs) -> str: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setColorSetName(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyColorMod(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAlphaScale_FloatValue(self, **kwargs) -> float: ...
    def getAlphaScale_Interp(self, **kwargs) -> int: ...
    def getAlphaScale_Position(self, **kwargs) -> float: ...
    def getBlueScale_FloatValue(self, **kwargs) -> float: ...
    def getBlueScale_Interp(self, **kwargs) -> int: ...
    def getBlueScale_Position(self, **kwargs) -> float: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getGreenScale_FloatValue(self, **kwargs) -> float: ...
    def getGreenScale_Interp(self, **kwargs) -> int: ...
    def getGreenScale_Position(self, **kwargs) -> float: ...
    def getHuev(self, **kwargs) -> float: ...
    def getIntensityScale_FloatValue(self, **kwargs) -> float: ...
    def getIntensityScale_Interp(self, **kwargs) -> int: ...
    def getIntensityScale_Position(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getRedScale_FloatValue(self, **kwargs) -> float: ...
    def getRedScale_Interp(self, **kwargs) -> int: ...
    def getRedScale_Position(self, **kwargs) -> float: ...
    def getSatv(self, **kwargs) -> float: ...
    def getValue(self, **kwargs) -> float: ...
    def setAlphaScale_FloatValue(self, val: float = ..., **kwargs: Any) -> None: ...
    def setAlphaScale_Interp(self, val: int = ..., **kwargs: Any) -> None: ...
    def setAlphaScale_Position(self, val: float = ..., **kwargs: Any) -> None: ...
    def setBlueScale_FloatValue(self, val: float = ..., **kwargs: Any) -> None: ...
    def setBlueScale_Interp(self, val: int = ..., **kwargs: Any) -> None: ...
    def setBlueScale_Position(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setGreenScale_FloatValue(self, val: float = ..., **kwargs: Any) -> None: ...
    def setGreenScale_Interp(self, val: int = ..., **kwargs: Any) -> None: ...
    def setGreenScale_Position(self, val: float = ..., **kwargs: Any) -> None: ...
    def setHuev(self, val: float = ..., **kwargs: Any) -> None: ...
    def setIntensityScale_FloatValue(self, val: float = ..., **kwargs: Any) -> None: ...
    def setIntensityScale_Interp(self, val: int = ..., **kwargs: Any) -> None: ...
    def setIntensityScale_Position(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setRedScale_FloatValue(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRedScale_Interp(self, val: int = ..., **kwargs: Any) -> None: ...
    def setRedScale_Position(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSatv(self, val: float = ..., **kwargs: Any) -> None: ...
    def setValue(self, val: float = ..., **kwargs: Any) -> None: ...

class PolyColorPerVertex(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAlpha(self, **kwargs) -> float: ...
    def getClamped(self, **kwargs) -> bool: ...
    def getColorB(self, **kwargs) -> float: ...
    def getColorDisplayOption(self, **kwargs) -> bool: ...
    def getColorG(self, **kwargs) -> float: ...
    def getColorR(self, **kwargs) -> float: ...
    def getColorRGB(self, **kwargs) -> Tuple[float, float, float]: ...
    def getNotUndoable(self, **kwargs) -> bool: ...
    def getRelative(self, **kwargs) -> bool: ...
    def getRemove(self, **kwargs) -> bool: ...
    def getRepresentation(self, **kwargs) -> int: ...
    def setAlpha(self, val: float = ..., **kwargs: Any) -> None: ...
    def setClamped(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setColorB(self, val: float = ..., **kwargs: Any) -> None: ...
    def setColorDisplayOption(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setColorG(self, val: float = ..., **kwargs: Any) -> None: ...
    def setColorR(self, val: float = ..., **kwargs: Any) -> None: ...
    def setColorRGB(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setNotUndoable(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setRelative(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setRemove(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setRepresentation(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyConnectComponents(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAdjustEdgeFlow(self, **kwargs) -> float: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getInsertWithEdgeFlow(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def setAdjustEdgeFlow(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setInsertWithEdgeFlow(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyDelEdge(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getCleanVertices(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCleanVertices(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyDelFacet(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyDelVertex(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyDuplicateEdge(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAdjustEdgeFlow(self, **kwargs) -> float: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getDeleteEdge(self, **kwargs) -> bool: ...
    def getEndVertexOffset(self, **kwargs) -> float: ...
    def getInsertWithEdgeFlow(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getSmoothingAngle(self, **kwargs) -> float: ...
    def getSplitType(self, **kwargs) -> int: ...
    def getStartVertexOffset(self, **kwargs) -> float: ...
    def setAdjustEdgeFlow(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDeleteEdge(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setEndVertexOffset(self, val: float = ..., **kwargs: Any) -> None: ...
    def setInsertWithEdgeFlow(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSmoothingAngle(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSplitType(self, val: int = ..., **kwargs: Any) -> None: ...
    def setStartVertexOffset(self, val: float = ..., **kwargs: Any) -> None: ...

class PolyEditEdgeFlow(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyFlipEdge(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str

class PolyMapCut(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getMoveratio(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setMoveratio(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyMapDel(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyMapSew(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyMergeEdge(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getFirstEdge(self, **kwargs) -> int: ...
    def getMergeMode(self, **kwargs) -> int: ...
    def getMergeTexture(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getSecondEdge(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFirstEdge(self, val: int = ..., **kwargs: Any) -> None: ...
    def setMergeMode(self, val: int = ..., **kwargs: Any) -> None: ...
    def setMergeTexture(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSecondEdge(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyMergeFace(PolyModifier):
    __melnode__: str

class PolyModifierWorld(PolyModifier):
    __melnode__: str

class PolyAverageVertex(PolyModifierWorld):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getIterations(self, **kwargs) -> int: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setIterations(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyBevel(PolyModifierWorld):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAngleTolerance(self, **kwargs) -> float: ...
    def getAutoFit(self, **kwargs) -> bool: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getMergeVertexTolerance(self, **kwargs) -> float: ...
    def getMergeVertices(self, **kwargs) -> bool: ...
    def getMiteringAngle(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getOffset(self, **kwargs) -> float: ...
    def getOffsetAsFraction(self, **kwargs) -> bool: ...
    def getRoundness(self, **kwargs) -> float: ...
    def getSegments(self, **kwargs) -> int: ...
    def getSmoothingAngle(self, **kwargs) -> float: ...
    def getSubdivideNgons(self, **kwargs) -> bool: ...
    def getUseLegacyBevelAlgorithm(self, **kwargs) -> bool: ...
    def getUvAssignment(self, **kwargs) -> int: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setAngleTolerance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setAutoFit(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setMergeVertexTolerance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setMergeVertices(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setMiteringAngle(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setOffset(self, val: float = ..., **kwargs: Any) -> None: ...
    def setOffsetAsFraction(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setRoundness(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSegments(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSmoothingAngle(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSubdivideNgons(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setUseLegacyBevelAlgorithm(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setUvAssignment(self, val: int = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyBevel2(PolyBevel):
    __melnode__: str

class PolyBevel3(PolyModifierWorld):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAngleTolerance(self, **kwargs) -> float: ...
    def getAutoFit(self, **kwargs) -> bool: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getChamfer(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getDepth(self, **kwargs) -> float: ...
    def getFillNgons(self, **kwargs) -> bool: ...
    def getMergeVertexTolerance(self, **kwargs) -> float: ...
    def getMergeVertices(self, **kwargs) -> bool: ...
    def getMiterAlong(self, **kwargs) -> int: ...
    def getMitering(self, **kwargs) -> int: ...
    def getMiteringAngle(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getOffset(self, **kwargs) -> float: ...
    def getOffsetAsFraction(self, **kwargs) -> bool: ...
    def getRoundness(self, **kwargs) -> float: ...
    def getSegments(self, **kwargs) -> int: ...
    def getSmoothingAngle(self, **kwargs) -> float: ...
    def getUvAssignment(self, **kwargs) -> int: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setAngleTolerance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setAutoFit(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setChamfer(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDepth(self, val: float = ..., **kwargs: Any) -> None: ...
    def setFillNgons(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setMergeVertexTolerance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setMergeVertices(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setMiterAlong(self, val: int = ..., **kwargs: Any) -> None: ...
    def setMitering(self, val: int = ..., **kwargs: Any) -> None: ...
    def setMiteringAngle(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setOffset(self, val: float = ..., **kwargs: Any) -> None: ...
    def setOffsetAsFraction(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setRoundness(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSegments(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSmoothingAngle(self, val: float = ..., **kwargs: Any) -> None: ...
    def setUvAssignment(self, val: int = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyBridgeEdge(PolyModifierWorld):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getBridgeOffset(self, **kwargs) -> int: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getCurveType(self, **kwargs) -> int: ...
    def getDivisions(self, **kwargs) -> int: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getSmoothingAngle(self, **kwargs) -> float: ...
    def getStartVert1(self, **kwargs) -> int: ...
    def getStartVert2(self, **kwargs) -> int: ...
    def getTaper(self, **kwargs) -> float: ...
    def getTaperCurve_FloatValue(self, **kwargs) -> float: ...
    def getTaperCurve_Interp(self, **kwargs) -> int: ...
    def getTaperCurve_Position(self, **kwargs) -> float: ...
    def getTwist(self, **kwargs) -> float: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setBridgeOffset(self, val: int = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCurveType(self, val: int = ..., **kwargs: Any) -> None: ...
    def setDivisions(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSmoothingAngle(self, val: float = ..., **kwargs: Any) -> None: ...
    def setStartVert1(self, val: int = ..., **kwargs: Any) -> None: ...
    def setStartVert2(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTaper(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTaperCurve_FloatValue(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTaperCurve_Interp(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTaperCurve_Position(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTwist(self, val: float = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyCircularize(PolyModifierWorld):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAlignment(self, **kwargs) -> int: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getEvenlyDistribute(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getNormalOrientation(self, **kwargs) -> int: ...
    def getRadialOffset(self, **kwargs) -> float: ...
    def getSmoothingAngle(self, **kwargs) -> float: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setAlignment(self, val: int = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setEvenlyDistribute(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNormalOrientation(self, val: int = ..., **kwargs: Any) -> None: ...
    def setRadialOffset(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSmoothingAngle(self, val: float = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyCrease(PolyModifierWorld):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCreateHistory(self, **kwargs) -> bool: ...
    def getOperation(self, **kwargs) -> int: ...
    def getRelativeValue(self, **kwargs) -> float: ...
    def getValue(self, **kwargs) -> float: ...
    def getVertexValue(self, **kwargs) -> float: ...
    def setCreateHistory(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setOperation(self, val: int = ..., **kwargs: Any) -> None: ...
    def setRelativeValue(self, val: float = ..., **kwargs: Any) -> None: ...
    def setValue(self, val: Union[float, List[float]] = ..., **kwargs: Any) -> None: ...
    def setVertexValue(self, val: Union[float, List[float]] = ..., **kwargs: Any) -> None: ...

class PolyCreaseEdge(PolyCrease):
    __melnode__: str

class PolyCut(PolyModifierWorld):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getCutPlaneCenter(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCutPlaneCenterX(self, **kwargs) -> float: ...
    def getCutPlaneCenterY(self, **kwargs) -> float: ...
    def getCutPlaneCenterZ(self, **kwargs) -> float: ...
    def getCutPlaneHeight(self, **kwargs) -> float: ...
    def getCutPlaneRotate(self, **kwargs) -> Tuple[float, float, float]: ...
    def getCutPlaneRotateX(self, **kwargs) -> float: ...
    def getCutPlaneRotateY(self, **kwargs) -> float: ...
    def getCutPlaneRotateZ(self, **kwargs) -> float: ...
    def getCutPlaneSize(self, **kwargs) -> Tuple[float, float]: ...
    def getCutPlaneWidth(self, **kwargs) -> float: ...
    def getDeleteFaces(self, **kwargs) -> bool: ...
    def getExtractFaces(self, **kwargs) -> bool: ...
    def getExtractOffset(self, **kwargs) -> Tuple[float, float, float]: ...
    def getExtractOffsetX(self, **kwargs) -> float: ...
    def getExtractOffsetY(self, **kwargs) -> float: ...
    def getExtractOffsetZ(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getOnObject(self, **kwargs) -> bool: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCutPlaneCenter(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCutPlaneCenterX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCutPlaneCenterY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCutPlaneCenterZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCutPlaneHeight(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCutPlaneRotate(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setCutPlaneRotateX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCutPlaneRotateY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCutPlaneRotateZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCutPlaneSize(self, val: Tuple[float, float] = ..., **kwargs: Any) -> None: ...
    def setCutPlaneWidth(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDeleteFaces(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setExtractFaces(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setExtractOffset(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setExtractOffsetX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setExtractOffsetY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setExtractOffsetZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setOnObject(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyCylProj(PolyModifierWorld):
    __melnode__: str

class PolyExtrudeVertex(PolyModifierWorld):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getDivisions(self, **kwargs) -> int: ...
    def getLength(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getWidth(self, **kwargs) -> float: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDivisions(self, val: int = ..., **kwargs: Any) -> None: ...
    def setLength(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setWidth(self, val: float = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyHoleFace(PolyModifierWorld):
    __melnode__: str

class PolyMergeVert(PolyModifierWorld):
    __melnode__: str

class PolyMirror(PolyModifierWorld):
    __melnode__: str

class PolyModifierUV(PolyModifierWorld):
    __melnode__: str

class PolyAutoProj(PolyModifierUV):
    __melnode__: str

class PolyContourProj(PolyModifierUV):
    __melnode__: str

class PolyCopyUV(PolyModifierUV):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getUvSetNameInput(self, **kwargs) -> str: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setUvSetNameInput(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyFlipUV(PolyModifierUV):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getCutUV(self, **kwargs) -> bool: ...
    def getFlipType(self, **kwargs) -> int: ...
    def getLocal(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getPivotU(self, **kwargs) -> float: ...
    def getPivotV(self, **kwargs) -> float: ...
    def getUsePivot(self, **kwargs) -> bool: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCutUV(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFlipType(self, val: int = ..., **kwargs: Any) -> None: ...
    def setLocal(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPivotU(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPivotV(self, val: float = ..., **kwargs: Any) -> None: ...
    def setUsePivot(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyLayoutUV(PolyModifierUV):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getFlipReversed(self, **kwargs) -> bool: ...
    def getLayout(self, **kwargs) -> int: ...
    def getLayoutMethod(self, **kwargs) -> int: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getPercentageSpace(self, **kwargs) -> float: ...
    def getRotateForBestFit(self, **kwargs) -> int: ...
    def getScale(self, **kwargs) -> int: ...
    def getSeparate(self, **kwargs) -> int: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFlipReversed(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setLayout(self, val: int = ..., **kwargs: Any) -> None: ...
    def setLayoutMethod(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPercentageSpace(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRotateForBestFit(self, val: int = ..., **kwargs: Any) -> None: ...
    def setScale(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSeparate(self, val: int = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyMapSewMove(PolyModifierUV):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getLimitPieceSize(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getNumberFaces(self, **kwargs) -> int: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setLimitPieceSize(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNumberFaces(self, val: int = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyMergeUV(PolyModifierUV):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getDistance(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDistance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyNormalizeUV(PolyModifierUV):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getCenterOnTile(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getNormalizeDirection(self, **kwargs) -> int: ...
    def getNormalizeType(self, **kwargs) -> int: ...
    def getPreserveAspectRatio(self, **kwargs) -> bool: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCenterOnTile(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNormalizeDirection(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNormalizeType(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPreserveAspectRatio(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyOptUvs(PolyModifierUV):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyPinUV(PolyModifierUV):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCreateHistory(self, **kwargs) -> bool: ...
    def getOperation(self, **kwargs) -> int: ...
    def getUnpinned(self, **kwargs) -> bool: ...
    def getUvSetName(self, **kwargs) -> str: ...
    def getValue(self, **kwargs) -> float: ...
    def setCreateHistory(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setOperation(self, val: int = ..., **kwargs: Any) -> None: ...
    def setUnpinned(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setUvSetName(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setValue(self, val: Union[float, List[float]] = ..., **kwargs: Any) -> None: ...

class PolyStraightenUVBorder(PolyModifierUV):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getBlendOriginal(self, **kwargs) -> Any: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getCurvature(self, **kwargs) -> Any: ...
    def getGapTolerance(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getPreserveLength(self, **kwargs) -> Any: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyMoveVertex(PolyModifierWorld):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getGain(self, **kwargs) -> float: ...
    def getLocalDirection(self, **kwargs) -> Tuple[float, float, float]: ...
    def getLocalDirectionX(self, **kwargs) -> float: ...
    def getLocalDirectionY(self, **kwargs) -> float: ...
    def getLocalDirectionZ(self, **kwargs) -> float: ...
    def getLocalTranslate(self, **kwargs) -> Tuple[float, float, float]: ...
    def getLocalTranslateX(self, **kwargs) -> float: ...
    def getLocalTranslateY(self, **kwargs) -> float: ...
    def getLocalTranslateZ(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getPivot(self, **kwargs) -> Tuple[float, float, float]: ...
    def getPivotX(self, **kwargs) -> float: ...
    def getPivotY(self, **kwargs) -> float: ...
    def getPivotZ(self, **kwargs) -> float: ...
    def getRandom(self, **kwargs) -> float: ...
    def getRotate(self, **kwargs) -> Tuple[float, float, float]: ...
    def getRotateX(self, **kwargs) -> float: ...
    def getRotateY(self, **kwargs) -> float: ...
    def getRotateZ(self, **kwargs) -> float: ...
    def getScale(self, **kwargs) -> Tuple[float, float, float]: ...
    def getScaleX(self, **kwargs) -> float: ...
    def getScaleY(self, **kwargs) -> float: ...
    def getScaleZ(self, **kwargs) -> float: ...
    def getTranslate(self, **kwargs) -> Tuple[float, float, float]: ...
    def getTranslateX(self, **kwargs) -> float: ...
    def getTranslateY(self, **kwargs) -> float: ...
    def getTranslateZ(self, **kwargs) -> float: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setGain(self, val: Union[float, List[float]] = ..., **kwargs: Any) -> None: ...
    def setLocalDirection(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setLocalDirectionX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalDirectionY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalDirectionZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalTranslate(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setLocalTranslateX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalTranslateY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalTranslateZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPivot(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setPivotX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPivotY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPivotZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRandom(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRotate(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setRotateX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRotateY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRotateZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setScale(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setScaleX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setScaleY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setScaleZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTranslate(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setTranslateX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTranslateY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTranslateZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyMoveEdge(PolyMoveVertex):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getGain(self, **kwargs) -> float: ...
    def getLocalCenter(self, **kwargs) -> int: ...
    def getLocalDirection(self, **kwargs) -> Tuple[float, float, float]: ...
    def getLocalDirectionX(self, **kwargs) -> float: ...
    def getLocalDirectionY(self, **kwargs) -> float: ...
    def getLocalDirectionZ(self, **kwargs) -> float: ...
    def getLocalRotate(self, **kwargs) -> Tuple[float, float, float]: ...
    def getLocalRotateX(self, **kwargs) -> float: ...
    def getLocalRotateY(self, **kwargs) -> float: ...
    def getLocalRotateZ(self, **kwargs) -> float: ...
    def getLocalScale(self, **kwargs) -> Tuple[float, float, float]: ...
    def getLocalScaleX(self, **kwargs) -> float: ...
    def getLocalScaleY(self, **kwargs) -> float: ...
    def getLocalScaleZ(self, **kwargs) -> float: ...
    def getLocalTranslate(self, **kwargs) -> Tuple[float, float, float]: ...
    def getLocalTranslateX(self, **kwargs) -> float: ...
    def getLocalTranslateY(self, **kwargs) -> float: ...
    def getLocalTranslateZ(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getPivot(self, **kwargs) -> Tuple[float, float, float]: ...
    def getPivotX(self, **kwargs) -> float: ...
    def getPivotY(self, **kwargs) -> float: ...
    def getPivotZ(self, **kwargs) -> float: ...
    def getRandom(self, **kwargs) -> float: ...
    def getRotate(self, **kwargs) -> Tuple[float, float, float]: ...
    def getRotateX(self, **kwargs) -> float: ...
    def getRotateY(self, **kwargs) -> float: ...
    def getRotateZ(self, **kwargs) -> float: ...
    def getScale(self, **kwargs) -> Tuple[float, float, float]: ...
    def getScaleX(self, **kwargs) -> float: ...
    def getScaleY(self, **kwargs) -> float: ...
    def getScaleZ(self, **kwargs) -> float: ...
    def getTranslate(self, **kwargs) -> Tuple[float, float, float]: ...
    def getTranslateX(self, **kwargs) -> float: ...
    def getTranslateY(self, **kwargs) -> float: ...
    def getTranslateZ(self, **kwargs) -> float: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setGain(self, val: Union[float, List[float]] = ..., **kwargs: Any) -> None: ...
    def setLocalCenter(self, val: int = ..., **kwargs: Any) -> None: ...
    def setLocalDirection(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setLocalDirectionX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalDirectionY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalDirectionZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalRotate(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setLocalRotateX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalRotateY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalRotateZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalScale(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setLocalScaleX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalScaleY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalScaleZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalTranslate(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setLocalTranslateX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalTranslateY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalTranslateZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPivot(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setPivotX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPivotY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPivotZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRandom(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRotate(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setRotateX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRotateY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRotateZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setScale(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setScaleX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setScaleY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setScaleZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTranslate(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setTranslateX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTranslateY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTranslateZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyExtrudeEdge(PolyMoveEdge):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getDivisions(self, **kwargs) -> int: ...
    def getGain(self, **kwargs) -> float: ...
    def getKeepFacesTogether(self, **kwargs) -> bool: ...
    def getLocalCenter(self, **kwargs) -> int: ...
    def getLocalDirection(self, **kwargs) -> Tuple[float, float, float]: ...
    def getLocalDirectionX(self, **kwargs) -> float: ...
    def getLocalDirectionY(self, **kwargs) -> float: ...
    def getLocalDirectionZ(self, **kwargs) -> float: ...
    def getLocalRotate(self, **kwargs) -> Tuple[float, float, float]: ...
    def getLocalRotateX(self, **kwargs) -> float: ...
    def getLocalRotateY(self, **kwargs) -> float: ...
    def getLocalRotateZ(self, **kwargs) -> float: ...
    def getLocalScale(self, **kwargs) -> Tuple[float, float, float]: ...
    def getLocalScaleX(self, **kwargs) -> float: ...
    def getLocalScaleY(self, **kwargs) -> float: ...
    def getLocalScaleZ(self, **kwargs) -> float: ...
    def getLocalTranslate(self, **kwargs) -> Tuple[float, float, float]: ...
    def getLocalTranslateX(self, **kwargs) -> float: ...
    def getLocalTranslateY(self, **kwargs) -> float: ...
    def getLocalTranslateZ(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getOffset(self, **kwargs) -> float: ...
    def getPivot(self, **kwargs) -> Tuple[float, float, float]: ...
    def getPivotX(self, **kwargs) -> float: ...
    def getPivotY(self, **kwargs) -> float: ...
    def getPivotZ(self, **kwargs) -> float: ...
    def getRandom(self, **kwargs) -> float: ...
    def getRotate(self, **kwargs) -> Tuple[float, float, float]: ...
    def getRotateX(self, **kwargs) -> float: ...
    def getRotateY(self, **kwargs) -> float: ...
    def getRotateZ(self, **kwargs) -> float: ...
    def getScale(self, **kwargs) -> Tuple[float, float, float]: ...
    def getScaleX(self, **kwargs) -> float: ...
    def getScaleY(self, **kwargs) -> float: ...
    def getScaleZ(self, **kwargs) -> float: ...
    def getSmoothingAngle(self, **kwargs) -> float: ...
    def getTaper(self, **kwargs) -> float: ...
    def getTaperCurve_FloatValue(self, **kwargs) -> float: ...
    def getTaperCurve_Interp(self, **kwargs) -> int: ...
    def getTaperCurve_Position(self, **kwargs) -> float: ...
    def getThickness(self, **kwargs) -> float: ...
    def getTranslate(self, **kwargs) -> Tuple[float, float, float]: ...
    def getTranslateX(self, **kwargs) -> float: ...
    def getTranslateY(self, **kwargs) -> float: ...
    def getTranslateZ(self, **kwargs) -> float: ...
    def getTwist(self, **kwargs) -> float: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDivisions(self, val: int = ..., **kwargs: Any) -> None: ...
    def setGain(self, val: Union[float, List[float]] = ..., **kwargs: Any) -> None: ...
    def setKeepFacesTogether(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setLocalCenter(self, val: int = ..., **kwargs: Any) -> None: ...
    def setLocalDirection(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setLocalDirectionX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalDirectionY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalDirectionZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalRotate(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setLocalRotateX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalRotateY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalRotateZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalScale(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setLocalScaleX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalScaleY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalScaleZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalTranslate(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setLocalTranslateX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalTranslateY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalTranslateZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setOffset(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPivot(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setPivotX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPivotY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPivotZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRandom(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRotate(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setRotateX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRotateY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRotateZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setScale(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setScaleX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setScaleY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setScaleZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSmoothingAngle(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTaper(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTaperCurve_FloatValue(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTaperCurve_Interp(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTaperCurve_Position(self, val: float = ..., **kwargs: Any) -> None: ...
    def setThickness(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTranslate(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setTranslateX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTranslateY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTranslateZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTwist(self, val: float = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyMoveFace(PolyMoveEdge):
    __melnode__: str

class PolyChipOff(PolyMoveFace):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAttraction(self, **kwargs) -> float: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getDuplicate(self, **kwargs) -> bool: ...
    def getGain(self, **kwargs) -> float: ...
    def getGravity(self, **kwargs) -> Tuple[float, float, float]: ...
    def getGravityX(self, **kwargs) -> float: ...
    def getGravityY(self, **kwargs) -> float: ...
    def getGravityZ(self, **kwargs) -> float: ...
    def getKeepFacesTogether(self, **kwargs) -> bool: ...
    def getKeepFacetTogether(self, **kwargs) -> bool: ...
    def getLocalCenter(self, **kwargs) -> int: ...
    def getLocalDirection(self, **kwargs) -> Tuple[float, float, float]: ...
    def getLocalDirectionX(self, **kwargs) -> float: ...
    def getLocalDirectionY(self, **kwargs) -> float: ...
    def getLocalDirectionZ(self, **kwargs) -> float: ...
    def getLocalRotate(self, **kwargs) -> Tuple[float, float, float]: ...
    def getLocalRotateX(self, **kwargs) -> float: ...
    def getLocalRotateY(self, **kwargs) -> float: ...
    def getLocalRotateZ(self, **kwargs) -> float: ...
    def getLocalScale(self, **kwargs) -> Tuple[float, float, float]: ...
    def getLocalScaleX(self, **kwargs) -> float: ...
    def getLocalScaleY(self, **kwargs) -> float: ...
    def getLocalScaleZ(self, **kwargs) -> float: ...
    def getLocalTranslate(self, **kwargs) -> Tuple[float, float, float]: ...
    def getLocalTranslateX(self, **kwargs) -> float: ...
    def getLocalTranslateY(self, **kwargs) -> float: ...
    def getLocalTranslateZ(self, **kwargs) -> float: ...
    def getMagnX(self, **kwargs) -> float: ...
    def getMagnY(self, **kwargs) -> float: ...
    def getMagnZ(self, **kwargs) -> float: ...
    def getMagnet(self, **kwargs) -> Tuple[float, float, float]: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getOffset(self, **kwargs) -> float: ...
    def getPivot(self, **kwargs) -> Tuple[float, float, float]: ...
    def getPivotX(self, **kwargs) -> float: ...
    def getPivotY(self, **kwargs) -> float: ...
    def getPivotZ(self, **kwargs) -> float: ...
    def getRandom(self, **kwargs) -> float: ...
    def getScale(self, **kwargs) -> Tuple[float, float, float]: ...
    def getScaleX(self, **kwargs) -> float: ...
    def getScaleY(self, **kwargs) -> float: ...
    def getScaleZ(self, **kwargs) -> float: ...
    def getTranslate(self, **kwargs) -> Tuple[float, float, float]: ...
    def getTranslateX(self, **kwargs) -> float: ...
    def getTranslateY(self, **kwargs) -> float: ...
    def getTranslateZ(self, **kwargs) -> float: ...
    def getWeight(self, **kwargs) -> float: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setAttraction(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDuplicate(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setGain(self, val: Union[float, List[float]] = ..., **kwargs: Any) -> None: ...
    def setGravity(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setGravityX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setGravityY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setGravityZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setKeepFacesTogether(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeepFacetTogether(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setLocalCenter(self, val: int = ..., **kwargs: Any) -> None: ...
    def setLocalDirection(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setLocalDirectionX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalDirectionY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalDirectionZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalRotate(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setLocalRotateX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalRotateY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalRotateZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalScale(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setLocalScaleX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalScaleY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalScaleZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalTranslate(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setLocalTranslateX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalTranslateY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setLocalTranslateZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setMagnX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setMagnY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setMagnZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setMagnet(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setOffset(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPivot(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setPivotX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPivotY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPivotZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRandom(self, val: float = ..., **kwargs: Any) -> None: ...
    def setScale(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setScaleX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setScaleY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setScaleZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTranslate(self, val: Tuple[float, float, float] = ..., **kwargs: Any) -> None: ...
    def setTranslateX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTranslateY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTranslateZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setWeight(self, val: float = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyExtrudeFace(PolyMoveFace):
    __melnode__: str

class PolyPassThru(PolyModifierWorld):
    __melnode__: str

class PolyPlanarProj(PolyModifierWorld):
    __melnode__: str

class PolyPoke(PolyModifierWorld):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyProj(PolyModifierWorld):
    __melnode__: str

class PolyQuad(PolyModifierWorld):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAngle(self, **kwargs) -> float: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getKeepGroupBorder(self, **kwargs) -> bool: ...
    def getKeepHardEdges(self, **kwargs) -> bool: ...
    def getKeepTextureBorders(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setAngle(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeepGroupBorder(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeepHardEdges(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeepTextureBorders(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyRemesh(PolyModifierWorld):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getCollapseThreshold(self, **kwargs) -> float: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getInterpolationType(self, **kwargs) -> int: ...
    def getMaxEdgeLength(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getSmoothStrength(self, **kwargs) -> float: ...
    def getTessellateBorders(self, **kwargs) -> bool: ...
    def getUseRelativeValues(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCollapseThreshold(self, val: float = ..., **kwargs: Any) -> None: ...
    def setInterpolationType(self, val: int = ..., **kwargs: Any) -> None: ...
    def setMaxEdgeLength(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSmoothStrength(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTessellateBorders(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setUseRelativeValues(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolySewEdge(PolyModifierWorld):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getTexture(self, **kwargs) -> bool: ...
    def getTolerance(self, **kwargs) -> float: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTexture(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setTolerance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolySoftEdge(PolyModifierWorld):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAngle(self, **kwargs) -> float: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setAngle(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolySphProj(PolyModifierWorld):
    __melnode__: str

class PolySplitRing(PolyModifierWorld):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAdjustEdgeFlow(self, **kwargs) -> float: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getDirection(self, **kwargs) -> bool: ...
    def getDivisions(self, **kwargs) -> int: ...
    def getEnableProfileCurve(self, **kwargs) -> bool: ...
    def getFixQuads(self, **kwargs) -> bool: ...
    def getInsertWithEdgeFlow(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getProfileCurve_FloatValue(self, **kwargs) -> float: ...
    def getProfileCurve_Interp(self, **kwargs) -> int: ...
    def getProfileCurve_Position(self, **kwargs) -> float: ...
    def getProfileCurveInputOffset(self, **kwargs) -> float: ...
    def getProfileCurveInputScale(self, **kwargs) -> float: ...
    def getRootEdge(self, **kwargs) -> int: ...
    def getSmoothingAngle(self, **kwargs) -> float: ...
    def getSplitType(self, **kwargs) -> int: ...
    def getUseEqualMultiplier(self, **kwargs) -> bool: ...
    def getUseFaceNormalsAtEnds(self, **kwargs) -> bool: ...
    def getWeight(self, **kwargs) -> float: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setAdjustEdgeFlow(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDirection(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDivisions(self, val: int = ..., **kwargs: Any) -> None: ...
    def setEnableProfileCurve(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFixQuads(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setInsertWithEdgeFlow(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setProfileCurve_FloatValue(self, val: float = ..., **kwargs: Any) -> None: ...
    def setProfileCurve_Interp(self, val: int = ..., **kwargs: Any) -> None: ...
    def setProfileCurve_Position(self, val: float = ..., **kwargs: Any) -> None: ...
    def setProfileCurveInputOffset(self, val: float = ..., **kwargs: Any) -> None: ...
    def setProfileCurveInputScale(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRootEdge(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSmoothingAngle(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSplitType(self, val: int = ..., **kwargs: Any) -> None: ...
    def setUseEqualMultiplier(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setUseFaceNormalsAtEnds(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setWeight(self, val: float = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolySplitVert(PolyModifierWorld):
    __melnode__: str

class PolySubdEdge(PolyModifierWorld):
    __melnode__: str

class PolyWedgeFace(PolyModifierWorld):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyMoveUV(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAxisLen(self, **kwargs) -> Tuple[float, float]: ...
    def getAxisLenX(self, **kwargs) -> float: ...
    def getAxisLenY(self, **kwargs) -> float: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getPivot(self, **kwargs) -> Tuple[float, float]: ...
    def getPivotU(self, **kwargs) -> float: ...
    def getPivotV(self, **kwargs) -> float: ...
    def getRandom(self, **kwargs) -> float: ...
    def getRotationAngle(self, **kwargs) -> float: ...
    def getScale(self, **kwargs) -> Tuple[float, float]: ...
    def getScaleU(self, **kwargs) -> float: ...
    def getScaleV(self, **kwargs) -> float: ...
    def getTranslate(self, **kwargs) -> Tuple[float, float]: ...
    def getTranslateU(self, **kwargs) -> float: ...
    def getTranslateV(self, **kwargs) -> float: ...
    def setAxisLen(self, val: Tuple[float, float] = ..., **kwargs: Any) -> None: ...
    def setAxisLenX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setAxisLenY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPivot(self, val: Tuple[float, float] = ..., **kwargs: Any) -> None: ...
    def setPivotU(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPivotV(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRandom(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRotationAngle(self, val: float = ..., **kwargs: Any) -> None: ...
    def setScale(self, val: Tuple[float, float] = ..., **kwargs: Any) -> None: ...
    def setScaleU(self, val: float = ..., **kwargs: Any) -> None: ...
    def setScaleV(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTranslate(self, val: Tuple[float, float] = ..., **kwargs: Any) -> None: ...
    def setTranslateU(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTranslateV(self, val: float = ..., **kwargs: Any) -> None: ...

class PolyMoveFacetUV(PolyMoveUV):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAxisLen(self, **kwargs) -> Tuple[float, float]: ...
    def getAxisLenX(self, **kwargs) -> float: ...
    def getAxisLenY(self, **kwargs) -> float: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getPivot(self, **kwargs) -> Tuple[float, float]: ...
    def getPivotU(self, **kwargs) -> float: ...
    def getPivotV(self, **kwargs) -> float: ...
    def getRandom(self, **kwargs) -> float: ...
    def getRotationAngle(self, **kwargs) -> float: ...
    def getScale(self, **kwargs) -> Tuple[float, float]: ...
    def getScaleU(self, **kwargs) -> float: ...
    def getScaleV(self, **kwargs) -> float: ...
    def getTranslate(self, **kwargs) -> Tuple[float, float]: ...
    def getTranslateU(self, **kwargs) -> float: ...
    def getTranslateV(self, **kwargs) -> float: ...
    def setAxisLen(self, val: Tuple[float, float] = ..., **kwargs: Any) -> None: ...
    def setAxisLenX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setAxisLenY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPivot(self, val: Tuple[float, float] = ..., **kwargs: Any) -> None: ...
    def setPivotU(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPivotV(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRandom(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRotationAngle(self, val: float = ..., **kwargs: Any) -> None: ...
    def setScale(self, val: Tuple[float, float] = ..., **kwargs: Any) -> None: ...
    def setScaleU(self, val: float = ..., **kwargs: Any) -> None: ...
    def setScaleV(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTranslate(self, val: Tuple[float, float] = ..., **kwargs: Any) -> None: ...
    def setTranslateU(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTranslateV(self, val: float = ..., **kwargs: Any) -> None: ...

class PolyNormal(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getNormalMode(self, **kwargs) -> int: ...
    def getUserNormalMode(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNormalMode(self, val: int = ..., **kwargs: Any) -> None: ...
    def setUserNormalMode(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyNormalPerVertex(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAllLocked(self, **kwargs) -> bool: ...
    def getDeformable(self, **kwargs) -> bool: ...
    def getFreezeNormal(self, **kwargs) -> bool: ...
    def getNormalX(self, **kwargs) -> float: ...
    def getNormalXYZ(self, **kwargs) -> Tuple[float, float, float]: ...
    def getNormalY(self, **kwargs) -> float: ...
    def getNormalZ(self, **kwargs) -> float: ...
    def getRelative(self, **kwargs) -> bool: ...
    def getUnFreezeNormal(self, **kwargs) -> bool: ...
    def setAllLocked(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDeformable(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFreezeNormal(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNormalX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNormalXYZ(self, val: Union[Tuple[float, float, float], List[Tuple[float, float, float]]] = ..., **kwargs: Any) -> None: ...
    def setNormalY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNormalZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRelative(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setUnFreezeNormal(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyReduce(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getCachingReduce(self, **kwargs) -> bool: ...
    def getColorWeights(self, **kwargs) -> float: ...
    def getCompactness(self, **kwargs) -> float: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getGeomWeights(self, **kwargs) -> float: ...
    def getInvertVertexWeights(self, **kwargs) -> bool: ...
    def getKeepBorder(self, **kwargs) -> bool: ...
    def getKeepBorderWeight(self, **kwargs) -> float: ...
    def getKeepColorBorder(self, **kwargs) -> bool: ...
    def getKeepColorBorderWeight(self, **kwargs) -> float: ...
    def getKeepCreaseEdge(self, **kwargs) -> bool: ...
    def getKeepCreaseEdgeWeight(self, **kwargs) -> float: ...
    def getKeepFaceGroupBorder(self, **kwargs) -> bool: ...
    def getKeepFaceGroupBorderWeight(self, **kwargs) -> float: ...
    def getKeepHardEdge(self, **kwargs) -> bool: ...
    def getKeepHardEdgeWeight(self, **kwargs) -> float: ...
    def getKeepMapBorder(self, **kwargs) -> bool: ...
    def getKeepMapBorderWeight(self, **kwargs) -> float: ...
    def getKeepOriginalVertices(self, **kwargs) -> bool: ...
    def getKeepQuadsWeight(self, **kwargs) -> float: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getPercentage(self, **kwargs) -> float: ...
    def getPreserveTopology(self, **kwargs) -> bool: ...
    def getSharpness(self, **kwargs) -> float: ...
    def getSymmetryPlaneW(self, **kwargs) -> float: ...
    def getSymmetryPlaneX(self, **kwargs) -> float: ...
    def getSymmetryPlaneY(self, **kwargs) -> float: ...
    def getSymmetryPlaneZ(self, **kwargs) -> float: ...
    def getSymmetryTolerance(self, **kwargs) -> float: ...
    def getTermination(self, **kwargs) -> int: ...
    def getTriangleCount(self, **kwargs) -> int: ...
    def getTriangulate(self, **kwargs) -> bool: ...
    def getUseVirtualSymmetry(self, **kwargs) -> int: ...
    def getUvWeights(self, **kwargs) -> float: ...
    def getVersion(self, **kwargs) -> int: ...
    def getVertexCount(self, **kwargs) -> int: ...
    def getVertexMapName(self, **kwargs) -> Any: ...
    def getVertexWeightCoefficient(self, **kwargs) -> float: ...
    def getWeightCoefficient(self, **kwargs) -> float: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCachingReduce(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setColorWeights(self, val: float = ..., **kwargs: Any) -> None: ...
    def setCompactness(self, val: float = ..., **kwargs: Any) -> None: ...
    def setGeomWeights(self, val: float = ..., **kwargs: Any) -> None: ...
    def setInvertVertexWeights(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeepBorder(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeepBorderWeight(self, val: float = ..., **kwargs: Any) -> None: ...
    def setKeepColorBorder(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeepColorBorderWeight(self, val: float = ..., **kwargs: Any) -> None: ...
    def setKeepCreaseEdge(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeepCreaseEdgeWeight(self, val: float = ..., **kwargs: Any) -> None: ...
    def setKeepFaceGroupBorder(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeepFaceGroupBorderWeight(self, val: float = ..., **kwargs: Any) -> None: ...
    def setKeepHardEdge(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeepHardEdgeWeight(self, val: float = ..., **kwargs: Any) -> None: ...
    def setKeepMapBorder(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeepMapBorderWeight(self, val: float = ..., **kwargs: Any) -> None: ...
    def setKeepOriginalVertices(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeepQuadsWeight(self, val: float = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPercentage(self, val: float = ..., **kwargs: Any) -> None: ...
    def setPreserveTopology(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSharpness(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSymmetryPlaneW(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSymmetryPlaneX(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSymmetryPlaneY(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSymmetryPlaneZ(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSymmetryTolerance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setTermination(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTriangleCount(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTriangulate(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setUseVirtualSymmetry(self, val: int = ..., **kwargs: Any) -> None: ...
    def setUvWeights(self, val: float = ..., **kwargs: Any) -> None: ...
    def setVersion(self, val: int = ..., **kwargs: Any) -> None: ...
    def setVertexCount(self, val: int = ..., **kwargs: Any) -> None: ...
    def setVertexWeightCoefficient(self, val: float = ..., **kwargs: Any) -> None: ...
    def setWeightCoefficient(self, val: float = ..., **kwargs: Any) -> None: ...

class PolyRetopo(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str

class PolySmooth(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getContinuity(self, **kwargs) -> float: ...
    def getDivisions(self, **kwargs) -> int: ...
    def getKeepBorder(self, **kwargs) -> bool: ...
    def getKeepHardEdge(self, **kwargs) -> bool: ...
    def getKeepSelectionBorder(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getOsdCreaseMethod(self, **kwargs) -> int: ...
    def getOsdFvarBoundary(self, **kwargs) -> int: ...
    def getOsdFvarPropagateCorners(self, **kwargs) -> bool: ...
    def getOsdSmoothTriangles(self, **kwargs) -> bool: ...
    def getOsdVertBoundary(self, **kwargs) -> int: ...
    def getPropagateEdgeHardness(self, **kwargs) -> bool: ...
    def getSubdivisionType(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setContinuity(self, val: float = ..., **kwargs: Any) -> None: ...
    def setDivisions(self, val: int = ..., **kwargs: Any) -> None: ...
    def setKeepBorder(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeepHardEdge(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setKeepSelectionBorder(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setOsdCreaseMethod(self, val: int = ..., **kwargs: Any) -> None: ...
    def setOsdFvarBoundary(self, val: int = ..., **kwargs: Any) -> None: ...
    def setOsdFvarPropagateCorners(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setOsdSmoothTriangles(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setOsdVertBoundary(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPropagateEdgeHardness(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSubdivisionType(self, val: int = ..., **kwargs: Any) -> None: ...

class PolySmoothFace(PolyModifier):
    __melnode__: str

class PolySmoothProxy(PolyModifier):
    __melnode__: str

class PolySpinEdge(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str

class PolySplit(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAdjustEdgeFlow(self, **kwargs) -> float: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getInsertWithEdgeFlow(self, **kwargs) -> bool: ...
    def getSubdivision(self, **kwargs) -> int: ...
    def setAdjustEdgeFlow(self, val: float = ..., **kwargs: Any) -> None: ...
    def setInsertWithEdgeFlow(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSubdivision(self, val: int = ..., **kwargs: Any) -> None: ...

class PolySplitEdge(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getOperation(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setOperation(self, val: int = ..., **kwargs: Any) -> None: ...

class PolySubdFace(PolyModifier):
    __melnode__: str

class PolyTransfer(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getAlternateObject(self, **kwargs) -> str: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getUvSets(self, **kwargs) -> bool: ...
    def getVertexColor(self, **kwargs) -> bool: ...
    def getVertices(self, **kwargs) -> bool: ...
    def setAlternateObject(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setUvSets(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setVertexColor(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setVertices(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class PolyTriangulate(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyTweak(PolyModifier):
    __melnode__: str

class PolyTweakUV(PolyModifier):
    __melnode__: str

class PolyUVRectangle(PolyModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getNodeState(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyBlindData(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def associationType(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def binaryData(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def booleanData(self, val: Union[bool, int, List[Union[bool, int]]] = ..., **kwargs: Any) -> None: ...
    def delete(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def doubleData(self, val: Union[float, List[float]] = ..., **kwargs: Any) -> None: ...
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def int64Data(self, val: Union[int, List[int]] = ..., **kwargs: Any) -> None: ...
    def intData(self, val: Union[int, List[int]] = ..., **kwargs: Any) -> None: ...
    def longDataName(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def rescan(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def reset(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...
    def setTypeId(self, val: int = ..., **kwargs: Any) -> None: ...
    def shape(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def shortDataName(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def stringData(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...

class SubdBlindData(PolyBlindData):
    __melnode__: str

class PolySeparate(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def getNodeState(self, **kwargs) -> int: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...

class PolyToSubdiv(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAbsolutePosition(self, **kwargs) -> bool: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getApplyMatrixToResult(self, **kwargs) -> bool: ...
    def getCaching(self, **kwargs) -> bool: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def getMaxEdgesPerVert(self, **kwargs) -> int: ...
    def getMaxPolyCount(self, **kwargs) -> int: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getPreserveVertexOrdering(self, **kwargs) -> bool: ...
    def getQuickConvert(self, **kwargs) -> bool: ...
    def getUvPoints(self, **kwargs) -> Tuple[float, float]: ...
    def getUvPointsU(self, **kwargs) -> float: ...
    def getUvPointsV(self, **kwargs) -> float: ...
    def getUvTreatment(self, **kwargs) -> int: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAbsolutePosition(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...
    def setApplyMatrixToResult(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setMaxEdgesPerVert(self, val: int = ..., **kwargs: Any) -> None: ...
    def setMaxPolyCount(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPreserveVertexOrdering(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setQuickConvert(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setUvPoints(self, val: Union[Tuple[float, float], List[Tuple[float, float]]] = ..., **kwargs: Any) -> None: ...
    def setUvPointsU(self, val: float = ..., **kwargs: Any) -> None: ...
    def setUvPointsV(self, val: float = ..., **kwargs: Any) -> None: ...
    def setUvTreatment(self, val: int = ..., **kwargs: Any) -> None: ...

class PoseInterpolatorManager(DependNode):
    __melnode__: str

class PostProcessList(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class PrecompExport(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class ProximityFalloff(DependNode):
    __melnode__: str

class ProximityPin(DependNode):
    __melnode__: str

class ProxyManager(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class Record(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class Reference(DependNode):
    __apicls__: Incomplete
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def associatedNamespace(self, baseName: bool) -> str: ...
    def containsNode(self, node: Union[str, DependNode]) -> bool: ...
    def containsNodeExactly(self, node: Union[str, DependNode]) -> bool: ...
    def fileName(self, resolvedName: bool, includePath: bool, includeCopyNumber: bool) -> str: ...
    @classmethod
    def getIgnoreReferenceEdits(self) -> bool: ...
    def isExportEditsFile(self) -> bool: ...
    def isLoaded(self) -> bool: ...
    def isReferenceLocked(self) -> bool: ...
    def isValidReference(self) -> bool: ...
    def nodes(self) -> List[DependNode]: ...
    def parentAssembly(self) -> DependNode: ...
    def parentFileName(self, resolveName: bool, includePath: bool, includeCopyNumber: bool) -> str: ...
    def parentReference(self) -> DependNode: ...
    @classmethod
    def setIgnoreReferenceEdits(self, ignoreEdits: bool) -> None: ...

class RemapColor(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class RemapHsv(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class RemapValue(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class RenderGlobals(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class RenderGlobalsList(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class RenderLayerManager(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class RenderPassSet(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class RenderQuality(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class ReorderUVSet(DependNode):
    __melnode__: str

class Resolution(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class Reverse(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class RgbToHsv(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class RigidSolver(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getAutoTolerances(self, **kwargs) -> bool: ...
    def getBounciness(self, **kwargs) -> bool: ...
    def getCacheData(self, **kwargs) -> bool: ...
    def getCollide(self, **kwargs) -> bool: ...
    def getCollisionTolerance(self, **kwargs) -> float: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def getContactData(self, **kwargs) -> bool: ...
    def getDeleteCache(self, **kwargs) -> bool: ...
    def getDisplayCenterOfMass(self, **kwargs) -> bool: ...
    def getDisplayConstraint(self, **kwargs) -> bool: ...
    def getDisplayVelocity(self, **kwargs) -> bool: ...
    def getDynamics(self, **kwargs) -> bool: ...
    def getFriction(self, **kwargs) -> bool: ...
    def getInterpenetrate(self, **kwargs) -> bool: ...
    def getRigidBodies(self, **kwargs) -> Any: ...
    def getRigidBodyCount(self, **kwargs) -> Any: ...
    def getShowCollision(self, **kwargs) -> bool: ...
    def getShowInterpenetration(self, **kwargs) -> bool: ...
    def getSolverMethod(self, **kwargs) -> int: ...
    def getStartTime(self, **kwargs) -> float: ...
    def getState(self, **kwargs) -> bool: ...
    def getStatistics(self, **kwargs) -> bool: ...
    def getStepSize(self, **kwargs) -> float: ...
    def getVelocityVectorScale(self, **kwargs) -> float: ...
    def interpenetrationCheck(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...
    def setAutoTolerances(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setBounciness(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCacheData(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCollide(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCollisionTolerance(self, val: float = ..., **kwargs: Any) -> None: ...
    def setContactData(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDeleteCache(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDisplayCenterOfMass(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDisplayConstraint(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDisplayVelocity(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setDynamics(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFriction(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setInterpenetrate(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setShowCollision(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setShowInterpenetration(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSolverMethod(self, val: int = ..., **kwargs: Any) -> None: ...
    def setStartTime(self, val: float = ..., **kwargs: Any) -> None: ...
    def setState(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setStatistics(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setStepSize(self, val: float = ..., **kwargs: Any) -> None: ...
    def setVelocityVectorScale(self, val: float = ..., **kwargs: Any) -> None: ...

class Sampler(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class Script(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class SelectionListOperator(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class SequenceManager(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def getCurrentShot(self, **kwargs) -> Any: ...
    def getCurrentTime(self, **kwargs) -> Any: ...
    def getModelPanel(self, **kwargs) -> Any: ...
    def getNode(self, **kwargs) -> Any: ...
    def getWritableSequencer(self, **kwargs) -> Any: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class Sequencer(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class SetRange(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class ShaderGlow(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class ShadingDependNode(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class BaseShadingSwitch(ShadingDependNode):
    __melnode__: str

class DoubleShadingSwitch(BaseShadingSwitch):
    __melnode__: str

class QuadShadingSwitch(BaseShadingSwitch):
    __melnode__: str

class SingleShadingSwitch(BaseShadingSwitch):
    __melnode__: str

class TripleShadingSwitch(BaseShadingSwitch):
    __melnode__: str

class Bump2d(ShadingDependNode):
    __melnode__: str

class HwShader(ShadingDependNode):
    __melnode__: str

class THhardwareShader(HwShader):
    __melnode__: str

class THhwShader(HwShader):
    __melnode__: str

class Lambert(ShadingDependNode):
    __apicls__: Incomplete
    __melnode__: str
    def getAmbientColor(self) -> datatypes.Color: ...
    def getColor(self) -> datatypes.Color: ...
    def getDiffuseCoeff(self) -> float: ...
    def getGlowIntensity(self) -> float: ...
    def getHideSource(self) -> bool: ...
    def getIncandescence(self) -> datatypes.Color: ...
    def getRefractedRayDepthLimit(self) -> int: ...
    def getRefractiveIndex(self) -> float: ...
    def getRtRefractedColor(self) -> bool: ...
    def getTranslucenceCoeff(self) -> float: ...
    def getTransparency(self) -> datatypes.Color: ...
    def setAmbientColor(self, ambient_color: datatypes.Color) -> None: ...
    def setColor(self, col: datatypes.Color) -> None: ...
    def setDiffuseCoeff(self, diffuse_coeff: float) -> None: ...
    def setGlowIntensity(self, glow_intensity: float) -> None: ...
    def setHideSource(self, hide_source: bool) -> None: ...
    def setIncandescence(self, incand: datatypes.Color) -> None: ...
    def setRefractedRayDepthLimit(self, refracted_ray_depth_limit: int) -> None: ...
    def setRefractiveIndex(self, refractive_index: float) -> None: ...
    def setRtRefractedColor(self, rt_refracted_color: bool) -> None: ...
    def setTranslucenceCoeff(self, translucence_coeff: float) -> None: ...
    def setTransparency(self, transp: datatypes.Color) -> None: ...

class Reflect(Lambert):
    __apicls__: Incomplete
    __melnode__: str
    def getReflectedColor(self) -> datatypes.Color: ...
    def getReflectedRayDepthLimit(self) -> int: ...
    def getReflectivity(self) -> float: ...
    def getSpecularColor(self) -> datatypes.Color: ...
    def setReflectedColor(self, reflected_color: datatypes.Color) -> None: ...
    def setReflectedRayDepthLimit(self, reflected_ray_depth_limit: int) -> None: ...
    def setReflectivity(self, reflect: float) -> None: ...
    def setSpecularColor(self, specular_color: datatypes.Color) -> None: ...

class Anisotropic(Reflect):
    __apicls__: Incomplete
    __melnode__: str
    def getAnisotropicReflectivity(self) -> bool: ...
    def getCorrelationX(self) -> float: ...
    def getCorrelationY(self) -> float: ...
    def getFresnelRefractiveIndex(self) -> float: ...
    def getRotateAngle(self) -> float: ...
    def getRoughness(self) -> float: ...
    def getTangentUCamera(self) -> datatypes.Color: ...
    def getTangentVCamera(self) -> datatypes.Color: ...
    def setAnisotropicReflectivity(self, anisotropic_reflectivity: bool) -> None: ...
    def setCorrelationX(self, correl_x: float) -> None: ...
    def setCorrelationY(self, correl_y: float) -> None: ...
    def setFresnelRefractiveIndex(self, refractive_index: float) -> None: ...
    def setRotateAngle(self, rotate_angle: float) -> None: ...
    def setRoughness(self, roughness: float) -> None: ...
    def setTangentUCamera(self, tangu_camera: datatypes.Color) -> None: ...
    def setTangentVCamera(self, tangv_camera: datatypes.Color) -> None: ...

class Blinn(Reflect):
    __apicls__: Incomplete
    __melnode__: str
    def getEccentricity(self) -> float: ...
    def getSpecularRollOff(self) -> float: ...
    def setEccentricity(self, eccentr: float) -> None: ...
    def setSpecularRollOff(self, specular_rolloff: float) -> None: ...

class HairTubeShader(Reflect):
    __melnode__: str

class Phong(Reflect):
    __apicls__: Incomplete
    __melnode__: str
    def getCosPower(self) -> float: ...
    def setCosPower(self, cos_power: float) -> None: ...

class PhongE(Reflect):
    __apicls__: Incomplete
    __melnode__: str
    def getHighlightSize(self) -> float: ...
    def getRoughness(self) -> float: ...
    def getWhiteness(self) -> datatypes.Color: ...
    def setHighlightSize(self, highlight_size: float) -> None: ...
    def setRoughness(self, roughness: float) -> None: ...
    def setWhiteness(self, whiteness: datatypes.Color) -> None: ...

class LayeredShader(ShadingDependNode):
    __apicls__: Incomplete
    __melnode__: str
    def getColor(self, lIndex: int = ...) -> datatypes.Color: ...
    def getCompositingFlag(self) -> int: ...
    def getGlowColor(self, lIndex: int = ...) -> datatypes.Color: ...
    def getHardwareColor(self) -> datatypes.Color: ...
    def getHardwareShader(self) -> datatypes.Color: ...
    def getTransparency(self, lIndex: int = ...) -> datatypes.Color: ...
    def setColor(self, col: datatypes.Color, lIndex: int = ...) -> None: ...
    def setCompositingFlag(self, cflag: int) -> None: ...
    def setGlowColor(self, glow_color: datatypes.Color, lIndex: int = ...) -> None: ...
    def setHardwareColor(self, hardware_color: datatypes.Color) -> None: ...
    def setHardwareShader(self, hardware_shader: datatypes.Color) -> None: ...
    def setTransparency(self, transp: datatypes.Color, lIndex: int = ...) -> None: ...

class LayeredTexture(ShadingDependNode):
    __melnode__: str

class LightFog(ShadingDependNode):
    __melnode__: str

class EnvFog(LightFog):
    __melnode__: str

class MultiplyDivide(ShadingDependNode):
    __melnode__: str

class OceanShader(ShadingDependNode):
    __melnode__: str

class ParticleCloud(ShadingDependNode):
    __melnode__: str

class ParticleSamplerInfo(ShadingDependNode):
    __melnode__: str

class Place2dTexture(ShadingDependNode):
    __melnode__: str

class PlusMinusAverage(ShadingDependNode):
    __melnode__: str

class RampShader(ShadingDependNode):
    __melnode__: str

class SamplerInfo(ShadingDependNode):
    __melnode__: str

class ShadingMap(ShadingDependNode):
    __melnode__: str

class StandardSurface(ShadingDependNode):
    __apicls__: Incomplete
    __melnode__: str
    def getBase(self) -> float: ...
    def getBaseColor(self) -> datatypes.Color: ...
    def getCoat(self) -> float: ...
    def getCoatAffectColor(self) -> float: ...
    def getCoatAffectRoughness(self) -> float: ...
    def getCoatAnisotropy(self) -> float: ...
    def getCoatColor(self) -> datatypes.Color: ...
    def getCoatIOR(self) -> float: ...
    def getCoatRotation(self) -> float: ...
    def getCoatRoughness(self) -> float: ...
    def getDiffuseRoughness(self) -> float: ...
    def getEmission(self) -> float: ...
    def getEmissionColor(self) -> datatypes.Color: ...
    def getMetalness(self) -> float: ...
    def getOpacity(self) -> datatypes.Color: ...
    def getSheen(self) -> float: ...
    def getSheenColor(self) -> datatypes.Color: ...
    def getSheenRoughness(self) -> float: ...
    def getSpecular(self) -> float: ...
    def getSpecularAnisotropy(self) -> float: ...
    def getSpecularColor(self) -> datatypes.Color: ...
    def getSpecularIOR(self) -> float: ...
    def getSpecularRotation(self) -> float: ...
    def getSpecularRoughness(self) -> float: ...
    def getSubsurface(self) -> float: ...
    def getSubsurfaceAnisotropy(self) -> float: ...
    def getSubsurfaceColor(self) -> datatypes.Color: ...
    def getSubsurfaceRadius(self) -> datatypes.Color: ...
    def getSubsurfaceScale(self) -> float: ...
    def getThinFilmIOR(self) -> float: ...
    def getThinFilmThickness(self) -> float: ...
    def getThinWalled(self) -> bool: ...
    def getTransmission(self) -> float: ...
    def getTransmissionColor(self) -> datatypes.Color: ...
    def getTransmissionDepth(self) -> float: ...
    def getTransmissionDispersion(self) -> float: ...
    def getTransmissionExtraRoughness(self) -> float: ...
    def getTransmissionScatter(self) -> datatypes.Color: ...
    def getTransmissionScatterAnisotropy(self) -> float: ...
    def setBase(self, base: float) -> None: ...
    def setBaseColor(self, base_color: datatypes.Color) -> None: ...
    def setCoat(self, coat: float) -> None: ...
    def setCoatAffectColor(self, coat_affect_color: float) -> None: ...
    def setCoatAffectRoughness(self, coat_affect_roughness: float) -> None: ...
    def setCoatAnisotropy(self, coat_anisotropy: float) -> None: ...
    def setCoatColor(self, coat_color: datatypes.Color) -> None: ...
    def setCoatIOR(self, coat_i_o_r: float) -> None: ...
    def setCoatRotation(self, coat_rotation: float) -> None: ...
    def setCoatRoughness(self, coat_roughness: float) -> None: ...
    def setDiffuseRoughness(self, diffuse_roughness: float) -> None: ...
    def setEmission(self, emission: float) -> None: ...
    def setEmissionColor(self, emission_color: datatypes.Color) -> None: ...
    def setMetalness(self, metalness: float) -> None: ...
    def setOpacity(self, opacity: datatypes.Color) -> None: ...
    def setSheen(self, sheen: float) -> None: ...
    def setSheenColor(self, sheen_color: datatypes.Color) -> None: ...
    def setSheenRoughness(self, sheen_roughness: float) -> None: ...
    def setSpecular(self, specular: float) -> None: ...
    def setSpecularAnisotropy(self, specular_anisotropy: float) -> None: ...
    def setSpecularColor(self, specular_color: datatypes.Color) -> None: ...
    def setSpecularIOR(self, specular_i_o_r: float) -> None: ...
    def setSpecularRotation(self, specular_rotation: float) -> None: ...
    def setSpecularRoughness(self, specular_roughness: float) -> None: ...
    def setSubsurface(self, subsurface: float) -> None: ...
    def setSubsurfaceAnisotropy(self, subsurface_anisotropy: float) -> None: ...
    def setSubsurfaceColor(self, subsurface_color: datatypes.Color) -> None: ...
    def setSubsurfaceRadius(self, subsurface_radius: datatypes.Color) -> None: ...
    def setSubsurfaceScale(self, subsurface_scale: float) -> None: ...
    def setThinFilmIOR(self, thin_film_i_o_r: float) -> None: ...
    def setThinFilmThickness(self, thin_film_thickness: float) -> None: ...
    def setThinWalled(self, thin_walled: bool) -> None: ...
    def setTransmission(self, transmission: float) -> None: ...
    def setTransmissionColor(self, transmission_color: datatypes.Color) -> None: ...
    def setTransmissionDepth(self, transmission_depth: float) -> None: ...
    def setTransmissionDispersion(self, transmission_dispersion: float) -> None: ...
    def setTransmissionExtraRoughness(self, transmission_extra_roughness: float) -> None: ...
    def setTransmissionScatter(self, transmission_scatter: datatypes.Color) -> None: ...
    def setTransmissionScatterAnisotropy(self, transmission_scatter_anisotropy: float) -> None: ...

class Texture2d(ShadingDependNode):
    __melnode__: str

class TadskAssetInstanceNode_TdnTx2D(Texture2d):
    __melnode__: str

class Bulge(Texture2d):
    __melnode__: str

class Checker(Texture2d):
    __melnode__: str

class Cloth(Texture2d):
    __melnode__: str

class File(Texture2d):
    __melnode__: str

class Movie(File):
    __melnode__: str

class PsdFileTex(File):
    __melnode__: str

class Fractal(Texture2d):
    __melnode__: str

class Grid(Texture2d):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getDefault(self, **kwargs) -> Any: ...
    def getDisplayAxes(self, **kwargs) -> Any: ...
    def getDisplayAxesBold(self, **kwargs) -> Any: ...
    def getDisplayDivisionLines(self, **kwargs) -> Any: ...
    def getDisplayGridLines(self, **kwargs) -> Any: ...
    def getDisplayOrthographicLabels(self, **kwargs) -> Any: ...
    def getDisplayPerspectiveLabels(self, **kwargs) -> Any: ...
    def getDivisions(self, **kwargs) -> Any: ...
    def getDrawInfiniteGrid(self, **kwargs) -> Any: ...
    def getFogBase(self, **kwargs) -> Any: ...
    def getFogEnabled(self, **kwargs) -> Any: ...
    def getFogMinimumCameraDistance(self, **kwargs) -> Any: ...
    def getFogPower(self, **kwargs) -> Any: ...
    def getGridSizeCameraDistanceFactor(self, **kwargs) -> Any: ...
    def getGridSizeFixed(self, **kwargs) -> Any: ...
    def getGridSizeLogFactorAdjustment(self, **kwargs) -> Any: ...
    def getGridSizeMinimum(self, **kwargs) -> Any: ...
    def getGridSizeVarying(self, **kwargs) -> Any: ...
    def getLineWidth(self, **kwargs) -> Any: ...
    def getMajorColor(self, **kwargs) -> Any: ...
    def getMinorColor(self, **kwargs) -> Any: ...
    def getNormalAxis(self, **kwargs) -> Any: ...
    def getOrthographicLabelPosition(self, **kwargs) -> Any: ...
    def getPerspectiveLabelPosition(self, **kwargs) -> Any: ...
    def getSize(self, **kwargs) -> Any: ...
    def getSpacing(self, **kwargs) -> Any: ...
    def getStyle(self, **kwargs) -> Any: ...
    def getToggle(self, **kwargs) -> Any: ...
    def getXAxisColor(self, **kwargs) -> Any: ...
    def getYAxisColor(self, **kwargs) -> Any: ...
    def getZAxisColor(self, **kwargs) -> Any: ...

class Mandelbrot(Texture2d):
    __melnode__: str

class Mountain(Texture2d):
    __melnode__: str

class Noise(Texture2d):
    __melnode__: str

class Ocean(Texture2d):
    __melnode__: str

class Ramp(Texture2d):
    __melnode__: str

class Stencil(Texture2d):
    __melnode__: str

class Water(Texture2d):
    __melnode__: str

class Texture3d(ShadingDependNode):
    __melnode__: str

class Brownian(Texture3d):
    __melnode__: str

class Cloud(Texture3d):
    __melnode__: str

class Crater(Texture3d):
    __melnode__: str

class Granite(Texture3d):
    __melnode__: str

class Leather(Texture3d):
    __melnode__: str

class Mandelbrot3D(Texture3d):
    __melnode__: str

class Marble(Texture3d):
    __melnode__: str

class Projection(Texture3d):
    __melnode__: str

class Rock(Texture3d):
    __melnode__: str

class Snow(Texture3d):
    __melnode__: str

class SolidFractal(Texture3d):
    __melnode__: str

class Stucco(Texture3d):
    __melnode__: str

class VolumeNoise(Texture3d):
    __melnode__: str

class Wood(Texture3d):
    __melnode__: str

class TextureEnv(ShadingDependNode):
    __melnode__: str

class EnvBall(TextureEnv):
    __melnode__: str

class EnvChrome(TextureEnv):
    __melnode__: str

class EnvCube(TextureEnv):
    __melnode__: str

class EnvSky(TextureEnv):
    __melnode__: str

class EnvSphere(TextureEnv):
    __melnode__: str

class UseBackground(ShadingDependNode):
    __melnode__: str

class VectorProduct(ShadingDependNode):
    __melnode__: str

class VolumeFog(ShadingDependNode):
    __melnode__: str

class ShapeEditorManager(DependNode):
    __melnode__: str

class Shot(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def createCustomAnim(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def deleteCustomAnim(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getAudio(self, **kwargs) -> str: ...
    def getClip(self, **kwargs) -> str: ...
    def getClipDuration(self, **kwargs) -> Union[int, float]: ...
    def getClipOpacity(self, **kwargs) -> float: ...
    def getClipSyncState(self, **kwargs) -> bool: ...
    def getClipZeroOffset(self, **kwargs) -> Union[int, float]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def getCopy(self, **kwargs) -> bool: ...
    def getCurrentCamera(self, **kwargs) -> str: ...
    def getCustomAnim(self, **kwargs) -> Any: ...
    def getDetermineTrack(self, **kwargs) -> bool: ...
    def getEndTime(self, **kwargs) -> Union[int, float]: ...
    def getFavorite(self, **kwargs) -> bool: ...
    def getFlag1(self, **kwargs) -> bool: ...
    def getFlag10(self, **kwargs) -> bool: ...
    def getFlag11(self, **kwargs) -> bool: ...
    def getFlag12(self, **kwargs) -> bool: ...
    def getFlag2(self, **kwargs) -> bool: ...
    def getFlag3(self, **kwargs) -> bool: ...
    def getFlag4(self, **kwargs) -> bool: ...
    def getFlag5(self, **kwargs) -> bool: ...
    def getFlag6(self, **kwargs) -> bool: ...
    def getFlag7(self, **kwargs) -> bool: ...
    def getFlag8(self, **kwargs) -> bool: ...
    def getFlag9(self, **kwargs) -> bool: ...
    def getHasCameraSet(self, **kwargs) -> bool: ...
    def getHasStereoCamera(self, **kwargs) -> bool: ...
    def getImagePlaneVisibility(self, **kwargs) -> bool: ...
    def getLinkAudio(self, **kwargs) -> str: ...
    def getLock(self, **kwargs) -> bool: ...
    def getMute(self, **kwargs) -> bool: ...
    def getPaste(self, **kwargs) -> bool: ...
    def getPasteInstance(self, **kwargs) -> bool: ...
    def getPostHoldTime(self, **kwargs) -> Union[int, float]: ...
    def getPreHoldTime(self, **kwargs) -> Union[int, float]: ...
    def getScale(self, **kwargs) -> float: ...
    def getSelfmute(self, **kwargs) -> bool: ...
    def getSequenceDuration(self, **kwargs) -> Union[int, float]: ...
    def getSequenceEndTime(self, **kwargs) -> Union[int, float]: ...
    def getSequenceStartTime(self, **kwargs) -> Union[int, float]: ...
    def getShotName(self, **kwargs) -> str: ...
    def getSourceDuration(self, **kwargs) -> Union[int, float]: ...
    def getStartTime(self, **kwargs) -> Union[int, float]: ...
    def getTrack(self, **kwargs) -> int: ...
    def getTransitionInLength(self, **kwargs) -> Union[int, float]: ...
    def getTransitionInType(self, **kwargs) -> int: ...
    def getTransitionOutLength(self, **kwargs) -> Union[int, float]: ...
    def getTransitionOutType(self, **kwargs) -> int: ...
    def getUnlinkAudio(self, **kwargs) -> bool: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...
    def setAudio(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setClip(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setClipDuration(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def setClipOpacity(self, val: float = ..., **kwargs: Any) -> None: ...
    def setClipSyncState(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setClipZeroOffset(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def setCopy(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCurrentCamera(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setDetermineTrack(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setEndTime(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def setFavorite(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFlag1(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFlag10(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFlag11(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFlag12(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFlag2(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFlag3(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFlag4(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFlag5(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFlag6(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFlag7(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFlag8(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFlag9(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setHasCameraSet(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setHasStereoCamera(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setImagePlaneVisibility(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setLinkAudio(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setLock(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setMute(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setPaste(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setPasteInstance(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setPostHoldTime(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def setPreHoldTime(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def setScale(self, val: float = ..., **kwargs: Any) -> None: ...
    def setSelfmute(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSequenceDuration(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def setSequenceEndTime(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def setSequenceStartTime(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def setShotName(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setSourceDuration(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def setStartTime(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def setTrack(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTransitionInLength(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def setTransitionInType(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTransitionOutLength(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def setTransitionOutType(self, val: int = ..., **kwargs: Any) -> None: ...
    def setUnlinkAudio(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class SimpleTestNode(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class SimpleVolumeShader(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class SkinBinding(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class Snapshot(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def getConstructionHistory(self, **kwargs) -> Any: ...
    def getEndTime(self, **kwargs) -> Union[int, float]: ...
    def getIncrement(self, **kwargs) -> Union[int, float]: ...
    def getStartTime(self, **kwargs) -> Union[int, float]: ...
    def getUpdate(self, **kwargs) -> str: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...
    def setEndTime(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def setIncrement(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def setStartTime(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def setUpdate(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...

class MotionTrail(Snapshot):
    __melnode__: str

class StrokeGlobals(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class SubdBase(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class SubdModifier(SubdBase):
    __melnode__: str

class SubdAddTopology(SubdModifier):
    __melnode__: str

class SubdCleanTopology(SubdModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str

class SubdMapCut(SubdModifier):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...

class SubdModifierWorld(SubdModifier):
    __melnode__: str

class SubdModifierUV(SubdModifierWorld):
    __melnode__: str

class SubdAutoProj(SubdModifierUV):
    __melnode__: str

class SubdLayoutUV(SubdModifierUV):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getFlipReversed(self, **kwargs) -> bool: ...
    def getLayout(self, **kwargs) -> int: ...
    def getLayoutMethod(self, **kwargs) -> int: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getPercentageSpace(self, **kwargs) -> float: ...
    def getRotateForBestFit(self, **kwargs) -> int: ...
    def getScale(self, **kwargs) -> int: ...
    def getSeparate(self, **kwargs) -> int: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setFlipReversed(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setLayout(self, val: int = ..., **kwargs: Any) -> None: ...
    def setLayoutMethod(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setPercentageSpace(self, val: float = ..., **kwargs: Any) -> None: ...
    def setRotateForBestFit(self, val: int = ..., **kwargs: Any) -> None: ...
    def setScale(self, val: int = ..., **kwargs: Any) -> None: ...
    def setSeparate(self, val: int = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class SubdMapSewMove(SubdModifierUV):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getCaching(self, **kwargs) -> bool: ...
    def getLimitPieceSize(self, **kwargs) -> bool: ...
    def getNodeState(self, **kwargs) -> int: ...
    def getNumberFaces(self, **kwargs) -> int: ...
    def getWorldSpace(self, **kwargs) -> bool: ...
    def setCaching(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setLimitPieceSize(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setNodeState(self, val: int = ..., **kwargs: Any) -> None: ...
    def setNumberFaces(self, val: int = ..., **kwargs: Any) -> None: ...
    def setWorldSpace(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class SubdPlanarProj(SubdModifierWorld):
    __melnode__: str

class SubdTweak(SubdModifier):
    __melnode__: str

class SubdTweakUV(SubdModifier):
    __melnode__: str

class SubdivCollapse(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class SubdivComponentId(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class SubdivReverseFaces(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class SubdivToPoly(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class SubsetFalloff(DependNode):
    __melnode__: str

class SurfaceLuminance(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class SurfaceShader(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class TexLattice(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class TextureToGeom(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class ThreadedDevice(DependNode):
    __melnode__: str

class ClientDevice(ThreadedDevice):
    __melnode__: str

class Time(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class TimeEditor(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def getMute(self, **kwargs) -> Any: ...

class TimeEditorAnimSource(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def addSource(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def apply(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def bakeToAnimSource(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def copyAnimation(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def exclusive(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def export(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def getAddObjects(self, **kwargs) -> str: ...
    def getAddRelatedKG(self, **kwargs) -> bool: ...
    def getAddSelectedObjects(self, **kwargs) -> bool: ...
    def getCalculateTiming(self, **kwargs) -> bool: ...
    def getDrivenClips(self, **kwargs) -> Any: ...
    def getIsUnique(self, **kwargs) -> Any: ...
    def getTargetIndex(self, **kwargs) -> Any: ...
    def getTargets(self, **kwargs) -> Any: ...
    def getType(self, **kwargs) -> str: ...
    def importOption(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def importPopulateOption(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def includeRoot(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def populateAttribute(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def recursively(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def removeSceneAnimation(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def removeSource(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setAddObjects(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setAddRelatedKG(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setAddSelectedObjects(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setCalculateTiming(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setType(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...

class TimeEditorClipBase(DependNode):
    __melnode__: str

class TimeEditorClip(TimeEditorClipBase):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def addClipAttribute(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def allowShrinking(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def clipId(self, val: Union[int, List[int]] = ..., **kwargs: Any) -> None: ...
    def copyClip(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def duplicateClip(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def exclusive(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def existingOnly(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def explode(self, val: int = ..., **kwargs: Any) -> None: ...
    def exportAllClips(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def exportFbx(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def extend(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def extendParent(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def getAbsolute(self, **kwargs) -> Any: ...
    def getAddObjects(self, **kwargs) -> str: ...
    def getAddRelatedKG(self, **kwargs) -> bool: ...
    def getAddSelectedObjects(self, **kwargs) -> bool: ...
    def getAnimSource(self, **kwargs) -> str: ...
    def getBlendMode(self, **kwargs) -> int: ...
    def getChildren(self, **kwargs) -> Any: ...
    def getClipAfter(self, **kwargs) -> Any: ...
    def getClipBefore(self, **kwargs) -> Any: ...
    def getClipDataType(self, **kwargs) -> Any: ...
    def getClipIdFromNodeName(self, **kwargs) -> Any: ...
    def getClipIdFromPath(self, **kwargs) -> Any: ...
    def getClipNode(self, **kwargs) -> Any: ...
    def getClipPath(self, **kwargs) -> Any: ...
    def getCrossfadeMode(self, **kwargs) -> int: ...
    def getCrossfadePlug(self, **kwargs) -> Any: ...
    def getCurveTime(self, **kwargs) -> Any: ...
    def getDefaultGhostRoot(self, **kwargs) -> bool: ...
    def getDrivenAttributes(self, **kwargs) -> Any: ...
    def getDrivenClipsBySource(self, **kwargs) -> Any: ...
    def getDrivenObjects(self, **kwargs) -> Any: ...
    def getDrivenRootObjects(self, **kwargs) -> Any: ...
    def getDrivingSources(self, **kwargs) -> Any: ...
    def getDuration(self, **kwargs) -> Any: ...
    def getEndTime(self, **kwargs) -> Any: ...
    def getExists(self, **kwargs) -> Any: ...
    def getGhost(self, **kwargs) -> bool: ...
    def getHoldEnd(self, **kwargs) -> Union[int, float]: ...
    def getHoldStart(self, **kwargs) -> Union[int, float]: ...
    def getIsContainer(self, **kwargs) -> Any: ...
    def getListUserGhostRoot(self, **kwargs) -> Any: ...
    def getLoopEnd(self, **kwargs) -> Union[int, float]: ...
    def getLoopStart(self, **kwargs) -> Union[int, float]: ...
    def getMinClipDuration(self, **kwargs) -> Any: ...
    def getMute(self, **kwargs) -> bool: ...
    def getParentClipId(self, **kwargs) -> Any: ...
    def getParentGroupId(self, **kwargs) -> Any: ...
    def getRemappedSourceAttrs(self, **kwargs) -> Any: ...
    def getRemappedTargetAttrs(self, **kwargs) -> Any: ...
    def getRemoveWeightCurve(self, **kwargs) -> bool: ...
    def getSpeedRamping(self, **kwargs) -> int: ...
    def getStartTime(self, **kwargs) -> Any: ...
    def getTimeWarp(self, **kwargs) -> Any: ...
    def getTimeWarpCurve(self, **kwargs) -> Any: ...
    def getTimeWarpType(self, **kwargs) -> int: ...
    def getTrack(self, **kwargs) -> str: ...
    def getTracksNode(self, **kwargs) -> Any: ...
    def getTruncated(self, **kwargs) -> Any: ...
    def getType(self, **kwargs) -> str: ...
    def getUserGhostRoot(self, **kwargs) -> bool: ...
    def getWeightCurve(self, **kwargs) -> bool: ...
    def ghostRootAdd(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def ghostRootRemove(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def importOption(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def importPopulateOption(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def includeRoot(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def modifyAnimSource(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def moveClip(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def parent(self, val: int = ..., **kwargs: Any) -> None: ...
    def pasteClip(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def path(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def populateAttribute(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def razorClip(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def recursively(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def remap(self, val: Tuple[str, str] = ..., **kwargs: Any) -> None: ...
    def remapSource(self, val: Tuple[str, str] = ..., **kwargs: Any) -> None: ...
    def removeClip(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def removeClipAttribute(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def removeCrossfade(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def removeSceneAnimation(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def resetTiming(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def resetTransition(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def ripple(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def rootClipId(self, val: int = ..., **kwargs: Any) -> None: ...
    def rootPath(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def scaleEnd(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def scalePivot(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def scaleStart(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def setAddObjects(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setAddRelatedKG(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setAddSelectedObjects(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setAnimSource(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setBlendMode(self, val: int = ..., **kwargs: Any) -> None: ...
    def setCrossfadeMode(self, val: int = ..., **kwargs: Any) -> None: ...
    def setDefaultGhostRoot(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setGhost(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setHoldEnd(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def setHoldStart(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def setKeyframe(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def setLoopEnd(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def setLoopStart(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def setMute(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setRemoveWeightCurve(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setSpeedRamping(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTimeWarpType(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTrack(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setType(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def setUserGhostRoot(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setWeightCurve(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def transition(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def trimEnd(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def trimStart(self, val: Union[int, float] = ..., **kwargs: Any) -> None: ...
    def uniqueAnimSource(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def zeroKeying(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...

class TimeEditorClipEvaluator(DependNode):
    __melnode__: str

class TimeEditorInterpolator(DependNode):
    __melnode__: str

class TimeEditorTracks(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def addTrack(self, val: int = ..., **kwargs: Any) -> None: ...
    def getActiveClipWeight(self, **kwargs) -> Any: ...
    def getActiveClipWeightId(self, **kwargs) -> Any: ...
    def getAllClips(self, **kwargs) -> Any: ...
    def getAllTracks(self, **kwargs) -> Any: ...
    def getAllTracksRecursive(self, **kwargs) -> Any: ...
    def getComposition(self, **kwargs) -> Any: ...
    def getPlugIndex(self, **kwargs) -> int: ...
    def getSelectedTracks(self, **kwargs) -> Any: ...
    def getTrackGhost(self, **kwargs) -> bool: ...
    def getTrackIndex(self, **kwargs) -> int: ...
    def getTrackMuted(self, **kwargs) -> bool: ...
    def getTrackName(self, **kwargs) -> str: ...
    def getTrackSolo(self, **kwargs) -> bool: ...
    def getTrackType(self, **kwargs) -> int: ...
    def path(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def removeTrack(self, val: Union[int, List[int]] = ..., **kwargs: Any) -> None: ...
    def removeTrackByPath(self, val: Union[str, List[str]] = ..., **kwargs: Any) -> None: ...
    def reorderTrack(self, val: Tuple[int, int] = ..., **kwargs: Any) -> None: ...
    def setPlugIndex(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTrackGhost(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setTrackIndex(self, val: int = ..., **kwargs: Any) -> None: ...
    def setTrackMuted(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setTrackName(self, val: Union[_util.ProxyUnicode, str] = ..., **kwargs: Any) -> None: ...
    def setTrackSolo(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setTrackType(self, val: int = ..., **kwargs: Any) -> None: ...

class TimeFunction(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class TimeToUnitConversion(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class TimeWarp(DependNode):
    __melcmd__: Incomplete
    __melcmd_isinfo__: bool
    __melcmdname__: str
    __melnode__: str
    def deleteFrame(self, val: int = ..., **kwargs: Any) -> None: ...
    def getFrame(self, **kwargs) -> float: ...
    def getG(self, **kwargs) -> bool: ...
    def getInterpType(self, **kwargs) -> Tuple[int, str]: ...
    def getMoveFrame(self, **kwargs) -> Tuple[int, float]: ...
    def setFrame(self, val: Union[float, List[float]] = ..., **kwargs: Any) -> None: ...
    def setG(self, val: Union[bool, int] = ..., **kwargs: Any) -> None: ...
    def setInterpType(self, val: Tuple[int, str] = ..., **kwargs: Any) -> None: ...
    def setMoveFrame(self, val: Tuple[int, float] = ..., **kwargs: Any) -> None: ...

class ToonLineAttributes(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class TrackInfoManager(DependNode):
    __melnode__: str

class TransferFalloff(DependNode):
    __melnode__: str

class UniformFalloff(DependNode):
    __melnode__: str

class UnitConversion(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class UnitToTimeConversion(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class Unknown(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class UvChooser(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class UvPin(DependNode):
    __melnode__: str

class ViewColorManager(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class VolumeShader(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

class WtAddMatrix(DependNode):
    __melnode__: str
    def findAlias(self, alias: str) -> Tuple[bool, DependNode]: ...
    def getAffectedAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAffectedByAttributes(self, attr: Union[str, DependNode]) -> List[DependNode]: ...
    def getAliasList(self) -> Tuple[bool, List[str]]: ...
    def getConnections(self) -> List[general.Attribute]: ...
    def plugsAlias(self, plug: Union[str, general.Attribute]) -> str: ...
    def setAlias(self, alias: str, name: str, plug: Union[str, general.Attribute], add: bool = ...) -> bool: ...

dynModule: Incomplete
