# A number of the aliases here are the result of a "failed" rename (using
# 'useName': renameAlias) in an older version of pymel - basically, there was
# a bug that made subclasses still wrap the old name (in addition to the new
# name), meaning that both names were accessible.  Since it existed like
# this for a long time before we noticed, we decided not to drop backward
# compatibility.
# For posterity, here is the full list of affected classes:
#
# DependNode
#     known affected children: too many to list
#
#     hasUniqueName => isUniquelyNamed
#     isFromReferencedFile => isReferenced
# DagNode
#     known affected children: shape (and all it's children), unknownDag
#
#     child => childAtIndex
#     childCount => numChildren
#     dagRoot => root
#     isIntermediateObject => isIntermediate
#     parent => parentAtIndex
#     setIntermediateObject => setIntermediate
#     usingObjectColor => isUsingObjectColor
# Camera
#     known affected children: stereoRigCamera
#
#     isMotionBlur => isMotionBlurred
#     getFarClippingPlane => getFarClipPlane
#     getNearClippingPlane => getNearClipPlane
#     setFarClippingPlane => setFarClipPlane
#     setNearClippingPlane => setNearClipPlane
#     setMotionBlur => setMotionBlurred
#     set => setupCamera
# Mesh
#     known affected children: greasePlaneRenderShape
#
#     createColorSetWithName => createColorSet
#     createUVSetWithName => createUVSet
#     getAssociatedColorSetInstances => _getAssociatedColorSetInstances
#     getAssociatedUVSetInstances => _getAssociatedUVSetInstances
#     numPolygons => _numPolygons (presumably in favor of "numFaces", from mel?)
#     polygonVertexCount => numPolygonVertices
# Transform
#     known affected children: place3DTexture, assembly, constraints, fields,
#         containers, many more...
#
#     enableLimit => setLimited
#     limitValue => getLimit
#     set => setTransformation
#     transformation => getTransformation
#
# In nearly all cases, we opted to simply add aliases for the "failed" renames.

version = (1, 1)

data = ({('AbstractBaseCreate', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('AbstractBaseCreate', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('AbstractBaseCreate', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('AbstractBaseCreate', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('AbstractBaseCreate', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('AbstractBaseCreate', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('AbstractBaseCreate', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('AddDoubleLinear', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('AddDoubleLinear', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('AddDoubleLinear', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('AddDoubleLinear', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('AddDoubleLinear', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('AddDoubleLinear', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('AddDoubleLinear', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('AddMatrix', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('AddMatrix', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('AddMatrix', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('AddMatrix', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('AddMatrix', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('AddMatrix', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('AddMatrix', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('AirField', 'getDirection'): {'melName': 'getDirection*'},
  ('AirField', 'getName'): {'melEnabled': False},
  ('AirField', 'setDirection'): {'melName': 'setDirection*'},
  ('AirField', 'setName'): {'melEnabled': False},
  ('AmbientLight', 'getName'): {'melEnabled': False},
  ('AmbientLight', 'setName'): {'melEnabled': False},
  ('AngleBetween', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('AngleBetween', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('AngleBetween', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('AngleBetween', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('AngleBetween', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('AngleBetween', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('AngleBetween', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('AnimBlend', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('AnimBlend', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('AnimBlend', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('AnimBlend', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('AnimBlend', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('AnimBlend', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('AnimBlend', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('AnimBlendNodeBase', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('AnimBlendNodeBase', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('AnimBlendNodeBase', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('AnimBlendNodeBase', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('AnimBlendNodeBase', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('AnimBlendNodeBase', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('AnimBlendNodeBase', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('AnimClip', 'createInstancedClip'): {'enabled': False},
  ('AnimClip', 'createSourceClip'): {'enabled': False},
  ('AnimClip', 'getAbsolute'): {'enabled': False},
  ('AnimClip', 'getCycle'): {'enabled': False},
  ('AnimClip', 'getTrack'): {'enabled': False},
  ('AnimClip', 'setAbsolute'): {'enabled': False},
  ('AnimClip', 'setCycle'): {'enabled': False},
  ('AnimClip', 'setTrack'): {'enabled': False},
  ('AnimCurve', 'addKey'): {'enabled': False},
  ('AnimCurve', 'addKeys'): {'enabled': False},
  ('AnimCurve', 'evaluate'): {'enabled': False},
  ('AnimCurve', 'find'): {'enabled': False},
  ('AnimCurve', 'findClosest'): {'enabled': False},
  ('AnimCurve', 'numKeyframes'): {'enabled': False},
  ('AnimLayer', 'removeAttribute'): {'enabled': False, 'melEnabled': True},
  ('Anisotropic', 'getFresnelRefractiveIndex'): {'origName': 'getRefractiveIndex'},
  ('Anisotropic', 'getRefractiveIndex'): {'useName': 'getFresnelRefractiveIndex'},
  ('Anisotropic', 'setFresnelRefractiveIndex'): {'origName': 'setRefractiveIndex'},
  ('Anisotropic', 'setRefractiveIndex'): {'useName': 'setFresnelRefractiveIndex'},
  ('ArrayMapper', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('ArrayMapper', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('ArrayMapper', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('ArrayMapper', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('ArrayMapper', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('ArrayMapper', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('ArrayMapper', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('AttrEnumOptionMenu', 'attribute'): {'melEnabled': True},
  ('AttrEnumOptionMenuGrp', 'attribute'): {'melEnabled': True},
  ('AttrHierarchyTest', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('AttrHierarchyTest', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('AttrHierarchyTest', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('AttrHierarchyTest', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('AttrHierarchyTest', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('AttrHierarchyTest', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('AttrHierarchyTest', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Attribute', 'MObject'): {'enabled': False},
  ('Attribute', '__eq__'): {'enabled': False},
  ('Attribute', '__getitem__'): {'enabled': False},
  ('Attribute', '__neq__'): {'enabled': False},
  ('Attribute', '_getArrayIndices'): {'origName': 'getExistingArrayAttributeIndices'},
  ('Attribute', '_partialname'): {'origName': 'partialName'},
  ('Attribute', '_setLocked'): {'origName': 'setLocked'},
  ('Attribute', 'array'): {'enabled': False},
  ('Attribute', 'asBool'): {'enabled': False},
  ('Attribute', 'asChar'): {'enabled': False},
  ('Attribute', 'asDouble'): {'enabled': False},
  ('Attribute', 'asFloat'): {'enabled': False},
  ('Attribute', 'asInt'): {'enabled': False},
  ('Attribute', 'asInt64'): {'enabled': False},
  ('Attribute', 'asMAngle'): {'enabled': False},
  ('Attribute', 'asMDataHandle'): {'enabled': False},
  ('Attribute', 'asMDistance'): {'enabled': False},
  ('Attribute', 'asMObject'): {'enabled': False},
  ('Attribute', 'asMTime'): {'enabled': False},
  ('Attribute', 'asShort'): {'enabled': False},
  ('Attribute', 'asString'): {'enabled': False},
  ('Attribute', 'child'): {'enabled': False},
  ('Attribute', 'connectedTo'): {'enabled': False},
  ('Attribute', 'connectionByPhysicalIndex'): {'enabled': False},
  ('Attribute', 'constructHandle'): {'enabled': False},
  ('Attribute', 'destructHandle'): {'enabled': False},
  ('Attribute', 'elementByLogicalIndex'): {'aliases': ['__getitem__']},
  ('Attribute', 'getAttribute'): {'enabled': False},
  ('Attribute', 'getExistingArrayAttributeIndices'): {'useName': '_getArrayIndices'},
  ('Attribute', 'getParent'): {'origName': 'parent'},
  ('Attribute', 'getValue'): {'enabled': False},
  ('Attribute', 'isArray'): {'aliases': ['isMulti']},
  ('Attribute', 'isCaching'): {'origName': 'isCachingFlagSet'},
  ('Attribute', 'isCachingFlagSet'): {'useName': 'isCaching'},
  ('Attribute', 'isChannelBoxFlagSet'): {'useName': 'isInChannelBox'},
  ('Attribute', 'isInChannelBox'): {'origName': 'isChannelBoxFlagSet'},
  ('Attribute', 'logicalIndex'): {'aliases': ['item', 'index']},
  ('Attribute', 'node'): {'enabled': False},
  ('Attribute', 'parent'): {'useName': 'getParent'},
  ('Attribute', 'partialName'): {'enabled': False, 'useName': '_partialname'},
  ('Attribute', 'selectAncestorLogicalIndex'): {'enabled': False},
  ('Attribute', 'setAttribute'): {'enabled': False},
  ('Attribute', 'setBool'): {'enabled': False},
  ('Attribute', 'setChannelBox'): {'useName': 'showInChannelBox'},
  ('Attribute', 'setChar'): {'enabled': False},
  ('Attribute', 'setDouble'): {'enabled': False},
  ('Attribute', 'setFloat'): {'enabled': False},
  ('Attribute', 'setInt'): {'enabled': False},
  ('Attribute', 'setInt64'): {'enabled': False},
  ('Attribute', 'setLocked'): {'useName': '_setLocked'},
  ('Attribute', 'setMAngle'): {'enabled': False},
  ('Attribute', 'setMDataHandle'): {'enabled': False},
  ('Attribute', 'setMDistance'): {'enabled': False},
  ('Attribute', 'setMObject'): {'enabled': False},
  ('Attribute', 'setMPxData'): {'enabled': False},
  ('Attribute', 'setMTime'): {'enabled': False},
  ('Attribute', 'setShort'): {'enabled': False},
  ('Attribute', 'setString'): {'enabled': False},
  ('Attribute', 'setValue'): {'enabled': False},
  ('Attribute', 'showInChannelBox'): {'origName': 'setChannelBox'},
  ('Audio', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Audio', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Audio', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Audio', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Audio', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Audio', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Audio', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('BaseGeometryVarGroup', 'getRotationQuaternion'): {'backwards_compatibility_enabled': 'Use getRotation(quaternion=True) instead.'},
  ('BaseGeometryVarGroup', 'setRotationQuaternion'): {'backwards_compatibility_enabled': 'Use setRotation, and pass in a Quaternion object, instead.'},
  ('BezierCurve', 'numCVs'): {'enabled': False},
  ('Blend', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Blend', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Blend', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Blend', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Blend', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Blend', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Blend', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('BlendColors', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('BlendColors', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('BlendColors', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('BlendColors', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('BlendColors', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('BlendColors', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('BlendColors', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('BlendShape', 'getEnvelope'): {'override': True},
  ('BlendShape', 'setEnvelope'): {'override': True},
  ('BlindDataTemplate', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('BlindDataTemplate', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('BlindDataTemplate', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('BlindDataTemplate', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('BlindDataTemplate', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('BlindDataTemplate', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('BlindDataTemplate', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('BoundingBox', 'width'): {'properties': ['w']},
  ('BoundingBox', 'height'): {'properties': ['h']},
  ('BoundingBox', 'depth'): {'properties': ['d']},
  ('Brush', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Brush', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Brush', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Brush', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Brush', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Brush', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Brush', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Bump3d', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Bump3d', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Bump3d', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Bump3d', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Bump3d', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Bump3d', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Bump3d', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('CacheBase', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('CacheBase', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('CacheBase', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('CacheBase', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('CacheBase', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('CacheBase', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('CacheBase', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Camera', '_setNearFarClippingPlanes'): {'origName': 'setNearFarClippingPlanes'},
  ('Camera', 'getFarClippingPlane'): {'aliases': ['getFarClipPlane'],
                                      'melName': 'getFarClipPlane'},
  ('Camera', 'getMotionBlur'): {'useName': 'isMotionBlurred'},
  ('Camera', 'getName'): {'melEnabled': False},
  ('Camera', 'getNearClippingPlane'): {'aliases': ['getNearClipPlane'],
                                       'melName': 'getNearClipPlane'},
  ('Camera', 'getOrthoWidth'): {'melName': 'getOrthographicWidth'},
  ('Camera', 'getPosition'): {'melEnabled': False},
  ('Camera', 'getRotation'): {'melEnabled': False},
  ('Camera', 'getStereoHIT'): {'melName': 'getStereoHorizontalImageTranslate'},
  ('Camera', 'getStereoHITEnabled'): {'melName': 'getStereoHorizontalImageTranslateEnabled'},
  ('Camera', 'isClippingPlanes'): {'melName': 'getClippingPlanes'},
  ('Camera', 'isDepthOfField'): {'melName': 'getDepthOfField'},
  ('Camera', 'isDisplayFilmGate'): {'melName': 'getDisplayFilmGate'},
  # failed rename: Camera.isMotionBlur => isMotionBlurred
  ('Camera', 'isMotionBlur'): {'aliases': ['isMotionBlurred'],
                               'melName': 'getMotionBlur'},
  ('Camera', 'isOrtho'): {'melName': 'getOrthographic'},
  ('Camera', 'isVerticalLock'): {'melName': 'getVerticalLock'},
  ('Camera', 'set'): {'aliases': ['setupCamera']},
  ('Camera', 'setFarClippingPlane'): {'aliases': ['setFarClipPlane'],
                                      'melName': 'setFarClipPlane'},
  ('Camera', 'setMotionBlur'): {'aliases': ['setMotionBlurred']},
  ('Camera', 'setName'): {'melEnabled': False},
  ('Camera', 'setNearClippingPlane'): {'aliases': ['setNearClipPlane'],
                                       'melName': 'setNearClipPlane'},
  ('Camera', 'setNearFarClippingPlanes'): {'useName': '_setNearFarClippingPlanes'},
  ('Camera', 'setOrtho'): {'melName': 'setOrthographic'},
  ('Camera', 'setOrthoWidth'): {'melName': 'setOrthographicWidth'},
  ('Camera', 'setPosition'): {'melEnabled': False},
  ('Camera', 'setRotation'): {'melEnabled': False},
  ('Camera', 'setStereoHIT'): {'melName': 'setStereoHorizontalImageTranslate'},
  ('Camera', 'setStereoHITEnabled'): {'melName': 'setStereoHorizontalImageTranslateEnabled'},
  ('CameraSet', 'getSortedIndices'): {'enabled': False},
  ('CameraView', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('CameraView', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('CameraView', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('CameraView', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('CameraView', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('CameraView', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('CameraView', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Character', 'addCurveToClip'): {'enabled': False},
  ('Character', 'attachInstanceToCharacter'): {'enabled': False},
  ('Character', 'attachSourceToCharacter'): {'enabled': False},
  ('Character', 'createBlend'): {'enabled': False},
  ('Character', 'removeBlend'): {'enabled': False},
  ('CharacterMap', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('CharacterMap', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('CharacterMap', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('CharacterMap', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('CharacterMap', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('CharacterMap', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('CharacterMap', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('CharacterOffset', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('CharacterOffset', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('CharacterOffset', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('CharacterOffset', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('CharacterOffset', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('CharacterOffset', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('CharacterOffset', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Choice', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Choice', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Choice', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Choice', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Choice', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Choice', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Choice', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Chooser', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Chooser', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Chooser', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Chooser', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Chooser', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Chooser', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Chooser', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Clamp', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Clamp', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Clamp', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Clamp', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Clamp', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Clamp', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Clamp', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('ClipLibrary', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('ClipLibrary', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('ClipLibrary', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('ClipLibrary', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('ClipLibrary', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('ClipLibrary', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('ClipLibrary', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('ClipScheduler', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('ClipScheduler', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('ClipScheduler', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('ClipScheduler', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('ClipScheduler', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('ClipScheduler', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('ClipScheduler', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('ClosestPointOnMesh', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('ClosestPointOnMesh', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('ClosestPointOnMesh', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('ClosestPointOnMesh', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('ClosestPointOnMesh', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('ClosestPointOnMesh', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('ClosestPointOnMesh', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('ColorProfile', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('ColorProfile', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('ColorProfile', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('ColorProfile', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('ColorProfile', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('ColorProfile', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('ColorProfile', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Condition', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Condition', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Condition', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Condition', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Condition', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Condition', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Condition', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Constraint', 'getRotationQuaternion'): {'backwards_compatibility_enabled': 'Use getRotation(quaternion=True) instead.'},
  ('Constraint', 'setRotationQuaternion'): {'backwards_compatibility_enabled': 'Use setRotation, and pass in a Quaternion object, instead.'},
  ('Container', 'getCurrent'): {'origName': 'getCurrentAsMObject'},
  ('Container', 'getCurrentAsMObject'): {'useName': 'getCurrent'},
  ('Contrast', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Contrast', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Contrast', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Contrast', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Contrast', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Contrast', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Contrast', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('CopyColorSet', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('CopyColorSet', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('CopyColorSet', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('CopyColorSet', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('CopyColorSet', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('CopyColorSet', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('CopyColorSet', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('CopyUVSet', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('CopyUVSet', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('CopyUVSet', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('CopyUVSet', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('CopyUVSet', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('CopyUVSet', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('CopyUVSet', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('CreateColorSet', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('CreateColorSet', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('CreateColorSet', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('CreateColorSet', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('CreateColorSet', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('CreateColorSet', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('CreateColorSet', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('CreateUVSet', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('CreateUVSet', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('CreateUVSet', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('CreateUVSet', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('CreateUVSet', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('CreateUVSet', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('CreateUVSet', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('CurveFromMesh', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('CurveFromMesh', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('CurveFromMesh', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('CurveFromMesh', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('CurveFromMesh', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('CurveFromMesh', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('CurveFromMesh', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('CurveNormalizer', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('CurveNormalizer', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('CurveNormalizer', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('CurveNormalizer', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('CurveNormalizer', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('CurveNormalizer', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('CurveNormalizer', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('CylindricalLightLocator', 'enum'): {'enabled': False},
  ('DagContainer', 'getRotationQuaternion'): {'backwards_compatibility_enabled': 'Use getRotation(quaternion=True) instead.'},
  ('DagContainer', 'setRotationQuaternion'): {'backwards_compatibility_enabled': 'Use setRotation, and pass in a Quaternion object, instead.'},
  ('DagNode', 'addChild'): {'enabled': False},
  ('DagNode', 'child'): {'aliases': ['childAtIndex']},
  ('DagNode', 'childCount'): {'aliases': ['numChildren']},
  ('DagNode', 'create'): {'overloadIndex': 2},
  ('DagNode', 'dagPath'): {'enabled': False},
  ('DagNode', 'dagRoot'): {'aliases': ['root']},
  ('DagNode', 'duplicate'): {'enabled': False},
  ('DagNode', 'enum'): {'enabled': False},
  ('DagNode', 'getAllPaths'): {'backwards_compatibility_enabled': 'Use getInstances instead.',
                               'enabled': False},
  ('DagNode', 'getPath'): {'enabled': False},
  ('DagNode', 'isIntermediateObject'): {'aliases': ['isIntermediate']},
  ('DagNode', 'model'): {'enabled': False},
  ('DagNode', 'parent'): {'aliases': ['parentAtIndex']},
  ('DagNode', 'removeChild'): {'enabled': False},
  ('DagNode', 'removeChildAt'): {'enabled': False},
  ('DagNode', 'setIntermediateObject'): {'aliases': ['setIntermediate']},
  ('DagNode', 'setObject'): {'enabled': False},
  ('DagNode', 'usingObjectColor'): {'aliases': ['isUsingObjectColor']},
  ('DagPose', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('DagPose', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('DagPose', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('DagPose', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('DagPose', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('DagPose', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('DagPose', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('DataBlockTest', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('DataBlockTest', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('DataBlockTest', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('DataBlockTest', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('DataBlockTest', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('DataBlockTest', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('DataBlockTest', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('DefaultLightList', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('DefaultLightList', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('DefaultLightList', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('DefaultLightList', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('DefaultLightList', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('DefaultLightList', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('DefaultLightList', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('DefaultRenderUtilityList', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('DefaultRenderUtilityList', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('DefaultRenderUtilityList', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('DefaultRenderUtilityList', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('DefaultRenderUtilityList', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('DefaultRenderUtilityList', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('DefaultRenderUtilityList', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('DefaultRenderingList', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('DefaultRenderingList', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('DefaultRenderingList', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('DefaultRenderingList', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('DefaultRenderingList', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('DefaultRenderingList', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('DefaultRenderingList', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('DefaultShaderList', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('DefaultShaderList', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('DefaultShaderList', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('DefaultShaderList', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('DefaultShaderList', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('DefaultShaderList', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('DefaultShaderList', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('DefaultTextureList', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('DefaultTextureList', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('DefaultTextureList', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('DefaultTextureList', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('DefaultTextureList', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('DefaultTextureList', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('DefaultTextureList', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('DeleteColorSet', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('DeleteColorSet', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('DeleteColorSet', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('DeleteColorSet', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('DeleteColorSet', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('DeleteColorSet', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('DeleteColorSet', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('DeleteComponent', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('DeleteComponent', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('DeleteComponent', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('DeleteComponent', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('DeleteComponent', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('DeleteComponent', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('DeleteComponent', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('DeleteUVSet', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('DeleteUVSet', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('DeleteUVSet', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('DeleteUVSet', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('DeleteUVSet', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('DeleteUVSet', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('DeleteUVSet', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('DependNode', 'addExternalContentForFileAttr'): {'enabled': False},
  ('DependNode', 'classification'): {'enabled': False},
  ('DependNode', 'dgCallbackIds'): {'enabled': False},
  ('DependNode', 'findAlias'): {'enabled': False},
  ('DependNode', 'findPlug'): {'enabled': False},
  ('DependNode', 'getAffectedAttributes'): {'enabled': False},
  ('DependNode', 'getAffectedByAttributes'): {'enabled': False},
  ('DependNode', 'getAliasList'): {'enabled': False},
  ('DependNode', 'getConnections'): {'enabled': False},
  ('DependNode', 'getExternalContent'): {'enabled': False},
  ('DependNode', 'getPlugsAlias'): {'enabled': False},
  ('DependNode', 'getUuid'): {'enabled': False},
  ('DependNode', 'hasUniqueName'): {'aliases': ['isUniquelyNamed']},
  ('DependNode', 'isFromReferencedFile'): {'aliases': ['isReadOnly',
                                                       'isReferenced']},
  ('DependNode', 'plugsAlias'): {'enabled': False},
  ('DependNode', 'reorderedAttribute'): {'enabled': False},
  ('DependNode', 'setAlias'): {'enabled': False},
  ('DependNode', 'setExternalContent'): {'enabled': False},
  ('DependNode', 'setExternalContentForFileAttr'): {'enabled': False},
  ('DependNode', 'setUuid'): {'enabled': False},
  ('DependNode', 'typeId'): {'enabled': False},
  ('DependNode', 'userNode'): {'enabled': False},
  ('DirectionalLight', 'getName'): {'melEnabled': False},
  ('DirectionalLight', 'getPosition'): {'melEnabled': False},
  ('DirectionalLight', 'getRotation'): {'melEnabled': False},
  ('DirectionalLight', 'setName'): {'melEnabled': False},
  ('DirectionalLight', 'setPosition'): {'melEnabled': False},
  ('DirectionalLight', 'setRotation'): {'melEnabled': False},
  ('DiscLightLocator', 'enum'): {'enabled': False},
  ('DiskCache', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('DiskCache', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('DiskCache', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('DiskCache', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('DiskCache', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('DiskCache', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('DiskCache', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('DisplacementShader', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('DisplacementShader', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('DisplacementShader', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('DisplacementShader', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('DisplacementShader', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('DisplacementShader', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('DisplacementShader', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('DisplayLayer', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('DisplayLayer', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('DisplayLayer', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('DisplayLayer', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('DisplayLayer', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('DisplayLayer', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('DisplayLayer', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('DisplayLayerManager', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('DisplayLayerManager', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('DisplayLayerManager', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('DisplayLayerManager', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('DisplayLayerManager', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('DisplayLayerManager', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('DisplayLayerManager', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('DistanceBetween', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('DistanceBetween', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('DistanceBetween', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('DistanceBetween', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('DistanceBetween', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('DistanceBetween', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('DistanceBetween', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Dof', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Dof', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Dof', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Dof', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Dof', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Dof', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Dof', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('DragField', 'getDirection'): {'melName': 'getDirection*'},
  ('DragField', 'getName'): {'melEnabled': False},
  ('DragField', 'getPosition'): {'melEnabled': False},
  ('DragField', 'setDirection'): {'melName': 'setDirection*'},
  ('DragField', 'setName'): {'melEnabled': False},
  ('DragField', 'setPosition'): {'melEnabled': False},
  ('DynBase', 'getRotationQuaternion'): {'backwards_compatibility_enabled': 'Use getRotation(quaternion=True) instead.'},
  ('DynBase', 'setRotationQuaternion'): {'backwards_compatibility_enabled': 'Use setRotation, and pass in a Quaternion object, instead.'},
  ('DynController', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('DynController', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('DynController', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('DynController', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('DynController', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('DynController', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('DynController', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('DynGlobals', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('DynGlobals', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('DynGlobals', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('DynGlobals', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('DynGlobals', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('DynGlobals', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('DynGlobals', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Entity', 'attributeCount'): {'enabled': False},
  ('Entity', 'canBeWritten'): {'enabled': False},
  ('Entity', 'create'): {'overloadIndex': 2},
  ('Entity', 'getName'): {'enabled': False},
  ('Entity', 'hasUniqueName'): {'enabled': False},
  ('Entity', 'isDefaultNode'): {'enabled': False},
  ('Entity', 'isFlagSet'): {'enabled': False},
  ('Entity', 'isFromReferencedFile'): {'enabled': False},
  ('Entity', 'isLocked'): {'enabled': False},
  ('Entity', 'isShared'): {'enabled': False},
  ('Entity', 'parentNamespace'): {'enabled': False},
  ('Entity', 'pluginName'): {'enabled': False},
  ('Entity', 'setDoNotWrite'): {'enabled': False},
  ('Entity', 'setLocked'): {'enabled': False},
  ('Entity', 'setName'): {'enabled': False},
  ('Facade', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Facade', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Facade', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Facade', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Facade', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Facade', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Facade', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Flow', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Flow', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Flow', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Flow', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Flow', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Flow', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Flow', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  # disabled for now because a) it wasn't enabled previously (hidden by
  # ProxyUnicode.index), and b) it has a bunch of different overloads - if we
  # want to enable it, we should probably make a manual wrapper which decides
  # which form to use depending on what it's fed - and maybe at least split into
  # two methods - coordsToIndex, and indexToCoords?
  # This might be a good idea, but don't want to tackle it now...
  ('FluidShape', 'index'): {'enabled': False},
  ('FourByFourMatrix', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('FourByFourMatrix', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('FourByFourMatrix', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('FourByFourMatrix', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('FourByFourMatrix', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('FourByFourMatrix', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('FourByFourMatrix', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('FrameCache', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('FrameCache', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('FrameCache', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('FrameCache', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('FrameCache', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('FrameCache', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('FrameCache', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('GammaCorrect', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('GammaCorrect', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('GammaCorrect', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('GammaCorrect', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('GammaCorrect', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('GammaCorrect', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('GammaCorrect', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('GeoConnector', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('GeoConnector', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('GeoConnector', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('GeoConnector', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('GeoConnector', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('GeoConnector', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('GeoConnector', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  # 'split' isn't from MFnGeometry filter, but from the various mel deformer
  # commands (skinCluster, lattice, etc) - but they check up the chain, so
  # we can disable here
  # We disable because a) it conflicts with the string "split" wrap, and
  # b) it's not very useful as a method - it can only be used in create mode
  # (not applicable) or edit if there is no geometry attached (how often do you
  # have no geo attached to a deformer?)
  ('GeometryFilter', 'split'): {'melEnabled': False},
  ('GlobalCacheControl', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('GlobalCacheControl', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('GlobalCacheControl', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('GlobalCacheControl', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('GlobalCacheControl', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('GlobalCacheControl', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('GlobalCacheControl', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('GravityField', 'getDirection'): {'melName': 'getDirection*'},
  ('GravityField', 'getName'): {'melEnabled': False},
  ('GravityField', 'getPosition'): {'melEnabled': False},
  ('GravityField', 'setDirection'): {'melName': 'setDirection*'},
  ('GravityField', 'setName'): {'melEnabled': False},
  ('GravityField', 'setPosition'): {'melEnabled': False},
  # Make sure these GreasePlaneRenderShape num* don't get wrapped, even as
  # deprecated, because they're manually wrapped (but not when building)
  ('GreasePlaneRenderShape', 'numColorSets'): {'enabled': False},
  ('GreasePlaneRenderShape', 'numFaceVertices'): {'enabled': False},
  ('GreasePlaneRenderShape', 'numNormals'): {'enabled': False},
  ('GreasePlaneRenderShape', 'numUVSets'): {'enabled': False},
  ('GreasePlaneRenderShape', 'numUVs'): {'enabled': False},
  ('GroupId', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('GroupId', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('GroupId', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('GroupId', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('GroupId', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('GroupId', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('GroupId', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('GroupParts', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('GroupParts', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('GroupParts', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('GroupParts', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('GroupParts', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('GroupParts', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('GroupParts', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Guide', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Guide', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Guide', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Guide', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Guide', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Guide', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Guide', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('HardwareRenderGlobals', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('HardwareRenderGlobals', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('HardwareRenderGlobals', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('HardwareRenderGlobals', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('HardwareRenderGlobals', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('HardwareRenderGlobals', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('HardwareRenderGlobals', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('HardwareRenderingGlobals', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('HardwareRenderingGlobals', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('HardwareRenderingGlobals', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('HardwareRenderingGlobals', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('HardwareRenderingGlobals', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('HardwareRenderingGlobals', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('HardwareRenderingGlobals', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('HierarchyTestNode1', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('HierarchyTestNode1', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('HierarchyTestNode1', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('HierarchyTestNode1', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('HierarchyTestNode1', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('HierarchyTestNode1', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('HierarchyTestNode1', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('HikGroundPlane', 'getRotationQuaternion'): {'backwards_compatibility_enabled': 'Use getRotation(quaternion=True) instead.'},
  ('HikGroundPlane', 'setRotationQuaternion'): {'backwards_compatibility_enabled': 'Use setRotation, and pass in a Quaternion object, instead.'},
  ('HikHandle', 'getRotationQuaternion'): {'backwards_compatibility_enabled': 'Use getRotation(quaternion=True) instead.'},
  ('HikHandle', 'setRotationQuaternion'): {'backwards_compatibility_enabled': 'Use setRotation, and pass in a Quaternion object, instead.'},
  ('HikIKEffector', 'getRotationQuaternion'): {'backwards_compatibility_enabled': 'Use getRotation(quaternion=True) instead.'},
  ('HikIKEffector', 'setRotationQuaternion'): {'backwards_compatibility_enabled': 'Use setRotation, and pass in a Quaternion object, instead.'},
  ('HoldMatrix', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('HoldMatrix', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('HoldMatrix', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('HoldMatrix', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('HoldMatrix', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('HoldMatrix', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('HoldMatrix', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('HsvToRgb', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('HsvToRgb', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('HsvToRgb', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('HsvToRgb', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('HsvToRgb', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('HsvToRgb', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('HsvToRgb', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('HwReflectionMap', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('HwReflectionMap', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('HwReflectionMap', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('HwReflectionMap', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('HwReflectionMap', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('HwReflectionMap', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('HwReflectionMap', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('HwRenderGlobals', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('HwRenderGlobals', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('HwRenderGlobals', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('HwRenderGlobals', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('HwRenderGlobals', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('HwRenderGlobals', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('HwRenderGlobals', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('HyperGraphInfo', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('HyperGraphInfo', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('HyperGraphInfo', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('HyperGraphInfo', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('HyperGraphInfo', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('HyperGraphInfo', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('HyperGraphInfo', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('HyperLayout', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('HyperLayout', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('HyperLayout', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('HyperLayout', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('HyperLayout', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('HyperLayout', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('HyperLayout', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('HyperView', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('HyperView', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('HyperView', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('HyperView', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('HyperView', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('HyperView', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('HyperView', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('IkHandle', 'getName'): {'melEnabled': False},
  ('IkHandle', 'setName'): {'melEnabled': False},
  ('IkSystem', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('IkSystem', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('IkSystem', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('IkSystem', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('IkSystem', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('IkSystem', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('IkSystem', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('ImageSource', 'getImageName'): {'enabled': False},
  ('Instancer', 'getName'): {'melEnabled': False},
  ('Joint', 'getHikJointName'): {'enabled': False},
  ('Joint', 'getName'): {'melEnabled': False},
  ('Joint', 'getPosition'): {'melEnabled': False},
  ('Joint', 'getRelative'): {'melEnabled': False},
  ('Joint', 'getStiffness'): {'melName': 'getStiffness*'},
  ('Joint', 'setName'): {'melEnabled': False},
  ('Joint', 'setPosition'): {'melEnabled': False},
  ('Joint', 'setRelative'): {'melEnabled': False},
  ('Joint', 'setStiffness'): {'melName': 'setStiffness*'},
  ('JointFfd', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('JointFfd', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('JointFfd', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('JointFfd', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('JointFfd', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('JointFfd', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('JointFfd', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  # We disable split because a) it conflicts with the string "split" wrap, and
  # b) it's not very useful as a method - it can only be used in create mode
  # (not applicable) or edit if there is no geometry attached (how often do you
  # have no geo attached to a deformer?)
  ('Lattice', 'split'): {'melEnabled': False},
  ('LightInfo', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('LightInfo', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('LightInfo', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('LightInfo', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('LightInfo', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('LightInfo', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('LightInfo', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('LightLinker', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('LightLinker', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('LightLinker', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('LightLinker', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('LightLinker', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('LightLinker', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('LightLinker', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('LightList', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('LightList', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('LightList', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('LightList', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('LightList', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('LightList', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('LightList', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('LodGroup', 'getRotationQuaternion'): {'backwards_compatibility_enabled': 'Use getRotation(quaternion=True) instead.'},
  ('LodGroup', 'setRotationQuaternion'): {'backwards_compatibility_enabled': 'Use setRotation, and pass in a Quaternion object, instead.'},
  ('LodThresholds', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('LodThresholds', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('LodThresholds', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('LodThresholds', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('LodThresholds', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('LodThresholds', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('LodThresholds', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Luminance', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Luminance', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Luminance', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Luminance', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Luminance', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Luminance', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Luminance', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('MakeGroup', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('MakeGroup', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('MakeGroup', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('MakeGroup', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('MakeGroup', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('MakeGroup', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('MakeGroup', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('MapVizShape', 'enum'): {'enabled': False},
  ('MaterialInfo', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('MaterialInfo', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('MaterialInfo', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('MaterialInfo', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('MaterialInfo', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('MaterialInfo', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('MaterialInfo', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Matrix', '__getitem__'): {'enabled': False},
  ('Membrane', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Membrane', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Membrane', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Membrane', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Membrane', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Membrane', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Membrane', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('MentalrayCCMeshProxy', 'enum'): {'enabled': False},
  ('MentalrayIblShape', 'enum'): {'enabled': False},
  ('MentalrayTessellation', 'enum'): {'enabled': False},
  ('Mesh', '_getUVAtPoint'): {'origName': 'getUVAtPoint'},
  ('Mesh', '_getVertexColors'): {'origName': 'getVertexColors'},
  ('Mesh', '_numColorSets'): {'origName': 'numColorSets'},
  ('Mesh', '_numColors'): {'origName': 'numColors'},
  ('Mesh', '_numEdges'): {'origName': 'numEdges'},
  ('Mesh', '_numFaceVertices'): {'origName': 'numFaceVertices'},
  ('Mesh', '_numNormals'): {'origName': 'numNormals'},
  ('Mesh', '_numUVSets'): {'origName': 'numUVSets'},
  ('Mesh', '_numUVs'): {'origName': 'numUVs'},
  ('Mesh', '_numVertices'): {'origName': 'numVertices'},
  ('Mesh', 'addPolygon'): {'enabled': False},
  ('Mesh', 'allIntersections'): {'enabled': False},
  ('Mesh', 'anyIntersection'): {'enabled': False},
  ('Mesh', 'autoUniformGridParams'): {'enabled': False},
  ('Mesh', 'binaryBlindDataComponentId'): {'enabled': False},
  ('Mesh', 'booleanOp'): {'enabled': False},
  ('Mesh', 'cachedIntersectionAcceleratorInfo'): {'enabled': False},
  ('Mesh', 'clearBlindData'): {'enabled': False},
  ('Mesh', 'clearGlobalIntersectionAcceleratorInfo'): {'enabled': False},
  ('Mesh', 'closestIntersection'): {'enabled': False},
  ('Mesh', 'collapseEdges'): {'enabled': False},
  ('Mesh', 'collapseFaces'): {'enabled': False},
  ('Mesh', 'copy'): {'enabled': False},
  ('Mesh', 'copyInPlace'): {'enabled': False},
  ('Mesh', 'copyUVSet'): {'enabled': False},
  ('Mesh', 'copyUVSetWithName'): {'enabled': False},
  ('Mesh', 'createBlindDataType'): {'enabled': False},
  ('Mesh', 'createColorSetWithName'): {'aliases': ['createColorSet']},
  ('Mesh', 'createInPlace'): {'enabled': False},
  ('Mesh', 'createUVSetWithName'): {'aliases': ['createUVSet']},
  ('Mesh', 'deleteEdge'): {'enabled': False},
  ('Mesh', 'deleteFace'): {'enabled': False},
  ('Mesh', 'deleteVertex'): {'enabled': False},
  ('Mesh', 'duplicateFaces'): {'enabled': False},
  ('Mesh', 'extractFaces'): {'enabled': False},
  ('Mesh', 'extrudeEdges'): {'enabled': False},
  ('Mesh', 'extrudeFaces'): {'enabled': False},
  ('Mesh', 'freeCachedIntersectionAccelerator'): {'enabled': False},
  ('Mesh', 'generateSmoothMesh'): {'enabled': False},
  ('Mesh', 'getAssociatedColorSetInstances'): {'aliases': ['_getAssociatedColorSetInstances']},
  ('Mesh', 'getAssociatedUVSetInstances'): {'aliases': ['_getAssociatedUVSetInstances']},
  ('Mesh', 'getBinaryBlindData'): {'enabled': False},
  ('Mesh', 'getBlindDataAttrNames'): {'enabled': False},
  ('Mesh', 'getBlindDataFaceVertexIndices'): {'enabled': False},
  ('Mesh', 'getBlindDataTypes'): {'enabled': False},
  ('Mesh', 'getBoolBlindData'): {'enabled': False},
  ('Mesh', 'getColorIndex'): {'enabled': False},
  ('Mesh', 'getColorSetsInFamily'): {'enabled': False},
  ('Mesh', 'getConnectedSetsAndMembers'): {'enabled': False},
  ('Mesh', 'getConnectedShaders'): {'enabled': False},
  ('Mesh', 'getCreaseEdges'): {'enabled': False},
  ('Mesh', 'getCreaseVertices'): {'enabled': False},
  ('Mesh', 'getCurrentColorSetName'): {'enabled': False},
  ('Mesh', 'getCurrentUVSetName'): {'enabled': False},
  ('Mesh', 'getDoubleBlindData'): {'enabled': False},
  ('Mesh', 'getFaceVertexBlindDataIndex'): {'enabled': False},
  ('Mesh', 'getFloatBlindData'): {'enabled': False},
  ('Mesh', 'getIntBlindData'): {'enabled': False},
  ('Mesh', 'getInvisibleFaces'): {'enabled': False},
  ('Mesh', 'getPinUVs'): {'enabled': False},
  ('Mesh', 'getPoints'): {'overloadIndex': 1},
  ('Mesh', 'getRawDoublePoints'): {'enabled': False},
  ('Mesh', 'getRawNormals'): {'enabled': False},
  ('Mesh', 'getRawPoints'): {'enabled': False},
  ('Mesh', 'getSmoothMeshDisplayOptions'): {'enabled': False},
  ('Mesh', 'getStringBlindData'): {'enabled': False},
  ('Mesh', 'getUVAtPoint'): {'useName': '_getUVAtPoint'},
  ('Mesh', 'getVertexColors'): {'useName': '_getVertexColors'},
  ('Mesh', 'getVertexNormal'): {'overloadIndex': 1},
  ('Mesh', 'globalIntersectionAcceleratorsInfo'): {'enabled': False},
  ('Mesh', 'hasBlindData'): {'enabled': False},
  ('Mesh', 'hasBlindDataComponentId'): {'enabled': False},
  ('Mesh', 'isBlindDataTypeUsed'): {'enabled': False},
  ('Mesh', 'numColorSets'): {'useName': '_numColorSets'},
  ('Mesh', 'numColors'): {'overloadIndex': 1, 'useName': '_numColors'},
  ('Mesh', 'numEdges'): {'useName': '_numEdges'},
  ('Mesh', 'numFaceVertices'): {'useName': '_numFaceVertices'},
  ('Mesh', 'numNormals'): {'useName': '_numNormals'},
  ('Mesh', 'numPolygons'): {'aliases': ['_numPolygons']},
  ('Mesh', 'numUVSets'): {'useName': '_numUVSets'},
  ('Mesh', 'numUVs'): {'useName': '_numUVs'},
  ('Mesh', 'numVertices'): {'useName': '_numVertices'},
  ('Mesh', 'polygonVertexCount'): {'aliases': ['numPolygonVertices']},
  ('Mesh', 'setBinaryBlindData'): {'enabled': False},
  ('Mesh', 'setBoolBlindData'): {'enabled': False},
  ('Mesh', 'setCreaseEdges'): {'enabled': False},
  ('Mesh', 'setCreaseVertices'): {'enabled': False},
  ('Mesh', 'setDoubleBlindData'): {'enabled': False},
  ('Mesh', 'setFaceVertexColors'): {'enabled': False},
  ('Mesh', 'setFaceVertexNormals'): {'enabled': False},
  ('Mesh', 'setFloatBlindData'): {'enabled': False},
  ('Mesh', 'setIntBlindData'): {'enabled': False},
  ('Mesh', 'setInvisibleFaces'): {'enabled': False},
  ('Mesh', 'setPinUVs'): {'enabled': False},
  ('Mesh', 'setPoints'): {'overloadIndex': 1},
  ('Mesh', 'setSmoothMeshDisplayOptions'): {'enabled': False},
  ('Mesh', 'setStringBlindData'): {'enabled': False},
  ('Mesh', 'setVertexColors'): {'enabled': False},
  ('Mesh', 'setVertexNormals'): {'enabled': False},
  ('Mesh', 'sortIntersectionFaceTriIds'): {'enabled': False},
  ('Mesh', 'split'): {'enabled': False},
  ('Mesh', 'stringBlindDataComponentId'): {'enabled': False},
  ('Mesh', 'subdivideEdges'): {'enabled': False},
  ('Mesh', 'subdivideFaces'): {'enabled': False},
  ('Mesh', 'uniformGridParams'): {'enabled': False},
  ('MeshEdge', 'cleanupSmoothing'): {'enabled': False},
  ('MeshEdge', 'connectedToEdge'): {'useName': 'isConnectedToEdge'},
  ('MeshEdge', 'connectedToFace'): {'useName': 'isConnectedToFace'},
  ('MeshEdge', 'currentItem'): {'enabled': False},
  ('MeshEdge', 'edge'): {'enabled': False},
  ('MeshEdge', 'geomChanged'): {'enabled': False},
  ('MeshEdge', 'getConnectedEdges'): {'enabled': False},
  ('MeshEdge', 'getConnectedFaces'): {'enabled': False},
  ('MeshEdge', 'isConnectedToEdge'): {'origName': 'connectedToEdge'},
  ('MeshEdge', 'isConnectedToFace'): {'origName': 'connectedToFace'},
  ('MeshEdge', 'isDone'): {'enabled': False},
  ('MeshEdge', 'isOnBoundary'): {'origName': 'onBoundary'},
  ('MeshEdge', 'onBoundary'): {'useName': 'isOnBoundary'},
  ('MeshFace', 'currentItem'): {'enabled': False},
  ('MeshFace', 'getConnectedEdges'): {'enabled': False},
  ('MeshFace', 'getConnectedFaces'): {'enabled': False},
  ('MeshFace', 'getConnectedVertices'): {'enabled': False},
  ('MeshFace', 'getTriangle'): {'enabled': False},
  ('MeshFace', 'getTriangles'): {'enabled': False},
  ('MeshFace', 'isDone'): {'enabled': False},
  ('MeshFace', 'isOnBoundary'): {'origName': 'onBoundary'},
  ('MeshFace', 'isZeroArea'): {'origName': 'zeroArea'},
  ('MeshFace', 'isZeroUVArea'): {'origName': 'zeroUVArea'},
  ('MeshFace', 'next'): {'enabled': False},
  ('MeshFace', 'onBoundary'): {'useName': 'isOnBoundary'},
  ('MeshFace', 'polygon'): {'enabled': False},
  ('MeshFace', 'tangentIndex'): {'enabled': False},
  ('MeshFace', 'vertexIndex'): {'enabled': False},
  ('MeshFace', 'zeroArea'): {'useName': 'isZeroArea'},
  ('MeshFace', 'zeroUVArea'): {'useName': 'isZeroUVArea'},
  ('MeshVertex', '_getConnectedEdges'): {'origName': 'getConnectedEdges'},
  ('MeshVertex', '_getConnectedFaces'): {'origName': 'getConnectedFaces'},
  ('MeshVertex', '_getConnectedVertices'): {'origName': 'getConnectedVertices'},
  ('MeshVertex', 'connectedToEdge'): {'useName': 'isConnectedToEdge'},
  ('MeshVertex', 'connectedToFace'): {'useName': 'isConnectedToFace'},
  ('MeshVertex', 'currentItem'): {'enabled': False},
  ('MeshVertex', 'getConnectedEdges'): {'enabled': False,
                                        'useName': '_getConnectedEdges'},
  ('MeshVertex', 'getConnectedFaces'): {'enabled': False,
                                        'useName': '_getConnectedFaces'},
  ('MeshVertex', 'getConnectedVertices'): {'enabled': False,
                                           'useName': '_getConnectedVertices'},
  ('MeshVertex', 'getOppositeVertex'): {'enabled': False},
  ('MeshVertex', 'isConnectedToEdge'): {'origName': 'connectedToEdge'},
  ('MeshVertex', 'isConnectedToFace'): {'origName': 'connectedToFace'},
  ('MeshVertex', 'isDone'): {'enabled': False},
  ('MeshVertex', 'isOnBoundary'): {'origName': 'onBoundary'},
  ('MeshVertex', 'next'): {'enabled': False},
  ('MeshVertex', 'onBoundary'): {'useName': 'isOnBoundary'},
  ('MeshVertex', 'vertex'): {'enabled': False},
  ('MultDoubleLinear', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('MultDoubleLinear', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('MultDoubleLinear', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('MultDoubleLinear', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('MultDoubleLinear', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('MultDoubleLinear', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('MultDoubleLinear', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('MultMatrix', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('MultMatrix', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('MultMatrix', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('MultMatrix', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('MultMatrix', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('MultMatrix', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('MultMatrix', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('MultilisterLight', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('MultilisterLight', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('MultilisterLight', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('MultilisterLight', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('MultilisterLight', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('MultilisterLight', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('MultilisterLight', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Mute', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Mute', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Mute', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Mute', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Mute', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Mute', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Mute', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('NComponent', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('NComponent', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('NComponent', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('NComponent', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('NComponent', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('NComponent', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('NComponent', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Network', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Network', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Network', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Network', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Network', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Network', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Network', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Nucleus', 'getRotationQuaternion'): {'backwards_compatibility_enabled': 'Use getRotation(quaternion=True) instead.'},
  ('Nucleus', 'setRotationQuaternion'): {'backwards_compatibility_enabled': 'Use setRotation, and pass in a Quaternion object, instead.'},
  ('NurbsCurve', '_numCVsApi'): {'origName': 'numCVs'},
  ('NurbsCurve', 'cv'): {'enabled': False},
  ('NurbsCurve', 'numCVs'): {'useName': '_numCVsApi'},
  ('NurbsCurveCV', 'cv'): {'enabled': False},
  ('NurbsSurface', '_numCVsInUApi'): {'origName': 'numCVsInU'},
  ('NurbsSurface', '_numCVsInVApi'): {'origName': 'numCVsInV'},
  ('NurbsSurface', 'cv'): {'enabled': False},
  ('NurbsSurface', 'getParamAtPoint'): {'overloadIndex': 1},
  ('NurbsSurface', 'getTrimBoundaries'): {'enabled': False},
  ('NurbsSurface', 'getUV'): {'enabled': False},
  ('NurbsSurface', 'getUVs'): {'enabled': False},
  ('NurbsSurface', 'numCVsInU'): {'useName': '_numCVsInUApi'},
  ('NurbsSurface', 'numCVsInV'): {'useName': '_numCVsInVApi'},
  ('NurbsSurface', 'setUV'): {'enabled': False},
  ('NurbsSurface', 'setUVs'): {'enabled': False},
  ('NurbsSurface', 'trimWithBoundaries'): {'enabled': False},
  ('ObjectFilter', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('ObjectFilter', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('ObjectFilter', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('ObjectFilter', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('ObjectFilter', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('ObjectFilter', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('ObjectFilter', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('ObjectSet', '_getIntersection'): {'origName': 'getIntersection'},
  ('ObjectSet', '_getUnion'): {'origName': 'getUnion'},
  ('ObjectSet', 'asSelectionSet'): {'origName': 'getMembers'},
  ('ObjectSet', 'getIntersection'): {'useName': '_getIntersection'},
  ('ObjectSet', 'getMembers'): {'useName': 'asSelectionSet'},
  ('ObjectSet', 'getUnion'): {'useName': '_getUnion'},
  ('OldBlindDataBase', 'create'): {'overloadIndex': 2},
  ('OldBlindDataBase', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('OldBlindDataBase', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('OldBlindDataBase', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('OldBlindDataBase', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('OldBlindDataBase', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('OldBlindDataBase', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('OldBlindDataBase', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('OldGeometryConstraint', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('OldGeometryConstraint', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('OldGeometryConstraint', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('OldGeometryConstraint', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('OldGeometryConstraint', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('OldGeometryConstraint', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('OldGeometryConstraint', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('OpticalFX', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('OpticalFX', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('OpticalFX', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('OpticalFX', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('OpticalFX', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('OpticalFX', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('OpticalFX', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('PairBlend', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('PairBlend', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('PairBlend', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('PairBlend', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('PairBlend', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('PairBlend', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('PairBlend', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('ParticleAgeMapper', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('ParticleAgeMapper', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('ParticleAgeMapper', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('ParticleAgeMapper', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('ParticleAgeMapper', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('ParticleAgeMapper', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('ParticleAgeMapper', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('ParticleColorMapper', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('ParticleColorMapper', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('ParticleColorMapper', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('ParticleColorMapper', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('ParticleColorMapper', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('ParticleColorMapper', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('ParticleColorMapper', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('ParticleIncandMapper', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('ParticleIncandMapper', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('ParticleIncandMapper', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('ParticleIncandMapper', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('ParticleIncandMapper', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('ParticleIncandMapper', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('ParticleIncandMapper', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('ParticleTranspMapper', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('ParticleTranspMapper', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('ParticleTranspMapper', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('ParticleTranspMapper', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('ParticleTranspMapper', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('ParticleTranspMapper', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('ParticleTranspMapper', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('PassContributionMap', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('PassContributionMap', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('PassContributionMap', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('PassContributionMap', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('PassContributionMap', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('PassContributionMap', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('PassContributionMap', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('PassMatrix', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('PassMatrix', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('PassMatrix', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('PassMatrix', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('PassMatrix', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('PassMatrix', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('PassMatrix', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('PfxGeometry', 'getLineData'): {'enabled': False},
  ('Place3dTexture', 'getRotationQuaternion'): {'backwards_compatibility_enabled': 'Use getRotation(quaternion=True) instead.'},
  ('Place3dTexture', 'setRotationQuaternion'): {'backwards_compatibility_enabled': 'Use setRotation, and pass in a Quaternion object, instead.'},
  ('PointLight', 'getName'): {'melEnabled': False},
  ('PointLight', 'getPosition'): {'melEnabled': False},
  ('PointLight', 'getRotation'): {'melEnabled': False},
  ('PointLight', 'setName'): {'melEnabled': False},
  ('PointLight', 'setPosition'): {'melEnabled': False},
  ('PointLight', 'setRotation'): {'melEnabled': False},
  ('PointMatrixMult', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('PointMatrixMult', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('PointMatrixMult', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('PointMatrixMult', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('PointMatrixMult', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('PointMatrixMult', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('PointMatrixMult', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('PolyBase', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('PolyBase', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('PolyBase', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('PolyBase', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('PolyBase', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('PolyBase', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('PolyBase', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('PolyBlindData', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('PolyBlindData', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('PolyBlindData', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('PolyBlindData', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('PolyBlindData', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('PolyBlindData', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('PolyBlindData', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('PolyBlindData', 'typeId'): {'enabled': False,
                                'melEnabled': True,
                                'melName': 'setTypeId'},
  ('PolySeparate', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('PolySeparate', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('PolySeparate', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('PolySeparate', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('PolySeparate', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('PolySeparate', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('PolySeparate', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('PolyToSubdiv', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('PolyToSubdiv', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('PolyToSubdiv', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('PolyToSubdiv', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('PolyToSubdiv', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('PolyToSubdiv', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('PolyToSubdiv', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('PostProcessList', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('PostProcessList', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('PostProcessList', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('PostProcessList', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('PostProcessList', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('PostProcessList', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('PostProcessList', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('PrecompExport', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('PrecompExport', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('PrecompExport', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('PrecompExport', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('PrecompExport', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('PrecompExport', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('PrecompExport', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('ProxyManager', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('ProxyManager', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('ProxyManager', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('ProxyManager', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('ProxyManager', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('ProxyManager', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('ProxyManager', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Quaternion', 'MMatrix'): {'enabled': False},
  ('Quaternion', 'getAxisAngle'): {'enabled': False},
  ('Quaternion', 'setAxisAngle'): {'enabled': False},
  ('Quaternion', 'slerp'): {'enabled': False},
  ('Quaternion', 'squad'): {'enabled': False},
  ('Quaternion', 'squadPt'): {'enabled': False},
  ('RadialField', 'getRadialType'): {'origName': 'radialType'},
  ('RadialField', 'getType'): {'enabled': False},
  ('RadialField', 'radialType'): {'useName': 'getRadialType'},
  ('RadialField', 'setRadialType'): {'origName': 'setType'},
  ('RadialField', 'setType'): {'useName': 'setRadialType'},
  ('Record', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Record', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Record', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Record', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Record', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Record', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Record', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('RectangularLightLocator', 'enum'): {'enabled': False},
  ('Reference', 'isLocked'): {'useName': 'isReferenceLocked'},
  ('Reference', 'isReferenceLocked'): {'origName': 'isLocked'},
  ('RemapColor', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('RemapColor', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('RemapColor', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('RemapColor', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('RemapColor', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('RemapColor', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('RemapColor', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('RemapHsv', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('RemapHsv', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('RemapHsv', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('RemapHsv', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('RemapHsv', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('RemapHsv', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('RemapHsv', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('RemapValue', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('RemapValue', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('RemapValue', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('RemapValue', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('RemapValue', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('RemapValue', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('RemapValue', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('RenderGlobals', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('RenderGlobals', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('RenderGlobals', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('RenderGlobals', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('RenderGlobals', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('RenderGlobals', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('RenderGlobals', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('RenderGlobalsList', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('RenderGlobalsList', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('RenderGlobalsList', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('RenderGlobalsList', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('RenderGlobalsList', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('RenderGlobalsList', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('RenderGlobalsList', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('RenderLayerManager', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('RenderLayerManager', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('RenderLayerManager', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('RenderLayerManager', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('RenderLayerManager', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('RenderLayerManager', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('RenderLayerManager', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('RenderPass', 'frameBufferType'): {'enabled': False},
  ('RenderPass', 'getImplementation'): {'enabled': False},
  ('RenderPass', 'setImplementation'): {'enabled': False},
  ('RenderPassSet', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('RenderPassSet', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('RenderPassSet', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('RenderPassSet', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('RenderPassSet', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('RenderPassSet', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('RenderPassSet', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('RenderQuality', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('RenderQuality', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('RenderQuality', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('RenderQuality', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('RenderQuality', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('RenderQuality', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('RenderQuality', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Resolution', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Resolution', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Resolution', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Resolution', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Resolution', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Resolution', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Resolution', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Reverse', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Reverse', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Reverse', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Reverse', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Reverse', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Reverse', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Reverse', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('RgbToHsv', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('RgbToHsv', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('RgbToHsv', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('RgbToHsv', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('RgbToHsv', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('RgbToHsv', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('RgbToHsv', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('RigidConstraint', 'getRotationQuaternion'): {'backwards_compatibility_enabled': 'Use getRotation(quaternion=True) instead.'},
  ('RigidConstraint', 'setRotationQuaternion'): {'backwards_compatibility_enabled': 'Use setRotation, and pass in a Quaternion object, instead.'},
  ('RigidSolver', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('RigidSolver', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('RigidSolver', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('RigidSolver', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('RigidSolver', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('RigidSolver', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('RigidSolver', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Sampler', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Sampler', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Sampler', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Sampler', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Sampler', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Sampler', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Sampler', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Script', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Script', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Script', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Script', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Script', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Script', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Script', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('SelectionListOperator', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('SelectionListOperator', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('SelectionListOperator', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('SelectionListOperator', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('SelectionListOperator', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('SelectionListOperator', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('SelectionListOperator', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('SelectionSet', 'add'): {'enabled': False},
  ('SelectionSet', 'getDagPath'): {'enabled': False},
  ('SelectionSet', 'getDependNode'): {'enabled': False},
  ('SelectionSet', 'getPlug'): {'enabled': False},
  ('SelectionSet', 'hasItem'): {'enabled': False},
  ('SelectionSet', 'hasItemPartly'): {'enabled': False},
  ('SelectionSet', 'length'): {'enabled': False},
  ('SelectionSet', 'merge'): {'enabled': False},
  ('SelectionSet', 'remove'): {'useName': 'removeAtIndex'},
  ('SelectionSet', 'removeAtIndex'): {'origName': 'remove'},
  ('SelectionSet', 'replace'): {'enabled': False},
  ('SelectionSet', 'toggle'): {'enabled': False},
  ('SequenceManager', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('SequenceManager', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('SequenceManager', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('SequenceManager', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('SequenceManager', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('SequenceManager', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('SequenceManager', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Sequencer', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Sequencer', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Sequencer', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Sequencer', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Sequencer', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Sequencer', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Sequencer', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('SetRange', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('SetRange', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('SetRange', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('SetRange', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('SetRange', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('SetRange', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('SetRange', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('ShaderGlow', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('ShaderGlow', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('ShaderGlow', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('ShaderGlow', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('ShaderGlow', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('ShaderGlow', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('ShaderGlow', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('ShadingDependNode', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('ShadingDependNode', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('ShadingDependNode', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('ShadingDependNode', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('ShadingDependNode', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('ShadingDependNode', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('ShadingDependNode', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Shot', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Shot', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Shot', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Shot', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Shot', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Shot', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Shot', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('SimpleTestNode', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('SimpleTestNode', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('SimpleTestNode', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('SimpleTestNode', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('SimpleTestNode', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('SimpleTestNode', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('SimpleTestNode', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('SimpleVolumeShader', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('SimpleVolumeShader', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('SimpleVolumeShader', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('SimpleVolumeShader', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('SimpleVolumeShader', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('SimpleVolumeShader', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('SimpleVolumeShader', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('SkinBinding', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('SkinBinding', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('SkinBinding', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('SkinBinding', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('SkinBinding', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('SkinBinding', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('SkinBinding', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('SkinCluster', '_influenceObjects'): {'origName': 'influenceObjects'},
  ('SkinCluster', 'getWeights'): {'enabled': False},
  ('SkinCluster', 'influenceObjects'): {'useName': '_influenceObjects'},
  ('SkinCluster', 'setWeights'): {'enabled': False},
  ('Snapshot', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Snapshot', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Snapshot', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Snapshot', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Snapshot', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Snapshot', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Snapshot', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('SphericalLightLocator', 'enum'): {'enabled': False},
  ('SpotLight', 'getName'): {'melEnabled': False},
  ('SpotLight', 'getPenumbra'): {'origName': 'getPenumbraAngle'},
  ('SpotLight', 'getPenumbraAngle'): {'melName': 'getPenumbra',
                                      'useName': 'MEL'},
  ('SpotLight', 'getPosition'): {'melEnabled': False},
  ('SpotLight', 'getRotation'): {'melEnabled': False},
  ('SpotLight', 'setName'): {'melEnabled': False},
  ('SpotLight', 'setPenumbra'): {'origName': 'setPenumbraAngle'},
  ('SpotLight', 'setPenumbraAngle'): {'melName': 'setPenumbra',
                                      'useName': 'MEL'},
  ('SpotLight', 'setPosition'): {'melEnabled': False},
  ('StrokeGlobals', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('StrokeGlobals', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('StrokeGlobals', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('StrokeGlobals', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('StrokeGlobals', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('StrokeGlobals', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('StrokeGlobals', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('SubdBase', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('SubdBase', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('SubdBase', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('SubdBase', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('SubdBase', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('SubdBase', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('SubdBase', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Subdiv', 'creasesGetAll'): {'enabled': False},
  ('Subdiv', 'creasesSetAll'): {'enabled': False},
  ('Subdiv', 'edgeAdjacentPolygon'): {'enabled': False},
  ('Subdiv', 'edgeBetween'): {'enabled': False},
  ('Subdiv', 'edgeChildren'): {'enabled': False},
  ('Subdiv', 'edgeCount'): {'useName': 'numEdges'},
  ('Subdiv', 'edgeCreaseRelevant'): {'enabled': False},
  ('Subdiv', 'edgeIsBoundary'): {'enabled': False},
  ('Subdiv', 'edgeIsCreased'): {'enabled': False},
  ('Subdiv', 'edgeIsValid'): {'enabled': False},
  ('Subdiv', 'edgeSetCrease'): {'enabled': False},
  ('Subdiv', 'edgeVertices'): {'enabled': False},
  ('Subdiv', 'evaluateNormal'): {'enabled': False},
  ('Subdiv', 'evaluatePosition'): {'enabled': False},
  ('Subdiv', 'evaluatePositionAndNormal'): {'enabled': False},
  ('Subdiv', 'getConnectedShaders'): {'enabled': False},
  ('Subdiv', 'getCubicSpline'): {'enabled': False},
  ('Subdiv', 'numEdges'): {'origName': 'edgeCount'},
  ('Subdiv', 'numFaces'): {'origName': 'polygonCount'},
  ('Subdiv', 'numVertices'): {'origName': 'vertexCount'},
  ('Subdiv', 'polygonBaseMeshAdd'): {'enabled': False},
  ('Subdiv', 'polygonBaseMeshAddWithUVs'): {'enabled': False},
  ('Subdiv', 'polygonChildren'): {'enabled': False},
  ('Subdiv', 'polygonCount'): {'useName': 'numFaces'},
  ('Subdiv', 'polygonEdgeCount'): {'enabled': False},
  ('Subdiv', 'polygonEdges'): {'enabled': False},
  ('Subdiv', 'polygonGetCenterUV'): {'enabled': False},
  ('Subdiv', 'polygonGetVertexUVs'): {'enabled': False},
  ('Subdiv', 'polygonHasChildren'): {'enabled': False},
  ('Subdiv', 'polygonHasVertexUVs'): {'enabled': False},
  ('Subdiv', 'polygonIsValid'): {'enabled': False},
  ('Subdiv', 'polygonSetUseUVs'): {'enabled': False},
  ('Subdiv', 'polygonSetVertexUVs'): {'enabled': False},
  ('Subdiv', 'polygonSubdivide'): {'enabled': False},
  ('Subdiv', 'polygonVertexCount'): {'enabled': False},
  ('Subdiv', 'polygonVertices'): {'enabled': False},
  ('Subdiv', 'vertexAdjacentVertices'): {'enabled': False},
  ('Subdiv', 'vertexBaseIndexFromVertexId'): {'enabled': False},
  ('Subdiv', 'vertexBaseMeshGetWithId'): {'enabled': False},
  ('Subdiv', 'vertexBaseMeshSetWithId'): {'enabled': False},
  ('Subdiv', 'vertexChildren'): {'enabled': False},
  ('Subdiv', 'vertexCount'): {'useName': 'numVertices'},
  ('Subdiv', 'vertexCreaseRelevant'): {'enabled': False},
  ('Subdiv', 'vertexEditGet'): {'enabled': False},
  ('Subdiv', 'vertexEditSet'): {'enabled': False},
  ('Subdiv', 'vertexEditsGetAllNonBase'): {'enabled': False},
  ('Subdiv', 'vertexEditsSetAllNonBase'): {'enabled': False},
  ('Subdiv', 'vertexIdFromBaseVertexIndex'): {'enabled': False},
  ('Subdiv', 'vertexIncidentEdges'): {'enabled': False},
  ('Subdiv', 'vertexIncidentPolygons'): {'enabled': False},
  ('Subdiv', 'vertexIsBoundary'): {'enabled': False},
  ('Subdiv', 'vertexIsCreased'): {'enabled': False},
  ('Subdiv', 'vertexIsValid'): {'enabled': False},
  ('Subdiv', 'vertexNormal'): {'enabled': False},
  ('Subdiv', 'vertexPositionGet'): {'enabled': False},
  ('Subdiv', 'vertexPositionGetNoEdit'): {'enabled': False},
  ('Subdiv', 'vertexPositionSet'): {'enabled': False},
  ('Subdiv', 'vertexSetCrease'): {'enabled': False},
  ('Subdiv', 'vertexValence'): {'enabled': False},
  ('SubdivCollapse', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('SubdivCollapse', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('SubdivCollapse', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('SubdivCollapse', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('SubdivCollapse', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('SubdivCollapse', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('SubdivCollapse', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('SubdivComponentId', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('SubdivComponentId', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('SubdivComponentId', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('SubdivComponentId', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('SubdivComponentId', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('SubdivComponentId', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('SubdivComponentId', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('SubdivReverseFaces', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('SubdivReverseFaces', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('SubdivReverseFaces', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('SubdivReverseFaces', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('SubdivReverseFaces', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('SubdivReverseFaces', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('SubdivReverseFaces', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('SubdivToPoly', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('SubdivToPoly', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('SubdivToPoly', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('SubdivToPoly', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('SubdivToPoly', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('SubdivToPoly', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('SubdivToPoly', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('SurfaceLuminance', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('SurfaceLuminance', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('SurfaceLuminance', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('SurfaceLuminance', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('SurfaceLuminance', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('SurfaceLuminance', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('SurfaceLuminance', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('SurfaceShader', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('SurfaceShader', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('SurfaceShader', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('SurfaceShader', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('SurfaceShader', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('SurfaceShader', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('SurfaceShader', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('THdependNode', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('THdependNode', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('THdependNode', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('THdependNode', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('THdependNode', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('THdependNode', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('THdependNode', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('TexLattice', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('TexLattice', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('TexLattice', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('TexLattice', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('TexLattice', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('TexLattice', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('TexLattice', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('TextureToGeom', 'create'): {'overloadIndex': 2},
  ('TextureToGeom', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('TextureToGeom', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('TextureToGeom', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('TextureToGeom', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('TextureToGeom', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('TextureToGeom', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('TextureToGeom', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Time', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Time', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Time', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Time', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Time', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Time', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Time', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('TimeEditorAnimSource', 'attribute'): {'melEnabled': True,
                                          'melName': 'populateAttribute'},
  ('TimeEditorClip', 'addAttribute'): {'melEnabled': True,
                                       'melName': 'addClipAttribute'},
  ('TimeEditorClip', 'attribute'): {'melEnabled': True,
                                    'melName': 'populateAttribute'},
  ('TimeEditorClip', 'removeAttribute'): {'melEnabled': True,
                                          'melName': 'removeClipAttribute'},
  ('TimeFunction', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('TimeFunction', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('TimeFunction', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('TimeFunction', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('TimeFunction', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('TimeFunction', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('TimeFunction', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('TimeToUnitConversion', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('TimeToUnitConversion', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('TimeToUnitConversion', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('TimeToUnitConversion', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('TimeToUnitConversion', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('TimeToUnitConversion', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('TimeToUnitConversion', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('ToonLineAttributes', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('ToonLineAttributes', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('ToonLineAttributes', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('ToonLineAttributes', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('ToonLineAttributes', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('ToonLineAttributes', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('ToonLineAttributes', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('TransferAttributes', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('TransferAttributes', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('TransferAttributes', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('TransferAttributes', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('TransferAttributes', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('TransferAttributes', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('TransferAttributes', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Transform', '_getRotateOrientation'): {'origName': 'getRotateOrientation'},
  ('Transform', '_getRotatePivot'): {'origName': 'getRotatePivot'},
  ('Transform', '_getRotatePivotTranslation'): {'origName': 'getRotatePivotTranslation'},
  ('Transform', '_getRotation'): {'origName': 'getRotation'},
  ('Transform', '_getScalePivot'): {'origName': 'getScalePivot'},
  ('Transform', '_getScalePivotTranslation'): {'origName': 'getScalePivotTranslation'},
  ('Transform', '_getTranslation'): {'origName': 'getTranslation'},
  ('Transform', '_rotateBy'): {'origName': 'rotateBy'},
  ('Transform', '_rotateByQuaternion'): {'origName': 'rotateByQuaternion'},
  ('Transform', '_scaleBy'): {'origName': 'scaleBy'},
  ('Transform', '_setRotateOrientation'): {'origName': 'setRotateOrientation'},
  ('Transform', '_setRotatePivot'): {'origName': 'setRotatePivot'},
  ('Transform', '_setRotatePivotTranslation'): {'origName': 'setRotatePivotTranslation'},
  ('Transform', '_setRotation'): {'origName': 'setRotation'},
  ('Transform', '_setScale'): {'origName': 'setScale'},
  ('Transform', '_setScalePivot'): {'origName': 'setScalePivot'},
  ('Transform', '_setScalePivotTranslation'): {'origName': 'setScalePivotTranslation'},
  ('Transform', '_setShear'): {'origName': 'setShear'},
  ('Transform', '_setTranslation'): {'origName': 'setTranslation'},
  ('Transform', '_shearBy'): {'origName': 'shearBy'},
  ('Transform', '_translateBy'): {'origName': 'translateBy'},
  ('Transform', 'enableLimit'): {'aliases': ['setLimited']},
  ('Transform', 'getMatrix'): {'useName': 'getTransformation'},
  ('Transform', 'getRotateOrientation'): {'useName': '_getRotateOrientation'},
  ('Transform', 'getRotatePivot'): {'useName': '_getRotatePivot'},
  ('Transform', 'getRotatePivotTranslation'): {'melName': 'getRotateTranslation',
                                               'useName': '_getRotatePivotTranslation'},
  ('Transform', 'getRotateTranslation'): {'useName': '_getRotatePivotTranslation'},
  ('Transform', 'getRotation'): {'useName': '_getRotation'},
  ('Transform', 'getRotationOrder'): {'melName': 'getRotateOrder'},
  ('Transform', 'getRotationQuaternion'): {'enabled': False},
  ('Transform', 'getScalePivot'): {'useName': '_getScalePivot'},
  ('Transform', 'getScalePivotTranslation'): {'melName': 'getScaleTranslation',
                                              'useName': '_getScalePivotTranslation'},
  ('Transform', 'getScaleTranslation'): {'useName': '_getScalePivotTranslation'},
  ('Transform', 'getTranslation'): {'useName': '_getTranslation'},
  ('Transform', 'limitValue'): {'aliases': ['getLimit']},
  ('Transform', 'rotateBy'): {'overloadIndex': 1, 'useName': '_rotateBy'},
  ('Transform', 'rotateByQuaternion'): {'useName': '_rotateByQuaternion'},
  ('Transform', 'scaleBy'): {'useName': '_scaleBy'},
  ('Transform', 'set'): {'aliases': ['setTransformation'],
                         'melName': 'setMatrix'},
  ('Transform', 'setLimit'): {'melName': 'setLimit*'},
  ('Transform', 'setMatrix'): {'useName': 'setTransformation'},
  ('Transform', 'setRotateOrientation'): {'useName': '_setRotateOrientation'},
  ('Transform', 'setRotatePivot'): {'useName': '_setRotatePivot'},
  ('Transform', 'setRotatePivotTranslation'): {'melName': 'setRotateTranslation',
                                               'useName': '_setRotatePivotTranslation'},
  ('Transform', 'setRotateTranslation'): {'useName': '_setRotatePivotTranslation'},
  ('Transform', 'setRotation'): {'useName': '_setRotation'},
  ('Transform', 'setRotationOrder'): {'melName': 'setRotateOrder'},
  ('Transform', 'setRotationQuaternion'): {'enabled': False},
  ('Transform', 'setScale'): {'useName': '_setScale'},
  ('Transform', 'setScalePivot'): {'useName': '_setScalePivot'},
  ('Transform', 'setScalePivotTranslation'): {'melName': 'setScaleTranslation',
                                              'useName': '_setScalePivotTranslation'},
  ('Transform', 'setScaleTranslation'): {'useName': '_setScalePivotTranslation'},
  ('Transform', 'setShear'): {'useName': '_setShear'},
  ('Transform', 'setTranslation'): {'useName': '_setTranslation'},
  ('Transform', 'shearBy'): {'useName': '_shearBy'},
  ('Transform', 'transformation'): {'aliases': ['getTransformation'],
                                    'melName': 'getMatrix'},
  ('Transform', 'translateBy'): {'useName': '_translateBy'},
  ('TurbulenceField', 'getName'): {'melEnabled': False},
  ('TurbulenceField', 'getPosition'): {'melEnabled': False},
  ('TurbulenceField', 'setName'): {'melEnabled': False},
  ('TurbulenceField', 'setPosition'): {'melEnabled': False},
  ('UniformField', 'getDirection'): {'melName': 'getDirection*'},
  ('UniformField', 'getName'): {'melEnabled': False},
  ('UniformField', 'getPosition'): {'melEnabled': False},
  ('UniformField', 'setDirection'): {'melName': 'setDirection*'},
  ('UniformField', 'setName'): {'melEnabled': False},
  ('UniformField', 'setPosition'): {'melEnabled': False},
  ('UnitConversion', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('UnitConversion', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('UnitConversion', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('UnitConversion', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('UnitConversion', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('UnitConversion', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('UnitConversion', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('UnitToTimeConversion', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('UnitToTimeConversion', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('UnitToTimeConversion', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('UnitToTimeConversion', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('UnitToTimeConversion', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('UnitToTimeConversion', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('UnitToTimeConversion', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('Unknown', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('Unknown', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('Unknown', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('Unknown', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('Unknown', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('Unknown', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('Unknown', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('UnknownTransform', 'getRotationQuaternion'): {'backwards_compatibility_enabled': 'Use getRotation(quaternion=True) instead.'},
  ('UnknownTransform', 'setRotationQuaternion'): {'backwards_compatibility_enabled': 'Use setRotation, and pass in a Quaternion object, instead.'},
  ('UvChooser', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('UvChooser', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('UvChooser', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('UvChooser', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('UvChooser', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('UvChooser', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('UvChooser', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('ViewColorManager', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('ViewColorManager', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('ViewColorManager', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('ViewColorManager', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('ViewColorManager', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('ViewColorManager', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('ViewColorManager', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('VolumeAxisField', 'getDirection'): {'melName': 'getDirection*'},
  ('VolumeAxisField', 'getName'): {'melEnabled': False},
  ('VolumeAxisField', 'getPosition'): {'melEnabled': False},
  ('VolumeAxisField', 'getSpeedAlongAxis'): {'melName': 'getAlongAxis'},
  ('VolumeAxisField', 'getSpeedAroundAxis'): {'melName': 'getAroundAxis'},
  ('VolumeAxisField', 'getSpeedAwayFromAxis'): {'melName': 'getAwayFromAxis'},
  ('VolumeAxisField', 'getSpeedAwayFromCenter'): {'melName': 'getAwayFromCenter'},
  ('VolumeAxisField', 'getTurbulenceFrequency'): {'melName': 'getTurbulenceFrequency*'},
  ('VolumeAxisField', 'getTurbulenceOffset'): {'melName': 'getTurbulenceOffset*'},
  ('VolumeAxisField', 'setDirection'): {'melName': 'setDirection*'},
  ('VolumeAxisField', 'setName'): {'melEnabled': False},
  ('VolumeAxisField', 'setPosition'): {'melEnabled': False},
  ('VolumeAxisField', 'setSpeedAlongAxis'): {'melName': 'setAlongAxis'},
  ('VolumeAxisField', 'setSpeedAroundAxis'): {'melName': 'setAroundAxis'},
  ('VolumeAxisField', 'setSpeedAwayFromAxis'): {'melName': 'setAwayFromAxis'},
  ('VolumeAxisField', 'setSpeedAwayFromCenter'): {'melName': 'setAwayFromCenter'},
  ('VolumeAxisField', 'setTurbulenceFrequency'): {'melName': 'setTurbulenceFrequency*'},
  ('VolumeAxisField', 'setTurbulenceOffset'): {'melName': 'setTurbulenceOffset*'},
  ('VolumeLight', 'colorRamp'): {'enabled': False},
  ('VolumeLight', 'penumbraRamp'): {'enabled': False},
  ('VolumeShader', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('VolumeShader', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('VolumeShader', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('VolumeShader', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('VolumeShader', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('VolumeShader', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('VolumeShader', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'},
  ('VortexField', 'getAxis'): {'melName': 'getAxis*'},
  ('VortexField', 'getName'): {'melEnabled': False},
  ('VortexField', 'getPosition'): {'melEnabled': False},
  ('VortexField', 'setAxis'): {'melName': 'setAxis*'},
  ('VortexField', 'setName'): {'melEnabled': False},
  ('VortexField', 'setPosition'): {'melEnabled': False},
  ('Wire', 'getDropoffLocator'): {'enabled': False},
  ('Wire', 'getEnvelope'): {'override': True},
  ('Wire', 'setDropoffLocator'): {'enabled': False},
  ('Wire', 'setEnvelope'): {'override': True},
  ('WtAddMatrix', 'findAlias'): {'backwards_compatibility_enabled': True},
  ('WtAddMatrix', 'getAffectedAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affected instead.'},
  ('WtAddMatrix', 'getAffectedByAttributes'): {'backwards_compatibility_enabled': 'Use Attribute.affects instead.'},
  ('WtAddMatrix', 'getAliasList'): {'backwards_compatibility_enabled': 'Use listAliases instead.'},
  ('WtAddMatrix', 'getConnections'): {'backwards_compatibility_enabled': 'Use inputs/outputs, or general.listConnections instead.'},
  ('WtAddMatrix', 'plugsAlias'): {'backwards_compatibility_enabled': 'Use Attribute.getAlias instead.'},
  ('WtAddMatrix', 'setAlias'): {'backwards_compatibility_enabled': 'Use Attribute.setAlias instead.'}},
 {'MFnAirField': {'methods': {'setSpread': {0: {'argInfo': {u'value': {'unitType': u'angular'}}}},
                              'spread': {0: {'returnInfo': {'unitType': u'angular'}}}}},
  'MFnCamera': {'methods': {'centerOfInterest': {0: {'returnInfo': {'unitType': u'linear'}}},
                            'farClippingPlane': {0: {'returnInfo': {'unitType': u'linear'}}},
                            'farFocusDistance': {0: {'returnInfo': {'unitType': u'linear'}}},
                            'focusDistance': {0: {'returnInfo': {'unitType': u'linear'}}},
                            'getFilmFrustum': {0: {'argInfo': {u'distance': {'unitType': u'linear'}}},
                                               1: {'argInfo': {u'distance': {'unitType': u'linear'}}}},
                            'getPortFieldOfView': {0: {'argInfo': {u'horizontalFOV': {'unitType': u'angular'},
                                                                   u'verticalFOV': {'unitType': u'angular'}}}},
                            'horizontalFieldOfView': {0: {'returnInfo': {'unitType': u'angular'}}},
                            'horizontalRollPivot': {0: {'returnInfo': {'unitType': u'linear'}}},
                            'nearClippingPlane': {0: {'returnInfo': {'unitType': u'linear'}}},
                            'nearFocusDistance': {0: {'returnInfo': {'unitType': u'linear'}}},
                            'setCenterOfInterest': {0: {'argInfo': {u'dist': {'unitType': u'linear'}}}},
                            'setFarClippingPlane': {0: {'argInfo': {u'dFar': {'unitType': u'linear'}}}},
                            'setFarFocusDistance': {0: {'argInfo': {u'farFocusDistance': {'unitType': u'linear'}}}},
                            'setFocusDistance': {0: {'argInfo': {u'distance': {'unitType': u'linear'}}}},
                            'setHorizontalFieldOfView': {0: {'argInfo': {u'fov': {'unitType': u'angular'}}}},
                            'setHorizontalRollPivot': {0: {'argInfo': {u'horizontalRollPivot': {'unitType': u'linear'}}}},
                            'setIsOrtho': {1: {'argInfo': {u'useDist': {'unitType': u'linear'}}}},
                            'setNearClippingPlane': {0: {'argInfo': {u'dNear': {'unitType': u'linear'}}}},
                            'setNearFarClippingPlanes': {0: {'argInfo': {u'dFar': {'unitType': u'linear'},
                                                                         u'dNear': {'unitType': u'linear'}}}},
                            'setNearFocusDistance': {0: {'argInfo': {u'nearFocusDistance': {'unitType': u'linear'}}}},
                            'setShutterAngle': {0: {'argInfo': {u'shutterAngle': {'unitType': u'angular'}}}},
                            'setVerticalFieldOfView': {0: {'argInfo': {u'fov': {'unitType': u'angular'}}}},
                            'setVerticalRollPivot': {0: {'argInfo': {u'verticalRollPivot': {'unitType': u'linear'}}}},
                            'shutterAngle': {0: {'returnInfo': {'unitType': u'angular'}}},
                            'verticalFieldOfView': {0: {'returnInfo': {'unitType': u'angular'}}},
                            'verticalRollPivot': {0: {'returnInfo': {'unitType': u'linear'}}}}},
  'MFnDagNode': {'methods': {'instanceCount': {0: {'defaults': {'total': True}}}}},
  'MFnField': {'methods': {'maxDistance': {0: {'returnInfo': {'unitType': u'linear'}}},
                           'setMaxDistance': {0: {'argInfo': {u'dist': {'unitType': u'linear'}}}}}},
  'MFnIkJoint': {'methods': {'setScaleOrientation': {0: {'args': [(u'quaternion',
                                                                   'MQuaternion',
                                                                   u'in')],
                                                         'inArgs': [u'quaternion'],
                                                         'outArgs': []}}}},
  'MFnLight': {'methods': {'centerOfIllumination': {0: {'returnInfo': {'unitType': u'linear'}}},
                           'setCenterOfIllumination': {0: {'argInfo': {u'dist': {'unitType': u'linear'}}}}}},
  'MFnMesh': {'methods': {'createColorSetWithName': {1: {'defaults': {'modifier': None}}},
                          'getFaceVertexNormal': {0: {'inverse': None}},
                          'getFaceVertexNormals': {0: {'inverse': None}},
                          'setFaceVertexNormal': {0: {'inverse': None}},
                          'setFaceVertexNormals': {0: {'inverse': None}},
                          'setPoints': {0: {'args': [(u'vertexArray',
                                                      'MFloatPointArray',
                                                      u'in'),
                                                     (u'space',
                                                      ('MSpace',
                                                       'Space'),
                                                      'in')],
                                            'inArgs': [u'vertexArray',
                                                       u'space'],
                                            'outArgs': []},
                                        1: {'args': [(u'vertexArray',
                                                      'MPointArray',
                                                      u'in'),
                                                     (u'space',
                                                      ('MSpace',
                                                       'Space'),
                                                      'in')],
                                            'inArgs': [u'vertexArray',
                                                       u'space'],
                                            'outArgs': []}}}},
  'MFnNurbsCurve': {'methods': {'setKnots': {0: {'args': {2: ('endIndex',
                                                              'uint',
                                                              'in')},
                                                 'inArgs': ['array',
                                                            'startIndex',
                                                            'endIndex'],
                                                 'outArgs': []}}}},
  'MFnNurbsSurface': {'methods': {'setKnotInU': {0: {'args': [(u'index',
                                                               'int',
                                                               'in'),
                                                              (u'param',
                                                               'double',
                                                               u'in')],
                                                     'inArgs': [u'index',
                                                                u'param'],
                                                     'outArgs': []}}}},
  'MFnRadialField': {'invertibles': [('setType', 'radialType')],
                     'methods': {'radialType': {0: {'inverse': ('setType',
                                                                False)}},
                                 'setType': {0: {'inverse': ('radialType',
                                                             True)}},
                                 'type': {0: {'inverse': None}}}},
  'MFnRenderLayer': {'methods': {'externalRenderPasses': {0: {'args': [(u'renderPassArray',
                                                                        'MObjectArray',
                                                                        u'out')],
                                                              'inArgs': [],
                                                              'outArgs': [u'renderPassArray']}},
                                 'layerChildren': {0: {'args': [(u'array',
                                                                 'MObjectArray',
                                                                 u'out'),
                                                                (u'recurse',
                                                                 'bool',
                                                                 'in')],
                                                       'inArgs': [u'recurse'],
                                                       'outArgs': [u'array']}},
                                 'listAllRenderLayers': {0: {'args': [(u'array',
                                                                       'MObjectArray',
                                                                       u'out')],
                                                             'inArgs': [],
                                                             'outArgs': [u'array']}},
                                 'listMembers': {0: {'args': [(u'objectsInLayer',
                                                               'MObjectArray',
                                                               u'out')],
                                                     'inArgs': [],
                                                     'outArgs': [u'objectsInLayer']}}}},
  'MFnSet': {'methods': {'getMembers': {0: {'defaults': {'flatten': False}}}}},
  'MFnSkinCluster': {'methods': {'influenceObjects': {0: {'args': [(u'paths',
                                                                    'MDagPathArray',
                                                                    u'out')],
                                                          'inArgs': [],
                                                          'outArgs': [u'paths']}},
                                 'setBlendWeights': {0: {'args': [(u'path',
                                                                   'MDagPath',
                                                                   'in'),
                                                                  (u'components',
                                                                   'MObject',
                                                                   'in'),
                                                                  (u'weights',
                                                                   'MDoubleArray',
                                                                   u'in')],
                                                         'inArgs': [u'path',
                                                                    u'components',
                                                                    u'weights'],
                                                         'outArgs': []}}}},
  'MFnSpotLight': {'methods': {'barnDoorAngle': {0: {'returnInfo': {'unitType': u'angular'}}},
                               'coneAngle': {0: {'returnInfo': {'unitType': u'angular'}}},
                               'penumbraAngle': {0: {'returnInfo': {'unitType': u'angular'}}},
                               'setBarnDoorAngle': {0: {'argInfo': {u'barn_door_angle': {'unitType': u'angular'}}}},
                               'setConeAngle': {0: {'argInfo': {u'cone_angle': {'unitType': u'angular'}}}},
                               'setPenumbraAngle': {0: {'argInfo': {u'penumbra_angle': {'unitType': u'angular'}}}}}},
  'MFnTransform': {'invertibles': [('setRotatePivotTranslation',
                                    'rotatePivotTranslation'),
                                   ('setScalePivot', 'scalePivot'),
                                   ('setRotation', 'getRotation'),
                                   ('setTranslation', 'getTranslation'),
                                   ('setRotatePivot', 'rotatePivot'),
                                   ('setRestPosition', 'restPosition'),
                                   ('setScale', 'getScale'),
                                   ('setShear', 'getShear'),
                                   ('setRotateOrientation',
                                    'rotateOrientation'),
                                   ('setRotationOrder', 'rotationOrder'),
                                   ('setScalePivotTranslation',
                                    'scalePivotTranslation'),
                                   ('setRotationQuaternion',
                                    'getRotationQuaternion'),
                                   ('enableLimit', 'isLimited'),
                                   ('setLimit', 'limitValue'),
                                   ('set', 'transformation')],
                   'methods': {'enableLimit': {0: {'inverse': ('isLimited',
                                                               True)}},
                               'getRotation': {2: {'argInfo': {u'rotation': {'unitType': u'angular'}}}},
                               'getTranslation': {0: {'returnInfo': {'unitType': u'linear'}}},
                               'isLimited': {0: {'inverse': ('enableLimit',
                                                             False)}},
                               'limitValue': {0: {'inverse': ('setLimit',
                                                              False)}},
                               'rotatePivotTranslation': {0: {'returnInfo': {'unitType': u'linear'}}},
                               'scalePivotTranslation': {0: {'returnInfo': {'unitType': u'linear'}}},
                               'set': {0: {'inverse': ('transformation',
                                                       True)}},
                               'setLimit': {0: {'argInfo': {u'value': {'unitType': u'linear'}},
                                                'inverse': ('limitValue',
                                                            True)}},
                               'setRotateOrientation': {0: {'defaults': {'balance': True}}},
                               'setRotatePivot': {0: {'defaults': {'balance': True}}},
                               'setRotatePivotTranslation': {0: {'argInfo': {u'vector': {'unitType': u'linear'}}}},
                               'setRotation': {2: {'argInfo': {u'rotation': {'unitType': u'angular'}}}},
                               'setScalePivot': {0: {'defaults': {'balance': True}}},
                               'setScalePivotTranslation': {0: {'argInfo': {u'vector': {'unitType': u'linear'}}}},
                               'setTranslation': {0: {'argInfo': {u'vector': {'unitType': u'linear'}}}},
                               'transformation': {0: {'inverse': ('set',
                                                                  False)}},
                               'translateBy': {0: {'argInfo': {u'vector': {'unitType': u'linear'}}}}}},
  'MItMeshEdge': {'methods': {'getConnectedEdges': {0: {'args': [(u'edges',
                                                                  'MIntArray',
                                                                  u'out')],
                                                        'inArgs': [],
                                                        'outArgs': [u'edges']}},
                              'getConnectedFaces': {0: {'args': [(u'faces',
                                                                  'MIntArray',
                                                                  u'out')],
                                                        'inArgs': [],
                                                        'outArgs': [u'faces']}},
                              'getLength': {0: {'argInfo': {u'length': {'unitType': u'linear'}}}},
                              'numConnectedEdges': {0: {'args': [(u'edgeCount',
                                                                  'int',
                                                                  u'out')],
                                                        'inArgs': [],
                                                        'outArgs': [u'edgeCount']}}}},
  'MPlug': {'invertibles': [('setValue', 'getValue'),
                            ('setKeyable', 'isKeyable'),
                            ('setLocked', 'isLocked'),
                            ('setAttribute', 'attribute'),
                            ('setNumElements', 'numElements'),
                            ('setCaching', 'isCachingFlagSet'),
                            ('setChannelBox', 'isChannelBoxFlagSet')],
            'methods': {'destinations': {0: {'args': [('theDestinations',
                                                       'MPlugArray',
                                                       'out')],
                                             'inArgs': [],
                                             'outArgs': [u'theDestinations']}},
                        'destinationsWithConversions': {0: {'args': [('theDestinations',
                                                                      'MPlugArray',
                                                                      'out')],
                                                            'inArgs': [],
                                                            'outArgs': [u'theDestinations']}},
                        'getExistingArrayAttributeIndices': {0: {'args': [(u'indices',
                                                                           'MIntArray',
                                                                           u'out')],
                                                                 'inArgs': [],
                                                                 'outArgs': [u'indices']}},
                        'isCachingFlagSet': {0: {'inverse': ('setCaching',
                                                             False)}},
                        'isChannelBoxFlagSet': {0: {'inverse': ('setChannelBox',
                                                                False)}},
                        'setCaching': {0: {'inverse': ('isCachingFlagSet',
                                                       True)}},
                        'setChannelBox': {0: {'inverse': ('isChannelBoxFlagSet',
                                                          True)}}}},
  'MSpace': {'pymelEnums': {'Space': "Enum('Space', {'invalid': 0, 'transform': 1, 'preTransform': 2, 'object': 3, 'world': 4, 'last': 5})"}}})