﻿

import os

def load_file(filepath):
    file_handle = open(filepath,'r')
    data = file_handle.read()
    file_handle.close()
    return data

def replace_mark_with_data(mark, orig_data, mark_data):
    return orig_data.replace(mark, mark + '\n' + mark_data)

def eval_file_data(filedata):
    import pymel.core as pm
    pm.mel.eval(filedata)

def resolve_script_path(filepath):
    import pymel.versions as maya_versions
    if maya_versions.fullName() == "2013 x64":
        return os.path.normpath( os.path.join( os.path.dirname(__file__), 'maya2013' , filepath) )
    elif maya_versions.fullName() == "2018":
        return os.path.normpath( os.path.join( os.path.dirname(__file__), 'maya2018' , filepath) )
    elif maya_versions.fullName() == "2023":
        return os.path.normpath( os.path.join( os.path.dirname(__file__), 'maya2023' , filepath) )
    elif maya_versions.fullName() == "2024":
        return os.path.normpath( os.path.join( os.path.dirname(__file__), 'maya2024' , filepath) )

def add_to_script_path():
    import pymel.versions as maya_versions
    parts = os.environ.get('MAYA_SCRIPT_PATH', '').split(";")
    current_folder = os.path.dirname(__file__)
    if maya_versions.fullName() == "2013 x64":
        parts.insert(0, os.path.join(current_folder, "maya2013") )
    elif maya_versions.fullName() == "2018":
        parts.insert(0, os.path.join(current_folder, "maya2018") )
    elif maya_versions.fullName() == "2023":
        parts.insert(0, os.path.join(current_folder, "maya2023") )
    elif maya_versions.fullName() == "2024":
        parts.insert(0, os.path.join(current_folder, "maya2024") )
    os.environ['MAYA_SCRIPT_PATH'] = ';'.join(parts)

import inspect

def call_function_from_mel(scriptName, func):
    args = inspect.getargspec(func).args

    #convert args to mel var inputs
    args = ['$'+ arg for arg in args]

    mel_call = """
    int ${scriptName}_{funcName}_result = `python("import wizart.maya_ui_override;wizart.maya_ui_override.{scriptName}.{funcName}(" + {args} + ")") `;
    if ( ${scriptName}_{funcName}_result == 1 )
        return ;
    """
    mel_args = []
    for arg in args:
        mel_args.append('"\'" +{arg} + "\'"'.format(arg = arg) )
    mel_args_str = '+ "," +'.join(mel_args)
    return mel_call.format(scriptName = scriptName, funcName = func.__name__, args = mel_args_str)
