﻿from . import handlers
from . import utils

__script_path__ = 'dagMenuProc.mel'
__script_name__ = 'dagMenuProc'

def dagMenuProcCallback(parent, object):
    current_handlers = handlers._handlers.get( __script_name__ + '.dagMenuProcCallback', [] )
    for matchFunc, successFunc in current_handlers:
        if matchFunc(parent, object):
            successFunc(parent, object)
            return 1


__script_callback_marks_map__ = {
    
    '/* DAG_MENU_PROC_OVERRIDE_PLACE */' : dagMenuProcCallback
}

def init_script():
    utils.add_to_script_path()
