import pymel.core as pm
import wizart.anim_utils.network
import logging


def doIt():
    log = logging.getLogger(__name__)
    controls = pm.ls("*_options_control", recursive=True)

    controls = [control for control in controls if pm.attributeQuery('ikfk', node=control, exists=True)]
    for control in controls:
        attr = control.ikfk

        network = wizart.anim_utils.network.getNetwork(control)
        if not network:
            continue

        if attr.inputs():
            input_node = attr.inputs()[0]
            curves  = []
            layer = None

            # support for animLayers
            if 'animBlend' in input_node.type():
                layer = input_node.message.get()
                curveA =  input_node.inputA.inputs()
                if curveA:
                    curves.append(curveA[0])
                curveB =  input_node.inputB.inputs()
                if curveB:
                    curves.append(curveB[0])

            elif input_node.isTimeInput(): # else think its animCurve
                curves.append(input_node)

            all_curves = []
            for na in ["ik", "polevector", "fk", "fk1", "fk2", "f3"]:
                n = network.getAttr(na)
                if n:
                    all_curves += n.node().listAnimatable()

            all_curves += control.listAnimatable()

            for curve in curves:
                timelist = [pm.keyframe(curve, index=i, q=True, timeChange=True)[0] for i in range(curve.numKeys()) ]
                valuelist = [pm.keyframe(curve,index=i, q=True, valueChange=True)[0] for i in range(curve.numKeys()) ]

                for time in timelist:
                    firstTime = time
                    secondTime = time - 1.0
                    if secondTime in timelist:
                        firstIndex = timelist.index(firstTime)
                        secondIndex = timelist.index(secondTime)
                        firstValue = valuelist[firstIndex]
                        secondValue = valuelist[secondIndex]

                        if firstValue != secondValue:
                            pm.keyframe(all_curves, edit=True, r=True, o='over',tc=-.2, t=(firstTime, firstTime) )
                            pm.keyframe(all_curves, edit=True, r=True, o='over',tc=.2, t=(secondTime, secondTime) )

                            for ac in all_curves:
                                log.info("moved key at time {firstTime} to {newTime} for {attr}".format(firstTime=firstTime, newTime=firstTime-0.2, attr=ac.name()))
                                log.info("moved key at time {secondTime} to {newTime} for {attr}".format(secondTime=secondTime, newTime=secondTime+0.2, attr=ac.name()))

