import pymel.core as core
from .dynamicParent import *
import re

def bezierRig_switchToSelected(object, toFK, walkDown=False):
    def switchParent(control, parent):
        core.select(parent)
        addSelectedToDynamicParent(control)
        
        core.select(cl=True)
        dynamicParentSwitch(control, parent)

    controls = set(core.ls("*_control", r=True, sl=True, type="transform") + [core.PyNode(object)])

    for ctrl in controls:
        namespace = ctrl.namespace()

        if not walkDown:
            if toFK:
                name = ctrl.stripNamespace()
                pattern = re.sub("_\\d+_control$", "_%d_control", name)

                r = re.search("_(\\d+)_control$", name)
                if r:
                    n = int(r.groups(0)[0])
                    prevCtrl = namespace + pattern%(n-1)
                    if core.objExists(prevCtrl):
                        switchParent(ctrl, prevCtrl)

            else: # toIK
                dynamicParentSwitch(ctrl, "")

        else: # walkDown
            name = ctrl.stripNamespace()
            pattern = re.sub("_\\d+_control$", "_%d_control", name)

            r = re.search("_(\\d+)_control$", name)
            if r:
                n = int(r.groups(0)[0])
                while True:
                    nextCtrl = namespace + pattern%n
                    if not core.objExists(nextCtrl):
                        break

                    if toFK:
                        prevCtrl = namespace + pattern%(n-1)
                        if core.objExists(prevCtrl):
                            switchParent(nextCtrl, prevCtrl)
                    else: # toIK
                        dynamicParentSwitch(nextCtrl, "")

                    n += 1

    core.select(controls)
