from wizart import maya_ui_override
import wizart.anim_utils.network 
import wizart.anim_utils.dynamicParent
import wizart.anim_utils.menu

def dagMenuProc_match(parent, mayaObjName):
    network = wizart.anim_utils.network.getNetwork(mayaObjName)
    if (network and (network.getAttr("type") or network.getAttr("kinematic"))) or wizart.anim_utils.dynamicParent.hasDynamicParent(mayaObjName):
        return True

def dagMenuProc_callback(parent, mayaObjName):
    wizart.anim_utils.menu.createContextMenu(parent, mayaObjName, wizart.anim_utils.menu.AppType.Maya)

maya_ui_override.registerHandler('dagMenuProc.dagMenuProcCallback', dagMenuProc_match, dagMenuProc_callback)
