import pymel.core as pm
import logging

def doIt():
    log = logging.getLogger(__name__)
    controls = pm.ls("*control",recursive = True)

    controls = [control for control in controls if pm.attributeQuery('parent', node = control, exists = True)]
    for control in controls:
        attr = control.attr("parent")
        if attr.inputs():
            input_node = attr.inputs()[0]
            curves  = []
            layer = None
            #support for animLayers
            if 'animBlend' in input_node.type():
                layer = input_node.message.get()
                curveA =  input_node.inputA.inputs()
                if curveA:
                    curves.append(curveA[0])
                curveB =  input_node.inputB.inputs()
                if curveB:
                    curves.append(curveB[0])
            #else think its animCurve
            elif input_node.isTimeInput():
                curves.append(input_node)
            for curve in curves:
                timelist = [pm.keyframe(curve,index = i, q = True, timeChange = True)[0] for i in range(curve.numKeys()) ]
                valuelist = [pm.keyframe(curve,index = i, q = True, valueChange = True)[0] for i in range(curve.numKeys()) ]
                for time in timelist:
                    firstTime = time
                    secondTime = time - 1.0
                    if secondTime in timelist:
                        firstIndex = timelist.index(firstTime)
                        secondIndex = timelist.index(secondTime)
                        firstValue = valuelist[firstIndex]
                        secondValue = valuelist[secondIndex]
                        if firstValue != secondValue:
                            pm.keyframe(control.listAnimatable(), edit = True, r = True, o='over',tc=-.2, t= (firstTime,firstTime) )
                            layerInfo = ""			
                            layerInfo = "Layer:%s" % layer.name() if layer else "Layer:Base"
                            log.info( '{layer} moved key at time {time} from {ch_time} for node {node}'.format(time = firstTime, ch_time = firstTime -0.2, node = control, layer = layerInfo) )
                            pm.keyframe(control.listAnimatable(), edit = True, r = True, o='over',tc=.2, t= (secondTime,secondTime) )
                            log.info( '{layer} moved key at time {time} from {ch_time} for node {node}'.format(time = secondTime, ch_time = secondTime +0.2, node = control, layer = layerInfo) )