import pymel.core as pm

def bake_anim(ref_list):
    all_controls = []
    animated_attrs = set()
    for ref in ref_list:
        asset_namespace = ref_namespace = ref.refNode.namespace() + ref.namespace
        asset_controls = pm.ls(asset_namespace + ":*_control_dynParent_transform") + pm.ls(asset_namespace + ":*_control")
        for ctrl in asset_controls:
            for attr in ctrl.listAnimatable():
                animated_attrs.add(attr.name(includeNode=False))
        all_controls += asset_controls
    pm.select(all_controls, r = True)
    start_anim_time = pm.playbackOptions( q = True, animationStartTime = True )
    end_anim_time = pm.playbackOptions( q = True, animationEndTime = True )
    anim_layers = pm.ls(type="animLayer")
    if len(anim_layers) > 1:
        """
        Merge all anim layers in because fact we have several layers make code more complicated
        """
        pm.mel.eval('source "performAnimLayerMerge.mel"')
        pm.mel.animLayerMerge(anim_layers)
    pm.bakeResults(all_controls, t=(start_anim_time, end_anim_time), simulation=False,  hi = "none", at= animated_attrs, disableImplicitControl = True)

    """
    Force constant pre and post infinity
    """
    for ctrl in all_controls:
        curves = ctrl.listConnections(d=False, s=True, type="animCurve")
        for curve in curves:
            curve.setPreInfinityType("constant")
            curve.setPostInfinityType("constant")

def is_t_pose_possible(ref):
    asset_namespace = ref.refNode.namespace() + ref.namespace
    main_control = pm.ls(asset_namespace + ":main_control")
    m_spine_1_joint = pm.ls(asset_namespace + ":M_spine_1_joint")
    if main_control and m_spine_1_joint:
        main_control = main_control[0]
        main_control_shape = main_control.getShape()
        if main_control_shape:
            if pm.objExists(main_control_shape.name() + ".t_pose_blend"):
                attr_names = ["translateX", "translateY", "translateZ", "rotateX", "rotateY","rotateZ"]
                attr_names = ["t_pose_blend_M_spine_1_joint_" + name for name in attr_names]
                if all([pm.objExists(main_control_shape.name() + "." + name)  for name in attr_names]):
                    return True
    return False

def add_t_pose_blend(ref, start_time, end_time, t_pose_time_delta = -30, stable_pose_time_delta = -10):
    keep_current_time = pm.currentTime(query = True)
    asset_namespace = ref.refNode.namespace() + ref.namespace
    main_control = pm.ls(asset_namespace + ":main_control")
    m_spine_1_joint = pm.ls(asset_namespace + ":M_spine_1_joint")
    if main_control and m_spine_1_joint:
        main_control = main_control[0]
        m_spine_1_joint = m_spine_1_joint[0]
        main_control_shape = main_control.getShape()
        pm.currentTime(start_time, edit = True)
        prefix = "t_pose_blend_M_spine_1_joint"
        main_control_shape.attr("%s_translateX" % prefix).set(m_spine_1_joint.tx.get())
        main_control_shape.attr("%s_translateY" % prefix).set(m_spine_1_joint.ty.get())
        main_control_shape.attr("%s_translateZ" % prefix).set(m_spine_1_joint.tz.get())
        main_control_shape.attr("%s_rotateX" % prefix).set(m_spine_1_joint.tx.get())
        main_control_shape.attr("%s_rotateY" % prefix).set(m_spine_1_joint.ry.get())
        main_control_shape.attr("%s_rotateZ" % prefix).set(m_spine_1_joint.rz.get())
        pm.setKeyframe(main_control_shape,at="t_pose_blend", time=start_time, value=0, inTangentType="linear", outTangentType = "linear")
        pm.setKeyframe(main_control_shape, at="t_pose_blend", time=stable_pose_time_delta, value=0, inTangentType="linear", outTangentType = "linear")
        pm.setKeyframe(main_control_shape, at="t_pose_blend", time=t_pose_time_delta, value=1, inTangentType="linear", outTangentType = "linear")
    pm.currentTime(keep_current_time, edit = True)