import maya.OpenMayaUI as apiUI

import pymel.versions as maya_versions

import six

POINTER_TYPE = long if six.PY2 else int 

if maya_versions.current() >= maya_versions.v2017:
    from Qt import QtCore, QtCompat

    def getMayaWindow(class_name = QtCore.QObject):
        ptr = apiUI.MQtUtil.mainWindow()
        if ptr is not None:
            return QtCompat.wrapInstance(POINTER_TYPE(ptr), class_name )

    def toQtObject(mayaName, class_name = QtCore.QObject):
        ptr = apiUI.MQtUtil.findControl(mayaName)
        if ptr is None:
            ptr = apiUI.MQtUtil.findLayout(mayaName)
        if ptr is None:
            ptr = apiUI.MQtUtil.findMenuItem(mayaName)
        if ptr is not None:
            return QtCompat.wrapInstance(POINTER_TYPE(ptr), class_name )

    def toMayaObject(qtObject):
        return apiUI.MQtUtil.fullName(POINTER_TYPE(QtCompat.getCppPointer(qtObject)))
    """
    Specific function below is added for rare cases, where we intentionaly wanted mix different bindings
    and dont ported to Qt.py yet
    """
    def PyQt5_wrapInstance(ptr, base = None):
        import sip
        import PyQt5.QtCore
        import PyQt5.QtWidgets
        if ptr is None:
            return None
        if base is None:
            q_object = sip.wrapinstance(long(ptr), PyQt5.QtCore.QObject)
            meta_object = q_object.metaObject()
            class_name = meta_object.className()
            super_class_name = meta_object.superClass().className()
            if hasattr(PyQt5.QtWidgets, class_name):
                base = getattr(PyQt5.QtWidgets, class_name)
            elif hasattr(PyQt5.QtWidgets, super_class_name):
                base = getattr(PyQt5.QtWidgets, super_class_name)
            else:
                base = PyQt5.QtCore.QObject 
        return sip.wrapinstance(POINTER_TYPE(ptr), base)

    def PySide2_wrapInstance(ptr, base = None):
        import shiboken2
        import PySide2.QtCore
        import PySide2.QtWidgets
        if ptr is None:
            return None
        ptr = POINTER_TYPE(ptr) #Ensure type
        if base is None:
            q_object = shiboken2.wrapInstance(POINTER_TYPE(ptr), PySide2.QtCore.QObject)
            meta_object = q_object.metaObject()
            class_name = meta_object.className()
            super_class_name = meta_object.superClass().className()
            if hasattr(PySide2.QtWidgets, class_name):
                base = getattr(PySide2.QtWidgets, class_name)
            elif hasattr(PySide2.QtWidgets, super_class_name):
                base = getattr(PySide2.QtWidgets, super_class_name)
            else:
                base = PySide2.QtCore.QObject 
        return shiboken2.wrapInstance(POINTER_TYPE(ptr), base)

    def PyQt5_getCppPointer(obj):
        import sip
        return sip.unwrapinstance(obj)

    def PySide2_getCppPointer(obj):
        import shiboken2
        return shiboken2.getCppPointer(obj)

    def PyQt5_getMayaWindow(class_name = None):
        import sip
        import PyQt5.QtWidgets
        ptr = apiUI.MQtUtil.mainWindow()
        if ptr is not None:
            return PyQt5_wrapInstance(POINTER_TYPE(ptr), class_name)

    def PyQt5_toQtObject(mayaName, class_name = None):
        import sip
        import PyQt5.QtCore
        ptr = apiUI.MQtUtil.findControl(mayaName)
        if ptr is None:
            ptr = apiUI.MQtUtil.findLayout(mayaName)
        if ptr is None:
            ptr = apiUI.MQtUtil.findMenuItem(mayaName)
        if ptr is not None:
            return PyQt5_wrapInstance(POINTER_TYPE(ptr), class_name)


    def PyQt5_toMayaObject(qtObject):
        import sip
        return apiUI.MQtUtil.fullName(POINTER_TYPE(PyQt5_getCppPointer(qtObject)))


    def PySide2_getMayaWindow(class_name = None):
        import sip
        import PySide2.QtWidgets
        ptr = apiUI.MQtUtil.mainWindow()
        if ptr is not None:
            return PySide2_wrapInstance(POINTER_TYPE(ptr), class_name)

    def PySide2_toQtObject(mayaName, class_name = None):
        import sip
        import PyQt5.QtCore
        ptr = apiUI.MQtUtil.findControl(mayaName)
        if ptr is None:
            ptr = apiUI.MQtUtil.findLayout(mayaName)
        if ptr is None:
            ptr = apiUI.MQtUtil.findMenuItem(mayaName)
        if ptr is not None:
            return PySide2_wrapInstance(POINTER_TYPE(ptr), class_name)

    def PySide2_toMayaObject(qtObject):
        import sip
        return apiUI.MQtUtil.fullName(POINTER_TYPE(PySide2_getCppPointer(qtObject)))
else:
    import sip
    from PyQt4 import QtCore

    def getMayaWindow():
        ptr = apiUI.MQtUtil.mainWindow()
        if ptr is not None:
            return sip.wrapinstance(POINTER_TYPE(ptr), QtCore.QObject)

    def toQtObject(mayaName):
        ptr = apiUI.MQtUtil.findControl(mayaName)
        if ptr is None:
            ptr = apiUI.MQtUtil.findLayout(mayaName)
        if ptr is None:
            ptr = apiUI.MQtUtil.findMenuItem(mayaName)
        if ptr is not None:
            return sip.wrapinstance(POINTER_TYPE(ptr), QtCore.QObject)

    def toMayaObject(qtObject):
        return apiUI.MQtUtil.fullName(POINTER_TYPE(sip.unwrapinstance(qtObject)))
