import logging
log = logging.getLogger("studio")

import maya.cmds
import maya.OpenMaya

def __load_maya_menu_plugin():
    try:    
        maya.cmds.loadPlugin("wizart_maya_menu_plugin")
        log.info("loaded maya plugin for wizart_maya_menu_plugin")
    except Exception as e:
        log.exception("failed to load maya plugin for wizart_maya_menu_plugin")

if maya.OpenMaya.MGlobal.mayaState() == maya.OpenMaya.MGlobal.kInteractive:
    from functools import partial
    maya.cmds.evalDeferred(partial(__load_maya_menu_plugin))
    log.info("register deferred load for maya plugin for wizart_maya_menu_plugin")