﻿import maya.mel as mel
import maya.cmds as cmds
import pymel.core as pm
import pymel.versions as maya_versions
import os, sys
import six

if maya_versions.current() >= maya_versions.v2017:
    from Qt import QtGui, QtCore, QtWidgets
else:
    from PyQt4 import QtGui, QtCore

import wizart.maya_qtutils as qtutils
import xml.etree.ElementTree as etree

current_module_path = os.path.dirname(__file__)

wizart_path = os.environ.get('WIZART_SOFTWARE_PATH', "W:/software/maya2018")

wizart_maya_ui_path = current_module_path

IS_FREELANCE = os.environ.get("WIZART_FREELANCE", 0 ) > 0

icon_path_cache = {}

def get_icon(path):
    if icon_path_cache.has_key(path):
        #if found cached_icon return it
        return icon_path_cache[path]
    else:
        #else cached it and return it
        icon_path_cache[path] = QtGui.QIcon(path)
        return icon_path_cache[path]

def _set_window_icon(window, icon_path):
    if window is not None:
        if maya_versions.current() >= maya_versions.v2017:
            if isinstance(window, QtWidgets.QWidget):
                #todo better check if it is qt pointer
                window.setWindowIcon(get_icon(icon_path))
            else:
                #assume it is maya mel widget path
                qtPtr = qtutils.toQtObject(window, QtWidgets.QWidget)
                qtPtr.setWindowIcon(get_icon(icon_path))
        elif maya_versions.current() >= maya_versions.v2013:
            if isinstance(window, QtGui.QWidget):
                #todo better check if it is qt pointer
                window.setWindowIcon(get_icon(icon_path))
            else:
                #assume it is maya mel widget path
                qtPtr = qtutils.toQtObject(window)
                qtPtr.setWindowIcon(get_icon(icon_path))
from functools import partial

def generate_menu_name_from_label(name):
    return "wizart_menu_" + name.replace(" ", "_").lower()

def makeMenu(element,parent = None):
    for child in element:
        if child.tag == 'menu':
            label = child.get("label")
            #menu = parent.addMenu(child.get('label'))
            menu = pm.menuItem(generate_menu_name_from_label(label), label = child.get("label"), subMenu = True, tearOff = True)
            if 'icon_path' in child.attrib:
                icon_path = child.get('icon_path')
                pm.menuItem(menu, edit = True, image = icon_path)
                if maya_versions.current() < maya_versions.v2017:

                    if icon_path.startswith(':'):
                         qtutils.toQtObject(menu).setIcon(QtGui.QIcon(icon_path) )
                    else:
                        icon_path = os.path.join(wizart_maya_ui_path, icon_path)
                        qtutils.toQtObject(menu).setIcon( get_icon(icon_path))
            if 'label_update_callback' in child.attrib:
                def eval_label(menu, code):
                    splitted = code.split(";")
                    exec_block = splitted[:-1] if len(splitted) > 1 else None
                    eval_block = splitted[-1] if len(splitted) > 1 else splitted[0]
                    try:
                        if exec_block:
                            six.exec_(";".join(exec_block))
                            value = eval(eval_block)
                        else:
                            value = eval(eval_block)
                    except:
                        import sys,traceback
                        exc_type, exc_value, exc_traceback = sys.exc_info()
                        cmds.error("label_update_callback error %s %s" % (exc_type,exc_value) )
                    if value:
                        if maya_versions.current() >= maya_versions.v2017:
                            qtutils.toQtObject(menu, QtWidgets.QMenu).setTitle(value)
                        else:
                            qtutils.toQtObject(menu).setTitle(value)
                callback_fn = partial(eval_label, menu, child.get('label_update_callback'))
                if maya_versions.current() >= maya_versions.v2018:
                    qtutils.toQtObject(parent, QtWidgets.QWidget).aboutToShow.connect(callback_fn)
                elif maya_versions.current() <= maya_versions.v2015:
                    qtutils.toQtObject(parent).aboutToShow.connect(callback_fn)
            makeMenu(child, menu)
            pm.setParent(menu.parent(), menu=True)
        elif child.tag == 'item':
            label = child.get("label")
            menu = pm.menuItem(generate_menu_name_from_label(label), label = label)
            icon_path = None
            if 'icon_path' in child.attrib:
                icon_path = child.get('icon_path')
                pm.menuItem(menu, edit = True, image = icon_path)
                if maya_versions.current() < maya_versions.v2017:
                    if icon_path.startswith(':'):
                         qtutils.toQtObject(menu).setIcon(QtGui.QIcon(icon_path) )
                    else:
                        icon_path = os.path.join(wizart_maya_ui_path, icon_path)
                        qtutils.toQtObject(menu).setIcon( get_icon(icon_path))
            if 'start_script' in child.attrib:
                def runCode(code,icon_path = None):
                    def set_icon(window):
                        if icon_path:
                            _set_window_icon(window,icon_path)
                    six.exec_(code)
                if 'start_module_path' in child.attrib:
                    import imp
                    def runFile(path,code, icon_path = None):
                        def set_icon(window):
                            if icon_path:
                                _set_window_icon(window,icon_path)

                        #add and remove later  to python module search path current module path => this way we can find relative packages
                        MODULE_PATH = os.path.dirname(path)
                        sys.path.append(MODULE_PATH)

                        #MODULE variable used in xml script to call init routines
                        MODULE = imp.load_source('module',path)
                        six.exec_(code)


                        if MODULE_PATH in sys.path:
                            sys.path.remove(MODULE_PATH)

                    module_path = os.path.join(wizart_path,child.get('start_module_path'))
                    pm.menuItem(menu, edit = True, command = pm.Callback(runFile, module_path,child.get('start_script'), icon_path) )
                else:
                    pm.menuItem(menu, edit = True, command = pm.Callback(runCode, child.get('start_script'), icon_path) )
            elif 'url' in child.attrib:
                def _open_url(url):
                    QtGui.QDesktopServices.openUrl(QtCore.QUrl(url))
                pm.menuItem(menu, edit = True, command = pm.Callback(_open_url, child.get('url')) )
        elif child.tag == 'separator':
            pm.menuItem(divider = True)


def init_items(parent_name):
    xml_path = os.path.join(wizart_maya_ui_path,'freelance.xml' if IS_FREELANCE else "menu.xml")
    tree = etree.parse(xml_path)
    root = tree.getroot()
    makeMenu(root, parent_name)
