# Explanation:
# Since Python 3.8 python deprecated dll resolution via PATH env variable.
# The new recommended way is using os.add_dll_directory()
import sys

if sys.platform == "win32" and sys.version_info[0] >= 3 and sys.version_info[1] >= 8:
    import os
    for path in os.getenv("PATH").split(";"):
        if os.path.exists(path):
            os.add_dll_directory(path)