import wizart.fs_ctrl.fs_schema as fs_schema


def get_schema(project_name, project_path, vcs_config=None):
    project_schema = fs_schema.ProjectFileSchema(project_name, project_path)
    if vcs_config:
        project_schema.set_vcs_config_path(vcs_config)
    project_schema.check_is_valid()
    return project_schema


def process_command(debug=False, **kwargs):
    project_schema = get_schema(kwargs.get('project_name'), kwargs.get('project_path'), kwargs.get('vcs_config'))
    process_command_for_schema(project_schema, debug=debug, **kwargs)


def process_command_for_schema(project_schema, debug=False, **kwargs):
    commands = project_schema.load_fs_ctrl_config().get('commands')

    for command in commands:
        if command['name'] == kwargs.get('command_name'):
            fs_args = dict()
            if "cmd_path_fs_args" in command:
                for fs_arg in command['cmd_path_fs_args']:
                    if fs_arg['name'] in kwargs:
                        fs_args[fs_arg['fs_arg']] = kwargs[fs_arg['name']]
                        
            cmd_path = command['cmd_path']

            if 'cmd_path_pre_format_args' in command:
                preformat_args = dict(
                    [(key, kwargs[key]) for key in command['cmd_path_pre_format_args'] if key in kwargs])
                if isinstance(cmd_path, list):
                    cmd_path = list(
                        map(lambda path: path.format(**preformat_args), cmd_path))
                else:
                    cmd_path = cmd_path.format(**preformat_args)

            def run_cmd(path):
                if command['action'] == "create_templated_folder":
                    project_schema.create_templated_folder(
                        path, debug=debug, **fs_args)
                elif command["action"] == "symlink_templated_folder":
                    project_schema.symlink_templated_folder(path, src_root=kwargs.get(
                        'src_root'), dst_root=kwargs.get('dst_root'), **fs_args)

            if isinstance(cmd_path, list):
                for path in cmd_path:
                    run_cmd(path)
            else:
                run_cmd(cmd_path)
