import os

import mock
import pytest

from wizart.fs_ctrl.tests.data.schema_dump import rl_schema, sup_schema

RL_PROJECT_PATH = os.getenv("RL_PROJECT_PATH", "")
SUP_PROJECT_PATH = os.getenv("SUP_PROJECT_PATH", "")
VCS_CONFIG_PATH = os.getenv("VCS_CONFIG_PATH", "")


@pytest.fixture
def rl_project_name():
    return 'rl'

@pytest.fixture
def rl_project_path():
    return RL_PROJECT_PATH

@pytest.fixture
def sup_project_name():
    return 'sup'

@pytest.fixture
def sup_project_path():
    return SUP_PROJECT_PATH

@pytest.fixture
def project_params(rl_project_name, rl_project_path, sup_project_name, sup_project_path):
    return [{"name": rl_project_name,
             "path": rl_project_path,
             "schema": rl_schema},
            {"name": sup_project_name, 
             "path": sup_project_path,
             "schema": sup_schema}]

@pytest.fixture
def vcs_config_path():
    return VCS_CONFIG_PATH




@pytest.fixture(autouse=True)
def mock_fs_schema():
    import wizart.fs_ctrl.assetvcs
    import wizart.fs_ctrl.fs_schema
    with mock.patch("wizart.fs_ctrl.assetvcs.AssetVcsAPI.create_asset", return_value={"_id": "123"}), \
            mock.patch("wizart.fs_ctrl.assetvcs.AssetVcsAPI.get_asset_versions", return_value=None), \
            mock.patch("wizart.fs_ctrl.assetvcs.AssetVcsAPI.create_version", return_value={"version": 1}), \
            mock.patch("wizart.fs_ctrl.assetvcs.AssetVcsAPI.publish_version", return_value=None), \
            mock.patch("wizart.fs_ctrl.assetvcs.AssetVcsAPI.upload_version_files", return_value=None), \
            mock.patch("wizart.fs_ctrl.fs_schema._chgrp", return_value=None):
        yield
