from StringIO import StringIO
import logging
from celery.utils.log import get_task_logger
from wizart.fs_ctrl.fs_start_service import celery, app
from wizart.fs_ctrl.utils import process_command_for_schema, get_schema

logger = get_task_logger('fs_ctrl')

def is_celery_working():
    result = celery.control.broadcast('ping', reply=True, limit=1)
    return bool(result)


@celery.task
def run_task(project_name, project_path, args):
    log_string = StringIO()
    string_handler = logging.StreamHandler(log_string)
    logger.addHandler(string_handler)

    project_schema = get_schema(
        project_name, project_path, vcs_config=args.get("vcs_config"))
    process_command_for_schema(project_schema, debug=app.debug, **args)
    task_result = {
        "log": log_string.getvalue()
    }
    logger.handlers.pop()
    return task_result
