import os

import pytest

import wizart.fs_ctrl.fs_schema


class TestFsSchema(object):   
    def test_project_file_schema(self, project_params, vcs_config_path):
        for params in project_params:
            project_name = params.get('name')
            project_path = params.get('path')
            project_dump_schema = params.get('schema')

            schema = wizart.fs_ctrl.fs_schema.ProjectFileSchema(project_name, project_path)
            assert schema.proj_name == project_name
            assert schema._vcs_admin_cfg_path == None
            assert schema._components == {}
            assert schema.root_node is not None
            schema.load_components()
            components = schema.get_components()
            assert components == project_dump_schema
            
            component = components.get('anim_prep')
            assert component == project_dump_schema.get('anim_prep')
            publish_path = component.get('publish_path')
            schema.check_is_valid()
            
            schema.set_vcs_config_path(vcs_config_path)
            
            assert schema.root_node is not None
            assert len(schema.root_node.children) > 0
            
            node = schema.root_node.children[0]
            schema.create_templated_folder(node.get_fullpath())
            folder_path = os.path.join(project_path, node.name)
            assert os.path.exists(folder_path)
            
            found_node = schema.find_node_by_path(folder_path)
            assert found_node.get_fullpath() == node.get_fullpath()
            
            asset_node = schema.root_node.find('$root/assets/char/$asset')
            kwargs = {'root': project_path, 'asset': 'human'}
            schema.create_templated_folder(asset_node.get_fullpath(), **kwargs)
            for child_node in asset_node.children:
                folder_path = schema._resolve_node_path(child_node.get_fullpath(), kwargs)
                assert os.path.exists(folder_path)
                
            component_name = 'char.charfx.cloth'
            cloth_component = components.get(component_name)
            cloth_node = schema.root_node.find(cloth_component.get('publish_path'))
            kwargs = {'root': project_path, 'asset': 'human', 'variant': 'v_001'}
            schema.create_templated_folder(cloth_node.get_fullpath(), **kwargs)
            
            wref_path = schema.get_wref_path_to_file(component_name, **kwargs)
            assert wref_path == (os.path.join(project_path, 'assets/char/human/charfx/cloth/v_001/pub?path=human.charfx.cloth.v_001.mb'), 
                                 'human.charfx.cloth.v_001.mb')
            
            found_node = schema.find_node_by_wref(wref_path[0])
            assert cloth_node.get_fullpath() == found_node.get_fullpath()
            
            dst_path = project_path+'_symlink'
            if not os.path.exists(dst_path):
                os.mkdir(dst_path)
            schema.symlink_templated_folder(node.get_fullpath(), project_path, dst_path)
            assert os.path.exists(os.path.join(dst_path, node.name))
            assert os.path.islink(os.path.join(dst_path, node.name))
            
           
    # def test_decode_encode_schema(self, rl_project_name, rl_project_path):
    #     schema = wizart.fs_ctrl.fs_schema.ProjectFileSchema(rl_project_name, rl_project_path)
    #     schema_json =schema.to_json()
    #     schema2 = wizart.fs_ctrl.fs_schema.ProjectFileSchema()
    #     schema2.from_json(schema_json)
    #     schema2.project_path = schema.project_path
    #     schema2._proj_name = schema._proj_name
    #     schema2._vcs_admin_cfg_path = schema._vcs_admin_cfg_path
    #     schema2.root_node = wizart.fs_ctrl.fs_schema.Folder(schema2)
    #     schema2._components = {}
    #     assert schema_json == schema2.to_json()