import os
import sys
import pytest
import mock
from wizart.fs_ctrl import cmd

PATHS_DATA_FOLDER = os.path.join(os.path.dirname(
    os.path.abspath(__file__)), "paths_data")


def paths_from_file(path_to_file):
    with open(path_to_file) as char_structure:
        return list(map(lambda l: l.rstrip(), char_structure.readlines()))


def structure_paths_on_asset_type(asset_type):
    if asset_type == "char":
        return paths_from_file(os.path.join(PATHS_DATA_FOLDER, "asset_char.txt"))
    if asset_type == "item":
        return paths_from_file(os.path.join(PATHS_DATA_FOLDER, "asset_item.txt"))
    return []


def variant_paths_on_type(variant_type):
    if variant_type == "cloth":
        return paths_from_file(os.path.join(PATHS_DATA_FOLDER, "asset_cloth_variant.txt"))
    if variant_type == "hair":
        return paths_from_file(os.path.join(PATHS_DATA_FOLDER, "asset_hair_variant.txt"))
    return []


class TestFsCmdCreateAsset(object):

    @pytest.mark.parametrize("asset_type", ["char", "item"])
    def test_create_asset(self, rl_project_path, vcs_config_path, asset_type):
        asset_name = "test_asset"
        args = ["cmd",
                "--project_name", "rl",
                "--project_path", rl_project_path,
                "--vcs_config", vcs_config_path,
                "create_asset", asset_type, asset_name]

        with mock.patch.object(sys, "argv", args):
            cmd.main()

            asset_structure_paths = structure_paths_on_asset_type(
                asset_type)
            for path in asset_structure_paths:
                asset_structure_fullpath = os.path.join(
                    rl_project_path, "assets", asset_type, asset_name, path)
                assert os.path.exists(asset_structure_fullpath)

    @pytest.mark.parametrize("variant_type", ["cloth", "hair"])
    def test_create_asset_variant(self, rl_project_path, vcs_config_path, variant_type):
        asset_type = "char"
        variant_name = "base_1"
        asset_name = "test_asset"

        args = ["cmd",
                "--project_name", "rl",
                "--project_path", rl_project_path,
                "--vcs_config", vcs_config_path,
                "create_asset_variant", variant_type, asset_name, variant_name]

        with mock.patch.object(sys, "argv", args):
            cmd.main()

            asset_structure_paths = structure_paths_on_asset_type(asset_type)
            variant_template_paths = variant_paths_on_type(variant_type)
            variant_resolved_paths = list(map(lambda t: t.format(
                variant_name), variant_template_paths))
            variant_structure_paths = asset_structure_paths + variant_resolved_paths
            for path in variant_structure_paths:
                asset_structure_fullpath = os.path.join(
                    rl_project_path, "assets", asset_type, asset_name, path)
                assert os.path.exists(asset_structure_fullpath)
