import os
from flask import Flask
from celery import Celery
from wizart.fs_ctrl.views import simple_page


default_path = os.path.abspath(r"../config.json")
config_path = os.environ.get('FS_SERVICE_CONFIG', default_path)

app = Flask(__name__)
app.config.from_json(config_path)
app.register_blueprint(simple_page)

celery = Celery(app.name, broker=app.config.get('CELERY_BROKER_URL'))
celery.conf.update(app.config)
celery.autodiscover_tasks(['wizart.fs_ctrl.celery_tasks'])


def main():
    app.run()


if __name__ == '__main__':

    main()
