import wizart.fs_ctrl.fs_schema as fs_schema
import argparse
import sys, os
import logging
from wizart.fs_ctrl.fs_schema import FSControlError

try:
    _BUILTINS = sys.modules['__builtin__']
except KeyError as e:
    _BUILTINS = sys.modules['builtins']

TYPES = dict([ (builtin,getattr(_BUILTINS, builtin)) for builtin in vars(_BUILTINS)])

import logging
logger = logging.getLogger('fs_ctrl')


def parse_args():
    parser = argparse.ArgumentParser(description='Filesytem control')
    parser.add_argument('--project_name', type=str)
    parser.add_argument('--project_path', type=str, required=True)
    parser.add_argument('--vcs_config', type=str)
    common_namespace = argparse.Namespace()
    parser.parse_known_args(namespace=common_namespace)
    if not common_namespace.project_path:
        raise FSControlError("Project path required")

    project_name = os.path.basename(common_namespace.project_path)
    if not common_namespace.project_name:
        logger.info("Assume project name: %s" % project_name)
    else:
        project_name = common_namespace.project_name
    project_schema = fs_schema.ProjectFileSchema(project_name, common_namespace.project_path)
    project_schema.set_vcs_config_path(common_namespace.vcs_config)

    project_schema.check_is_valid()

    commands = project_schema.load_fs_ctrl_config().get('commands')
    subparsers = parser.add_subparsers(help=" ".join([cmd['name'] for cmd in commands]))
    for command in commands:
        subparser = subparsers.add_parser(command['name'])
        if command["action"] == "symlink_templated_folder":
            subparser.add_argument("--src_root", type=str, required=True)
            subparser.add_argument("--dst_root", type=str, required=True)
        for cmd_arg_name, cmd_arg_options in command['args'].items():
            if 'type' in cmd_arg_options:
                cmd_arg_options['type'] = TYPES[cmd_arg_options['type']]
            subparser.add_argument(cmd_arg_name, **cmd_arg_options)
        subparser.set_defaults(which=command['name'])
        # create_parser.add_argument("--project", type=str, required = True)
        # create_parser.add_argument("--permission", action='append', default = [])
        # create_parser.set_defaults(which='create-asset')
    args = parser.parse_args(namespace=common_namespace)
    args_dict = vars(args)
    args_dict['command'] = args.which

    return args_dict


def main():
    parser = argparse.ArgumentParser(description='Filesytem control')
    parser.add_argument('--project_name', type=str)
    parser.add_argument('--project_path', type=str, required = True)
    parser.add_argument('--vcs_config', type=str)
    common_namespace = argparse.Namespace()
    parser.parse_known_args(namespace = common_namespace)
    if not common_namespace.project_path:
        raise FSControlError("Project path required")

    project_name = os.path.basename(common_namespace.project_path)
    if not common_namespace.project_name:
        logger.info("Assume project name: %s" % project_name)
    else:
        project_name = common_namespace.project_name
    project_schema = fs_schema.ProjectFileSchema(project_name, common_namespace.project_path)
    project_schema.set_vcs_config_path(common_namespace.vcs_config)
    
    project_schema.check_is_valid()

    commands = project_schema.load_fs_ctrl_config().get('commands')
    subparsers = parser.add_subparsers(help= " ".join([cmd['name'] for cmd in commands])  )
    for command in commands:
        subparser = subparsers.add_parser(command['name'])
        if command["action"] == "symlink_templated_folder":
            subparser.add_argument("--src_root", type=str, required = True)
            subparser.add_argument("--dst_root", type=str, required = True)
        if "args" in command:
            for cmd_arg_name, cmd_arg_options in command['args'].items():
                if 'type' in cmd_arg_options:
                    cmd_arg_options['type'] = TYPES[cmd_arg_options['type']]
                if cmd_arg_name == "variant":
                    cmd_arg_options["nargs"] = "?"
                    cmd_arg_options["default"] = "base"
                subparser.add_argument(cmd_arg_name, **cmd_arg_options)
        subparser.set_defaults(which=command['name'])
            # create_parser.add_argument("--project", type=str, required = True)
            # create_parser.add_argument("--permission", action='append', default = [])
            # create_parser.set_defaults(which='create-asset')
    args = parser.parse_args(namespace=common_namespace)
    args_dict = vars(args)
    def _get_cmd():
        for command in commands:
            if command['name'] == args.which:
                return command
    command = _get_cmd()
    cmd_path = command['cmd_path']
    if 'cmd_path_pre_format_args' in command:
        preformat_args = dict([(key, args_dict[key])
                               for key in command['cmd_path_pre_format_args'] if key in args_dict])
        if isinstance(cmd_path, list):
            cmd_path = list(
                map(lambda path: path.format(**preformat_args), cmd_path))
        else:
            cmd_path = cmd_path.format(**preformat_args)

    fs_args = dict()
    if "cmd_path_fs_args" in command:
        for fs_arg in command['cmd_path_fs_args']:
            if fs_arg['name'] in args_dict:
                fs_args[fs_arg['fs_arg']] = args_dict[fs_arg['name']]

    def run_cmd(path):
        if command['action'] == "create_templated_folder":
            project_schema.create_templated_folder(path, **fs_args)
        elif command["action"] == "symlink_templated_folder":
            project_schema.symlink_templated_folder(
                path, src_root=args.src_root, dst_root=args.dst_root, **fs_args)

    if isinstance(cmd_path, list):
        for path in cmd_path:
            run_cmd(path)
    else:
        run_cmd(cmd_path)
